import{s as oa,o as ma,n as ca}from"../chunks/scheduler.f7e1785c.js";import{S as da,i as Ja,g as p,s as n,r as u,A as ya,h as r,f as l,c as a,j as Ma,u as M,x as i,k as Kt,y as Ta,a as t,v as o,d as m,t as c,w as d}from"../chunks/index.9f8f0838.js";import{T as wa}from"../chunks/Tip.4575d9cf.js";import{C as J}from"../chunks/CodeBlock.4baef5d7.js";import{H as w,E as ja}from"../chunks/getInferenceSnippets.ba5f4cd0.js";function Ua(_s){let y,b="Dans notre exemple, nous utiliserons environ 40 heures de données d’entraînement. Si vous souhaitez suivre en utilisant la version gratuite de Google Colab, vous devrez réduire la quantité de données d’entraînement à environ 10-15 heures, ainsi que réduire le nombre d’étapes d’entraînement.";return{c(){y=p("p"),y.textContent=b},l(T){y=r(T,"P",{"data-svelte-h":!0}),i(y)!=="svelte-6yku8n"&&(y.textContent=b)},m(T,Ws){t(T,y,Ws)},p:ca,d(T){T&&l(y)}}}function ha(_s){let y,b,T,Ws,f,zs,I,Ot="Maintenant que vous êtes familiarisé avec la tâche de synthèse vocale et le fonctionnement interne du SpeechT5 qui a été entraîné sur des données en langue anglaise, voyons comment nous pouvons le <em>finetuner</em> à une autre langue.",Xs,C,Ns,$,en="Assurez-vous de disposer d’un GPU si vous souhaitez reproduire cet exemple. Dans un <em>notebook</em>, vous pouvez vérifier avec la commande suivante :",Ys,Z,Qs,j,Rs,v,sn="Vous aurez également besoin de quelques dépendances supplémentaires :",qs,g,As,x,ln="Enfin, n’oubliez pas de vous connecter à votre compte Hugging Face pour pouvoir télécharger et partager votre modèle avec la communauté :",Es,k,Hs,V,Fs,B,tn=`Pour cet exemple, nous prendrons le sous-ensemble en néerlandais (<code>nl</code>) du jeu de données <a href="https://huggingface.co/datasets/facebook/voxpopuli" rel="nofollow">VoxPopuli</a>.
<a href="https://huggingface.co/datasets/facebook/voxpopuli" rel="nofollow">VoxPopuli</a> est un corpus de parole multilingue à grande échelle composé de données provenant d’enregistrements d’événements du Parlement européen de 2009 à 2020.
Il contient des données de transcription audio étiquetées pour 15 langues européennes. Nous utiliserons le sous-ensemble néerlandais, mais vous pouvez choisir un autre sous-ensemble.`,Ss,W,nn="Il s’agit d’un jeu de données de reconnaissance automatique de la parole, donc comme mentionné précédemment, ce n’est pas l’option la plus appropriée pour entraîner des modèles TTS. Cependant, il sera suffisant pour cet exercice.",Ls,G,an="Chargeons les données :",Ds,_,Ps,z,pn="<strong>Sortie :</strong>",Ks,X,Os,N,rn="20968 exemples devraient suffire pour un <em>finetuning</em>. SpeechT5 s’attend à ce que les données audio aient une fréquence d’échantillonnage de 16 kHz, assurez-vous donc que les exemples du jeu de données répondent à cette exigence :",el,Y,sl,Q,ll,R,un="Commençons par définir le <em>checkpoint</em> du modèle à utiliser et par charger le processeur approprié qui contient à la fois le <em>tokenizer</em> et l’extracteur de caractéristiques dont nous aurons besoin pour préparer les données en vue de l’entraînement :",tl,q,nl,A,al,E,Mn="Tout d’abord, pour préparer le texte, nous aurons besoin de la partie <em>tokenizer</em> du processeur, alors allons-y :",pl,H,rl,F,on="Prenons un exemple :",il,S,ul,L,mn="<strong>Sortie :</strong>",Ml,D,ol,P,cn="Vous remarquerez que les exemples du jeu de données contiennent les caractéristiques <code>raw_text</code> et <code>normalized_text</code>. Lorsque vous décidez quelle caractéristique utiliser comme entrée de texte, il est important de savoir que le <em>tokenizer</em> de SpeechT5 n’a pas de <em>tokens</em> pour les nombres. Dans <code>normalized_text</code>, les nombres sont écrits sous forme textuel. Il s’agit donc d’une meilleure option, et nous devrions utiliser <code>normalized_text</code> comme texte d’entrée.",ml,K,dn=`Comme SpeechT5 a été entraîné sur la langue anglaise, il se peut qu’il ne reconnaisse pas certains caractères dans le jeu de données néerlandais.
S’ils sont laissés tels quels, ces caractères seront convertis en tokens <code>&lt;unk&gt;</code>. Cependant, en néerlandais, certains caractères comme <code>à</code> sont utilisés pour souligner les syllabes. Afin de préserver le sens du texte, nous pouvons remplacer ce caractère par un <code>a</code> normal.`,cl,O,Jn=`Pour identifier les <em>tokens</em> non supportés, extrayez tous les caractères uniques du jeu de données en utilisant le <code>SpeechT5Tokenizer</code> qui fonctionne avec les caractères comme des <em>tokens</em>.
Pour ce faire, nous allons écrire la fonction <code>extract_all_chars</code> qui concatène les transcriptions de tous les exemples en une chaîne et la convertit en un ensemble de caractères.
Assurez-vous de mettre <code>batched=True</code> et <code>batch_size=-1</code> dans <code>dataset.map()</code> afin que toutes les transcriptions soient disponibles en même temps pour la fonction de <em>mapping</em>.`,dl,ee,Jl,se,yn=`Vous disposez à présent de deux ensembles de caractères : l’un avec le vocabulaire du jeu de données et l’autre avec le vocabulaire du <em>tokenizer</em>.
Pour identifier les caractères non pris en charge dans le jeu de données, vous pouvez prendre la différence entre ces deux ensembles. L’ensemble résultant contiendra les caractères qui se trouvent dans le jeu de données mais pas dans le <em>tokenizer</em>.`,yl,le,Tl,te,Tn="<strong>Sortie :</strong>",wl,ne,jl,ae,wn="Pour gérer les caractères non supportés identifiés dans l’étape précédente, nous pouvons définir une fonction qui fait correspondre ces caractères à des <em>tokens</em> valides. Notez que les espaces sont déjà remplacés par <code>▁</code> dans le <em>tokenizer</em> et n’ont pas besoin d’être gérés séparément.",Ul,pe,hl,re,jn="Maintenant que nous avons traité les caractères spéciaux dans le texte, il est temps de se concentrer sur les données audio.",bl,ie,fl,ue,Un=`Le jeu de données VoxPopuli comprend la parole de plusieurs locuteurs, mais combien de locuteurs sont représentés dans le jeu de données ? Pour le savoir, nous pouvons compter le nombre de locuteurs uniques et le nombre d’exemples que chaque locuteur apporte au jeu de données.
Avec un total de 20 968 exemples dans le jeu de données, cette information nous permettra de mieux comprendre la distribution des locuteurs et des exemples dans les données.`,Il,Me,Cl,oe,hn="En traçant un histogramme, vous pouvez vous faire une idée de la quantité de données pour chaque locuteur.",$l,me,Zl,U,bn='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/tts_speakers_histogram.png" alt="Speakers histogram"/>',vl,ce,fn="L’histogramme révèle qu’environ un tiers des locuteurs du jeu de données ont moins de 100 exemples, tandis qu’une dizaine de locuteurs ont plus de 500 exemples. Pour améliorer l’efficacité de l’entraînement et équilibrer le jeu de données, nous pouvons limiter les données aux locuteurs ayant entre 100 et 400 exemples.",gl,de,xl,Je,In="Vérifions le nombre de locuteurs restants :",kl,ye,Vl,Te,Cn="<strong>Sortie :</strong>",Bl,we,Wl,je,$n="Voyons combien d’exemples il reste :",Gl,Ue,_l,he,Zn="<strong>Sortie :</strong>",zl,be,Xl,fe,vn="Vous vous retrouvez avec un peu moins de 10 000 exemples provenant d’environ 40 locuteurs uniques, ce qui devrait être suffisant.",Nl,Ie,gn="Notez que certains locuteurs ayant peu d’exemples peuvent en fait avoir plus d’audio disponible si les exemples sont longs. Cependant, pour déterminer la quantité totale d’audio pour chaque locuteur, il faut parcourir l’ensemble des données, ce qui est un processus long qui implique le chargement et le décodage de chaque fichier audio. C’est pourquoi nous avons choisi de sauter cette étape.",Yl,Ce,Ql,$e,xn=`Pour permettre au modèle TTS de différencier plusieurs locuteurs, vous devrez créer un enchâssement de locuteur pour chaque exemple.
C’est est une entrée supplémentaire dans le modèle qui capture les caractéristiques de la voix d’un locuteur particulier.
Pour générer ces enchâssements, utilisez le modèle pré-entraîné <a href="https://huggingface.co/speechbrain/spkrec-xvect-voxceleb" rel="nofollow">spkrec-xvect-voxceleb</a> de SpeechBrain.`,Rl,Ze,kn="Créez une fonction <code>create_speaker_embedding()</code> qui prend une forme d’onde audio en entrée et produit un vecteur de 512 éléments contenant l’enchâssement du locuteur correspondant.",ql,ve,Al,ge,Vn="Il est important de noter que le modèle <code>speechbrain/spkrec-xvect-voxceleb</code> a été entraîné sur de l’anglais provenant du jeu de données VoxCeleb, alors que les exemples d’entraînement dans ce guide sont en néerlandais. Bien que nous pensions que ce modèle génèrerait toujours des enchâssements de locuteurs raisonnables pour notre jeu de données néerlandais, cette hypothèse peut ne pas être vraie dans tous les cas.",El,xe,Bn='Pour obtenir des résultats optimaux, nous devrions d’abord entraîner un modèle de vecteur X sur le discours cible. Ainsi, le modèle sera mieux à même de capturer les caractéristiques vocales uniques présentes dans la langue néerlandaise. Si vous souhaitez entraîner votre propre modèle X-vector, vous pouvez utiliser <a href="https://huggingface.co/mechanicalsea/speecht5-vc/blob/main/manifest/utils/prep_cmu_arctic_spkemb.py" rel="nofollow">ce script</a> comme exemple.',Hl,ke,Fl,Ve,Wn=`Enfin, traitons les données dans le format attendu par le modèle. Créez une fonction <code>prepare_dataset</code> qui prend un seul exemple et utilise l’objet <code>SpeechT5Processor</code> pour tokeniser le texte d’entrée et charger l’audio cible dans un spectrogramme log-mel.
Elle devrait également ajouter les enchâssements de locuteur en tant qu’entrée supplémentaire.`,Sl,Be,Ll,We,Gn="Vérifiez que le traitement est correct en examinant un seul exemple :",Dl,Ge,Pl,_e,_n="<strong>Sortie :</strong>",Kl,ze,Ol,Xe,zn="Les enchâssements de locuteurs doivent être un vecteur de 512 éléments :",et,Ne,st,Ye,Xn="<strong>Sortie :</strong>",lt,Qe,tt,Re,Nn="Les étiquettes doivent être un spectrogramme log-mel avec 80 bins mel.",nt,qe,at,h,Yn='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/tts_logmelspectrogram_1.png" alt="Log-mel spectrogram with 80 mel bins"/>',pt,Ae,Qn=`Remarque : si vous trouvez ce spectrogramme déroutant, c’est peut-être parce que vous êtes familier avec la convention qui consiste à placer les basses fréquences en bas et les hautes fréquences en haut d’un graphique.
Cependant, lorsque l’on trace des spectrogrammes sous forme d’image à l’aide de la bibliothèque matplotlib, l’axe des ordonnées est inversé et les spectrogrammes apparaissent à l’envers.`,rt,Ee,Rn="Nous devons maintenant appliquer la fonction de traitement à l’ensemble du jeu de données. Cela prendra entre 5 et 10 minutes.",it,He,ut,Fe,qn=`Vous verrez un avertissement indiquant que certains exemples du jeu de données sont plus longs que la longueur d’entrée maximale que le modèle peut traiter (600 <em>tokens</em>).
Supprimez ces exemples du jeu de données. Ici, nous allons encore plus loin et, pour tenir compte de la taille des batchs, nous supprimons tout ce qui dépasse 200 <em>tokens</em>.`,Mt,Se,ot,Le,An="<strong>Sortie :</strong>",mt,De,ct,Pe,En="Next, create a basic train/test split:",dt,Ke,Jt,Oe,yt,es,Hn="Afin de combiner plusieurs exemples dans un batch, vous devez définir un assembleur de données personnalisé. Il remplacera les séquences les plus courtes par des <em>tokens</em> de rembourrage, afin de s’assurer que tous les exemples ont la même longueur. Pour les étiquettes des spectrogrammes, les parties rembourrées sont remplacées par la valeur spéciale <code>-100</code>. Cette valeur spéciale indique au modèle d’ignorer cette partie du spectrogramme lors du calcul de la perte de spectrogramme.",Tt,ss,wt,ls,Fn="Dans SpeechT5, l’entrée de la partie décodeur du modèle est réduite d’un facteur 2. En d’autres termes, il élimine un pas de temps sur deux de la séquence cible. Le décodeur prédit alors une séquence deux fois plus longue. Étant donné que la longueur de la séquence cible d’origine peut être impaire, l’assembleur de données veille à arrondir la longueur maximale du batch à un multiple de 2.",jt,ts,Ut,ns,ht,as,Sn="Chargez le modèle pré-entraîné à partir du même <em>checkpoint</em> que celui utilisé pour le chargement du processeur :",bt,ps,ft,rs,Ln="L’option <code>use_cache=True</code> est incompatible avec le <em>checkingpointing</em> du gradient. Désactivez-la pour l’entraînement, et réactivez le cache pour la génération afin d’accélérer le temps d’inférence :",It,is,Ct,us,Dn="Définir les arguments d’entraînement. Ici, nous ne calculons aucune métrique d’évaluation pendant le processus d’entraînement, nous parlerons d’évaluation plus tard dans ce chapitre. Au lieu de cela, nous ne nous intéresserons qu’à la perte :",$t,Ms,Zt,os,Pn="Instancie l’objet <code>Trainer</code> et lui passe le modèle, le jeu de données et l’assembleur de données.",vt,ms,gt,cs,Kn="Et voilà, nous sommes prêts à commencer l’entraînement ! Il prendra plusieurs heures. En fonction de votre GPU, il est possible que vous rencontriez une erreur CUDA “out-of-memory” lorsque vous commencez l’entraînement. Dans ce cas, vous pouvez réduire la taille de <code>per_device_train_batch_size</code> par incréments d’un facteur 2 et augmenter <code>gradient_accumulation_steps</code> par 2 pour compenser.",xt,ds,kt,Js,On="Pousser le modèle final sur le <em>Hub</em> :",Vt,ys,Bt,Ts,Wt,ws,ea="Une fois que vous avez <em>finetuné</em> un modèle, vous pouvez l’utiliser pour l’inférence ! Chargez le modèle à partir du <em>Hub</em> (assurez-vous d’utiliser votre nom de compte dans l’extrait de code suivant) :",Gt,js,_t,Us,sa="Choisissez un exemple, ici nous en prendrons un du jeu de données de test. Obtenez un enchâssement du locuteur.",zt,hs,Xt,bs,la="Définir un texte d’entrée et le <em>tokeniser</em>.",Nt,fs,Yt,Is,ta="Prétraiter le texte d’entrée :",Qt,Cs,Rt,$s,na="Installez un vocodeur et générez de la parole :",qt,Zs,At,vs,aa="On écoute le résultat ?",Et,gs,Ht,xs,pa="Il peut être difficile d’obtenir des résultats satisfaisants avec ce modèle dans une nouvelle langue. La qualité de l’enchâssement du locuteur peut être un facteur important. Comme SpeechT5 a été entraîné avec des X-vectors anglais, il donne de meilleurs résultats lorsqu’il utilise des enchâssements de locuteurs anglais. Si la synthèse vocale semble médiocre, essayez d’utiliser un autre enchâssement de locuteur.",Ft,ks,ra=`L’augmentation de la durée d’entraînement est également susceptible d’améliorer la qualité des résultats. Malgré cela, le discours est clairement néerlandais et non anglais, et il capture les caractéristiques vocales du locuteur (comparez avec l’audio original dans l’exemple).
Une autre chose à expérimenter est la configuration du modèle. Par exemple, essayez d’utiliser <code>config.reduction_factor = 1</code> pour voir si cela améliore les résultats.`,St,Vs,ia="Dans la section suivante, nous verrons comment nous évaluons les modèles de synthèse vocale.",Lt,Bs,Dt,Gs,Pt;return f=new w({props:{title:"Finetuning du SpeechT5",local:"finetuning-du-speecht5",headingTag:"h1"}}),C=new w({props:{title:"Préparation",local:"préparation",headingTag:"h2"}}),Z=new J({props:{code:"bnZpZGlhLXNtaQ==",highlighted:"nvidia-smi",wrap:!1}}),j=new wa({props:{warning:!0,$$slots:{default:[Ua]},$$scope:{ctx:_s}}}),g=new J({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGRhdGFzZXRzJTIwc291bmRmaWxlJTIwc3BlZWNoYnJhaW4lMjBhY2NlbGVyYXRl",highlighted:"pip install transformers datasets soundfile speechbrain accelerate",wrap:!1}}),k=new J({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),V=new w({props:{title:"Le jeu de données",local:"le-jeu-de-données",headingTag:"h2"}}),_=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTJDJTIwQXVkaW8lMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmZhY2Vib29rJTJGdm94cG9wdWxpJTIyJTJDJTIwJTIybmwlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQWxlbihkYXRhc2V0KQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, Audio

dataset = load_dataset(<span class="hljs-string">&quot;facebook/voxpopuli&quot;</span>, <span class="hljs-string">&quot;nl&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-built_in">len</span>(dataset)`,wrap:!1}}),X=new J({props:{code:"MjA5Njg=",highlighted:"20968",wrap:!1}}),Y=new J({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuY2FzdF9jb2x1bW4oJTIyYXVkaW8lMjIlMkMlMjBBdWRpbyhzYW1wbGluZ19yYXRlJTNEMTYwMDApKQ==",highlighted:'dataset = dataset.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16000</span>))',wrap:!1}}),Q=new w({props:{title:"Prétraitement des données",local:"prétraitement-des-données",headingTag:"h2"}}),q=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1UHJvY2Vzc29yJTBBJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMm1pY3Jvc29mdCUyRnNwZWVjaHQ1X3R0cyUyMiUwQXByb2Nlc3NvciUyMCUzRCUyMFNwZWVjaFQ1UHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5Processor

checkpoint = <span class="hljs-string">&quot;microsoft/speecht5_tts&quot;</span>
processor = SpeechT5Processor.from_pretrained(checkpoint)`,wrap:!1}}),A=new w({props:{title:"Nettoyage du texte pour la tokenisation de SpeechT5",local:"nettoyage-du-texte-pour-la-tokenisation-de-speecht5",headingTag:"h3"}}),H=new J({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwcHJvY2Vzc29yLnRva2VuaXplcg==",highlighted:"tokenizer = processor.tokenizer",wrap:!1}}),S=new J({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:'dataset[<span class="hljs-number">0</span>]',wrap:!1}}),D=new J({props:{code:"JTdCJ2F1ZGlvX2lkJyUzQSUyMCcyMDEwMDIxMC0wOTAwLVBMRU5BUlktMy1ubF8yMDEwMDIxMC0wOSUzQTA2JTNBNDNfNCclMkMlMEElMjAnbGFuZ3VhZ2UnJTNBJTIwOSUyQyUwQSUyMCdhdWRpbyclM0ElMjAlN0IncGF0aCclM0ElMjAnJTJGcm9vdCUyRi5jYWNoZSUyRmh1Z2dpbmdmYWNlJTJGZGF0YXNldHMlMkZkb3dubG9hZHMlMkZleHRyYWN0ZWQlMkYwMmVjNmExOWQ1Yjk3YzAzZTEzNzkyNTAzNzg0NTRkYmYzZmEyOTcyOTQzNTA0YTkxYzdkYTUwNDVhYTI2YTg5JTJGdHJhaW5fcGFydF8wJTJGMjAxMDAyMTAtMDkwMC1QTEVOQVJZLTMtbmxfMjAxMDAyMTAtMDklM0EwNiUzQTQzXzQud2F2JyUyQyUwQSUyMCUyMCdhcnJheSclM0ElMjBhcnJheSglNUIlMjA0LjI3MjQ2MDk0ZS0wNCUyQyUyMCUyMDEuMzEyMjU1ODZlLTAzJTJDJTIwJTIwMS4wMzc1OTc2NmUtMDMlMkMlMjAuLi4lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAtOS4xNTUyNzM0NGUtMDUlMkMlMjAlMjA3LjYyOTM5NDUzZS0wNCUyQyUyMC0yLjQ0MTQwNjI1ZS0wNCU1RCklMkMlMEElMjAlMjAnc2FtcGxpbmdfcmF0ZSclM0ElMjAxNjAwMCU3RCUyQyUwQSUyMCdyYXdfdGV4dCclM0ElMjAnRGF0JTIwa2FuJTIwbmFhciUyMG1pam4lMjBnZXZvZWwlMjBhbGxlZW4lMjBtZXQlMjBlZW4lMjBicmVkZSUyMG1lZXJkZXJoZWlkJTIwZGllJTIwd2lqJTIwc2FtZW4lMjB6b2VrZW4uJyUyQyUwQSUyMCdub3JtYWxpemVkX3RleHQnJTNBJTIwJ2RhdCUyMGthbiUyMG5hYXIlMjBtaWpuJTIwZ2V2b2VsJTIwYWxsZWVuJTIwbWV0JTIwZWVuJTIwYnJlZGUlMjBtZWVyZGVyaGVpZCUyMGRpZSUyMHdpaiUyMHNhbWVuJTIwem9la2VuLiclMkMlMEElMjAnZ2VuZGVyJyUzQSUyMCdmZW1hbGUnJTJDJTBBJTIwJ3NwZWFrZXJfaWQnJTNBJTIwJzExMjInJTJDJTBBJTIwJ2lzX2dvbGRfdHJhbnNjcmlwdCclM0ElMjBUcnVlJTJDJTBBJTIwJ2FjY2VudCclM0ElMjAnTm9uZSclN0Q=",highlighted:`{&#x27;audio_id&#x27;: &#x27;<span class="hljs-number">20100210-0900</span>-PLENARY-3-nl_<span class="hljs-number">20100210-09:06:43</span>_4&#x27;,
 &#x27;language&#x27;: <span class="hljs-number">9</span>,
 &#x27;audio&#x27;: {&#x27;path&#x27;: &#x27;/root/.cache/huggingface/datasets/downloads/extracted/02ec6a19d5b97c03e<span class="hljs-number">137925037845</span>4dbf3fa<span class="hljs-number">2972943504</span>a91c7da<span class="hljs-number">5045</span>aa26a89/train_part_0/<span class="hljs-number">20100210-0900</span>-PLENARY-3-nl_<span class="hljs-number">20100210-09:06:43</span>_4.wav&#x27;,
  &#x27;array&#x27;: array([ <span class="hljs-number">4.27246094</span>e-<span class="hljs-number">04</span>,  <span class="hljs-number">1.31225586</span>e-<span class="hljs-number">03</span>,  <span class="hljs-number">1.03759766</span>e-<span class="hljs-number">03</span>, ...,
         -<span class="hljs-number">9.15527344</span>e-<span class="hljs-number">05</span>,  <span class="hljs-number">7.62939453</span>e-<span class="hljs-number">04</span>, -<span class="hljs-number">2.44140625</span>e-<span class="hljs-number">04</span>]),
  &#x27;sampling_rate&#x27;: <span class="hljs-number">16000</span>},
 &#x27;raw_text&#x27;: &#x27;Dat kan naar mijn gevoel alleen met een brede meerderheid die wij samen zoeken.&#x27;,
 &#x27;normalized_text&#x27;: &#x27;dat kan naar mijn gevoel alleen met een brede meerderheid die wij samen zoeken.&#x27;,
 &#x27;gender&#x27;: &#x27;female&#x27;,
 &#x27;speaker_id&#x27;: &#x27;<span class="hljs-number">1122</span>&#x27;,
 &#x27;is_gold_transcript&#x27;: True,
 &#x27;accent&#x27;: &#x27;None&#x27;}`,wrap:!1}}),ee=new J({props:{code:"ZGVmJTIwZXh0cmFjdF9hbGxfY2hhcnMoYmF0Y2gpJTNBJTBBJTIwJTIwJTIwJTIwYWxsX3RleHQlMjAlM0QlMjAlMjIlMjAlMjIuam9pbihiYXRjaCU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RCklMEElMjAlMjAlMjAlMjB2b2NhYiUyMCUzRCUyMGxpc3Qoc2V0KGFsbF90ZXh0KSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJ2b2NhYiUyMiUzQSUyMCU1QnZvY2FiJTVEJTJDJTIwJTIyYWxsX3RleHQlMjIlM0ElMjAlNUJhbGxfdGV4dCU1RCU3RCUwQSUwQSUwQXZvY2FicyUyMCUzRCUyMGRhdGFzZXQubWFwKCUwQSUyMCUyMCUyMCUyMGV4dHJhY3RfYWxsX2NoYXJzJTJDJTBBJTIwJTIwJTIwJTIwYmF0Y2hlZCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNELTElMkMlMEElMjAlMjAlMjAlMjBrZWVwX2luX21lbW9yeSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZW1vdmVfY29sdW1ucyUzRGRhdGFzZXQuY29sdW1uX25hbWVzJTJDJTBBKSUwQSUwQWRhdGFzZXRfdm9jYWIlMjAlM0QlMjBzZXQodm9jYWJzJTVCJTIydm9jYWIlMjIlNUQlNUIwJTVEKSUwQXRva2VuaXplcl92b2NhYiUyMCUzRCUyMCU3QmslMjBmb3IlMjBrJTJDJTIwXyUyMGluJTIwdG9rZW5pemVyLmdldF92b2NhYigpLml0ZW1zKCklN0Q=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">extract_all_chars</span>(<span class="hljs-params">batch</span>):
    all_text = <span class="hljs-string">&quot; &quot;</span>.join(batch[<span class="hljs-string">&quot;normalized_text&quot;</span>])
    vocab = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">set</span>(all_text))
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;vocab&quot;</span>: [vocab], <span class="hljs-string">&quot;all_text&quot;</span>: [all_text]}


vocabs = dataset.<span class="hljs-built_in">map</span>(
    extract_all_chars,
    batched=<span class="hljs-literal">True</span>,
    batch_size=-<span class="hljs-number">1</span>,
    keep_in_memory=<span class="hljs-literal">True</span>,
    remove_columns=dataset.column_names,
)

dataset_vocab = <span class="hljs-built_in">set</span>(vocabs[<span class="hljs-string">&quot;vocab&quot;</span>][<span class="hljs-number">0</span>])
tokenizer_vocab = {k <span class="hljs-keyword">for</span> k, _ <span class="hljs-keyword">in</span> tokenizer.get_vocab().items()}`,wrap:!1}}),le=new J({props:{code:"ZGF0YXNldF92b2NhYiUyMC0lMjB0b2tlbml6ZXJfdm9jYWI=",highlighted:"dataset_vocab - tokenizer_vocab",wrap:!1}}),ne=new J({props:{code:"JTdCJyUyMCclMkMlMjAnJUMzJUEwJyUyQyUyMCclQzMlQTcnJTJDJTIwJyVDMyVBOCclMkMlMjAnJUMzJUFCJyUyQyUyMCclQzMlQUQnJTJDJTIwJyVDMyVBRiclMkMlMjAnJUMzJUI2JyUyQyUyMCclQzMlQkMnJTdE",highlighted:"{&#x27; &#x27;, &#x27;à&#x27;, &#x27;ç&#x27;, &#x27;è&#x27;, &#x27;ë&#x27;, &#x27;í&#x27;, &#x27;ï&#x27;, &#x27;ö&#x27;, &#x27;ü&#x27;}",wrap:!1}}),pe=new J({props:{code:"cmVwbGFjZW1lbnRzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBMCUyMiUyQyUyMCUyMmElMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBNyUyMiUyQyUyMCUyMmMlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBOCUyMiUyQyUyMCUyMmUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBQiUyMiUyQyUyMCUyMmUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBRCUyMiUyQyUyMCUyMmklMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBRiUyMiUyQyUyMCUyMmklMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVCNiUyMiUyQyUyMCUyMm8lMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVCQyUyMiUyQyUyMCUyMnUlMjIpJTJDJTBBJTVEJTBBJTBBJTBBZGVmJTIwY2xlYW51cF90ZXh0KGlucHV0cyklM0ElMEElMjAlMjAlMjAlMjBmb3IlMjBzcmMlMkMlMjBkc3QlMjBpbiUyMHJlcGxhY2VtZW50cyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0cyU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RCUyMCUzRCUyMGlucHV0cyU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RC5yZXBsYWNlKHNyYyUyQyUyMGRzdCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbnB1dHMlMEElMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoY2xlYW51cF90ZXh0KQ==",highlighted:`replacements = [
    (<span class="hljs-string">&quot;à&quot;</span>, <span class="hljs-string">&quot;a&quot;</span>),
    (<span class="hljs-string">&quot;ç&quot;</span>, <span class="hljs-string">&quot;c&quot;</span>),
    (<span class="hljs-string">&quot;è&quot;</span>, <span class="hljs-string">&quot;e&quot;</span>),
    (<span class="hljs-string">&quot;ë&quot;</span>, <span class="hljs-string">&quot;e&quot;</span>),
    (<span class="hljs-string">&quot;í&quot;</span>, <span class="hljs-string">&quot;i&quot;</span>),
    (<span class="hljs-string">&quot;ï&quot;</span>, <span class="hljs-string">&quot;i&quot;</span>),
    (<span class="hljs-string">&quot;ö&quot;</span>, <span class="hljs-string">&quot;o&quot;</span>),
    (<span class="hljs-string">&quot;ü&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>),
]


<span class="hljs-keyword">def</span> <span class="hljs-title function_">cleanup_text</span>(<span class="hljs-params">inputs</span>):
    <span class="hljs-keyword">for</span> src, dst <span class="hljs-keyword">in</span> replacements:
        inputs[<span class="hljs-string">&quot;normalized_text&quot;</span>] = inputs[<span class="hljs-string">&quot;normalized_text&quot;</span>].replace(src, dst)
    <span class="hljs-keyword">return</span> inputs


dataset = dataset.<span class="hljs-built_in">map</span>(cleanup_text)`,wrap:!1}}),ie=new w({props:{title:"Les locuteurs",local:"les-locuteurs",headingTag:"h3"}}),Me=new J({props:{code:"ZnJvbSUyMGNvbGxlY3Rpb25zJTIwaW1wb3J0JTIwZGVmYXVsdGRpY3QlMEElMEFzcGVha2VyX2NvdW50cyUyMCUzRCUyMGRlZmF1bHRkaWN0KGludCklMEElMEFmb3IlMjBzcGVha2VyX2lkJTIwaW4lMjBkYXRhc2V0JTVCJTIyc3BlYWtlcl9pZCUyMiU1RCUzQSUwQSUyMCUyMCUyMCUyMHNwZWFrZXJfY291bnRzJTVCc3BlYWtlcl9pZCU1RCUyMCUyQiUzRCUyMDE=",highlighted:`<span class="hljs-keyword">from</span> collections <span class="hljs-keyword">import</span> defaultdict

speaker_counts = defaultdict(<span class="hljs-built_in">int</span>)

<span class="hljs-keyword">for</span> speaker_id <span class="hljs-keyword">in</span> dataset[<span class="hljs-string">&quot;speaker_id&quot;</span>]:
    speaker_counts[speaker_id] += <span class="hljs-number">1</span>`,wrap:!1}}),me=new J({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQXBsdC5maWd1cmUoKSUwQXBsdC5oaXN0KHNwZWFrZXJfY291bnRzLnZhbHVlcygpJTJDJTIwYmlucyUzRDIwKSUwQXBsdC55bGFiZWwoJTIyU3BlYWtlcnMlMjIpJTBBcGx0LnhsYWJlbCglMjJFeGFtcGxlcyUyMiklMEFwbHQuc2hvdygp",highlighted:`<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

plt.figure()
plt.hist(speaker_counts.values(), bins=<span class="hljs-number">20</span>)
plt.ylabel(<span class="hljs-string">&quot;Speakers&quot;</span>)
plt.xlabel(<span class="hljs-string">&quot;Examples&quot;</span>)
plt.show()`,wrap:!1}}),de=new J({props:{code:"ZGVmJTIwc2VsZWN0X3NwZWFrZXIoc3BlYWtlcl9pZCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjAxMDAlMjAlM0MlM0QlMjBzcGVha2VyX2NvdW50cyU1QnNwZWFrZXJfaWQlNUQlMjAlM0MlM0QlMjA0MDAlMEElMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5maWx0ZXIoc2VsZWN0X3NwZWFrZXIlMkMlMjBpbnB1dF9jb2x1bW5zJTNEJTVCJTIyc3BlYWtlcl9pZCUyMiU1RCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">select_speaker</span>(<span class="hljs-params">speaker_id</span>):
    <span class="hljs-keyword">return</span> <span class="hljs-number">100</span> &lt;= speaker_counts[speaker_id] &lt;= <span class="hljs-number">400</span>


dataset = dataset.<span class="hljs-built_in">filter</span>(select_speaker, input_columns=[<span class="hljs-string">&quot;speaker_id&quot;</span>])`,wrap:!1}}),ye=new J({props:{code:"bGVuKHNldChkYXRhc2V0JTVCJTIyc3BlYWtlcl9pZCUyMiU1RCkp",highlighted:'<span class="hljs-built_in">len</span>(<span class="hljs-built_in">set</span>(dataset[<span class="hljs-string">&quot;speaker_id&quot;</span>]))',wrap:!1}}),we=new J({props:{code:"NDI=",highlighted:"42",wrap:!1}}),Ue=new J({props:{code:"bGVuKGRhdGFzZXQp",highlighted:'<span class="hljs-built_in">len</span>(dataset)',wrap:!1}}),be=new J({props:{code:"OTk3Mw==",highlighted:'<span class="hljs-number">9973</span>',wrap:!1}}),Ce=new w({props:{title:"Enchâssement des locuteurs",local:"enchâssement-des-locuteurs",headingTag:"h3"}}),ve=new J({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBzcGVlY2hicmFpbi5wcmV0cmFpbmVkJTIwaW1wb3J0JTIwRW5jb2RlckNsYXNzaWZpZXIlMEElMEFzcGtfbW9kZWxfbmFtZSUyMCUzRCUyMCUyMnNwZWVjaGJyYWluJTJGc3BrcmVjLXh2ZWN0LXZveGNlbGViJTIyJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEFzcGVha2VyX21vZGVsJTIwJTNEJTIwRW5jb2RlckNsYXNzaWZpZXIuZnJvbV9ocGFyYW1zKCUwQSUyMCUyMCUyMCUyMHNvdXJjZSUzRHNwa19tb2RlbF9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwcnVuX29wdHMlM0QlN0IlMjJkZXZpY2UlMjIlM0ElMjBkZXZpY2UlN0QlMkMlMEElMjAlMjAlMjAlMjBzYXZlZGlyJTNEb3MucGF0aC5qb2luKCUyMiUyRnRtcCUyMiUyQyUyMHNwa19tb2RlbF9uYW1lKSUyQyUwQSklMEElMEElMEFkZWYlMjBjcmVhdGVfc3BlYWtlcl9lbWJlZGRpbmcod2F2ZWZvcm0pJTNBJTBBJTIwJTIwJTIwJTIwd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwZWFrZXJfZW1iZWRkaW5ncyUyMCUzRCUyMHNwZWFrZXJfbW9kZWwuZW5jb2RlX2JhdGNoKHRvcmNoLnRlbnNvcih3YXZlZm9ybSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3BlYWtlcl9lbWJlZGRpbmdzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5ub3JtYWxpemUoc3BlYWtlcl9lbWJlZGRpbmdzJTJDJTIwZGltJTNEMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzcGVha2VyX2VtYmVkZGluZ3MlMjAlM0QlMjBzcGVha2VyX2VtYmVkZGluZ3Muc3F1ZWV6ZSgpLmNwdSgpLm51bXB5KCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBzcGVha2VyX2VtYmVkZGluZ3M=",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> speechbrain.pretrained <span class="hljs-keyword">import</span> EncoderClassifier

spk_model_name = <span class="hljs-string">&quot;speechbrain/spkrec-xvect-voxceleb&quot;</span>

device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
speaker_model = EncoderClassifier.from_hparams(
    source=spk_model_name,
    run_opts={<span class="hljs-string">&quot;device&quot;</span>: device},
    savedir=os.path.join(<span class="hljs-string">&quot;/tmp&quot;</span>, spk_model_name),
)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">create_speaker_embedding</span>(<span class="hljs-params">waveform</span>):
    <span class="hljs-keyword">with</span> torch.no_grad():
        speaker_embeddings = speaker_model.encode_batch(torch.tensor(waveform))
        speaker_embeddings = torch.nn.functional.normalize(speaker_embeddings, dim=<span class="hljs-number">2</span>)
        speaker_embeddings = speaker_embeddings.squeeze().cpu().numpy()
    <span class="hljs-keyword">return</span> speaker_embeddings`,wrap:!1}}),ke=new w({props:{title:"Traitement du jeu de données",local:"traitement-du-jeu-de-données",headingTag:"h3"}}),Be=new J({props:{code:"ZGVmJTIwcHJlcGFyZV9kYXRhc2V0KGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjBleGFtcGxlJTVCJTIyYXVkaW8lMjIlNUQlMEElMEElMjAlMjAlMjAlMjBleGFtcGxlJTIwJTNEJTIwcHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRleHQlM0RleGFtcGxlJTVCJTIybm9ybWFsaXplZF90ZXh0JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXVkaW9fdGFyZ2V0JTNEYXVkaW8lNUIlMjJhcnJheSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNhbXBsaW5nX3JhdGUlM0RhdWRpbyU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm5fYXR0ZW50aW9uX21hc2slM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBzdHJpcCUyMG9mZiUyMHRoZSUyMGJhdGNoJTIwZGltZW5zaW9uJTBBJTIwJTIwJTIwJTIwZXhhbXBsZSU1QiUyMmxhYmVscyUyMiU1RCUyMCUzRCUyMGV4YW1wbGUlNUIlMjJsYWJlbHMlMjIlNUQlNUIwJTVEJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwdXNlJTIwU3BlZWNoQnJhaW4lMjB0byUyMG9idGFpbiUyMHgtdmVjdG9yJTBBJTIwJTIwJTIwJTIwZXhhbXBsZSU1QiUyMnNwZWFrZXJfZW1iZWRkaW5ncyUyMiU1RCUyMCUzRCUyMGNyZWF0ZV9zcGVha2VyX2VtYmVkZGluZyhhdWRpbyU1QiUyMmFycmF5JTIyJTVEKSUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGV4YW1wbGU=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">prepare_dataset</span>(<span class="hljs-params">example</span>):
    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]

    example = processor(
        text=example[<span class="hljs-string">&quot;normalized_text&quot;</span>],
        audio_target=audio[<span class="hljs-string">&quot;array&quot;</span>],
        sampling_rate=audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
        return_attention_mask=<span class="hljs-literal">False</span>,
    )

    <span class="hljs-comment"># strip off the batch dimension</span>
    example[<span class="hljs-string">&quot;labels&quot;</span>] = example[<span class="hljs-string">&quot;labels&quot;</span>][<span class="hljs-number">0</span>]

    <span class="hljs-comment"># use SpeechBrain to obtain x-vector</span>
    example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] = create_speaker_embedding(audio[<span class="hljs-string">&quot;array&quot;</span>])

    <span class="hljs-keyword">return</span> example`,wrap:!1}}),Ge=new J({props:{code:"cHJvY2Vzc2VkX2V4YW1wbGUlMjAlM0QlMjBwcmVwYXJlX2RhdGFzZXQoZGF0YXNldCU1QjAlNUQpJTBBbGlzdChwcm9jZXNzZWRfZXhhbXBsZS5rZXlzKCkp",highlighted:`processed_example = prepare_dataset(dataset[<span class="hljs-number">0</span>])
<span class="hljs-built_in">list</span>(processed_example.keys())`,wrap:!1}}),ze=new J({props:{code:"JTVCJ2lucHV0X2lkcyclMkMlMjAnbGFiZWxzJyUyQyUyMCdzdG9wX2xhYmVscyclMkMlMjAnc3BlYWtlcl9lbWJlZGRpbmdzJyU1RA==",highlighted:'[<span class="hljs-symbol">&#x27;input_ids</span>&#x27;, <span class="hljs-symbol">&#x27;labels</span>&#x27;, <span class="hljs-symbol">&#x27;stop_labels</span>&#x27;, <span class="hljs-symbol">&#x27;speaker_embeddings</span>&#x27;]',wrap:!1}}),Ne=new J({props:{code:"cHJvY2Vzc2VkX2V4YW1wbGUlNUIlMjJzcGVha2VyX2VtYmVkZGluZ3MlMjIlNUQuc2hhcGU=",highlighted:'processed_example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>].shape',wrap:!1}}),Qe=new J({props:{code:"KDUxMiUyQyk=",highlighted:'(<span class="hljs-number">512</span><span class="hljs-punctuation">,</span>)',wrap:!1}}),qe=new J({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQXBsdC5maWd1cmUoKSUwQXBsdC5pbXNob3cocHJvY2Vzc2VkX2V4YW1wbGUlNUIlMjJsYWJlbHMlMjIlNUQuVCklMEFwbHQuc2hvdygp",highlighted:`<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

plt.figure()
plt.imshow(processed_example[<span class="hljs-string">&quot;labels&quot;</span>].T)
plt.show()`,wrap:!1}}),He=new J({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKHByZXBhcmVfZGF0YXNldCUyQyUyMHJlbW92ZV9jb2x1bW5zJTNEZGF0YXNldC5jb2x1bW5fbmFtZXMp",highlighted:'dataset = dataset.<span class="hljs-built_in">map</span>(prepare_dataset, remove_columns=dataset.column_names)',wrap:!1}}),Se=new J({props:{code:"ZGVmJTIwaXNfbm90X3Rvb19sb25nKGlucHV0X2lkcyklM0ElMEElMjAlMjAlMjAlMjBpbnB1dF9sZW5ndGglMjAlM0QlMjBsZW4oaW5wdXRfaWRzKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGlucHV0X2xlbmd0aCUyMCUzQyUyMDIwMCUwQSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LmZpbHRlcihpc19ub3RfdG9vX2xvbmclMkMlMjBpbnB1dF9jb2x1bW5zJTNEJTVCJTIyaW5wdXRfaWRzJTIyJTVEKSUwQWxlbihkYXRhc2V0KQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">is_not_too_long</span>(<span class="hljs-params">input_ids</span>):
    input_length = <span class="hljs-built_in">len</span>(input_ids)
    <span class="hljs-keyword">return</span> input_length &lt; <span class="hljs-number">200</span>


dataset = dataset.<span class="hljs-built_in">filter</span>(is_not_too_long, input_columns=[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-built_in">len</span>(dataset)`,wrap:!1}}),De=new J({props:{code:"ODI1OQ==",highlighted:'<span class="hljs-number">8259</span>',wrap:!1}}),Ke=new J({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQudHJhaW5fdGVzdF9zcGxpdCh0ZXN0X3NpemUlM0QwLjEp",highlighted:'dataset = dataset.train_test_split(test_size=<span class="hljs-number">0.1</span>)',wrap:!1}}),Oe=new w({props:{title:"Assembleur de données",local:"assembleur-de-données",headingTag:"h3"}}),ss=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Any</span>, <span class="hljs-type">Dict</span>, <span class="hljs-type">List</span>, <span class="hljs-type">Union</span>


<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">TTSDataCollatorWithPadding</span>:
    processor: <span class="hljs-type">Any</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">
        self, features: <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Union</span>[<span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>], torch.Tensor]]]
    </span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor]:
        input_ids = [{<span class="hljs-string">&quot;input_ids&quot;</span>: feature[<span class="hljs-string">&quot;input_ids&quot;</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]
        label_features = [{<span class="hljs-string">&quot;input_values&quot;</span>: feature[<span class="hljs-string">&quot;labels&quot;</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]
        speaker_features = [feature[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]

        <span class="hljs-comment"># assembler les données d&#x27;entrée et les cibles dans un batch</span>
        batch = processor.pad(
            input_ids=input_ids, labels=label_features, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
        )

        <span class="hljs-comment"># remplacer le rembourrage par -100 pour ignorer correctement les pertes</span>
        batch[<span class="hljs-string">&quot;labels&quot;</span>] = batch[<span class="hljs-string">&quot;labels&quot;</span>].masked_fill(
            batch.decoder_attention_mask.unsqueeze(-<span class="hljs-number">1</span>).ne(<span class="hljs-number">1</span>), -<span class="hljs-number">100</span>
        )

        <span class="hljs-comment"># non utilisé pendant le finetuning</span>
        <span class="hljs-keyword">del</span> batch[<span class="hljs-string">&quot;decoder_attention_mask&quot;</span>]

        <span class="hljs-comment"># arrondir les longueurs cibles au multiple du facteur de réduction</span>
        <span class="hljs-keyword">if</span> model.config.reduction_factor &gt; <span class="hljs-number">1</span>:
            target_lengths = torch.tensor(
                [<span class="hljs-built_in">len</span>(feature[<span class="hljs-string">&quot;input_values&quot;</span>]) <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> label_features]
            )
            target_lengths = target_lengths.new(
                [
                    length - length % model.config.reduction_factor
                    <span class="hljs-keyword">for</span> length <span class="hljs-keyword">in</span> target_lengths
                ]
            )
            max_length = <span class="hljs-built_in">max</span>(target_lengths)
            batch[<span class="hljs-string">&quot;labels&quot;</span>] = batch[<span class="hljs-string">&quot;labels&quot;</span>][:, :max_length]

        <span class="hljs-comment"># ajoutez également les enchâssements de locuteur</span>
        batch[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] = torch.tensor(speaker_features)

        <span class="hljs-keyword">return</span> batch`,wrap:!1}}),ts=new J({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMFRUU0RhdGFDb2xsYXRvcldpdGhQYWRkaW5nKHByb2Nlc3NvciUzRHByb2Nlc3Nvcik=",highlighted:"data_collator = TTSDataCollatorWithPadding(processor=processor)",wrap:!1}}),ns=new w({props:{title:"Entraîner le modèle",local:"entraîner-le-modèle",headingTag:"h2"}}),ps=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1Rm9yVGV4dFRvU3BlZWNoJTBBJTBBbW9kZWwlMjAlM0QlMjBTcGVlY2hUNUZvclRleHRUb1NwZWVjaC5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5ForTextToSpeech

model = SpeechT5ForTextToSpeech.from_pretrained(checkpoint)`,wrap:!1}}),is=new J({props:{code:"ZnJvbSUyMGZ1bmN0b29scyUyMGltcG9ydCUyMHBhcnRpYWwlMEElMEElMjMlMjBkJUMzJUE5c2FjdGl2ZXIlMjBsZSUyMGNhY2hlJTIwcGVuZGFudCUyMGwnZW50cmElQzMlQUVuZW1lbnQlMjBjYXIlMjBpbCUyMGVzdCUyMGluY29tcGF0aWJsZSUyMGF2ZWMlMjBsZSUyMGNoZWNrcG9pbnRpbmclMjBkdSUyMGdyYWRpZW50JTBBbW9kZWwuY29uZmlnLnVzZV9jYWNoZSUyMCUzRCUyMEZhbHNlJTBBJTBBJTIzJTIwZCVDMyVBOWZpbmlyJTIwbGElMjBsYW5ndWUlMjBldCUyMGxhJTIwdCVDMyVBMmNoZSUyMHBvdXIlMjBsYSUyMGclQzMlQTluJUMzJUE5cmF0aW9uJTIwZXQlMjByJUMzJUE5YWN0aXZlciUyMGxlJTIwY2FjaGUlMEFtb2RlbC5nZW5lcmF0ZSUyMCUzRCUyMHBhcnRpYWwobW9kZWwuZ2VuZXJhdGUlMkMlMjB1c2VfY2FjaGUlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> functools <span class="hljs-keyword">import</span> partial

<span class="hljs-comment"># désactiver le cache pendant l&#x27;entraînement car il est incompatible avec le checkpointing du gradient</span>
model.config.use_cache = <span class="hljs-literal">False</span>

<span class="hljs-comment"># définir la langue et la tâche pour la génération et réactiver le cache</span>
model.generate = partial(model.generate, use_cache=<span class="hljs-literal">True</span>)`,wrap:!1}}),Ms=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlcTJTZXFUcmFpbmluZ0FyZ3VtZW50cyUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBTZXEyU2VxVHJhaW5pbmdBcmd1bWVudHMoJTBBJTIwJTIwJTIwJTIwb3V0cHV0X2RpciUzRCUyMnNwZWVjaHQ1X2ZpbmV0dW5lZF92b3hwb3B1bGlfbmwlMjIlMkMlMjAlMjAlMjMlMjBjaGFuZ2VyJTIwcG91ciUyMHVuJTIwbm9tJTIwZGUlMjBkJUMzJUE5cCVDMyVCNHQlMjBkZSUyMHZvdHJlJTIwY2hvaXglMEElMjAlMjAlMjAlMjBwZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlM0Q0JTJDJTBBJTIwJTIwJTIwJTIwZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTNEOCUyQyUwQSUyMCUyMCUyMCUyMGxlYXJuaW5nX3JhdGUlM0QxZS01JTJDJTBBJTIwJTIwJTIwJTIwd2FybXVwX3N0ZXBzJTNENTAwJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3N0ZXBzJTNENDAwMCUyQyUwQSUyMCUyMCUyMCUyMGdyYWRpZW50X2NoZWNrcG9pbnRpbmclM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwZnAxNiUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBldmFsdWF0aW9uX3N0cmF0ZWd5JTNEJTIyc3RlcHMlMjIlMkMlMEElMjAlMjAlMjAlMjBwZXJfZGV2aWNlX2V2YWxfYmF0Y2hfc2l6ZSUzRDIlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3N0ZXBzJTNEMTAwMCUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfc3RlcHMlM0QxMDAwJTJDJTBBJTIwJTIwJTIwJTIwbG9nZ2luZ19zdGVwcyUzRDI1JTJDJTBBJTIwJTIwJTIwJTIwcmVwb3J0X3RvJTNEJTVCJTIydGVuc29yYm9hcmQlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBsb2FkX2Jlc3RfbW9kZWxfYXRfZW5kJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGdyZWF0ZXJfaXNfYmV0dGVyJTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjBsYWJlbF9uYW1lcyUzRCU1QiUyMmxhYmVscyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHB1c2hfdG9faHViJTNEVHJ1ZSUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Seq2SeqTrainingArguments

training_args = Seq2SeqTrainingArguments(
    output_dir=<span class="hljs-string">&quot;speecht5_finetuned_voxpopuli_nl&quot;</span>,  <span class="hljs-comment"># changer pour un nom de dépôt de votre choix</span>
    per_device_train_batch_size=<span class="hljs-number">4</span>,
    gradient_accumulation_steps=<span class="hljs-number">8</span>,
    learning_rate=<span class="hljs-number">1e-5</span>,
    warmup_steps=<span class="hljs-number">500</span>,
    max_steps=<span class="hljs-number">4000</span>,
    gradient_checkpointing=<span class="hljs-literal">True</span>,
    fp16=<span class="hljs-literal">True</span>,
    evaluation_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
    per_device_eval_batch_size=<span class="hljs-number">2</span>,
    save_steps=<span class="hljs-number">1000</span>,
    eval_steps=<span class="hljs-number">1000</span>,
    logging_steps=<span class="hljs-number">25</span>,
    report_to=[<span class="hljs-string">&quot;tensorboard&quot;</span>],
    load_best_model_at_end=<span class="hljs-literal">True</span>,
    greater_is_better=<span class="hljs-literal">False</span>,
    label_names=[<span class="hljs-string">&quot;labels&quot;</span>],
    push_to_hub=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),ms=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlcTJTZXFUcmFpbmVyJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNlcTJTZXFUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0RkYXRhc2V0JTVCJTIydGVzdCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0RkYXRhX2NvbGxhdG9yJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEcHJvY2Vzc29yJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Seq2SeqTrainer

trainer = Seq2SeqTrainer(
    args=training_args,
    model=model,
    train_dataset=dataset[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=dataset[<span class="hljs-string">&quot;test&quot;</span>],
    data_collator=data_collator,
    tokenizer=processor,
)`,wrap:!1}}),ds=new J({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()",wrap:!1}}),ys=new J({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1Yigp",highlighted:"trainer.push_to_hub()",wrap:!1}}),Ts=new w({props:{title:"Inférence",local:"inférence",headingTag:"h2"}}),js=new J({props:{code:"bW9kZWwlMjAlM0QlMjBTcGVlY2hUNUZvclRleHRUb1NwZWVjaC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyWU9VUl9BQ0NPVU5UJTJGc3BlZWNodDVfZmluZXR1bmVkX3ZveHBvcHVsaV9ubCUyMiUwQSk=",highlighted:`model = SpeechT5ForTextToSpeech.from_pretrained(
    <span class="hljs-string">&quot;YOUR_ACCOUNT/speecht5_finetuned_voxpopuli_nl&quot;</span>
)`,wrap:!1}}),hs=new J({props:{code:"ZXhhbXBsZSUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTVCMzA0JTVEJTBBc3BlYWtlcl9lbWJlZGRpbmdzJTIwJTNEJTIwdG9yY2gudGVuc29yKGV4YW1wbGUlNUIlMjJzcGVha2VyX2VtYmVkZGluZ3MlMjIlNUQpLnVuc3F1ZWV6ZSgwKQ==",highlighted:`example = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-number">304</span>]
speaker_embeddings = torch.tensor(example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>]).unsqueeze(<span class="hljs-number">0</span>)`,wrap:!1}}),fs=new J({props:{code:"dGV4dCUyMCUzRCUyMCUyMmhhbGxvJTIwYWxsZW1hYWwlMkMlMjBpayUyMHByYWF0JTIwbmVkZXJsYW5kcy4lMjBncm9ldGplcyUyMGFhbiUyMGllZGVyZWVuISUyMg==",highlighted:'text = <span class="hljs-string">&quot;hallo allemaal, ik praat nederlands. groetjes aan iedereen!&quot;</span>',wrap:!1}}),Cs=new J({props:{code:"aW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKHRleHQlM0R0ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:'inputs = processor(text=text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),Zs=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1SGlmaUdhbiUwQSUwQXZvY29kZXIlMjAlM0QlMjBTcGVlY2hUNUhpZmlHYW4uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnNwZWVjaHQ1X2hpZmlnYW4lMjIpJTBBc3BlZWNoJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGVfc3BlZWNoKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCUyQyUyMHNwZWFrZXJfZW1iZWRkaW5ncyUyQyUyMHZvY29kZXIlM0R2b2NvZGVyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5HifiGan

vocoder = SpeechT5HifiGan.from_pretrained(<span class="hljs-string">&quot;microsoft/speecht5_hifigan&quot;</span>)
speech = model.generate_speech(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], speaker_embeddings, vocoder=vocoder)`,wrap:!1}}),gs=new J({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBQXVkaW8oc3BlZWNoLm51bXB5KCklMkMlMjByYXRlJTNEMTYwMDAp",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio

Audio(speech.numpy(), rate=<span class="hljs-number">16000</span>)`,wrap:!1}}),Bs=new ja({props:{source:"https://github.com/huggingface/audio-transformers-course/blob/main/chapters/fr/chapter6/fine-tuning.mdx"}}),{c(){y=p("meta"),b=n(),T=p("p"),Ws=n(),u(f.$$.fragment),zs=n(),I=p("p"),I.innerHTML=Ot,Xs=n(),u(C.$$.fragment),Ns=n(),$=p("p"),$.innerHTML=en,Ys=n(),u(Z.$$.fragment),Qs=n(),u(j.$$.fragment),Rs=n(),v=p("p"),v.textContent=sn,qs=n(),u(g.$$.fragment),As=n(),x=p("p"),x.textContent=ln,Es=n(),u(k.$$.fragment),Hs=n(),u(V.$$.fragment),Fs=n(),B=p("p"),B.innerHTML=tn,Ss=n(),W=p("p"),W.textContent=nn,Ls=n(),G=p("p"),G.textContent=an,Ds=n(),u(_.$$.fragment),Ps=n(),z=p("p"),z.innerHTML=pn,Ks=n(),u(X.$$.fragment),Os=n(),N=p("p"),N.innerHTML=rn,el=n(),u(Y.$$.fragment),sl=n(),u(Q.$$.fragment),ll=n(),R=p("p"),R.innerHTML=un,tl=n(),u(q.$$.fragment),nl=n(),u(A.$$.fragment),al=n(),E=p("p"),E.innerHTML=Mn,pl=n(),u(H.$$.fragment),rl=n(),F=p("p"),F.textContent=on,il=n(),u(S.$$.fragment),ul=n(),L=p("p"),L.innerHTML=mn,Ml=n(),u(D.$$.fragment),ol=n(),P=p("p"),P.innerHTML=cn,ml=n(),K=p("p"),K.innerHTML=dn,cl=n(),O=p("p"),O.innerHTML=Jn,dl=n(),u(ee.$$.fragment),Jl=n(),se=p("p"),se.innerHTML=yn,yl=n(),u(le.$$.fragment),Tl=n(),te=p("p"),te.innerHTML=Tn,wl=n(),u(ne.$$.fragment),jl=n(),ae=p("p"),ae.innerHTML=wn,Ul=n(),u(pe.$$.fragment),hl=n(),re=p("p"),re.textContent=jn,bl=n(),u(ie.$$.fragment),fl=n(),ue=p("p"),ue.textContent=Un,Il=n(),u(Me.$$.fragment),Cl=n(),oe=p("p"),oe.textContent=hn,$l=n(),u(me.$$.fragment),Zl=n(),U=p("div"),U.innerHTML=bn,vl=n(),ce=p("p"),ce.textContent=fn,gl=n(),u(de.$$.fragment),xl=n(),Je=p("p"),Je.textContent=In,kl=n(),u(ye.$$.fragment),Vl=n(),Te=p("p"),Te.innerHTML=Cn,Bl=n(),u(we.$$.fragment),Wl=n(),je=p("p"),je.textContent=$n,Gl=n(),u(Ue.$$.fragment),_l=n(),he=p("p"),he.innerHTML=Zn,zl=n(),u(be.$$.fragment),Xl=n(),fe=p("p"),fe.textContent=vn,Nl=n(),Ie=p("p"),Ie.textContent=gn,Yl=n(),u(Ce.$$.fragment),Ql=n(),$e=p("p"),$e.innerHTML=xn,Rl=n(),Ze=p("p"),Ze.innerHTML=kn,ql=n(),u(ve.$$.fragment),Al=n(),ge=p("p"),ge.innerHTML=Vn,El=n(),xe=p("p"),xe.innerHTML=Bn,Hl=n(),u(ke.$$.fragment),Fl=n(),Ve=p("p"),Ve.innerHTML=Wn,Sl=n(),u(Be.$$.fragment),Ll=n(),We=p("p"),We.textContent=Gn,Dl=n(),u(Ge.$$.fragment),Pl=n(),_e=p("p"),_e.innerHTML=_n,Kl=n(),u(ze.$$.fragment),Ol=n(),Xe=p("p"),Xe.textContent=zn,et=n(),u(Ne.$$.fragment),st=n(),Ye=p("p"),Ye.innerHTML=Xn,lt=n(),u(Qe.$$.fragment),tt=n(),Re=p("p"),Re.textContent=Nn,nt=n(),u(qe.$$.fragment),at=n(),h=p("div"),h.innerHTML=Yn,pt=n(),Ae=p("p"),Ae.textContent=Qn,rt=n(),Ee=p("p"),Ee.textContent=Rn,it=n(),u(He.$$.fragment),ut=n(),Fe=p("p"),Fe.innerHTML=qn,Mt=n(),u(Se.$$.fragment),ot=n(),Le=p("p"),Le.innerHTML=An,mt=n(),u(De.$$.fragment),ct=n(),Pe=p("p"),Pe.textContent=En,dt=n(),u(Ke.$$.fragment),Jt=n(),u(Oe.$$.fragment),yt=n(),es=p("p"),es.innerHTML=Hn,Tt=n(),u(ss.$$.fragment),wt=n(),ls=p("p"),ls.textContent=Fn,jt=n(),u(ts.$$.fragment),Ut=n(),u(ns.$$.fragment),ht=n(),as=p("p"),as.innerHTML=Sn,bt=n(),u(ps.$$.fragment),ft=n(),rs=p("p"),rs.innerHTML=Ln,It=n(),u(is.$$.fragment),Ct=n(),us=p("p"),us.textContent=Dn,$t=n(),u(Ms.$$.fragment),Zt=n(),os=p("p"),os.innerHTML=Pn,vt=n(),u(ms.$$.fragment),gt=n(),cs=p("p"),cs.innerHTML=Kn,xt=n(),u(ds.$$.fragment),kt=n(),Js=p("p"),Js.innerHTML=On,Vt=n(),u(ys.$$.fragment),Bt=n(),u(Ts.$$.fragment),Wt=n(),ws=p("p"),ws.innerHTML=ea,Gt=n(),u(js.$$.fragment),_t=n(),Us=p("p"),Us.textContent=sa,zt=n(),u(hs.$$.fragment),Xt=n(),bs=p("p"),bs.innerHTML=la,Nt=n(),u(fs.$$.fragment),Yt=n(),Is=p("p"),Is.textContent=ta,Qt=n(),u(Cs.$$.fragment),Rt=n(),$s=p("p"),$s.textContent=na,qt=n(),u(Zs.$$.fragment),At=n(),vs=p("p"),vs.textContent=aa,Et=n(),u(gs.$$.fragment),Ht=n(),xs=p("p"),xs.textContent=pa,Ft=n(),ks=p("p"),ks.innerHTML=ra,St=n(),Vs=p("p"),Vs.textContent=ia,Lt=n(),u(Bs.$$.fragment),Dt=n(),Gs=p("p"),this.h()},l(e){const s=ya("svelte-u9bgzb",document.head);y=r(s,"META",{name:!0,content:!0}),s.forEach(l),b=a(e),T=r(e,"P",{}),Ma(T).forEach(l),Ws=a(e),M(f.$$.fragment,e),zs=a(e),I=r(e,"P",{"data-svelte-h":!0}),i(I)!=="svelte-1odglk1"&&(I.innerHTML=Ot),Xs=a(e),M(C.$$.fragment,e),Ns=a(e),$=r(e,"P",{"data-svelte-h":!0}),i($)!=="svelte-1xtit6n"&&($.innerHTML=en),Ys=a(e),M(Z.$$.fragment,e),Qs=a(e),M(j.$$.fragment,e),Rs=a(e),v=r(e,"P",{"data-svelte-h":!0}),i(v)!=="svelte-zql47t"&&(v.textContent=sn),qs=a(e),M(g.$$.fragment,e),As=a(e),x=r(e,"P",{"data-svelte-h":!0}),i(x)!=="svelte-182tg48"&&(x.textContent=ln),Es=a(e),M(k.$$.fragment,e),Hs=a(e),M(V.$$.fragment,e),Fs=a(e),B=r(e,"P",{"data-svelte-h":!0}),i(B)!=="svelte-649ds4"&&(B.innerHTML=tn),Ss=a(e),W=r(e,"P",{"data-svelte-h":!0}),i(W)!=="svelte-r0igd1"&&(W.textContent=nn),Ls=a(e),G=r(e,"P",{"data-svelte-h":!0}),i(G)!=="svelte-gwah4k"&&(G.textContent=an),Ds=a(e),M(_.$$.fragment,e),Ps=a(e),z=r(e,"P",{"data-svelte-h":!0}),i(z)!=="svelte-dbzevp"&&(z.innerHTML=pn),Ks=a(e),M(X.$$.fragment,e),Os=a(e),N=r(e,"P",{"data-svelte-h":!0}),i(N)!=="svelte-iud575"&&(N.innerHTML=rn),el=a(e),M(Y.$$.fragment,e),sl=a(e),M(Q.$$.fragment,e),ll=a(e),R=r(e,"P",{"data-svelte-h":!0}),i(R)!=="svelte-1xkg4b0"&&(R.innerHTML=un),tl=a(e),M(q.$$.fragment,e),nl=a(e),M(A.$$.fragment,e),al=a(e),E=r(e,"P",{"data-svelte-h":!0}),i(E)!=="svelte-1hwlbv"&&(E.innerHTML=Mn),pl=a(e),M(H.$$.fragment,e),rl=a(e),F=r(e,"P",{"data-svelte-h":!0}),i(F)!=="svelte-1ma4sp4"&&(F.textContent=on),il=a(e),M(S.$$.fragment,e),ul=a(e),L=r(e,"P",{"data-svelte-h":!0}),i(L)!=="svelte-dbzevp"&&(L.innerHTML=mn),Ml=a(e),M(D.$$.fragment,e),ol=a(e),P=r(e,"P",{"data-svelte-h":!0}),i(P)!=="svelte-1fh07v6"&&(P.innerHTML=cn),ml=a(e),K=r(e,"P",{"data-svelte-h":!0}),i(K)!=="svelte-bjt1cp"&&(K.innerHTML=dn),cl=a(e),O=r(e,"P",{"data-svelte-h":!0}),i(O)!=="svelte-1y8jaor"&&(O.innerHTML=Jn),dl=a(e),M(ee.$$.fragment,e),Jl=a(e),se=r(e,"P",{"data-svelte-h":!0}),i(se)!=="svelte-1xmdue5"&&(se.innerHTML=yn),yl=a(e),M(le.$$.fragment,e),Tl=a(e),te=r(e,"P",{"data-svelte-h":!0}),i(te)!=="svelte-dbzevp"&&(te.innerHTML=Tn),wl=a(e),M(ne.$$.fragment,e),jl=a(e),ae=r(e,"P",{"data-svelte-h":!0}),i(ae)!=="svelte-8zji7u"&&(ae.innerHTML=wn),Ul=a(e),M(pe.$$.fragment,e),hl=a(e),re=r(e,"P",{"data-svelte-h":!0}),i(re)!=="svelte-19enlau"&&(re.textContent=jn),bl=a(e),M(ie.$$.fragment,e),fl=a(e),ue=r(e,"P",{"data-svelte-h":!0}),i(ue)!=="svelte-18ycs8t"&&(ue.textContent=Un),Il=a(e),M(Me.$$.fragment,e),Cl=a(e),oe=r(e,"P",{"data-svelte-h":!0}),i(oe)!=="svelte-nwfji0"&&(oe.textContent=hn),$l=a(e),M(me.$$.fragment,e),Zl=a(e),U=r(e,"DIV",{class:!0,"data-svelte-h":!0}),i(U)!=="svelte-1uufiik"&&(U.innerHTML=bn),vl=a(e),ce=r(e,"P",{"data-svelte-h":!0}),i(ce)!=="svelte-1rtsrif"&&(ce.textContent=fn),gl=a(e),M(de.$$.fragment,e),xl=a(e),Je=r(e,"P",{"data-svelte-h":!0}),i(Je)!=="svelte-16v30mk"&&(Je.textContent=In),kl=a(e),M(ye.$$.fragment,e),Vl=a(e),Te=r(e,"P",{"data-svelte-h":!0}),i(Te)!=="svelte-dbzevp"&&(Te.innerHTML=Cn),Bl=a(e),M(we.$$.fragment,e),Wl=a(e),je=r(e,"P",{"data-svelte-h":!0}),i(je)!=="svelte-zuw53j"&&(je.textContent=$n),Gl=a(e),M(Ue.$$.fragment,e),_l=a(e),he=r(e,"P",{"data-svelte-h":!0}),i(he)!=="svelte-dbzevp"&&(he.innerHTML=Zn),zl=a(e),M(be.$$.fragment,e),Xl=a(e),fe=r(e,"P",{"data-svelte-h":!0}),i(fe)!=="svelte-31x8kk"&&(fe.textContent=vn),Nl=a(e),Ie=r(e,"P",{"data-svelte-h":!0}),i(Ie)!=="svelte-1w6hl2u"&&(Ie.textContent=gn),Yl=a(e),M(Ce.$$.fragment,e),Ql=a(e),$e=r(e,"P",{"data-svelte-h":!0}),i($e)!=="svelte-17z7cpr"&&($e.innerHTML=xn),Rl=a(e),Ze=r(e,"P",{"data-svelte-h":!0}),i(Ze)!=="svelte-4hmwow"&&(Ze.innerHTML=kn),ql=a(e),M(ve.$$.fragment,e),Al=a(e),ge=r(e,"P",{"data-svelte-h":!0}),i(ge)!=="svelte-xw8jh1"&&(ge.innerHTML=Vn),El=a(e),xe=r(e,"P",{"data-svelte-h":!0}),i(xe)!=="svelte-6lbev2"&&(xe.innerHTML=Bn),Hl=a(e),M(ke.$$.fragment,e),Fl=a(e),Ve=r(e,"P",{"data-svelte-h":!0}),i(Ve)!=="svelte-1oc1ikt"&&(Ve.innerHTML=Wn),Sl=a(e),M(Be.$$.fragment,e),Ll=a(e),We=r(e,"P",{"data-svelte-h":!0}),i(We)!=="svelte-56wyab"&&(We.textContent=Gn),Dl=a(e),M(Ge.$$.fragment,e),Pl=a(e),_e=r(e,"P",{"data-svelte-h":!0}),i(_e)!=="svelte-dbzevp"&&(_e.innerHTML=_n),Kl=a(e),M(ze.$$.fragment,e),Ol=a(e),Xe=r(e,"P",{"data-svelte-h":!0}),i(Xe)!=="svelte-8c0crw"&&(Xe.textContent=zn),et=a(e),M(Ne.$$.fragment,e),st=a(e),Ye=r(e,"P",{"data-svelte-h":!0}),i(Ye)!=="svelte-dbzevp"&&(Ye.innerHTML=Xn),lt=a(e),M(Qe.$$.fragment,e),tt=a(e),Re=r(e,"P",{"data-svelte-h":!0}),i(Re)!=="svelte-33k1kn"&&(Re.textContent=Nn),nt=a(e),M(qe.$$.fragment,e),at=a(e),h=r(e,"DIV",{class:!0,"data-svelte-h":!0}),i(h)!=="svelte-j4o1b8"&&(h.innerHTML=Yn),pt=a(e),Ae=r(e,"P",{"data-svelte-h":!0}),i(Ae)!=="svelte-dra6ot"&&(Ae.textContent=Qn),rt=a(e),Ee=r(e,"P",{"data-svelte-h":!0}),i(Ee)!=="svelte-6d8mq6"&&(Ee.textContent=Rn),it=a(e),M(He.$$.fragment,e),ut=a(e),Fe=r(e,"P",{"data-svelte-h":!0}),i(Fe)!=="svelte-ezcn9z"&&(Fe.innerHTML=qn),Mt=a(e),M(Se.$$.fragment,e),ot=a(e),Le=r(e,"P",{"data-svelte-h":!0}),i(Le)!=="svelte-dbzevp"&&(Le.innerHTML=An),mt=a(e),M(De.$$.fragment,e),ct=a(e),Pe=r(e,"P",{"data-svelte-h":!0}),i(Pe)!=="svelte-12gx63x"&&(Pe.textContent=En),dt=a(e),M(Ke.$$.fragment,e),Jt=a(e),M(Oe.$$.fragment,e),yt=a(e),es=r(e,"P",{"data-svelte-h":!0}),i(es)!=="svelte-zdglne"&&(es.innerHTML=Hn),Tt=a(e),M(ss.$$.fragment,e),wt=a(e),ls=r(e,"P",{"data-svelte-h":!0}),i(ls)!=="svelte-1g1h6a2"&&(ls.textContent=Fn),jt=a(e),M(ts.$$.fragment,e),Ut=a(e),M(ns.$$.fragment,e),ht=a(e),as=r(e,"P",{"data-svelte-h":!0}),i(as)!=="svelte-kop7ev"&&(as.innerHTML=Sn),bt=a(e),M(ps.$$.fragment,e),ft=a(e),rs=r(e,"P",{"data-svelte-h":!0}),i(rs)!=="svelte-1wpgu2u"&&(rs.innerHTML=Ln),It=a(e),M(is.$$.fragment,e),Ct=a(e),us=r(e,"P",{"data-svelte-h":!0}),i(us)!=="svelte-14u91wl"&&(us.textContent=Dn),$t=a(e),M(Ms.$$.fragment,e),Zt=a(e),os=r(e,"P",{"data-svelte-h":!0}),i(os)!=="svelte-15wpyyc"&&(os.innerHTML=Pn),vt=a(e),M(ms.$$.fragment,e),gt=a(e),cs=r(e,"P",{"data-svelte-h":!0}),i(cs)!=="svelte-c07opw"&&(cs.innerHTML=Kn),xt=a(e),M(ds.$$.fragment,e),kt=a(e),Js=r(e,"P",{"data-svelte-h":!0}),i(Js)!=="svelte-mr5xro"&&(Js.innerHTML=On),Vt=a(e),M(ys.$$.fragment,e),Bt=a(e),M(Ts.$$.fragment,e),Wt=a(e),ws=r(e,"P",{"data-svelte-h":!0}),i(ws)!=="svelte-7v0yj3"&&(ws.innerHTML=ea),Gt=a(e),M(js.$$.fragment,e),_t=a(e),Us=r(e,"P",{"data-svelte-h":!0}),i(Us)!=="svelte-qm5zo2"&&(Us.textContent=sa),zt=a(e),M(hs.$$.fragment,e),Xt=a(e),bs=r(e,"P",{"data-svelte-h":!0}),i(bs)!=="svelte-1atngeh"&&(bs.innerHTML=la),Nt=a(e),M(fs.$$.fragment,e),Yt=a(e),Is=r(e,"P",{"data-svelte-h":!0}),i(Is)!=="svelte-11n0rrj"&&(Is.textContent=ta),Qt=a(e),M(Cs.$$.fragment,e),Rt=a(e),$s=r(e,"P",{"data-svelte-h":!0}),i($s)!=="svelte-671fhq"&&($s.textContent=na),qt=a(e),M(Zs.$$.fragment,e),At=a(e),vs=r(e,"P",{"data-svelte-h":!0}),i(vs)!=="svelte-7kkl40"&&(vs.textContent=aa),Et=a(e),M(gs.$$.fragment,e),Ht=a(e),xs=r(e,"P",{"data-svelte-h":!0}),i(xs)!=="svelte-d3yvzd"&&(xs.textContent=pa),Ft=a(e),ks=r(e,"P",{"data-svelte-h":!0}),i(ks)!=="svelte-1i751j2"&&(ks.innerHTML=ra),St=a(e),Vs=r(e,"P",{"data-svelte-h":!0}),i(Vs)!=="svelte-y5achn"&&(Vs.textContent=ia),Lt=a(e),M(Bs.$$.fragment,e),Dt=a(e),Gs=r(e,"P",{}),Ma(Gs).forEach(l),this.h()},h(){Kt(y,"name","hf:doc:metadata"),Kt(y,"content",ba),Kt(U,"class","flex justify-center"),Kt(h,"class","flex justify-center")},m(e,s){Ta(document.head,y),t(e,b,s),t(e,T,s),t(e,Ws,s),o(f,e,s),t(e,zs,s),t(e,I,s),t(e,Xs,s),o(C,e,s),t(e,Ns,s),t(e,$,s),t(e,Ys,s),o(Z,e,s),t(e,Qs,s),o(j,e,s),t(e,Rs,s),t(e,v,s),t(e,qs,s),o(g,e,s),t(e,As,s),t(e,x,s),t(e,Es,s),o(k,e,s),t(e,Hs,s),o(V,e,s),t(e,Fs,s),t(e,B,s),t(e,Ss,s),t(e,W,s),t(e,Ls,s),t(e,G,s),t(e,Ds,s),o(_,e,s),t(e,Ps,s),t(e,z,s),t(e,Ks,s),o(X,e,s),t(e,Os,s),t(e,N,s),t(e,el,s),o(Y,e,s),t(e,sl,s),o(Q,e,s),t(e,ll,s),t(e,R,s),t(e,tl,s),o(q,e,s),t(e,nl,s),o(A,e,s),t(e,al,s),t(e,E,s),t(e,pl,s),o(H,e,s),t(e,rl,s),t(e,F,s),t(e,il,s),o(S,e,s),t(e,ul,s),t(e,L,s),t(e,Ml,s),o(D,e,s),t(e,ol,s),t(e,P,s),t(e,ml,s),t(e,K,s),t(e,cl,s),t(e,O,s),t(e,dl,s),o(ee,e,s),t(e,Jl,s),t(e,se,s),t(e,yl,s),o(le,e,s),t(e,Tl,s),t(e,te,s),t(e,wl,s),o(ne,e,s),t(e,jl,s),t(e,ae,s),t(e,Ul,s),o(pe,e,s),t(e,hl,s),t(e,re,s),t(e,bl,s),o(ie,e,s),t(e,fl,s),t(e,ue,s),t(e,Il,s),o(Me,e,s),t(e,Cl,s),t(e,oe,s),t(e,$l,s),o(me,e,s),t(e,Zl,s),t(e,U,s),t(e,vl,s),t(e,ce,s),t(e,gl,s),o(de,e,s),t(e,xl,s),t(e,Je,s),t(e,kl,s),o(ye,e,s),t(e,Vl,s),t(e,Te,s),t(e,Bl,s),o(we,e,s),t(e,Wl,s),t(e,je,s),t(e,Gl,s),o(Ue,e,s),t(e,_l,s),t(e,he,s),t(e,zl,s),o(be,e,s),t(e,Xl,s),t(e,fe,s),t(e,Nl,s),t(e,Ie,s),t(e,Yl,s),o(Ce,e,s),t(e,Ql,s),t(e,$e,s),t(e,Rl,s),t(e,Ze,s),t(e,ql,s),o(ve,e,s),t(e,Al,s),t(e,ge,s),t(e,El,s),t(e,xe,s),t(e,Hl,s),o(ke,e,s),t(e,Fl,s),t(e,Ve,s),t(e,Sl,s),o(Be,e,s),t(e,Ll,s),t(e,We,s),t(e,Dl,s),o(Ge,e,s),t(e,Pl,s),t(e,_e,s),t(e,Kl,s),o(ze,e,s),t(e,Ol,s),t(e,Xe,s),t(e,et,s),o(Ne,e,s),t(e,st,s),t(e,Ye,s),t(e,lt,s),o(Qe,e,s),t(e,tt,s),t(e,Re,s),t(e,nt,s),o(qe,e,s),t(e,at,s),t(e,h,s),t(e,pt,s),t(e,Ae,s),t(e,rt,s),t(e,Ee,s),t(e,it,s),o(He,e,s),t(e,ut,s),t(e,Fe,s),t(e,Mt,s),o(Se,e,s),t(e,ot,s),t(e,Le,s),t(e,mt,s),o(De,e,s),t(e,ct,s),t(e,Pe,s),t(e,dt,s),o(Ke,e,s),t(e,Jt,s),o(Oe,e,s),t(e,yt,s),t(e,es,s),t(e,Tt,s),o(ss,e,s),t(e,wt,s),t(e,ls,s),t(e,jt,s),o(ts,e,s),t(e,Ut,s),o(ns,e,s),t(e,ht,s),t(e,as,s),t(e,bt,s),o(ps,e,s),t(e,ft,s),t(e,rs,s),t(e,It,s),o(is,e,s),t(e,Ct,s),t(e,us,s),t(e,$t,s),o(Ms,e,s),t(e,Zt,s),t(e,os,s),t(e,vt,s),o(ms,e,s),t(e,gt,s),t(e,cs,s),t(e,xt,s),o(ds,e,s),t(e,kt,s),t(e,Js,s),t(e,Vt,s),o(ys,e,s),t(e,Bt,s),o(Ts,e,s),t(e,Wt,s),t(e,ws,s),t(e,Gt,s),o(js,e,s),t(e,_t,s),t(e,Us,s),t(e,zt,s),o(hs,e,s),t(e,Xt,s),t(e,bs,s),t(e,Nt,s),o(fs,e,s),t(e,Yt,s),t(e,Is,s),t(e,Qt,s),o(Cs,e,s),t(e,Rt,s),t(e,$s,s),t(e,qt,s),o(Zs,e,s),t(e,At,s),t(e,vs,s),t(e,Et,s),o(gs,e,s),t(e,Ht,s),t(e,xs,s),t(e,Ft,s),t(e,ks,s),t(e,St,s),t(e,Vs,s),t(e,Lt,s),o(Bs,e,s),t(e,Dt,s),t(e,Gs,s),Pt=!0},p(e,[s]){const ua={};s&2&&(ua.$$scope={dirty:s,ctx:e}),j.$set(ua)},i(e){Pt||(m(f.$$.fragment,e),m(C.$$.fragment,e),m(Z.$$.fragment,e),m(j.$$.fragment,e),m(g.$$.fragment,e),m(k.$$.fragment,e),m(V.$$.fragment,e),m(_.$$.fragment,e),m(X.$$.fragment,e),m(Y.$$.fragment,e),m(Q.$$.fragment,e),m(q.$$.fragment,e),m(A.$$.fragment,e),m(H.$$.fragment,e),m(S.$$.fragment,e),m(D.$$.fragment,e),m(ee.$$.fragment,e),m(le.$$.fragment,e),m(ne.$$.fragment,e),m(pe.$$.fragment,e),m(ie.$$.fragment,e),m(Me.$$.fragment,e),m(me.$$.fragment,e),m(de.$$.fragment,e),m(ye.$$.fragment,e),m(we.$$.fragment,e),m(Ue.$$.fragment,e),m(be.$$.fragment,e),m(Ce.$$.fragment,e),m(ve.$$.fragment,e),m(ke.$$.fragment,e),m(Be.$$.fragment,e),m(Ge.$$.fragment,e),m(ze.$$.fragment,e),m(Ne.$$.fragment,e),m(Qe.$$.fragment,e),m(qe.$$.fragment,e),m(He.$$.fragment,e),m(Se.$$.fragment,e),m(De.$$.fragment,e),m(Ke.$$.fragment,e),m(Oe.$$.fragment,e),m(ss.$$.fragment,e),m(ts.$$.fragment,e),m(ns.$$.fragment,e),m(ps.$$.fragment,e),m(is.$$.fragment,e),m(Ms.$$.fragment,e),m(ms.$$.fragment,e),m(ds.$$.fragment,e),m(ys.$$.fragment,e),m(Ts.$$.fragment,e),m(js.$$.fragment,e),m(hs.$$.fragment,e),m(fs.$$.fragment,e),m(Cs.$$.fragment,e),m(Zs.$$.fragment,e),m(gs.$$.fragment,e),m(Bs.$$.fragment,e),Pt=!0)},o(e){c(f.$$.fragment,e),c(C.$$.fragment,e),c(Z.$$.fragment,e),c(j.$$.fragment,e),c(g.$$.fragment,e),c(k.$$.fragment,e),c(V.$$.fragment,e),c(_.$$.fragment,e),c(X.$$.fragment,e),c(Y.$$.fragment,e),c(Q.$$.fragment,e),c(q.$$.fragment,e),c(A.$$.fragment,e),c(H.$$.fragment,e),c(S.$$.fragment,e),c(D.$$.fragment,e),c(ee.$$.fragment,e),c(le.$$.fragment,e),c(ne.$$.fragment,e),c(pe.$$.fragment,e),c(ie.$$.fragment,e),c(Me.$$.fragment,e),c(me.$$.fragment,e),c(de.$$.fragment,e),c(ye.$$.fragment,e),c(we.$$.fragment,e),c(Ue.$$.fragment,e),c(be.$$.fragment,e),c(Ce.$$.fragment,e),c(ve.$$.fragment,e),c(ke.$$.fragment,e),c(Be.$$.fragment,e),c(Ge.$$.fragment,e),c(ze.$$.fragment,e),c(Ne.$$.fragment,e),c(Qe.$$.fragment,e),c(qe.$$.fragment,e),c(He.$$.fragment,e),c(Se.$$.fragment,e),c(De.$$.fragment,e),c(Ke.$$.fragment,e),c(Oe.$$.fragment,e),c(ss.$$.fragment,e),c(ts.$$.fragment,e),c(ns.$$.fragment,e),c(ps.$$.fragment,e),c(is.$$.fragment,e),c(Ms.$$.fragment,e),c(ms.$$.fragment,e),c(ds.$$.fragment,e),c(ys.$$.fragment,e),c(Ts.$$.fragment,e),c(js.$$.fragment,e),c(hs.$$.fragment,e),c(fs.$$.fragment,e),c(Cs.$$.fragment,e),c(Zs.$$.fragment,e),c(gs.$$.fragment,e),c(Bs.$$.fragment,e),Pt=!1},d(e){e&&(l(b),l(T),l(Ws),l(zs),l(I),l(Xs),l(Ns),l($),l(Ys),l(Qs),l(Rs),l(v),l(qs),l(As),l(x),l(Es),l(Hs),l(Fs),l(B),l(Ss),l(W),l(Ls),l(G),l(Ds),l(Ps),l(z),l(Ks),l(Os),l(N),l(el),l(sl),l(ll),l(R),l(tl),l(nl),l(al),l(E),l(pl),l(rl),l(F),l(il),l(ul),l(L),l(Ml),l(ol),l(P),l(ml),l(K),l(cl),l(O),l(dl),l(Jl),l(se),l(yl),l(Tl),l(te),l(wl),l(jl),l(ae),l(Ul),l(hl),l(re),l(bl),l(fl),l(ue),l(Il),l(Cl),l(oe),l($l),l(Zl),l(U),l(vl),l(ce),l(gl),l(xl),l(Je),l(kl),l(Vl),l(Te),l(Bl),l(Wl),l(je),l(Gl),l(_l),l(he),l(zl),l(Xl),l(fe),l(Nl),l(Ie),l(Yl),l(Ql),l($e),l(Rl),l(Ze),l(ql),l(Al),l(ge),l(El),l(xe),l(Hl),l(Fl),l(Ve),l(Sl),l(Ll),l(We),l(Dl),l(Pl),l(_e),l(Kl),l(Ol),l(Xe),l(et),l(st),l(Ye),l(lt),l(tt),l(Re),l(nt),l(at),l(h),l(pt),l(Ae),l(rt),l(Ee),l(it),l(ut),l(Fe),l(Mt),l(ot),l(Le),l(mt),l(ct),l(Pe),l(dt),l(Jt),l(yt),l(es),l(Tt),l(wt),l(ls),l(jt),l(Ut),l(ht),l(as),l(bt),l(ft),l(rs),l(It),l(Ct),l(us),l($t),l(Zt),l(os),l(vt),l(gt),l(cs),l(xt),l(kt),l(Js),l(Vt),l(Bt),l(Wt),l(ws),l(Gt),l(_t),l(Us),l(zt),l(Xt),l(bs),l(Nt),l(Yt),l(Is),l(Qt),l(Rt),l($s),l(qt),l(At),l(vs),l(Et),l(Ht),l(xs),l(Ft),l(ks),l(St),l(Vs),l(Lt),l(Dt),l(Gs)),l(y),d(f,e),d(C,e),d(Z,e),d(j,e),d(g,e),d(k,e),d(V,e),d(_,e),d(X,e),d(Y,e),d(Q,e),d(q,e),d(A,e),d(H,e),d(S,e),d(D,e),d(ee,e),d(le,e),d(ne,e),d(pe,e),d(ie,e),d(Me,e),d(me,e),d(de,e),d(ye,e),d(we,e),d(Ue,e),d(be,e),d(Ce,e),d(ve,e),d(ke,e),d(Be,e),d(Ge,e),d(ze,e),d(Ne,e),d(Qe,e),d(qe,e),d(He,e),d(Se,e),d(De,e),d(Ke,e),d(Oe,e),d(ss,e),d(ts,e),d(ns,e),d(ps,e),d(is,e),d(Ms,e),d(ms,e),d(ds,e),d(ys,e),d(Ts,e),d(js,e),d(hs,e),d(fs,e),d(Cs,e),d(Zs,e),d(gs,e),d(Bs,e)}}}const ba='{"title":"Finetuning du SpeechT5","local":"finetuning-du-speecht5","sections":[{"title":"Préparation","local":"préparation","sections":[],"depth":2},{"title":"Le jeu de données","local":"le-jeu-de-données","sections":[],"depth":2},{"title":"Prétraitement des données","local":"prétraitement-des-données","sections":[{"title":"Nettoyage du texte pour la tokenisation de SpeechT5","local":"nettoyage-du-texte-pour-la-tokenisation-de-speecht5","sections":[],"depth":3},{"title":"Les locuteurs","local":"les-locuteurs","sections":[],"depth":3},{"title":"Enchâssement des locuteurs","local":"enchâssement-des-locuteurs","sections":[],"depth":3},{"title":"Traitement du jeu de données","local":"traitement-du-jeu-de-données","sections":[],"depth":3},{"title":"Assembleur de données","local":"assembleur-de-données","sections":[],"depth":3}],"depth":2},{"title":"Entraîner le modèle","local":"entraîner-le-modèle","sections":[],"depth":2},{"title":"Inférence","local":"inférence","sections":[],"depth":2}],"depth":1}';function fa(_s){return ma(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ga extends da{constructor(y){super(),Ja(this,y,fa,ha,oa,{})}}export{ga as component};
