import{s as gn,n as In,o as dn}from"../chunks/scheduler.37c15a92.js";import{S as bn,i as fn,g as U,s as n,r as T,A as Rn,h as M,f as e,c as a,j as Vn,u as p,x as J,k as Ms,y as hn,a as s,v as i,d as o,t as C,w as y}from"../chunks/index.2bf4358c.js";import{C as r}from"../chunks/CodeBlock.4e987730.js";import{C as Qn}from"../chunks/CourseFloatingBanner.6add7356.js";import{H as m}from"../chunks/Heading.8ada512a.js";import{E as Bn}from"../chunks/getInferenceSnippets.0aa3753f.js";function kn(Js){let u,ot,pt,Ct,c,yt,j,mt,w,Ts='<p>你可以跟随<a href="https://huggingface.co/agents-course/notebooks/blob/main/bonus-unit2/monitoring-and-evaluating-agents-notebook.ipynb" target="_blank">这个 notebook</a> 中的代码进行操作，你可以在 Google Colab 上运行它。</p>',rt,V,ps="在这个 notebook 中，我们将学习如何使用开源可观测性工具来<strong>监督我们 AI 智能体的内部步骤（追踪）</strong>并<strong>评估其性能</strong>。",ut,g,is="观测和评估智能体行为的能力对于以下方面至关重要：",wt,I,os="<li>当任务失败或产生次优结果时调试问题</li> <li>实时跟踪成本和性能</li> <li>通过持续反馈提高可靠性和安全性</li>",ct,d,jt,b,Cs="在运行此 notebook 之前，请确保你已经：",Vt,f,ys='🔲 📚  <strong>学习了</strong> <a href="https://huggingface.co/learn/agents-course/unit1/introduction" rel="nofollow">智能体简介</a>',gt,R,ms='🔲 📚  <strong>学习了</strong> <a href="https://huggingface.co/learn/agents-course/unit2/smolagents/introduction" rel="nofollow">smolagents 框架</a>',It,h,dt,Q,rs="我们将需要一些库，以便我们能够运行、监控和评估我们的智能体：",bt,B,ft,k,Rt,N,us='在这个 notebook 中，我们将使用 <a href="https://langfuse.com/" rel="nofollow">Langfuse</a> 作为我们的可观测性工具，但你可以使用<strong>任何其他兼容 OpenTelemetry 的服务</strong>。下面的代码展示了如何为 Langfuse（或任何 OTel 端点）设置环境变量，以及如何检测你的 smolagent。',ht,E,ws='<strong>请注意：</strong> 如果你正在使用 LlamaIndex 或 LangGraph，你可以在<a href="https://langfuse.com/docs/integrations/llama-index/workflows" rel="nofollow">这里</a>和<a href="https://langfuse.com/docs/integrations/langchain/example-python-langgraph" rel="nofollow">这里</a>找到检测它们的文档。',Qt,F,cs="首先，让我们配置正确的环境变量，以设置到 Langfuse OpenTelemetry 端点的连接。",Bt,Z,kt,S,js="我们还需要配置我们的 Hugging Face token 用于推理调用。",Nt,v,Et,$,Vs="接下来，我们可以为我们配置的 OpenTelemetry 设置一个 tracer-provider。",Ft,G,Zt,Y,St,_,gs="这里有一个来自 smolagents 的简单 CodeAgent，用于计算 <code>1+1</code>。我们运行它来确认检测是否正常工作。如果一切设置正确，你将在你的可观测性仪表板中看到日志/跨度（spans）。",vt,x,$t,A,Is='检查你的 <a href="https://cloud.langfuse.com" rel="nofollow">Langfuse Traces Dashboard</a>（或你选择的可观测性工具）以确认跨度（spans）和日志已被记录。',Gt,W,ds="Langfuse 中的示例截图：",Yt,L,bs='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/first-example-trace.png" alt="Example trace in Langfuse"/>',_t,O,fs='<em><a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/1b94d6888258e0998329cdb72a371155?timestamp=2025-03-10T11%3A59%3A41.743Z" rel="nofollow">追踪链接</a></em>',xt,H,At,X,Rs="既然你已经确认你的检测工作正常，让我们尝试一个更复杂的查询，这样我们就可以看到高级指标（token 使用量、延迟、成本等）是如何被追踪的。",Wt,z,Lt,q,Ot,D,hs="大多数可观测性工具会记录一个<strong>追踪（trace）</strong>，其中包含<strong>跨度（spans）</strong>，每个跨度代表你的智能体逻辑的一个步骤。在这里，追踪包含了整体的智能体运行以及用于以下内容的子跨度：",Ht,P,Qs="<li>工具调用 (DuckDuckGoSearchTool)</li> <li>LLM 调用 (InferenceClientModel)</li>",Xt,K,Bs="你可以检查这些跨度，以精确地了解时间花在哪里、使用了多少 token 等等：",zt,ll,ks="Langfuse 中的追踪树：",qt,tl,Ns='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/trace-tree.png" alt="Trace tree in Langfuse"/>',Dt,el,Es='<em><a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/1ac33b89ffd5e75d4265b62900c348ed?timestamp=2025-03-07T13%3A45%3A09.149Z&amp;display=preview" rel="nofollow">前往追踪（trace）的链接</a></em>',Pt,sl,Kt,nl,Fs="在上一节中，我们了解了在线评估和离线评估的区别。现在，我们将了解如何在生产环境中监控你的智能体并实时评估它。",le,al,te,Ul,Zs="<li><strong>成本</strong> — smolagents 检测会捕获 token 使用量，你可以通过为每个 token 分配价格将其转换为近似成本。</li> <li><strong>延迟</strong> — 观察完成每个步骤或整个运行所需的时间。</li> <li><strong>用户反馈</strong> — 用户可以提供直接反馈（点赞/点踩）来帮助优化或纠正智能体。</li> <li><strong>LLM 作为评判者</strong> — 使用一个单独的 LLM 来近乎实时地评估你的智能体的输出（例如，检查毒性或正确性）。</li>",ee,Ml,Ss="下面，我们展示这些指标的示例。",se,Jl,ne,Tl,vs="下面是一个显示 <code>Qwen2.5-Coder-32B-Instruct</code> 调用使用情况的截图。这对于查看成本高昂的步骤并优化你的智能体很有用。",ae,pl,$s='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/smolagents-costs.png" alt="Costs"/>',Ue,il,Gs='<em><a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/1ac33b89ffd5e75d4265b62900c348ed?timestamp=2025-03-07T13%3A45%3A09.149Z&amp;display=preview" rel="nofollow">前往追踪（trace）的链接</a></em>',Me,ol,Je,Cl,Ys="我们还可以看到完成每个步骤所需的时间。在下面的示例中，整个对话花费了 32 秒，你可以按步骤分解。这有助于你识别瓶颈并优化你的智能体。",Te,yl,_s='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/smolagents-latency.png" alt="Latency"/>',pe,ml,xs='<em><a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/1ac33b89ffd5e75d4265b62900c348ed?timestamp=2025-03-07T13%3A45%3A09.149Z&amp;display=preview" rel="nofollow">前往追踪（trace）的链接</a></em>',ie,rl,oe,ul,As="你还可以通过在跨度（spans）上设置附加属性——例如用户 ID、会话 ID 或标签。例如，smolagents 检测使用 OpenTelemetry 来附加诸如 <code>langfuse.user.id</code> 或自定义标签之类的属性。",Ce,wl,ye,cl,Ws='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/smolagents-attributes.png" alt="Enhancing agent runs with additional metrics"/>',me,jl,re,Vl,Ls='如果你的智能体嵌入到用户界面中，你可以记录直接的用户反馈（例如聊天界面中的点赞/点踩）。下面是使用 <a href="https://gradio.app/" rel="nofollow">Gradio</a> 嵌入带有简单反馈机制的聊天示例。',ue,gl,Os="在下面的代码片段中，当用户发送聊天消息时，我们捕获 OpenTelemetry 追踪 ID。如果用户喜欢/不喜欢上一个答案，我们将评分附加到该追踪上。",we,Il,ce,dl,Hs="然后，用户反馈会被捕获到你的可观测性工具中：",je,bl,Xs='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/user-feedback-gradio.png" alt="User feedback is being captured in Langfuse"/>',Ve,fl,ge,Rl,zs="LLM 作为评判者（LLM-as-a-Judge）是另一种自动评估你的智能体输出的方法。你可以设置一个单独的 LLM 调用来衡量输出的正确性、毒性、风格或你关心的任何其他标准。",Ie,hl,qs="<strong>工作流程</strong>：",de,Ql,Ds="<li>你定义一个<strong>评估模板</strong>，例如，“检查文本是否有毒。”</li> <li>每次你的智能体生成输出时，你将该输出连同模板一起传递给你的“评判者” LLM。</li> <li>评判者 LLM 会返回一个评分或标签，你将其记录到你的可观测性工具中。</li>",be,Bl,Ps="来自 Langfuse 的示例：",fe,kl,Ks='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/evaluator-template.png" alt="LLM-as-a-Judge Evaluation Template"/> <img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/evaluator.png" alt="LLM-as-a-Judge Evaluator"/>',Re,Nl,he,El,ln="你可以看到这个例子的答案被判定为“无毒”。",Qe,Fl,tn='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/llm-as-a-judge-score.png" alt="LLM-as-a-Judge Evaluation Score"/>',Be,Zl,ke,Sl,en="所有这些指标都可以在仪表板中一起可视化。这使你能够快速查看你的智能体在多个会话中的表现，并帮助你随时间追踪质量指标。",Ne,vl,sn='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/langfuse-dashboard.png" alt="Observability metrics overview"/>',Ee,$l,Fe,Gl,nn="在线评估对于实时反馈至关重要，但你还需要<strong>离线评估</strong>——在开发之前或期间进行系统性检查。这有助于在将更改推送到生产环境之前维护质量和可靠性。",Ze,Yl,Se,_l,an="在离线评估中，你通常：",ve,xl,Un="<li>拥有一个基准数据集（包含提示和预期输出对）</li> <li>在该数据集上运行你的智能体</li> <li>将输出与预期结果进行比较，或使用额外的评分机制</li>",$e,Al,Mn='下面，我们使用 <a href="https://huggingface.co/datasets/gsm8k" rel="nofollow">GSM8K 数据集</a> 来演示这种方法，该数据集包含数学问题和解决方案。',Ge,Wl,Ye,Ll,Jn="接下来，我们在 Langfuse 中创建一个数据集实体来追踪运行。然后，我们将数据集中的每个项目添加到系统中。（如果你不使用 Langfuse，你可以简单地将这些存储在你自己的数据库或本地文件中进行分析。）",_e,Ol,xe,Hl,Ae,Xl,Tn='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/example-dataset.png" alt="Dataset items in Langfuse"/>',We,zl,Le,ql,pn="我们定义一个辅助函数 <code>run_smolagent()</code>，它：",Oe,Dl,on="<li>启动一个 OpenTelemetry 跨度（span）</li> <li>在提示上运行我们的智能体</li> <li>在 Langfuse 中记录追踪 ID</li>",He,Pl,Cn="然后，我们遍历每个数据集项目，运行智能体，并将追踪链接到数据集项目。如果需要，我们还可以附加一个快速评估分数。",Xe,Kl,ze,lt,qe,tt,yn="你可以用不同的配置重复这个过程：",De,et,mn="<li>模型 (OpenAI GPT, 本地 LLM 等)</li> <li>工具 (使用搜索 vs. 不使用搜索)</li> <li>提示 (不同的系统消息)</li>",Pe,st,rn="然后在你的可观测性工具中并排比较它们：",Ke,nt,un='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/dataset_runs.png" alt="Dataset run overview"/> <img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/dataset-run-comparison.png" alt="Dataset run comparison"/>',ls,at,ts,Ut,wn="在这个 notebook 中，我们介绍了如何：",es,Mt,cn="<li><strong>设置可观测性</strong> 使用 smolagents + OpenTelemetry 导出器</li> <li><strong>检查检测</strong> 通过运行一个简单的智能体</li> <li><strong>捕获详细指标</strong> (成本、延迟等) 通过可观测性工具</li> <li><strong>收集用户反馈</strong> 通过 Gradio 界面</li> <li><strong>使用 LLM 作为评判者</strong> 自动评估输出</li> <li><strong>执行离线评估</strong> 使用基准数据集</li>",ss,Jt,jn="🤗 编代码愉快！",ns,Tt,as,it,Us;return c=new Qn({props:{chapter:2,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/#fileId=https://huggingface.co/agents-course/notebooks/blob/main/bonus-unit2/monitoring-and-evaluating-agents.ipynb"}]}}),j=new m({props:{title:"附加单元 2：AI 智能体(AI Agent)的可观测性与评估",local:"附加单元-2ai-智能体ai-agent的可观测性与评估",headingTag:"h1"}}),d=new m({props:{title:"练习先决条件 🏗️",local:"练习先决条件-",headingTag:"h2"}}),h=new m({props:{title:"步骤 0：安装所需的库",local:"步骤-0安装所需的库",headingTag:"h2"}}),B=new r({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMCdzbW9sYWdlbnRzJTVCdGVsZW1ldHJ5JTVEJyUwQSUyNXBpcCUyMGluc3RhbGwlMjBvcGVudGVsZW1ldHJ5LXNkayUyMG9wZW50ZWxlbWV0cnktZXhwb3J0ZXItb3RscCUyMG9wZW5pbmZlcmVuY2UtaW5zdHJ1bWVudGF0aW9uLXNtb2xhZ2VudHMlMEElMjVwaXAlMjBpbnN0YWxsJTIwbGFuZ2Z1c2UlMjBkYXRhc2V0cyUyMCdzbW9sYWdlbnRzJTVCZ3JhZGlvJTVEJw==",highlighted:`%pip install <span class="hljs-string">&#x27;smolagents[telemetry]&#x27;</span>
%pip install opentelemetry-sdk opentelemetry-exporter-otlp openinference-instrumentation-smolagents
%pip install langfuse datasets <span class="hljs-string">&#x27;smolagents[gradio]&#x27;</span>`,wrap:!1}}),k=new m({props:{title:"步骤 1：检测你的智能体",local:"步骤-1检测你的智能体",headingTag:"h2"}}),Z=new r({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjBiYXNlNjQlMEElMEElMjMlMjAlRTQlQkIlOEUlMjBodHRwcyUzQSUyRiUyRmNsb3VkLmxhbmdmdXNlLmNvbSUyMCVFOCU4RSVCNyVFNSU4RiU5NiVFNCVCRCVBMCVFOCU4NyVBQSVFNSVCNyVCMSVFNyU5QSU4NCVFNSVBRiU4NiVFOSU5MiVBNSUwQUxBTkdGVVNFX1BVQkxJQ19LRVklMjAlM0QlMjAlMjJway1sZi0uLi4lMjIlMEFMQU5HRlVTRV9TRUNSRVRfS0VZJTIwJTNEJTIwJTIyc2stbGYtLi4uJTIyJTBBb3MuZW52aXJvbiU1QiUyMkxBTkdGVVNFX1BVQkxJQ19LRVklMjIlNUQlMjAlM0QlMjBMQU5HRlVTRV9QVUJMSUNfS0VZJTBBb3MuZW52aXJvbiU1QiUyMkxBTkdGVVNFX1NFQ1JFVF9LRVklMjIlNUQlMjAlM0QlMjBMQU5HRlVTRV9TRUNSRVRfS0VZJTBBb3MuZW52aXJvbiU1QiUyMkxBTkdGVVNFX0hPU1QlMjIlNUQlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmNsb3VkLmxhbmdmdXNlLmNvbSUyMiUyMCUyMCUyMyUyMCVGMCU5RiU4NyVBQSVGMCU5RiU4NyVCQSUyMCVFNiVBQyVBNyVFNyU5QiU5RiVFNSU4QyVCQSVFNSU5RiU5RiVFNyVBNCVCQSVFNCVCRSU4QiUwQSUyMyUyMG9zLmVudmlyb24lNUIlMjJMQU5HRlVTRV9IT1NUJTIyJTVEJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZ1cy5jbG91ZC5sYW5nZnVzZS5jb20lMjIlMjAlMjAlMjMlMjAlRjAlOUYlODclQkElRjAlOUYlODclQjglMjAlRTclQkUlOEUlRTUlOUIlQkQlRTUlOEMlQkElRTUlOUYlOUYlRTclQTQlQkElRTQlQkUlOEIlMEElMEFMQU5HRlVTRV9BVVRIJTIwJTNEJTIwYmFzZTY0LmI2NGVuY29kZSglMEElMjAlMjAlMjAlMjBmJTIyJTdCTEFOR0ZVU0VfUFVCTElDX0tFWSU3RCUzQSU3QkxBTkdGVVNFX1NFQ1JFVF9LRVklN0QlMjIuZW5jb2RlKCklMEEpLmRlY29kZSgpJTBBJTBBb3MuZW52aXJvbiU1QiUyMk9URUxfRVhQT1JURVJfT1RMUF9FTkRQT0lOVCUyMiU1RCUyMCUzRCUyMG9zLmVudmlyb24uZ2V0KCUyMkxBTkdGVVNFX0hPU1QlMjIpJTIwJTJCJTIwJTIyJTJGYXBpJTJGcHVibGljJTJGb3RlbCUyMiUwQW9zLmVudmlyb24lNUIlMjJPVEVMX0VYUE9SVEVSX09UTFBfSEVBREVSUyUyMiU1RCUyMCUzRCUyMGYlMjJBdXRob3JpemF0aW9uJTNEQmFzaWMlMjAlN0JMQU5HRlVTRV9BVVRIJTdEJTIy",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> base64

<span class="hljs-comment"># 从 https://cloud.langfuse.com 获取你自己的密钥</span>
LANGFUSE_PUBLIC_KEY = <span class="hljs-string">&quot;pk-lf-...&quot;</span>
LANGFUSE_SECRET_KEY = <span class="hljs-string">&quot;sk-lf-...&quot;</span>
os.environ[<span class="hljs-string">&quot;LANGFUSE_PUBLIC_KEY&quot;</span>] = LANGFUSE_PUBLIC_KEY
os.environ[<span class="hljs-string">&quot;LANGFUSE_SECRET_KEY&quot;</span>] = LANGFUSE_SECRET_KEY
os.environ[<span class="hljs-string">&quot;LANGFUSE_HOST&quot;</span>] = <span class="hljs-string">&quot;https://cloud.langfuse.com&quot;</span>  <span class="hljs-comment"># 🇪🇺 欧盟区域示例</span>
<span class="hljs-comment"># os.environ[&quot;LANGFUSE_HOST&quot;] = &quot;https://us.cloud.langfuse.com&quot;  # 🇺🇸 美国区域示例</span>

LANGFUSE_AUTH = base64.b64encode(
    <span class="hljs-string">f&quot;<span class="hljs-subst">{LANGFUSE_PUBLIC_KEY}</span>:<span class="hljs-subst">{LANGFUSE_SECRET_KEY}</span>&quot;</span>.encode()
).decode()

os.environ[<span class="hljs-string">&quot;OTEL_EXPORTER_OTLP_ENDPOINT&quot;</span>] = os.environ.get(<span class="hljs-string">&quot;LANGFUSE_HOST&quot;</span>) + <span class="hljs-string">&quot;/api/public/otel&quot;</span>
os.environ[<span class="hljs-string">&quot;OTEL_EXPORTER_OTLP_HEADERS&quot;</span>] = <span class="hljs-string">f&quot;Authorization=Basic <span class="hljs-subst">{LANGFUSE_AUTH}</span>&quot;</span>`,wrap:!1}}),v=new r({props:{code:"JTIzJTIwJUU1JUIwJTg2JUU0JUJEJUEwJUU3JTlBJTg0JTIwSHVnZ2luZyUyMEZhY2UlMjAlRTUlOTIlOEMlRTUlODUlQjYlRTQlQkIlOTYlMjB0b2tlbiVFNiU4OCU5NiVFOCU4MCU4NSVFNSVBRiU4NiVFOSU5MiVBNSVFOCVBRSVCRSVFNyVCRCVBRSVFNCVCOCVCQSVFNyU4RSVBRiVFNSVBMiU4MyVFNSU4RiU5OCVFOSU4NyU4RiUwQW9zLmVudmlyb24lNUIlMjJIRl9UT0tFTiUyMiU1RCUyMCUzRCUyMCUyMmhmXy4uLiUyMg==",highlighted:`<span class="hljs-comment"># 将你的 Hugging Face 和其他 token或者密钥设置为环境变量</span>
os.environ[<span class="hljs-string">&quot;HF_TOKEN&quot;</span>] = <span class="hljs-string">&quot;hf_...&quot;</span>`,wrap:!1}}),G=new r({props:{code:"ZnJvbSUyMG9wZW50ZWxlbWV0cnkuc2RrLnRyYWNlJTIwaW1wb3J0JTIwVHJhY2VyUHJvdmlkZXIlMEFmcm9tJTIwb3BlbmluZmVyZW5jZS5pbnN0cnVtZW50YXRpb24uc21vbGFnZW50cyUyMGltcG9ydCUyMFNtb2xhZ2VudHNJbnN0cnVtZW50b3IlMEFmcm9tJTIwb3BlbnRlbGVtZXRyeS5leHBvcnRlci5vdGxwLnByb3RvLmh0dHAudHJhY2VfZXhwb3J0ZXIlMjBpbXBvcnQlMjBPVExQU3BhbkV4cG9ydGVyJTBBZnJvbSUyMG9wZW50ZWxlbWV0cnkuc2RrLnRyYWNlLmV4cG9ydCUyMGltcG9ydCUyMFNpbXBsZVNwYW5Qcm9jZXNzb3IlMEElMEElMjMlMjAlRTQlQjglQkElMjBPcGVuVGVsZW1ldHJ5JTIwJUU1JTg4JTlCJUU1JUJCJUJBJUU0JUI4JTgwJUU0JUI4JUFBJTIwVHJhY2VyUHJvdmlkZXIlMEF0cmFjZV9wcm92aWRlciUyMCUzRCUyMFRyYWNlclByb3ZpZGVyKCklMEElMEElMjMlMjAlRTYlQjclQkIlRTUlOEElQTAlRTQlQjglODAlRTQlQjglQUElRTUlQjglQTYlRTYlOUMlODklMjBPVExQU3BhbkV4cG9ydGVyJTIwJUU3JTlBJTg0JTIwU2ltcGxlU3BhblByb2Nlc3NvciUyMCVFNiU5RCVBNSVFNSU4RiU5MSVFOSU4MCU4MSVFOCVCRiVCRCVFOCVCOCVBQSUwQXRyYWNlX3Byb3ZpZGVyLmFkZF9zcGFuX3Byb2Nlc3NvcihTaW1wbGVTcGFuUHJvY2Vzc29yKE9UTFBTcGFuRXhwb3J0ZXIoKSkpJTBBJTBBJTIzJTIwJUU4JUFFJUJFJUU3JUJEJUFFJUU1JTg1JUE4JUU1JUIxJTgwJUU5JUJCJTk4JUU4JUFFJUE0JTIwdHJhY2VyJTIwcHJvdmlkZXIlMEFmcm9tJTIwb3BlbnRlbGVtZXRyeSUyMGltcG9ydCUyMHRyYWNlJTBBdHJhY2Uuc2V0X3RyYWNlcl9wcm92aWRlcih0cmFjZV9wcm92aWRlciklMEF0cmFjZXIlMjAlM0QlMjB0cmFjZS5nZXRfdHJhY2VyKF9fbmFtZV9fKSUwQSUwQSUyMyUyMCVFNCVCRCVCRiVFNyU5NCVBOCVFOSU4NSU4RCVFNyVCRCVBRSVFNyU5QSU4NCUyMHByb3ZpZGVyJTIwJUU2JUEzJTgwJUU2JUI1JThCJTIwc21vbGFnZW50cyUwQVNtb2xhZ2VudHNJbnN0cnVtZW50b3IoKS5pbnN0cnVtZW50KHRyYWNlcl9wcm92aWRlciUzRHRyYWNlX3Byb3ZpZGVyKSUwQQ==",highlighted:`<span class="hljs-keyword">from</span> opentelemetry.sdk.trace <span class="hljs-keyword">import</span> TracerProvider
<span class="hljs-keyword">from</span> openinference.instrumentation.smolagents <span class="hljs-keyword">import</span> SmolagentsInstrumentor
<span class="hljs-keyword">from</span> opentelemetry.exporter.otlp.proto.http.trace_exporter <span class="hljs-keyword">import</span> OTLPSpanExporter
<span class="hljs-keyword">from</span> opentelemetry.sdk.trace.export <span class="hljs-keyword">import</span> SimpleSpanProcessor

<span class="hljs-comment"># 为 OpenTelemetry 创建一个 TracerProvider</span>
trace_provider = TracerProvider()

<span class="hljs-comment"># 添加一个带有 OTLPSpanExporter 的 SimpleSpanProcessor 来发送追踪</span>
trace_provider.add_span_processor(SimpleSpanProcessor(OTLPSpanExporter()))

<span class="hljs-comment"># 设置全局默认 tracer provider</span>
<span class="hljs-keyword">from</span> opentelemetry <span class="hljs-keyword">import</span> trace
trace.set_tracer_provider(trace_provider)
tracer = trace.get_tracer(__name__)

<span class="hljs-comment"># 使用配置的 provider 检测 smolagents</span>
SmolagentsInstrumentor().instrument(tracer_provider=trace_provider)
`,wrap:!1}}),Y=new m({props:{title:"步骤 2：测试你的检测",local:"步骤-2测试你的检测",headingTag:"h2"}}),x=new r({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUwQSUwQSUyMyUyMCVFNSU4OCU5QiVFNSVCQiVCQSVFNCVCOCU4MCVFNCVCOCVBQSVFNyVBRSU4MCVFNSU4RCU5NSVFNyU5QSU4NCVFNiU5OSVCQSVFOCU4MyVCRCVFNCVCRCU5MyVFNiU5RCVBNSVFNiVCNSU4QiVFOCVBRiU5NSVFNiVBMyU4MCVFNiVCNSU4QiUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpJTBBKSUwQSUwQWFnZW50LnJ1biglMjIxJTJCMSUzRCUyMik=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent

<span class="hljs-comment"># 创建一个简单的智能体来测试检测</span>
agent = CodeAgent(
    tools=[],
    model=InferenceClientModel()
)

agent.run(<span class="hljs-string">&quot;1+1=&quot;</span>)`,wrap:!1}}),H=new m({props:{title:"步骤 3：观测和评估更复杂的AI智能体",local:"步骤-3观测和评估更复杂的ai智能体",headingTag:"h2"}}),z=new r({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjAoQ29kZUFnZW50JTJDJTIwRHVja0R1Y2tHb1NlYXJjaFRvb2wlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCklMEElMEFzZWFyY2hfdG9vbCUyMCUzRCUyMER1Y2tEdWNrR29TZWFyY2hUb29sKCklMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1QnNlYXJjaF90b29sJTVEJTJDJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpKSUwQSUwQWFnZW50LnJ1biglMjJIb3clMjBtYW55JTIwUnViaWsncyUyMEN1YmVzJTIwY291bGQlMjB5b3UlMjBmaXQlMjBpbnNpZGUlMjB0aGUlMjBOb3RyZSUyMERhbWUlMjBDYXRoZWRyYWwlM0YlMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, DuckDuckGoSearchTool, InferenceClientModel)

search_tool = DuckDuckGoSearchTool()
agent = CodeAgent(tools=[search_tool], model=InferenceClientModel())

agent.run(<span class="hljs-string">&quot;How many Rubik&#x27;s Cubes could you fit inside the Notre Dame Cathedral?&quot;</span>)`,wrap:!1}}),q=new m({props:{title:"追踪结构",local:"追踪结构",headingTag:"h3"}}),sl=new m({props:{title:"在线评估",local:"在线评估",headingTag:"h2"}}),al=new m({props:{title:"生产环境中要追踪的常见指标",local:"生产环境中要追踪的常见指标",headingTag:"h3"}}),Jl=new m({props:{title:"1. 成本",local:"1-成本",headingTag:"h4"}}),ol=new m({props:{title:"2. 延迟",local:"2-延迟",headingTag:"h4"}}),rl=new m({props:{title:"3. 附加属性",local:"3-附加属性",headingTag:"h4"}}),wl=new r({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjAoQ29kZUFnZW50JTJDJTIwRHVja0R1Y2tHb1NlYXJjaFRvb2wlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCklMEFmcm9tJTIwb3BlbnRlbGVtZXRyeSUyMGltcG9ydCUyMHRyYWNlJTBBJTBBc2VhcmNoX3Rvb2wlMjAlM0QlMjBEdWNrRHVja0dvU2VhcmNoVG9vbCgpJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUJzZWFyY2hfdG9vbCU1RCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNESW5mZXJlbmNlQ2xpZW50TW9kZWwoKSUwQSklMEElMEF3aXRoJTIwdHJhY2VyLnN0YXJ0X2FzX2N1cnJlbnRfc3BhbiglMjJTbW9sYWdlbnQtVHJhY2UlMjIpJTIwYXMlMjBzcGFuJTNBJTBBJTIwJTIwJTIwJTIwc3Bhbi5zZXRfYXR0cmlidXRlKCUyMmxhbmdmdXNlLnVzZXIuaWQlMjIlMkMlMjAlMjJzbW9sYWdlbnQtdXNlci0xMjMlMjIpJTBBJTIwJTIwJTIwJTIwc3Bhbi5zZXRfYXR0cmlidXRlKCUyMmxhbmdmdXNlLnNlc3Npb24uaWQlMjIlMkMlMjAlMjJzbW9sYWdlbnQtc2Vzc2lvbi0xMjM0NTY3ODklMjIpJTBBJTIwJTIwJTIwJTIwc3Bhbi5zZXRfYXR0cmlidXRlKCUyMmxhbmdmdXNlLnRhZ3MlMjIlMkMlMjAlNUIlMjJjaXR5LXF1ZXN0aW9uJTIyJTJDJTIwJTIydGVzdGluZy1hZ2VudHMlMjIlNUQpJTBBJTBBJTIwJTIwJTIwJTIwYWdlbnQucnVuKCUyMldoYXQlMjBpcyUyMHRoZSUyMGNhcGl0YWwlMjBvZiUyMEdlcm1hbnklM0YlMjIpJTBB",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, DuckDuckGoSearchTool, InferenceClientModel)
<span class="hljs-keyword">from</span> opentelemetry <span class="hljs-keyword">import</span> trace

search_tool = DuckDuckGoSearchTool()
agent = CodeAgent(
    tools=[search_tool],
    model=InferenceClientModel()
)

<span class="hljs-keyword">with</span> tracer.start_as_current_span(<span class="hljs-string">&quot;Smolagent-Trace&quot;</span>) <span class="hljs-keyword">as</span> span:
    span.set_attribute(<span class="hljs-string">&quot;langfuse.user.id&quot;</span>, <span class="hljs-string">&quot;smolagent-user-123&quot;</span>)
    span.set_attribute(<span class="hljs-string">&quot;langfuse.session.id&quot;</span>, <span class="hljs-string">&quot;smolagent-session-123456789&quot;</span>)
    span.set_attribute(<span class="hljs-string">&quot;langfuse.tags&quot;</span>, [<span class="hljs-string">&quot;city-question&quot;</span>, <span class="hljs-string">&quot;testing-agents&quot;</span>])

    agent.run(<span class="hljs-string">&quot;What is the capital of Germany?&quot;</span>)
`,wrap:!1}}),jl=new m({props:{title:"4. 用户反馈",local:"4-用户反馈",headingTag:"h4"}}),Il=new r({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">from</span> opentelemetry.trace <span class="hljs-keyword">import</span> format_trace_id
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, InferenceClientModel)
<span class="hljs-keyword">from</span> langfuse <span class="hljs-keyword">import</span> Langfuse

langfuse = Langfuse()
model = InferenceClientModel()
agent = CodeAgent(tools=[], model=model, add_base_tools=<span class="hljs-literal">True</span>)

formatted_trace_id = <span class="hljs-literal">None</span>  <span class="hljs-comment"># 为演示目的，我们将在全局存储当前的 trace_id</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">respond</span>(<span class="hljs-params">prompt, history</span>):
    <span class="hljs-keyword">with</span> trace.get_tracer(__name__).start_as_current_span(<span class="hljs-string">&quot;Smolagent-Trace&quot;</span>) <span class="hljs-keyword">as</span> span:
        output = agent.run(prompt)

        current_span = trace.get_current_span()
        span_context = current_span.get_span_context()
        trace_id = span_context.trace_id
        <span class="hljs-keyword">global</span> formatted_trace_id
        formatted_trace_id = <span class="hljs-built_in">str</span>(format_trace_id(trace_id))
        langfuse.trace(<span class="hljs-built_in">id</span>=formatted_trace_id, <span class="hljs-built_in">input</span>=prompt, output=output)

    history.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-built_in">str</span>(output)})
    <span class="hljs-keyword">return</span> history

<span class="hljs-keyword">def</span> <span class="hljs-title function_">handle_like</span>(<span class="hljs-params">data: gr.LikeData</span>):
    <span class="hljs-comment"># 作为演示，我们将用户反馈映射为 1 (喜欢) 或 0 (不喜欢)</span>
    <span class="hljs-keyword">if</span> data.liked:
        langfuse.score(
            value=<span class="hljs-number">1</span>,
            name=<span class="hljs-string">&quot;user-feedback&quot;</span>,
            trace_id=formatted_trace_id
        )
    <span class="hljs-keyword">else</span>:
        langfuse.score(
            value=<span class="hljs-number">0</span>,
            name=<span class="hljs-string">&quot;user-feedback&quot;</span>,
            trace_id=formatted_trace_id
        )

<span class="hljs-keyword">with</span> gr.Blocks() <span class="hljs-keyword">as</span> demo:
    chatbot = gr.Chatbot(label=<span class="hljs-string">&quot;Chat&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;messages&quot;</span>)
    prompt_box = gr.Textbox(placeholder=<span class="hljs-string">&quot;Type your message...&quot;</span>, label=<span class="hljs-string">&quot;Your message&quot;</span>)

    <span class="hljs-comment"># 当用户在提示框上按 &#x27;Enter&#x27; 时，我们运行 &#x27;respond&#x27;</span>
    prompt_box.submit(
        fn=respond,
        inputs=[prompt_box, chatbot],
        outputs=chatbot
    )

    <span class="hljs-comment"># 当用户点击消息上的 &#x27;喜欢&#x27; 按钮时，我们运行 &#x27;handle_like&#x27;</span>
    chatbot.like(handle_like, <span class="hljs-literal">None</span>, <span class="hljs-literal">None</span>)

demo.launch()
`,wrap:!1}}),fl=new m({props:{title:"5. LLM 作为评判者",local:"5-llm-作为评判者",headingTag:"h4"}}),Nl=new r({props:{code:"JTIzJTIwJUU3JUE0JUJBJUU0JUJFJThCJUVGJUJDJTlBJUU2JUEzJTgwJUU2JTlGJUE1JUU2JTk5JUJBJUU4JTgzJUJEJUU0JUJEJTkzJUU3JTlBJTg0JUU4JUJFJTkzJUU1JTg3JUJBJUU2JTk4JUFGJUU1JTkwJUE2JUU2JTlDJTg5JUU2JUFGJTkyJUUzJTgwJTgyJTBBZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjAoQ29kZUFnZW50JTJDJTIwRHVja0R1Y2tHb1NlYXJjaFRvb2wlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCklMEElMEFzZWFyY2hfdG9vbCUyMCUzRCUyMER1Y2tEdWNrR29TZWFyY2hUb29sKCklMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1QnNlYXJjaF90b29sJTVEJTJDJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpKSUwQSUwQWFnZW50LnJ1biglMjJDYW4lMjBlYXRpbmclMjBjYXJyb3RzJTIwaW1wcm92ZSUyMHlvdXIlMjB2aXNpb24lM0YlMjIpJTBB",highlighted:`<span class="hljs-comment"># 示例：检查智能体的输出是否有毒。</span>
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, DuckDuckGoSearchTool, InferenceClientModel)

search_tool = DuckDuckGoSearchTool()
agent = CodeAgent(tools=[search_tool], model=InferenceClientModel())

agent.run(<span class="hljs-string">&quot;Can eating carrots improve your vision?&quot;</span>)
`,wrap:!1}}),Zl=new m({props:{title:"6. 可观测性指标概览",local:"6-可观测性指标概览",headingTag:"h4"}}),$l=new m({props:{title:"离线评估",local:"离线评估",headingTag:"h2"}}),Yl=new m({props:{title:"数据集评估",local:"数据集评估",headingTag:"h3"}}),Wl=new r({props:{code:"aW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQSUyMyUyMCVFNCVCQiU4RSUyMEh1Z2dpbmclMjBGYWNlJTIwJUU4JThFJUI3JUU1JThGJTk2JTIwR1NNOEslMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMm9wZW5haSUyRmdzbThrJTIyJTJDJTIwJ21haW4nJTJDJTIwc3BsaXQlM0QndHJhaW4nKSUwQWRmJTIwJTNEJTIwcGQuRGF0YUZyYW1lKGRhdGFzZXQpJTBBcHJpbnQoJTIyR1NNOEslMjAlRTYlOTUlQjAlRTYlOEQlQUUlRTklOUIlODYlRTclOUElODQlRTUlODklOEQlRTUlODclQTAlRTglQTElOEMlRUYlQkMlOUElMjIpJTBBcHJpbnQoZGYuaGVhZCgpKSUwQQ==",highlighted:`<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># 从 Hugging Face 获取 GSM8K</span>
dataset = load_dataset(<span class="hljs-string">&quot;openai/gsm8k&quot;</span>, <span class="hljs-string">&#x27;main&#x27;</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>)
df = pd.DataFrame(dataset)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;GSM8K 数据集的前几行：&quot;</span>)
<span class="hljs-built_in">print</span>(df.head())
`,wrap:!1}}),Ol=new r({props:{code:"ZnJvbSUyMGxhbmdmdXNlJTIwaW1wb3J0JTIwTGFuZ2Z1c2UlMEFsYW5nZnVzZSUyMCUzRCUyMExhbmdmdXNlKCklMEElMEFsYW5nZnVzZV9kYXRhc2V0X25hbWUlMjAlM0QlMjAlMjJnc204a19kYXRhc2V0X2h1Z2dpbmdmYWNlJTIyJTBBJTBBJTIzJTIwJUU1JTlDJUE4JTIwTGFuZ2Z1c2UlMjAlRTQlQjglQUQlRTUlODglOUIlRTUlQkIlQkElRTYlOTUlQjAlRTYlOEQlQUUlRTklOUIlODYlMEFsYW5nZnVzZS5jcmVhdGVfZGF0YXNldCglMEElMjAlMjAlMjAlMjBuYW1lJTNEbGFuZ2Z1c2VfZGF0YXNldF9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0QlMjIlRTQlQkIlOEUlMjBIdWdnaW5nZmFjZSUyMCVFNCVCOCU4QSVFNCVCQyVBMCVFNyU5QSU4NCUyMEdTTThLJTIwJUU1JTlGJUJBJUU1JTg3JTg2JUU2JTk1JUIwJUU2JThEJUFFJUU5JTlCJTg2JTIyJTJDJTBBJTIwJTIwJTIwJTIwbWV0YWRhdGElM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJkYXRlJTIyJTNBJTIwJTIyMjAyNS0wMy0xMCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJiZW5jaG1hcmslMjIlMEElMjAlMjAlMjAlMjAlN0QlMEEpJTBB",highlighted:`<span class="hljs-keyword">from</span> langfuse <span class="hljs-keyword">import</span> Langfuse
langfuse = Langfuse()

langfuse_dataset_name = <span class="hljs-string">&quot;gsm8k_dataset_huggingface&quot;</span>

<span class="hljs-comment"># 在 Langfuse 中创建数据集</span>
langfuse.create_dataset(
    name=langfuse_dataset_name,
    description=<span class="hljs-string">&quot;从 Huggingface 上传的 GSM8K 基准数据集&quot;</span>,
    metadata={
        <span class="hljs-string">&quot;date&quot;</span>: <span class="hljs-string">&quot;2025-03-10&quot;</span>,
        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;benchmark&quot;</span>
    }
)
`,wrap:!1}}),Hl=new r({props:{code:"Zm9yJTIwaWR4JTJDJTIwcm93JTIwaW4lMjBkZi5pdGVycm93cygpJTNBJTBBJTIwJTIwJTIwJTIwbGFuZ2Z1c2UuY3JlYXRlX2RhdGFzZXRfaXRlbSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkYXRhc2V0X25hbWUlM0RsYW5nZnVzZV9kYXRhc2V0X25hbWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnB1dCUzRCU3QiUyMnRleHQlMjIlM0ElMjByb3clNUIlMjJxdWVzdGlvbiUyMiU1RCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGV4cGVjdGVkX291dHB1dCUzRCU3QiUyMnRleHQlMjIlM0ElMjByb3clNUIlMjJhbnN3ZXIlMjIlNUQlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZXRhZGF0YSUzRCU3QiUyMnNvdXJjZV9pbmRleCUyMiUzQSUyMGlkeCU3RCUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjBpZiUyMGlkeCUyMCUzRSUzRCUyMDklM0ElMjAlMjMlMjAlRTQlQkIlODUlRTQlQjglOEElRTQlQkMlQTAlRTUlODklOEQlMjAxMCUyMCVFNCVCOCVBQSVFOSVBMSVCOSVFNyU5QiVBRSVFNyU5NCVBOCVFNCVCQSU4RSVFNiVCQyU5NCVFNyVBNCVCQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJyZWFrJTBB",highlighted:`<span class="hljs-keyword">for</span> idx, row <span class="hljs-keyword">in</span> df.iterrows():
    langfuse.create_dataset_item(
        dataset_name=langfuse_dataset_name,
        <span class="hljs-built_in">input</span>={<span class="hljs-string">&quot;text&quot;</span>: row[<span class="hljs-string">&quot;question&quot;</span>]},
        expected_output={<span class="hljs-string">&quot;text&quot;</span>: row[<span class="hljs-string">&quot;answer&quot;</span>]},
        metadata={<span class="hljs-string">&quot;source_index&quot;</span>: idx}
    )
    <span class="hljs-keyword">if</span> idx &gt;= <span class="hljs-number">9</span>: <span class="hljs-comment"># 仅上传前 10 个项目用于演示</span>
        <span class="hljs-keyword">break</span>
`,wrap:!1}}),zl=new m({props:{title:"在数据集上运行智能体",local:"在数据集上运行智能体",headingTag:"h4"}}),Kl=new r({props:{code:"ZnJvbSUyMG9wZW50ZWxlbWV0cnkudHJhY2UlMjBpbXBvcnQlMjBmb3JtYXRfdHJhY2VfaWQlMEFmcm9tJTIwc21vbGFnZW50cyUyMGltcG9ydCUyMChDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMExpdGVMTE1Nb2RlbCklMEElMEElMjMlMjAlRTclQTQlQkElRTQlQkUlOEIlRUYlQkMlOUElRTQlQkQlQkYlRTclOTQlQTglMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyMCVFNiU4OCU5NiUyMExpdGVMTE1Nb2RlbCUyMCVFOCVBRSVCRiVFOSU5NyVBRSUyMG9wZW5haSVFMyU4MCU4MWFudGhyb3BpYyVFMyU4MCU4MWdlbWluaSUyMCVFNyVBRCU4OSVFNiVBOCVBMSVFNSU5RSU4QiVFRiVCQyU5QSUwQW1vZGVsJTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwoKSUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSUwQSklMEElMEFkZWYlMjBydW5fc21vbGFnZW50KHF1ZXN0aW9uKSUzQSUwQSUyMCUyMCUyMCUyMHdpdGglMjB0cmFjZXIuc3RhcnRfYXNfY3VycmVudF9zcGFuKCUyMlNtb2xhZ2VudC1UcmFjZSUyMiklMjBhcyUyMHNwYW4lM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzcGFuLnNldF9hdHRyaWJ1dGUoJTIybGFuZ2Z1c2UudGFnJTIyJTJDJTIwJTIyZGF0YXNldC1ydW4lMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0JTIwJTNEJTIwYWdlbnQucnVuKHF1ZXN0aW9uKSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGN1cnJlbnRfc3BhbiUyMCUzRCUyMHRyYWNlLmdldF9jdXJyZW50X3NwYW4oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwYW5fY29udGV4dCUyMCUzRCUyMGN1cnJlbnRfc3Bhbi5nZXRfc3Bhbl9jb250ZXh0KCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0cmFjZV9pZCUyMCUzRCUyMHNwYW5fY29udGV4dC50cmFjZV9pZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvcm1hdHRlZF90cmFjZV9pZCUyMCUzRCUyMGZvcm1hdF90cmFjZV9pZCh0cmFjZV9pZCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYW5nZnVzZV90cmFjZSUyMCUzRCUyMGxhbmdmdXNlLnRyYWNlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlkJTNEZm9ybWF0dGVkX3RyYWNlX2lkJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5wdXQlM0RxdWVzdGlvbiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dCUzRG91dHB1dCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBsYW5nZnVzZV90cmFjZSUyQyUyMG91dHB1dCUwQQ==",highlighted:`<span class="hljs-keyword">from</span> opentelemetry.trace <span class="hljs-keyword">import</span> format_trace_id
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, InferenceClientModel, LiteLLMModel)

<span class="hljs-comment"># 示例：使用 InferenceClientModel 或 LiteLLMModel 访问 openai、anthropic、gemini 等模型：</span>
model = InferenceClientModel()

agent = CodeAgent(
    tools=[],
    model=model,
    add_base_tools=<span class="hljs-literal">True</span>
)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_smolagent</span>(<span class="hljs-params">question</span>):
    <span class="hljs-keyword">with</span> tracer.start_as_current_span(<span class="hljs-string">&quot;Smolagent-Trace&quot;</span>) <span class="hljs-keyword">as</span> span:
        span.set_attribute(<span class="hljs-string">&quot;langfuse.tag&quot;</span>, <span class="hljs-string">&quot;dataset-run&quot;</span>)
        output = agent.run(question)

        current_span = trace.get_current_span()
        span_context = current_span.get_span_context()
        trace_id = span_context.trace_id
        formatted_trace_id = format_trace_id(trace_id)

        langfuse_trace = langfuse.trace(
            <span class="hljs-built_in">id</span>=formatted_trace_id,
            <span class="hljs-built_in">input</span>=question,
            output=output
        )
    <span class="hljs-keyword">return</span> langfuse_trace, output
`,wrap:!1}}),lt=new r({props:{code:"ZGF0YXNldCUyMCUzRCUyMGxhbmdmdXNlLmdldF9kYXRhc2V0KGxhbmdmdXNlX2RhdGFzZXRfbmFtZSklMEElMEElMjMlMjAlRTklOTIlODglRTUlQUYlQjklRTYlQUYlOEYlRTQlQjglQUElRTYlOTUlQjAlRTYlOEQlQUUlRTklOUIlODYlRTklQTElQjklRTclOUIlQUUlRTglQkYlOTAlRTglQTElOEMlRTYlODglOTElRTQlQkIlQUMlRTclOUElODQlRTYlOTklQkElRTglODMlQkQlRTQlQkQlOTMlRUYlQkMlODglRTQlQjglOEElRTklOUQlQTIlRTklOTklOTAlRTUlODglQjYlRTQlQjglQkElRTUlODklOEQlMjAxMCUyMCVFNCVCOCVBQSVFRiVCQyU4OSUwQWZvciUyMGl0ZW0lMjBpbiUyMGRhdGFzZXQuaXRlbXMlM0ElMEElMjAlMjAlMjAlMjBsYW5nZnVzZV90cmFjZSUyQyUyMG91dHB1dCUyMCUzRCUyMHJ1bl9zbW9sYWdlbnQoaXRlbS5pbnB1dCU1QiUyMnRleHQlMjIlNUQpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwJUU1JUIwJTg2JUU4JUJGJUJEJUU4JUI4JUFBJUU5JTkzJUJFJUU2JThFJUE1JUU1JTg4JUIwJUU2JTk1JUIwJUU2JThEJUFFJUU5JTlCJTg2JUU5JUExJUI5JUU3JTlCJUFFJUU0JUJCJUE1JUU0JUJFJTlCJUU1JTg4JTg2JUU2JTlFJTkwJTBBJTIwJTIwJTIwJTIwaXRlbS5saW5rKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxhbmdmdXNlX3RyYWNlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcnVuX25hbWUlM0QlMjJzbW9sYWdlbnQtbm90ZWJvb2stcnVuLTAxJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcnVuX21ldGFkYXRhJTNEJTdCJTIwJTIybW9kZWwlMjIlM0ElMjBtb2RlbC5tb2RlbF9pZCUyMCU3RCUwQSUyMCUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjAlMjMlMjAlRTUlOEYlQUYlRTklODAlODklRTUlOUMlQjAlRUYlQkMlOEMlRTUlQUQlOTglRTUlODIlQTglRTQlQjglODAlRTQlQjglQUElRTUlQkYlQUIlRTklODAlOUYlRTglQUYlODQlRTQlQkMlQjAlRTUlODglODYlRTYlOTUlQjAlRTclOTQlQTglRTQlQkElOEUlRTYlQkMlOTQlRTclQTQlQkElMEElMjAlMjAlMjAlMjBsYW5nZnVzZV90cmFjZS5zY29yZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBuYW1lJTNEJTIyJTNDZXhhbXBsZV9ldmFsJTNFJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdmFsdWUlM0QxJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29tbWVudCUzRCUyMiVFOCVCRiU5OSVFNiU5OCVBRiVFNCVCOCU4MCVFNiU5RCVBMSVFOCVBRiU4NCVFOCVBRSVCQSUyMiUwQSUyMCUyMCUyMCUyMCklMEElMEElMjMlMjAlRTUlODglQjclRTYlOTYlQjAlRTYlOTUlQjAlRTYlOEQlQUUlRTQlQkIlQTUlRTclQTElQUUlRTQlQkYlOUQlRTYlODklODAlRTYlOUMlODklRTklODElQTUlRTYlQjUlOEIlRTYlOTUlQjAlRTYlOEQlQUUlRTklODMlQkQlRTUlQjclQjIlRTUlOEYlOTElRTklODAlODElMEFsYW5nZnVzZS5mbHVzaCgpJTBB",highlighted:`dataset = langfuse.get_dataset(langfuse_dataset_name)

<span class="hljs-comment"># 针对每个数据集项目运行我们的智能体（上面限制为前 10 个）</span>
<span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> dataset.items:
    langfuse_trace, output = run_smolagent(item.<span class="hljs-built_in">input</span>[<span class="hljs-string">&quot;text&quot;</span>])

    <span class="hljs-comment"># 将追踪链接到数据集项目以供分析</span>
    item.link(
        langfuse_trace,
        run_name=<span class="hljs-string">&quot;smolagent-notebook-run-01&quot;</span>,
        run_metadata={ <span class="hljs-string">&quot;model&quot;</span>: model.model_id }
    )

    <span class="hljs-comment"># 可选地，存储一个快速评估分数用于演示</span>
    langfuse_trace.score(
        name=<span class="hljs-string">&quot;&lt;example_eval&gt;&quot;</span>,
        value=<span class="hljs-number">1</span>,
        comment=<span class="hljs-string">&quot;这是一条评论&quot;</span>
    )

<span class="hljs-comment"># 刷新数据以确保所有遥测数据都已发送</span>
langfuse.flush()
`,wrap:!1}}),at=new m({props:{title:"结语",local:"结语",headingTag:"h2"}}),Tt=new Bn({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/zh-CN/bonus_unit2/monitoring-and-evaluating-agents-notebook.mdx"}}),{c(){u=U("meta"),ot=n(),pt=U("p"),Ct=n(),T(c.$$.fragment),yt=n(),T(j.$$.fragment),mt=n(),w=U("blockquote"),w.innerHTML=Ts,rt=n(),V=U("p"),V.innerHTML=ps,ut=n(),g=U("p"),g.textContent=is,wt=n(),I=U("ul"),I.innerHTML=os,ct=n(),T(d.$$.fragment),jt=n(),b=U("p"),b.textContent=Cs,Vt=n(),f=U("p"),f.innerHTML=ys,gt=n(),R=U("p"),R.innerHTML=ms,It=n(),T(h.$$.fragment),dt=n(),Q=U("p"),Q.textContent=rs,bt=n(),T(B.$$.fragment),ft=n(),T(k.$$.fragment),Rt=n(),N=U("p"),N.innerHTML=us,ht=n(),E=U("p"),E.innerHTML=ws,Qt=n(),F=U("p"),F.textContent=cs,Bt=n(),T(Z.$$.fragment),kt=n(),S=U("p"),S.textContent=js,Nt=n(),T(v.$$.fragment),Et=n(),$=U("p"),$.textContent=Vs,Ft=n(),T(G.$$.fragment),Zt=n(),T(Y.$$.fragment),St=n(),_=U("p"),_.innerHTML=gs,vt=n(),T(x.$$.fragment),$t=n(),A=U("p"),A.innerHTML=Is,Gt=n(),W=U("p"),W.textContent=ds,Yt=n(),L=U("p"),L.innerHTML=bs,_t=n(),O=U("p"),O.innerHTML=fs,xt=n(),T(H.$$.fragment),At=n(),X=U("p"),X.textContent=Rs,Wt=n(),T(z.$$.fragment),Lt=n(),T(q.$$.fragment),Ot=n(),D=U("p"),D.innerHTML=hs,Ht=n(),P=U("ul"),P.innerHTML=Qs,Xt=n(),K=U("p"),K.textContent=Bs,zt=n(),ll=U("p"),ll.textContent=ks,qt=n(),tl=U("p"),tl.innerHTML=Ns,Dt=n(),el=U("p"),el.innerHTML=Es,Pt=n(),T(sl.$$.fragment),Kt=n(),nl=U("p"),nl.textContent=Fs,le=n(),T(al.$$.fragment),te=n(),Ul=U("ol"),Ul.innerHTML=Zs,ee=n(),Ml=U("p"),Ml.textContent=Ss,se=n(),T(Jl.$$.fragment),ne=n(),Tl=U("p"),Tl.innerHTML=vs,ae=n(),pl=U("p"),pl.innerHTML=$s,Ue=n(),il=U("p"),il.innerHTML=Gs,Me=n(),T(ol.$$.fragment),Je=n(),Cl=U("p"),Cl.textContent=Ys,Te=n(),yl=U("p"),yl.innerHTML=_s,pe=n(),ml=U("p"),ml.innerHTML=xs,ie=n(),T(rl.$$.fragment),oe=n(),ul=U("p"),ul.innerHTML=As,Ce=n(),T(wl.$$.fragment),ye=n(),cl=U("p"),cl.innerHTML=Ws,me=n(),T(jl.$$.fragment),re=n(),Vl=U("p"),Vl.innerHTML=Ls,ue=n(),gl=U("p"),gl.textContent=Os,we=n(),T(Il.$$.fragment),ce=n(),dl=U("p"),dl.textContent=Hs,je=n(),bl=U("p"),bl.innerHTML=Xs,Ve=n(),T(fl.$$.fragment),ge=n(),Rl=U("p"),Rl.textContent=zs,Ie=n(),hl=U("p"),hl.innerHTML=qs,de=n(),Ql=U("ol"),Ql.innerHTML=Ds,be=n(),Bl=U("p"),Bl.textContent=Ps,fe=n(),kl=U("p"),kl.innerHTML=Ks,Re=n(),T(Nl.$$.fragment),he=n(),El=U("p"),El.textContent=ln,Qe=n(),Fl=U("p"),Fl.innerHTML=tn,Be=n(),T(Zl.$$.fragment),ke=n(),Sl=U("p"),Sl.textContent=en,Ne=n(),vl=U("p"),vl.innerHTML=sn,Ee=n(),T($l.$$.fragment),Fe=n(),Gl=U("p"),Gl.innerHTML=nn,Ze=n(),T(Yl.$$.fragment),Se=n(),_l=U("p"),_l.textContent=an,ve=n(),xl=U("ol"),xl.innerHTML=Un,$e=n(),Al=U("p"),Al.innerHTML=Mn,Ge=n(),T(Wl.$$.fragment),Ye=n(),Ll=U("p"),Ll.textContent=Jn,_e=n(),T(Ol.$$.fragment),xe=n(),T(Hl.$$.fragment),Ae=n(),Xl=U("p"),Xl.innerHTML=Tn,We=n(),T(zl.$$.fragment),Le=n(),ql=U("p"),ql.innerHTML=pn,Oe=n(),Dl=U("ol"),Dl.innerHTML=on,He=n(),Pl=U("p"),Pl.textContent=Cn,Xe=n(),T(Kl.$$.fragment),ze=n(),T(lt.$$.fragment),qe=n(),tt=U("p"),tt.textContent=yn,De=n(),et=U("ul"),et.innerHTML=mn,Pe=n(),st=U("p"),st.textContent=rn,Ke=n(),nt=U("p"),nt.innerHTML=un,ls=n(),T(at.$$.fragment),ts=n(),Ut=U("p"),Ut.textContent=wn,es=n(),Mt=U("ol"),Mt.innerHTML=cn,ss=n(),Jt=U("p"),Jt.textContent=jn,ns=n(),T(Tt.$$.fragment),as=n(),it=U("p"),this.h()},l(l){const t=Rn("svelte-u9bgzb",document.head);u=M(t,"META",{name:!0,content:!0}),t.forEach(e),ot=a(l),pt=M(l,"P",{}),Vn(pt).forEach(e),Ct=a(l),p(c.$$.fragment,l),yt=a(l),p(j.$$.fragment,l),mt=a(l),w=M(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),J(w)!=="svelte-m8i388"&&(w.innerHTML=Ts),rt=a(l),V=M(l,"P",{"data-svelte-h":!0}),J(V)!=="svelte-1c30g7l"&&(V.innerHTML=ps),ut=a(l),g=M(l,"P",{"data-svelte-h":!0}),J(g)!=="svelte-1uesxvj"&&(g.textContent=is),wt=a(l),I=M(l,"UL",{"data-svelte-h":!0}),J(I)!=="svelte-mz9jkh"&&(I.innerHTML=os),ct=a(l),p(d.$$.fragment,l),jt=a(l),b=M(l,"P",{"data-svelte-h":!0}),J(b)!=="svelte-1fwgexo"&&(b.textContent=Cs),Vt=a(l),f=M(l,"P",{"data-svelte-h":!0}),J(f)!=="svelte-1vr9vc3"&&(f.innerHTML=ys),gt=a(l),R=M(l,"P",{"data-svelte-h":!0}),J(R)!=="svelte-r9pvtq"&&(R.innerHTML=ms),It=a(l),p(h.$$.fragment,l),dt=a(l),Q=M(l,"P",{"data-svelte-h":!0}),J(Q)!=="svelte-zkb5dt"&&(Q.textContent=rs),bt=a(l),p(B.$$.fragment,l),ft=a(l),p(k.$$.fragment,l),Rt=a(l),N=M(l,"P",{"data-svelte-h":!0}),J(N)!=="svelte-p625jc"&&(N.innerHTML=us),ht=a(l),E=M(l,"P",{"data-svelte-h":!0}),J(E)!=="svelte-ucz4lr"&&(E.innerHTML=ws),Qt=a(l),F=M(l,"P",{"data-svelte-h":!0}),J(F)!=="svelte-1oy2tpn"&&(F.textContent=cs),Bt=a(l),p(Z.$$.fragment,l),kt=a(l),S=M(l,"P",{"data-svelte-h":!0}),J(S)!=="svelte-11x9hcs"&&(S.textContent=js),Nt=a(l),p(v.$$.fragment,l),Et=a(l),$=M(l,"P",{"data-svelte-h":!0}),J($)!=="svelte-1yxxfzg"&&($.textContent=Vs),Ft=a(l),p(G.$$.fragment,l),Zt=a(l),p(Y.$$.fragment,l),St=a(l),_=M(l,"P",{"data-svelte-h":!0}),J(_)!=="svelte-n8l4w3"&&(_.innerHTML=gs),vt=a(l),p(x.$$.fragment,l),$t=a(l),A=M(l,"P",{"data-svelte-h":!0}),J(A)!=="svelte-1gvxwiu"&&(A.innerHTML=Is),Gt=a(l),W=M(l,"P",{"data-svelte-h":!0}),J(W)!=="svelte-19bn6vz"&&(W.textContent=ds),Yt=a(l),L=M(l,"P",{"data-svelte-h":!0}),J(L)!=="svelte-1cb993n"&&(L.innerHTML=bs),_t=a(l),O=M(l,"P",{"data-svelte-h":!0}),J(O)!=="svelte-ctgz93"&&(O.innerHTML=fs),xt=a(l),p(H.$$.fragment,l),At=a(l),X=M(l,"P",{"data-svelte-h":!0}),J(X)!=="svelte-1nzh9h2"&&(X.textContent=Rs),Wt=a(l),p(z.$$.fragment,l),Lt=a(l),p(q.$$.fragment,l),Ot=a(l),D=M(l,"P",{"data-svelte-h":!0}),J(D)!=="svelte-qb0ba2"&&(D.innerHTML=hs),Ht=a(l),P=M(l,"UL",{"data-svelte-h":!0}),J(P)!=="svelte-72wkz6"&&(P.innerHTML=Qs),Xt=a(l),K=M(l,"P",{"data-svelte-h":!0}),J(K)!=="svelte-j6apou"&&(K.textContent=Bs),zt=a(l),ll=M(l,"P",{"data-svelte-h":!0}),J(ll)!=="svelte-hh28r2"&&(ll.textContent=ks),qt=a(l),tl=M(l,"P",{"data-svelte-h":!0}),J(tl)!=="svelte-yhkq5w"&&(tl.innerHTML=Ns),Dt=a(l),el=M(l,"P",{"data-svelte-h":!0}),J(el)!=="svelte-1ana1zw"&&(el.innerHTML=Es),Pt=a(l),p(sl.$$.fragment,l),Kt=a(l),nl=M(l,"P",{"data-svelte-h":!0}),J(nl)!=="svelte-193508y"&&(nl.textContent=Fs),le=a(l),p(al.$$.fragment,l),te=a(l),Ul=M(l,"OL",{"data-svelte-h":!0}),J(Ul)!=="svelte-icrnhf"&&(Ul.innerHTML=Zs),ee=a(l),Ml=M(l,"P",{"data-svelte-h":!0}),J(Ml)!=="svelte-14tuos8"&&(Ml.textContent=Ss),se=a(l),p(Jl.$$.fragment,l),ne=a(l),Tl=M(l,"P",{"data-svelte-h":!0}),J(Tl)!=="svelte-1fpyo1s"&&(Tl.innerHTML=vs),ae=a(l),pl=M(l,"P",{"data-svelte-h":!0}),J(pl)!=="svelte-dard47"&&(pl.innerHTML=$s),Ue=a(l),il=M(l,"P",{"data-svelte-h":!0}),J(il)!=="svelte-1ana1zw"&&(il.innerHTML=Gs),Me=a(l),p(ol.$$.fragment,l),Je=a(l),Cl=M(l,"P",{"data-svelte-h":!0}),J(Cl)!=="svelte-rc014l"&&(Cl.textContent=Ys),Te=a(l),yl=M(l,"P",{"data-svelte-h":!0}),J(yl)!=="svelte-1org4pj"&&(yl.innerHTML=_s),pe=a(l),ml=M(l,"P",{"data-svelte-h":!0}),J(ml)!=="svelte-1ana1zw"&&(ml.innerHTML=xs),ie=a(l),p(rl.$$.fragment,l),oe=a(l),ul=M(l,"P",{"data-svelte-h":!0}),J(ul)!=="svelte-1joyolg"&&(ul.innerHTML=As),Ce=a(l),p(wl.$$.fragment,l),ye=a(l),cl=M(l,"P",{"data-svelte-h":!0}),J(cl)!=="svelte-1gx91hu"&&(cl.innerHTML=Ws),me=a(l),p(jl.$$.fragment,l),re=a(l),Vl=M(l,"P",{"data-svelte-h":!0}),J(Vl)!=="svelte-12jailm"&&(Vl.innerHTML=Ls),ue=a(l),gl=M(l,"P",{"data-svelte-h":!0}),J(gl)!=="svelte-w7ysmk"&&(gl.textContent=Os),we=a(l),p(Il.$$.fragment,l),ce=a(l),dl=M(l,"P",{"data-svelte-h":!0}),J(dl)!=="svelte-1fcgnxf"&&(dl.textContent=Hs),je=a(l),bl=M(l,"P",{"data-svelte-h":!0}),J(bl)!=="svelte-e6ive4"&&(bl.innerHTML=Xs),Ve=a(l),p(fl.$$.fragment,l),ge=a(l),Rl=M(l,"P",{"data-svelte-h":!0}),J(Rl)!=="svelte-voo053"&&(Rl.textContent=zs),Ie=a(l),hl=M(l,"P",{"data-svelte-h":!0}),J(hl)!=="svelte-1k98euk"&&(hl.innerHTML=qs),de=a(l),Ql=M(l,"OL",{"data-svelte-h":!0}),J(Ql)!=="svelte-1kzotuw"&&(Ql.innerHTML=Ds),be=a(l),Bl=M(l,"P",{"data-svelte-h":!0}),J(Bl)!=="svelte-xckzqt"&&(Bl.textContent=Ps),fe=a(l),kl=M(l,"P",{"data-svelte-h":!0}),J(kl)!=="svelte-1uar592"&&(kl.innerHTML=Ks),Re=a(l),p(Nl.$$.fragment,l),he=a(l),El=M(l,"P",{"data-svelte-h":!0}),J(El)!=="svelte-kvyv77"&&(El.textContent=ln),Qe=a(l),Fl=M(l,"P",{"data-svelte-h":!0}),J(Fl)!=="svelte-zj9pt2"&&(Fl.innerHTML=tn),Be=a(l),p(Zl.$$.fragment,l),ke=a(l),Sl=M(l,"P",{"data-svelte-h":!0}),J(Sl)!=="svelte-bra8no"&&(Sl.textContent=en),Ne=a(l),vl=M(l,"P",{"data-svelte-h":!0}),J(vl)!=="svelte-1jemoxg"&&(vl.innerHTML=sn),Ee=a(l),p($l.$$.fragment,l),Fe=a(l),Gl=M(l,"P",{"data-svelte-h":!0}),J(Gl)!=="svelte-fgmb5i"&&(Gl.innerHTML=nn),Ze=a(l),p(Yl.$$.fragment,l),Se=a(l),_l=M(l,"P",{"data-svelte-h":!0}),J(_l)!=="svelte-2oo2a3"&&(_l.textContent=an),ve=a(l),xl=M(l,"OL",{"data-svelte-h":!0}),J(xl)!=="svelte-1laz0b9"&&(xl.innerHTML=Un),$e=a(l),Al=M(l,"P",{"data-svelte-h":!0}),J(Al)!=="svelte-utwpi5"&&(Al.innerHTML=Mn),Ge=a(l),p(Wl.$$.fragment,l),Ye=a(l),Ll=M(l,"P",{"data-svelte-h":!0}),J(Ll)!=="svelte-1jminco"&&(Ll.textContent=Jn),_e=a(l),p(Ol.$$.fragment,l),xe=a(l),p(Hl.$$.fragment,l),Ae=a(l),Xl=M(l,"P",{"data-svelte-h":!0}),J(Xl)!=="svelte-giwu4e"&&(Xl.innerHTML=Tn),We=a(l),p(zl.$$.fragment,l),Le=a(l),ql=M(l,"P",{"data-svelte-h":!0}),J(ql)!=="svelte-1fsq05o"&&(ql.innerHTML=pn),Oe=a(l),Dl=M(l,"OL",{"data-svelte-h":!0}),J(Dl)!=="svelte-qvbyzq"&&(Dl.innerHTML=on),He=a(l),Pl=M(l,"P",{"data-svelte-h":!0}),J(Pl)!=="svelte-6xg5qt"&&(Pl.textContent=Cn),Xe=a(l),p(Kl.$$.fragment,l),ze=a(l),p(lt.$$.fragment,l),qe=a(l),tt=M(l,"P",{"data-svelte-h":!0}),J(tt)!=="svelte-qwuhs5"&&(tt.textContent=yn),De=a(l),et=M(l,"UL",{"data-svelte-h":!0}),J(et)!=="svelte-1ih063h"&&(et.innerHTML=mn),Pe=a(l),st=M(l,"P",{"data-svelte-h":!0}),J(st)!=="svelte-1qr0dda"&&(st.textContent=rn),Ke=a(l),nt=M(l,"P",{"data-svelte-h":!0}),J(nt)!=="svelte-ukc2vx"&&(nt.innerHTML=un),ls=a(l),p(at.$$.fragment,l),ts=a(l),Ut=M(l,"P",{"data-svelte-h":!0}),J(Ut)!=="svelte-1q6s2or"&&(Ut.textContent=wn),es=a(l),Mt=M(l,"OL",{"data-svelte-h":!0}),J(Mt)!=="svelte-1gov4si"&&(Mt.innerHTML=cn),ss=a(l),Jt=M(l,"P",{"data-svelte-h":!0}),J(Jt)!=="svelte-byy2n0"&&(Jt.textContent=jn),ns=a(l),p(Tt.$$.fragment,l),as=a(l),it=M(l,"P",{}),Vn(it).forEach(e),this.h()},h(){Ms(u,"name","hf:doc:metadata"),Ms(u,"content",Nn),Ms(w,"class","tip")},m(l,t){hn(document.head,u),s(l,ot,t),s(l,pt,t),s(l,Ct,t),i(c,l,t),s(l,yt,t),i(j,l,t),s(l,mt,t),s(l,w,t),s(l,rt,t),s(l,V,t),s(l,ut,t),s(l,g,t),s(l,wt,t),s(l,I,t),s(l,ct,t),i(d,l,t),s(l,jt,t),s(l,b,t),s(l,Vt,t),s(l,f,t),s(l,gt,t),s(l,R,t),s(l,It,t),i(h,l,t),s(l,dt,t),s(l,Q,t),s(l,bt,t),i(B,l,t),s(l,ft,t),i(k,l,t),s(l,Rt,t),s(l,N,t),s(l,ht,t),s(l,E,t),s(l,Qt,t),s(l,F,t),s(l,Bt,t),i(Z,l,t),s(l,kt,t),s(l,S,t),s(l,Nt,t),i(v,l,t),s(l,Et,t),s(l,$,t),s(l,Ft,t),i(G,l,t),s(l,Zt,t),i(Y,l,t),s(l,St,t),s(l,_,t),s(l,vt,t),i(x,l,t),s(l,$t,t),s(l,A,t),s(l,Gt,t),s(l,W,t),s(l,Yt,t),s(l,L,t),s(l,_t,t),s(l,O,t),s(l,xt,t),i(H,l,t),s(l,At,t),s(l,X,t),s(l,Wt,t),i(z,l,t),s(l,Lt,t),i(q,l,t),s(l,Ot,t),s(l,D,t),s(l,Ht,t),s(l,P,t),s(l,Xt,t),s(l,K,t),s(l,zt,t),s(l,ll,t),s(l,qt,t),s(l,tl,t),s(l,Dt,t),s(l,el,t),s(l,Pt,t),i(sl,l,t),s(l,Kt,t),s(l,nl,t),s(l,le,t),i(al,l,t),s(l,te,t),s(l,Ul,t),s(l,ee,t),s(l,Ml,t),s(l,se,t),i(Jl,l,t),s(l,ne,t),s(l,Tl,t),s(l,ae,t),s(l,pl,t),s(l,Ue,t),s(l,il,t),s(l,Me,t),i(ol,l,t),s(l,Je,t),s(l,Cl,t),s(l,Te,t),s(l,yl,t),s(l,pe,t),s(l,ml,t),s(l,ie,t),i(rl,l,t),s(l,oe,t),s(l,ul,t),s(l,Ce,t),i(wl,l,t),s(l,ye,t),s(l,cl,t),s(l,me,t),i(jl,l,t),s(l,re,t),s(l,Vl,t),s(l,ue,t),s(l,gl,t),s(l,we,t),i(Il,l,t),s(l,ce,t),s(l,dl,t),s(l,je,t),s(l,bl,t),s(l,Ve,t),i(fl,l,t),s(l,ge,t),s(l,Rl,t),s(l,Ie,t),s(l,hl,t),s(l,de,t),s(l,Ql,t),s(l,be,t),s(l,Bl,t),s(l,fe,t),s(l,kl,t),s(l,Re,t),i(Nl,l,t),s(l,he,t),s(l,El,t),s(l,Qe,t),s(l,Fl,t),s(l,Be,t),i(Zl,l,t),s(l,ke,t),s(l,Sl,t),s(l,Ne,t),s(l,vl,t),s(l,Ee,t),i($l,l,t),s(l,Fe,t),s(l,Gl,t),s(l,Ze,t),i(Yl,l,t),s(l,Se,t),s(l,_l,t),s(l,ve,t),s(l,xl,t),s(l,$e,t),s(l,Al,t),s(l,Ge,t),i(Wl,l,t),s(l,Ye,t),s(l,Ll,t),s(l,_e,t),i(Ol,l,t),s(l,xe,t),i(Hl,l,t),s(l,Ae,t),s(l,Xl,t),s(l,We,t),i(zl,l,t),s(l,Le,t),s(l,ql,t),s(l,Oe,t),s(l,Dl,t),s(l,He,t),s(l,Pl,t),s(l,Xe,t),i(Kl,l,t),s(l,ze,t),i(lt,l,t),s(l,qe,t),s(l,tt,t),s(l,De,t),s(l,et,t),s(l,Pe,t),s(l,st,t),s(l,Ke,t),s(l,nt,t),s(l,ls,t),i(at,l,t),s(l,ts,t),s(l,Ut,t),s(l,es,t),s(l,Mt,t),s(l,ss,t),s(l,Jt,t),s(l,ns,t),i(Tt,l,t),s(l,as,t),s(l,it,t),Us=!0},p:In,i(l){Us||(o(c.$$.fragment,l),o(j.$$.fragment,l),o(d.$$.fragment,l),o(h.$$.fragment,l),o(B.$$.fragment,l),o(k.$$.fragment,l),o(Z.$$.fragment,l),o(v.$$.fragment,l),o(G.$$.fragment,l),o(Y.$$.fragment,l),o(x.$$.fragment,l),o(H.$$.fragment,l),o(z.$$.fragment,l),o(q.$$.fragment,l),o(sl.$$.fragment,l),o(al.$$.fragment,l),o(Jl.$$.fragment,l),o(ol.$$.fragment,l),o(rl.$$.fragment,l),o(wl.$$.fragment,l),o(jl.$$.fragment,l),o(Il.$$.fragment,l),o(fl.$$.fragment,l),o(Nl.$$.fragment,l),o(Zl.$$.fragment,l),o($l.$$.fragment,l),o(Yl.$$.fragment,l),o(Wl.$$.fragment,l),o(Ol.$$.fragment,l),o(Hl.$$.fragment,l),o(zl.$$.fragment,l),o(Kl.$$.fragment,l),o(lt.$$.fragment,l),o(at.$$.fragment,l),o(Tt.$$.fragment,l),Us=!0)},o(l){C(c.$$.fragment,l),C(j.$$.fragment,l),C(d.$$.fragment,l),C(h.$$.fragment,l),C(B.$$.fragment,l),C(k.$$.fragment,l),C(Z.$$.fragment,l),C(v.$$.fragment,l),C(G.$$.fragment,l),C(Y.$$.fragment,l),C(x.$$.fragment,l),C(H.$$.fragment,l),C(z.$$.fragment,l),C(q.$$.fragment,l),C(sl.$$.fragment,l),C(al.$$.fragment,l),C(Jl.$$.fragment,l),C(ol.$$.fragment,l),C(rl.$$.fragment,l),C(wl.$$.fragment,l),C(jl.$$.fragment,l),C(Il.$$.fragment,l),C(fl.$$.fragment,l),C(Nl.$$.fragment,l),C(Zl.$$.fragment,l),C($l.$$.fragment,l),C(Yl.$$.fragment,l),C(Wl.$$.fragment,l),C(Ol.$$.fragment,l),C(Hl.$$.fragment,l),C(zl.$$.fragment,l),C(Kl.$$.fragment,l),C(lt.$$.fragment,l),C(at.$$.fragment,l),C(Tt.$$.fragment,l),Us=!1},d(l){l&&(e(ot),e(pt),e(Ct),e(yt),e(mt),e(w),e(rt),e(V),e(ut),e(g),e(wt),e(I),e(ct),e(jt),e(b),e(Vt),e(f),e(gt),e(R),e(It),e(dt),e(Q),e(bt),e(ft),e(Rt),e(N),e(ht),e(E),e(Qt),e(F),e(Bt),e(kt),e(S),e(Nt),e(Et),e($),e(Ft),e(Zt),e(St),e(_),e(vt),e($t),e(A),e(Gt),e(W),e(Yt),e(L),e(_t),e(O),e(xt),e(At),e(X),e(Wt),e(Lt),e(Ot),e(D),e(Ht),e(P),e(Xt),e(K),e(zt),e(ll),e(qt),e(tl),e(Dt),e(el),e(Pt),e(Kt),e(nl),e(le),e(te),e(Ul),e(ee),e(Ml),e(se),e(ne),e(Tl),e(ae),e(pl),e(Ue),e(il),e(Me),e(Je),e(Cl),e(Te),e(yl),e(pe),e(ml),e(ie),e(oe),e(ul),e(Ce),e(ye),e(cl),e(me),e(re),e(Vl),e(ue),e(gl),e(we),e(ce),e(dl),e(je),e(bl),e(Ve),e(ge),e(Rl),e(Ie),e(hl),e(de),e(Ql),e(be),e(Bl),e(fe),e(kl),e(Re),e(he),e(El),e(Qe),e(Fl),e(Be),e(ke),e(Sl),e(Ne),e(vl),e(Ee),e(Fe),e(Gl),e(Ze),e(Se),e(_l),e(ve),e(xl),e($e),e(Al),e(Ge),e(Ye),e(Ll),e(_e),e(xe),e(Ae),e(Xl),e(We),e(Le),e(ql),e(Oe),e(Dl),e(He),e(Pl),e(Xe),e(ze),e(qe),e(tt),e(De),e(et),e(Pe),e(st),e(Ke),e(nt),e(ls),e(ts),e(Ut),e(es),e(Mt),e(ss),e(Jt),e(ns),e(as),e(it)),e(u),y(c,l),y(j,l),y(d,l),y(h,l),y(B,l),y(k,l),y(Z,l),y(v,l),y(G,l),y(Y,l),y(x,l),y(H,l),y(z,l),y(q,l),y(sl,l),y(al,l),y(Jl,l),y(ol,l),y(rl,l),y(wl,l),y(jl,l),y(Il,l),y(fl,l),y(Nl,l),y(Zl,l),y($l,l),y(Yl,l),y(Wl,l),y(Ol,l),y(Hl,l),y(zl,l),y(Kl,l),y(lt,l),y(at,l),y(Tt,l)}}}const Nn='{"title":"附加单元 2：AI 智能体(AI Agent)的可观测性与评估","local":"附加单元-2ai-智能体ai-agent的可观测性与评估","sections":[{"title":"练习先决条件 🏗️","local":"练习先决条件-","sections":[],"depth":2},{"title":"步骤 0：安装所需的库","local":"步骤-0安装所需的库","sections":[],"depth":2},{"title":"步骤 1：检测你的智能体","local":"步骤-1检测你的智能体","sections":[],"depth":2},{"title":"步骤 2：测试你的检测","local":"步骤-2测试你的检测","sections":[],"depth":2},{"title":"步骤 3：观测和评估更复杂的AI智能体","local":"步骤-3观测和评估更复杂的ai智能体","sections":[{"title":"追踪结构","local":"追踪结构","sections":[],"depth":3}],"depth":2},{"title":"在线评估","local":"在线评估","sections":[{"title":"生产环境中要追踪的常见指标","local":"生产环境中要追踪的常见指标","sections":[{"title":"1. 成本","local":"1-成本","sections":[],"depth":4},{"title":"2. 延迟","local":"2-延迟","sections":[],"depth":4},{"title":"3. 附加属性","local":"3-附加属性","sections":[],"depth":4},{"title":"4. 用户反馈","local":"4-用户反馈","sections":[],"depth":4},{"title":"5. LLM 作为评判者","local":"5-llm-作为评判者","sections":[],"depth":4},{"title":"6. 可观测性指标概览","local":"6-可观测性指标概览","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"离线评估","local":"离线评估","sections":[{"title":"数据集评估","local":"数据集评估","sections":[{"title":"在数据集上运行智能体","local":"在数据集上运行智能体","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"结语","local":"结语","sections":[],"depth":2}],"depth":1}';function En(Js){return dn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Yn extends bn{constructor(u){super(),fn(this,u,En,kn,gn,{})}}export{Yn as component};
