import{s as gn,n as fn,o as In}from"../chunks/scheduler.37c15a92.js";import{S as vn,i as Cn,g as i,s as n,r,A as hn,h as u,f as l,c as a,j as bn,u as M,x as o,k as us,y as Zn,a as s,v as p,d as m,t as c,w as d}from"../chunks/index.2bf4358c.js";import{C as y}from"../chunks/CodeBlock.4e987730.js";import{C as Gn}from"../chunks/CourseFloatingBanner.6add7356.js";import{H as J}from"../chunks/Heading.8ada512a.js";import{E as Bn}from"../chunks/getInferenceSnippets.0aa3753f.js";function Vn(os){let T,mt,Mt,ct,w,dt,j,Jt,U,rs='<p>Vous pouvez suivre le code dans <a href="https://colab.research.google.com/#fileId=https%3A//huggingface.co/agents-course/notebooks/blob/main/fr/bonus-unit2/monitoring-and-evaluating-agents.ipynb" target="_blank">ce <i>notebook</i></a> que vous pouvez exécuter avec Google Colab.</p>',yt,b,Ms="Dans ce <em>notebook</em>, nous apprendrons comment <strong>surveiller les étapes internes (traces) de notre agent</strong> et <strong>évaluer ses performances</strong> en utilisant des outils d’observabilité <em>open source</em>.",Tt,g,ps="La capacité d’observer et d’évaluer le comportement d’un agent est essentielle pour :",Ut,f,ms="<li>Déboguer les problèmes lorsque les tâches échouent ou produisent des résultats sous-optimaux</li> <li>Contrôler les coûts et les performances en temps réel</li> <li>Améliorer la fiabilité et la sécurité grâce à un retour d’information continu</li>",wt,I,jt,v,cs="Avant d’exécuter ce <em>notebook</em>, assurez-vous d’avoir :",bt,C,ds='🔲 📚 <strong>Etudier la section <a href="https://huggingface.co/learn/agents-course/fr/unit1/introduction" rel="nofollow">Introduction aux agents</a></strong>',gt,h,Js='🔲 📚 <strong>Etudier la section <a href="https://huggingface.co/learn/agents-course/fr/unit2/smolagents/introduction" rel="nofollow">le <em>framework</em> smolagents</a></strong>',ft,Z,It,G,ys="Nous aurons besoin de quelques bibliothèques qui nous permettront d’exécuter, de contrôler et d’évaluer nos agents :",vt,B,Ct,V,ht,x,Ts='Dans ce <em>notebook</em>, nous utiliserons <a href="https://langfuse.com/" rel="nofollow">Langfuse</a> comme outil d’observabilité, mais vous pouvez utiliser <strong>n’importe quel autre service compatible avec OpenTelemetry</strong>. Le code ci-dessous montre comment définir les variables d’environnement pour Langfuse (ou n’importe quel <em>endpoint OTel</em>) et comment instrumenter votre smolagent.',Zt,W,Us='<strong>Note :</strong> Si vous utilisez LlamaIndex ou LangGraph, vous pouvez trouver de la documentation sur leur instrumentation <a href="https://langfuse.com/docs/integrations/llama-index/workflows" rel="nofollow">ici</a> et <a href="https://langfuse.com/docs/integrations/langchain/example-python-langgraph" rel="nofollow">ici</a>.',Gt,$,ws='D’abord, configurons les credentials <em>Langfuse</em> comme variables d’environnement. Obtenez vos clés API <em>Langfuse</em> en vous inscrivant sur <a href="https://cloud.langfuse.com" rel="nofollow">Langfuse Cloud</a> ou en <a href="https://langfuse.com/self-hosting" rel="nofollow">auto-hébergeant Langfuse</a>.',Bt,E,Vt,z,js="Nous devons aussi configurer notre token <em>Hugging Face</em> pour les appels d’inférence.",xt,k,Wt,R,bs="Avec les variables d’environnement définies, nous pouvons maintenant initialiser le client <em>Langfuse</em>. <code>get_client()</code> initialise le client <em>Langfuse</em> en utilisant les credentials fournis dans les variables d’environnement.",$t,Q,Et,N,gs="Ensuite, nous pouvons configurer le <code>SmolagentsInstrumentor()</code> pour instrumenter notre <em>smolagent</em> et envoyer des traces à <em>Langfuse</em>.",zt,A,kt,L,Rt,S,fs="Voici un simple <em>CodeAgent</em> de smolagents qui calcule <code>1+1</code>. Nous l’exécutons pour confirmer que l’instrumentation fonctionne correctement. Si tout est configuré correctement, vous verrez des logs/spans dans votre tableau de bord d’observabilité.",Qt,q,Nt,X,Is='Consultez votre <a href="https://cloud.langfuse.com/traces" rel="nofollow">Langfuse Traces Dashboard</a> (ou l’outil d’observabilité de votre choix) pour confirmer que les portées et les logs ont été enregistrés.',At,H,vs="Exemple de capture d’écran de Langfuse :",Lt,Y,Cs='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/first-example-trace.png" alt="Example trace in Langfuse"/>',St,_,hs='<em><a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/1b94d6888258e0998329cdb72a371155?timestamp=2025-03-10T11%3A59%3A41.743Z" rel="nofollow">Lien vers la trace</a></em>',qt,F,Xt,D,Zs="Maintenant que vous avez confirmé que votre instrumentation fonctionne, essayons une requête plus complexe afin de voir comment les mesures avancées (utilisation des <em>tokens</em>, latence, coûts, etc.) sont suivies.",Ht,P,Yt,K,_t,O,Gs="La plupart des outils d’observabilité enregistrent une <strong>trace</strong> qui contient des <strong>spans</strong>, qui représentent chaque étape de la logique de votre agent. Ici, la trace contient l’exécution globale de l’agent et les sous-périodes pour :",Ft,ee,Bs="<li>les appels à l’outil (DuckDuckGoSearchTool)</li> <li>Les appels LLM (InferenceClientModel)</li>",Dt,te,Vs="Vous pouvez les inspecter pour voir précisément où le temps est passé, combien de <em>tokens</em> sont utilisés, etc. :",Pt,le,xs='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/trace-tree.png" alt="Trace tree in Langfuse"/>',Kt,se,Ws='<em><a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/1ac33b89ffd5e75d4265b62900c348ed?timestamp=2025-03-07T13%3A45%3A09.149Z&amp;display=preview" rel="nofollow">Lien vers la trace</a></em>',Ot,ne,el,ae,$s="Dans la section précédente, nous avons appris la différence entre l’évaluation en ligne et hors ligne. Nous allons maintenant voir comment surveiller votre agent en production et l’évaluer en direct.",tl,ie,ll,ue,Es="<li><strong>Coûts</strong> - L’instrumentation smolagents capture l’utilisation des <em>tokens</em>, que vous pouvez transformer en coûts approximatifs en assignant un prix par <em>token</em>.</li> <li><strong>Latence</strong> - Observez le temps nécessaire à la réalisation de chaque étape ou de l’ensemble de l’exécution.</li> <li><strong>Retour utilisateur</strong> - Les utilisateurs peuvent fournir un retour direct (pouce vers le haut/vers le bas) pour aider à affiner ou à corriger l’agent.</li> <li><strong><em>LLM-as-a-Judge</em></strong> - Utilisez un autre LLM pour évaluer les résultats de votre agent en quasi temps réel (par exemple, vérification de la toxicité ou de l’exactitude des résultats).</li>",sl,oe,zs="Ci-dessous, nous montrons des exemples de ces métriques.",nl,re,al,Me,ks="Vous trouverez ci-dessous une capture d’écran montrant l’utilisation des appels <code>Qwen2.5-Coder-32B-Instruct</code>. Ceci est utile pour voir les étapes coûteuses et optimiser votre agent.",il,pe,Rs='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/smolagents-costs.png" alt="Costs"/>',ul,me,Qs='<em><a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/1ac33b89ffd5e75d4265b62900c348ed?timestamp=2025-03-07T13%3A45%3A09.149Z&amp;display=preview" rel="nofollow">Lien vers la trace</a></em>',ol,ce,rl,de,Ns="Nous pouvons également voir combien de temps a duré chaque étape. Dans l’exemple ci-dessous, l’ensemble de la conversation a duré 32 secondes, que vous pouvez répartir par étape. Cela vous permet d’identifier les goulets d’étranglement et d’optimiser votre agent.",Ml,Je,As='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/smolagents-latency.png" alt="Latency"/>',pl,ye,Ls='_<a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/1ac33b89ffd5e75d4265b62900c348ed?timestamp=2025-03-07T13%3A45%3A09.149Z&amp;display=preview" rel="nofollow">Lien vers la trace</a>_blank',ml,Te,cl,Ue,Ss="Vous pouvez également passer des attributs supplémentaires à vos spans. Ceux-ci peuvent inclure <code>user_id</code>, <code>tags</code>, <code>session_id</code>, et des métadonnées personnalisées. Enrichir les traces avec ces détails est important pour l’analyse, le débogage et la surveillance du comportement de votre application à travers différents utilisateurs ou sessions.",dl,we,Jl,je,qs='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/smolagents-attributes.png" alt="Enhancing agent runs with additional metrics"/>',yl,be,Tl,ge,Xs='Si votre agent est intégré dans une interface utilisateur, vous pouvez enregistrer les réactions directes de l’utilisateur (comme un pouce levé ou baissé dans une interface de discussion). Vous trouverez ci-dessous un exemple utilisant <a href="https://gradio.app/" rel="nofollow">Gradio</a> pour intégrer un chat avec un mécanisme de retour d’information simple.',Ul,fe,Hs="Dans l’extrait de code ci-dessous, lorsqu’un utilisateur envoie un message de chat, nous capturons la trace dans Langfuse. Si l’utilisateur aime ou n’aime pas la dernière réponse, nous attribuons un score à la trace.",wl,Ie,jl,ve,Ys="Les retours des utilisateurs sont ensuite saisis dans votre outil d’observabilité :",bl,Ce,_s='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/user-feedback-gradio.png" alt="User feedback is being captured in Langfuse"/>',gl,he,fl,Ze,Fs="<em>LLM-as-a-Judge</em> est une autre façon d’évaluer automatiquement les résultats de votre agent. Vous pouvez configurer l’appel d’un autre LLM pour évaluer l’exactitude, la toxicité, le style ou tout autre critère qui vous intéresse.",Il,Ge,Ds="<strong>Fonctionnement</strong> :",vl,Be,Ps="<li>Vous définissez un <strong>Modèle d’évaluation</strong>, par exemple, « Vérifier si le texte est toxique ».</li> <li>Chaque fois que votre agent génère un résultat, vous transmettez ce résultat à votre LLM juge avec le gabarit.</li> <li>Le LLM juge répond avec un score ou une étiquette que vous enregistrez dans votre outil d’observabilité.</li>",Cl,Ve,Ks="Exemple de Langfuse :",hl,xe,Os='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/evaluator-template.png" alt="LLM-as-a-Judge Evaluation Template"/> <img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/evaluator.png" alt="LLM-as-a-Judge Evaluator"/>',Zl,We,Gl,$e,en="Vous pouvez voir que la réponse de cet exemple est jugée « non toxique ».",Bl,Ee,tn='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/llm-as-a-judge-score.png" alt="LLM-as-a-Judge Evaluation Score"/>',Vl,ze,xl,ke,ln="Toutes ces métriques peuvent être visualisées ensemble dans des tableaux de bord. Cela vous permet de voir rapidement les performances de votre agent sur plusieurs sessions et vous aide à suivre les mesures de qualité au fil du temps.",Wl,Re,sn='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/langfuse-dashboard.png" alt="Observability metrics overview"/>',$l,Qe,El,Ne,nn="L’évaluation en ligne est essentielle pour obtenir un retour d’information en temps réel, mais vous avez également besoin d’une <strong>évaluation hors ligne</strong>, c’est-à-dire de vérifications systématiques avant ou pendant le développement. Cela permet de maintenir la qualité et la fiabilité avant de mettre les changements en production.",zl,Ae,kl,Le,an="Lors d’une évaluation hors ligne, vous devez généralement",Rl,Se,un="<li>Disposer d’un jeu de données de référence (avec des paires de <em>prompts</em> et de résultats attendus)</li> <li>Exécuter votre agent sur ce jeu de données</li> <li>Comparer les résultats aux résultats attendus ou utiliser un mécanisme de notation supplémentaire.</li>",Ql,qe,on='Ci-dessous, nous démontrons cette approche avec le jeu de données <a href="https://huggingface.co/datasets/gsm8k" rel="nofollow">GSM8K</a>, qui contient des questions et des solutions mathématiques.',Nl,Xe,Al,He,rn=`Ensuite, nous créons un jeu de données dans Langfuse pour suivre les exécutions. Nous ajoutons ensuite chaque élément du jeu de données au système.<br/>
(Si vous n’utilisez pas Langfuse, vous pouvez simplement les stocker dans votre propre base de données ou dans un fichier local à des fins d’analyse).`,Ll,Ye,Sl,_e,ql,Fe,Mn='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/example-dataset.png" alt="Dataset items in Langfuse"/>',Xl,De,Hl,Pe,pn="Nous définissons une fonction d’aide <code>run_smolagent()</code> qui :",Yl,Ke,mn="<li>Démarre un span Langfuse</li> <li>Exécute notre agent sur le <em>prompt</em></li> <li>Enregistre l’ID de la trace dans Langfuse</li>",_l,Oe,cn="Ensuite, nous parcourons en boucle chaque élément de l’ensemble de données, nous exécutons l’agent et nous lions la trace à l’élément de l’ensemble de données. Nous pouvons également joindre une note d’évaluation rapide si vous le souhaitez.",Fl,et,Dl,tt,dn="Vous pouvez répéter ce processus avec différents :",Pl,lt,Jn="<li>Modèles (OpenAI GPT, LLM local, etc.)</li> <li>Outils (recherche ou pas recherche)</li> <li>Prompts (différents messages du système)</li>",Kl,st,yn="Ensuite, comparez-les côte à côte dans votre outil d’observabilité :",Ol,nt,Tn='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/dataset_runs.png" alt="Dataset run overview"/> <img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/dataset-run-comparison.png" alt="Dataset run comparison"/>',es,at,ts,it,Un="Dans ce <em>notebook</em>, nous avons vu comment :",ls,ut,wn="<li><strong>Mettre en place l’observabilité</strong> en utilisant les exportateurs smolagents + OpenTelemetry</li> <li><strong>Vérifier l’instrumentation</strong> en lançant un agent simple</li> <li><strong>Capturez des métriques détaillées</strong> (coût, latence, etc.) à l’aide d’outils d’observabilité</li> <li><strong>Recueillir les commentaires des utilisateurs</strong> via une interface Gradio</li> <li><strong>Utiliser un LLM-as-a-Judge</strong> pour évaluer automatiquement les résultats</li> <li><strong>Effectuer une évaluation hors ligne</strong> avec un jeu de données de référence</li>",ss,ot,jn="🤗 Bon codage !",ns,rt,as,pt,is;return w=new Gn({props:{chapter:2,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/#fileId=https%3A//huggingface.co/agents-course/notebooks/blob/main/fr/bonus-unit2/monitoring-and-evaluating-agents.ipynb"}]}}),j=new J({props:{title:"Observer et évaluer des agents",local:"observer-et-évaluer-des-agents",headingTag:"h1"}}),I=new J({props:{title:"Prérequis de l’exercice 🏗️",local:"prérequis-de-lexercice-",headingTag:"h2"}}),Z=new J({props:{title:"Étape 0 : Installer les bibliothèques nécessaires",local:"étape-0--installer-les-bibliothèques-nécessaires",headingTag:"h2"}}),B=new y({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMGxhbmdmdXNlJTIwJ3Ntb2xhZ2VudHMlNUJ0ZWxlbWV0cnklNUQnJTIwb3BlbmluZmVyZW5jZS1pbnN0cnVtZW50YXRpb24tc21vbGFnZW50cyUyMGRhdGFzZXRzJTIwJ3Ntb2xhZ2VudHMlNUJncmFkaW8lNUQnJTIwZ3JhZGlvJTIwLS11cGdyYWRl",highlighted:'%pip install langfuse <span class="hljs-string">&#x27;smolagents[telemetry]&#x27;</span> openinference-instrumentation-smolagents datasets <span class="hljs-string">&#x27;smolagents[gradio]&#x27;</span> gradio --upgrade',wrap:!1}}),V=new J({props:{title:"Étape 1 : Instrumenter votre agent",local:"étape-1--instrumenter-votre-agent",headingTag:"h2"}}),E=new y({props:{code:"aW1wb3J0JTIwb3MlMEElMjMlMjBPYnRlbmV6JTIwbGVzJTIwY2wlQzMlQTlzJTIwcG91ciUyMHZvdHJlJTIwcHJvamV0JTIwZGVwdWlzJTIwbGElMjBwYWdlJTIwZGVzJTIwcGFyYW0lQzMlQTh0cmVzJTIwZHUlMjBwcm9qZXQlMjAlM0ElMjBodHRwcyUzQSUyRiUyRmNsb3VkLmxhbmdmdXNlLmNvbSUwQW9zLmVudmlyb24lNUIlMjJMQU5HRlVTRV9QVUJMSUNfS0VZJTIyJTVEJTIwJTNEJTIwJTIycGstbGYtLi4uJTIyJTIwJTBBb3MuZW52aXJvbiU1QiUyMkxBTkdGVVNFX1NFQ1JFVF9LRVklMjIlNUQlMjAlM0QlMjAlMjJzay1sZi0uLi4lMjIlMjAlMEFvcy5lbnZpcm9uJTVCJTIyTEFOR0ZVU0VfSE9TVCUyMiU1RCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGY2xvdWQubGFuZ2Z1c2UuY29tJTIyJTIwJTIzJTIwJUYwJTlGJTg3JUFBJUYwJTlGJTg3JUJBJTIwciVDMyVBOWdpb24lMjBFVSUwQSUyMyUyMG9zLmVudmlyb24lNUIlMjJMQU5HRlVTRV9IT1NUJTIyJTVEJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZ1cy5jbG91ZC5sYW5nZnVzZS5jb20lMjIlMjAlMjMlMjAlRjAlOUYlODclQkElRjAlOUYlODclQjglMjByJUMzJUE5Z2lvbiUyMFVT",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-comment"># Obtenez les clés pour votre projet depuis la page des paramètres du projet : https://cloud.langfuse.com</span>
os.environ[<span class="hljs-string">&quot;LANGFUSE_PUBLIC_KEY&quot;</span>] = <span class="hljs-string">&quot;pk-lf-...&quot;</span> 
os.environ[<span class="hljs-string">&quot;LANGFUSE_SECRET_KEY&quot;</span>] = <span class="hljs-string">&quot;sk-lf-...&quot;</span> 
os.environ[<span class="hljs-string">&quot;LANGFUSE_HOST&quot;</span>] = <span class="hljs-string">&quot;https://cloud.langfuse.com&quot;</span> <span class="hljs-comment"># 🇪🇺 région EU</span>
<span class="hljs-comment"># os.environ[&quot;LANGFUSE_HOST&quot;] = &quot;https://us.cloud.langfuse.com&quot; # 🇺🇸 région US</span>`,wrap:!1}}),k=new y({props:{code:"JTIzJTIwRCVDMyVBOWZpbmlzc2V6JTIwdm9zJTIwdG9rZW5zJTJGc2VjcmV0cyUyMEh1Z2dpbmclMjBGYWNlJTIwY29tbWUlMjB2YXJpYWJsZSUyMGQnZW52aXJvbm5lbWVudCUwQW9zLmVudmlyb24lNUIlMjJIRl9UT0tFTiUyMiU1RCUyMCUzRCUyMCUyMmhmXy4uLiUyMiUyMA==",highlighted:`<span class="hljs-comment"># Définissez vos tokens/secrets Hugging Face comme variable d&#x27;environnement</span>
os.environ[<span class="hljs-string">&quot;HF_TOKEN&quot;</span>] = <span class="hljs-string">&quot;hf_...&quot;</span> `,wrap:!1}}),Q=new y({props:{code:"ZnJvbSUyMGxhbmdmdXNlJTIwaW1wb3J0JTIwZ2V0X2NsaWVudCUwQSUyMCUwQWxhbmdmdXNlJTIwJTNEJTIwZ2V0X2NsaWVudCgpJTBBJTIwJTBBJTIzJTIwViVDMyVBOXJpZmllciUyMGxhJTIwY29ubmV4aW9uJTBBaWYlMjBsYW5nZnVzZS5hdXRoX2NoZWNrKCklM0ElMEElMjAlMjAlMjAlMjBwcmludCglMjJMZSUyMGNsaWVudCUyMExhbmdmdXNlJTIwZXN0JTIwYXV0aGVudGlmaSVDMyVBOSUyMGV0JTIwcHIlQzMlQUF0JTIwISUyMiklMEFlbHNlJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyTCdhdXRoZW50aWZpY2F0aW9uJTIwYSUyMCVDMyVBOWNob3UlQzMlQTkuJTIwVmV1aWxsZXolMjB2JUMzJUE5cmlmaWVyJTIwdm9zJTIwY3JlZGVudGlhbHMlMjBldCUyMGglQzMlQjR0ZS4lMjIp",highlighted:`<span class="hljs-keyword">from</span> langfuse <span class="hljs-keyword">import</span> get_client
 
langfuse = get_client()
 
<span class="hljs-comment"># Vérifier la connexion</span>
<span class="hljs-keyword">if</span> langfuse.auth_check():
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Le client Langfuse est authentifié et prêt !&quot;</span>)
<span class="hljs-keyword">else</span>:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;L&#x27;authentification a échoué. Veuillez vérifier vos credentials et hôte.&quot;</span>)`,wrap:!1}}),A=new y({props:{code:"ZnJvbSUyMG9wZW5pbmZlcmVuY2UuaW5zdHJ1bWVudGF0aW9uLnNtb2xhZ2VudHMlMjBpbXBvcnQlMjBTbW9sYWdlbnRzSW5zdHJ1bWVudG9yJTBBJTIwJTBBU21vbGFnZW50c0luc3RydW1lbnRvcigpLmluc3RydW1lbnQoKQ==",highlighted:`<span class="hljs-keyword">from</span> openinference.instrumentation.smolagents <span class="hljs-keyword">import</span> SmolagentsInstrumentor
 
SmolagentsInstrumentor().instrument()`,wrap:!1}}),L=new J({props:{title:"Étape 2 : Testez votre instrumentation",local:"étape-2--testez-votre-instrumentation",headingTag:"h2"}}),q=new y({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUwQSUwQSUyMyUyMENyJUMzJUE5ZXIlMjB1biUyMGFnZW50JTIwYmFzaXF1ZSUyMHBvdXIlMjB0ZXN0ZXIlMjBsJ2luc3RydW1lbnRhdGlvbiUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpJTBBKSUwQSUwQWFnZW50LnJ1biglMjIxJTJCMSUzRCUyMik=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent

<span class="hljs-comment"># Créer un agent basique pour tester l&#x27;instrumentation</span>
agent = CodeAgent(
    tools=[],
    model=InferenceClientModel()
)

agent.run(<span class="hljs-string">&quot;1+1=&quot;</span>)`,wrap:!1}}),F=new J({props:{title:"Étape 3 : Observer et évaluer un agent plus complexe",local:"étape-3--observer-et-évaluer-un-agent-plus-complexe",headingTag:"h2"}}),P=new y({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjAoQ29kZUFnZW50JTJDJTIwRHVja0R1Y2tHb1NlYXJjaFRvb2wlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCklMEElMEFzZWFyY2hfdG9vbCUyMCUzRCUyMER1Y2tEdWNrR29TZWFyY2hUb29sKCklMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1QnNlYXJjaF90b29sJTVEJTJDJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpKSUwQSUwQWFnZW50LnJ1biglMjJDb21iaWVuJTIwZGUlMjBSdWJpaydzJTIwQ3ViZXMlMjBwb3VycmFpdC1vbiUyMGZhaXJlJTIwdGVuaXIlMjBkYW5zJTIwbGElMjBDYXRoJUMzJUE5ZHJhbGUlMjBOb3RyZS1EYW1lJTIwJTNGJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, DuckDuckGoSearchTool, InferenceClientModel)

search_tool = DuckDuckGoSearchTool()
agent = CodeAgent(tools=[search_tool], model=InferenceClientModel())

agent.run(<span class="hljs-string">&quot;Combien de Rubik&#x27;s Cubes pourrait-on faire tenir dans la Cathédrale Notre-Dame ?&quot;</span>)`,wrap:!1}}),K=new J({props:{title:"Structure de la trace",local:"structure-de-la-trace",headingTag:"h3"}}),ne=new J({props:{title:"Évaluation en ligne",local:"évaluation-en-ligne",headingTag:"h2"}}),ie=new J({props:{title:"Métriques courantes à suivre en production",local:"métriques-courantes-à-suivre-en-production",headingTag:"h3"}}),re=new J({props:{title:"1. Coûts",local:"1-coûts",headingTag:"h4"}}),ce=new J({props:{title:"2. Temps de latence",local:"2-temps-de-latence",headingTag:"h4"}}),Te=new J({props:{title:"3. Attributs supplémentaires",local:"3-attributs-supplémentaires",headingTag:"h4"}}),we=new y({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjAoQ29kZUFnZW50JTJDJTIwRHVja0R1Y2tHb1NlYXJjaFRvb2wlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCklMEElMEFzZWFyY2hfdG9vbCUyMCUzRCUyMER1Y2tEdWNrR29TZWFyY2hUb29sKCklMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QnNlYXJjaF90b29sJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpJTBBKSUwQSUwQXdpdGglMjBsYW5nZnVzZS5zdGFydF9hc19jdXJyZW50X3NwYW4oJTBBJTIwJTIwJTIwJTIwbmFtZSUzRCUyMlNtb2xhZ2VudC1UcmFjZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCklMjBhcyUyMHNwYW4lM0ElMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBFeCVDMyVBOWN1dGV6JTIwdm90cmUlMjBhcHBsaWNhdGlvbiUyMGljaSUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwYWdlbnQucnVuKCUyMlF1ZWxsZSUyMGVzdCUyMGxhJTIwY2FwaXRhbGUlMjBkZSUyMGwnQWxsZW1hZ25lJTIwJTNGJTIyKSUwQSUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMFBhc3NleiUyMGRlcyUyMGF0dHJpYnV0cyUyMHN1cHBsJUMzJUE5bWVudGFpcmVzJTIwYXUlMjBzcGFuJTBBJTIwJTIwJTIwJTIwc3Bhbi51cGRhdGVfdHJhY2UoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5wdXQlM0QlMjJRdWVsbGUlMjBlc3QlMjBsYSUyMGNhcGl0YWxlJTIwZGUlMjBsJ0FsbGVtYWduZSUyMCUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dCUzRHJlc3BvbnNlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdXNlcl9pZCUzRCUyMnNtb2xhZ2VudC11c2VyLTEyMyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlc3Npb25faWQlM0QlMjJzbW9sYWdlbnQtc2Vzc2lvbi0xMjM0NTY3ODklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0YWdzJTNEJTVCJTIycXVlc3Rpb24tdmlsbGUlMjIlMkMlMjAlMjJ0ZXN0LWFnZW50cyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1ldGFkYXRhJTNEJTdCJTIyZW1haWwlMjIlM0ElMjAlMjJ1c2VyJTQwbGFuZ2Z1c2UuY29tJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUyMCUwQSUyMyUyMEZsdXNoZXIlMjBsZXMlMjAlQzMlQTl2JUMzJUE5bmVtZW50cyUyMGRhbnMlMjBsZXMlMjBhcHBsaWNhdGlvbnMlMjBkZSUyMGNvdXJ0ZSUyMGR1ciVDMyVBOWUlMEFsYW5nZnVzZS5mbHVzaCgp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, DuckDuckGoSearchTool, InferenceClientModel)

search_tool = DuckDuckGoSearchTool()
agent = CodeAgent(
    tools=[search_tool],
    model=InferenceClientModel()
)

<span class="hljs-keyword">with</span> langfuse.start_as_current_span(
    name=<span class="hljs-string">&quot;Smolagent-Trace&quot;</span>,
    ) <span class="hljs-keyword">as</span> span:
    
    <span class="hljs-comment"># Exécutez votre application ici</span>
    response = agent.run(<span class="hljs-string">&quot;Quelle est la capitale de l&#x27;Allemagne ?&quot;</span>)
 
    <span class="hljs-comment"># Passez des attributs supplémentaires au span</span>
    span.update_trace(
        <span class="hljs-built_in">input</span>=<span class="hljs-string">&quot;Quelle est la capitale de l&#x27;Allemagne ?&quot;</span>,
        output=response,
        user_id=<span class="hljs-string">&quot;smolagent-user-123&quot;</span>,
        session_id=<span class="hljs-string">&quot;smolagent-session-123456789&quot;</span>,
        tags=[<span class="hljs-string">&quot;question-ville&quot;</span>, <span class="hljs-string">&quot;test-agents&quot;</span>],
        metadata={<span class="hljs-string">&quot;email&quot;</span>: <span class="hljs-string">&quot;user@langfuse.com&quot;</span>},
        )
 
<span class="hljs-comment"># Flusher les événements dans les applications de courte durée</span>
langfuse.flush()`,wrap:!1}}),be=new J({props:{title:"4. #### 4. Retour utilisateur",local:"4--4-retour-utilisateur",headingTag:"h4"}}),Ie=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, InferenceClientModel)
<span class="hljs-keyword">from</span> langfuse <span class="hljs-keyword">import</span> get_client

langfuse = get_client()

model = InferenceClientModel()
agent = CodeAgent(tools=[], model=model, add_base_tools=<span class="hljs-literal">True</span>)

trace_id = <span class="hljs-literal">None</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">respond</span>(<span class="hljs-params">prompt, history</span>):
    <span class="hljs-keyword">with</span> langfuse.start_as_current_span(
        name=<span class="hljs-string">&quot;Smolagent-Trace&quot;</span>):
        
        <span class="hljs-comment"># Exécutez votre application ici</span>
        output = agent.run(prompt)

        <span class="hljs-keyword">global</span> trace_id
        trace_id = langfuse.get_current_trace_id()

    history.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-built_in">str</span>(output)})
    <span class="hljs-keyword">return</span> history

<span class="hljs-keyword">def</span> <span class="hljs-title function_">handle_like</span>(<span class="hljs-params">data: gr.LikeData</span>):
    <span class="hljs-comment"># Pour la démonstration, nous mappons les retours utilisateur à 1 (j&#x27;aime) ou 0 (je n&#x27;aime pas)</span>
    <span class="hljs-keyword">if</span> data.liked:
        langfuse.create_score(
            value=<span class="hljs-number">1</span>,
            name=<span class="hljs-string">&quot;user-feedback&quot;</span>,
            trace_id=trace_id
        )
    <span class="hljs-keyword">else</span>:
        langfuse.create_score(
            value=<span class="hljs-number">0</span>,
            name=<span class="hljs-string">&quot;user-feedback&quot;</span>,
            trace_id=trace_id
        )

<span class="hljs-keyword">with</span> gr.Blocks() <span class="hljs-keyword">as</span> demo:
    chatbot = gr.Chatbot(label=<span class="hljs-string">&quot;Chat&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;messages&quot;</span>)
    prompt_box = gr.Textbox(placeholder=<span class="hljs-string">&quot;Tapez votre message...&quot;</span>, label=<span class="hljs-string">&quot;Votre message&quot;</span>)

    <span class="hljs-comment"># Lorsque l&#x27;utilisateur appuie sur &quot;Enter&quot;, nous exécutons &#x27;respond&#x27;</span>
    prompt_box.submit(
        fn=respond,
        inputs=[prompt_box, chatbot],
        outputs=chatbot
    )

    <span class="hljs-comment"># Lorsque l&#x27;utilisateur clique sur le bouton &quot;J&#x27;aime&quot; d&#x27;un message, nous exécutons &#x27;handle_like&#x27;</span>
    chatbot.like(handle_like, <span class="hljs-literal">None</span>, <span class="hljs-literal">None</span>)

demo.launch()`,wrap:!1}}),he=new J({props:{title:"5. LLM-as-a-Judge",local:"5-llm-as-a-judge",headingTag:"h4"}}),We=new y({props:{code:"JTIzJTIwRXhlbXBsZSUyMCUzQSUyMFYlQzMlQTlyaWZpZXIlMjBzaSUyMGxhJTIwc29ydGllJTIwZGUlMjBsJ2FnZW50JTIwZXN0JTIwdG94aXF1ZSUyMG91JTIwbm9uJTBBZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjAoQ29kZUFnZW50JTJDJTIwRHVja0R1Y2tHb1NlYXJjaFRvb2wlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCklMEElMEFzZWFyY2hfdG9vbCUyMCUzRCUyMER1Y2tEdWNrR29TZWFyY2hUb29sKCklMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1QnNlYXJjaF90b29sJTVEJTJDJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpKSUwQSUwQWFnZW50LnJ1biglMjJNYW5nZXIlMjBkZXMlMjBjYXJvdHRlcyUyMHBldXQtaWwlMjBhbSVDMyVBOWxpb3JlciUyMHZvdHJlJTIwdmlzaW9uJTIwJTNGJTIyKQ==",highlighted:`<span class="hljs-comment"># Exemple : Vérifier si la sortie de l&#x27;agent est toxique ou non</span>
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, DuckDuckGoSearchTool, InferenceClientModel)

search_tool = DuckDuckGoSearchTool()
agent = CodeAgent(tools=[search_tool], model=InferenceClientModel())

agent.run(<span class="hljs-string">&quot;Manger des carottes peut-il améliorer votre vision ?&quot;</span>)`,wrap:!1}}),ze=new J({props:{title:"6. Aperçu des métriques d’observabilité",local:"6-aperçu-des-métriques-dobservabilité",headingTag:"h4"}}),Qe=new J({props:{title:"Évaluation hors ligne",local:"évaluation-hors-ligne",headingTag:"h2"}}),Ae=new J({props:{title:"Évaluation d’un jeu de données",local:"évaluation-dun-jeu-de-données",headingTag:"h3"}}),Xe=new y({props:{code:"aW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQSUyMyUyMFIlQzMlQTljdXAlQzMlQTlyZXIlMjBHU004SyUyMHN1ciUyMEh1Z2dpbmclMjBGYWNlJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJvcGVuYWklMkZnc204ayUyMiUyQyUyMCdtYWluJyUyQyUyMHNwbGl0JTNEJ3RyYWluJyklMEFkZiUyMCUzRCUyMHBkLkRhdGFGcmFtZShkYXRhc2V0KSUwQXByaW50KCUyMlByZW1pJUMzJUE4cmVzJTIwbGlnbmVzJTIwZHUlMjBqZXUlMjBkZSUyMGRvbm4lQzMlQTllcyUyMEdTTThLJTIwJTNBJTIyKSUwQXByaW50KGRmLmhlYWQoKSk=",highlighted:`<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># Récupérer GSM8K sur Hugging Face</span>
dataset = load_dataset(<span class="hljs-string">&quot;openai/gsm8k&quot;</span>, <span class="hljs-string">&#x27;main&#x27;</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>)
df = pd.DataFrame(dataset)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Premières lignes du jeu de données GSM8K :&quot;</span>)
<span class="hljs-built_in">print</span>(df.head())`,wrap:!1}}),Ye=new y({props:{code:"ZnJvbSUyMGxhbmdmdXNlJTIwaW1wb3J0JTIwZ2V0X2NsaWVudCUwQWxhbmdmdXNlJTIwJTNEJTIwZ2V0X2NsaWVudCgpJTBBJTBBbGFuZ2Z1c2VfZGF0YXNldF9uYW1lJTIwJTNEJTIwJTIyZ3NtOGtfZGF0YXNldF9odWdnaW5nZmFjZSUyMiUwQSUwQSUyMyUyMENyJUMzJUE5ZXIlMjB1biUyMGpldSUyMGRlJTIwZG9ubiVDMyVBOWVzJTIwZGFucyUyMExhbmdmdXNlJTBBbGFuZ2Z1c2UuY3JlYXRlX2RhdGFzZXQoJTBBJTIwJTIwJTIwJTIwbmFtZSUzRGxhbmdmdXNlX2RhdGFzZXRfbmFtZSUyQyUwQSUyMCUyMCUyMCUyMGRlc2NyaXB0aW9uJTNEJTIySmV1JTIwZGUlMjBkb25uJUMzJUE5ZXMlMjBkZSUyMHIlQzMlQTlmJUMzJUE5cmVuY2UlMjBHU004SyUyMHQlQzMlQTlsJUMzJUE5Y2hhcmclQzMlQTklMjBkZXB1aXMlMjBIdWdnaW5nZmFjZSUyMiUyQyUwQSUyMCUyMCUyMCUyMG1ldGFkYXRhJTNEJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZGF0ZSUyMiUzQSUyMCUyMjIwMjUtMDMtMTAlMjIlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyYmVuY2htYXJrJTIyJTBBJTIwJTIwJTIwJTIwJTdEJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> langfuse <span class="hljs-keyword">import</span> get_client
langfuse = get_client()

langfuse_dataset_name = <span class="hljs-string">&quot;gsm8k_dataset_huggingface&quot;</span>

<span class="hljs-comment"># Créer un jeu de données dans Langfuse</span>
langfuse.create_dataset(
    name=langfuse_dataset_name,
    description=<span class="hljs-string">&quot;Jeu de données de référence GSM8K téléchargé depuis Huggingface&quot;</span>,
    metadata={
        <span class="hljs-string">&quot;date&quot;</span>: <span class="hljs-string">&quot;2025-03-10&quot;</span>, 
        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;benchmark&quot;</span>
    }
)`,wrap:!1}}),_e=new y({props:{code:"Zm9yJTIwaWR4JTJDJTIwcm93JTIwaW4lMjBkZi5pdGVycm93cygpJTNBJTBBJTIwJTIwJTIwJTIwbGFuZ2Z1c2UuY3JlYXRlX2RhdGFzZXRfaXRlbSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkYXRhc2V0X25hbWUlM0RsYW5nZnVzZV9kYXRhc2V0X25hbWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnB1dCUzRCU3QiUyMnRleHQlMjIlM0ElMjByb3clNUIlMjJxdWVzdGlvbiUyMiU1RCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGV4cGVjdGVkX291dHB1dCUzRCU3QiUyMnRleHQlMjIlM0ElMjByb3clNUIlMjJhbnN3ZXIlMjIlNUQlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZXRhZGF0YSUzRCU3QiUyMnNvdXJjZV9pbmRleCUyMiUzQSUyMGlkeCU3RCUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjBpZiUyMGlkeCUyMCUzRSUzRCUyMDklM0ElMjAlMjMlMjBUJUMzJUE5bCVDMyVBOWNoYXJnZXIlMjBzZXVsZW1lbnQlMjBsZXMlMjAxMCUyMHByZW1pZXJzJTIwJUMzJUE5bCVDMyVBOW1lbnRzJTIwcG91ciUyMGxhJTIwZCVDMyVBOW1vbnN0cmF0aW9uJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYnJlYWs=",highlighted:`<span class="hljs-keyword">for</span> idx, row <span class="hljs-keyword">in</span> df.iterrows():
    langfuse.create_dataset_item(
        dataset_name=langfuse_dataset_name,
        <span class="hljs-built_in">input</span>={<span class="hljs-string">&quot;text&quot;</span>: row[<span class="hljs-string">&quot;question&quot;</span>]},
        expected_output={<span class="hljs-string">&quot;text&quot;</span>: row[<span class="hljs-string">&quot;answer&quot;</span>]},
        metadata={<span class="hljs-string">&quot;source_index&quot;</span>: idx}
    )
    <span class="hljs-keyword">if</span> idx &gt;= <span class="hljs-number">9</span>: <span class="hljs-comment"># Télécharger seulement les 10 premiers éléments pour la démonstration</span>
        <span class="hljs-keyword">break</span>`,wrap:!1}}),De=new J({props:{title:"Exécution de l’agent sur le jeu de données",local:"exécution-de-lagent-sur-le-jeu-de-données",headingTag:"h4"}}),et=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> opentelemetry.trace <span class="hljs-keyword">import</span> format_trace_id
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, InferenceClientModel, LiteLLMModel)
<span class="hljs-keyword">from</span> langfuse <span class="hljs-keyword">import</span> get_client
 
langfuse = get_client()

<span class="hljs-comment"># Exemple : utiliser InferenceClientModel ou LiteLLMModel pour accéder aux modèles openai, anthropic, gemini, etc. :</span>
model = InferenceClientModel()

agent = CodeAgent(
    tools=[],
    model=model,
    add_base_tools=<span class="hljs-literal">True</span>
)

dataset_name = <span class="hljs-string">&quot;gsm8k_dataset_huggingface&quot;</span>
current_run_name = <span class="hljs-string">&quot;smolagent-notebook-run-01&quot;</span> <span class="hljs-comment"># Identifie cette exécution d&#x27;évaluation spécifique</span>
 
<span class="hljs-comment"># Supposons que &#x27;run_smolagent&#x27; est votre fonction d&#x27;application instrumentée</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_smolagent</span>(<span class="hljs-params">question</span>):
    <span class="hljs-keyword">with</span> langfuse.start_as_current_generation(name=<span class="hljs-string">&quot;qna-llm-call&quot;</span>) <span class="hljs-keyword">as</span> generation:
        <span class="hljs-comment"># Simuler un appel LLM</span>
        result = agent.run(question)
 
        <span class="hljs-comment"># Mettre à jour la trace avec l&#x27;entrée et la sortie</span>
        generation.update_trace(
            <span class="hljs-built_in">input</span>= question,
            output=result,
        )
 
        <span class="hljs-keyword">return</span> result
 
dataset = langfuse.get_dataset(name=dataset_name) <span class="hljs-comment"># Récupérer votre jeu de données pré-peuplé</span>
 
<span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> dataset.items:
 
    <span class="hljs-comment"># Utiliser le gestionnaire de contexte item.run()</span>
    <span class="hljs-keyword">with</span> item.run(
        run_name=current_run_name,
        run_metadata={<span class="hljs-string">&quot;model_provider&quot;</span>: <span class="hljs-string">&quot;Hugging Face&quot;</span>, <span class="hljs-string">&quot;temperature_setting&quot;</span>: <span class="hljs-number">0.7</span>},
        run_description=<span class="hljs-string">&quot;Exécution d&#x27;évaluation pour le jeu de données GSM8K&quot;</span>
    ) <span class="hljs-keyword">as</span> root_span: <span class="hljs-comment"># root_span est le span racine de la nouvelle trace pour cet élément et exécution.</span>
        <span class="hljs-comment"># Toutes les opérations langfuse suivantes dans ce bloc font partie de cette trace.</span>
 
        <span class="hljs-comment"># Appelez votre logique d&#x27;application</span>
        generated_answer = run_smolagent(question=item.<span class="hljs-built_in">input</span>[<span class="hljs-string">&quot;text&quot;</span>])
 
        <span class="hljs-built_in">print</span>(item.<span class="hljs-built_in">input</span>)`,wrap:!1}}),at=new J({props:{title:"Réflexions finales",local:"réflexions-finales",headingTag:"h2"}}),rt=new Bn({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/fr/bonus-unit2/monitoring-and-evaluating-agents-notebook.mdx"}}),{c(){T=i("meta"),mt=n(),Mt=i("p"),ct=n(),r(w.$$.fragment),dt=n(),r(j.$$.fragment),Jt=n(),U=i("blockquote"),U.innerHTML=rs,yt=n(),b=i("p"),b.innerHTML=Ms,Tt=n(),g=i("p"),g.textContent=ps,Ut=n(),f=i("ul"),f.innerHTML=ms,wt=n(),r(I.$$.fragment),jt=n(),v=i("p"),v.innerHTML=cs,bt=n(),C=i("p"),C.innerHTML=ds,gt=n(),h=i("p"),h.innerHTML=Js,ft=n(),r(Z.$$.fragment),It=n(),G=i("p"),G.textContent=ys,vt=n(),r(B.$$.fragment),Ct=n(),r(V.$$.fragment),ht=n(),x=i("p"),x.innerHTML=Ts,Zt=n(),W=i("p"),W.innerHTML=Us,Gt=n(),$=i("p"),$.innerHTML=ws,Bt=n(),r(E.$$.fragment),Vt=n(),z=i("p"),z.innerHTML=js,xt=n(),r(k.$$.fragment),Wt=n(),R=i("p"),R.innerHTML=bs,$t=n(),r(Q.$$.fragment),Et=n(),N=i("p"),N.innerHTML=gs,zt=n(),r(A.$$.fragment),kt=n(),r(L.$$.fragment),Rt=n(),S=i("p"),S.innerHTML=fs,Qt=n(),r(q.$$.fragment),Nt=n(),X=i("p"),X.innerHTML=Is,At=n(),H=i("p"),H.textContent=vs,Lt=n(),Y=i("p"),Y.innerHTML=Cs,St=n(),_=i("p"),_.innerHTML=hs,qt=n(),r(F.$$.fragment),Xt=n(),D=i("p"),D.innerHTML=Zs,Ht=n(),r(P.$$.fragment),Yt=n(),r(K.$$.fragment),_t=n(),O=i("p"),O.innerHTML=Gs,Ft=n(),ee=i("ul"),ee.innerHTML=Bs,Dt=n(),te=i("p"),te.innerHTML=Vs,Pt=n(),le=i("p"),le.innerHTML=xs,Kt=n(),se=i("p"),se.innerHTML=Ws,Ot=n(),r(ne.$$.fragment),el=n(),ae=i("p"),ae.textContent=$s,tl=n(),r(ie.$$.fragment),ll=n(),ue=i("ol"),ue.innerHTML=Es,sl=n(),oe=i("p"),oe.textContent=zs,nl=n(),r(re.$$.fragment),al=n(),Me=i("p"),Me.innerHTML=ks,il=n(),pe=i("p"),pe.innerHTML=Rs,ul=n(),me=i("p"),me.innerHTML=Qs,ol=n(),r(ce.$$.fragment),rl=n(),de=i("p"),de.textContent=Ns,Ml=n(),Je=i("p"),Je.innerHTML=As,pl=n(),ye=i("p"),ye.innerHTML=Ls,ml=n(),r(Te.$$.fragment),cl=n(),Ue=i("p"),Ue.innerHTML=Ss,dl=n(),r(we.$$.fragment),Jl=n(),je=i("p"),je.innerHTML=qs,yl=n(),r(be.$$.fragment),Tl=n(),ge=i("p"),ge.innerHTML=Xs,Ul=n(),fe=i("p"),fe.textContent=Hs,wl=n(),r(Ie.$$.fragment),jl=n(),ve=i("p"),ve.textContent=Ys,bl=n(),Ce=i("p"),Ce.innerHTML=_s,gl=n(),r(he.$$.fragment),fl=n(),Ze=i("p"),Ze.innerHTML=Fs,Il=n(),Ge=i("p"),Ge.innerHTML=Ds,vl=n(),Be=i("ol"),Be.innerHTML=Ps,Cl=n(),Ve=i("p"),Ve.textContent=Ks,hl=n(),xe=i("p"),xe.innerHTML=Os,Zl=n(),r(We.$$.fragment),Gl=n(),$e=i("p"),$e.textContent=en,Bl=n(),Ee=i("p"),Ee.innerHTML=tn,Vl=n(),r(ze.$$.fragment),xl=n(),ke=i("p"),ke.textContent=ln,Wl=n(),Re=i("p"),Re.innerHTML=sn,$l=n(),r(Qe.$$.fragment),El=n(),Ne=i("p"),Ne.innerHTML=nn,zl=n(),r(Ae.$$.fragment),kl=n(),Le=i("p"),Le.textContent=an,Rl=n(),Se=i("ol"),Se.innerHTML=un,Ql=n(),qe=i("p"),qe.innerHTML=on,Nl=n(),r(Xe.$$.fragment),Al=n(),He=i("p"),He.innerHTML=rn,Ll=n(),r(Ye.$$.fragment),Sl=n(),r(_e.$$.fragment),ql=n(),Fe=i("p"),Fe.innerHTML=Mn,Xl=n(),r(De.$$.fragment),Hl=n(),Pe=i("p"),Pe.innerHTML=pn,Yl=n(),Ke=i("ol"),Ke.innerHTML=mn,_l=n(),Oe=i("p"),Oe.textContent=cn,Fl=n(),r(et.$$.fragment),Dl=n(),tt=i("p"),tt.textContent=dn,Pl=n(),lt=i("ul"),lt.innerHTML=Jn,Kl=n(),st=i("p"),st.textContent=yn,Ol=n(),nt=i("p"),nt.innerHTML=Tn,es=n(),r(at.$$.fragment),ts=n(),it=i("p"),it.innerHTML=Un,ls=n(),ut=i("ol"),ut.innerHTML=wn,ss=n(),ot=i("p"),ot.textContent=jn,ns=n(),r(rt.$$.fragment),as=n(),pt=i("p"),this.h()},l(e){const t=hn("svelte-u9bgzb",document.head);T=u(t,"META",{name:!0,content:!0}),t.forEach(l),mt=a(e),Mt=u(e,"P",{}),bn(Mt).forEach(l),ct=a(e),M(w.$$.fragment,e),dt=a(e),M(j.$$.fragment,e),Jt=a(e),U=u(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(U)!=="svelte-1svf75u"&&(U.innerHTML=rs),yt=a(e),b=u(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-lybehf"&&(b.innerHTML=Ms),Tt=a(e),g=u(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-16qrkpq"&&(g.textContent=ps),Ut=a(e),f=u(e,"UL",{"data-svelte-h":!0}),o(f)!=="svelte-1h1arbq"&&(f.innerHTML=ms),wt=a(e),M(I.$$.fragment,e),jt=a(e),v=u(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1fzblhn"&&(v.innerHTML=cs),bt=a(e),C=u(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-1nlun3v"&&(C.innerHTML=ds),gt=a(e),h=u(e,"P",{"data-svelte-h":!0}),o(h)!=="svelte-w3fllb"&&(h.innerHTML=Js),ft=a(e),M(Z.$$.fragment,e),It=a(e),G=u(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-ity0ku"&&(G.textContent=ys),vt=a(e),M(B.$$.fragment,e),Ct=a(e),M(V.$$.fragment,e),ht=a(e),x=u(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-eowye6"&&(x.innerHTML=Ts),Zt=a(e),W=u(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-4n5fuh"&&(W.innerHTML=Us),Gt=a(e),$=u(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-1bg6vsc"&&($.innerHTML=ws),Bt=a(e),M(E.$$.fragment,e),Vt=a(e),z=u(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-170jlvq"&&(z.innerHTML=js),xt=a(e),M(k.$$.fragment,e),Wt=a(e),R=u(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-beqsvu"&&(R.innerHTML=bs),$t=a(e),M(Q.$$.fragment,e),Et=a(e),N=u(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-madoyk"&&(N.innerHTML=gs),zt=a(e),M(A.$$.fragment,e),kt=a(e),M(L.$$.fragment,e),Rt=a(e),S=u(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1qdntcg"&&(S.innerHTML=fs),Qt=a(e),M(q.$$.fragment,e),Nt=a(e),X=u(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-1efj51z"&&(X.innerHTML=Is),At=a(e),H=u(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-7kof4j"&&(H.textContent=vs),Lt=a(e),Y=u(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1cb993n"&&(Y.innerHTML=Cs),St=a(e),_=u(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-t25v6l"&&(_.innerHTML=hs),qt=a(e),M(F.$$.fragment,e),Xt=a(e),D=u(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1x0qldt"&&(D.innerHTML=Zs),Ht=a(e),M(P.$$.fragment,e),Yt=a(e),M(K.$$.fragment,e),_t=a(e),O=u(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-f51tlc"&&(O.innerHTML=Gs),Ft=a(e),ee=u(e,"UL",{"data-svelte-h":!0}),o(ee)!=="svelte-17u4fl8"&&(ee.innerHTML=Bs),Dt=a(e),te=u(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-16i9hdh"&&(te.innerHTML=Vs),Pt=a(e),le=u(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-yhkq5w"&&(le.innerHTML=xs),Kt=a(e),se=u(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-1a5vclt"&&(se.innerHTML=Ws),Ot=a(e),M(ne.$$.fragment,e),el=a(e),ae=u(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-jbtu0t"&&(ae.textContent=$s),tl=a(e),M(ie.$$.fragment,e),ll=a(e),ue=u(e,"OL",{"data-svelte-h":!0}),o(ue)!=="svelte-gqhp1d"&&(ue.innerHTML=Es),sl=a(e),oe=u(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-1npsh72"&&(oe.textContent=zs),nl=a(e),M(re.$$.fragment,e),al=a(e),Me=u(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-zi6mnf"&&(Me.innerHTML=ks),il=a(e),pe=u(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-dard47"&&(pe.innerHTML=Rs),ul=a(e),me=u(e,"P",{"data-svelte-h":!0}),o(me)!=="svelte-1a5vclt"&&(me.innerHTML=Qs),ol=a(e),M(ce.$$.fragment,e),rl=a(e),de=u(e,"P",{"data-svelte-h":!0}),o(de)!=="svelte-1g371w2"&&(de.textContent=Ns),Ml=a(e),Je=u(e,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-1org4pj"&&(Je.innerHTML=As),pl=a(e),ye=u(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-xazaea"&&(ye.innerHTML=Ls),ml=a(e),M(Te.$$.fragment,e),cl=a(e),Ue=u(e,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-908dc2"&&(Ue.innerHTML=Ss),dl=a(e),M(we.$$.fragment,e),Jl=a(e),je=u(e,"P",{"data-svelte-h":!0}),o(je)!=="svelte-1gx91hu"&&(je.innerHTML=qs),yl=a(e),M(be.$$.fragment,e),Tl=a(e),ge=u(e,"P",{"data-svelte-h":!0}),o(ge)!=="svelte-18xjhr3"&&(ge.innerHTML=Xs),Ul=a(e),fe=u(e,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-1ia0u96"&&(fe.textContent=Hs),wl=a(e),M(Ie.$$.fragment,e),jl=a(e),ve=u(e,"P",{"data-svelte-h":!0}),o(ve)!=="svelte-ohty0e"&&(ve.textContent=Ys),bl=a(e),Ce=u(e,"P",{"data-svelte-h":!0}),o(Ce)!=="svelte-e6ive4"&&(Ce.innerHTML=_s),gl=a(e),M(he.$$.fragment,e),fl=a(e),Ze=u(e,"P",{"data-svelte-h":!0}),o(Ze)!=="svelte-1590hso"&&(Ze.innerHTML=Fs),Il=a(e),Ge=u(e,"P",{"data-svelte-h":!0}),o(Ge)!=="svelte-sdfoo6"&&(Ge.innerHTML=Ds),vl=a(e),Be=u(e,"OL",{"data-svelte-h":!0}),o(Be)!=="svelte-1d8py7"&&(Be.innerHTML=Ps),Cl=a(e),Ve=u(e,"P",{"data-svelte-h":!0}),o(Ve)!=="svelte-ajk1n4"&&(Ve.textContent=Ks),hl=a(e),xe=u(e,"P",{"data-svelte-h":!0}),o(xe)!=="svelte-1uar592"&&(xe.innerHTML=Os),Zl=a(e),M(We.$$.fragment,e),Gl=a(e),$e=u(e,"P",{"data-svelte-h":!0}),o($e)!=="svelte-hyawqv"&&($e.textContent=en),Bl=a(e),Ee=u(e,"P",{"data-svelte-h":!0}),o(Ee)!=="svelte-zj9pt2"&&(Ee.innerHTML=tn),Vl=a(e),M(ze.$$.fragment,e),xl=a(e),ke=u(e,"P",{"data-svelte-h":!0}),o(ke)!=="svelte-sht47v"&&(ke.textContent=ln),Wl=a(e),Re=u(e,"P",{"data-svelte-h":!0}),o(Re)!=="svelte-1jemoxg"&&(Re.innerHTML=sn),$l=a(e),M(Qe.$$.fragment,e),El=a(e),Ne=u(e,"P",{"data-svelte-h":!0}),o(Ne)!=="svelte-1imslsb"&&(Ne.innerHTML=nn),zl=a(e),M(Ae.$$.fragment,e),kl=a(e),Le=u(e,"P",{"data-svelte-h":!0}),o(Le)!=="svelte-15twuau"&&(Le.textContent=an),Rl=a(e),Se=u(e,"OL",{"data-svelte-h":!0}),o(Se)!=="svelte-16qbv16"&&(Se.innerHTML=un),Ql=a(e),qe=u(e,"P",{"data-svelte-h":!0}),o(qe)!=="svelte-1t95yi7"&&(qe.innerHTML=on),Nl=a(e),M(Xe.$$.fragment,e),Al=a(e),He=u(e,"P",{"data-svelte-h":!0}),o(He)!=="svelte-1aqq29z"&&(He.innerHTML=rn),Ll=a(e),M(Ye.$$.fragment,e),Sl=a(e),M(_e.$$.fragment,e),ql=a(e),Fe=u(e,"P",{"data-svelte-h":!0}),o(Fe)!=="svelte-giwu4e"&&(Fe.innerHTML=Mn),Xl=a(e),M(De.$$.fragment,e),Hl=a(e),Pe=u(e,"P",{"data-svelte-h":!0}),o(Pe)!=="svelte-6lsq77"&&(Pe.innerHTML=pn),Yl=a(e),Ke=u(e,"OL",{"data-svelte-h":!0}),o(Ke)!=="svelte-1q8x5n1"&&(Ke.innerHTML=mn),_l=a(e),Oe=u(e,"P",{"data-svelte-h":!0}),o(Oe)!=="svelte-f6d7w3"&&(Oe.textContent=cn),Fl=a(e),M(et.$$.fragment,e),Dl=a(e),tt=u(e,"P",{"data-svelte-h":!0}),o(tt)!=="svelte-sd79jh"&&(tt.textContent=dn),Pl=a(e),lt=u(e,"UL",{"data-svelte-h":!0}),o(lt)!=="svelte-ns94uw"&&(lt.innerHTML=Jn),Kl=a(e),st=u(e,"P",{"data-svelte-h":!0}),o(st)!=="svelte-3cnt1q"&&(st.textContent=yn),Ol=a(e),nt=u(e,"P",{"data-svelte-h":!0}),o(nt)!=="svelte-ukc2vx"&&(nt.innerHTML=Tn),es=a(e),M(at.$$.fragment,e),ts=a(e),it=u(e,"P",{"data-svelte-h":!0}),o(it)!=="svelte-1r8mqsy"&&(it.innerHTML=Un),ls=a(e),ut=u(e,"OL",{"data-svelte-h":!0}),o(ut)!=="svelte-9j8n5a"&&(ut.innerHTML=wn),ss=a(e),ot=u(e,"P",{"data-svelte-h":!0}),o(ot)!=="svelte-rdnrm6"&&(ot.textContent=jn),ns=a(e),M(rt.$$.fragment,e),as=a(e),pt=u(e,"P",{}),bn(pt).forEach(l),this.h()},h(){us(T,"name","hf:doc:metadata"),us(T,"content",xn),us(U,"class","tip")},m(e,t){Zn(document.head,T),s(e,mt,t),s(e,Mt,t),s(e,ct,t),p(w,e,t),s(e,dt,t),p(j,e,t),s(e,Jt,t),s(e,U,t),s(e,yt,t),s(e,b,t),s(e,Tt,t),s(e,g,t),s(e,Ut,t),s(e,f,t),s(e,wt,t),p(I,e,t),s(e,jt,t),s(e,v,t),s(e,bt,t),s(e,C,t),s(e,gt,t),s(e,h,t),s(e,ft,t),p(Z,e,t),s(e,It,t),s(e,G,t),s(e,vt,t),p(B,e,t),s(e,Ct,t),p(V,e,t),s(e,ht,t),s(e,x,t),s(e,Zt,t),s(e,W,t),s(e,Gt,t),s(e,$,t),s(e,Bt,t),p(E,e,t),s(e,Vt,t),s(e,z,t),s(e,xt,t),p(k,e,t),s(e,Wt,t),s(e,R,t),s(e,$t,t),p(Q,e,t),s(e,Et,t),s(e,N,t),s(e,zt,t),p(A,e,t),s(e,kt,t),p(L,e,t),s(e,Rt,t),s(e,S,t),s(e,Qt,t),p(q,e,t),s(e,Nt,t),s(e,X,t),s(e,At,t),s(e,H,t),s(e,Lt,t),s(e,Y,t),s(e,St,t),s(e,_,t),s(e,qt,t),p(F,e,t),s(e,Xt,t),s(e,D,t),s(e,Ht,t),p(P,e,t),s(e,Yt,t),p(K,e,t),s(e,_t,t),s(e,O,t),s(e,Ft,t),s(e,ee,t),s(e,Dt,t),s(e,te,t),s(e,Pt,t),s(e,le,t),s(e,Kt,t),s(e,se,t),s(e,Ot,t),p(ne,e,t),s(e,el,t),s(e,ae,t),s(e,tl,t),p(ie,e,t),s(e,ll,t),s(e,ue,t),s(e,sl,t),s(e,oe,t),s(e,nl,t),p(re,e,t),s(e,al,t),s(e,Me,t),s(e,il,t),s(e,pe,t),s(e,ul,t),s(e,me,t),s(e,ol,t),p(ce,e,t),s(e,rl,t),s(e,de,t),s(e,Ml,t),s(e,Je,t),s(e,pl,t),s(e,ye,t),s(e,ml,t),p(Te,e,t),s(e,cl,t),s(e,Ue,t),s(e,dl,t),p(we,e,t),s(e,Jl,t),s(e,je,t),s(e,yl,t),p(be,e,t),s(e,Tl,t),s(e,ge,t),s(e,Ul,t),s(e,fe,t),s(e,wl,t),p(Ie,e,t),s(e,jl,t),s(e,ve,t),s(e,bl,t),s(e,Ce,t),s(e,gl,t),p(he,e,t),s(e,fl,t),s(e,Ze,t),s(e,Il,t),s(e,Ge,t),s(e,vl,t),s(e,Be,t),s(e,Cl,t),s(e,Ve,t),s(e,hl,t),s(e,xe,t),s(e,Zl,t),p(We,e,t),s(e,Gl,t),s(e,$e,t),s(e,Bl,t),s(e,Ee,t),s(e,Vl,t),p(ze,e,t),s(e,xl,t),s(e,ke,t),s(e,Wl,t),s(e,Re,t),s(e,$l,t),p(Qe,e,t),s(e,El,t),s(e,Ne,t),s(e,zl,t),p(Ae,e,t),s(e,kl,t),s(e,Le,t),s(e,Rl,t),s(e,Se,t),s(e,Ql,t),s(e,qe,t),s(e,Nl,t),p(Xe,e,t),s(e,Al,t),s(e,He,t),s(e,Ll,t),p(Ye,e,t),s(e,Sl,t),p(_e,e,t),s(e,ql,t),s(e,Fe,t),s(e,Xl,t),p(De,e,t),s(e,Hl,t),s(e,Pe,t),s(e,Yl,t),s(e,Ke,t),s(e,_l,t),s(e,Oe,t),s(e,Fl,t),p(et,e,t),s(e,Dl,t),s(e,tt,t),s(e,Pl,t),s(e,lt,t),s(e,Kl,t),s(e,st,t),s(e,Ol,t),s(e,nt,t),s(e,es,t),p(at,e,t),s(e,ts,t),s(e,it,t),s(e,ls,t),s(e,ut,t),s(e,ss,t),s(e,ot,t),s(e,ns,t),p(rt,e,t),s(e,as,t),s(e,pt,t),is=!0},p:fn,i(e){is||(m(w.$$.fragment,e),m(j.$$.fragment,e),m(I.$$.fragment,e),m(Z.$$.fragment,e),m(B.$$.fragment,e),m(V.$$.fragment,e),m(E.$$.fragment,e),m(k.$$.fragment,e),m(Q.$$.fragment,e),m(A.$$.fragment,e),m(L.$$.fragment,e),m(q.$$.fragment,e),m(F.$$.fragment,e),m(P.$$.fragment,e),m(K.$$.fragment,e),m(ne.$$.fragment,e),m(ie.$$.fragment,e),m(re.$$.fragment,e),m(ce.$$.fragment,e),m(Te.$$.fragment,e),m(we.$$.fragment,e),m(be.$$.fragment,e),m(Ie.$$.fragment,e),m(he.$$.fragment,e),m(We.$$.fragment,e),m(ze.$$.fragment,e),m(Qe.$$.fragment,e),m(Ae.$$.fragment,e),m(Xe.$$.fragment,e),m(Ye.$$.fragment,e),m(_e.$$.fragment,e),m(De.$$.fragment,e),m(et.$$.fragment,e),m(at.$$.fragment,e),m(rt.$$.fragment,e),is=!0)},o(e){c(w.$$.fragment,e),c(j.$$.fragment,e),c(I.$$.fragment,e),c(Z.$$.fragment,e),c(B.$$.fragment,e),c(V.$$.fragment,e),c(E.$$.fragment,e),c(k.$$.fragment,e),c(Q.$$.fragment,e),c(A.$$.fragment,e),c(L.$$.fragment,e),c(q.$$.fragment,e),c(F.$$.fragment,e),c(P.$$.fragment,e),c(K.$$.fragment,e),c(ne.$$.fragment,e),c(ie.$$.fragment,e),c(re.$$.fragment,e),c(ce.$$.fragment,e),c(Te.$$.fragment,e),c(we.$$.fragment,e),c(be.$$.fragment,e),c(Ie.$$.fragment,e),c(he.$$.fragment,e),c(We.$$.fragment,e),c(ze.$$.fragment,e),c(Qe.$$.fragment,e),c(Ae.$$.fragment,e),c(Xe.$$.fragment,e),c(Ye.$$.fragment,e),c(_e.$$.fragment,e),c(De.$$.fragment,e),c(et.$$.fragment,e),c(at.$$.fragment,e),c(rt.$$.fragment,e),is=!1},d(e){e&&(l(mt),l(Mt),l(ct),l(dt),l(Jt),l(U),l(yt),l(b),l(Tt),l(g),l(Ut),l(f),l(wt),l(jt),l(v),l(bt),l(C),l(gt),l(h),l(ft),l(It),l(G),l(vt),l(Ct),l(ht),l(x),l(Zt),l(W),l(Gt),l($),l(Bt),l(Vt),l(z),l(xt),l(Wt),l(R),l($t),l(Et),l(N),l(zt),l(kt),l(Rt),l(S),l(Qt),l(Nt),l(X),l(At),l(H),l(Lt),l(Y),l(St),l(_),l(qt),l(Xt),l(D),l(Ht),l(Yt),l(_t),l(O),l(Ft),l(ee),l(Dt),l(te),l(Pt),l(le),l(Kt),l(se),l(Ot),l(el),l(ae),l(tl),l(ll),l(ue),l(sl),l(oe),l(nl),l(al),l(Me),l(il),l(pe),l(ul),l(me),l(ol),l(rl),l(de),l(Ml),l(Je),l(pl),l(ye),l(ml),l(cl),l(Ue),l(dl),l(Jl),l(je),l(yl),l(Tl),l(ge),l(Ul),l(fe),l(wl),l(jl),l(ve),l(bl),l(Ce),l(gl),l(fl),l(Ze),l(Il),l(Ge),l(vl),l(Be),l(Cl),l(Ve),l(hl),l(xe),l(Zl),l(Gl),l($e),l(Bl),l(Ee),l(Vl),l(xl),l(ke),l(Wl),l(Re),l($l),l(El),l(Ne),l(zl),l(kl),l(Le),l(Rl),l(Se),l(Ql),l(qe),l(Nl),l(Al),l(He),l(Ll),l(Sl),l(ql),l(Fe),l(Xl),l(Hl),l(Pe),l(Yl),l(Ke),l(_l),l(Oe),l(Fl),l(Dl),l(tt),l(Pl),l(lt),l(Kl),l(st),l(Ol),l(nt),l(es),l(ts),l(it),l(ls),l(ut),l(ss),l(ot),l(ns),l(as),l(pt)),l(T),d(w,e),d(j,e),d(I,e),d(Z,e),d(B,e),d(V,e),d(E,e),d(k,e),d(Q,e),d(A,e),d(L,e),d(q,e),d(F,e),d(P,e),d(K,e),d(ne,e),d(ie,e),d(re,e),d(ce,e),d(Te,e),d(we,e),d(be,e),d(Ie,e),d(he,e),d(We,e),d(ze,e),d(Qe,e),d(Ae,e),d(Xe,e),d(Ye,e),d(_e,e),d(De,e),d(et,e),d(at,e),d(rt,e)}}}const xn='{"title":"Observer et évaluer des agents","local":"observer-et-évaluer-des-agents","sections":[{"title":"Prérequis de l’exercice 🏗️","local":"prérequis-de-lexercice-","sections":[],"depth":2},{"title":"Étape 0 : Installer les bibliothèques nécessaires","local":"étape-0--installer-les-bibliothèques-nécessaires","sections":[],"depth":2},{"title":"Étape 1 : Instrumenter votre agent","local":"étape-1--instrumenter-votre-agent","sections":[],"depth":2},{"title":"Étape 2 : Testez votre instrumentation","local":"étape-2--testez-votre-instrumentation","sections":[],"depth":2},{"title":"Étape 3 : Observer et évaluer un agent plus complexe","local":"étape-3--observer-et-évaluer-un-agent-plus-complexe","sections":[{"title":"Structure de la trace","local":"structure-de-la-trace","sections":[],"depth":3}],"depth":2},{"title":"Évaluation en ligne","local":"évaluation-en-ligne","sections":[{"title":"Métriques courantes à suivre en production","local":"métriques-courantes-à-suivre-en-production","sections":[{"title":"1. Coûts","local":"1-coûts","sections":[],"depth":4},{"title":"2. Temps de latence","local":"2-temps-de-latence","sections":[],"depth":4},{"title":"3. Attributs supplémentaires","local":"3-attributs-supplémentaires","sections":[],"depth":4},{"title":"4. #### 4. Retour utilisateur","local":"4--4-retour-utilisateur","sections":[],"depth":4},{"title":"5. LLM-as-a-Judge","local":"5-llm-as-a-judge","sections":[],"depth":4},{"title":"6. Aperçu des métriques d’observabilité","local":"6-aperçu-des-métriques-dobservabilité","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Évaluation hors ligne","local":"évaluation-hors-ligne","sections":[{"title":"Évaluation d’un jeu de données","local":"évaluation-dun-jeu-de-données","sections":[{"title":"Exécution de l’agent sur le jeu de données","local":"exécution-de-lagent-sur-le-jeu-de-données","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Réflexions finales","local":"réflexions-finales","sections":[],"depth":2}],"depth":1}';function Wn(os){return In(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Nn extends vn{constructor(T){super(),Cn(this,T,Wn,Vn,gn,{})}}export{Nn as component};
