import{s as ls,f as ss,n as ns,o as is}from"../chunks/scheduler.37c15a92.js";import{S as os,i as as,g as o,s as n,r as u,A as rs,h as a,f as l,c as i,j as al,u as p,x as r,k as Xe,y as qe,a as s,v as M,d,t as c,w as m}from"../chunks/index.2bf4358c.js";import{C as w}from"../chunks/CodeBlock.4e987730.js";import{C as us}from"../chunks/CourseFloatingBanner.6add7356.js";import{H as y}from"../chunks/Heading.8ada512a.js";import{E as ps}from"../chunks/getInferenceSnippets.0aa3753f.js";function Ms(rl){let T,_e,Ae,ze,f,Re,j,Se,h,ul='Comme nous l’avons exploré dans <a href="https://huggingface.co/learn/agents-course/fr/unit1/introduction" rel="nofollow">l’Unité 1</a>, les agents utilisent des outils pour effectuer diverses actions. Dans <code>smolagents</code>, les outils sont traités comme des <strong>fonctions qu’un <em>LLM</em> peut appeler au sein d’un système d’agent</strong>.',ke,b,pl="Pour interagir avec un outil, le <em>LLM</em> a besoin d’une <strong>description d’interface</strong> avec ces composants clés :",Ne,g,Ml="<li><strong>Nom</strong> : Comment l’outil s’appelle</li> <li><strong>Description de l’outil</strong> : Ce que fait l’outil</li> <li><strong>Types et descriptions des entrées</strong> : Quels arguments l’outil accepte</li> <li><strong>Type de sortie</strong> : Ce que l’outil retourne</li>",Fe,I,dl="Par exemple, pendant qu’il se prépare pour une fête au manoir Wayne, Alfred a besoin de divers outils pour recueillir des informations : de la recherche de services de traiteur à la recherche d’idées de thèmes de fête. Voici à quoi pourrait ressembler l’interface d’un simple outil de recherche :",Le,v,cl="<li><strong>Nom :</strong> <code>web_search</code></li> <li><strong>Description de l’outil :</strong> Recherche sur le web des requêtes spécifiques</li> <li><strong>Entrée :</strong> <code>query</code> (string) - Le terme de recherche à rechercher</li> <li><strong>Sortie :</strong> String contenant les résultats de recherche</li>",Ye,C,ml="En utilisant ces outils, Alfred peut prendre des décisions éclairées et rassembler toutes les informations nécessaires pour planifier la fête parfaite.",Pe,B,yl="Ci-dessous, vous pouvez voir une animation illustrant comment un appel d’outil est géré :",De,G,Jl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/Agent_ManimCE.gif" alt="Pipeline agentique de https://huggingface.co/docs/smolagents/conceptual_guides/react"/>',Ke,Z,Oe,V,Tl="Dans <code>smolagents</code>, les outils peuvent être définis de deux façons :",et,x,Ul="<li><strong>En utilisant le décorateur <code>@tool</code></strong> pour des outils simples basés sur des fonctions</li> <li><strong>En créant une sous-classe de <code>Tool</code></strong> pour des fonctionnalités plus complexes</li>",tt,W,lt,$,wl="Le décorateur <code>@tool</code> est la <strong>méthode recommandée pour définir des outils simples</strong>. Sous le capot, <code>smolagents</code> analysera les informations de base sur la fonction à partir de Python. Donc si vous nommez votre fonction clairement et écrivez une bonne <em>docstring</em>, il sera plus facile pour le <em>LLM</em> de l’utiliser.",st,Q,fl="En utilisant cette approche, nous définissons une fonction avec :",nt,E,jl="<li><strong>Un nom de fonction clair et descriptif</strong> qui aide le <em>LLM</em> à comprendre son objectif.</li> <li><strong>Des indications de type pour les entrées et les sorties</strong> pour assurer une utilisation correcte.</li> <li><strong>Une description détaillée</strong>, incluant une section <code>Args:</code> où chaque argument est explicitement décrit. Ces descriptions fournissent un contexte précieux pour le <em>LLM</em>, il est donc important de les écrire soigneusement.</li>",it,A,ot,H,hl,at,U,bl='<p>Vous pouvez suivre le code dans <a href="https://huggingface.co/agents-course/notebooks/blob/main/fr/unit2/smolagents/tools.ipynb" target="_blank">ce <i>notebook</i></a> que vous pouvez exécuter avec Google Colab.</p>',rt,X,gl="Imaginons qu’Alfred ait déjà décidé du menu pour la fête, mais qu’il ait maintenant besoin d’aide pour préparer la nourriture pour un si grand nombre d’invités. Pour ce faire, il aimerait engager un service de traiteur et doit identifier les options les mieux notées disponibles. Alfred peut utiliser un outil pour rechercher les meilleurs services de traiteur proche de chez lui.",ut,q,Il="Voici un exemple de la façon dont Alfred peut utiliser le décorateur <code>@tool</code> pour y parvenir :",pt,_,Mt,z,dt,R,vl='Cette approche implique de créer une sous-classe de <a href="https://huggingface.co/docs/smolagents/v1.8.1/en/reference/tools#smolagents.Tool" rel="nofollow"><code>Tool</code></a>. Pour des outils complexes, nous pouvons implémenter une classe au lieu d’une fonction Python. La classe encapsule la fonction avec des métadonnées qui aident le <em>LLM</em> à comprendre comment l’utiliser efficacement. Dans cette classe, nous définissons :',ct,S,Cl="<li><code>name</code> : Le nom de l’outil.</li> <li><code>description</code> : Une description utilisée pour remplir le prompt système de l’agent.</li> <li><code>inputs</code> : Un dictionnaire avec les clés <code>type</code> et <code>description</code>, fournissant des informations pour aider l’interpréteur Python à traiter les entrées.</li> <li><code>output_type</code> : Spécifie le type de sortie attendu.</li> <li><code>forward</code> : La méthode contenant la logique d’inférence à exécuter.</li>",mt,k,Bl="Ci-dessous, nous pouvons voir un exemple d’un outil construit en utilisant <code>Tool</code> et comment l’intégrer dans un <code>CodeAgent</code>.",yt,N,Jt,F,Gl="La fête d’Alfred au manoir est un <strong>événement à thème portant sur les super-héros</strong>, mais il a besoin d’idées créatives pour la rendre vraiment spéciale. En tant qu’hôte fantastique, il veut surprendre les invités avec un thème unique.",Tt,L,Zl="Pour ce faire, il peut utiliser un agent qui génère des idées de fêtes sur le thème des super-héros en fonction d’une catégorie donnée. De cette façon, Alfred peut trouver le thème de fête parfait pour épater ses invités.",Ut,Y,wt,P,Vl="Avec cet outil, Alfred sera le super hôte par excellence, impressionnant ses invités avec une fête sur le thème des super-héros qu’ils n’oublieront pas ! 🦸‍♂️🦸‍♀️",ft,D,jt,K,xl='<code>smolagents</code> est livré avec un ensemble d’outils pré-construits qui peuvent être directement injectés dans votre agent. La <a href="https://huggingface.co/docs/smolagents/guided_tour?build-a-tool=Decorate+a+function+with+%40tool#default-toolbox" rel="nofollow">boîte à outils par défaut</a> comprend :',ht,O,Wl="<li><strong>PythonInterpreterTool</strong></li> <li><strong>FinalAnswerTool</strong></li> <li><strong>UserInputTool</strong></li> <li><strong>DuckDuckGoSearchTool</strong></li> <li><strong>GoogleSearchTool</strong></li> <li><strong>VisitWebpageTool</strong></li>",bt,ee,$l="Alfred peut utiliser divers outils pour assurer une fête parfaite au manoir Wayne :",gt,te,Ql="<li><p>D’abord, il pourrait utiliser le <code>DuckDuckGoSearchTool</code> pour trouver des idées créatives de fête sur le thème des super-héros.</p></li> <li><p>Pour le traiteur, il se fierait au <code>GoogleSearchTool</code> pour trouver les services les mieux notés à Gotham.</p></li> <li><p>Pour gérer la disposition des tables, Alfred pourrait effectuer des calculs avec l’outil <code>PythonInterpreterTool</code>.</p></li> <li><p>Une fois que tout est rassemblé, il compilerait le plan en utilisant  <code>FinalAnswerTool</code>.</p></li>",It,le,El="Grâce à ces outils, Alfred garantit que la fête sera à la fois exceptionnelle et harmonieuse. 🦇💡",vt,se,Ct,ne,Al="L’une des fonctionnalités les plus puissantes de <code>smolagents</code> est sa capacité à partager des outils personnalisés sur le Hub et à intégrer de manière transparente des outils créés par la communauté. Cela inclut la connexion avec les <strong>Spaces</strong> d’Hugging Face et les <strong>outils LangChain</strong>, améliorant considérablement la capacité d’Alfred à orchestrer une fête inoubliable. 🎭",Bt,ie,Hl="Avec ces intégrations, Alfred peut exploiter des outils avancés de planification d’événements ; qu’il s’agisse d’ajuster l’éclairage pour l’ambiance parfaite, de créer la <em>playlist</em> idéale pour la fête, ou de coordonner avec les meilleurs traiteurs de Gotham.",Gt,oe,Xl="Voici des exemples montrant comment ces fonctionnalités peuvent améliorer l’expérience de la fête :",Zt,ae,Vt,re,ql="Partager votre outil personnalisé avec la communauté est facile ! Il suffit de le télécharger sur votre compte Hugging Face en utilisant la méthode <code>push_to_hub()</code>.",xt,ue,_l="Par exemple, Alfred peut partager son <code>party_theme_tool</code> pour aider les autres à trouver les meilleurs services de traiteur à Gotham. Voici comment faire :",Wt,pe,$t,Me,Qt,de,zl="Vous pouvez facilement importer des outils créés par d’autres utilisateurs en utilisant la fonction <code>load_tool()</code>. Par exemple, Alfred pourrait vouloir générer une image promotionnelle pour la fête en utilisant l’IA. Au lieu de construire un outil à partir de zéro, il peut exploiter un outil prédéfini de la communauté :",Et,ce,At,me,Ht,ye,Rl="Vous pouvez également importer un <em>Space</em> comme outil en utilisant <code>Tool.from_space()</code>. Cela ouvre des possibilités d’intégration avec des milliers de <em>Spaces</em> de la communauté pour des tâches allant de la génération d’images à l’analyse de données.",Xt,Je,Sl="L’outil se connectera au <em>backend Gradio</em> des <em>Spaces</em> en utilisant le <code>gradio_client</code>, alors assurez-vous de l’installer via <code>pip</code> si vous ne l’avez pas déjà fait.",qt,Te,kl="Pour la fête, Alfred peut utiliser un <em>Space</em> existant pour la génération de l’image générée par IA à utiliser comme invitation (au lieu de l’outil pré-construit que nous avons mentionné précédemment). Construisons-le !",_t,Ue,zt,we,Rt,fe,Nl="Nous discuterons du <em>framework</em> <code>LangChain</code> dans les sections à venir. Pour l’instant, nous notons simplement que nous pouvons réutiliser des outils LangChain dans votre <em>workflow</em> <code>smolagents</code> !",St,je,Fl="Vous pouvez facilement charger des outils LangChain en utilisant la méthode <code>Tool.from_langchain()</code>. Alfred, toujours aussi perfectionniste, prépare une spectaculaire soirée de super-héros au manoir pendant l’absence des Wayne. Pour s’assurer que chaque détail dépasse les attentes, il utilise les outils LangChain pour trouver des idées de divertissement de premier ordre.",kt,he,Ll="En utilisant <code>Tool.from_langchain()</code>, Alfred ajoute sans effort des fonctionnalités de recherche avancées à son agent, lui permettant de découvrir des idées et services de fête exclusifs avec seulement quelques commandes.",Nt,be,Yl="Voici comment il procède :",Ft,ge,Lt,Ie,Yt,ve,Pl='<code>smolagents</code> permet également d’importer des outils depuis les centaines de serveurs MCP disponibles sur <a href="https://glama.ai/mcp/servers" rel="nofollow">glama.ai</a> ou <a href="https://smithery.ai" rel="nofollow">smithery.ai</a>. Si vous voulez approfondir le MCP, vous pouvez consulter notre <a href="https://huggingface.co/learn/mcp-course/" rel="nofollow">cours gratuit</a>.',Pt,J,$e,Dl="Installer le client mcp",il,Qe,Kl="Nous devons d’abord installer l’intégration <code>mcp</code> pour <code>smolagents</code>.",ol,Ce,Dt,Be,Ol="Les outils des serveurs MCP peuvent être chargés dans un objet <code>ToolCollection</code> comme suit :",Kt,Ge,Ot,Ze,es="Grâce à cette configuration, Alfred peut rapidement découvrir des options de divertissement luxueuses et s’assurer que les invités de l’élite de Gotham vivent une expérience inoubliable. Cet outil l’aide à organiser l’événement parfait sur le thème des super-héros ! 🎉",el,Ve,tl,xe,ts='<li><a href="https://huggingface.co/docs/smolagents/tutorials/tools" rel="nofollow">Tutoriel sur les outils</a> - Explorez ce tutoriel pour apprendre à travailler efficacement avec les outils.</li> <li><a href="https://huggingface.co/docs/smolagents/v1.8.1/en/reference/tools" rel="nofollow">Documentation sur les outils</a> - Documentation de référence complète sur les outils.</li> <li><a href="https://huggingface.co/docs/smolagents/v1.8.1/en/guided_tour#tools" rel="nofollow">Visite guidée des outils</a> - Une visite guidée étape par étape pour vous aider à construire et utiliser efficacement les outils.</li> <li><a href="https://huggingface.co/docs/smolagents/tutorials/building_good_agents" rel="nofollow">Construire des agents efficaces</a> - Un guide détaillé sur les meilleures pratiques pour développer des agents de fonctions personnalisées fiables et performants.</li>',ll,We,sl,He,nl;return f=new us({props:{classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/#fileId=https://huggingface.co/agents-course/notebooks/blob/main/fr/unit2/smolagents/tools.ipynb"}],askForHelpUrl:"http://hf.co/join/discord"}}),j=new y({props:{title:"Outils",local:"outils",headingTag:"h1"}}),Z=new y({props:{title:"Méthodes de création d’outils",local:"méthodes-de-création-doutils",headingTag:"h2"}}),W=new y({props:{title:"Le décorateur @tool",local:"le-décorateur-tool",headingTag:"h3"}}),A=new y({props:{title:"Générer un outil qui récupère le service de traiteur le mieux noté",local:"générer-un-outil-qui-récupère-le-service-de-traiteur-le-mieux-noté",headingTag:"h4"}}),_=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel, tool

<span class="hljs-comment"># Supposons que nous ayons une fonction qui recherche les services de restauration les mieux notés</span>
<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">catering_service_tool</span>(<span class="hljs-params">query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Cet outil retourne le service de traiteur le mieux noté à Gotham City.

    Args:
        query: Un terme de recherche pour trouver des services de traiteur.
    &quot;&quot;&quot;</span>
    <span class="hljs-comment"># Exemple de liste de services de traiteur et leurs notes</span>
    services = {
        <span class="hljs-string">&quot;Gotham Catering Co.&quot;</span>: <span class="hljs-number">4.9</span>,
        <span class="hljs-string">&quot;Wayne Manor Catering&quot;</span>: <span class="hljs-number">4.8</span>,
        <span class="hljs-string">&quot;Gotham City Events&quot;</span>: <span class="hljs-number">4.7</span>,
    }

    <span class="hljs-comment"># Trouver le service de traiteur le mieux noté (simulation du filtrage de requête de recherche)</span>
    best_service = <span class="hljs-built_in">max</span>(services, key=services.get)

    <span class="hljs-keyword">return</span> best_service


agent = CodeAgent(tools=[catering_service_tool], model=InferenceClientModel())

<span class="hljs-comment"># Exécuter l&#x27;agent pour trouver le meilleur service de traiteur</span>
result = agent.run(
    <span class="hljs-string">&quot;Can you give me the name of the highest-rated catering service in Gotham City?&quot;</span>
)

<span class="hljs-built_in">print</span>(result)   <span class="hljs-comment"># Sortie : Gotham Catering Co.</span>`,wrap:!1}}),z=new y({props:{title:"Définir un outil comme une classe Python",local:"définir-un-outil-comme-une-classe-python",headingTag:"h3"}}),N=new y({props:{title:"Générer un outil pour générer des idées pour une fête sur le thème des super-héros",local:"générer-un-outil-pour-générer-des-idées-pour-une-fête-sur-le-thème-des-super-héros",headingTag:"h4"}}),Y=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool, CodeAgent, InferenceClientModel

<span class="hljs-keyword">class</span> <span class="hljs-title class_">SuperheroPartyThemeTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;superhero_party_theme_generator&quot;</span>
    description = <span class="hljs-string">&quot;&quot;&quot;
    Cet outil propose des idées de fêtes créatives sur le thème des super-héros en fonction d&#x27;une catégorie.
    Il retourne une idée de thème de fête unique.&quot;&quot;&quot;</span>

    inputs = {
        <span class="hljs-string">&quot;category&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Le type de fête de super-héros (par exemple, &#x27;classic heroes&#x27;, &#x27;villain masquerade&#x27;, &#x27;futuristic Gotham&#x27;).&quot;</span>,
        }
    }

    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, category: <span class="hljs-built_in">str</span></span>):
        themes = {
            <span class="hljs-string">&quot;classic heroes&quot;</span>: <span class="hljs-string">&quot;Justice League Gala : Les invités viennent habillés en leurs héros DC préférés avec des cocktails à thème comme &#x27;The Kryptonite Punch&#x27;.&quot;</span>,
            <span class="hljs-string">&quot;villain masquerade&quot;</span>: <span class="hljs-string">&quot;Gotham Rogues&#x27; Ball : Un bal masqué mystérieux où les invités s&#x27;habillent en méchants classiques de Batman.&quot;</span>,
            <span class="hljs-string">&quot;futuristic Gotham&quot;</span>: <span class="hljs-string">&quot;Neo-Gotham Night : Une fête de style cyberpunk inspirée de Batman Beyond, avec des décorations néon et des gadgets futuristes.&quot;</span>
        }

        <span class="hljs-keyword">return</span> themes.get(category.lower(), <span class="hljs-string">&quot;Idée de fête à thème non trouvée. Essayez &#x27;classic heroes&#x27;, &#x27;villain masquerade&#x27;, ou &#x27;futuristic Gotham&#x27;.&quot;</span>)

<span class="hljs-comment"># Instancier l&#x27;outil</span>
party_theme_tool = SuperheroPartyThemeTool()
agent = CodeAgent(tools=[party_theme_tool], model=InferenceClientModel())

<span class="hljs-comment"># Exécuter l&#x27;agent pour générer une idée de thème de fête</span>
result = agent.run(
    <span class="hljs-string">&quot;What would be a good superhero party idea for a &#x27;villain masquerade&#x27; theme?&quot;</span>
)

<span class="hljs-built_in">print</span>(result)  <span class="hljs-comment"># Sortie : &quot;Gotham Rogues&#x27; Ball : Un bal masqué mystérieux où les invités s&#x27;habillent en méchants classiques de Batman.&quot;</span>`,wrap:!1}}),D=new y({props:{title:"Boîte à outils par défaut",local:"boîte-à-outils-par-défaut",headingTag:"h2"}}),se=new y({props:{title:"Partage et importation d’outils",local:"partage-et-importation-doutils",headingTag:"h2"}}),ae=new y({props:{title:"Partager un outil sur le Hub",local:"partager-un-outil-sur-le-hub",headingTag:"h3"}}),pe=new w({props:{code:"cGFydHlfdGhlbWVfdG9vbC5wdXNoX3RvX2h1YiglMjIlN0J5b3VyX3VzZXJuYW1lJTdEJTJGcGFydHlfdGhlbWVfdG9vbCUyMiUyQyUyMHRva2VuJTNEJTIyJTNDWU9VUl9IVUdHSU5HRkFDRUhVQl9BUElfVE9LRU4lM0UlMjIp",highlighted:'party_theme_tool.push_to_hub(<span class="hljs-string">&quot;{your_username}/party_theme_tool&quot;</span>, token=<span class="hljs-string">&quot;&lt;YOUR_HUGGINGFACEHUB_API_TOKEN&gt;&quot;</span>)',wrap:!1}}),Me=new y({props:{title:"Importer un outil depuis le Hub",local:"importer-un-outil-depuis-le-hub",headingTag:"h3"}}),ce=new w({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2wlMkMlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQWltYWdlX2dlbmVyYXRpb25fdG9vbCUyMCUzRCUyMGxvYWRfdG9vbCglMEElMjAlMjAlMjAlMjAlMjJtLXJpYyUyRnRleHQtdG8taW1hZ2UlMjIlMkMlMEElMjAlMjAlMjAlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMEEpJTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUJpbWFnZV9nZW5lcmF0aW9uX3Rvb2wlNUQlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzREluZmVyZW5jZUNsaWVudE1vZGVsKCklMEEpJTBBJTBBYWdlbnQucnVuKCUyMkdlbmVyYXRlJTIwYW4lMjBpbWFnZSUyMG9mJTIwYSUyMGx1eHVyaW91cyUyMHN1cGVyaGVyby10aGVtZWQlMjBwYXJ0eSUyMGF0JTIwV2F5bmUlMjBNYW5vciUyMHdpdGglMjBtYWRlLXVwJTIwc3VwZXJoZXJvcy4lMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> load_tool, CodeAgent, InferenceClientModel

image_generation_tool = load_tool(
    <span class="hljs-string">&quot;m-ric/text-to-image&quot;</span>,
    trust_remote_code=<span class="hljs-literal">True</span>
)

agent = CodeAgent(
    tools=[image_generation_tool],
    model=InferenceClientModel()
)

agent.run(<span class="hljs-string">&quot;Generate an image of a luxurious superhero-themed party at Wayne Manor with made-up superheros.&quot;</span>)`,wrap:!1}}),me=new y({props:{title:"Importer un Space comme outil",local:"importer-un-space-comme-outil",headingTag:"h3"}}),Ue=new w({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMFRvb2wlMEElMEFpbWFnZV9nZW5lcmF0aW9uX3Rvb2wlMjAlM0QlMjBUb29sLmZyb21fc3BhY2UoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtc2NobmVsbCUyMiUyQyUwQSUyMCUyMCUyMCUyMG5hbWUlM0QlMjJpbWFnZV9nZW5lcmF0b3IlMjIlMkMlMEElMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUzRCUyMkdlbmVyYXRlJTIwYW4lMjBpbWFnZSUyMGZyb20lMjBhJTIwcHJvbXB0JTIyJTBBKSUwQSUwQW1vZGVsJTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwoJTIyUXdlbiUyRlF3ZW4yLjUtQ29kZXItMzJCLUluc3RydWN0JTIyKSUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCaW1hZ2VfZ2VuZXJhdGlvbl90b29sJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCklMEElMEFhZ2VudC5ydW4oJTBBJTIwJTIwJTIwJTIwJTIySW1wcm92ZSUyMHRoaXMlMjBwcm9tcHQlMkMlMjB0aGVuJTIwZ2VuZXJhdGUlMjBhbiUyMGltYWdlJTIwb2YlMjBpdC4lMjIlMkMlMEElMjAlMjAlMjAlMjBhZGRpdGlvbmFsX2FyZ3MlM0QlN0IndXNlcl9wcm9tcHQnJTNBJTIwJ0ElMjBncmFuZCUyMHN1cGVyaGVyby10aGVtZWQlMjBwYXJ0eSUyMGF0JTIwV2F5bmUlMjBNYW5vciUyQyUyMHdpdGglMjBBbGZyZWQlMjBvdmVyc2VlaW5nJTIwYSUyMGx1eHVyaW91cyUyMGdhbGEnJTdEJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel, Tool

image_generation_tool = Tool.from_space(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>,
    name=<span class="hljs-string">&quot;image_generator&quot;</span>,
    description=<span class="hljs-string">&quot;Generate an image from a prompt&quot;</span>
)

model = InferenceClientModel(<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)

agent = CodeAgent(tools=[image_generation_tool], model=model)

agent.run(
    <span class="hljs-string">&quot;Improve this prompt, then generate an image of it.&quot;</span>,
    additional_args={<span class="hljs-string">&#x27;user_prompt&#x27;</span>: <span class="hljs-string">&#x27;A grand superhero-themed party at Wayne Manor, with Alfred overseeing a luxurious gala&#x27;</span>}
)`,wrap:!1}}),we=new y({props:{title:"Importer un outil LangChain",local:"importer-un-outil-langchain",headingTag:"h3"}}),ge=new w({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5hZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2xzJTBBZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMFRvb2wlMEElMEFzZWFyY2hfdG9vbCUyMCUzRCUyMFRvb2wuZnJvbV9sYW5nY2hhaW4obG9hZF90b29scyglNUIlMjJzZXJwYXBpJTIyJTVEKSU1QjAlNUQpJTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUJzZWFyY2hfdG9vbCU1RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBJTBBYWdlbnQucnVuKCUyMlNlYXJjaCUyMGZvciUyMGx1eHVyeSUyMGVudGVydGFpbm1lbnQlMjBpZGVhcyUyMGZvciUyMGElMjBzdXBlcmhlcm8tdGhlbWVkJTIwZXZlbnQlMkMlMjBzdWNoJTIwYXMlMjBsaXZlJTIwcGVyZm9ybWFuY2VzJTIwYW5kJTIwaW50ZXJhY3RpdmUlMjBleHBlcmllbmNlcy4lMjIp",highlighted:`<span class="hljs-keyword">from</span> langchain.agents <span class="hljs-keyword">import</span> load_tools
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel, Tool

search_tool = Tool.from_langchain(load_tools([<span class="hljs-string">&quot;serpapi&quot;</span>])[<span class="hljs-number">0</span>])

agent = CodeAgent(tools=[search_tool], model=model)

agent.run(<span class="hljs-string">&quot;Search for luxury entertainment ideas for a superhero-themed event, such as live performances and interactive experiences.&quot;</span>)`,wrap:!1}}),Ie=new y({props:{title:"Importer une collection d’outils depuis n’importe quel serveur MCP",local:"importer-une-collection-doutils-depuis-nimporte-quel-serveur-mcp",headingTag:"h3"}}),Ce=new w({props:{code:"cGlwJTIwaW5zdGFsbCUyMCUyMnNtb2xhZ2VudHMlNUJtY3AlNUQlMjI=",highlighted:'pip install <span class="hljs-string">&quot;smolagents[mcp]&quot;</span>',wrap:!1}}),Ge=new w({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwc21vbGFnZW50cyUyMGltcG9ydCUyMFRvb2xDb2xsZWN0aW9uJTJDJTIwQ29kZUFnZW50JTBBZnJvbSUyMG1jcCUyMGltcG9ydCUyMFN0ZGlvU2VydmVyUGFyYW1ldGVycyUwQWZyb20lMjBzbW9sYWdlbnRzJTIwaW1wb3J0JTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwlMEElMEElMEFtb2RlbCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudE1vZGVsKCUyMlF3ZW4lMkZRd2VuMi41LUNvZGVyLTMyQi1JbnN0cnVjdCUyMiklMEElMEElMEFzZXJ2ZXJfcGFyYW1ldGVycyUyMCUzRCUyMFN0ZGlvU2VydmVyUGFyYW1ldGVycyglMEElMjAlMjAlMjAlMjBjb21tYW5kJTNEJTIydXZ4JTIyJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRCU1QiUyMi0tcXVpZXQlMjIlMkMlMjAlMjJwdWJtZWRtY3AlNDAwLjEuMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGVudiUzRCU3QiUyMlVWX1BZVEhPTiUyMiUzQSUyMCUyMjMuMTIlMjIlMkMlMjAqKm9zLmVudmlyb24lN0QlMkMlMEEpJTBBJTBBd2l0aCUyMFRvb2xDb2xsZWN0aW9uLmZyb21fbWNwKHNlcnZlcl9wYXJhbWV0ZXJzJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKSUyMGFzJTIwdG9vbF9jb2xsZWN0aW9uJTNBJTBBJTIwJTIwJTIwJTIwYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIqdG9vbF9jb2xsZWN0aW9uLnRvb2xzJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZmluZCUyMGElMjByZW1lZHklMjBmb3IlMjBoYW5nb3Zlci4lMjIp",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent
<span class="hljs-keyword">from</span> mcp <span class="hljs-keyword">import</span> StdioServerParameters
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel


model = InferenceClientModel(<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)


server_parameters = StdioServerParameters(
    command=<span class="hljs-string">&quot;uvx&quot;</span>,
    args=[<span class="hljs-string">&quot;--quiet&quot;</span>, <span class="hljs-string">&quot;pubmedmcp@0.1.3&quot;</span>],
    env={<span class="hljs-string">&quot;UV_PYTHON&quot;</span>: <span class="hljs-string">&quot;3.12&quot;</span>, **os.environ},
)

<span class="hljs-keyword">with</span> ToolCollection.from_mcp(server_parameters, trust_remote_code=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> tool_collection:
    agent = CodeAgent(tools=[*tool_collection.tools], model=model, add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please find a remedy for hangover.&quot;</span>)`,wrap:!1}}),Ve=new y({props:{title:"Ressources",local:"ressources",headingTag:"h2"}}),We=new ps({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/fr/unit2/smolagents/tools.mdx"}}),{c(){T=o("meta"),_e=n(),Ae=o("p"),ze=n(),u(f.$$.fragment),Re=n(),u(j.$$.fragment),Se=n(),h=o("p"),h.innerHTML=ul,ke=n(),b=o("p"),b.innerHTML=pl,Ne=n(),g=o("ul"),g.innerHTML=Ml,Fe=n(),I=o("p"),I.textContent=dl,Le=n(),v=o("ul"),v.innerHTML=cl,Ye=n(),C=o("p"),C.textContent=ml,Pe=n(),B=o("p"),B.textContent=yl,De=n(),G=o("p"),G.innerHTML=Jl,Ke=n(),u(Z.$$.fragment),Oe=n(),V=o("p"),V.innerHTML=Tl,et=n(),x=o("ol"),x.innerHTML=Ul,tt=n(),u(W.$$.fragment),lt=n(),$=o("p"),$.innerHTML=wl,st=n(),Q=o("p"),Q.textContent=fl,nt=n(),E=o("ul"),E.innerHTML=jl,it=n(),u(A.$$.fragment),ot=n(),H=o("img"),at=n(),U=o("blockquote"),U.innerHTML=bl,rt=n(),X=o("p"),X.textContent=gl,ut=n(),q=o("p"),q.innerHTML=Il,pt=n(),u(_.$$.fragment),Mt=n(),u(z.$$.fragment),dt=n(),R=o("p"),R.innerHTML=vl,ct=n(),S=o("ul"),S.innerHTML=Cl,mt=n(),k=o("p"),k.innerHTML=Bl,yt=n(),u(N.$$.fragment),Jt=n(),F=o("p"),F.innerHTML=Gl,Tt=n(),L=o("p"),L.textContent=Zl,Ut=n(),u(Y.$$.fragment),wt=n(),P=o("p"),P.textContent=Vl,ft=n(),u(D.$$.fragment),jt=n(),K=o("p"),K.innerHTML=xl,ht=n(),O=o("ul"),O.innerHTML=Wl,bt=n(),ee=o("p"),ee.textContent=$l,gt=n(),te=o("ul"),te.innerHTML=Ql,It=n(),le=o("p"),le.textContent=El,vt=n(),u(se.$$.fragment),Ct=n(),ne=o("p"),ne.innerHTML=Al,Bt=n(),ie=o("p"),ie.innerHTML=Hl,Gt=n(),oe=o("p"),oe.textContent=Xl,Zt=n(),u(ae.$$.fragment),Vt=n(),re=o("p"),re.innerHTML=ql,xt=n(),ue=o("p"),ue.innerHTML=_l,Wt=n(),u(pe.$$.fragment),$t=n(),u(Me.$$.fragment),Qt=n(),de=o("p"),de.innerHTML=zl,Et=n(),u(ce.$$.fragment),At=n(),u(me.$$.fragment),Ht=n(),ye=o("p"),ye.innerHTML=Rl,Xt=n(),Je=o("p"),Je.innerHTML=Sl,qt=n(),Te=o("p"),Te.innerHTML=kl,_t=n(),u(Ue.$$.fragment),zt=n(),u(we.$$.fragment),Rt=n(),fe=o("p"),fe.innerHTML=Nl,St=n(),je=o("p"),je.innerHTML=Fl,kt=n(),he=o("p"),he.innerHTML=Ll,Nt=n(),be=o("p"),be.textContent=Yl,Ft=n(),u(ge.$$.fragment),Lt=n(),u(Ie.$$.fragment),Yt=n(),ve=o("p"),ve.innerHTML=Pl,Pt=n(),J=o("details"),$e=o("summary"),$e.textContent=Dl,il=n(),Qe=o("p"),Qe.innerHTML=Kl,ol=n(),u(Ce.$$.fragment),Dt=n(),Be=o("p"),Be.innerHTML=Ol,Kt=n(),u(Ge.$$.fragment),Ot=n(),Ze=o("p"),Ze.textContent=es,el=n(),u(Ve.$$.fragment),tl=n(),xe=o("ul"),xe.innerHTML=ts,ll=n(),u(We.$$.fragment),sl=n(),He=o("p"),this.h()},l(e){const t=rs("svelte-u9bgzb",document.head);T=a(t,"META",{name:!0,content:!0}),t.forEach(l),_e=i(e),Ae=a(e,"P",{}),al(Ae).forEach(l),ze=i(e),p(f.$$.fragment,e),Re=i(e),p(j.$$.fragment,e),Se=i(e),h=a(e,"P",{"data-svelte-h":!0}),r(h)!=="svelte-xa76i8"&&(h.innerHTML=ul),ke=i(e),b=a(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-8iw59w"&&(b.innerHTML=pl),Ne=i(e),g=a(e,"UL",{"data-svelte-h":!0}),r(g)!=="svelte-18p9ky2"&&(g.innerHTML=Ml),Fe=i(e),I=a(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-65o2d2"&&(I.textContent=dl),Le=i(e),v=a(e,"UL",{"data-svelte-h":!0}),r(v)!=="svelte-fn7bfx"&&(v.innerHTML=cl),Ye=i(e),C=a(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-akaqns"&&(C.textContent=ml),Pe=i(e),B=a(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-54238e"&&(B.textContent=yl),De=i(e),G=a(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-x4dds9"&&(G.innerHTML=Jl),Ke=i(e),p(Z.$$.fragment,e),Oe=i(e),V=a(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-hcuhdx"&&(V.innerHTML=Tl),et=i(e),x=a(e,"OL",{"data-svelte-h":!0}),r(x)!=="svelte-1do2zv8"&&(x.innerHTML=Ul),tt=i(e),p(W.$$.fragment,e),lt=i(e),$=a(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-157it"&&($.innerHTML=wl),st=i(e),Q=a(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-rsnl86"&&(Q.textContent=fl),nt=i(e),E=a(e,"UL",{"data-svelte-h":!0}),r(E)!=="svelte-1kjfrrb"&&(E.innerHTML=jl),it=i(e),p(A.$$.fragment,e),ot=i(e),H=a(e,"IMG",{src:!0,alt:!0}),at=i(e),U=a(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(U)!=="svelte-76fzs1"&&(U.innerHTML=bl),rt=i(e),X=a(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1n7syy1"&&(X.textContent=gl),ut=i(e),q=a(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-ij0502"&&(q.innerHTML=Il),pt=i(e),p(_.$$.fragment,e),Mt=i(e),p(z.$$.fragment,e),dt=i(e),R=a(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-p9b8bg"&&(R.innerHTML=vl),ct=i(e),S=a(e,"UL",{"data-svelte-h":!0}),r(S)!=="svelte-1ar2z8v"&&(S.innerHTML=Cl),mt=i(e),k=a(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1krrphr"&&(k.innerHTML=Bl),yt=i(e),p(N.$$.fragment,e),Jt=i(e),F=a(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-mppjee"&&(F.innerHTML=Gl),Tt=i(e),L=a(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-bazx3o"&&(L.textContent=Zl),Ut=i(e),p(Y.$$.fragment,e),wt=i(e),P=a(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1a3cg8s"&&(P.textContent=Vl),ft=i(e),p(D.$$.fragment,e),jt=i(e),K=a(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-3tumra"&&(K.innerHTML=xl),ht=i(e),O=a(e,"UL",{"data-svelte-h":!0}),r(O)!=="svelte-1n5ilxc"&&(O.innerHTML=Wl),bt=i(e),ee=a(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1q12cn2"&&(ee.textContent=$l),gt=i(e),te=a(e,"UL",{"data-svelte-h":!0}),r(te)!=="svelte-gylfs5"&&(te.innerHTML=Ql),It=i(e),le=a(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1ycck93"&&(le.textContent=El),vt=i(e),p(se.$$.fragment,e),Ct=i(e),ne=a(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-11bjgz5"&&(ne.innerHTML=Al),Bt=i(e),ie=a(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1qtp9zt"&&(ie.innerHTML=Hl),Gt=i(e),oe=a(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1io9n7l"&&(oe.textContent=Xl),Zt=i(e),p(ae.$$.fragment,e),Vt=i(e),re=a(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1dj2m8q"&&(re.innerHTML=ql),xt=i(e),ue=a(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-dzdo4c"&&(ue.innerHTML=_l),Wt=i(e),p(pe.$$.fragment,e),$t=i(e),p(Me.$$.fragment,e),Qt=i(e),de=a(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-lkw15u"&&(de.innerHTML=zl),Et=i(e),p(ce.$$.fragment,e),At=i(e),p(me.$$.fragment,e),Ht=i(e),ye=a(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1a489zo"&&(ye.innerHTML=Rl),Xt=i(e),Je=a(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-1l3ahp3"&&(Je.innerHTML=Sl),qt=i(e),Te=a(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-t1i6dg"&&(Te.innerHTML=kl),_t=i(e),p(Ue.$$.fragment,e),zt=i(e),p(we.$$.fragment,e),Rt=i(e),fe=a(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-1au8scc"&&(fe.innerHTML=Nl),St=i(e),je=a(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-110sxce"&&(je.innerHTML=Fl),kt=i(e),he=a(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-18qnnre"&&(he.innerHTML=Ll),Nt=i(e),be=a(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-l54s8f"&&(be.textContent=Yl),Ft=i(e),p(ge.$$.fragment,e),Lt=i(e),p(Ie.$$.fragment,e),Yt=i(e),ve=a(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-112h65z"&&(ve.innerHTML=Pl),Pt=i(e),J=a(e,"DETAILS",{});var Ee=al(J);$e=a(Ee,"SUMMARY",{"data-svelte-h":!0}),r($e)!=="svelte-1gpv5oq"&&($e.textContent=Dl),il=i(Ee),Qe=a(Ee,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-1lje2t5"&&(Qe.innerHTML=Kl),ol=i(Ee),p(Ce.$$.fragment,Ee),Ee.forEach(l),Dt=i(e),Be=a(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-14p1bj6"&&(Be.innerHTML=Ol),Kt=i(e),p(Ge.$$.fragment,e),Ot=i(e),Ze=a(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-1a1c657"&&(Ze.textContent=es),el=i(e),p(Ve.$$.fragment,e),tl=i(e),xe=a(e,"UL",{"data-svelte-h":!0}),r(xe)!=="svelte-13zdug0"&&(xe.innerHTML=ts),ll=i(e),p(We.$$.fragment,e),sl=i(e),He=a(e,"P",{}),al(He).forEach(l),this.h()},h(){Xe(T,"name","hf:doc:metadata"),Xe(T,"content",ds),ss(H.src,hl="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/smolagents/alfred-catering.jpg")||Xe(H,"src",hl),Xe(H,"alt","Alfred Catering"),Xe(U,"class","tip")},m(e,t){qe(document.head,T),s(e,_e,t),s(e,Ae,t),s(e,ze,t),M(f,e,t),s(e,Re,t),M(j,e,t),s(e,Se,t),s(e,h,t),s(e,ke,t),s(e,b,t),s(e,Ne,t),s(e,g,t),s(e,Fe,t),s(e,I,t),s(e,Le,t),s(e,v,t),s(e,Ye,t),s(e,C,t),s(e,Pe,t),s(e,B,t),s(e,De,t),s(e,G,t),s(e,Ke,t),M(Z,e,t),s(e,Oe,t),s(e,V,t),s(e,et,t),s(e,x,t),s(e,tt,t),M(W,e,t),s(e,lt,t),s(e,$,t),s(e,st,t),s(e,Q,t),s(e,nt,t),s(e,E,t),s(e,it,t),M(A,e,t),s(e,ot,t),s(e,H,t),s(e,at,t),s(e,U,t),s(e,rt,t),s(e,X,t),s(e,ut,t),s(e,q,t),s(e,pt,t),M(_,e,t),s(e,Mt,t),M(z,e,t),s(e,dt,t),s(e,R,t),s(e,ct,t),s(e,S,t),s(e,mt,t),s(e,k,t),s(e,yt,t),M(N,e,t),s(e,Jt,t),s(e,F,t),s(e,Tt,t),s(e,L,t),s(e,Ut,t),M(Y,e,t),s(e,wt,t),s(e,P,t),s(e,ft,t),M(D,e,t),s(e,jt,t),s(e,K,t),s(e,ht,t),s(e,O,t),s(e,bt,t),s(e,ee,t),s(e,gt,t),s(e,te,t),s(e,It,t),s(e,le,t),s(e,vt,t),M(se,e,t),s(e,Ct,t),s(e,ne,t),s(e,Bt,t),s(e,ie,t),s(e,Gt,t),s(e,oe,t),s(e,Zt,t),M(ae,e,t),s(e,Vt,t),s(e,re,t),s(e,xt,t),s(e,ue,t),s(e,Wt,t),M(pe,e,t),s(e,$t,t),M(Me,e,t),s(e,Qt,t),s(e,de,t),s(e,Et,t),M(ce,e,t),s(e,At,t),M(me,e,t),s(e,Ht,t),s(e,ye,t),s(e,Xt,t),s(e,Je,t),s(e,qt,t),s(e,Te,t),s(e,_t,t),M(Ue,e,t),s(e,zt,t),M(we,e,t),s(e,Rt,t),s(e,fe,t),s(e,St,t),s(e,je,t),s(e,kt,t),s(e,he,t),s(e,Nt,t),s(e,be,t),s(e,Ft,t),M(ge,e,t),s(e,Lt,t),M(Ie,e,t),s(e,Yt,t),s(e,ve,t),s(e,Pt,t),s(e,J,t),qe(J,$e),qe(J,il),qe(J,Qe),qe(J,ol),M(Ce,J,null),s(e,Dt,t),s(e,Be,t),s(e,Kt,t),M(Ge,e,t),s(e,Ot,t),s(e,Ze,t),s(e,el,t),M(Ve,e,t),s(e,tl,t),s(e,xe,t),s(e,ll,t),M(We,e,t),s(e,sl,t),s(e,He,t),nl=!0},p:ns,i(e){nl||(d(f.$$.fragment,e),d(j.$$.fragment,e),d(Z.$$.fragment,e),d(W.$$.fragment,e),d(A.$$.fragment,e),d(_.$$.fragment,e),d(z.$$.fragment,e),d(N.$$.fragment,e),d(Y.$$.fragment,e),d(D.$$.fragment,e),d(se.$$.fragment,e),d(ae.$$.fragment,e),d(pe.$$.fragment,e),d(Me.$$.fragment,e),d(ce.$$.fragment,e),d(me.$$.fragment,e),d(Ue.$$.fragment,e),d(we.$$.fragment,e),d(ge.$$.fragment,e),d(Ie.$$.fragment,e),d(Ce.$$.fragment,e),d(Ge.$$.fragment,e),d(Ve.$$.fragment,e),d(We.$$.fragment,e),nl=!0)},o(e){c(f.$$.fragment,e),c(j.$$.fragment,e),c(Z.$$.fragment,e),c(W.$$.fragment,e),c(A.$$.fragment,e),c(_.$$.fragment,e),c(z.$$.fragment,e),c(N.$$.fragment,e),c(Y.$$.fragment,e),c(D.$$.fragment,e),c(se.$$.fragment,e),c(ae.$$.fragment,e),c(pe.$$.fragment,e),c(Me.$$.fragment,e),c(ce.$$.fragment,e),c(me.$$.fragment,e),c(Ue.$$.fragment,e),c(we.$$.fragment,e),c(ge.$$.fragment,e),c(Ie.$$.fragment,e),c(Ce.$$.fragment,e),c(Ge.$$.fragment,e),c(Ve.$$.fragment,e),c(We.$$.fragment,e),nl=!1},d(e){e&&(l(_e),l(Ae),l(ze),l(Re),l(Se),l(h),l(ke),l(b),l(Ne),l(g),l(Fe),l(I),l(Le),l(v),l(Ye),l(C),l(Pe),l(B),l(De),l(G),l(Ke),l(Oe),l(V),l(et),l(x),l(tt),l(lt),l($),l(st),l(Q),l(nt),l(E),l(it),l(ot),l(H),l(at),l(U),l(rt),l(X),l(ut),l(q),l(pt),l(Mt),l(dt),l(R),l(ct),l(S),l(mt),l(k),l(yt),l(Jt),l(F),l(Tt),l(L),l(Ut),l(wt),l(P),l(ft),l(jt),l(K),l(ht),l(O),l(bt),l(ee),l(gt),l(te),l(It),l(le),l(vt),l(Ct),l(ne),l(Bt),l(ie),l(Gt),l(oe),l(Zt),l(Vt),l(re),l(xt),l(ue),l(Wt),l($t),l(Qt),l(de),l(Et),l(At),l(Ht),l(ye),l(Xt),l(Je),l(qt),l(Te),l(_t),l(zt),l(Rt),l(fe),l(St),l(je),l(kt),l(he),l(Nt),l(be),l(Ft),l(Lt),l(Yt),l(ve),l(Pt),l(J),l(Dt),l(Be),l(Kt),l(Ot),l(Ze),l(el),l(tl),l(xe),l(ll),l(sl),l(He)),l(T),m(f,e),m(j,e),m(Z,e),m(W,e),m(A,e),m(_,e),m(z,e),m(N,e),m(Y,e),m(D,e),m(se,e),m(ae,e),m(pe,e),m(Me,e),m(ce,e),m(me,e),m(Ue,e),m(we,e),m(ge,e),m(Ie,e),m(Ce),m(Ge,e),m(Ve,e),m(We,e)}}}const ds='{"title":"Outils","local":"outils","sections":[{"title":"Méthodes de création d’outils","local":"méthodes-de-création-doutils","sections":[{"title":"Le décorateur @tool","local":"le-décorateur-tool","sections":[{"title":"Générer un outil qui récupère le service de traiteur le mieux noté","local":"générer-un-outil-qui-récupère-le-service-de-traiteur-le-mieux-noté","sections":[],"depth":4}],"depth":3},{"title":"Définir un outil comme une classe Python","local":"définir-un-outil-comme-une-classe-python","sections":[{"title":"Générer un outil pour générer des idées pour une fête sur le thème des super-héros","local":"générer-un-outil-pour-générer-des-idées-pour-une-fête-sur-le-thème-des-super-héros","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Boîte à outils par défaut","local":"boîte-à-outils-par-défaut","sections":[],"depth":2},{"title":"Partage et importation d’outils","local":"partage-et-importation-doutils","sections":[{"title":"Partager un outil sur le Hub","local":"partager-un-outil-sur-le-hub","sections":[],"depth":3},{"title":"Importer un outil depuis le Hub","local":"importer-un-outil-depuis-le-hub","sections":[],"depth":3},{"title":"Importer un Space comme outil","local":"importer-un-space-comme-outil","sections":[],"depth":3},{"title":"Importer un outil LangChain","local":"importer-un-outil-langchain","sections":[],"depth":3},{"title":"Importer une collection d’outils depuis n’importe quel serveur MCP","local":"importer-une-collection-doutils-depuis-nimporte-quel-serveur-mcp","sections":[],"depth":3}],"depth":2},{"title":"Ressources","local":"ressources","sections":[],"depth":2}],"depth":1}';function cs(rl){return is(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class fs extends os{constructor(T){super(),as(this,T,cs,Ms,ls,{})}}export{fs as component};
