import{s as YU,f as zU,n as HU,o as _U}from"../chunks/scheduler.37c15a92.js";import{S as $U,i as LU,g as j,s as e,r as s,A as qU,h as C,f as U,c as y,j as xU,u as J,x as t,k as PM,l as KU,y as PU,a as T,v as I,d as A,t as n,w}from"../chunks/index.2bf4358c.js";import{C as i}from"../chunks/CodeBlock.4e987730.js";import{C as lT}from"../chunks/CourseFloatingBanner.6add7356.js";import{H as Bl}from"../chunks/Heading.8ada512a.js";import{E as MT}from"../chunks/getInferenceSnippets.0aa3753f.js";function UT(lU){let a,El,hl,gl,o,Gl,r,Zl,u,MU="Les systèmes multi-agents permettent à des <strong>agents spécialisés de collaborer sur des tâches complexes</strong>, améliorant la modularité, la scalabilité et la robustesse. Au lieu de s’appuyer sur un seul agent, les tâches sont distribuées entre des agents ayant des capacités distinctes.",vl,c,UU="Dans <code>smolagents</code>, différents agents peuvent être combinés pour générer du code Python, appeler des outils externes, effectuer des recherches web et plus encore. En orchestrant ces agents, nous pouvons créer des flux de travail puissants.",fl,d,TU="Une configuration typique pourrait inclure :",Wl,O,eU="<li>Un <strong>agent manageur</strong> pour la délégation des tâches</li> <li>Un <strong>agent interpréteur de code</strong> pour l’exécution de code</li> <li>Un <strong>agent de recherche web</strong> pour la récupération d’informations</li>",Xl,m,yU="Le diagramme ci-dessous illustre une architecture multi-agents simple où un <strong>agent manageur</strong> coordonne un <strong>outil interpréteur de code</strong> et un <strong>agent de recherche web</strong>, qui à son tour utilise des outils comme <code>DuckDuckGoSearchTool</code> et <code>VisitWebpageTool</code> pour rassembler des informations pertinentes.",kl,V,jU,xl,Q,Yl,N,CU="Un système multi-agents se compose de plusieurs agents spécialisés travaillant ensemble sous la coordination d’un <strong>agent orchestrateur</strong>. Cette approche permet des flux de travail complexes en distribuant les tâches entre des agents ayant des rôles distincts.",zl,R,tU="Par exemple, un <strong>système de RAG multi-agents</strong> peut intégrer :",Hl,b,sU="<li>Un <strong>agent web</strong> pour naviguer sur internet.</li> <li>Un <strong>agent récupérateur</strong> pour récupérer des informations à partir de bases de connaissances.</li> <li>Un <strong>agent de génération d’images</strong> pour produire des visuels.</li>",_l,F,JU="Tous ces agents opèrent sous un orchestrateur qui gère la délégation de tâches et l’interaction.",$l,S,Ll,p,IU='<p>Vous pouvez suivre le code dans <a href="https://huggingface.co/agents-course/notebooks/blob/main/fr/unit2/smolagents/multiagent_notebook.ipynb" target="_blank">ce <i>notebook</i></a> que vous pouvez exécuter avec Google Colab.</p>',ql,B,AU="La réception approche ! Avec votre aide, Alfred a presque terminé les préparatifs.",Kl,h,nU="Mais maintenant il y a un problème : la Batmobile a disparu. Alfred doit trouver une remplaçante, et la trouver rapidement.",Pl,D,wU="Heureusement, quelques biographies ont été réalisées sur la vie de Bruce Wayne, alors peut-être qu’Alfred pourrait récupérer une voiture abandonnée sur l’un des plateaux de tournage et la reconditionner selon les normes modernes, ce qui inclurait certainement une option de conduite entièrement autonome.",lM,E,iU="Mais cela pourrait être n’importe où dans les lieux de tournage autour du monde ; pouvant être nombreux.",MM,g,aU="Donc Alfred nécessite votre aide. Pourriez-vous construire un agent capable de résoudre cette tâche ?",UM,G,pU="<p>👉 Trouvez tous les lieux de tournage de Batman dans le monde, calculez le temps de transfert par cargo jusqu’à ces lieux, et représentez-les sur une carte, avec une couleur variant en fonction du temps de transfert par cargo. Représentez également quelques usines de supercars avec le même temps de transfert en cargo.</p>",TM,Z,oU="Construisons cela !",eM,v,rU="Cet exemple nécessite des packages supplémentaires, donc installons-les d’abord :",yM,f,jM,W,CM,X,tM,k,sM,x,uU='Pour le fournisseur de modèle, nous utilisons Together AI, l’un des nouveaux <a href="https://huggingface.co/blog/inference-providers" rel="nofollow">fournisseurs d’inférence sur le Hub</a> !',JM,Y,cU='Le <code>GoogleSearchTool</code> utilise l’<a href="https://serper.dev" rel="nofollow">API Serper</a> pour rechercher sur le web, cela nécessite donc soit d’avoir configuré la variable d’environnement <code>SERPAPI_API_KEY</code> et de passer <code>provider=&quot;serpapi&quot;</code> ou d’avoir <code>SERPER_API_KEY</code> et de passer <code>provider=serper</code>.',IM,z,dU="Si vous n’avez pas de fournisseur Serp API configuré, vous pouvez utiliser <code>DuckDuckGoSearchTool</code> mais attention il a une limite d’appels.",AM,H,nM,_,OU="Nous pouvons commencer par créer un agent simple comme ligne de base pour nous donner un rapport simple.",wM,$,iM,L,aM,q,pM,K,oM,P,mU="Dans notre cas, il génère cette sortie :",rM,ll,uM,Ml,VU="Nous pourrions déjà l’améliorer un peu en ajoutant des étapes de planification dédiées et en ajoutant davantage de <em>prompts</em>.",cM,Ul,QU="Les étapes de planification permettent à l’agent de penser à l’avance et planifier ses prochaines étapes, ce qui peut être utile pour des tâches plus complexes.",dM,Tl,OM,el,mM,yl,NU="Dans notre cas, il génère cette sortie :",VM,jl,QM,Cl,RU="Grâce à ces changements rapides, nous avons obtenu un rapport beaucoup plus concis en fournissant simplement à notre agent un <em>prompt</em> détaillé, et en lui donnant des capacités de planification !",NM,tl,bU="La fenêtre de contexte du modèle se remplit rapidement. Donc <strong>si nous demandons à notre agent de combiner les résultats de recherche détaillée avec une autre, il sera plus lent et cela augmentera rapidement le nombre de <em>tokens</em> utilisés et donc les coûts</strong>.",RM,sl,FU="➡️ Nous devons améliorer la structure de notre système.",bM,Jl,FM,Il,SU="Les structures multi-agents permettent de séparer les mémoires entre différentes sous-tâches, avec deux grands avantages :",SM,Al,BU="<li>Chaque agent est davantage focalisé sur sa tâche principale, donc plus performant</li> <li>Séparer les mémoires réduit le nombre de <em>tokens</em> d’entrée à chaque étape, réduisant ainsi la latence et le coût.</li>",BM,nl,hU="Créons une équipe avec un agent de recherche web dédié, géré par un autre agent.",hM,wl,DU="L’agent gestionnaire devrait avoir des capacités de traçage pour écrire son rapport final : donnons-lui donc accès à des importations supplémentaires, incluant <code>plotly</code>, et <code>geopandas</code> + <code>shapely</code> pour le traçage spatial.",DM,il,EM,al,EU="L’agent gestionnaire aura besoin de faire du travail mental intensif.",gM,pl,gU='Donc nous lui donnons le modèle plus puissant <a href="https://huggingface.co/deepseek-ai/DeepSeek-R1" rel="nofollow">DeepSeek-R1</a>, et ajoutons un <code>planning_interval</code> au mélange.',GM,ol,ZM,rl,GU="Inspectons à quoi ressemble cette équipe :",vM,ul,fM,cl,ZU="Cela générera quelque chose comme ceci, nous aidant à comprendre la structure et les relations entre les agents et les outils utilisés :",WM,dl,XM,Ol,kM,ml,vU="Je ne sais pas comment cela s’est passé pour votre exécution, mais dans la mienne, l’agent gestionnaire a habilement divisé les tâches données à l’agent web en <code>1. Rechercher les lieux de tournage de Batman</code>, puis <code>2. Trouver les usines de supercars</code>, avant d’agréger les listes et de tracer la carte.",xM,Vl,fU="Voyons à quoi ressemble la carte en l’inspectant directement depuis l’état de l’agent :",YM,Ql,zM,Nl,WU="Cela affichera la carte :",HM,Rl,XU='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/smolagents/output_map.png" alt="Exemple de sortie de carte du système multi-agents"/>',_M,bl,$M,Fl,kU='<li><a href="https://huggingface.co/docs/smolagents/main/en/examples/multiagents" rel="nofollow">Systèmes multi-agents</a> – Aperçu des systèmes multi-agents.</li> <li><a href="https://weaviate.io/blog/what-is-agentic-rag" rel="nofollow">Qu’est-ce que le RAG agentique ?</a> – Introduction au RAG agentique.</li> <li><a href="https://huggingface.co/learn/cookbook/multiagent_rag_system" rel="nofollow">Système RAG multi-agents 🤖🤝🤖 Recette</a> – Guide étape par étape pour construire un système RAG multi-agents.</li>',LM,Sl,qM,Dl,KM;return o=new lT({props:{classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/#fileId=https://huggingface.co/agents-course/notebooks/blob/main/fr/unit2/smolagents/multiagent_notebook.ipynb"}],askForHelpUrl:"http://hf.co/join/discord"}}),r=new Bl({props:{title:"Systèmes multi-agents",local:"systèmes-multi-agents",headingTag:"h1"}}),Q=new Bl({props:{title:"Systèmes multi-agents en action",local:"systèmes-multi-agents-en-action",headingTag:"h2"}}),S=new Bl({props:{title:"Résoudre une tâche complexe avec une hiérarchie multi-agents",local:"résoudre-une-tâche-complexe-avec-une-hiérarchie-multi-agents",headingTag:"h2"}}),f=new i({props:{code:"cGlwJTIwaW5zdGFsbCUyMCdzbW9sYWdlbnRzJTVCbGl0ZWxsbSU1RCclMjBwbG90bHklMjBnZW9wYW5kYXMlMjBzaGFwZWx5JTIwa2FsZWlkbyUyMC1x",highlighted:'pip install <span class="hljs-string">&#x27;smolagents[litellm]&#x27;</span> plotly geopandas shapely kaleido -q',wrap:!1}}),W=new Bl({props:{title:"Nous créons d’abord un outil pour obtenir le temps de transfert en avion cargo.",local:"nous-créons-dabord-un-outil-pour-obtenir-le-temps-de-transfert-en-avion-cargo",headingTag:"h3"}}),X=new i({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> math
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Optional</span>, <span class="hljs-type">Tuple</span>

<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> tool


<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculate_cargo_travel_time</span>(<span class="hljs-params">
    origin_coords: <span class="hljs-type">Tuple</span>[<span class="hljs-built_in">float</span>, <span class="hljs-built_in">float</span>],
    destination_coords: <span class="hljs-type">Tuple</span>[<span class="hljs-built_in">float</span>, <span class="hljs-built_in">float</span>],
    cruising_speed_kmh: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">float</span>] = <span class="hljs-number">750.0</span>,  <span class="hljs-comment"># Vitesse moyenne pour les avions cargo</span>
</span>) -&gt; <span class="hljs-built_in">float</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Calcule le temps de voyage pour un avion cargo entre deux points sur Terre en utilisant la distance du grand cercle.

    Args:
        origin_coords: Tuple de (latitude, longitude) pour le point de départ
        destination_coords: Tuple de (latitude, longitude) pour la destination
        cruising_speed_kmh: Vitesse de croisière optionnelle en km/h (par défaut 750 km/h pour les avions cargo typiques)

    Returns:
        float: Le temps de voyage estimé en heures

    Example:
        &gt;&gt;&gt; # Chicago (41.8781° N, 87.6298° W) vers Sydney (33.8688° S, 151.2093° E)
        &gt;&gt;&gt; result = calculate_cargo_travel_time((41.8781, -87.6298), (-33.8688, 151.2093))
    &quot;&quot;&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">to_radians</span>(<span class="hljs-params">degrees: <span class="hljs-built_in">float</span></span>) -&gt; <span class="hljs-built_in">float</span>:
        <span class="hljs-keyword">return</span> degrees * (math.pi / <span class="hljs-number">180</span>)

    <span class="hljs-comment"># Extraire les coordonnées</span>
    lat1, lon1 = <span class="hljs-built_in">map</span>(to_radians, origin_coords)
    lat2, lon2 = <span class="hljs-built_in">map</span>(to_radians, destination_coords)

    <span class="hljs-comment"># Rayon de la Terre en kilomètres</span>
    EARTH_RADIUS_KM = <span class="hljs-number">6371.0</span>

    <span class="hljs-comment"># Calculer la distance du grand cercle en utilisant la formule de haversine</span>
    dlon = lon2 - lon1
    dlat = lat2 - lat1

    a = (
        math.sin(dlat / <span class="hljs-number">2</span>) ** <span class="hljs-number">2</span>
        + math.cos(lat1) * math.cos(lat2) * math.sin(dlon / <span class="hljs-number">2</span>) ** <span class="hljs-number">2</span>
    )
    c = <span class="hljs-number">2</span> * math.asin(math.sqrt(a))
    distance = EARTH_RADIUS_KM * c

    <span class="hljs-comment"># Ajouter 10% pour tenir compte des routes non directes et des contrôles de trafic aérien</span>
    actual_distance = distance * <span class="hljs-number">1.1</span>

    <span class="hljs-comment"># Calculer le temps de vol</span>
    <span class="hljs-comment"># Ajouter 1 heure pour les procédures de décollage et d&#x27;atterrissage</span>
    flight_time = (actual_distance / cruising_speed_kmh) + <span class="hljs-number">1.0</span>

    <span class="hljs-comment"># Formater les résultats</span>
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">round</span>(flight_time, <span class="hljs-number">2</span>)


<span class="hljs-built_in">print</span>(calculate_cargo_travel_time((<span class="hljs-number">41.8781</span>, -<span class="hljs-number">87.6298</span>), (-<span class="hljs-number">33.8688</span>, <span class="hljs-number">151.2093</span>)))`,wrap:!1}}),k=new Bl({props:{title:"Configuration de l’agent",local:"configuration-de-lagent",headingTag:"h3"}}),H=new i({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwc21vbGFnZW50cyUyMGltcG9ydCUyMENvZGVBZ2VudCUyQyUyMEdvb2dsZVNlYXJjaFRvb2wlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMFZpc2l0V2VicGFnZVRvb2wlMEElMEFtb2RlbCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudE1vZGVsKG1vZGVsX2lkJTNEJTIyUXdlbiUyRlF3ZW4yLjUtQ29kZXItMzJCLUluc3RydWN0JTIyJTJDJTIwcHJvdmlkZXIlM0QlMjJ0b2dldGhlciUyMik=",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, GoogleSearchTool, InferenceClientModel, VisitWebpageTool

model = InferenceClientModel(model_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>, provider=<span class="hljs-string">&quot;together&quot;</span>)`,wrap:!1}}),$=new i({props:{code:"dGFzayUyMCUzRCUyMCUyMiUyMiUyMlRyb3V2ZXolMjB0b3VzJTIwbGVzJTIwbGlldXglMjBkZSUyMHRvdXJuYWdlJTIwZGUlMjBCYXRtYW4lMjBkYW5zJTIwbGUlMjBtb25kZSUyQyUyMGNhbGN1bGV6JTIwbGUlMjB0ZW1wcyUyMGRlJTIwdHJhbnNmZXJ0JTIwcGFyJTIwYXZpb24lMjBjYXJnbyUyMGp1c3F1J2ljaSUyMChub3VzJTIwc29tbWVzJTIwJUMzJUEwJTIwR290aGFtJTJDJTIwNDAuNzEyOCVDMiVCMCUyME4lMkMlMjA3NC4wMDYwJUMyJUIwJTIwVyklMkMlMjBldCUyMHJlbnZveWV6LWxlcyUyMG1vaSUyMHNvdXMlMjBsYSUyMGZvcm1lJTIwZCd1biUyMGRhdGFmcmFtZSUyMHBhbmRhcy4lMEFEb25uZXotbW9pJTIwYXVzc2klMjBkZXMlMjB1c2luZXMlMjBkZSUyMHN1cGVyY2FycyUyMGF2ZWMlMjBsZSUyMG0lQzMlQUFtZSUyMHRlbXBzJTIwZGUlMjB0cmFuc2ZlcnQlMjBwYXIlMjBhdmlvbi1jYXJnby4lMjIlMjIlMjI=",highlighted:`task = <span class="hljs-string">&quot;&quot;&quot;Trouvez tous les lieux de tournage de Batman dans le monde, calculez le temps de transfert par avion cargo jusqu&#x27;ici (nous sommes à Gotham, 40.7128° N, 74.0060° W), et renvoyez-les moi sous la forme d&#x27;un dataframe pandas.
Donnez-moi aussi des usines de supercars avec le même temps de transfert par avion-cargo.&quot;&quot;&quot;</span>`,wrap:!1}}),L=new i({props:{code:"YWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCR29vZ2xlU2VhcmNoVG9vbCglMjJzZXJwZXIlMjIpJTJDJTIwVmlzaXRXZWJwYWdlVG9vbCgpJTJDJTIwY2FsY3VsYXRlX2NhcmdvX3RyYXZlbF90aW1lJTVEJTJDJTBBJTIwJTIwJTIwJTIwYWRkaXRpb25hbF9hdXRob3JpemVkX2ltcG9ydHMlM0QlNUIlMjJwYW5kYXMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBtYXhfc3RlcHMlM0QyMCUyQyUwQSk=",highlighted:`agent = CodeAgent(
    model=model,
    tools=[GoogleSearchTool(<span class="hljs-string">&quot;serper&quot;</span>), VisitWebpageTool(), calculate_cargo_travel_time],
    additional_authorized_imports=[<span class="hljs-string">&quot;pandas&quot;</span>],
    max_steps=<span class="hljs-number">20</span>,
)`,wrap:!1}}),q=new i({props:{code:"cmVzdWx0JTIwJTNEJTIwYWdlbnQucnVuKHRhc2sp",highlighted:"result = agent.run(task)",wrap:!1}}),K=new i({props:{code:"cmVzdWx0",highlighted:"result",wrap:!1}}),ll=new i({props:{code:"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",highlighted:`|  | Location                                             | Travel Time to Gotham (hours) |
|--|------------------------------------------------------|------------------------------|
| <span class="hljs-number">0</span>  | Necropolis Cemetery, Glasgow, Scotland, UK         | <span class="hljs-number">8.60</span>                         |
| <span class="hljs-number">1</span>  | St. George<span class="hljs-string">&#x27;s Hall, Liverpool, England, UK         | 8.81                         |
| 2  | Two Temple Place, London, England, UK             | 9.17                         |
| 3  | Wollaton Hall, Nottingham, England, UK           | 9.00                         |
| 4  | Knebworth House, Knebworth, Hertfordshire, UK    | 9.15                         |
| 5  | Acton Lane Power Station, Acton Lane, Acton, UK  | 9.16                         |
| 6  | Queensboro Bridge, New York City, USA            | 1.01                         |
| 7  | Wall Street, New York City, USA                  | 1.00                         |
| 8  | Mehrangarh Fort, Jodhpur, Rajasthan, India       | 18.34                        |
| 9  | Turda Gorge, Turda, Romania                      | 11.89                        |
| 10 | Chicago, USA                                     | 2.68                         |
| 11 | Hong Kong, China                                 | 19.99                        |
| 12 | Cardington Studios, Northamptonshire, UK        | 9.10                         |
| 13 | Warner Bros. Leavesden Studios, Hertfordshire, UK | 9.13                         |
| 14 | Westwood, Los Angeles, CA, USA                  | 6.79                         |
| 15 | Woking, UK (McLaren)                             | 9.13                         |</span>`,wrap:!1}}),Tl=new i({props:{code:"YWdlbnQucGxhbm5pbmdfaW50ZXJ2YWwlMjAlM0QlMjA0JTBBJTBBZGV0YWlsZWRfcmVwb3J0JTIwJTNEJTIwYWdlbnQucnVuKGYlMjIlMjIlMjIlMEFWb3VzJTIwJUMzJUFBdGVzJTIwdW4lMjBhbmFseXN0ZSUyMGV4cGVydC4lMjBWb3VzJTIwciVDMyVBOWRpZ2V6JTIwZGVzJTIwcmFwcG9ydHMlMjBjb21wbGV0cyUyMGFwciVDMyVBOHMlMjBhdm9pciUyMHZpc2l0JUMzJUE5JTIwZGUlMjBub21icmV1eCUyMHNpdGVzJTIwd2ViLiUwQU4naCVDMyVBOXNpdGV6JTIwcGFzJTIwJUMzJUEwJTIwZWZmZWN0dWVyJTIwcGx1c2lldXJzJTIwcmVjaGVyY2hlcyUyMCVDMyVBMCUyMGxhJTIwZm9pcyUyMGRhbnMlMjB1bmUlMjBib3VjbGUlMjBmb3IuJTBBUG91ciUyMGNoYXF1ZSUyMHBvaW50JTIwZGUlMjBkb25uJUMzJUE5ZXMlMjBxdWUlMjB2b3VzJTIwdHJvdXZleiUyQyUyMHZpc2l0ZXolMjBsJ3VybCUyMHNvdXJjZSUyMHBvdXIlMjBjb25maXJtZXIlMjBsZXMlMjBjaGlmZnJlcy4lMEElMEElN0J0YXNrJTdEJTBBJTIyJTIyJTIyKSUwQSUwQXByaW50KGRldGFpbGVkX3JlcG9ydCk=",highlighted:`agent.planning_interval = <span class="hljs-number">4</span>

detailed_report = agent.run(<span class="hljs-string">f&quot;&quot;&quot;
Vous êtes un analyste expert. Vous rédigez des rapports complets après avoir visité de nombreux sites web.
N&#x27;hésitez pas à effectuer plusieurs recherches à la fois dans une boucle for.
Pour chaque point de données que vous trouvez, visitez l&#x27;url source pour confirmer les chiffres.

<span class="hljs-subst">{task}</span>
&quot;&quot;&quot;</span>)

<span class="hljs-built_in">print</span>(detailed_report)`,wrap:!1}}),el=new i({props:{code:"ZGV0YWlsZWRfcmVwb3J0",highlighted:"detailed_report",wrap:!1}}),jl=new i({props:{code:"JTdDJTIwJTIwJTdDJTIwTG9jYXRpb24lMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMjBUcmF2ZWwlMjBUaW1lJTIwKGhvdXJzKSUyMCU3QyUwQSU3Qy0tJTdDLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0lN0MtLS0tLS0tLS0tLS0tLS0tLS0tLS0lN0MlMEElN0MlMjAwJTIwJTIwJTdDJTIwQnJpZGdlJTIwb2YlMjBTaWdocyUyQyUyMEdsYXNnb3clMjBOZWNyb3BvbGlzJTJDJTIwR2xhc2dvdyUyQyUyMFVLJTIwJTdDJTIwOC42JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTBBJTdDJTIwMSUyMCUyMCU3QyUyMFdpc2hhcnQlMjBTdHJlZXQlMkMlMjBHbGFzZ293JTJDJTIwU2NvdGxhbmQlMkMlMjBVSyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMDguNiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3Qw==",highlighted:`|  | Location                                         | Travel Time (hours) |
|--|--------------------------------------------------|---------------------|
| <span class="hljs-number">0</span>  | Bridge of Sighs, Glasgow Necropolis, Glasgow, UK | <span class="hljs-number">8.6</span>                 |
| <span class="hljs-number">1</span>  | Wishart Street, Glasgow, Scotland, UK         | <span class="hljs-number">8.6</span>                 |`,wrap:!1}}),Jl=new Bl({props:{title:"✌️ Diviser la tâche entre deux agents",local:"-diviser-la-tâche-entre-deux-agents",headingTag:"h3"}}),il=new i({props:{code:"bW9kZWwlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCglMEElMjAlMjAlMjAlMjAlMjJRd2VuJTJGUXdlbjIuNS1Db2Rlci0zMkItSW5zdHJ1Y3QlMjIlMkMlMjBwcm92aWRlciUzRCUyMnRvZ2V0aGVyJTIyJTJDJTIwbWF4X3Rva2VucyUzRDgwOTYlMEEpJTBBJTBBd2ViX2FnZW50JTIwJTNEJTIwQ29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEdvb2dsZVNlYXJjaFRvb2wocHJvdmlkZXIlM0QlMjJzZXJwZXIlMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwVmlzaXRXZWJwYWdlVG9vbCgpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2FsY3VsYXRlX2NhcmdvX3RyYXZlbF90aW1lJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwbmFtZSUzRCUyMndlYl9hZ2VudCUyMiUyQyUwQSUyMCUyMCUyMCUyMGRlc2NyaXB0aW9uJTNEJTIyTmF2aWd1ZSUyMHN1ciUyMGxlJTIwd2ViJTIwcG91ciUyMHRyb3V2ZXIlMjBkZXMlMjBpbmZvcm1hdGlvbnMlMjIlMkMlMEElMjAlMjAlMjAlMjB2ZXJib3NpdHlfbGV2ZWwlM0QwJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3N0ZXBzJTNEMTAlMkMlMEEp",highlighted:`model = InferenceClientModel(
    <span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>, provider=<span class="hljs-string">&quot;together&quot;</span>, max_tokens=<span class="hljs-number">8096</span>
)

web_agent = CodeAgent(
    model=model,
    tools=[
        GoogleSearchTool(provider=<span class="hljs-string">&quot;serper&quot;</span>),
        VisitWebpageTool(),
        calculate_cargo_travel_time,
    ],
    name=<span class="hljs-string">&quot;web_agent&quot;</span>,
    description=<span class="hljs-string">&quot;Navigue sur le web pour trouver des informations&quot;</span>,
    verbosity_level=<span class="hljs-number">0</span>,
    max_steps=<span class="hljs-number">10</span>,
)`,wrap:!1}}),ol=new i({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents.utils <span class="hljs-keyword">import</span> encode_image_base64, make_image_url
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> OpenAIServerModel


<span class="hljs-keyword">def</span> <span class="hljs-title function_">check_reasoning_and_plot</span>(<span class="hljs-params">final_answer, agent_memory</span>):
    multimodal_model = OpenAIServerModel(<span class="hljs-string">&quot;gpt-4o&quot;</span>, max_tokens=<span class="hljs-number">8096</span>)
    filepath = <span class="hljs-string">&quot;saved_map.png&quot;</span>
    <span class="hljs-keyword">assert</span> os.path.exists(filepath), <span class="hljs-string">&quot;Assurez-vous de sauvegarder le graphique sous saved_map.png !&quot;</span>
    image = Image.<span class="hljs-built_in">open</span>(filepath)
    prompt = (
        <span class="hljs-string">f&quot;Voici une tâche donnée par l&#x27;utilisateur et les étapes de l&#x27;agent : <span class="hljs-subst">{agent_memory.get_succinct_steps()}</span>. Maintenant voici le graphique qui a été fait.&quot;</span>
        <span class="hljs-string">&quot;Veuillez vérifier que le processus de raisonnement et le graphique sont corrects : répondent-ils correctement à la tâche donnée ?&quot;</span>
        <span class="hljs-string">&quot;Listez d&#x27;abord les raisons pour lesquelles oui/non, puis écrivez votre décision finale : PASS en majuscules si c&#x27;est satisfaisant, FAIL si ce n&#x27;est pas le cas.&quot;</span>
        <span class="hljs-string">&quot;Ne soyez pas dur : si le graphique résout principalement la tâche, il devrait passer.&quot;</span>
        <span class="hljs-string">&quot;Pour passer, un graphique devrait être fait en utilisant px.scatter_map et non toute autre méthode (scatter_map a l&#x27;air plus joli).&quot;</span>
    )
    messages = [
        {
            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
            <span class="hljs-string">&quot;content&quot;</span>: [
                {
                    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
                    <span class="hljs-string">&quot;text&quot;</span>: prompt,
                },
                {
                    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image_url&quot;</span>,
                    <span class="hljs-string">&quot;image_url&quot;</span>: {<span class="hljs-string">&quot;url&quot;</span>: make_image_url(encode_image_base64(image))},
                },
            ],
        }
    ]
    output = multimodal_model(messages).content
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Feedback: &quot;</span>, output)
    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;FAIL&quot;</span> <span class="hljs-keyword">in</span> output:
        <span class="hljs-keyword">raise</span> Exception(output)
    <span class="hljs-keyword">return</span> <span class="hljs-literal">True</span>


manager_agent = CodeAgent(
    model=InferenceClientModel(<span class="hljs-string">&quot;deepseek-ai/DeepSeek-R1&quot;</span>, provider=<span class="hljs-string">&quot;together&quot;</span>, max_tokens=<span class="hljs-number">8096</span>),
    tools=[calculate_cargo_travel_time],
    managed_agents=[web_agent],
    additional_authorized_imports=[
        <span class="hljs-string">&quot;geopandas&quot;</span>,
        <span class="hljs-string">&quot;plotly&quot;</span>,
        <span class="hljs-string">&quot;shapely&quot;</span>,
        <span class="hljs-string">&quot;json&quot;</span>,
        <span class="hljs-string">&quot;pandas&quot;</span>,
        <span class="hljs-string">&quot;numpy&quot;</span>,
    ],
    planning_interval=<span class="hljs-number">5</span>,
    verbosity_level=<span class="hljs-number">2</span>,
    final_answer_checks=[check_reasoning_and_plot],
    max_steps=<span class="hljs-number">15</span>,
)`,wrap:!1}}),ul=new i({props:{code:"bWFuYWdlcl9hZ2VudC52aXN1YWxpemUoKQ==",highlighted:"manager_agent.visualize()",wrap:!1}}),dl=new i({props:{code:"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",highlighted:`CodeAgent | deepseek-ai/DeepSeek-R1
├── ✅ Importations autorisées : [<span class="hljs-string">&#x27;geopandas&#x27;</span>, <span class="hljs-string">&#x27;plotly&#x27;</span>, <span class="hljs-string">&#x27;shapely&#x27;</span>, <span class="hljs-string">&#x27;json&#x27;</span>, <span class="hljs-string">&#x27;pandas&#x27;</span>, <span class="hljs-string">&#x27;numpy&#x27;</span>]
├── 🛠️ Outils :
│   ┏━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┓
│   ┃ Nom                         ┃ Description                           ┃ Arguments                             ┃
│   ┡━━━━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┩
│   │ calculate_cargo_travel_time │ Calcule le temps de voyage pour un    │ origin_coords (\`array\`) : <span class="hljs-type">Tuple</span> de    │
│   │                             │ avion cargo entre deux points sur     │ (latitude, longitude) pour le         │
│   │                             │ Terre en utilisant la distance du     │ point de départ                       │
│   │                             │ grand cercle.                          │ destination_coords (\`array\`) : <span class="hljs-type">Tuple</span>  │
│   │                             │                                       │ de (latitude, longitude) pour la      │
│   │                             │                                       │ destination                           │
│   │                             │                                       │ cruising_speed_kmh (\`number\`) :       │
│   │                             │                                       │ Vitesse de croisière optionnelle      │
│   │                             │                                       │ en km/h (par défaut <span class="hljs-number">750</span> km/h pour     │
│   │                             │                                       │ les avions cargo typiques)            │
│   │ final_answer                │ Fournit une réponse finale au problème │ answer (\`<span class="hljs-built_in">any</span>\`) : La réponse finale    │
│   │                             │ donné.                                │ au problème                           │
│   └─────────────────────────────┴───────────────────────────────────────┴───────────────────────────────────────┘
└── 🤖 Agents gérés :
    └── web_agent | CodeAgent | Qwen/Qwen2<span class="hljs-number">.5</span>-Coder-32B-Instruct
        ├── ✅ Importations autorisées : []
        ├── 📝 Description : Navigue sur le web pour trouver des informations
        └── 🛠️ Outils :
            ┏━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┓
            ┃ Nom                         ┃ Description                       ┃ Arguments                         ┃
            ┡━━━━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┩
            │ web_search                  │ Effectue une recherche web Google │ query (\`string\`) : La requête de  │
            │                             │ pour votre requête puis retourne  │ recherche à effectuer.            │
            │                             │ une chaîne des meilleurs résultats │ filter_year (\`integer\`) :         │
            │                             │ de recherche.                      │ Optionnellement restreindre les   │
            │                             │                                   │ résultats à une certaine année    │
            │ visit_webpage               │ Visite une page web à l<span class="hljs-string">&#x27;URL donnée │ url (\`string\`) : L&#x27;</span>URL de la page │
            │                             │ et lit son contenu comme une      │ web à visiter.                    │
            │                             │ chaîne markdown. Utilisez ceci    │                                   │
            │                             │ pour naviguer sur les pages web.  │                                   │
            │ calculate_cargo_travel_time │ Calcule le temps de voyage pour un │ origin_coords (\`array\`) : <span class="hljs-type">Tuple</span> de │
            │                             │ avion cargo entre deux points sur │ (latitude, longitude) pour le     │
            │                             │ Terre en utilisant la distance du │ point de départ                   │
            │                             │ grand cercle.                      │ destination_coords (\`array\`) :    │
            │                             │                                   │ <span class="hljs-type">Tuple</span> de (latitude, longitude)    │
            │                             │                                   │ pour la destination               │
            │                             │                                   │ cruising_speed_kmh (\`number\`) :   │
            │                             │                                   │ Vitesse de croisière optionnelle  │
            │                             │                                   │ en km/h (par défaut <span class="hljs-number">750</span> km/h pour │
            │                             │                                   │ les avions cargo typiques)        │
            │ final_answer                │ Fournit une réponse finale au     │ answer (\`<span class="hljs-built_in">any</span>\`) : La réponse finale │
            │                             │ problème donné.                   │ au problème                       │
            └─────────────────────────────┴───────────────────────────────────┴───────────────────────────────────┘`,wrap:!1}}),Ol=new i({props:{code:"bWFuYWdlcl9hZ2VudC5ydW4oJTIyJTIyJTIyJTBBRmluZCUyMGFsbCUyMEJhdG1hbiUyMGZpbG1pbmclMjBsb2NhdGlvbnMlMjBpbiUyMHRoZSUyMHdvcmxkJTJDJTIwY2FsY3VsYXRlJTIwdGhlJTIwdGltZSUyMHRvJTIwdHJhbnNmZXIlMjB2aWElMjBjYXJnbyUyMHBsYW5lJTIwdG8lMjBoZXJlJTIwKHdlJ3JlJTIwaW4lMjBHb3RoYW0lMkMlMjA0MC43MTI4JUMyJUIwJTIwTiUyQyUyMDc0LjAwNjAlQzIlQjAlMjBXKS4lMEFBbHNvJTIwZ2l2ZSUyMG1lJTIwc29tZSUyMHN1cGVyY2FyJTIwZmFjdG9yaWVzJTIwd2l0aCUyMHRoZSUyMHNhbWUlMjBjYXJnbyUyMHBsYW5lJTIwdHJhbnNmZXIlMjB0aW1lLiUyMFlvdSUyMG5lZWQlMjBhdCUyMGxlYXN0JTIwNiUyMHBvaW50cyUyMGluJTIwdG90YWwuJTBBUmVwcmVzZW50JTIwdGhpcyUyMGFzJTIwc3BhdGlhbCUyMG1hcCUyMG9mJTIwdGhlJTIwd29ybGQlMkMlMjB3aXRoJTIwdGhlJTIwbG9jYXRpb25zJTIwcmVwcmVzZW50ZWQlMjBhcyUyMHNjYXR0ZXIlMjBwb2ludHMlMjB3aXRoJTIwYSUyMGNvbG9yJTIwdGhhdCUyMGRlcGVuZHMlMjBvbiUyMHRoZSUyMHRyYXZlbCUyMHRpbWUlMkMlMjBhbmQlMjBzYXZlJTIwaXQlMjB0byUyMHNhdmVkX21hcC5wbmchJTBBJTBBSGVyZSdzJTIwYW4lMjBleGFtcGxlJTIwb2YlMjBob3clMjB0byUyMHBsb3QlMjBhbmQlMjByZXR1cm4lMjBhJTIwbWFwJTNBJTBBaW1wb3J0JTIwcGxvdGx5LmV4cHJlc3MlMjBhcyUyMHB4JTBBZGYlMjAlM0QlMjBweC5kYXRhLmNhcnNoYXJlKCklMEFmaWclMjAlM0QlMjBweC5zY2F0dGVyX21hcChkZiUyQyUyMGxhdCUzRCUyMmNlbnRyb2lkX2xhdCUyMiUyQyUyMGxvbiUzRCUyMmNlbnRyb2lkX2xvbiUyMiUyQyUyMHRleHQlM0QlMjJuYW1lJTIyJTJDJTIwY29sb3IlM0QlMjJwZWFrX2hvdXIlMjIlMkMlMjBzaXplJTNEMTAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwY29sb3JfY29udGludW91c19zY2FsZSUzRHB4LmNvbG9ycy5zZXF1ZW50aWFsLk1hZ21hJTJDJTIwc2l6ZV9tYXglM0QxNSUyQyUyMHpvb20lM0QxKSUwQWZpZy5zaG93KCklMEFmaWcud3JpdGVfaW1hZ2UoJTIyc2F2ZWRfaW1hZ2UucG5nJTIyKSUwQWZpbmFsX2Fuc3dlcihmaWcpJTBBJTBBTmV2ZXIlMjB0cnklMjB0byUyMHByb2Nlc3MlMjBzdHJpbmdzJTIwdXNpbmclMjBjb2RlJTNBJTIwd2hlbiUyMHlvdSUyMGhhdmUlMjBhJTIwc3RyaW5nJTIwdG8lMjByZWFkJTJDJTIwanVzdCUyMHByaW50JTIwaXQlMjBhbmQlMjB5b3UnbGwlMjBzZWUlMjBpdC4lMEElMjIlMjIlMjIp",highlighted:`manager_agent.run(<span class="hljs-string">&quot;&quot;&quot;
Find all Batman filming locations in the world, calculate the time to transfer via cargo plane to here (we&#x27;re in Gotham, 40.7128° N, 74.0060° W).
Also give me some supercar factories with the same cargo plane transfer time. You need at least 6 points in total.
Represent this as spatial map of the world, with the locations represented as scatter points with a color that depends on the travel time, and save it to saved_map.png!

Here&#x27;s an example of how to plot and return a map:
import plotly.express as px
df = px.data.carshare()
fig = px.scatter_map(df, lat=&quot;centroid_lat&quot;, lon=&quot;centroid_lon&quot;, text=&quot;name&quot;, color=&quot;peak_hour&quot;, size=100,
     color_continuous_scale=px.colors.sequential.Magma, size_max=15, zoom=1)
fig.show()
fig.write_image(&quot;saved_image.png&quot;)
final_answer(fig)

Never try to process strings using code: when you have a string to read, just print it and you&#x27;ll see it.
&quot;&quot;&quot;</span>)`,wrap:!1}}),Ql=new i({props:{code:"bWFuYWdlcl9hZ2VudC5weXRob25fZXhlY3V0b3Iuc3RhdGUlNUIlMjJmaWclMjIlNUQ=",highlighted:'manager_agent.python_executor.state[<span class="hljs-string">&quot;fig&quot;</span>]',wrap:!1}}),bl=new Bl({props:{title:"Ressources",local:"ressources",headingTag:"h2"}}),Sl=new MT({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/fr/unit2/smolagents/multi_agent_systems.mdx"}}),{c(){a=j("meta"),El=e(),hl=j("p"),gl=e(),s(o.$$.fragment),Gl=e(),s(r.$$.fragment),Zl=e(),u=j("p"),u.innerHTML=MU,vl=e(),c=j("p"),c.innerHTML=UU,fl=e(),d=j("p"),d.textContent=TU,Wl=e(),O=j("ul"),O.innerHTML=eU,Xl=e(),m=j("p"),m.innerHTML=yU,kl=e(),V=j("img"),xl=e(),s(Q.$$.fragment),Yl=e(),N=j("p"),N.innerHTML=CU,zl=e(),R=j("p"),R.innerHTML=tU,Hl=e(),b=j("ul"),b.innerHTML=sU,_l=e(),F=j("p"),F.textContent=JU,$l=e(),s(S.$$.fragment),Ll=e(),p=j("blockquote"),p.innerHTML=IU,ql=e(),B=j("p"),B.textContent=AU,Kl=e(),h=j("p"),h.textContent=nU,Pl=e(),D=j("p"),D.textContent=wU,lM=e(),E=j("p"),E.textContent=iU,MM=e(),g=j("p"),g.textContent=aU,UM=e(),G=j("blockquote"),G.innerHTML=pU,TM=e(),Z=j("p"),Z.textContent=oU,eM=e(),v=j("p"),v.textContent=rU,yM=e(),s(f.$$.fragment),jM=e(),s(W.$$.fragment),CM=e(),s(X.$$.fragment),tM=e(),s(k.$$.fragment),sM=e(),x=j("p"),x.innerHTML=uU,JM=e(),Y=j("p"),Y.innerHTML=cU,IM=e(),z=j("p"),z.innerHTML=dU,AM=e(),s(H.$$.fragment),nM=e(),_=j("p"),_.textContent=OU,wM=e(),s($.$$.fragment),iM=e(),s(L.$$.fragment),aM=e(),s(q.$$.fragment),pM=e(),s(K.$$.fragment),oM=e(),P=j("p"),P.textContent=mU,rM=e(),s(ll.$$.fragment),uM=e(),Ml=j("p"),Ml.innerHTML=VU,cM=e(),Ul=j("p"),Ul.textContent=QU,dM=e(),s(Tl.$$.fragment),OM=e(),s(el.$$.fragment),mM=e(),yl=j("p"),yl.textContent=NU,VM=e(),s(jl.$$.fragment),QM=e(),Cl=j("p"),Cl.innerHTML=RU,NM=e(),tl=j("p"),tl.innerHTML=bU,RM=e(),sl=j("p"),sl.textContent=FU,bM=e(),s(Jl.$$.fragment),FM=e(),Il=j("p"),Il.textContent=SU,SM=e(),Al=j("ul"),Al.innerHTML=BU,BM=e(),nl=j("p"),nl.textContent=hU,hM=e(),wl=j("p"),wl.innerHTML=DU,DM=e(),s(il.$$.fragment),EM=e(),al=j("p"),al.textContent=EU,gM=e(),pl=j("p"),pl.innerHTML=gU,GM=e(),s(ol.$$.fragment),ZM=e(),rl=j("p"),rl.textContent=GU,vM=e(),s(ul.$$.fragment),fM=e(),cl=j("p"),cl.textContent=ZU,WM=e(),s(dl.$$.fragment),XM=e(),s(Ol.$$.fragment),kM=e(),ml=j("p"),ml.innerHTML=vU,xM=e(),Vl=j("p"),Vl.textContent=fU,YM=e(),s(Ql.$$.fragment),zM=e(),Nl=j("p"),Nl.textContent=WU,HM=e(),Rl=j("p"),Rl.innerHTML=XU,_M=e(),s(bl.$$.fragment),$M=e(),Fl=j("ul"),Fl.innerHTML=kU,LM=e(),s(Sl.$$.fragment),qM=e(),Dl=j("p"),this.h()},l(l){const M=qU("svelte-u9bgzb",document.head);a=C(M,"META",{name:!0,content:!0}),M.forEach(U),El=y(l),hl=C(l,"P",{}),xU(hl).forEach(U),gl=y(l),J(o.$$.fragment,l),Gl=y(l),J(r.$$.fragment,l),Zl=y(l),u=C(l,"P",{"data-svelte-h":!0}),t(u)!=="svelte-1ejpric"&&(u.innerHTML=MU),vl=y(l),c=C(l,"P",{"data-svelte-h":!0}),t(c)!=="svelte-z8cfut"&&(c.innerHTML=UU),fl=y(l),d=C(l,"P",{"data-svelte-h":!0}),t(d)!=="svelte-1m23n4b"&&(d.textContent=TU),Wl=y(l),O=C(l,"UL",{"data-svelte-h":!0}),t(O)!=="svelte-vwuhe6"&&(O.innerHTML=eU),Xl=y(l),m=C(l,"P",{"data-svelte-h":!0}),t(m)!=="svelte-djw2wy"&&(m.innerHTML=yU),kl=y(l),V=C(l,"IMG",{src:!0,style:!0}),xl=y(l),J(Q.$$.fragment,l),Yl=y(l),N=C(l,"P",{"data-svelte-h":!0}),t(N)!=="svelte-wat2kw"&&(N.innerHTML=CU),zl=y(l),R=C(l,"P",{"data-svelte-h":!0}),t(R)!=="svelte-6c9tln"&&(R.innerHTML=tU),Hl=y(l),b=C(l,"UL",{"data-svelte-h":!0}),t(b)!=="svelte-1o2l7cu"&&(b.innerHTML=sU),_l=y(l),F=C(l,"P",{"data-svelte-h":!0}),t(F)!=="svelte-ldidxu"&&(F.textContent=JU),$l=y(l),J(S.$$.fragment,l),Ll=y(l),p=C(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),t(p)!=="svelte-1gmiwp6"&&(p.innerHTML=IU),ql=y(l),B=C(l,"P",{"data-svelte-h":!0}),t(B)!=="svelte-te02p6"&&(B.textContent=AU),Kl=y(l),h=C(l,"P",{"data-svelte-h":!0}),t(h)!=="svelte-85e8m2"&&(h.textContent=nU),Pl=y(l),D=C(l,"P",{"data-svelte-h":!0}),t(D)!=="svelte-1vntfuj"&&(D.textContent=wU),lM=y(l),E=C(l,"P",{"data-svelte-h":!0}),t(E)!=="svelte-ci5r7t"&&(E.textContent=iU),MM=y(l),g=C(l,"P",{"data-svelte-h":!0}),t(g)!=="svelte-k90i08"&&(g.textContent=aU),UM=y(l),G=C(l,"BLOCKQUOTE",{"data-svelte-h":!0}),t(G)!=="svelte-guoqzr"&&(G.innerHTML=pU),TM=y(l),Z=C(l,"P",{"data-svelte-h":!0}),t(Z)!=="svelte-1jfyogc"&&(Z.textContent=oU),eM=y(l),v=C(l,"P",{"data-svelte-h":!0}),t(v)!=="svelte-1itl8qe"&&(v.textContent=rU),yM=y(l),J(f.$$.fragment,l),jM=y(l),J(W.$$.fragment,l),CM=y(l),J(X.$$.fragment,l),tM=y(l),J(k.$$.fragment,l),sM=y(l),x=C(l,"P",{"data-svelte-h":!0}),t(x)!=="svelte-txiqlx"&&(x.innerHTML=uU),JM=y(l),Y=C(l,"P",{"data-svelte-h":!0}),t(Y)!=="svelte-avmskx"&&(Y.innerHTML=cU),IM=y(l),z=C(l,"P",{"data-svelte-h":!0}),t(z)!=="svelte-1o1qcjq"&&(z.innerHTML=dU),AM=y(l),J(H.$$.fragment,l),nM=y(l),_=C(l,"P",{"data-svelte-h":!0}),t(_)!=="svelte-1f4606u"&&(_.textContent=OU),wM=y(l),J($.$$.fragment,l),iM=y(l),J(L.$$.fragment,l),aM=y(l),J(q.$$.fragment,l),pM=y(l),J(K.$$.fragment,l),oM=y(l),P=C(l,"P",{"data-svelte-h":!0}),t(P)!=="svelte-1ftfkvc"&&(P.textContent=mU),rM=y(l),J(ll.$$.fragment,l),uM=y(l),Ml=C(l,"P",{"data-svelte-h":!0}),t(Ml)!=="svelte-1bh7dkh"&&(Ml.innerHTML=VU),cM=y(l),Ul=C(l,"P",{"data-svelte-h":!0}),t(Ul)!=="svelte-14yn4d7"&&(Ul.textContent=QU),dM=y(l),J(Tl.$$.fragment,l),OM=y(l),J(el.$$.fragment,l),mM=y(l),yl=C(l,"P",{"data-svelte-h":!0}),t(yl)!=="svelte-1ftfkvc"&&(yl.textContent=NU),VM=y(l),J(jl.$$.fragment,l),QM=y(l),Cl=C(l,"P",{"data-svelte-h":!0}),t(Cl)!=="svelte-2s7fkm"&&(Cl.innerHTML=RU),NM=y(l),tl=C(l,"P",{"data-svelte-h":!0}),t(tl)!=="svelte-pj7d94"&&(tl.innerHTML=bU),RM=y(l),sl=C(l,"P",{"data-svelte-h":!0}),t(sl)!=="svelte-12kwd26"&&(sl.textContent=FU),bM=y(l),J(Jl.$$.fragment,l),FM=y(l),Il=C(l,"P",{"data-svelte-h":!0}),t(Il)!=="svelte-4a3ixt"&&(Il.textContent=SU),SM=y(l),Al=C(l,"UL",{"data-svelte-h":!0}),t(Al)!=="svelte-cexoz3"&&(Al.innerHTML=BU),BM=y(l),nl=C(l,"P",{"data-svelte-h":!0}),t(nl)!=="svelte-1tv63is"&&(nl.textContent=hU),hM=y(l),wl=C(l,"P",{"data-svelte-h":!0}),t(wl)!=="svelte-n7inle"&&(wl.innerHTML=DU),DM=y(l),J(il.$$.fragment,l),EM=y(l),al=C(l,"P",{"data-svelte-h":!0}),t(al)!=="svelte-qlc3to"&&(al.textContent=EU),gM=y(l),pl=C(l,"P",{"data-svelte-h":!0}),t(pl)!=="svelte-2ljo26"&&(pl.innerHTML=gU),GM=y(l),J(ol.$$.fragment,l),ZM=y(l),rl=C(l,"P",{"data-svelte-h":!0}),t(rl)!=="svelte-lkzymi"&&(rl.textContent=GU),vM=y(l),J(ul.$$.fragment,l),fM=y(l),cl=C(l,"P",{"data-svelte-h":!0}),t(cl)!=="svelte-1v92z29"&&(cl.textContent=ZU),WM=y(l),J(dl.$$.fragment,l),XM=y(l),J(Ol.$$.fragment,l),kM=y(l),ml=C(l,"P",{"data-svelte-h":!0}),t(ml)!=="svelte-1pfllib"&&(ml.innerHTML=vU),xM=y(l),Vl=C(l,"P",{"data-svelte-h":!0}),t(Vl)!=="svelte-24z0c7"&&(Vl.textContent=fU),YM=y(l),J(Ql.$$.fragment,l),zM=y(l),Nl=C(l,"P",{"data-svelte-h":!0}),t(Nl)!=="svelte-i90ooy"&&(Nl.textContent=WU),HM=y(l),Rl=C(l,"P",{"data-svelte-h":!0}),t(Rl)!=="svelte-1ioyck"&&(Rl.innerHTML=XU),_M=y(l),J(bl.$$.fragment,l),$M=y(l),Fl=C(l,"UL",{"data-svelte-h":!0}),t(Fl)!=="svelte-1khk9mx"&&(Fl.innerHTML=kU),LM=y(l),J(Sl.$$.fragment,l),qM=y(l),Dl=C(l,"P",{}),xU(Dl).forEach(U),this.h()},h(){PM(a,"name","hf:doc:metadata"),PM(a,"content",TT),zU(V.src,jU="https://mermaid.ink/img/pako:eNp1kc1qhTAQRl9FUiQb8wIpdNO76eKubrmFks1oRg3VSYgjpYjv3lFL_2hnMWQOJwn5sqgmelRWleUSKLAtFs09jqhtoWuYUFfFAa6QA9QDTnpzamheuhxn8pt40-6l13UtS0ddhtQXj6dbR4XUGQg6zEYasTF393KjeSDGnDJKNxzj8I_7hLW5IOSmP9CH9hv_NL-d94d4DVNg84p1EnK4qlIj5hGClySWbadT-6OdsrL02MI8sFOOVkciw8zx8kaNspxnrJQE0fXKtjBMMs3JA-MpgOQwftIE9Bzj14w-cMznI_39E9Z3p0uFoA?type=png")||PM(V,"src",jU),KU(V,"background","white"),PM(p,"class","tip")},m(l,M){PU(document.head,a),T(l,El,M),T(l,hl,M),T(l,gl,M),I(o,l,M),T(l,Gl,M),I(r,l,M),T(l,Zl,M),T(l,u,M),T(l,vl,M),T(l,c,M),T(l,fl,M),T(l,d,M),T(l,Wl,M),T(l,O,M),T(l,Xl,M),T(l,m,M),T(l,kl,M),T(l,V,M),T(l,xl,M),I(Q,l,M),T(l,Yl,M),T(l,N,M),T(l,zl,M),T(l,R,M),T(l,Hl,M),T(l,b,M),T(l,_l,M),T(l,F,M),T(l,$l,M),I(S,l,M),T(l,Ll,M),T(l,p,M),T(l,ql,M),T(l,B,M),T(l,Kl,M),T(l,h,M),T(l,Pl,M),T(l,D,M),T(l,lM,M),T(l,E,M),T(l,MM,M),T(l,g,M),T(l,UM,M),T(l,G,M),T(l,TM,M),T(l,Z,M),T(l,eM,M),T(l,v,M),T(l,yM,M),I(f,l,M),T(l,jM,M),I(W,l,M),T(l,CM,M),I(X,l,M),T(l,tM,M),I(k,l,M),T(l,sM,M),T(l,x,M),T(l,JM,M),T(l,Y,M),T(l,IM,M),T(l,z,M),T(l,AM,M),I(H,l,M),T(l,nM,M),T(l,_,M),T(l,wM,M),I($,l,M),T(l,iM,M),I(L,l,M),T(l,aM,M),I(q,l,M),T(l,pM,M),I(K,l,M),T(l,oM,M),T(l,P,M),T(l,rM,M),I(ll,l,M),T(l,uM,M),T(l,Ml,M),T(l,cM,M),T(l,Ul,M),T(l,dM,M),I(Tl,l,M),T(l,OM,M),I(el,l,M),T(l,mM,M),T(l,yl,M),T(l,VM,M),I(jl,l,M),T(l,QM,M),T(l,Cl,M),T(l,NM,M),T(l,tl,M),T(l,RM,M),T(l,sl,M),T(l,bM,M),I(Jl,l,M),T(l,FM,M),T(l,Il,M),T(l,SM,M),T(l,Al,M),T(l,BM,M),T(l,nl,M),T(l,hM,M),T(l,wl,M),T(l,DM,M),I(il,l,M),T(l,EM,M),T(l,al,M),T(l,gM,M),T(l,pl,M),T(l,GM,M),I(ol,l,M),T(l,ZM,M),T(l,rl,M),T(l,vM,M),I(ul,l,M),T(l,fM,M),T(l,cl,M),T(l,WM,M),I(dl,l,M),T(l,XM,M),I(Ol,l,M),T(l,kM,M),T(l,ml,M),T(l,xM,M),T(l,Vl,M),T(l,YM,M),I(Ql,l,M),T(l,zM,M),T(l,Nl,M),T(l,HM,M),T(l,Rl,M),T(l,_M,M),I(bl,l,M),T(l,$M,M),T(l,Fl,M),T(l,LM,M),I(Sl,l,M),T(l,qM,M),T(l,Dl,M),KM=!0},p:HU,i(l){KM||(A(o.$$.fragment,l),A(r.$$.fragment,l),A(Q.$$.fragment,l),A(S.$$.fragment,l),A(f.$$.fragment,l),A(W.$$.fragment,l),A(X.$$.fragment,l),A(k.$$.fragment,l),A(H.$$.fragment,l),A($.$$.fragment,l),A(L.$$.fragment,l),A(q.$$.fragment,l),A(K.$$.fragment,l),A(ll.$$.fragment,l),A(Tl.$$.fragment,l),A(el.$$.fragment,l),A(jl.$$.fragment,l),A(Jl.$$.fragment,l),A(il.$$.fragment,l),A(ol.$$.fragment,l),A(ul.$$.fragment,l),A(dl.$$.fragment,l),A(Ol.$$.fragment,l),A(Ql.$$.fragment,l),A(bl.$$.fragment,l),A(Sl.$$.fragment,l),KM=!0)},o(l){n(o.$$.fragment,l),n(r.$$.fragment,l),n(Q.$$.fragment,l),n(S.$$.fragment,l),n(f.$$.fragment,l),n(W.$$.fragment,l),n(X.$$.fragment,l),n(k.$$.fragment,l),n(H.$$.fragment,l),n($.$$.fragment,l),n(L.$$.fragment,l),n(q.$$.fragment,l),n(K.$$.fragment,l),n(ll.$$.fragment,l),n(Tl.$$.fragment,l),n(el.$$.fragment,l),n(jl.$$.fragment,l),n(Jl.$$.fragment,l),n(il.$$.fragment,l),n(ol.$$.fragment,l),n(ul.$$.fragment,l),n(dl.$$.fragment,l),n(Ol.$$.fragment,l),n(Ql.$$.fragment,l),n(bl.$$.fragment,l),n(Sl.$$.fragment,l),KM=!1},d(l){l&&(U(El),U(hl),U(gl),U(Gl),U(Zl),U(u),U(vl),U(c),U(fl),U(d),U(Wl),U(O),U(Xl),U(m),U(kl),U(V),U(xl),U(Yl),U(N),U(zl),U(R),U(Hl),U(b),U(_l),U(F),U($l),U(Ll),U(p),U(ql),U(B),U(Kl),U(h),U(Pl),U(D),U(lM),U(E),U(MM),U(g),U(UM),U(G),U(TM),U(Z),U(eM),U(v),U(yM),U(jM),U(CM),U(tM),U(sM),U(x),U(JM),U(Y),U(IM),U(z),U(AM),U(nM),U(_),U(wM),U(iM),U(aM),U(pM),U(oM),U(P),U(rM),U(uM),U(Ml),U(cM),U(Ul),U(dM),U(OM),U(mM),U(yl),U(VM),U(QM),U(Cl),U(NM),U(tl),U(RM),U(sl),U(bM),U(FM),U(Il),U(SM),U(Al),U(BM),U(nl),U(hM),U(wl),U(DM),U(EM),U(al),U(gM),U(pl),U(GM),U(ZM),U(rl),U(vM),U(fM),U(cl),U(WM),U(XM),U(kM),U(ml),U(xM),U(Vl),U(YM),U(zM),U(Nl),U(HM),U(Rl),U(_M),U($M),U(Fl),U(LM),U(qM),U(Dl)),U(a),w(o,l),w(r,l),w(Q,l),w(S,l),w(f,l),w(W,l),w(X,l),w(k,l),w(H,l),w($,l),w(L,l),w(q,l),w(K,l),w(ll,l),w(Tl,l),w(el,l),w(jl,l),w(Jl,l),w(il,l),w(ol,l),w(ul,l),w(dl,l),w(Ol,l),w(Ql,l),w(bl,l),w(Sl,l)}}}const TT='{"title":"Systèmes multi-agents","local":"systèmes-multi-agents","sections":[{"title":"Systèmes multi-agents en action","local":"systèmes-multi-agents-en-action","sections":[],"depth":2},{"title":"Résoudre une tâche complexe avec une hiérarchie multi-agents","local":"résoudre-une-tâche-complexe-avec-une-hiérarchie-multi-agents","sections":[{"title":"Nous créons d’abord un outil pour obtenir le temps de transfert en avion cargo.","local":"nous-créons-dabord-un-outil-pour-obtenir-le-temps-de-transfert-en-avion-cargo","sections":[],"depth":3},{"title":"Configuration de l’agent","local":"configuration-de-lagent","sections":[],"depth":3},{"title":"✌️ Diviser la tâche entre deux agents","local":"-diviser-la-tâche-entre-deux-agents","sections":[],"depth":3}],"depth":2},{"title":"Ressources","local":"ressources","sections":[],"depth":2}],"depth":1}';function eT(lU){return _U(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class IT extends $U{constructor(a){super(),LU(this,a,eT,UT,YU,{})}}export{IT as component};
