import{s as dt,f as mt,n as Mt,o as ft}from"../chunks/scheduler.37c15a92.js";import{S as yt,i as Tt,g as a,s as l,r as R,A as gt,h as r,f as n,c as i,j as ut,u as P,x as o,k as F,y as vt,a as s,v as X,d as k,t as V,w as Y}from"../chunks/index.2bf4358c.js";import{C as ct}from"../chunks/CodeBlock.4e987730.js";import{H as Qe}from"../chunks/Heading.8ada512a.js";import{E as Ut}from"../chunks/getInferenceSnippets.0aa3753f.js";function ht(Se){let p,D,W,K,c,ee,u,ze="<p>Dans cette section, nous explorons les étapes concrètes qu’un agent entreprend pour interagir avec son environnement.</p> <p>Nous aborderons la manière dont les actions sont représentées (en utilisant du JSON ou du code), l’importance de l’approche <i>stop</i> and <i>parse</i>, et nous présenterons différents types d’agents.</p>",te,d,Ae="Les actions sont les étapes concrètes qu’un <strong>agent entreprend pour interagir avec son environnement</strong>.",ne,m,Ze="Que ce soit pour naviguer sur le web à la recherche d’informations ou pour contrôler un dispositif physique, chaque action est une opération délibérée exécutée par l’agent.",se,M,Ge="Par exemple, un agent assistant au service client pourrait récupérer des données client, proposer des articles de support ou transférer des problèmes à un représentant humain.",le,f,ie,y,Ne="Il existe plusieurs types d’agents qui réalisent des actions de manières différentes :",ae,T,Re="<thead><tr><th>Type d’Agent</th> <th>Description</th></tr></thead> <tbody><tr><td>Agent à JSON</td> <td>L’action à entreprendre est spécifiée au format JSON.</td></tr> <tr><td>Agent à code</td> <td>L’agent génère un bloc de code qui est interprété de manière externe.</td></tr> <tr><td>Agent à appel de fonction</td> <td>Il s’agit d’une sous-catégorie de l’agent JSON qui a été affiné pour générer un nouveau message pour chaque action.</td></tr></tbody>",re,g,Pe="Les actions elles-mêmes peuvent remplir de nombreux objectifs :",oe,v,Xe="<thead><tr><th>Type d’Action</th> <th>Description</th></tr></thead> <tbody><tr><td>Collecte d’informations</td> <td>Effectuer des recherches sur le web, interroger des bases de données ou récupérer des documents.</td></tr> <tr><td>Utilisation d’outils</td> <td>Effectuer des appels API, réaliser des calculs et exécuter du code.</td></tr> <tr><td>Interaction avec l’environnement</td> <td>Manipuler des interfaces numériques ou contrôler des dispositifs physiques.</td></tr> <tr><td>Communication</td> <td>Interagir avec les utilisateurs via le chat ou collaborer avec d’autres agents.</td></tr></tbody>",pe,U,ke=`Le LLM ne gère que du texte et l’utilise pour décrire l’action qu’il souhaite entreprendre ainsi que les paramètres à fournir à l’outil.
Pour qu’un agent fonctionne correctement, le LLM doit savoir <strong>ARRÊTER de générer de nouveaux <em>tokens</em> lorsque l’action est terminée</strong>. Cela permet de transférer le contrôle du LLM à l’agent et de s’assurer que le résultat est analysable, que le format prévu soit JSON, du code ou des appels de fonctions.`,ue,h,ce,J,Ve="Une méthode clé pour implémenter des actions est l’<strong>approche <em>stop</em> and <em>parse</em></strong>. Cette méthode garantit que la sortie de l’agent est structurée et prévisible :",de,C,Ye="<li><p><strong>Génération dans un format structuré</strong> :</p> <p>L’agent produit l’action envisagée dans un format clair et prédéfini (JSON ou code).</p></li> <li><p><strong>Arrêt de la génération</strong> :</p> <p>Une fois que le texte définissant l’action a été émis, le <strong>LLM cesse de générer des <em>tokens</em> supplémentaires</strong>. Cela permet d’éviter les sorties supplémentaires ou erronées.</p></li> <li><p><strong>Analyse de la sortie</strong> :</p> <p>Un parseur externe lit l’action formatée, détermine quel outil appeler, et extrait les paramètres requis.</p></li>",me,b,We="Par exemple, un agent ayant besoin de vérifier la météo pourrait produire la sortie suivante :",Me,x,fe,w,Oe="Le <em>framework</em> peut ensuite analyser facilement le nom de la fonction à appeler et les arguments à fournir.",ye,j,Fe="Ce format clair et lisible par une machine minimise les erreurs et permet aux outils externes de traiter avec précision la commande de l’agent.",Te,q,De="<p>Note : Les agents à appel de fonction fonctionnent de manière similaire en structurant chaque action de manière à ce qu’une fonction désignée soit invoquée avec les arguments corrects. Nous approfondirons ces types d’agents dans une prochaine unité.</p>",ge,I,ve,L,Ke=`Une approche alternative consiste à utiliser des <em>agents [générateur de] code</em>.<br/>
L’idée est : <strong>au lieu de produire un simple objet JSON</strong>, un agent code génère un <strong>bloc de code exécutable — typiquement dans un langage de haut niveau comme Python</strong>.`,Ue,_,et,he,$,tt="Cette approche offre plusieurs avantages :",Je,B,nt="<li><strong>Expressivité :</strong> Le code peut naturellement représenter une logique complexe, incluant des boucles, des conditionnels et des fonctions imbriquées, offrant ainsi une flexibilité supérieure au JSON.</li> <li><strong>Modularité et réutilisabilité :</strong> Le code généré peut inclure des fonctions et des modules réutilisables pour différentes actions ou tâches.</li> <li><strong>Débogage amélioré :</strong> Grâce à une syntaxe de programmation bien définie, les erreurs de code sont souvent plus faciles à détecter et corriger.</li> <li><strong>Intégration directe :</strong> Les agents à code peuvent s’intégrer directement avec des bibliothèques et des API externes, permettant ainsi des opérations plus complexes comme le traitement de données ou la prise de décision en temps réel.</li>",Ce,H,st="Par exemple, un agent à code chargé de récupérer la météo pourrait générer l’extrait Python suivant :",be,E,xe,Q,lt="Dans cet exemple, l’agent à code :",we,S,it="<li>Récupère des données météo <strong>via un appel API</strong>,</li> <li>Traite la réponse,</li> <li>Et utilise la fonction <code>print()</code> pour afficher la réponse finale.</li>",je,z,at="Cette méthode <strong>suit également l’approche <em>stop and parse</em></strong> en délimitant clairement le bloc de code et en signalant quand l’exécution est terminée (ici, par l’affichage de <code>final_answer</code>).",qe,Ie,Le,A,rt="Nous avons vu que les actions font le lien entre le raisonnement interne de l’agent et ses interactions réelles en exécutant des tâches claires et structurées — que ce soit via JSON, du code ou des appels de fonctions.",_e,Z,ot="Cette exécution délibérée garantit que chaque action est précise et prête pour un traitement externe via l’approche <em>stop and parse</em>. Dans la section suivante, nous explorerons les Observations pour voir comment les agents capturent et intègrent les retours de leur environnement.",$e,G,pt="Après cela, nous serons <strong>finalement prêts à construire notre premier agent !</strong>",Be,N,He,O,Ee;return c=new Qe({props:{title:"Actions : permettre à l’agent d’interagir avec son environnement",local:"actions--permettre-à-lagent-dinteragir-avec-son-environnement",headingTag:"h1"}}),f=new Qe({props:{title:"Types d’actions",local:"types-dactions",headingTag:"h2"}}),h=new Qe({props:{title:"L’approche Stop and Parse",local:"lapproche-stop-and-parse",headingTag:"h2"}}),x=new ct({props:{code:"VGhvdWdodCUzQSUyMEplJTIwZG9pcyUyMHYlQzMlQTlyaWZpZXIlMjBsZSUyMHRlbXBzJTIwcXUnaWwlMjBmYWl0JTIwJUMzJUEwJTIwTmV3JTIwWW9yay4lMEFBY3Rpb24lMjAlM0ElMEElN0IlMEElMjAlMjAlMjJhY3Rpb24lMjIlM0ElMjAlMjJnZXRfd2VhdGhlciUyMiUyQyUwQSUyMCUyMCUyMmFjdGlvbl9pbnB1dCUyMiUzQSUyMCU3QiUyMmxvY2F0aW9uJTIyJTNBJTIwJTIyTmV3JTIwWW9yayUyMiU3RCUwQSU3RA==",highlighted:`Thought<span class="hljs-punctuation">:</span> Je dois vérifier le temps qu&#x27;il fait à New York.
Action <span class="hljs-punctuation">:</span>
<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;action&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;get_weather&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;action_input&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;location&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;New York&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),I=new Qe({props:{title:"Agents à code",local:"agents-à-code",headingTag:"h2"}}),E=new ct({props:{code:"JTIzJTIwRXhlbXBsZSUyMGQnQWdlbnQlMjBDb2RlJTIwJTNBJTIwUiVDMyVBOWN1cCVDMyVBOXJlciUyMGRlcyUyMGluZm9ybWF0aW9ucyUyMG0lQzMlQTl0JUMzJUE5b3JvbG9naXF1ZXMlMEFkZWYlMjBnZXRfd2VhdGhlcihjaXR5KSUzQSUwQSUyMCUyMCUyMCUyMGltcG9ydCUyMHJlcXVlc3RzJTBBJTIwJTIwJTIwJTIwYXBpX3VybCUyMCUzRCUyMGYlMjJodHRwcyUzQSUyRiUyRmFwaS53ZWF0aGVyLmNvbSUyRnYxJTJGbG9jYXRpb24lMkYlN0JjaXR5JTdEJTNGYXBpS2V5JTNEWU9VUl9BUElfS0VZJTIyJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjByZXF1ZXN0cy5nZXQoYXBpX3VybCklMEElMjAlMjAlMjAlMjBpZiUyMHJlc3BvbnNlLnN0YXR1c19jb2RlJTIwJTNEJTNEJTIwMjAwJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0YSUyMCUzRCUyMHJlc3BvbnNlLmpzb24oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGRhdGEuZ2V0KCUyMndlYXRoZXIlMjIlMkMlMjAlMjJBdWN1bmUlMjBpbmZvcm1hdGlvbiUyMG0lQzMlQTl0JUMzJUE5byUyMGRpc3BvbmlibGUlMjIpJTBBJTIwJTIwJTIwJTIwZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCUyMkVycmV1ciUyMCUzQSUyMEltcG9zc2libGUlMjBkZSUyMHIlQzMlQTljdXAlQzMlQTlyZXIlMjBsZXMlMjBkb25uJUMzJUE5ZXMlMjBtJUMzJUE5dCVDMyVBOW8uJTIyJTBBJTBBJTIzJTIwRXglQzMlQTljdXRlciUyMGxhJTIwZm9uY3Rpb24lMjBldCUyMHByJUMzJUE5cGFyZXIlMjBsYSUyMHIlQzMlQTlwb25zZSUyMGZpbmFsZSUwQXJlc3VsdCUyMCUzRCUyMGdldF93ZWF0aGVyKCUyMk5ldyUyMFlvcmslMjIpJTBBZmluYWxfYW5zd2VyJTIwJTNEJTIwZiUyMkxhJTIwbSVDMyVBOXQlQzMlQTlvJTIwYWN0dWVsbGUlMjAlQzMlQTAlMjBOZXclMjBZb3JrJTIwZXN0JTIwJTNBJTIwJTdCcmVzdWx0JTdEJTIyJTBBcHJpbnQoZmluYWxfYW5zd2VyKQ==",highlighted:`<span class="hljs-comment"># Exemple d&#x27;Agent Code : Récupérer des informations météorologiques</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_weather</span>(<span class="hljs-params">city</span>):
    <span class="hljs-keyword">import</span> requests
    api_url = <span class="hljs-string">f&quot;https://api.weather.com/v1/location/<span class="hljs-subst">{city}</span>?apiKey=YOUR_API_KEY&quot;</span>
    response = requests.get(api_url)
    <span class="hljs-keyword">if</span> response.status_code == <span class="hljs-number">200</span>:
        data = response.json()
        <span class="hljs-keyword">return</span> data.get(<span class="hljs-string">&quot;weather&quot;</span>, <span class="hljs-string">&quot;Aucune information météo disponible&quot;</span>)
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Erreur : Impossible de récupérer les données météo.&quot;</span>

<span class="hljs-comment"># Exécuter la fonction et préparer la réponse finale</span>
result = get_weather(<span class="hljs-string">&quot;New York&quot;</span>)
final_answer = <span class="hljs-string">f&quot;La météo actuelle à New York est : <span class="hljs-subst">{result}</span>&quot;</span>
<span class="hljs-built_in">print</span>(final_answer)`,wrap:!1}}),N=new Ut({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/fr/unit1/actions.mdx"}}),{c(){p=a("meta"),D=l(),W=a("p"),K=l(),R(c.$$.fragment),ee=l(),u=a("blockquote"),u.innerHTML=ze,te=l(),d=a("p"),d.innerHTML=Ae,ne=l(),m=a("p"),m.textContent=Ze,se=l(),M=a("p"),M.textContent=Ge,le=l(),R(f.$$.fragment),ie=l(),y=a("p"),y.textContent=Ne,ae=l(),T=a("table"),T.innerHTML=Re,re=l(),g=a("p"),g.textContent=Pe,oe=l(),v=a("table"),v.innerHTML=Xe,pe=l(),U=a("p"),U.innerHTML=ke,ue=l(),R(h.$$.fragment),ce=l(),J=a("p"),J.innerHTML=Ve,de=l(),C=a("ol"),C.innerHTML=Ye,me=l(),b=a("p"),b.textContent=We,Me=l(),R(x.$$.fragment),fe=l(),w=a("p"),w.innerHTML=Oe,ye=l(),j=a("p"),j.textContent=Fe,Te=l(),q=a("blockquote"),q.innerHTML=De,ge=l(),R(I.$$.fragment),ve=l(),L=a("p"),L.innerHTML=Ke,Ue=l(),_=a("img"),he=l(),$=a("p"),$.textContent=tt,Je=l(),B=a("ul"),B.innerHTML=nt,Ce=l(),H=a("p"),H.textContent=st,be=l(),R(E.$$.fragment),xe=l(),Q=a("p"),Q.textContent=lt,we=l(),S=a("ul"),S.innerHTML=it,je=l(),z=a("p"),z.innerHTML=at,qe=l(),Ie=a("hr"),Le=l(),A=a("p"),A.textContent=rt,_e=l(),Z=a("p"),Z.innerHTML=ot,$e=l(),G=a("p"),G.innerHTML=pt,Be=l(),R(N.$$.fragment),He=l(),O=a("p"),this.h()},l(e){const t=gt("svelte-u9bgzb",document.head);p=r(t,"META",{name:!0,content:!0}),t.forEach(n),D=i(e),W=r(e,"P",{}),ut(W).forEach(n),K=i(e),P(c.$$.fragment,e),ee=i(e),u=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(u)!=="svelte-oo722p"&&(u.innerHTML=ze),te=i(e),d=r(e,"P",{"data-svelte-h":!0}),o(d)!=="svelte-1697wml"&&(d.innerHTML=Ae),ne=i(e),m=r(e,"P",{"data-svelte-h":!0}),o(m)!=="svelte-4fz2z8"&&(m.textContent=Ze),se=i(e),M=r(e,"P",{"data-svelte-h":!0}),o(M)!=="svelte-1404tx8"&&(M.textContent=Ge),le=i(e),P(f.$$.fragment,e),ie=i(e),y=r(e,"P",{"data-svelte-h":!0}),o(y)!=="svelte-1fso4d5"&&(y.textContent=Ne),ae=i(e),T=r(e,"TABLE",{"data-svelte-h":!0}),o(T)!=="svelte-2hr652"&&(T.innerHTML=Re),re=i(e),g=r(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-1o3pjlj"&&(g.textContent=Pe),oe=i(e),v=r(e,"TABLE",{"data-svelte-h":!0}),o(v)!=="svelte-1md8d1s"&&(v.innerHTML=Xe),pe=i(e),U=r(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-1gi0wjo"&&(U.innerHTML=ke),ue=i(e),P(h.$$.fragment,e),ce=i(e),J=r(e,"P",{"data-svelte-h":!0}),o(J)!=="svelte-1j2776x"&&(J.innerHTML=Ve),de=i(e),C=r(e,"OL",{"data-svelte-h":!0}),o(C)!=="svelte-gq832m"&&(C.innerHTML=Ye),me=i(e),b=r(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1c5nt2s"&&(b.textContent=We),Me=i(e),P(x.$$.fragment,e),fe=i(e),w=r(e,"P",{"data-svelte-h":!0}),o(w)!=="svelte-18q8hc0"&&(w.innerHTML=Oe),ye=i(e),j=r(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-1bbqe0p"&&(j.textContent=Fe),Te=i(e),q=r(e,"BLOCKQUOTE",{"data-svelte-h":!0}),o(q)!=="svelte-gpl4dn"&&(q.innerHTML=De),ge=i(e),P(I.$$.fragment,e),ve=i(e),L=r(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-1becqkk"&&(L.innerHTML=Ke),Ue=i(e),_=r(e,"IMG",{src:!0,alt:!0}),he=i(e),$=r(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-hsjn6l"&&($.textContent=tt),Je=i(e),B=r(e,"UL",{"data-svelte-h":!0}),o(B)!=="svelte-g2neo8"&&(B.innerHTML=nt),Ce=i(e),H=r(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-16y7q2r"&&(H.textContent=st),be=i(e),P(E.$$.fragment,e),xe=i(e),Q=r(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-1hqpb3n"&&(Q.textContent=lt),we=i(e),S=r(e,"UL",{"data-svelte-h":!0}),o(S)!=="svelte-168stk7"&&(S.innerHTML=it),je=i(e),z=r(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-15wvbu7"&&(z.innerHTML=at),qe=i(e),Ie=r(e,"HR",{}),Le=i(e),A=r(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-2r0pbh"&&(A.textContent=rt),_e=i(e),Z=r(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-tnlt1c"&&(Z.innerHTML=ot),$e=i(e),G=r(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1x6jlyx"&&(G.innerHTML=pt),Be=i(e),P(N.$$.fragment,e),He=i(e),O=r(e,"P",{}),ut(O).forEach(n),this.h()},h(){F(p,"name","hf:doc:metadata"),F(p,"content",Jt),F(u,"class","tip"),mt(_.src,et="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/code-vs-json-actions.png")||F(_,"src",et),F(_,"alt","Agents Code")},m(e,t){vt(document.head,p),s(e,D,t),s(e,W,t),s(e,K,t),X(c,e,t),s(e,ee,t),s(e,u,t),s(e,te,t),s(e,d,t),s(e,ne,t),s(e,m,t),s(e,se,t),s(e,M,t),s(e,le,t),X(f,e,t),s(e,ie,t),s(e,y,t),s(e,ae,t),s(e,T,t),s(e,re,t),s(e,g,t),s(e,oe,t),s(e,v,t),s(e,pe,t),s(e,U,t),s(e,ue,t),X(h,e,t),s(e,ce,t),s(e,J,t),s(e,de,t),s(e,C,t),s(e,me,t),s(e,b,t),s(e,Me,t),X(x,e,t),s(e,fe,t),s(e,w,t),s(e,ye,t),s(e,j,t),s(e,Te,t),s(e,q,t),s(e,ge,t),X(I,e,t),s(e,ve,t),s(e,L,t),s(e,Ue,t),s(e,_,t),s(e,he,t),s(e,$,t),s(e,Je,t),s(e,B,t),s(e,Ce,t),s(e,H,t),s(e,be,t),X(E,e,t),s(e,xe,t),s(e,Q,t),s(e,we,t),s(e,S,t),s(e,je,t),s(e,z,t),s(e,qe,t),s(e,Ie,t),s(e,Le,t),s(e,A,t),s(e,_e,t),s(e,Z,t),s(e,$e,t),s(e,G,t),s(e,Be,t),X(N,e,t),s(e,He,t),s(e,O,t),Ee=!0},p:Mt,i(e){Ee||(k(c.$$.fragment,e),k(f.$$.fragment,e),k(h.$$.fragment,e),k(x.$$.fragment,e),k(I.$$.fragment,e),k(E.$$.fragment,e),k(N.$$.fragment,e),Ee=!0)},o(e){V(c.$$.fragment,e),V(f.$$.fragment,e),V(h.$$.fragment,e),V(x.$$.fragment,e),V(I.$$.fragment,e),V(E.$$.fragment,e),V(N.$$.fragment,e),Ee=!1},d(e){e&&(n(D),n(W),n(K),n(ee),n(u),n(te),n(d),n(ne),n(m),n(se),n(M),n(le),n(ie),n(y),n(ae),n(T),n(re),n(g),n(oe),n(v),n(pe),n(U),n(ue),n(ce),n(J),n(de),n(C),n(me),n(b),n(Me),n(fe),n(w),n(ye),n(j),n(Te),n(q),n(ge),n(ve),n(L),n(Ue),n(_),n(he),n($),n(Je),n(B),n(Ce),n(H),n(be),n(xe),n(Q),n(we),n(S),n(je),n(z),n(qe),n(Ie),n(Le),n(A),n(_e),n(Z),n($e),n(G),n(Be),n(He),n(O)),n(p),Y(c,e),Y(f,e),Y(h,e),Y(x,e),Y(I,e),Y(E,e),Y(N,e)}}}const Jt='{"title":"Actions : permettre à l’agent d’interagir avec son environnement","local":"actions--permettre-à-lagent-dinteragir-avec-son-environnement","sections":[{"title":"Types d’actions","local":"types-dactions","sections":[],"depth":2},{"title":"L’approche Stop and Parse","local":"lapproche-stop-and-parse","sections":[],"depth":2},{"title":"Agents à code","local":"agents-à-code","sections":[],"depth":2}],"depth":1}';function Ct(Se){return ft(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class It extends yt{constructor(p){super(),Tt(this,p,Ct,ht,dt,{})}}export{It as component};
