import{s as Xl,f as zl,n as _l,o as Hl}from"../chunks/scheduler.37c15a92.js";import{S as $l,i as ql,g as I,s as U,r as t,A as Ll,h as y,f as l,c as w,j as Fl,u as a,x as e,k as PT,l as Kl,y as Pl,a as M,v as s,d as n,t as j,w as C}from"../chunks/index.2bf4358c.js";import{C as i}from"../chunks/CodeBlock.4e987730.js";import{C as JM}from"../chunks/CourseFloatingBanner.6add7356.js";import{H as EJ}from"../chunks/Heading.8ada512a.js";import{E as TM}from"../chunks/getInferenceSnippets.0aa3753f.js";function lM(Jl){let o,ZJ,GJ,fJ,p,VJ,r,DJ,g,Tl="Los sistemas multi-agente permiten que <strong>agentes especializados colaboren en tareas complejas</strong>, mejorando la modularidad, escalabilidad y robustez. En lugar de depender de un solo agente, las tareas se distribuyen entre agentes con capacidades distintas.",WJ,d,ll="En <strong>smolagents</strong>, diferentes agentes pueden combinarse para generar código Python, llamar a herramientas externas, realizar búsquedas web y más. Al orquestar estos agentes, podemos crear flujos de trabajo potentes.",vJ,c,Ml="Una configuración típica podría incluir:",SJ,m,Ul="<li>Un <strong>Agente Gestor</strong> para la delegación de tareas</li> <li>Un <strong>Agente Intérprete de Código</strong> para la ejecución de código</li> <li>Un <strong>Agente de Búsqueda Web</strong> para la recuperación de información</li>",NJ,u,wl="El diagrama a continuación ilustra una arquitectura multi-agente simple donde un <strong>Agente Gestor</strong> coordina una <strong>Herramienta Intérprete de Código</strong> y un <strong>Agente de Búsqueda Web</strong>, que a su vez utiliza herramientas como <code>DuckDuckGoSearchTool</code> y <code>VisitWebpageTool</code> para recopilar información relevante.",YJ,k,Il,FJ,b,XJ,h,yl="Un sistema multi-agente consiste en múltiples agentes especializados trabajando juntos bajo la coordinación de un <strong>Agente Orquestador</strong>. Este enfoque permite flujos de trabajo complejos distribuyendo tareas entre agentes con roles distintos.",zJ,B,el="Por ejemplo, un <strong>sistema RAG Multi-Agente</strong> puede integrar:",_J,Q,tl="<li>Un <strong>Agente Web</strong> para navegar por internet.</li> <li>Un <strong>Agente Recuperador</strong> para obtener información de bases de conocimiento.</li> <li>Un <strong>Agente de Generación de Imágenes</strong> para producir elementos visuales.</li>",HJ,R,al="Todos estos agentes operan bajo un orquestador que gestiona la delegación de tareas y la interacción.",$J,O,qJ,A,sl='<p>Puedes seguir el código en <a href="https://huggingface.co/agents-course/notebooks/blob/main/unit2/smolagents/multiagent_notebook.ipynb" target="_blank">este notebook</a> que puedes ejecutar usando Google Colab.</p>',LJ,E,nl="¡La recepción se acerca! Con tu ayuda, Alfred ya casi ha terminado con los preparativos.",KJ,G,jl="Pero ahora hay un problema: el Batmóvil ha desaparecido. Alfred necesita encontrar un reemplazo, y encontrarlo rápidamente.",PJ,x,Cl="Afortunadamente, se han realizado algunas biografías cinematográficas sobre la vida de Bruce Wayne, así que tal vez Alfred podría conseguir un automóvil abandonado en uno de los sets de filmación y rediseñarlo según los estándares modernos, lo que ciertamente incluiría una opción de conducción autónoma completa.",JT,Z,il="Pero esto podría estar en cualquier lugar de las locaciones de filmación alrededor del mundo, que podrían ser numerosas.",TT,f,ol="Así que Alfred quiere tu ayuda. ¿Podrías construir un agente capaz de resolver esta tarea?",lT,V,Al="<p>👉 Encuentra todas las locaciones de filmación de Batman en el mundo, calcula el tiempo de transferencia en avión de carga hasta allí, y represéntalas en un mapa, con un color que varíe según el tiempo de transferencia en avión. También representa algunas fábricas de superdeportivos con el mismo tiempo de transferencia en avión.</p>",MT,D,pl="¡Vamos a construir esto!",UT,W,rl="Este ejemplo necesita algunos paquetes adicionales, así que vamos a instalarlos primero:",wT,v,IT,S,yT,N,eT,Y,tT,F,gl='Para el proveedor de modelos, usamos Together AI, ¡uno de los nuevos <a href="https://huggingface.co/blog/inference-providers" rel="nofollow">proveedores de inferencia en el Hub</a>!',aT,X,dl='La herramienta GoogleSearchTool usa la <a href="https://serper.dev" rel="nofollow">API de Serper</a> para buscar en la web, por lo que requiere haber configurado la variable de entorno <code>SERPAPI_API_KEY</code> y pasar <code>provider=&quot;serpapi&quot;</code> o tener <code>SERPER_API_KEY</code> y pasar <code>provider=serper</code>.',sT,z,cl="Si no tienes ningún proveedor de Serp API configurado, puedes usar <code>DuckDuckGoSearchTool</code> pero ten en cuenta que tiene un límite de tasa.",nT,_,jT,H,ml="Podemos empezar creando un agente simple como base para darnos un informe simple.",CT,$,iT,q,oT,L,AT,K,pT,P,ul="En nuestro caso, genera este output:",rT,JJ,gT,TJ,kl="Podríamos mejorar esto un poco agregando algunos pasos de planificación y más instrucciones.",dT,lJ,bl="Los pasos de planificación permiten al agente pensar con anticipación y planificar sus próximos pasos, lo que puede ser útil para tareas más complejas.",cT,MJ,mT,UJ,uT,wJ,hl="En nuestro caso, genera este output:",kT,IJ,bT,yJ,Bl="Gracias a estos cambios rápidos, obtuvimos un informe mucho más conciso proporcionando simplemente una instrucción detallada a nuestro agente y dándole capacidades de planificación.",hT,eJ,Ql="El contexto de la ventana del modelo se está llenando rápidamente. Así que <strong>si le pedimos a nuestro agente que combine los resultados de una búsqueda detallada con otra, será más lento y rápidamente aumentará los tokens y los costos</strong>.",BT,tJ,Rl="➡️ Necesitamos mejorar la estructura de nuestro sistema.",QT,aJ,RT,sJ,Ol="Las estructuras multi-agente permiten separar memorias entre diferentes sub-tareas, con dos grandes beneficios:",OT,nJ,El="<li>Cada agente está más enfocado en su tarea principal, por lo que es más performante</li> <li>Separar memorias reduce la cantidad de tokens de entrada en cada paso, reduciendo la latencia y el costo.</li>",ET,jJ,Gl="Vamos a crear un equipo con un agente de búsqueda web dedicado, gestionado por otro agente.",GT,CJ,xl="El agente gestor debe tener capacidades de trazado para escribir su informe final: así que vamos a darle acceso a importaciones adicionales, incluyendo <code>matplotlib</code>, y <code>geopandas</code> + <code>shapely</code> para trazado espacial.",xT,iJ,ZT,oJ,Zl="El agente gestor necesitará hacer algo de trabajo mental pesado.",fT,AJ,fl='Así que le damos el modelo más fuerte <a href="https://huggingface.co/deepseek-ai/DeepSeek-R1" rel="nofollow">DeepSeek-R1</a>, y agregamos un <code>planning_interval</code> a la mezcla.',VT,pJ,DT,rJ,Vl="Vamos a inspeccionar qué se ve este equipo:",WT,gJ,vT,dJ,Dl="Esto generará algo como esto, ayudándonos a entender la estructura y la relación entre agentes y herramientas utilizadas:",ST,cJ,NT,mJ,YT,uJ,Wl="No sé cómo salió en tu ejecución, pero en la mía, el agente gestor dividió hábilmente las tareas dadas al agente web en <code>1. Buscar locaciones de filmación de Batman</code>, luego <code>2. Encontrar fábricas de superdeportivos</code>, antes de agregar las listas y trazar el mapa.",FT,kJ,vl="Vamos a ver qué se ve el mapa inspeccionándolo directamente desde el estado del agente:",XT,bJ,zT,hJ,Sl="Esto generará el mapa:",_T,BJ,Nl='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/smolagents/output_map.png" alt="Multiagent system example output map"/>',HT,QJ,$T,RJ,Yl='<li><a href="https://huggingface.co/docs/smolagents/main/en/examples/multiagents" rel="nofollow">Sistemas Multi-Agente</a> – Visión general de los sistemas multi-agente.</li> <li><a href="https://weaviate.io/blog/what-is-agentic-rag" rel="nofollow">¿Qué es Agentic RAG?</a> – Introducción a Agentic RAG.</li> <li><a href="https://huggingface.co/learn/cookbook/multiagent_rag_system" rel="nofollow">Sistema RAG Multi-Agente 🤖🤝🤖 Receta</a> – Guía paso a paso para construir un sistema RAG multi-agente.</li>',qT,OJ,LT,xJ,KT;return p=new JM({props:{chapter:2,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/#fileId=https://huggingface.co/agents-course/notebooks/blob/main/unit2/smolagents/multiagent_notebook.ipynb"}]}}),r=new EJ({props:{title:"Sistemas Multi-Agente",local:"sistemas-multi-agente",headingTag:"h1"}}),b=new EJ({props:{title:"Sistemas Multi-Agente en Acción",local:"sistemas-multi-agente-en-acción",headingTag:"h2"}}),O=new EJ({props:{title:"Resolviendo una tarea compleja con una jerarquía multi-agente",local:"resolviendo-una-tarea-compleja-con-una-jerarquía-multi-agente",headingTag:"h2"}}),v=new i({props:{code:"cGlwJTIwaW5zdGFsbCUyMCdzbW9sYWdlbnRzJTVCbGl0ZWxsbSU1RCclMjBtYXRwbG90bGliJTIwZ2VvcGFuZGFzJTIwc2hhcGVseSUyMGthbGVpZG8lMjAtcQ==",highlighted:'pip install <span class="hljs-string">&#x27;smolagents[litellm]&#x27;</span> matplotlib geopandas shapely kaleido -q',wrap:!1}}),S=new EJ({props:{title:"Primero creamos una herramienta para obtener el tiempo de transferencia del avión de carga.",local:"primero-creamos-una-herramienta-para-obtener-el-tiempo-de-transferencia-del-avión-de-carga",headingTag:"h3"}}),N=new i({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> math
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Optional</span>, <span class="hljs-type">Tuple</span>

<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> tool


<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculate_cargo_travel_time</span>(<span class="hljs-params">
    origin_coords: <span class="hljs-type">Tuple</span>[<span class="hljs-built_in">float</span>, <span class="hljs-built_in">float</span>],
    destination_coords: <span class="hljs-type">Tuple</span>[<span class="hljs-built_in">float</span>, <span class="hljs-built_in">float</span>],
    cruising_speed_kmh: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">float</span>] = <span class="hljs-number">750.0</span>,  <span class="hljs-comment"># Average speed for cargo planes</span>
</span>) -&gt; <span class="hljs-built_in">float</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Calculate the travel time for a cargo plane between two points on Earth using great-circle distance.

    Args:
        origin_coords: Tuple of (latitude, longitude) for the starting point
        destination_coords: Tuple of (latitude, longitude) for the destination
        cruising_speed_kmh: Optional cruising speed in km/h (defaults to 750 km/h for typical cargo planes)

    Returns:
        float: The estimated travel time in hours

    Example:
        &gt;&gt;&gt; # Chicago (41.8781° N, 87.6298° W) to Sydney (33.8688° S, 151.2093° E)
        &gt;&gt;&gt; result = calculate_cargo_travel_time((41.8781, -87.6298), (-33.8688, 151.2093))
    &quot;&quot;&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">to_radians</span>(<span class="hljs-params">degrees: <span class="hljs-built_in">float</span></span>) -&gt; <span class="hljs-built_in">float</span>:
        <span class="hljs-keyword">return</span> degrees * (math.pi / <span class="hljs-number">180</span>)

    <span class="hljs-comment"># Extract coordinates</span>
    lat1, lon1 = <span class="hljs-built_in">map</span>(to_radians, origin_coords)
    lat2, lon2 = <span class="hljs-built_in">map</span>(to_radians, destination_coords)

    <span class="hljs-comment"># Earth&#x27;s radius in kilometers</span>
    EARTH_RADIUS_KM = <span class="hljs-number">6371.0</span>

    <span class="hljs-comment"># Calculate great-circle distance using the haversine formula</span>
    dlon = lon2 - lon1
    dlat = lat2 - lat1

    a = (
        math.sin(dlat / <span class="hljs-number">2</span>) ** <span class="hljs-number">2</span>
        + math.cos(lat1) * math.cos(lat2) * math.sin(dlon / <span class="hljs-number">2</span>) ** <span class="hljs-number">2</span>
    )
    c = <span class="hljs-number">2</span> * math.asin(math.sqrt(a))
    distance = EARTH_RADIUS_KM * c

    <span class="hljs-comment"># Add 10% to account for non-direct routes and air traffic controls</span>
    actual_distance = distance * <span class="hljs-number">1.1</span>

    <span class="hljs-comment"># Calculate flight time</span>
    <span class="hljs-comment"># Add 1 hour for takeoff and landing procedures</span>
    flight_time = (actual_distance / cruising_speed_kmh) + <span class="hljs-number">1.0</span>

    <span class="hljs-comment"># Format the results</span>
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">round</span>(flight_time, <span class="hljs-number">2</span>)


<span class="hljs-built_in">print</span>(calculate_cargo_travel_time((<span class="hljs-number">41.8781</span>, -<span class="hljs-number">87.6298</span>), (-<span class="hljs-number">33.8688</span>, <span class="hljs-number">151.2093</span>)))`,wrap:!1}}),Y=new EJ({props:{title:"Configurando el agente",local:"configurando-el-agente",headingTag:"h3"}}),_=new i({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwc21vbGFnZW50cyUyMGltcG9ydCUyMENvZGVBZ2VudCUyQyUyMEdvb2dsZVNlYXJjaFRvb2wlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMFZpc2l0V2VicGFnZVRvb2wlMEElMEFtb2RlbCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudE1vZGVsKG1vZGVsX2lkJTNEJTIyUXdlbiUyRlF3ZW4yLjUtQ29kZXItMzJCLUluc3RydWN0JTIyJTJDJTIwcHJvdmlkZXIlM0QlMjJ0b2dldGhlciUyMik=",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, GoogleSearchTool, InferenceClientModel, VisitWebpageTool

model = InferenceClientModel(model_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>, provider=<span class="hljs-string">&quot;together&quot;</span>)`,wrap:!1}}),$=new i({props:{code:"dGFzayUyMCUzRCUyMCUyMiUyMiUyMkVuY3VlbnRyYSUyMHRvZGFzJTIwbGFzJTIwbG9jYWNpb25lcyUyMGRlJTIwZmlsbWFjaSVDMyVCM24lMjBkZSUyMEJhdG1hbiUyMGVuJTIwZWwlMjBtdW5kbyUyQyUyMGNhbGN1bGElMjBlbCUyMHRpZW1wbyUyMGRlJTIwdHJhbnNmZXJlbmNpYSUyMGVuJTIwYXZpJUMzJUIzbiUyMGRlJTIwY2FyZ2ElMjBoYXN0YSUyMGFxdSVDMyVBRCUyMChlc3RhbW9zJTIwZW4lMjBHb3RoYW0lMkMlMjA0MC43MTI4JUMyJUIwJTIwTiUyQyUyMDc0LjAwNjAlQzIlQjAlMjBXKSUyQyUyMHklMjBkZXZ1JUMzJUE5bHZlbGFzJTIwYSUyMG0lQzMlQUQlMjBjb21vJTIwdW4lMjBkYXRhZnJhbWUlMjBkZSUyMHBhbmRhcy4lMEFUYW1iaSVDMyVBOW4lMjBkYW1lJTIwYWxndW5hcyUyMGYlQzMlQTFicmljYXMlMjBkZSUyMHN1cGVyZGVwb3J0aXZvcyUyMGNvbiUyMGVsJTIwbWlzbW8lMjB0aWVtcG8lMjBkZSUyMHRyYW5zZmVyZW5jaWElMjBlbiUyMGF2aSVDMyVCM24uJTIyJTIyJTIy",highlighted:`task = <span class="hljs-string">&quot;&quot;&quot;Encuentra todas las locaciones de filmación de Batman en el mundo, calcula el tiempo de transferencia en avión de carga hasta aquí (estamos en Gotham, 40.7128° N, 74.0060° W), y devuélvelas a mí como un dataframe de pandas.
También dame algunas fábricas de superdeportivos con el mismo tiempo de transferencia en avión.&quot;&quot;&quot;</span>`,wrap:!1}}),q=new i({props:{code:"YWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCR29vZ2xlU2VhcmNoVG9vbCglMjJzZXJwZXIlMjIpJTJDJTIwVmlzaXRXZWJwYWdlVG9vbCgpJTJDJTIwY2FsY3VsYXRlX2NhcmdvX3RyYXZlbF90aW1lJTVEJTJDJTBBJTIwJTIwJTIwJTIwYWRkaXRpb25hbF9hdXRob3JpemVkX2ltcG9ydHMlM0QlNUIlMjJwYW5kYXMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBtYXhfc3RlcHMlM0QyMCUyQyUwQSk=",highlighted:`agent = CodeAgent(
    model=model,
    tools=[GoogleSearchTool(<span class="hljs-string">&quot;serper&quot;</span>), VisitWebpageTool(), calculate_cargo_travel_time],
    additional_authorized_imports=[<span class="hljs-string">&quot;pandas&quot;</span>],
    max_steps=<span class="hljs-number">20</span>,
)`,wrap:!1}}),L=new i({props:{code:"cmVzdWx0JTIwJTNEJTIwYWdlbnQucnVuKHRhc2sp",highlighted:"result = agent.run(task)",wrap:!1}}),K=new i({props:{code:"cmVzdWx0",highlighted:"result",wrap:!1}}),JJ=new i({props:{code:"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",highlighted:`|  | Location                                             | Travel Time to Gotham (hours) |
|--|------------------------------------------------------|------------------------------|
| <span class="hljs-number">0</span>  | Necropolis Cemetery, Glasgow, Scotland, UK         | <span class="hljs-number">8.60</span>                         |
| <span class="hljs-number">1</span>  | St. George<span class="hljs-string">&#x27;s Hall, Liverpool, England, UK         | 8.81                         |
| 2  | Two Temple Place, London, England, UK             | 9.17                         |
| 3  | Wollaton Hall, Nottingham, England, UK           | 9.00                         |
| 4  | Knebworth House, Knebworth, Hertfordshire, UK    | 9.15                         |
| 5  | Acton Lane Power Station, Acton Lane, Acton, UK  | 9.16                         |
| 6  | Queensboro Bridge, New York City, USA            | 1.01                         |
| 7  | Wall Street, New York City, USA                  | 1.00                         |
| 8  | Mehrangarh Fort, Jodhpur, Rajasthan, India       | 18.34                        |
| 9  | Turda Gorge, Turda, Romania                      | 11.89                        |
| 10 | Chicago, USA                                     | 2.68                         |
| 11 | Hong Kong, China                                 | 19.99                        |
| 12 | Cardington Studios, Northamptonshire, UK        | 9.10                         |
| 13 | Warner Bros. Leavesden Studios, Hertfordshire, UK | 9.13                         |
| 14 | Westwood, Los Angeles, CA, USA                  | 6.79                         |
| 15 | Woking, UK (McLaren)                             | 9.13                         |</span>`,wrap:!1}}),MJ=new i({props:{code:"YWdlbnQucGxhbm5pbmdfaW50ZXJ2YWwlMjAlM0QlMjA0JTBBJTBBZGV0YWlsZWRfcmVwb3J0JTIwJTNEJTIwYWdlbnQucnVuKGYlMjIlMjIlMjIlMEFFcmVzJTIwdW4lMjBhbmFsaXN0YSUyMGV4cGVydG8uJTIwQ3JlYXMlMjBpbmZvcm1lcyUyMGV4aGF1c3Rpdm9zJTIwZGVzcHUlQzMlQTlzJTIwZGUlMjB2aXNpdGFyJTIwbXVjaG9zJTIwc2l0aW9zJTIwd2ViLiUwQU5vJTIwZHVkZXMlMjBlbiUyMGJ1c2NhciUyMG11Y2hhcyUyMGNvbnN1bHRhcyUyMGElMjBsYSUyMHZleiUyMGVuJTIwdW4lMjBidWNsZSUyMGZvci4lMEFQYXJhJTIwY2FkYSUyMGRhdG8lMjBxdWUlMjBlbmN1ZW50cmVzJTJDJTIwdmlzaXRhJTIwbGElMjBVUkwlMjBkZSUyMG9yaWdlbiUyMHBhcmElMjBjb25maXJtYXIlMjBsb3MlMjBuJUMzJUJBbWVyb3MuJTBBJTBBJTdCdGFzayU3RCUwQSUyMiUyMiUyMiklMEElMEFwcmludChkZXRhaWxlZF9yZXBvcnQp",highlighted:`agent.planning_interval = <span class="hljs-number">4</span>

detailed_report = agent.run(<span class="hljs-string">f&quot;&quot;&quot;
Eres un analista experto. Creas informes exhaustivos después de visitar muchos sitios web.
No dudes en buscar muchas consultas a la vez en un bucle for.
Para cada dato que encuentres, visita la URL de origen para confirmar los números.

<span class="hljs-subst">{task}</span>
&quot;&quot;&quot;</span>)

<span class="hljs-built_in">print</span>(detailed_report)`,wrap:!1}}),UJ=new i({props:{code:"ZGV0YWlsZWRfcmVwb3J0",highlighted:"detailed_report",wrap:!1}}),IJ=new i({props:{code:"JTdDJTIwJTIwJTdDJTIwTG9jYXRpb24lMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMjBUcmF2ZWwlMjBUaW1lJTIwKGhvdXJzKSUyMCU3QyUwQSU3Qy0tJTdDLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0lN0MtLS0tLS0tLS0tLS0tLS0tLS0tLS0lN0MlMEElN0MlMjAwJTIwJTIwJTdDJTIwQnJpZGdlJTIwb2YlMjBTaWdocyUyQyUyMEdsYXNnb3clMjBOZWNyb3BvbGlzJTJDJTIwR2xhc2dvdyUyQyUyMFVLJTIwJTdDJTIwOC42JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTBBJTdDJTIwMSUyMCUyMCU3QyUyMFdpc2hhcnQlMjBTdHJlZXQlMkMlMjBHbGFzZ293JTJDJTIwU2NvdGxhbmQlMkMlMjBVSyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMDguNiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3Qw==",highlighted:`|  | Location                                         | Travel Time (hours) |
|--|--------------------------------------------------|---------------------|
| <span class="hljs-number">0</span>  | Bridge of Sighs, Glasgow Necropolis, Glasgow, UK | <span class="hljs-number">8.6</span>                 |
| <span class="hljs-number">1</span>  | Wishart Street, Glasgow, Scotland, UK         | <span class="hljs-number">8.6</span>                 |`,wrap:!1}}),aJ=new EJ({props:{title:"✌️ Dividiendo la tarea entre dos agentes",local:"-dividiendo-la-tarea-entre-dos-agentes",headingTag:"h3"}}),iJ=new i({props:{code:"bW9kZWwlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCglMEElMjAlMjAlMjAlMjAlMjJRd2VuJTJGUXdlbjIuNS1Db2Rlci0zMkItSW5zdHJ1Y3QlMjIlMkMlMjBwcm92aWRlciUzRCUyMnRvZ2V0aGVyJTIyJTJDJTIwbWF4X3Rva2VucyUzRDgwOTYlMEEpJTBBJTBBd2ViX2FnZW50JTIwJTNEJTIwQ29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEdvb2dsZVNlYXJjaFRvb2wocHJvdmlkZXIlM0QlMjJzZXJwZXIlMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwVmlzaXRXZWJwYWdlVG9vbCgpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2FsY3VsYXRlX2NhcmdvX3RyYXZlbF90aW1lJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwbmFtZSUzRCUyMndlYl9hZ2VudCUyMiUyQyUwQSUyMCUyMCUyMCUyMGRlc2NyaXB0aW9uJTNEJTIyTmF2ZWdhJTIwcG9yJTIwbGElMjB3ZWIlMjBwYXJhJTIwZW5jb250cmFyJTIwaW5mb3JtYWNpJUMzJUIzbiUyMiUyQyUwQSUyMCUyMCUyMCUyMHZlcmJvc2l0eV9sZXZlbCUzRDAlMkMlMEElMjAlMjAlMjAlMjBtYXhfc3RlcHMlM0QxMCUyQyUwQSk=",highlighted:`model = InferenceClientModel(
    <span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>, provider=<span class="hljs-string">&quot;together&quot;</span>, max_tokens=<span class="hljs-number">8096</span>
)

web_agent = CodeAgent(
    model=model,
    tools=[
        GoogleSearchTool(provider=<span class="hljs-string">&quot;serper&quot;</span>),
        VisitWebpageTool(),
        calculate_cargo_travel_time,
    ],
    name=<span class="hljs-string">&quot;web_agent&quot;</span>,
    description=<span class="hljs-string">&quot;Navega por la web para encontrar información&quot;</span>,
    verbosity_level=<span class="hljs-number">0</span>,
    max_steps=<span class="hljs-number">10</span>,
)`,wrap:!1}}),pJ=new i({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents.utils <span class="hljs-keyword">import</span> encode_image_base64, make_image_url
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> OpenAIServerModel


<span class="hljs-keyword">def</span> <span class="hljs-title function_">check_reasoning_and_plot</span>(<span class="hljs-params">final_answer, agent_memory</span>):
    final_answer
    multimodal_model = OpenAIServerModel(<span class="hljs-string">&quot;gpt-4o&quot;</span>, max_tokens=<span class="hljs-number">8096</span>)
    filepath = <span class="hljs-string">&quot;saved_map.png&quot;</span>
    <span class="hljs-keyword">assert</span> os.path.exists(filepath), <span class="hljs-string">&quot;Asegúrate de guardar el trazado bajo saved_map.png!&quot;</span>
    image = Image.<span class="hljs-built_in">open</span>(filepath)
    prompt = (
        <span class="hljs-string">f&quot;Aquí está una tarea dada por el usuario y los pasos del agente: <span class="hljs-subst">{agent_memory.get_succinct_steps()}</span>. Ahora aquí está el trazado que se hizo.&quot;</span>
        <span class="hljs-string">&quot;Por favor, verifica que el proceso de razonamiento y el trazado sean correctos: ¿responden correctamente a la tarea dada?&quot;</span>
        <span class="hljs-string">&quot;Primero enumera razones por las que sí/no, luego escribe tu decisión final: PASS en mayúsculas si es satisfactorio, FAIL si no lo es.&quot;</span>
        <span class="hljs-string">&quot;No seas duro: si el trazado resuelve en gran medida la tarea, debe pasar.&quot;</span>
        <span class="hljs-string">&quot;Para pasar, un trazado debe hacerse usando px.scatter_map y no cualquier otro método (scatter_map se ve mejor).&quot;</span>
    )
    messages = [
        {
            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
            <span class="hljs-string">&quot;content&quot;</span>: [
                {
                    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
                    <span class="hljs-string">&quot;text&quot;</span>: prompt,
                },
                {
                    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image_url&quot;</span>,
                    <span class="hljs-string">&quot;image_url&quot;</span>: {<span class="hljs-string">&quot;url&quot;</span>: make_image_url(encode_image_base64(image))},
                },
            ],
        }
    ]
    output = multimodal_model(messages).content
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Retroalimentación: &quot;</span>, output)
    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;FAIL&quot;</span> <span class="hljs-keyword">in</span> output:
        <span class="hljs-keyword">raise</span> Exception(output)
    <span class="hljs-keyword">return</span> <span class="hljs-literal">True</span>


manager_agent = CodeAgent(
    model=InferenceClientModel(<span class="hljs-string">&quot;deepseek-ai/DeepSeek-R1&quot;</span>, provider=<span class="hljs-string">&quot;together&quot;</span>, max_tokens=<span class="hljs-number">8096</span>),
    tools=[calculate_cargo_travel_time],
    managed_agents=[web_agent],
    additional_authorized_imports=[
        <span class="hljs-string">&quot;geopandas&quot;</span>,
        <span class="hljs-string">&quot;plotly&quot;</span>,
        <span class="hljs-string">&quot;shapely&quot;</span>,
        <span class="hljs-string">&quot;json&quot;</span>,
        <span class="hljs-string">&quot;pandas&quot;</span>,
        <span class="hljs-string">&quot;numpy&quot;</span>,
    ],
    planning_interval=<span class="hljs-number">5</span>,
    verbosity_level=<span class="hljs-number">2</span>,
    final_answer_checks=[check_reasoning_and_plot],
    max_steps=<span class="hljs-number">15</span>,
)`,wrap:!1}}),gJ=new i({props:{code:"bWFuYWdlcl9hZ2VudC52aXN1YWxpemUoKQ==",highlighted:"manager_agent.visualize()",wrap:!1}}),cJ=new i({props:{code:"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",highlighted:`CodeAgent | deepseek-ai/DeepSeek-R1
├── ✅ Authorized imports: [<span class="hljs-string">&#x27;geopandas&#x27;</span>, <span class="hljs-string">&#x27;plotly&#x27;</span>, <span class="hljs-string">&#x27;shapely&#x27;</span>, <span class="hljs-string">&#x27;json&#x27;</span>, <span class="hljs-string">&#x27;pandas&#x27;</span>, <span class="hljs-string">&#x27;numpy&#x27;</span>]
├── 🛠️ Tools:
│   ┏━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┓
│   ┃ Name                        ┃ Description                           ┃ Arguments                             ┃
│   ┡━━━━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┩
│   │ calculate_cargo_travel_time │ Calculate the travel time <span class="hljs-keyword">for</span> a cargo │ origin_coords (\`array\`): <span class="hljs-type">Tuple</span> of     │
│   │                             │ plane between two points on Earth     │ (latitude, longitude) <span class="hljs-keyword">for</span> the         │
│   │                             │ using great-circle distance.          │ starting point                        │
│   │                             │                                       │ destination_coords (\`array\`): <span class="hljs-type">Tuple</span>   │
│   │                             │                                       │ of (latitude, longitude) <span class="hljs-keyword">for</span> the      │
│   │                             │                                       │ destination                           │
│   │                             │                                       │ cruising_speed_kmh (\`number\`):        │
│   │                             │                                       │ <span class="hljs-type">Optional</span> cruising speed <span class="hljs-keyword">in</span> km/h       │
│   │                             │                                       │ (defaults to <span class="hljs-number">750</span> km/h <span class="hljs-keyword">for</span> typical     │
│   │                             │                                       │ cargo planes)                         │
│   │ final_answer                │ Provides a final answer to the given  │ answer (\`<span class="hljs-built_in">any</span>\`): The final answer to   │
│   │                             │ problem.                              │ the problem                           │
│   └─────────────────────────────┴───────────────────────────────────────┴───────────────────────────────────────┘
└── 🤖 Managed agents:
    └── web_agent | CodeAgent | Qwen/Qwen2<span class="hljs-number">.5</span>-Coder-32B-Instruct
        ├── ✅ Authorizar imports: []
        ├── 📝 Description: Navega por la web para encontrar información
        └── 🛠️ Tools:
            ┏━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┓
            ┃ Name                        ┃ Description                       ┃ Arguments                         ┃
            ┡━━━━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┩
            │ web_search                  │ Performs a google web search <span class="hljs-keyword">for</span>  │ query (\`string\`): The search      │
            │                             │ your query then returns a string  │ query to perform.                 │
            │                             │ of the top search results.        │ filter_year (\`integer\`):          │
            │                             │                                   │ Optionally restrict results to a  │
            │                             │                                   │ certain year                      │
            │ visit_webpage               │ Visits a webpage at the given url │ url (\`string\`): The url of the    │
            │                             │ <span class="hljs-keyword">and</span> reads its content <span class="hljs-keyword">as</span> a        │ webpage to visit.                 │
            │                             │ markdown string. Use this to      │                                   │
            │                             │ browse webpages.                  │                                   │
            │ calculate_cargo_travel_time │ Calculate the travel time <span class="hljs-keyword">for</span> a   │ origin_coords (\`array\`): <span class="hljs-type">Tuple</span> of │
            │                             │ cargo plane between two points on │ (latitude, longitude) <span class="hljs-keyword">for</span> the     │
            │                             │ Earth using great-circle          │ starting point                    │
            │                             │ distance.                         │ destination_coords (\`array\`):     │
            │                             │                                   │ <span class="hljs-type">Tuple</span> of (latitude, longitude)    │
            │                             │                                   │ <span class="hljs-keyword">for</span> the destination               │
            │                             │                                   │ cruising_speed_kmh (\`number\`):    │
            │                             │                                   │ <span class="hljs-type">Optional</span> cruising speed <span class="hljs-keyword">in</span> km/h   │
            │                             │                                   │ (defaults to <span class="hljs-number">750</span> km/h <span class="hljs-keyword">for</span> typical │
            │                             │                                   │ cargo planes)                     │
            │ final_answer                │ Provides a final answer to the    │ answer (\`<span class="hljs-built_in">any</span>\`): The final answer  │
            │                             │ given problem.                    │ to the problem                    │
            └─────────────────────────────┴───────────────────────────────────┴───────────────────────────────────┘`,wrap:!1}}),mJ=new i({props:{code:"bWFuYWdlcl9hZ2VudC5ydW4oJTIyJTIyJTIyJTBBRW5jdWVudHJhJTIwdG9kYXMlMjBsYXMlMjBsb2NhY2lvbmVzJTIwZGUlMjBmaWxtYWNpJUMzJUIzbiUyMGRlJTIwQmF0bWFuJTIwZW4lMjBlbCUyMG11bmRvJTJDJTIwY2FsY3VsYSUyMGVsJTIwdGllbXBvJTIwZGUlMjB0cmFuc2ZlcmVuY2lhJTIwZW4lMjBhdmklQzMlQjNuJTIwZGUlMjBjYXJnYSUyMGhhc3RhJTIwYXF1JUMzJUFEJTIwKGVzdGFtb3MlMjBlbiUyMEdvdGhhbSUyQyUyMDQwLjcxMjglQzIlQjAlMjBOJTJDJTIwNzQuMDA2MCVDMiVCMCUyMFcpLiUwQVRhbWJpJUMzJUE5biUyMGRhbWUlMjBhbGd1bmFzJTIwZiVDMyVBMWJyaWNhcyUyMGRlJTIwc3VwZXJkZXBvcnRpdm9zJTIwY29uJTIwZWwlMjBtaXNtbyUyMHRpZW1wbyUyMGRlJTIwdHJhbnNmZXJlbmNpYSUyMGVuJTIwYXZpJUMzJUIzbi4lMEFOZWNlc2l0byUyMGFsJTIwbWVub3MlMjA2JTIwcHVudG9zJTIwZW4lMjB0b3RhbC4lMEFSZXByZXNlbnRhJTIwZXN0byUyMGNvbW8lMjB1biUyMG1hcGElMjBlc3BhY2lhbCUyMGRlbCUyMG11bmRvJTJDJTIwY29uJTIwbGFzJTIwbG9jYWNpb25lcyUyMHJlcHJlc2VudGFkYXMlMjBjb21vJTIwcHVudG9zJTIwZGUlMjBkaXNwZXJzaSVDMyVCM24lMjBjb24lMjB1biUyMGNvbG9yJTIwcXVlJTIwZGVwZW5kZSUyMGRlbCUyMHRpZW1wbyUyMGRlJTIwdHJhbnNmZXJlbmNpYSUyQyUyMHklMjBndSVDMyVBMXJkYWxvJTIwZW4lMjBzYXZlZF9tYXAucG5nISUwQSUwQUFxdSVDMyVBRCUyMGhheSUyMHVuJTIwZWplbXBsbyUyMGRlJTIwYyVDMyVCM21vJTIwdHJhemFyJTIweSUyMGRldm9sdmVyJTIwdW4lMjBtYXBhJTNBJTBBaW1wb3J0JTIwcGxvdGx5LmV4cHJlc3MlMjBhcyUyMHB4JTBBZGYlMjAlM0QlMjBweC5kYXRhLmNhcnNoYXJlKCklMEFmaWclMjAlM0QlMjBweC5zY2F0dGVyX21hcChkZiUyQyUyMGxhdCUzRCUyMmNlbnRyb2lkX2xhdCUyMiUyQyUyMGxvbiUzRCUyMmNlbnRyb2lkX2xvbiUyMiUyQyUyMHRleHQlM0QlMjJuYW1lJTIyJTJDJTIwY29sb3IlM0QlMjJwZWFrX2hvdXIlMjIlMkMlMjBzaXplJTNEMTAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwY29sb3JfY29udGludW91c19zY2FsZSUzRHB4LmNvbG9ycy5zZXF1ZW50aWFsLk1hZ21hJTJDJTIwc2l6ZV9tYXglM0QxNSUyQyUyMHpvb20lM0QxKSUwQWZpZy5zaG93KCklMEFmaWcud3JpdGVfaW1hZ2UoJTIyc2F2ZWRfaW1hZ2UucG5nJTIyKSUwQWZpbmFsX2Fuc3dlcihmaWcpJTBBJTBBTnVuY2ElMjBpbnRlbnRlcyUyMHByb2Nlc2FyJTIwY2FkZW5hcyUyMHVzYW5kbyUyMGMlQzMlQjNkaWdvJTNBJTIwY3VhbmRvJTIwdGVuZ2FzJTIwdW5hJTIwY2FkZW5hJTIwcGFyYSUyMGxlZXIlMkMlMjBzaW1wbGVtZW50ZSUyMGltcHIlQzMlQURtZWxhJTIweSUyMGxhJTIwdmVyJUMzJUExcy4lMEElMjIlMjIlMjIp",highlighted:`manager_agent.run(<span class="hljs-string">&quot;&quot;&quot;
Encuentra todas las locaciones de filmación de Batman en el mundo, calcula el tiempo de transferencia en avión de carga hasta aquí (estamos en Gotham, 40.7128° N, 74.0060° W).
También dame algunas fábricas de superdeportivos con el mismo tiempo de transferencia en avión.
Necesito al menos 6 puntos en total.
Representa esto como un mapa espacial del mundo, con las locaciones representadas como puntos de dispersión con un color que depende del tiempo de transferencia, y guárdalo en saved_map.png!

Aquí hay un ejemplo de cómo trazar y devolver un mapa:
import plotly.express as px
df = px.data.carshare()
fig = px.scatter_map(df, lat=&quot;centroid_lat&quot;, lon=&quot;centroid_lon&quot;, text=&quot;name&quot;, color=&quot;peak_hour&quot;, size=100,
     color_continuous_scale=px.colors.sequential.Magma, size_max=15, zoom=1)
fig.show()
fig.write_image(&quot;saved_image.png&quot;)
final_answer(fig)

Nunca intentes procesar cadenas usando código: cuando tengas una cadena para leer, simplemente imprímela y la verás.
&quot;&quot;&quot;</span>)`,wrap:!1}}),bJ=new i({props:{code:"bWFuYWdlcl9hZ2VudC5weXRob25fZXhlY3V0b3Iuc3RhdGUlNUIlMjJmaWclMjIlNUQ=",highlighted:'manager_agent.python_executor.state[<span class="hljs-string">&quot;fig&quot;</span>]',wrap:!1}}),QJ=new EJ({props:{title:"Recursos",local:"recursos",headingTag:"h2"}}),OJ=new TM({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/es/unit2/smolagents/multi_agent_systems.mdx"}}),{c(){o=I("meta"),ZJ=U(),GJ=I("p"),fJ=U(),t(p.$$.fragment),VJ=U(),t(r.$$.fragment),DJ=U(),g=I("p"),g.innerHTML=Tl,WJ=U(),d=I("p"),d.innerHTML=ll,vJ=U(),c=I("p"),c.textContent=Ml,SJ=U(),m=I("ul"),m.innerHTML=Ul,NJ=U(),u=I("p"),u.innerHTML=wl,YJ=U(),k=I("img"),FJ=U(),t(b.$$.fragment),XJ=U(),h=I("p"),h.innerHTML=yl,zJ=U(),B=I("p"),B.innerHTML=el,_J=U(),Q=I("ul"),Q.innerHTML=tl,HJ=U(),R=I("p"),R.textContent=al,$J=U(),t(O.$$.fragment),qJ=U(),A=I("blockquote"),A.innerHTML=sl,LJ=U(),E=I("p"),E.textContent=nl,KJ=U(),G=I("p"),G.textContent=jl,PJ=U(),x=I("p"),x.textContent=Cl,JT=U(),Z=I("p"),Z.textContent=il,TT=U(),f=I("p"),f.textContent=ol,lT=U(),V=I("blockquote"),V.innerHTML=Al,MT=U(),D=I("p"),D.textContent=pl,UT=U(),W=I("p"),W.textContent=rl,wT=U(),t(v.$$.fragment),IT=U(),t(S.$$.fragment),yT=U(),t(N.$$.fragment),eT=U(),t(Y.$$.fragment),tT=U(),F=I("p"),F.innerHTML=gl,aT=U(),X=I("p"),X.innerHTML=dl,sT=U(),z=I("p"),z.innerHTML=cl,nT=U(),t(_.$$.fragment),jT=U(),H=I("p"),H.textContent=ml,CT=U(),t($.$$.fragment),iT=U(),t(q.$$.fragment),oT=U(),t(L.$$.fragment),AT=U(),t(K.$$.fragment),pT=U(),P=I("p"),P.textContent=ul,rT=U(),t(JJ.$$.fragment),gT=U(),TJ=I("p"),TJ.textContent=kl,dT=U(),lJ=I("p"),lJ.textContent=bl,cT=U(),t(MJ.$$.fragment),mT=U(),t(UJ.$$.fragment),uT=U(),wJ=I("p"),wJ.textContent=hl,kT=U(),t(IJ.$$.fragment),bT=U(),yJ=I("p"),yJ.textContent=Bl,hT=U(),eJ=I("p"),eJ.innerHTML=Ql,BT=U(),tJ=I("p"),tJ.textContent=Rl,QT=U(),t(aJ.$$.fragment),RT=U(),sJ=I("p"),sJ.textContent=Ol,OT=U(),nJ=I("ul"),nJ.innerHTML=El,ET=U(),jJ=I("p"),jJ.textContent=Gl,GT=U(),CJ=I("p"),CJ.innerHTML=xl,xT=U(),t(iJ.$$.fragment),ZT=U(),oJ=I("p"),oJ.textContent=Zl,fT=U(),AJ=I("p"),AJ.innerHTML=fl,VT=U(),t(pJ.$$.fragment),DT=U(),rJ=I("p"),rJ.textContent=Vl,WT=U(),t(gJ.$$.fragment),vT=U(),dJ=I("p"),dJ.textContent=Dl,ST=U(),t(cJ.$$.fragment),NT=U(),t(mJ.$$.fragment),YT=U(),uJ=I("p"),uJ.innerHTML=Wl,FT=U(),kJ=I("p"),kJ.textContent=vl,XT=U(),t(bJ.$$.fragment),zT=U(),hJ=I("p"),hJ.textContent=Sl,_T=U(),BJ=I("p"),BJ.innerHTML=Nl,HT=U(),t(QJ.$$.fragment),$T=U(),RJ=I("ul"),RJ.innerHTML=Yl,qT=U(),t(OJ.$$.fragment),LT=U(),xJ=I("p"),this.h()},l(J){const T=Ll("svelte-u9bgzb",document.head);o=y(T,"META",{name:!0,content:!0}),T.forEach(l),ZJ=w(J),GJ=y(J,"P",{}),Fl(GJ).forEach(l),fJ=w(J),a(p.$$.fragment,J),VJ=w(J),a(r.$$.fragment,J),DJ=w(J),g=y(J,"P",{"data-svelte-h":!0}),e(g)!=="svelte-fmwqrq"&&(g.innerHTML=Tl),WJ=w(J),d=y(J,"P",{"data-svelte-h":!0}),e(d)!=="svelte-rtqme"&&(d.innerHTML=ll),vJ=w(J),c=y(J,"P",{"data-svelte-h":!0}),e(c)!=="svelte-1aikdpk"&&(c.textContent=Ml),SJ=w(J),m=y(J,"UL",{"data-svelte-h":!0}),e(m)!=="svelte-q90avd"&&(m.innerHTML=Ul),NJ=w(J),u=y(J,"P",{"data-svelte-h":!0}),e(u)!=="svelte-rilfzs"&&(u.innerHTML=wl),YJ=w(J),k=y(J,"IMG",{src:!0,style:!0}),FJ=w(J),a(b.$$.fragment,J),XJ=w(J),h=y(J,"P",{"data-svelte-h":!0}),e(h)!=="svelte-gazwo6"&&(h.innerHTML=yl),zJ=w(J),B=y(J,"P",{"data-svelte-h":!0}),e(B)!=="svelte-6zterm"&&(B.innerHTML=el),_J=w(J),Q=y(J,"UL",{"data-svelte-h":!0}),e(Q)!=="svelte-6a1kbm"&&(Q.innerHTML=tl),HJ=w(J),R=y(J,"P",{"data-svelte-h":!0}),e(R)!=="svelte-1jeelbo"&&(R.textContent=al),$J=w(J),a(O.$$.fragment,J),qJ=w(J),A=y(J,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),e(A)!=="svelte-1blqlkc"&&(A.innerHTML=sl),LJ=w(J),E=y(J,"P",{"data-svelte-h":!0}),e(E)!=="svelte-1pghdy9"&&(E.textContent=nl),KJ=w(J),G=y(J,"P",{"data-svelte-h":!0}),e(G)!=="svelte-ebg2aq"&&(G.textContent=jl),PJ=w(J),x=y(J,"P",{"data-svelte-h":!0}),e(x)!=="svelte-1o2ah4c"&&(x.textContent=Cl),JT=w(J),Z=y(J,"P",{"data-svelte-h":!0}),e(Z)!=="svelte-dyejq3"&&(Z.textContent=il),TT=w(J),f=y(J,"P",{"data-svelte-h":!0}),e(f)!=="svelte-1nsx5n0"&&(f.textContent=ol),lT=w(J),V=y(J,"BLOCKQUOTE",{"data-svelte-h":!0}),e(V)!=="svelte-1yhfnkw"&&(V.innerHTML=Al),MT=w(J),D=y(J,"P",{"data-svelte-h":!0}),e(D)!=="svelte-hh44nj"&&(D.textContent=pl),UT=w(J),W=y(J,"P",{"data-svelte-h":!0}),e(W)!=="svelte-1aru903"&&(W.textContent=rl),wT=w(J),a(v.$$.fragment,J),IT=w(J),a(S.$$.fragment,J),yT=w(J),a(N.$$.fragment,J),eT=w(J),a(Y.$$.fragment,J),tT=w(J),F=y(J,"P",{"data-svelte-h":!0}),e(F)!=="svelte-12t06ua"&&(F.innerHTML=gl),aT=w(J),X=y(J,"P",{"data-svelte-h":!0}),e(X)!=="svelte-f3ikqm"&&(X.innerHTML=dl),sT=w(J),z=y(J,"P",{"data-svelte-h":!0}),e(z)!=="svelte-1ly8acu"&&(z.innerHTML=cl),nT=w(J),a(_.$$.fragment,J),jT=w(J),H=y(J,"P",{"data-svelte-h":!0}),e(H)!=="svelte-1jq1h6r"&&(H.textContent=ml),CT=w(J),a($.$$.fragment,J),iT=w(J),a(q.$$.fragment,J),oT=w(J),a(L.$$.fragment,J),AT=w(J),a(K.$$.fragment,J),pT=w(J),P=y(J,"P",{"data-svelte-h":!0}),e(P)!=="svelte-132b781"&&(P.textContent=ul),rT=w(J),a(JJ.$$.fragment,J),gT=w(J),TJ=y(J,"P",{"data-svelte-h":!0}),e(TJ)!=="svelte-18u1xwq"&&(TJ.textContent=kl),dT=w(J),lJ=y(J,"P",{"data-svelte-h":!0}),e(lJ)!=="svelte-1iwmhbi"&&(lJ.textContent=bl),cT=w(J),a(MJ.$$.fragment,J),mT=w(J),a(UJ.$$.fragment,J),uT=w(J),wJ=y(J,"P",{"data-svelte-h":!0}),e(wJ)!=="svelte-132b781"&&(wJ.textContent=hl),kT=w(J),a(IJ.$$.fragment,J),bT=w(J),yJ=y(J,"P",{"data-svelte-h":!0}),e(yJ)!=="svelte-30ratm"&&(yJ.textContent=Bl),hT=w(J),eJ=y(J,"P",{"data-svelte-h":!0}),e(eJ)!=="svelte-13r8n48"&&(eJ.innerHTML=Ql),BT=w(J),tJ=y(J,"P",{"data-svelte-h":!0}),e(tJ)!=="svelte-1q1e765"&&(tJ.textContent=Rl),QT=w(J),a(aJ.$$.fragment,J),RT=w(J),sJ=y(J,"P",{"data-svelte-h":!0}),e(sJ)!=="svelte-km5dzv"&&(sJ.textContent=Ol),OT=w(J),nJ=y(J,"UL",{"data-svelte-h":!0}),e(nJ)!=="svelte-1ps36yh"&&(nJ.innerHTML=El),ET=w(J),jJ=y(J,"P",{"data-svelte-h":!0}),e(jJ)!=="svelte-1iroo8u"&&(jJ.textContent=Gl),GT=w(J),CJ=y(J,"P",{"data-svelte-h":!0}),e(CJ)!=="svelte-ujf8rp"&&(CJ.innerHTML=xl),xT=w(J),a(iJ.$$.fragment,J),ZT=w(J),oJ=y(J,"P",{"data-svelte-h":!0}),e(oJ)!=="svelte-1ua8v3b"&&(oJ.textContent=Zl),fT=w(J),AJ=y(J,"P",{"data-svelte-h":!0}),e(AJ)!=="svelte-1uf8d85"&&(AJ.innerHTML=fl),VT=w(J),a(pJ.$$.fragment,J),DT=w(J),rJ=y(J,"P",{"data-svelte-h":!0}),e(rJ)!=="svelte-32twah"&&(rJ.textContent=Vl),WT=w(J),a(gJ.$$.fragment,J),vT=w(J),dJ=y(J,"P",{"data-svelte-h":!0}),e(dJ)!=="svelte-kgu306"&&(dJ.textContent=Dl),ST=w(J),a(cJ.$$.fragment,J),NT=w(J),a(mJ.$$.fragment,J),YT=w(J),uJ=y(J,"P",{"data-svelte-h":!0}),e(uJ)!=="svelte-18623z8"&&(uJ.innerHTML=Wl),FT=w(J),kJ=y(J,"P",{"data-svelte-h":!0}),e(kJ)!=="svelte-yx3hha"&&(kJ.textContent=vl),XT=w(J),a(bJ.$$.fragment,J),zT=w(J),hJ=y(J,"P",{"data-svelte-h":!0}),e(hJ)!=="svelte-1ret7u2"&&(hJ.textContent=Sl),_T=w(J),BJ=y(J,"P",{"data-svelte-h":!0}),e(BJ)!=="svelte-z627a9"&&(BJ.innerHTML=Nl),HT=w(J),a(QJ.$$.fragment,J),$T=w(J),RJ=y(J,"UL",{"data-svelte-h":!0}),e(RJ)!=="svelte-xersmj"&&(RJ.innerHTML=Yl),qT=w(J),a(OJ.$$.fragment,J),LT=w(J),xJ=y(J,"P",{}),Fl(xJ).forEach(l),this.h()},h(){PT(o,"name","hf:doc:metadata"),PT(o,"content",MM),zl(k.src,Il="https://mermaid.ink/img/pako:eNp1kc1qhTAQRl9FUiQb8wIpdNO76eKubrmFks1oRg3VSYgjpYjv3lFL_2hnMWQOJwn5sqgmelRWleUSKLAtFs09jqhtoWuYUFfFAa6QA9QDTnpzamheuhxn8pt40-6l13UtS0ddhtQXj6dbR4XUGQg6zEYasTF393KjeSDGnDJKNxzj8I_7hLW5IOSmP9CH9hv_NL-d94d4DVNg84p1EnK4qlIj5hGClySWbadT-6OdsrL02MI8sFOOVkciw8zx8kaNspxnrJQE0fXKtjBMMs3JA-MpgOQwftIE9Bzj14w-cMznI_39E9Z3p0uFoA?type=png")||PT(k,"src",Il),Kl(k,"background","white"),PT(A,"class","tip")},m(J,T){Pl(document.head,o),M(J,ZJ,T),M(J,GJ,T),M(J,fJ,T),s(p,J,T),M(J,VJ,T),s(r,J,T),M(J,DJ,T),M(J,g,T),M(J,WJ,T),M(J,d,T),M(J,vJ,T),M(J,c,T),M(J,SJ,T),M(J,m,T),M(J,NJ,T),M(J,u,T),M(J,YJ,T),M(J,k,T),M(J,FJ,T),s(b,J,T),M(J,XJ,T),M(J,h,T),M(J,zJ,T),M(J,B,T),M(J,_J,T),M(J,Q,T),M(J,HJ,T),M(J,R,T),M(J,$J,T),s(O,J,T),M(J,qJ,T),M(J,A,T),M(J,LJ,T),M(J,E,T),M(J,KJ,T),M(J,G,T),M(J,PJ,T),M(J,x,T),M(J,JT,T),M(J,Z,T),M(J,TT,T),M(J,f,T),M(J,lT,T),M(J,V,T),M(J,MT,T),M(J,D,T),M(J,UT,T),M(J,W,T),M(J,wT,T),s(v,J,T),M(J,IT,T),s(S,J,T),M(J,yT,T),s(N,J,T),M(J,eT,T),s(Y,J,T),M(J,tT,T),M(J,F,T),M(J,aT,T),M(J,X,T),M(J,sT,T),M(J,z,T),M(J,nT,T),s(_,J,T),M(J,jT,T),M(J,H,T),M(J,CT,T),s($,J,T),M(J,iT,T),s(q,J,T),M(J,oT,T),s(L,J,T),M(J,AT,T),s(K,J,T),M(J,pT,T),M(J,P,T),M(J,rT,T),s(JJ,J,T),M(J,gT,T),M(J,TJ,T),M(J,dT,T),M(J,lJ,T),M(J,cT,T),s(MJ,J,T),M(J,mT,T),s(UJ,J,T),M(J,uT,T),M(J,wJ,T),M(J,kT,T),s(IJ,J,T),M(J,bT,T),M(J,yJ,T),M(J,hT,T),M(J,eJ,T),M(J,BT,T),M(J,tJ,T),M(J,QT,T),s(aJ,J,T),M(J,RT,T),M(J,sJ,T),M(J,OT,T),M(J,nJ,T),M(J,ET,T),M(J,jJ,T),M(J,GT,T),M(J,CJ,T),M(J,xT,T),s(iJ,J,T),M(J,ZT,T),M(J,oJ,T),M(J,fT,T),M(J,AJ,T),M(J,VT,T),s(pJ,J,T),M(J,DT,T),M(J,rJ,T),M(J,WT,T),s(gJ,J,T),M(J,vT,T),M(J,dJ,T),M(J,ST,T),s(cJ,J,T),M(J,NT,T),s(mJ,J,T),M(J,YT,T),M(J,uJ,T),M(J,FT,T),M(J,kJ,T),M(J,XT,T),s(bJ,J,T),M(J,zT,T),M(J,hJ,T),M(J,_T,T),M(J,BJ,T),M(J,HT,T),s(QJ,J,T),M(J,$T,T),M(J,RJ,T),M(J,qT,T),s(OJ,J,T),M(J,LT,T),M(J,xJ,T),KT=!0},p:_l,i(J){KT||(n(p.$$.fragment,J),n(r.$$.fragment,J),n(b.$$.fragment,J),n(O.$$.fragment,J),n(v.$$.fragment,J),n(S.$$.fragment,J),n(N.$$.fragment,J),n(Y.$$.fragment,J),n(_.$$.fragment,J),n($.$$.fragment,J),n(q.$$.fragment,J),n(L.$$.fragment,J),n(K.$$.fragment,J),n(JJ.$$.fragment,J),n(MJ.$$.fragment,J),n(UJ.$$.fragment,J),n(IJ.$$.fragment,J),n(aJ.$$.fragment,J),n(iJ.$$.fragment,J),n(pJ.$$.fragment,J),n(gJ.$$.fragment,J),n(cJ.$$.fragment,J),n(mJ.$$.fragment,J),n(bJ.$$.fragment,J),n(QJ.$$.fragment,J),n(OJ.$$.fragment,J),KT=!0)},o(J){j(p.$$.fragment,J),j(r.$$.fragment,J),j(b.$$.fragment,J),j(O.$$.fragment,J),j(v.$$.fragment,J),j(S.$$.fragment,J),j(N.$$.fragment,J),j(Y.$$.fragment,J),j(_.$$.fragment,J),j($.$$.fragment,J),j(q.$$.fragment,J),j(L.$$.fragment,J),j(K.$$.fragment,J),j(JJ.$$.fragment,J),j(MJ.$$.fragment,J),j(UJ.$$.fragment,J),j(IJ.$$.fragment,J),j(aJ.$$.fragment,J),j(iJ.$$.fragment,J),j(pJ.$$.fragment,J),j(gJ.$$.fragment,J),j(cJ.$$.fragment,J),j(mJ.$$.fragment,J),j(bJ.$$.fragment,J),j(QJ.$$.fragment,J),j(OJ.$$.fragment,J),KT=!1},d(J){J&&(l(ZJ),l(GJ),l(fJ),l(VJ),l(DJ),l(g),l(WJ),l(d),l(vJ),l(c),l(SJ),l(m),l(NJ),l(u),l(YJ),l(k),l(FJ),l(XJ),l(h),l(zJ),l(B),l(_J),l(Q),l(HJ),l(R),l($J),l(qJ),l(A),l(LJ),l(E),l(KJ),l(G),l(PJ),l(x),l(JT),l(Z),l(TT),l(f),l(lT),l(V),l(MT),l(D),l(UT),l(W),l(wT),l(IT),l(yT),l(eT),l(tT),l(F),l(aT),l(X),l(sT),l(z),l(nT),l(jT),l(H),l(CT),l(iT),l(oT),l(AT),l(pT),l(P),l(rT),l(gT),l(TJ),l(dT),l(lJ),l(cT),l(mT),l(uT),l(wJ),l(kT),l(bT),l(yJ),l(hT),l(eJ),l(BT),l(tJ),l(QT),l(RT),l(sJ),l(OT),l(nJ),l(ET),l(jJ),l(GT),l(CJ),l(xT),l(ZT),l(oJ),l(fT),l(AJ),l(VT),l(DT),l(rJ),l(WT),l(vT),l(dJ),l(ST),l(NT),l(YT),l(uJ),l(FT),l(kJ),l(XT),l(zT),l(hJ),l(_T),l(BJ),l(HT),l($T),l(RJ),l(qT),l(LT),l(xJ)),l(o),C(p,J),C(r,J),C(b,J),C(O,J),C(v,J),C(S,J),C(N,J),C(Y,J),C(_,J),C($,J),C(q,J),C(L,J),C(K,J),C(JJ,J),C(MJ,J),C(UJ,J),C(IJ,J),C(aJ,J),C(iJ,J),C(pJ,J),C(gJ,J),C(cJ,J),C(mJ,J),C(bJ,J),C(QJ,J),C(OJ,J)}}}const MM='{"title":"Sistemas Multi-Agente","local":"sistemas-multi-agente","sections":[{"title":"Sistemas Multi-Agente en Acción","local":"sistemas-multi-agente-en-acción","sections":[],"depth":2},{"title":"Resolviendo una tarea compleja con una jerarquía multi-agente","local":"resolviendo-una-tarea-compleja-con-una-jerarquía-multi-agente","sections":[{"title":"Primero creamos una herramienta para obtener el tiempo de transferencia del avión de carga.","local":"primero-creamos-una-herramienta-para-obtener-el-tiempo-de-transferencia-del-avión-de-carga","sections":[],"depth":3},{"title":"Configurando el agente","local":"configurando-el-agente","sections":[],"depth":3},{"title":"✌️ Dividiendo la tarea entre dos agentes","local":"-dividiendo-la-tarea-entre-dos-agentes","sections":[],"depth":3}],"depth":2},{"title":"Recursos","local":"recursos","sections":[],"depth":2}],"depth":1}';function UM(Jl){return Hl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class sM extends $l{constructor(o){super(),ql(this,o,UM,lM,Xl,{})}}export{sM as component};
