import{s as Ye,n as Le,o as Pe}from"../chunks/scheduler.37c15a92.js";import{S as De,i as Ke,g as o,s as t,r,m as Oe,A as sl,h as p,f as l,c as n,j as Me,u as c,x as i,n as el,k as de,y as we,a,v as u,d,t as m,w as M}from"../chunks/index.2bf4358c.js";import{C as T}from"../chunks/CodeBlock.4e987730.js";import{H as U}from"../chunks/Heading.8ada512a.js";import{E as ll}from"../chunks/getInferenceSnippets.0aa3753f.js";function al(je){let w,ws,ms,js,b,ys,f,ye="Un workflow en LlamaIndex proporciona una forma estructurada de organizar su código en pasos secuenciales y manejables.",Js,h,Je="Tal workflow se crea definiendo <code>Steps</code> que se activan por <code>Events</code>, y emiten <code>Events</code> para activar pasos posteriores.",Ts,I,Te="Echemos un vistazo a Alfred mostrando un workflow de LlamaIndex para una tarea de RAG.",Us,C,Ue='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/llama-index/workflows.png" alt="Workflows esquematico"/>',bs,B,be="<strong>Workflows ofrecen varios beneficios clave:</strong>",fs,v,fe="<li>Organizacion clara de código en pasos discretos</li> <li>Arquitectura de control de flujo basada en eventos flexible</li> <li>Comunicación de tipado segura entre pasos</li> <li>Manejo de estado integrado</li> <li>Apoyo para agentes simples y complejos</li>",hs,g,he="Como podra haber adivinado, <strong>workflows ofrecen un equilibrio entre la autonomía de los agentes mientras se mantiene el control sobre el workflow global.</strong>",Is,k,Ie="Asi que, vamos a aprender como crear un workflow nosotros mismos!",Cs,G,Bs,j,Ce='<p>Puede seguir el código en <a href="https://huggingface.co/agents-course/notebooks/blob/main/unit2/llama-index/workflows.ipynb" target="_blank">esta notebook</a> que puede ejecutar utilizando Google Colab.</p>',vs,V,gs,y,ds,Be="Instalar el paquete Workflow",me,Z,ks,_,ve=`Podemos crear un flujo de trabajo de un solo paso definiendo una clase que herede de <code>Workflow</code> y decorando tus funciones con <code>@step</code>.
También necesitaremos añadir <code>StartEvent</code> y <code>StopEvent</code>, que son eventos especiales que se utilizan para indicar el inicio y el fin del flujo de trabajo.`,Gs,E,Vs,x,ge="Como puedes ver, ahora podemos ejecutar el flujo de trabajo llamando a <code>w.run()</code>.",Zs,W,_s,z,ke=`Para conectar múltiples pasos, <strong>creamos eventos personalizados que transportan datos entre pasos.</strong>
Para hacerlo, necesitamos agregar un <code>Event</code> que se pasa entre los pasos y transfiere la salida del primer paso al segundo paso.`,Es,$,xs,Q,Ge="La indicación de tipo es importante aquí, ya que asegura que el flujo de trabajo se ejecute correctamente. ¡Vamos a complicar un poco más las cosas!",Ws,q,zs,X,Ve="La indicación de tipo es la parte más poderosa de los flujos de trabajo porque nos permite crear ramificaciones, bucles y uniones para facilitar flujos de trabajo más complejos.",$s,S,Ze=`Veamos un ejemplo de <strong>creación de un bucle</strong> usando el operador de unión <code>|</code>.
En el ejemplo siguiente, vemos que el <code>LoopEvent</code> se toma como entrada para el paso y también puede devolverse como salida.`,Qs,H,qs,N,Xs,R,_e="También podemos dibujar flujos de trabajo. Usemos la función <code>draw_all_possible_flows</code> para dibujar el flujo de trabajo. Esto almacena el flujo de trabajo en un archivo HTML.",Ss,A,Hs,F,Ee='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/llama-index/workflow-draw.png" alt="dibujo del flujo de trabajo"/>',Ns,Y,xe="Hay un último truco interesante que cubriremos en el curso, que es la capacidad de añadir estado al flujo de trabajo.",Rs,L,As,P,We=`La gestión de estado es útil cuando quieres hacer un seguimiento del estado del flujo de trabajo, para que cada paso tenga acceso al mismo estado.
Podemos hacer esto usando la pista de tipo <code>Context</code> encima de un parámetro en la función del paso.`,Fs,D,Ys,K,ze="¡Genial! ¡Ahora sabes cómo crear flujos de trabajo básicos en LlamaIndex!",Ls,J,$e='<p>Hay algunos matices más complejos en los flujos de trabajo, que puedes aprender en <a href="https://docs.llamaindex.ai/en/stable/understanding/workflows/">la documentación de LlamaIndex</a>.</p>',Ps,O,Qe="Sin embargo, hay otra forma de crear flujos de trabajo, que se basa en la clase <code>AgentWorkflow</code>. Veamos cómo podemos usar esto para crear un flujo de trabajo multiagente.",Ds,ss,Ks,es,qe=`En lugar de la creación manual de flujos de trabajo, podemos usar la clase <strong><code>AgentWorkflow</code> para crear un flujo de trabajo multiagente</strong>.
El <code>AgentWorkflow</code> utiliza Agentes de Flujo de Trabajo para permitirte crear un sistema de uno o más agentes que pueden colaborar y transferir tareas entre sí según sus capacidades especializadas.
Esto permite construir sistemas de agentes complejos donde diferentes agentes manejan diferentes aspectos de una tarea.
En lugar de importar clases de <code>llama_index.core.agent</code>, importaremos las clases de agente de <code>llama_index.core.agent.workflow</code>.
Un agente debe ser designado como el agente raíz en el constructor de <code>AgentWorkflow</code>.
Cuando llega un mensaje de usuario, primero se dirige al agente raíz.`,Os,ls,Xe="Cada agente puede entonces:",se,as,Se="<li>Manejar la solicitud directamente usando sus herramientas</li> <li>Transferir a otro agente mejor preparado para la tarea</li> <li>Devolver una respuesta al usuario</li>",ee,ts,He="Veamos cómo crear un flujo de trabajo multiagente.",le,ns,ae,os,Ne=`Las herramientas del agente también pueden modificar el estado del flujo de trabajo que mencionamos anteriormente. Antes de iniciar el flujo de trabajo, podemos proporcionar un diccionario de estado inicial que estará disponible para todos los agentes.
El estado se almacena en la clave state del contexto del flujo de trabajo. Se inyectará en el state_prompt que aumenta cada nuevo mensaje de usuario.`,te,ps,Re="Vamos a inyectar un contador para contar las llamadas a funciones modificando el ejemplo anterior:",ne,is,oe,rs,Ae="¡Felicidades! ¡Ahora has dominado los conceptos básicos de los Agentes en LlamaIndex! 🎉",pe,cs,Fe="¡Continuemos con un último cuestionario para consolidar tu conocimiento! 🚀",ie,us,re,Ms,ce;return b=new U({props:{title:"Crear workflows agenticos en LlamaIndex",local:"crear-workflows-agenticos-en-llamaindex",headingTag:"h1"}}),G=new U({props:{title:"Crear Workflows",local:"crear-workflows",headingTag:"h2"}}),V=new U({props:{title:"Crear un workflow básico",local:"crear-un-workflow-básico",headingTag:"h3"}}),Z=new T({props:{code:"cGlwJTIwaW5zdGFsbCUyMGxsYW1hLWluZGV4LXV0aWxzLXdvcmtmbG93",highlighted:"pip install llama-index-utils-workflow",wrap:!1}}),E=new T({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUud29ya2Zsb3clMjBpbXBvcnQlMjBTdGFydEV2ZW50JTJDJTIwU3RvcEV2ZW50JTJDJTIwV29ya2Zsb3clMkMlMjBzdGVwJTBBJTBBY2xhc3MlMjBNeVdvcmtmbG93KFdvcmtmbG93KSUzQSUwQSUyMCUyMCUyMCUyMCU0MHN0ZXAlMEElMjAlMjAlMjAlMjBhc3luYyUyMGRlZiUyMG15X3N0ZXAoc2VsZiUyQyUyMGV2JTNBJTIwU3RhcnRFdmVudCklMjAtJTNFJTIwU3RvcEV2ZW50JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwaGFjZXIlMjBhbGdvJTIwYXF1JUMzJUFEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwU3RvcEV2ZW50KHJlc3VsdCUzRCUyMiVDMiVBMUhvbGElMkMlMjBtdW5kbyElMjIpJTBBJTBBJTBBdyUyMCUzRCUyME15V29ya2Zsb3codGltZW91dCUzRDEwJTJDJTIwdmVyYm9zZSUzREZhbHNlKSUwQXJlc3VsdCUyMCUzRCUyMGF3YWl0JTIwdy5ydW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> StartEvent, StopEvent, Workflow, step

<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyWorkflow</span>(<span class="hljs-title class_ inherited__">Workflow</span>):
<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">my_step</span>(<span class="hljs-params">self, ev: StartEvent</span>) -&gt; StopEvent:
        <span class="hljs-comment"># hacer algo aquí</span>
        <span class="hljs-keyword">return</span> StopEvent(result=<span class="hljs-string">&quot;¡Hola, mundo!&quot;</span>)


w = MyWorkflow(timeout=<span class="hljs-number">10</span>, verbose=<span class="hljs-literal">False</span>)
result = <span class="hljs-keyword">await</span> w.run()`,wrap:!1}}),W=new U({props:{title:"Conectando Múltiples Pasos",local:"conectando-múltiples-pasos",headingTag:"h3"}}),$=new T({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUud29ya2Zsb3clMjBpbXBvcnQlMjBFdmVudCUwQSUwQWNsYXNzJTIwUHJvY2Vzc2luZ0V2ZW50KEV2ZW50KSUzQSUwQSUyMCUyMCUyMCUyMGludGVybWVkaWF0ZV9yZXN1bHQlM0ElMjBzdHIlMEElMEFjbGFzcyUyME11bHRpU3RlcFdvcmtmbG93KFdvcmtmbG93KSUzQSUwQSUyMCUyMCUyMCUyMCU0MHN0ZXAlMEElMjAlMjAlMjAlMjBhc3luYyUyMGRlZiUyMHN0ZXBfb25lKHNlbGYlMkMlMjBldiUzQSUyMFN0YXJ0RXZlbnQpJTIwLSUzRSUyMFByb2Nlc3NpbmdFdmVudCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFByb2Nlc2FyJTIwZGF0b3MlMjBpbmljaWFsZXMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBQcm9jZXNzaW5nRXZlbnQoaW50ZXJtZWRpYXRlX3Jlc3VsdCUzRCUyMlBhc28lMjAxJTIwY29tcGxldGFkbyUyMiklMEElMEElMjAlMjAlMjAlMjAlNDBzdGVwJTBBJTIwJTIwJTIwJTIwYXN5bmMlMjBkZWYlMjBzdGVwX3R3byhzZWxmJTJDJTIwZXYlM0ElMjBQcm9jZXNzaW5nRXZlbnQpJTIwLSUzRSUyMFN0b3BFdmVudCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFVzYXIlMjBlbCUyMHJlc3VsdGFkbyUyMGludGVybWVkaW8lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmaW5hbF9yZXN1bHQlMjAlM0QlMjBmJTIyUHJvY2VzYW1pZW50byUyMGZpbmFsaXphZG8lM0ElMjAlN0Jldi5pbnRlcm1lZGlhdGVfcmVzdWx0JTdEJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwU3RvcEV2ZW50KHJlc3VsdCUzRGZpbmFsX3Jlc3VsdCklMEElMEF3JTIwJTNEJTIwTXVsdGlTdGVwV29ya2Zsb3codGltZW91dCUzRDEwJTJDJTIwdmVyYm9zZSUzREZhbHNlKSUwQXJlc3VsdCUyMCUzRCUyMGF3YWl0JTIwdy5ydW4oKSUwQXJlc3VsdA==",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> Event

<span class="hljs-keyword">class</span> <span class="hljs-title class_">ProcessingEvent</span>(<span class="hljs-title class_ inherited__">Event</span>):
    intermediate_result: <span class="hljs-built_in">str</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">MultiStepWorkflow</span>(<span class="hljs-title class_ inherited__">Workflow</span>):
<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">step_one</span>(<span class="hljs-params">self, ev: StartEvent</span>) -&gt; ProcessingEvent:
        <span class="hljs-comment"># Procesar datos iniciales</span>
        <span class="hljs-keyword">return</span> ProcessingEvent(intermediate_result=<span class="hljs-string">&quot;Paso 1 completado&quot;</span>)

<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">step_two</span>(<span class="hljs-params">self, ev: ProcessingEvent</span>) -&gt; StopEvent:
        <span class="hljs-comment"># Usar el resultado intermedio</span>
        final_result = <span class="hljs-string">f&quot;Procesamiento finalizado: <span class="hljs-subst">{ev.intermediate_result}</span>&quot;</span>
        <span class="hljs-keyword">return</span> StopEvent(result=final_result)

w = MultiStepWorkflow(timeout=<span class="hljs-number">10</span>, verbose=<span class="hljs-literal">False</span>)
result = <span class="hljs-keyword">await</span> w.run()
result`,wrap:!1}}),q=new U({props:{title:"Bucles y Ramificaciones",local:"bucles-y-ramificaciones",headingTag:"h3"}}),H=new T({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUud29ya2Zsb3clMjBpbXBvcnQlMjBFdmVudCUwQWltcG9ydCUyMHJhbmRvbSUwQSUwQSUwQWNsYXNzJTIwUHJvY2Vzc2luZ0V2ZW50KEV2ZW50KSUzQSUwQSUyMCUyMCUyMCUyMGludGVybWVkaWF0ZV9yZXN1bHQlM0ElMjBzdHIlMEElMEElMEFjbGFzcyUyMExvb3BFdmVudChFdmVudCklM0ElMEElMjAlMjAlMjAlMjBsb29wX291dHB1dCUzQSUyMHN0ciUwQSUwQSUwQWNsYXNzJTIwTXVsdGlTdGVwV29ya2Zsb3coV29ya2Zsb3cpJTNBJTBBJTIwJTIwJTIwJTIwJTQwc3RlcCUwQSUyMCUyMCUyMCUyMGFzeW5jJTIwZGVmJTIwc3RlcF9vbmUoc2VsZiUyQyUyMGV2JTNBJTIwU3RhcnRFdmVudCklMjAtJTNFJTIwUHJvY2Vzc2luZ0V2ZW50JTIwJTdDJTIwTG9vcEV2ZW50JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjByYW5kb20ucmFuZGludCgwJTJDJTIwMSklMjAlM0QlM0QlMjAwJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoJTIyT2N1cnJpJUMzJUIzJTIwYWxnbyUyMG1hbG8lMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwTG9vcEV2ZW50KGxvb3Bfb3V0cHV0JTNEJTIyVm9sdmVyJTIwYWwlMjBwYXNvJTIwdW5vLiUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoJTIyT2N1cnJpJUMzJUIzJTIwYWxnbyUyMGJ1ZW5vJTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMFByb2Nlc3NpbmdFdmVudChpbnRlcm1lZGlhdGVfcmVzdWx0JTNEJTIyUHJpbWVyJTIwcGFzbyUyMGNvbXBsZXRhZG8uJTIyKSUwQSUwQSUyMCUyMCUyMCUyMCU0MHN0ZXAlMEElMjAlMjAlMjAlMjBhc3luYyUyMGRlZiUyMHN0ZXBfdHdvKHNlbGYlMkMlMjBldiUzQSUyMFByb2Nlc3NpbmdFdmVudCUyMCU3QyUyMExvb3BFdmVudCklMjAtJTNFJTIwU3RvcEV2ZW50JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwVXNhciUyMGVsJTIwcmVzdWx0YWRvJTIwaW50ZXJtZWRpbyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZpbmFsX3Jlc3VsdCUyMCUzRCUyMGYlMjJQcm9jZXNhbWllbnRvJTIwZmluYWxpemFkbyUzQSUyMCU3QmV2LmludGVybWVkaWF0ZV9yZXN1bHQlN0QlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBTdG9wRXZlbnQocmVzdWx0JTNEZmluYWxfcmVzdWx0KSUwQSUwQSUwQXclMjAlM0QlMjBNdWx0aVN0ZXBXb3JrZmxvdyh2ZXJib3NlJTNERmFsc2UpJTBBcmVzdWx0JTIwJTNEJTIwYXdhaXQlMjB3LnJ1bigpJTBBcmVzdWx0",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> Event
<span class="hljs-keyword">import</span> random


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ProcessingEvent</span>(<span class="hljs-title class_ inherited__">Event</span>):
    intermediate_result: <span class="hljs-built_in">str</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">LoopEvent</span>(<span class="hljs-title class_ inherited__">Event</span>):
    loop_output: <span class="hljs-built_in">str</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MultiStepWorkflow</span>(<span class="hljs-title class_ inherited__">Workflow</span>):
<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">step_one</span>(<span class="hljs-params">self, ev: StartEvent</span>) -&gt; ProcessingEvent | LoopEvent:
        <span class="hljs-keyword">if</span> random.randint(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>) == <span class="hljs-number">0</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Ocurrió algo malo&quot;</span>)
            <span class="hljs-keyword">return</span> LoopEvent(loop_output=<span class="hljs-string">&quot;Volver al paso uno.&quot;</span>)
        <span class="hljs-keyword">else</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Ocurrió algo bueno&quot;</span>)
            <span class="hljs-keyword">return</span> ProcessingEvent(intermediate_result=<span class="hljs-string">&quot;Primer paso completado.&quot;</span>)

<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">step_two</span>(<span class="hljs-params">self, ev: ProcessingEvent | LoopEvent</span>) -&gt; StopEvent:
        <span class="hljs-comment"># Usar el resultado intermedio</span>
        final_result = <span class="hljs-string">f&quot;Procesamiento finalizado: <span class="hljs-subst">{ev.intermediate_result}</span>&quot;</span>
        <span class="hljs-keyword">return</span> StopEvent(result=final_result)


w = MultiStepWorkflow(verbose=<span class="hljs-literal">False</span>)
result = <span class="hljs-keyword">await</span> w.run()
result`,wrap:!1}}),N=new U({props:{title:"Dibujando Flujos de Trabajo",local:"dibujando-flujos-de-trabajo",headingTag:"h3"}}),A=new T({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LnV0aWxzLndvcmtmbG93JTIwaW1wb3J0JTIwZHJhd19hbGxfcG9zc2libGVfZmxvd3MlMEElMEF3JTIwJTNEJTIwLi4uJTIwJTIzJTIwY29tbyUyMHNlJTIwZGVmaW5pJUMzJUIzJTIwZW4lMjBsYSUyMHNlY2NpJUMzJUIzbiUyMGFudGVyaW9yJTBBZHJhd19hbGxfcG9zc2libGVfZmxvd3ModyUyQyUyMCUyMmZsb3cuaHRtbCUyMik=",highlighted:`<span class="hljs-keyword">from</span> llama_index.utils.workflow <span class="hljs-keyword">import</span> draw_all_possible_flows

w = ... <span class="hljs-comment"># como se definió en la sección anterior</span>
draw_all_possible_flows(w, <span class="hljs-string">&quot;flow.html&quot;</span>)`,wrap:!1}}),L=new U({props:{title:"Gestión de Estado",local:"gestión-de-estado",headingTag:"h3"}}),D=new T({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUud29ya2Zsb3clMjBpbXBvcnQlMjBDb250ZXh0JTJDJTIwU3RhcnRFdmVudCUyQyUyMFN0b3BFdmVudCUwQSUwQSUwQSU0MHN0ZXAlMEFhc3luYyUyMGRlZiUyMHF1ZXJ5KHNlbGYlMkMlMjBjdHglM0ElMjBDb250ZXh0JTJDJTIwZXYlM0ElMjBTdGFydEV2ZW50KSUyMC0lM0UlMjBTdG9wRXZlbnQlM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBhbG1hY2VuYXIlMjBlbiUyMGNvbnRleHRvJTBBJTIwJTIwJTIwJTIwYXdhaXQlMjBjdHguc3RvcmUuc2V0KCUyMnF1ZXJ5JTIyJTJDJTIwJTIyJUMyJUJGQ3UlQzMlQTFsJTIwZXMlMjBsYSUyMGNhcGl0YWwlMjBkZSUyMEZyYW5jaWElM0YlMjIpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwaGFjZXIlMjBhbGdvJTIwY29uJTIwZWwlMjBjb250ZXh0byUyMHklMjBlbCUyMGV2ZW50byUwQSUyMCUyMCUyMCUyMHZhbCUyMCUzRCUyMC4uLiUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMHJlY3VwZXJhciUyMGRlbCUyMGNvbnRleHRvJTBBJTIwJTIwJTIwJTIwcXVlcnklMjAlM0QlMjBhd2FpdCUyMGN0eC5zdG9yZS5nZXQoJTIycXVlcnklMjIpJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwU3RvcEV2ZW50KHJlc3VsdCUzRHJlc3VsdCk=",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> Context, StartEvent, StopEvent


<span class="hljs-meta">@step</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">query</span>(<span class="hljs-params">self, ctx: Context, ev: StartEvent</span>) -&gt; StopEvent:
    <span class="hljs-comment"># almacenar en contexto</span>
    <span class="hljs-keyword">await</span> ctx.store.<span class="hljs-built_in">set</span>(<span class="hljs-string">&quot;query&quot;</span>, <span class="hljs-string">&quot;¿Cuál es la capital de Francia?&quot;</span>)

    <span class="hljs-comment"># hacer algo con el contexto y el evento</span>
    val = ...

    <span class="hljs-comment"># recuperar del contexto</span>
    query = <span class="hljs-keyword">await</span> ctx.store.get(<span class="hljs-string">&quot;query&quot;</span>)

    <span class="hljs-keyword">return</span> StopEvent(result=result)`,wrap:!1}}),ss=new U({props:{title:"Automatizando flujos de trabajo con Flujos de Trabajo Multiagente",local:"automatizando-flujos-de-trabajo-con-flujos-de-trabajo-multiagente",headingTag:"h2"}}),ns=new T({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.agent.workflow <span class="hljs-keyword">import</span> AgentWorkflow, ReActAgent
<span class="hljs-keyword">from</span> llama_index.llms.huggingface_api <span class="hljs-keyword">import</span> HuggingFaceInferenceAPI

<span class="hljs-comment"># Definir algunas herramientas</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">add</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Sumar dos números.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a + b

<span class="hljs-keyword">def</span> <span class="hljs-title function_">multiply</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiplicar dos números.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

llm = HuggingFaceInferenceAPI(model_name=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)

<span class="hljs-comment"># podemos pasar funciones directamente sin FunctionTool -- la función/docstring se analizan para el nombre/descripción</span>
multiply_agent = ReActAgent(
    name=<span class="hljs-string">&quot;multiply_agent&quot;</span>,
    description=<span class="hljs-string">&quot;Es capaz de multiplicar dos enteros&quot;</span>,
    system_prompt=<span class="hljs-string">&quot;Un asistente útil que puede usar una herramienta para multiplicar números.&quot;</span>,
    tools=[multiply],
    llm=llm,
)

addition_agent = ReActAgent(
    name=<span class="hljs-string">&quot;add_agent&quot;</span>,
    description=<span class="hljs-string">&quot;Es capaz de sumar dos enteros&quot;</span>,
    system_prompt=<span class="hljs-string">&quot;Un asistente útil que puede usar una herramienta para sumar números.&quot;</span>,
    tools=[add],
    llm=llm,
)

<span class="hljs-comment"># Crear el flujo de trabajo</span>
workflow = AgentWorkflow(
    agents=[multiply_agent, addition_agent],
    root_agent=<span class="hljs-string">&quot;multiply_agent&quot;</span>,
)

<span class="hljs-comment"># Ejecutar el sistema</span>
response = <span class="hljs-keyword">await</span> workflow.run(user_msg=<span class="hljs-string">&quot;¿Puedes sumar 5 y 3?&quot;</span>)`,wrap:!1}}),is=new T({props:{code:"JTBBJTBBJTBBJTBBJTBBJTBBJTBB",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> Context

<span class="hljs-comment"># Definir algunas herramientas</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">add</span>(<span class="hljs-params">ctx: Context, a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Sumar dos números.&quot;&quot;&quot;</span>
    <span class="hljs-comment"># actualizar nuestro contador</span>
    cur_state = <span class="hljs-keyword">await</span> ctx.store.get(<span class="hljs-string">&quot;state&quot;</span>)
    cur_state[<span class="hljs-string">&quot;num_fn_calls&quot;</span>] += <span class="hljs-number">1</span>
    <span class="hljs-keyword">await</span> ctx.store.<span class="hljs-built_in">set</span>(<span class="hljs-string">&quot;state&quot;</span>, cur_state)

    <span class="hljs-keyword">return</span> a + b

<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">multiply</span>(<span class="hljs-params">ctx: Context, a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiplicar dos números.&quot;&quot;&quot;</span>
    <span class="hljs-comment"># actualizar nuestro contador</span>
    cur_state = <span class="hljs-keyword">await</span> ctx.store.get(<span class="hljs-string">&quot;state&quot;</span>)
    cur_state[<span class="hljs-string">&quot;num_fn_calls&quot;</span>] += <span class="hljs-number">1</span>
    <span class="hljs-keyword">await</span> ctx.store.<span class="hljs-built_in">set</span>(<span class="hljs-string">&quot;state&quot;</span>, cur_state)

    <span class="hljs-keyword">return</span> a * b

...

workflow = AgentWorkflow(
    agents=[multiply_agent, addition_agent],
    root_agent=<span class="hljs-string">&quot;multiply_agent&quot;</span>
    initial_state={<span class="hljs-string">&quot;num_fn_calls&quot;</span>: <span class="hljs-number">0</span>},
    state_prompt=<span class="hljs-string">&quot;Estado actual: {state}. Mensaje del usuario: {msg}&quot;</span>,
)

<span class="hljs-comment"># ejecutar el flujo de trabajo con contexto</span>
ctx = Context(workflow)
response = <span class="hljs-keyword">await</span> workflow.run(user_msg=<span class="hljs-string">&quot;¿Puedes sumar 5 y 3?&quot;</span>, ctx=ctx)

<span class="hljs-comment"># extraer e inspeccionar el estado</span>
state = <span class="hljs-keyword">await</span> ctx.store.get(<span class="hljs-string">&quot;state&quot;</span>)
<span class="hljs-built_in">print</span>(state[<span class="hljs-string">&quot;num_fn_calls&quot;</span>])`,wrap:!1}}),us=new ll({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/es/unit2/llama-index/workflows.mdx"}}),{c(){w=o("meta"),ws=t(),ms=o("p"),js=t(),r(b.$$.fragment),ys=t(),f=o("p"),f.textContent=ye,Js=t(),h=o("p"),h.innerHTML=Je,Ts=t(),I=o("p"),I.textContent=Te,Us=t(),C=o("p"),C.innerHTML=Ue,bs=t(),B=o("p"),B.innerHTML=be,fs=t(),v=o("ul"),v.innerHTML=fe,hs=t(),g=o("p"),g.innerHTML=he,Is=t(),k=o("p"),k.textContent=Ie,Cs=t(),r(G.$$.fragment),Bs=t(),j=o("blockquote"),j.innerHTML=Ce,vs=t(),r(V.$$.fragment),gs=t(),y=o("details"),ds=o("summary"),ds.textContent=Be,me=Oe(`
Como se introdujo en la [sección sobre LlamaHub](llama-hub), podemos instalar el paquete Workflow con el siguiente comando:

	`),r(Z.$$.fragment),ks=t(),_=o("p"),_.innerHTML=ve,Gs=t(),r(E.$$.fragment),Vs=t(),x=o("p"),x.innerHTML=ge,Zs=t(),r(W.$$.fragment),_s=t(),z=o("p"),z.innerHTML=ke,Es=t(),r($.$$.fragment),xs=t(),Q=o("p"),Q.textContent=Ge,Ws=t(),r(q.$$.fragment),zs=t(),X=o("p"),X.textContent=Ve,$s=t(),S=o("p"),S.innerHTML=Ze,Qs=t(),r(H.$$.fragment),qs=t(),r(N.$$.fragment),Xs=t(),R=o("p"),R.innerHTML=_e,Ss=t(),r(A.$$.fragment),Hs=t(),F=o("p"),F.innerHTML=Ee,Ns=t(),Y=o("p"),Y.textContent=xe,Rs=t(),r(L.$$.fragment),As=t(),P=o("p"),P.innerHTML=We,Fs=t(),r(D.$$.fragment),Ys=t(),K=o("p"),K.textContent=ze,Ls=t(),J=o("blockquote"),J.innerHTML=$e,Ps=t(),O=o("p"),O.innerHTML=Qe,Ds=t(),r(ss.$$.fragment),Ks=t(),es=o("p"),es.innerHTML=qe,Os=t(),ls=o("p"),ls.textContent=Xe,se=t(),as=o("ul"),as.innerHTML=Se,ee=t(),ts=o("p"),ts.textContent=He,le=t(),r(ns.$$.fragment),ae=t(),os=o("p"),os.textContent=Ne,te=t(),ps=o("p"),ps.textContent=Re,ne=t(),r(is.$$.fragment),oe=t(),rs=o("p"),rs.textContent=Ae,pe=t(),cs=o("p"),cs.textContent=Fe,ie=t(),r(us.$$.fragment),re=t(),Ms=o("p"),this.h()},l(s){const e=sl("svelte-u9bgzb",document.head);w=p(e,"META",{name:!0,content:!0}),e.forEach(l),ws=n(s),ms=p(s,"P",{}),Me(ms).forEach(l),js=n(s),c(b.$$.fragment,s),ys=n(s),f=p(s,"P",{"data-svelte-h":!0}),i(f)!=="svelte-1lix0g5"&&(f.textContent=ye),Js=n(s),h=p(s,"P",{"data-svelte-h":!0}),i(h)!=="svelte-1m5c0tu"&&(h.innerHTML=Je),Ts=n(s),I=p(s,"P",{"data-svelte-h":!0}),i(I)!=="svelte-khslop"&&(I.textContent=Te),Us=n(s),C=p(s,"P",{"data-svelte-h":!0}),i(C)!=="svelte-w1nyou"&&(C.innerHTML=Ue),bs=n(s),B=p(s,"P",{"data-svelte-h":!0}),i(B)!=="svelte-1drxdlt"&&(B.innerHTML=be),fs=n(s),v=p(s,"UL",{"data-svelte-h":!0}),i(v)!=="svelte-jiyuvc"&&(v.innerHTML=fe),hs=n(s),g=p(s,"P",{"data-svelte-h":!0}),i(g)!=="svelte-1gm9hbm"&&(g.innerHTML=he),Is=n(s),k=p(s,"P",{"data-svelte-h":!0}),i(k)!=="svelte-ung185"&&(k.textContent=Ie),Cs=n(s),c(G.$$.fragment,s),Bs=n(s),j=p(s,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),i(j)!=="svelte-103t8nk"&&(j.innerHTML=Ce),vs=n(s),c(V.$$.fragment,s),gs=n(s),y=p(s,"DETAILS",{});var ue=Me(y);ds=p(ue,"SUMMARY",{"data-svelte-h":!0}),i(ds)!=="svelte-nidhp3"&&(ds.textContent=Be),me=el(ue,`
Como se introdujo en la [sección sobre LlamaHub](llama-hub), podemos instalar el paquete Workflow con el siguiente comando:

	`),c(Z.$$.fragment,ue),ue.forEach(l),ks=n(s),_=p(s,"P",{"data-svelte-h":!0}),i(_)!=="svelte-1q8rqbj"&&(_.innerHTML=ve),Gs=n(s),c(E.$$.fragment,s),Vs=n(s),x=p(s,"P",{"data-svelte-h":!0}),i(x)!=="svelte-113newy"&&(x.innerHTML=ge),Zs=n(s),c(W.$$.fragment,s),_s=n(s),z=p(s,"P",{"data-svelte-h":!0}),i(z)!=="svelte-1gigad5"&&(z.innerHTML=ke),Es=n(s),c($.$$.fragment,s),xs=n(s),Q=p(s,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-1ctrgy3"&&(Q.textContent=Ge),Ws=n(s),c(q.$$.fragment,s),zs=n(s),X=p(s,"P",{"data-svelte-h":!0}),i(X)!=="svelte-1yaw7gt"&&(X.textContent=Ve),$s=n(s),S=p(s,"P",{"data-svelte-h":!0}),i(S)!=="svelte-zm1jpc"&&(S.innerHTML=Ze),Qs=n(s),c(H.$$.fragment,s),qs=n(s),c(N.$$.fragment,s),Xs=n(s),R=p(s,"P",{"data-svelte-h":!0}),i(R)!=="svelte-e8mj9m"&&(R.innerHTML=_e),Ss=n(s),c(A.$$.fragment,s),Hs=n(s),F=p(s,"P",{"data-svelte-h":!0}),i(F)!=="svelte-s95098"&&(F.innerHTML=Ee),Ns=n(s),Y=p(s,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-fe8nvj"&&(Y.textContent=xe),Rs=n(s),c(L.$$.fragment,s),As=n(s),P=p(s,"P",{"data-svelte-h":!0}),i(P)!=="svelte-mobhjv"&&(P.innerHTML=We),Fs=n(s),c(D.$$.fragment,s),Ys=n(s),K=p(s,"P",{"data-svelte-h":!0}),i(K)!=="svelte-yqpb97"&&(K.textContent=ze),Ls=n(s),J=p(s,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),i(J)!=="svelte-wck0n7"&&(J.innerHTML=$e),Ps=n(s),O=p(s,"P",{"data-svelte-h":!0}),i(O)!=="svelte-gmv6hb"&&(O.innerHTML=Qe),Ds=n(s),c(ss.$$.fragment,s),Ks=n(s),es=p(s,"P",{"data-svelte-h":!0}),i(es)!=="svelte-tz499j"&&(es.innerHTML=qe),Os=n(s),ls=p(s,"P",{"data-svelte-h":!0}),i(ls)!=="svelte-1hnc17x"&&(ls.textContent=Xe),se=n(s),as=p(s,"UL",{"data-svelte-h":!0}),i(as)!=="svelte-2x6jux"&&(as.innerHTML=Se),ee=n(s),ts=p(s,"P",{"data-svelte-h":!0}),i(ts)!=="svelte-tm81au"&&(ts.textContent=He),le=n(s),c(ns.$$.fragment,s),ae=n(s),os=p(s,"P",{"data-svelte-h":!0}),i(os)!=="svelte-1hvckkj"&&(os.textContent=Ne),te=n(s),ps=p(s,"P",{"data-svelte-h":!0}),i(ps)!=="svelte-131zgzc"&&(ps.textContent=Re),ne=n(s),c(is.$$.fragment,s),oe=n(s),rs=p(s,"P",{"data-svelte-h":!0}),i(rs)!=="svelte-1dnh5hk"&&(rs.textContent=Ae),pe=n(s),cs=p(s,"P",{"data-svelte-h":!0}),i(cs)!=="svelte-172wyo2"&&(cs.textContent=Fe),ie=n(s),c(us.$$.fragment,s),re=n(s),Ms=p(s,"P",{}),Me(Ms).forEach(l),this.h()},h(){de(w,"name","hf:doc:metadata"),de(w,"content",tl),de(j,"class","tip"),de(J,"class","tip")},m(s,e){we(document.head,w),a(s,ws,e),a(s,ms,e),a(s,js,e),u(b,s,e),a(s,ys,e),a(s,f,e),a(s,Js,e),a(s,h,e),a(s,Ts,e),a(s,I,e),a(s,Us,e),a(s,C,e),a(s,bs,e),a(s,B,e),a(s,fs,e),a(s,v,e),a(s,hs,e),a(s,g,e),a(s,Is,e),a(s,k,e),a(s,Cs,e),u(G,s,e),a(s,Bs,e),a(s,j,e),a(s,vs,e),u(V,s,e),a(s,gs,e),a(s,y,e),we(y,ds),we(y,me),u(Z,y,null),a(s,ks,e),a(s,_,e),a(s,Gs,e),u(E,s,e),a(s,Vs,e),a(s,x,e),a(s,Zs,e),u(W,s,e),a(s,_s,e),a(s,z,e),a(s,Es,e),u($,s,e),a(s,xs,e),a(s,Q,e),a(s,Ws,e),u(q,s,e),a(s,zs,e),a(s,X,e),a(s,$s,e),a(s,S,e),a(s,Qs,e),u(H,s,e),a(s,qs,e),u(N,s,e),a(s,Xs,e),a(s,R,e),a(s,Ss,e),u(A,s,e),a(s,Hs,e),a(s,F,e),a(s,Ns,e),a(s,Y,e),a(s,Rs,e),u(L,s,e),a(s,As,e),a(s,P,e),a(s,Fs,e),u(D,s,e),a(s,Ys,e),a(s,K,e),a(s,Ls,e),a(s,J,e),a(s,Ps,e),a(s,O,e),a(s,Ds,e),u(ss,s,e),a(s,Ks,e),a(s,es,e),a(s,Os,e),a(s,ls,e),a(s,se,e),a(s,as,e),a(s,ee,e),a(s,ts,e),a(s,le,e),u(ns,s,e),a(s,ae,e),a(s,os,e),a(s,te,e),a(s,ps,e),a(s,ne,e),u(is,s,e),a(s,oe,e),a(s,rs,e),a(s,pe,e),a(s,cs,e),a(s,ie,e),u(us,s,e),a(s,re,e),a(s,Ms,e),ce=!0},p:Le,i(s){ce||(d(b.$$.fragment,s),d(G.$$.fragment,s),d(V.$$.fragment,s),d(Z.$$.fragment,s),d(E.$$.fragment,s),d(W.$$.fragment,s),d($.$$.fragment,s),d(q.$$.fragment,s),d(H.$$.fragment,s),d(N.$$.fragment,s),d(A.$$.fragment,s),d(L.$$.fragment,s),d(D.$$.fragment,s),d(ss.$$.fragment,s),d(ns.$$.fragment,s),d(is.$$.fragment,s),d(us.$$.fragment,s),ce=!0)},o(s){m(b.$$.fragment,s),m(G.$$.fragment,s),m(V.$$.fragment,s),m(Z.$$.fragment,s),m(E.$$.fragment,s),m(W.$$.fragment,s),m($.$$.fragment,s),m(q.$$.fragment,s),m(H.$$.fragment,s),m(N.$$.fragment,s),m(A.$$.fragment,s),m(L.$$.fragment,s),m(D.$$.fragment,s),m(ss.$$.fragment,s),m(ns.$$.fragment,s),m(is.$$.fragment,s),m(us.$$.fragment,s),ce=!1},d(s){s&&(l(ws),l(ms),l(js),l(ys),l(f),l(Js),l(h),l(Ts),l(I),l(Us),l(C),l(bs),l(B),l(fs),l(v),l(hs),l(g),l(Is),l(k),l(Cs),l(Bs),l(j),l(vs),l(gs),l(y),l(ks),l(_),l(Gs),l(Vs),l(x),l(Zs),l(_s),l(z),l(Es),l(xs),l(Q),l(Ws),l(zs),l(X),l($s),l(S),l(Qs),l(qs),l(Xs),l(R),l(Ss),l(Hs),l(F),l(Ns),l(Y),l(Rs),l(As),l(P),l(Fs),l(Ys),l(K),l(Ls),l(J),l(Ps),l(O),l(Ds),l(Ks),l(es),l(Os),l(ls),l(se),l(as),l(ee),l(ts),l(le),l(ae),l(os),l(te),l(ps),l(ne),l(oe),l(rs),l(pe),l(cs),l(ie),l(re),l(Ms)),l(w),M(b,s),M(G,s),M(V,s),M(Z),M(E,s),M(W,s),M($,s),M(q,s),M(H,s),M(N,s),M(A,s),M(L,s),M(D,s),M(ss,s),M(ns,s),M(is,s),M(us,s)}}}const tl='{"title":"Crear workflows agenticos en LlamaIndex","local":"crear-workflows-agenticos-en-llamaindex","sections":[{"title":"Crear Workflows","local":"crear-workflows","sections":[{"title":"Crear un workflow básico","local":"crear-un-workflow-básico","sections":[],"depth":3},{"title":"Conectando Múltiples Pasos","local":"conectando-múltiples-pasos","sections":[],"depth":3},{"title":"Bucles y Ramificaciones","local":"bucles-y-ramificaciones","sections":[],"depth":3},{"title":"Dibujando Flujos de Trabajo","local":"dibujando-flujos-de-trabajo","sections":[],"depth":3},{"title":"Gestión de Estado","local":"gestión-de-estado","sections":[],"depth":3}],"depth":2},{"title":"Automatizando flujos de trabajo con Flujos de Trabajo Multiagente","local":"automatizando-flujos-de-trabajo-con-flujos-de-trabajo-multiagente","sections":[],"depth":2}],"depth":1}';function nl(je){return Pe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ul extends De{constructor(w){super(),Ke(this,w,nl,al,Ye,{})}}export{ul as component};
