import{s as It,n as Vt,o as $t}from"../chunks/scheduler.37c15a92.js";import{S as Xt,i as Bt,g as o,s as n,r as d,m as _t,A as Rt,h as i,f as t,c as s,j as Xa,u as c,x as r,n as Et,k as Ue,y as f,a as l,v as m,d as u,t as p,w as b}from"../chunks/index.2bf4358c.js";import{C as v}from"../chunks/CodeBlock.4e987730.js";import{H as xe}from"../chunks/Heading.8ada512a.js";import{E as St}from"../chunks/getInferenceSnippets.0aa3753f.js";function Ht(Aa){let y,We,Ce,_e,Z,Ee,L,qa=`¿Recuerdas a Alfred, nuestro útil agente mayordomo de la Unidad 1?
Para ayudarnos de manera efectiva, Alfred necesita entender nuestras solicitudes y <strong>preparar, encontrar y usar información relevante para ayudar a completar tareas.</strong>
Aquí es donde entran los componentes de LlamaIndex.`,Ie,w,ka="Aunque LlamaIndex tiene muchos componentes, <strong>nos centraremos específicamente en el componente <code>QueryEngine</code></strong>. ¿Por qué? Porque se puede usar como una herramienta de Generación Aumentada por Recuperación (RAG) para un agente.",Ve,C,Ya=`Entonces, ¿qué es RAG? Los LLMs están entrenados en enormes cuerpos de datos para aprender conocimiento general. Sin embargo, pueden no estar entrenados en datos relevantes y actualizados.
RAG resuelve este problema encontrando y recuperando información relevante de tus datos y dándosela al LLM.`,$e,G,Na='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/llama-index/rag.png" alt="RAG"/>',Xe,W,Qa="Ahora, piensa en como funciona Alfred:",Be,_,Pa="<li>Le pides a Alfred que te ayude a planear una cena</li> <li>Alfred necesita revisar tu calendario, preferencias dietéticas y menús exitosos anteriores</li> <li>El <code>QueryEngine</code> ayuda a Alfred a encontrar esta información y usarla para planear la cena</li>",Re,E,za=`Esto hace que el <code>QueryEngine</code> <strong>sea un componente clave para construir flujos de trabajo RAG agentic</strong> en LlamaIndex.
Así como Alfred necesita buscar en la información de tu hogar para ser útil, cualquier agente necesita una forma de encontrar y entender datos relevantes.
El <code>QueryEngine</code> proporciona exactamente esta capacidad.`,Se,I,Fa="Ahora, profundicemos un poco más en los componentes y veamos como puedes <strong>combinar componentes para crear un pipeline RAG.</strong>",He,V,Ae,g,Ka='<p>Puedes seguir el código en <a href="https://huggingface.co/agents-course/notebooks/blob/main/unit2/llama-index/components.ipynb" target="_blank">este notebook</a> que puedes ejecutar usando Google Colab.</p>',qe,$,Da="Hay cinco etapas clave dentro de RAG, que a su vez serán parte de la mayoría de las aplicaciones más grandes que construyas. Estas son:",ke,X,Oa="<li><strong>Carga</strong>: esto se refiere a obtener tus datos desde donde residen — ya sean archivos de texto, PDFs, otro sitio web, una base de datos o una API — e incorporarlos a tu flujo de trabajo. LlamaHub proporciona cientos de integraciones para elegir.</li> <li><strong>Indexación</strong>: significa crear una estructura de datos que permita consultar la información. Para los LLMs, esto casi siempre significa crear embeddings vectoriales, que son representaciones numéricas del significado de los datos. La indexación también puede referirse a numerosas estrategias de metadatos para facilitar la búsqueda precisa de datos contextualmente relevantes basados en propiedades.</li> <li><strong>Almacenamiento</strong>: una vez que tus datos están indexados, querrás almacenar tu índice, así como otros metadatos, para evitar tener que volver a indexarlos.</li> <li><strong>Consulta</strong>: para cualquier estrategia de indexación hay muchas formas en que puedes utilizar LLMs y estructuras de datos de LlamaIndex para consultar, incluyendo subconsultas, consultas de múltiples pasos y estrategias híbridas.</li> <li><strong>Evaluación</strong>: un paso crítico en cualquier flujo es comprobar qué tan efectivo es en relación con otras estrategias, o cuando realizas cambios. La evaluación proporciona medidas objetivas de cuán precisas, fieles y rápidas son tus respuestas a las consultas.</li>",Ye,B,et="A continuación, veamos cómo podemos reproducir estas etapas usando componentes.",Ne,R,Qe,S,at=`Como se mencionó anteriormente, LlamaIndex puede trabajar sobre tus propios datos, sin embargo, <strong>antes de acceder a los datos, necesitamos cargarlos.</strong>
Hay tres formas principales de cargar datos en LlamaIndex:`,Pe,H,tt="<li><code>SimpleDirectoryReader</code>: Un cargador integrado para varios tipos de archivos desde un directorio local.</li> <li><code>LlamaParse</code>: LlamaParse, la herramienta oficial de LlamaIndex para el análisis de PDFs, disponible como API gestionada.</li> <li><code>LlamaHub</code>: Un registro de cientos de bibliotecas de carga de datos para ingerir datos desde cualquier fuente.</li>",ze,h,lt='<p>Familiarízate con los cargadores de <a href="https://docs.llamaindex.ai/en/stable/module_guides/loading/connector/">LlamaHub</a> y el analizador <a href="https://github.com/run-llama/llama_cloud_services/blob/main/parse.md">LlamaParse</a> para fuentes de datos más complejas.</p>',Fe,A,nt=`<strong>La forma más sencilla de cargar datos es con <code>SimpleDirectoryReader</code>.</strong>
Este componente versátil puede cargar varios tipos de archivos desde una carpeta y convertirlos en objetos <code>Document</code> con los que LlamaIndex puede trabajar.
Veamos cómo podemos usar <code>SimpleDirectoryReader</code> para cargar datos desde una carpeta.`,Ke,q,De,k,st=`Después de cargar nuestros documentos, necesitamos dividirlos en piezas más pequeñas llamadas objetos <code>Node</code>.
Un <code>Node</code> es simplemente un fragmento de texto del documento original que es más fácil de manejar para la IA, mientras que mantiene referencias al objeto <code>Document</code> original.`,Oe,Y,ot="El <code>IngestionPipeline</code> nos ayuda a crear estos nodos a través de dos transformaciones clave.",ea,N,it="<li><code>SentenceSplitter</code> descompone los documentos en fragmentos manejables dividiéndolos en los límites naturales de las oraciones.</li> <li><code>HuggingFaceInferenceAPIEmbedding</code> convierte cada fragmento en embeddings numéricos - representaciones vectoriales que capturan el significado semántico de una manera que la IA puede procesar eficientemente.</li>",aa,Q,rt="Este proceso nos ayuda a organizar nuestros documentos de una manera que es más útil para la búsqueda y el análisis.",ta,P,la,z,na,F,dt="Después de crear nuestros objetos <code>Node</code>, necesitamos indexarlos para hacerlos buscables, pero antes de poder hacerlo, necesitamos un lugar para almacenar nuestros datos.",sa,K,ct=`Como estamos usando un pipeline de ingesta, podemos adjuntar directamente un almacén vectorial al pipeline para poblarlo.
En este caso, usaremos <code>Chroma</code> para almacenar nuestros documentos.`,oa,T,Je,mt="Instalar ChromaDB",Ba,D,ia,O,ra,j,ut='<p>Una visión general de los diferentes almacenes vectoriales se puede encontrar en la <a href="https://docs.llamaindex.ai/en/stable/module_guides/storing/vector_stores/">documentación de LlamaIndex</a>.</p>',da,ee,pt=`Aquí es donde entran los embeddings vectoriales - al incorporar tanto la consulta como los nodos en el mismo espacio vectorial, podemos encontrar coincidencias relevantes.
El <code>VectorStoreIndex</code> se encarga de esto por nosotros, utilizando el mismo modelo de embedding que usamos durante la ingesta para garantizar la consistencia.`,ca,ae,bt="Veamos cómo crear este índice a partir de nuestro almacén vectorial y embeddings:",ma,te,ua,le,Mt="Toda la información se persiste automáticamente dentro del objeto <code>ChromaVectorStore</code> y la ruta del directorio proporcionado.",pa,ne,yt="¡Genial! Ahora que podemos guardar y cargar nuestro índice fácilmente, exploremos cómo consultarlo de diferentes maneras.",ba,se,Ma,oe,ft="Antes de poder consultar nuestro índice, necesitamos convertirlo a una interfaz de consulta. Las opciones de conversión más comunes son:",ya,ie,vt="<li><code>as_retriever</code>: Para recuperación básica de documentos, devolviendo una lista de objetos <code>NodeWithScore</code> con puntuaciones de similitud</li> <li><code>as_query_engine</code>: Para interacciones de pregunta-respuesta simples, devolviendo una respuesta escrita</li> <li><code>as_chat_engine</code>: Para interacciones conversacionales que mantienen la memoria a través de múltiples mensajes, devolviendo una respuesta escrita utilizando el historial de chat y el contexto indexado</li>",fa,re,gt=`Nos centraremos en el motor de consulta ya que es más común para interacciones tipo agente.
También pasamos un LLM al motor de consulta para usarlo en la respuesta.`,va,de,ga,ce,ha,me,ht=`Bajo el capó, el motor de consulta no solo usa el LLM para responder a la pregunta, sino que también utiliza un <code>ResponseSynthesizer</code> como estrategia para procesar la respuesta.
Una vez más, esto es completamente personalizable, pero hay tres estrategias principales que funcionan bien de forma predeterminada:`,Ta,ue,Tt="<li><code>refine</code>: crear y refinar una respuesta recorriendo secuencialmente cada fragmento de texto recuperado. Esto hace una llamada LLM separada por cada Node/fragmento recuperado.</li> <li><code>compact</code> (predeterminado): similar a refinar pero concatenando los fragmentos de antemano, resultando en menos llamadas LLM.</li> <li><code>tree_summarize</code>: crear una respuesta detallada recorriendo cada fragmento de texto recuperado y creando una estructura de árbol de la respuesta.</li>",ja,U,jt='<p>Toma control detallado de tus flujos de consulta con la <a href="https://docs.llamaindex.ai/en/stable/module_guides/deploying/query_engine/usage_pattern/#low-level-composition-api">API de composición de bajo nivel</a>. Esta API te permite personalizar y ajustar cada paso del proceso de consulta para que coincida con tus necesidades exactas, lo que también se combina muy bien con <a href="https://docs.llamaindex.ai/en/stable/module_guides/workflow/">Flujos de trabajo</a></p>',Ua,pe,Ut="El modelo de lenguaje no siempre funcionará de manera predecible, por lo que no podemos estar seguros de que la respuesta que obtenemos sea siempre correcta. Podemos lidiar con esto <strong>evaluando la calidad de la respuesta</strong>.",xa,be,Ja,Me,xt=`LlamaIndex proporciona <strong>herramientas de evaluación integradas para evaluar la calidad de la respuesta.</strong>
Estos evaluadores aprovechan los LLMs para analizar respuestas a través de diferentes dimensiones.
Veamos los tres evaluadores principales disponibles:`,Za,ye,Jt="<li><code>FaithfulnessEvaluator</code>: Evalúa la fidelidad de la respuesta comprobando si está respaldada por el contexto.</li> <li><code>AnswerRelevancyEvaluator</code>: Evalúa la relevancia de la respuesta comprobando si es relevante para la pregunta.</li> <li><code>CorrectnessEvaluator</code>: Evalúa la corrección de la respuesta comprobando si es correcta.</li>",La,fe,wa,ve,Zt=`Incluso sin evaluación directa, podemos <strong>obtener información sobre cómo está funcionando nuestro sistema a través de la observabilidad.</strong>
Esto es especialmente útil cuando estamos construyendo flujos de trabajo más complejos y queremos entender cómo está funcionando cada componente.`,Ca,M,Ze,Lt="Instalar LlamaTrace",Ra,ge,Sa,Le,wt="Además, necesitamos establecer la variable de entorno <code>PHOENIX_API_KEY</code> con nuestra clave API de LlamaTrace. Podemos obtenerla:",Ha,we,Ct='<li>Creando una cuenta en <a href="https://llamatrace.com/login" rel="nofollow">LlamaTrace</a></li> <li>Generando una clave API en la configuración de tu cuenta</li> <li>Usando la clave API en el código siguiente para habilitar el seguimiento</li>',Ga,he,Wa,x,Gt='<p>¿Quieres aprender más sobre los componentes y cómo usarlos? Continúa tu viaje con las <a href="https://docs.llamaindex.ai/en/stable/module_guides/">Guías de Componentes</a> o la <a href="https://docs.llamaindex.ai/en/stable/understanding/rag/">Guía sobre RAG</a>.</p>',_a,Te,Wt="Hemos visto cómo usar componentes para crear un <code>QueryEngine</code>. Ahora, ¡veamos cómo <strong>usar el <code>QueryEngine</code> como una herramienta para un agente!</strong>",Ea,je,Ia,Ge,Va;return Z=new xe({props:{title:"¿Qué son los componentes en LlamaIndex?",local:"qué-son-los-componentes-en-llamaindex",headingTag:"h1"}}),V=new xe({props:{title:"Creando un pipeline RAG usando componentes",local:"creando-un-pipeline-rag-usando-componentes",headingTag:"h2"}}),R=new xe({props:{title:"Carga y embedding de documentos",local:"carga-y-embedding-de-documentos",headingTag:"h3"}}),q=new v({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUlMjBpbXBvcnQlMjBTaW1wbGVEaXJlY3RvcnlSZWFkZXIlMEElMEFyZWFkZXIlMjAlM0QlMjBTaW1wbGVEaXJlY3RvcnlSZWFkZXIoaW5wdXRfZGlyJTNEJTIycGF0aCUyRnRvJTJGZGlyZWN0b3J5JTIyKSUwQWRvY3VtZW50cyUyMCUzRCUyMHJlYWRlci5sb2FkX2RhdGEoKQ==",highlighted:`<span class="hljs-keyword">from</span> llama_index.core <span class="hljs-keyword">import</span> SimpleDirectoryReader

reader = SimpleDirectoryReader(input_dir=<span class="hljs-string">&quot;path/to/directory&quot;</span>)
documents = reader.load_data()`,wrap:!1}}),P=new v({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUlMjBpbXBvcnQlMjBEb2N1bWVudCUwQWZyb20lMjBsbGFtYV9pbmRleC5lbWJlZGRpbmdzLmh1Z2dpbmdmYWNlX2FwaSUyMGltcG9ydCUyMEh1Z2dpbmdGYWNlSW5mZXJlbmNlQVBJRW1iZWRkaW5nJTBBZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUubm9kZV9wYXJzZXIlMjBpbXBvcnQlMjBTZW50ZW5jZVNwbGl0dGVyJTBBZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUuaW5nZXN0aW9uJTIwaW1wb3J0JTIwSW5nZXN0aW9uUGlwZWxpbmUlMEElMEElMjMlMjBjcmVhciUyMGVsJTIwcGlwZWxpbmUlMjBjb24lMjB0cmFuc2Zvcm1hY2lvbmVzJTBBcGlwZWxpbmUlMjAlM0QlMjBJbmdlc3Rpb25QaXBlbGluZSglMEElMjAlMjAlMjAlMjB0cmFuc2Zvcm1hdGlvbnMlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBTZW50ZW5jZVNwbGl0dGVyKGNodW5rX292ZXJsYXAlM0QwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEh1Z2dpbmdGYWNlSW5mZXJlbmNlQVBJRW1iZWRkaW5nKG1vZGVsX25hbWUlM0QlMjJCQUFJJTJGYmdlLXNtYWxsLWVuLXYxLjUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTBBKSUwQSUwQW5vZGVzJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZS5hcnVuKGRvY3VtZW50cyUzRCU1QkRvY3VtZW50LmV4YW1wbGUoKSU1RCk=",highlighted:`<span class="hljs-keyword">from</span> llama_index.core <span class="hljs-keyword">import</span> Document
<span class="hljs-keyword">from</span> llama_index.embeddings.huggingface_api <span class="hljs-keyword">import</span> HuggingFaceInferenceAPIEmbedding
<span class="hljs-keyword">from</span> llama_index.core.node_parser <span class="hljs-keyword">import</span> SentenceSplitter
<span class="hljs-keyword">from</span> llama_index.core.ingestion <span class="hljs-keyword">import</span> IngestionPipeline

<span class="hljs-comment"># crear el pipeline con transformaciones</span>
pipeline = IngestionPipeline(
    transformations=[
        SentenceSplitter(chunk_overlap=<span class="hljs-number">0</span>),
        HuggingFaceInferenceAPIEmbedding(model_name=<span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>),
    ]
)

nodes = <span class="hljs-keyword">await</span> pipeline.arun(documents=[Document.example()])`,wrap:!1}}),z=new xe({props:{title:"Almacenamiento e indexación de documentos",local:"almacenamiento-e-indexación-de-documentos",headingTag:"h3"}}),D=new v({props:{code:"cGlwJTIwaW5zdGFsbCUyMGxsYW1hLWluZGV4LXZlY3Rvci1zdG9yZXMtY2hyb21h",highlighted:"pip install llama-index-vector-stores-chroma",wrap:!1}}),O=new v({props:{code:"aW1wb3J0JTIwY2hyb21hZGIlMEFmcm9tJTIwbGxhbWFfaW5kZXgudmVjdG9yX3N0b3Jlcy5jaHJvbWElMjBpbXBvcnQlMjBDaHJvbWFWZWN0b3JTdG9yZSUwQSUwQWRiJTIwJTNEJTIwY2hyb21hZGIuUGVyc2lzdGVudENsaWVudChwYXRoJTNEJTIyLiUyRmFsZnJlZF9jaHJvbWFfZGIlMjIpJTBBY2hyb21hX2NvbGxlY3Rpb24lMjAlM0QlMjBkYi5nZXRfb3JfY3JlYXRlX2NvbGxlY3Rpb24oJTIyYWxmcmVkJTIyKSUwQXZlY3Rvcl9zdG9yZSUyMCUzRCUyMENocm9tYVZlY3RvclN0b3JlKGNocm9tYV9jb2xsZWN0aW9uJTNEY2hyb21hX2NvbGxlY3Rpb24pJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBJbmdlc3Rpb25QaXBlbGluZSglMEElMjAlMjAlMjAlMjB0cmFuc2Zvcm1hdGlvbnMlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBTZW50ZW5jZVNwbGl0dGVyKGNodW5rX3NpemUlM0QyNSUyQyUyMGNodW5rX292ZXJsYXAlM0QwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEh1Z2dpbmdGYWNlSW5mZXJlbmNlQVBJRW1iZWRkaW5nKG1vZGVsX25hbWUlM0QlMjJCQUFJJTJGYmdlLXNtYWxsLWVuLXYxLjUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwdmVjdG9yX3N0b3JlJTNEdmVjdG9yX3N0b3JlJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> chromadb
<span class="hljs-keyword">from</span> llama_index.vector_stores.chroma <span class="hljs-keyword">import</span> ChromaVectorStore

db = chromadb.PersistentClient(path=<span class="hljs-string">&quot;./alfred_chroma_db&quot;</span>)
chroma_collection = db.get_or_create_collection(<span class="hljs-string">&quot;alfred&quot;</span>)
vector_store = ChromaVectorStore(chroma_collection=chroma_collection)

pipeline = IngestionPipeline(
    transformations=[
        SentenceSplitter(chunk_size=<span class="hljs-number">25</span>, chunk_overlap=<span class="hljs-number">0</span>),
        HuggingFaceInferenceAPIEmbedding(model_name=<span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>),
    ],
    vector_store=vector_store,
)`,wrap:!1}}),te=new v({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUlMjBpbXBvcnQlMjBWZWN0b3JTdG9yZUluZGV4JTBBZnJvbSUyMGxsYW1hX2luZGV4LmVtYmVkZGluZ3MuaHVnZ2luZ2ZhY2VfYXBpJTIwaW1wb3J0JTIwSHVnZ2luZ0ZhY2VJbmZlcmVuY2VBUElFbWJlZGRpbmclMEElMEFlbWJlZF9tb2RlbCUyMCUzRCUyMEh1Z2dpbmdGYWNlSW5mZXJlbmNlQVBJRW1iZWRkaW5nKG1vZGVsX25hbWUlM0QlMjJCQUFJJTJGYmdlLXNtYWxsLWVuLXYxLjUlMjIpJTBBaW5kZXglMjAlM0QlMjBWZWN0b3JTdG9yZUluZGV4LmZyb21fdmVjdG9yX3N0b3JlKHZlY3Rvcl9zdG9yZSUyQyUyMGVtYmVkX21vZGVsJTNEZW1iZWRfbW9kZWwp",highlighted:`<span class="hljs-keyword">from</span> llama_index.core <span class="hljs-keyword">import</span> VectorStoreIndex
<span class="hljs-keyword">from</span> llama_index.embeddings.huggingface_api <span class="hljs-keyword">import</span> HuggingFaceInferenceAPIEmbedding

embed_model = HuggingFaceInferenceAPIEmbedding(model_name=<span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>)
index = VectorStoreIndex.from_vector_store(vector_store, embed_model=embed_model)`,wrap:!1}}),se=new xe({props:{title:"Consultando un VectorStoreIndex con prompts y LLMs",local:"consultando-un-vectorstoreindex-con-prompts-y-llms",headingTag:"h3"}}),de=new v({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmxsbXMuaHVnZ2luZ2ZhY2VfYXBpJTIwaW1wb3J0JTIwSHVnZ2luZ0ZhY2VJbmZlcmVuY2VBUEklMEElMEFsbG0lMjAlM0QlMjBIdWdnaW5nRmFjZUluZmVyZW5jZUFQSShtb2RlbF9uYW1lJTNEJTIyUXdlbiUyRlF3ZW4yLjUtQ29kZXItMzJCLUluc3RydWN0JTIyKSUwQXF1ZXJ5X2VuZ2luZSUyMCUzRCUyMGluZGV4LmFzX3F1ZXJ5X2VuZ2luZSglMEElMjAlMjAlMjAlMjBsbG0lM0RsbG0lMkMlMEElMjAlMjAlMjAlMjByZXNwb25zZV9tb2RlJTNEJTIydHJlZV9zdW1tYXJpemUlMjIlMkMlMEEpJTBBcXVlcnlfZW5naW5lLnF1ZXJ5KCUyMiVDMiVCRkN1JUMzJUExbCUyMGVzJTIwZWwlMjBzaWduaWZpY2FkbyUyMGRlJTIwbGElMjB2aWRhJTNGJTIyKSUwQSUyMyUyMEVsJTIwc2lnbmlmaWNhZG8lMjBkZSUyMGxhJTIwdmlkYSUyMGVzJTIwNDI=",highlighted:`<span class="hljs-keyword">from</span> llama_index.llms.huggingface_api <span class="hljs-keyword">import</span> HuggingFaceInferenceAPI

llm = HuggingFaceInferenceAPI(model_name=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)
query_engine = index.as_query_engine(
    llm=llm,
    response_mode=<span class="hljs-string">&quot;tree_summarize&quot;</span>,
)
query_engine.query(<span class="hljs-string">&quot;¿Cuál es el significado de la vida?&quot;</span>)
<span class="hljs-comment"># El significado de la vida es 42</span>`,wrap:!1}}),ce=new xe({props:{title:"Procesamiento de Respuestas",local:"procesamiento-de-respuestas",headingTag:"h3"}}),be=new xe({props:{title:"Evaluación y observabilidad",local:"evaluación-y-observabilidad",headingTag:"h3"}}),fe=new v({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUuZXZhbHVhdGlvbiUyMGltcG9ydCUyMEZhaXRoZnVsbmVzc0V2YWx1YXRvciUwQSUwQXF1ZXJ5X2VuZ2luZSUyMCUzRCUyMCUyMyUyMGRlJTIwbGElMjBzZWNjaSVDMyVCM24lMjBhbnRlcmlvciUwQWxsbSUyMCUzRCUyMCUyMyUyMGRlJTIwbGElMjBzZWNjaSVDMyVCM24lMjBhbnRlcmlvciUwQSUwQSUyMyUyMGNvbnN1bHRhciUyMCVDMyVBRG5kaWNlJTBBZXZhbHVhdG9yJTIwJTNEJTIwRmFpdGhmdWxuZXNzRXZhbHVhdG9yKGxsbSUzRGxsbSklMEFyZXNwb25zZSUyMCUzRCUyMHF1ZXJ5X2VuZ2luZS5xdWVyeSglMEElMjAlMjAlMjAlMjAlMjIlQzIlQkZRdSVDMyVBOSUyMGJhdGFsbGFzJTIwdHV2aWVyb24lMjBsdWdhciUyMGVuJTIwbGElMjBjaXVkYWQlMjBkZSUyME51ZXZhJTIwWW9yayUyMGR1cmFudGUlMjBsYSUyMFJldm9sdWNpJUMzJUIzbiUyMEFtZXJpY2FuYSUzRiUyMiUwQSklMEFldmFsX3Jlc3VsdCUyMCUzRCUyMGV2YWx1YXRvci5ldmFsdWF0ZV9yZXNwb25zZShyZXNwb25zZSUzRHJlc3BvbnNlKSUwQWV2YWxfcmVzdWx0LnBhc3Npbmc=",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.evaluation <span class="hljs-keyword">import</span> FaithfulnessEvaluator

query_engine = <span class="hljs-comment"># de la sección anterior</span>
llm = <span class="hljs-comment"># de la sección anterior</span>

<span class="hljs-comment"># consultar índice</span>
evaluator = FaithfulnessEvaluator(llm=llm)
response = query_engine.query(
    <span class="hljs-string">&quot;¿Qué batallas tuvieron lugar en la ciudad de Nueva York durante la Revolución Americana?&quot;</span>
)
eval_result = evaluator.evaluate_response(response=response)
eval_result.passing`,wrap:!1}}),ge=new v({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwbGxhbWEtaW5kZXgtY2FsbGJhY2tzLWFyaXplLXBob2VuaXg=",highlighted:"pip install -U llama-index-callbacks-arize-phoenix",wrap:!1}}),he=new v({props:{code:"aW1wb3J0JTIwbGxhbWFfaW5kZXglMEFpbXBvcnQlMjBvcyUwQSUwQVBIT0VOSVhfQVBJX0tFWSUyMCUzRCUyMCUyMiUzQ1BIT0VOSVhfQVBJX0tFWSUzRSUyMiUwQW9zLmVudmlyb24lNUIlMjJPVEVMX0VYUE9SVEVSX09UTFBfSEVBREVSUyUyMiU1RCUyMCUzRCUyMGYlMjJhcGlfa2V5JTNEJTdCUEhPRU5JWF9BUElfS0VZJTdEJTIyJTBBbGxhbWFfaW5kZXguY29yZS5zZXRfZ2xvYmFsX2hhbmRsZXIoJTBBJTIwJTIwJTIwJTIwJTIyYXJpemVfcGhvZW5peCUyMiUyQyUwQSUyMCUyMCUyMCUyMGVuZHBvaW50JTNEJTIyaHR0cHMlM0ElMkYlMkZsbGFtYXRyYWNlLmNvbSUyRnYxJTJGdHJhY2VzJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> llama_index
<span class="hljs-keyword">import</span> os

PHOENIX_API_KEY = <span class="hljs-string">&quot;&lt;PHOENIX_API_KEY&gt;&quot;</span>
os.environ[<span class="hljs-string">&quot;OTEL_EXPORTER_OTLP_HEADERS&quot;</span>] = <span class="hljs-string">f&quot;api_key=<span class="hljs-subst">{PHOENIX_API_KEY}</span>&quot;</span>
llama_index.core.set_global_handler(
    <span class="hljs-string">&quot;arize_phoenix&quot;</span>,
    endpoint=<span class="hljs-string">&quot;https://llamatrace.com/v1/traces&quot;</span>
)`,wrap:!1}}),je=new St({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/es/unit2/llama-index/components.mdx"}}),{c(){y=o("meta"),We=n(),Ce=o("p"),_e=n(),d(Z.$$.fragment),Ee=n(),L=o("p"),L.innerHTML=qa,Ie=n(),w=o("p"),w.innerHTML=ka,Ve=n(),C=o("p"),C.textContent=Ya,$e=n(),G=o("p"),G.innerHTML=Na,Xe=n(),W=o("p"),W.textContent=Qa,Be=n(),_=o("ol"),_.innerHTML=Pa,Re=n(),E=o("p"),E.innerHTML=za,Se=n(),I=o("p"),I.innerHTML=Fa,He=n(),d(V.$$.fragment),Ae=n(),g=o("blockquote"),g.innerHTML=Ka,qe=n(),$=o("p"),$.textContent=Da,ke=n(),X=o("ol"),X.innerHTML=Oa,Ye=n(),B=o("p"),B.textContent=et,Ne=n(),d(R.$$.fragment),Qe=n(),S=o("p"),S.innerHTML=at,Pe=n(),H=o("ol"),H.innerHTML=tt,ze=n(),h=o("blockquote"),h.innerHTML=lt,Fe=n(),A=o("p"),A.innerHTML=nt,Ke=n(),d(q.$$.fragment),De=n(),k=o("p"),k.innerHTML=st,Oe=n(),Y=o("p"),Y.innerHTML=ot,ea=n(),N=o("ol"),N.innerHTML=it,aa=n(),Q=o("p"),Q.textContent=rt,ta=n(),d(P.$$.fragment),la=n(),d(z.$$.fragment),na=n(),F=o("p"),F.innerHTML=dt,sa=n(),K=o("p"),K.innerHTML=ct,oa=n(),T=o("details"),Je=o("summary"),Je.textContent=mt,Ba=_t(`
Como se introdujo en la [sección sobre LlamaHub](llama-hub), podemos instalar el almacén vectorial ChromaDB con el siguiente comando:

	`),d(D.$$.fragment),ia=n(),d(O.$$.fragment),ra=n(),j=o("blockquote"),j.innerHTML=ut,da=n(),ee=o("p"),ee.innerHTML=pt,ca=n(),ae=o("p"),ae.textContent=bt,ma=n(),d(te.$$.fragment),ua=n(),le=o("p"),le.innerHTML=Mt,pa=n(),ne=o("p"),ne.textContent=yt,ba=n(),d(se.$$.fragment),Ma=n(),oe=o("p"),oe.textContent=ft,ya=n(),ie=o("ul"),ie.innerHTML=vt,fa=n(),re=o("p"),re.textContent=gt,va=n(),d(de.$$.fragment),ga=n(),d(ce.$$.fragment),ha=n(),me=o("p"),me.innerHTML=ht,Ta=n(),ue=o("ul"),ue.innerHTML=Tt,ja=n(),U=o("blockquote"),U.innerHTML=jt,Ua=n(),pe=o("p"),pe.innerHTML=Ut,xa=n(),d(be.$$.fragment),Ja=n(),Me=o("p"),Me.innerHTML=xt,Za=n(),ye=o("ul"),ye.innerHTML=Jt,La=n(),d(fe.$$.fragment),wa=n(),ve=o("p"),ve.innerHTML=Zt,Ca=n(),M=o("details"),Ze=o("summary"),Ze.textContent=Lt,Ra=_t(`
Como se introdujo en la [sección sobre LlamaHub](llama-hub), podemos instalar el callback LlamaTrace de Arize Phoenix con el siguiente comando:

	`),d(ge.$$.fragment),Sa=n(),Le=o("p"),Le.innerHTML=wt,Ha=n(),we=o("ul"),we.innerHTML=Ct,Ga=n(),d(he.$$.fragment),Wa=n(),x=o("blockquote"),x.innerHTML=Gt,_a=n(),Te=o("p"),Te.innerHTML=Wt,Ea=n(),d(je.$$.fragment),Ia=n(),Ge=o("p"),this.h()},l(e){const a=Rt("svelte-u9bgzb",document.head);y=i(a,"META",{name:!0,content:!0}),a.forEach(t),We=s(e),Ce=i(e,"P",{}),Xa(Ce).forEach(t),_e=s(e),c(Z.$$.fragment,e),Ee=s(e),L=i(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-pm99e2"&&(L.innerHTML=qa),Ie=s(e),w=i(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-13gpelo"&&(w.innerHTML=ka),Ve=s(e),C=i(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-19mpk4z"&&(C.textContent=Ya),$e=s(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-kysd50"&&(G.innerHTML=Na),Xe=s(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1xsxtoj"&&(W.textContent=Qa),Be=s(e),_=i(e,"OL",{"data-svelte-h":!0}),r(_)!=="svelte-1mjeq7y"&&(_.innerHTML=Pa),Re=s(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-suuz1p"&&(E.innerHTML=za),Se=s(e),I=i(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-11egg01"&&(I.innerHTML=Fa),He=s(e),c(V.$$.fragment,e),Ae=s(e),g=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(g)!=="svelte-baqnu3"&&(g.innerHTML=Ka),qe=s(e),$=i(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1jzhuw7"&&($.textContent=Da),ke=s(e),X=i(e,"OL",{"data-svelte-h":!0}),r(X)!=="svelte-42twja"&&(X.innerHTML=Oa),Ye=s(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1q05m75"&&(B.textContent=et),Ne=s(e),c(R.$$.fragment,e),Qe=s(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-ltse76"&&(S.innerHTML=at),Pe=s(e),H=i(e,"OL",{"data-svelte-h":!0}),r(H)!=="svelte-hgvwyx"&&(H.innerHTML=tt),ze=s(e),h=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(h)!=="svelte-ohpmeu"&&(h.innerHTML=lt),Fe=s(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-g44q18"&&(A.innerHTML=nt),Ke=s(e),c(q.$$.fragment,e),De=s(e),k=i(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1dr39ef"&&(k.innerHTML=st),Oe=s(e),Y=i(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1sz6pbb"&&(Y.innerHTML=ot),ea=s(e),N=i(e,"OL",{"data-svelte-h":!0}),r(N)!=="svelte-s3d25b"&&(N.innerHTML=it),aa=s(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-6evtuq"&&(Q.textContent=rt),ta=s(e),c(P.$$.fragment,e),la=s(e),c(z.$$.fragment,e),na=s(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-jayxlx"&&(F.innerHTML=dt),sa=s(e),K=i(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1n0ff7"&&(K.innerHTML=ct),oa=s(e),T=i(e,"DETAILS",{});var $a=Xa(T);Je=i($a,"SUMMARY",{"data-svelte-h":!0}),r(Je)!=="svelte-1j6ze5i"&&(Je.textContent=mt),Ba=Et($a,`
Como se introdujo en la [sección sobre LlamaHub](llama-hub), podemos instalar el almacén vectorial ChromaDB con el siguiente comando:

	`),c(D.$$.fragment,$a),$a.forEach(t),ia=s(e),c(O.$$.fragment,e),ra=s(e),j=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(j)!=="svelte-12qoguh"&&(j.innerHTML=ut),da=s(e),ee=i(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1udl3w2"&&(ee.innerHTML=pt),ca=s(e),ae=i(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-dk0wjq"&&(ae.textContent=bt),ma=s(e),c(te.$$.fragment,e),ua=s(e),le=i(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-k2u2nl"&&(le.innerHTML=Mt),pa=s(e),ne=i(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1vfh4sr"&&(ne.textContent=yt),ba=s(e),c(se.$$.fragment,e),Ma=s(e),oe=i(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-19hd66j"&&(oe.textContent=ft),ya=s(e),ie=i(e,"UL",{"data-svelte-h":!0}),r(ie)!=="svelte-10edu3t"&&(ie.innerHTML=vt),fa=s(e),re=i(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1f9ozoe"&&(re.textContent=gt),va=s(e),c(de.$$.fragment,e),ga=s(e),c(ce.$$.fragment,e),ha=s(e),me=i(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1w6g8k2"&&(me.innerHTML=ht),Ta=s(e),ue=i(e,"UL",{"data-svelte-h":!0}),r(ue)!=="svelte-1m28xcd"&&(ue.innerHTML=Tt),ja=s(e),U=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(U)!=="svelte-s19g0w"&&(U.innerHTML=jt),Ua=s(e),pe=i(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-1bsvcjs"&&(pe.innerHTML=Ut),xa=s(e),c(be.$$.fragment,e),Ja=s(e),Me=i(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-13q421x"&&(Me.innerHTML=xt),Za=s(e),ye=i(e,"UL",{"data-svelte-h":!0}),r(ye)!=="svelte-1latvry"&&(ye.innerHTML=Jt),La=s(e),c(fe.$$.fragment,e),wa=s(e),ve=i(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-ktqj9w"&&(ve.innerHTML=Zt),Ca=s(e),M=i(e,"DETAILS",{});var J=Xa(M);Ze=i(J,"SUMMARY",{"data-svelte-h":!0}),r(Ze)!=="svelte-1590nuk"&&(Ze.textContent=Lt),Ra=Et(J,`
Como se introdujo en la [sección sobre LlamaHub](llama-hub), podemos instalar el callback LlamaTrace de Arize Phoenix con el siguiente comando:

	`),c(ge.$$.fragment,J),Sa=s(J),Le=i(J,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-1of2p3f"&&(Le.innerHTML=wt),Ha=s(J),we=i(J,"UL",{"data-svelte-h":!0}),r(we)!=="svelte-1s72lw8"&&(we.innerHTML=Ct),J.forEach(t),Ga=s(e),c(he.$$.fragment,e),Wa=s(e),x=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(x)!=="svelte-1vq8zru"&&(x.innerHTML=Gt),_a=s(e),Te=i(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1ylul7b"&&(Te.innerHTML=Wt),Ea=s(e),c(je.$$.fragment,e),Ia=s(e),Ge=i(e,"P",{}),Xa(Ge).forEach(t),this.h()},h(){Ue(y,"name","hf:doc:metadata"),Ue(y,"content",At),Ue(g,"class","tip"),Ue(h,"class","tip"),Ue(j,"class","tip"),Ue(U,"class","tip"),Ue(x,"class","tip")},m(e,a){f(document.head,y),l(e,We,a),l(e,Ce,a),l(e,_e,a),m(Z,e,a),l(e,Ee,a),l(e,L,a),l(e,Ie,a),l(e,w,a),l(e,Ve,a),l(e,C,a),l(e,$e,a),l(e,G,a),l(e,Xe,a),l(e,W,a),l(e,Be,a),l(e,_,a),l(e,Re,a),l(e,E,a),l(e,Se,a),l(e,I,a),l(e,He,a),m(V,e,a),l(e,Ae,a),l(e,g,a),l(e,qe,a),l(e,$,a),l(e,ke,a),l(e,X,a),l(e,Ye,a),l(e,B,a),l(e,Ne,a),m(R,e,a),l(e,Qe,a),l(e,S,a),l(e,Pe,a),l(e,H,a),l(e,ze,a),l(e,h,a),l(e,Fe,a),l(e,A,a),l(e,Ke,a),m(q,e,a),l(e,De,a),l(e,k,a),l(e,Oe,a),l(e,Y,a),l(e,ea,a),l(e,N,a),l(e,aa,a),l(e,Q,a),l(e,ta,a),m(P,e,a),l(e,la,a),m(z,e,a),l(e,na,a),l(e,F,a),l(e,sa,a),l(e,K,a),l(e,oa,a),l(e,T,a),f(T,Je),f(T,Ba),m(D,T,null),l(e,ia,a),m(O,e,a),l(e,ra,a),l(e,j,a),l(e,da,a),l(e,ee,a),l(e,ca,a),l(e,ae,a),l(e,ma,a),m(te,e,a),l(e,ua,a),l(e,le,a),l(e,pa,a),l(e,ne,a),l(e,ba,a),m(se,e,a),l(e,Ma,a),l(e,oe,a),l(e,ya,a),l(e,ie,a),l(e,fa,a),l(e,re,a),l(e,va,a),m(de,e,a),l(e,ga,a),m(ce,e,a),l(e,ha,a),l(e,me,a),l(e,Ta,a),l(e,ue,a),l(e,ja,a),l(e,U,a),l(e,Ua,a),l(e,pe,a),l(e,xa,a),m(be,e,a),l(e,Ja,a),l(e,Me,a),l(e,Za,a),l(e,ye,a),l(e,La,a),m(fe,e,a),l(e,wa,a),l(e,ve,a),l(e,Ca,a),l(e,M,a),f(M,Ze),f(M,Ra),m(ge,M,null),f(M,Sa),f(M,Le),f(M,Ha),f(M,we),l(e,Ga,a),m(he,e,a),l(e,Wa,a),l(e,x,a),l(e,_a,a),l(e,Te,a),l(e,Ea,a),m(je,e,a),l(e,Ia,a),l(e,Ge,a),Va=!0},p:Vt,i(e){Va||(u(Z.$$.fragment,e),u(V.$$.fragment,e),u(R.$$.fragment,e),u(q.$$.fragment,e),u(P.$$.fragment,e),u(z.$$.fragment,e),u(D.$$.fragment,e),u(O.$$.fragment,e),u(te.$$.fragment,e),u(se.$$.fragment,e),u(de.$$.fragment,e),u(ce.$$.fragment,e),u(be.$$.fragment,e),u(fe.$$.fragment,e),u(ge.$$.fragment,e),u(he.$$.fragment,e),u(je.$$.fragment,e),Va=!0)},o(e){p(Z.$$.fragment,e),p(V.$$.fragment,e),p(R.$$.fragment,e),p(q.$$.fragment,e),p(P.$$.fragment,e),p(z.$$.fragment,e),p(D.$$.fragment,e),p(O.$$.fragment,e),p(te.$$.fragment,e),p(se.$$.fragment,e),p(de.$$.fragment,e),p(ce.$$.fragment,e),p(be.$$.fragment,e),p(fe.$$.fragment,e),p(ge.$$.fragment,e),p(he.$$.fragment,e),p(je.$$.fragment,e),Va=!1},d(e){e&&(t(We),t(Ce),t(_e),t(Ee),t(L),t(Ie),t(w),t(Ve),t(C),t($e),t(G),t(Xe),t(W),t(Be),t(_),t(Re),t(E),t(Se),t(I),t(He),t(Ae),t(g),t(qe),t($),t(ke),t(X),t(Ye),t(B),t(Ne),t(Qe),t(S),t(Pe),t(H),t(ze),t(h),t(Fe),t(A),t(Ke),t(De),t(k),t(Oe),t(Y),t(ea),t(N),t(aa),t(Q),t(ta),t(la),t(na),t(F),t(sa),t(K),t(oa),t(T),t(ia),t(ra),t(j),t(da),t(ee),t(ca),t(ae),t(ma),t(ua),t(le),t(pa),t(ne),t(ba),t(Ma),t(oe),t(ya),t(ie),t(fa),t(re),t(va),t(ga),t(ha),t(me),t(Ta),t(ue),t(ja),t(U),t(Ua),t(pe),t(xa),t(Ja),t(Me),t(Za),t(ye),t(La),t(wa),t(ve),t(Ca),t(M),t(Ga),t(Wa),t(x),t(_a),t(Te),t(Ea),t(Ia),t(Ge)),t(y),b(Z,e),b(V,e),b(R,e),b(q,e),b(P,e),b(z,e),b(D),b(O,e),b(te,e),b(se,e),b(de,e),b(ce,e),b(be,e),b(fe,e),b(ge),b(he,e),b(je,e)}}}const At='{"title":"¿Qué son los componentes en LlamaIndex?","local":"qué-son-los-componentes-en-llamaindex","sections":[{"title":"Creando un pipeline RAG usando componentes","local":"creando-un-pipeline-rag-usando-componentes","sections":[{"title":"Carga y embedding de documentos","local":"carga-y-embedding-de-documentos","sections":[],"depth":3},{"title":"Almacenamiento e indexación de documentos","local":"almacenamiento-e-indexación-de-documentos","sections":[],"depth":3},{"title":"Consultando un VectorStoreIndex con prompts y LLMs","local":"consultando-un-vectorstoreindex-con-prompts-y-llms","sections":[],"depth":3},{"title":"Procesamiento de Respuestas","local":"procesamiento-de-respuestas","sections":[],"depth":3},{"title":"Evaluación y observabilidad","local":"evaluación-y-observabilidad","sections":[],"depth":3}],"depth":2}],"depth":1}';function qt(Aa){return $t(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zt extends Xt{constructor(y){super(),Bt(this,y,qt,Ht,It,{})}}export{zt as component};
