import{s as fs,n as Ys,o as Es}from"../chunks/scheduler.37c15a92.js";import{S as vs,i as Rs,g as M,s as t,r as p,A as ks,h as o,f as e,c as n,j as ns,u as y,x as i,k as Ms,y as os,a,v as j,d as J,t as r,w as U}from"../chunks/index.2bf4358c.js";import{C as m}from"../chunks/CodeBlock.4e987730.js";import{H as c}from"../chunks/Heading.8ada512a.js";import{E as $s}from"../chunks/getInferenceSnippets.0aa3753f.js";function Fs(ps){let w,jl,yl,Jl,d,rl,u,ys="Alfred a su servicio. Como mayordomo de confianza del Sr. Wayne, me he tomado la libertad de documentar cómo asisto al Sr. Wayne con sus diversas necesidades documentales. Mientras él está fuera atendiendo sus… actividades nocturnas, me aseguro de que todos sus documentos, horarios de entrenamiento y planes nutricionales estén adecuadamente analizados y organizados.",Ul,I,is="Antes de irse, dejó una nota con su programa de entrenamiento semanal. Entonces asumí la responsabilidad de crear un <strong>menú</strong> para las comidas de mañana.",cl,h,js="Para futuros eventos similares, creemos un sistema de análisis de documentos usando LangGraph para servir a las necesidades del Señor Wayne. Este sistema puede:",ml,C,Js="<li>Procesar imágenes</li> <li>Extraer texto usando modelos de visión (Modelo de Lenguaje y Visión)</li> <li>Realizar cálculos cuando sea necesario (para demostrar herramientas normales)</li> <li>Analizar contenido y proporcionar resúmenes concisos</li> <li>Ejecutar instrucciones específicas relacionadas con documentos</li>",wl,b,Tl,B,rs="El flujo de trabajo que construiremos, sigue este esquema estructurado:",dl,g,Us='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/alfred_flow.png" alt="Butler&#39;s Document Analysis Workflow"/>',ul,T,pl,cs='Puedes seguir el código en <a href="https://huggingface.co/agents-course/notebooks/blob/main/unit2/langgraph/agent.ipynb" target="_blank">este notebook</a> que puedes ejecutar usando Google Colab.',ts,A,Il,W,hl,G,ms="and imports :",Cl,Z,bl,f,Bl,Y,ws=`Este estado es un poco más complejo que los anteriores que hemos visto.
AnyMessage es una clase de langchain que define mensajes y add_messages es un operador que agrega el mensaje más reciente en lugar de sobrescribirlo con el último estado.`,gl,E,Ts="Este es un nuevo concepto en langGraph, donde puedes agregar operadores en tu estado para definir la forma en que deben interactuar juntos.",Al,v,Wl,R,Gl,k,Zl,$,fl,F,Yl,S,El,X,ds="Permítame explicar el enfoque en este agente. El agente sigue lo que se conoce como el patrón ReAct (Reason-Act-Observe)",vl,V,us="<li><strong>Razonar(Reason)</strong> sobre sus documentos y solicitudes</li> <li><strong>Actuar (Act)</strong> usando las herramientas apropiadas</li> <li><strong>Observar(Observe)</strong> los resultados</li> <li><strong>Repetir(Repeat)</strong> según sea necesario hasta que haya atendido completamente sus necesidades</li>",Rl,x,Is="Esta es una implementación simple de un agente usando langGraph.",kl,N,$l,Q,hs='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/Agent.png" alt="ReAct Pattern"/>',Fl,z,Sl,_,Xl,q,Cs="En el siguiente ejemplo, agregamos este ejemplo de división simplemente como un",Vl,H,xl,L,bs="La conversación procedería:",Nl,P,Ql,D,zl,K,Bs="Cuando el Maestro Wayne deja sus notas de entrenamiento y comidas:",_l,O,ql,ll,gs="La interacción procedería:",Hl,sl,Ll,el,Pl,al,As="Si deseas crear tu propio mayordomo de análisis de documentos, aquí hay consideraciones clave:",Dl,tl,Ws="<li><strong>Define herramientas claras</strong> para tareas específicas relacionadas con documentos</li> <li><strong>Crea un rastreador de estado robust</strong> para mantener el contexto entre llamadas a herramientas</li> <li><strong>Considera el manejo de errores</strong> para fallos de herramientas</li> <li><strong>Mantén la conciencia contextual</strong> de interacciones previas (asegurado por el operador add_messages)</li>",Kl,nl,Gs="Con estos principios, tú también puedes proporcionar un servicio de análisis de documentos ejemplar digno de la Mansión Wayne.",Ol,Ml,Zs="<em>Confío en que esta explicación haya sido satisfactoria. Ahora, si me disculpas, la capa del Maestro Wayne requiere planchado antes de las actividades de esta noche.</em>",ls,ol,ss,il,es;return d=new c({props:{title:"Grafo de Análisis de Documentos",local:"grafo-de-análisis-de-documentos",headingTag:"h1"}}),b=new c({props:{title:"El Flujo de Trabajo del Mayordomo",local:"el-flujo-de-trabajo-del-mayordomo",headingTag:"h2"}}),A=new c({props:{title:"Configurando el entorno",local:"configurando-el-entorno",headingTag:"h2"}}),W=new m({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMGxhbmdncmFwaCUyMGxhbmdjaGFpbl9vcGVuYWklMjBQaWxsb3clMjBiYXNlNjQlMjBsYW5nY2hhaW5fY29yZQ==",highlighted:"%pip install langgraph langchain_openai Pillow base64 langchain_core",wrap:!1}}),Z=new m({props:{code:"aW1wb3J0JTIwYmFzZTY0JTBBZnJvbSUyMHR5cGluZyUyMGltcG9ydCUyMExpc3QlMkMlMjBUeXBlZERpY3QlMkMlMjBBbm5vdGF0ZWQlMkMlMjBPcHRpb25hbCUwQWZyb20lMjBsYW5nY2hhaW4uc2NoZW1hJTIwaW1wb3J0JTIwSHVtYW5NZXNzYWdlJTBBZnJvbSUyMGxhbmdjaGFpbl9vcGVuYWklMjBpbXBvcnQlMjBDaGF0T3BlbkFJJTBBZnJvbSUyMGxhbmdjaGFpbl9jb3JlLm1lc3NhZ2VzJTIwaW1wb3J0JTIwQW55TWVzc2FnZSUyQyUyMFN5c3RlbU1lc3NhZ2UlMEFmcm9tJTIwbGFuZ2dyYXBoLmdyYXBoLm1lc3NhZ2UlMjBpbXBvcnQlMjBhZGRfbWVzc2FnZXMlMEFmcm9tJTIwbGFuZ2dyYXBoLmdyYXBoJTIwaW1wb3J0JTIwU1RBUlQlMkMlMjBTdGF0ZUdyYXBoJTBBZnJvbSUyMGxhbmdncmFwaC5wcmVidWlsdCUyMGltcG9ydCUyMHRvb2xzX2NvbmRpdGlvbiUwQWZyb20lMjBsYW5nZ3JhcGgucHJlYnVpbHQlMjBpbXBvcnQlMjBUb29sTm9kZSUwQWZyb20lMjBJUHl0aG9uLmRpc3BsYXklMjBpbXBvcnQlMjBJbWFnZSUyQyUyMGRpc3BsYXk=",highlighted:`<span class="hljs-keyword">import</span> base64
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>, TypedDict, Annotated, <span class="hljs-type">Optional</span>
<span class="hljs-keyword">from</span> langchain.schema <span class="hljs-keyword">import</span> HumanMessage
<span class="hljs-keyword">from</span> langchain_openai <span class="hljs-keyword">import</span> ChatOpenAI
<span class="hljs-keyword">from</span> langchain_core.messages <span class="hljs-keyword">import</span> AnyMessage, SystemMessage
<span class="hljs-keyword">from</span> langgraph.graph.message <span class="hljs-keyword">import</span> add_messages
<span class="hljs-keyword">from</span> langgraph.graph <span class="hljs-keyword">import</span> START, StateGraph
<span class="hljs-keyword">from</span> langgraph.prebuilt <span class="hljs-keyword">import</span> tools_condition
<span class="hljs-keyword">from</span> langgraph.prebuilt <span class="hljs-keyword">import</span> ToolNode
<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Image, display`,wrap:!1}}),f=new c({props:{title:"Definiendo el Estado del Agente",local:"definiendo-el-estado-del-agente",headingTag:"h2"}}),v=new m({props:{code:"Y2xhc3MlMjBBZ2VudFN0YXRlKFR5cGVkRGljdCklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBFbCUyMGRvY3VtZW50byUyMHByb3BvcmNpb25hZG8lMEElMjAlMjAlMjAlMjBpbnB1dF9maWxlJTNBJTIwT3B0aW9uYWwlNUJzdHIlNUQlMjAlMjMlMjBDb250aWVuZSUyMGxhJTIwcnV0YSUyMGRlbCUyMGFyY2hpdm8lMjAoUERGJTJGUE5HKSUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNBJTIwQW5ub3RhdGVkJTVCbGlzdCU1QkFueU1lc3NhZ2UlNUQlMkMlMjBhZGRfbWVzc2FnZXMlNUQ=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">AgentState</span>(<span class="hljs-title class_ inherited__">TypedDict</span>):
    <span class="hljs-comment"># El documento proporcionado</span>
    input_file: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>] <span class="hljs-comment"># Contiene la ruta del archivo (PDF/PNG)</span>
    messages: Annotated[<span class="hljs-built_in">list</span>[AnyMessage], add_messages]`,wrap:!1}}),R=new c({props:{title:"Preparando Herramientas",local:"preparando-herramientas",headingTag:"h2"}}),k=new m({props:{code:"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",highlighted:`vision_llm = ChatOpenAI(model=<span class="hljs-string">&quot;gpt-4o&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">extract_text</span>(<span class="hljs-params">img_path: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Extrae texto de un archivo de imagen usando un modelo multimodal.
    
    El Maestro Wayne a menudo deja notas con su régimen de entrenamiento o planes de comidas.
    Esto me permite analizar adecuadamente el contenido.
    &quot;&quot;&quot;</span>
    all_text = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Leer imagen y codificar como base64</span>
        <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(img_path, <span class="hljs-string">&quot;rb&quot;</span>) <span class="hljs-keyword">as</span> image_file:
            image_bytes = image_file.read()

        image_base64 = base64.b64encode(image_bytes).decode(<span class="hljs-string">&quot;utf-8&quot;</span>)

        <span class="hljs-comment"># Preparar el prompt incluyendo los datos de imagen en base64</span>
        message = [
            HumanMessage(
                content=[
                    {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
                        <span class="hljs-string">&quot;text&quot;</span>: (
                            <span class="hljs-string">&quot;Extrae todo el texto de esta imagen. &quot;</span>
                            <span class="hljs-string">&quot;Devuelve solo el texto extraído, sin explicaciones.&quot;</span>
                        ),
                    },
                    {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image_url&quot;</span>,
                        <span class="hljs-string">&quot;image_url&quot;</span>: {
                            <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">f&quot;data:image/png;base64,<span class="hljs-subst">{image_base64}</span>&quot;</span>
                        },
                    },
                ]
            )
        ]

        <span class="hljs-comment"># Llamar al modelo con capacidad de visión</span>
        response = vision_llm.invoke(message)

        <span class="hljs-comment"># Agregar texto extraído</span>
        all_text += response.content + <span class="hljs-string">&quot;\\n\\n&quot;</span>

        <span class="hljs-keyword">return</span> all_text.strip()
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-comment"># Un mayordomo debe manejar los errores con elegancia</span>
        error_msg = <span class="hljs-string">f&quot;Error extracting text: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>
        <span class="hljs-built_in">print</span>(error_msg)
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;&quot;</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">divide</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">float</span>:
    <span class="hljs-string">&quot;&quot;&quot;Divide a y b - para los cálculos ocasionales del Maestro Wayne.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a / b

<span class="hljs-comment"># Equipar al mayordomo con herramientas</span>
tools = [
    divide,
    extract_text
]

llm = ChatOpenAI(model=<span class="hljs-string">&quot;gpt-4o&quot;</span>)
llm_with_tools = llm.bind_tools(tools, parallel_tool_calls=<span class="hljs-literal">False</span>)`,wrap:!1}}),$=new c({props:{title:"Los nodos",local:"los-nodos",headingTag:"h2"}}),F=new m({props:{code:"ZGVmJTIwYXNzaXN0YW50KHN0YXRlJTNBJTIwQWdlbnRTdGF0ZSklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjAlMjAlMjMlMjBNZW5zYWplJTIwZGVsJTIwc2lzdGVtYSUwQSUyMCUyMCUyMCUyMHRleHR1YWxfZGVzY3JpcHRpb25fb2ZfdG9vbCUzRCUyMiUyMiUyMiUwQWV4dHJhY3RfdGV4dChpbWdfcGF0aCUzQSUyMHN0ciklMjAtJTNFJTIwc3RyJTNBJTBBJTIwJTIwJTIwJTIwRXh0cmFlJTIwdGV4dG8lMjBkZSUyMHVuJTIwYXJjaGl2byUyMGRlJTIwaW1hZ2VuJTIwdXNhbmRvJTIwdW4lMjBtb2RlbG8lMjBtdWx0aW1vZGFsLiUwQSUwQSUyMCUyMCUyMCUyMEFyZ3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbWdfcGF0aCUzQSUyMFVuYSUyMHJ1dGElMjBkZSUyMGFyY2hpdm8lMjBkZSUyMGltYWdlbiUyMGxvY2FsJTIwKHN0cmluZ3MpLiUwQSUwQSUyMCUyMCUyMCUyMFJldHVybnMlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBVbmElMjAlQzMlQkFuaWNhJTIwY2FkZW5hJTIwcXVlJTIwY29udGllbmUlMjBlbCUyMHRleHRvJTIwY29uY2F0ZW5hZG8lMjBleHRyYSVDMyVBRGRvJTIwZGUlMjBjYWRhJTIwaW1hZ2VuLiUwQWRpdmlkZShhJTNBJTIwaW50JTJDJTIwYiUzQSUyMGludCklMjAtJTNFJTIwZmxvYXQlM0ElMEElMjAlMjAlMjAlMjBEaXZpZGUlMjBhJTIweSUyMGIlMEElMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBpbWFnZSUzRHN0YXRlJTVCJTIyaW5wdXRfZmlsZSUyMiU1RCUwQSUyMCUyMCUyMCUyMHN5c19tc2clMjAlM0QlMjBTeXN0ZW1NZXNzYWdlKGNvbnRlbnQlM0RmJTIyRXJlcyUyMHVuJTIwbWF5b3Jkb21vJTIwc2VydmljaWFsJTIwbGxhbWFkbyUyMEFsZnJlZCUyMHF1ZSUyMHNpcnZlJTIwYWwlMjBTci4lMjBXYXluZSUyMHklMjBhJTIwQmF0bWFuLiUyMFB1ZWRlcyUyMGFuYWxpemFyJTIwZG9jdW1lbnRvcyUyMHklMjByZWFsaXphciUyMGMlQzMlQTFsY3Vsb3MlMjBjb24lMjBsYXMlMjBoZXJyYW1pZW50YXMlMjBwcm9wb3JjaW9uYWRhcyUzQSU1Q24lN0J0ZXh0dWFsX2Rlc2NyaXB0aW9uX29mX3Rvb2wlN0QlMjAlNUNuJTIwVGllbmVzJTIwYWNjZXNvJTIwYSUyMGFsZ3VuYXMlMjBpbSVDMyVBMWdlbmVzJTIwb3BjaW9uYWxlcy4lMjBBY3R1YWxtZW50ZSUyMGxhJTIwaW1hZ2VuJTIwY2FyZ2FkYSUyMGVzJTNBJTIwJTdCaW1hZ2UlN0QlMjIpJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybWVzc2FnZXMlMjIlM0ElMjAlNUJsbG1fd2l0aF90b29scy5pbnZva2UoJTVCc3lzX21zZyU1RCUyMCUyQiUyMHN0YXRlJTVCJTIybWVzc2FnZXMlMjIlNUQpJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaW5wdXRfZmlsZSUyMiUzQSUyMHN0YXRlJTVCJTIyaW5wdXRfZmlsZSUyMiU1RCUwQSUyMCUyMCUyMCUyMCU3RA==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">assistant</span>(<span class="hljs-params">state: AgentState</span>):
    <span class="hljs-comment">#  # Mensaje del sistema</span>
    textual_description_of_tool=<span class="hljs-string">&quot;&quot;&quot;
extract_text(img_path: str) -&gt; str:
    Extrae texto de un archivo de imagen usando un modelo multimodal.

    Args:
        img_path: Una ruta de archivo de imagen local (strings).

    Returns:
        Una única cadena que contiene el texto concatenado extraído de cada imagen.
divide(a: int, b: int) -&gt; float:
    Divide a y b
&quot;&quot;&quot;</span>
    image=state[<span class="hljs-string">&quot;input_file&quot;</span>]
    sys_msg = SystemMessage(content=<span class="hljs-string">f&quot;Eres un mayordomo servicial llamado Alfred que sirve al Sr. Wayne y a Batman. Puedes analizar documentos y realizar cálculos con las herramientas proporcionadas:\\n<span class="hljs-subst">{textual_description_of_tool}</span> \\n Tienes acceso a algunas imágenes opcionales. Actualmente la imagen cargada es: <span class="hljs-subst">{image}</span>&quot;</span>)

    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;messages&quot;</span>: [llm_with_tools.invoke([sys_msg] + state[<span class="hljs-string">&quot;messages&quot;</span>])],
        <span class="hljs-string">&quot;input_file&quot;</span>: state[<span class="hljs-string">&quot;input_file&quot;</span>]
    }`,wrap:!1}}),S=new c({props:{title:"El Patrón ReAct: Cómo Asisto al Sr. Wayne?",local:"el-patrón-react-cómo-asisto-al-sr-wayne",headingTag:"h2"}}),N=new m({props:{code:"JTIzJTIzJTIwRWwlMjBncmFmbyUwQWJ1aWxkZXIlMjAlM0QlMjBTdGF0ZUdyYXBoKEFnZW50U3RhdGUpJTBBJTBBJTIzJTIwRGVmaW5pciUyMG5vZG9zJTNBJTIwZXN0b3MlMjBoYWNlbiUyMGVsJTIwdHJhYmFqbyUwQWJ1aWxkZXIuYWRkX25vZGUoJTIyYXNzaXN0YW50JTIyJTJDJTIwYXNzaXN0YW50KSUwQWJ1aWxkZXIuYWRkX25vZGUoJTIydG9vbHMlMjIlMkMlMjBUb29sTm9kZSh0b29scykpJTBBJTBBJTIzJTIwRGVmaW5pciUyMGFyaXN0YXMoZWRnZXMpJTNBJTIwZXN0YXMlMjBkZXRlcm1pbmFuJTIwYyVDMyVCM21vJTIwc2UlMjBtdWV2ZSUyMGVsJTIwZmx1am8lMjBkZSUyMGNvbnRyb2wlMEFidWlsZGVyLmFkZF9lZGdlKFNUQVJUJTJDJTIwJTIyYXNzaXN0YW50JTIyKSUwQWJ1aWxkZXIuYWRkX2NvbmRpdGlvbmFsX2VkZ2VzKCUwQSUyMCUyMCUyMCUyMCUyMmFzc2lzdGFudCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMyUyMFNpJTIwZWwlMjAlQzMlQkFsdGltbyUyMG1lbnNhamUlMjByZXF1aWVyZSUyMHVuYSUyMGhlcnJhbWllbnRhJTJDJTIwZGlyaWdpciUyMGElMjBsYXMlMjBoZXJyYW1pZW50YXMlMEElMjAlMjAlMjAlMjAlMjMlMjBEZSUyMGxvJTIwY29udHJhcmlvJTJDJTIwcHJvcG9yY2lvbmFyJTIwdW5hJTIwcmVzcHVlc3RhJTIwZGlyZWN0YSUwQSUyMCUyMCUyMCUyMHRvb2xzX2NvbmRpdGlvbiUyQyUwQSklMEFidWlsZGVyLmFkZF9lZGdlKCUyMnRvb2xzJTIyJTJDJTIwJTIyYXNzaXN0YW50JTIyKSUwQXJlYWN0X2dyYXBoJTIwJTNEJTIwYnVpbGRlci5jb21waWxlKCklMEElMEElMjMlMjBNb3N0cmFyJTIwZWwlMjBwcm9jZXNvJTIwZGUlMjBwZW5zYW1pZW50byUyMGRlbCUyMG1heW9yZG9tbyUwQWRpc3BsYXkoSW1hZ2UocmVhY3RfZ3JhcGguZ2V0X2dyYXBoKHhyYXklM0RUcnVlKS5kcmF3X21lcm1haWRfcG5nKCkpKQ==",highlighted:`<span class="hljs-comment">## El grafo</span>
builder = StateGraph(AgentState)

<span class="hljs-comment"># Definir nodos: estos hacen el trabajo</span>
builder.add_node(<span class="hljs-string">&quot;assistant&quot;</span>, assistant)
builder.add_node(<span class="hljs-string">&quot;tools&quot;</span>, ToolNode(tools))

<span class="hljs-comment"># Definir aristas(edges): estas determinan cómo se mueve el flujo de control</span>
builder.add_edge(START, <span class="hljs-string">&quot;assistant&quot;</span>)
builder.add_conditional_edges(
    <span class="hljs-string">&quot;assistant&quot;</span>,
    <span class="hljs-comment"># Si el último mensaje requiere una herramienta, dirigir a las herramientas</span>
    <span class="hljs-comment"># De lo contrario, proporcionar una respuesta directa</span>
    tools_condition,
)
builder.add_edge(<span class="hljs-string">&quot;tools&quot;</span>, <span class="hljs-string">&quot;assistant&quot;</span>)
react_graph = builder.<span class="hljs-built_in">compile</span>()

<span class="hljs-comment"># Mostrar el proceso de pensamiento del mayordomo</span>
display(Image(react_graph.get_graph(xray=<span class="hljs-literal">True</span>).draw_mermaid_png()))`,wrap:!1}}),z=new c({props:{title:"El Mayordomo en Acción",local:"el-mayordomo-en-acción",headingTag:"h2"}}),_=new c({props:{title:"Ejemplo 1: Cálculos Simples",local:"ejemplo-1-cálculos-simples",headingTag:"h3"}}),H=new m({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUJIdW1hbk1lc3NhZ2UoY29udGVudCUzRCUyMkRpdmlkZSUyMDY3OTAlMjBwb3IlMjA1JTIyKSU1RCUwQW1lc3NhZ2VzJTIwJTNEJTIwcmVhY3RfZ3JhcGguaW52b2tlKCU3QiUyMm1lc3NhZ2VzJTIyJTNBJTIwbWVzc2FnZXMlMkMlMjAlMjJpbnB1dF9maWxlJTIyJTNBJTIwTm9uZSU3RCk=",highlighted:`messages = [HumanMessage(content=<span class="hljs-string">&quot;Divide 6790 por 5&quot;</span>)]
messages = react_graph.invoke({<span class="hljs-string">&quot;messages&quot;</span>: messages, <span class="hljs-string">&quot;input_file&quot;</span>: <span class="hljs-literal">None</span>})`,wrap:!1}}),P=new m({props:{code:"SHVtYW5vJTNBJTIwRGl2aWRlJTIwNjc5MCUyMHBvciUyMDUlMEElMEFMbGFtYWRhJTIwYSUyMEhlcnJhbWllbnRhJTIwSUElM0ElMjBkaXZpZGUoYSUzRDY3OTAlMkMlMjBiJTNENSklMEElMEFSZXNwdWVzdGElMjBkZSUyMGxhJTIwSGVycmFtaWVudGElM0ElMjAxMzU4LjAlMEElMEFBbGZyZWQlM0ElMjBFbCUyMHJlc3VsdGFkbyUyMGRlJTIwZGl2aWRpciUyMDY3OTAlMjBwb3IlMjA1JTIwZXMlMjAxMzU4LjAu",highlighted:`<span class="hljs-attribute">Humano</span>: Divide <span class="hljs-number">6790</span> por <span class="hljs-number">5</span>

<span class="hljs-attribute">Llamada</span> a Herramienta IA: divide(a=<span class="hljs-number">6790</span>, b=<span class="hljs-number">5</span>)

<span class="hljs-attribute">Respuesta</span> de la Herramienta: <span class="hljs-number">1358</span>.<span class="hljs-number">0</span>

<span class="hljs-attribute">Alfred</span>: El resultado de dividir <span class="hljs-number">6790</span> por <span class="hljs-number">5</span> es <span class="hljs-number">1358</span>.<span class="hljs-number">0</span>.`,wrap:!1}}),D=new c({props:{title:"Ejemplo 2: Analizando los Documentos de Entrenamiento del Maestro Wayne",local:"ejemplo-2-analizando-los-documentos-de-entrenamiento-del-maestro-wayne",headingTag:"h3"}}),O=new m({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUJIdW1hbk1lc3NhZ2UoY29udGVudCUzRCUyMlNlZyVDMyVCQW4lMjBsYSUyMG5vdGElMjBwcm9wb3JjaW9uYWRhJTIwcG9yJTIwZWwlMjBTci4lMjBXYXluZSUyMGVuJTIwbGFzJTIwaW0lQzMlQTFnZW5lcyUyMHByb3BvcmNpb25hZGFzLiUyMCVDMiVCRkN1JUMzJUExbCUyMGVzJTIwbGElMjBsaXN0YSUyMGRlJTIwYXJ0JUMzJUFEY3Vsb3MlMjBxdWUlMjBkZWJvJTIwY29tcHJhciUyMHBhcmElMjBlbCUyMG1lbiVDMyVCQSUyMGRlJTIwbGElMjBjZW5hJTNGJTIyKSU1RCUwQW1lc3NhZ2VzJTIwJTNEJTIwcmVhY3RfZ3JhcGguaW52b2tlKCU3QiUyMm1lc3NhZ2VzJTIyJTNBJTIwbWVzc2FnZXMlMkMlMjAlMjJpbnB1dF9maWxlJTIyJTNBJTIwJTIyQmF0bWFuX3RyYWluaW5nX2FuZF9tZWFscy5wbmclMjIlN0Qp",highlighted:`messages = [HumanMessage(content=<span class="hljs-string">&quot;Según la nota proporcionada por el Sr. Wayne en las imágenes proporcionadas. ¿Cuál es la lista de artículos que debo comprar para el menú de la cena?&quot;</span>)]
messages = react_graph.invoke({<span class="hljs-string">&quot;messages&quot;</span>: messages, <span class="hljs-string">&quot;input_file&quot;</span>: <span class="hljs-string">&quot;Batman_training_and_meals.png&quot;</span>})`,wrap:!1}}),sl=new m({props:{code:"SHVtYW5vJTNBJTIwU2VnJUMzJUJBbiUyMGxhJTIwbm90YSUyMHByb3BvcmNpb25hZGElMjBwb3IlMjBlbCUyMFNyLiUyMFdheW5lJTIwZW4lMjBsYXMlMjBpbSVDMyVBMWdlbmVzJTIwcHJvcG9yY2lvbmFkYXMuJTIwJUMyJUJGQ3UlQzMlQTFsJTIwZXMlMjBsYSUyMGxpc3RhJTIwZGUlMjBhcnQlQzMlQURjdWxvcyUyMHF1ZSUyMGRlYm8lMjBjb21wcmFyJTIwcGFyYSUyMGVsJTIwbWVuJUMzJUJBJTIwZGUlMjBsYSUyMGNlbmElM0YlMEElMEFMbGFtYWRhJTIwYSUyMEhlcnJhbWllbnRhJTIwSUElM0ElMjBleHRyYWN0X3RleHQoaW1nX3BhdGglM0QlMjJCYXRtYW5fdHJhaW5pbmdfYW5kX21lYWxzLnBuZyUyMiklMEElMEFSZXNwdWVzdGElMjBkZSUyMGxhJTIwSGVycmFtaWVudGElM0ElMjAlNUJUZXh0byUyMGV4dHJhJUMzJUFEZG8lMjBjb24lMjBob3JhcmlvJTIwZGUlMjBlbnRyZW5hbWllbnRvJTIweSUyMGRldGFsbGVzJTIwZGVsJTIwbWVuJUMzJUJBJTVEJTBBJTBBQWxmcmVkJTNBJTIwUGFyYSUyMGVsJTIwbWVuJUMzJUJBJTIwZGUlMjBsYSUyMGNlbmElMkMlMjBkZWJlciVDMyVBRGFzJTIwY29tcHJhciUyMGxvcyUyMHNpZ3VpZW50ZXMlMjBhcnQlQzMlQURjdWxvcyUzQSUwQSUwQTEuJTIwRmlsZXRlJTIwZGUlMjByZXMlMjBsb2NhbCUyMGFsaW1lbnRhZG8lMjBjb24lMjBwYXN0byUwQTIuJTIwRXNwaW5hY2FzJTIwb3JnJUMzJUExbmljYXMlMEEzLiUyMFBpbWllbnRvcyUyMGRlbCUyMHBpcXVpbGxvJTBBNC4lMjBQYXBhcyUyMChwYXJhJTIwcGFwYXMlMjBkb3JhZGFzJTIwYWwlMjBob3JubyUyMGNvbiUyMGhpZXJiYXMpJTBBNS4lMjBBY2VpdGUlMjBkZSUyMHBlc2NhZG8lMjAoMiUyMGdyYW1vcyklMEElMEFBc2VnJUMzJUJBcmF0ZSUyMGRlJTIwcXVlJTIwZWwlMjBmaWxldGUlMjBzZWElMjBhbGltZW50YWRvJTIwY29uJTIwcGFzdG8lMjB5JTIwcXVlJTIwbGFzJTIwZXNwaW5hY2FzJTIweSUyMGxvcyUyMHBpbWllbnRvcyUyMHNlYW4lMjBvcmclQzMlQTFuaWNvcyUyMHBhcmElMjBsYSUyMG1lam9yJTIwY2FsaWRhZCUyMGRlJTIwY29taWRhLg==",highlighted:`Humano: Segú<span class="hljs-keyword">n</span> <span class="hljs-keyword">la</span> nota proporcionada por el Sr. Wayne <span class="hljs-keyword">en</span> las imágenes proporcionadas. ¿Cuá<span class="hljs-keyword">l</span> es <span class="hljs-keyword">la</span> lista <span class="hljs-keyword">de</span> artículos <span class="hljs-keyword">que</span> debo comprar para el menú <span class="hljs-keyword">de</span> <span class="hljs-keyword">la</span> cena?

Llamada a Herramienta IA: extract_text(img_path=<span class="hljs-string">&quot;Batman_training_and_meals.png&quot;</span>)

Respuesta <span class="hljs-keyword">de</span> <span class="hljs-keyword">la</span> Herramienta: [Texto extraí<span class="hljs-keyword">do</span> con horario <span class="hljs-keyword">de</span> entrenamiento y detalles del menú]

Alfred: Para el menú <span class="hljs-keyword">de</span> <span class="hljs-keyword">la</span> cena, deberí<span class="hljs-keyword">as</span> comprar los siguientes artículos:

1. Filete <span class="hljs-keyword">de</span> res <span class="hljs-keyword">local</span> alimentado con pasto
2. Espinacas orgánicas
3. Pimientos del piquillo
4. Papas (para papas doradas al horno con hierbas)
5. Aceite <span class="hljs-keyword">de</span> pescado (2 gramos)

Asegúrate <span class="hljs-keyword">de</span> <span class="hljs-keyword">que</span> el filete sea alimentado con pasto y <span class="hljs-keyword">que</span> las espinacas y los pimientos sean orgánicos para <span class="hljs-keyword">la</span> mejor calidad <span class="hljs-keyword">de</span> comida.`,wrap:!1}}),el=new c({props:{title:"Puntos Clave",local:"puntos-clave",headingTag:"h2"}}),ol=new $s({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/es/unit2/langgraph/document_analysis_agent.mdx"}}),{c(){w=M("meta"),jl=t(),yl=M("p"),Jl=t(),p(d.$$.fragment),rl=t(),u=M("p"),u.textContent=ys,Ul=t(),I=M("p"),I.innerHTML=is,cl=t(),h=M("p"),h.textContent=js,ml=t(),C=M("ol"),C.innerHTML=Js,wl=t(),p(b.$$.fragment),Tl=t(),B=M("p"),B.textContent=rs,dl=t(),g=M("p"),g.innerHTML=Us,ul=t(),T=M("blockquote"),pl=M("p"),pl.innerHTML=cs,ts=t(),p(A.$$.fragment),Il=t(),p(W.$$.fragment),hl=t(),G=M("p"),G.textContent=ms,Cl=t(),p(Z.$$.fragment),bl=t(),p(f.$$.fragment),Bl=t(),Y=M("p"),Y.textContent=ws,gl=t(),E=M("p"),E.textContent=Ts,Al=t(),p(v.$$.fragment),Wl=t(),p(R.$$.fragment),Gl=t(),p(k.$$.fragment),Zl=t(),p($.$$.fragment),fl=t(),p(F.$$.fragment),Yl=t(),p(S.$$.fragment),El=t(),X=M("p"),X.textContent=ds,vl=t(),V=M("ol"),V.innerHTML=us,Rl=t(),x=M("p"),x.textContent=Is,kl=t(),p(N.$$.fragment),$l=t(),Q=M("p"),Q.innerHTML=hs,Fl=t(),p(z.$$.fragment),Sl=t(),p(_.$$.fragment),Xl=t(),q=M("p"),q.textContent=Cs,Vl=t(),p(H.$$.fragment),xl=t(),L=M("p"),L.textContent=bs,Nl=t(),p(P.$$.fragment),Ql=t(),p(D.$$.fragment),zl=t(),K=M("p"),K.textContent=Bs,_l=t(),p(O.$$.fragment),ql=t(),ll=M("p"),ll.textContent=gs,Hl=t(),p(sl.$$.fragment),Ll=t(),p(el.$$.fragment),Pl=t(),al=M("p"),al.textContent=As,Dl=t(),tl=M("ol"),tl.innerHTML=Ws,Kl=t(),nl=M("p"),nl.textContent=Gs,Ol=t(),Ml=M("p"),Ml.innerHTML=Zs,ls=t(),p(ol.$$.fragment),ss=t(),il=M("p"),this.h()},l(l){const s=ks("svelte-u9bgzb",document.head);w=o(s,"META",{name:!0,content:!0}),s.forEach(e),jl=n(l),yl=o(l,"P",{}),ns(yl).forEach(e),Jl=n(l),y(d.$$.fragment,l),rl=n(l),u=o(l,"P",{"data-svelte-h":!0}),i(u)!=="svelte-zsxxt7"&&(u.textContent=ys),Ul=n(l),I=o(l,"P",{"data-svelte-h":!0}),i(I)!=="svelte-qp0tiq"&&(I.innerHTML=is),cl=n(l),h=o(l,"P",{"data-svelte-h":!0}),i(h)!=="svelte-z249ta"&&(h.textContent=js),ml=n(l),C=o(l,"OL",{"data-svelte-h":!0}),i(C)!=="svelte-afmwq1"&&(C.innerHTML=Js),wl=n(l),y(b.$$.fragment,l),Tl=n(l),B=o(l,"P",{"data-svelte-h":!0}),i(B)!=="svelte-bf5yzp"&&(B.textContent=rs),dl=n(l),g=o(l,"P",{"data-svelte-h":!0}),i(g)!=="svelte-g7cpwr"&&(g.innerHTML=Us),ul=n(l),T=o(l,"BLOCKQUOTE",{class:!0});var as=ns(T);pl=o(as,"P",{"data-svelte-h":!0}),i(pl)!=="svelte-1r3qz93"&&(pl.innerHTML=cs),ts=n(as),y(A.$$.fragment,as),as.forEach(e),Il=n(l),y(W.$$.fragment,l),hl=n(l),G=o(l,"P",{"data-svelte-h":!0}),i(G)!=="svelte-1ey17wx"&&(G.textContent=ms),Cl=n(l),y(Z.$$.fragment,l),bl=n(l),y(f.$$.fragment,l),Bl=n(l),Y=o(l,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-1bl0on2"&&(Y.textContent=ws),gl=n(l),E=o(l,"P",{"data-svelte-h":!0}),i(E)!=="svelte-1gcl5ng"&&(E.textContent=Ts),Al=n(l),y(v.$$.fragment,l),Wl=n(l),y(R.$$.fragment,l),Gl=n(l),y(k.$$.fragment,l),Zl=n(l),y($.$$.fragment,l),fl=n(l),y(F.$$.fragment,l),Yl=n(l),y(S.$$.fragment,l),El=n(l),X=o(l,"P",{"data-svelte-h":!0}),i(X)!=="svelte-2k43o2"&&(X.textContent=ds),vl=n(l),V=o(l,"OL",{"data-svelte-h":!0}),i(V)!=="svelte-l3ic7l"&&(V.innerHTML=us),Rl=n(l),x=o(l,"P",{"data-svelte-h":!0}),i(x)!=="svelte-1yeg1q0"&&(x.textContent=Is),kl=n(l),y(N.$$.fragment,l),$l=n(l),Q=o(l,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-1nhlurw"&&(Q.innerHTML=hs),Fl=n(l),y(z.$$.fragment,l),Sl=n(l),y(_.$$.fragment,l),Xl=n(l),q=o(l,"P",{"data-svelte-h":!0}),i(q)!=="svelte-180npus"&&(q.textContent=Cs),Vl=n(l),y(H.$$.fragment,l),xl=n(l),L=o(l,"P",{"data-svelte-h":!0}),i(L)!=="svelte-j2ej"&&(L.textContent=bs),Nl=n(l),y(P.$$.fragment,l),Ql=n(l),y(D.$$.fragment,l),zl=n(l),K=o(l,"P",{"data-svelte-h":!0}),i(K)!=="svelte-yg2xrh"&&(K.textContent=Bs),_l=n(l),y(O.$$.fragment,l),ql=n(l),ll=o(l,"P",{"data-svelte-h":!0}),i(ll)!=="svelte-1cgp1ee"&&(ll.textContent=gs),Hl=n(l),y(sl.$$.fragment,l),Ll=n(l),y(el.$$.fragment,l),Pl=n(l),al=o(l,"P",{"data-svelte-h":!0}),i(al)!=="svelte-1eylppk"&&(al.textContent=As),Dl=n(l),tl=o(l,"OL",{"data-svelte-h":!0}),i(tl)!=="svelte-1ikimrz"&&(tl.innerHTML=Ws),Kl=n(l),nl=o(l,"P",{"data-svelte-h":!0}),i(nl)!=="svelte-v8anja"&&(nl.textContent=Gs),Ol=n(l),Ml=o(l,"P",{"data-svelte-h":!0}),i(Ml)!=="svelte-o5yhc9"&&(Ml.innerHTML=Zs),ls=n(l),y(ol.$$.fragment,l),ss=n(l),il=o(l,"P",{}),ns(il).forEach(e),this.h()},h(){Ms(w,"name","hf:doc:metadata"),Ms(w,"content",Ss),Ms(T,"class","tip")},m(l,s){os(document.head,w),a(l,jl,s),a(l,yl,s),a(l,Jl,s),j(d,l,s),a(l,rl,s),a(l,u,s),a(l,Ul,s),a(l,I,s),a(l,cl,s),a(l,h,s),a(l,ml,s),a(l,C,s),a(l,wl,s),j(b,l,s),a(l,Tl,s),a(l,B,s),a(l,dl,s),a(l,g,s),a(l,ul,s),a(l,T,s),os(T,pl),os(T,ts),j(A,T,null),a(l,Il,s),j(W,l,s),a(l,hl,s),a(l,G,s),a(l,Cl,s),j(Z,l,s),a(l,bl,s),j(f,l,s),a(l,Bl,s),a(l,Y,s),a(l,gl,s),a(l,E,s),a(l,Al,s),j(v,l,s),a(l,Wl,s),j(R,l,s),a(l,Gl,s),j(k,l,s),a(l,Zl,s),j($,l,s),a(l,fl,s),j(F,l,s),a(l,Yl,s),j(S,l,s),a(l,El,s),a(l,X,s),a(l,vl,s),a(l,V,s),a(l,Rl,s),a(l,x,s),a(l,kl,s),j(N,l,s),a(l,$l,s),a(l,Q,s),a(l,Fl,s),j(z,l,s),a(l,Sl,s),j(_,l,s),a(l,Xl,s),a(l,q,s),a(l,Vl,s),j(H,l,s),a(l,xl,s),a(l,L,s),a(l,Nl,s),j(P,l,s),a(l,Ql,s),j(D,l,s),a(l,zl,s),a(l,K,s),a(l,_l,s),j(O,l,s),a(l,ql,s),a(l,ll,s),a(l,Hl,s),j(sl,l,s),a(l,Ll,s),j(el,l,s),a(l,Pl,s),a(l,al,s),a(l,Dl,s),a(l,tl,s),a(l,Kl,s),a(l,nl,s),a(l,Ol,s),a(l,Ml,s),a(l,ls,s),j(ol,l,s),a(l,ss,s),a(l,il,s),es=!0},p:Ys,i(l){es||(J(d.$$.fragment,l),J(b.$$.fragment,l),J(A.$$.fragment,l),J(W.$$.fragment,l),J(Z.$$.fragment,l),J(f.$$.fragment,l),J(v.$$.fragment,l),J(R.$$.fragment,l),J(k.$$.fragment,l),J($.$$.fragment,l),J(F.$$.fragment,l),J(S.$$.fragment,l),J(N.$$.fragment,l),J(z.$$.fragment,l),J(_.$$.fragment,l),J(H.$$.fragment,l),J(P.$$.fragment,l),J(D.$$.fragment,l),J(O.$$.fragment,l),J(sl.$$.fragment,l),J(el.$$.fragment,l),J(ol.$$.fragment,l),es=!0)},o(l){r(d.$$.fragment,l),r(b.$$.fragment,l),r(A.$$.fragment,l),r(W.$$.fragment,l),r(Z.$$.fragment,l),r(f.$$.fragment,l),r(v.$$.fragment,l),r(R.$$.fragment,l),r(k.$$.fragment,l),r($.$$.fragment,l),r(F.$$.fragment,l),r(S.$$.fragment,l),r(N.$$.fragment,l),r(z.$$.fragment,l),r(_.$$.fragment,l),r(H.$$.fragment,l),r(P.$$.fragment,l),r(D.$$.fragment,l),r(O.$$.fragment,l),r(sl.$$.fragment,l),r(el.$$.fragment,l),r(ol.$$.fragment,l),es=!1},d(l){l&&(e(jl),e(yl),e(Jl),e(rl),e(u),e(Ul),e(I),e(cl),e(h),e(ml),e(C),e(wl),e(Tl),e(B),e(dl),e(g),e(ul),e(T),e(Il),e(hl),e(G),e(Cl),e(bl),e(Bl),e(Y),e(gl),e(E),e(Al),e(Wl),e(Gl),e(Zl),e(fl),e(Yl),e(El),e(X),e(vl),e(V),e(Rl),e(x),e(kl),e($l),e(Q),e(Fl),e(Sl),e(Xl),e(q),e(Vl),e(xl),e(L),e(Nl),e(Ql),e(zl),e(K),e(_l),e(ql),e(ll),e(Hl),e(Ll),e(Pl),e(al),e(Dl),e(tl),e(Kl),e(nl),e(Ol),e(Ml),e(ls),e(ss),e(il)),e(w),U(d,l),U(b,l),U(A),U(W,l),U(Z,l),U(f,l),U(v,l),U(R,l),U(k,l),U($,l),U(F,l),U(S,l),U(N,l),U(z,l),U(_,l),U(H,l),U(P,l),U(D,l),U(O,l),U(sl,l),U(el,l),U(ol,l)}}}const Ss='{"title":"Grafo de Análisis de Documentos","local":"grafo-de-análisis-de-documentos","sections":[{"title":"El Flujo de Trabajo del Mayordomo","local":"el-flujo-de-trabajo-del-mayordomo","sections":[],"depth":2},{"title":"Configurando el entorno","local":"configurando-el-entorno","sections":[],"depth":2},{"title":"Definiendo el Estado del Agente","local":"definiendo-el-estado-del-agente","sections":[],"depth":2},{"title":"Preparando Herramientas","local":"preparando-herramientas","sections":[],"depth":2},{"title":"Los nodos","local":"los-nodos","sections":[],"depth":2},{"title":"El Patrón ReAct: Cómo Asisto al Sr. Wayne?","local":"el-patrón-react-cómo-asisto-al-sr-wayne","sections":[],"depth":2},{"title":"El Mayordomo en Acción","local":"el-mayordomo-en-acción","sections":[{"title":"Ejemplo 1: Cálculos Simples","local":"ejemplo-1-cálculos-simples","sections":[],"depth":3},{"title":"Ejemplo 2: Analizando los Documentos de Entrenamiento del Maestro Wayne","local":"ejemplo-2-analizando-los-documentos-de-entrenamiento-del-maestro-wayne","sections":[],"depth":3}],"depth":2},{"title":"Puntos Clave","local":"puntos-clave","sections":[],"depth":2}],"depth":1}';function Xs(ps){return Es(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _s extends vs{constructor(w){super(),Rs(this,w,Xs,Fs,fs,{})}}export{_s as component};
