import{s as Ba,f as Ut,n as ga,o as xa}from"../chunks/scheduler.37c15a92.js";import{S as Ea,i as _a,g as M,s,r as o,A as Ga,h as i,f as t,c as n,j as Tt,u as p,x as r,k as y,y as wt,a,v as u,d as m,t as c,w as j}from"../chunks/index.2bf4358c.js";import{C as U}from"../chunks/CodeBlock.4e987730.js";import{H as $e}from"../chunks/Heading.8ada512a.js";import{E as qa}from"../chunks/getInferenceSnippets.0aa3753f.js";function Ha(Ct){let d,ke,ze,Ve,T,Ne,w,It,Re,C,At="Un aspecto crucial de los Agentes de IA es su capacidad para realizar <strong>acciones</strong>. Como vimos, esto sucede a través del uso de <strong>Herramientas</strong>.",Xe,I,bt="En esta sección, aprenderemos qué son las Herramientas, cómo diseñarlas de manera efectiva y cómo integrarlas en tu Agente a través del Mensaje del Sistema.",Fe,A,ht="Al proporcionar a tu Agente las Herramientas adecuadas —y describir claramente cómo funcionan esas Herramientas— puedes aumentar dramáticamente lo que tu IA puede lograr. ¡Vamos a profundizar!",Pe,b,Ke,h,ft="Una <strong>Herramienta es una función proporcionada al LLM</strong>. Esta función debe cumplir un <strong>objetivo claro</strong>.",De,f,vt="Aquí hay algunas herramientas comúnmente utilizadas en agentes de IA:",Oe,v,Bt="<thead><tr><th>Herramienta</th> <th>Descripción</th></tr></thead> <tbody><tr><td>Búsqueda Web</td> <td>Permite al agente obtener información actualizada de internet.</td></tr> <tr><td>Generación de Imágenes</td> <td>Crea imágenes basadas en descripciones textuales.</td></tr> <tr><td>Recuperación</td> <td>Recupera información de una fuente externa.</td></tr> <tr><td>Interfaz de API</td> <td>Interactúa con una API externa (GitHub, YouTube, Spotify, etc.).</td></tr></tbody>",el,B,gt="¡Esos son solo ejemplos, ya que de hecho puedes crear una herramienta para cualquier caso de uso!",ll,g,xt="Una buena herramienta debería ser algo que <strong>complemente el poder de un LLM</strong>.",tl,x,Et="Por ejemplo, si necesitas realizar operaciones aritméticas, proporcionar una <strong>herramienta de calculadora</strong> a tu LLM proporcionará mejores resultados que confiar en las capacidades nativas del modelo.",al,E,_t="Además, <strong>los LLMs predicen la finalización de un prompt basándose en sus datos de entrenamiento</strong>, lo que significa que su conocimiento interno solo incluye eventos anteriores a su entrenamiento. Por lo tanto, si tu agente necesita datos actualizados, debes proporcionarlos a través de alguna herramienta.",sl,_,Gt="Por ejemplo, si le preguntas directamente a un LLM (sin una herramienta de búsqueda) sobre el clima de hoy, el LLM potencialmente alucinará un clima aleatorio.",nl,G,qt,Ml,q,Ht="<li><p>Una Herramienta debe contener:</p> <ul><li>Una <strong>descripción textual de lo que hace la función</strong>.</li> <li>Un <em>Callable</em> (algo para realizar una acción).</li> <li><em>Argumentos</em> con tipos.</li> <li>(Opcional) Salidas con tipos.</li></ul></li>",il,H,rl,L,Lt="Los LLMs, como vimos, solo pueden recibir entradas de texto y generar salidas de texto. No tienen forma de llamar a herramientas por sí mismos. Lo que queremos decir cuando hablamos de <em>proporcionar herramientas a un Agente</em>, es que <strong>enseñamos</strong> al LLM sobre la existencia de herramientas, y pedimos al modelo que genere texto que invocará herramientas cuando las necesite. Por ejemplo, si proporcionamos una herramienta para verificar el clima en una ubicación desde Internet, y luego preguntamos al LLM sobre el clima en París, el LLM reconocerá esa pregunta como una oportunidad relevante para usar la herramienta “clima” que le enseñamos. El LLM generará <em>texto</em>, en forma de código, para invocar esa herramienta. Es responsabilidad del <strong>Agente</strong> analizar la salida del LLM, reconocer que se requiere una llamada a una herramienta e invocar la herramienta en nombre del LLM. La salida de la herramienta luego se enviará de vuelta al LLM, que compondrá su respuesta final para el usuario.",ol,Z,Zt="La salida de una llamada a una herramienta es otro tipo de mensaje en la conversación. Los pasos de llamada a herramientas típicamente no se muestran al usuario: el Agente recupera la conversación, llama a la(s) herramienta(s), obtiene las salidas, las agrega como un nuevo mensaje de conversación y envía la conversación actualizada al LLM nuevamente. Desde el punto de vista del usuario, es como si el LLM hubiera usado la herramienta, pero de hecho fue nuestro código de aplicación (el <strong>Agente</strong>) quien lo hizo.",pl,S,St="Hablaremos mucho más sobre este proceso en sesiones futuras.",ul,W,ml,Y,Wt="La respuesta completa puede parecer abrumadora, pero esencialmente usamos el prompt del sistema para proporcionar descripciones textuales de las herramientas disponibles al modelo:",cl,$,Yt,jl,z,$t="Para que esto funcione, tenemos que ser muy precisos y exactos sobre:",yl,Q,zt="<li><strong>Lo que hace la herramienta</strong></li> <li><strong>Qué entradas exactas espera</strong></li>",dl,k,Qt="Esta es la razón por la que las descripciones de herramientas generalmente se proporcionan utilizando estructuras expresivas pero precisas, como lenguajes de computadora o JSON. No es <em>necesario</em> hacerlo así, cualquier formato preciso y coherente funcionaría.",Ul,V,kt="Si esto parece demasiado teórico, vamos a entenderlo a través de un ejemplo concreto.",Jl,N,Vt="Implementaremos una herramienta <strong>calculadora</strong> simplificada que solo multiplicará dos enteros. Esta podría ser nuestra implementación en Python:",Tl,R,wl,X,Nt="Así que nuestra herramienta se llama <code>calculadora</code>, <strong>multiplica dos enteros</strong>, y requiere las siguientes entradas:",Cl,F,Rt="<li><strong><code>a</code></strong> (<em>int</em>): Un entero.</li> <li><strong><code>b</code></strong> (<em>int</em>): Un entero.</li>",Il,P,Xt="La salida de la herramienta es otro número entero que podemos describir así:",Al,K,Ft="<li>(<em>int</em>): El producto de <code>a</code> y <code>b</code>.</li>",bl,D,Pt="Todos estos detalles son importantes. Vamos a juntarlos en una cadena de texto que describe nuestra herramienta para que el LLM la entienda.",hl,O,fl,ee,Kt="<p><strong>Recordatorio:</strong> Esta descripción textual es <em>lo que queremos que el LLM sepa sobre la herramienta</em>.</p>",vl,le,Dt="Cuando pasamos la cadena anterior como parte de la entrada al LLM, el modelo la reconocerá como una herramienta, y sabrá qué necesita pasar como entradas y qué esperar de la salida.",Bl,te,Ot="Si queremos proporcionar herramientas adicionales, debemos ser consistentes y siempre usar el mismo formato. Este proceso puede ser frágil, y podríamos pasar por alto accidentalmente algunos detalles.",gl,ae,ea="¿Hay una mejor manera?",xl,se,El,ne,la="Nuestra herramienta fue escrita en Python, y la implementación ya proporciona todo lo que necesitamos:",_l,Me,ta="<li>Un nombre descriptivo de lo que hace: <code>calculadora</code></li> <li>Una descripción más larga, proporcionada por el comentario docstring de la función: <code>Multiplica dos enteros.</code></li> <li>Las entradas y su tipo: la función claramente espera dos <code>int</code>s.</li> <li>El tipo de la salida.</li>",Gl,ie,aa="Hay una razón por la que la gente usa lenguajes de programación: son expresivos, concisos y precisos.",ql,re,sa="Podríamos proporcionar el código fuente de Python como la <em>especificación</em> de la herramienta para el LLM, pero la forma en que se implementa la herramienta no importa. Todo lo que importa es su nombre, lo que hace, las entradas que espera y la salida que proporciona.",Hl,oe,na="Aprovecharemos las características de introspección de Python para aprovechar el código fuente y construir una descripción de herramienta automáticamente para nosotros. Todo lo que necesitamos es que la implementación de la herramienta use sugerencias de tipo, docstrings y nombres de función sensatos. Escribiremos algo de código para extraer las partes relevantes del código fuente.",Ll,pe,Ma="Después de terminar, solo necesitaremos usar un decorador de Python para indicar que la función <code>calculadora</code> es una herramienta:",Zl,ue,Sl,me,ia="Nota el decorador <code>@tool</code> antes de la definición de la función.",Wl,ce,ra="Con la implementación que veremos a continuación, podremos recuperar el siguiente texto automáticamente del código fuente a través de la función <code>to_string()</code> proporcionada por el decorador:",Yl,je,$l,ye,oa="Como puedes ver, ¡es lo mismo que escribimos manualmente antes!",zl,de,Ql,Ue,pa="Creamos una clase genérica <code>Tool</code> que podemos reutilizar siempre que necesitemos usar una herramienta.",kl,Je,ua="<p><strong>Descargo de responsabilidad:</strong> Esta implementación de ejemplo es ficticia pero se parece mucho a implementaciones reales en la mayoría de las bibliotecas.</p>",Vl,Te,Nl,we,ma="Puede parecer complicado, pero si lo recorremos lentamente podemos ver lo que hace. Definimos una clase <strong><code>Tool</code></strong> que incluye:",Rl,Ce,ca="<li><strong><code>name</code></strong> (<em>str</em>): El nombre de la herramienta.</li> <li><strong><code>description</code></strong> (<em>str</em>): Una breve descripción de lo que hace la herramienta.</li> <li><strong><code>function</code></strong> (<em>callable</em>): La función que ejecuta la herramienta.</li> <li><strong><code>arguments</code></strong> (<em>list</em>): Los parámetros de entrada esperados.</li> <li><strong><code>outputs</code></strong> (<em>str</em> o <em>list</em>): Las salidas esperadas de la herramienta.</li> <li><strong><code>__call__()</code></strong>: Llama a la función cuando se invoca la instancia de la herramienta.</li> <li><strong><code>to_string()</code></strong>: Convierte los atributos de la herramienta en una representación textual.</li>",Xl,Ie,ja="Podríamos crear una Herramienta con esta clase usando código como el siguiente:",Fl,Ae,Pl,be,ya="¡Pero también podemos usar el módulo <code>inspect</code> de Python para recuperar toda la información por nosotros! Esto es lo que hace el decorador <code>@tool</code>.",Kl,he,da="<p>Si estás interesado, puedes revelar la siguiente sección para ver la implementación del decorador.</p>",Dl,J,Ye,Ua="código del decorador",Jt,fe,Ol,ve,Ja="Solo para reiterar, con este decorador en su lugar podemos implementar nuestra herramienta así:",et,Be,lt,ge,Ta="Y podemos usar el método <code>to_string</code> de la <code>Tool</code> para recuperar automáticamente un texto adecuado para ser utilizado como descripción de herramienta para un LLM:",tt,xe,at,Ee,wa="La descripción se <strong>inyecta</strong> en el prompt del sistema. Tomando el ejemplo con el que comenzamos esta sección, así es como se vería después de reemplazar el <code>tools_description</code>:",st,_e,Ca,nt,Ge,Ia='En la sección <a href="actions.mdx">Acciones</a>, aprenderemos más sobre cómo un Agente puede <strong>Llamar</strong> a esta herramienta que acabamos de crear.',Mt,it,rt,qe,Aa="Las herramientas juegan un papel crucial en la mejora de las capacidades de los agentes de IA.",ot,He,ba="Para resumir, aprendimos:",pt,Le,ha="<li><p><em>Qué son las Herramientas</em>: Funciones que dan a los LLMs capacidades adicionales, como realizar cálculos o acceder a datos externos.</p></li> <li><p><em>Cómo Definir una Herramienta</em>: Proporcionando una descripción textual clara, entradas, salidas y una función invocable.</p></li> <li><p><em>Por qué las Herramientas son Esenciales</em>: Permiten a los Agentes superar las limitaciones del entrenamiento estático del modelo, manejar tareas en tiempo real y realizar acciones especializadas.</p></li>",ut,Ze,fa='Ahora, podemos pasar al <a href="agent-steps-and-structure.mdx">Flujo de Trabajo del Agente</a> donde verás cómo un Agente observa, piensa y actúa. Esto <strong>reúne todo lo que hemos cubierto hasta ahora</strong> y prepara el escenario para crear tu propio Agente de IA completamente funcional.',mt,Se,va="Pero primero, ¡es hora de otro cuestionario corto!",ct,We,jt,Qe,yt;return T=new $e({props:{title:"¿Qué son las Herramientas?",local:"qué-son-las-herramientas",headingTag:"h1"}}),b=new $e({props:{title:"¿Qué son las Herramientas de IA?",local:"qué-son-las-herramientas-de-ia",headingTag:"h2"}}),H=new $e({props:{title:"¿Cómo funcionan las herramientas?",local:"cómo-funcionan-las-herramientas",headingTag:"h2"}}),W=new $e({props:{title:"¿Cómo proporcionamos herramientas a un LLM?",local:"cómo-proporcionamos-herramientas-a-un-llm",headingTag:"h2"}}),R=new U({props:{code:"ZGVmJTIwY2FsY3VsYWRvcmEoYSUzQSUyMGludCUyQyUyMGIlM0ElMjBpbnQpJTIwLSUzRSUyMGludCUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMk11bHRpcGxpY2ElMjBkb3MlMjBlbnRlcm9zLiUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGElMjAqJTIwYg==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculadora</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiplica dos enteros.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b`,wrap:!1}}),O=new U({props:{code:"Tm9tYnJlJTIwZGUlMjBIZXJyYW1pZW50YSUzQSUyMGNhbGN1bGFkb3JhJTJDJTIwRGVzY3JpcGNpJUMzJUIzbiUzQSUyME11bHRpcGxpY2ElMjBkb3MlMjBlbnRlcm9zLiUyQyUyMEFyZ3VtZW50b3MlM0ElMjBhJTNBJTIwaW50JTJDJTIwYiUzQSUyMGludCUyQyUyMFNhbGlkYXMlM0ElMjBpbnQ=",highlighted:"Nombre de Herramienta: calculadora, Descripción: Multiplica dos enteros., Argumentos: a: int, b: int, Salidas: int",wrap:!1}}),se=new $e({props:{title:"Auto-formateo de secciones de Herramientas",local:"auto-formateo-de-secciones-de-herramientas",headingTag:"h3"}}),ue=new U({props:{code:"JTQwdG9vbCUwQWRlZiUyMGNhbGN1bGFkb3JhKGElM0ElMjBpbnQlMkMlMjBiJTNBJTIwaW50KSUyMC0lM0UlMjBpbnQlM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJNdWx0aXBsaWNhJTIwZG9zJTIwZW50ZXJvcy4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBhJTIwKiUyMGIlMEElMEFwcmludChjYWxjdWxhZG9yYS50b19zdHJpbmcoKSk=",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculadora</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiplica dos enteros.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

<span class="hljs-built_in">print</span>(calculadora.to_string())`,wrap:!1}}),je=new U({props:{code:"Tm9tYnJlJTIwZGUlMjBIZXJyYW1pZW50YSUzQSUyMGNhbGN1bGFkb3JhJTJDJTIwRGVzY3JpcGNpJUMzJUIzbiUzQSUyME11bHRpcGxpY2ElMjBkb3MlMjBlbnRlcm9zLiUyQyUyMEFyZ3VtZW50b3MlM0ElMjBhJTNBJTIwaW50JTJDJTIwYiUzQSUyMGludCUyQyUyMFNhbGlkYXMlM0ElMjBpbnQ=",highlighted:"Nombre de Herramienta: calculadora, Descripción: Multiplica dos enteros., Argumentos: a: int, b: int, Salidas: int",wrap:!1}}),de=new $e({props:{title:"Implementación genérica de Herramienta",local:"implementación-genérica-de-herramienta",headingTag:"h3"}}),Te=new U({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">Tool</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Una clase que representa un fragmento de código reutilizable (Herramienta).
    
    Atributos:
        name (str): Nombre de la herramienta.
        description (str): Una descripción textual de lo que hace la herramienta.
        func (callable): La función que esta herramienta envuelve.
        arguments (list): Una lista de argumentos.
        outputs (str or list): El tipo(s) de retorno de la función envuelta.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, 
                 name: <span class="hljs-built_in">str</span>, 
                 description: <span class="hljs-built_in">str</span>, 
                 func: <span class="hljs-built_in">callable</span>, 
                 arguments: <span class="hljs-built_in">list</span>,
                 outputs: <span class="hljs-built_in">str</span></span>):
        self.name = name
        self.description = description
        self.func = func
        self.arguments = arguments
        self.outputs = outputs

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">to_string</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-string">&quot;&quot;&quot;
        Devuelve una representación en cadena de la herramienta, 
        incluyendo su nombre, descripción, argumentos y salidas.
        &quot;&quot;&quot;</span>
        args_str = <span class="hljs-string">&quot;, &quot;</span>.join([
            <span class="hljs-string">f&quot;<span class="hljs-subst">{arg_name}</span>: <span class="hljs-subst">{arg_type}</span>&quot;</span> <span class="hljs-keyword">for</span> arg_name, arg_type <span class="hljs-keyword">in</span> self.arguments
        ])
        
        <span class="hljs-keyword">return</span> (
            <span class="hljs-string">f&quot;Nombre de Herramienta: <span class="hljs-subst">{self.name}</span>,&quot;</span>
            <span class="hljs-string">f&quot; Descripción: <span class="hljs-subst">{self.description}</span>,&quot;</span>
            <span class="hljs-string">f&quot; Argumentos: <span class="hljs-subst">{args_str}</span>,&quot;</span>
            <span class="hljs-string">f&quot; Salidas: <span class="hljs-subst">{self.outputs}</span>&quot;</span>
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, *args, **kwargs</span>):
        <span class="hljs-string">&quot;&quot;&quot;
        Invoca la función subyacente (callable) con los argumentos proporcionados.
        &quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> self.func(*args, **kwargs)`,wrap:!1}}),Ae=new U({props:{code:"Y2FsY3VsYWRvcmFfdG9vbCUyMCUzRCUyMFRvb2woJTBBJTIwJTIwJTIwJTIwJTIyY2FsY3VsYWRvcmElMjIlMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBub21icmUlMEElMjAlMjAlMjAlMjAlMjJNdWx0aXBsaWNhJTIwZG9zJTIwZW50ZXJvcy4lMjIlMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBkZXNjcmlwY2klQzMlQjNuJTBBJTIwJTIwJTIwJTIwY2FsY3VsYWRvcmElMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBmdW5jaSVDMyVCM24lMjBhJTIwbGxhbWFyJTBBJTIwJTIwJTIwJTIwJTVCKCUyMmElMjIlMkMlMjAlMjJpbnQlMjIpJTJDJTIwKCUyMmIlMjIlMkMlMjAlMjJpbnQlMjIpJTVEJTJDJTIwJTIwJTIwJTIzJTIwZW50cmFkYXMlMjAobm9tYnJlcyUyMHklMjB0aXBvcyklMEElMjAlMjAlMjAlMjAlMjJpbnQlMjIlMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBzYWxpZGElMEEp",highlighted:`calculadora_tool = Tool(
    <span class="hljs-string">&quot;calculadora&quot;</span>,                   <span class="hljs-comment"># nombre</span>
    <span class="hljs-string">&quot;Multiplica dos enteros.&quot;</span>,       <span class="hljs-comment"># descripción</span>
    calculadora,                     <span class="hljs-comment"># función a llamar</span>
    [(<span class="hljs-string">&quot;a&quot;</span>, <span class="hljs-string">&quot;int&quot;</span>), (<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;int&quot;</span>)],   <span class="hljs-comment"># entradas (nombres y tipos)</span>
    <span class="hljs-string">&quot;int&quot;</span>,                          <span class="hljs-comment"># salida</span>
)`,wrap:!1}}),fe=new U({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">tool</span>(<span class="hljs-params">func</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Un decorador que crea una instancia de Tool a partir de la función dada.
    &quot;&quot;&quot;</span>
    <span class="hljs-comment"># Obtener la firma de la función</span>
    signature = inspect.signature(func)
    
    <span class="hljs-comment"># Extraer pares (param_name, param_annotation) para entradas</span>
    arguments = []
    <span class="hljs-keyword">for</span> param <span class="hljs-keyword">in</span> signature.parameters.values():
        annotation_name = (
            param.annotation.__name__ 
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">hasattr</span>(param.annotation, <span class="hljs-string">&#x27;__name__&#x27;</span>) 
            <span class="hljs-keyword">else</span> <span class="hljs-built_in">str</span>(param.annotation)
        )
        arguments.append((param.name, annotation_name))
    
    <span class="hljs-comment"># Determinar la anotación de retorno</span>
    return_annotation = signature.return_annotation
    <span class="hljs-keyword">if</span> return_annotation <span class="hljs-keyword">is</span> inspect._empty:
        outputs = <span class="hljs-string">&quot;Sin anotación de retorno&quot;</span>
    <span class="hljs-keyword">else</span>:
        outputs = (
            return_annotation.__name__ 
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">hasattr</span>(return_annotation, <span class="hljs-string">&#x27;__name__&#x27;</span>) 
            <span class="hljs-keyword">else</span> <span class="hljs-built_in">str</span>(return_annotation)
        )
    
    <span class="hljs-comment"># Usar el docstring de la función como descripción (por defecto si es None)</span>
    description = func.__doc__ <span class="hljs-keyword">or</span> <span class="hljs-string">&quot;No se proporcionó descripción.&quot;</span>
    
    <span class="hljs-comment"># El nombre de la función se convierte en el nombre de la Herramienta</span>
    name = func.__name__
    
    <span class="hljs-comment"># Devolver una nueva instancia de Tool</span>
    <span class="hljs-keyword">return</span> Tool(
        name=name, 
        description=description, 
        func=func, 
        arguments=arguments, 
        outputs=outputs
    )`,wrap:!1}}),Be=new U({props:{code:"JTQwdG9vbCUwQWRlZiUyMGNhbGN1bGFkb3JhKGElM0ElMjBpbnQlMkMlMjBiJTNBJTIwaW50KSUyMC0lM0UlMjBpbnQlM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJNdWx0aXBsaWNhJTIwZG9zJTIwZW50ZXJvcy4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBhJTIwKiUyMGIlMEElMEFwcmludChjYWxjdWxhZG9yYS50b19zdHJpbmcoKSk=",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculadora</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiplica dos enteros.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

<span class="hljs-built_in">print</span>(calculadora.to_string())`,wrap:!1}}),xe=new U({props:{code:"Tm9tYnJlJTIwZGUlMjBIZXJyYW1pZW50YSUzQSUyMGNhbGN1bGFkb3JhJTJDJTIwRGVzY3JpcGNpJUMzJUIzbiUzQSUyME11bHRpcGxpY2ElMjBkb3MlMjBlbnRlcm9zLiUyQyUyMEFyZ3VtZW50b3MlM0ElMjBhJTNBJTIwaW50JTJDJTIwYiUzQSUyMGludCUyQyUyMFNhbGlkYXMlM0ElMjBpbnQ=",highlighted:"Nombre de Herramienta: calculadora, Descripción: Multiplica dos enteros., Argumentos: a: int, b: int, Salidas: int",wrap:!1}}),We=new qa({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/es/unit1/tools.mdx"}}),{c(){d=M("meta"),ke=s(),ze=M("p"),Ve=s(),o(T.$$.fragment),Ne=s(),w=M("img"),Re=s(),C=M("p"),C.innerHTML=At,Xe=s(),I=M("p"),I.textContent=bt,Fe=s(),A=M("p"),A.textContent=ht,Pe=s(),o(b.$$.fragment),Ke=s(),h=M("p"),h.innerHTML=ft,De=s(),f=M("p"),f.textContent=vt,Oe=s(),v=M("table"),v.innerHTML=Bt,el=s(),B=M("p"),B.textContent=gt,ll=s(),g=M("p"),g.innerHTML=xt,tl=s(),x=M("p"),x.innerHTML=Et,al=s(),E=M("p"),E.innerHTML=_t,sl=s(),_=M("p"),_.textContent=Gt,nl=s(),G=M("img"),Ml=s(),q=M("ul"),q.innerHTML=Ht,il=s(),o(H.$$.fragment),rl=s(),L=M("p"),L.innerHTML=Lt,ol=s(),Z=M("p"),Z.innerHTML=Zt,pl=s(),S=M("p"),S.textContent=St,ul=s(),o(W.$$.fragment),ml=s(),Y=M("p"),Y.textContent=Wt,cl=s(),$=M("img"),jl=s(),z=M("p"),z.textContent=$t,yl=s(),Q=M("ol"),Q.innerHTML=zt,dl=s(),k=M("p"),k.innerHTML=Qt,Ul=s(),V=M("p"),V.textContent=kt,Jl=s(),N=M("p"),N.innerHTML=Vt,Tl=s(),o(R.$$.fragment),wl=s(),X=M("p"),X.innerHTML=Nt,Cl=s(),F=M("ul"),F.innerHTML=Rt,Il=s(),P=M("p"),P.textContent=Xt,Al=s(),K=M("ul"),K.innerHTML=Ft,bl=s(),D=M("p"),D.textContent=Pt,hl=s(),o(O.$$.fragment),fl=s(),ee=M("blockquote"),ee.innerHTML=Kt,vl=s(),le=M("p"),le.textContent=Dt,Bl=s(),te=M("p"),te.textContent=Ot,gl=s(),ae=M("p"),ae.textContent=ea,xl=s(),o(se.$$.fragment),El=s(),ne=M("p"),ne.textContent=la,_l=s(),Me=M("ul"),Me.innerHTML=ta,Gl=s(),ie=M("p"),ie.textContent=aa,ql=s(),re=M("p"),re.innerHTML=sa,Hl=s(),oe=M("p"),oe.textContent=na,Ll=s(),pe=M("p"),pe.innerHTML=Ma,Zl=s(),o(ue.$$.fragment),Sl=s(),me=M("p"),me.innerHTML=ia,Wl=s(),ce=M("p"),ce.innerHTML=ra,Yl=s(),o(je.$$.fragment),$l=s(),ye=M("p"),ye.textContent=oa,zl=s(),o(de.$$.fragment),Ql=s(),Ue=M("p"),Ue.innerHTML=pa,kl=s(),Je=M("blockquote"),Je.innerHTML=ua,Vl=s(),o(Te.$$.fragment),Nl=s(),we=M("p"),we.innerHTML=ma,Rl=s(),Ce=M("ul"),Ce.innerHTML=ca,Xl=s(),Ie=M("p"),Ie.textContent=ja,Fl=s(),o(Ae.$$.fragment),Pl=s(),be=M("p"),be.innerHTML=ya,Kl=s(),he=M("blockquote"),he.innerHTML=da,Dl=s(),J=M("details"),Ye=M("summary"),Ye.textContent=Ua,Jt=s(),o(fe.$$.fragment),Ol=s(),ve=M("p"),ve.textContent=Ja,et=s(),o(Be.$$.fragment),lt=s(),ge=M("p"),ge.innerHTML=Ta,tt=s(),o(xe.$$.fragment),at=s(),Ee=M("p"),Ee.innerHTML=wa,st=s(),_e=M("img"),nt=s(),Ge=M("p"),Ge.innerHTML=Ia,Mt=s(),it=M("hr"),rt=s(),qe=M("p"),qe.textContent=Aa,ot=s(),He=M("p"),He.textContent=ba,pt=s(),Le=M("ul"),Le.innerHTML=ha,ut=s(),Ze=M("p"),Ze.innerHTML=fa,mt=s(),Se=M("p"),Se.textContent=va,ct=s(),o(We.$$.fragment),jt=s(),Qe=M("p"),this.h()},l(e){const l=Ga("svelte-u9bgzb",document.head);d=i(l,"META",{name:!0,content:!0}),l.forEach(t),ke=n(e),ze=i(e,"P",{}),Tt(ze).forEach(t),Ve=n(e),p(T.$$.fragment,e),Ne=n(e),w=i(e,"IMG",{src:!0,alt:!0}),Re=n(e),C=i(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-11v5lbd"&&(C.innerHTML=At),Xe=n(e),I=i(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-yzryio"&&(I.textContent=bt),Fe=n(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-ldqc23"&&(A.textContent=ht),Pe=n(e),p(b.$$.fragment,e),Ke=n(e),h=i(e,"P",{"data-svelte-h":!0}),r(h)!=="svelte-3spete"&&(h.innerHTML=ft),De=n(e),f=i(e,"P",{"data-svelte-h":!0}),r(f)!=="svelte-19u4e87"&&(f.textContent=vt),Oe=n(e),v=i(e,"TABLE",{"data-svelte-h":!0}),r(v)!=="svelte-x2anqg"&&(v.innerHTML=Bt),el=n(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1rhr6un"&&(B.textContent=gt),ll=n(e),g=i(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1f5lua9"&&(g.innerHTML=xt),tl=n(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-axh2sd"&&(x.innerHTML=Et),al=n(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-uajc2b"&&(E.innerHTML=_t),sl=n(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-qgie3k"&&(_.textContent=Gt),nl=n(e),G=i(e,"IMG",{src:!0,alt:!0}),Ml=n(e),q=i(e,"UL",{"data-svelte-h":!0}),r(q)!=="svelte-nvr74z"&&(q.innerHTML=Ht),il=n(e),p(H.$$.fragment,e),rl=n(e),L=i(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1vf9x86"&&(L.innerHTML=Lt),ol=n(e),Z=i(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1jfsjsz"&&(Z.innerHTML=Zt),pl=n(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-w3s9nu"&&(S.textContent=St),ul=n(e),p(W.$$.fragment,e),ml=n(e),Y=i(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1iuucst"&&(Y.textContent=Wt),cl=n(e),$=i(e,"IMG",{src:!0,alt:!0}),jl=n(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1auxopn"&&(z.textContent=$t),yl=n(e),Q=i(e,"OL",{"data-svelte-h":!0}),r(Q)!=="svelte-nxsu3i"&&(Q.innerHTML=zt),dl=n(e),k=i(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-14ua9gl"&&(k.innerHTML=Qt),Ul=n(e),V=i(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1ruj9h1"&&(V.textContent=kt),Jl=n(e),N=i(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-50x2n7"&&(N.innerHTML=Vt),Tl=n(e),p(R.$$.fragment,e),wl=n(e),X=i(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1t933sx"&&(X.innerHTML=Nt),Cl=n(e),F=i(e,"UL",{"data-svelte-h":!0}),r(F)!=="svelte-1hgz7n1"&&(F.innerHTML=Rt),Il=n(e),P=i(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1p1ymq5"&&(P.textContent=Xt),Al=n(e),K=i(e,"UL",{"data-svelte-h":!0}),r(K)!=="svelte-x64alw"&&(K.innerHTML=Ft),bl=n(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-ogtujw"&&(D.textContent=Pt),hl=n(e),p(O.$$.fragment,e),fl=n(e),ee=i(e,"BLOCKQUOTE",{"data-svelte-h":!0}),r(ee)!=="svelte-jgxyv0"&&(ee.innerHTML=Kt),vl=n(e),le=i(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1simtbd"&&(le.textContent=Dt),Bl=n(e),te=i(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1f18wsz"&&(te.textContent=Ot),gl=n(e),ae=i(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1aeb213"&&(ae.textContent=ea),xl=n(e),p(se.$$.fragment,e),El=n(e),ne=i(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-umx0z8"&&(ne.textContent=la),_l=n(e),Me=i(e,"UL",{"data-svelte-h":!0}),r(Me)!=="svelte-4mn1a5"&&(Me.innerHTML=ta),Gl=n(e),ie=i(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1vcqfuv"&&(ie.textContent=aa),ql=n(e),re=i(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-14fd26j"&&(re.innerHTML=sa),Hl=n(e),oe=i(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-d1jwkz"&&(oe.textContent=na),Ll=n(e),pe=i(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-12rpj5d"&&(pe.innerHTML=Ma),Zl=n(e),p(ue.$$.fragment,e),Sl=n(e),me=i(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-sc3whw"&&(me.innerHTML=ia),Wl=n(e),ce=i(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-zq1sjc"&&(ce.innerHTML=ra),Yl=n(e),p(je.$$.fragment,e),$l=n(e),ye=i(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1nnyzya"&&(ye.textContent=oa),zl=n(e),p(de.$$.fragment,e),Ql=n(e),Ue=i(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-1ggdx7a"&&(Ue.innerHTML=pa),kl=n(e),Je=i(e,"BLOCKQUOTE",{"data-svelte-h":!0}),r(Je)!=="svelte-zpb818"&&(Je.innerHTML=ua),Vl=n(e),p(Te.$$.fragment,e),Nl=n(e),we=i(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1pqprji"&&(we.innerHTML=ma),Rl=n(e),Ce=i(e,"UL",{"data-svelte-h":!0}),r(Ce)!=="svelte-ndkw87"&&(Ce.innerHTML=ca),Xl=n(e),Ie=i(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-1342fh5"&&(Ie.textContent=ja),Fl=n(e),p(Ae.$$.fragment,e),Pl=n(e),be=i(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-n2m443"&&(be.innerHTML=ya),Kl=n(e),he=i(e,"BLOCKQUOTE",{"data-svelte-h":!0}),r(he)!=="svelte-uzxbeb"&&(he.innerHTML=da),Dl=n(e),J=i(e,"DETAILS",{});var dt=Tt(J);Ye=i(dt,"SUMMARY",{"data-svelte-h":!0}),r(Ye)!=="svelte-1u34veb"&&(Ye.textContent=Ua),Jt=n(dt),p(fe.$$.fragment,dt),dt.forEach(t),Ol=n(e),ve=i(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-i0tl7x"&&(ve.textContent=Ja),et=n(e),p(Be.$$.fragment,e),lt=n(e),ge=i(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-ovqblh"&&(ge.innerHTML=Ta),tt=n(e),p(xe.$$.fragment,e),at=n(e),Ee=i(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-gdec90"&&(Ee.innerHTML=wa),st=n(e),_e=i(e,"IMG",{src:!0,alt:!0}),nt=n(e),Ge=i(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-1n9jyyn"&&(Ge.innerHTML=Ia),Mt=n(e),it=i(e,"HR",{}),rt=n(e),qe=i(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-1ezmtbd"&&(qe.textContent=Aa),ot=n(e),He=i(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-2xuet7"&&(He.textContent=ba),pt=n(e),Le=i(e,"UL",{"data-svelte-h":!0}),r(Le)!=="svelte-1m3sl14"&&(Le.innerHTML=ha),ut=n(e),Ze=i(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-1rb6wl2"&&(Ze.innerHTML=fa),mt=n(e),Se=i(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-1u8pkw1"&&(Se.textContent=va),ct=n(e),p(We.$$.fragment,e),jt=n(e),Qe=i(e,"P",{}),Tt(Qe).forEach(t),this.h()},h(){y(d,"name","hf:doc:metadata"),y(d,"content",La),Ut(w.src,It="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/whiteboard-check-2.jpg")||y(w,"src",It),y(w,"alt","Planificación de la Unidad 1"),Ut(G.src,qt="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/weather.jpg")||y(G,"src",qt),y(G,"alt","Clima"),Ut($.src,Yt="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/Agent_system_prompt.png")||y($,"src",Yt),y($,"alt","Prompt del sistema para herramientas"),Ut(_e.src,Ca="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/Agent_system_prompt_tools.png")||y(_e,"src",Ca),y(_e,"alt","Prompt del sistema para herramientas")},m(e,l){wt(document.head,d),a(e,ke,l),a(e,ze,l),a(e,Ve,l),u(T,e,l),a(e,Ne,l),a(e,w,l),a(e,Re,l),a(e,C,l),a(e,Xe,l),a(e,I,l),a(e,Fe,l),a(e,A,l),a(e,Pe,l),u(b,e,l),a(e,Ke,l),a(e,h,l),a(e,De,l),a(e,f,l),a(e,Oe,l),a(e,v,l),a(e,el,l),a(e,B,l),a(e,ll,l),a(e,g,l),a(e,tl,l),a(e,x,l),a(e,al,l),a(e,E,l),a(e,sl,l),a(e,_,l),a(e,nl,l),a(e,G,l),a(e,Ml,l),a(e,q,l),a(e,il,l),u(H,e,l),a(e,rl,l),a(e,L,l),a(e,ol,l),a(e,Z,l),a(e,pl,l),a(e,S,l),a(e,ul,l),u(W,e,l),a(e,ml,l),a(e,Y,l),a(e,cl,l),a(e,$,l),a(e,jl,l),a(e,z,l),a(e,yl,l),a(e,Q,l),a(e,dl,l),a(e,k,l),a(e,Ul,l),a(e,V,l),a(e,Jl,l),a(e,N,l),a(e,Tl,l),u(R,e,l),a(e,wl,l),a(e,X,l),a(e,Cl,l),a(e,F,l),a(e,Il,l),a(e,P,l),a(e,Al,l),a(e,K,l),a(e,bl,l),a(e,D,l),a(e,hl,l),u(O,e,l),a(e,fl,l),a(e,ee,l),a(e,vl,l),a(e,le,l),a(e,Bl,l),a(e,te,l),a(e,gl,l),a(e,ae,l),a(e,xl,l),u(se,e,l),a(e,El,l),a(e,ne,l),a(e,_l,l),a(e,Me,l),a(e,Gl,l),a(e,ie,l),a(e,ql,l),a(e,re,l),a(e,Hl,l),a(e,oe,l),a(e,Ll,l),a(e,pe,l),a(e,Zl,l),u(ue,e,l),a(e,Sl,l),a(e,me,l),a(e,Wl,l),a(e,ce,l),a(e,Yl,l),u(je,e,l),a(e,$l,l),a(e,ye,l),a(e,zl,l),u(de,e,l),a(e,Ql,l),a(e,Ue,l),a(e,kl,l),a(e,Je,l),a(e,Vl,l),u(Te,e,l),a(e,Nl,l),a(e,we,l),a(e,Rl,l),a(e,Ce,l),a(e,Xl,l),a(e,Ie,l),a(e,Fl,l),u(Ae,e,l),a(e,Pl,l),a(e,be,l),a(e,Kl,l),a(e,he,l),a(e,Dl,l),a(e,J,l),wt(J,Ye),wt(J,Jt),u(fe,J,null),a(e,Ol,l),a(e,ve,l),a(e,et,l),u(Be,e,l),a(e,lt,l),a(e,ge,l),a(e,tt,l),u(xe,e,l),a(e,at,l),a(e,Ee,l),a(e,st,l),a(e,_e,l),a(e,nt,l),a(e,Ge,l),a(e,Mt,l),a(e,it,l),a(e,rt,l),a(e,qe,l),a(e,ot,l),a(e,He,l),a(e,pt,l),a(e,Le,l),a(e,ut,l),a(e,Ze,l),a(e,mt,l),a(e,Se,l),a(e,ct,l),u(We,e,l),a(e,jt,l),a(e,Qe,l),yt=!0},p:ga,i(e){yt||(m(T.$$.fragment,e),m(b.$$.fragment,e),m(H.$$.fragment,e),m(W.$$.fragment,e),m(R.$$.fragment,e),m(O.$$.fragment,e),m(se.$$.fragment,e),m(ue.$$.fragment,e),m(je.$$.fragment,e),m(de.$$.fragment,e),m(Te.$$.fragment,e),m(Ae.$$.fragment,e),m(fe.$$.fragment,e),m(Be.$$.fragment,e),m(xe.$$.fragment,e),m(We.$$.fragment,e),yt=!0)},o(e){c(T.$$.fragment,e),c(b.$$.fragment,e),c(H.$$.fragment,e),c(W.$$.fragment,e),c(R.$$.fragment,e),c(O.$$.fragment,e),c(se.$$.fragment,e),c(ue.$$.fragment,e),c(je.$$.fragment,e),c(de.$$.fragment,e),c(Te.$$.fragment,e),c(Ae.$$.fragment,e),c(fe.$$.fragment,e),c(Be.$$.fragment,e),c(xe.$$.fragment,e),c(We.$$.fragment,e),yt=!1},d(e){e&&(t(ke),t(ze),t(Ve),t(Ne),t(w),t(Re),t(C),t(Xe),t(I),t(Fe),t(A),t(Pe),t(Ke),t(h),t(De),t(f),t(Oe),t(v),t(el),t(B),t(ll),t(g),t(tl),t(x),t(al),t(E),t(sl),t(_),t(nl),t(G),t(Ml),t(q),t(il),t(rl),t(L),t(ol),t(Z),t(pl),t(S),t(ul),t(ml),t(Y),t(cl),t($),t(jl),t(z),t(yl),t(Q),t(dl),t(k),t(Ul),t(V),t(Jl),t(N),t(Tl),t(wl),t(X),t(Cl),t(F),t(Il),t(P),t(Al),t(K),t(bl),t(D),t(hl),t(fl),t(ee),t(vl),t(le),t(Bl),t(te),t(gl),t(ae),t(xl),t(El),t(ne),t(_l),t(Me),t(Gl),t(ie),t(ql),t(re),t(Hl),t(oe),t(Ll),t(pe),t(Zl),t(Sl),t(me),t(Wl),t(ce),t(Yl),t($l),t(ye),t(zl),t(Ql),t(Ue),t(kl),t(Je),t(Vl),t(Nl),t(we),t(Rl),t(Ce),t(Xl),t(Ie),t(Fl),t(Pl),t(be),t(Kl),t(he),t(Dl),t(J),t(Ol),t(ve),t(et),t(lt),t(ge),t(tt),t(at),t(Ee),t(st),t(_e),t(nt),t(Ge),t(Mt),t(it),t(rt),t(qe),t(ot),t(He),t(pt),t(Le),t(ut),t(Ze),t(mt),t(Se),t(ct),t(jt),t(Qe)),t(d),j(T,e),j(b,e),j(H,e),j(W,e),j(R,e),j(O,e),j(se,e),j(ue,e),j(je,e),j(de,e),j(Te,e),j(Ae,e),j(fe),j(Be,e),j(xe,e),j(We,e)}}}const La='{"title":"¿Qué son las Herramientas?","local":"qué-son-las-herramientas","sections":[{"title":"¿Qué son las Herramientas de IA?","local":"qué-son-las-herramientas-de-ia","sections":[],"depth":2},{"title":"¿Cómo funcionan las herramientas?","local":"cómo-funcionan-las-herramientas","sections":[],"depth":2},{"title":"¿Cómo proporcionamos herramientas a un LLM?","local":"cómo-proporcionamos-herramientas-a-un-llm","sections":[{"title":"Auto-formateo de secciones de Herramientas","local":"auto-formateo-de-secciones-de-herramientas","sections":[],"depth":3},{"title":"Implementación genérica de Herramienta","local":"implementación-genérica-de-herramienta","sections":[],"depth":3}],"depth":2}],"depth":1}';function Za(Ct){return xa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Qa extends Ea{constructor(d){super(),_a(this,d,Za,Ha,Ba,{})}}export{Qa as component};
