import{s as qt,f as Et,n as _t,o as $t}from"../chunks/scheduler.37c15a92.js";import{S as Lt,i as Ht,g as i,s as l,r as Q,A as Bt,h as o,f as a,c as s,j as Ut,u as F,x as r,k as O,y as Nt,a as n,v as D,d as K,t as ee,w as te}from"../chunks/index.2bf4358c.js";import{C as At}from"../chunks/CodeBlock.4e987730.js";import{H as Ye}from"../chunks/Heading.8ada512a.js";import{E as zt}from"../chunks/getInferenceSnippets.0aa3753f.js";function Gt(Qe){let u,le,ae,se,m,ie,c,Fe="<p>En esta sección, exploramos los pasos concretos que un agente de IA toma para interactuar con su entorno.</p> <p>Cubriremos cómo se representan las acciones (usando JSON o código), la importancia del enfoque de detener y analizar, e introduciremos diferentes tipos de agentes.</p>",oe,f,Oe="Las acciones son los pasos concretos que un <strong>agente de IA toma para interactuar con su entorno</strong>.",re,M,De="Ya sea navegando por la web en busca de información o controlando un dispositivo físico, cada acción es una operación deliberada ejecutada por el agente.",ue,y,Ke="Por ejemplo, un agente que asiste con servicio al cliente podría recuperar datos del cliente, ofrecer artículos de soporte o transferir problemas a un representante humano.",ce,g,pe,T,et="Hay múltiples tipos de Agentes que realizan acciones de manera diferente:",de,v,tt="<thead><tr><th>Tipo de Agente</th> <th>Descripción</th></tr></thead> <tbody><tr><td>Agente JSON</td> <td>La Acción a tomar se especifica en formato JSON.</td></tr> <tr><td>Agente de Código</td> <td>El Agente escribe un bloque de código que es interpretado externamente.</td></tr> <tr><td>Agente de llamada a funciones</td> <td>Es una subcategoría del Agente JSON que ha sido ajustado para generar un nuevo mensaje para cada acción.</td></tr></tbody>",me,j,at="Las acciones en sí pueden servir para muchos propósitos:",fe,J,nt="<thead><tr><th>Tipo de Acción</th> <th>Descripción</th></tr></thead> <tbody><tr><td>Recopilación de Información</td> <td>Realizar búsquedas web, consultar bases de datos o recuperar documentos.</td></tr> <tr><td>Uso de Herramientas</td> <td>Hacer llamadas a API, realizar cálculos y ejecutar código.</td></tr> <tr><td>Interacción con el Entorno</td> <td>Manipular interfaces digitales o controlar dispositivos físicos.</td></tr> <tr><td>Comunicación</td> <td>Interactuar con usuarios a través de chat o colaborar con otros agentes.</td></tr></tbody>",Me,C,lt="Una parte crucial de un agente es la <strong>capacidad de DETENER la generación de nuevos tokens cuando una acción está completa</strong>, y eso es cierto para todos los formatos de Agente: JSON, código o llamada a funciones. Esto previene la salida no intencionada y asegura que la respuesta del agente sea clara y precisa.",ye,w,st="El LLM solo maneja texto y lo usa para describir la acción que quiere tomar y los parámetros a suministrar a la herramienta.",ge,b,Te,x,it="Un método clave para implementar acciones es el <strong>enfoque de detener y analizar</strong>. Este método asegura que la salida del agente sea estructurada y predecible:",ve,h,ot="<li><strong>Generación en un Formato Estructurado</strong>:</li>",je,I,rt="El agente produce su acción prevista en un formato claro y predeterminado (JSON o código).",Je,p,ut="<li><strong>Deteniendo la Generación Adicional</strong>:</li>",Ce,U,ct="Una vez que la acción está completa, <strong>el agente deja de generar tokens adicionales</strong>. Esto previene salidas adicionales o erróneas.",we,d,pt="<li><strong>Analizando la Salida</strong>:</li>",be,A,dt="Un analizador externo lee la acción formateada, determina qué Herramienta llamar y extrae los parámetros requeridos.",xe,q,mt="Por ejemplo, un agente que necesita verificar el clima podría producir:",he,E,Ie,_,ft="El framework puede entonces analizar fácilmente el nombre de la función a llamar y los argumentos a aplicar.",Ue,$,Mt="Este formato claro y legible por máquina minimiza errores y permite que herramientas externas procesen con precisión el comando del agente.",Ae,L,yt=`Nota: Los agentes de llamada a funciones operan de manera similar estructurando cada acción para que una función designada sea invocada con los argumentos correctos.
Profundizaremos en esos tipos de Agentes en una Unidad futura.`,qe,H,Ee,B,gt=`Un enfoque alternativo es usar <em>Agentes de Código</em>.
La idea es: <strong>en lugar de producir un simple objeto JSON</strong>, un Agente de Código genera un <strong>bloque de código ejecutable—típicamente en un lenguaje de alto nivel como Python</strong>.`,_e,N,Tt,$e,z,vt="Este enfoque ofrece varias ventajas:",Le,G,jt="<li><strong>Expresividad:</strong> El código puede representar naturalmente lógica compleja, incluyendo bucles, condicionales y funciones anidadas, proporcionando mayor flexibilidad que JSON.</li> <li><strong>Modularidad y Reusabilidad:</strong> El código generado puede incluir funciones y módulos que son reutilizables a través de diferentes acciones o tareas.</li> <li><strong>Depuración Mejorada:</strong> Con una sintaxis de programación bien definida, los errores de código son a menudo más fáciles de detectar y corregir.</li> <li><strong>Integración Directa:</strong> Los Agentes de Código pueden integrarse directamente con bibliotecas y APIs externas, permitiendo operaciones más complejas como procesamiento de datos o toma de decisiones en tiempo real.</li>",He,P,Jt="Por ejemplo, un Agente de Código encargado de obtener el clima podría generar el siguiente fragmento de Python:",Be,k,Ne,S,Ct="En este ejemplo, el Agente de Código:",ze,Z,wt="<li>Recupera datos del clima <strong>a través de una llamada a API</strong>,</li> <li>Procesa la respuesta,</li> <li>Y usa la función print() para producir una respuesta final.</li>",Ge,W,bt="Este método <strong>también sigue el enfoque de detener y analizar</strong> delimitando claramente el bloque de código y señalando cuando la ejecución está completa (aquí, imprimiendo el final_answer).",Pe,ke,Se,R,xt="Aprendimos que las Acciones conectan el razonamiento interno de un agente y sus interacciones con el mundo real ejecutando tareas claras y estructuradas—ya sea a través de JSON, código o llamadas a funciones.",Ze,X,ht="Esta ejecución deliberada asegura que cada acción sea precisa y esté lista para el procesamiento externo a través del enfoque de detener y analizar. En la siguiente sección, exploraremos las Observaciones para ver cómo los agentes capturan e integran retroalimentación de su entorno.",We,V,It="Después de esto, ¡<strong>finalmente estaremos listos para construir nuestro primer Agente</strong>!",Re,Y,Xe,ne,Ve;return m=new Ye({props:{title:"Acciones: Permitiendo al Agente Interactuar con Su Entorno",local:"acciones-permitiendo-al-agente-interactuar-con-su-entorno",headingTag:"h1"}}),g=new Ye({props:{title:"Tipos de Acciones de Agentes",local:"tipos-de-acciones-de-agentes",headingTag:"h2"}}),b=new Ye({props:{title:"El Enfoque de Detener y Analizar",local:"el-enfoque-de-detener-y-analizar",headingTag:"h2"}}),E=new At({props:{code:"VGhvdWdodCUzQSUyME5lY2VzaXRvJTIwdmVyaWZpY2FyJTIwZWwlMjBjbGltYSUyMGFjdHVhbCUyMHBhcmElMjBOdWV2YSUyMFlvcmsuJTBBQWN0aW9uJTIwJTNBJTBBJTdCJTBBJTIwJTIwJTIyYWN0aW9uJTIyJTNBJTIwJTIyZ2V0X3dlYXRoZXIlMjIlMkMlMEElMjAlMjAlMjJhY3Rpb25faW5wdXQlMjIlM0ElMjAlN0IlMjJsb2NhdGlvbiUyMiUzQSUyMCUyMk51ZXZhJTIwWW9yayUyMiU3RCUwQSU3RA==",highlighted:`Thought<span class="hljs-punctuation">:</span> Necesito verificar el clima actual para Nueva York.
Action <span class="hljs-punctuation">:</span>
<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;action&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;get_weather&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;action_input&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;location&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Nueva York&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),H=new Ye({props:{title:"Agentes de Código",local:"agentes-de-código",headingTag:"h2"}}),k=new At({props:{code:"JTIzJTIwRWplbXBsbyUyMGRlJTIwQWdlbnRlJTIwZGUlMjBDJUMzJUIzZGlnbyUzQSUyMFJlY3VwZXJhciUyMEluZm9ybWFjaSVDMyVCM24lMjBkZWwlMjBDbGltYSUwQWRlZiUyMGdldF93ZWF0aGVyKGNpdHkpJTNBJTBBJTIwJTIwJTIwJTIwaW1wb3J0JTIwcmVxdWVzdHMlMEElMjAlMjAlMjAlMjBhcGlfdXJsJTIwJTNEJTIwZiUyMmh0dHBzJTNBJTJGJTJGYXBpLndlYXRoZXIuY29tJTJGdjElMkZsb2NhdGlvbiUyRiU3QmNpdHklN0QlM0ZhcGlLZXklM0RZT1VSX0FQSV9LRVklMjIlMEElMjAlMjAlMjAlMjByZXNwb25zZSUyMCUzRCUyMHJlcXVlc3RzLmdldChhcGlfdXJsKSUwQSUyMCUyMCUyMCUyMGlmJTIwcmVzcG9uc2Uuc3RhdHVzX2NvZGUlMjAlM0QlM0QlMjAyMDAlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkYXRhJTIwJTNEJTIwcmVzcG9uc2UuanNvbigpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwZGF0YS5nZXQoJTIyd2VhdGhlciUyMiUyQyUyMCUyMk5vJTIwaGF5JTIwaW5mb3JtYWNpJUMzJUIzbiUyMGRlbCUyMGNsaW1hJTIwZGlzcG9uaWJsZSUyMiklMEElMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIyRXJyb3IlM0ElMjBObyUyMHNlJTIwcHVkbyUyMG9idGVuZXIlMjBkYXRvcyUyMGRlbCUyMGNsaW1hLiUyMiUwQSUwQSUyMyUyMEVqZWN1dGFyJTIwbGElMjBmdW5jaSVDMyVCM24lMjB5JTIwcHJlcGFyYXIlMjBsYSUyMHJlc3B1ZXN0YSUyMGZpbmFsJTBBcmVzdWx0JTIwJTNEJTIwZ2V0X3dlYXRoZXIoJTIyTnVldmElMjBZb3JrJTIyKSUwQWZpbmFsX2Fuc3dlciUyMCUzRCUyMGYlMjJFbCUyMGNsaW1hJTIwYWN0dWFsJTIwZW4lMjBOdWV2YSUyMFlvcmslMjBlcyUzQSUyMCU3QnJlc3VsdCU3RCUyMiUwQXByaW50KGZpbmFsX2Fuc3dlcik=",highlighted:`<span class="hljs-comment"># Ejemplo de Agente de Código: Recuperar Información del Clima</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_weather</span>(<span class="hljs-params">city</span>):
    <span class="hljs-keyword">import</span> requests
    api_url = <span class="hljs-string">f&quot;https://api.weather.com/v1/location/<span class="hljs-subst">{city}</span>?apiKey=YOUR_API_KEY&quot;</span>
    response = requests.get(api_url)
    <span class="hljs-keyword">if</span> response.status_code == <span class="hljs-number">200</span>:
        data = response.json()
        <span class="hljs-keyword">return</span> data.get(<span class="hljs-string">&quot;weather&quot;</span>, <span class="hljs-string">&quot;No hay información del clima disponible&quot;</span>)
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Error: No se pudo obtener datos del clima.&quot;</span>

<span class="hljs-comment"># Ejecutar la función y preparar la respuesta final</span>
result = get_weather(<span class="hljs-string">&quot;Nueva York&quot;</span>)
final_answer = <span class="hljs-string">f&quot;El clima actual en Nueva York es: <span class="hljs-subst">{result}</span>&quot;</span>
<span class="hljs-built_in">print</span>(final_answer)`,wrap:!1}}),Y=new zt({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/es/unit1/actions.mdx"}}),{c(){u=i("meta"),le=l(),ae=i("p"),se=l(),Q(m.$$.fragment),ie=l(),c=i("blockquote"),c.innerHTML=Fe,oe=l(),f=i("p"),f.innerHTML=Oe,re=l(),M=i("p"),M.textContent=De,ue=l(),y=i("p"),y.textContent=Ke,ce=l(),Q(g.$$.fragment),pe=l(),T=i("p"),T.textContent=et,de=l(),v=i("table"),v.innerHTML=tt,me=l(),j=i("p"),j.textContent=at,fe=l(),J=i("table"),J.innerHTML=nt,Me=l(),C=i("p"),C.innerHTML=lt,ye=l(),w=i("p"),w.textContent=st,ge=l(),Q(b.$$.fragment),Te=l(),x=i("p"),x.innerHTML=it,ve=l(),h=i("ol"),h.innerHTML=ot,je=l(),I=i("p"),I.textContent=rt,Je=l(),p=i("ol"),p.innerHTML=ut,Ce=l(),U=i("p"),U.innerHTML=ct,we=l(),d=i("ol"),d.innerHTML=pt,be=l(),A=i("p"),A.textContent=dt,xe=l(),q=i("p"),q.textContent=mt,he=l(),Q(E.$$.fragment),Ie=l(),_=i("p"),_.textContent=ft,Ue=l(),$=i("p"),$.textContent=Mt,Ae=l(),L=i("p"),L.textContent=yt,qe=l(),Q(H.$$.fragment),Ee=l(),B=i("p"),B.innerHTML=gt,_e=l(),N=i("img"),$e=l(),z=i("p"),z.textContent=vt,Le=l(),G=i("ul"),G.innerHTML=jt,He=l(),P=i("p"),P.textContent=Jt,Be=l(),Q(k.$$.fragment),Ne=l(),S=i("p"),S.textContent=Ct,ze=l(),Z=i("ul"),Z.innerHTML=wt,Ge=l(),W=i("p"),W.innerHTML=bt,Pe=l(),ke=i("hr"),Se=l(),R=i("p"),R.textContent=xt,Ze=l(),X=i("p"),X.textContent=ht,We=l(),V=i("p"),V.innerHTML=It,Re=l(),Q(Y.$$.fragment),Xe=l(),ne=i("p"),this.h()},l(e){const t=Bt("svelte-u9bgzb",document.head);u=o(t,"META",{name:!0,content:!0}),t.forEach(a),le=s(e),ae=o(e,"P",{}),Ut(ae).forEach(a),se=s(e),F(m.$$.fragment,e),ie=s(e),c=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(c)!=="svelte-1u5dcys"&&(c.innerHTML=Fe),oe=s(e),f=o(e,"P",{"data-svelte-h":!0}),r(f)!=="svelte-1g792u3"&&(f.innerHTML=Oe),re=s(e),M=o(e,"P",{"data-svelte-h":!0}),r(M)!=="svelte-2bb1h1"&&(M.textContent=De),ue=s(e),y=o(e,"P",{"data-svelte-h":!0}),r(y)!=="svelte-gljhvq"&&(y.textContent=Ke),ce=s(e),F(g.$$.fragment,e),pe=s(e),T=o(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-1wivjva"&&(T.textContent=et),de=s(e),v=o(e,"TABLE",{"data-svelte-h":!0}),r(v)!=="svelte-1vr8tjf"&&(v.innerHTML=tt),me=s(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-134tcfx"&&(j.textContent=at),fe=s(e),J=o(e,"TABLE",{"data-svelte-h":!0}),r(J)!=="svelte-1uwysts"&&(J.innerHTML=nt),Me=s(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-vif9d1"&&(C.innerHTML=lt),ye=s(e),w=o(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-5cern7"&&(w.textContent=st),ge=s(e),F(b.$$.fragment,e),Te=s(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-k29tct"&&(x.innerHTML=it),ve=s(e),h=o(e,"OL",{"data-svelte-h":!0}),r(h)!=="svelte-19p5l5m"&&(h.innerHTML=ot),je=s(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1axqync"&&(I.textContent=rt),Je=s(e),p=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(p)!=="svelte-m7mpd0"&&(p.innerHTML=ut),Ce=s(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-gvcxwr"&&(U.innerHTML=ct),we=s(e),d=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(d)!=="svelte-1tzrn4s"&&(d.innerHTML=pt),be=s(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-h0r7pb"&&(A.textContent=dt),xe=s(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-m1aeyu"&&(q.textContent=mt),he=s(e),F(E.$$.fragment,e),Ie=s(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1gzno4y"&&(_.textContent=ft),Ue=s(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1o7cfwp"&&($.textContent=Mt),Ae=s(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1nvv5ro"&&(L.textContent=yt),qe=s(e),F(H.$$.fragment,e),Ee=s(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1ttpln8"&&(B.innerHTML=gt),_e=s(e),N=o(e,"IMG",{src:!0,alt:!0}),$e=s(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-ahakaw"&&(z.textContent=vt),Le=s(e),G=o(e,"UL",{"data-svelte-h":!0}),r(G)!=="svelte-1bukje0"&&(G.innerHTML=jt),He=s(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-11c5kc2"&&(P.textContent=Jt),Be=s(e),F(k.$$.fragment,e),Ne=s(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-10jmk85"&&(S.textContent=Ct),ze=s(e),Z=o(e,"UL",{"data-svelte-h":!0}),r(Z)!=="svelte-1u48854"&&(Z.innerHTML=wt),Ge=s(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-k5ksx6"&&(W.innerHTML=bt),Pe=s(e),ke=o(e,"HR",{}),Se=s(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-u9xjsq"&&(R.textContent=xt),Ze=s(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1xrixeh"&&(X.textContent=ht),We=s(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-5z8s1y"&&(V.innerHTML=It),Re=s(e),F(Y.$$.fragment,e),Xe=s(e),ne=o(e,"P",{}),Ut(ne).forEach(a),this.h()},h(){O(u,"name","hf:doc:metadata"),O(u,"content",Pt),O(c,"class","tip"),O(p,"start","2"),O(d,"start","3"),Et(N.src,Tt="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/code-vs-json-actions.png")||O(N,"src",Tt),O(N,"alt","Agentes de Código")},m(e,t){Nt(document.head,u),n(e,le,t),n(e,ae,t),n(e,se,t),D(m,e,t),n(e,ie,t),n(e,c,t),n(e,oe,t),n(e,f,t),n(e,re,t),n(e,M,t),n(e,ue,t),n(e,y,t),n(e,ce,t),D(g,e,t),n(e,pe,t),n(e,T,t),n(e,de,t),n(e,v,t),n(e,me,t),n(e,j,t),n(e,fe,t),n(e,J,t),n(e,Me,t),n(e,C,t),n(e,ye,t),n(e,w,t),n(e,ge,t),D(b,e,t),n(e,Te,t),n(e,x,t),n(e,ve,t),n(e,h,t),n(e,je,t),n(e,I,t),n(e,Je,t),n(e,p,t),n(e,Ce,t),n(e,U,t),n(e,we,t),n(e,d,t),n(e,be,t),n(e,A,t),n(e,xe,t),n(e,q,t),n(e,he,t),D(E,e,t),n(e,Ie,t),n(e,_,t),n(e,Ue,t),n(e,$,t),n(e,Ae,t),n(e,L,t),n(e,qe,t),D(H,e,t),n(e,Ee,t),n(e,B,t),n(e,_e,t),n(e,N,t),n(e,$e,t),n(e,z,t),n(e,Le,t),n(e,G,t),n(e,He,t),n(e,P,t),n(e,Be,t),D(k,e,t),n(e,Ne,t),n(e,S,t),n(e,ze,t),n(e,Z,t),n(e,Ge,t),n(e,W,t),n(e,Pe,t),n(e,ke,t),n(e,Se,t),n(e,R,t),n(e,Ze,t),n(e,X,t),n(e,We,t),n(e,V,t),n(e,Re,t),D(Y,e,t),n(e,Xe,t),n(e,ne,t),Ve=!0},p:_t,i(e){Ve||(K(m.$$.fragment,e),K(g.$$.fragment,e),K(b.$$.fragment,e),K(E.$$.fragment,e),K(H.$$.fragment,e),K(k.$$.fragment,e),K(Y.$$.fragment,e),Ve=!0)},o(e){ee(m.$$.fragment,e),ee(g.$$.fragment,e),ee(b.$$.fragment,e),ee(E.$$.fragment,e),ee(H.$$.fragment,e),ee(k.$$.fragment,e),ee(Y.$$.fragment,e),Ve=!1},d(e){e&&(a(le),a(ae),a(se),a(ie),a(c),a(oe),a(f),a(re),a(M),a(ue),a(y),a(ce),a(pe),a(T),a(de),a(v),a(me),a(j),a(fe),a(J),a(Me),a(C),a(ye),a(w),a(ge),a(Te),a(x),a(ve),a(h),a(je),a(I),a(Je),a(p),a(Ce),a(U),a(we),a(d),a(be),a(A),a(xe),a(q),a(he),a(Ie),a(_),a(Ue),a($),a(Ae),a(L),a(qe),a(Ee),a(B),a(_e),a(N),a($e),a(z),a(Le),a(G),a(He),a(P),a(Be),a(Ne),a(S),a(ze),a(Z),a(Ge),a(W),a(Pe),a(ke),a(Se),a(R),a(Ze),a(X),a(We),a(V),a(Re),a(Xe),a(ne)),a(u),te(m,e),te(g,e),te(b,e),te(E,e),te(H,e),te(k,e),te(Y,e)}}}const Pt='{"title":"Acciones: Permitiendo al Agente Interactuar con Su Entorno","local":"acciones-permitiendo-al-agente-interactuar-con-su-entorno","sections":[{"title":"Tipos de Acciones de Agentes","local":"tipos-de-acciones-de-agentes","sections":[],"depth":2},{"title":"El Enfoque de Detener y Analizar","local":"el-enfoque-de-detener-y-analizar","sections":[],"depth":2},{"title":"Agentes de Código","local":"agentes-de-código","sections":[],"depth":2}],"depth":1}';function kt(Qe){return $t(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Vt extends Lt{constructor(u){super(),Ht(this,u,kt,Gt,qt,{})}}export{Vt as component};
