import{s as Dt,f as Lt,o as Pt,n as E}from"../chunks/scheduler.37c15a92.js";import{S as Kt,i as Ot,g as J,s as M,r as I,A as el,h as w,f as l,c,j as wt,u as b,x as T,k as W,y as tl,a as s,v as g,d as Z,t as C,w as B}from"../chunks/index.2bf4358c.js";import{C as k}from"../chunks/CodeBlock.4e987730.js";import{H as V}from"../chunks/Heading.8ada512a.js";import{H as Tt,a as x}from"../chunks/HfOption.02c8e375.js";import{E as ll}from"../chunks/getInferenceSnippets.0aa3753f.js";function sl(G){let i,h="We will use the Hugging Face <code>datasets</code> library to load the dataset and convert it into a list of <code>Document</code> objects from the <code>langchain.docstore.document</code> module.",p,d,m;return d=new k({props:{code:"aW1wb3J0JTIwZGF0YXNldHMlMEFmcm9tJTIwbGFuZ2NoYWluX2NvcmUuZG9jdW1lbnRzJTIwaW1wb3J0JTIwRG9jdW1lbnQlMEElMEElMjMlMjBMb2FkJTIwdGhlJTIwZGF0YXNldCUwQWd1ZXN0X2RhdGFzZXQlMjAlM0QlMjBkYXRhc2V0cy5sb2FkX2RhdGFzZXQoJTIyYWdlbnRzLWNvdXJzZSUyRnVuaXQzLWludml0ZWVzJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEElMEElMjMlMjBDb252ZXJ0JTIwZGF0YXNldCUyMGVudHJpZXMlMjBpbnRvJTIwRG9jdW1lbnQlMjBvYmplY3RzJTBBZG9jcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMERvY3VtZW50KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhZ2VfY29udGVudCUzRCUyMiU1Q24lMjIuam9pbiglNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmJTIyTmFtZSUzQSUyMCU3Qmd1ZXN0JTVCJ25hbWUnJTVEJTdEJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMlJlbGF0aW9uJTNBJTIwJTdCZ3Vlc3QlNUIncmVsYXRpb24nJTVEJTdEJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMkRlc2NyaXB0aW9uJTNBJTIwJTdCZ3Vlc3QlNUInZGVzY3JpcHRpb24nJTVEJTdEJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMkVtYWlsJTNBJTIwJTdCZ3Vlc3QlNUInZW1haWwnJTVEJTdEJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1ldGFkYXRhJTNEJTdCJTIybmFtZSUyMiUzQSUyMGd1ZXN0JTVCJTIybmFtZSUyMiU1RCU3RCUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjBmb3IlMjBndWVzdCUyMGluJTIwZ3Vlc3RfZGF0YXNldCUwQSU1RCUwQQ==",highlighted:`<span class="hljs-keyword">import</span> datasets
<span class="hljs-keyword">from</span> langchain_core.documents <span class="hljs-keyword">import</span> Document

<span class="hljs-comment"># Load the dataset</span>
guest_dataset = datasets.load_dataset(<span class="hljs-string">&quot;agents-course/unit3-invitees&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

<span class="hljs-comment"># Convert dataset entries into Document objects</span>
docs = [
    Document(
        page_content=<span class="hljs-string">&quot;\\n&quot;</span>.join([
            <span class="hljs-string">f&quot;Name: <span class="hljs-subst">{guest[<span class="hljs-string">&#x27;name&#x27;</span>]}</span>&quot;</span>,
            <span class="hljs-string">f&quot;Relation: <span class="hljs-subst">{guest[<span class="hljs-string">&#x27;relation&#x27;</span>]}</span>&quot;</span>,
            <span class="hljs-string">f&quot;Description: <span class="hljs-subst">{guest[<span class="hljs-string">&#x27;description&#x27;</span>]}</span>&quot;</span>,
            <span class="hljs-string">f&quot;Email: <span class="hljs-subst">{guest[<span class="hljs-string">&#x27;email&#x27;</span>]}</span>&quot;</span>
        ]),
        metadata={<span class="hljs-string">&quot;name&quot;</span>: guest[<span class="hljs-string">&quot;name&quot;</span>]}
    )
    <span class="hljs-keyword">for</span> guest <span class="hljs-keyword">in</span> guest_dataset
]
`,wrap:!1}}),{c(){i=J("p"),i.innerHTML=h,p=M(),I(d.$$.fragment)},l(r){i=w(r,"P",{"data-svelte-h":!0}),T(i)!=="svelte-1vrqwzz"&&(i.innerHTML=h),p=c(r),b(d.$$.fragment,r)},m(r,t){s(r,i,t),s(r,p,t),g(d,r,t),m=!0},p:E,i(r){m||(Z(d.$$.fragment,r),m=!0)},o(r){C(d.$$.fragment,r),m=!1},d(r){r&&(l(i),l(p)),B(d,r)}}}function al(G){let i,h="We will use the Hugging Face <code>datasets</code> library to load the dataset and convert it into a list of <code>Document</code> objects from the <code>llama_index.core.schema</code> module.",p,d,m;return d=new k({props:{code:"aW1wb3J0JTIwZGF0YXNldHMlMEFmcm9tJTIwbGxhbWFfaW5kZXguY29yZS5zY2hlbWElMjBpbXBvcnQlMjBEb2N1bWVudCUwQSUwQSUyMyUyMExvYWQlMjB0aGUlMjBkYXRhc2V0JTBBZ3Vlc3RfZGF0YXNldCUyMCUzRCUyMGRhdGFzZXRzLmxvYWRfZGF0YXNldCglMjJhZ2VudHMtY291cnNlJTJGdW5pdDMtaW52aXRlZXMlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQSUyMyUyMENvbnZlcnQlMjBkYXRhc2V0JTIwZW50cmllcyUyMGludG8lMjBEb2N1bWVudCUyMG9iamVjdHMlMEFkb2NzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwRG9jdW1lbnQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGV4dCUzRCUyMiU1Q24lMjIuam9pbiglNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmJTIyTmFtZSUzQSUyMCU3Qmd1ZXN0X2RhdGFzZXQlNUInbmFtZSclNUQlNUJpJTVEJTdEJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMlJlbGF0aW9uJTNBJTIwJTdCZ3Vlc3RfZGF0YXNldCU1QidyZWxhdGlvbiclNUQlNUJpJTVEJTdEJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMkRlc2NyaXB0aW9uJTNBJTIwJTdCZ3Vlc3RfZGF0YXNldCU1QidkZXNjcmlwdGlvbiclNUQlNUJpJTVEJTdEJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMkVtYWlsJTNBJTIwJTdCZ3Vlc3RfZGF0YXNldCU1QidlbWFpbCclNUQlNUJpJTVEJTdEJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1ldGFkYXRhJTNEJTdCJTIybmFtZSUyMiUzQSUyMGd1ZXN0X2RhdGFzZXQlNUInbmFtZSclNUQlNUJpJTVEJTdEJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMGZvciUyMGklMjBpbiUyMHJhbmdlKGxlbihndWVzdF9kYXRhc2V0KSklMEElNUQ=",highlighted:`<span class="hljs-keyword">import</span> datasets
<span class="hljs-keyword">from</span> llama_index.core.schema <span class="hljs-keyword">import</span> Document

<span class="hljs-comment"># Load the dataset</span>
guest_dataset = datasets.load_dataset(<span class="hljs-string">&quot;agents-course/unit3-invitees&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

<span class="hljs-comment"># Convert dataset entries into Document objects</span>
docs = [
    Document(
        text=<span class="hljs-string">&quot;\\n&quot;</span>.join([
            <span class="hljs-string">f&quot;Name: <span class="hljs-subst">{guest_dataset[<span class="hljs-string">&#x27;name&#x27;</span>][i]}</span>&quot;</span>,
            <span class="hljs-string">f&quot;Relation: <span class="hljs-subst">{guest_dataset[<span class="hljs-string">&#x27;relation&#x27;</span>][i]}</span>&quot;</span>,
            <span class="hljs-string">f&quot;Description: <span class="hljs-subst">{guest_dataset[<span class="hljs-string">&#x27;description&#x27;</span>][i]}</span>&quot;</span>,
            <span class="hljs-string">f&quot;Email: <span class="hljs-subst">{guest_dataset[<span class="hljs-string">&#x27;email&#x27;</span>][i]}</span>&quot;</span>
        ]),
        metadata={<span class="hljs-string">&quot;name&quot;</span>: guest_dataset[<span class="hljs-string">&#x27;name&#x27;</span>][i]}
    )
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(guest_dataset))
]`,wrap:!1}}),{c(){i=J("p"),i.innerHTML=h,p=M(),I(d.$$.fragment)},l(r){i=w(r,"P",{"data-svelte-h":!0}),T(i)!=="svelte-ag3ykm"&&(i.innerHTML=h),p=c(r),b(d.$$.fragment,r)},m(r,t){s(r,i,t),s(r,p,t),g(d,r,t),m=!0},p:E,i(r){m||(Z(d.$$.fragment,r),m=!0)},o(r){C(d.$$.fragment,r),m=!1},d(r){r&&(l(i),l(p)),B(d,r)}}}function nl(G){let i,h="We will use the Hugging Face <code>datasets</code> library to load the dataset and convert it into a list of <code>Document</code> objects from the <code>langchain.docstore.document</code> module.",p,d,m;return d=new k({props:{code:"aW1wb3J0JTIwZGF0YXNldHMlMEFmcm9tJTIwbGFuZ2NoYWluX2NvcmUuZG9jdW1lbnRzJTIwaW1wb3J0JTIwRG9jdW1lbnQlMEElMEElMjMlMjBMb2FkJTIwdGhlJTIwZGF0YXNldCUwQWd1ZXN0X2RhdGFzZXQlMjAlM0QlMjBkYXRhc2V0cy5sb2FkX2RhdGFzZXQoJTIyYWdlbnRzLWNvdXJzZSUyRnVuaXQzLWludml0ZWVzJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEElMEElMjMlMjBDb252ZXJ0JTIwZGF0YXNldCUyMGVudHJpZXMlMjBpbnRvJTIwRG9jdW1lbnQlMjBvYmplY3RzJTBBZG9jcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMERvY3VtZW50KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhZ2VfY29udGVudCUzRCUyMiU1Q24lMjIuam9pbiglNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmJTIyTmFtZSUzQSUyMCU3Qmd1ZXN0JTVCJ25hbWUnJTVEJTdEJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMlJlbGF0aW9uJTNBJTIwJTdCZ3Vlc3QlNUIncmVsYXRpb24nJTVEJTdEJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMkRlc2NyaXB0aW9uJTNBJTIwJTdCZ3Vlc3QlNUInZGVzY3JpcHRpb24nJTVEJTdEJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMkVtYWlsJTNBJTIwJTdCZ3Vlc3QlNUInZW1haWwnJTVEJTdEJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1ldGFkYXRhJTNEJTdCJTIybmFtZSUyMiUzQSUyMGd1ZXN0JTVCJTIybmFtZSUyMiU1RCU3RCUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjBmb3IlMjBndWVzdCUyMGluJTIwZ3Vlc3RfZGF0YXNldCUwQSU1RA==",highlighted:`<span class="hljs-keyword">import</span> datasets
<span class="hljs-keyword">from</span> langchain_core.documents <span class="hljs-keyword">import</span> Document

<span class="hljs-comment"># Load the dataset</span>
guest_dataset = datasets.load_dataset(<span class="hljs-string">&quot;agents-course/unit3-invitees&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

<span class="hljs-comment"># Convert dataset entries into Document objects</span>
docs = [
    Document(
        page_content=<span class="hljs-string">&quot;\\n&quot;</span>.join([
            <span class="hljs-string">f&quot;Name: <span class="hljs-subst">{guest[<span class="hljs-string">&#x27;name&#x27;</span>]}</span>&quot;</span>,
            <span class="hljs-string">f&quot;Relation: <span class="hljs-subst">{guest[<span class="hljs-string">&#x27;relation&#x27;</span>]}</span>&quot;</span>,
            <span class="hljs-string">f&quot;Description: <span class="hljs-subst">{guest[<span class="hljs-string">&#x27;description&#x27;</span>]}</span>&quot;</span>,
            <span class="hljs-string">f&quot;Email: <span class="hljs-subst">{guest[<span class="hljs-string">&#x27;email&#x27;</span>]}</span>&quot;</span>
        ]),
        metadata={<span class="hljs-string">&quot;name&quot;</span>: guest[<span class="hljs-string">&quot;name&quot;</span>]}
    )
    <span class="hljs-keyword">for</span> guest <span class="hljs-keyword">in</span> guest_dataset
]`,wrap:!1}}),{c(){i=J("p"),i.innerHTML=h,p=M(),I(d.$$.fragment)},l(r){i=w(r,"P",{"data-svelte-h":!0}),T(i)!=="svelte-1vrqwzz"&&(i.innerHTML=h),p=c(r),b(d.$$.fragment,r)},m(r,t){s(r,i,t),s(r,p,t),g(d,r,t),m=!0},p:E,i(r){m||(Z(d.$$.fragment,r),m=!0)},o(r){C(d.$$.fragment,r),m=!1},d(r){r&&(l(i),l(p)),B(d,r)}}}function il(G){let i,h,p,d,m,r;return i=new x({props:{id:"agents-frameworks",option:"smolagents",$$slots:{default:[sl]},$$scope:{ctx:G}}}),p=new x({props:{id:"agents-frameworks",option:"llama-index",$$slots:{default:[al]},$$scope:{ctx:G}}}),m=new x({props:{id:"agents-frameworks",option:"langgraph",$$slots:{default:[nl]},$$scope:{ctx:G}}}),{c(){I(i.$$.fragment),h=M(),I(p.$$.fragment),d=M(),I(m.$$.fragment)},l(t){b(i.$$.fragment,t),h=c(t),b(p.$$.fragment,t),d=c(t),b(m.$$.fragment,t)},m(t,u){g(i,t,u),s(t,h,u),g(p,t,u),s(t,d,u),g(m,t,u),r=!0},p(t,u){const j={};u&2&&(j.$$scope={dirty:u,ctx:t}),i.$set(j);const f={};u&2&&(f.$$scope={dirty:u,ctx:t}),p.$set(f);const y={};u&2&&(y.$$scope={dirty:u,ctx:t}),m.$set(y)},i(t){r||(Z(i.$$.fragment,t),Z(p.$$.fragment,t),Z(m.$$.fragment,t),r=!0)},o(t){C(i.$$.fragment,t),C(p.$$.fragment,t),C(m.$$.fragment,t),r=!1},d(t){t&&(l(h),l(d)),B(i,t),B(p,t),B(m,t)}}}function ol(G){let i,h="We will use the <code>BM25Retriever</code> from the <code>langchain_community.retrievers</code> module to create a retriever tool.",p,d,m='<p>The <code>BM25Retriever</code> is a great starting point for retrieval, but for more advanced semantic search, you might consider using embedding-based retrievers like those from <a href="https://www.sbert.net/">sentence-transformers</a>.</p>',r,t,u,j,f="Let’s understand this tool step-by-step:",y,U,$="<li>The <code>name</code> and <code>description</code> help the agent understand when and how to use this tool</li> <li>The <code>inputs</code> define what parameters the tool expects (in this case, a search query)</li> <li>We’re using a <code>BM25Retriever</code>, which is a powerful text retrieval algorithm that doesn’t require embeddings</li> <li>The <code>forward</code> method processes the query and returns the most relevant guest information</li>",n;return t=new k({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sJTBBZnJvbSUyMGxhbmdjaGFpbl9jb21tdW5pdHkucmV0cmlldmVycyUyMGltcG9ydCUyMEJNMjVSZXRyaWV2ZXIlMEElMEFjbGFzcyUyMEd1ZXN0SW5mb1JldHJpZXZlclRvb2woVG9vbCklM0ElMEElMjAlMjAlMjAlMjBuYW1lJTIwJTNEJTIwJTIyZ3Vlc3RfaW5mb19yZXRyaWV2ZXIlMjIlMEElMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUyMCUzRCUyMCUyMlJldHJpZXZlcyUyMGRldGFpbGVkJTIwaW5mb3JtYXRpb24lMjBhYm91dCUyMGdhbGElMjBndWVzdHMlMjBiYXNlZCUyMG9uJTIwdGhlaXIlMjBuYW1lJTIwb3IlMjByZWxhdGlvbi4lMjIlMEElMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJxdWVyeSUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJzdHJpbmclMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJkZXNjcmlwdGlvbiUyMiUzQSUyMCUyMlRoZSUyMG5hbWUlMjBvciUyMHJlbGF0aW9uJTIwb2YlMjB0aGUlMjBndWVzdCUyMHlvdSUyMHdhbnQlMjBpbmZvcm1hdGlvbiUyMGFib3V0LiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMG91dHB1dF90eXBlJTIwJTNEJTIwJTIyc3RyaW5nJTIyJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGRvY3MpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5pc19pbml0aWFsaXplZCUyMCUzRCUyMEZhbHNlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5yZXRyaWV2ZXIlMjAlM0QlMjBCTTI1UmV0cmlldmVyLmZyb21fZG9jdW1lbnRzKGRvY3MpJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwcXVlcnklM0ElMjBzdHIpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzdWx0cyUyMCUzRCUyMHNlbGYucmV0cmlldmVyLmdldF9yZWxldmFudF9kb2N1bWVudHMocXVlcnkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjByZXN1bHRzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIyJTVDbiU1Q24lMjIuam9pbiglNUJkb2MucGFnZV9jb250ZW50JTIwZm9yJTIwZG9jJTIwaW4lMjByZXN1bHRzJTVCJTNBMyU1RCU1RCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIyTm8lMjBtYXRjaGluZyUyMGd1ZXN0JTIwaW5mb3JtYXRpb24lMjBmb3VuZC4lMjIlMEElMEElMjMlMjBJbml0aWFsaXplJTIwdGhlJTIwdG9vbCUwQWd1ZXN0X2luZm9fdG9vbCUyMCUzRCUyMEd1ZXN0SW5mb1JldHJpZXZlclRvb2woZG9jcyk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool
<span class="hljs-keyword">from</span> langchain_community.retrievers <span class="hljs-keyword">import</span> BM25Retriever

<span class="hljs-keyword">class</span> <span class="hljs-title class_">GuestInfoRetrieverTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;guest_info_retriever&quot;</span>
    description = <span class="hljs-string">&quot;Retrieves detailed information about gala guests based on their name or relation.&quot;</span>
    inputs = {
        <span class="hljs-string">&quot;query&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The name or relation of the guest you want information about.&quot;</span>
        }
    }
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, docs</span>):
        self.is_initialized = <span class="hljs-literal">False</span>
        self.retriever = BM25Retriever.from_documents(docs)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, query: <span class="hljs-built_in">str</span></span>):
        results = self.retriever.get_relevant_documents(query)
        <span class="hljs-keyword">if</span> results:
            <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\n\\n&quot;</span>.join([doc.page_content <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> results[:<span class="hljs-number">3</span>]])
        <span class="hljs-keyword">else</span>:
            <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;No matching guest information found.&quot;</span>

<span class="hljs-comment"># Initialize the tool</span>
guest_info_tool = GuestInfoRetrieverTool(docs)`,wrap:!1}}),{c(){i=J("p"),i.innerHTML=h,p=M(),d=J("blockquote"),d.innerHTML=m,r=M(),I(t.$$.fragment),u=M(),j=J("p"),j.textContent=f,y=M(),U=J("ul"),U.innerHTML=$,this.h()},l(a){i=w(a,"P",{"data-svelte-h":!0}),T(i)!=="svelte-1weris3"&&(i.innerHTML=h),p=c(a),d=w(a,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),T(d)!=="svelte-jinfwb"&&(d.innerHTML=m),r=c(a),b(t.$$.fragment,a),u=c(a),j=w(a,"P",{"data-svelte-h":!0}),T(j)!=="svelte-xficc2"&&(j.textContent=f),y=c(a),U=w(a,"UL",{"data-svelte-h":!0}),T(U)!=="svelte-14ztz3k"&&(U.innerHTML=$),this.h()},h(){W(d,"class","tip")},m(a,v){s(a,i,v),s(a,p,v),s(a,d,v),s(a,r,v),g(t,a,v),s(a,u,v),s(a,j,v),s(a,y,v),s(a,U,v),n=!0},p:E,i(a){n||(Z(t.$$.fragment,a),n=!0)},o(a){C(t.$$.fragment,a),n=!1},d(a){a&&(l(i),l(p),l(d),l(r),l(u),l(j),l(y),l(U)),B(t,a)}}}function rl(G){let i,h="We will use the <code>BM25Retriever</code> from the <code>llama_index.retrievers.bm25</code> module to create a retriever tool.",p,d,m='<p>The <code>BM25Retriever</code> is a great starting point for retrieval, but for more advanced semantic search, you might consider using embedding-based retrievers like those from <a href="https://www.sbert.net/">sentence-transformers</a>.</p>',r,t,u,j,f="Let’s understand this tool step-by-step.",y,U,$="<li>The docstring helps the agent understand when and how to use this tool</li> <li>The type decorators define what parameters the tool expects (in this case, a search query)</li> <li>We’re using a <code>BM25Retriever</code>, which is a powerful text retrieval algorithm that doesn’t require embeddings</li> <li>The method processes the query and returns the most relevant guest information</li>",n;return t=new k({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUudG9vbHMlMjBpbXBvcnQlMjBGdW5jdGlvblRvb2wlMEFmcm9tJTIwbGxhbWFfaW5kZXgucmV0cmlldmVycy5ibTI1JTIwaW1wb3J0JTIwQk0yNVJldHJpZXZlciUwQSUwQWJtMjVfcmV0cmlldmVyJTIwJTNEJTIwQk0yNVJldHJpZXZlci5mcm9tX2RlZmF1bHRzKG5vZGVzJTNEZG9jcyklMEElMEFkZWYlMjBnZXRfZ3Vlc3RfaW5mb19yZXRyaWV2ZXIocXVlcnklM0ElMjBzdHIpJTIwLSUzRSUyMHN0ciUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMlJldHJpZXZlcyUyMGRldGFpbGVkJTIwaW5mb3JtYXRpb24lMjBhYm91dCUyMGdhbGElMjBndWVzdHMlMjBiYXNlZCUyMG9uJTIwdGhlaXIlMjBuYW1lJTIwb3IlMjByZWxhdGlvbi4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjByZXN1bHRzJTIwJTNEJTIwYm0yNV9yZXRyaWV2ZXIucmV0cmlldmUocXVlcnkpJTBBJTIwJTIwJTIwJTIwaWYlMjByZXN1bHRzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIyJTVDbiU1Q24lMjIuam9pbiglNUJkb2MudGV4dCUyMGZvciUyMGRvYyUyMGluJTIwcmVzdWx0cyU1QiUzQTMlNUQlNUQpJTBBJTIwJTIwJTIwJTIwZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCUyMk5vJTIwbWF0Y2hpbmclMjBndWVzdCUyMGluZm9ybWF0aW9uJTIwZm91bmQuJTIyJTBBJTBBJTIzJTIwSW5pdGlhbGl6ZSUyMHRoZSUyMHRvb2wlMEFndWVzdF9pbmZvX3Rvb2wlMjAlM0QlMjBGdW5jdGlvblRvb2wuZnJvbV9kZWZhdWx0cyhnZXRfZ3Vlc3RfaW5mb19yZXRyaWV2ZXIp",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.tools <span class="hljs-keyword">import</span> FunctionTool
<span class="hljs-keyword">from</span> llama_index.retrievers.bm25 <span class="hljs-keyword">import</span> BM25Retriever

bm25_retriever = BM25Retriever.from_defaults(nodes=docs)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_guest_info_retriever</span>(<span class="hljs-params">query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Retrieves detailed information about gala guests based on their name or relation.&quot;&quot;&quot;</span>
    results = bm25_retriever.retrieve(query)
    <span class="hljs-keyword">if</span> results:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\n\\n&quot;</span>.join([doc.text <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> results[:<span class="hljs-number">3</span>]])
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;No matching guest information found.&quot;</span>

<span class="hljs-comment"># Initialize the tool</span>
guest_info_tool = FunctionTool.from_defaults(get_guest_info_retriever)`,wrap:!1}}),{c(){i=J("p"),i.innerHTML=h,p=M(),d=J("blockquote"),d.innerHTML=m,r=M(),I(t.$$.fragment),u=M(),j=J("p"),j.textContent=f,y=M(),U=J("ul"),U.innerHTML=$,this.h()},l(a){i=w(a,"P",{"data-svelte-h":!0}),T(i)!=="svelte-1li0cac"&&(i.innerHTML=h),p=c(a),d=w(a,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),T(d)!=="svelte-jinfwb"&&(d.innerHTML=m),r=c(a),b(t.$$.fragment,a),u=c(a),j=w(a,"P",{"data-svelte-h":!0}),T(j)!=="svelte-5xdv72"&&(j.textContent=f),y=c(a),U=w(a,"UL",{"data-svelte-h":!0}),T(U)!=="svelte-1grz3gg"&&(U.innerHTML=$),this.h()},h(){W(d,"class","tip")},m(a,v){s(a,i,v),s(a,p,v),s(a,d,v),s(a,r,v),g(t,a,v),s(a,u,v),s(a,j,v),s(a,y,v),s(a,U,v),n=!0},p:E,i(a){n||(Z(t.$$.fragment,a),n=!0)},o(a){C(t.$$.fragment,a),n=!1},d(a){a&&(l(i),l(p),l(d),l(r),l(u),l(j),l(y),l(U)),B(t,a)}}}function pl(G){let i,h="We will use the <code>BM25Retriever</code> from the <code>langchain_community.retrievers</code> module to create a retriever tool.",p,d,m='<p>The <code>BM25Retriever</code> is a great starting point for retrieval, but for more advanced semantic search, you might consider using embedding-based retrievers like those from <a href="https://www.sbert.net/">sentence-transformers</a>.</p>',r,t,u,j,f="Let’s understand this tool step-by-step.",y,U,$="<li>The <code>name</code> and <code>description</code> help the agent understand when and how to use this tool</li> <li>The type decorators define what parameters the tool expects (in this case, a search query)</li> <li>We’re using a <code>BM25Retriever</code>, which is a powerful text retrieval algorithm that doesn’t require embeddings</li> <li>The method processes the query and returns the most relevant guest information</li>",n;return t=new k({props:{code:"ZnJvbSUyMGxhbmdjaGFpbl9jb21tdW5pdHkucmV0cmlldmVycyUyMGltcG9ydCUyMEJNMjVSZXRyaWV2ZXIlMEFmcm9tJTIwbGFuZ2NoYWluLnRvb2xzJTIwaW1wb3J0JTIwVG9vbCUwQSUwQWJtMjVfcmV0cmlldmVyJTIwJTNEJTIwQk0yNVJldHJpZXZlci5mcm9tX2RvY3VtZW50cyhkb2NzKSUwQSUwQWRlZiUyMGV4dHJhY3RfdGV4dChxdWVyeSUzQSUyMHN0ciklMjAtJTNFJTIwc3RyJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyUmV0cmlldmVzJTIwZGV0YWlsZWQlMjBpbmZvcm1hdGlvbiUyMGFib3V0JTIwZ2FsYSUyMGd1ZXN0cyUyMGJhc2VkJTIwb24lMjB0aGVpciUyMG5hbWUlMjBvciUyMHJlbGF0aW9uLiUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMHJlc3VsdHMlMjAlM0QlMjBibTI1X3JldHJpZXZlci5pbnZva2UocXVlcnkpJTBBJTIwJTIwJTIwJTIwaWYlMjByZXN1bHRzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIyJTVDbiU1Q24lMjIuam9pbiglNUJkb2MucGFnZV9jb250ZW50JTIwZm9yJTIwZG9jJTIwaW4lMjByZXN1bHRzJTVCJTNBMyU1RCU1RCklMEElMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIyTm8lMjBtYXRjaGluZyUyMGd1ZXN0JTIwaW5mb3JtYXRpb24lMjBmb3VuZC4lMjIlMEElMEFndWVzdF9pbmZvX3Rvb2wlMjAlM0QlMjBUb29sKCUwQSUyMCUyMCUyMCUyMG5hbWUlM0QlMjJndWVzdF9pbmZvX3JldHJpZXZlciUyMiUyQyUwQSUyMCUyMCUyMCUyMGZ1bmMlM0RleHRyYWN0X3RleHQlMkMlMEElMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUzRCUyMlJldHJpZXZlcyUyMGRldGFpbGVkJTIwaW5mb3JtYXRpb24lMjBhYm91dCUyMGdhbGElMjBndWVzdHMlMjBiYXNlZCUyMG9uJTIwdGhlaXIlMjBuYW1lJTIwb3IlMjByZWxhdGlvbi4lMjIlMEEp",highlighted:`<span class="hljs-keyword">from</span> langchain_community.retrievers <span class="hljs-keyword">import</span> BM25Retriever
<span class="hljs-keyword">from</span> langchain.tools <span class="hljs-keyword">import</span> Tool

bm25_retriever = BM25Retriever.from_documents(docs)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">extract_text</span>(<span class="hljs-params">query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Retrieves detailed information about gala guests based on their name or relation.&quot;&quot;&quot;</span>
    results = bm25_retriever.invoke(query)
    <span class="hljs-keyword">if</span> results:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\n\\n&quot;</span>.join([doc.page_content <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> results[:<span class="hljs-number">3</span>]])
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;No matching guest information found.&quot;</span>

guest_info_tool = Tool(
    name=<span class="hljs-string">&quot;guest_info_retriever&quot;</span>,
    func=extract_text,
    description=<span class="hljs-string">&quot;Retrieves detailed information about gala guests based on their name or relation.&quot;</span>
)`,wrap:!1}}),{c(){i=J("p"),i.innerHTML=h,p=M(),d=J("blockquote"),d.innerHTML=m,r=M(),I(t.$$.fragment),u=M(),j=J("p"),j.textContent=f,y=M(),U=J("ul"),U.innerHTML=$,this.h()},l(a){i=w(a,"P",{"data-svelte-h":!0}),T(i)!=="svelte-1weris3"&&(i.innerHTML=h),p=c(a),d=w(a,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),T(d)!=="svelte-jinfwb"&&(d.innerHTML=m),r=c(a),b(t.$$.fragment,a),u=c(a),j=w(a,"P",{"data-svelte-h":!0}),T(j)!=="svelte-5xdv72"&&(j.textContent=f),y=c(a),U=w(a,"UL",{"data-svelte-h":!0}),T(U)!=="svelte-95yww2"&&(U.innerHTML=$),this.h()},h(){W(d,"class","tip")},m(a,v){s(a,i,v),s(a,p,v),s(a,d,v),s(a,r,v),g(t,a,v),s(a,u,v),s(a,j,v),s(a,y,v),s(a,U,v),n=!0},p:E,i(a){n||(Z(t.$$.fragment,a),n=!0)},o(a){C(t.$$.fragment,a),n=!1},d(a){a&&(l(i),l(p),l(d),l(r),l(u),l(j),l(y),l(U)),B(t,a)}}}function Ml(G){let i,h,p,d,m,r;return i=new x({props:{id:"agents-frameworks",option:"smolagents",$$slots:{default:[ol]},$$scope:{ctx:G}}}),p=new x({props:{id:"agents-frameworks",option:"llama-index",$$slots:{default:[rl]},$$scope:{ctx:G}}}),m=new x({props:{id:"agents-frameworks",option:"langgraph",$$slots:{default:[pl]},$$scope:{ctx:G}}}),{c(){I(i.$$.fragment),h=M(),I(p.$$.fragment),d=M(),I(m.$$.fragment)},l(t){b(i.$$.fragment,t),h=c(t),b(p.$$.fragment,t),d=c(t),b(m.$$.fragment,t)},m(t,u){g(i,t,u),s(t,h,u),g(p,t,u),s(t,d,u),g(m,t,u),r=!0},p(t,u){const j={};u&2&&(j.$$scope={dirty:u,ctx:t}),i.$set(j);const f={};u&2&&(f.$$scope={dirty:u,ctx:t}),p.$set(f);const y={};u&2&&(y.$$scope={dirty:u,ctx:t}),m.$set(y)},i(t){r||(Z(i.$$.fragment,t),Z(p.$$.fragment,t),Z(m.$$.fragment,t),r=!0)},o(t){C(i.$$.fragment,t),C(p.$$.fragment,t),C(m.$$.fragment,t),r=!1},d(t){t&&(l(h),l(d)),B(i,t),B(p,t),B(m,t)}}}function cl(G){let i,h,p,d="Expected output:",m,r,t,u,j="What’s happening in this final step:",f,y,U="<li>We initialize a Hugging Face model using the <code>InferenceClientModel</code> class</li> <li>We create our agent (Alfred) as a <code>CodeAgent</code>, which can execute Python code to solve problems</li> <li>We ask Alfred to retrieve information about a guest named “Lady Ada Lovelace”</li>",$;return i=new k({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemUlMjB0aGUlMjBIdWdnaW5nJTIwRmFjZSUyMG1vZGVsJTBBbW9kZWwlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCgpJTBBJTBBJTIzJTIwQ3JlYXRlJTIwQWxmcmVkJTJDJTIwb3VyJTIwZ2FsYSUyMGFnZW50JTJDJTIwd2l0aCUyMHRoZSUyMGd1ZXN0JTIwaW5mbyUyMHRvb2wlMEFhbGZyZWQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUJndWVzdF9pbmZvX3Rvb2wlNUQlMkMlMjBtb2RlbCUzRG1vZGVsKSUwQSUwQSUyMyUyMEV4YW1wbGUlMjBxdWVyeSUyMEFsZnJlZCUyMG1pZ2h0JTIwcmVjZWl2ZSUyMGR1cmluZyUyMHRoZSUyMGdhbGElMEFyZXNwb25zZSUyMCUzRCUyMGFsZnJlZC5ydW4oJTIyVGVsbCUyMG1lJTIwYWJvdXQlMjBvdXIlMjBndWVzdCUyMG5hbWVkJTIwJ0xhZHklMjBBZGElMjBMb3ZlbGFjZScuJTIyKSUwQSUwQXByaW50KCUyMiVGMCU5RiU4RSVBOSUyMEFsZnJlZCdzJTIwUmVzcG9uc2UlM0ElMjIpJTBBcHJpbnQocmVzcG9uc2Up",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel

<span class="hljs-comment"># Initialize the Hugging Face model</span>
model = InferenceClientModel()

<span class="hljs-comment"># Create Alfred, our gala agent, with the guest info tool</span>
alfred = CodeAgent(tools=[guest_info_tool], model=model)

<span class="hljs-comment"># Example query Alfred might receive during the gala</span>
response = alfred.run(<span class="hljs-string">&quot;Tell me about our guest named &#x27;Lady Ada Lovelace&#x27;.&quot;</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;🎩 Alfred&#x27;s Response:&quot;</span>)
<span class="hljs-built_in">print</span>(response)`,wrap:!1}}),r=new k({props:{code:"JUYwJTlGJThFJUE5JTIwQWxmcmVkJ3MlMjBSZXNwb25zZSUzQSUwQUJhc2VkJTIwb24lMjB0aGUlMjBpbmZvcm1hdGlvbiUyMEklMjByZXRyaWV2ZWQlMkMlMjBMYWR5JTIwQWRhJTIwTG92ZWxhY2UlMjBpcyUyMGFuJTIwZXN0ZWVtZWQlMjBtYXRoZW1hdGljaWFuJTIwYW5kJTIwZnJpZW5kLiUyMFNoZSUyMGlzJTIwcmVub3duZWQlMjBmb3IlMjBoZXIlMjBwaW9uZWVyaW5nJTIwd29yayUyMGluJTIwbWF0aGVtYXRpY3MlMjBhbmQlMjBjb21wdXRpbmclMkMlMjBvZnRlbiUyMGNlbGVicmF0ZWQlMjBhcyUyMHRoZSUyMGZpcnN0JTIwY29tcHV0ZXIlMjBwcm9ncmFtbWVyJTIwZHVlJTIwdG8lMjBoZXIlMjB3b3JrJTIwb24lMjBDaGFybGVzJTIwQmFiYmFnZSdzJTIwQW5hbHl0aWNhbCUyMEVuZ2luZS4lMjBIZXIlMjBlbWFpbCUyMGFkZHJlc3MlMjBpcyUyMGFkYS5sb3ZlbGFjZSU0MGV4YW1wbGUuY29tLg==",highlighted:`🎩 Alfred<span class="hljs-comment">&#x27;s Response:</span>
Based <span class="hljs-keyword">on</span> the information I retrieved, Lady Ada Lovelace <span class="hljs-built_in">is</span> an esteemed mathematician <span class="hljs-built_in">and</span> <span class="hljs-keyword">friend</span>. She <span class="hljs-built_in">is</span> renowned <span class="hljs-keyword">for</span> her pioneering work <span class="hljs-keyword">in</span> mathematics <span class="hljs-built_in">and</span> computing, often celebrated <span class="hljs-keyword">as</span> the first computer programmer due <span class="hljs-keyword">to</span> her work <span class="hljs-keyword">on</span> Charles Babbage<span class="hljs-comment">&#x27;s Analytical Engine. Her email address is ada.lovelace@example.com.</span>`,wrap:!1}}),{c(){I(i.$$.fragment),h=M(),p=J("p"),p.textContent=d,m=M(),I(r.$$.fragment),t=M(),u=J("p"),u.textContent=j,f=M(),y=J("ul"),y.innerHTML=U},l(n){b(i.$$.fragment,n),h=c(n),p=w(n,"P",{"data-svelte-h":!0}),T(p)!=="svelte-15t3xg7"&&(p.textContent=d),m=c(n),b(r.$$.fragment,n),t=c(n),u=w(n,"P",{"data-svelte-h":!0}),T(u)!=="svelte-18avn85"&&(u.textContent=j),f=c(n),y=w(n,"UL",{"data-svelte-h":!0}),T(y)!=="svelte-1mwulne"&&(y.innerHTML=U)},m(n,a){g(i,n,a),s(n,h,a),s(n,p,a),s(n,m,a),g(r,n,a),s(n,t,a),s(n,u,a),s(n,f,a),s(n,y,a),$=!0},p:E,i(n){$||(Z(i.$$.fragment,n),Z(r.$$.fragment,n),$=!0)},o(n){C(i.$$.fragment,n),C(r.$$.fragment,n),$=!1},d(n){n&&(l(h),l(p),l(m),l(t),l(u),l(f),l(y)),B(i,n),B(r,n)}}}function ul(G){let i,h,p,d="Expected output:",m,r,t,u,j="What’s happening in this final step:",f,y,U="<li>We initialize a Hugging Face model using the <code>HuggingFaceInferenceAPI</code> class</li> <li>We create our agent (Alfred) as a <code>AgentWorkflow</code>, including the tool we just created</li> <li>We ask Alfred to retrieve information about a guest named “Lady Ada Lovelace”</li>",$;return i=new k({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUuYWdlbnQud29ya2Zsb3clMjBpbXBvcnQlMjBBZ2VudFdvcmtmbG93JTBBZnJvbSUyMGxsYW1hX2luZGV4LmxsbXMuaHVnZ2luZ2ZhY2VfYXBpJTIwaW1wb3J0JTIwSHVnZ2luZ0ZhY2VJbmZlcmVuY2VBUEklMEElMEElMjMlMjBJbml0aWFsaXplJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBtb2RlbCUwQWxsbSUyMCUzRCUyMEh1Z2dpbmdGYWNlSW5mZXJlbmNlQVBJKG1vZGVsX25hbWUlM0QlMjJRd2VuJTJGUXdlbjIuNS1Db2Rlci0zMkItSW5zdHJ1Y3QlMjIpJTBBJTBBJTIzJTIwQ3JlYXRlJTIwQWxmcmVkJTJDJTIwb3VyJTIwZ2FsYSUyMGFnZW50JTJDJTIwd2l0aCUyMHRoZSUyMGd1ZXN0JTIwaW5mbyUyMHRvb2wlMEFhbGZyZWQlMjAlM0QlMjBBZ2VudFdvcmtmbG93LmZyb21fdG9vbHNfb3JfZnVuY3Rpb25zKCUwQSUyMCUyMCUyMCUyMCU1Qmd1ZXN0X2luZm9fdG9vbCU1RCUyQyUwQSUyMCUyMCUyMCUyMGxsbSUzRGxsbSUyQyUwQSklMEElMEElMjMlMjBFeGFtcGxlJTIwcXVlcnklMjBBbGZyZWQlMjBtaWdodCUyMHJlY2VpdmUlMjBkdXJpbmclMjB0aGUlMjBnYWxhJTBBcmVzcG9uc2UlMjAlM0QlMjBhd2FpdCUyMGFsZnJlZC5ydW4oJTIyVGVsbCUyMG1lJTIwYWJvdXQlMjBvdXIlMjBndWVzdCUyMG5hbWVkJTIwJ0xhZHklMjBBZGElMjBMb3ZlbGFjZScuJTIyKSUwQSUwQXByaW50KCUyMiVGMCU5RiU4RSVBOSUyMEFsZnJlZCdzJTIwUmVzcG9uc2UlM0ElMjIpJTBBcHJpbnQocmVzcG9uc2Up",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.agent.workflow <span class="hljs-keyword">import</span> AgentWorkflow
<span class="hljs-keyword">from</span> llama_index.llms.huggingface_api <span class="hljs-keyword">import</span> HuggingFaceInferenceAPI

<span class="hljs-comment"># Initialize the Hugging Face model</span>
llm = HuggingFaceInferenceAPI(model_name=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)

<span class="hljs-comment"># Create Alfred, our gala agent, with the guest info tool</span>
alfred = AgentWorkflow.from_tools_or_functions(
    [guest_info_tool],
    llm=llm,
)

<span class="hljs-comment"># Example query Alfred might receive during the gala</span>
response = <span class="hljs-keyword">await</span> alfred.run(<span class="hljs-string">&quot;Tell me about our guest named &#x27;Lady Ada Lovelace&#x27;.&quot;</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;🎩 Alfred&#x27;s Response:&quot;</span>)
<span class="hljs-built_in">print</span>(response)`,wrap:!1}}),r=new k({props:{code:"JUYwJTlGJThFJUE5JTIwQWxmcmVkJ3MlMjBSZXNwb25zZSUzQSUwQUxhZHklMjBBZGElMjBMb3ZlbGFjZSUyMGlzJTIwYW4lMjBlc3RlZW1lZCUyMG1hdGhlbWF0aWNpYW4lMjBhbmQlMjBmcmllbmQlMkMlMjByZW5vd25lZCUyMGZvciUyMGhlciUyMHBpb25lZXJpbmclMjB3b3JrJTIwaW4lMjBtYXRoZW1hdGljcyUyMGFuZCUyMGNvbXB1dGluZy4lMjBTaGUlMjBpcyUyMGNlbGVicmF0ZWQlMjBhcyUyMHRoZSUyMGZpcnN0JTIwY29tcHV0ZXIlMjBwcm9ncmFtbWVyJTIwZHVlJTIwdG8lMjBoZXIlMjB3b3JrJTIwb24lMjBDaGFybGVzJTIwQmFiYmFnZSdzJTIwQW5hbHl0aWNhbCUyMEVuZ2luZS4lMjBIZXIlMjBlbWFpbCUyMGlzJTIwYWRhLmxvdmVsYWNlJTQwZXhhbXBsZS5jb20u",highlighted:`🎩 Alfred<span class="hljs-comment">&#x27;s Response:</span>
Lady Ada Lovelace <span class="hljs-built_in">is</span> an esteemed mathematician <span class="hljs-built_in">and</span> <span class="hljs-keyword">friend</span>, renowned <span class="hljs-keyword">for</span> her pioneering work <span class="hljs-keyword">in</span> mathematics <span class="hljs-built_in">and</span> computing. She <span class="hljs-built_in">is</span> celebrated <span class="hljs-keyword">as</span> the first computer programmer due <span class="hljs-keyword">to</span> her work <span class="hljs-keyword">on</span> Charles Babbage<span class="hljs-comment">&#x27;s Analytical Engine. Her email is ada.lovelace@example.com.</span>`,wrap:!1}}),{c(){I(i.$$.fragment),h=M(),p=J("p"),p.textContent=d,m=M(),I(r.$$.fragment),t=M(),u=J("p"),u.textContent=j,f=M(),y=J("ul"),y.innerHTML=U},l(n){b(i.$$.fragment,n),h=c(n),p=w(n,"P",{"data-svelte-h":!0}),T(p)!=="svelte-15t3xg7"&&(p.textContent=d),m=c(n),b(r.$$.fragment,n),t=c(n),u=w(n,"P",{"data-svelte-h":!0}),T(u)!=="svelte-18avn85"&&(u.textContent=j),f=c(n),y=w(n,"UL",{"data-svelte-h":!0}),T(y)!=="svelte-1xe3pcb"&&(y.innerHTML=U)},m(n,a){g(i,n,a),s(n,h,a),s(n,p,a),s(n,m,a),g(r,n,a),s(n,t,a),s(n,u,a),s(n,f,a),s(n,y,a),$=!0},p:E,i(n){$||(Z(i.$$.fragment,n),Z(r.$$.fragment,n),$=!0)},o(n){C(i.$$.fragment,n),C(r.$$.fragment,n),$=!1},d(n){n&&(l(h),l(p),l(m),l(t),l(u),l(f),l(y)),B(i,n),B(r,n)}}}function dl(G){let i,h,p,d="Expected output:",m,r,t,u,j="What’s happening in this final step:",f,y,U="<li>We initialize a Hugging Face model using the <code>HuggingFaceEndpoint</code> class. We also generate a chat interface and append the tools.</li> <li>We create our agent (Alfred) as a <code>StateGraph</code>, that combines 2 nodes (<code>assistant</code>, <code>tools</code>) using an edge</li> <li>We ask Alfred to retrieve information about a guest named “Lady Ada Lovelace”</li>",$;return i=new k({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> TypedDict, Annotated
<span class="hljs-keyword">from</span> langgraph.graph.message <span class="hljs-keyword">import</span> add_messages
<span class="hljs-keyword">from</span> langchain_core.messages <span class="hljs-keyword">import</span> AnyMessage, HumanMessage, AIMessage
<span class="hljs-keyword">from</span> langgraph.prebuilt <span class="hljs-keyword">import</span> ToolNode
<span class="hljs-keyword">from</span> langgraph.graph <span class="hljs-keyword">import</span> START, StateGraph
<span class="hljs-keyword">from</span> langgraph.prebuilt <span class="hljs-keyword">import</span> tools_condition
<span class="hljs-keyword">from</span> langchain_huggingface <span class="hljs-keyword">import</span> HuggingFaceEndpoint, ChatHuggingFace

<span class="hljs-comment"># Generate the chat interface, including the tools</span>
llm = HuggingFaceEndpoint(
    repo_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>,
    huggingfacehub_api_token=HUGGINGFACEHUB_API_TOKEN,
)

chat = ChatHuggingFace(llm=llm, verbose=<span class="hljs-literal">True</span>)
tools = [guest_info_tool]
chat_with_tools = chat.bind_tools(tools)

<span class="hljs-comment"># Generate the AgentState and Agent graph</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">AgentState</span>(<span class="hljs-title class_ inherited__">TypedDict</span>):
    messages: Annotated[<span class="hljs-built_in">list</span>[AnyMessage], add_messages]

<span class="hljs-keyword">def</span> <span class="hljs-title function_">assistant</span>(<span class="hljs-params">state: AgentState</span>):
    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;messages&quot;</span>: [chat_with_tools.invoke(state[<span class="hljs-string">&quot;messages&quot;</span>])],
    }

<span class="hljs-comment">## The graph</span>
builder = StateGraph(AgentState)

<span class="hljs-comment"># Define nodes: these do the work</span>
builder.add_node(<span class="hljs-string">&quot;assistant&quot;</span>, assistant)
builder.add_node(<span class="hljs-string">&quot;tools&quot;</span>, ToolNode(tools))

<span class="hljs-comment"># Define edges: these determine how the control flow moves</span>
builder.add_edge(START, <span class="hljs-string">&quot;assistant&quot;</span>)
builder.add_conditional_edges(
    <span class="hljs-string">&quot;assistant&quot;</span>,
    <span class="hljs-comment"># If the latest message requires a tool, route to tools</span>
    <span class="hljs-comment"># Otherwise, provide a direct response</span>
    tools_condition,
)
builder.add_edge(<span class="hljs-string">&quot;tools&quot;</span>, <span class="hljs-string">&quot;assistant&quot;</span>)
alfred = builder.<span class="hljs-built_in">compile</span>()

messages = [HumanMessage(content=<span class="hljs-string">&quot;Tell me about our guest named &#x27;Lady Ada Lovelace&#x27;.&quot;</span>)]
response = alfred.invoke({<span class="hljs-string">&quot;messages&quot;</span>: messages})

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;🎩 Alfred&#x27;s Response:&quot;</span>)
<span class="hljs-built_in">print</span>(response[<span class="hljs-string">&#x27;messages&#x27;</span>][-<span class="hljs-number">1</span>].content)`,wrap:!1}}),r=new k({props:{code:"JUYwJTlGJThFJUE5JTIwQWxmcmVkJ3MlMjBSZXNwb25zZSUzQSUwQUxhZHklMjBBZGElMjBMb3ZlbGFjZSUyMGlzJTIwYW4lMjBlc3RlZW1lZCUyMG1hdGhlbWF0aWNpYW4lMjBhbmQlMjBwaW9uZWVyJTIwaW4lMjBjb21wdXRpbmclMkMlMjBvZnRlbiUyMGNlbGVicmF0ZWQlMjBhcyUyMHRoZSUyMGZpcnN0JTIwY29tcHV0ZXIlMjBwcm9ncmFtbWVyJTIwZHVlJTIwdG8lMjBoZXIlMjB3b3JrJTIwb24lMjBDaGFybGVzJTIwQmFiYmFnZSdzJTIwQW5hbHl0aWNhbCUyMEVuZ2luZS4=",highlighted:`🎩 Alfred<span class="hljs-comment">&#x27;s Response:</span>
Lady Ada Lovelace <span class="hljs-built_in">is</span> an esteemed mathematician <span class="hljs-built_in">and</span> pioneer <span class="hljs-keyword">in</span> computing, often celebrated <span class="hljs-keyword">as</span> the first computer programmer due <span class="hljs-keyword">to</span> her work <span class="hljs-keyword">on</span> Charles Babbage<span class="hljs-comment">&#x27;s Analytical Engine.</span>`,wrap:!1}}),{c(){I(i.$$.fragment),h=M(),p=J("p"),p.textContent=d,m=M(),I(r.$$.fragment),t=M(),u=J("p"),u.textContent=j,f=M(),y=J("ul"),y.innerHTML=U},l(n){b(i.$$.fragment,n),h=c(n),p=w(n,"P",{"data-svelte-h":!0}),T(p)!=="svelte-15t3xg7"&&(p.textContent=d),m=c(n),b(r.$$.fragment,n),t=c(n),u=w(n,"P",{"data-svelte-h":!0}),T(u)!=="svelte-18avn85"&&(u.textContent=j),f=c(n),y=w(n,"UL",{"data-svelte-h":!0}),T(y)!=="svelte-1gzv19f"&&(y.innerHTML=U)},m(n,a){g(i,n,a),s(n,h,a),s(n,p,a),s(n,m,a),g(r,n,a),s(n,t,a),s(n,u,a),s(n,f,a),s(n,y,a),$=!0},p:E,i(n){$||(Z(i.$$.fragment,n),Z(r.$$.fragment,n),$=!0)},o(n){C(i.$$.fragment,n),C(r.$$.fragment,n),$=!1},d(n){n&&(l(h),l(p),l(m),l(t),l(u),l(f),l(y)),B(i,n),B(r,n)}}}function ml(G){let i,h,p,d,m,r;return i=new x({props:{id:"agents-frameworks",option:"smolagents",$$slots:{default:[cl]},$$scope:{ctx:G}}}),p=new x({props:{id:"agents-frameworks",option:"llama-index",$$slots:{default:[ul]},$$scope:{ctx:G}}}),m=new x({props:{id:"agents-frameworks",option:"langgraph",$$slots:{default:[dl]},$$scope:{ctx:G}}}),{c(){I(i.$$.fragment),h=M(),I(p.$$.fragment),d=M(),I(m.$$.fragment)},l(t){b(i.$$.fragment,t),h=c(t),b(p.$$.fragment,t),d=c(t),b(m.$$.fragment,t)},m(t,u){g(i,t,u),s(t,h,u),g(p,t,u),s(t,d,u),g(m,t,u),r=!0},p(t,u){const j={};u&2&&(j.$$scope={dirty:u,ctx:t}),i.$set(j);const f={};u&2&&(f.$$scope={dirty:u,ctx:t}),p.$set(f);const y={};u&2&&(y.$$scope={dirty:u,ctx:t}),m.$set(y)},i(t){r||(Z(i.$$.fragment,t),Z(p.$$.fragment,t),Z(m.$$.fragment,t),r=!0)},o(t){C(i.$$.fragment,t),C(p.$$.fragment,t),C(m.$$.fragment,t),r=!1},d(t){t&&(l(h),l(d)),B(i,t),B(p,t),B(m,t)}}}function Jl(G){let i,h,p,d,m,r,t,u="Alfred, your trusted agent, is preparing for the most extravagant gala of the century. To ensure the event runs smoothly, Alfred needs quick access to up-to-date information about each guest. Let’s help Alfred by creating a custom Retrieval-Augmented Generation (RAG) tool, powered by our custom dataset.",j,f,y,U,$="Imagine Alfred mingling among the guests, needing to recall specific details about each person at a moment’s notice. A traditional LLM might struggle with this task because:",n,a,v="<li>The guest list is specific to your event and not in the model’s training data</li> <li>Guest information may change or be updated frequently</li> <li>Alfred needs to retrieve precise details like email addresses</li>",Ze,H,ht="This is where Retrieval Augmented Generation (RAG) shines! By combining a retrieval system with an LLM, Alfred can access accurate, up-to-date information about your guests on demand.",Ce,Q,yt="<p>You can choose any of the frameworks covered in the course for this use case. Select your preferred option from the code tabs.</p>",Be,Y,ve,q,jt="In this unit, we’ll develop our agent within a HF Space, as a structured Python project. This approach helps us maintain clean, modular code by organizing different functionalities into separate files.  Also, this makes for a more realistic use case where you would deploy the application for public use.",Ge,z,$e,L,ft="<li><strong><code>tools.py</code></strong> – Provides auxiliary tools for the agent.</li> <li><strong><code>retriever.py</code></strong> – Implements retrieval functions to support knowledge access.</li> <li><strong><code>app.py</code></strong> – Integrates all components into a fully functional agent, which we’ll finalize in the last part of this unit.</li>",We,D,Ut='For a hands-on reference, check out <a href="https://huggingface.co/spaces/agents-course/Unit_3_Agentic_RAG" rel="nofollow">this HF Space</a>, where the Agentic RAG developed in this unit is live. Feel free to clone it and experiment!',ke,P,It="You can directly test the agent below:",Ve,R,bt,Re,K,Xe,O,gt='Our dataset <a href="https://huggingface.co/datasets/agents-course/unit3-invitees/" rel="nofollow"><code>agents-course/unit3-invitees</code></a> contains the following fields for each guest:',xe,ee,Zt="<li><strong>Name</strong>: Guest’s full name</li> <li><strong>Relation</strong>: How the guest is related to the host</li> <li><strong>Description</strong>: A brief biography or interesting facts about the guest</li> <li><strong>Email Address</strong>: Contact information for sending invitations or follow-ups</li>",Ee,te,Ct="Below is a preview of the dataset:",Qe,X,Bt,_e,_,vt="<p>In a real-world scenario, this dataset could be expanded to include dietary preferences, gift interests, conversation topics to avoid, and other helpful details for a host.</p>",Ne,le,Ae,se,Gt="We’ll create a custom tool that Alfred can use to quickly retrieve guest information during the gala. Let’s break this down into three manageable steps:",Fe,ae,$t="<li>Load and prepare the dataset</li> <li>Create the Retriever Tool</li> <li>Integrate the Tool with Alfred</li>",Se,ne,Wt="Let’s start with loading and preparing the dataset!",He,ie,Ye,oe,kt="First, we need to transform our raw guest data into a format that’s optimized for retrieval.",qe,N,ze,re,Vt="In the code above, we:",Le,pe,Rt="<li>Load the dataset</li> <li>Convert each guest entry into a <code>Document</code> object with formatted content</li> <li>Store the <code>Document</code> objects in a list</li>",De,Me,Xt="This means we’ve got all of our data nicely available so we can get started with configuring our retrieval.",Pe,ce,Ke,ue,xt="Now, let’s create a custom tool that Alfred can use to search through our guest information.",Oe,A,et,de,tt,me,Et="Finally, let’s bring everything together by creating our agent and equipping it with our custom tool:",lt,F,st,Je,at,we,Qt="During the gala, a conversation might flow like this:",nt,Te,_t="<strong>You:</strong> “Alfred, who is that gentleman talking to the ambassador?”",it,he,Nt="<strong>Alfred:</strong> <em>quickly searches the guest database</em> “That’s Dr. Nikola Tesla, sir. He’s an old friend from your university days. He’s recently patented a new wireless energy transmission system and would be delighted to discuss it with you. Just remember he’s passionate about pigeons, so that might make for good small talk.”",ot,ye,rt,je,pt,fe,At="Now that Alfred can retrieve guest information, consider how you might enhance this system:",Mt,Ue,Ft='<li><strong>Improve the retriever</strong> to use a more sophisticated algorithm like <a href="https://www.sbert.net/" rel="nofollow">sentence-transformers</a></li> <li><strong>Implement a conversation memory</strong> so Alfred remembers previous interactions</li> <li><strong>Combine with web search</strong> to get the latest information on unfamiliar guests</li> <li><strong>Integrate multiple indexes</strong> to get more complete information from verified sources</li>',ct,Ie,St="Now Alfred is fully equipped to handle guest inquiries effortlessly, ensuring your gala is remembered as the most sophisticated and delightful event of the century!",ut,S,Ht="<p>Try extending the retriever tool to also return conversation starters based on each guest’s interests or background. How would you modify the tool to accomplish this?</p> <p>When you’re done, implement your guest retriever tool in the <code>retriever.py</code> file.</p>",dt,be,mt,ge,Jt;return m=new V({props:{title:"Creating a RAG Tool for Guest Stories",local:"creating-a-rag-tool-for-guest-stories",headingTag:"h1"}}),f=new V({props:{title:"Why RAG for a Gala?",local:"why-rag-for-a-gala",headingTag:"h2"}}),Y=new V({props:{title:"Setting up our application",local:"setting-up-our-application",headingTag:"h2"}}),z=new V({props:{title:"Project Structure",local:"project-structure",headingTag:"h3"}}),K=new V({props:{title:"Dataset Overview",local:"dataset-overview",headingTag:"h2"}}),le=new V({props:{title:"Building the Guestbook Tool",local:"building-the-guestbook-tool",headingTag:"h2"}}),ie=new V({props:{title:"Step 1: Load and Prepare the Dataset",local:"step-1-load-and-prepare-the-dataset",headingTag:"h3"}}),N=new Tt({props:{id:"agents-frameworks",options:["smolagents","llama-index","langgraph"],$$slots:{default:[il]},$$scope:{ctx:G}}}),ce=new V({props:{title:"Step 2: Create the Retriever Tool",local:"step-2-create-the-retriever-tool",headingTag:"h3"}}),A=new Tt({props:{id:"agents-frameworks",options:["smolagents","llama-index","langgraph"],$$slots:{default:[Ml]},$$scope:{ctx:G}}}),de=new V({props:{title:"Step 3: Integrate the Tool with Alfred",local:"step-3-integrate-the-tool-with-alfred",headingTag:"h3"}}),F=new Tt({props:{id:"agents-frameworks",options:["smolagents","llama-index","langgraph"],$$slots:{default:[ml]},$$scope:{ctx:G}}}),Je=new V({props:{title:"Example Interaction",local:"example-interaction",headingTag:"h2"}}),ye=new k({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIybmFtZSUyMiUzQSUyMCUyMkRyLiUyME5pa29sYSUyMFRlc2xhJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIycmVsYXRpb24lMjIlM0ElMjAlMjJvbGQlMjBmcmllbmQlMjBmcm9tJTIwdW5pdmVyc2l0eSUyMGRheXMlMjIlMkMlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjJkZXNjcmlwdGlvbiUyMiUzQSUyMCUyMkRyLiUyME5pa29sYSUyMFRlc2xhJTIwaXMlMjBhbiUyMG9sZCUyMGZyaWVuZCUyMGZyb20lMjB5b3VyJTIwdW5pdmVyc2l0eSUyMGRheXMuJTIwSGUncyUyMHJlY2VudGx5JTIwcGF0ZW50ZWQlMjBhJTIwbmV3JTIwd2lyZWxlc3MlMjBlbmVyZ3klMjB0cmFuc21pc3Npb24lMjBzeXN0ZW0lMjBhbmQlMjB3b3VsZCUyMGJlJTIwZGVsaWdodGVkJTIwdG8lMjBkaXNjdXNzJTIwaXQlMjB3aXRoJTIweW91LiUyMEp1c3QlMjByZW1lbWJlciUyMGhlJ3MlMjBwYXNzaW9uYXRlJTIwYWJvdXQlMjBwaWdlb25zJTJDJTIwc28lMjB0aGF0JTIwbWlnaHQlMjBtYWtlJTIwZm9yJTIwZ29vZCUyMHNtYWxsJTIwdGFsay4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJlbWFpbCUyMiUzQSUyMCUyMm5pa29sYS50ZXNsYSU0MGdtYWlsLmNvbSUyMiUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Dr. Nikola Tesla&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;relation&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;old friend from university days&quot;</span><span class="hljs-punctuation">,</span>  
    <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Dr. Nikola Tesla is an old friend from your university days. He&#x27;s recently patented a new wireless energy transmission system and would be delighted to discuss it with you. Just remember he&#x27;s passionate about pigeons, so that might make for good small talk.&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;email&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;nikola.tesla@gmail.com&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),je=new V({props:{title:"Taking It Further",local:"taking-it-further",headingTag:"h2"}}),be=new ll({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit3/agentic-rag/invitees.mdx"}}),{c(){i=J("meta"),h=M(),p=J("p"),d=M(),I(m.$$.fragment),r=M(),t=J("p"),t.textContent=u,j=M(),I(f.$$.fragment),y=M(),U=J("p"),U.textContent=$,n=M(),a=J("ol"),a.innerHTML=v,Ze=M(),H=J("p"),H.textContent=ht,Ce=M(),Q=J("blockquote"),Q.innerHTML=yt,Be=M(),I(Y.$$.fragment),ve=M(),q=J("p"),q.textContent=jt,Ge=M(),I(z.$$.fragment),$e=M(),L=J("ul"),L.innerHTML=ft,We=M(),D=J("p"),D.innerHTML=Ut,ke=M(),P=J("p"),P.textContent=It,Ve=M(),R=J("iframe"),Re=M(),I(K.$$.fragment),Xe=M(),O=J("p"),O.innerHTML=gt,xe=M(),ee=J("ul"),ee.innerHTML=Zt,Ee=M(),te=J("p"),te.textContent=Ct,Qe=M(),X=J("iframe"),_e=M(),_=J("blockquote"),_.innerHTML=vt,Ne=M(),I(le.$$.fragment),Ae=M(),se=J("p"),se.textContent=Gt,Fe=M(),ae=J("ol"),ae.innerHTML=$t,Se=M(),ne=J("p"),ne.textContent=Wt,He=M(),I(ie.$$.fragment),Ye=M(),oe=J("p"),oe.textContent=kt,qe=M(),I(N.$$.fragment),ze=M(),re=J("p"),re.textContent=Vt,Le=M(),pe=J("ul"),pe.innerHTML=Rt,De=M(),Me=J("p"),Me.textContent=Xt,Pe=M(),I(ce.$$.fragment),Ke=M(),ue=J("p"),ue.textContent=xt,Oe=M(),I(A.$$.fragment),et=M(),I(de.$$.fragment),tt=M(),me=J("p"),me.textContent=Et,lt=M(),I(F.$$.fragment),st=M(),I(Je.$$.fragment),at=M(),we=J("p"),we.textContent=Qt,nt=M(),Te=J("p"),Te.innerHTML=_t,it=M(),he=J("p"),he.innerHTML=Nt,ot=M(),I(ye.$$.fragment),rt=M(),I(je.$$.fragment),pt=M(),fe=J("p"),fe.textContent=At,Mt=M(),Ue=J("ol"),Ue.innerHTML=Ft,ct=M(),Ie=J("p"),Ie.textContent=St,ut=M(),S=J("blockquote"),S.innerHTML=Ht,dt=M(),I(be.$$.fragment),mt=M(),ge=J("p"),this.h()},l(e){const o=el("svelte-u9bgzb",document.head);i=w(o,"META",{name:!0,content:!0}),o.forEach(l),h=c(e),p=w(e,"P",{}),wt(p).forEach(l),d=c(e),b(m.$$.fragment,e),r=c(e),t=w(e,"P",{"data-svelte-h":!0}),T(t)!=="svelte-1dmibto"&&(t.textContent=u),j=c(e),b(f.$$.fragment,e),y=c(e),U=w(e,"P",{"data-svelte-h":!0}),T(U)!=="svelte-1ohazl4"&&(U.textContent=$),n=c(e),a=w(e,"OL",{"data-svelte-h":!0}),T(a)!=="svelte-jzmsqw"&&(a.innerHTML=v),Ze=c(e),H=w(e,"P",{"data-svelte-h":!0}),T(H)!=="svelte-1pkxjfz"&&(H.textContent=ht),Ce=c(e),Q=w(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),T(Q)!=="svelte-7qfbjg"&&(Q.innerHTML=yt),Be=c(e),b(Y.$$.fragment,e),ve=c(e),q=w(e,"P",{"data-svelte-h":!0}),T(q)!=="svelte-1dq0niz"&&(q.textContent=jt),Ge=c(e),b(z.$$.fragment,e),$e=c(e),L=w(e,"UL",{"data-svelte-h":!0}),T(L)!=="svelte-718qhw"&&(L.innerHTML=ft),We=c(e),D=w(e,"P",{"data-svelte-h":!0}),T(D)!=="svelte-1ahpfas"&&(D.innerHTML=Ut),ke=c(e),P=w(e,"P",{"data-svelte-h":!0}),T(P)!=="svelte-rbljri"&&(P.textContent=It),Ve=c(e),R=w(e,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),wt(R).forEach(l),Re=c(e),b(K.$$.fragment,e),Xe=c(e),O=w(e,"P",{"data-svelte-h":!0}),T(O)!=="svelte-1irlnn3"&&(O.innerHTML=gt),xe=c(e),ee=w(e,"UL",{"data-svelte-h":!0}),T(ee)!=="svelte-kf7jwx"&&(ee.innerHTML=Zt),Ee=c(e),te=w(e,"P",{"data-svelte-h":!0}),T(te)!=="svelte-79xtgg"&&(te.textContent=Ct),Qe=c(e),X=w(e,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),wt(X).forEach(l),_e=c(e),_=w(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),T(_)!=="svelte-1qutpnn"&&(_.innerHTML=vt),Ne=c(e),b(le.$$.fragment,e),Ae=c(e),se=w(e,"P",{"data-svelte-h":!0}),T(se)!=="svelte-1oc2u9p"&&(se.textContent=Gt),Fe=c(e),ae=w(e,"OL",{"data-svelte-h":!0}),T(ae)!=="svelte-u61lb"&&(ae.innerHTML=$t),Se=c(e),ne=w(e,"P",{"data-svelte-h":!0}),T(ne)!=="svelte-1psmdrg"&&(ne.textContent=Wt),He=c(e),b(ie.$$.fragment,e),Ye=c(e),oe=w(e,"P",{"data-svelte-h":!0}),T(oe)!=="svelte-1qfcd42"&&(oe.textContent=kt),qe=c(e),b(N.$$.fragment,e),ze=c(e),re=w(e,"P",{"data-svelte-h":!0}),T(re)!=="svelte-bw00jq"&&(re.textContent=Vt),Le=c(e),pe=w(e,"UL",{"data-svelte-h":!0}),T(pe)!=="svelte-1676c5f"&&(pe.innerHTML=Rt),De=c(e),Me=w(e,"P",{"data-svelte-h":!0}),T(Me)!=="svelte-1mdm43h"&&(Me.textContent=Xt),Pe=c(e),b(ce.$$.fragment,e),Ke=c(e),ue=w(e,"P",{"data-svelte-h":!0}),T(ue)!=="svelte-1bgeoxd"&&(ue.textContent=xt),Oe=c(e),b(A.$$.fragment,e),et=c(e),b(de.$$.fragment,e),tt=c(e),me=w(e,"P",{"data-svelte-h":!0}),T(me)!=="svelte-11fbh5x"&&(me.textContent=Et),lt=c(e),b(F.$$.fragment,e),st=c(e),b(Je.$$.fragment,e),at=c(e),we=w(e,"P",{"data-svelte-h":!0}),T(we)!=="svelte-12f07z5"&&(we.textContent=Qt),nt=c(e),Te=w(e,"P",{"data-svelte-h":!0}),T(Te)!=="svelte-r8vshx"&&(Te.innerHTML=_t),it=c(e),he=w(e,"P",{"data-svelte-h":!0}),T(he)!=="svelte-hi3m2m"&&(he.innerHTML=Nt),ot=c(e),b(ye.$$.fragment,e),rt=c(e),b(je.$$.fragment,e),pt=c(e),fe=w(e,"P",{"data-svelte-h":!0}),T(fe)!=="svelte-1up6x2f"&&(fe.textContent=At),Mt=c(e),Ue=w(e,"OL",{"data-svelte-h":!0}),T(Ue)!=="svelte-1eie5na"&&(Ue.innerHTML=Ft),ct=c(e),Ie=w(e,"P",{"data-svelte-h":!0}),T(Ie)!=="svelte-1upuje4"&&(Ie.textContent=St),ut=c(e),S=w(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),T(S)!=="svelte-1mvfvvl"&&(S.innerHTML=Ht),dt=c(e),b(be.$$.fragment,e),mt=c(e),ge=w(e,"P",{}),wt(ge).forEach(l),this.h()},h(){W(i,"name","hf:doc:metadata"),W(i,"content",wl),W(Q,"class","tip"),Lt(R.src,bt="https://agents-course-unit-3-agentic-rag.hf.space")||W(R,"src",bt),W(R,"frameborder","0"),W(R,"width","850"),W(R,"height","450"),Lt(X.src,Bt="https://huggingface.co/datasets/agents-course/unit3-invitees/embed/viewer/default/train")||W(X,"src",Bt),W(X,"frameborder","0"),W(X,"width","100%"),W(X,"height","560px"),W(_,"class","tip"),W(S,"class","tip")},m(e,o){tl(document.head,i),s(e,h,o),s(e,p,o),s(e,d,o),g(m,e,o),s(e,r,o),s(e,t,o),s(e,j,o),g(f,e,o),s(e,y,o),s(e,U,o),s(e,n,o),s(e,a,o),s(e,Ze,o),s(e,H,o),s(e,Ce,o),s(e,Q,o),s(e,Be,o),g(Y,e,o),s(e,ve,o),s(e,q,o),s(e,Ge,o),g(z,e,o),s(e,$e,o),s(e,L,o),s(e,We,o),s(e,D,o),s(e,ke,o),s(e,P,o),s(e,Ve,o),s(e,R,o),s(e,Re,o),g(K,e,o),s(e,Xe,o),s(e,O,o),s(e,xe,o),s(e,ee,o),s(e,Ee,o),s(e,te,o),s(e,Qe,o),s(e,X,o),s(e,_e,o),s(e,_,o),s(e,Ne,o),g(le,e,o),s(e,Ae,o),s(e,se,o),s(e,Fe,o),s(e,ae,o),s(e,Se,o),s(e,ne,o),s(e,He,o),g(ie,e,o),s(e,Ye,o),s(e,oe,o),s(e,qe,o),g(N,e,o),s(e,ze,o),s(e,re,o),s(e,Le,o),s(e,pe,o),s(e,De,o),s(e,Me,o),s(e,Pe,o),g(ce,e,o),s(e,Ke,o),s(e,ue,o),s(e,Oe,o),g(A,e,o),s(e,et,o),g(de,e,o),s(e,tt,o),s(e,me,o),s(e,lt,o),g(F,e,o),s(e,st,o),g(Je,e,o),s(e,at,o),s(e,we,o),s(e,nt,o),s(e,Te,o),s(e,it,o),s(e,he,o),s(e,ot,o),g(ye,e,o),s(e,rt,o),g(je,e,o),s(e,pt,o),s(e,fe,o),s(e,Mt,o),s(e,Ue,o),s(e,ct,o),s(e,Ie,o),s(e,ut,o),s(e,S,o),s(e,dt,o),g(be,e,o),s(e,mt,o),s(e,ge,o),Jt=!0},p(e,[o]){const Yt={};o&2&&(Yt.$$scope={dirty:o,ctx:e}),N.$set(Yt);const qt={};o&2&&(qt.$$scope={dirty:o,ctx:e}),A.$set(qt);const zt={};o&2&&(zt.$$scope={dirty:o,ctx:e}),F.$set(zt)},i(e){Jt||(Z(m.$$.fragment,e),Z(f.$$.fragment,e),Z(Y.$$.fragment,e),Z(z.$$.fragment,e),Z(K.$$.fragment,e),Z(le.$$.fragment,e),Z(ie.$$.fragment,e),Z(N.$$.fragment,e),Z(ce.$$.fragment,e),Z(A.$$.fragment,e),Z(de.$$.fragment,e),Z(F.$$.fragment,e),Z(Je.$$.fragment,e),Z(ye.$$.fragment,e),Z(je.$$.fragment,e),Z(be.$$.fragment,e),Jt=!0)},o(e){C(m.$$.fragment,e),C(f.$$.fragment,e),C(Y.$$.fragment,e),C(z.$$.fragment,e),C(K.$$.fragment,e),C(le.$$.fragment,e),C(ie.$$.fragment,e),C(N.$$.fragment,e),C(ce.$$.fragment,e),C(A.$$.fragment,e),C(de.$$.fragment,e),C(F.$$.fragment,e),C(Je.$$.fragment,e),C(ye.$$.fragment,e),C(je.$$.fragment,e),C(be.$$.fragment,e),Jt=!1},d(e){e&&(l(h),l(p),l(d),l(r),l(t),l(j),l(y),l(U),l(n),l(a),l(Ze),l(H),l(Ce),l(Q),l(Be),l(ve),l(q),l(Ge),l($e),l(L),l(We),l(D),l(ke),l(P),l(Ve),l(R),l(Re),l(Xe),l(O),l(xe),l(ee),l(Ee),l(te),l(Qe),l(X),l(_e),l(_),l(Ne),l(Ae),l(se),l(Fe),l(ae),l(Se),l(ne),l(He),l(Ye),l(oe),l(qe),l(ze),l(re),l(Le),l(pe),l(De),l(Me),l(Pe),l(Ke),l(ue),l(Oe),l(et),l(tt),l(me),l(lt),l(st),l(at),l(we),l(nt),l(Te),l(it),l(he),l(ot),l(rt),l(pt),l(fe),l(Mt),l(Ue),l(ct),l(Ie),l(ut),l(S),l(dt),l(mt),l(ge)),l(i),B(m,e),B(f,e),B(Y,e),B(z,e),B(K,e),B(le,e),B(ie,e),B(N,e),B(ce,e),B(A,e),B(de,e),B(F,e),B(Je,e),B(ye,e),B(je,e),B(be,e)}}}const wl='{"title":"Creating a RAG Tool for Guest Stories","local":"creating-a-rag-tool-for-guest-stories","sections":[{"title":"Why RAG for a Gala?","local":"why-rag-for-a-gala","sections":[],"depth":2},{"title":"Setting up our application","local":"setting-up-our-application","sections":[{"title":"Project Structure","local":"project-structure","sections":[],"depth":3}],"depth":2},{"title":"Dataset Overview","local":"dataset-overview","sections":[],"depth":2},{"title":"Building the Guestbook Tool","local":"building-the-guestbook-tool","sections":[{"title":"Step 1: Load and Prepare the Dataset","local":"step-1-load-and-prepare-the-dataset","sections":[],"depth":3},{"title":"Step 2: Create the Retriever Tool","local":"step-2-create-the-retriever-tool","sections":[],"depth":3},{"title":"Step 3: Integrate the Tool with Alfred","local":"step-3-integrate-the-tool-with-alfred","sections":[],"depth":3}],"depth":2},{"title":"Example Interaction","local":"example-interaction","sections":[],"depth":2},{"title":"Taking It Further","local":"taking-it-further","sections":[],"depth":2}],"depth":1}';function Tl(G){return Pt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bl extends Kt{constructor(i){super(),Ot(this,i,Tl,Jl,Dt,{})}}export{bl as component};
