import{s as Sn,n as An,o as Yn}from"../chunks/scheduler.37c15a92.js";import{S as qn,i as Fn,g as i,s as a,r as m,A as Nn,h as o,f as n,c as s,j as Xt,u as d,x as r,k as Z,y,a as l,v as c,d as u,t as p,w as h}from"../chunks/index.2bf4358c.js";import{C as M}from"../chunks/CodeBlock.4e987730.js";import{H as Ue}from"../chunks/Heading.8ada512a.js";import{E as Qn}from"../chunks/getInferenceSnippets.0aa3753f.js";function Pn(Qt){let g,Ge,We,Ee,j,Ve,C,Pt=`Remember Alfred, our helpful butler agent from Unit 1?
To assist us effectively, Alfred needs to understand our requests and <strong>prepare, find and use relevant information to help complete tasks.</strong>
This is where LlamaIndex’s components come in.`,He,I,zt=`While LlamaIndex has many components, <strong>we’ll focus specifically on the <code>QueryEngine</code> component.</strong>
Why? Because it can be used as a Retrieval-Augmented Generation (RAG) tool for an agent.`,Be,k,Ot=`So, what is RAG? LLMs are trained on enormous bodies of data to learn general knowledge.
However, they may not be trained on relevant and up-to-date data.
RAG solves this problem by finding and retrieving relevant information from your data and giving that to the LLM.`,Re,_,Dt='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/llama-index/rag.png" alt="RAG"/>',Xe,W,Kt="Now, think about how Alfred works:",Se,$,en="<li>You ask Alfred to help plan a dinner party</li> <li>Alfred needs to check your calendar, dietary preferences, and past successful menus</li> <li>The <code>QueryEngine</code> helps Alfred find this information and use it to plan the dinner party</li>",Ae,G,tn=`This makes the <code>QueryEngine</code> <strong>a key component for building agentic RAG workflows</strong> in LlamaIndex.
Just as Alfred needs to search through your household information to be helpful, any agent needs a way to find and understand relevant data.
The <code>QueryEngine</code> provides exactly this capability.`,Ye,E,nn="Now, let’s dive a bit deeper into the components and see how you can <strong>combine components to create a RAG pipeline.</strong>",qe,V,Fe,v,ln='<p>You can follow the code in <a href="https://huggingface.co/agents-course/notebooks/blob/main/unit2/llama-index/components.ipynb" target="_blank">this notebook</a> that you can run using Google Colab.</p>',Ne,H,an="There are five key stages within RAG, which in turn will be a part of most larger applications you build. These are:",Qe,B,sn="<li><strong>Loading</strong>: this refers to getting your data from where it lives — whether it’s text files, PDFs, another website, a database, or an API — into your workflow. LlamaHub provides hundreds of integrations to choose from.</li> <li><strong>Indexing</strong>: this means creating a data structure that allows for querying the data. For LLMs, this nearly always means creating vector embeddings. Which are numerical representations of the meaning of the data. Indexing can also refer to numerous other metadata strategies to make it easy to accurately find contextually relevant data based on properties.</li> <li><strong>Storing</strong>: once your data is indexed you will want to store your index, as well as other metadata, to avoid having to re-index it.</li> <li><strong>Querying</strong>: for any given indexing strategy there are many ways you can utilize LLMs and LlamaIndex data structures to query, including sub-queries, multi-step queries and hybrid strategies.</li> <li><strong>Evaluation</strong>: a critical step in any flow is checking how effective it is relative to other strategies, or when you make changes. Evaluation provides objective measures of how accurate, faithful and fast your responses to queries are.</li>",Pe,R,on="Next, let’s see how we can reproduce these stages using components.",ze,X,Oe,S,rn=`As mentioned before, LlamaIndex can work on top of your own data, however, <strong>before accessing data, we need to load it.</strong>
There are three main ways to load data into LlamaIndex:`,De,A,mn="<li><code>SimpleDirectoryReader</code>: A built-in loader for various file types from a local directory.</li> <li><code>LlamaParse</code>: LlamaParse, LlamaIndex’s official tool for PDF parsing, available as a managed API.</li> <li><code>LlamaHub</code>: A registry of hundreds of data-loading libraries to ingest data from any source.</li>",Ke,T,dn='<p>Get familiar with <a href="https://docs.llamaindex.ai/en/stable/module_guides/loading/connector/">LlamaHub</a> loaders and <a href="https://github.com/run-llama/llama_cloud_services/blob/main/parse.md">LlamaParse</a> parser for more complex data sources.</p>',et,Y,cn=`<strong>The simplest way to load data is with <code>SimpleDirectoryReader</code>.</strong>
This versatile component can load various file types from a folder and convert them into <code>Document</code> objects that LlamaIndex can work with.
Let’s see how we can use <code>SimpleDirectoryReader</code> to load data from a folder.`,tt,q,nt,F,un=`After loading our documents, we need to break them into smaller pieces called <code>Node</code> objects.
A <code>Node</code> is just a chunk of text from the original document that’s easier for the AI to work with, while it still has references to the original <code>Document</code> object.`,lt,N,pn="The <code>IngestionPipeline</code> helps us create these nodes through two key transformations.",at,Q,hn="<li><code>SentenceSplitter</code> breaks down documents into manageable chunks by splitting them at natural sentence boundaries.</li> <li><code>HuggingFaceEmbedding</code> converts each chunk into numerical embeddings - vector representations that capture the semantic meaning in a way AI can process efficiently.</li>",st,P,fn="This process helps us organise our documents in a way that’s more useful for searching and analysis.",it,z,ot,O,rt,D,yn="After creating our <code>Node</code> objects we need to index them to make them searchable, but before we can do that, we need a place to store our data.",mt,K,bn=`Since we are using an ingestion pipeline, we can directly attach a vector store to the pipeline to populate it.
In this case, we will use <code>Chroma</code> to store our documents.`,dt,b,Le,wn="Install ChromaDB",St,Ze,gn='As introduced in the <a href="./llama-hub">section on the LlamaHub</a>, we can install the ChromaDB vector store with the following command:',At,ee,ct,te,ut,x,Mn='<p>An overview of the different vector stores can be found in the <a href="https://docs.llamaindex.ai/en/stable/module_guides/storing/vector_stores/">LlamaIndex documentation</a>.</p>',pt,ne,vn=`This is where vector embeddings come in - by embedding both the query and nodes in the same vector space, we can find relevant matches.
The <code>VectorStoreIndex</code> handles this for us, using the same embedding model we used during ingestion to ensure consistency.`,ht,le,Tn="Let’s see how to create this index from our vector store and embeddings:",ft,ae,yt,se,xn="All information is automatically persisted within the <code>ChromaVectorStore</code> object and the passed directory path.",bt,ie,Jn="Great! Now that we can save and load our index easily, let’s explore how to query it in different ways.",wt,oe,gt,re,Un="Before we can query our index, we need to convert it to a query interface. The most common conversion options are:",Mt,me,Ln="<li><code>as_retriever</code>: For basic document retrieval, returning a list of <code>NodeWithScore</code> objects with similarity scores</li> <li><code>as_query_engine</code>: For single question-answer interactions, returning a written response</li> <li><code>as_chat_engine</code>: For conversational interactions that maintain memory across multiple messages, returning a written response using chat history and indexed context</li>",vt,de,Zn=`We’ll focus on the query engine since it is more common for agent-like interactions.
We also pass in an LLM to the query engine to use for the response.`,Tt,ce,xt,ue,Jt,pe,jn=`Under the hood, the query engine doesn’t only use the LLM to answer the question but also uses a <code>ResponseSynthesizer</code> as a strategy to process the response.
Once again, this is fully customisable but there are three main strategies that work well out of the box:`,Ut,he,Cn="<li><code>refine</code>: create and refine an answer by sequentially going through each retrieved text chunk. This makes a separate LLM call per Node/retrieved chunk.</li> <li><code>compact</code> (default): similar to refining but concatenating the chunks beforehand, resulting in fewer LLM calls.</li> <li><code>tree_summarize</code>: create a detailed answer by going through each retrieved text chunk and creating a tree structure of the answer.</li>",Lt,J,In='<p>Take fine-grained control of your query workflows with the <a href="https://docs.llamaindex.ai/en/stable/module_guides/deploying/query_engine/usage_pattern/#low-level-composition-api">low-level composition API</a>. This API lets you customize and fine-tune every step of the query process to match your exact needs, which also pairs great with <a href="https://docs.llamaindex.ai/en/stable/module_guides/workflow/">Workflows</a></p>',Zt,fe,kn="The language model won’t always perform in predictable ways, so we can’t be sure that the answer we get is always correct. We can deal with this by <strong>evaluating the quality of the answer</strong>.",jt,ye,Ct,be,_n=`LlamaIndex provides <strong>built-in evaluation tools to assess response quality.</strong>
These evaluators leverage LLMs to analyze responses across different dimensions.
Let’s look at the three main evaluators available:`,It,we,Wn="<li><code>FaithfulnessEvaluator</code>: Evaluates the faithfulness of the answer by checking if the answer is supported by the context.</li> <li><code>AnswerRelevancyEvaluator</code>: Evaluate the relevance of the answer by checking if the answer is relevant to the question.</li> <li><code>CorrectnessEvaluator</code>: Evaluate the correctness of the answer by checking if the answer is correct.</li>",kt,U,$n='<p>Want to learn more about agent observability and evaluation? Continue your journey with the <a href="https://huggingface.co/learn/agents-course/bonus-unit2/introduction">Bonus Unit 2</a>.</p>',_t,ge,Wt,Me,Gn=`Even without direct evaluation, we can <strong>gain insights into how our system is performing through observability.</strong>
This is especially useful when we are building more complex workflows and want to understand how each component is performing.`,$t,f,je,En="Install LlamaTrace",Yt,Ce,Vn='As introduced in the <a href="./llama-hub">section on the LlamaHub</a>, we can install the LlamaTrace callback from Arize Phoenix with the following command:',qt,ve,Ft,Ie,Hn="Additionally, we need to set the <code>PHOENIX_API_KEY</code> environment variable to our LlamaTrace API key. We can get this by:",Nt,ke,Bn='<li>Creating an account at <a href="https://llamatrace.com/login" rel="nofollow">LlamaTrace</a></li> <li>Generating an API key in your account settings</li> <li>Using the API key in the code below to enable tracing</li>',Gt,Te,Et,L,Rn='<p>Want to learn more about components and how to use them? Continue your journey with the <a href="https://docs.llamaindex.ai/en/stable/module_guides/">Components Guides</a> or the <a href="https://docs.llamaindex.ai/en/stable/understanding/rag/">Guide on RAG</a>.</p>',Vt,xe,Xn="We have seen how to use components to create a <code>QueryEngine</code>. Now, let’s see how we can <strong>use the <code>QueryEngine</code> as a tool for an agent!</strong>",Ht,Je,Bt,$e,Rt;return j=new Ue({props:{title:"What are components in LlamaIndex?",local:"what-are-components-in-llamaindex",headingTag:"h1"}}),V=new Ue({props:{title:"Creating a RAG pipeline using components",local:"creating-a-rag-pipeline-using-components",headingTag:"h2"}}),X=new Ue({props:{title:"Loading and embedding documents",local:"loading-and-embedding-documents",headingTag:"h3"}}),q=new M({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUlMjBpbXBvcnQlMjBTaW1wbGVEaXJlY3RvcnlSZWFkZXIlMEElMEFyZWFkZXIlMjAlM0QlMjBTaW1wbGVEaXJlY3RvcnlSZWFkZXIoaW5wdXRfZGlyJTNEJTIycGF0aCUyRnRvJTJGZGlyZWN0b3J5JTIyKSUwQWRvY3VtZW50cyUyMCUzRCUyMHJlYWRlci5sb2FkX2RhdGEoKQ==",highlighted:`<span class="hljs-keyword">from</span> llama_index.core <span class="hljs-keyword">import</span> SimpleDirectoryReader

reader = SimpleDirectoryReader(input_dir=<span class="hljs-string">&quot;path/to/directory&quot;</span>)
documents = reader.load_data()`,wrap:!1}}),z=new M({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUlMjBpbXBvcnQlMjBEb2N1bWVudCUwQWZyb20lMjBsbGFtYV9pbmRleC5lbWJlZGRpbmdzLmh1Z2dpbmdmYWNlJTIwaW1wb3J0JTIwSHVnZ2luZ0ZhY2VFbWJlZGRpbmclMEFmcm9tJTIwbGxhbWFfaW5kZXguY29yZS5ub2RlX3BhcnNlciUyMGltcG9ydCUyMFNlbnRlbmNlU3BsaXR0ZXIlMEFmcm9tJTIwbGxhbWFfaW5kZXguY29yZS5pbmdlc3Rpb24lMjBpbXBvcnQlMjBJbmdlc3Rpb25QaXBlbGluZSUwQSUwQSUyMyUyMGNyZWF0ZSUyMHRoZSUyMHBpcGVsaW5lJTIwd2l0aCUyMHRyYW5zZm9ybWF0aW9ucyUwQXBpcGVsaW5lJTIwJTNEJTIwSW5nZXN0aW9uUGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwdHJhbnNmb3JtYXRpb25zJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwU2VudGVuY2VTcGxpdHRlcihjaHVua19vdmVybGFwJTNEMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBIdWdnaW5nRmFjZUVtYmVkZGluZyhtb2RlbF9uYW1lJTNEJTIyQkFBSSUyRmJnZS1zbWFsbC1lbi12MS41JTIyKSUyQyUwQSUyMCUyMCUyMCUyMCU1RCUwQSklMEElMEFub2RlcyUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUuYXJ1bihkb2N1bWVudHMlM0QlNUJEb2N1bWVudC5leGFtcGxlKCklNUQp",highlighted:`<span class="hljs-keyword">from</span> llama_index.core <span class="hljs-keyword">import</span> Document
<span class="hljs-keyword">from</span> llama_index.embeddings.huggingface <span class="hljs-keyword">import</span> HuggingFaceEmbedding
<span class="hljs-keyword">from</span> llama_index.core.node_parser <span class="hljs-keyword">import</span> SentenceSplitter
<span class="hljs-keyword">from</span> llama_index.core.ingestion <span class="hljs-keyword">import</span> IngestionPipeline

<span class="hljs-comment"># create the pipeline with transformations</span>
pipeline = IngestionPipeline(
    transformations=[
        SentenceSplitter(chunk_overlap=<span class="hljs-number">0</span>),
        HuggingFaceEmbedding(model_name=<span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>),
    ]
)

nodes = <span class="hljs-keyword">await</span> pipeline.arun(documents=[Document.example()])`,wrap:!1}}),O=new Ue({props:{title:"Storing and indexing documents",local:"storing-and-indexing-documents",headingTag:"h3"}}),ee=new M({props:{code:"cGlwJTIwaW5zdGFsbCUyMGxsYW1hLWluZGV4LXZlY3Rvci1zdG9yZXMtY2hyb21h",highlighted:"pip install llama-index-vector-stores-chroma",wrap:!1}}),te=new M({props:{code:"aW1wb3J0JTIwY2hyb21hZGIlMEFmcm9tJTIwbGxhbWFfaW5kZXgudmVjdG9yX3N0b3Jlcy5jaHJvbWElMjBpbXBvcnQlMjBDaHJvbWFWZWN0b3JTdG9yZSUwQSUwQWRiJTIwJTNEJTIwY2hyb21hZGIuUGVyc2lzdGVudENsaWVudChwYXRoJTNEJTIyLiUyRmFsZnJlZF9jaHJvbWFfZGIlMjIpJTBBY2hyb21hX2NvbGxlY3Rpb24lMjAlM0QlMjBkYi5nZXRfb3JfY3JlYXRlX2NvbGxlY3Rpb24oJTIyYWxmcmVkJTIyKSUwQXZlY3Rvcl9zdG9yZSUyMCUzRCUyMENocm9tYVZlY3RvclN0b3JlKGNocm9tYV9jb2xsZWN0aW9uJTNEY2hyb21hX2NvbGxlY3Rpb24pJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBJbmdlc3Rpb25QaXBlbGluZSglMEElMjAlMjAlMjAlMjB0cmFuc2Zvcm1hdGlvbnMlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBTZW50ZW5jZVNwbGl0dGVyKGNodW5rX3NpemUlM0QyNSUyQyUyMGNodW5rX292ZXJsYXAlM0QwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEh1Z2dpbmdGYWNlRW1iZWRkaW5nKG1vZGVsX25hbWUlM0QlMjJCQUFJJTJGYmdlLXNtYWxsLWVuLXYxLjUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwdmVjdG9yX3N0b3JlJTNEdmVjdG9yX3N0b3JlJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> chromadb
<span class="hljs-keyword">from</span> llama_index.vector_stores.chroma <span class="hljs-keyword">import</span> ChromaVectorStore

db = chromadb.PersistentClient(path=<span class="hljs-string">&quot;./alfred_chroma_db&quot;</span>)
chroma_collection = db.get_or_create_collection(<span class="hljs-string">&quot;alfred&quot;</span>)
vector_store = ChromaVectorStore(chroma_collection=chroma_collection)

pipeline = IngestionPipeline(
    transformations=[
        SentenceSplitter(chunk_size=<span class="hljs-number">25</span>, chunk_overlap=<span class="hljs-number">0</span>),
        HuggingFaceEmbedding(model_name=<span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>),
    ],
    vector_store=vector_store,
)`,wrap:!1}}),ae=new M({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUlMjBpbXBvcnQlMjBWZWN0b3JTdG9yZUluZGV4JTBBZnJvbSUyMGxsYW1hX2luZGV4LmVtYmVkZGluZ3MuaHVnZ2luZ2ZhY2UlMjBpbXBvcnQlMjBIdWdnaW5nRmFjZUVtYmVkZGluZyUwQSUwQWVtYmVkX21vZGVsJTIwJTNEJTIwSHVnZ2luZ0ZhY2VFbWJlZGRpbmcobW9kZWxfbmFtZSUzRCUyMkJBQUklMkZiZ2Utc21hbGwtZW4tdjEuNSUyMiklMEFpbmRleCUyMCUzRCUyMFZlY3RvclN0b3JlSW5kZXguZnJvbV92ZWN0b3Jfc3RvcmUodmVjdG9yX3N0b3JlJTJDJTIwZW1iZWRfbW9kZWwlM0RlbWJlZF9tb2RlbCk=",highlighted:`<span class="hljs-keyword">from</span> llama_index.core <span class="hljs-keyword">import</span> VectorStoreIndex
<span class="hljs-keyword">from</span> llama_index.embeddings.huggingface <span class="hljs-keyword">import</span> HuggingFaceEmbedding

embed_model = HuggingFaceEmbedding(model_name=<span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>)
index = VectorStoreIndex.from_vector_store(vector_store, embed_model=embed_model)`,wrap:!1}}),oe=new Ue({props:{title:"Querying a VectorStoreIndex with prompts and LLMs",local:"querying-a-vectorstoreindex-with-prompts-and-llms",headingTag:"h3"}}),ce=new M({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmxsbXMuaHVnZ2luZ2ZhY2VfYXBpJTIwaW1wb3J0JTIwSHVnZ2luZ0ZhY2VJbmZlcmVuY2VBUEklMEElMEFsbG0lMjAlM0QlMjBIdWdnaW5nRmFjZUluZmVyZW5jZUFQSShtb2RlbF9uYW1lJTNEJTIyUXdlbiUyRlF3ZW4yLjUtQ29kZXItMzJCLUluc3RydWN0JTIyKSUwQXF1ZXJ5X2VuZ2luZSUyMCUzRCUyMGluZGV4LmFzX3F1ZXJ5X2VuZ2luZSglMEElMjAlMjAlMjAlMjBsbG0lM0RsbG0lMkMlMEElMjAlMjAlMjAlMjByZXNwb25zZV9tb2RlJTNEJTIydHJlZV9zdW1tYXJpemUlMjIlMkMlMEEpJTBBcXVlcnlfZW5naW5lLnF1ZXJ5KCUyMldoYXQlMjBpcyUyMHRoZSUyMG1lYW5pbmclMjBvZiUyMGxpZmUlM0YlMjIpJTBBJTIzJTIwVGhlJTIwbWVhbmluZyUyMG9mJTIwbGlmZSUyMGlzJTIwNDI=",highlighted:`<span class="hljs-keyword">from</span> llama_index.llms.huggingface_api <span class="hljs-keyword">import</span> HuggingFaceInferenceAPI

llm = HuggingFaceInferenceAPI(model_name=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)
query_engine = index.as_query_engine(
    llm=llm,
    response_mode=<span class="hljs-string">&quot;tree_summarize&quot;</span>,
)
query_engine.query(<span class="hljs-string">&quot;What is the meaning of life?&quot;</span>)
<span class="hljs-comment"># The meaning of life is 42</span>`,wrap:!1}}),ue=new Ue({props:{title:"Response Processing",local:"response-processing",headingTag:"h3"}}),ye=new Ue({props:{title:"Evaluation and observability",local:"evaluation-and-observability",headingTag:"h3"}}),ge=new M({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUuZXZhbHVhdGlvbiUyMGltcG9ydCUyMEZhaXRoZnVsbmVzc0V2YWx1YXRvciUwQSUwQXF1ZXJ5X2VuZ2luZSUyMCUzRCUyMCUyMyUyMGZyb20lMjB0aGUlMjBwcmV2aW91cyUyMHNlY3Rpb24lMEFsbG0lMjAlM0QlMjAlMjMlMjBmcm9tJTIwdGhlJTIwcHJldmlvdXMlMjBzZWN0aW9uJTBBJTBBJTIzJTIwcXVlcnklMjBpbmRleCUwQWV2YWx1YXRvciUyMCUzRCUyMEZhaXRoZnVsbmVzc0V2YWx1YXRvcihsbG0lM0RsbG0pJTBBcmVzcG9uc2UlMjAlM0QlMjBxdWVyeV9lbmdpbmUucXVlcnkoJTBBJTIwJTIwJTIwJTIwJTIyV2hhdCUyMGJhdHRsZXMlMjB0b29rJTIwcGxhY2UlMjBpbiUyME5ldyUyMFlvcmslMjBDaXR5JTIwaW4lMjB0aGUlMjBBbWVyaWNhbiUyMFJldm9sdXRpb24lM0YlMjIlMEEpJTBBZXZhbF9yZXN1bHQlMjAlM0QlMjBldmFsdWF0b3IuZXZhbHVhdGVfcmVzcG9uc2UocmVzcG9uc2UlM0RyZXNwb25zZSklMEFldmFsX3Jlc3VsdC5wYXNzaW5n",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.evaluation <span class="hljs-keyword">import</span> FaithfulnessEvaluator

query_engine = <span class="hljs-comment"># from the previous section</span>
llm = <span class="hljs-comment"># from the previous section</span>

<span class="hljs-comment"># query index</span>
evaluator = FaithfulnessEvaluator(llm=llm)
response = query_engine.query(
    <span class="hljs-string">&quot;What battles took place in New York City in the American Revolution?&quot;</span>
)
eval_result = evaluator.evaluate_response(response=response)
eval_result.passing`,wrap:!1}}),ve=new M({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwbGxhbWEtaW5kZXgtY2FsbGJhY2tzLWFyaXplLXBob2VuaXg=",highlighted:"pip install -U llama-index-callbacks-arize-phoenix",wrap:!1}}),Te=new M({props:{code:"aW1wb3J0JTIwbGxhbWFfaW5kZXglMEFpbXBvcnQlMjBvcyUwQSUwQVBIT0VOSVhfQVBJX0tFWSUyMCUzRCUyMCUyMiUzQ1BIT0VOSVhfQVBJX0tFWSUzRSUyMiUwQW9zLmVudmlyb24lNUIlMjJPVEVMX0VYUE9SVEVSX09UTFBfSEVBREVSUyUyMiU1RCUyMCUzRCUyMGYlMjJhcGlfa2V5JTNEJTdCUEhPRU5JWF9BUElfS0VZJTdEJTIyJTBBbGxhbWFfaW5kZXguY29yZS5zZXRfZ2xvYmFsX2hhbmRsZXIoJTBBJTIwJTIwJTIwJTIwJTIyYXJpemVfcGhvZW5peCUyMiUyQyUwQSUyMCUyMCUyMCUyMGVuZHBvaW50JTNEJTIyaHR0cHMlM0ElMkYlMkZsbGFtYXRyYWNlLmNvbSUyRnYxJTJGdHJhY2VzJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> llama_index
<span class="hljs-keyword">import</span> os

PHOENIX_API_KEY = <span class="hljs-string">&quot;&lt;PHOENIX_API_KEY&gt;&quot;</span>
os.environ[<span class="hljs-string">&quot;OTEL_EXPORTER_OTLP_HEADERS&quot;</span>] = <span class="hljs-string">f&quot;api_key=<span class="hljs-subst">{PHOENIX_API_KEY}</span>&quot;</span>
llama_index.core.set_global_handler(
    <span class="hljs-string">&quot;arize_phoenix&quot;</span>,
    endpoint=<span class="hljs-string">&quot;https://llamatrace.com/v1/traces&quot;</span>
)`,wrap:!1}}),Je=new Qn({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit2/llama-index/components.mdx"}}),{c(){g=i("meta"),Ge=a(),We=i("p"),Ee=a(),m(j.$$.fragment),Ve=a(),C=i("p"),C.innerHTML=Pt,He=a(),I=i("p"),I.innerHTML=zt,Be=a(),k=i("p"),k.textContent=Ot,Re=a(),_=i("p"),_.innerHTML=Dt,Xe=a(),W=i("p"),W.textContent=Kt,Se=a(),$=i("ol"),$.innerHTML=en,Ae=a(),G=i("p"),G.innerHTML=tn,Ye=a(),E=i("p"),E.innerHTML=nn,qe=a(),m(V.$$.fragment),Fe=a(),v=i("blockquote"),v.innerHTML=ln,Ne=a(),H=i("p"),H.textContent=an,Qe=a(),B=i("ol"),B.innerHTML=sn,Pe=a(),R=i("p"),R.textContent=on,ze=a(),m(X.$$.fragment),Oe=a(),S=i("p"),S.innerHTML=rn,De=a(),A=i("ol"),A.innerHTML=mn,Ke=a(),T=i("blockquote"),T.innerHTML=dn,et=a(),Y=i("p"),Y.innerHTML=cn,tt=a(),m(q.$$.fragment),nt=a(),F=i("p"),F.innerHTML=un,lt=a(),N=i("p"),N.innerHTML=pn,at=a(),Q=i("ol"),Q.innerHTML=hn,st=a(),P=i("p"),P.textContent=fn,it=a(),m(z.$$.fragment),ot=a(),m(O.$$.fragment),rt=a(),D=i("p"),D.innerHTML=yn,mt=a(),K=i("p"),K.innerHTML=bn,dt=a(),b=i("details"),Le=i("summary"),Le.textContent=wn,St=a(),Ze=i("p"),Ze.innerHTML=gn,At=a(),m(ee.$$.fragment),ct=a(),m(te.$$.fragment),ut=a(),x=i("blockquote"),x.innerHTML=Mn,pt=a(),ne=i("p"),ne.innerHTML=vn,ht=a(),le=i("p"),le.textContent=Tn,ft=a(),m(ae.$$.fragment),yt=a(),se=i("p"),se.innerHTML=xn,bt=a(),ie=i("p"),ie.textContent=Jn,wt=a(),m(oe.$$.fragment),gt=a(),re=i("p"),re.textContent=Un,Mt=a(),me=i("ul"),me.innerHTML=Ln,vt=a(),de=i("p"),de.textContent=Zn,Tt=a(),m(ce.$$.fragment),xt=a(),m(ue.$$.fragment),Jt=a(),pe=i("p"),pe.innerHTML=jn,Ut=a(),he=i("ul"),he.innerHTML=Cn,Lt=a(),J=i("blockquote"),J.innerHTML=In,Zt=a(),fe=i("p"),fe.innerHTML=kn,jt=a(),m(ye.$$.fragment),Ct=a(),be=i("p"),be.innerHTML=_n,It=a(),we=i("ul"),we.innerHTML=Wn,kt=a(),U=i("blockquote"),U.innerHTML=$n,_t=a(),m(ge.$$.fragment),Wt=a(),Me=i("p"),Me.innerHTML=Gn,$t=a(),f=i("details"),je=i("summary"),je.textContent=En,Yt=a(),Ce=i("p"),Ce.innerHTML=Vn,qt=a(),m(ve.$$.fragment),Ft=a(),Ie=i("p"),Ie.innerHTML=Hn,Nt=a(),ke=i("ul"),ke.innerHTML=Bn,Gt=a(),m(Te.$$.fragment),Et=a(),L=i("blockquote"),L.innerHTML=Rn,Vt=a(),xe=i("p"),xe.innerHTML=Xn,Ht=a(),m(Je.$$.fragment),Bt=a(),$e=i("p"),this.h()},l(e){const t=Nn("svelte-u9bgzb",document.head);g=o(t,"META",{name:!0,content:!0}),t.forEach(n),Ge=s(e),We=o(e,"P",{}),Xt(We).forEach(n),Ee=s(e),d(j.$$.fragment,e),Ve=s(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1vh4okn"&&(C.innerHTML=Pt),He=s(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-35rbyv"&&(I.innerHTML=zt),Be=s(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1dt1sd0"&&(k.textContent=Ot),Re=s(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-kysd50"&&(_.innerHTML=Dt),Xe=s(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-aqkixd"&&(W.textContent=Kt),Se=s(e),$=o(e,"OL",{"data-svelte-h":!0}),r($)!=="svelte-135qvuu"&&($.innerHTML=en),Ae=s(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-mnkj36"&&(G.innerHTML=tn),Ye=s(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-ga98sq"&&(E.innerHTML=nn),qe=s(e),d(V.$$.fragment,e),Fe=s(e),v=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(v)!=="svelte-1xg39e4"&&(v.innerHTML=ln),Ne=s(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-bhgae9"&&(H.textContent=an),Qe=s(e),B=o(e,"OL",{"data-svelte-h":!0}),r(B)!=="svelte-1y6wwuy"&&(B.innerHTML=sn),Pe=s(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-12zc4us"&&(R.textContent=on),ze=s(e),d(X.$$.fragment,e),Oe=s(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1246hsd"&&(S.innerHTML=rn),De=s(e),A=o(e,"OL",{"data-svelte-h":!0}),r(A)!=="svelte-iz7p8h"&&(A.innerHTML=mn),Ke=s(e),T=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(T)!=="svelte-1v11qmv"&&(T.innerHTML=dn),et=s(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1c6elju"&&(Y.innerHTML=cn),tt=s(e),d(q.$$.fragment,e),nt=s(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-4bo0to"&&(F.innerHTML=un),lt=s(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1uspfck"&&(N.innerHTML=pn),at=s(e),Q=o(e,"OL",{"data-svelte-h":!0}),r(Q)!=="svelte-1slr2bx"&&(Q.innerHTML=hn),st=s(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-7ysnum"&&(P.textContent=fn),it=s(e),d(z.$$.fragment,e),ot=s(e),d(O.$$.fragment,e),rt=s(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1symqva"&&(D.innerHTML=yn),mt=s(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1j1sj1y"&&(K.innerHTML=bn),dt=s(e),b=o(e,"DETAILS",{});var _e=Xt(b);Le=o(_e,"SUMMARY",{"data-svelte-h":!0}),r(Le)!=="svelte-187ducf"&&(Le.textContent=wn),St=s(_e),Ze=o(_e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-z0lktq"&&(Ze.innerHTML=gn),At=s(_e),d(ee.$$.fragment,_e),_e.forEach(n),ct=s(e),d(te.$$.fragment,e),ut=s(e),x=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(x)!=="svelte-18frj1l"&&(x.innerHTML=Mn),pt=s(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-axr536"&&(ne.innerHTML=vn),ht=s(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-s47gic"&&(le.textContent=Tn),ft=s(e),d(ae.$$.fragment,e),yt=s(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-54vaw7"&&(se.innerHTML=xn),bt=s(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1j63axa"&&(ie.textContent=Jn),wt=s(e),d(oe.$$.fragment,e),gt=s(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-18ur37c"&&(re.textContent=Un),Mt=s(e),me=o(e,"UL",{"data-svelte-h":!0}),r(me)!=="svelte-d9r342"&&(me.innerHTML=Ln),vt=s(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-rqskw5"&&(de.textContent=Zn),Tt=s(e),d(ce.$$.fragment,e),xt=s(e),d(ue.$$.fragment,e),Jt=s(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-1j4gc2q"&&(pe.innerHTML=jn),Ut=s(e),he=o(e,"UL",{"data-svelte-h":!0}),r(he)!=="svelte-3mam70"&&(he.innerHTML=Cn),Lt=s(e),J=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(J)!=="svelte-13ris5q"&&(J.innerHTML=In),Zt=s(e),fe=o(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-16j3xwr"&&(fe.innerHTML=kn),jt=s(e),d(ye.$$.fragment,e),Ct=s(e),be=o(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-1m4sp8c"&&(be.innerHTML=_n),It=s(e),we=o(e,"UL",{"data-svelte-h":!0}),r(we)!=="svelte-252wdz"&&(we.innerHTML=Wn),kt=s(e),U=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(U)!=="svelte-1c9z98q"&&(U.innerHTML=$n),_t=s(e),d(ge.$$.fragment,e),Wt=s(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-f2lt8l"&&(Me.innerHTML=Gn),$t=s(e),f=o(e,"DETAILS",{});var w=Xt(f);je=o(w,"SUMMARY",{"data-svelte-h":!0}),r(je)!=="svelte-1csrw0t"&&(je.textContent=En),Yt=s(w),Ce=o(w,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-ho52mp"&&(Ce.innerHTML=Vn),qt=s(w),d(ve.$$.fragment,w),Ft=s(w),Ie=o(w,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-2gef6z"&&(Ie.innerHTML=Hn),Nt=s(w),ke=o(w,"UL",{"data-svelte-h":!0}),r(ke)!=="svelte-13n4s9w"&&(ke.innerHTML=Bn),w.forEach(n),Gt=s(e),d(Te.$$.fragment,e),Et=s(e),L=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(L)!=="svelte-a1et1y"&&(L.innerHTML=Rn),Vt=s(e),xe=o(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-13rfypl"&&(xe.innerHTML=Xn),Ht=s(e),d(Je.$$.fragment,e),Bt=s(e),$e=o(e,"P",{}),Xt($e).forEach(n),this.h()},h(){Z(g,"name","hf:doc:metadata"),Z(g,"content",zn),Z(v,"class","tip"),Z(T,"class","tip"),Z(x,"class","tip"),Z(J,"class","tip"),Z(U,"class","tip"),Z(L,"class","tip")},m(e,t){y(document.head,g),l(e,Ge,t),l(e,We,t),l(e,Ee,t),c(j,e,t),l(e,Ve,t),l(e,C,t),l(e,He,t),l(e,I,t),l(e,Be,t),l(e,k,t),l(e,Re,t),l(e,_,t),l(e,Xe,t),l(e,W,t),l(e,Se,t),l(e,$,t),l(e,Ae,t),l(e,G,t),l(e,Ye,t),l(e,E,t),l(e,qe,t),c(V,e,t),l(e,Fe,t),l(e,v,t),l(e,Ne,t),l(e,H,t),l(e,Qe,t),l(e,B,t),l(e,Pe,t),l(e,R,t),l(e,ze,t),c(X,e,t),l(e,Oe,t),l(e,S,t),l(e,De,t),l(e,A,t),l(e,Ke,t),l(e,T,t),l(e,et,t),l(e,Y,t),l(e,tt,t),c(q,e,t),l(e,nt,t),l(e,F,t),l(e,lt,t),l(e,N,t),l(e,at,t),l(e,Q,t),l(e,st,t),l(e,P,t),l(e,it,t),c(z,e,t),l(e,ot,t),c(O,e,t),l(e,rt,t),l(e,D,t),l(e,mt,t),l(e,K,t),l(e,dt,t),l(e,b,t),y(b,Le),y(b,St),y(b,Ze),y(b,At),c(ee,b,null),l(e,ct,t),c(te,e,t),l(e,ut,t),l(e,x,t),l(e,pt,t),l(e,ne,t),l(e,ht,t),l(e,le,t),l(e,ft,t),c(ae,e,t),l(e,yt,t),l(e,se,t),l(e,bt,t),l(e,ie,t),l(e,wt,t),c(oe,e,t),l(e,gt,t),l(e,re,t),l(e,Mt,t),l(e,me,t),l(e,vt,t),l(e,de,t),l(e,Tt,t),c(ce,e,t),l(e,xt,t),c(ue,e,t),l(e,Jt,t),l(e,pe,t),l(e,Ut,t),l(e,he,t),l(e,Lt,t),l(e,J,t),l(e,Zt,t),l(e,fe,t),l(e,jt,t),c(ye,e,t),l(e,Ct,t),l(e,be,t),l(e,It,t),l(e,we,t),l(e,kt,t),l(e,U,t),l(e,_t,t),c(ge,e,t),l(e,Wt,t),l(e,Me,t),l(e,$t,t),l(e,f,t),y(f,je),y(f,Yt),y(f,Ce),y(f,qt),c(ve,f,null),y(f,Ft),y(f,Ie),y(f,Nt),y(f,ke),l(e,Gt,t),c(Te,e,t),l(e,Et,t),l(e,L,t),l(e,Vt,t),l(e,xe,t),l(e,Ht,t),c(Je,e,t),l(e,Bt,t),l(e,$e,t),Rt=!0},p:An,i(e){Rt||(u(j.$$.fragment,e),u(V.$$.fragment,e),u(X.$$.fragment,e),u(q.$$.fragment,e),u(z.$$.fragment,e),u(O.$$.fragment,e),u(ee.$$.fragment,e),u(te.$$.fragment,e),u(ae.$$.fragment,e),u(oe.$$.fragment,e),u(ce.$$.fragment,e),u(ue.$$.fragment,e),u(ye.$$.fragment,e),u(ge.$$.fragment,e),u(ve.$$.fragment,e),u(Te.$$.fragment,e),u(Je.$$.fragment,e),Rt=!0)},o(e){p(j.$$.fragment,e),p(V.$$.fragment,e),p(X.$$.fragment,e),p(q.$$.fragment,e),p(z.$$.fragment,e),p(O.$$.fragment,e),p(ee.$$.fragment,e),p(te.$$.fragment,e),p(ae.$$.fragment,e),p(oe.$$.fragment,e),p(ce.$$.fragment,e),p(ue.$$.fragment,e),p(ye.$$.fragment,e),p(ge.$$.fragment,e),p(ve.$$.fragment,e),p(Te.$$.fragment,e),p(Je.$$.fragment,e),Rt=!1},d(e){e&&(n(Ge),n(We),n(Ee),n(Ve),n(C),n(He),n(I),n(Be),n(k),n(Re),n(_),n(Xe),n(W),n(Se),n($),n(Ae),n(G),n(Ye),n(E),n(qe),n(Fe),n(v),n(Ne),n(H),n(Qe),n(B),n(Pe),n(R),n(ze),n(Oe),n(S),n(De),n(A),n(Ke),n(T),n(et),n(Y),n(tt),n(nt),n(F),n(lt),n(N),n(at),n(Q),n(st),n(P),n(it),n(ot),n(rt),n(D),n(mt),n(K),n(dt),n(b),n(ct),n(ut),n(x),n(pt),n(ne),n(ht),n(le),n(ft),n(yt),n(se),n(bt),n(ie),n(wt),n(gt),n(re),n(Mt),n(me),n(vt),n(de),n(Tt),n(xt),n(Jt),n(pe),n(Ut),n(he),n(Lt),n(J),n(Zt),n(fe),n(jt),n(Ct),n(be),n(It),n(we),n(kt),n(U),n(_t),n(Wt),n(Me),n($t),n(f),n(Gt),n(Et),n(L),n(Vt),n(xe),n(Ht),n(Bt),n($e)),n(g),h(j,e),h(V,e),h(X,e),h(q,e),h(z,e),h(O,e),h(ee),h(te,e),h(ae,e),h(oe,e),h(ce,e),h(ue,e),h(ye,e),h(ge,e),h(ve),h(Te,e),h(Je,e)}}}const zn='{"title":"What are components in LlamaIndex?","local":"what-are-components-in-llamaindex","sections":[{"title":"Creating a RAG pipeline using components","local":"creating-a-rag-pipeline-using-components","sections":[{"title":"Loading and embedding documents","local":"loading-and-embedding-documents","sections":[],"depth":3},{"title":"Storing and indexing documents","local":"storing-and-indexing-documents","sections":[],"depth":3},{"title":"Querying a VectorStoreIndex with prompts and LLMs","local":"querying-a-vectorstoreindex-with-prompts-and-llms","sections":[],"depth":3},{"title":"Response Processing","local":"response-processing","sections":[],"depth":3},{"title":"Evaluation and observability","local":"evaluation-and-observability","sections":[],"depth":3}],"depth":2}],"depth":1}';function On(Qt){return Yn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ll extends qn{constructor(g){super(),Fn(this,g,On,Pn,Sn,{})}}export{ll as component};
