import{s as Qs,n as _s,o as Vs}from"../chunks/scheduler.37c15a92.js";import{S as Hs,i as zs,g as M,s as a,r as p,A as qs,h as i,f as e,c as n,j as Xs,u as o,x as y,k as Us,y as Ls,a as t,v as j,d as w,t as U,w as T}from"../chunks/index.2bf4358c.js";import{C as c}from"../chunks/CodeBlock.4e987730.js";import{H as J}from"../chunks/Heading.8ada512a.js";import{E as Ps}from"../chunks/getInferenceSnippets.0aa3753f.js";function Ds(Ts){let m,Jl,Ul,cl,h,ml,d,Js="Alfred at your service. As Mr. Wayne’s trusted butler, I’ve taken the liberty of documenting how I assist Mr Wayne with his various documentary needs. While he’s out attending to his… nighttime activities, I ensure all his paperwork, training schedules, and nutritional plans are properly analyzed and organized.",rl,u,cs="Before leaving, he left a note with his week’s training program. I then took the responsibility to come up with a <strong>menu</strong> for tomorrow’s meals.",hl,I,ms="For future such events, let’s create a document analysis system using LangGraph to serve Mr. Wayne’s needs. This system can:",dl,C,rs="<li>Process images document</li> <li>Extract text using vision models (Vision Language Model)</li> <li>Perform calculations when needed (to demonstrate normal tools)</li> <li>Analyze content and provide concise summaries</li> <li>Execute specific instructions related to documents</li>",ul,b,Il,g,hs="The workflow we’ll build follows this structured schema:",Cl,A,ds='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/alfred_flow.png" alt="Butler&#39;s Document Analysis Workflow"/>',bl,r,us='<p>You can follow the code in <a href="https://huggingface.co/agents-course/notebooks/blob/main/unit2/langgraph/agent.ipynb" target="_blank">this notebook</a> that you can run using Google Colab.</p>',gl,G,Al,B,Gl,f,Is="and imports :",Bl,Z,fl,W,Zl,k,Cs=`This state is a little more complex than the previous ones we have seen.
<code>AnyMessage</code> is a class from Langchain that defines messages, and <code>add_messages</code> is an operator that adds the latest message rather than overwriting it with the latest state.`,Wl,v,bs="This is a new concept in LangGraph, where you can add operators in your state to define the way they should interact together.",kl,E,vl,x,El,$,xl,S,$l,R,Sl,N,Rl,Y,gs="Allow me to explain the approach in this agent. The agent follows what’s known as the ReAct pattern (Reason-Act-Observe)",Nl,F,As="<li><strong>Reason</strong> about his documents and requests</li> <li><strong>Act</strong> by using appropriate tools</li> <li><strong>Observe</strong> the results</li> <li><strong>Repeat</strong> as necessary until I’ve fully addressed his needs</li>",Yl,X,Gs="This is a simple implementation of an agent using LangGraph.",Fl,Q,Xl,_,Bs=`We define a <code>tools</code> node with our list of tools. The <code>assistant</code> node is just our model with bound tools.
We create a graph with <code>assistant</code> and <code>tools</code> nodes.`,Ql,V,fs="We add a <code>tools_condition</code> edge, which routes to <code>End</code> or to <code>tools</code> based on whether the <code>assistant</code> calls a tool.",_l,H,Zs="Now, we add one new step:",Vl,z,Ws="We connect the <code>tools</code> node back to the <code>assistant</code>, forming a loop.",Hl,q,ks="<li>After the <code>assistant</code> node executes, <code>tools_condition</code> checks if the model’s output is a tool call.</li> <li>If it is a tool call, the flow is directed to the <code>tools</code> node.</li> <li>The <code>tools</code> node connects back to <code>assistant</code>.</li> <li>This loop continues as long as the model decides to call tools.</li> <li>If the model response is not a tool call, the flow is directed to END, terminating the process.</li>",zl,L,vs='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/Agent.png" alt="ReAct Pattern"/>',ql,P,Ll,D,Pl,K,Es="Here is an example to show a simple use case of an agent using a tool in LangGraph.",Dl,O,Kl,ll,xs="The conversation would proceed:",Ol,sl,ls,el,ss,tl,$s="When Master Wayne leaves his training and meal notes:",es,al,ts,nl,Ss="The interaction would proceed:",as,Ml,ns,il,Ms,yl,Rs="Should you wish to create your own document analysis butler, here are key considerations:",is,pl,Ns="<li><strong>Define clear tools</strong> for specific document-related tasks</li> <li><strong>Create a robust state tracker</strong> to maintain context between tool calls</li> <li><strong>Consider error handling</strong> for tool failures</li> <li><strong>Maintain contextual awareness</strong> of previous interactions (ensured by the operator <code>add_messages</code>)</li>",ys,ol,Ys="With these principles, you too can provide exemplary document analysis service worthy of Wayne Manor.",ps,jl,Fs="<em>I trust this explanation has been satisfactory. Now, if you’ll excuse me, Master Wayne’s cape requires pressing before tonight’s activities.</em>",os,wl,js,Tl,ws;return h=new J({props:{title:"Document Analysis Graph",local:"document-analysis-graph",headingTag:"h1"}}),b=new J({props:{title:"The Butler’s Workflow",local:"the-butlers-workflow",headingTag:"h2"}}),G=new J({props:{title:"Setting Up the environment",local:"setting-up-the-environment",headingTag:"h2"}}),B=new c({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMGxhbmdncmFwaCUyMGxhbmdjaGFpbl9vcGVuYWklMjBsYW5nY2hhaW5fY29yZQ==",highlighted:"%pip install langgraph langchain_openai langchain_core",wrap:!1}}),Z=new c({props:{code:"aW1wb3J0JTIwYmFzZTY0JTBBZnJvbSUyMHR5cGluZyUyMGltcG9ydCUyMExpc3QlMkMlMjBUeXBlZERpY3QlMkMlMjBBbm5vdGF0ZWQlMkMlMjBPcHRpb25hbCUwQWZyb20lMjBsYW5nY2hhaW5fb3BlbmFpJTIwaW1wb3J0JTIwQ2hhdE9wZW5BSSUwQWZyb20lMjBsYW5nY2hhaW5fY29yZS5tZXNzYWdlcyUyMGltcG9ydCUyMEFueU1lc3NhZ2UlMkMlMjBTeXN0ZW1NZXNzYWdlJTJDJTIwSHVtYW5NZXNzYWdlJTBBZnJvbSUyMGxhbmdncmFwaC5ncmFwaC5tZXNzYWdlJTIwaW1wb3J0JTIwYWRkX21lc3NhZ2VzJTBBZnJvbSUyMGxhbmdncmFwaC5ncmFwaCUyMGltcG9ydCUyMFNUQVJUJTJDJTIwU3RhdGVHcmFwaCUwQWZyb20lMjBsYW5nZ3JhcGgucHJlYnVpbHQlMjBpbXBvcnQlMjBUb29sTm9kZSUyQyUyMHRvb2xzX2NvbmRpdGlvbiUwQWZyb20lMjBJUHl0aG9uLmRpc3BsYXklMjBpbXBvcnQlMjBJbWFnZSUyQyUyMGRpc3BsYXk=",highlighted:`<span class="hljs-keyword">import</span> base64
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>, TypedDict, Annotated, <span class="hljs-type">Optional</span>
<span class="hljs-keyword">from</span> langchain_openai <span class="hljs-keyword">import</span> ChatOpenAI
<span class="hljs-keyword">from</span> langchain_core.messages <span class="hljs-keyword">import</span> AnyMessage, SystemMessage, HumanMessage
<span class="hljs-keyword">from</span> langgraph.graph.message <span class="hljs-keyword">import</span> add_messages
<span class="hljs-keyword">from</span> langgraph.graph <span class="hljs-keyword">import</span> START, StateGraph
<span class="hljs-keyword">from</span> langgraph.prebuilt <span class="hljs-keyword">import</span> ToolNode, tools_condition
<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Image, display`,wrap:!1}}),W=new J({props:{title:"Defining Agent’s State",local:"defining-agents-state",headingTag:"h2"}}),E=new c({props:{code:"Y2xhc3MlMjBBZ2VudFN0YXRlKFR5cGVkRGljdCklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBUaGUlMjBkb2N1bWVudCUyMHByb3ZpZGVkJTBBJTIwJTIwJTIwJTIwaW5wdXRfZmlsZSUzQSUyME9wdGlvbmFsJTVCc3RyJTVEJTIwJTIwJTIzJTIwQ29udGFpbnMlMjBmaWxlJTIwcGF0aCUyMChQREYlMkZQTkcpJTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMlM0ElMjBBbm5vdGF0ZWQlNUJsaXN0JTVCQW55TWVzc2FnZSU1RCUyQyUyMGFkZF9tZXNzYWdlcyU1RA==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">AgentState</span>(<span class="hljs-title class_ inherited__">TypedDict</span>):
    <span class="hljs-comment"># The document provided</span>
    input_file: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>]  <span class="hljs-comment"># Contains file path (PDF/PNG)</span>
    messages: Annotated[<span class="hljs-built_in">list</span>[AnyMessage], add_messages]`,wrap:!1}}),x=new J({props:{title:"Preparing Tools",local:"preparing-tools",headingTag:"h2"}}),$=new c({props:{code:"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",highlighted:`vision_llm = ChatOpenAI(model=<span class="hljs-string">&quot;gpt-4o&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">extract_text</span>(<span class="hljs-params">img_path: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Extract text from an image file using a multimodal model.
    
    Master Wayne often leaves notes with his training regimen or meal plans.
    This allows me to properly analyze the contents.
    &quot;&quot;&quot;</span>
    all_text = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Read image and encode as base64</span>
        <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(img_path, <span class="hljs-string">&quot;rb&quot;</span>) <span class="hljs-keyword">as</span> image_file:
            image_bytes = image_file.read()

        image_base64 = base64.b64encode(image_bytes).decode(<span class="hljs-string">&quot;utf-8&quot;</span>)

        <span class="hljs-comment"># Prepare the prompt including the base64 image data</span>
        message = [
            HumanMessage(
                content=[
                    {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
                        <span class="hljs-string">&quot;text&quot;</span>: (
                            <span class="hljs-string">&quot;Extract all the text from this image. &quot;</span>
                            <span class="hljs-string">&quot;Return only the extracted text, no explanations.&quot;</span>
                        ),
                    },
                    {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image_url&quot;</span>,
                        <span class="hljs-string">&quot;image_url&quot;</span>: {
                            <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">f&quot;data:image/png;base64,<span class="hljs-subst">{image_base64}</span>&quot;</span>
                        },
                    },
                ]
            )
        ]

        <span class="hljs-comment"># Call the vision-capable model</span>
        response = vision_llm.invoke(message)

        <span class="hljs-comment"># Append extracted text</span>
        all_text += response.content + <span class="hljs-string">&quot;\\n\\n&quot;</span>

        <span class="hljs-keyword">return</span> all_text.strip()
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-comment"># A butler should handle errors gracefully</span>
        error_msg = <span class="hljs-string">f&quot;Error extracting text: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>
        <span class="hljs-built_in">print</span>(error_msg)
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;&quot;</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">divide</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">float</span>:
    <span class="hljs-string">&quot;&quot;&quot;Divide a and b - for Master Wayne&#x27;s occasional calculations.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a / b

<span class="hljs-comment"># Equip the butler with tools</span>
tools = [
    divide,
    extract_text
]

llm = ChatOpenAI(model=<span class="hljs-string">&quot;gpt-4o&quot;</span>)
llm_with_tools = llm.bind_tools(tools, parallel_tool_calls=<span class="hljs-literal">False</span>)`,wrap:!1}}),S=new J({props:{title:"The nodes",local:"the-nodes",headingTag:"h2"}}),R=new c({props:{code:"ZGVmJTIwYXNzaXN0YW50KHN0YXRlJTNBJTIwQWdlbnRTdGF0ZSklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBTeXN0ZW0lMjBtZXNzYWdlJTBBJTIwJTIwJTIwJTIwdGV4dHVhbF9kZXNjcmlwdGlvbl9vZl90b29sJTNEJTIyJTIyJTIyJTBBZXh0cmFjdF90ZXh0KGltZ19wYXRoJTNBJTIwc3RyKSUyMC0lM0UlMjBzdHIlM0ElMEElMjAlMjAlMjAlMjBFeHRyYWN0JTIwdGV4dCUyMGZyb20lMjBhbiUyMGltYWdlJTIwZmlsZSUyMHVzaW5nJTIwYSUyMG11bHRpbW9kYWwlMjBtb2RlbC4lMEElMEElMjAlMjAlMjAlMjBBcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW1nX3BhdGglM0ElMjBBJTIwbG9jYWwlMjBpbWFnZSUyMGZpbGUlMjBwYXRoJTIwKHN0cmluZ3MpLiUwQSUwQSUyMCUyMCUyMCUyMFJldHVybnMlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBBJTIwc2luZ2xlJTIwc3RyaW5nJTIwY29udGFpbmluZyUyMHRoZSUyMGNvbmNhdGVuYXRlZCUyMHRleHQlMjBleHRyYWN0ZWQlMjBmcm9tJTIwZWFjaCUyMGltYWdlLiUwQWRpdmlkZShhJTNBJTIwaW50JTJDJTIwYiUzQSUyMGludCklMjAtJTNFJTIwZmxvYXQlM0ElMEElMjAlMjAlMjAlMjBEaXZpZGUlMjBhJTIwYW5kJTIwYiUwQSUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMGltYWdlJTNEc3RhdGUlNUIlMjJpbnB1dF9maWxlJTIyJTVEJTBBJTIwJTIwJTIwJTIwc3lzX21zZyUyMCUzRCUyMFN5c3RlbU1lc3NhZ2UoY29udGVudCUzRGYlMjJZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGJ1dGxlciUyMG5hbWVkJTIwQWxmcmVkJTIwdGhhdCUyMHNlcnZlcyUyME1yLiUyMFdheW5lJTIwYW5kJTIwQmF0bWFuLiUyMFlvdSUyMGNhbiUyMGFuYWx5c2UlMjBkb2N1bWVudHMlMjBhbmQlMjBydW4lMjBjb21wdXRhdGlvbnMlMjB3aXRoJTIwcHJvdmlkZWQlMjB0b29scyUzQSU1Q24lN0J0ZXh0dWFsX2Rlc2NyaXB0aW9uX29mX3Rvb2wlN0QlMjAlNUNuJTIwWW91JTIwaGF2ZSUyMGFjY2VzcyUyMHRvJTIwc29tZSUyMG9wdGlvbmFsJTIwaW1hZ2VzLiUyMEN1cnJlbnRseSUyMHRoZSUyMGxvYWRlZCUyMGltYWdlJTIwaXMlM0ElMjAlN0JpbWFnZSU3RCUyMiklMEElMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtZXNzYWdlcyUyMiUzQSUyMCU1QmxsbV93aXRoX3Rvb2xzLmludm9rZSglNUJzeXNfbXNnJTVEJTIwJTJCJTIwc3RhdGUlNUIlMjJtZXNzYWdlcyUyMiU1RCklNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJpbnB1dF9maWxlJTIyJTNBJTIwc3RhdGUlNUIlMjJpbnB1dF9maWxlJTIyJTVEJTBBJTIwJTIwJTIwJTIwJTdE",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">assistant</span>(<span class="hljs-params">state: AgentState</span>):
    <span class="hljs-comment"># System message</span>
    textual_description_of_tool=<span class="hljs-string">&quot;&quot;&quot;
extract_text(img_path: str) -&gt; str:
    Extract text from an image file using a multimodal model.

    Args:
        img_path: A local image file path (strings).

    Returns:
        A single string containing the concatenated text extracted from each image.
divide(a: int, b: int) -&gt; float:
    Divide a and b
&quot;&quot;&quot;</span>
    image=state[<span class="hljs-string">&quot;input_file&quot;</span>]
    sys_msg = SystemMessage(content=<span class="hljs-string">f&quot;You are a helpful butler named Alfred that serves Mr. Wayne and Batman. You can analyse documents and run computations with provided tools:\\n<span class="hljs-subst">{textual_description_of_tool}</span> \\n You have access to some optional images. Currently the loaded image is: <span class="hljs-subst">{image}</span>&quot;</span>)

    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;messages&quot;</span>: [llm_with_tools.invoke([sys_msg] + state[<span class="hljs-string">&quot;messages&quot;</span>])],
        <span class="hljs-string">&quot;input_file&quot;</span>: state[<span class="hljs-string">&quot;input_file&quot;</span>]
    }`,wrap:!1}}),N=new J({props:{title:"The ReAct Pattern: How I Assist Mr. Wayne",local:"the-react-pattern-how-i-assist-mr-wayne",headingTag:"h2"}}),Q=new c({props:{code:"JTIzJTIwVGhlJTIwZ3JhcGglMEFidWlsZGVyJTIwJTNEJTIwU3RhdGVHcmFwaChBZ2VudFN0YXRlKSUwQSUwQSUyMyUyMERlZmluZSUyMG5vZGVzJTNBJTIwdGhlc2UlMjBkbyUyMHRoZSUyMHdvcmslMEFidWlsZGVyLmFkZF9ub2RlKCUyMmFzc2lzdGFudCUyMiUyQyUyMGFzc2lzdGFudCklMEFidWlsZGVyLmFkZF9ub2RlKCUyMnRvb2xzJTIyJTJDJTIwVG9vbE5vZGUodG9vbHMpKSUwQSUwQSUyMyUyMERlZmluZSUyMGVkZ2VzJTNBJTIwdGhlc2UlMjBkZXRlcm1pbmUlMjBob3clMjB0aGUlMjBjb250cm9sJTIwZmxvdyUyMG1vdmVzJTBBYnVpbGRlci5hZGRfZWRnZShTVEFSVCUyQyUyMCUyMmFzc2lzdGFudCUyMiklMEFidWlsZGVyLmFkZF9jb25kaXRpb25hbF9lZGdlcyglMEElMjAlMjAlMjAlMjAlMjJhc3Npc3RhbnQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjMlMjBJZiUyMHRoZSUyMGxhdGVzdCUyMG1lc3NhZ2UlMjByZXF1aXJlcyUyMGElMjB0b29sJTJDJTIwcm91dGUlMjB0byUyMHRvb2xzJTBBJTIwJTIwJTIwJTIwJTIzJTIwT3RoZXJ3aXNlJTJDJTIwcHJvdmlkZSUyMGElMjBkaXJlY3QlMjByZXNwb25zZSUwQSUyMCUyMCUyMCUyMHRvb2xzX2NvbmRpdGlvbiUyQyUwQSklMEFidWlsZGVyLmFkZF9lZGdlKCUyMnRvb2xzJTIyJTJDJTIwJTIyYXNzaXN0YW50JTIyKSUwQXJlYWN0X2dyYXBoJTIwJTNEJTIwYnVpbGRlci5jb21waWxlKCklMEElMEElMjMlMjBTaG93JTIwdGhlJTIwYnV0bGVyJ3MlMjB0aG91Z2h0JTIwcHJvY2VzcyUwQWRpc3BsYXkoSW1hZ2UocmVhY3RfZ3JhcGguZ2V0X2dyYXBoKHhyYXklM0RUcnVlKS5kcmF3X21lcm1haWRfcG5nKCkpKQ==",highlighted:`<span class="hljs-comment"># The graph</span>
builder = StateGraph(AgentState)

<span class="hljs-comment"># Define nodes: these do the work</span>
builder.add_node(<span class="hljs-string">&quot;assistant&quot;</span>, assistant)
builder.add_node(<span class="hljs-string">&quot;tools&quot;</span>, ToolNode(tools))

<span class="hljs-comment"># Define edges: these determine how the control flow moves</span>
builder.add_edge(START, <span class="hljs-string">&quot;assistant&quot;</span>)
builder.add_conditional_edges(
    <span class="hljs-string">&quot;assistant&quot;</span>,
    <span class="hljs-comment"># If the latest message requires a tool, route to tools</span>
    <span class="hljs-comment"># Otherwise, provide a direct response</span>
    tools_condition,
)
builder.add_edge(<span class="hljs-string">&quot;tools&quot;</span>, <span class="hljs-string">&quot;assistant&quot;</span>)
react_graph = builder.<span class="hljs-built_in">compile</span>()

<span class="hljs-comment"># Show the butler&#x27;s thought process</span>
display(Image(react_graph.get_graph(xray=<span class="hljs-literal">True</span>).draw_mermaid_png()))`,wrap:!1}}),P=new J({props:{title:"The Butler in Action",local:"the-butler-in-action",headingTag:"h2"}}),D=new J({props:{title:"Example 1: Simple Calculations",local:"example-1-simple-calculations",headingTag:"h3"}}),O=new c({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUJIdW1hbk1lc3NhZ2UoY29udGVudCUzRCUyMkRpdmlkZSUyMDY3OTAlMjBieSUyMDUlMjIpJTVEJTBBbWVzc2FnZXMlMjAlM0QlMjByZWFjdF9ncmFwaC5pbnZva2UoJTdCJTIybWVzc2FnZXMlMjIlM0ElMjBtZXNzYWdlcyUyQyUyMCUyMmlucHV0X2ZpbGUlMjIlM0ElMjBOb25lJTdEKSUwQSUwQSUyMyUyMFNob3clMjB0aGUlMjBtZXNzYWdlcyUwQWZvciUyMG0lMjBpbiUyMG1lc3NhZ2VzJTVCJ21lc3NhZ2VzJyU1RCUzQSUwQSUyMCUyMCUyMCUyMG0ucHJldHR5X3ByaW50KCk=",highlighted:`messages = [HumanMessage(content=<span class="hljs-string">&quot;Divide 6790 by 5&quot;</span>)]
messages = react_graph.invoke({<span class="hljs-string">&quot;messages&quot;</span>: messages, <span class="hljs-string">&quot;input_file&quot;</span>: <span class="hljs-literal">None</span>})

<span class="hljs-comment"># Show the messages</span>
<span class="hljs-keyword">for</span> m <span class="hljs-keyword">in</span> messages[<span class="hljs-string">&#x27;messages&#x27;</span>]:
    m.pretty_print()`,wrap:!1}}),sl=new c({props:{code:"SHVtYW4lM0ElMjBEaXZpZGUlMjA2NzkwJTIwYnklMjA1JTBBJTBBQUklMjBUb29sJTIwQ2FsbCUzQSUyMGRpdmlkZShhJTNENjc5MCUyQyUyMGIlM0Q1KSUwQSUwQVRvb2wlMjBSZXNwb25zZSUzQSUyMDEzNTguMCUwQSUwQUFsZnJlZCUzQSUyMFRoZSUyMHJlc3VsdCUyMG9mJTIwZGl2aWRpbmclMjA2NzkwJTIwYnklMjA1JTIwaXMlMjAxMzU4LjAu",highlighted:`<span class="hljs-attribute">Human</span>: Divide <span class="hljs-number">6790</span> by <span class="hljs-number">5</span>

<span class="hljs-attribute">AI</span> Tool Call: divide(a=<span class="hljs-number">6790</span>, b=<span class="hljs-number">5</span>)

<span class="hljs-attribute">Tool</span> Response: <span class="hljs-number">1358</span>.<span class="hljs-number">0</span>

<span class="hljs-attribute">Alfred</span>: The result of dividing <span class="hljs-number">6790</span> by <span class="hljs-number">5</span> is <span class="hljs-number">1358</span>.<span class="hljs-number">0</span>.`,wrap:!1}}),el=new J({props:{title:"Example 2: Analyzing Master Wayne’s Training Documents",local:"example-2-analyzing-master-waynes-training-documents",headingTag:"h3"}}),al=new c({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUJIdW1hbk1lc3NhZ2UoY29udGVudCUzRCUyMkFjY29yZGluZyUyMHRvJTIwdGhlJTIwbm90ZSUyMHByb3ZpZGVkJTIwYnklMjBNci4lMjBXYXluZSUyMGluJTIwdGhlJTIwcHJvdmlkZWQlMjBpbWFnZXMuJTIwV2hhdCdzJTIwdGhlJTIwbGlzdCUyMG9mJTIwaXRlbXMlMjBJJTIwc2hvdWxkJTIwYnV5JTIwZm9yJTIwdGhlJTIwZGlubmVyJTIwbWVudSUzRiUyMiklNUQlMEFtZXNzYWdlcyUyMCUzRCUyMHJlYWN0X2dyYXBoLmludm9rZSglN0IlMjJtZXNzYWdlcyUyMiUzQSUyMG1lc3NhZ2VzJTJDJTIwJTIyaW5wdXRfZmlsZSUyMiUzQSUyMCUyMkJhdG1hbl90cmFpbmluZ19hbmRfbWVhbHMucG5nJTIyJTdEKQ==",highlighted:`messages = [HumanMessage(content=<span class="hljs-string">&quot;According to the note provided by Mr. Wayne in the provided images. What&#x27;s the list of items I should buy for the dinner menu?&quot;</span>)]
messages = react_graph.invoke({<span class="hljs-string">&quot;messages&quot;</span>: messages, <span class="hljs-string">&quot;input_file&quot;</span>: <span class="hljs-string">&quot;Batman_training_and_meals.png&quot;</span>})`,wrap:!1}}),Ml=new c({props:{code:"SHVtYW4lM0ElMjBBY2NvcmRpbmclMjB0byUyMHRoZSUyMG5vdGUlMjBwcm92aWRlZCUyMGJ5JTIwTXIuJTIwV2F5bmUlMjBpbiUyMHRoZSUyMHByb3ZpZGVkJTIwaW1hZ2VzLiUyMFdoYXQncyUyMHRoZSUyMGxpc3QlMjBvZiUyMGl0ZW1zJTIwSSUyMHNob3VsZCUyMGJ1eSUyMGZvciUyMHRoZSUyMGRpbm5lciUyMG1lbnUlM0YlMEElMEFBSSUyMFRvb2wlMjBDYWxsJTNBJTIwZXh0cmFjdF90ZXh0KGltZ19wYXRoJTNEJTIyQmF0bWFuX3RyYWluaW5nX2FuZF9tZWFscy5wbmclMjIpJTBBJTBBVG9vbCUyMFJlc3BvbnNlJTNBJTIwJTVCRXh0cmFjdGVkJTIwdGV4dCUyMHdpdGglMjB0cmFpbmluZyUyMHNjaGVkdWxlJTIwYW5kJTIwbWVudSUyMGRldGFpbHMlNUQlMEElMEFBbGZyZWQlM0ElMjBGb3IlMjB0aGUlMjBkaW5uZXIlMjBtZW51JTJDJTIweW91JTIwc2hvdWxkJTIwYnV5JTIwdGhlJTIwZm9sbG93aW5nJTIwaXRlbXMlM0ElMEElMEExLiUyMEdyYXNzLWZlZCUyMGxvY2FsJTIwc2lybG9pbiUyMHN0ZWFrJTBBMi4lMjBPcmdhbmljJTIwc3BpbmFjaCUwQTMuJTIwUGlxdWlsbG8lMjBwZXBwZXJzJTBBNC4lMjBQb3RhdG9lcyUyMChmb3IlMjBvdmVuLWJha2VkJTIwZ29sZGVuJTIwaGVyYiUyMHBvdGF0byklMEE1LiUyMEZpc2glMjBvaWwlMjAoMiUyMGdyYW1zKSUwQSUwQUVuc3VyZSUyMHRoZSUyMHN0ZWFrJTIwaXMlMjBncmFzcy1mZWQlMjBhbmQlMjB0aGUlMjBzcGluYWNoJTIwYW5kJTIwcGVwcGVycyUyMGFyZSUyMG9yZ2FuaWMlMjBmb3IlMjB0aGUlMjBiZXN0JTIwcXVhbGl0eSUyMG1lYWwu",highlighted:`<span class="hljs-symbol">Human:</span> According <span class="hljs-keyword">to</span> the note provided <span class="hljs-keyword">by</span> Mr. Wayne <span class="hljs-keyword">in</span> the provided images. What<span class="hljs-comment">&#x27;s the list of items I should buy for the dinner menu?</span>

AI Tool <span class="hljs-keyword">Call</span>: extract_text(img_path=<span class="hljs-string">&quot;Batman_training_and_meals.png&quot;</span>)

Tool Response: [Extracted <span class="hljs-keyword">text</span> <span class="hljs-keyword">with</span> training schedule <span class="hljs-built_in">and</span> menu details]

<span class="hljs-symbol">Alfred:</span> <span class="hljs-keyword">For</span> the dinner menu, you should buy the following items:

<span class="hljs-number">1</span>. Grass-fed local sirloin steak
<span class="hljs-number">2</span>. Organic spinach
<span class="hljs-number">3</span>. Piquillo peppers
<span class="hljs-number">4</span>. Potatoes (<span class="hljs-keyword">for</span> oven-baked golden herb potato)
<span class="hljs-number">5</span>. Fish oil (<span class="hljs-number">2</span> grams)

Ensure the steak <span class="hljs-built_in">is</span> grass-fed <span class="hljs-built_in">and</span> the spinach <span class="hljs-built_in">and</span> peppers are organic <span class="hljs-keyword">for</span> the best quality meal.`,wrap:!1}}),il=new J({props:{title:"Key Takeaways",local:"key-takeaways",headingTag:"h2"}}),wl=new Ps({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit2/langgraph/document_analysis_agent.mdx"}}),{c(){m=M("meta"),Jl=a(),Ul=M("p"),cl=a(),p(h.$$.fragment),ml=a(),d=M("p"),d.textContent=Js,rl=a(),u=M("p"),u.innerHTML=cs,hl=a(),I=M("p"),I.textContent=ms,dl=a(),C=M("ol"),C.innerHTML=rs,ul=a(),p(b.$$.fragment),Il=a(),g=M("p"),g.textContent=hs,Cl=a(),A=M("p"),A.innerHTML=ds,bl=a(),r=M("blockquote"),r.innerHTML=us,gl=a(),p(G.$$.fragment),Al=a(),p(B.$$.fragment),Gl=a(),f=M("p"),f.textContent=Is,Bl=a(),p(Z.$$.fragment),fl=a(),p(W.$$.fragment),Zl=a(),k=M("p"),k.innerHTML=Cs,Wl=a(),v=M("p"),v.textContent=bs,kl=a(),p(E.$$.fragment),vl=a(),p(x.$$.fragment),El=a(),p($.$$.fragment),xl=a(),p(S.$$.fragment),$l=a(),p(R.$$.fragment),Sl=a(),p(N.$$.fragment),Rl=a(),Y=M("p"),Y.textContent=gs,Nl=a(),F=M("ol"),F.innerHTML=As,Yl=a(),X=M("p"),X.textContent=Gs,Fl=a(),p(Q.$$.fragment),Xl=a(),_=M("p"),_.innerHTML=Bs,Ql=a(),V=M("p"),V.innerHTML=fs,_l=a(),H=M("p"),H.textContent=Zs,Vl=a(),z=M("p"),z.innerHTML=Ws,Hl=a(),q=M("ul"),q.innerHTML=ks,zl=a(),L=M("p"),L.innerHTML=vs,ql=a(),p(P.$$.fragment),Ll=a(),p(D.$$.fragment),Pl=a(),K=M("p"),K.textContent=Es,Dl=a(),p(O.$$.fragment),Kl=a(),ll=M("p"),ll.textContent=xs,Ol=a(),p(sl.$$.fragment),ls=a(),p(el.$$.fragment),ss=a(),tl=M("p"),tl.textContent=$s,es=a(),p(al.$$.fragment),ts=a(),nl=M("p"),nl.textContent=Ss,as=a(),p(Ml.$$.fragment),ns=a(),p(il.$$.fragment),Ms=a(),yl=M("p"),yl.textContent=Rs,is=a(),pl=M("ol"),pl.innerHTML=Ns,ys=a(),ol=M("p"),ol.textContent=Ys,ps=a(),jl=M("p"),jl.innerHTML=Fs,os=a(),p(wl.$$.fragment),js=a(),Tl=M("p"),this.h()},l(l){const s=qs("svelte-u9bgzb",document.head);m=i(s,"META",{name:!0,content:!0}),s.forEach(e),Jl=n(l),Ul=i(l,"P",{}),Xs(Ul).forEach(e),cl=n(l),o(h.$$.fragment,l),ml=n(l),d=i(l,"P",{"data-svelte-h":!0}),y(d)!=="svelte-11xka8s"&&(d.textContent=Js),rl=n(l),u=i(l,"P",{"data-svelte-h":!0}),y(u)!=="svelte-130n2j9"&&(u.innerHTML=cs),hl=n(l),I=i(l,"P",{"data-svelte-h":!0}),y(I)!=="svelte-fz9q9p"&&(I.textContent=ms),dl=n(l),C=i(l,"OL",{"data-svelte-h":!0}),y(C)!=="svelte-gyca7w"&&(C.innerHTML=rs),ul=n(l),o(b.$$.fragment,l),Il=n(l),g=i(l,"P",{"data-svelte-h":!0}),y(g)!=="svelte-zxoaj3"&&(g.textContent=hs),Cl=n(l),A=i(l,"P",{"data-svelte-h":!0}),y(A)!=="svelte-g7cpwr"&&(A.innerHTML=ds),bl=n(l),r=i(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),y(r)!=="svelte-1uoqj7n"&&(r.innerHTML=us),gl=n(l),o(G.$$.fragment,l),Al=n(l),o(B.$$.fragment,l),Gl=n(l),f=i(l,"P",{"data-svelte-h":!0}),y(f)!=="svelte-1ey17wx"&&(f.textContent=Is),Bl=n(l),o(Z.$$.fragment,l),fl=n(l),o(W.$$.fragment,l),Zl=n(l),k=i(l,"P",{"data-svelte-h":!0}),y(k)!=="svelte-h15r15"&&(k.innerHTML=Cs),Wl=n(l),v=i(l,"P",{"data-svelte-h":!0}),y(v)!=="svelte-s7exkc"&&(v.textContent=bs),kl=n(l),o(E.$$.fragment,l),vl=n(l),o(x.$$.fragment,l),El=n(l),o($.$$.fragment,l),xl=n(l),o(S.$$.fragment,l),$l=n(l),o(R.$$.fragment,l),Sl=n(l),o(N.$$.fragment,l),Rl=n(l),Y=i(l,"P",{"data-svelte-h":!0}),y(Y)!=="svelte-18vru10"&&(Y.textContent=gs),Nl=n(l),F=i(l,"OL",{"data-svelte-h":!0}),y(F)!=="svelte-1lieze1"&&(F.innerHTML=As),Yl=n(l),X=i(l,"P",{"data-svelte-h":!0}),y(X)!=="svelte-139l5j8"&&(X.textContent=Gs),Fl=n(l),o(Q.$$.fragment,l),Xl=n(l),_=i(l,"P",{"data-svelte-h":!0}),y(_)!=="svelte-1d0auck"&&(_.innerHTML=Bs),Ql=n(l),V=i(l,"P",{"data-svelte-h":!0}),y(V)!=="svelte-1svgz16"&&(V.innerHTML=fs),_l=n(l),H=i(l,"P",{"data-svelte-h":!0}),y(H)!=="svelte-1f0m6x1"&&(H.textContent=Zs),Vl=n(l),z=i(l,"P",{"data-svelte-h":!0}),y(z)!=="svelte-echfi8"&&(z.innerHTML=Ws),Hl=n(l),q=i(l,"UL",{"data-svelte-h":!0}),y(q)!=="svelte-bdsar0"&&(q.innerHTML=ks),zl=n(l),L=i(l,"P",{"data-svelte-h":!0}),y(L)!=="svelte-1nhlurw"&&(L.innerHTML=vs),ql=n(l),o(P.$$.fragment,l),Ll=n(l),o(D.$$.fragment,l),Pl=n(l),K=i(l,"P",{"data-svelte-h":!0}),y(K)!=="svelte-1rxi6tg"&&(K.textContent=Es),Dl=n(l),o(O.$$.fragment,l),Kl=n(l),ll=i(l,"P",{"data-svelte-h":!0}),y(ll)!=="svelte-eegy09"&&(ll.textContent=xs),Ol=n(l),o(sl.$$.fragment,l),ls=n(l),o(el.$$.fragment,l),ss=n(l),tl=i(l,"P",{"data-svelte-h":!0}),y(tl)!=="svelte-k6gec7"&&(tl.textContent=$s),es=n(l),o(al.$$.fragment,l),ts=n(l),nl=i(l,"P",{"data-svelte-h":!0}),y(nl)!=="svelte-gpwkjm"&&(nl.textContent=Ss),as=n(l),o(Ml.$$.fragment,l),ns=n(l),o(il.$$.fragment,l),Ms=n(l),yl=i(l,"P",{"data-svelte-h":!0}),y(yl)!=="svelte-17u0oai"&&(yl.textContent=Rs),is=n(l),pl=i(l,"OL",{"data-svelte-h":!0}),y(pl)!=="svelte-1caujcm"&&(pl.innerHTML=Ns),ys=n(l),ol=i(l,"P",{"data-svelte-h":!0}),y(ol)!=="svelte-1tc3qgy"&&(ol.textContent=Ys),ps=n(l),jl=i(l,"P",{"data-svelte-h":!0}),y(jl)!=="svelte-1ik86s0"&&(jl.innerHTML=Fs),os=n(l),o(wl.$$.fragment,l),js=n(l),Tl=i(l,"P",{}),Xs(Tl).forEach(e),this.h()},h(){Us(m,"name","hf:doc:metadata"),Us(m,"content",Ks),Us(r,"class","tip")},m(l,s){Ls(document.head,m),t(l,Jl,s),t(l,Ul,s),t(l,cl,s),j(h,l,s),t(l,ml,s),t(l,d,s),t(l,rl,s),t(l,u,s),t(l,hl,s),t(l,I,s),t(l,dl,s),t(l,C,s),t(l,ul,s),j(b,l,s),t(l,Il,s),t(l,g,s),t(l,Cl,s),t(l,A,s),t(l,bl,s),t(l,r,s),t(l,gl,s),j(G,l,s),t(l,Al,s),j(B,l,s),t(l,Gl,s),t(l,f,s),t(l,Bl,s),j(Z,l,s),t(l,fl,s),j(W,l,s),t(l,Zl,s),t(l,k,s),t(l,Wl,s),t(l,v,s),t(l,kl,s),j(E,l,s),t(l,vl,s),j(x,l,s),t(l,El,s),j($,l,s),t(l,xl,s),j(S,l,s),t(l,$l,s),j(R,l,s),t(l,Sl,s),j(N,l,s),t(l,Rl,s),t(l,Y,s),t(l,Nl,s),t(l,F,s),t(l,Yl,s),t(l,X,s),t(l,Fl,s),j(Q,l,s),t(l,Xl,s),t(l,_,s),t(l,Ql,s),t(l,V,s),t(l,_l,s),t(l,H,s),t(l,Vl,s),t(l,z,s),t(l,Hl,s),t(l,q,s),t(l,zl,s),t(l,L,s),t(l,ql,s),j(P,l,s),t(l,Ll,s),j(D,l,s),t(l,Pl,s),t(l,K,s),t(l,Dl,s),j(O,l,s),t(l,Kl,s),t(l,ll,s),t(l,Ol,s),j(sl,l,s),t(l,ls,s),j(el,l,s),t(l,ss,s),t(l,tl,s),t(l,es,s),j(al,l,s),t(l,ts,s),t(l,nl,s),t(l,as,s),j(Ml,l,s),t(l,ns,s),j(il,l,s),t(l,Ms,s),t(l,yl,s),t(l,is,s),t(l,pl,s),t(l,ys,s),t(l,ol,s),t(l,ps,s),t(l,jl,s),t(l,os,s),j(wl,l,s),t(l,js,s),t(l,Tl,s),ws=!0},p:_s,i(l){ws||(w(h.$$.fragment,l),w(b.$$.fragment,l),w(G.$$.fragment,l),w(B.$$.fragment,l),w(Z.$$.fragment,l),w(W.$$.fragment,l),w(E.$$.fragment,l),w(x.$$.fragment,l),w($.$$.fragment,l),w(S.$$.fragment,l),w(R.$$.fragment,l),w(N.$$.fragment,l),w(Q.$$.fragment,l),w(P.$$.fragment,l),w(D.$$.fragment,l),w(O.$$.fragment,l),w(sl.$$.fragment,l),w(el.$$.fragment,l),w(al.$$.fragment,l),w(Ml.$$.fragment,l),w(il.$$.fragment,l),w(wl.$$.fragment,l),ws=!0)},o(l){U(h.$$.fragment,l),U(b.$$.fragment,l),U(G.$$.fragment,l),U(B.$$.fragment,l),U(Z.$$.fragment,l),U(W.$$.fragment,l),U(E.$$.fragment,l),U(x.$$.fragment,l),U($.$$.fragment,l),U(S.$$.fragment,l),U(R.$$.fragment,l),U(N.$$.fragment,l),U(Q.$$.fragment,l),U(P.$$.fragment,l),U(D.$$.fragment,l),U(O.$$.fragment,l),U(sl.$$.fragment,l),U(el.$$.fragment,l),U(al.$$.fragment,l),U(Ml.$$.fragment,l),U(il.$$.fragment,l),U(wl.$$.fragment,l),ws=!1},d(l){l&&(e(Jl),e(Ul),e(cl),e(ml),e(d),e(rl),e(u),e(hl),e(I),e(dl),e(C),e(ul),e(Il),e(g),e(Cl),e(A),e(bl),e(r),e(gl),e(Al),e(Gl),e(f),e(Bl),e(fl),e(Zl),e(k),e(Wl),e(v),e(kl),e(vl),e(El),e(xl),e($l),e(Sl),e(Rl),e(Y),e(Nl),e(F),e(Yl),e(X),e(Fl),e(Xl),e(_),e(Ql),e(V),e(_l),e(H),e(Vl),e(z),e(Hl),e(q),e(zl),e(L),e(ql),e(Ll),e(Pl),e(K),e(Dl),e(Kl),e(ll),e(Ol),e(ls),e(ss),e(tl),e(es),e(ts),e(nl),e(as),e(ns),e(Ms),e(yl),e(is),e(pl),e(ys),e(ol),e(ps),e(jl),e(os),e(js),e(Tl)),e(m),T(h,l),T(b,l),T(G,l),T(B,l),T(Z,l),T(W,l),T(E,l),T(x,l),T($,l),T(S,l),T(R,l),T(N,l),T(Q,l),T(P,l),T(D,l),T(O,l),T(sl,l),T(el,l),T(al,l),T(Ml,l),T(il,l),T(wl,l)}}}const Ks='{"title":"Document Analysis Graph","local":"document-analysis-graph","sections":[{"title":"The Butler’s Workflow","local":"the-butlers-workflow","sections":[],"depth":2},{"title":"Setting Up the environment","local":"setting-up-the-environment","sections":[],"depth":2},{"title":"Defining Agent’s State","local":"defining-agents-state","sections":[],"depth":2},{"title":"Preparing Tools","local":"preparing-tools","sections":[],"depth":2},{"title":"The nodes","local":"the-nodes","sections":[],"depth":2},{"title":"The ReAct Pattern: How I Assist Mr. Wayne","local":"the-react-pattern-how-i-assist-mr-wayne","sections":[],"depth":2},{"title":"The Butler in Action","local":"the-butler-in-action","sections":[{"title":"Example 1: Simple Calculations","local":"example-1-simple-calculations","sections":[],"depth":3},{"title":"Example 2: Analyzing Master Wayne’s Training Documents","local":"example-2-analyzing-master-waynes-training-documents","sections":[],"depth":3}],"depth":2},{"title":"Key Takeaways","local":"key-takeaways","sections":[],"depth":2}],"depth":1}';function Os(Ts){return Vs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ne extends Hs{constructor(m){super(),zs(this,m,Os,Ds,Qs,{})}}export{ne as component};
