import{s as ge,n as ue,o as ye}from"../chunks/scheduler.85c25b89.js";import{S as Je,i as je,g as l,s as o,u as c,A as fe,h as n,f as e,c as i,j as h,v as d,y as m,k as p,o as r,a,w,d as M,t as g,x as u}from"../chunks/index.9633332f.js";import{I as rt}from"../chunks/IconCopyLink.a4acffac.js";import{C as et}from"../chunks/CodeBlock.00597c71.js";function Te(Xt){let y,ht,st,mt,J,v,at,Z,At,D,Ht="ResNet-D",ct,$,Ft='<strong>ResNet-D</strong> is a modification on the <a href="https://paperswithcode.com/method/resnet" rel="nofollow">ResNet</a> architecture that utilises an <a href="https://paperswithcode.com/method/average-pooling" rel="nofollow">average pooling</a> tweak for downsampling. The motivation is that in the unmodified ResNet, the <a href="https://paperswithcode.com/method/1x1-convolution" rel="nofollow">1×1 convolution</a> for the downsampling block ignores 3/4 of input feature maps, so this is modified so no information will be ignored',dt,j,U,lt,x,Rt,q,zt="How do I use this model on an image?",wt,N,Pt="To load a pretrained model:",Mt,W,gt,B,Lt="To load and preprocess the image:",ut,E,yt,_,Dt="To get the model predictions:",Jt,G,jt,Q,qt="To get the top-5 predictions class names:",ft,A,Tt,R,Kt="Replace the model name with the variant you want to use, e.g. <code>resnet101d</code>. You can find the IDs in the model summaries at the top of this page.",bt,S,Ot='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',vt,f,C,nt,V,St,K,te="How do I finetune this model?",Ut,Y,ee="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",Ct,X,It,H,se=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,kt,T,I,ot,F,Vt,O,ae="How do I train this model?",Zt,z,le='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',$t,b,k,it,P,Yt,tt,ne="Citation",xt,L,Nt,pt,Wt;return Z=new rt({}),x=new rt({}),W=new et({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3Jlc25ldDEwMWQnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;resnet101d&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`}}),E=new et({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`}}),G=new et({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`}}),A=new et({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`}}),V=new rt({}),X=new et({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgncmVzbmV0MTAxZCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;resnet101d&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)'}}),F=new rt({}),P=new rt({}),L=new et({props:{code:"JTQwbWlzYyU3QmhlMjAxOGJhZyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHRpdGxlJTNEJTdCQmFnJTIwb2YlMjBUcmlja3MlMjBmb3IlMjBJbWFnZSUyMENsYXNzaWZpY2F0aW9uJTIwd2l0aCUyMENvbnZvbHV0aW9uYWwlMjBOZXVyYWwlMjBOZXR3b3JrcyU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMGF1dGhvciUzRCU3QlRvbmclMjBIZSUyMGFuZCUyMFpoaSUyMFpoYW5nJTIwYW5kJTIwSGFuZyUyMFpoYW5nJTIwYW5kJTIwWmhvbmd5dWUlMjBaaGFuZyUyMGFuZCUyMEp1bnl1YW4lMjBYaWUlMjBhbmQlMjBNdSUyMExpJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMTglN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IxODEyLjAxMTg3JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuQ1YlN0QlMEElN0Q=",highlighted:`@misc{he<span class="hljs-symbol">2018b</span>ag,
      title={<span class="hljs-keyword">Bag </span>of Tricks for Image Classification with Convolutional Neural Networks}, 
      author={Tong He <span class="hljs-keyword">and </span>Zhi Zhang <span class="hljs-keyword">and </span>Hang Zhang <span class="hljs-keyword">and </span>Zhongyue Zhang <span class="hljs-keyword">and </span><span class="hljs-keyword">Junyuan </span>Xie <span class="hljs-keyword">and </span>Mu Li},
      year={<span class="hljs-number">2018</span>},
      eprint={<span class="hljs-number">1812</span>.<span class="hljs-number">01187</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`}}),{c(){y=l("meta"),ht=o(),st=l("p"),mt=o(),J=l("h1"),v=l("a"),at=l("span"),c(Z.$$.fragment),At=o(),D=l("span"),D.textContent=Ht,ct=o(),$=l("p"),$.innerHTML=Ft,dt=o(),j=l("h2"),U=l("a"),lt=l("span"),c(x.$$.fragment),Rt=o(),q=l("span"),q.textContent=zt,wt=o(),N=l("p"),N.textContent=Pt,Mt=o(),c(W.$$.fragment),gt=o(),B=l("p"),B.textContent=Lt,ut=o(),c(E.$$.fragment),yt=o(),_=l("p"),_.textContent=Dt,Jt=o(),c(G.$$.fragment),jt=o(),Q=l("p"),Q.textContent=qt,ft=o(),c(A.$$.fragment),Tt=o(),R=l("p"),R.innerHTML=Kt,bt=o(),S=l("p"),S.innerHTML=Ot,vt=o(),f=l("h2"),C=l("a"),nt=l("span"),c(V.$$.fragment),St=o(),K=l("span"),K.textContent=te,Ut=o(),Y=l("p"),Y.textContent=ee,Ct=o(),c(X.$$.fragment),It=o(),H=l("p"),H.innerHTML=se,kt=o(),T=l("h2"),I=l("a"),ot=l("span"),c(F.$$.fragment),Vt=o(),O=l("span"),O.textContent=ae,Zt=o(),z=l("p"),z.innerHTML=le,$t=o(),b=l("h2"),k=l("a"),it=l("span"),c(P.$$.fragment),Yt=o(),tt=l("span"),tt.textContent=ne,xt=o(),c(L.$$.fragment),Nt=o(),pt=l("p"),this.h()},l(t){const s=fe("svelte-1phssyn",document.head);y=n(s,"META",{name:!0,content:!0}),s.forEach(e),ht=i(t),st=n(t,"P",{}),h(st).forEach(e),mt=i(t),J=n(t,"H1",{class:!0});var Bt=h(J);v=n(Bt,"A",{id:!0,class:!0,href:!0});var oe=h(v);at=n(oe,"SPAN",{});var ie=h(at);d(Z.$$.fragment,ie),ie.forEach(e),oe.forEach(e),At=i(Bt),D=n(Bt,"SPAN",{"data-svelte-h":!0}),m(D)!=="svelte-kn4p5h"&&(D.textContent=Ht),Bt.forEach(e),ct=i(t),$=n(t,"P",{"data-svelte-h":!0}),m($)!=="svelte-8lziuy"&&($.innerHTML=Ft),dt=i(t),j=n(t,"H2",{class:!0});var Et=h(j);U=n(Et,"A",{id:!0,class:!0,href:!0});var pe=h(U);lt=n(pe,"SPAN",{});var re=h(lt);d(x.$$.fragment,re),re.forEach(e),pe.forEach(e),Rt=i(Et),q=n(Et,"SPAN",{"data-svelte-h":!0}),m(q)!=="svelte-1c1hspn"&&(q.textContent=zt),Et.forEach(e),wt=i(t),N=n(t,"P",{"data-svelte-h":!0}),m(N)!=="svelte-18ywhxh"&&(N.textContent=Pt),Mt=i(t),d(W.$$.fragment,t),gt=i(t),B=n(t,"P",{"data-svelte-h":!0}),m(B)!=="svelte-1c2ipa8"&&(B.textContent=Lt),ut=i(t),d(E.$$.fragment,t),yt=i(t),_=n(t,"P",{"data-svelte-h":!0}),m(_)!=="svelte-1n9qsq1"&&(_.textContent=Dt),Jt=i(t),d(G.$$.fragment,t),jt=i(t),Q=n(t,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-19cnvx1"&&(Q.textContent=qt),ft=i(t),d(A.$$.fragment,t),Tt=i(t),R=n(t,"P",{"data-svelte-h":!0}),m(R)!=="svelte-1iogwu7"&&(R.innerHTML=Kt),bt=i(t),S=n(t,"P",{"data-svelte-h":!0}),m(S)!=="svelte-1wmi3ea"&&(S.innerHTML=Ot),vt=i(t),f=n(t,"H2",{class:!0});var _t=h(f);C=n(_t,"A",{id:!0,class:!0,href:!0});var he=h(C);nt=n(he,"SPAN",{});var me=h(nt);d(V.$$.fragment,me),me.forEach(e),he.forEach(e),St=i(_t),K=n(_t,"SPAN",{"data-svelte-h":!0}),m(K)!=="svelte-1viv4qv"&&(K.textContent=te),_t.forEach(e),Ut=i(t),Y=n(t,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-9sr7nh"&&(Y.textContent=ee),Ct=i(t),d(X.$$.fragment,t),It=i(t),H=n(t,"P",{"data-svelte-h":!0}),m(H)!=="svelte-1kguc51"&&(H.innerHTML=se),kt=i(t),T=n(t,"H2",{class:!0});var Gt=h(T);I=n(Gt,"A",{id:!0,class:!0,href:!0});var ce=h(I);ot=n(ce,"SPAN",{});var de=h(ot);d(F.$$.fragment,de),de.forEach(e),ce.forEach(e),Vt=i(Gt),O=n(Gt,"SPAN",{"data-svelte-h":!0}),m(O)!=="svelte-1ce591d"&&(O.textContent=ae),Gt.forEach(e),Zt=i(t),z=n(t,"P",{"data-svelte-h":!0}),m(z)!=="svelte-1n0coha"&&(z.innerHTML=le),$t=i(t),b=n(t,"H2",{class:!0});var Qt=h(b);k=n(Qt,"A",{id:!0,class:!0,href:!0});var we=h(k);it=n(we,"SPAN",{});var Me=h(it);d(P.$$.fragment,Me),Me.forEach(e),we.forEach(e),Yt=i(Qt),tt=n(Qt,"SPAN",{"data-svelte-h":!0}),m(tt)!=="svelte-15mb3gy"&&(tt.textContent=ne),Qt.forEach(e),xt=i(t),d(L.$$.fragment,t),Nt=i(t),pt=n(t,"P",{}),h(pt).forEach(e),this.h()},h(){p(y,"name","hf:doc:metadata"),p(y,"content",JSON.stringify(be)),p(v,"id","resnetd"),p(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(v,"href","#resnetd"),p(J,"class","relative group"),p(U,"id","how-do-i-use-this-model-on-an-image"),p(U,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(U,"href","#how-do-i-use-this-model-on-an-image"),p(j,"class","relative group"),p(C,"id","how-do-i-finetune-this-model"),p(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(C,"href","#how-do-i-finetune-this-model"),p(f,"class","relative group"),p(I,"id","how-do-i-train-this-model"),p(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(I,"href","#how-do-i-train-this-model"),p(T,"class","relative group"),p(k,"id","citation"),p(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(k,"href","#citation"),p(b,"class","relative group")},m(t,s){r(document.head,y),a(t,ht,s),a(t,st,s),a(t,mt,s),a(t,J,s),r(J,v),r(v,at),w(Z,at,null),r(J,At),r(J,D),a(t,ct,s),a(t,$,s),a(t,dt,s),a(t,j,s),r(j,U),r(U,lt),w(x,lt,null),r(j,Rt),r(j,q),a(t,wt,s),a(t,N,s),a(t,Mt,s),w(W,t,s),a(t,gt,s),a(t,B,s),a(t,ut,s),w(E,t,s),a(t,yt,s),a(t,_,s),a(t,Jt,s),w(G,t,s),a(t,jt,s),a(t,Q,s),a(t,ft,s),w(A,t,s),a(t,Tt,s),a(t,R,s),a(t,bt,s),a(t,S,s),a(t,vt,s),a(t,f,s),r(f,C),r(C,nt),w(V,nt,null),r(f,St),r(f,K),a(t,Ut,s),a(t,Y,s),a(t,Ct,s),w(X,t,s),a(t,It,s),a(t,H,s),a(t,kt,s),a(t,T,s),r(T,I),r(I,ot),w(F,ot,null),r(T,Vt),r(T,O),a(t,Zt,s),a(t,z,s),a(t,$t,s),a(t,b,s),r(b,k),r(k,it),w(P,it,null),r(b,Yt),r(b,tt),a(t,xt,s),w(L,t,s),a(t,Nt,s),a(t,pt,s),Wt=!0},p:ue,i(t){Wt||(M(Z.$$.fragment,t),M(x.$$.fragment,t),M(W.$$.fragment,t),M(E.$$.fragment,t),M(G.$$.fragment,t),M(A.$$.fragment,t),M(V.$$.fragment,t),M(X.$$.fragment,t),M(F.$$.fragment,t),M(P.$$.fragment,t),M(L.$$.fragment,t),Wt=!0)},o(t){g(Z.$$.fragment,t),g(x.$$.fragment,t),g(W.$$.fragment,t),g(E.$$.fragment,t),g(G.$$.fragment,t),g(A.$$.fragment,t),g(V.$$.fragment,t),g(X.$$.fragment,t),g(F.$$.fragment,t),g(P.$$.fragment,t),g(L.$$.fragment,t),Wt=!1},d(t){t&&(e(ht),e(st),e(mt),e(J),e(ct),e($),e(dt),e(j),e(wt),e(N),e(Mt),e(gt),e(B),e(ut),e(yt),e(_),e(Jt),e(jt),e(Q),e(ft),e(Tt),e(R),e(bt),e(S),e(vt),e(f),e(Ut),e(Y),e(Ct),e(It),e(H),e(kt),e(T),e(Zt),e(z),e($t),e(b),e(xt),e(Nt),e(pt)),e(y),u(Z),u(x),u(W,t),u(E,t),u(G,t),u(A,t),u(V),u(X,t),u(F),u(P),u(L,t)}}}const be={local:"resnetd",sections:[{local:"how-do-i-use-this-model-on-an-image",title:"How do I use this model on an image?"},{local:"how-do-i-finetune-this-model",title:"How do I finetune this model?"},{local:"how-do-i-train-this-model",title:"How do I train this model?"},{local:"citation",title:"Citation"}],title:"ResNet-D"};function ve(Xt){return ye(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ze extends Je{constructor(y){super(),je(this,y,ve,Te,ge,{})}}export{Ze as component};
