import{s as Cl,n as Il,o as fl}from"../chunks/scheduler.85c25b89.js";import{S as Al,i as Zl,g as M,s as e,r as m,A as kl,h as p,f as t,c as n,j as bl,u as i,x as r,k as ul,y as Bl,a,v as o,d as j,t as c,w as y}from"../chunks/index.c9837788.js";import{C as v}from"../chunks/CodeBlock.52fa569e.js";import{H as Y}from"../chunks/Heading.3097d2ed.js";function Nl(jl){let h,V,x,X,J,_,w,cl='<strong>MobileNetV3</strong> is a convolutional neural network that is designed for mobile phone CPUs. The network design includes the use of a <a href="https://paperswithcode.com/method/hard-swish" rel="nofollow">hard swish activation</a> and <a href="https://paperswithcode.com/method/squeeze-and-excitation-block" rel="nofollow">squeeze-and-excitation</a> modules in the <a href="https://paperswithcode.com/method/inverted-residual-block" rel="nofollow">MBConv blocks</a>.',S,T,F,d,yl="To load a pretrained model:",H,U,z,g,rl="To load and preprocess the image:",D,b,L,u,hl="To get the model predictions:",q,C,P,I,Jl="To get the top-5 predictions class names:",K,f,O,A,wl="Replace the model name with the variant you want to use, e.g. <code>mobilenetv3_large_100</code>. You can find the IDs in the model summaries at the top of this page.",ll,Z,Tl='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',sl,k,tl,B,dl="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",al,N,el,W,Ul=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,nl,$,Ml,G,gl='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',pl,E,ml,Q,il,R,ol;return J=new Y({props:{title:"MobileNet v3",local:"mobilenet-v3",headingTag:"h1"}}),T=new Y({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),U=new v({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ21vYmlsZW5ldHYzX2xhcmdlXzEwMCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;mobilenetv3_large_100&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new v({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),C=new v({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),f=new v({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),k=new Y({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),N=new v({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnbW9iaWxlbmV0djNfbGFyZ2VfMTAwJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;mobilenetv3_large_100&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),$=new Y({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),E=new Y({props:{title:"Citation",local:"citation",headingTag:"h2"}}),Q=new v({props:{code:"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",highlighted:`<span class="hljs-comment">@article{DBLP:journals/corr/abs-1905-02244,</span>
  author    = {Andrew Howard <span class="hljs-keyword">and</span>
               Mark Sandler <span class="hljs-keyword">and</span>
               Grace Chu <span class="hljs-keyword">and</span>
               Liang{-}Chieh Chen <span class="hljs-keyword">and</span>
               Bo Chen <span class="hljs-keyword">and</span>
               Mingxing Tan <span class="hljs-keyword">and</span>
               Weijun Wang <span class="hljs-keyword">and</span>
               Yukun Zhu <span class="hljs-keyword">and</span>
               Ruoming Pang <span class="hljs-keyword">and</span>
               Vijay Vasudevan <span class="hljs-keyword">and</span>
               Quoc V. Le <span class="hljs-keyword">and</span>
               Hartwig Adam},
  title     = {Searching for MobileNetV3},
  journal   = {CoRR},
  volume    = {abs/<span class="hljs-number">1905</span>.<span class="hljs-number">02244</span>},
  year      = {<span class="hljs-number">2019</span>},
  url       = {http:<span class="hljs-comment">//arxiv.org/abs/1905.02244},</span>
  archivePrefix = {arXiv},
  eprint    = {<span class="hljs-number">1905</span>.<span class="hljs-number">02244</span>},
  timestamp = {Tue, <span class="hljs-number">12</span> Jan <span class="hljs-number">2021</span> <span class="hljs-number">15</span>:<span class="hljs-number">30</span>:<span class="hljs-number">06</span> +<span class="hljs-number">0100</span>},
  biburl    = {https:<span class="hljs-comment">//dblp.org/rec/journals/corr/abs-1905-02244.bib},</span>
  bibsource = {dblp computer science bibliography, https:<span class="hljs-comment">//dblp.org}</span>
}`,wrap:!1}}),{c(){h=M("meta"),V=e(),x=M("p"),X=e(),m(J.$$.fragment),_=e(),w=M("p"),w.innerHTML=cl,S=e(),m(T.$$.fragment),F=e(),d=M("p"),d.textContent=yl,H=e(),m(U.$$.fragment),z=e(),g=M("p"),g.textContent=rl,D=e(),m(b.$$.fragment),L=e(),u=M("p"),u.textContent=hl,q=e(),m(C.$$.fragment),P=e(),I=M("p"),I.textContent=Jl,K=e(),m(f.$$.fragment),O=e(),A=M("p"),A.innerHTML=wl,ll=e(),Z=M("p"),Z.innerHTML=Tl,sl=e(),m(k.$$.fragment),tl=e(),B=M("p"),B.textContent=dl,al=e(),m(N.$$.fragment),el=e(),W=M("p"),W.innerHTML=Ul,nl=e(),m($.$$.fragment),Ml=e(),G=M("p"),G.innerHTML=gl,pl=e(),m(E.$$.fragment),ml=e(),m(Q.$$.fragment),il=e(),R=M("p"),this.h()},l(l){const s=kl("svelte-u9bgzb",document.head);h=p(s,"META",{name:!0,content:!0}),s.forEach(t),V=n(l),x=p(l,"P",{}),bl(x).forEach(t),X=n(l),i(J.$$.fragment,l),_=n(l),w=p(l,"P",{"data-svelte-h":!0}),r(w)!=="svelte-1xpy3t9"&&(w.innerHTML=cl),S=n(l),i(T.$$.fragment,l),F=n(l),d=p(l,"P",{"data-svelte-h":!0}),r(d)!=="svelte-18ywhxh"&&(d.textContent=yl),H=n(l),i(U.$$.fragment,l),z=n(l),g=p(l,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1c2ipa8"&&(g.textContent=rl),D=n(l),i(b.$$.fragment,l),L=n(l),u=p(l,"P",{"data-svelte-h":!0}),r(u)!=="svelte-1n9qsq1"&&(u.textContent=hl),q=n(l),i(C.$$.fragment,l),P=n(l),I=p(l,"P",{"data-svelte-h":!0}),r(I)!=="svelte-19cnvx1"&&(I.textContent=Jl),K=n(l),i(f.$$.fragment,l),O=n(l),A=p(l,"P",{"data-svelte-h":!0}),r(A)!=="svelte-w2zjew"&&(A.innerHTML=wl),ll=n(l),Z=p(l,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1wmi3ea"&&(Z.innerHTML=Tl),sl=n(l),i(k.$$.fragment,l),tl=n(l),B=p(l,"P",{"data-svelte-h":!0}),r(B)!=="svelte-9sr7nh"&&(B.textContent=dl),al=n(l),i(N.$$.fragment,l),el=n(l),W=p(l,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1kguc51"&&(W.innerHTML=Ul),nl=n(l),i($.$$.fragment,l),Ml=n(l),G=p(l,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1n0coha"&&(G.innerHTML=gl),pl=n(l),i(E.$$.fragment,l),ml=n(l),i(Q.$$.fragment,l),il=n(l),R=p(l,"P",{}),bl(R).forEach(t),this.h()},h(){ul(h,"name","hf:doc:metadata"),ul(h,"content",Wl)},m(l,s){Bl(document.head,h),a(l,V,s),a(l,x,s),a(l,X,s),o(J,l,s),a(l,_,s),a(l,w,s),a(l,S,s),o(T,l,s),a(l,F,s),a(l,d,s),a(l,H,s),o(U,l,s),a(l,z,s),a(l,g,s),a(l,D,s),o(b,l,s),a(l,L,s),a(l,u,s),a(l,q,s),o(C,l,s),a(l,P,s),a(l,I,s),a(l,K,s),o(f,l,s),a(l,O,s),a(l,A,s),a(l,ll,s),a(l,Z,s),a(l,sl,s),o(k,l,s),a(l,tl,s),a(l,B,s),a(l,al,s),o(N,l,s),a(l,el,s),a(l,W,s),a(l,nl,s),o($,l,s),a(l,Ml,s),a(l,G,s),a(l,pl,s),o(E,l,s),a(l,ml,s),o(Q,l,s),a(l,il,s),a(l,R,s),ol=!0},p:Il,i(l){ol||(j(J.$$.fragment,l),j(T.$$.fragment,l),j(U.$$.fragment,l),j(b.$$.fragment,l),j(C.$$.fragment,l),j(f.$$.fragment,l),j(k.$$.fragment,l),j(N.$$.fragment,l),j($.$$.fragment,l),j(E.$$.fragment,l),j(Q.$$.fragment,l),ol=!0)},o(l){c(J.$$.fragment,l),c(T.$$.fragment,l),c(U.$$.fragment,l),c(b.$$.fragment,l),c(C.$$.fragment,l),c(f.$$.fragment,l),c(k.$$.fragment,l),c(N.$$.fragment,l),c($.$$.fragment,l),c(E.$$.fragment,l),c(Q.$$.fragment,l),ol=!1},d(l){l&&(t(V),t(x),t(X),t(_),t(w),t(S),t(F),t(d),t(H),t(z),t(g),t(D),t(L),t(u),t(q),t(P),t(I),t(K),t(O),t(A),t(ll),t(Z),t(sl),t(tl),t(B),t(al),t(el),t(W),t(nl),t(Ml),t(G),t(pl),t(ml),t(il),t(R)),t(h),y(J,l),y(T,l),y(U,l),y(b,l),y(C,l),y(f,l),y(k,l),y(N,l),y($,l),y(E,l),y(Q,l)}}}const Wl='{"title":"MobileNet v3","local":"mobilenet-v3","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function $l(jl){return fl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class xl extends Al{constructor(h){super(),Zl(this,h,$l,Nl,Cl,{})}}export{xl as component};
