import{s as vl,n as $l,o as Gl}from"../chunks/scheduler.85c25b89.js";import{S as El,i as xl,g as M,s as e,r as J,A as Ql,h as p,f as a,c as n,j as Wl,u as i,x as w,k as Zl,y as Yl,a as t,v as m,d as o,t as T,w as j}from"../chunks/index.c9837788.js";import{C as R}from"../chunks/CodeBlock.52fa569e.js";import{H as F,E as Nl}from"../chunks/EditOnGithub.b65eee75.js";function Rl(yl){let h,_,V,S,r,H,y,cl='<strong>Inception v3</strong> is a convolutional neural network architecture from the Inception family that makes several improvements including using <a href="https://paperswithcode.com/method/label-smoothing" rel="nofollow">Label Smoothing</a>, Factorized 7 x 7 convolutions, and the use of an <a href="https://paperswithcode.com/method/auxiliary-classifier" rel="nofollow">auxiliary classifier</a> to propagate label information lower down the network (along with the use of batch normalization for layers in the sidehead). The key building block is an <a href="https://paperswithcode.com/method/inception-v3-module" rel="nofollow">Inception Module</a>.',z,c,Il="This particular model was trained for study of adversarial examples (adversarial training).",L,I,dl='The weights from this model were ported from <a href="https://github.com/tensorflow/models" rel="nofollow">Tensorflow/Models</a>.',D,d,P,U,Ul="To load a pretrained model:",q,u,K,g,ul="To load and preprocess the image:",O,b,ll,A,gl="To get the model predictions:",sl,C,al,f,bl="To get the top-5 predictions class names:",tl,k,el,B,Al="Replace the model name with the variant you want to use, e.g. <code>adv_inception_v3</code>. You can find the IDs in the model summaries at the top of this page.",nl,W,Cl='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',Ml,Z,pl,v,fl="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",Jl,$,il,G,kl=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,wl,E,ml,x,Bl='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',ol,Q,Tl,Y,jl,N,hl,X,rl;return r=new F({props:{title:"Adversarial Inception v3",local:"adversarial-inception-v3",headingTag:"h1"}}),d=new F({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),u=new R({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2Fkdl9pbmNlcHRpb25fdjMnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;adv_inception_v3&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new R({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),C=new R({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),k=new R({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),Z=new F({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),$=new R({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnYWR2X2luY2VwdGlvbl92MyclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;adv_inception_v3&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),E=new F({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),Q=new F({props:{title:"Citation",local:"citation",headingTag:"h2"}}),Y=new R({props:{code:"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",highlighted:`<span class="hljs-comment">@article{DBLP:journals/corr/abs-1804-00097,</span>
  author    = {Alexey Kurakin <span class="hljs-keyword">and</span>
               Ian J. Goodfellow <span class="hljs-keyword">and</span>
               Samy Bengio <span class="hljs-keyword">and</span>
               Yinpeng Dong <span class="hljs-keyword">and</span>
               Fangzhou Liao <span class="hljs-keyword">and</span>
               Ming Liang <span class="hljs-keyword">and</span>
               Tianyu Pang <span class="hljs-keyword">and</span>
               Jun Zhu <span class="hljs-keyword">and</span>
               Xiaolin Hu <span class="hljs-keyword">and</span>
               Cihang Xie <span class="hljs-keyword">and</span>
               Jianyu Wang <span class="hljs-keyword">and</span>
               Zhishuai Zhang <span class="hljs-keyword">and</span>
               Zhou Ren <span class="hljs-keyword">and</span>
               Alan L. Yuille <span class="hljs-keyword">and</span>
               Sangxia Huang <span class="hljs-keyword">and</span>
               Yao Zhao <span class="hljs-keyword">and</span>
               Yuzhe Zhao <span class="hljs-keyword">and</span>
               Zhonglin Han <span class="hljs-keyword">and</span>
               Junjiajia Long <span class="hljs-keyword">and</span>
               Yerkebulan Berdibekov <span class="hljs-keyword">and</span>
               Takuya Akiba <span class="hljs-keyword">and</span>
               Seiya Tokui <span class="hljs-keyword">and</span>
               Motoki Abe},
  title     = {Adversarial Attacks <span class="hljs-keyword">and</span> Defences Competition},
  journal   = {CoRR},
  volume    = {abs/<span class="hljs-number">1804</span>.<span class="hljs-number">00097</span>},
  year      = {<span class="hljs-number">2018</span>},
  url       = {http:<span class="hljs-comment">//arxiv.org/abs/1804.00097},</span>
  archivePrefix = {arXiv},
  eprint    = {<span class="hljs-number">1804</span>.<span class="hljs-number">00097</span>},
  timestamp = {Thu, <span class="hljs-number">31</span> Oct <span class="hljs-number">2019</span> <span class="hljs-number">16</span>:<span class="hljs-number">31</span>:<span class="hljs-number">22</span> +<span class="hljs-number">0100</span>},
  biburl    = {https:<span class="hljs-comment">//dblp.org/rec/journals/corr/abs-1804-00097.bib},</span>
  bibsource = {dblp computer science bibliography, https:<span class="hljs-comment">//dblp.org}</span>
}`,wrap:!1}}),N=new Nl({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/adversarial-inception-v3.mdx"}}),{c(){h=M("meta"),_=e(),V=M("p"),S=e(),J(r.$$.fragment),H=e(),y=M("p"),y.innerHTML=cl,z=e(),c=M("p"),c.textContent=Il,L=e(),I=M("p"),I.innerHTML=dl,D=e(),J(d.$$.fragment),P=e(),U=M("p"),U.textContent=Ul,q=e(),J(u.$$.fragment),K=e(),g=M("p"),g.textContent=ul,O=e(),J(b.$$.fragment),ll=e(),A=M("p"),A.textContent=gl,sl=e(),J(C.$$.fragment),al=e(),f=M("p"),f.textContent=bl,tl=e(),J(k.$$.fragment),el=e(),B=M("p"),B.innerHTML=Al,nl=e(),W=M("p"),W.innerHTML=Cl,Ml=e(),J(Z.$$.fragment),pl=e(),v=M("p"),v.textContent=fl,Jl=e(),J($.$$.fragment),il=e(),G=M("p"),G.innerHTML=kl,wl=e(),J(E.$$.fragment),ml=e(),x=M("p"),x.innerHTML=Bl,ol=e(),J(Q.$$.fragment),Tl=e(),J(Y.$$.fragment),jl=e(),J(N.$$.fragment),hl=e(),X=M("p"),this.h()},l(l){const s=Ql("svelte-u9bgzb",document.head);h=p(s,"META",{name:!0,content:!0}),s.forEach(a),_=n(l),V=p(l,"P",{}),Wl(V).forEach(a),S=n(l),i(r.$$.fragment,l),H=n(l),y=p(l,"P",{"data-svelte-h":!0}),w(y)!=="svelte-1oyeygh"&&(y.innerHTML=cl),z=n(l),c=p(l,"P",{"data-svelte-h":!0}),w(c)!=="svelte-1fjxi1n"&&(c.textContent=Il),L=n(l),I=p(l,"P",{"data-svelte-h":!0}),w(I)!=="svelte-1nh6o5x"&&(I.innerHTML=dl),D=n(l),i(d.$$.fragment,l),P=n(l),U=p(l,"P",{"data-svelte-h":!0}),w(U)!=="svelte-18ywhxh"&&(U.textContent=Ul),q=n(l),i(u.$$.fragment,l),K=n(l),g=p(l,"P",{"data-svelte-h":!0}),w(g)!=="svelte-1c2ipa8"&&(g.textContent=ul),O=n(l),i(b.$$.fragment,l),ll=n(l),A=p(l,"P",{"data-svelte-h":!0}),w(A)!=="svelte-1n9qsq1"&&(A.textContent=gl),sl=n(l),i(C.$$.fragment,l),al=n(l),f=p(l,"P",{"data-svelte-h":!0}),w(f)!=="svelte-19cnvx1"&&(f.textContent=bl),tl=n(l),i(k.$$.fragment,l),el=n(l),B=p(l,"P",{"data-svelte-h":!0}),w(B)!=="svelte-1wl9nov"&&(B.innerHTML=Al),nl=n(l),W=p(l,"P",{"data-svelte-h":!0}),w(W)!=="svelte-1wmi3ea"&&(W.innerHTML=Cl),Ml=n(l),i(Z.$$.fragment,l),pl=n(l),v=p(l,"P",{"data-svelte-h":!0}),w(v)!=="svelte-9sr7nh"&&(v.textContent=fl),Jl=n(l),i($.$$.fragment,l),il=n(l),G=p(l,"P",{"data-svelte-h":!0}),w(G)!=="svelte-1kguc51"&&(G.innerHTML=kl),wl=n(l),i(E.$$.fragment,l),ml=n(l),x=p(l,"P",{"data-svelte-h":!0}),w(x)!=="svelte-xtxxu6"&&(x.innerHTML=Bl),ol=n(l),i(Q.$$.fragment,l),Tl=n(l),i(Y.$$.fragment,l),jl=n(l),i(N.$$.fragment,l),hl=n(l),X=p(l,"P",{}),Wl(X).forEach(a),this.h()},h(){Zl(h,"name","hf:doc:metadata"),Zl(h,"content",Vl)},m(l,s){Yl(document.head,h),t(l,_,s),t(l,V,s),t(l,S,s),m(r,l,s),t(l,H,s),t(l,y,s),t(l,z,s),t(l,c,s),t(l,L,s),t(l,I,s),t(l,D,s),m(d,l,s),t(l,P,s),t(l,U,s),t(l,q,s),m(u,l,s),t(l,K,s),t(l,g,s),t(l,O,s),m(b,l,s),t(l,ll,s),t(l,A,s),t(l,sl,s),m(C,l,s),t(l,al,s),t(l,f,s),t(l,tl,s),m(k,l,s),t(l,el,s),t(l,B,s),t(l,nl,s),t(l,W,s),t(l,Ml,s),m(Z,l,s),t(l,pl,s),t(l,v,s),t(l,Jl,s),m($,l,s),t(l,il,s),t(l,G,s),t(l,wl,s),m(E,l,s),t(l,ml,s),t(l,x,s),t(l,ol,s),m(Q,l,s),t(l,Tl,s),m(Y,l,s),t(l,jl,s),m(N,l,s),t(l,hl,s),t(l,X,s),rl=!0},p:$l,i(l){rl||(o(r.$$.fragment,l),o(d.$$.fragment,l),o(u.$$.fragment,l),o(b.$$.fragment,l),o(C.$$.fragment,l),o(k.$$.fragment,l),o(Z.$$.fragment,l),o($.$$.fragment,l),o(E.$$.fragment,l),o(Q.$$.fragment,l),o(Y.$$.fragment,l),o(N.$$.fragment,l),rl=!0)},o(l){T(r.$$.fragment,l),T(d.$$.fragment,l),T(u.$$.fragment,l),T(b.$$.fragment,l),T(C.$$.fragment,l),T(k.$$.fragment,l),T(Z.$$.fragment,l),T($.$$.fragment,l),T(E.$$.fragment,l),T(Q.$$.fragment,l),T(Y.$$.fragment,l),T(N.$$.fragment,l),rl=!1},d(l){l&&(a(_),a(V),a(S),a(H),a(y),a(z),a(c),a(L),a(I),a(D),a(P),a(U),a(q),a(K),a(g),a(O),a(ll),a(A),a(sl),a(al),a(f),a(tl),a(el),a(B),a(nl),a(W),a(Ml),a(pl),a(v),a(Jl),a(il),a(G),a(wl),a(ml),a(x),a(ol),a(Tl),a(jl),a(hl),a(X)),a(h),j(r,l),j(d,l),j(u,l),j(b,l),j(C,l),j(k,l),j(Z,l),j($,l),j(E,l),j(Q,l),j(Y,l),j(N,l)}}}const Vl='{"title":"Adversarial Inception v3","local":"adversarial-inception-v3","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Xl(yl){return Gl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zl extends El{constructor(h){super(),xl(this,h,Xl,Rl,vl,{})}}export{zl as component};
