import{s as nl,o as Jl,n as il}from"../chunks/scheduler.c59d9fbb.js";import{S as Tl,i as ol,g as J,s as a,r as M,A as Ml,h as i,f as s,c as n,j as tl,u as U,x as T,k as al,y as Ul,a as t,v as r,d,t as c,w as y}from"../chunks/index.a47918e3.js";import{T as rl}from"../chunks/Tip.3fcf4aa4.js";import{C as K}from"../chunks/CodeBlock.936db8cd.js";import{D as dl}from"../chunks/DocNotebookDropdown.efd8a791.js";import{H as O}from"../chunks/Heading.604bc707.js";function cl(se){let o,m="Unlike the default Logistic Regression head, the differentiable classification head only supports integer labels in the following range: <code>[0, num_classes)</code>.";return{c(){o=J("p"),o.innerHTML=m},l(p){o=i(p,"P",{"data-svelte-h":!0}),T(o)!=="svelte-1ivugeb"&&(o.innerHTML=m)},m(p,ee){t(p,o,ee)},p:il,d(p){p&&s(o)}}}function yl(se){let o,m,p,ee,g,te,h,ae,u,Ne='Any 🤗 SetFit model consists of two parts: a <a href="https://sbert.net/" rel="nofollow">SentenceTransformer</a> embedding body and a classification head.',ne,A,$e="This guide will show you:",Je,f,ve="<li>The built-in logistic regression classification head</li> <li>The built-in differentiable classification head</li> <li>The requirements for a custom classification head</li>",ie,w,Te,k,Se='When a new SetFit model is initialized, a <a href="https://scikit-learn.org/stable/modules/generated/sklearn.linear_model.LogisticRegression.html" rel="nofollow">scikit-learn logistic regression</a> head is chosen by default. This has been shown to be highly effective when applied on top of a finetuned sentence transformer body, and it remains the recommended classification head. Initializing a new SetFit model with a Logistic Regression head is simple:',oe,b,Me,I,Ee="To initialize the Logistic Regression head (or any other head) with additional parameters, then you can use the <code>head_params</code> argument on <code>SetFitModel.from_pretrained()</code>:",Ue,Z,re,_,de,B,Qe='SetFit also provides <a href="/docs/setfit/v1.0.1/en/reference/main#setfit.SetFitHead">SetFitHead</a> as an exclusively <code>torch</code> classification head. It uses a linear layer to map the embeddings to the class. It can be used by setting the <code>use_differentiable_head</code> argument on <code>SetFitModel.from_pretrained()</code> to <code>True</code>:',ce,C,ye,W,ze="By default, this will assume binary classification. To change that, also set the <code>out_features</code> via <code>head_params</code> to the number of classes that you are using.",pe,F,je,j,me,G,ge,x,Ve='Using the <a href="/docs/setfit/v1.0.1/en/reference/main#setfit.SetFitHead">SetFitHead</a> unlocks some new <a href="/docs/setfit/v1.0.1/en/reference/trainer#setfit.TrainingArguments">TrainingArguments</a> that are not used with a sklearn-based head. Note that training with SetFit consists of two phases behind the scenes: <strong>finetuning embeddings</strong> and <strong>training a classification head</strong>. As a result, some of the training arguments can be tuples, where the two values are used for each of the two phases, respectively. For a lot of these cases, the second value is only used if the classification head is differentiable. For example:',he,R,Ye="<li><p><strong>batch_size</strong>: (<code>Union[int, Tuple[int, int]]</code>, defaults to <code>(16, 2)</code>) - The second value in the tuple determines the batch size when training the differentiable SetFitHead.</p></li> <li><p><strong>num_epochs</strong>: (<code>Union[int, Tuple[int, int]]</code>, defaults to <code>(1, 16)</code>) - The second value in the tuple determines the number of epochs when training the differentiable SetFitHead. In practice, the <code>num_epochs</code> is usually larger for training the classification head. There are two reasons for this:</p> <ol><li>This training phase does not train with contrastive pairs, so unlike when finetuning the embedding model, you only get one training sample per labeled training text.</li> <li>This training phase involves training a classifier from scratch, not finetuning an already capable model. We need more training steps for this.</li></ol></li> <li><p><strong>end_to_end</strong>: (<code>bool</code>, defaults to <code>False</code>) - If <code>True</code>, train the entire model end-to-end during the classifier training phase. Otherwise, freeze the Sentence Transformer body and only train the head.</p></li> <li><p><strong>body_learning_rate</strong>: (<code>Union[float, Tuple[float, float]]</code>, defaults to <code>(2e-5, 1e-5)</code>) - The second value in the tuple determines the learning rate of the Sentence Transformer body during the classifier training phase. This is only relevant if <code>end_to_end</code> is <code>True</code>, as otherwise the Sentence Transformer body is frozen when training the classifier.</p></li> <li><p><strong>head_learning_rate</strong> (<code>float</code>, defaults to <code>1e-2</code>) - This value determines the learning rate of the differentiable head during the classifier training phase. It is only used if the differentiable head is used.</p></li> <li><p><strong>l2_weight</strong> (<code>float</code>, <em>optional</em>) - Optional l2 weight for both the model body and head, passed to the <code>AdamW</code> optimizer in the classifier training phase only if a differentiable head is used.</p></li>",ue,X,He="For example, a full training script using a differentiable classification head may look something like this:",Ae,N,fe,$,we,v,De="Alongside the two built-in options, SetFit allows you to specify a custom classification head. There are two forms of supported heads: a custom <strong>differentiable</strong> head or a custom <strong>non-differentiable</strong> head. Both heads must implement the following two methods:",ke,S,be,E,Le="A custom differentiable head must follow these requirements:",Ie,Q,qe="<li>Must subclass <code>nn.Module</code>.</li> <li>A <code>predict</code> method: <code>(self, torch.Tensor with shape [num_inputs, embedding_size]) -&gt; torch.Tensor with shape [num_inputs]</code> - This method classifies the embeddings. The output must integers in the range of <code>[0, num_classes)</code>.</li> <li>A <code>predict_proba</code> method: <code>(self, torch.Tensor with shape [num_inputs, embedding_size]) -&gt; torch.Tensor with shape [num_inputs, num_classes]</code> - This method classifies the embeddings into probabilities for each class. For each input, the tensor of size <code>num_classes</code> must sum to 1. Applying <code>torch.argmax(output, dim=-1)</code> should result in the output for <code>predict</code>.</li> <li>A <code>get_loss_fn</code> method: <code>(self) -&gt; nn.Module</code> - Returns an initialized loss function, e.g. <code>torch.nn.CrossEntropyLoss()</code>.</li> <li>A <code>forward</code> method: <code>(self, Dict[str, torch.Tensor]) -&gt; Dict[str, torch.Tensor]</code> - Given the output from the Sentence Transformer body, i.e. a dictionary of <code>&#39;input_ids&#39;</code>, <code>&#39;token_type_ids&#39;</code>, <code>&#39;attention_mask&#39;</code>, <code>&#39;token_embeddings&#39;</code> and <code>&#39;sentence_embedding&#39;</code> keys, return a dictionary with a <code>&#39;logits&#39;</code> key and a <code>torch.Tensor</code> value with shape <code>[batch_size, num_classes]</code>.</li>",Ze,z,_e,V,Pe="A custom non-differentiable head must follow these requirements:",Be,Y,Ke="<li>A <code>predict</code> method: <code>(self, np.array with shape [num_inputs, embedding_size]) -&gt; np.array with shape [num_inputs]</code> - This method classifies the embeddings. The output must integers in the range of <code>[0, num_classes)</code>.</li> <li>A <code>predict_proba</code> method: <code>(self, np.array with shape [num_inputs, embedding_size]) -&gt; np.array with shape [num_inputs, num_classes]</code> - This method classifies the embeddings into probabilities for each class. For each input, the array of size <code>num_classes</code> must sum to 1. Applying <code>np.argmax(output, dim=-1)</code> should result in the output for <code>predict</code>.</li> <li>A <code>fit</code> method: <code>(self, np.array with shape [num_inputs, embedding_size], List[Any]) -&gt; None</code> - This method must take a <code>numpy</code> array of embeddings and a list of corresponding labels. The labels need not be integers per se.</li>",Ce,H,Oe='Many classifiers from sklearn already fit these requirements, such as <a href="https://scikit-learn.org/stable/modules/generated/sklearn.ensemble.RandomForestClassifier.html#sklearn.ensemble.RandomForestClassifier" rel="nofollow"><code>RandomForestClassifier</code></a>, <a href="https://scikit-learn.org/stable/modules/generated/sklearn.neural_network.MLPClassifier.html#sklearn.neural_network.MLPClassifier" rel="nofollow"><code>MLPClassifier</code></a>, <a href="https://scikit-learn.org/stable/modules/generated/sklearn.neighbors.KNeighborsClassifier.html#sklearn.neighbors.KNeighborsClassifier" rel="nofollow"><code>KNeighborsClassifier</code></a>, etc.',We,D,el="When initializing a SetFit model using your custom (non-)differentiable classification head, it is recommended to use the regular <code>__init__</code> method:",Fe,L,Ge,q,ll="Then, training and inference can commence like normal, e.g.:",xe,P,Re,le,Xe;return g=new O({props:{title:"Classification heads",local:"classification-heads",headingTag:"h1"}}),h=new dl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/setfit_doc/en/classification_heads.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/setfit_doc/en/pytorch/classification_heads.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/setfit_doc/en/tensorflow/classification_heads.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/setfit_doc/en/classification_heads.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/setfit_doc/en/pytorch/classification_heads.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/setfit_doc/en/tensorflow/classification_heads.ipynb"}]}}),w=new O({props:{title:"Logistic Regression classification head",local:"logistic-regression-classification-head",headingTag:"h2"}}),b=new K({props:{code:"ZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMFNldEZpdE1vZGVsJTBBJTBBbW9kZWwlMjAlM0QlMjBTZXRGaXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyQkFBSSUyRmJnZS1zbWFsbC1lbi12MS41JTIyKSUwQW1vZGVsLm1vZGVsX2hlYWQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> SetFitModel

<span class="hljs-meta">&gt;&gt;&gt; </span>model = SetFitModel.from_pretrained(<span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.model_head
LogisticRegression()`,wrap:!1}}),Z=new K({props:{code:"ZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMFNldEZpdE1vZGVsJTBBJTBBbW9kZWwlMjAlM0QlMjBTZXRGaXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyQkFBSSUyRmJnZS1zbWFsbC1lbi12MS41JTIyJTJDJTIwaGVhZF9wYXJhbXMlM0QlN0IlMjJzb2x2ZXIlMjIlM0ElMjAlMjJsaWJsaW5lYXIlMjIlMkMlMjAlMjJtYXhfaXRlciUyMiUzQSUyMDMwMCU3RCklMEFtb2RlbC5tb2RlbF9oZWFk",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> SetFitModel

<span class="hljs-meta">&gt;&gt;&gt; </span>model = SetFitModel.from_pretrained(<span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>, head_params={<span class="hljs-string">&quot;solver&quot;</span>: <span class="hljs-string">&quot;liblinear&quot;</span>, <span class="hljs-string">&quot;max_iter&quot;</span>: <span class="hljs-number">300</span>})
<span class="hljs-meta">&gt;&gt;&gt; </span>model.model_head
LogisticRegression(max_iter=<span class="hljs-number">300</span>, solver=<span class="hljs-string">&#x27;liblinear&#x27;</span>)`,wrap:!1}}),_=new O({props:{title:"Differentiable classification head",local:"differentiable-classification-head",headingTag:"h2"}}),C=new K({props:{code:"ZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMFNldEZpdE1vZGVsJTBBJTBBbW9kZWwlMjAlM0QlMjBTZXRGaXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyQkFBSSUyRmJnZS1zbWFsbC1lbi12MS41JTIyJTJDJTIwdXNlX2RpZmZlcmVudGlhYmxlX2hlYWQlM0RUcnVlKSUwQW1vZGVsLm1vZGVsX2hlYWQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> SetFitModel

<span class="hljs-meta">&gt;&gt;&gt; </span>model = SetFitModel.from_pretrained(<span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>, use_differentiable_head=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.model_head
SetFitHead({<span class="hljs-string">&#x27;in_features&#x27;</span>: <span class="hljs-number">384</span>, <span class="hljs-string">&#x27;out_features&#x27;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&#x27;temperature&#x27;</span>: <span class="hljs-number">1.0</span>, <span class="hljs-string">&#x27;bias&#x27;</span>: <span class="hljs-literal">True</span>, <span class="hljs-string">&#x27;device&#x27;</span>: <span class="hljs-string">&#x27;cuda&#x27;</span>})`,wrap:!1}}),F=new K({props:{code:"ZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMFNldEZpdE1vZGVsJTBBJTBBbW9kZWwlMjAlM0QlMjBTZXRGaXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyQkFBSSUyRmJnZS1zbWFsbC1lbi12MS41JTIyJTJDJTIwdXNlX2RpZmZlcmVudGlhYmxlX2hlYWQlM0RUcnVlJTJDJTIwaGVhZF9wYXJhbXMlM0QlN0IlMjJvdXRfZmVhdHVyZXMlMjIlM0ElMjA1JTdEKSUwQW1vZGVsLm1vZGVsX2hlYWQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> SetFitModel

<span class="hljs-meta">&gt;&gt;&gt; </span>model = SetFitModel.from_pretrained(<span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>, use_differentiable_head=<span class="hljs-literal">True</span>, head_params={<span class="hljs-string">&quot;out_features&quot;</span>: <span class="hljs-number">5</span>})
<span class="hljs-meta">&gt;&gt;&gt; </span>model.model_head
SetFitHead({<span class="hljs-string">&#x27;in_features&#x27;</span>: <span class="hljs-number">384</span>, <span class="hljs-string">&#x27;out_features&#x27;</span>: <span class="hljs-number">5</span>, <span class="hljs-string">&#x27;temperature&#x27;</span>: <span class="hljs-number">1.0</span>, <span class="hljs-string">&#x27;bias&#x27;</span>: <span class="hljs-literal">True</span>, <span class="hljs-string">&#x27;device&#x27;</span>: <span class="hljs-string">&#x27;cuda&#x27;</span>})`,wrap:!1}}),j=new rl({props:{warning:!0,$$slots:{default:[cl]},$$scope:{ctx:se}}}),G=new O({props:{title:"Training with a differentiable classification head",local:"training-with-a-differentiable-classification-head",headingTag:"h3"}}),N=new K({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> SetFitModel, Trainer, TrainingArguments, sample_dataset
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># Initializing a new SetFit model</span>
model = SetFitModel.from_pretrained(<span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>, use_differentiable_head=<span class="hljs-literal">True</span>, head_params={<span class="hljs-string">&quot;out_features&quot;</span>: <span class="hljs-number">2</span>})

<span class="hljs-comment"># Preparing the dataset</span>
dataset = load_dataset(<span class="hljs-string">&quot;SetFit/sst2&quot;</span>)
train_dataset = sample_dataset(dataset[<span class="hljs-string">&quot;train&quot;</span>], label_column=<span class="hljs-string">&quot;label&quot;</span>, num_samples=<span class="hljs-number">32</span>)
test_dataset = dataset[<span class="hljs-string">&quot;test&quot;</span>]

<span class="hljs-comment"># Preparing the training arguments</span>
args = TrainingArguments(
    batch_size=(<span class="hljs-number">32</span>, <span class="hljs-number">16</span>),
    num_epochs=(<span class="hljs-number">3</span>, <span class="hljs-number">8</span>),
    end_to_end=<span class="hljs-literal">True</span>,
    body_learning_rate=(<span class="hljs-number">2e-5</span>, <span class="hljs-number">5e-6</span>),
    head_learning_rate=<span class="hljs-number">2e-3</span>,
    l2_weight=<span class="hljs-number">0.01</span>,
)

<span class="hljs-comment"># Preparing the trainer</span>
trainer = Trainer(
    model=model,
    args=args,
    train_dataset=train_dataset,
)
trainer.train()
<span class="hljs-comment"># ***** Running training *****</span>
<span class="hljs-comment">#   Num examples = 66</span>
<span class="hljs-comment">#   Num epochs = 3</span>
<span class="hljs-comment">#   Total optimization steps = 198</span>
<span class="hljs-comment">#   Total train batch size = 3</span>
<span class="hljs-comment"># {&#x27;embedding_loss&#x27;: 0.2204, &#x27;learning_rate&#x27;: 1.0000000000000002e-06, &#x27;epoch&#x27;: 0.02}                                                                                 </span>
<span class="hljs-comment"># {&#x27;embedding_loss&#x27;: 0.0058, &#x27;learning_rate&#x27;: 1.662921348314607e-05, &#x27;epoch&#x27;: 0.76}                                                                                  </span>
<span class="hljs-comment"># {&#x27;embedding_loss&#x27;: 0.0026, &#x27;learning_rate&#x27;: 1.101123595505618e-05, &#x27;epoch&#x27;: 1.52}                                                                                  </span>
<span class="hljs-comment"># {&#x27;embedding_loss&#x27;: 0.0022, &#x27;learning_rate&#x27;: 5.393258426966292e-06, &#x27;epoch&#x27;: 2.27}                                                                                  </span>
<span class="hljs-comment"># {&#x27;train_runtime&#x27;: 36.6756, &#x27;train_samples_per_second&#x27;: 172.758, &#x27;train_steps_per_second&#x27;: 5.399, &#x27;epoch&#x27;: 3.0}                                                     </span>
<span class="hljs-comment"># 100%|███████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████| 198/198 [00:30&lt;00:00,  6.45it/s] </span>
<span class="hljs-comment"># The \`max_length\` is \`None\`. Using the maximum acceptable length according to the current model body: 512.</span>
<span class="hljs-comment"># Epoch: 100%|████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████| 8/8 [00:07&lt;00:00,  1.03it/s]</span>

<span class="hljs-comment"># Evaluating</span>
metrics = trainer.evaluate(test_dataset)
<span class="hljs-built_in">print</span>(metrics)
<span class="hljs-comment"># =&gt; {&#x27;accuracy&#x27;: 0.8632619439868204}</span>

<span class="hljs-comment"># Performing inference</span>
preds = model.predict([
    <span class="hljs-string">&quot;It&#x27;s a charming and often affecting journey.&quot;</span>,
    <span class="hljs-string">&quot;It&#x27;s slow -- very, very slow.&quot;</span>,
    <span class="hljs-string">&quot;A sometimes tedious film.&quot;</span>,
])
<span class="hljs-built_in">print</span>(preds)
<span class="hljs-comment"># =&gt; tensor([1, 0, 0], device=&#x27;cuda:0&#x27;)</span>`,wrap:!1}}),$=new O({props:{title:"Custom classification head",local:"custom-classification-head",headingTag:"h2"}}),S=new O({props:{title:"Custom differentiable head",local:"custom-differentiable-head",headingTag:"h3"}}),z=new O({props:{title:"Custom non-differentiable head",local:"custom-non-differentiable-head",headingTag:"h3"}}),L=new K({props:{code:"ZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMFNldEZpdE1vZGVsJTBBZnJvbSUyMHNrbGVhcm4uc3ZtJTIwaW1wb3J0JTIwTGluZWFyU1ZDJTBBZnJvbSUyMHNlbnRlbmNlX3RyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlbnRlbmNlVHJhbnNmb3JtZXIlMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwbmV3JTIwU2V0Rml0JTIwbW9kZWwlMEFtb2RlbF9ib2R5JTIwJTNEJTIwU2VudGVuY2VUcmFuc2Zvcm1lciglMjJCQUFJJTJGYmdlLXNtYWxsLWVuLXYxLjUlMjIpJTBBbW9kZWxfaGVhZCUyMCUzRCUyMExpbmVhclNWQygpJTBBbW9kZWwlMjAlM0QlMjBTZXRGaXRNb2RlbChtb2RlbF9ib2R5JTJDJTIwbW9kZWxfaGVhZCk=",highlighted:`<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> SetFitModel
<span class="hljs-keyword">from</span> sklearn.svm <span class="hljs-keyword">import</span> LinearSVC
<span class="hljs-keyword">from</span> sentence_transformers <span class="hljs-keyword">import</span> SentenceTransformer

<span class="hljs-comment"># Initializing a new SetFit model</span>
model_body = SentenceTransformer(<span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>)
model_head = LinearSVC()
model = SetFitModel(model_body, model_head)`,wrap:!1}}),P=new K({props:{code:"ZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMFRyYWluZXIlMkMlMjBUcmFpbmluZ0FyZ3VtZW50cyUyQyUyMHNhbXBsZV9kYXRhc2V0JTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBJTIzJTIwUHJlcGFyaW5nJTIwdGhlJTIwZGF0YXNldCUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyU2V0Rml0JTJGc3N0MiUyMiklMEF0cmFpbl9kYXRhc2V0JTIwJTNEJTIwc2FtcGxlX2RhdGFzZXQoZGF0YXNldCU1QiUyMnRyYWluJTIyJTVEJTJDJTIwbGFiZWxfY29sdW1uJTNEJTIybGFiZWwlMjIlMkMlMjBudW1fc2FtcGxlcyUzRDMyKSUwQXRlc3RfZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTBBJTBBJTIzJTIwUHJlcGFyaW5nJTIwdGhlJTIwdHJhaW5pbmclMjBhcmd1bWVudHMlMEFhcmdzJTIwJTNEJTIwVHJhaW5pbmdBcmd1bWVudHMoJTBBJTIwJTIwJTIwJTIwYmF0Y2hfc2l6ZSUzRDMyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2Vwb2NocyUzRDMlMkMlMEEpJTBBJTBBJTIzJTIwUHJlcGFyaW5nJTIwdGhlJTIwdHJhaW5lciUwQXRyYWluZXIlMjAlM0QlMjBUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEYXJncyUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0R0cmFpbl9kYXRhc2V0JTJDJTBBKSUwQXRyYWluZXIudHJhaW4oKSUwQSUwQSUyMyUyMEV2YWx1YXRpbmclMEFtZXRyaWNzJTIwJTNEJTIwdHJhaW5lci5ldmFsdWF0ZSh0ZXN0X2RhdGFzZXQpJTBBcHJpbnQobWV0cmljcyklMEElMjMlMjAlM0QlM0UlMjAlN0InYWNjdXJhY3knJTNBJTIwMC44NjM4MTEwOTI4MDYxNTA0JTdEJTBBJTBBJTIzJTIwUGVyZm9ybWluZyUyMGluZmVyZW5jZSUwQXByZWRzJTIwJTNEJTIwbW9kZWwucHJlZGljdCglNUIlMEElMjAlMjAlMjAlMjAlMjJJdCdzJTIwYSUyMGNoYXJtaW5nJTIwYW5kJTIwb2Z0ZW4lMjBhZmZlY3RpbmclMjBqb3VybmV5LiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMkl0J3MlMjBzbG93JTIwLS0lMjB2ZXJ5JTJDJTIwdmVyeSUyMHNsb3cuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyQSUyMHNvbWV0aW1lcyUyMHRlZGlvdXMlMjBmaWxtLiUyMiUyQyUwQSU1RCklMEFwcmludChwcmVkcyklMEElMjMlMjAlM0QlM0UlMjB0ZW5zb3IoJTVCMSUyQyUyMDAlMkMlMjAwJTVEJTJDJTIwZHR5cGUlM0R0b3JjaC5pbnQzMik=",highlighted:`<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> Trainer, TrainingArguments, sample_dataset
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># Preparing the dataset</span>
dataset = load_dataset(<span class="hljs-string">&quot;SetFit/sst2&quot;</span>)
train_dataset = sample_dataset(dataset[<span class="hljs-string">&quot;train&quot;</span>], label_column=<span class="hljs-string">&quot;label&quot;</span>, num_samples=<span class="hljs-number">32</span>)
test_dataset = dataset[<span class="hljs-string">&quot;test&quot;</span>]

<span class="hljs-comment"># Preparing the training arguments</span>
args = TrainingArguments(
    batch_size=<span class="hljs-number">32</span>,
    num_epochs=<span class="hljs-number">3</span>,
)

<span class="hljs-comment"># Preparing the trainer</span>
trainer = Trainer(
    model=model,
    args=args,
    train_dataset=train_dataset,
)
trainer.train()

<span class="hljs-comment"># Evaluating</span>
metrics = trainer.evaluate(test_dataset)
<span class="hljs-built_in">print</span>(metrics)
<span class="hljs-comment"># =&gt; {&#x27;accuracy&#x27;: 0.8638110928061504}</span>

<span class="hljs-comment"># Performing inference</span>
preds = model.predict([
    <span class="hljs-string">&quot;It&#x27;s a charming and often affecting journey.&quot;</span>,
    <span class="hljs-string">&quot;It&#x27;s slow -- very, very slow.&quot;</span>,
    <span class="hljs-string">&quot;A sometimes tedious film.&quot;</span>,
])
<span class="hljs-built_in">print</span>(preds)
<span class="hljs-comment"># =&gt; tensor([1, 0, 0], dtype=torch.int32)</span>`,wrap:!1}}),{c(){o=J("meta"),m=a(),p=J("p"),ee=a(),M(g.$$.fragment),te=a(),M(h.$$.fragment),ae=a(),u=J("p"),u.innerHTML=Ne,ne=a(),A=J("p"),A.textContent=$e,Je=a(),f=J("ul"),f.innerHTML=ve,ie=a(),M(w.$$.fragment),Te=a(),k=J("p"),k.innerHTML=Se,oe=a(),M(b.$$.fragment),Me=a(),I=J("p"),I.innerHTML=Ee,Ue=a(),M(Z.$$.fragment),re=a(),M(_.$$.fragment),de=a(),B=J("p"),B.innerHTML=Qe,ce=a(),M(C.$$.fragment),ye=a(),W=J("p"),W.innerHTML=ze,pe=a(),M(F.$$.fragment),je=a(),M(j.$$.fragment),me=a(),M(G.$$.fragment),ge=a(),x=J("p"),x.innerHTML=Ve,he=a(),R=J("ul"),R.innerHTML=Ye,ue=a(),X=J("p"),X.textContent=He,Ae=a(),M(N.$$.fragment),fe=a(),M($.$$.fragment),we=a(),v=J("p"),v.innerHTML=De,ke=a(),M(S.$$.fragment),be=a(),E=J("p"),E.textContent=Le,Ie=a(),Q=J("ul"),Q.innerHTML=qe,Ze=a(),M(z.$$.fragment),_e=a(),V=J("p"),V.textContent=Pe,Be=a(),Y=J("ul"),Y.innerHTML=Ke,Ce=a(),H=J("p"),H.innerHTML=Oe,We=a(),D=J("p"),D.innerHTML=el,Fe=a(),M(L.$$.fragment),Ge=a(),q=J("p"),q.textContent=ll,xe=a(),M(P.$$.fragment),Re=a(),le=J("p"),this.h()},l(e){const l=Ml("svelte-u9bgzb",document.head);o=i(l,"META",{name:!0,content:!0}),l.forEach(s),m=n(e),p=i(e,"P",{}),tl(p).forEach(s),ee=n(e),U(g.$$.fragment,e),te=n(e),U(h.$$.fragment,e),ae=n(e),u=i(e,"P",{"data-svelte-h":!0}),T(u)!=="svelte-1pwcu2g"&&(u.innerHTML=Ne),ne=n(e),A=i(e,"P",{"data-svelte-h":!0}),T(A)!=="svelte-vfprc8"&&(A.textContent=$e),Je=n(e),f=i(e,"UL",{"data-svelte-h":!0}),T(f)!=="svelte-1w84dii"&&(f.innerHTML=ve),ie=n(e),U(w.$$.fragment,e),Te=n(e),k=i(e,"P",{"data-svelte-h":!0}),T(k)!=="svelte-o8r9r0"&&(k.innerHTML=Se),oe=n(e),U(b.$$.fragment,e),Me=n(e),I=i(e,"P",{"data-svelte-h":!0}),T(I)!=="svelte-as5qif"&&(I.innerHTML=Ee),Ue=n(e),U(Z.$$.fragment,e),re=n(e),U(_.$$.fragment,e),de=n(e),B=i(e,"P",{"data-svelte-h":!0}),T(B)!=="svelte-1to9yzj"&&(B.innerHTML=Qe),ce=n(e),U(C.$$.fragment,e),ye=n(e),W=i(e,"P",{"data-svelte-h":!0}),T(W)!=="svelte-15hbde"&&(W.innerHTML=ze),pe=n(e),U(F.$$.fragment,e),je=n(e),U(j.$$.fragment,e),me=n(e),U(G.$$.fragment,e),ge=n(e),x=i(e,"P",{"data-svelte-h":!0}),T(x)!=="svelte-1dvieya"&&(x.innerHTML=Ve),he=n(e),R=i(e,"UL",{"data-svelte-h":!0}),T(R)!=="svelte-8ozmeh"&&(R.innerHTML=Ye),ue=n(e),X=i(e,"P",{"data-svelte-h":!0}),T(X)!=="svelte-1ai1itu"&&(X.textContent=He),Ae=n(e),U(N.$$.fragment,e),fe=n(e),U($.$$.fragment,e),we=n(e),v=i(e,"P",{"data-svelte-h":!0}),T(v)!=="svelte-1jqe8yt"&&(v.innerHTML=De),ke=n(e),U(S.$$.fragment,e),be=n(e),E=i(e,"P",{"data-svelte-h":!0}),T(E)!=="svelte-1f21kd5"&&(E.textContent=Le),Ie=n(e),Q=i(e,"UL",{"data-svelte-h":!0}),T(Q)!=="svelte-pbshp9"&&(Q.innerHTML=qe),Ze=n(e),U(z.$$.fragment,e),_e=n(e),V=i(e,"P",{"data-svelte-h":!0}),T(V)!=="svelte-10vhtjr"&&(V.textContent=Pe),Be=n(e),Y=i(e,"UL",{"data-svelte-h":!0}),T(Y)!=="svelte-b6pgek"&&(Y.innerHTML=Ke),Ce=n(e),H=i(e,"P",{"data-svelte-h":!0}),T(H)!=="svelte-ll7qy4"&&(H.innerHTML=Oe),We=n(e),D=i(e,"P",{"data-svelte-h":!0}),T(D)!=="svelte-t902ae"&&(D.innerHTML=el),Fe=n(e),U(L.$$.fragment,e),Ge=n(e),q=i(e,"P",{"data-svelte-h":!0}),T(q)!=="svelte-1eatjxu"&&(q.textContent=ll),xe=n(e),U(P.$$.fragment,e),Re=n(e),le=i(e,"P",{}),tl(le).forEach(s),this.h()},h(){al(o,"name","hf:doc:metadata"),al(o,"content",pl)},m(e,l){Ul(document.head,o),t(e,m,l),t(e,p,l),t(e,ee,l),r(g,e,l),t(e,te,l),r(h,e,l),t(e,ae,l),t(e,u,l),t(e,ne,l),t(e,A,l),t(e,Je,l),t(e,f,l),t(e,ie,l),r(w,e,l),t(e,Te,l),t(e,k,l),t(e,oe,l),r(b,e,l),t(e,Me,l),t(e,I,l),t(e,Ue,l),r(Z,e,l),t(e,re,l),r(_,e,l),t(e,de,l),t(e,B,l),t(e,ce,l),r(C,e,l),t(e,ye,l),t(e,W,l),t(e,pe,l),r(F,e,l),t(e,je,l),r(j,e,l),t(e,me,l),r(G,e,l),t(e,ge,l),t(e,x,l),t(e,he,l),t(e,R,l),t(e,ue,l),t(e,X,l),t(e,Ae,l),r(N,e,l),t(e,fe,l),r($,e,l),t(e,we,l),t(e,v,l),t(e,ke,l),r(S,e,l),t(e,be,l),t(e,E,l),t(e,Ie,l),t(e,Q,l),t(e,Ze,l),r(z,e,l),t(e,_e,l),t(e,V,l),t(e,Be,l),t(e,Y,l),t(e,Ce,l),t(e,H,l),t(e,We,l),t(e,D,l),t(e,Fe,l),r(L,e,l),t(e,Ge,l),t(e,q,l),t(e,xe,l),r(P,e,l),t(e,Re,l),t(e,le,l),Xe=!0},p(e,[l]){const sl={};l&2&&(sl.$$scope={dirty:l,ctx:e}),j.$set(sl)},i(e){Xe||(d(g.$$.fragment,e),d(h.$$.fragment,e),d(w.$$.fragment,e),d(b.$$.fragment,e),d(Z.$$.fragment,e),d(_.$$.fragment,e),d(C.$$.fragment,e),d(F.$$.fragment,e),d(j.$$.fragment,e),d(G.$$.fragment,e),d(N.$$.fragment,e),d($.$$.fragment,e),d(S.$$.fragment,e),d(z.$$.fragment,e),d(L.$$.fragment,e),d(P.$$.fragment,e),Xe=!0)},o(e){c(g.$$.fragment,e),c(h.$$.fragment,e),c(w.$$.fragment,e),c(b.$$.fragment,e),c(Z.$$.fragment,e),c(_.$$.fragment,e),c(C.$$.fragment,e),c(F.$$.fragment,e),c(j.$$.fragment,e),c(G.$$.fragment,e),c(N.$$.fragment,e),c($.$$.fragment,e),c(S.$$.fragment,e),c(z.$$.fragment,e),c(L.$$.fragment,e),c(P.$$.fragment,e),Xe=!1},d(e){e&&(s(m),s(p),s(ee),s(te),s(ae),s(u),s(ne),s(A),s(Je),s(f),s(ie),s(Te),s(k),s(oe),s(Me),s(I),s(Ue),s(re),s(de),s(B),s(ce),s(ye),s(W),s(pe),s(je),s(me),s(ge),s(x),s(he),s(R),s(ue),s(X),s(Ae),s(fe),s(we),s(v),s(ke),s(be),s(E),s(Ie),s(Q),s(Ze),s(_e),s(V),s(Be),s(Y),s(Ce),s(H),s(We),s(D),s(Fe),s(Ge),s(q),s(xe),s(Re),s(le)),s(o),y(g,e),y(h,e),y(w,e),y(b,e),y(Z,e),y(_,e),y(C,e),y(F,e),y(j,e),y(G,e),y(N,e),y($,e),y(S,e),y(z,e),y(L,e),y(P,e)}}}const pl='{"title":"Classification heads","local":"classification-heads","sections":[{"title":"Logistic Regression classification head","local":"logistic-regression-classification-head","sections":[],"depth":2},{"title":"Differentiable classification head","local":"differentiable-classification-head","sections":[{"title":"Training with a differentiable classification head","local":"training-with-a-differentiable-classification-head","sections":[],"depth":3}],"depth":2},{"title":"Custom classification head","local":"custom-classification-head","sections":[{"title":"Custom differentiable head","local":"custom-differentiable-head","sections":[],"depth":3},{"title":"Custom non-differentiable head","local":"custom-non-differentiable-head","sections":[],"depth":3}],"depth":2}],"depth":1}';function jl(se){return Jl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class wl extends Tl{constructor(o){super(),ol(this,o,jl,yl,nl,{})}}export{wl as component};
