import{s as Ts,f as xs,o as $s,n as He}from"../chunks/scheduler.9bc65507.js";import{S as Is,i as js,g as l,s as n,r as g,A as zs,h as d,f as t,c as r,j as w,u as h,x as k,k as v,y as o,a as c,v as f,d as u,t as _,w as b}from"../chunks/index.707bf1b6.js";import{T as Go}from"../chunks/Tip.c2ecdbf4.js";import{D as x}from"../chunks/Docstring.17db21ae.js";import{C as oo}from"../chunks/CodeBlock.54a9f38d.js";import{E as to}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{P as Us}from"../chunks/PipelineTag.44585822.js";import{H as P}from"../chunks/Heading.342b1fa6.js";function Ns(z){let a,y=`This is a recently introduced model so the API hasn’t been tested extensively. There may be some bugs or slight
breaking changes to fix it in the future. If you see something strange, file a <a href="https://github.com/huggingface/transformers/issues/new?assignees=&amp;labels=&amp;template=bug-report.md&amp;title" rel="nofollow">Github Issue</a>.`;return{c(){a=l("p"),a.innerHTML=y},l(m){a=d(m,"P",{"data-svelte-h":!0}),k(a)!=="svelte-j665pk"&&(a.innerHTML=y)},m(m,p){c(m,a,p)},p:He,d(m){m&&t(a)}}}function Ls(z){let a,y="Examples:",m,p,M;return p=new oo({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1hc2tGb3JtZXJDb25maWclMkMlMjBNYXNrRm9ybWVyTW9kZWwlMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwTWFza0Zvcm1lciUyMGZhY2Vib29rJTJGbWFza2Zvcm1lci1zd2luLWJhc2UtYWRlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBNYXNrRm9ybWVyQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwbW9kZWwlMjAod2l0aCUyMHJhbmRvbSUyMHdlaWdodHMpJTIwZnJvbSUyMHRoZSUyMGZhY2Vib29rJTJGbWFza2Zvcm1lci1zd2luLWJhc2UtYWRlJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBNYXNrRm9ybWVyTW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MaskFormerConfig, MaskFormerModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a MaskFormer facebook/maskformer-swin-base-ade configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = MaskFormerConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the facebook/maskformer-swin-base-ade style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MaskFormerModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){a=l("p"),a.textContent=y,m=n(),g(p.$$.fragment)},l(i){a=d(i,"P",{"data-svelte-h":!0}),k(a)!=="svelte-kvfsh7"&&(a.textContent=y),m=r(i),h(p.$$.fragment,i)},m(i,F){c(i,a,F),c(i,m,F),f(p,i,F),M=!0},p:He,i(i){M||(u(p.$$.fragment,i),M=!0)},o(i){_(p.$$.fragment,i),M=!1},d(i){i&&(t(a),t(m)),b(p,i)}}}function Zs(z){let a,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=l("p"),a.innerHTML=y},l(m){a=d(m,"P",{"data-svelte-h":!0}),k(a)!=="svelte-fincs2"&&(a.innerHTML=y)},m(m,p){c(m,a,p)},p:He,d(m){m&&t(a)}}}function Cs(z){let a,y="Examples:",m,p,M;return p=new oo({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyME1hc2tGb3JtZXJNb2RlbCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBJTIzJTIwbG9hZCUyME1hc2tGb3JtZXIlMjBmaW5lLXR1bmVkJTIwb24lMjBBREUyMGslMjBzZW1hbnRpYyUyMHNlZ21lbnRhdGlvbiUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtYXNrZm9ybWVyLXN3aW4tYmFzZS1hZGUlMjIpJTBBbW9kZWwlMjAlM0QlMjBNYXNrRm9ybWVyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbWFza2Zvcm1lci1zd2luLWJhc2UtYWRlJTIyKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMGZvcndhcmQlMjBwYXNzJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQSUyMyUyMHRoZSUyMGRlY29kZXIlMjBvZiUyME1hc2tGb3JtZXIlMjBvdXRwdXRzJTIwaGlkZGVuJTIwc3RhdGVzJTIwb2YlMjBzaGFwZSUyMChiYXRjaF9zaXplJTJDJTIwbnVtX3F1ZXJpZXMlMkMlMjBoaWRkZW5fc2l6ZSklMEF0cmFuc2Zvcm1lcl9kZWNvZGVyX2xhc3RfaGlkZGVuX3N0YXRlJTIwJTNEJTIwb3V0cHV0cy50cmFuc2Zvcm1lcl9kZWNvZGVyX2xhc3RfaGlkZGVuX3N0YXRlJTBBbGlzdCh0cmFuc2Zvcm1lcl9kZWNvZGVyX2xhc3RfaGlkZGVuX3N0YXRlLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, MaskFormerModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load MaskFormer fine-tuned on ADE20k semantic segmentation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/maskformer-swin-base-ade&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MaskFormerModel.from_pretrained(<span class="hljs-string">&quot;facebook/maskformer-swin-base-ade&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># the decoder of MaskFormer outputs hidden states of shape (batch_size, num_queries, hidden_size)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>transformer_decoder_last_hidden_state = outputs.transformer_decoder_last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(transformer_decoder_last_hidden_state.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">100</span>, <span class="hljs-number">256</span>]`,wrap:!1}}),{c(){a=l("p"),a.textContent=y,m=n(),g(p.$$.fragment)},l(i){a=d(i,"P",{"data-svelte-h":!0}),k(a)!=="svelte-kvfsh7"&&(a.textContent=y),m=r(i),h(p.$$.fragment,i)},m(i,F){c(i,a,F),c(i,m,F),f(p,i,F),M=!0},p:He,i(i){M||(u(p.$$.fragment,i),M=!0)},o(i){_(p.$$.fragment,i),M=!1},d(i){i&&(t(a),t(m)),b(p,i)}}}function Js(z){let a,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=l("p"),a.innerHTML=y},l(m){a=d(m,"P",{"data-svelte-h":!0}),k(a)!=="svelte-fincs2"&&(a.innerHTML=y)},m(m,p){c(m,a,p)},p:He,d(m){m&&t(a)}}}function Ws(z){let a,y="Semantic segmentation example:",m,p,M;return p=new oo({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, MaskFormerForInstanceSegmentation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load MaskFormer fine-tuned on ADE20k semantic segmentation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/maskformer-swin-base-ade&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MaskFormerForInstanceSegmentation.from_pretrained(<span class="hljs-string">&quot;facebook/maskformer-swin-base-ade&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/fixtures_ade20k/resolve/main/ADE_val_00000001.jpg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts class_queries_logits of shape \`(batch_size, num_queries)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># and masks_queries_logits of shape \`(batch_size, num_queries, height, width)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>class_queries_logits = outputs.class_queries_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>masks_queries_logits = outputs.masks_queries_logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># you can pass them to image_processor for postprocessing</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_semantic_map = image_processor.post_process_semantic_segmentation(
<span class="hljs-meta">... </span>    outputs, target_sizes=[image.size[::-<span class="hljs-number">1</span>]]
<span class="hljs-meta">... </span>)[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># we refer to the demo notebooks for visualization (see &quot;Resources&quot; section in the MaskFormer docs)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(predicted_semantic_map.shape)
[<span class="hljs-number">512</span>, <span class="hljs-number">683</span>]`,wrap:!1}}),{c(){a=l("p"),a.textContent=y,m=n(),g(p.$$.fragment)},l(i){a=d(i,"P",{"data-svelte-h":!0}),k(a)!=="svelte-ec2k7m"&&(a.textContent=y),m=r(i),h(p.$$.fragment,i)},m(i,F){c(i,a,F),c(i,m,F),f(p,i,F),M=!0},p:He,i(i){M||(u(p.$$.fragment,i),M=!0)},o(i){_(p.$$.fragment,i),M=!1},d(i){i&&(t(a),t(m)),b(p,i)}}}function Rs(z){let a,y="Panoptic segmentation example:",m,p,M;return p=new oo({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyME1hc2tGb3JtZXJGb3JJbnN0YW5jZVNlZ21lbnRhdGlvbiUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBJTIzJTIwbG9hZCUyME1hc2tGb3JtZXIlMjBmaW5lLXR1bmVkJTIwb24lMjBDT0NPJTIwcGFub3B0aWMlMjBzZWdtZW50YXRpb24lMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbWFza2Zvcm1lci1zd2luLWJhc2UtY29jbyUyMiklMEFtb2RlbCUyMCUzRCUyME1hc2tGb3JtZXJGb3JJbnN0YW5jZVNlZ21lbnRhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtYXNrZm9ybWVyLXN3aW4tYmFzZS1jb2NvJTIyKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMjMlMjBtb2RlbCUyMHByZWRpY3RzJTIwY2xhc3NfcXVlcmllc19sb2dpdHMlMjBvZiUyMHNoYXBlJTIwJTYwKGJhdGNoX3NpemUlMkMlMjBudW1fcXVlcmllcyklNjAlMEElMjMlMjBhbmQlMjBtYXNrc19xdWVyaWVzX2xvZ2l0cyUyMG9mJTIwc2hhcGUlMjAlNjAoYmF0Y2hfc2l6ZSUyQyUyMG51bV9xdWVyaWVzJTJDJTIwaGVpZ2h0JTJDJTIwd2lkdGgpJTYwJTBBY2xhc3NfcXVlcmllc19sb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmNsYXNzX3F1ZXJpZXNfbG9naXRzJTBBbWFza3NfcXVlcmllc19sb2dpdHMlMjAlM0QlMjBvdXRwdXRzLm1hc2tzX3F1ZXJpZXNfbG9naXRzJTBBJTBBJTIzJTIweW91JTIwY2FuJTIwcGFzcyUyMHRoZW0lMjB0byUyMGltYWdlX3Byb2Nlc3NvciUyMGZvciUyMHBvc3Rwcm9jZXNzaW5nJTBBcmVzdWx0JTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yLnBvc3RfcHJvY2Vzc19wYW5vcHRpY19zZWdtZW50YXRpb24ob3V0cHV0cyUyQyUyMHRhcmdldF9zaXplcyUzRCU1QmltYWdlLnNpemUlNUIlM0ElM0EtMSU1RCU1RCklNUIwJTVEJTBBJTBBJTIzJTIwd2UlMjByZWZlciUyMHRvJTIwdGhlJTIwZGVtbyUyMG5vdGVib29rcyUyMGZvciUyMHZpc3VhbGl6YXRpb24lMjAoc2VlJTIwJTIyUmVzb3VyY2VzJTIyJTIwc2VjdGlvbiUyMGluJTIwdGhlJTIwTWFza0Zvcm1lciUyMGRvY3MpJTBBcHJlZGljdGVkX3Bhbm9wdGljX21hcCUyMCUzRCUyMHJlc3VsdCU1QiUyMnNlZ21lbnRhdGlvbiUyMiU1RCUwQWxpc3QocHJlZGljdGVkX3Bhbm9wdGljX21hcC5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, MaskFormerForInstanceSegmentation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load MaskFormer fine-tuned on COCO panoptic segmentation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/maskformer-swin-base-coco&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MaskFormerForInstanceSegmentation.from_pretrained(<span class="hljs-string">&quot;facebook/maskformer-swin-base-coco&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts class_queries_logits of shape \`(batch_size, num_queries)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># and masks_queries_logits of shape \`(batch_size, num_queries, height, width)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>class_queries_logits = outputs.class_queries_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>masks_queries_logits = outputs.masks_queries_logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># you can pass them to image_processor for postprocessing</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>result = image_processor.post_process_panoptic_segmentation(outputs, target_sizes=[image.size[::-<span class="hljs-number">1</span>]])[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># we refer to the demo notebooks for visualization (see &quot;Resources&quot; section in the MaskFormer docs)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_panoptic_map = result[<span class="hljs-string">&quot;segmentation&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(predicted_panoptic_map.shape)
[<span class="hljs-number">480</span>, <span class="hljs-number">640</span>]`,wrap:!1}}),{c(){a=l("p"),a.textContent=y,m=n(),g(p.$$.fragment)},l(i){a=d(i,"P",{"data-svelte-h":!0}),k(a)!=="svelte-1hqqxa2"&&(a.textContent=y),m=r(i),h(p.$$.fragment,i)},m(i,F){c(i,a,F),c(i,m,F),f(p,i,F),M=!0},p:He,i(i){M||(u(p.$$.fragment,i),M=!0)},o(i){_(p.$$.fragment,i),M=!1},d(i){i&&(t(a),t(m)),b(p,i)}}}function Bs(z){let a,y,m,p,M,i,F,yt,re,Ft,ae,Oo='The MaskFormer model was proposed in <a href="https://arxiv.org/abs/2107.06278" rel="nofollow">Per-Pixel Classification is Not All You Need for Semantic Segmentation</a> by Bowen Cheng, Alexander G. Schwing, Alexander Kirillov. MaskFormer addresses semantic segmentation with a mask classification paradigm instead of performing classic pixel-level classification.',vt,ie,Do="The abstract from the paper is the following:",wt,le,Ao="<em>Modern approaches typically formulate semantic segmentation as a per-pixel classification task, while instance-level segmentation is handled with an alternative mask classification. Our key insight: mask classification is sufficiently general to solve both semantic- and instance-level segmentation tasks in a unified manner using the exact same model, loss, and training procedure. Following this observation, we propose MaskFormer, a simple mask classification model which predicts a set of binary masks, each associated with a single global class label prediction. Overall, the proposed mask classification-based method simplifies the landscape of effective approaches to semantic and panoptic segmentation tasks and shows excellent empirical results. In particular, we observe that MaskFormer outperforms per-pixel classification baselines when the number of classes is large. Our mask classification-based method outperforms both current state-of-the-art semantic (55.6 mIoU on ADE20K) and panoptic segmentation (52.7 PQ on COCO) models.</em>",Tt,de,qo='The figure below illustrates the architecture of MaskFormer. Taken from the <a href="https://arxiv.org/abs/2107.06278" rel="nofollow">original paper</a>.',xt,ce,Yo,$t,me,Qo='This model was contributed by <a href="https://huggingface.co/francesco" rel="nofollow">francesco</a>. The original code can be found <a href="https://github.com/facebookresearch/MaskFormer" rel="nofollow">here</a>.',It,pe,jt,ge,Ko=`<li>MaskFormer’s Transformer decoder is identical to the decoder of <a href="detr">DETR</a>. During training, the authors of DETR did find it helpful to use auxiliary losses in the decoder, especially to help the model output the correct number of objects of each class. If you set the parameter <code>use_auxilary_loss</code> of <a href="/docs/transformers/v4.36.2/en/model_doc/maskformer#transformers.MaskFormerConfig">MaskFormerConfig</a> to <code>True</code>, then prediction feedforward neural networks and Hungarian losses are added after each decoder layer (with the FFNs sharing parameters).</li> <li>If you want to train the model in a distributed environment across multiple nodes, then one should update the
<code>get_num_masks</code> function inside in the <code>MaskFormerLoss</code> class of <code>modeling_maskformer.py</code>. When training on multiple nodes, this should be
set to the average number of target masks across all nodes, as can be seen in the original implementation <a href="https://github.com/facebookresearch/MaskFormer/blob/da3e60d85fdeedcb31476b5edd7d328826ce56cc/mask_former/modeling/criterion.py#L169" rel="nofollow">here</a>.</li> <li>One can use <a href="/docs/transformers/v4.36.2/en/model_doc/maskformer#transformers.MaskFormerImageProcessor">MaskFormerImageProcessor</a> to prepare images for the model and optional targets for the model.</li> <li>To get the final segmentation, depending on the task, you can call <a href="/docs/transformers/v4.36.2/en/model_doc/maskformer#transformers.MaskFormerFeatureExtractor.post_process_semantic_segmentation">post_process_semantic_segmentation()</a> or <a href="/docs/transformers/v4.36.2/en/model_doc/maskformer#transformers.MaskFormerFeatureExtractor.post_process_panoptic_segmentation">post_process_panoptic_segmentation()</a>. Both tasks can be solved using <a href="/docs/transformers/v4.36.2/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a> output, panoptic segmentation accepts an optional <code>label_ids_to_fuse</code> argument to fuse instances of the target object/s (e.g. sky) together.</li>`,zt,he,Ut,fe,Nt,ue,es='<li>All notebooks that illustrate inference as well as fine-tuning on custom data with MaskFormer can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/MaskFormer" rel="nofollow">here</a>.</li>',Lt,_e,Zt,E,be,so,Ge,ts='Class for outputs of <a href="/docs/transformers/v4.36.2/en/model_doc/maskformer#transformers.MaskFormerModel">MaskFormerModel</a>. This class returns all the needed hidden states to compute the logits.',Ct,J,ke,no,Oe,os='Class for outputs of <a href="/docs/transformers/v4.36.2/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a>.',ro,De,ss=`This output can be directly passed to <a href="/docs/transformers/v4.36.2/en/model_doc/maskformer#transformers.MaskFormerFeatureExtractor.post_process_semantic_segmentation">post_process_semantic_segmentation()</a> or or
<a href="/docs/transformers/v4.36.2/en/model_doc/maskformer#transformers.MaskFormerFeatureExtractor.post_process_instance_segmentation">post_process_instance_segmentation()</a> or
<a href="/docs/transformers/v4.36.2/en/model_doc/maskformer#transformers.MaskFormerFeatureExtractor.post_process_panoptic_segmentation">post_process_panoptic_segmentation()</a> depending on the task. Please, see
[\`~MaskFormerImageProcessor] for details regarding usage.`,Jt,Me,Wt,I,ye,ao,Ae,ns=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.36.2/en/model_doc/maskformer#transformers.MaskFormerModel">MaskFormerModel</a>. It is used to instantiate a
MaskFormer model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the MaskFormer
<a href="https://huggingface.co/facebook/maskformer-swin-base-ade" rel="nofollow">facebook/maskformer-swin-base-ade</a> architecture trained
on <a href="https://huggingface.co/datasets/scene_parse_150" rel="nofollow">ADE20k-150</a>.`,io,qe,rs=`Configuration objects inherit from <a href="/docs/transformers/v4.36.2/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.36.2/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,lo,Ye,as='Currently, MaskFormer only supports the <a href="swin">Swin Transformer</a> as backbone.',co,H,mo,G,Fe,po,Qe,is=`Instantiate a <a href="/docs/transformers/v4.36.2/en/model_doc/maskformer#transformers.MaskFormerConfig">MaskFormerConfig</a> (or a derived class) from a pre-trained backbone model configuration and DETR model
configuration.`,Rt,ve,Bt,T,we,go,Ke,ls=`Constructs a MaskFormer image processor. The image processor can be used to prepare image(s) and optional targets
for the model.`,ho,et,ds=`This image processor inherits from <code>BaseImageProcessor</code> which contains most of the main methods. Users should
refer to this superclass for more information regarding those methods.`,fo,tt,Te,uo,R,xe,_o,ot,cs="Pad images up to the largest image in a batch and create a corresponding <code>pixel_mask</code>.",bo,st,ms=`MaskFormer addresses semantic segmentation with a mask classification paradigm, thus input segmentation maps
will be converted to lists of binary masks and their respective labels. Let’s see an example, assuming
<code>segmentation_maps = [[2,6,7,9]]</code>, the output will contain <code>mask_labels = [[1,0,0,0],[0,1,0,0],[0,0,1,0],[0,0,0,1]]</code> (four binary masks) and <code>class_labels = [2,6,7,9]</code>, the labels for
each mask.`,ko,O,$e,Mo,nt,ps=`Converts the output of <a href="/docs/transformers/v4.36.2/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a> into semantic segmentation maps. Only supports
PyTorch.`,yo,D,Ie,Fo,rt,gs=`Converts the output of <code>MaskFormerForInstanceSegmentationOutput</code> into instance segmentation predictions. Only
supports PyTorch.`,vo,A,je,wo,at,hs=`Converts the output of <code>MaskFormerForInstanceSegmentationOutput</code> into image panoptic segmentation
predictions. Only supports PyTorch.`,Pt,ze,Et,j,Ue,To,it,Ne,xo,B,Le,$o,lt,fs="Pad images up to the largest image in a batch and create a corresponding <code>pixel_mask</code>.",Io,dt,us=`MaskFormer addresses semantic segmentation with a mask classification paradigm, thus input segmentation maps
will be converted to lists of binary masks and their respective labels. Let’s see an example, assuming
<code>segmentation_maps = [[2,6,7,9]]</code>, the output will contain <code>mask_labels = [[1,0,0,0],[0,1,0,0],[0,0,1,0],[0,0,0,1]]</code> (four binary masks) and <code>class_labels = [2,6,7,9]</code>, the labels for
each mask.`,jo,q,Ze,zo,ct,_s=`Converts the output of <a href="/docs/transformers/v4.36.2/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a> into semantic segmentation maps. Only supports
PyTorch.`,Uo,Y,Ce,No,mt,bs=`Converts the output of <code>MaskFormerForInstanceSegmentationOutput</code> into instance segmentation predictions. Only
supports PyTorch.`,Lo,Q,Je,Zo,pt,ks=`Converts the output of <code>MaskFormerForInstanceSegmentationOutput</code> into image panoptic segmentation
predictions. Only supports PyTorch.`,Vt,We,Xt,W,Re,Co,gt,Ms=`The bare MaskFormer Model outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Jo,L,Be,Wo,ht,ys='The <a href="/docs/transformers/v4.36.2/en/model_doc/maskformer#transformers.MaskFormerModel">MaskFormerModel</a> forward method, overrides the <code>__call__</code> special method.',Ro,K,Bo,ee,St,Pe,Ht,V,Ee,Po,U,Ve,Eo,ft,Fs='The <a href="/docs/transformers/v4.36.2/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a> forward method, overrides the <code>__call__</code> special method.',Vo,te,Xo,ut,vs="Examples:",So,oe,Ho,se,Gt,kt,Ot;return M=new P({props:{title:"MaskFormer",local:"maskformer",headingTag:"h1"}}),F=new Go({props:{$$slots:{default:[Ns]},$$scope:{ctx:z}}}),re=new P({props:{title:"Overview",local:"overview",headingTag:"h2"}}),pe=new P({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),he=new P({props:{title:"Resources",local:"resources",headingTag:"h2"}}),fe=new Us({props:{pipeline:"image-segmentation"}}),_e=new P({props:{title:"MaskFormer specific outputs",local:"transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput",headingTag:"h2"}}),be=new x({props:{name:"class transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput",anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput",parameters:[{name:"encoder_last_hidden_state",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pixel_decoder_last_hidden_state",val:": typing.Optional[torch.FloatTensor] = None"},{name:"transformer_decoder_last_hidden_state",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"pixel_decoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"transformer_decoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Last hidden states (final feature map) of the last stage of the encoder model (backbone).`,name:"encoder_last_hidden_state"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput.pixel_decoder_last_hidden_state",description:`<strong>pixel_decoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Last hidden states (final feature map) of the last stage of the pixel decoder model (FPN).`,name:"pixel_decoder_last_hidden_state"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput.transformer_decoder_last_hidden_state",description:`<strong>transformer_decoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Last hidden states (final feature map) of the last stage of the transformer decoder model.`,name:"transformer_decoder_last_hidden_state"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage.`,name:"encoder_hidden_states"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput.pixel_decoder_hidden_states",description:`<strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage.`,name:"pixel_decoder_hidden_states"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput.transformer_decoder_hidden_states",description:`<strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states (also called feature maps) of the
transformer decoder at the output of each stage.`,name:"transformer_decoder_hidden_states"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput.hidden_states",description:`<strong>hidden_states</strong> <code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> containing <code>encoder_hidden_states</code>, <code>pixel_decoder_hidden_states</code> and
<code>decoder_hidden_states</code>`,name:"hidden_states"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights from Detr&#x2019;s decoder after the attention softmax, used to compute the
weighted average in the self-attention heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.36.2/src/transformers/models/maskformer/modeling_maskformer.py#L147"}}),ke=new x({props:{name:"class transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput",anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"class_queries_logits",val:": FloatTensor = None"},{name:"masks_queries_logits",val:": FloatTensor = None"},{name:"auxiliary_logits",val:": FloatTensor = None"},{name:"encoder_last_hidden_state",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pixel_decoder_last_hidden_state",val:": typing.Optional[torch.FloatTensor] = None"},{name:"transformer_decoder_last_hidden_state",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"pixel_decoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"transformer_decoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput.loss",description:`<strong>loss</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
The computed loss, returned when labels are present.`,name:"loss"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput.class_queries_logits",description:`<strong>class_queries_logits</strong> (<code>torch.FloatTensor</code>) &#x2014;
A tensor of shape <code>(batch_size, num_queries, num_labels + 1)</code> representing the proposed classes for each
query. Note the <code>+ 1</code> is needed because we incorporate the null class.`,name:"class_queries_logits"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput.masks_queries_logits",description:`<strong>masks_queries_logits</strong> (<code>torch.FloatTensor</code>) &#x2014;
A tensor of shape <code>(batch_size, num_queries, height, width)</code> representing the proposed masks for each
query.`,name:"masks_queries_logits"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Last hidden states (final feature map) of the last stage of the encoder model (backbone).`,name:"encoder_last_hidden_state"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput.pixel_decoder_last_hidden_state",description:`<strong>pixel_decoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Last hidden states (final feature map) of the last stage of the pixel decoder model (FPN).`,name:"pixel_decoder_last_hidden_state"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput.transformer_decoder_last_hidden_state",description:`<strong>transformer_decoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Last hidden states (final feature map) of the last stage of the transformer decoder model.`,name:"transformer_decoder_last_hidden_state"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage.`,name:"encoder_hidden_states"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput.pixel_decoder_hidden_states",description:`<strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage.`,name:"pixel_decoder_hidden_states"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput.transformer_decoder_hidden_states",description:`<strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the transformer decoder at the output
of each stage.`,name:"transformer_decoder_hidden_states"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput.hidden_states",description:`<strong>hidden_states</strong> <code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> containing <code>encoder_hidden_states</code>, <code>pixel_decoder_hidden_states</code> and
<code>decoder_hidden_states</code>.`,name:"hidden_states"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights from Detr&#x2019;s decoder after the attention softmax, used to compute the
weighted average in the self-attention heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.36.2/src/transformers/models/maskformer/modeling_maskformer.py#L190"}}),Me=new P({props:{title:"MaskFormerConfig",local:"transformers.MaskFormerConfig",headingTag:"h2"}}),ye=new x({props:{name:"class transformers.MaskFormerConfig",anchor:"transformers.MaskFormerConfig",parameters:[{name:"fpn_feature_size",val:": int = 256"},{name:"mask_feature_size",val:": int = 256"},{name:"no_object_weight",val:": float = 0.1"},{name:"use_auxiliary_loss",val:": bool = False"},{name:"backbone_config",val:": typing.Optional[typing.Dict] = None"},{name:"decoder_config",val:": typing.Optional[typing.Dict] = None"},{name:"init_std",val:": float = 0.02"},{name:"init_xavier_std",val:": float = 1.0"},{name:"dice_weight",val:": float = 1.0"},{name:"cross_entropy_weight",val:": float = 1.0"},{name:"mask_weight",val:": float = 20.0"},{name:"output_auxiliary_logits",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MaskFormerConfig.mask_feature_size",description:`<strong>mask_feature_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The masks&#x2019; features size, this value will also be used to specify the Feature Pyramid Network features&#x2019;
size.`,name:"mask_feature_size"},{anchor:"transformers.MaskFormerConfig.no_object_weight",description:`<strong>no_object_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Weight to apply to the null (no object) class.`,name:"no_object_weight"},{anchor:"transformers.MaskFormerConfig.use_auxiliary_loss(bool,",description:`<strong>use_auxiliary_loss(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code> <code>MaskFormerForInstanceSegmentationOutput</code> will contain the auxiliary losses computed using the
logits from each decoder&#x2019;s stage.`,name:"use_auxiliary_loss(bool,"},{anchor:"transformers.MaskFormerConfig.backbone_config",description:`<strong>backbone_config</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
The configuration passed to the backbone, if unset, the configuration corresponding to
<code>swin-base-patch4-window12-384</code> will be used.`,name:"backbone_config"},{anchor:"transformers.MaskFormerConfig.decoder_config",description:`<strong>decoder_config</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
The configuration passed to the transformer decoder model, if unset the base config for <code>detr-resnet-50</code>
will be used.`,name:"decoder_config"},{anchor:"transformers.MaskFormerConfig.init_std",description:`<strong>init_std</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"init_std"},{anchor:"transformers.MaskFormerConfig.init_xavier_std",description:`<strong>init_xavier_std</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
The scaling factor used for the Xavier initialization gain in the HM Attention map module.`,name:"init_xavier_std"},{anchor:"transformers.MaskFormerConfig.dice_weight",description:`<strong>dice_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The weight for the dice loss.`,name:"dice_weight"},{anchor:"transformers.MaskFormerConfig.cross_entropy_weight",description:`<strong>cross_entropy_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The weight for the cross entropy loss.`,name:"cross_entropy_weight"},{anchor:"transformers.MaskFormerConfig.mask_weight",description:`<strong>mask_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 20.0) &#x2014;
The weight for the mask loss.`,name:"mask_weight"},{anchor:"transformers.MaskFormerConfig.output_auxiliary_logits",description:`<strong>output_auxiliary_logits</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Should the model output its <code>auxiliary_logits</code> or not.`,name:"output_auxiliary_logits"}],source:"https://github.com/huggingface/transformers/blob/v4.36.2/src/transformers/models/maskformer/configuration_maskformer.py#L35",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValueError</code> —
Raised if the backbone model type selected is not in <code>["swin"]</code> or the decoder model type selected is not
in <code>["detr"]</code></li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),H=new to({props:{anchor:"transformers.MaskFormerConfig.example",$$slots:{default:[Ls]},$$scope:{ctx:z}}}),Fe=new x({props:{name:"from_backbone_and_decoder_configs",anchor:"transformers.MaskFormerConfig.from_backbone_and_decoder_configs",parameters:[{name:"backbone_config",val:": PretrainedConfig"},{name:"decoder_config",val:": PretrainedConfig"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MaskFormerConfig.from_backbone_and_decoder_configs.backbone_config",description:`<strong>backbone_config</strong> (<a href="/docs/transformers/v4.36.2/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The backbone configuration.`,name:"backbone_config"},{anchor:"transformers.MaskFormerConfig.from_backbone_and_decoder_configs.decoder_config",description:`<strong>decoder_config</strong> (<a href="/docs/transformers/v4.36.2/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The transformer decoder configuration to use.`,name:"decoder_config"}],source:"https://github.com/huggingface/transformers/blob/v4.36.2/src/transformers/models/maskformer/configuration_maskformer.py#L182",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An instance of a configuration object</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.36.2/en/model_doc/maskformer#transformers.MaskFormerConfig"
>MaskFormerConfig</a></p>
`}}),ve=new P({props:{title:"MaskFormerImageProcessor",local:"transformers.MaskFormerImageProcessor",headingTag:"h2"}}),we=new x({props:{name:"class transformers.MaskFormerImageProcessor",anchor:"transformers.MaskFormerImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"size_divisor",val:": int = 32"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": float = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float]] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float]] = None"},{name:"ignore_index",val:": typing.Optional[int] = None"},{name:"do_reduce_labels",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MaskFormerImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the input to a certain <code>size</code>.`,name:"do_resize"},{anchor:"transformers.MaskFormerImageProcessor.size",description:`<strong>size</strong> (<code>int</code>, <em>optional</em>, defaults to 800) &#x2014;
Resize the input to the given size. Only has an effect if <code>do_resize</code> is set to <code>True</code>. If size is a
sequence like <code>(width, height)</code>, output size will be matched to this. If size is an int, smaller edge of
the image will be matched to this number. i.e, if <code>height &gt; width</code>, then image will be rescaled to <code>(size * height / width, size)</code>.`,name:"size"},{anchor:"transformers.MaskFormerImageProcessor.size_divisor",description:`<strong>size_divisor</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Some backbones need images divisible by a certain number. If not passed, it defaults to the value used in
Swin Transformer.`,name:"size_divisor"},{anchor:"transformers.MaskFormerImageProcessor.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>Resampling.BILINEAR</code>) &#x2014;
An optional resampling filter. This can be one of <code>PIL.Image.Resampling.NEAREST</code>,
<code>PIL.Image.Resampling.BOX</code>, <code>PIL.Image.Resampling.BILINEAR</code>, <code>PIL.Image.Resampling.HAMMING</code>,
<code>PIL.Image.Resampling.BICUBIC</code> or <code>PIL.Image.Resampling.LANCZOS</code>. Only has an effect if <code>do_resize</code> is set
to <code>True</code>.`,name:"resample"},{anchor:"transformers.MaskFormerImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the input to a certain <code>scale</code>.`,name:"do_rescale"},{anchor:"transformers.MaskFormerImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>1/ 255</code>) &#x2014;
Rescale the input by the given factor. Only has an effect if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.MaskFormerImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to normalize the input with mean and standard deviation.`,name:"do_normalize"},{anchor:"transformers.MaskFormerImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>int</code>, <em>optional</em>, defaults to <code>[0.485, 0.456, 0.406]</code>) &#x2014;
The sequence of means for each channel, to be used when normalizing images. Defaults to the ImageNet mean.`,name:"image_mean"},{anchor:"transformers.MaskFormerImageProcessor.image_std",description:`<strong>image_std</strong> (<code>int</code>, <em>optional</em>, defaults to <code>[0.229, 0.224, 0.225]</code>) &#x2014;
The sequence of standard deviations for each channel, to be used when normalizing images. Defaults to the
ImageNet std.`,name:"image_std"},{anchor:"transformers.MaskFormerImageProcessor.ignore_index",description:`<strong>ignore_index</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Label to be assigned to background pixels in segmentation maps. If provided, segmentation map pixels
denoted with 0 (background) will be replaced with <code>ignore_index</code>.`,name:"ignore_index"},{anchor:"transformers.MaskFormerImageProcessor.do_reduce_labels",description:`<strong>do_reduce_labels</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to decrement all label values of segmentation maps by 1. Usually used for datasets where 0
is used for background, and background itself is not included in all classes of a dataset (e.g. ADE20k).
The background label will be replaced by <code>ignore_index</code>.`,name:"do_reduce_labels"}],source:"https://github.com/huggingface/transformers/blob/v4.36.2/src/transformers/models/maskformer/image_processing_maskformer.py#L347"}}),Te=new x({props:{name:"preprocess",anchor:"transformers.MaskFormerImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]"},{name:"segmentation_maps",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')], NoneType] = None"},{name:"instance_id_to_semantic_id",val:": typing.Union[typing.Dict[int, int], NoneType] = None"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Union[typing.Dict[str, int], NoneType] = None"},{name:"size_divisor",val:": typing.Optional[int] = None"},{name:"resample",val:": Resampling = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"ignore_index",val:": typing.Optional[int] = None"},{name:"do_reduce_labels",val:": typing.Optional[bool] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension] = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.36.2/src/transformers/models/maskformer/image_processing_maskformer.py#L677"}}),xe=new x({props:{name:"encode_inputs",anchor:"transformers.MaskFormerImageProcessor.encode_inputs",parameters:[{name:"pixel_values_list",val:": typing.List[typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]]"},{name:"segmentation_maps",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]] = None"},{name:"instance_id_to_semantic_id",val:": typing.Union[typing.List[typing.Dict[int, int]], typing.Dict[int, int], NoneType] = None"},{name:"ignore_index",val:": typing.Optional[int] = None"},{name:"reduce_labels",val:": bool = False"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.MaskFormerImageProcessor.encode_inputs.pixel_values_list",description:`<strong>pixel_values_list</strong> (<code>List[ImageInput]</code>) &#x2014;
List of images (pixel values) to be padded. Each image should be a tensor of shape <code>(channels, height, width)</code>.`,name:"pixel_values_list"},{anchor:"transformers.MaskFormerImageProcessor.encode_inputs.segmentation_maps",description:`<strong>segmentation_maps</strong> (<code>ImageInput</code>, <em>optional</em>) &#x2014;
The corresponding semantic segmentation maps with the pixel-wise annotations.</p>
<p>(<code>bool</code>, <em>optional</em>, defaults to <code>True</code>):
Whether or not to pad images up to the largest image in a batch and create a pixel mask.</p>
<p>If left to the default, will return a pixel mask that is:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>`,name:"segmentation_maps"},{anchor:"transformers.MaskFormerImageProcessor.encode_inputs.instance_id_to_semantic_id",description:`<strong>instance_id_to_semantic_id</strong> (<code>List[Dict[int, int]]</code> or <code>Dict[int, int]</code>, <em>optional</em>) &#x2014;
A mapping between object instance ids and class ids. If passed, <code>segmentation_maps</code> is treated as an
instance segmentation map where each pixel represents an instance id. Can be provided as a single
dictionary with a global/dataset-level mapping or as a list of dictionaries (one per image), to map
instance ids in each image separately.`,name:"instance_id_to_semantic_id"},{anchor:"transformers.MaskFormerImageProcessor.encode_inputs.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/v4.36.2/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors instead of NumPy arrays. If set to <code>&apos;pt&apos;</code>, return PyTorch <code>torch.Tensor</code>
objects.`,name:"return_tensors"}],source:"https://github.com/huggingface/transformers/blob/v4.36.2/src/transformers/models/maskformer/image_processing_maskformer.py#L875",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.36.2/en/main_classes/image_processor#transformers.BatchFeature"
>BatchFeature</a> with the following fields:</p>
<ul>
<li><strong>pixel_values</strong> — Pixel values to be fed to a model.</li>
<li><strong>pixel_mask</strong> — Pixel mask to be fed to a model (when <code>=True</code> or if <code>pixel_mask</code> is in
<code>self.model_input_names</code>).</li>
<li><strong>mask_labels</strong> — Optional list of mask labels of shape <code>(labels, height, width)</code> to be fed to a model
(when <code>annotations</code> are provided).</li>
<li><strong>class_labels</strong> — Optional list of class labels of shape <code>(labels)</code> to be fed to a model (when
<code>annotations</code> are provided). They identify the labels of <code>mask_labels</code>, e.g. the label of
<code>mask_labels[i][j]</code> if <code>class_labels[i][j]</code>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.36.2/en/main_classes/image_processor#transformers.BatchFeature"
>BatchFeature</a></p>
`}}),$e=new x({props:{name:"post_process_semantic_segmentation",anchor:"transformers.MaskFormerImageProcessor.post_process_semantic_segmentation",parameters:[{name:"outputs",val:""},{name:"target_sizes",val:": typing.Union[typing.List[typing.Tuple[int, int]], NoneType] = None"}],parametersDescription:[{anchor:"transformers.MaskFormerImageProcessor.post_process_semantic_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/v4.36.2/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.MaskFormerImageProcessor.post_process_semantic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction. If left to None, predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/v4.36.2/src/transformers/models/maskformer/image_processing_maskformer.py#L1029",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of length <code>batch_size</code>, where each item is a semantic segmentation map of shape (height, width)
corresponding to the target_sizes entry (if <code>target_sizes</code> is specified). Each entry of each
<code>torch.Tensor</code> correspond to a semantic class id.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[torch.Tensor]</code></p>
`}}),Ie=new x({props:{name:"post_process_instance_segmentation",anchor:"transformers.MaskFormerImageProcessor.post_process_instance_segmentation",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"mask_threshold",val:": float = 0.5"},{name:"overlap_mask_area_threshold",val:": float = 0.8"},{name:"target_sizes",val:": typing.Union[typing.List[typing.Tuple[int, int]], NoneType] = None"},{name:"return_coco_annotation",val:": typing.Optional[bool] = False"},{name:"return_binary_maps",val:": typing.Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.MaskFormerImageProcessor.post_process_instance_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/v4.36.2/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.MaskFormerImageProcessor.post_process_instance_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The probability score threshold to keep predicted instance masks.`,name:"threshold"},{anchor:"transformers.MaskFormerImageProcessor.post_process_instance_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"transformers.MaskFormerImageProcessor.post_process_instance_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
The overlap mask area threshold to merge or discard small disconnected parts within each binary
instance mask.`,name:"overlap_mask_area_threshold"},{anchor:"transformers.MaskFormerImageProcessor.post_process_instance_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction. If left to None, predictions will not be resized.`,name:"target_sizes"},{anchor:"transformers.MaskFormerImageProcessor.post_process_instance_segmentation.return_coco_annotation",description:`<strong>return_coco_annotation</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If set to <code>True</code>, segmentation maps are returned in COCO run-length encoding (RLE) format.`,name:"return_coco_annotation"},{anchor:"transformers.MaskFormerImageProcessor.post_process_instance_segmentation.return_binary_maps",description:`<strong>return_binary_maps</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If set to <code>True</code>, segmentation maps are returned as a concatenated tensor of binary segmentation maps
(one per detected instance).`,name:"return_binary_maps"}],source:"https://github.com/huggingface/transformers/blob/v4.36.2/src/transformers/models/maskformer/image_processing_maskformer.py#L1079",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, one per image, each dictionary containing two keys:</p>
<ul>
<li><strong>segmentation</strong> — A tensor of shape <code>(height, width)</code> where each pixel represents a <code>segment_id</code> or
<code>List[List]</code> run-length encoding (RLE) of the segmentation map if return_coco_annotation is set to
<code>True</code>. Set to <code>None</code> if no mask if found above <code>threshold</code>.</li>
<li><strong>segments_info</strong> — A dictionary that contains additional information on each segment.<ul>
<li><strong>id</strong> — An integer representing the <code>segment_id</code>.</li>
<li><strong>label_id</strong> — An integer representing the label / semantic class id corresponding to <code>segment_id</code>.</li>
<li><strong>score</strong> — Prediction score of segment with <code>segment_id</code>.</li>
</ul></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),je=new x({props:{name:"post_process_panoptic_segmentation",anchor:"transformers.MaskFormerImageProcessor.post_process_panoptic_segmentation",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"mask_threshold",val:": float = 0.5"},{name:"overlap_mask_area_threshold",val:": float = 0.8"},{name:"label_ids_to_fuse",val:": typing.Optional[typing.Set[int]] = None"},{name:"target_sizes",val:": typing.Union[typing.List[typing.Tuple[int, int]], NoneType] = None"}],parametersDescription:[{anchor:"transformers.MaskFormerImageProcessor.post_process_panoptic_segmentation.outputs",description:`<strong>outputs</strong> (<code>MaskFormerForInstanceSegmentationOutput</code>) &#x2014;
The outputs from <a href="/docs/transformers/v4.36.2/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a>.`,name:"outputs"},{anchor:"transformers.MaskFormerImageProcessor.post_process_panoptic_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The probability score threshold to keep predicted instance masks.`,name:"threshold"},{anchor:"transformers.MaskFormerImageProcessor.post_process_panoptic_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"transformers.MaskFormerImageProcessor.post_process_panoptic_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
The overlap mask area threshold to merge or discard small disconnected parts within each binary
instance mask.`,name:"overlap_mask_area_threshold"},{anchor:"transformers.MaskFormerImageProcessor.post_process_panoptic_segmentation.label_ids_to_fuse",description:`<strong>label_ids_to_fuse</strong> (<code>Set[int]</code>, <em>optional</em>) &#x2014;
The labels in this state will have all their instances be fused together. For instance we could say
there can only be one sky in an image, but several persons, so the label ID for sky would be in that
set, but not the one for person.`,name:"label_ids_to_fuse"},{anchor:"transformers.MaskFormerImageProcessor.post_process_panoptic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction in batch. If left to None, predictions will not be
resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/v4.36.2/src/transformers/models/maskformer/image_processing_maskformer.py#L1193",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, one per image, each dictionary containing two keys:</p>
<ul>
<li><strong>segmentation</strong> — a tensor of shape <code>(height, width)</code> where each pixel represents a <code>segment_id</code>, set
to <code>None</code> if no mask if found above <code>threshold</code>. If <code>target_sizes</code> is specified, segmentation is resized
to the corresponding <code>target_sizes</code> entry.</li>
<li><strong>segments_info</strong> — A dictionary that contains additional information on each segment.<ul>
<li><strong>id</strong> — an integer representing the <code>segment_id</code>.</li>
<li><strong>label_id</strong> — An integer representing the label / semantic class id corresponding to <code>segment_id</code>.</li>
<li><strong>was_fused</strong> — a boolean, <code>True</code> if <code>label_id</code> was in <code>label_ids_to_fuse</code>, <code>False</code> otherwise.
Multiple instances of the same class / label were fused and assigned a single <code>segment_id</code>.</li>
<li><strong>score</strong> — Prediction score of segment with <code>segment_id</code>.</li>
</ul></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),ze=new P({props:{title:"MaskFormerFeatureExtractor",local:"transformers.MaskFormerFeatureExtractor",headingTag:"h2"}}),Ue=new x({props:{name:"class transformers.MaskFormerFeatureExtractor",anchor:"transformers.MaskFormerFeatureExtractor",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.36.2/src/transformers/models/maskformer/feature_extraction_maskformer.py#L26"}}),Ne=new x({props:{name:"__call__",anchor:"transformers.MaskFormerFeatureExtractor.__call__",parameters:[{name:"images",val:""},{name:"segmentation_maps",val:" = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.36.2/src/transformers/models/maskformer/image_processing_maskformer.py#L571"}}),Le=new x({props:{name:"encode_inputs",anchor:"transformers.MaskFormerFeatureExtractor.encode_inputs",parameters:[{name:"pixel_values_list",val:": typing.List[typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]]"},{name:"segmentation_maps",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]] = None"},{name:"instance_id_to_semantic_id",val:": typing.Union[typing.List[typing.Dict[int, int]], typing.Dict[int, int], NoneType] = None"},{name:"ignore_index",val:": typing.Optional[int] = None"},{name:"reduce_labels",val:": bool = False"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.MaskFormerFeatureExtractor.encode_inputs.pixel_values_list",description:`<strong>pixel_values_list</strong> (<code>List[ImageInput]</code>) &#x2014;
List of images (pixel values) to be padded. Each image should be a tensor of shape <code>(channels, height, width)</code>.`,name:"pixel_values_list"},{anchor:"transformers.MaskFormerFeatureExtractor.encode_inputs.segmentation_maps",description:`<strong>segmentation_maps</strong> (<code>ImageInput</code>, <em>optional</em>) &#x2014;
The corresponding semantic segmentation maps with the pixel-wise annotations.</p>
<p>(<code>bool</code>, <em>optional</em>, defaults to <code>True</code>):
Whether or not to pad images up to the largest image in a batch and create a pixel mask.</p>
<p>If left to the default, will return a pixel mask that is:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>`,name:"segmentation_maps"},{anchor:"transformers.MaskFormerFeatureExtractor.encode_inputs.instance_id_to_semantic_id",description:`<strong>instance_id_to_semantic_id</strong> (<code>List[Dict[int, int]]</code> or <code>Dict[int, int]</code>, <em>optional</em>) &#x2014;
A mapping between object instance ids and class ids. If passed, <code>segmentation_maps</code> is treated as an
instance segmentation map where each pixel represents an instance id. Can be provided as a single
dictionary with a global/dataset-level mapping or as a list of dictionaries (one per image), to map
instance ids in each image separately.`,name:"instance_id_to_semantic_id"},{anchor:"transformers.MaskFormerFeatureExtractor.encode_inputs.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/v4.36.2/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors instead of NumPy arrays. If set to <code>&apos;pt&apos;</code>, return PyTorch <code>torch.Tensor</code>
objects.`,name:"return_tensors"}],source:"https://github.com/huggingface/transformers/blob/v4.36.2/src/transformers/models/maskformer/image_processing_maskformer.py#L875",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.36.2/en/main_classes/image_processor#transformers.BatchFeature"
>BatchFeature</a> with the following fields:</p>
<ul>
<li><strong>pixel_values</strong> — Pixel values to be fed to a model.</li>
<li><strong>pixel_mask</strong> — Pixel mask to be fed to a model (when <code>=True</code> or if <code>pixel_mask</code> is in
<code>self.model_input_names</code>).</li>
<li><strong>mask_labels</strong> — Optional list of mask labels of shape <code>(labels, height, width)</code> to be fed to a model
(when <code>annotations</code> are provided).</li>
<li><strong>class_labels</strong> — Optional list of class labels of shape <code>(labels)</code> to be fed to a model (when
<code>annotations</code> are provided). They identify the labels of <code>mask_labels</code>, e.g. the label of
<code>mask_labels[i][j]</code> if <code>class_labels[i][j]</code>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.36.2/en/main_classes/image_processor#transformers.BatchFeature"
>BatchFeature</a></p>
`}}),Ze=new x({props:{name:"post_process_semantic_segmentation",anchor:"transformers.MaskFormerFeatureExtractor.post_process_semantic_segmentation",parameters:[{name:"outputs",val:""},{name:"target_sizes",val:": typing.Union[typing.List[typing.Tuple[int, int]], NoneType] = None"}],parametersDescription:[{anchor:"transformers.MaskFormerFeatureExtractor.post_process_semantic_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/v4.36.2/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.MaskFormerFeatureExtractor.post_process_semantic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction. If left to None, predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/v4.36.2/src/transformers/models/maskformer/image_processing_maskformer.py#L1029",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of length <code>batch_size</code>, where each item is a semantic segmentation map of shape (height, width)
corresponding to the target_sizes entry (if <code>target_sizes</code> is specified). Each entry of each
<code>torch.Tensor</code> correspond to a semantic class id.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[torch.Tensor]</code></p>
`}}),Ce=new x({props:{name:"post_process_instance_segmentation",anchor:"transformers.MaskFormerFeatureExtractor.post_process_instance_segmentation",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"mask_threshold",val:": float = 0.5"},{name:"overlap_mask_area_threshold",val:": float = 0.8"},{name:"target_sizes",val:": typing.Union[typing.List[typing.Tuple[int, int]], NoneType] = None"},{name:"return_coco_annotation",val:": typing.Optional[bool] = False"},{name:"return_binary_maps",val:": typing.Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.MaskFormerFeatureExtractor.post_process_instance_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/v4.36.2/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.MaskFormerFeatureExtractor.post_process_instance_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The probability score threshold to keep predicted instance masks.`,name:"threshold"},{anchor:"transformers.MaskFormerFeatureExtractor.post_process_instance_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"transformers.MaskFormerFeatureExtractor.post_process_instance_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
The overlap mask area threshold to merge or discard small disconnected parts within each binary
instance mask.`,name:"overlap_mask_area_threshold"},{anchor:"transformers.MaskFormerFeatureExtractor.post_process_instance_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction. If left to None, predictions will not be resized.`,name:"target_sizes"},{anchor:"transformers.MaskFormerFeatureExtractor.post_process_instance_segmentation.return_coco_annotation",description:`<strong>return_coco_annotation</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If set to <code>True</code>, segmentation maps are returned in COCO run-length encoding (RLE) format.`,name:"return_coco_annotation"},{anchor:"transformers.MaskFormerFeatureExtractor.post_process_instance_segmentation.return_binary_maps",description:`<strong>return_binary_maps</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If set to <code>True</code>, segmentation maps are returned as a concatenated tensor of binary segmentation maps
(one per detected instance).`,name:"return_binary_maps"}],source:"https://github.com/huggingface/transformers/blob/v4.36.2/src/transformers/models/maskformer/image_processing_maskformer.py#L1079",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, one per image, each dictionary containing two keys:</p>
<ul>
<li><strong>segmentation</strong> — A tensor of shape <code>(height, width)</code> where each pixel represents a <code>segment_id</code> or
<code>List[List]</code> run-length encoding (RLE) of the segmentation map if return_coco_annotation is set to
<code>True</code>. Set to <code>None</code> if no mask if found above <code>threshold</code>.</li>
<li><strong>segments_info</strong> — A dictionary that contains additional information on each segment.<ul>
<li><strong>id</strong> — An integer representing the <code>segment_id</code>.</li>
<li><strong>label_id</strong> — An integer representing the label / semantic class id corresponding to <code>segment_id</code>.</li>
<li><strong>score</strong> — Prediction score of segment with <code>segment_id</code>.</li>
</ul></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),Je=new x({props:{name:"post_process_panoptic_segmentation",anchor:"transformers.MaskFormerFeatureExtractor.post_process_panoptic_segmentation",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"mask_threshold",val:": float = 0.5"},{name:"overlap_mask_area_threshold",val:": float = 0.8"},{name:"label_ids_to_fuse",val:": typing.Optional[typing.Set[int]] = None"},{name:"target_sizes",val:": typing.Union[typing.List[typing.Tuple[int, int]], NoneType] = None"}],parametersDescription:[{anchor:"transformers.MaskFormerFeatureExtractor.post_process_panoptic_segmentation.outputs",description:`<strong>outputs</strong> (<code>MaskFormerForInstanceSegmentationOutput</code>) &#x2014;
The outputs from <a href="/docs/transformers/v4.36.2/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a>.`,name:"outputs"},{anchor:"transformers.MaskFormerFeatureExtractor.post_process_panoptic_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The probability score threshold to keep predicted instance masks.`,name:"threshold"},{anchor:"transformers.MaskFormerFeatureExtractor.post_process_panoptic_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"transformers.MaskFormerFeatureExtractor.post_process_panoptic_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
The overlap mask area threshold to merge or discard small disconnected parts within each binary
instance mask.`,name:"overlap_mask_area_threshold"},{anchor:"transformers.MaskFormerFeatureExtractor.post_process_panoptic_segmentation.label_ids_to_fuse",description:`<strong>label_ids_to_fuse</strong> (<code>Set[int]</code>, <em>optional</em>) &#x2014;
The labels in this state will have all their instances be fused together. For instance we could say
there can only be one sky in an image, but several persons, so the label ID for sky would be in that
set, but not the one for person.`,name:"label_ids_to_fuse"},{anchor:"transformers.MaskFormerFeatureExtractor.post_process_panoptic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction in batch. If left to None, predictions will not be
resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/v4.36.2/src/transformers/models/maskformer/image_processing_maskformer.py#L1193",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, one per image, each dictionary containing two keys:</p>
<ul>
<li><strong>segmentation</strong> — a tensor of shape <code>(height, width)</code> where each pixel represents a <code>segment_id</code>, set
to <code>None</code> if no mask if found above <code>threshold</code>. If <code>target_sizes</code> is specified, segmentation is resized
to the corresponding <code>target_sizes</code> entry.</li>
<li><strong>segments_info</strong> — A dictionary that contains additional information on each segment.<ul>
<li><strong>id</strong> — an integer representing the <code>segment_id</code>.</li>
<li><strong>label_id</strong> — An integer representing the label / semantic class id corresponding to <code>segment_id</code>.</li>
<li><strong>was_fused</strong> — a boolean, <code>True</code> if <code>label_id</code> was in <code>label_ids_to_fuse</code>, <code>False</code> otherwise.
Multiple instances of the same class / label were fused and assigned a single <code>segment_id</code>.</li>
<li><strong>score</strong> — Prediction score of segment with <code>segment_id</code>.</li>
</ul></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),We=new P({props:{title:"MaskFormerModel",local:"transformers.MaskFormerModel",headingTag:"h2"}}),Re=new x({props:{name:"class transformers.MaskFormerModel",anchor:"transformers.MaskFormerModel",parameters:[{name:"config",val:": MaskFormerConfig"}],parametersDescription:[{anchor:"transformers.MaskFormerModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.36.2/en/model_doc/maskformer#transformers.MaskFormerConfig">MaskFormerConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.36.2/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.36.2/src/transformers/models/maskformer/modeling_maskformer.py#L1601"}}),Be=new x({props:{name:"forward",anchor:"transformers.MaskFormerModel.forward",parameters:[{name:"pixel_values",val:": Tensor"},{name:"pixel_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.MaskFormerModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.36.2/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/v4.36.2/en/model_doc/maskformer#transformers.MaskFormerFeatureExtractor.__call__">MaskFormerImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.MaskFormerModel.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.MaskFormerModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MaskFormerModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of Detr&#x2019;s decoder attention layers.`,name:"output_attentions"},{anchor:"transformers.MaskFormerModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <code>~MaskFormerModelOutput</code> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.36.2/src/transformers/models/maskformer/modeling_maskformer.py#L1611",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.36.2/en/model_doc/maskformer#transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput"
>transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.36.2/en/model_doc/maskformer#transformers.MaskFormerConfig"
>MaskFormerConfig</a>) and inputs.</p>
<ul>
<li><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) — Last hidden states (final feature map) of the last stage of the encoder model (backbone).</li>
<li><strong>pixel_decoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) — Last hidden states (final feature map) of the last stage of the pixel decoder model (FPN).</li>
<li><strong>transformer_decoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Last hidden states (final feature map) of the last stage of the transformer decoder model.</li>
<li><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage.</li>
<li><strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage.</li>
<li><strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states (also called feature maps) of the
transformer decoder at the output of each stage.</li>
<li><strong>hidden_states</strong> <code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> containing <code>encoder_hidden_states</code>, <code>pixel_decoder_hidden_states</code> and
<code>decoder_hidden_states</code></li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights from Detr’s decoder after the attention softmax, used to compute the
weighted average in the self-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.36.2/en/model_doc/maskformer#transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput"
>transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),K=new Go({props:{$$slots:{default:[Zs]},$$scope:{ctx:z}}}),ee=new to({props:{anchor:"transformers.MaskFormerModel.forward.example",$$slots:{default:[Cs]},$$scope:{ctx:z}}}),Pe=new P({props:{title:"MaskFormerForInstanceSegmentation",local:"transformers.MaskFormerForInstanceSegmentation",headingTag:"h2"}}),Ee=new x({props:{name:"class transformers.MaskFormerForInstanceSegmentation",anchor:"transformers.MaskFormerForInstanceSegmentation",parameters:[{name:"config",val:": MaskFormerConfig"}],source:"https://github.com/huggingface/transformers/blob/v4.36.2/src/transformers/models/maskformer/modeling_maskformer.py#L1700"}}),Ve=new x({props:{name:"forward",anchor:"transformers.MaskFormerForInstanceSegmentation.forward",parameters:[{name:"pixel_values",val:": Tensor"},{name:"mask_labels",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"class_labels",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"pixel_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_auxiliary_logits",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.MaskFormerForInstanceSegmentation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.36.2/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/v4.36.2/en/model_doc/maskformer#transformers.MaskFormerFeatureExtractor.__call__">MaskFormerImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.MaskFormerForInstanceSegmentation.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.MaskFormerForInstanceSegmentation.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MaskFormerForInstanceSegmentation.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of Detr&#x2019;s decoder attention layers.`,name:"output_attentions"},{anchor:"transformers.MaskFormerForInstanceSegmentation.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <code>~MaskFormerModelOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MaskFormerForInstanceSegmentation.forward.mask_labels",description:`<strong>mask_labels</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
List of mask labels of shape <code>(num_labels, height, width)</code> to be fed to a model`,name:"mask_labels"},{anchor:"transformers.MaskFormerForInstanceSegmentation.forward.class_labels",description:`<strong>class_labels</strong> (<code>List[torch.LongTensor]</code>, <em>optional</em>) &#x2014;
list of target class labels of shape <code>(num_labels, height, width)</code> to be fed to a model. They identify the
labels of <code>mask_labels</code>, e.g. the label of <code>mask_labels[i][j]</code> if <code>class_labels[i][j]</code>.`,name:"class_labels"}],source:"https://github.com/huggingface/transformers/blob/v4.36.2/src/transformers/models/maskformer/modeling_maskformer.py#L1795",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.36.2/en/model_doc/maskformer#transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput"
>transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.36.2/en/model_doc/maskformer#transformers.MaskFormerConfig"
>MaskFormerConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.Tensor</code>, <em>optional</em>) — The computed loss, returned when labels are present.</li>
<li><strong>class_queries_logits</strong> (<code>torch.FloatTensor</code>) — A tensor of shape <code>(batch_size, num_queries, num_labels + 1)</code> representing the proposed classes for each
query. Note the <code>+ 1</code> is needed because we incorporate the null class.</li>
<li><strong>masks_queries_logits</strong> (<code>torch.FloatTensor</code>) — A tensor of shape <code>(batch_size, num_queries, height, width)</code> representing the proposed masks for each
query.</li>
<li><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) — Last hidden states (final feature map) of the last stage of the encoder model (backbone).</li>
<li><strong>pixel_decoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) — Last hidden states (final feature map) of the last stage of the pixel decoder model (FPN).</li>
<li><strong>transformer_decoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Last hidden states (final feature map) of the last stage of the transformer decoder model.</li>
<li><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage.</li>
<li><strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage.</li>
<li><strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the transformer decoder at the output
of each stage.</li>
<li><strong>hidden_states</strong> <code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> containing <code>encoder_hidden_states</code>, <code>pixel_decoder_hidden_states</code> and
<code>decoder_hidden_states</code>.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights from Detr’s decoder after the attention softmax, used to compute the
weighted average in the self-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.36.2/en/model_doc/maskformer#transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput"
>transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),te=new Go({props:{$$slots:{default:[Js]},$$scope:{ctx:z}}}),oe=new to({props:{anchor:"transformers.MaskFormerForInstanceSegmentation.forward.example",$$slots:{default:[Ws]},$$scope:{ctx:z}}}),se=new to({props:{anchor:"transformers.MaskFormerForInstanceSegmentation.forward.example-2",$$slots:{default:[Rs]},$$scope:{ctx:z}}}),{c(){a=l("meta"),y=n(),m=l("p"),p=n(),g(M.$$.fragment),i=n(),g(F.$$.fragment),yt=n(),g(re.$$.fragment),Ft=n(),ae=l("p"),ae.innerHTML=Oo,vt=n(),ie=l("p"),ie.textContent=Do,wt=n(),le=l("p"),le.innerHTML=Ao,Tt=n(),de=l("p"),de.innerHTML=qo,xt=n(),ce=l("img"),$t=n(),me=l("p"),me.innerHTML=Qo,It=n(),g(pe.$$.fragment),jt=n(),ge=l("ul"),ge.innerHTML=Ko,zt=n(),g(he.$$.fragment),Ut=n(),g(fe.$$.fragment),Nt=n(),ue=l("ul"),ue.innerHTML=es,Lt=n(),g(_e.$$.fragment),Zt=n(),E=l("div"),g(be.$$.fragment),so=n(),Ge=l("p"),Ge.innerHTML=ts,Ct=n(),J=l("div"),g(ke.$$.fragment),no=n(),Oe=l("p"),Oe.innerHTML=os,ro=n(),De=l("p"),De.innerHTML=ss,Jt=n(),g(Me.$$.fragment),Wt=n(),I=l("div"),g(ye.$$.fragment),ao=n(),Ae=l("p"),Ae.innerHTML=ns,io=n(),qe=l("p"),qe.innerHTML=rs,lo=n(),Ye=l("p"),Ye.innerHTML=as,co=n(),g(H.$$.fragment),mo=n(),G=l("div"),g(Fe.$$.fragment),po=n(),Qe=l("p"),Qe.innerHTML=is,Rt=n(),g(ve.$$.fragment),Bt=n(),T=l("div"),g(we.$$.fragment),go=n(),Ke=l("p"),Ke.textContent=ls,ho=n(),et=l("p"),et.innerHTML=ds,fo=n(),tt=l("div"),g(Te.$$.fragment),uo=n(),R=l("div"),g(xe.$$.fragment),_o=n(),ot=l("p"),ot.innerHTML=cs,bo=n(),st=l("p"),st.innerHTML=ms,ko=n(),O=l("div"),g($e.$$.fragment),Mo=n(),nt=l("p"),nt.innerHTML=ps,yo=n(),D=l("div"),g(Ie.$$.fragment),Fo=n(),rt=l("p"),rt.innerHTML=gs,vo=n(),A=l("div"),g(je.$$.fragment),wo=n(),at=l("p"),at.innerHTML=hs,Pt=n(),g(ze.$$.fragment),Et=n(),j=l("div"),g(Ue.$$.fragment),To=n(),it=l("div"),g(Ne.$$.fragment),xo=n(),B=l("div"),g(Le.$$.fragment),$o=n(),lt=l("p"),lt.innerHTML=fs,Io=n(),dt=l("p"),dt.innerHTML=us,jo=n(),q=l("div"),g(Ze.$$.fragment),zo=n(),ct=l("p"),ct.innerHTML=_s,Uo=n(),Y=l("div"),g(Ce.$$.fragment),No=n(),mt=l("p"),mt.innerHTML=bs,Lo=n(),Q=l("div"),g(Je.$$.fragment),Zo=n(),pt=l("p"),pt.innerHTML=ks,Vt=n(),g(We.$$.fragment),Xt=n(),W=l("div"),g(Re.$$.fragment),Co=n(),gt=l("p"),gt.innerHTML=Ms,Jo=n(),L=l("div"),g(Be.$$.fragment),Wo=n(),ht=l("p"),ht.innerHTML=ys,Ro=n(),g(K.$$.fragment),Bo=n(),g(ee.$$.fragment),St=n(),g(Pe.$$.fragment),Ht=n(),V=l("div"),g(Ee.$$.fragment),Po=n(),U=l("div"),g(Ve.$$.fragment),Eo=n(),ft=l("p"),ft.innerHTML=Fs,Vo=n(),g(te.$$.fragment),Xo=n(),ut=l("p"),ut.textContent=vs,So=n(),g(oe.$$.fragment),Ho=n(),g(se.$$.fragment),Gt=n(),kt=l("p"),this.h()},l(e){const s=zs("svelte-u9bgzb",document.head);a=d(s,"META",{name:!0,content:!0}),s.forEach(t),y=r(e),m=d(e,"P",{}),w(m).forEach(t),p=r(e),h(M.$$.fragment,e),i=r(e),h(F.$$.fragment,e),yt=r(e),h(re.$$.fragment,e),Ft=r(e),ae=d(e,"P",{"data-svelte-h":!0}),k(ae)!=="svelte-1nc0rjr"&&(ae.innerHTML=Oo),vt=r(e),ie=d(e,"P",{"data-svelte-h":!0}),k(ie)!=="svelte-vfdo9a"&&(ie.textContent=Do),wt=r(e),le=d(e,"P",{"data-svelte-h":!0}),k(le)!=="svelte-lfolgg"&&(le.innerHTML=Ao),Tt=r(e),de=d(e,"P",{"data-svelte-h":!0}),k(de)!=="svelte-58561s"&&(de.innerHTML=qo),xt=r(e),ce=d(e,"IMG",{width:!0,src:!0}),$t=r(e),me=d(e,"P",{"data-svelte-h":!0}),k(me)!=="svelte-1j464j"&&(me.innerHTML=Qo),It=r(e),h(pe.$$.fragment,e),jt=r(e),ge=d(e,"UL",{"data-svelte-h":!0}),k(ge)!=="svelte-1fumaw6"&&(ge.innerHTML=Ko),zt=r(e),h(he.$$.fragment,e),Ut=r(e),h(fe.$$.fragment,e),Nt=r(e),ue=d(e,"UL",{"data-svelte-h":!0}),k(ue)!=="svelte-wxe7j8"&&(ue.innerHTML=es),Lt=r(e),h(_e.$$.fragment,e),Zt=r(e),E=d(e,"DIV",{class:!0});var Xe=w(E);h(be.$$.fragment,Xe),so=r(Xe),Ge=d(Xe,"P",{"data-svelte-h":!0}),k(Ge)!=="svelte-1u0ugmt"&&(Ge.innerHTML=ts),Xe.forEach(t),Ct=r(e),J=d(e,"DIV",{class:!0});var X=w(J);h(ke.$$.fragment,X),no=r(X),Oe=d(X,"P",{"data-svelte-h":!0}),k(Oe)!=="svelte-vteak6"&&(Oe.innerHTML=os),ro=r(X),De=d(X,"P",{"data-svelte-h":!0}),k(De)!=="svelte-pugf1t"&&(De.innerHTML=ss),X.forEach(t),Jt=r(e),h(Me.$$.fragment,e),Wt=r(e),I=d(e,"DIV",{class:!0});var N=w(I);h(ye.$$.fragment,N),ao=r(N),Ae=d(N,"P",{"data-svelte-h":!0}),k(Ae)!=="svelte-rmp7c8"&&(Ae.innerHTML=ns),io=r(N),qe=d(N,"P",{"data-svelte-h":!0}),k(qe)!=="svelte-relmed"&&(qe.innerHTML=rs),lo=r(N),Ye=d(N,"P",{"data-svelte-h":!0}),k(Ye)!=="svelte-l3soxz"&&(Ye.innerHTML=as),co=r(N),h(H.$$.fragment,N),mo=r(N),G=d(N,"DIV",{class:!0});var Se=w(G);h(Fe.$$.fragment,Se),po=r(Se),Qe=d(Se,"P",{"data-svelte-h":!0}),k(Qe)!=="svelte-anptk0"&&(Qe.innerHTML=is),Se.forEach(t),N.forEach(t),Rt=r(e),h(ve.$$.fragment,e),Bt=r(e),T=d(e,"DIV",{class:!0});var $=w(T);h(we.$$.fragment,$),go=r($),Ke=d($,"P",{"data-svelte-h":!0}),k(Ke)!=="svelte-1fb5les"&&(Ke.textContent=ls),ho=r($),et=d($,"P",{"data-svelte-h":!0}),k(et)!=="svelte-1wh3jgn"&&(et.innerHTML=ds),fo=r($),tt=d($,"DIV",{class:!0});var Mt=w(tt);h(Te.$$.fragment,Mt),Mt.forEach(t),uo=r($),R=d($,"DIV",{class:!0});var S=w(R);h(xe.$$.fragment,S),_o=r(S),ot=d(S,"P",{"data-svelte-h":!0}),k(ot)!=="svelte-1tetyua"&&(ot.innerHTML=cs),bo=r(S),st=d(S,"P",{"data-svelte-h":!0}),k(st)!=="svelte-1r85oma"&&(st.innerHTML=ms),S.forEach(t),ko=r($),O=d($,"DIV",{class:!0});var Dt=w(O);h($e.$$.fragment,Dt),Mo=r(Dt),nt=d(Dt,"P",{"data-svelte-h":!0}),k(nt)!=="svelte-1wluz57"&&(nt.innerHTML=ps),Dt.forEach(t),yo=r($),D=d($,"DIV",{class:!0});var At=w(D);h(Ie.$$.fragment,At),Fo=r(At),rt=d(At,"P",{"data-svelte-h":!0}),k(rt)!=="svelte-109ykdi"&&(rt.innerHTML=gs),At.forEach(t),vo=r($),A=d($,"DIV",{class:!0});var qt=w(A);h(je.$$.fragment,qt),wo=r(qt),at=d(qt,"P",{"data-svelte-h":!0}),k(at)!=="svelte-pw2uru"&&(at.innerHTML=hs),qt.forEach(t),$.forEach(t),Pt=r(e),h(ze.$$.fragment,e),Et=r(e),j=d(e,"DIV",{class:!0});var Z=w(j);h(Ue.$$.fragment,Z),To=r(Z),it=d(Z,"DIV",{class:!0});var ws=w(it);h(Ne.$$.fragment,ws),ws.forEach(t),xo=r(Z),B=d(Z,"DIV",{class:!0});var _t=w(B);h(Le.$$.fragment,_t),$o=r(_t),lt=d(_t,"P",{"data-svelte-h":!0}),k(lt)!=="svelte-1tetyua"&&(lt.innerHTML=fs),Io=r(_t),dt=d(_t,"P",{"data-svelte-h":!0}),k(dt)!=="svelte-1r85oma"&&(dt.innerHTML=us),_t.forEach(t),jo=r(Z),q=d(Z,"DIV",{class:!0});var Yt=w(q);h(Ze.$$.fragment,Yt),zo=r(Yt),ct=d(Yt,"P",{"data-svelte-h":!0}),k(ct)!=="svelte-1wluz57"&&(ct.innerHTML=_s),Yt.forEach(t),Uo=r(Z),Y=d(Z,"DIV",{class:!0});var Qt=w(Y);h(Ce.$$.fragment,Qt),No=r(Qt),mt=d(Qt,"P",{"data-svelte-h":!0}),k(mt)!=="svelte-109ykdi"&&(mt.innerHTML=bs),Qt.forEach(t),Lo=r(Z),Q=d(Z,"DIV",{class:!0});var Kt=w(Q);h(Je.$$.fragment,Kt),Zo=r(Kt),pt=d(Kt,"P",{"data-svelte-h":!0}),k(pt)!=="svelte-pw2uru"&&(pt.innerHTML=ks),Kt.forEach(t),Z.forEach(t),Vt=r(e),h(We.$$.fragment,e),Xt=r(e),W=d(e,"DIV",{class:!0});var bt=w(W);h(Re.$$.fragment,bt),Co=r(bt),gt=d(bt,"P",{"data-svelte-h":!0}),k(gt)!=="svelte-1wwkld6"&&(gt.innerHTML=Ms),Jo=r(bt),L=d(bt,"DIV",{class:!0});var ne=w(L);h(Be.$$.fragment,ne),Wo=r(ne),ht=d(ne,"P",{"data-svelte-h":!0}),k(ht)!=="svelte-cvtdz4"&&(ht.innerHTML=ys),Ro=r(ne),h(K.$$.fragment,ne),Bo=r(ne),h(ee.$$.fragment,ne),ne.forEach(t),bt.forEach(t),St=r(e),h(Pe.$$.fragment,e),Ht=r(e),V=d(e,"DIV",{class:!0});var eo=w(V);h(Ee.$$.fragment,eo),Po=r(eo),U=d(eo,"DIV",{class:!0});var C=w(U);h(Ve.$$.fragment,C),Eo=r(C),ft=d(C,"P",{"data-svelte-h":!0}),k(ft)!=="svelte-1y4thoo"&&(ft.innerHTML=Fs),Vo=r(C),h(te.$$.fragment,C),Xo=r(C),ut=d(C,"P",{"data-svelte-h":!0}),k(ut)!=="svelte-kvfsh7"&&(ut.textContent=vs),So=r(C),h(oe.$$.fragment,C),Ho=r(C),h(se.$$.fragment,C),C.forEach(t),eo.forEach(t),Gt=r(e),kt=d(e,"P",{}),w(kt).forEach(t),this.h()},h(){v(a,"name","hf:doc:metadata"),v(a,"content",Ps),v(ce,"width","600"),xs(ce.src,Yo="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/maskformer_architecture.png")||v(ce,"src",Yo),v(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(it,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,s){o(document.head,a),c(e,y,s),c(e,m,s),c(e,p,s),f(M,e,s),c(e,i,s),f(F,e,s),c(e,yt,s),f(re,e,s),c(e,Ft,s),c(e,ae,s),c(e,vt,s),c(e,ie,s),c(e,wt,s),c(e,le,s),c(e,Tt,s),c(e,de,s),c(e,xt,s),c(e,ce,s),c(e,$t,s),c(e,me,s),c(e,It,s),f(pe,e,s),c(e,jt,s),c(e,ge,s),c(e,zt,s),f(he,e,s),c(e,Ut,s),f(fe,e,s),c(e,Nt,s),c(e,ue,s),c(e,Lt,s),f(_e,e,s),c(e,Zt,s),c(e,E,s),f(be,E,null),o(E,so),o(E,Ge),c(e,Ct,s),c(e,J,s),f(ke,J,null),o(J,no),o(J,Oe),o(J,ro),o(J,De),c(e,Jt,s),f(Me,e,s),c(e,Wt,s),c(e,I,s),f(ye,I,null),o(I,ao),o(I,Ae),o(I,io),o(I,qe),o(I,lo),o(I,Ye),o(I,co),f(H,I,null),o(I,mo),o(I,G),f(Fe,G,null),o(G,po),o(G,Qe),c(e,Rt,s),f(ve,e,s),c(e,Bt,s),c(e,T,s),f(we,T,null),o(T,go),o(T,Ke),o(T,ho),o(T,et),o(T,fo),o(T,tt),f(Te,tt,null),o(T,uo),o(T,R),f(xe,R,null),o(R,_o),o(R,ot),o(R,bo),o(R,st),o(T,ko),o(T,O),f($e,O,null),o(O,Mo),o(O,nt),o(T,yo),o(T,D),f(Ie,D,null),o(D,Fo),o(D,rt),o(T,vo),o(T,A),f(je,A,null),o(A,wo),o(A,at),c(e,Pt,s),f(ze,e,s),c(e,Et,s),c(e,j,s),f(Ue,j,null),o(j,To),o(j,it),f(Ne,it,null),o(j,xo),o(j,B),f(Le,B,null),o(B,$o),o(B,lt),o(B,Io),o(B,dt),o(j,jo),o(j,q),f(Ze,q,null),o(q,zo),o(q,ct),o(j,Uo),o(j,Y),f(Ce,Y,null),o(Y,No),o(Y,mt),o(j,Lo),o(j,Q),f(Je,Q,null),o(Q,Zo),o(Q,pt),c(e,Vt,s),f(We,e,s),c(e,Xt,s),c(e,W,s),f(Re,W,null),o(W,Co),o(W,gt),o(W,Jo),o(W,L),f(Be,L,null),o(L,Wo),o(L,ht),o(L,Ro),f(K,L,null),o(L,Bo),f(ee,L,null),c(e,St,s),f(Pe,e,s),c(e,Ht,s),c(e,V,s),f(Ee,V,null),o(V,Po),o(V,U),f(Ve,U,null),o(U,Eo),o(U,ft),o(U,Vo),f(te,U,null),o(U,Xo),o(U,ut),o(U,So),f(oe,U,null),o(U,Ho),f(se,U,null),c(e,Gt,s),c(e,kt,s),Ot=!0},p(e,[s]){const Xe={};s&2&&(Xe.$$scope={dirty:s,ctx:e}),F.$set(Xe);const X={};s&2&&(X.$$scope={dirty:s,ctx:e}),H.$set(X);const N={};s&2&&(N.$$scope={dirty:s,ctx:e}),K.$set(N);const Se={};s&2&&(Se.$$scope={dirty:s,ctx:e}),ee.$set(Se);const $={};s&2&&($.$$scope={dirty:s,ctx:e}),te.$set($);const Mt={};s&2&&(Mt.$$scope={dirty:s,ctx:e}),oe.$set(Mt);const S={};s&2&&(S.$$scope={dirty:s,ctx:e}),se.$set(S)},i(e){Ot||(u(M.$$.fragment,e),u(F.$$.fragment,e),u(re.$$.fragment,e),u(pe.$$.fragment,e),u(he.$$.fragment,e),u(fe.$$.fragment,e),u(_e.$$.fragment,e),u(be.$$.fragment,e),u(ke.$$.fragment,e),u(Me.$$.fragment,e),u(ye.$$.fragment,e),u(H.$$.fragment,e),u(Fe.$$.fragment,e),u(ve.$$.fragment,e),u(we.$$.fragment,e),u(Te.$$.fragment,e),u(xe.$$.fragment,e),u($e.$$.fragment,e),u(Ie.$$.fragment,e),u(je.$$.fragment,e),u(ze.$$.fragment,e),u(Ue.$$.fragment,e),u(Ne.$$.fragment,e),u(Le.$$.fragment,e),u(Ze.$$.fragment,e),u(Ce.$$.fragment,e),u(Je.$$.fragment,e),u(We.$$.fragment,e),u(Re.$$.fragment,e),u(Be.$$.fragment,e),u(K.$$.fragment,e),u(ee.$$.fragment,e),u(Pe.$$.fragment,e),u(Ee.$$.fragment,e),u(Ve.$$.fragment,e),u(te.$$.fragment,e),u(oe.$$.fragment,e),u(se.$$.fragment,e),Ot=!0)},o(e){_(M.$$.fragment,e),_(F.$$.fragment,e),_(re.$$.fragment,e),_(pe.$$.fragment,e),_(he.$$.fragment,e),_(fe.$$.fragment,e),_(_e.$$.fragment,e),_(be.$$.fragment,e),_(ke.$$.fragment,e),_(Me.$$.fragment,e),_(ye.$$.fragment,e),_(H.$$.fragment,e),_(Fe.$$.fragment,e),_(ve.$$.fragment,e),_(we.$$.fragment,e),_(Te.$$.fragment,e),_(xe.$$.fragment,e),_($e.$$.fragment,e),_(Ie.$$.fragment,e),_(je.$$.fragment,e),_(ze.$$.fragment,e),_(Ue.$$.fragment,e),_(Ne.$$.fragment,e),_(Le.$$.fragment,e),_(Ze.$$.fragment,e),_(Ce.$$.fragment,e),_(Je.$$.fragment,e),_(We.$$.fragment,e),_(Re.$$.fragment,e),_(Be.$$.fragment,e),_(K.$$.fragment,e),_(ee.$$.fragment,e),_(Pe.$$.fragment,e),_(Ee.$$.fragment,e),_(Ve.$$.fragment,e),_(te.$$.fragment,e),_(oe.$$.fragment,e),_(se.$$.fragment,e),Ot=!1},d(e){e&&(t(y),t(m),t(p),t(i),t(yt),t(Ft),t(ae),t(vt),t(ie),t(wt),t(le),t(Tt),t(de),t(xt),t(ce),t($t),t(me),t(It),t(jt),t(ge),t(zt),t(Ut),t(Nt),t(ue),t(Lt),t(Zt),t(E),t(Ct),t(J),t(Jt),t(Wt),t(I),t(Rt),t(Bt),t(T),t(Pt),t(Et),t(j),t(Vt),t(Xt),t(W),t(St),t(Ht),t(V),t(Gt),t(kt)),t(a),b(M,e),b(F,e),b(re,e),b(pe,e),b(he,e),b(fe,e),b(_e,e),b(be),b(ke),b(Me,e),b(ye),b(H),b(Fe),b(ve,e),b(we),b(Te),b(xe),b($e),b(Ie),b(je),b(ze,e),b(Ue),b(Ne),b(Le),b(Ze),b(Ce),b(Je),b(We,e),b(Re),b(Be),b(K),b(ee),b(Pe,e),b(Ee),b(Ve),b(te),b(oe),b(se)}}}const Ps='{"title":"MaskFormer","local":"maskformer","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"MaskFormer specific outputs","local":"transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput","sections":[],"depth":2},{"title":"MaskFormerConfig","local":"transformers.MaskFormerConfig","sections":[],"depth":2},{"title":"MaskFormerImageProcessor","local":"transformers.MaskFormerImageProcessor","sections":[],"depth":2},{"title":"MaskFormerFeatureExtractor","local":"transformers.MaskFormerFeatureExtractor","sections":[],"depth":2},{"title":"MaskFormerModel","local":"transformers.MaskFormerModel","sections":[],"depth":2},{"title":"MaskFormerForInstanceSegmentation","local":"transformers.MaskFormerForInstanceSegmentation","sections":[],"depth":2}],"depth":1}';function Es(z){return $s(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class qs extends Is{constructor(a){super(),js(this,a,Es,Bs,Ts,{})}}export{qs as component};
