import{s as Oe,o as et,n as tt}from"../chunks/scheduler.9bc65507.js";import{S as st,i as nt,g as o,s as l,r as y,A as lt,h as r,f as s,c as a,j as Ye,u as h,x as p,k as Ke,y as at,a as n,v as w,d as m,t as d,w as f,m as it,n as ot}from"../chunks/index.707bf1b6.js";import{H as Y,g as rt}from"../chunks/Heading.98cce615.js";import{T as De}from"../chunks/Tip.c2ecdbf4.js";import{C as Be}from"../chunks/CodeBlock.54a9f38d.js";function pt(F){let i;return{c(){i=it(`Creating an inference engine is a complex topic, and the "best" solution 
will most likely depend on your problem space. Are you on CPU or GPU? Do
you want the lowest latency, the highest throughput, support for
many models, or just highly optimize 1 specific model?
There are many ways to tackle this topic, so what we are going to present is a good default
to get started which may not necessarily be the most optimal solution for you.`)},l(c){i=ot(c,`Creating an inference engine is a complex topic, and the "best" solution 
will most likely depend on your problem space. Are you on CPU or GPU? Do
you want the lowest latency, the highest throughput, support for
many models, or just highly optimize 1 specific model?
There are many ways to tackle this topic, so what we are going to present is a good default
to get started which may not necessarily be the most optimal solution for you.`)},m(c,u){n(c,i,u)},d(c){c&&s(i)}}}function ct(F){let i,c=`The code sample below is intentionally written like pseudo-code for readability.
Do not run this without checking if it makes sense for your system resources!`;return{c(){i=o("p"),i.textContent=c},l(u){i=r(u,"P",{"data-svelte-h":!0}),p(i)!=="svelte-rnh8z1"&&(i.textContent=c)},m(u,L){n(u,i,L)},p:tt,d(u){u&&s(i)}}}function ut(F){let i,c,u,L,J,D,T,O,g,ke=`The key thing to understand is that we can use an iterator, just like you would <a href="pipeline_tutorial#using-pipelines-on-a-dataset">on a
dataset</a>, since a webserver is basically a system that waits for requests and
treats them as they come in.`,ee,b,xe=`Usually webservers are multiplexed (multithreaded, async, etc..) to handle various
requests concurrently. Pipelines on the other hand (and mostly the underlying models)
are not really great for parallelism; they take up a lot of RAM, so it’s best to give them all the available resources when they are running or it’s a compute-intensive job.`,te,U,qe=`We are going to solve that by having the webserver handle the light load of receiving
and sending requests, and having a single thread handling the actual work.
This example is going to use <code>starlette</code>. The actual framework is not really
important, but you might have to tune or change the code if you are using another
one to achieve the same effect.`,se,C,_e="Create <code>server.py</code>:",ne,j,le,v,Ne="Now you can start it with:",ae,I,ie,$,Qe="And you can query it:",oe,B,re,k,Xe="And there you go, now you have a good idea of how to create a webserver!",pe,x,Ee=`What is really important is that we load the model only <strong>once</strong>, so there are no copies
of the model on the webserver. This way, no unnecessary RAM is being used.
Then the queuing mechanism allows you to do fancy stuff like maybe accumulating a few
items before inferring to use dynamic batching:`,ce,M,ue,q,ye,_,Ze=`Again, the proposed code is optimized for readability, not for being the best code.
First of all, there’s no batch size limit which is usually not a
great idea. Next, the timeout is reset on every queue fetch, meaning you could
wait much more than 1ms before running the inference (delaying the first request
by that much).`,he,N,He="It would be better to have a single 1ms deadline.",we,Q,Ge=`This will always wait for 1ms even if the queue is empty, which might not be the
best since you probably want to start doing inference if there’s nothing in the queue.
But maybe it does make sense if batching is really crucial for your use case.
Again, there’s really no one best solution.`,me,X,de,E,fe,Z,Ve=`There’s a lot that can go wrong in production: out of memory, out of space,
loading the model might fail, the query might be wrong, the query might be
correct but still fail to run because of a model misconfiguration, and so on.`,Te,H,Se=`Generally, it’s good if the server outputs the errors to the user, so
adding a lot of <code>try..except</code> statements to show those errors is a good
idea. But keep in mind it may also be a security risk to reveal all those errors depending
on your security context.`,Me,G,Je,V,We=`Webservers usually look better when they do circuit breaking. It means they
return proper errors when they’re overloaded instead of just waiting for the query indefinitely. Return a 503 error instead of waiting for a super long time or a 504 after a long time.`,ge,S,Ae=`This is relatively easy to implement in the proposed code since there is a single queue.
Looking at the queue size is a basic way to start returning errors before your
webserver fails under load.`,be,W,Ue,A,Re=`Currently PyTorch is not async aware, and computation will block the main
thread while running. That means it would be better if PyTorch was forced to run
on its own thread/process. This wasn’t done here because the code is a lot more
complex (mostly because threads and async and queues don’t play nice together).
But ultimately it does the same thing.`,Ce,R,ze=`This would be important if the inference of single items were long (> 1s) because
in this case, it means every query during inference would have to wait for 1s before
even receiving an error.`,je,z,ve,P,Pe=`In general, batching is not necessarily an improvement over passing 1 item at
a time (see <a href="./main_classes/pipelines#pipeline-batching">batching details</a> for more information). But it can be very effective
when used in the correct setting. In the API, there is no dynamic
batching by default (too much opportunity for a slowdown). But for BLOOM inference -
which is a very large model - dynamic batching is <strong>essential</strong> to provide a decent experience for everyone.`,Ie,K,$e;return J=new Y({props:{title:"Using pipelines for a webserver",local:"using-pipelines-for-a-webserver",headingTag:"h1"}}),T=new De({props:{$$slots:{default:[pt]},$$scope:{ctx:F}}}),j=new Be({props:{code:"ZnJvbSUyMHN0YXJsZXR0ZS5hcHBsaWNhdGlvbnMlMjBpbXBvcnQlMjBTdGFybGV0dGUlMEFmcm9tJTIwc3RhcmxldHRlLnJlc3BvbnNlcyUyMGltcG9ydCUyMEpTT05SZXNwb25zZSUwQWZyb20lMjBzdGFybGV0dGUucm91dGluZyUyMGltcG9ydCUyMFJvdXRlJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwYXN5bmNpbyUwQSUwQSUwQWFzeW5jJTIwZGVmJTIwaG9tZXBhZ2UocmVxdWVzdCklM0ElMEElMjAlMjAlMjAlMjBwYXlsb2FkJTIwJTNEJTIwYXdhaXQlMjByZXF1ZXN0LmJvZHkoKSUwQSUyMCUyMCUyMCUyMHN0cmluZyUyMCUzRCUyMHBheWxvYWQuZGVjb2RlKCUyMnV0Zi04JTIyKSUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlX3ElMjAlM0QlMjBhc3luY2lvLlF1ZXVlKCklMEElMjAlMjAlMjAlMjBhd2FpdCUyMHJlcXVlc3QuYXBwLm1vZGVsX3F1ZXVlLnB1dCgoc3RyaW5nJTJDJTIwcmVzcG9uc2VfcSkpJTBBJTIwJTIwJTIwJTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjByZXNwb25zZV9xLmdldCgpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwSlNPTlJlc3BvbnNlKG91dHB1dCklMEElMEElMEFhc3luYyUyMGRlZiUyMHNlcnZlcl9sb29wKHEpJTNBJTBBJTIwJTIwJTIwJTIwcGlwZSUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIpJTBBJTIwJTIwJTIwJTIwd2hpbGUlMjBUcnVlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKHN0cmluZyUyQyUyMHJlc3BvbnNlX3EpJTIwJTNEJTIwYXdhaXQlMjBxLmdldCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwcGlwZShzdHJpbmcpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXdhaXQlMjByZXNwb25zZV9xLnB1dChvdXQpJTBBJTBBJTBBYXBwJTIwJTNEJTIwU3RhcmxldHRlKCUwQSUyMCUyMCUyMCUyMHJvdXRlcyUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFJvdXRlKCUyMiUyRiUyMiUyQyUyMGhvbWVwYWdlJTJDJTIwbWV0aG9kcyUzRCU1QiUyMlBPU1QlMjIlNUQpJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBKSUwQSUwQSUwQSU0MGFwcC5vbl9ldmVudCglMjJzdGFydHVwJTIyKSUwQWFzeW5jJTIwZGVmJTIwc3RhcnR1cF9ldmVudCgpJTNBJTBBJTIwJTIwJTIwJTIwcSUyMCUzRCUyMGFzeW5jaW8uUXVldWUoKSUwQSUyMCUyMCUyMCUyMGFwcC5tb2RlbF9xdWV1ZSUyMCUzRCUyMHElMEElMjAlMjAlMjAlMjBhc3luY2lvLmNyZWF0ZV90YXNrKHNlcnZlcl9sb29wKHEpKQ==",highlighted:`<span class="hljs-keyword">from</span> starlette.applications <span class="hljs-keyword">import</span> Starlette
<span class="hljs-keyword">from</span> starlette.responses <span class="hljs-keyword">import</span> JSONResponse
<span class="hljs-keyword">from</span> starlette.routing <span class="hljs-keyword">import</span> Route
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> asyncio


<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">homepage</span>(<span class="hljs-params">request</span>):
    payload = <span class="hljs-keyword">await</span> request.body()
    string = payload.decode(<span class="hljs-string">&quot;utf-8&quot;</span>)
    response_q = asyncio.Queue()
    <span class="hljs-keyword">await</span> request.app.model_queue.put((string, response_q))
    output = <span class="hljs-keyword">await</span> response_q.get()
    <span class="hljs-keyword">return</span> JSONResponse(output)


<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">server_loop</span>(<span class="hljs-params">q</span>):
    pipe = pipeline(model=<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)
    <span class="hljs-keyword">while</span> <span class="hljs-literal">True</span>:
        (string, response_q) = <span class="hljs-keyword">await</span> q.get()
        out = pipe(string)
        <span class="hljs-keyword">await</span> response_q.put(out)


app = Starlette(
    routes=[
        Route(<span class="hljs-string">&quot;/&quot;</span>, homepage, methods=[<span class="hljs-string">&quot;POST&quot;</span>]),
    ],
)


<span class="hljs-meta">@app.on_event(<span class="hljs-params"><span class="hljs-string">&quot;startup&quot;</span></span>)</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">startup_event</span>():
    q = asyncio.Queue()
    app.model_queue = q
    asyncio.create_task(server_loop(q))`,wrap:!1}}),I=new Be({props:{code:"dXZpY29ybiUyMHNlcnZlciUzQWFwcA==",highlighted:"uvicorn server:app",wrap:!1}}),B=new Be({props:{code:"Y3VybCUyMC1YJTIwUE9TVCUyMC1kJTIwJTIydGVzdCUyMCU1Qk1BU0slNUQlMjIlMjBodHRwJTNBJTJGJTJGbG9jYWxob3N0JTNBODAwMCUyRiUwQSUyMyU1QiU3QiUyMnNjb3JlJTIyJTNBMC43NzQyOTM2MDE1MTI5MDg5JTJDJTIydG9rZW4lMjIlM0ExMDEyJTJDJTIydG9rZW5fc3RyJTIyJTNBJTIyLiUyMiUyQyUyMnNlcXVlbmNlJTIyJTNBJTIydGVzdC4lMjIlN0QlMkMuLi4lNUQ=",highlighted:`curl -X POST -d <span class="hljs-string">&quot;test [MASK]&quot;</span> http://localhost:8000/
<span class="hljs-comment">#[{&quot;score&quot;:0.7742936015129089,&quot;token&quot;:1012,&quot;token_str&quot;:&quot;.&quot;,&quot;sequence&quot;:&quot;test.&quot;},...]</span>`,wrap:!1}}),M=new De({props:{warning:!0,$$slots:{default:[ct]},$$scope:{ctx:F}}}),q=new Be({props:{code:"KHN0cmluZyUyQyUyMHJxKSUyMCUzRCUyMGF3YWl0JTIwcS5nZXQoKSUwQXN0cmluZ3MlMjAlM0QlMjAlNUIlNUQlMEFxdWV1ZXMlMjAlM0QlMjAlNUIlNUQlMEF3aGlsZSUyMFRydWUlM0ElMEElMjAlMjAlMjAlMjB0cnklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAoc3RyaW5nJTJDJTIwcnEpJTIwJTNEJTIwYXdhaXQlMjBhc3luY2lvLndhaXRfZm9yKHEuZ2V0KCklMkMlMjB0aW1lb3V0JTNEMC4wMDEpJTIwJTIwJTIzJTIwMW1zJTBBJTIwJTIwJTIwJTIwZXhjZXB0JTIwYXN5bmNpby5leGNlcHRpb25zLlRpbWVvdXRFcnJvciUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJyZWFrJTBBJTIwJTIwJTIwJTIwc3RyaW5ncy5hcHBlbmQoc3RyaW5nKSUwQSUyMCUyMCUyMCUyMHF1ZXVlcy5hcHBlbmQocnEpJTBBc3RyaW5ncyUwQW91dHMlMjAlM0QlMjBwaXBlKHN0cmluZ3MlMkMlMjBiYXRjaF9zaXplJTNEbGVuKHN0cmluZ3MpKSUwQWZvciUyMHJxJTJDJTIwb3V0JTIwaW4lMjB6aXAocXVldWVzJTJDJTIwb3V0cyklM0ElMEElMjAlMjAlMjAlMjBhd2FpdCUyMHJxLnB1dChvdXQp",highlighted:`(string, rq) = <span class="hljs-keyword">await</span> q.get()
strings = []
queues = []
<span class="hljs-keyword">while</span> <span class="hljs-literal">True</span>:
    <span class="hljs-keyword">try</span>:
        (string, rq) = <span class="hljs-keyword">await</span> asyncio.wait_for(q.get(), timeout=<span class="hljs-number">0.001</span>)  <span class="hljs-comment"># 1ms</span>
    <span class="hljs-keyword">except</span> asyncio.exceptions.TimeoutError:
        <span class="hljs-keyword">break</span>
    strings.append(string)
    queues.append(rq)
strings
outs = pipe(strings, batch_size=<span class="hljs-built_in">len</span>(strings))
<span class="hljs-keyword">for</span> rq, out <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(queues, outs):
    <span class="hljs-keyword">await</span> rq.put(out)`,wrap:!1}}),X=new Y({props:{title:"Few things you might want to consider",local:"few-things-you-might-want-to-consider",headingTag:"h2"}}),E=new Y({props:{title:"Error checking",local:"error-checking",headingTag:"h3"}}),G=new Y({props:{title:"Circuit breaking",local:"circuit-breaking",headingTag:"h3"}}),W=new Y({props:{title:"Blocking the main thread",local:"blocking-the-main-thread",headingTag:"h3"}}),z=new Y({props:{title:"Dynamic batching",local:"dynamic-batching",headingTag:"h3"}}),{c(){i=o("meta"),c=l(),u=o("p"),L=l(),y(J.$$.fragment),D=l(),y(T.$$.fragment),O=l(),g=o("p"),g.innerHTML=ke,ee=l(),b=o("p"),b.textContent=xe,te=l(),U=o("p"),U.innerHTML=qe,se=l(),C=o("p"),C.innerHTML=_e,ne=l(),y(j.$$.fragment),le=l(),v=o("p"),v.textContent=Ne,ae=l(),y(I.$$.fragment),ie=l(),$=o("p"),$.textContent=Qe,oe=l(),y(B.$$.fragment),re=l(),k=o("p"),k.textContent=Xe,pe=l(),x=o("p"),x.innerHTML=Ee,ce=l(),y(M.$$.fragment),ue=l(),y(q.$$.fragment),ye=l(),_=o("p"),_.textContent=Ze,he=l(),N=o("p"),N.textContent=He,we=l(),Q=o("p"),Q.textContent=Ge,me=l(),y(X.$$.fragment),de=l(),y(E.$$.fragment),fe=l(),Z=o("p"),Z.textContent=Ve,Te=l(),H=o("p"),H.innerHTML=Se,Me=l(),y(G.$$.fragment),Je=l(),V=o("p"),V.textContent=We,ge=l(),S=o("p"),S.textContent=Ae,be=l(),y(W.$$.fragment),Ue=l(),A=o("p"),A.textContent=Re,Ce=l(),R=o("p"),R.textContent=ze,je=l(),y(z.$$.fragment),ve=l(),P=o("p"),P.innerHTML=Pe,Ie=l(),K=o("p"),this.h()},l(e){const t=lt("svelte-u9bgzb",document.head);i=r(t,"META",{name:!0,content:!0}),t.forEach(s),c=a(e),u=r(e,"P",{}),Ye(u).forEach(s),L=a(e),h(J.$$.fragment,e),D=a(e),h(T.$$.fragment,e),O=a(e),g=r(e,"P",{"data-svelte-h":!0}),p(g)!=="svelte-n5c362"&&(g.innerHTML=ke),ee=a(e),b=r(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-1fnss2o"&&(b.textContent=xe),te=a(e),U=r(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-8q5x1q"&&(U.innerHTML=qe),se=a(e),C=r(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-g4gw6x"&&(C.innerHTML=_e),ne=a(e),h(j.$$.fragment,e),le=a(e),v=r(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-1uqobnc"&&(v.textContent=Ne),ae=a(e),h(I.$$.fragment,e),ie=a(e),$=r(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-65h2jl"&&($.textContent=Qe),oe=a(e),h(B.$$.fragment,e),re=a(e),k=r(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-1c2g0w1"&&(k.textContent=Xe),pe=a(e),x=r(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-1l65fmc"&&(x.innerHTML=Ee),ce=a(e),h(M.$$.fragment,e),ue=a(e),h(q.$$.fragment,e),ye=a(e),_=r(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-14jxcik"&&(_.textContent=Ze),he=a(e),N=r(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-1bprwig"&&(N.textContent=He),we=a(e),Q=r(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1fuz8qb"&&(Q.textContent=Ge),me=a(e),h(X.$$.fragment,e),de=a(e),h(E.$$.fragment,e),fe=a(e),Z=r(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-vb47n8"&&(Z.textContent=Ve),Te=a(e),H=r(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-n6itpg"&&(H.innerHTML=Se),Me=a(e),h(G.$$.fragment,e),Je=a(e),V=r(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1h0ewze"&&(V.textContent=We),ge=a(e),S=r(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-7kt80n"&&(S.textContent=Ae),be=a(e),h(W.$$.fragment,e),Ue=a(e),A=r(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1vr6kgq"&&(A.textContent=Re),Ce=a(e),R=r(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-ime2kf"&&(R.textContent=ze),je=a(e),h(z.$$.fragment,e),ve=a(e),P=r(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-hsmuqq"&&(P.innerHTML=Pe),Ie=a(e),K=r(e,"P",{}),Ye(K).forEach(s),this.h()},h(){Ke(i,"name","hf:doc:metadata"),Ke(i,"content",yt)},m(e,t){at(document.head,i),n(e,c,t),n(e,u,t),n(e,L,t),w(J,e,t),n(e,D,t),w(T,e,t),n(e,O,t),n(e,g,t),n(e,ee,t),n(e,b,t),n(e,te,t),n(e,U,t),n(e,se,t),n(e,C,t),n(e,ne,t),w(j,e,t),n(e,le,t),n(e,v,t),n(e,ae,t),w(I,e,t),n(e,ie,t),n(e,$,t),n(e,oe,t),w(B,e,t),n(e,re,t),n(e,k,t),n(e,pe,t),n(e,x,t),n(e,ce,t),w(M,e,t),n(e,ue,t),w(q,e,t),n(e,ye,t),n(e,_,t),n(e,he,t),n(e,N,t),n(e,we,t),n(e,Q,t),n(e,me,t),w(X,e,t),n(e,de,t),w(E,e,t),n(e,fe,t),n(e,Z,t),n(e,Te,t),n(e,H,t),n(e,Me,t),w(G,e,t),n(e,Je,t),n(e,V,t),n(e,ge,t),n(e,S,t),n(e,be,t),w(W,e,t),n(e,Ue,t),n(e,A,t),n(e,Ce,t),n(e,R,t),n(e,je,t),w(z,e,t),n(e,ve,t),n(e,P,t),n(e,Ie,t),n(e,K,t),$e=!0},p(e,[t]){const Fe={};t&2&&(Fe.$$scope={dirty:t,ctx:e}),T.$set(Fe);const Le={};t&2&&(Le.$$scope={dirty:t,ctx:e}),M.$set(Le)},i(e){$e||(m(J.$$.fragment,e),m(T.$$.fragment,e),m(j.$$.fragment,e),m(I.$$.fragment,e),m(B.$$.fragment,e),m(M.$$.fragment,e),m(q.$$.fragment,e),m(X.$$.fragment,e),m(E.$$.fragment,e),m(G.$$.fragment,e),m(W.$$.fragment,e),m(z.$$.fragment,e),$e=!0)},o(e){d(J.$$.fragment,e),d(T.$$.fragment,e),d(j.$$.fragment,e),d(I.$$.fragment,e),d(B.$$.fragment,e),d(M.$$.fragment,e),d(q.$$.fragment,e),d(X.$$.fragment,e),d(E.$$.fragment,e),d(G.$$.fragment,e),d(W.$$.fragment,e),d(z.$$.fragment,e),$e=!1},d(e){e&&(s(c),s(u),s(L),s(D),s(O),s(g),s(ee),s(b),s(te),s(U),s(se),s(C),s(ne),s(le),s(v),s(ae),s(ie),s($),s(oe),s(re),s(k),s(pe),s(x),s(ce),s(ue),s(ye),s(_),s(he),s(N),s(we),s(Q),s(me),s(de),s(fe),s(Z),s(Te),s(H),s(Me),s(Je),s(V),s(ge),s(S),s(be),s(Ue),s(A),s(Ce),s(R),s(je),s(ve),s(P),s(Ie),s(K)),s(i),f(J,e),f(T,e),f(j,e),f(I,e),f(B,e),f(M,e),f(q,e),f(X,e),f(E,e),f(G,e),f(W,e),f(z,e)}}}const yt='{"title":"Using pipelines for a webserver","local":"using-pipelines-for-a-webserver","sections":[{"title":"Few things you might want to consider","local":"few-things-you-might-want-to-consider","sections":[{"title":"Error checking","local":"error-checking","sections":[],"depth":3},{"title":"Circuit breaking","local":"circuit-breaking","sections":[],"depth":3},{"title":"Blocking the main thread","local":"blocking-the-main-thread","sections":[],"depth":3},{"title":"Dynamic batching","local":"dynamic-batching","sections":[],"depth":3}],"depth":2}],"depth":1}';function ht(F){return et(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=rt}),[]}class Mt extends st{constructor(i){super(),nt(this,i,ht,ut,Oe,{})}}export{Mt as component};
