import{s as Xt,o as xt,n as At}from"../chunks/scheduler.987d3921.js";import{S as Lt,i as St,g as s,s as a,r as p,A as Qt,h as r,f as n,c as i,j as Ht,u as o,x as M,k as he,y as It,a as l,v as m,d as f,t as u,w as b}from"../chunks/index.c8b1fed4.js";import{H as J,g as Nt}from"../chunks/Heading.fa674bf6.js";import{T as Et}from"../chunks/Tip.6bc1e794.js";import{C as h}from"../chunks/CodeBlock.18094d58.js";import{D as Pt}from"../chunks/DocNotebookDropdown.aed1009b.js";function Yt(Me){let d,g="Sie können einen PEFT-Adapter entweder mit einer <code>AutoModelFor</code>-Klasse oder der Basismodellklasse wie <code>OPTForCausalLM</code> oder <code>LlamaForCausalLM</code> laden.";return{c(){d=s("p"),d.innerHTML=g},l(c){d=r(c,"P",{"data-svelte-h":!0}),M(d)!=="svelte-2zshms"&&(d.innerHTML=g)},m(c,y){l(c,d,y)},p:At,d(c){c&&n(d)}}}function qt(Me){let d,g='Wenn Sie mit der Feinabstimmung eines Modells mit <code>Trainer</code> noch nicht vertraut sind, werfen Sie einen Blick auf das Tutorial <a href="Training">Feinabstimmung eines vortrainierten Modells</a>.';return{c(){d=s("p"),d.innerHTML=g},l(c){d=r(c,"P",{"data-svelte-h":!0}),M(d)!=="svelte-1qi8q6s"&&(d.innerHTML=g)},m(c,y){l(c,d,y)},p:At,d(c){c&&n(d)}}}function Dt(Me){let d,g,c,y,C,ge,Z,ye,_,ut='Die <a href="https://huggingface.co/blog/peft" rel="nofollow">Parameter-Efficient Fine Tuning (PEFT)</a> Methoden frieren die vorab trainierten Modellparameter während der Feinabstimmung ein und fügen eine kleine Anzahl trainierbarer Parameter (die Adapter) hinzu. Die Adapter werden trainiert, um aufgabenspezifische Informationen zu lernen. Es hat sich gezeigt, dass dieser Ansatz sehr speichereffizient ist und weniger Rechenleistung beansprucht, während die Ergebnisse mit denen eines vollständig feinabgestimmten Modells vergleichbar sind.',$e,U,bt="Adapter, die mit PEFT trainiert wurden, sind in der Regel um eine Größenordnung kleiner als das vollständige Modell, so dass sie bequem gemeinsam genutzt, gespeichert und geladen werden können.",we,$,Mt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/peft/PEFT-hub-screenshot.png"/> <figcaption class="text-center">Die Adaptergewichte für ein OPTForCausalLM-Modell, die auf dem Hub gespeichert sind, sind nur ~6MB groß, verglichen mit der vollen Größe der Modellgewichte, die ~700MB betragen können.</figcaption>',Te,F,ct='Wenn Sie mehr über die 🤗 PEFT-Bibliothek erfahren möchten, sehen Sie sich die <a href="https://huggingface.co/docs/peft/index" rel="nofollow">Dokumentation</a> an.',ke,W,ve,B,ht="Starten Sie mit der Installation von 🤗 PEFT:",Je,j,Ce,z,gt="Wenn Sie die brandneuen Funktionen ausprobieren möchten, sollten Sie die Bibliothek aus dem Quellcode installieren:",Ze,R,_e,G,Ue,V,yt="Transformers unterstützt nativ einige PEFT-Methoden, d.h. Sie können lokal oder auf dem Hub gespeicherte Adaptergewichte laden und sie mit wenigen Zeilen Code einfach ausführen oder trainieren. Die folgenden Methoden werden unterstützt:",Fe,H,$t='<li><a href="https://huggingface.co/docs/peft/conceptual_guides/lora" rel="nofollow">Low Rank Adapters</a></li> <li><a href="https://huggingface.co/docs/peft/conceptual_guides/ia3" rel="nofollow">IA3</a></li> <li><a href="https://arxiv.org/abs/2303.10512" rel="nofollow">AdaLoRA</a></li>',We,E,wt='Wenn Sie andere PEFT-Methoden, wie z.B. Prompt Learning oder Prompt Tuning, verwenden möchten, oder über die 🤗 PEFT-Bibliothek im Allgemeinen, lesen Sie bitte die <a href="https://huggingface.co/docs/peft/index" rel="nofollow">Dokumentation</a>.',Be,A,je,X,Tt="Um ein PEFT-Adaptermodell von 🤗 Transformers zu laden und zu verwenden, stellen Sie sicher, dass das Hub-Repository oder das lokale Verzeichnis eine <code>adapter_config.json</code>-Datei und die Adaptergewichte enthält, wie im obigen Beispielbild gezeigt. Dann können Sie das PEFT-Adaptermodell mit der Klasse <code>AutoModelFor</code> laden. Um zum Beispiel ein PEFT-Adaptermodell für die kausale Sprachmodellierung zu laden:",ze,x,kt="<li>Geben Sie die PEFT-Modell-ID an.</li> <li>übergeben Sie es an die Klasse <code>AutoModelForCausalLM</code>.</li>",Re,L,Ge,w,Ve,S,vt="Sie können einen PEFT-Adapter auch laden, indem Sie die Methode <code>load_adapter</code> aufrufen:",He,Q,Ee,I,Ae,N,Jt='Die <code>bitsandbytes</code>-Integration unterstützt Datentypen mit 8bit und 4bit Genauigkeit, was für das Laden großer Modelle nützlich ist, weil es Speicher spart (lesen Sie den <code>bitsandbytes</code>-Integrations <a href="./quantization#bitsandbytes-integration">guide</a>, um mehr zu erfahren). Fügen Sie die Parameter <code>load_in_8bit</code> oder <code>load_in_4bit</code> zu <code>from_pretrained()</code> hinzu und setzen Sie <code>device_map=&quot;auto&quot;</code>, um das Modell effektiv auf Ihre Hardware zu verteilen:',Xe,P,xe,Y,Le,q,Ct="Sie können <code>~peft.PeftModel.add_adapter</code> verwenden, um einen neuen Adapter zu einem Modell mit einem bestehenden Adapter hinzuzufügen, solange der neue Adapter vom gleichen Typ ist wie der aktuelle Adapter. Wenn Sie zum Beispiel einen bestehenden LoRA-Adapter an ein Modell angehängt haben:",Se,D,Qe,K,Zt="Um einen neuen Adapter hinzuzufügen:",Ie,O,Ne,ee,_t="Jetzt können Sie mit <code>~peft.PeftModel.set_adapter</code> festlegen, welcher Adapter verwendet werden soll:",Pe,te,Ye,ne,qe,le,Ut="Sobald Sie einen Adapter zu einem Modell hinzugefügt haben, können Sie das Adaptermodul aktivieren oder deaktivieren. So aktivieren Sie das Adaptermodul:",De,ae,Ke,ie,Ft="So deaktivieren Sie das Adaptermodul:",Oe,se,et,re,tt,de,Wt="PEFT-Adapter werden von der Klasse <code>Trainer</code> unterstützt, so dass Sie einen Adapter für Ihren speziellen Anwendungsfall trainieren können. Dazu müssen Sie nur ein paar weitere Codezeilen hinzufügen. Zum Beispiel, um einen LoRA-Adapter zu trainieren:",nt,T,lt,pe,Bt="<li>Definieren Sie Ihre Adapterkonfiguration mit dem Aufgabentyp und den Hyperparametern (siehe <code>~peft.LoraConfig</code> für weitere Details darüber, was die Hyperparameter tun).</li>",at,oe,it,k,jt="<li>Fügen Sie dem Modell einen Adapter hinzu.</li>",st,me,rt,v,zt="<li>Jetzt können Sie das Modell an <code>Trainer</code> übergeben!</li>",dt,fe,pt,ue,Rt="So speichern Sie Ihren trainierten Adapter und laden ihn wieder:",ot,be,mt,ce,ft;return C=new J({props:{title:"Adapter mit 🤗 PEFT laden",local:"adapter-mit--peft-laden",headingTag:"h1"}}),Z=new Pt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/de/peft.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/de/pytorch/peft.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/de/tensorflow/peft.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/de/peft.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/de/pytorch/peft.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/de/tensorflow/peft.ipynb"}]}}),W=new J({props:{title:"Setup",local:"setup",headingTag:"h2"}}),j=new h({props:{code:"cGlwJTIwaW5zdGFsbCUyMHBlZnQ=",highlighted:"pip install peft",wrap:!1}}),R=new h({props:{code:"cGlwJTIwaW5zdGFsbCUyMGdpdCUyQmh0dHBzJTNBJTJGJTJGZ2l0aHViLmNvbSUyRmh1Z2dpbmdmYWNlJTJGcGVmdC5naXQ=",highlighted:"pip install git+https://github.com/huggingface/peft.git",wrap:!1}}),G=new J({props:{title:"Unterstützte PEFT-Modelle",local:"unterstützte-peft-modelle",headingTag:"h2"}}),A=new J({props:{title:"Laden Sie einen PEFT-Adapter",local:"laden-sie-einen-peft-adapter",headingTag:"h2"}}),L=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXBlZnRfbW9kZWxfaWQlMjAlM0QlMjAlMjJ5YmVsa2FkYSUyRm9wdC0zNTBtLWxvcmElMjIlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChwZWZ0X21vZGVsX2lkKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

peft_model_id = <span class="hljs-string">&quot;ybelkada/opt-350m-lora&quot;</span>
model = AutoModelForCausalLM.from_pretrained(peft_model_id)`,wrap:!1}}),w=new Et({props:{$$slots:{default:[Yt]},$$scope:{ctx:Me}}}),Q=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiUwQXBlZnRfbW9kZWxfaWQlMjAlM0QlMjAlMjJ5YmVsa2FkYSUyRm9wdC0zNTBtLWxvcmElMjIlMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEFtb2RlbC5sb2FkX2FkYXB0ZXIocGVmdF9tb2RlbF9pZCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

model_id = <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>
peft_model_id = <span class="hljs-string">&quot;ybelkada/opt-350m-lora&quot;</span>

model = AutoModelForCausalLM.from_pretrained(model_id)
model.load_adapter(peft_model_id)`,wrap:!1}}),I=new J({props:{title:"Laden in 8bit oder 4bit",local:"laden-in-8bit-oder-4bit",headingTag:"h2"}}),P=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXBlZnRfbW9kZWxfaWQlMjAlM0QlMjAlMjJ5YmVsa2FkYSUyRm9wdC0zNTBtLWxvcmElMjIlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChwZWZ0X21vZGVsX2lkJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBsb2FkX2luXzhiaXQlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

peft_model_id = <span class="hljs-string">&quot;ybelkada/opt-350m-lora&quot;</span>
model = AutoModelForCausalLM.from_pretrained(peft_model_id, device_map=<span class="hljs-string">&quot;auto&quot;</span>, load_in_8bit=<span class="hljs-literal">True</span>)`,wrap:!1}}),Y=new J({props:{title:"Einen neuen Adapter hinzufügen",local:"einen-neuen-adapter-hinzufügen",headingTag:"h2"}}),D=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwT1BURm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0Q29uZmlnJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBJTBBbG9yYV9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycV9wcm9qJTIyJTJDJTIwJTIya19wcm9qJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwaW5pdF9sb3JhX3dlaWdodHMlM0RGYWxzZSUwQSklMEElMEFtb2RlbC5hZGRfYWRhcHRlcihsb3JhX2NvbmZpZyUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmFkYXB0ZXJfMSUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, OPTForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftConfig

model_id = <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>
model = AutoModelForCausalLM.from_pretrained(model_id)

lora_config = LoraConfig(
    target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>],
    init_lora_weights=<span class="hljs-literal">False</span>
)

model.add_adapter(lora_config, adapter_name=<span class="hljs-string">&quot;adapter_1&quot;</span>)`,wrap:!1}}),O=new h({props:{code:"JTIzJTIwYXR0YWNoJTIwbmV3JTIwYWRhcHRlciUyMHdpdGglMjBzYW1lJTIwY29uZmlnJTBBbW9kZWwuYWRkX2FkYXB0ZXIobG9yYV9jb25maWclMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJhZGFwdGVyXzIlMjIp",highlighted:`<span class="hljs-comment"># attach new adapter with same config</span>
model.add_adapter(lora_config, adapter_name=<span class="hljs-string">&quot;adapter_2&quot;</span>)`,wrap:!1}}),te=new h({props:{code:"JTIzJTIwdXNlJTIwYWRhcHRlcl8xJTBBbW9kZWwuc2V0X2FkYXB0ZXIoJTIyYWRhcHRlcl8xJTIyKSUwQW91dHB1dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzKSUwQXByaW50KHRva2VuaXplci5kZWNvZGUob3V0cHV0X2Rpc2FibGVkJTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSklMEElMEElMjMlMjB1c2UlMjBhZGFwdGVyXzIlMEFtb2RlbC5zZXRfYWRhcHRlciglMjJhZGFwdGVyXzIlMjIpJTBBb3V0cHV0X2VuYWJsZWQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFwcmludCh0b2tlbml6ZXIuZGVjb2RlKG91dHB1dF9lbmFibGVkJTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSk=",highlighted:`<span class="hljs-comment"># use adapter_1</span>
model.set_adapter(<span class="hljs-string">&quot;adapter_1&quot;</span>)
output = model.generate(**inputs)
<span class="hljs-built_in">print</span>(tokenizer.decode(output_disabled[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))

<span class="hljs-comment"># use adapter_2</span>
model.set_adapter(<span class="hljs-string">&quot;adapter_2&quot;</span>)
output_enabled = model.generate(**inputs)
<span class="hljs-built_in">print</span>(tokenizer.decode(output_enabled[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))`,wrap:!1}}),ne=new J({props:{title:"Aktivieren und Deaktivieren von Adaptern",local:"aktivieren-und-deaktivieren-von-adaptern",headingTag:"h2"}}),ae=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwT1BURm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0Q29uZmlnJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyJTBBYWRhcHRlcl9tb2RlbF9pZCUyMCUzRCUyMCUyMnliZWxrYWRhJTJGb3B0LTM1MG0tbG9yYSUyMiUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQXRleHQlMjAlM0QlMjAlMjJIZWxsbyUyMiUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcih0ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEFwZWZ0X2NvbmZpZyUyMCUzRCUyMFBlZnRDb25maWcuZnJvbV9wcmV0cmFpbmVkKGFkYXB0ZXJfbW9kZWxfaWQpJTBBJTBBJTIzJTIwdG8lMjBpbml0aWF0ZSUyMHdpdGglMjByYW5kb20lMjB3ZWlnaHRzJTBBcGVmdF9jb25maWcuaW5pdF9sb3JhX3dlaWdodHMlMjAlM0QlMjBGYWxzZSUwQSUwQW1vZGVsLmFkZF9hZGFwdGVyKHBlZnRfY29uZmlnKSUwQW1vZGVsLmVuYWJsZV9hZGFwdGVycygpJTBBb3V0cHV0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, OPTForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftConfig

model_id = <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>
adapter_model_id = <span class="hljs-string">&quot;ybelkada/opt-350m-lora&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_id)
text = <span class="hljs-string">&quot;Hello&quot;</span>
inputs = tokenizer(text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

model = AutoModelForCausalLM.from_pretrained(model_id)
peft_config = PeftConfig.from_pretrained(adapter_model_id)

<span class="hljs-comment"># to initiate with random weights</span>
peft_config.init_lora_weights = <span class="hljs-literal">False</span>

model.add_adapter(peft_config)
model.enable_adapters()
output = model.generate(**inputs)`,wrap:!1}}),se=new h({props:{code:"bW9kZWwuZGlzYWJsZV9hZGFwdGVycygpJTBBb3V0cHV0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMp",highlighted:`model.disable_adapters()
output = model.generate(**inputs)`,wrap:!1}}),re=new J({props:{title:"PEFT-Adapter trainieren",local:"peft-adapter-trainieren",headingTag:"h2"}}),T=new Et({props:{$$slots:{default:[qt]},$$scope:{ctx:Me}}}),oe=new h({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfZHJvcG91dCUzRDAuMSUyQyUwQSUyMCUyMCUyMCUyMHIlM0Q2NCUyQyUwQSUyMCUyMCUyMCUyMGJpYXMlM0QlMjJub25lJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGFza190eXBlJTNEJTIyQ0FVU0FMX0xNJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

peft_config = LoraConfig(
    lora_alpha=<span class="hljs-number">16</span>,
    lora_dropout=<span class="hljs-number">0.1</span>,
    r=<span class="hljs-number">64</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)`,wrap:!1}}),me=new h({props:{code:"bW9kZWwuYWRkX2FkYXB0ZXIocGVmdF9jb25maWcp",highlighted:"model.add_adapter(peft_config)",wrap:!1}}),fe=new h({props:{code:"dHJhaW5lciUyMCUzRCUyMFRyYWluZXIobW9kZWwlM0Rtb2RlbCUyQyUyMC4uLiklMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`trainer = Trainer(model=model, ...)
trainer.train()`,wrap:!1}}),be=new h({props:{code:"bW9kZWwuc2F2ZV9wcmV0cmFpbmVkKHNhdmVfZGlyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKHNhdmVfZGlyKQ==",highlighted:`model.save_pretrained(save_dir)
model = AutoModelForCausalLM.from_pretrained(save_dir)`,wrap:!1}}),{c(){d=s("meta"),g=a(),c=s("p"),y=a(),p(C.$$.fragment),ge=a(),p(Z.$$.fragment),ye=a(),_=s("p"),_.innerHTML=ut,$e=a(),U=s("p"),U.textContent=bt,we=a(),$=s("div"),$.innerHTML=Mt,Te=a(),F=s("p"),F.innerHTML=ct,ke=a(),p(W.$$.fragment),ve=a(),B=s("p"),B.textContent=ht,Je=a(),p(j.$$.fragment),Ce=a(),z=s("p"),z.textContent=gt,Ze=a(),p(R.$$.fragment),_e=a(),p(G.$$.fragment),Ue=a(),V=s("p"),V.textContent=yt,Fe=a(),H=s("ul"),H.innerHTML=$t,We=a(),E=s("p"),E.innerHTML=wt,Be=a(),p(A.$$.fragment),je=a(),X=s("p"),X.innerHTML=Tt,ze=a(),x=s("ol"),x.innerHTML=kt,Re=a(),p(L.$$.fragment),Ge=a(),p(w.$$.fragment),Ve=a(),S=s("p"),S.innerHTML=vt,He=a(),p(Q.$$.fragment),Ee=a(),p(I.$$.fragment),Ae=a(),N=s("p"),N.innerHTML=Jt,Xe=a(),p(P.$$.fragment),xe=a(),p(Y.$$.fragment),Le=a(),q=s("p"),q.innerHTML=Ct,Se=a(),p(D.$$.fragment),Qe=a(),K=s("p"),K.textContent=Zt,Ie=a(),p(O.$$.fragment),Ne=a(),ee=s("p"),ee.innerHTML=_t,Pe=a(),p(te.$$.fragment),Ye=a(),p(ne.$$.fragment),qe=a(),le=s("p"),le.textContent=Ut,De=a(),p(ae.$$.fragment),Ke=a(),ie=s("p"),ie.textContent=Ft,Oe=a(),p(se.$$.fragment),et=a(),p(re.$$.fragment),tt=a(),de=s("p"),de.innerHTML=Wt,nt=a(),p(T.$$.fragment),lt=a(),pe=s("ol"),pe.innerHTML=Bt,at=a(),p(oe.$$.fragment),it=a(),k=s("ol"),k.innerHTML=jt,st=a(),p(me.$$.fragment),rt=a(),v=s("ol"),v.innerHTML=zt,dt=a(),p(fe.$$.fragment),pt=a(),ue=s("p"),ue.textContent=Rt,ot=a(),p(be.$$.fragment),mt=a(),ce=s("p"),this.h()},l(e){const t=Qt("svelte-u9bgzb",document.head);d=r(t,"META",{name:!0,content:!0}),t.forEach(n),g=i(e),c=r(e,"P",{}),Ht(c).forEach(n),y=i(e),o(C.$$.fragment,e),ge=i(e),o(Z.$$.fragment,e),ye=i(e),_=r(e,"P",{"data-svelte-h":!0}),M(_)!=="svelte-hsx716"&&(_.innerHTML=ut),$e=i(e),U=r(e,"P",{"data-svelte-h":!0}),M(U)!=="svelte-oo13ds"&&(U.textContent=bt),we=i(e),$=r(e,"DIV",{class:!0,"data-svelte-h":!0}),M($)!=="svelte-c63tvn"&&($.innerHTML=Mt),Te=i(e),F=r(e,"P",{"data-svelte-h":!0}),M(F)!=="svelte-1x4iyf"&&(F.innerHTML=ct),ke=i(e),o(W.$$.fragment,e),ve=i(e),B=r(e,"P",{"data-svelte-h":!0}),M(B)!=="svelte-l2w44q"&&(B.textContent=ht),Je=i(e),o(j.$$.fragment,e),Ce=i(e),z=r(e,"P",{"data-svelte-h":!0}),M(z)!=="svelte-yjewq8"&&(z.textContent=gt),Ze=i(e),o(R.$$.fragment,e),_e=i(e),o(G.$$.fragment,e),Ue=i(e),V=r(e,"P",{"data-svelte-h":!0}),M(V)!=="svelte-n01ak8"&&(V.textContent=yt),Fe=i(e),H=r(e,"UL",{"data-svelte-h":!0}),M(H)!=="svelte-1ulyaf4"&&(H.innerHTML=$t),We=i(e),E=r(e,"P",{"data-svelte-h":!0}),M(E)!=="svelte-1hsc4d0"&&(E.innerHTML=wt),Be=i(e),o(A.$$.fragment,e),je=i(e),X=r(e,"P",{"data-svelte-h":!0}),M(X)!=="svelte-m03b6b"&&(X.innerHTML=Tt),ze=i(e),x=r(e,"OL",{"data-svelte-h":!0}),M(x)!=="svelte-1p7myyj"&&(x.innerHTML=kt),Re=i(e),o(L.$$.fragment,e),Ge=i(e),o(w.$$.fragment,e),Ve=i(e),S=r(e,"P",{"data-svelte-h":!0}),M(S)!=="svelte-d2kaw9"&&(S.innerHTML=vt),He=i(e),o(Q.$$.fragment,e),Ee=i(e),o(I.$$.fragment,e),Ae=i(e),N=r(e,"P",{"data-svelte-h":!0}),M(N)!=="svelte-1917vd5"&&(N.innerHTML=Jt),Xe=i(e),o(P.$$.fragment,e),xe=i(e),o(Y.$$.fragment,e),Le=i(e),q=r(e,"P",{"data-svelte-h":!0}),M(q)!=="svelte-n2ugt0"&&(q.innerHTML=Ct),Se=i(e),o(D.$$.fragment,e),Qe=i(e),K=r(e,"P",{"data-svelte-h":!0}),M(K)!=="svelte-1198s84"&&(K.textContent=Zt),Ie=i(e),o(O.$$.fragment,e),Ne=i(e),ee=r(e,"P",{"data-svelte-h":!0}),M(ee)!=="svelte-jt7cnj"&&(ee.innerHTML=_t),Pe=i(e),o(te.$$.fragment,e),Ye=i(e),o(ne.$$.fragment,e),qe=i(e),le=r(e,"P",{"data-svelte-h":!0}),M(le)!=="svelte-1h3vgmm"&&(le.textContent=Ut),De=i(e),o(ae.$$.fragment,e),Ke=i(e),ie=r(e,"P",{"data-svelte-h":!0}),M(ie)!=="svelte-14k4vtu"&&(ie.textContent=Ft),Oe=i(e),o(se.$$.fragment,e),et=i(e),o(re.$$.fragment,e),tt=i(e),de=r(e,"P",{"data-svelte-h":!0}),M(de)!=="svelte-tszlee"&&(de.innerHTML=Wt),nt=i(e),o(T.$$.fragment,e),lt=i(e),pe=r(e,"OL",{"data-svelte-h":!0}),M(pe)!=="svelte-ec6ptw"&&(pe.innerHTML=Bt),at=i(e),o(oe.$$.fragment,e),it=i(e),k=r(e,"OL",{start:!0,"data-svelte-h":!0}),M(k)!=="svelte-pjgoc8"&&(k.innerHTML=jt),st=i(e),o(me.$$.fragment,e),rt=i(e),v=r(e,"OL",{start:!0,"data-svelte-h":!0}),M(v)!=="svelte-1ihq60u"&&(v.innerHTML=zt),dt=i(e),o(fe.$$.fragment,e),pt=i(e),ue=r(e,"P",{"data-svelte-h":!0}),M(ue)!=="svelte-7lvzty"&&(ue.textContent=Rt),ot=i(e),o(be.$$.fragment,e),mt=i(e),ce=r(e,"P",{}),Ht(ce).forEach(n),this.h()},h(){he(d,"name","hf:doc:metadata"),he(d,"content",Kt),he($,"class","flex flex-col justify-center"),he(k,"start","2"),he(v,"start","3")},m(e,t){It(document.head,d),l(e,g,t),l(e,c,t),l(e,y,t),m(C,e,t),l(e,ge,t),m(Z,e,t),l(e,ye,t),l(e,_,t),l(e,$e,t),l(e,U,t),l(e,we,t),l(e,$,t),l(e,Te,t),l(e,F,t),l(e,ke,t),m(W,e,t),l(e,ve,t),l(e,B,t),l(e,Je,t),m(j,e,t),l(e,Ce,t),l(e,z,t),l(e,Ze,t),m(R,e,t),l(e,_e,t),m(G,e,t),l(e,Ue,t),l(e,V,t),l(e,Fe,t),l(e,H,t),l(e,We,t),l(e,E,t),l(e,Be,t),m(A,e,t),l(e,je,t),l(e,X,t),l(e,ze,t),l(e,x,t),l(e,Re,t),m(L,e,t),l(e,Ge,t),m(w,e,t),l(e,Ve,t),l(e,S,t),l(e,He,t),m(Q,e,t),l(e,Ee,t),m(I,e,t),l(e,Ae,t),l(e,N,t),l(e,Xe,t),m(P,e,t),l(e,xe,t),m(Y,e,t),l(e,Le,t),l(e,q,t),l(e,Se,t),m(D,e,t),l(e,Qe,t),l(e,K,t),l(e,Ie,t),m(O,e,t),l(e,Ne,t),l(e,ee,t),l(e,Pe,t),m(te,e,t),l(e,Ye,t),m(ne,e,t),l(e,qe,t),l(e,le,t),l(e,De,t),m(ae,e,t),l(e,Ke,t),l(e,ie,t),l(e,Oe,t),m(se,e,t),l(e,et,t),m(re,e,t),l(e,tt,t),l(e,de,t),l(e,nt,t),m(T,e,t),l(e,lt,t),l(e,pe,t),l(e,at,t),m(oe,e,t),l(e,it,t),l(e,k,t),l(e,st,t),m(me,e,t),l(e,rt,t),l(e,v,t),l(e,dt,t),m(fe,e,t),l(e,pt,t),l(e,ue,t),l(e,ot,t),m(be,e,t),l(e,mt,t),l(e,ce,t),ft=!0},p(e,[t]){const Gt={};t&2&&(Gt.$$scope={dirty:t,ctx:e}),w.$set(Gt);const Vt={};t&2&&(Vt.$$scope={dirty:t,ctx:e}),T.$set(Vt)},i(e){ft||(f(C.$$.fragment,e),f(Z.$$.fragment,e),f(W.$$.fragment,e),f(j.$$.fragment,e),f(R.$$.fragment,e),f(G.$$.fragment,e),f(A.$$.fragment,e),f(L.$$.fragment,e),f(w.$$.fragment,e),f(Q.$$.fragment,e),f(I.$$.fragment,e),f(P.$$.fragment,e),f(Y.$$.fragment,e),f(D.$$.fragment,e),f(O.$$.fragment,e),f(te.$$.fragment,e),f(ne.$$.fragment,e),f(ae.$$.fragment,e),f(se.$$.fragment,e),f(re.$$.fragment,e),f(T.$$.fragment,e),f(oe.$$.fragment,e),f(me.$$.fragment,e),f(fe.$$.fragment,e),f(be.$$.fragment,e),ft=!0)},o(e){u(C.$$.fragment,e),u(Z.$$.fragment,e),u(W.$$.fragment,e),u(j.$$.fragment,e),u(R.$$.fragment,e),u(G.$$.fragment,e),u(A.$$.fragment,e),u(L.$$.fragment,e),u(w.$$.fragment,e),u(Q.$$.fragment,e),u(I.$$.fragment,e),u(P.$$.fragment,e),u(Y.$$.fragment,e),u(D.$$.fragment,e),u(O.$$.fragment,e),u(te.$$.fragment,e),u(ne.$$.fragment,e),u(ae.$$.fragment,e),u(se.$$.fragment,e),u(re.$$.fragment,e),u(T.$$.fragment,e),u(oe.$$.fragment,e),u(me.$$.fragment,e),u(fe.$$.fragment,e),u(be.$$.fragment,e),ft=!1},d(e){e&&(n(g),n(c),n(y),n(ge),n(ye),n(_),n($e),n(U),n(we),n($),n(Te),n(F),n(ke),n(ve),n(B),n(Je),n(Ce),n(z),n(Ze),n(_e),n(Ue),n(V),n(Fe),n(H),n(We),n(E),n(Be),n(je),n(X),n(ze),n(x),n(Re),n(Ge),n(Ve),n(S),n(He),n(Ee),n(Ae),n(N),n(Xe),n(xe),n(Le),n(q),n(Se),n(Qe),n(K),n(Ie),n(Ne),n(ee),n(Pe),n(Ye),n(qe),n(le),n(De),n(Ke),n(ie),n(Oe),n(et),n(tt),n(de),n(nt),n(lt),n(pe),n(at),n(it),n(k),n(st),n(rt),n(v),n(dt),n(pt),n(ue),n(ot),n(mt),n(ce)),n(d),b(C,e),b(Z,e),b(W,e),b(j,e),b(R,e),b(G,e),b(A,e),b(L,e),b(w,e),b(Q,e),b(I,e),b(P,e),b(Y,e),b(D,e),b(O,e),b(te,e),b(ne,e),b(ae,e),b(se,e),b(re,e),b(T,e),b(oe,e),b(me,e),b(fe,e),b(be,e)}}}const Kt='{"title":"Adapter mit 🤗 PEFT laden","local":"adapter-mit--peft-laden","sections":[{"title":"Setup","local":"setup","sections":[],"depth":2},{"title":"Unterstützte PEFT-Modelle","local":"unterstützte-peft-modelle","sections":[],"depth":2},{"title":"Laden Sie einen PEFT-Adapter","local":"laden-sie-einen-peft-adapter","sections":[],"depth":2},{"title":"Laden in 8bit oder 4bit","local":"laden-in-8bit-oder-4bit","sections":[],"depth":2},{"title":"Einen neuen Adapter hinzufügen","local":"einen-neuen-adapter-hinzufügen","sections":[],"depth":2},{"title":"Aktivieren und Deaktivieren von Adaptern","local":"aktivieren-und-deaktivieren-von-adaptern","sections":[],"depth":2},{"title":"PEFT-Adapter trainieren","local":"peft-adapter-trainieren","sections":[],"depth":2}],"depth":1}';function Ot(Me){return xt(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=Nt}),[]}class rn extends Lt{constructor(d){super(),St(this,d,Ot,Dt,Xt,{})}}export{rn as component};
