import{s as Rt,o as Ht,n as $e}from"../chunks/scheduler.defa9a21.js";import{S as Yt,i as Vt,g as $,s as c,r as f,A as Bt,h as g,f as a,c as n,j as At,u,x as T,k as Wt,y as zt,a as l,v as h,d as y,t as M,w}from"../chunks/index.fe795e71.js";import{T as st}from"../chunks/Tip.179eb360.js";import{C as k}from"../chunks/CodeBlock.204b6c34.js";import{H as C,E as xt}from"../chunks/index.d995652d.js";import{H as Ft,a as Xt}from"../chunks/HfOption.3c290b0f.js";function Qt(J){let r,b="Accelerate only prepares objects that inherit from their respective PyTorch classes such as <code>torch.optim.Optimizer</code>.";return{c(){r=$("p"),r.innerHTML=b},l(o){r=g(o,"P",{"data-svelte-h":!0}),T(r)!=="svelte-1oh2ah6"&&(r.innerHTML=b)},m(o,m){l(o,r,m)},p:$e,d(o){o&&a(r)}}}function St(J){let r,b='Accelerate enables automatic mixed precision, so <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.autocast">autocast()</a> is only needed if there are other mixed precision operations besides those performed on loss by <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.backward">backward()</a> which already handles the scaling.';return{c(){r=$("p"),r.innerHTML=b},l(o){r=g(o,"P",{"data-svelte-h":!0}),T(r)!=="svelte-17p4of7"&&(r.innerHTML=b)},m(o,m){l(o,r,m)},p:$e,d(o){o&&a(r)}}}function Nt(J){let r,b='For models from the <a href="https://hf.co/docs/transformers/index" rel="nofollow">Transformers</a> library, save the model with the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.save_pretrained" rel="nofollow">save_pretrained</a> method so that it can be reloaded with the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained" rel="nofollow">from_pretrained</a> method.',o,m,i;return m=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQSUwQXVud3JhcHBlZF9tb2RlbCUyMCUzRCUyMGFjY2VsZXJhdG9yLnVud3JhcF9tb2RlbChtb2RlbCklMEF1bndyYXBwZWRfbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnBhdGglMkZ0byUyRm15X21vZGVsX2RpcmVjdG9yeSUyMiUyQyUwQSUyMCUyMCUyMCUyMGlzX21haW5fcHJvY2VzcyUzRGFjY2VsZXJhdG9yLmlzX21haW5fcHJvY2VzcyUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfZnVuY3Rpb24lM0RhY2NlbGVyYXRvci5zYXZlJTJDJTBBKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJwYXRoJTJGdG8lMkZteV9tb2RlbF9kaXJlY3RvcnklMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel

unwrapped_model = accelerator.unwrap_model(model)
unwrapped_model.save_pretrained(
    <span class="hljs-string">&quot;path/to/my_model_directory&quot;</span>,
    is_main_process=accelerator.is_main_process,
    save_function=accelerator.save,
)

model = AutoModel.from_pretrained(<span class="hljs-string">&quot;path/to/my_model_directory&quot;</span>)`,wrap:!1}}),{c(){r=$("p"),r.innerHTML=b,o=c(),f(m.$$.fragment)},l(d){r=g(d,"P",{"data-svelte-h":!0}),T(r)!=="svelte-y3y63b"&&(r.innerHTML=b),o=n(d),u(m.$$.fragment,d)},m(d,_){l(d,r,_),l(d,o,_),h(m,d,_),i=!0},p:$e,i(d){i||(y(m.$$.fragment,d),i=!0)},o(d){M(m.$$.fragment,d),i=!1},d(d){d&&(a(r),a(o)),w(m,d)}}}function Lt(J){let r,b,o,m,i,d='To load your weights, use the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.unwrap_model">unwrap_model()</a> method to unwrap the model first before loading the weights. All model parameters are references to tensors, so this loads your weights inside <code>model</code>.',_,U,v;return r=new k({props:{code:"YWNjZWxlcmF0b3Iud2FpdF9mb3JfZXZlcnlvbmUoKSUwQWFjY2VsZXJhdG9yLnNhdmVfbW9kZWwobW9kZWwlMkMlMjBzYXZlX2RpcmVjdG9yeSk=",highlighted:`accelerator.wait_for_everyone()
accelerator.save_model(model, save_directory)`,wrap:!1}}),o=new st({props:{$$slots:{default:[Nt]},$$scope:{ctx:J}}}),U=new k({props:{code:"dW53cmFwcGVkX21vZGVsJTIwJTNEJTIwYWNjZWxlcmF0b3IudW53cmFwX21vZGVsKG1vZGVsKSUwQXBhdGhfdG9fY2hlY2twb2ludCUyMCUzRCUyMG9zLnBhdGguam9pbihzYXZlX2RpcmVjdG9yeSUyQyUyMnB5dG9yY2hfbW9kZWwuYmluJTIyKSUwQXVud3JhcHBlZF9tb2RlbC5sb2FkX3N0YXRlX2RpY3QodG9yY2gubG9hZChwYXRoX3RvX2NoZWNrcG9pbnQpKQ==",highlighted:`unwrapped_model = accelerator.unwrap_model(model)
path_to_checkpoint = os.path.join(save_directory,<span class="hljs-string">&quot;pytorch_model.bin&quot;</span>)
unwrapped_model.load_state_dict(torch.load(path_to_checkpoint))`,wrap:!1}}),{c(){f(r.$$.fragment),b=c(),f(o.$$.fragment),m=c(),i=$("p"),i.innerHTML=d,_=c(),f(U.$$.fragment)},l(s){u(r.$$.fragment,s),b=n(s),u(o.$$.fragment,s),m=n(s),i=g(s,"P",{"data-svelte-h":!0}),T(i)!=="svelte-js2qkb"&&(i.innerHTML=d),_=n(s),u(U.$$.fragment,s)},m(s,p){h(r,s,p),l(s,b,p),h(o,s,p),l(s,m,p),l(s,i,p),l(s,_,p),h(U,s,p),v=!0},p(s,p){const j={};p&2&&(j.$$scope={dirty:p,ctx:s}),o.$set(j)},i(s){v||(y(r.$$.fragment,s),y(o.$$.fragment,s),y(U.$$.fragment,s),v=!0)},o(s){M(r.$$.fragment,s),M(o.$$.fragment,s),M(U.$$.fragment,s),v=!1},d(s){s&&(a(b),a(m),a(i),a(_)),w(r,s),w(o,s),w(U,s)}}}function Pt(J){let r,b="Set <code>safe_serialization=True</code> to save the model in the safetensor format.",o,m,i,d,_='To load a sharded checkpoint or a safetensor formatted checkpoint, use the <a href="/docs/accelerate/main/en/package_reference/big_modeling#accelerate.load_checkpoint_in_model">load_checkpoint_in_model()</a> method. This method allows you to load a checkpoint onto a specific device.',U,v,s;return m=new k({props:{code:"YWNjZWxlcmF0b3Iud2FpdF9mb3JfZXZlcnlvbmUoKSUwQWFjY2VsZXJhdG9yLnNhdmVfbW9kZWwobW9kZWwlMkMlMjBzYXZlX2RpcmVjdG9yeSUyQyUyMG1heF9zaGFyZF9zaXplJTNEJTIyMUdCJTIyJTJDJTIwc2FmZV9zZXJpYWxpemF0aW9uJTNEVHJ1ZSk=",highlighted:`accelerator.wait_for_everyone()
accelerator.save_model(model, save_directory, max_shard_size=<span class="hljs-string">&quot;1GB&quot;</span>, safe_serialization=<span class="hljs-literal">True</span>)`,wrap:!1}}),v=new k({props:{code:"bG9hZF9jaGVja3BvaW50X2luX21vZGVsKHVud3JhcHBlZF9tb2RlbCUyQyUyMHNhdmVfZGlyZWN0b3J5JTJDJTIwZGV2aWNlX21hcCUzRCU3QiUyMiUyMiUzQWRldmljZSU3RCk=",highlighted:'load_checkpoint_in_model(unwrapped_model, save_directory, device_map={<span class="hljs-string">&quot;&quot;</span>:device})',wrap:!1}}),{c(){r=$("p"),r.innerHTML=b,o=c(),f(m.$$.fragment),i=c(),d=$("p"),d.innerHTML=_,U=c(),f(v.$$.fragment)},l(p){r=g(p,"P",{"data-svelte-h":!0}),T(r)!=="svelte-jahj75"&&(r.innerHTML=b),o=n(p),u(m.$$.fragment,p),i=n(p),d=g(p,"P",{"data-svelte-h":!0}),T(d)!=="svelte-70qodr"&&(d.innerHTML=_),U=n(p),u(v.$$.fragment,p)},m(p,j){l(p,r,j),l(p,o,j),h(m,p,j),l(p,i,j),l(p,d,j),l(p,U,j),h(v,p,j),s=!0},p:$e,i(p){s||(y(m.$$.fragment,p),y(v.$$.fragment,p),s=!0)},o(p){M(m.$$.fragment,p),M(v.$$.fragment,p),s=!1},d(p){p&&(a(r),a(o),a(i),a(d),a(U)),w(m,p),w(v,p)}}}function Et(J){let r,b,o,m;return r=new Xt({props:{id:"save",option:"single checkpoint",$$slots:{default:[Lt]},$$scope:{ctx:J}}}),o=new Xt({props:{id:"save",option:"sharded checkpoint",$$slots:{default:[Pt]},$$scope:{ctx:J}}}),{c(){f(r.$$.fragment),b=c(),f(o.$$.fragment)},l(i){u(r.$$.fragment,i),b=n(i),u(o.$$.fragment,i)},m(i,d){h(r,i,d),l(i,b,d),h(o,i,d),m=!0},p(i,d){const _={};d&2&&(_.$$scope={dirty:d,ctx:i}),r.$set(_);const U={};d&2&&(U.$$scope={dirty:d,ctx:i}),o.$set(U)},i(i){m||(y(r.$$.fragment,i),y(o.$$.fragment,i),m=!0)},o(i){M(r.$$.fragment,i),M(o.$$.fragment,i),m=!1},d(i){i&&a(b),w(r,i),w(o,i)}}}function Kt(J){let r,b='If you have <a href="https://github.com/pytorch/data/tree/main" rel="nofollow"><code>torchdata&gt;=0.8.0</code></a> installed, you can additionally pass <code>use_stateful_dataloader=True</code> into your <a href="/docs/accelerate/main/en/package_reference/utilities#accelerate.DataLoaderConfiguration">DataLoaderConfiguration</a>. This extends Accelerate’s DataLoader classes with a <code>load_state_dict</code> and <code>state_dict</code> function, and makes it so <code>Accelerator.save_state</code> and <code>Accelerator.load_state</code> also track how far into the training dataset it has read when persisting the model.';return{c(){r=$("p"),r.innerHTML=b},l(o){r=g(o,"P",{"data-svelte-h":!0}),T(r)!=="svelte-31z922"&&(r.innerHTML=b)},m(o,m){l(o,r,m)},p:$e,d(o){o&&a(r)}}}function qt(J){let r,b,o,m,i,d,_,U="Each distributed training framework has their own way of doing things which can require writing a lot of custom code to adapt it to your PyTorch training code and training environment. Accelerate offers a friendly way to interface with these distributed training frameworks without having to learn the specific details of each one. Accelerate takes care of those details for you, so you can focus on the training code and scale it to any distributed training environment.",v,s,p="In this tutorial, you’ll learn how to adapt your existing PyTorch code with Accelerate and get you on your way toward training on distributed systems with ease! You’ll start with a basic PyTorch training loop (it assumes all the training objects like <code>model</code> and <code>optimizer</code> have been setup already) and progressively integrate Accelerate into it.",j,W,ge,X,be,R,dt='The <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> is the main class for adapting your code to work with Accelerate. It knows about the distributed setup you’re using such as the number of different processes and your hardware type. This class also provides access to many of the necessary methods for enabling your PyTorch code to work in any distributed training environment and for managing and executing processes across devices.',Te,H,pt='That’s why you should always start by importing and creating an <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> instance in your script.',_e,Y,Ue,V,mt='The <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> also knows which device to move your PyTorch objects to, so it is recommended to let Accelerate handle this for you.',ve,B,Je,z,je,x,ft='Next, you need to prepare your PyTorch objects (model, optimizer, scheduler, etc.) for distributed training. The <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.prepare">prepare()</a> method takes care of placing your model in the appropriate container (like single GPU or multi-GPU) for your training setup, adapting the optimizer and scheduler to use Accelerate’s <a href="/docs/accelerate/main/en/package_reference/torch_wrappers#accelerate.optimizer.AcceleratedOptimizer">AcceleratedOptimizer</a> and <a href="/docs/accelerate/main/en/package_reference/torch_wrappers#accelerate.scheduler.AcceleratedScheduler">AcceleratedScheduler</a>, and creating a new dataloader that can be sharded across processes.',ke,G,Ce,F,ut="The PyTorch objects are returned in the same order they’re sent.",Ge,Q,Ze,S,Ie,N,ht='Finally, remove the <code>to(device)</code> calls to the inputs and targets in the training loop because Accelerate’s DataLoader classes automatically places them on the right device. You should also replace the usual <code>backward()</code> pass with Accelerate’s <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.backward">backward()</a> method which scales the gradients for you and uses the appropriate <code>backward()</code> method depending on your distributed setup (for example, DeepSpeed or Megatron).',Ae,L,We,P,yt="Put everything together and your new Accelerate training loop should now look like this!",Xe,E,Re,K,He,q,Mt="Accelerate offers additional features - like gradient accumulation, gradient clipping, mixed precision training and more - you can add to your script to improve your training run. Let’s explore these three features.",Ye,D,Ve,O,wt='Gradient accumulation enables you to train on larger batch sizes by accumulating the gradients over multiple batches before updating the weights. This can be useful for getting around memory limitations. To enable this feature in Accelerate, specify the <code>gradient_accumulation_steps</code> parameter in the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> class and add the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.accumulate">accumulate()</a> context manager to your script.',Be,ee,ze,te,xe,ae,$t="Gradient clipping is a technique to prevent “exploding gradients”, and Accelerate offers:",Fe,le,gt='<li><a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.clip_grad_value_">clip<em>grad_value</em>()</a> to clip gradients to a minimum and maximum value</li> <li><a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.clip_grad_norm_">clip<em>grad_norm</em>()</a> for normalizing gradients to a certain value</li>',Qe,re,Se,ce,bt="Mixed precision accelerates training by using a lower precision data type like fp16 (half-precision) to calculate the gradients. For the best performance with Accelerate, the loss should be computed inside your model (like in Transformers models) because computations outside of the model are computed in full precision.",Ne,ne,Tt='Set the mixed precision type to use in the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a>, and then use the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.autocast">autocast()</a> context manager to automatically cast the values to the specified data type.',Le,Z,Pe,oe,Ee,ie,Ke,se,_t="Accelerate can also save and load a <em>model</em> once training is complete or you can also save the model and optimizer <em>state</em> which could be useful for resuming training.",qe,de,De,pe,Ut='Once all processes are complete, unwrap the model with the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.unwrap_model">unwrap_model()</a> method before saving it because the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.prepare">prepare()</a> method wrapped your model into the proper interface for distributed training. If you don’t unwrap the model, saving the model state dictionary also saves any potential extra layers from the larger model and you won’t be able to load the weights back into your base model.',Oe,me,vt='You should use the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.save_model">save_model()</a> method to unwrap and save the model state dictionary. This method can also save a model into sharded checkpoints or into the <a href="https://hf.co/docs/safetensors/index" rel="nofollow">safetensors</a> format.',et,I,tt,fe,at,ue,Jt='During training, you may want to save the current state of the model, optimizer, random generators, and potentially learning rate schedulers so they can be restored in the <em>same script</em>. You should add the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.save_state">save_state()</a> and <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.load_state">load_state()</a> methods to your script to save and load states.',lt,he,jt='To further customize where and how states are saved through <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.save_state">save_state()</a>, use the <a href="/docs/accelerate/main/en/package_reference/utilities#accelerate.utils.ProjectConfiguration">ProjectConfiguration</a> class. For example, if <code>automatic_checkpoint_naming</code> is enabled, each saved checkpoint is stored at <code>Accelerator.project_dir/checkpoints/checkpoint_{checkpoint_number}</code>.',rt,ye,kt='Any other stateful items to be stored should be registered with the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.register_for_checkpointing">register_for_checkpointing()</a> method so they can be saved and loaded. Every object passed to this method to be stored must have a <code>load_state_dict</code> and <code>state_dict</code> function.',ct,A,nt,Me,ot,we,it;return i=new C({props:{title:"Add Accelerate to your code",local:"add-accelerate-to-your-code",headingTag:"h1"}}),W=new k({props:{code:"ZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUwQW1vZGVsLnRvKGRldmljZSklMEElMEFmb3IlMjBiYXRjaCUyMGluJTIwdHJhaW5pbmdfZGF0YWxvYWRlciUzQSUwQSUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKSUwQSUyMCUyMCUyMCUyMGlucHV0cyUyQyUyMHRhcmdldHMlMjAlM0QlMjBiYXRjaCUwQSUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMGlucHV0cy50byhkZXZpY2UpJTBBJTIwJTIwJTIwJTIwdGFyZ2V0cyUyMCUzRCUyMHRhcmdldHMudG8oZGV2aWNlKSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbChpbnB1dHMpJTBBJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMGxvc3NfZnVuY3Rpb24ob3V0cHV0cyUyQyUyMHRhcmdldHMpJTBBJTIwJTIwJTIwJTIwbG9zcy5iYWNrd2FyZCgpJTBBJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMHNjaGVkdWxlci5zdGVwKCk=",highlighted:`device = <span class="hljs-string">&quot;cuda&quot;</span>
model.to(device)

<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> training_dataloader:
    optimizer.zero_grad()
    inputs, targets = batch
    inputs = inputs.to(device)
    targets = targets.to(device)
    outputs = model(inputs)
    loss = loss_function(outputs, targets)
    loss.backward()
    optimizer.step()
    scheduler.step()`,wrap:!1}}),X=new C({props:{title:"Accelerator",local:"accelerator",headingTag:"h2"}}),Y=new k({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

accelerator = Accelerator()`,wrap:!1}}),B=new k({props:{code:"LSUyMGRldmljZSUyMCUzRCUyMCUyMmN1ZGElMjIlMEElMkIlMjBkZXZpY2UlMjAlM0QlMjBhY2NlbGVyYXRvci5kZXZpY2UlMEElMjAlMjBtb2RlbC50byhkZXZpY2Up",highlighted:`<span class="hljs-deletion">- device = &quot;cuda&quot;</span>
<span class="hljs-addition">+ device = accelerator.device</span>
  model.to(device)`,wrap:!1}}),z=new C({props:{title:"Prepare PyTorch objects",local:"prepare-pytorch-objects",headingTag:"h2"}}),G=new st({props:{warning:!1,$$slots:{default:[Qt]},$$scope:{ctx:J}}}),Q=new k({props:{code:"bW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjB0cmFpbmluZ19kYXRhbG9hZGVyJTJDJTIwc2NoZWR1bGVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZSglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUyMG9wdGltaXplciUyQyUyMHRyYWluaW5nX2RhdGFsb2FkZXIlMkMlMjBzY2hlZHVsZXIlMEEp",highlighted:`model, optimizer, training_dataloader, scheduler = accelerator.prepare(
    model, optimizer, training_dataloader, scheduler
)`,wrap:!1}}),S=new C({props:{title:"Training loop",local:"training-loop",headingTag:"h2"}}),L=new k({props:{code:"LSUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMGlucHV0cy50byhkZXZpY2UpJTBBLSUyMCUyMCUyMHRhcmdldHMlMjAlM0QlMjB0YXJnZXRzLnRvKGRldmljZSklMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoaW5wdXRzKSUwQSUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBsb3NzX2Z1bmN0aW9uKG91dHB1dHMlMkMlMjB0YXJnZXRzKSUwQS0lMjAlMjAlMjBsb3NzLmJhY2t3YXJkKCklMEElMkIlMjAlMjAlMjBhY2NlbGVyYXRvci5iYWNrd2FyZChsb3NzKQ==",highlighted:`<span class="hljs-deletion">-   inputs = inputs.to(device)</span>
<span class="hljs-deletion">-   targets = targets.to(device)</span>
    outputs = model(inputs)
    loss = loss_function(outputs, targets)
<span class="hljs-deletion">-   loss.backward()</span>
<span class="hljs-addition">+   accelerator.backward(loss)</span>`,wrap:!1}}),E=new k({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQSUwQWRldmljZSUyMCUzRCUyMGFjY2VsZXJhdG9yLmRldmljZSUwQW1vZGVsJTJDJTIwb3B0aW1pemVyJTJDJTIwdHJhaW5pbmdfZGF0YWxvYWRlciUyQyUyMHNjaGVkdWxlciUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjB0cmFpbmluZ19kYXRhbG9hZGVyJTJDJTIwc2NoZWR1bGVyJTBBKSUwQSUwQWZvciUyMGJhdGNoJTIwaW4lMjB0cmFpbmluZ19kYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwb3B0aW1pemVyLnplcm9fZ3JhZCgpJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTJDJTIwdGFyZ2V0cyUyMCUzRCUyMGJhdGNoJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0cyklMEElMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwbG9zc19mdW5jdGlvbihvdXRwdXRzJTJDJTIwdGFyZ2V0cyklMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvci5iYWNrd2FyZChsb3NzKSUwQSUyMCUyMCUyMCUyMG9wdGltaXplci5zdGVwKCklMEElMjAlMjAlMjAlMjBzY2hlZHVsZXIuc3RlcCgp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
accelerator = Accelerator()

device = accelerator.device
model, optimizer, training_dataloader, scheduler = accelerator.prepare(
    model, optimizer, training_dataloader, scheduler
)

<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> training_dataloader:
    optimizer.zero_grad()
    inputs, targets = batch
    outputs = model(inputs)
    loss = loss_function(outputs, targets)
    accelerator.backward(loss)
    optimizer.step()
    scheduler.step()`,wrap:!1}}),K=new C({props:{title:"Training features",local:"training-features",headingTag:"h2"}}),D=new C({props:{title:"Gradient accumulation",local:"gradient-accumulation",headingTag:"h3"}}),ee=new k({props:{code:"JTJCJTIwYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcihncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0QyKSUwQSUyMCUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTJDJTIwdHJhaW5pbmdfZGF0YWxvYWRlciUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUobW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjB0cmFpbmluZ19kYXRhbG9hZGVyKSUwQSUwQSUyMCUyMGZvciUyMGlucHV0JTJDJTIwbGFiZWwlMjBpbiUyMHRyYWluaW5nX2RhdGFsb2FkZXIlM0ElMEElMkIlMjAlMjAlMjAlMjAlMjB3aXRoJTIwYWNjZWxlcmF0b3IuYWNjdW11bGF0ZShtb2RlbCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmVkaWN0aW9ucyUyMCUzRCUyMG1vZGVsKGlucHV0KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBsb3NzX2Z1bmN0aW9uKHByZWRpY3Rpb25zJTJDJTIwbGFiZWwpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3IuYmFja3dhcmQobG9zcyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2NoZWR1bGVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKQ==",highlighted:`<span class="hljs-addition">+ accelerator = Accelerator(gradient_accumulation_steps=2)</span>
  model, optimizer, training_dataloader = accelerator.prepare(model, optimizer, training_dataloader)

  for input, label in training_dataloader:
<span class="hljs-addition">+     with accelerator.accumulate(model):</span>
          predictions = model(input)
          loss = loss_function(predictions, label)
          accelerator.backward(loss)
          optimizer.step()
          scheduler.step()
          optimizer.zero_grad()`,wrap:!1}}),te=new C({props:{title:"Gradient clipping",local:"gradient-clipping",headingTag:"h3"}}),re=new C({props:{title:"Mixed precision",local:"mixed-precision",headingTag:"h3"}}),Z=new st({props:{warning:!0,$$slots:{default:[St]},$$scope:{ctx:J}}}),oe=new k({props:{code:"JTJCJTIwYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcihtaXhlZF9wcmVjaXNpb24lM0QlMjJmcDE2JTIyKSUwQSUyQiUyMHdpdGglMjBhY2NlbGVyYXRvci5hdXRvY2FzdCgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMGNvbXBsZXhfbG9zc19mdW5jdGlvbihvdXRwdXRzJTJDJTIwdGFyZ2V0KQ==",highlighted:`<span class="hljs-addition">+ accelerator = Accelerator(mixed_precision=&quot;fp16&quot;)</span>
<span class="hljs-addition">+ with accelerator.autocast():</span>
      loss = complex_loss_function(outputs, target)`,wrap:!1}}),ie=new C({props:{title:"Save and load",local:"save-and-load",headingTag:"h2"}}),de=new C({props:{title:"Model",local:"model",headingTag:"h3"}}),I=new Ft({props:{id:"save",options:["single checkpoint","sharded checkpoint"],$$slots:{default:[Et]},$$scope:{ctx:J}}}),fe=new C({props:{title:"State",local:"state",headingTag:"h3"}}),A=new st({props:{warning:!1,$$slots:{default:[Kt]},$$scope:{ctx:J}}}),Me=new xt({props:{source:"https://github.com/huggingface/accelerate/blob/main/docs/source/basic_tutorials/migration.md"}}),{c(){r=$("meta"),b=c(),o=$("p"),m=c(),f(i.$$.fragment),d=c(),_=$("p"),_.textContent=U,v=c(),s=$("p"),s.innerHTML=p,j=c(),f(W.$$.fragment),ge=c(),f(X.$$.fragment),be=c(),R=$("p"),R.innerHTML=dt,Te=c(),H=$("p"),H.innerHTML=pt,_e=c(),f(Y.$$.fragment),Ue=c(),V=$("p"),V.innerHTML=mt,ve=c(),f(B.$$.fragment),Je=c(),f(z.$$.fragment),je=c(),x=$("p"),x.innerHTML=ft,ke=c(),f(G.$$.fragment),Ce=c(),F=$("p"),F.textContent=ut,Ge=c(),f(Q.$$.fragment),Ze=c(),f(S.$$.fragment),Ie=c(),N=$("p"),N.innerHTML=ht,Ae=c(),f(L.$$.fragment),We=c(),P=$("p"),P.textContent=yt,Xe=c(),f(E.$$.fragment),Re=c(),f(K.$$.fragment),He=c(),q=$("p"),q.textContent=Mt,Ye=c(),f(D.$$.fragment),Ve=c(),O=$("p"),O.innerHTML=wt,Be=c(),f(ee.$$.fragment),ze=c(),f(te.$$.fragment),xe=c(),ae=$("p"),ae.textContent=$t,Fe=c(),le=$("ul"),le.innerHTML=gt,Qe=c(),f(re.$$.fragment),Se=c(),ce=$("p"),ce.textContent=bt,Ne=c(),ne=$("p"),ne.innerHTML=Tt,Le=c(),f(Z.$$.fragment),Pe=c(),f(oe.$$.fragment),Ee=c(),f(ie.$$.fragment),Ke=c(),se=$("p"),se.innerHTML=_t,qe=c(),f(de.$$.fragment),De=c(),pe=$("p"),pe.innerHTML=Ut,Oe=c(),me=$("p"),me.innerHTML=vt,et=c(),f(I.$$.fragment),tt=c(),f(fe.$$.fragment),at=c(),ue=$("p"),ue.innerHTML=Jt,lt=c(),he=$("p"),he.innerHTML=jt,rt=c(),ye=$("p"),ye.innerHTML=kt,ct=c(),f(A.$$.fragment),nt=c(),f(Me.$$.fragment),ot=c(),we=$("p"),this.h()},l(e){const t=Bt("svelte-u9bgzb",document.head);r=g(t,"META",{name:!0,content:!0}),t.forEach(a),b=n(e),o=g(e,"P",{}),At(o).forEach(a),m=n(e),u(i.$$.fragment,e),d=n(e),_=g(e,"P",{"data-svelte-h":!0}),T(_)!=="svelte-19zbp5z"&&(_.textContent=U),v=n(e),s=g(e,"P",{"data-svelte-h":!0}),T(s)!=="svelte-1lmjen8"&&(s.innerHTML=p),j=n(e),u(W.$$.fragment,e),ge=n(e),u(X.$$.fragment,e),be=n(e),R=g(e,"P",{"data-svelte-h":!0}),T(R)!=="svelte-1dn1lk2"&&(R.innerHTML=dt),Te=n(e),H=g(e,"P",{"data-svelte-h":!0}),T(H)!=="svelte-zcqlut"&&(H.innerHTML=pt),_e=n(e),u(Y.$$.fragment,e),Ue=n(e),V=g(e,"P",{"data-svelte-h":!0}),T(V)!=="svelte-1csx4md"&&(V.innerHTML=mt),ve=n(e),u(B.$$.fragment,e),Je=n(e),u(z.$$.fragment,e),je=n(e),x=g(e,"P",{"data-svelte-h":!0}),T(x)!=="svelte-wqk9uz"&&(x.innerHTML=ft),ke=n(e),u(G.$$.fragment,e),Ce=n(e),F=g(e,"P",{"data-svelte-h":!0}),T(F)!=="svelte-l5v2wx"&&(F.textContent=ut),Ge=n(e),u(Q.$$.fragment,e),Ze=n(e),u(S.$$.fragment,e),Ie=n(e),N=g(e,"P",{"data-svelte-h":!0}),T(N)!=="svelte-i5xqdp"&&(N.innerHTML=ht),Ae=n(e),u(L.$$.fragment,e),We=n(e),P=g(e,"P",{"data-svelte-h":!0}),T(P)!=="svelte-1b6tm11"&&(P.textContent=yt),Xe=n(e),u(E.$$.fragment,e),Re=n(e),u(K.$$.fragment,e),He=n(e),q=g(e,"P",{"data-svelte-h":!0}),T(q)!=="svelte-1ef6475"&&(q.textContent=Mt),Ye=n(e),u(D.$$.fragment,e),Ve=n(e),O=g(e,"P",{"data-svelte-h":!0}),T(O)!=="svelte-1nruvdz"&&(O.innerHTML=wt),Be=n(e),u(ee.$$.fragment,e),ze=n(e),u(te.$$.fragment,e),xe=n(e),ae=g(e,"P",{"data-svelte-h":!0}),T(ae)!=="svelte-bg95gl"&&(ae.textContent=$t),Fe=n(e),le=g(e,"UL",{"data-svelte-h":!0}),T(le)!=="svelte-3kii7l"&&(le.innerHTML=gt),Qe=n(e),u(re.$$.fragment,e),Se=n(e),ce=g(e,"P",{"data-svelte-h":!0}),T(ce)!=="svelte-81s14c"&&(ce.textContent=bt),Ne=n(e),ne=g(e,"P",{"data-svelte-h":!0}),T(ne)!=="svelte-mmotdg"&&(ne.innerHTML=Tt),Le=n(e),u(Z.$$.fragment,e),Pe=n(e),u(oe.$$.fragment,e),Ee=n(e),u(ie.$$.fragment,e),Ke=n(e),se=g(e,"P",{"data-svelte-h":!0}),T(se)!=="svelte-dqdivd"&&(se.innerHTML=_t),qe=n(e),u(de.$$.fragment,e),De=n(e),pe=g(e,"P",{"data-svelte-h":!0}),T(pe)!=="svelte-nvfiz9"&&(pe.innerHTML=Ut),Oe=n(e),me=g(e,"P",{"data-svelte-h":!0}),T(me)!=="svelte-56aoja"&&(me.innerHTML=vt),et=n(e),u(I.$$.fragment,e),tt=n(e),u(fe.$$.fragment,e),at=n(e),ue=g(e,"P",{"data-svelte-h":!0}),T(ue)!=="svelte-qzsquh"&&(ue.innerHTML=Jt),lt=n(e),he=g(e,"P",{"data-svelte-h":!0}),T(he)!=="svelte-cf1uwy"&&(he.innerHTML=jt),rt=n(e),ye=g(e,"P",{"data-svelte-h":!0}),T(ye)!=="svelte-uuw2iq"&&(ye.innerHTML=kt),ct=n(e),u(A.$$.fragment,e),nt=n(e),u(Me.$$.fragment,e),ot=n(e),we=g(e,"P",{}),At(we).forEach(a),this.h()},h(){Wt(r,"name","hf:doc:metadata"),Wt(r,"content",Dt)},m(e,t){zt(document.head,r),l(e,b,t),l(e,o,t),l(e,m,t),h(i,e,t),l(e,d,t),l(e,_,t),l(e,v,t),l(e,s,t),l(e,j,t),h(W,e,t),l(e,ge,t),h(X,e,t),l(e,be,t),l(e,R,t),l(e,Te,t),l(e,H,t),l(e,_e,t),h(Y,e,t),l(e,Ue,t),l(e,V,t),l(e,ve,t),h(B,e,t),l(e,Je,t),h(z,e,t),l(e,je,t),l(e,x,t),l(e,ke,t),h(G,e,t),l(e,Ce,t),l(e,F,t),l(e,Ge,t),h(Q,e,t),l(e,Ze,t),h(S,e,t),l(e,Ie,t),l(e,N,t),l(e,Ae,t),h(L,e,t),l(e,We,t),l(e,P,t),l(e,Xe,t),h(E,e,t),l(e,Re,t),h(K,e,t),l(e,He,t),l(e,q,t),l(e,Ye,t),h(D,e,t),l(e,Ve,t),l(e,O,t),l(e,Be,t),h(ee,e,t),l(e,ze,t),h(te,e,t),l(e,xe,t),l(e,ae,t),l(e,Fe,t),l(e,le,t),l(e,Qe,t),h(re,e,t),l(e,Se,t),l(e,ce,t),l(e,Ne,t),l(e,ne,t),l(e,Le,t),h(Z,e,t),l(e,Pe,t),h(oe,e,t),l(e,Ee,t),h(ie,e,t),l(e,Ke,t),l(e,se,t),l(e,qe,t),h(de,e,t),l(e,De,t),l(e,pe,t),l(e,Oe,t),l(e,me,t),l(e,et,t),h(I,e,t),l(e,tt,t),h(fe,e,t),l(e,at,t),l(e,ue,t),l(e,lt,t),l(e,he,t),l(e,rt,t),l(e,ye,t),l(e,ct,t),h(A,e,t),l(e,nt,t),h(Me,e,t),l(e,ot,t),l(e,we,t),it=!0},p(e,[t]){const Ct={};t&2&&(Ct.$$scope={dirty:t,ctx:e}),G.$set(Ct);const Gt={};t&2&&(Gt.$$scope={dirty:t,ctx:e}),Z.$set(Gt);const Zt={};t&2&&(Zt.$$scope={dirty:t,ctx:e}),I.$set(Zt);const It={};t&2&&(It.$$scope={dirty:t,ctx:e}),A.$set(It)},i(e){it||(y(i.$$.fragment,e),y(W.$$.fragment,e),y(X.$$.fragment,e),y(Y.$$.fragment,e),y(B.$$.fragment,e),y(z.$$.fragment,e),y(G.$$.fragment,e),y(Q.$$.fragment,e),y(S.$$.fragment,e),y(L.$$.fragment,e),y(E.$$.fragment,e),y(K.$$.fragment,e),y(D.$$.fragment,e),y(ee.$$.fragment,e),y(te.$$.fragment,e),y(re.$$.fragment,e),y(Z.$$.fragment,e),y(oe.$$.fragment,e),y(ie.$$.fragment,e),y(de.$$.fragment,e),y(I.$$.fragment,e),y(fe.$$.fragment,e),y(A.$$.fragment,e),y(Me.$$.fragment,e),it=!0)},o(e){M(i.$$.fragment,e),M(W.$$.fragment,e),M(X.$$.fragment,e),M(Y.$$.fragment,e),M(B.$$.fragment,e),M(z.$$.fragment,e),M(G.$$.fragment,e),M(Q.$$.fragment,e),M(S.$$.fragment,e),M(L.$$.fragment,e),M(E.$$.fragment,e),M(K.$$.fragment,e),M(D.$$.fragment,e),M(ee.$$.fragment,e),M(te.$$.fragment,e),M(re.$$.fragment,e),M(Z.$$.fragment,e),M(oe.$$.fragment,e),M(ie.$$.fragment,e),M(de.$$.fragment,e),M(I.$$.fragment,e),M(fe.$$.fragment,e),M(A.$$.fragment,e),M(Me.$$.fragment,e),it=!1},d(e){e&&(a(b),a(o),a(m),a(d),a(_),a(v),a(s),a(j),a(ge),a(be),a(R),a(Te),a(H),a(_e),a(Ue),a(V),a(ve),a(Je),a(je),a(x),a(ke),a(Ce),a(F),a(Ge),a(Ze),a(Ie),a(N),a(Ae),a(We),a(P),a(Xe),a(Re),a(He),a(q),a(Ye),a(Ve),a(O),a(Be),a(ze),a(xe),a(ae),a(Fe),a(le),a(Qe),a(Se),a(ce),a(Ne),a(ne),a(Le),a(Pe),a(Ee),a(Ke),a(se),a(qe),a(De),a(pe),a(Oe),a(me),a(et),a(tt),a(at),a(ue),a(lt),a(he),a(rt),a(ye),a(ct),a(nt),a(ot),a(we)),a(r),w(i,e),w(W,e),w(X,e),w(Y,e),w(B,e),w(z,e),w(G,e),w(Q,e),w(S,e),w(L,e),w(E,e),w(K,e),w(D,e),w(ee,e),w(te,e),w(re,e),w(Z,e),w(oe,e),w(ie,e),w(de,e),w(I,e),w(fe,e),w(A,e),w(Me,e)}}}const Dt='{"title":"Add Accelerate to your code","local":"add-accelerate-to-your-code","sections":[{"title":"Accelerator","local":"accelerator","sections":[],"depth":2},{"title":"Prepare PyTorch objects","local":"prepare-pytorch-objects","sections":[],"depth":2},{"title":"Training loop","local":"training-loop","sections":[],"depth":2},{"title":"Training features","local":"training-features","sections":[{"title":"Gradient accumulation","local":"gradient-accumulation","sections":[],"depth":3},{"title":"Gradient clipping","local":"gradient-clipping","sections":[],"depth":3},{"title":"Mixed precision","local":"mixed-precision","sections":[],"depth":3}],"depth":2},{"title":"Save and load","local":"save-and-load","sections":[{"title":"Model","local":"model","sections":[],"depth":3},{"title":"State","local":"state","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ot(J){return Ht(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class na extends Yt{constructor(r){super(),Vt(this,r,Ot,qt,Rt,{})}}export{na as component};
