import{s as yt,n as $t,o as vt}from"../chunks/scheduler.defa9a21.js";import{S as wt,i as Pt,g as l,s as r,r as s,A as xt,h as d,f as t,c as o,j as h,u as c,x as y,k as g,y as n,a as i,v as p,d as m,t as f,w as _}from"../chunks/index.fe795e71.js";import{D as v}from"../chunks/Docstring.f6f3c506.js";import{H as T,E as St}from"../chunks/index.d995652d.js";function Dt(it){let w,ue,fe,he,O,ge,U,be,P,L,qe,ee,lt="Enables RAM efficient loading of Hugging Face models for FSDP in the environment.",ye,M,$e,x,E,Be,te,dt="Disables RAM efficient loading of Hugging Face models for FSDP in the environment.",ve,I,we,$,A,je,ae,st=`Merge the weights from sharded FSDP model checkpoints into a single combined checkpoint. Should be used if
<code>SHARDED_STATE_DICT</code> was used for the model. Weights will be saved to <code>{output_path}/model.safetensors</code> if
<code>safe_serialization</code> else <code>pytorch_model.bin</code>.`,Ge,re,ct="Note: this is a CPU-bound process.",Pe,R,xe,u,H,Ke,oe,pt="This plugin is used to enable fully sharded data parallelism.",Je,C,V,Qe,ne,mt=`Given <code>model</code>, creates an <code>auto_wrap_policy</code> baesd on the passed in policy and if we can use the
<code>transformer_cls_to_wrap</code>`,Xe,k,W,Ye,ie,ft="Sets the mixed precision policy for FSDP",Ze,N,q,et,le,_t="Set the state dict config based on the <code>StateDictType</code>.",tt,z,B,at,de,ut="Validates the mixed precision policy, abstracted away to not bring in the imports if not needed.",Se,j,De,S,G,rt,se,ht=`Loads the full state dict (could be only on rank 0) into the sharded model. This is done by broadcasting the
parameters from rank 0 to all other ranks. This function modifies the model in-place.`,Fe,K,Te,D,J,ot,ce,gt=`Switches the parameters of the optimizer to new ones (sharded parameters in usual case). This function modifies the
optimizer in-place.`,Ce,Q,ke,F,X,nt,pe,bt="Prepares the model for FSDP2 in-place. Also returns the model to avoid misuse of the original model.",Ne,Y,ze,Z,Oe,_e,Ue;return O=new T({props:{title:"Fully Sharded Data Parallel utilities",local:"fully-sharded-data-parallel-utilities",headingTag:"h1"}}),U=new T({props:{title:"enable_fsdp_ram_efficient_loading",local:"accelerate.utils.enable_fsdp_ram_efficient_loading",headingTag:"h2"}}),L=new v({props:{name:"accelerate.utils.enable_fsdp_ram_efficient_loading",anchor:"accelerate.utils.enable_fsdp_ram_efficient_loading",parameters:[],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/utils/fsdp_utils.py#L37"}}),M=new T({props:{title:"disable_fsdp_ram_efficient_loading",local:"accelerate.utils.disable_fsdp_ram_efficient_loading",headingTag:"h2"}}),E=new v({props:{name:"accelerate.utils.disable_fsdp_ram_efficient_loading",anchor:"accelerate.utils.disable_fsdp_ram_efficient_loading",parameters:[],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/utils/fsdp_utils.py#L47"}}),I=new T({props:{title:"merge_fsdp_weights",local:"accelerate.utils.merge_fsdp_weights",headingTag:"h2"}}),A=new v({props:{name:"accelerate.utils.merge_fsdp_weights",anchor:"accelerate.utils.merge_fsdp_weights",parameters:[{name:"checkpoint_dir",val:": str"},{name:"output_path",val:": str"},{name:"safe_serialization",val:": bool = True"},{name:"remove_checkpoint_dir",val:": bool = False"}],parametersDescription:[{anchor:"accelerate.utils.merge_fsdp_weights.checkpoint_dir",description:`<strong>checkpoint_dir</strong> (<code>str</code>) &#x2014;
The directory containing the FSDP checkpoints (can be either the model or optimizer).`,name:"checkpoint_dir"},{anchor:"accelerate.utils.merge_fsdp_weights.output_path",description:`<strong>output_path</strong> (<code>str</code>) &#x2014;
The path to save the merged checkpoint.`,name:"output_path"},{anchor:"accelerate.utils.merge_fsdp_weights.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to save the merged weights with safetensors (recommended).`,name:"safe_serialization"},{anchor:"accelerate.utils.merge_fsdp_weights.remove_checkpoint_dir",description:`<strong>remove_checkpoint_dir</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to remove the checkpoint directory after merging.`,name:"remove_checkpoint_dir"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/utils/fsdp_utils.py#L354"}}),R=new T({props:{title:"FullyShardedDataParallelPlugin",local:"accelerate.FullyShardedDataParallelPlugin",headingTag:"h2"}}),H=new v({props:{name:"class accelerate.FullyShardedDataParallelPlugin",anchor:"accelerate.FullyShardedDataParallelPlugin",parameters:[{name:"fsdp_version",val:": int = None"},{name:"sharding_strategy",val:": typing.Union[str, ForwardRef('torch.distributed.fsdp.ShardingStrategy')] = None"},{name:"reshard_after_forward",val:": typing.Union[str, ForwardRef('torch.distributed.fsdp.ShardingStrategy'), bool] = None"},{name:"backward_prefetch",val:": typing.Union[str, ForwardRef('torch.distributed.fsdp.BackwardPrefetch'), NoneType] = None"},{name:"mixed_precision_policy",val:": typing.Union[dict, ForwardRef('torch.distributed.fsdp.MixedPrecision'), ForwardRef('torch.distributed.fsdp.MixedPrecisionPolicy'), NoneType] = None"},{name:"auto_wrap_policy",val:": typing.Union[typing.Callable, typing.Literal['transformer_based_wrap', 'size_based_wrap', 'no_wrap'], NoneType] = None"},{name:"cpu_offload",val:": typing.Union[bool, ForwardRef('torch.distributed.fsdp.CPUOffload'), ForwardRef('torch.distributed.fsdp.CPUOffloadPolicy')] = None"},{name:"ignored_modules",val:": typing.Optional[collections.abc.Iterable[torch.nn.modules.module.Module]] = None"},{name:"state_dict_type",val:": typing.Union[str, ForwardRef('torch.distributed.fsdp.StateDictType')] = None"},{name:"state_dict_config",val:": typing.Union[ForwardRef('torch.distributed.fsdp.FullStateDictConfig'), ForwardRef('torch.distributed.fsdp.ShardedStateDictConfig'), NoneType] = None"},{name:"optim_state_dict_config",val:": typing.Union[ForwardRef('torch.distributed.fsdp.FullOptimStateDictConfig'), ForwardRef('torch.distributed.fsdp.ShardedOptimStateDictConfig'), NoneType] = None"},{name:"limit_all_gathers",val:": bool = True"},{name:"use_orig_params",val:": typing.Optional[bool] = None"},{name:"param_init_fn",val:": typing.Optional[typing.Callable[[torch.nn.modules.module.Module], NoneType]] = None"},{name:"sync_module_states",val:": typing.Optional[bool] = None"},{name:"forward_prefetch",val:": bool = None"},{name:"activation_checkpointing",val:": bool = None"},{name:"cpu_ram_efficient_loading",val:": bool = None"},{name:"transformer_cls_names_to_wrap",val:": typing.Optional[list[str]] = None"},{name:"min_num_params",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"accelerate.FullyShardedDataParallelPlugin.fsdp_version",description:`<strong>fsdp_version</strong> (<code>int</code>, defaults to <code>1</code>) &#x2014;
The version of FSDP to use. Defaults to 1. If set to 2, launcher expects the config to be converted to
FSDP2 format.`,name:"fsdp_version"},{anchor:"accelerate.FullyShardedDataParallelPlugin.sharding_strategy",description:`<strong>sharding_strategy</strong> (<code>Union[str, torch.distributed.fsdp.ShardingStrategy]</code>, defaults to <code>&apos;FULL_SHARD&apos;</code>) &#x2014;
Sharding strategy to use. Should be either a <code>str</code> or an instance of
<code>torch.distributed.fsdp.fully_sharded_data_parallel.ShardingStrategy</code>. Is deprecated in favor of
<code>reshard_after_forward</code>.`,name:"sharding_strategy"},{anchor:"accelerate.FullyShardedDataParallelPlugin.reshard_after_forward",description:`<strong>reshard_after_forward</strong> (<code>Union[str, torch.distributed.fsdp.ShardingStrategy, bool]</code>, defaults to <code>&apos;FULL_SHARD&apos;</code> for <code>fsdp_version=1</code> and <code>True</code> for <code>fsdp_version=2</code>) &#x2014;
Sharding strategy to use. Should be a bool if <code>fsdp_version</code> is set to 2 else a <code>str</code> or an instance of
<code>torch.distributed.fsdp.fully_sharded_data_parallel.ShardingStrategy</code>.`,name:"reshard_after_forward"},{anchor:"accelerate.FullyShardedDataParallelPlugin.backward_prefetch",description:`<strong>backward_prefetch</strong> (<code>Union[str, torch.distributed.fsdp.BackwardPrefetch]</code>, defaults to <code>&apos;NO_PREFETCH&apos;</code>) &#x2014;
Backward prefetch strategy to use. Should be either a <code>str</code> or an instance of
<code>torch.distributed.fsdp.fully_sharded_data_parallel.BackwardPrefetch</code>.`,name:"backward_prefetch"},{anchor:"accelerate.FullyShardedDataParallelPlugin.mixed_precision_policy",description:`<strong>mixed_precision_policy</strong> (<code>Optional[Union[dict, torch.distributed.fsdp.MixedPrecision, torch.distributed.fsdp.MixedPrecisionPolicy]]</code>, defaults to <code>None</code>) &#x2014;
A config to enable mixed precision training with FullyShardedDataParallel. If passing in a <code>dict</code>, it
should have the following keys: <code>param_dtype</code>, <code>reduce_dtype</code>, and <code>buffer_dtype</code>, can be an instance of
<code>torch.distributed.fsdp.MixedPrecisionPolicy</code> if <code>fsdp_version</code> is set to 2.`,name:"mixed_precision_policy"},{anchor:"accelerate.FullyShardedDataParallelPlugin.auto_wrap_policy",description:"<strong>auto_wrap_policy</strong> (<code>Optional(Union[Callable, Literal[&quot;transformer_based_wrap&quot;, &quot;size_based_wrap&quot;, &quot;no_wrap&quot;]]), defaults to </code>NO_WRAP<code>) -- A callable or string specifying a policy to recursively wrap layers with FSDP. If a string, it must be one of </code>transformer_based_wrap<code>, </code>size_based_wrap<code>, or </code>no_wrap<code>. See </code>torch.distributed.fsdp.wrap.size_based_wrap_policy` for a direction on what it should look like.",name:"auto_wrap_policy"},{anchor:"accelerate.FullyShardedDataParallelPlugin.cpu_offload",description:`<strong>cpu_offload</strong> (<code>Union[bool, torch.distributed.fsdp.CPUOffload, torch.distributed.fsdp.CPUOffloadPolicy]</code>, defaults to <code>False</code>) &#x2014;
Whether to offload parameters to CPU. Should be either a <code>bool</code> or an instance of
<code>torch.distributed.fsdp.fully_sharded_data_parallel.CPUOffload</code> or
<code>torch.distributed.fsdp.fully_sharded_data_parallel.CPUOffloadPolicy</code> if <code>fsdp_version</code> is set to 2.`,name:"cpu_offload"},{anchor:"accelerate.FullyShardedDataParallelPlugin.ignored_modules",description:`<strong>ignored_modules</strong> (<code>Optional[Iterable[torch.nn.Module]]</code>, defaults to <code>None</code>) &#x2014;
A list of modules to ignore when wrapping with FSDP.`,name:"ignored_modules"},{anchor:"accelerate.FullyShardedDataParallelPlugin.state_dict_type",description:`<strong>state_dict_type</strong> (<code>Union[str, torch.distributed.fsdp.StateDictType]</code>, defaults to <code>&apos;FULL_STATE_DICT&apos;</code>) &#x2014;
State dict type to use. If a string, it must be one of <code>full_state_dict</code>, <code>local_state_dict</code>, or
<code>sharded_state_dict</code>.`,name:"state_dict_type"},{anchor:"accelerate.FullyShardedDataParallelPlugin.state_dict_config",description:`<strong>state_dict_config</strong> (<code>Optional[Union[torch.distributed.fsdp.FullStateDictConfig, torch.distributed.fsdp.ShardedStateDictConfig]</code>, defaults to <code>None</code>) &#x2014;
State dict config to use. Is determined based on the <code>state_dict_type</code> if not passed in.`,name:"state_dict_config"},{anchor:"accelerate.FullyShardedDataParallelPlugin.optim_state_dict_config",description:`<strong>optim_state_dict_config</strong> (<code>Optional[Union[torch.distributed.fsdp.FullOptimStateDictConfig, torch.distributed.fsdp.ShardedOptimStateDictConfig]</code>, defaults to <code>None</code>) &#x2014;
Optim state dict config to use. Is determined based on the <code>state_dict_type</code> if not passed in.`,name:"optim_state_dict_config"},{anchor:"accelerate.FullyShardedDataParallelPlugin.limit_all_gathers",description:`<strong>limit_all_gathers</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to have FSDP explicitly synchronizes the CPU thread to prevent too many in-flight all-gathers. This
bool only affects the sharded strategies that schedule all-gathers. Enabling this can help lower the number
of CUDA malloc retries.`,name:"limit_all_gathers"},{anchor:"accelerate.FullyShardedDataParallelPlugin.use_orig_params",description:`<strong>use_orig_params</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to use the original parameters for the optimizer.`,name:"use_orig_params"},{anchor:"accelerate.FullyShardedDataParallelPlugin.param_init_fn",description:`<strong>param_init_fn</strong> (<code>Optional[Callable[[torch.nn.Module], None]</code>, defaults to <code>None</code>) &#x2014;
A <code>Callable[torch.nn.Module] -&gt; None</code> that specifies how modules that are currently on the meta device
should be initialized onto an actual device. Only applicable when <code>sync_module_states</code> is <code>True</code>. By
default is a <code>lambda</code> which calls <code>to_empty</code> on the module.`,name:"param_init_fn"},{anchor:"accelerate.FullyShardedDataParallelPlugin.sync_module_states",description:`<strong>sync_module_states</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether each individually wrapped FSDP unit should broadcast module parameters from rank 0 to ensure they
are the same across all ranks after initialization. Defaults to <code>False</code> unless <code>cpu_ram_efficient_loading</code>
is <code>True</code>, then will be forcibly enabled.`,name:"sync_module_states"},{anchor:"accelerate.FullyShardedDataParallelPlugin.forward_prefetch",description:`<strong>forward_prefetch</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to have FSDP explicitly prefetches the next upcoming all-gather while executing in the forward
pass. only use with Static graphs.`,name:"forward_prefetch"},{anchor:"accelerate.FullyShardedDataParallelPlugin.activation_checkpointing",description:`<strong>activation_checkpointing</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
A technique to reduce memory usage by clearing activations of certain layers and recomputing them during a
backward pass. Effectively, this trades extra computation time for reduced memory usage.`,name:"activation_checkpointing"},{anchor:"accelerate.FullyShardedDataParallelPlugin.cpu_ram_efficient_loading",description:`<strong>cpu_ram_efficient_loading</strong> (<code>bool</code>, defaults to <code>None</code>) &#x2014;
If True, only the first process loads the pretrained model checkoint while all other processes have empty
weights. Only applicable for Transformers. When using this, <code>sync_module_states</code> needs to be <code>True</code>.`,name:"cpu_ram_efficient_loading"},{anchor:"accelerate.FullyShardedDataParallelPlugin.transformer_cls_names_to_wrap",description:`<strong>transformer_cls_names_to_wrap</strong> (<code>Optional[List[str]]</code>, defaults to <code>None</code>) &#x2014;
A list of transformer layer class names to wrap. Only applicable when <code>auto_wrap_policy</code> is
<code>transformer_based_wrap</code>.`,name:"transformer_cls_names_to_wrap"},{anchor:"accelerate.FullyShardedDataParallelPlugin.min_num_params",description:`<strong>min_num_params</strong> (<code>Optional[int]</code>, defaults to <code>None</code>) &#x2014;
The minimum number of parameters a module must have to be wrapped. Only applicable when <code>auto_wrap_policy</code>
is <code>size_based_wrap</code>.`,name:"min_num_params"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/utils/dataclasses.py#L1480"}}),V=new v({props:{name:"set_auto_wrap_policy",anchor:"accelerate.FullyShardedDataParallelPlugin.set_auto_wrap_policy",parameters:[{name:"model",val:""}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/utils/dataclasses.py#L1930"}}),W=new v({props:{name:"set_mixed_precision",anchor:"accelerate.FullyShardedDataParallelPlugin.set_mixed_precision",parameters:[{name:"mixed_precision",val:""},{name:"buffer_autocast",val:" = False"},{name:"override",val:" = False"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/utils/dataclasses.py#L1961"}}),q=new v({props:{name:"set_state_dict_type",anchor:"accelerate.FullyShardedDataParallelPlugin.set_state_dict_type",parameters:[{name:"state_dict_type",val:" = None"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/utils/dataclasses.py#L1886"}}),B=new v({props:{name:"validate_mixed_precision_policy",anchor:"accelerate.FullyShardedDataParallelPlugin.validate_mixed_precision_policy",parameters:[],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/utils/dataclasses.py#L2013"}}),j=new T({props:{title:"fsdp2_load_full_state_dict",local:"accelerate.utils.fsdp2_load_full_state_dict",headingTag:"h2"}}),G=new v({props:{name:"accelerate.utils.fsdp2_load_full_state_dict",anchor:"accelerate.utils.fsdp2_load_full_state_dict",parameters:[{name:"accelerator",val:""},{name:"model",val:": Module"},{name:"full_sd",val:": dict"}],parametersDescription:[{anchor:"accelerate.utils.fsdp2_load_full_state_dict.accelerator",description:"<strong>accelerator</strong> (<code>Accelerator</code>) &#x2014; The accelerator instance",name:"accelerator"},{anchor:"accelerate.utils.fsdp2_load_full_state_dict.model",description:`<strong>model</strong> (<code>torch.nn.Module</code>) &#x2014;
The model to load the state dict into, expected to be on meta device or a VRAM spike can occur`,name:"model"},{anchor:"accelerate.utils.fsdp2_load_full_state_dict.full_sd",description:"<strong>full_sd</strong> (<code>dict</code>) &#x2014; The full state dict to load, can only be on rank 0",name:"full_sd"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/utils/fsdp_utils.py#L455"}}),K=new T({props:{title:"fsdp2_switch_optimizer_parameters",local:"accelerate.utils.fsdp2_switch_optimizer_parameters",headingTag:"h2"}}),J=new v({props:{name:"accelerate.utils.fsdp2_switch_optimizer_parameters",anchor:"accelerate.utils.fsdp2_switch_optimizer_parameters",parameters:[{name:"optimizer",val:": Optimizer"},{name:"mapping",val:": dict"}],parametersDescription:[{anchor:"accelerate.utils.fsdp2_switch_optimizer_parameters.optimizer",description:"<strong>optimizer</strong> (<code>torch.optim.Optimizer</code>) &#x2014; Optimizer instance which contains the original model parameters",name:"optimizer"},{anchor:"accelerate.utils.fsdp2_switch_optimizer_parameters.mapping",description:"<strong>mapping</strong> (<code>dict</code>) &#x2014; Mapping from the original parameter (specified by <code>data_ptr</code>) to the sharded parameter",name:"mapping"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/utils/fsdp_utils.py#L532",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>KeyError</code> —
If a parameter in the optimizer couldn’t be switched to its sharded version. This should never happen and
indicates a bug. If we kept the original params instead of raising, the training wouldn’t be numerically
correct and weights wouldn’t get updated.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>KeyError</code></p>
`}}),Q=new T({props:{title:"fsdp2_prepare_model",local:"accelerate.utils.fsdp2_prepare_model",headingTag:"h2"}}),X=new v({props:{name:"accelerate.utils.fsdp2_prepare_model",anchor:"accelerate.utils.fsdp2_prepare_model",parameters:[{name:"accelerator",val:""},{name:"model",val:": Module"}],parametersDescription:[{anchor:"accelerate.utils.fsdp2_prepare_model.accelerator",description:"<strong>accelerator</strong> (<code>Accelerator</code>) &#x2014; The accelerator instance",name:"accelerator"},{anchor:"accelerate.utils.fsdp2_prepare_model.model",description:"<strong>model</strong> (<code>torch.nn.Module</code>) &#x2014; The model to prepare",name:"model"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/utils/fsdp_utils.py#L558",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Prepared model</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.nn.Module</code></p>
`}}),Y=new T({props:{title:"fsdp2_prepare_auto_wrap_policy",local:"fsdp2prepareautowrappolicy",headingTag:"h2"}}),Z=new St({props:{source:"https://github.com/huggingface/accelerate/blob/main/docs/source/package_reference/fsdp.md"}}),{c(){w=l("meta"),ue=r(),fe=l("p"),he=r(),s(O.$$.fragment),ge=r(),s(U.$$.fragment),be=r(),P=l("div"),s(L.$$.fragment),qe=r(),ee=l("p"),ee.textContent=lt,ye=r(),s(M.$$.fragment),$e=r(),x=l("div"),s(E.$$.fragment),Be=r(),te=l("p"),te.textContent=dt,ve=r(),s(I.$$.fragment),we=r(),$=l("div"),s(A.$$.fragment),je=r(),ae=l("p"),ae.innerHTML=st,Ge=r(),re=l("p"),re.textContent=ct,Pe=r(),s(R.$$.fragment),xe=r(),u=l("div"),s(H.$$.fragment),Ke=r(),oe=l("p"),oe.textContent=pt,Je=r(),C=l("div"),s(V.$$.fragment),Qe=r(),ne=l("p"),ne.innerHTML=mt,Xe=r(),k=l("div"),s(W.$$.fragment),Ye=r(),ie=l("p"),ie.textContent=ft,Ze=r(),N=l("div"),s(q.$$.fragment),et=r(),le=l("p"),le.innerHTML=_t,tt=r(),z=l("div"),s(B.$$.fragment),at=r(),de=l("p"),de.textContent=ut,Se=r(),s(j.$$.fragment),De=r(),S=l("div"),s(G.$$.fragment),rt=r(),se=l("p"),se.textContent=ht,Fe=r(),s(K.$$.fragment),Te=r(),D=l("div"),s(J.$$.fragment),ot=r(),ce=l("p"),ce.textContent=gt,Ce=r(),s(Q.$$.fragment),ke=r(),F=l("div"),s(X.$$.fragment),nt=r(),pe=l("p"),pe.textContent=bt,Ne=r(),s(Y.$$.fragment),ze=r(),s(Z.$$.fragment),Oe=r(),_e=l("p"),this.h()},l(e){const a=xt("svelte-u9bgzb",document.head);w=d(a,"META",{name:!0,content:!0}),a.forEach(t),ue=o(e),fe=d(e,"P",{}),h(fe).forEach(t),he=o(e),c(O.$$.fragment,e),ge=o(e),c(U.$$.fragment,e),be=o(e),P=d(e,"DIV",{class:!0});var Le=h(P);c(L.$$.fragment,Le),qe=o(Le),ee=d(Le,"P",{"data-svelte-h":!0}),y(ee)!=="svelte-1lsbcnp"&&(ee.textContent=lt),Le.forEach(t),ye=o(e),c(M.$$.fragment,e),$e=o(e),x=d(e,"DIV",{class:!0});var Me=h(x);c(E.$$.fragment,Me),Be=o(Me),te=d(Me,"P",{"data-svelte-h":!0}),y(te)!=="svelte-o9zxg8"&&(te.textContent=dt),Me.forEach(t),ve=o(e),c(I.$$.fragment,e),we=o(e),$=d(e,"DIV",{class:!0});var me=h($);c(A.$$.fragment,me),je=o(me),ae=d(me,"P",{"data-svelte-h":!0}),y(ae)!=="svelte-lbcivn"&&(ae.innerHTML=st),Ge=o(me),re=d(me,"P",{"data-svelte-h":!0}),y(re)!=="svelte-s693kt"&&(re.textContent=ct),me.forEach(t),Pe=o(e),c(R.$$.fragment,e),xe=o(e),u=d(e,"DIV",{class:!0});var b=h(u);c(H.$$.fragment,b),Ke=o(b),oe=d(b,"P",{"data-svelte-h":!0}),y(oe)!=="svelte-da89af"&&(oe.textContent=pt),Je=o(b),C=d(b,"DIV",{class:!0});var Ee=h(C);c(V.$$.fragment,Ee),Qe=o(Ee),ne=d(Ee,"P",{"data-svelte-h":!0}),y(ne)!=="svelte-i24l23"&&(ne.innerHTML=mt),Ee.forEach(t),Xe=o(b),k=d(b,"DIV",{class:!0});var Ie=h(k);c(W.$$.fragment,Ie),Ye=o(Ie),ie=d(Ie,"P",{"data-svelte-h":!0}),y(ie)!=="svelte-1oofbyv"&&(ie.textContent=ft),Ie.forEach(t),Ze=o(b),N=d(b,"DIV",{class:!0});var Ae=h(N);c(q.$$.fragment,Ae),et=o(Ae),le=d(Ae,"P",{"data-svelte-h":!0}),y(le)!=="svelte-1ugzx3"&&(le.innerHTML=_t),Ae.forEach(t),tt=o(b),z=d(b,"DIV",{class:!0});var Re=h(z);c(B.$$.fragment,Re),at=o(Re),de=d(Re,"P",{"data-svelte-h":!0}),y(de)!=="svelte-w1jkhd"&&(de.textContent=ut),Re.forEach(t),b.forEach(t),Se=o(e),c(j.$$.fragment,e),De=o(e),S=d(e,"DIV",{class:!0});var He=h(S);c(G.$$.fragment,He),rt=o(He),se=d(He,"P",{"data-svelte-h":!0}),y(se)!=="svelte-1kruoq8"&&(se.textContent=ht),He.forEach(t),Fe=o(e),c(K.$$.fragment,e),Te=o(e),D=d(e,"DIV",{class:!0});var Ve=h(D);c(J.$$.fragment,Ve),ot=o(Ve),ce=d(Ve,"P",{"data-svelte-h":!0}),y(ce)!=="svelte-cvynzy"&&(ce.textContent=gt),Ve.forEach(t),Ce=o(e),c(Q.$$.fragment,e),ke=o(e),F=d(e,"DIV",{class:!0});var We=h(F);c(X.$$.fragment,We),nt=o(We),pe=d(We,"P",{"data-svelte-h":!0}),y(pe)!=="svelte-pwh3xf"&&(pe.textContent=bt),We.forEach(t),Ne=o(e),c(Y.$$.fragment,e),ze=o(e),c(Z.$$.fragment,e),Oe=o(e),_e=d(e,"P",{}),h(_e).forEach(t),this.h()},h(){g(w,"name","hf:doc:metadata"),g(w,"content",Ft),g(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(u,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,a){n(document.head,w),i(e,ue,a),i(e,fe,a),i(e,he,a),p(O,e,a),i(e,ge,a),p(U,e,a),i(e,be,a),i(e,P,a),p(L,P,null),n(P,qe),n(P,ee),i(e,ye,a),p(M,e,a),i(e,$e,a),i(e,x,a),p(E,x,null),n(x,Be),n(x,te),i(e,ve,a),p(I,e,a),i(e,we,a),i(e,$,a),p(A,$,null),n($,je),n($,ae),n($,Ge),n($,re),i(e,Pe,a),p(R,e,a),i(e,xe,a),i(e,u,a),p(H,u,null),n(u,Ke),n(u,oe),n(u,Je),n(u,C),p(V,C,null),n(C,Qe),n(C,ne),n(u,Xe),n(u,k),p(W,k,null),n(k,Ye),n(k,ie),n(u,Ze),n(u,N),p(q,N,null),n(N,et),n(N,le),n(u,tt),n(u,z),p(B,z,null),n(z,at),n(z,de),i(e,Se,a),p(j,e,a),i(e,De,a),i(e,S,a),p(G,S,null),n(S,rt),n(S,se),i(e,Fe,a),p(K,e,a),i(e,Te,a),i(e,D,a),p(J,D,null),n(D,ot),n(D,ce),i(e,Ce,a),p(Q,e,a),i(e,ke,a),i(e,F,a),p(X,F,null),n(F,nt),n(F,pe),i(e,Ne,a),p(Y,e,a),i(e,ze,a),p(Z,e,a),i(e,Oe,a),i(e,_e,a),Ue=!0},p:$t,i(e){Ue||(m(O.$$.fragment,e),m(U.$$.fragment,e),m(L.$$.fragment,e),m(M.$$.fragment,e),m(E.$$.fragment,e),m(I.$$.fragment,e),m(A.$$.fragment,e),m(R.$$.fragment,e),m(H.$$.fragment,e),m(V.$$.fragment,e),m(W.$$.fragment,e),m(q.$$.fragment,e),m(B.$$.fragment,e),m(j.$$.fragment,e),m(G.$$.fragment,e),m(K.$$.fragment,e),m(J.$$.fragment,e),m(Q.$$.fragment,e),m(X.$$.fragment,e),m(Y.$$.fragment,e),m(Z.$$.fragment,e),Ue=!0)},o(e){f(O.$$.fragment,e),f(U.$$.fragment,e),f(L.$$.fragment,e),f(M.$$.fragment,e),f(E.$$.fragment,e),f(I.$$.fragment,e),f(A.$$.fragment,e),f(R.$$.fragment,e),f(H.$$.fragment,e),f(V.$$.fragment,e),f(W.$$.fragment,e),f(q.$$.fragment,e),f(B.$$.fragment,e),f(j.$$.fragment,e),f(G.$$.fragment,e),f(K.$$.fragment,e),f(J.$$.fragment,e),f(Q.$$.fragment,e),f(X.$$.fragment,e),f(Y.$$.fragment,e),f(Z.$$.fragment,e),Ue=!1},d(e){e&&(t(ue),t(fe),t(he),t(ge),t(be),t(P),t(ye),t($e),t(x),t(ve),t(we),t($),t(Pe),t(xe),t(u),t(Se),t(De),t(S),t(Fe),t(Te),t(D),t(Ce),t(ke),t(F),t(Ne),t(ze),t(Oe),t(_e)),t(w),_(O,e),_(U,e),_(L),_(M,e),_(E),_(I,e),_(A),_(R,e),_(H),_(V),_(W),_(q),_(B),_(j,e),_(G),_(K,e),_(J),_(Q,e),_(X),_(Y,e),_(Z,e)}}}const Ft='{"title":"Fully Sharded Data Parallel utilities","local":"fully-sharded-data-parallel-utilities","sections":[{"title":"enable_fsdp_ram_efficient_loading","local":"accelerate.utils.enable_fsdp_ram_efficient_loading","sections":[],"depth":2},{"title":"disable_fsdp_ram_efficient_loading","local":"accelerate.utils.disable_fsdp_ram_efficient_loading","sections":[],"depth":2},{"title":"merge_fsdp_weights","local":"accelerate.utils.merge_fsdp_weights","sections":[],"depth":2},{"title":"FullyShardedDataParallelPlugin","local":"accelerate.FullyShardedDataParallelPlugin","sections":[],"depth":2},{"title":"fsdp2_load_full_state_dict","local":"accelerate.utils.fsdp2_load_full_state_dict","sections":[],"depth":2},{"title":"fsdp2_switch_optimizer_parameters","local":"accelerate.utils.fsdp2_switch_optimizer_parameters","sections":[],"depth":2},{"title":"fsdp2_prepare_model","local":"accelerate.utils.fsdp2_prepare_model","sections":[],"depth":2},{"title":"fsdp2_prepare_auto_wrap_policy","local":"fsdp2prepareautowrappolicy","sections":[],"depth":2}],"depth":1}';function Tt(it){return vt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ot extends wt{constructor(w){super(),Pt(this,w,Tt,Dt,yt,{})}}export{Ot as component};
