import{s as ll,f as al,n as el,o as nl}from"../chunks/scheduler.56730f09.js";import{S as pl,i as il,g as p,s as e,r as m,A as cl,h as i,f as l,c as n,j as wt,u as o,x as c,k as j,y as ml,a,v as r,d as g,t as M,w as h}from"../chunks/index.1f144517.js";import{C as y}from"../chunks/CodeBlock.738eeccb.js";import{D as ol}from"../chunks/DocNotebookDropdown.b2e82107.js";import{H as Js}from"../chunks/Heading.57d46534.js";function rl(xt){let b,ds,us,Us,C,ws,W,xs,v,Tt=`일반적으로 <a href="object_detection">객체 탐지</a>에 사용되는 모델을 학습하기 위해서는 레이블이 지정된 이미지 데이터 세트가 필요합니다.
그리고 학습 데이터에 존재하는 클래스(레이블)만 탐지할 수 있다는 한계점이 있습니다.`,Ts,I,ft=`다른 방식을 사용하는 <a href="../model_doc/owlvit">OWL-ViT</a> 모델로 제로샷 객체 탐지가 가능합니다.
OWL-ViT는 개방형 어휘(open-vocabulary) 객체 탐지기입니다.
즉, 레이블이 지정된 데이터 세트에 미세 조정하지 않고 자유 텍스트 쿼리를 기반으로 이미지에서 객체를 탐지할 수 있습니다.`,fs,k,Ct=`OWL-ViT 모델은 멀티 모달 표현을 활용해 개방형 어휘 탐지(open-vocabulary detection)를 수행합니다.
<a href="../model_doc/clip">CLIP</a> 모델에 경량화(lightweight)된 객체 분류와 지역화(localization) 헤드를 결합합니다.
개방형 어휘 탐지는 CLIP의 텍스트 인코더로 free-text 쿼리를 임베딩하고, 객체 분류와 지역화 헤드의 입력으로 사용합니다.
이미지와 해당 텍스트 설명을 연결하면 ViT가 이미지 패치(image patches)를 입력으로 처리합니다.
OWL-ViT 모델의 저자들은 CLIP 모델을 처음부터 학습(scratch learning)한 후에, bipartite matching loss를 사용하여 표준 객체 인식 데이터셋으로 OWL-ViT 모델을 미세 조정했습니다.`,Cs,$,Wt="이 접근 방식을 사용하면 모델은 레이블이 지정된 데이터 세트에 대한 사전 학습 없이도 텍스트 설명을 기반으로 객체를 탐지할 수 있습니다.",Ws,R,vt="이번 가이드에서는 OWL-ViT 모델의 사용법을 다룰 것입니다:",vs,Q,It="<li>텍스트 프롬프트 기반 객체 탐지</li> <li>일괄 객체 탐지</li> <li>이미지 가이드 객체 탐지</li>",Is,z,kt="시작하기 전에 필요한 라이브러리가 모두 설치되어 있는지 확인하세요:",ks,Z,$s,V,Rs,_,$t=`<code>pipeline()</code>을 활용하면 가장 간단하게 OWL-ViT 모델을 추론해볼 수 있습니다.
<a href="https://huggingface.co/models?pipeline_tag=zero-shot-image-classification&amp;sort=downloads" rel="nofollow">Hugging Face Hub에 업로드된 체크포인트</a>에서 제로샷(zero-shot) 객체 탐지용 파이프라인을 인스턴스화합니다:`,Qs,B,zs,H,Rt=`다음으로, 객체를 탐지하고 싶은 이미지를 선택하세요.
여기서는 <a href="https://www.nasa.gov/multimedia/imagegallery/index.html" rel="nofollow">NASA</a> Great Images 데이터 세트의 일부인 우주비행사 에일린 콜린스(Eileen Collins) 사진을 사용하겠습니다.`,Zs,N,Vs,J,Qt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/zero-sh-obj-detection_1.png" alt="Astronaut Eileen Collins"/>',_s,X,zt=`이미지와 해당 이미지의 후보 레이블을 파이프라인으로 전달합니다.
여기서는 이미지를 직접 전달하지만, 컴퓨터에 저장된 이미지의 경로나 url로 전달할 수도 있습니다.
candidate_labels는 이 예시처럼 간단한 단어일 수도 있고 좀 더 설명적인 단어일 수도 있습니다.
또한, 이미지를 검색(query)하려는 모든 항목에 대한 텍스트 설명도 전달합니다.`,Bs,q,Hs,G,Zt="이제 예측값을 시각화해봅시다:",Ns,Y,Xs,d,Vt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/zero-sh-obj-detection_2.png" alt="Visualized predictions on NASA image"/>',qs,E,Gs,S,_t="제로샷 객체 탐지 파이프라인 사용법에 대해 살펴보았으니, 이제 동일한 결과를 복제해보겠습니다.",Ys,F,Bt=`<a href="https://huggingface.co/models?other=owlvit" rel="nofollow">Hugging Face Hub에 업로드된 체크포인트</a>에서 관련 모델과 프로세서를 가져오는 것으로 시작합니다.
여기서는 이전과 동일한 체크포인트를 사용하겠습니다:`,Es,L,Ss,A,Ht="다른 이미지를 사용해 보겠습니다:",Fs,D,Ls,U,Nt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/zero-sh-obj-detection_3.png" alt="Beach photo"/>',As,P,Xt=`프로세서를 사용해 모델의 입력을 준비합니다.
프로세서는 모델의 입력으로 사용하기 위해 이미지 크기를 변환하고 정규화하는 이미지 프로세서와 텍스트 입력을 처리하는 <code>CLIPTokenizer</code>로 구성됩니다.`,Ds,K,Ps,O,qt=`모델에 입력을 전달하고 결과를 후처리 및 시각화합니다.
이미지 프로세서가 모델에 이미지를 입력하기 전에 이미지 크기를 조정했기 때문에, <code>post_process_object_detection()</code> 메소드를 사용해
예측값의 바운딩 박스(bounding box)가 원본 이미지의 좌표와 상대적으로 동일한지 확인해야 합니다.`,Ks,ss,Os,w,Gt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/zero-sh-obj-detection_4.png" alt="Beach photo with detected objects"/>',st,ts,tt,ls,Yt=`여러 이미지와 텍스트 쿼리를 전달하여 여러 이미지에서 서로 다른(또는 동일한) 객체를 검색할 수 있습니다.
일괄 처리를 위해서 텍스트 쿼리는 이중 리스트로, 이미지는 PIL 이미지, PyTorch 텐서, 또는 NumPy 배열로 이루어진 리스트로 프로세서에 전달해야 합니다.`,lt,as,at,es,Et=`이전에는 후처리를 위해 단일 이미지의 크기를 텐서로 전달했지만, 튜플을 전달할 수 있고, 여러 이미지를 처리하는 경우에는 튜플로 이루어진 리스트를 전달할 수도 있습니다.
아래 두 예제에 대한 예측을 생성하고, 두 번째 이미지(<code>image_idx = 1</code>)를 시각화해 보겠습니다.`,et,ns,nt,x,St='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/zero-sh-obj-detection_4.png" alt="Beach photo with detected objects"/>',pt,ps,it,is,Ft=`텍스트 쿼리를 이용한 제로샷 객체 탐지 외에도 OWL-ViT 모델은 이미지 가이드 객체 탐지 기능을 제공합니다.
이미지를 쿼리로 사용해 대상 이미지에서 유사한 객체를 찾을 수 있다는 의미입니다.
텍스트 쿼리와 달리 하나의 예제 이미지에서만 가능합니다.`,ct,cs,Lt="소파에 고양이 두 마리가 있는 이미지를 대상 이미지(target image)로, 고양이 한 마리가 있는 이미지를 쿼리로 사용해보겠습니다:",mt,ms,ot,os,At="다음 이미지를 살펴보겠습니다:",rt,rs,gt,T,Dt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/zero-sh-obj-detection_5.png" alt="Cats"/>',Mt,gs,Pt="전처리 단계에서 텍스트 쿼리 대신에 <code>query_images</code>를 사용합니다:",ht,Ms,yt,hs,Kt=`예측의 경우, 모델에 입력을 전달하는 대신 <code>image_guided_detection()</code>에 전달합니다.
레이블이 없다는 점을 제외하면 이전과 동일합니다.
이전과 동일하게 이미지를 시각화합니다.`,jt,ys,ut,f,Ot='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/zero-sh-obj-detection_6.png" alt="Cats with bounding boxes"/>',bt,js,sl="OWL-ViT 모델을 추론하고 싶다면 아래 데모를 확인하세요:",Jt,u,tl,dt,bs,Ut;return C=new Js({props:{title:"제로샷(zero-shot) 객체 탐지",local:"zeroshot-object-detection",headingTag:"h1"}}),W=new ol({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ko/zero_shot_object_detection.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ko/pytorch/zero_shot_object_detection.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ko/tensorflow/zero_shot_object_detection.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ko/zero_shot_object_detection.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ko/pytorch/zero_shot_object_detection.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ko/tensorflow/zero_shot_object_detection.ipynb"}]}}),Z=new y({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwdHJhbnNmb3JtZXJz",highlighted:"pip install -q transformers",wrap:!1}}),V=new Js({props:{title:"제로샷(zero-shot) 객체 탐지 파이프라인",local:"zeroshot-object-detection-pipeline",headingTag:"h2"}}),B=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMmdvb2dsZSUyRm93bHZpdC1iYXNlLXBhdGNoMzIlMjIlMEFkZXRlY3RvciUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEY2hlY2twb2ludCUyQyUyMHRhc2slM0QlMjJ6ZXJvLXNob3Qtb2JqZWN0LWRldGVjdGlvbiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;google/owlvit-base-patch32&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>detector = pipeline(model=checkpoint, task=<span class="hljs-string">&quot;zero-shot-object-detection&quot;</span>)`,wrap:!1}}),N=new y({props:{code:"aW1wb3J0JTIwc2tpbWFnZSUwQWltcG9ydCUyMG51bXB5JTIwYXMlMjBucCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQSUwQWltYWdlJTIwJTNEJTIwc2tpbWFnZS5kYXRhLmFzdHJvbmF1dCgpJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5mcm9tYXJyYXkobnAudWludDgoaW1hZ2UpKS5jb252ZXJ0KCUyMlJHQiUyMiklMEElMEFpbWFnZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> skimage
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span>image = skimage.data.astronaut()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.fromarray(np.uint8(image)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),q=new y({props:{code:"cHJlZGljdGlvbnMlMjAlM0QlMjBkZXRlY3RvciglMEElMjAlMjAlMjAlMjBpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMGNhbmRpZGF0ZV9sYWJlbHMlM0QlNUIlMjJodW1hbiUyMGZhY2UlMjIlMkMlMjAlMjJyb2NrZXQlMjIlMkMlMjAlMjJuYXNhJTIwYmFkZ2UlMjIlMkMlMjAlMjJzdGFyLXNwYW5nbGVkJTIwYmFubmVyJTIyJTVEJTJDJTBBKSUwQXByZWRpY3Rpb25z",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>predictions = detector(
<span class="hljs-meta">... </span>    image,
<span class="hljs-meta">... </span>    candidate_labels=[<span class="hljs-string">&quot;human face&quot;</span>, <span class="hljs-string">&quot;rocket&quot;</span>, <span class="hljs-string">&quot;nasa badge&quot;</span>, <span class="hljs-string">&quot;star-spangled banner&quot;</span>],
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>predictions
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.3571370542049408</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;human face&#x27;</span>,
  <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">180</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">71</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">271</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">178</span>}},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.28099656105041504</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;nasa badge&#x27;</span>,
  <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">129</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">348</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">206</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">427</span>}},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.2110239565372467</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;rocket&#x27;</span>,
  <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">350</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: -<span class="hljs-number">1</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">468</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">288</span>}},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.13790413737297058</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;star-spangled banner&#x27;</span>,
  <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">105</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">509</span>}},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.11950037628412247</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;nasa badge&#x27;</span>,
  <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">277</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">338</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">327</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">380</span>}},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.10649408400058746</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;rocket&#x27;</span>,
  <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">358</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">64</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">424</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">280</span>}}]`,wrap:!1}}),Y=new y({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlRHJhdyUwQSUwQWRyYXclMjAlM0QlMjBJbWFnZURyYXcuRHJhdyhpbWFnZSklMEElMEFmb3IlMjBwcmVkaWN0aW9uJTIwaW4lMjBwcmVkaWN0aW9ucyUzQSUwQSUyMCUyMCUyMCUyMGJveCUyMCUzRCUyMHByZWRpY3Rpb24lNUIlMjJib3glMjIlNUQlMEElMjAlMjAlMjAlMjBsYWJlbCUyMCUzRCUyMHByZWRpY3Rpb24lNUIlMjJsYWJlbCUyMiU1RCUwQSUyMCUyMCUyMCUyMHNjb3JlJTIwJTNEJTIwcHJlZGljdGlvbiU1QiUyMnNjb3JlJTIyJTVEJTBBJTBBJTIwJTIwJTIwJTIweG1pbiUyQyUyMHltaW4lMkMlMjB4bWF4JTJDJTIweW1heCUyMCUzRCUyMGJveC52YWx1ZXMoKSUwQSUyMCUyMCUyMCUyMGRyYXcucmVjdGFuZ2xlKCh4bWluJTJDJTIweW1pbiUyQyUyMHhtYXglMkMlMjB5bWF4KSUyQyUyMG91dGxpbmUlM0QlMjJyZWQlMjIlMkMlMjB3aWR0aCUzRDEpJTBBJTIwJTIwJTIwJTIwZHJhdy50ZXh0KCh4bWluJTJDJTIweW1pbiklMkMlMjBmJTIyJTdCbGFiZWwlN0QlM0ElMjAlN0Jyb3VuZChzY29yZSUyQzIpJTdEJTIyJTJDJTIwZmlsbCUzRCUyMndoaXRlJTIyKSUwQSUwQWltYWdl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> ImageDraw

<span class="hljs-meta">&gt;&gt;&gt; </span>draw = ImageDraw.Draw(image)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> prediction <span class="hljs-keyword">in</span> predictions:
<span class="hljs-meta">... </span>    box = prediction[<span class="hljs-string">&quot;box&quot;</span>]
<span class="hljs-meta">... </span>    label = prediction[<span class="hljs-string">&quot;label&quot;</span>]
<span class="hljs-meta">... </span>    score = prediction[<span class="hljs-string">&quot;score&quot;</span>]

<span class="hljs-meta">... </span>    xmin, ymin, xmax, ymax = box.values()
<span class="hljs-meta">... </span>    draw.rectangle((xmin, ymin, xmax, ymax), outline=<span class="hljs-string">&quot;red&quot;</span>, width=<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    draw.text((xmin, ymin), <span class="hljs-string">f&quot;<span class="hljs-subst">{label}</span>: <span class="hljs-subst">{<span class="hljs-built_in">round</span>(score,<span class="hljs-number">2</span>)}</span>&quot;</span>, fill=<span class="hljs-string">&quot;white&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),E=new Js({props:{title:"텍스트 프롬프트 기반 객체 탐지",local:"textprompted-zeroshot-object-detection-by-hand",headingTag:"h2"}}),L=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBBdXRvTW9kZWxGb3JaZXJvU2hvdE9iamVjdERldGVjdGlvbiUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yWmVyb1Nob3RPYmplY3REZXRlY3Rpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForZeroShotObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForZeroShotObjectDetection.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(checkpoint)`,wrap:!1}}),D=new y({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnVuc3BsYXNoLmNvbSUyRnBob3RvcyUyRm9qMHplWTJMdGs0JTJGZG93bmxvYWQlM0ZpeGlkJTNETW53eE1qQTNmREI4TVh4elpXRnlZMmg4TVRSOGZIQnBZMjVwWTN4bGJud3dmSHg4ZkRFMk56YzBPVEUxTkRrJTI2Zm9yY2UlM0R0cnVlJTI2dyUzRDY0MCUyMiUwQWltJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQWlt",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://unsplash.com/photos/oj0zeY2Ltk4/download?ixid=MnwxMjA3fDB8MXxzZWFyY2h8MTR8fHBpY25pY3xlbnwwfHx8fDE2Nzc0OTE1NDk&amp;force=true&amp;w=640&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>im = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>im`,wrap:!1}}),K=new y({props:{code:"dGV4dF9xdWVyaWVzJTIwJTNEJTIwJTVCJTIyaGF0JTIyJTJDJTIwJTIyYm9vayUyMiUyQyUyMCUyMnN1bmdsYXNzZXMlMjIlMkMlMjAlMjJjYW1lcmElMjIlNUQlMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IodGV4dCUzRHRleHRfcXVlcmllcyUyQyUyMGltYWdlcyUzRGltJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>text_queries = [<span class="hljs-string">&quot;hat&quot;</span>, <span class="hljs-string">&quot;book&quot;</span>, <span class="hljs-string">&quot;sunglasses&quot;</span>, <span class="hljs-string">&quot;camera&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=text_queries, images=im, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)`,wrap:!1}}),ss=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUyMCUyMCUyMCUyMHRhcmdldF9zaXplcyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUJpbS5zaXplJTVCJTNBJTNBLTElNUQlNUQpJTBBJTIwJTIwJTIwJTIwcmVzdWx0cyUyMCUzRCUyMHByb2Nlc3Nvci5wb3N0X3Byb2Nlc3Nfb2JqZWN0X2RldGVjdGlvbihvdXRwdXRzJTJDJTIwdGhyZXNob2xkJTNEMC4xJTJDJTIwdGFyZ2V0X3NpemVzJTNEdGFyZ2V0X3NpemVzKSU1QjAlNUQlMEElMEFkcmF3JTIwJTNEJTIwSW1hZ2VEcmF3LkRyYXcoaW0pJTBBJTBBc2NvcmVzJTIwJTNEJTIwcmVzdWx0cyU1QiUyMnNjb3JlcyUyMiU1RC50b2xpc3QoKSUwQWxhYmVscyUyMCUzRCUyMHJlc3VsdHMlNUIlMjJsYWJlbHMlMjIlNUQudG9saXN0KCklMEFib3hlcyUyMCUzRCUyMHJlc3VsdHMlNUIlMjJib3hlcyUyMiU1RC50b2xpc3QoKSUwQSUwQWZvciUyMGJveCUyQyUyMHNjb3JlJTJDJTIwbGFiZWwlMjBpbiUyMHppcChib3hlcyUyQyUyMHNjb3JlcyUyQyUyMGxhYmVscyklM0ElMEElMjAlMjAlMjAlMjB4bWluJTJDJTIweW1pbiUyQyUyMHhtYXglMkMlMjB5bWF4JTIwJTNEJTIwYm94JTBBJTIwJTIwJTIwJTIwZHJhdy5yZWN0YW5nbGUoKHhtaW4lMkMlMjB5bWluJTJDJTIweG1heCUyQyUyMHltYXgpJTJDJTIwb3V0bGluZSUzRCUyMnJlZCUyMiUyQyUyMHdpZHRoJTNEMSklMEElMjAlMjAlMjAlMjBkcmF3LnRleHQoKHhtaW4lMkMlMjB5bWluKSUyQyUyMGYlMjIlN0J0ZXh0X3F1ZXJpZXMlNUJsYWJlbCU1RCU3RCUzQSUyMCU3QnJvdW5kKHNjb3JlJTJDMiklN0QlMjIlMkMlMjBmaWxsJTNEJTIyd2hpdGUlMjIpJTBBJTBBaW0=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)
<span class="hljs-meta">... </span>    target_sizes = torch.tensor([im.size[::-<span class="hljs-number">1</span>]])
<span class="hljs-meta">... </span>    results = processor.post_process_object_detection(outputs, threshold=<span class="hljs-number">0.1</span>, target_sizes=target_sizes)[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>draw = ImageDraw.Draw(im)

<span class="hljs-meta">&gt;&gt;&gt; </span>scores = results[<span class="hljs-string">&quot;scores&quot;</span>].tolist()
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = results[<span class="hljs-string">&quot;labels&quot;</span>].tolist()
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes = results[<span class="hljs-string">&quot;boxes&quot;</span>].tolist()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> box, score, label <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(boxes, scores, labels):
<span class="hljs-meta">... </span>    xmin, ymin, xmax, ymax = box
<span class="hljs-meta">... </span>    draw.rectangle((xmin, ymin, xmax, ymax), outline=<span class="hljs-string">&quot;red&quot;</span>, width=<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    draw.text((xmin, ymin), <span class="hljs-string">f&quot;<span class="hljs-subst">{text_queries[label]}</span>: <span class="hljs-subst">{<span class="hljs-built_in">round</span>(score,<span class="hljs-number">2</span>)}</span>&quot;</span>, fill=<span class="hljs-string">&quot;white&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>im`,wrap:!1}}),ts=new Js({props:{title:"일괄 처리",local:"batch-processing",headingTag:"h2"}}),as=new y({props:{code:"aW1hZ2VzJTIwJTNEJTIwJTVCaW1hZ2UlMkMlMjBpbSU1RCUwQXRleHRfcXVlcmllcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU1QiUyMmh1bWFuJTIwZmFjZSUyMiUyQyUyMCUyMnJvY2tldCUyMiUyQyUyMCUyMm5hc2ElMjBiYWRnZSUyMiUyQyUyMCUyMnN0YXItc3BhbmdsZWQlMjBiYW5uZXIlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlNUIlMjJoYXQlMjIlMkMlMjAlMjJib29rJTIyJTJDJTIwJTIyc3VuZ2xhc3NlcyUyMiUyQyUyMCUyMmNhbWVyYSUyMiU1RCUyQyUwQSU1RCUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcih0ZXh0JTNEdGV4dF9xdWVyaWVzJTJDJTIwaW1hZ2VzJTNEaW1hZ2VzJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>images = [image, im]
<span class="hljs-meta">&gt;&gt;&gt; </span>text_queries = [
<span class="hljs-meta">... </span>    [<span class="hljs-string">&quot;human face&quot;</span>, <span class="hljs-string">&quot;rocket&quot;</span>, <span class="hljs-string">&quot;nasa badge&quot;</span>, <span class="hljs-string">&quot;star-spangled banner&quot;</span>],
<span class="hljs-meta">... </span>    [<span class="hljs-string">&quot;hat&quot;</span>, <span class="hljs-string">&quot;book&quot;</span>, <span class="hljs-string">&quot;sunglasses&quot;</span>, <span class="hljs-string">&quot;camera&quot;</span>],
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=text_queries, images=images, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)`,wrap:!1}}),ns=new y({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMjAlMjAlMjAlMjB0YXJnZXRfc2l6ZXMlMjAlM0QlMjAlNUJ4LnNpemUlNUIlM0ElM0EtMSU1RCUyMGZvciUyMHglMjBpbiUyMGltYWdlcyU1RCUwQSUyMCUyMCUyMCUyMHJlc3VsdHMlMjAlM0QlMjBwcm9jZXNzb3IucG9zdF9wcm9jZXNzX29iamVjdF9kZXRlY3Rpb24ob3V0cHV0cyUyQyUyMHRocmVzaG9sZCUzRDAuMSUyQyUyMHRhcmdldF9zaXplcyUzRHRhcmdldF9zaXplcyklMEElMEFpbWFnZV9pZHglMjAlM0QlMjAxJTBBZHJhdyUyMCUzRCUyMEltYWdlRHJhdy5EcmF3KGltYWdlcyU1QmltYWdlX2lkeCU1RCklMEElMEFzY29yZXMlMjAlM0QlMjByZXN1bHRzJTVCaW1hZ2VfaWR4JTVEJTVCJTIyc2NvcmVzJTIyJTVELnRvbGlzdCgpJTBBbGFiZWxzJTIwJTNEJTIwcmVzdWx0cyU1QmltYWdlX2lkeCU1RCU1QiUyMmxhYmVscyUyMiU1RC50b2xpc3QoKSUwQWJveGVzJTIwJTNEJTIwcmVzdWx0cyU1QmltYWdlX2lkeCU1RCU1QiUyMmJveGVzJTIyJTVELnRvbGlzdCgpJTBBJTBBZm9yJTIwYm94JTJDJTIwc2NvcmUlMkMlMjBsYWJlbCUyMGluJTIwemlwKGJveGVzJTJDJTIwc2NvcmVzJTJDJTIwbGFiZWxzKSUzQSUwQSUyMCUyMCUyMCUyMHhtaW4lMkMlMjB5bWluJTJDJTIweG1heCUyQyUyMHltYXglMjAlM0QlMjBib3glMEElMjAlMjAlMjAlMjBkcmF3LnJlY3RhbmdsZSgoeG1pbiUyQyUyMHltaW4lMkMlMjB4bWF4JTJDJTIweW1heCklMkMlMjBvdXRsaW5lJTNEJTIycmVkJTIyJTJDJTIwd2lkdGglM0QxKSUwQSUyMCUyMCUyMCUyMGRyYXcudGV4dCgoeG1pbiUyQyUyMHltaW4pJTJDJTIwZiUyMiU3QnRleHRfcXVlcmllcyU1QmltYWdlX2lkeCU1RCU1QmxhYmVsJTVEJTdEJTNBJTIwJTdCcm91bmQoc2NvcmUlMkMyKSU3RCUyMiUyQyUyMGZpbGwlM0QlMjJ3aGl0ZSUyMiklMEElMEFpbWFnZXMlNUJpbWFnZV9pZHglNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)
<span class="hljs-meta">... </span>    target_sizes = [x.size[::-<span class="hljs-number">1</span>] <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> images]
<span class="hljs-meta">... </span>    results = processor.post_process_object_detection(outputs, threshold=<span class="hljs-number">0.1</span>, target_sizes=target_sizes)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_idx = <span class="hljs-number">1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>draw = ImageDraw.Draw(images[image_idx])

<span class="hljs-meta">&gt;&gt;&gt; </span>scores = results[image_idx][<span class="hljs-string">&quot;scores&quot;</span>].tolist()
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = results[image_idx][<span class="hljs-string">&quot;labels&quot;</span>].tolist()
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes = results[image_idx][<span class="hljs-string">&quot;boxes&quot;</span>].tolist()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> box, score, label <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(boxes, scores, labels):
<span class="hljs-meta">... </span>    xmin, ymin, xmax, ymax = box
<span class="hljs-meta">... </span>    draw.rectangle((xmin, ymin, xmax, ymax), outline=<span class="hljs-string">&quot;red&quot;</span>, width=<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    draw.text((xmin, ymin), <span class="hljs-string">f&quot;<span class="hljs-subst">{text_queries[image_idx][label]}</span>: <span class="hljs-subst">{<span class="hljs-built_in">round</span>(score,<span class="hljs-number">2</span>)}</span>&quot;</span>, fill=<span class="hljs-string">&quot;white&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>images[image_idx]`,wrap:!1}}),ps=new Js({props:{title:"이미지 가이드 객체 탐지",local:"imageguided-object-detection",headingTag:"h2"}}),ms=new y({props:{code:"dXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlX3RhcmdldCUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFxdWVyeV91cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDA1MjQyODAuanBnJTIyJTBBcXVlcnlfaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldChxdWVyeV91cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_target = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>query_url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000524280.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>query_image = Image.<span class="hljs-built_in">open</span>(requests.get(query_url, stream=<span class="hljs-literal">True</span>).raw)`,wrap:!1}}),rs=new y({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQWZpZyUyQyUyMGF4JTIwJTNEJTIwcGx0LnN1YnBsb3RzKDElMkMlMjAyKSUwQWF4JTVCMCU1RC5pbXNob3coaW1hZ2VfdGFyZ2V0KSUwQWF4JTVCMSU1RC5pbXNob3cocXVlcnlfaW1hZ2Up",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

<span class="hljs-meta">&gt;&gt;&gt; </span>fig, ax = plt.subplots(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ax[<span class="hljs-number">0</span>].imshow(image_target)
<span class="hljs-meta">&gt;&gt;&gt; </span>ax[<span class="hljs-number">1</span>].imshow(query_image)`,wrap:!1}}),Ms=new y({props:{code:"aW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlX3RhcmdldCUyQyUyMHF1ZXJ5X2ltYWdlcyUzRHF1ZXJ5X2ltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image_target, query_images=query_image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),ys=new y({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbC5pbWFnZV9ndWlkZWRfZGV0ZWN0aW9uKCoqaW5wdXRzKSUwQSUyMCUyMCUyMCUyMHRhcmdldF9zaXplcyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUJpbWFnZV90YXJnZXQuc2l6ZSU1QiUzQSUzQS0xJTVEJTVEKSUwQSUyMCUyMCUyMCUyMHJlc3VsdHMlMjAlM0QlMjBwcm9jZXNzb3IucG9zdF9wcm9jZXNzX2ltYWdlX2d1aWRlZF9kZXRlY3Rpb24ob3V0cHV0cyUzRG91dHB1dHMlMkMlMjB0YXJnZXRfc2l6ZXMlM0R0YXJnZXRfc2l6ZXMpJTVCMCU1RCUwQSUwQWRyYXclMjAlM0QlMjBJbWFnZURyYXcuRHJhdyhpbWFnZV90YXJnZXQpJTBBJTBBc2NvcmVzJTIwJTNEJTIwcmVzdWx0cyU1QiUyMnNjb3JlcyUyMiU1RC50b2xpc3QoKSUwQWJveGVzJTIwJTNEJTIwcmVzdWx0cyU1QiUyMmJveGVzJTIyJTVELnRvbGlzdCgpJTBBJTBBZm9yJTIwYm94JTJDJTIwc2NvcmUlMkMlMjBsYWJlbCUyMGluJTIwemlwKGJveGVzJTJDJTIwc2NvcmVzJTJDJTIwbGFiZWxzKSUzQSUwQSUyMCUyMCUyMCUyMHhtaW4lMkMlMjB5bWluJTJDJTIweG1heCUyQyUyMHltYXglMjAlM0QlMjBib3glMEElMjAlMjAlMjAlMjBkcmF3LnJlY3RhbmdsZSgoeG1pbiUyQyUyMHltaW4lMkMlMjB4bWF4JTJDJTIweW1heCklMkMlMjBvdXRsaW5lJTNEJTIyd2hpdGUlMjIlMkMlMjB3aWR0aCUzRDQpJTBBJTBBaW1hZ2VfdGFyZ2V0",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model.image_guided_detection(**inputs)
<span class="hljs-meta">... </span>    target_sizes = torch.tensor([image_target.size[::-<span class="hljs-number">1</span>]])
<span class="hljs-meta">... </span>    results = processor.post_process_image_guided_detection(outputs=outputs, target_sizes=target_sizes)[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>draw = ImageDraw.Draw(image_target)

<span class="hljs-meta">&gt;&gt;&gt; </span>scores = results[<span class="hljs-string">&quot;scores&quot;</span>].tolist()
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes = results[<span class="hljs-string">&quot;boxes&quot;</span>].tolist()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> box, score, label <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(boxes, scores, labels):
<span class="hljs-meta">... </span>    xmin, ymin, xmax, ymax = box
<span class="hljs-meta">... </span>    draw.rectangle((xmin, ymin, xmax, ymax), outline=<span class="hljs-string">&quot;white&quot;</span>, width=<span class="hljs-number">4</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_target`,wrap:!1}}),{c(){b=p("meta"),ds=e(),us=p("p"),Us=e(),m(C.$$.fragment),ws=e(),m(W.$$.fragment),xs=e(),v=p("p"),v.innerHTML=Tt,Ts=e(),I=p("p"),I.innerHTML=ft,fs=e(),k=p("p"),k.innerHTML=Ct,Cs=e(),$=p("p"),$.textContent=Wt,Ws=e(),R=p("p"),R.textContent=vt,vs=e(),Q=p("ul"),Q.innerHTML=It,Is=e(),z=p("p"),z.textContent=kt,ks=e(),m(Z.$$.fragment),$s=e(),m(V.$$.fragment),Rs=e(),_=p("p"),_.innerHTML=$t,Qs=e(),m(B.$$.fragment),zs=e(),H=p("p"),H.innerHTML=Rt,Zs=e(),m(N.$$.fragment),Vs=e(),J=p("div"),J.innerHTML=Qt,_s=e(),X=p("p"),X.textContent=zt,Bs=e(),m(q.$$.fragment),Hs=e(),G=p("p"),G.textContent=Zt,Ns=e(),m(Y.$$.fragment),Xs=e(),d=p("div"),d.innerHTML=Vt,qs=e(),m(E.$$.fragment),Gs=e(),S=p("p"),S.textContent=_t,Ys=e(),F=p("p"),F.innerHTML=Bt,Es=e(),m(L.$$.fragment),Ss=e(),A=p("p"),A.textContent=Ht,Fs=e(),m(D.$$.fragment),Ls=e(),U=p("div"),U.innerHTML=Nt,As=e(),P=p("p"),P.innerHTML=Xt,Ds=e(),m(K.$$.fragment),Ps=e(),O=p("p"),O.innerHTML=qt,Ks=e(),m(ss.$$.fragment),Os=e(),w=p("div"),w.innerHTML=Gt,st=e(),m(ts.$$.fragment),tt=e(),ls=p("p"),ls.textContent=Yt,lt=e(),m(as.$$.fragment),at=e(),es=p("p"),es.innerHTML=Et,et=e(),m(ns.$$.fragment),nt=e(),x=p("div"),x.innerHTML=St,pt=e(),m(ps.$$.fragment),it=e(),is=p("p"),is.textContent=Ft,ct=e(),cs=p("p"),cs.textContent=Lt,mt=e(),m(ms.$$.fragment),ot=e(),os=p("p"),os.textContent=At,rt=e(),m(rs.$$.fragment),gt=e(),T=p("div"),T.innerHTML=Dt,Mt=e(),gs=p("p"),gs.innerHTML=Pt,ht=e(),m(Ms.$$.fragment),yt=e(),hs=p("p"),hs.innerHTML=Kt,jt=e(),m(ys.$$.fragment),ut=e(),f=p("div"),f.innerHTML=Ot,bt=e(),js=p("p"),js.textContent=sl,Jt=e(),u=p("iframe"),dt=e(),bs=p("p"),this.h()},l(s){const t=cl("svelte-u9bgzb",document.head);b=i(t,"META",{name:!0,content:!0}),t.forEach(l),ds=n(s),us=i(s,"P",{}),wt(us).forEach(l),Us=n(s),o(C.$$.fragment,s),ws=n(s),o(W.$$.fragment,s),xs=n(s),v=i(s,"P",{"data-svelte-h":!0}),c(v)!=="svelte-6eje4v"&&(v.innerHTML=Tt),Ts=n(s),I=i(s,"P",{"data-svelte-h":!0}),c(I)!=="svelte-17o36b3"&&(I.innerHTML=ft),fs=n(s),k=i(s,"P",{"data-svelte-h":!0}),c(k)!=="svelte-1148tws"&&(k.innerHTML=Ct),Cs=n(s),$=i(s,"P",{"data-svelte-h":!0}),c($)!=="svelte-1au2n2f"&&($.textContent=Wt),Ws=n(s),R=i(s,"P",{"data-svelte-h":!0}),c(R)!=="svelte-114e4n4"&&(R.textContent=vt),vs=n(s),Q=i(s,"UL",{"data-svelte-h":!0}),c(Q)!=="svelte-m6pgk5"&&(Q.innerHTML=It),Is=n(s),z=i(s,"P",{"data-svelte-h":!0}),c(z)!=="svelte-1k0z9pm"&&(z.textContent=kt),ks=n(s),o(Z.$$.fragment,s),$s=n(s),o(V.$$.fragment,s),Rs=n(s),_=i(s,"P",{"data-svelte-h":!0}),c(_)!=="svelte-1nqv12v"&&(_.innerHTML=$t),Qs=n(s),o(B.$$.fragment,s),zs=n(s),H=i(s,"P",{"data-svelte-h":!0}),c(H)!=="svelte-1p9c2je"&&(H.innerHTML=Rt),Zs=n(s),o(N.$$.fragment,s),Vs=n(s),J=i(s,"DIV",{class:!0,"data-svelte-h":!0}),c(J)!=="svelte-17qmfee"&&(J.innerHTML=Qt),_s=n(s),X=i(s,"P",{"data-svelte-h":!0}),c(X)!=="svelte-1argm47"&&(X.textContent=zt),Bs=n(s),o(q.$$.fragment,s),Hs=n(s),G=i(s,"P",{"data-svelte-h":!0}),c(G)!=="svelte-1uqzhy9"&&(G.textContent=Zt),Ns=n(s),o(Y.$$.fragment,s),Xs=n(s),d=i(s,"DIV",{class:!0,"data-svelte-h":!0}),c(d)!=="svelte-1fwpqdn"&&(d.innerHTML=Vt),qs=n(s),o(E.$$.fragment,s),Gs=n(s),S=i(s,"P",{"data-svelte-h":!0}),c(S)!=="svelte-1ipgrv9"&&(S.textContent=_t),Ys=n(s),F=i(s,"P",{"data-svelte-h":!0}),c(F)!=="svelte-qzn480"&&(F.innerHTML=Bt),Es=n(s),o(L.$$.fragment,s),Ss=n(s),A=i(s,"P",{"data-svelte-h":!0}),c(A)!=="svelte-1ist5bc"&&(A.textContent=Ht),Fs=n(s),o(D.$$.fragment,s),Ls=n(s),U=i(s,"DIV",{class:!0,"data-svelte-h":!0}),c(U)!=="svelte-owux8y"&&(U.innerHTML=Nt),As=n(s),P=i(s,"P",{"data-svelte-h":!0}),c(P)!=="svelte-18gx5db"&&(P.innerHTML=Xt),Ds=n(s),o(K.$$.fragment,s),Ps=n(s),O=i(s,"P",{"data-svelte-h":!0}),c(O)!=="svelte-5kpzn3"&&(O.innerHTML=qt),Ks=n(s),o(ss.$$.fragment,s),Os=n(s),w=i(s,"DIV",{class:!0,"data-svelte-h":!0}),c(w)!=="svelte-1m863ar"&&(w.innerHTML=Gt),st=n(s),o(ts.$$.fragment,s),tt=n(s),ls=i(s,"P",{"data-svelte-h":!0}),c(ls)!=="svelte-xr561s"&&(ls.textContent=Yt),lt=n(s),o(as.$$.fragment,s),at=n(s),es=i(s,"P",{"data-svelte-h":!0}),c(es)!=="svelte-1e7zpei"&&(es.innerHTML=Et),et=n(s),o(ns.$$.fragment,s),nt=n(s),x=i(s,"DIV",{class:!0,"data-svelte-h":!0}),c(x)!=="svelte-1m863ar"&&(x.innerHTML=St),pt=n(s),o(ps.$$.fragment,s),it=n(s),is=i(s,"P",{"data-svelte-h":!0}),c(is)!=="svelte-1oyzclh"&&(is.textContent=Ft),ct=n(s),cs=i(s,"P",{"data-svelte-h":!0}),c(cs)!=="svelte-3m9urc"&&(cs.textContent=Lt),mt=n(s),o(ms.$$.fragment,s),ot=n(s),os=i(s,"P",{"data-svelte-h":!0}),c(os)!=="svelte-17azu4t"&&(os.textContent=At),rt=n(s),o(rs.$$.fragment,s),gt=n(s),T=i(s,"DIV",{class:!0,"data-svelte-h":!0}),c(T)!=="svelte-y78yu"&&(T.innerHTML=Dt),Mt=n(s),gs=i(s,"P",{"data-svelte-h":!0}),c(gs)!=="svelte-1lh7bnx"&&(gs.innerHTML=Pt),ht=n(s),o(Ms.$$.fragment,s),yt=n(s),hs=i(s,"P",{"data-svelte-h":!0}),c(hs)!=="svelte-c93o6k"&&(hs.innerHTML=Kt),jt=n(s),o(ys.$$.fragment,s),ut=n(s),f=i(s,"DIV",{class:!0,"data-svelte-h":!0}),c(f)!=="svelte-1f4dev0"&&(f.innerHTML=Ot),bt=n(s),js=i(s,"P",{"data-svelte-h":!0}),c(js)!=="svelte-16bo4q7"&&(js.textContent=sl),Jt=n(s),u=i(s,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),wt(u).forEach(l),dt=n(s),bs=i(s,"P",{}),wt(bs).forEach(l),this.h()},h(){j(b,"name","hf:doc:metadata"),j(b,"content",gl),j(J,"class","flex justify-center"),j(d,"class","flex justify-center"),j(U,"class","flex justify-center"),j(w,"class","flex justify-center"),j(x,"class","flex justify-center"),j(T,"class","flex justify-center"),j(f,"class","flex justify-center"),al(u.src,tl="https://adirik-owl-vit.hf.space")||j(u,"src",tl),j(u,"frameborder","0"),j(u,"width","850"),j(u,"height","450")},m(s,t){ml(document.head,b),a(s,ds,t),a(s,us,t),a(s,Us,t),r(C,s,t),a(s,ws,t),r(W,s,t),a(s,xs,t),a(s,v,t),a(s,Ts,t),a(s,I,t),a(s,fs,t),a(s,k,t),a(s,Cs,t),a(s,$,t),a(s,Ws,t),a(s,R,t),a(s,vs,t),a(s,Q,t),a(s,Is,t),a(s,z,t),a(s,ks,t),r(Z,s,t),a(s,$s,t),r(V,s,t),a(s,Rs,t),a(s,_,t),a(s,Qs,t),r(B,s,t),a(s,zs,t),a(s,H,t),a(s,Zs,t),r(N,s,t),a(s,Vs,t),a(s,J,t),a(s,_s,t),a(s,X,t),a(s,Bs,t),r(q,s,t),a(s,Hs,t),a(s,G,t),a(s,Ns,t),r(Y,s,t),a(s,Xs,t),a(s,d,t),a(s,qs,t),r(E,s,t),a(s,Gs,t),a(s,S,t),a(s,Ys,t),a(s,F,t),a(s,Es,t),r(L,s,t),a(s,Ss,t),a(s,A,t),a(s,Fs,t),r(D,s,t),a(s,Ls,t),a(s,U,t),a(s,As,t),a(s,P,t),a(s,Ds,t),r(K,s,t),a(s,Ps,t),a(s,O,t),a(s,Ks,t),r(ss,s,t),a(s,Os,t),a(s,w,t),a(s,st,t),r(ts,s,t),a(s,tt,t),a(s,ls,t),a(s,lt,t),r(as,s,t),a(s,at,t),a(s,es,t),a(s,et,t),r(ns,s,t),a(s,nt,t),a(s,x,t),a(s,pt,t),r(ps,s,t),a(s,it,t),a(s,is,t),a(s,ct,t),a(s,cs,t),a(s,mt,t),r(ms,s,t),a(s,ot,t),a(s,os,t),a(s,rt,t),r(rs,s,t),a(s,gt,t),a(s,T,t),a(s,Mt,t),a(s,gs,t),a(s,ht,t),r(Ms,s,t),a(s,yt,t),a(s,hs,t),a(s,jt,t),r(ys,s,t),a(s,ut,t),a(s,f,t),a(s,bt,t),a(s,js,t),a(s,Jt,t),a(s,u,t),a(s,dt,t),a(s,bs,t),Ut=!0},p:el,i(s){Ut||(g(C.$$.fragment,s),g(W.$$.fragment,s),g(Z.$$.fragment,s),g(V.$$.fragment,s),g(B.$$.fragment,s),g(N.$$.fragment,s),g(q.$$.fragment,s),g(Y.$$.fragment,s),g(E.$$.fragment,s),g(L.$$.fragment,s),g(D.$$.fragment,s),g(K.$$.fragment,s),g(ss.$$.fragment,s),g(ts.$$.fragment,s),g(as.$$.fragment,s),g(ns.$$.fragment,s),g(ps.$$.fragment,s),g(ms.$$.fragment,s),g(rs.$$.fragment,s),g(Ms.$$.fragment,s),g(ys.$$.fragment,s),Ut=!0)},o(s){M(C.$$.fragment,s),M(W.$$.fragment,s),M(Z.$$.fragment,s),M(V.$$.fragment,s),M(B.$$.fragment,s),M(N.$$.fragment,s),M(q.$$.fragment,s),M(Y.$$.fragment,s),M(E.$$.fragment,s),M(L.$$.fragment,s),M(D.$$.fragment,s),M(K.$$.fragment,s),M(ss.$$.fragment,s),M(ts.$$.fragment,s),M(as.$$.fragment,s),M(ns.$$.fragment,s),M(ps.$$.fragment,s),M(ms.$$.fragment,s),M(rs.$$.fragment,s),M(Ms.$$.fragment,s),M(ys.$$.fragment,s),Ut=!1},d(s){s&&(l(ds),l(us),l(Us),l(ws),l(xs),l(v),l(Ts),l(I),l(fs),l(k),l(Cs),l($),l(Ws),l(R),l(vs),l(Q),l(Is),l(z),l(ks),l($s),l(Rs),l(_),l(Qs),l(zs),l(H),l(Zs),l(Vs),l(J),l(_s),l(X),l(Bs),l(Hs),l(G),l(Ns),l(Xs),l(d),l(qs),l(Gs),l(S),l(Ys),l(F),l(Es),l(Ss),l(A),l(Fs),l(Ls),l(U),l(As),l(P),l(Ds),l(Ps),l(O),l(Ks),l(Os),l(w),l(st),l(tt),l(ls),l(lt),l(at),l(es),l(et),l(nt),l(x),l(pt),l(it),l(is),l(ct),l(cs),l(mt),l(ot),l(os),l(rt),l(gt),l(T),l(Mt),l(gs),l(ht),l(yt),l(hs),l(jt),l(ut),l(f),l(bt),l(js),l(Jt),l(u),l(dt),l(bs)),l(b),h(C,s),h(W,s),h(Z,s),h(V,s),h(B,s),h(N,s),h(q,s),h(Y,s),h(E,s),h(L,s),h(D,s),h(K,s),h(ss,s),h(ts,s),h(as,s),h(ns,s),h(ps,s),h(ms,s),h(rs,s),h(Ms,s),h(ys,s)}}}const gl='{"title":"제로샷(zero-shot) 객체 탐지","local":"zeroshot-object-detection","sections":[{"title":"제로샷(zero-shot) 객체 탐지 파이프라인","local":"zeroshot-object-detection-pipeline","sections":[],"depth":2},{"title":"텍스트 프롬프트 기반 객체 탐지","local":"textprompted-zeroshot-object-detection-by-hand","sections":[],"depth":2},{"title":"일괄 처리","local":"batch-processing","sections":[],"depth":2},{"title":"이미지 가이드 객체 탐지","local":"imageguided-object-detection","sections":[],"depth":2}],"depth":1}';function Ml(xt){return nl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Jl extends pl{constructor(b){super(),il(this,b,Ml,rl,ll,{})}}export{Jl as component};
