import{s as sa,o as oa,n as Re}from"../chunks/scheduler.9bc65507.js";import{S as ra,i as la,g as m,s as o,r as h,A as ia,h as p,f as n,c as r,j as S,u,x as v,k,y as c,a as l,v as f,d as g,t as T,w as _}from"../chunks/index.707bf1b6.js";import{D as Z}from"../chunks/Docstring.17db21ae.js";import{C as Ie}from"../chunks/CodeBlock.54a9f38d.js";import{E as Ne}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{H as G}from"../chunks/Heading.342b1fa6.js";function ca(w){let s,y;return s=new Ie({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBhdGNoVFNUQ29uZmlnJTJDJTIwUGF0Y2hUU1RNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGFuJTIwUGF0Y2hUU1QlMjBjb25maWd1cmF0aW9uJTIwd2l0aCUyMDEyJTIwdGltZSUyMHN0ZXBzJTIwZm9yJTIwcHJlZGljdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBQYXRjaFRTVENvbmZpZyhwcmVkaWN0aW9uX2xlbmd0aCUzRDEyKSUwQSUwQSUyMyUyMFJhbmRvbWx5JTIwaW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBQYXRjaFRTVE1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PatchTSTConfig, PatchTSTModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing an PatchTST configuration with 12 time steps for prediction</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = PatchTSTConfig(prediction_length=<span class="hljs-number">12</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Randomly initializing a model (with random weights) from the configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PatchTSTModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){h(s.$$.fragment)},l(d){u(s.$$.fragment,d)},m(d,i){f(s,d,i),y=!0},p:Re,i(d){y||(g(s.$$.fragment,d),y=!0)},o(d){T(s.$$.fragment,d),y=!1},d(d){_(s,d)}}}function da(w){let s,y="Examples:",d,i,b;return i=new Ie({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBhdGNoVFNUTW9kZWwlMEElMEFmaWxlJTIwJTNEJTIwaGZfaHViX2Rvd25sb2FkKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZXR0aDEtaG91cmx5LWJhdGNoJTIyJTJDJTIwZmlsZW5hbWUlM0QlMjJ0cmFpbi1iYXRjaC5wdCUyMiUyQyUyMHJlcG9fdHlwZSUzRCUyMmRhdGFzZXQlMjIlMEEpJTBBYmF0Y2glMjAlM0QlMjB0b3JjaC5sb2FkKGZpbGUpJTBBJTBBbW9kZWwlMjAlM0QlMjBQYXRjaFRTVE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJuYW1jdGluJTJGcGF0Y2h0c3RfZXR0aDFfcHJldHJhaW4lMjIpJTBBJTBBJTIzJTIwZHVyaW5nJTIwdHJhaW5pbmclMkMlMjBvbmUlMjBwcm92aWRlcyUyMGJvdGglMjBwYXN0JTIwYW5kJTIwZnV0dXJlJTIwdmFsdWVzJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCUwQSUyMCUyMCUyMCUyMHBhc3RfdmFsdWVzJTNEYmF0Y2glNUIlMjJwYXN0X3ZhbHVlcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGZ1dHVyZV92YWx1ZXMlM0RiYXRjaCU1QiUyMmZ1dHVyZV92YWx1ZXMlMjIlNUQlMkMlMEEpJTBBJTBBbGFzdF9oaWRkZW5fc3RhdGUlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PatchTSTModel

<span class="hljs-meta">&gt;&gt;&gt; </span>file = hf_hub_download(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;hf-internal-testing/etth1-hourly-batch&quot;</span>, filename=<span class="hljs-string">&quot;train-batch.pt&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>batch = torch.load(file)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = PatchTSTModel.from_pretrained(<span class="hljs-string">&quot;namctin/patchtst_etth1_pretrain&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># during training, one provides both past and future values</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(
<span class="hljs-meta">... </span>    past_values=batch[<span class="hljs-string">&quot;past_values&quot;</span>],
<span class="hljs-meta">... </span>    future_values=batch[<span class="hljs-string">&quot;future_values&quot;</span>],
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_state = outputs.last_hidden_state`,wrap:!1}}),{c(){s=m("p"),s.textContent=y,d=o(),h(i.$$.fragment)},l(t){s=p(t,"P",{"data-svelte-h":!0}),v(s)!=="svelte-kvfsh7"&&(s.textContent=y),d=r(t),u(i.$$.fragment,t)},m(t,M){l(t,s,M),l(t,d,M),f(i,t,M),b=!0},p:Re,i(t){b||(g(i.$$.fragment,t),b=!0)},o(t){T(i.$$.fragment,t),b=!1},d(t){t&&(n(s),n(d)),_(i,t)}}}function ma(w){let s,y="Examples:",d,i,b;return i=new Ie({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBhdGNoVFNUQ29uZmlnJTJDJTIwUGF0Y2hUU1RGb3JQcmVkaWN0aW9uJTBBJTBBZmlsZSUyMCUzRCUyMGhmX2h1Yl9kb3dubG9hZCglMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmV0dGgxLWhvdXJseS1iYXRjaCUyMiUyQyUyMGZpbGVuYW1lJTNEJTIydHJhaW4tYmF0Y2gucHQlMjIlMkMlMjByZXBvX3R5cGUlM0QlMjJkYXRhc2V0JTIyJTBBKSUwQWJhdGNoJTIwJTNEJTIwdG9yY2gubG9hZChmaWxlKSUwQSUwQSUyMyUyMFByZWRpY3Rpb24lMjB0YXNrJTIwd2l0aCUyMDclMjBpbnB1dCUyMGNoYW5uZWxzJTIwYW5kJTIwcHJlZGljdGlvbiUyMGxlbmd0aCUyMGlzJTIwOTYlMEFtb2RlbCUyMCUzRCUyMFBhdGNoVFNURm9yUHJlZGljdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIybmFtY3RpbiUyRnBhdGNodHN0X2V0dGgxX2ZvcmVjYXN0JTIyKSUwQSUwQSUyMyUyMGR1cmluZyUyMHRyYWluaW5nJTJDJTIwb25lJTIwcHJvdmlkZXMlMjBib3RoJTIwcGFzdCUyMGFuZCUyMGZ1dHVyZSUyMHZhbHVlcyUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCglMEElMjAlMjAlMjAlMjBwYXN0X3ZhbHVlcyUzRGJhdGNoJTVCJTIycGFzdF92YWx1ZXMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBmdXR1cmVfdmFsdWVzJTNEYmF0Y2glNUIlMjJmdXR1cmVfdmFsdWVzJTIyJTVEJTJDJTBBKSUwQSUwQWxvc3MlMjAlM0QlMjBvdXRwdXRzLmxvc3MlMEFsb3NzLmJhY2t3YXJkKCklMEElMEElMjMlMjBkdXJpbmclMjBpbmZlcmVuY2UlMkMlMjBvbmUlMjBvbmx5JTIwcHJvdmlkZXMlMjBwYXN0JTIwdmFsdWVzJTJDJTIwdGhlJTIwbW9kZWwlMjBvdXRwdXRzJTIwZnV0dXJlJTIwdmFsdWVzJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKHBhc3RfdmFsdWVzJTNEYmF0Y2glNUIlMjJwYXN0X3ZhbHVlcyUyMiU1RCklMEFwcmVkaWN0aW9uX291dHB1dHMlMjAlM0QlMjBvdXRwdXRzLnByZWRpY3Rpb25fb3V0cHV0cw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PatchTSTConfig, PatchTSTForPrediction

<span class="hljs-meta">&gt;&gt;&gt; </span>file = hf_hub_download(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;hf-internal-testing/etth1-hourly-batch&quot;</span>, filename=<span class="hljs-string">&quot;train-batch.pt&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>batch = torch.load(file)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prediction task with 7 input channels and prediction length is 96</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PatchTSTForPrediction.from_pretrained(<span class="hljs-string">&quot;namctin/patchtst_etth1_forecast&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># during training, one provides both past and future values</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(
<span class="hljs-meta">... </span>    past_values=batch[<span class="hljs-string">&quot;past_values&quot;</span>],
<span class="hljs-meta">... </span>    future_values=batch[<span class="hljs-string">&quot;future_values&quot;</span>],
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span>loss.backward()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># during inference, one only provides past values, the model outputs future values</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(past_values=batch[<span class="hljs-string">&quot;past_values&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>prediction_outputs = outputs.prediction_outputs`,wrap:!1}}),{c(){s=m("p"),s.textContent=y,d=o(),h(i.$$.fragment)},l(t){s=p(t,"P",{"data-svelte-h":!0}),v(s)!=="svelte-kvfsh7"&&(s.textContent=y),d=r(t),u(i.$$.fragment,t)},m(t,M){l(t,s,M),l(t,d,M),f(i,t,M),b=!0},p:Re,i(t){b||(g(i.$$.fragment,t),b=!0)},o(t){T(i.$$.fragment,t),b=!1},d(t){t&&(n(s),n(d)),_(i,t)}}}function pa(w){let s,y="Examples:",d,i,b;return i=new Ie({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBhdGNoVFNUQ29uZmlnJTJDJTIwUGF0Y2hUU1RGb3JDbGFzc2lmaWNhdGlvbiUwQSUwQSUyMyUyMGNsYXNzaWZpY2F0aW9uJTIwdGFzayUyMHdpdGglMjB0d28lMjBpbnB1dCUyMGNoYW5uZWwyJTIwYW5kJTIwMyUyMGNsYXNzZXMlMEFjb25maWclMjAlM0QlMjBQYXRjaFRTVENvbmZpZyglMEElMjAlMjAlMjAlMjBudW1faW5wdXRfY2hhbm5lbHMlM0QyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RhcmdldHMlM0QzJTJDJTBBJTIwJTIwJTIwJTIwY29udGV4dF9sZW5ndGglM0Q1MTIlMkMlMEElMjAlMjAlMjAlMjBwYXRjaF9sZW5ndGglM0QxMiUyQyUwQSUyMCUyMCUyMCUyMHN0cmlkZSUzRDEyJTJDJTBBJTIwJTIwJTIwJTIwdXNlX2Nsc190b2tlbiUzRFRydWUlMkMlMEEpJTBBbW9kZWwlMjAlM0QlMjBQYXRjaFRTVEZvckNsYXNzaWZpY2F0aW9uKGNvbmZpZyUzRGNvbmZpZyklMEElMEElMjMlMjBkdXJpbmclMjBpbmZlcmVuY2UlMkMlMjBvbmUlMjBvbmx5JTIwcHJvdmlkZXMlMjBwYXN0JTIwdmFsdWVzJTBBcGFzdF92YWx1ZXMlMjAlM0QlMjB0b3JjaC5yYW5kbigyMCUyQyUyMDUxMiUyQyUyMDIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKHBhc3RfdmFsdWVzJTNEcGFzdF92YWx1ZXMpJTBBbGFiZWxzJTIwJTNEJTIwb3V0cHV0cy5wcmVkaWN0aW9uX2xvZ2l0cw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PatchTSTConfig, PatchTSTForClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># classification task with two input channel2 and 3 classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = PatchTSTConfig(
<span class="hljs-meta">... </span>    num_input_channels=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    num_targets=<span class="hljs-number">3</span>,
<span class="hljs-meta">... </span>    context_length=<span class="hljs-number">512</span>,
<span class="hljs-meta">... </span>    patch_length=<span class="hljs-number">12</span>,
<span class="hljs-meta">... </span>    stride=<span class="hljs-number">12</span>,
<span class="hljs-meta">... </span>    use_cls_token=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PatchTSTForClassification(config=config)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># during inference, one only provides past values</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_values = torch.randn(<span class="hljs-number">20</span>, <span class="hljs-number">512</span>, <span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(past_values=past_values)
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = outputs.prediction_logits`,wrap:!1}}),{c(){s=m("p"),s.textContent=y,d=o(),h(i.$$.fragment)},l(t){s=p(t,"P",{"data-svelte-h":!0}),v(s)!=="svelte-kvfsh7"&&(s.textContent=y),d=r(t),u(i.$$.fragment,t)},m(t,M){l(t,s,M),l(t,d,M),f(i,t,M),b=!0},p:Re,i(t){b||(g(i.$$.fragment,t),b=!0)},o(t){T(i.$$.fragment,t),b=!1},d(t){t&&(n(s),n(d)),_(i,t)}}}function ha(w){let s,y="Examples:",d,i,b;return i=new Ie({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBhdGNoVFNUQ29uZmlnJTJDJTIwUGF0Y2hUU1RGb3JQcmV0cmFpbmluZyUwQSUwQWZpbGUlMjAlM0QlMjBoZl9odWJfZG93bmxvYWQoJTBBJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZldHRoMS1ob3VybHktYmF0Y2glMjIlMkMlMjBmaWxlbmFtZSUzRCUyMnRyYWluLWJhdGNoLnB0JTIyJTJDJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiUwQSklMEFiYXRjaCUyMCUzRCUyMHRvcmNoLmxvYWQoZmlsZSklMEElMEElMjMlMjBDb25maWclMjBmb3IlMjByYW5kb20lMjBtYXNrJTIwcHJldHJhaW5pbmclMEFjb25maWclMjAlM0QlMjBQYXRjaFRTVENvbmZpZyglMEElMjAlMjAlMjAlMjBudW1faW5wdXRfY2hhbm5lbHMlM0Q3JTJDJTBBJTIwJTIwJTIwJTIwY29udGV4dF9sZW5ndGglM0Q1MTIlMkMlMEElMjAlMjAlMjAlMjBwYXRjaF9sZW5ndGglM0QxMiUyQyUwQSUyMCUyMCUyMCUyMHN0cmlkZSUzRDEyJTJDJTBBJTIwJTIwJTIwJTIwbWFza190eXBlJTNEJ3JhbmRvbSclMkMlMEElMjAlMjAlMjAlMjByYW5kb21fbWFza19yYXRpbyUzRDAuNCUyQyUwQSUyMCUyMCUyMCUyMHVzZV9jbHNfdG9rZW4lM0RUcnVlJTJDJTBBKSUwQSUyMyUyMENvbmZpZyUyMGZvciUyMGZvcmVjYXN0JTIwbWFzayUyMHByZXRyYWluaW5nJTBBY29uZmlnJTIwJTNEJTIwUGF0Y2hUU1RDb25maWcoJTBBJTIwJTIwJTIwJTIwbnVtX2lucHV0X2NoYW5uZWxzJTNENyUyQyUwQSUyMCUyMCUyMCUyMGNvbnRleHRfbGVuZ3RoJTNENTEyJTJDJTBBJTIwJTIwJTIwJTIwcGF0Y2hfbGVuZ3RoJTNEMTIlMkMlMEElMjAlMjAlMjAlMjBzdHJpZGUlM0QxMiUyQyUwQSUyMCUyMCUyMCUyMG1hc2tfdHlwZSUzRCdmb3JlY2FzdCclMkMlMEElMjAlMjAlMjAlMjBudW1fZm9yZWNhc3RfbWFza19wYXRjaGVzJTNENSUyQyUwQSUyMCUyMCUyMCUyMHVzZV9jbHNfdG9rZW4lM0RUcnVlJTJDJTBBKSUwQW1vZGVsJTIwJTNEJTIwUGF0Y2hUU1RGb3JQcmV0cmFpbmluZyhjb25maWcpJTBBJTBBJTIzJTIwZHVyaW5nJTIwdHJhaW5pbmclMkMlMjBvbmUlMjBwcm92aWRlcyUyMGJvdGglMjBwYXN0JTIwYW5kJTIwZnV0dXJlJTIwdmFsdWVzJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKHBhc3RfdmFsdWVzJTNEYmF0Y2glNUIlMjJwYXN0X3ZhbHVlcyUyMiU1RCklMEElMEFsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTBBbG9zcy5iYWNrd2FyZCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PatchTSTConfig, PatchTSTForPretraining

<span class="hljs-meta">&gt;&gt;&gt; </span>file = hf_hub_download(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;hf-internal-testing/etth1-hourly-batch&quot;</span>, filename=<span class="hljs-string">&quot;train-batch.pt&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>batch = torch.load(file)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Config for random mask pretraining</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = PatchTSTConfig(
<span class="hljs-meta">... </span>    num_input_channels=<span class="hljs-number">7</span>,
<span class="hljs-meta">... </span>    context_length=<span class="hljs-number">512</span>,
<span class="hljs-meta">... </span>    patch_length=<span class="hljs-number">12</span>,
<span class="hljs-meta">... </span>    stride=<span class="hljs-number">12</span>,
<span class="hljs-meta">... </span>    mask_type=<span class="hljs-string">&#x27;random&#x27;</span>,
<span class="hljs-meta">... </span>    random_mask_ratio=<span class="hljs-number">0.4</span>,
<span class="hljs-meta">... </span>    use_cls_token=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Config for forecast mask pretraining</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = PatchTSTConfig(
<span class="hljs-meta">... </span>    num_input_channels=<span class="hljs-number">7</span>,
<span class="hljs-meta">... </span>    context_length=<span class="hljs-number">512</span>,
<span class="hljs-meta">... </span>    patch_length=<span class="hljs-number">12</span>,
<span class="hljs-meta">... </span>    stride=<span class="hljs-number">12</span>,
<span class="hljs-meta">... </span>    mask_type=<span class="hljs-string">&#x27;forecast&#x27;</span>,
<span class="hljs-meta">... </span>    num_forecast_mask_patches=<span class="hljs-number">5</span>,
<span class="hljs-meta">... </span>    use_cls_token=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PatchTSTForPretraining(config)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># during training, one provides both past and future values</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(past_values=batch[<span class="hljs-string">&quot;past_values&quot;</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span>loss.backward()`,wrap:!1}}),{c(){s=m("p"),s.textContent=y,d=o(),h(i.$$.fragment)},l(t){s=p(t,"P",{"data-svelte-h":!0}),v(s)!=="svelte-kvfsh7"&&(s.textContent=y),d=r(t),u(i.$$.fragment,t)},m(t,M){l(t,s,M),l(t,d,M),f(i,t,M),b=!0},p:Re,i(t){b||(g(i.$$.fragment,t),b=!0)},o(t){T(i.$$.fragment,t),b=!1},d(t){t&&(n(s),n(d)),_(i,t)}}}function ua(w){let s,y="Examples:",d,i,b;return i=new Ie({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBhdGNoVFNUQ29uZmlnJTJDJTIwUGF0Y2hUU1RGb3JSZWdyZXNzaW9uJTBBJTBBJTIzJTIwUmVncmVzc2lvbiUyMHRhc2slMjB3aXRoJTIwNiUyMGlucHV0JTIwY2hhbm5lbHMlMjBhbmQlMjByZWdyZXNzJTIwMiUyMHRhcmdldHMlMEFtb2RlbCUyMCUzRCUyMFBhdGNoVFNURm9yUmVncmVzc2lvbi5mcm9tX3ByZXRyYWluZWQoJTIybmFtY3RpbiUyRnBhdGNodHN0X2V0dGgxX3JlZ3Jlc3Npb24lMjIpJTBBJTBBJTIzJTIwZHVyaW5nJTIwaW5mZXJlbmNlJTJDJTIwb25lJTIwb25seSUyMHByb3ZpZGVzJTIwcGFzdCUyMHZhbHVlcyUyQyUyMHRoZSUyMG1vZGVsJTIwb3V0cHV0cyUyMGZ1dHVyZSUyMHZhbHVlcyUwQXBhc3RfdmFsdWVzJTIwJTNEJTIwdG9yY2gucmFuZG4oMjAlMkMlMjA1MTIlMkMlMjA2KSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbChwYXN0X3ZhbHVlcyUzRHBhc3RfdmFsdWVzKSUwQXJlZ3Jlc3Npb25fb3V0cHV0cyUyMCUzRCUyMG91dHB1dHMucmVncmVzc2lvbl9vdXRwdXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PatchTSTConfig, PatchTSTForRegression

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Regression task with 6 input channels and regress 2 targets</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PatchTSTForRegression.from_pretrained(<span class="hljs-string">&quot;namctin/patchtst_etth1_regression&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># during inference, one only provides past values, the model outputs future values</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_values = torch.randn(<span class="hljs-number">20</span>, <span class="hljs-number">512</span>, <span class="hljs-number">6</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(past_values=past_values)
<span class="hljs-meta">&gt;&gt;&gt; </span>regression_outputs = outputs.regression_outputs`,wrap:!1}}),{c(){s=m("p"),s.textContent=y,d=o(),h(i.$$.fragment)},l(t){s=p(t,"P",{"data-svelte-h":!0}),v(s)!=="svelte-kvfsh7"&&(s.textContent=y),d=r(t),u(i.$$.fragment,t)},m(t,M){l(t,s,M),l(t,d,M),f(i,t,M),b=!0},p:Re,i(t){b||(g(i.$$.fragment,t),b=!0)},o(t){T(i.$$.fragment,t),b=!1},d(t){t&&(n(s),n(d)),_(i,t)}}}function fa(w){let s,y,d,i,b,t,M,He,A,Nt='The PatchTST model was proposed in <a href="https://arxiv.org/abs/2211.14730" rel="nofollow">A Time Series is Worth 64 Words: Long-term Forecasting with Transformers</a> by Yuqi Nie, Nam H. Nguyen, Phanwadee Sinthong and Jayant Kalagnanam.',Ye,O,Rt="At a high level the model vectorizes time series into patches of a given size and encodes the resulting sequence of vectors via a Transformer that then outputs the prediction length forecast via an appropriate head. The model is illustrated in the following figure:",ze,K,It='<img src="https://github.com/namctin/transformers/assets/8100/150af169-29de-419a-8d98-eb78251c21fa" alt="model"/>',Xe,ee,Vt="The abstract from the paper is the following:",Ee,te,Ht="<em>We propose an efficient design of Transformer-based models for multivariate time series forecasting and self-supervised representation learning. It is based on two key components: (i) segmentation of time series into subseries-level patches which are served as input tokens to Transformer; (ii) channel-independence where each channel contains a single univariate time series that shares the same embedding and Transformer weights across all the series. Patching design naturally has three-fold benefit: local semantic information is retained in the embedding; computation and memory usage of the attention maps are quadratically reduced given the same look-back window; and the model can attend longer history. Our channel-independent patch time series Transformer (PatchTST) can improve the long-term forecasting accuracy significantly when compared with that of SOTA Transformer-based models. We also apply our model to self-supervised pre-training tasks and attain excellent fine-tuning performance, which outperforms supervised training on large datasets. Transferring of masked pre-trained representation on one dataset to others also produces SOTA forecasting accuracy.</em>",qe,ae,Yt='This model was contributed by <a href="https://huggingface.co/namctin" rel="nofollow">namctin</a>, <a href="https://huggingface.co/gsinthong" rel="nofollow">gsinthong</a>, <a href="https://huggingface.co/diepi" rel="nofollow">diepi</a>, <a href="https://huggingface.co/vijaye12" rel="nofollow">vijaye12</a>, <a href="https://huggingface.co/wmgifford" rel="nofollow">wmgifford</a>, and <a href="https://huggingface.co/kashif" rel="nofollow">kashif</a>. The original code can be found <a href="https://github.com/yuqinie98/PatchTST" rel="nofollow">here</a>.',Qe,ne,De,se,zt='The model can also be used for time series classification and time series regression. See the respective <a href="/docs/transformers/v4.39.1/en/model_doc/patchtst#transformers.PatchTSTForClassification">PatchTSTForClassification</a> and <a href="/docs/transformers/v4.39.1/en/model_doc/patchtst#transformers.PatchTSTForRegression">PatchTSTForRegression</a> classes.',Le,oe,Ae,re,Xt='<li>A blog post explaining PatchTST in depth can be found <a href="https://huggingface.co/blog/patchtst" rel="nofollow">here</a>. The blog can also be opened in Google Colab.</li>',Oe,le,Ke,j,ie,ft,Je,Et=`This is the configuration class to store the configuration of an <a href="/docs/transformers/v4.39.1/en/model_doc/patchtst#transformers.PatchTSTModel">PatchTSTModel</a>. It is used to instantiate an
PatchTST model according to the specified arguments, defining the model architecture.
<a href="https://huggingface.co/ibm/patchtst" rel="nofollow">ibm/patchtst</a> architecture.`,gt,Ue,qt=`Configuration objects inherit from <a href="/docs/transformers/v4.39.1/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.39.1/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Tt,N,et,ce,tt,$,de,_t,Pe,Qt=`The bare PatchTST Model outputting raw hidden-states without any specific head.
This model inherits from <a href="/docs/transformers/v4.39.1/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,bt,Ce,Dt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Mt,R,me,vt,I,at,pe,nt,J,he,yt,Se,Lt=`The PatchTST for prediction model.
This model inherits from <a href="/docs/transformers/v4.39.1/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,wt,ke,At=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,jt,V,ue,$t,H,st,fe,ot,U,ge,Jt,xe,Ot=`The PatchTST for classification model.
This model inherits from <a href="/docs/transformers/v4.39.1/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Ut,Fe,Kt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Pt,Y,Te,Ct,z,rt,_e,lt,P,be,St,Be,ea=`The PatchTST for pretrain model.
This model inherits from <a href="/docs/transformers/v4.39.1/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,kt,We,ta=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,xt,X,Me,Ft,E,it,ve,ct,C,ye,Bt,Ze,aa=`The PatchTST for regression model.
This model inherits from <a href="/docs/transformers/v4.39.1/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Wt,Ge,na=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Zt,q,we,Gt,Q,dt,Ve,mt;return b=new G({props:{title:"PatchTST",local:"patchtst",headingTag:"h1"}}),M=new G({props:{title:"Overview",local:"overview",headingTag:"h2"}}),ne=new G({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),oe=new G({props:{title:"Resources",local:"resources",headingTag:"h2"}}),le=new G({props:{title:"PatchTSTConfig",local:"transformers.PatchTSTConfig",headingTag:"h2"}}),ie=new Z({props:{name:"class transformers.PatchTSTConfig",anchor:"transformers.PatchTSTConfig",parameters:[{name:"num_input_channels",val:": int = 1"},{name:"context_length",val:": int = 32"},{name:"distribution_output",val:": str = 'student_t'"},{name:"loss",val:": str = 'mse'"},{name:"patch_length",val:": int = 1"},{name:"patch_stride",val:": int = 1"},{name:"num_hidden_layers",val:": int = 3"},{name:"d_model",val:": int = 128"},{name:"num_attention_heads",val:": int = 4"},{name:"share_embedding",val:": bool = True"},{name:"channel_attention",val:": bool = False"},{name:"ffn_dim",val:": int = 512"},{name:"norm_type",val:": str = 'batchnorm'"},{name:"norm_eps",val:": float = 1e-05"},{name:"attention_dropout",val:": float = 0.0"},{name:"dropout",val:": float = 0.0"},{name:"positional_dropout",val:": float = 0.0"},{name:"path_dropout",val:": float = 0.0"},{name:"ff_dropout",val:": float = 0.0"},{name:"bias",val:": bool = True"},{name:"activation_function",val:": str = 'gelu'"},{name:"pre_norm",val:": bool = True"},{name:"positional_encoding_type",val:": str = 'sincos'"},{name:"use_cls_token",val:": bool = False"},{name:"init_std",val:": float = 0.02"},{name:"share_projection",val:": bool = True"},{name:"scaling",val:": Union = 'std'"},{name:"do_mask_input",val:": Optional = None"},{name:"mask_type",val:": str = 'random'"},{name:"random_mask_ratio",val:": float = 0.5"},{name:"num_forecast_mask_patches",val:": Union = [2]"},{name:"channel_consistent_masking",val:": Optional = False"},{name:"unmasked_channel_indices",val:": Optional = None"},{name:"mask_value",val:": int = 0"},{name:"pooling_type",val:": str = 'mean'"},{name:"head_dropout",val:": float = 0.0"},{name:"prediction_length",val:": int = 24"},{name:"num_targets",val:": int = 1"},{name:"output_range",val:": Optional = None"},{name:"num_parallel_samples",val:": int = 100"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PatchTSTConfig.num_input_channels",description:`<strong>num_input_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The size of the target variable which by default is 1 for univariate targets. Would be &gt; 1 in case of
multivariate targets.`,name:"num_input_channels"},{anchor:"transformers.PatchTSTConfig.context_length",description:`<strong>context_length</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
The context length of the input sequence.`,name:"context_length"},{anchor:"transformers.PatchTSTConfig.distribution_output",description:`<strong>distribution_output</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;student_t&quot;</code>) &#x2014;
The distribution emission head for the model when loss is &#x201C;nll&#x201D;. Could be either &#x201C;student_t&#x201D;, &#x201C;normal&#x201D; or
&#x201C;negative_binomial&#x201D;.`,name:"distribution_output"},{anchor:"transformers.PatchTSTConfig.loss",description:`<strong>loss</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;mse&quot;</code>) &#x2014;
The loss function for the model corresponding to the <code>distribution_output</code> head. For parametric
distributions it is the negative log likelihood (&#x201C;nll&#x201D;) and for point estimates it is the mean squared
error &#x201C;mse&#x201D;.`,name:"loss"},{anchor:"transformers.PatchTSTConfig.patch_length",description:`<strong>patch_length</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Define the patch length of the patchification process.`,name:"patch_length"},{anchor:"transformers.PatchTSTConfig.patch_stride",description:`<strong>patch_stride</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Define the stride of the patchification process.`,name:"patch_stride"},{anchor:"transformers.PatchTSTConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Number of hidden layers.`,name:"num_hidden_layers"},{anchor:"transformers.PatchTSTConfig.d_model",description:`<strong>d_model</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
Dimensionality of the transformer layers.`,name:"d_model"},{anchor:"transformers.PatchTSTConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.PatchTSTConfig.share_embedding",description:`<strong>share_embedding</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Sharing the input embedding across all channels.`,name:"share_embedding"},{anchor:"transformers.PatchTSTConfig.channel_attention",description:`<strong>channel_attention</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Activate channel attention block in the Transformer to allow channels to attend each other.`,name:"channel_attention"},{anchor:"transformers.PatchTSTConfig.ffn_dim",description:`<strong>ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Dimension of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in the Transformer encoder.`,name:"ffn_dim"},{anchor:"transformers.PatchTSTConfig.norm_type",description:`<strong>norm_type</strong> (<code>str</code> , <em>optional</em>, defaults to <code>&quot;batchnorm&quot;</code>) &#x2014;
Normalization at each Transformer layer. Can be <code>&quot;batchnorm&quot;</code> or <code>&quot;layernorm&quot;</code>.`,name:"norm_type"},{anchor:"transformers.PatchTSTConfig.norm_eps",description:`<strong>norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
A value added to the denominator for numerical stability of normalization.`,name:"norm_eps"},{anchor:"transformers.PatchTSTConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.PatchTSTConfig.dropout",description:`<strong>dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for all fully connected layers in the Transformer.`,name:"dropout"},{anchor:"transformers.PatchTSTConfig.positional_dropout",description:`<strong>positional_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability in the positional embedding layer.`,name:"positional_dropout"},{anchor:"transformers.PatchTSTConfig.path_dropout",description:`<strong>path_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout path in the residual block.`,name:"path_dropout"},{anchor:"transformers.PatchTSTConfig.ff_dropout",description:`<strong>ff_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability used between the two layers of the feed-forward networks.`,name:"ff_dropout"},{anchor:"transformers.PatchTSTConfig.bias",description:`<strong>bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add bias in the feed-forward networks.`,name:"bias"},{anchor:"transformers.PatchTSTConfig.activation_function",description:`<strong>activation_function</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (string) in the Transformer.<code>&quot;gelu&quot;</code> and <code>&quot;relu&quot;</code> are supported.`,name:"activation_function"},{anchor:"transformers.PatchTSTConfig.pre_norm",description:`<strong>pre_norm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Normalization is applied before self-attention if pre_norm is set to <code>True</code>. Otherwise, normalization is
applied after residual block.`,name:"pre_norm"},{anchor:"transformers.PatchTSTConfig.positional_encoding_type",description:`<strong>positional_encoding_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;sincos&quot;</code>) &#x2014;
Positional encodings. Options <code>&quot;random&quot;</code> and <code>&quot;sincos&quot;</code> are supported.`,name:"positional_encoding_type"},{anchor:"transformers.PatchTSTConfig.use_cls_token",description:`<strong>use_cls_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether cls token is used.`,name:"use_cls_token"},{anchor:"transformers.PatchTSTConfig.init_std",description:`<strong>init_std</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated normal weight initialization distribution.`,name:"init_std"},{anchor:"transformers.PatchTSTConfig.share_projection",description:`<strong>share_projection</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Sharing the projection layer across different channels in the forecast head.`,name:"share_projection"},{anchor:"transformers.PatchTSTConfig.scaling",description:`<strong>scaling</strong> (<code>Union</code>, <em>optional</em>, defaults to <code>&quot;std&quot;</code>) &#x2014;
Whether to scale the input targets via &#x201C;mean&#x201D; scaler, &#x201C;std&#x201D; scaler or no scaler if <code>None</code>. If <code>True</code>, the
scaler is set to &#x201C;mean&#x201D;.`,name:"scaling"},{anchor:"transformers.PatchTSTConfig.do_mask_input",description:`<strong>do_mask_input</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Apply masking during the pretraining.`,name:"do_mask_input"},{anchor:"transformers.PatchTSTConfig.mask_type",description:`<strong>mask_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;random&quot;</code>) &#x2014;
Masking type. Only <code>&quot;random&quot;</code> and <code>&quot;forecast&quot;</code> are currently supported.`,name:"mask_type"},{anchor:"transformers.PatchTSTConfig.random_mask_ratio",description:`<strong>random_mask_ratio</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Masking ratio applied to mask the input data during random pretraining.`,name:"random_mask_ratio"},{anchor:"transformers.PatchTSTConfig.num_forecast_mask_patches",description:`<strong>num_forecast_mask_patches</strong> (<code>int</code> or <code>list</code>, <em>optional</em>, defaults to <code>[2]</code>) &#x2014;
Number of patches to be masked at the end of each batch sample. If it is an integer,
all the samples in the batch will have the same number of masked patches. If it is a list,
samples in the batch will be randomly masked by numbers defined in the list. This argument is only used
for forecast pretraining.`,name:"num_forecast_mask_patches"},{anchor:"transformers.PatchTSTConfig.channel_consistent_masking",description:`<strong>channel_consistent_masking</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If channel consistent masking is True, all the channels will have the same masking pattern.`,name:"channel_consistent_masking"},{anchor:"transformers.PatchTSTConfig.unmasked_channel_indices",description:`<strong>unmasked_channel_indices</strong> (<code>list</code>, <em>optional</em>) &#x2014;
Indices of channels that are not masked during pretraining. Values in the list are number between 1 and
<code>num_input_channels</code>`,name:"unmasked_channel_indices"},{anchor:"transformers.PatchTSTConfig.mask_value",description:`<strong>mask_value</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Values in the masked patches will be filled by <code>mask_value</code>.`,name:"mask_value"},{anchor:"transformers.PatchTSTConfig.pooling_type",description:`<strong>pooling_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;mean&quot;</code>) &#x2014;
Pooling of the embedding. <code>&quot;mean&quot;</code>, <code>&quot;max&quot;</code> and <code>None</code> are supported.`,name:"pooling_type"},{anchor:"transformers.PatchTSTConfig.head_dropout",description:`<strong>head_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for head.`,name:"head_dropout"},{anchor:"transformers.PatchTSTConfig.prediction_length",description:`<strong>prediction_length</strong> (<code>int</code>, <em>optional</em>, defaults to 24) &#x2014;
The prediction horizon that the model will output.`,name:"prediction_length"},{anchor:"transformers.PatchTSTConfig.num_targets",description:`<strong>num_targets</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of targets for regression and classification tasks. For classification, it is the number of
classes.`,name:"num_targets"},{anchor:"transformers.PatchTSTConfig.output_range",description:`<strong>output_range</strong> (<code>list</code>, <em>optional</em>) &#x2014;
Output range for regression task. The range of output values can be set to enforce the model to produce
values within a range.`,name:"output_range"},{anchor:"transformers.PatchTSTConfig.num_parallel_samples",description:`<strong>num_parallel_samples</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of samples is generated in parallel for probabilistic prediction.`,name:"num_parallel_samples"}],source:"https://github.com/huggingface/transformers/blob/v4.39.1/src/transformers/models/patchtst/configuration_patchtst.py#L31"}}),N=new Ne({props:{anchor:"transformers.PatchTSTConfig.example",$$slots:{default:[ca]},$$scope:{ctx:w}}}),ce=new G({props:{title:"PatchTSTModel",local:"transformers.PatchTSTModel",headingTag:"h2"}}),de=new Z({props:{name:"class transformers.PatchTSTModel",anchor:"transformers.PatchTSTModel",parameters:[{name:"config",val:": PatchTSTConfig"}],parametersDescription:[{anchor:"transformers.PatchTSTModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.39.1/en/model_doc/patchtst#transformers.PatchTSTConfig">PatchTSTConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/v4.39.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.39.1/src/transformers/models/patchtst/modeling_patchtst.py#L1147"}}),me=new Z({props:{name:"forward",anchor:"transformers.PatchTSTModel.forward",parameters:[{name:"past_values",val:": Tensor"},{name:"past_observed_mask",val:": Optional = None"},{name:"future_values",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.PatchTSTModel.forward.past_values",description:`<strong>past_values</strong> (<code>torch.Tensor</code> of shape <code>(bs, sequence_length, num_input_channels)</code>, <em>required</em>) &#x2014;
Input sequence to the model`,name:"past_values"},{anchor:"transformers.PatchTSTModel.forward.past_observed_mask",description:`<strong>past_observed_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, sequence_length, num_input_channels)</code>, <em>optional</em>) &#x2014;
Boolean mask to indicate which <code>past_values</code> were observed and which were missing. Mask values selected
in <code>[0, 1]</code>:</p>
<ul>
<li>1 for values that are <strong>observed</strong>,</li>
<li>0 for values that are <strong>missing</strong> (i.e. NaNs that were replaced by zeros).</li>
</ul>`,name:"past_observed_mask"},{anchor:"transformers.PatchTSTModel.forward.future_values",description:`<strong>future_values</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, prediction_length, num_input_channels)</code>, <em>optional</em>) &#x2014;
Future target values associated with the <code>past_values</code>`,name:"future_values"},{anchor:"transformers.PatchTSTModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers`,name:"output_hidden_states"},{anchor:"transformers.PatchTSTModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the output attention of all layers`,name:"output_attentions"},{anchor:"transformers.PatchTSTModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <code>ModelOutput</code> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.39.1/src/transformers/models/patchtst/modeling_patchtst.py#L1170",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PatchTSTModelOutput</code> or tuple of <code>torch.Tensor</code> (if <code>return_dict</code>=False or <code>config.return_dict</code>=False)</p>
`}}),I=new Ne({props:{anchor:"transformers.PatchTSTModel.forward.example",$$slots:{default:[da]},$$scope:{ctx:w}}}),pe=new G({props:{title:"PatchTSTForPrediction",local:"transformers.PatchTSTForPrediction",headingTag:"h2"}}),he=new Z({props:{name:"class transformers.PatchTSTForPrediction",anchor:"transformers.PatchTSTForPrediction",parameters:[{name:"config",val:": PatchTSTConfig"}],parametersDescription:[{anchor:"transformers.PatchTSTForPrediction.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.39.1/en/model_doc/patchtst#transformers.PatchTSTConfig">PatchTSTConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/v4.39.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.39.1/src/transformers/models/patchtst/modeling_patchtst.py#L1638"}}),ue=new Z({props:{name:"forward",anchor:"transformers.PatchTSTForPrediction.forward",parameters:[{name:"past_values",val:": Tensor"},{name:"past_observed_mask",val:": Optional = None"},{name:"future_values",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.PatchTSTForPrediction.forward.past_values",description:`<strong>past_values</strong> (<code>torch.Tensor</code> of shape <code>(bs, sequence_length, num_input_channels)</code>, <em>required</em>) &#x2014;
Input sequence to the model`,name:"past_values"},{anchor:"transformers.PatchTSTForPrediction.forward.past_observed_mask",description:`<strong>past_observed_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, sequence_length, num_input_channels)</code>, <em>optional</em>) &#x2014;
Boolean mask to indicate which <code>past_values</code> were observed and which were missing. Mask values selected
in <code>[0, 1]</code>:</p>
<ul>
<li>1 for values that are <strong>observed</strong>,</li>
<li>0 for values that are <strong>missing</strong> (i.e. NaNs that were replaced by zeros).</li>
</ul>`,name:"past_observed_mask"},{anchor:"transformers.PatchTSTForPrediction.forward.future_values",description:`<strong>future_values</strong> (<code>torch.Tensor</code> of shape <code>(bs, forecast_len, num_input_channels)</code>, <em>optional</em>) &#x2014;
Future target values associated with the <code>past_values</code>`,name:"future_values"},{anchor:"transformers.PatchTSTForPrediction.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers`,name:"output_hidden_states"},{anchor:"transformers.PatchTSTForPrediction.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the output attention of all layers`,name:"output_attentions"},{anchor:"transformers.PatchTSTForPrediction.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <code>ModelOutput</code> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.39.1/src/transformers/models/patchtst/modeling_patchtst.py#L1672",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PatchTSTForPredictionOutput</code> or tuple of <code>torch.Tensor</code> (if <code>return_dict</code>=False or
<code>config.return_dict</code>=False)</p>
`}}),H=new Ne({props:{anchor:"transformers.PatchTSTForPrediction.forward.example",$$slots:{default:[ma]},$$scope:{ctx:w}}}),fe=new G({props:{title:"PatchTSTForClassification",local:"transformers.PatchTSTForClassification",headingTag:"h2"}}),ge=new Z({props:{name:"class transformers.PatchTSTForClassification",anchor:"transformers.PatchTSTForClassification",parameters:[{name:"config",val:": PatchTSTConfig"}],parametersDescription:[{anchor:"transformers.PatchTSTForClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.39.1/en/model_doc/patchtst#transformers.PatchTSTConfig">PatchTSTConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/v4.39.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.39.1/src/transformers/models/patchtst/modeling_patchtst.py#L1443"}}),Te=new Z({props:{name:"forward",anchor:"transformers.PatchTSTForClassification.forward",parameters:[{name:"past_values",val:": Tensor"},{name:"target_values",val:": Tensor = None"},{name:"past_observed_mask",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.PatchTSTForClassification.forward.past_values",description:`<strong>past_values</strong> (<code>torch.Tensor</code> of shape <code>(bs, sequence_length, num_input_channels)</code>, <em>required</em>) &#x2014;
Input sequence to the model`,name:"past_values"},{anchor:"transformers.PatchTSTForClassification.forward.target_values",description:`<strong>target_values</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Labels associates with the <code>past_values</code>`,name:"target_values"},{anchor:"transformers.PatchTSTForClassification.forward.past_observed_mask",description:`<strong>past_observed_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, sequence_length, num_input_channels)</code>, <em>optional</em>) &#x2014;
Boolean mask to indicate which <code>past_values</code> were observed and which were missing. Mask values selected
in <code>[0, 1]</code>:</p>
<ul>
<li>1 for values that are <strong>observed</strong>,</li>
<li>0 for values that are <strong>missing</strong> (i.e. NaNs that were replaced by zeros).</li>
</ul>`,name:"past_observed_mask"},{anchor:"transformers.PatchTSTForClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers`,name:"output_hidden_states"},{anchor:"transformers.PatchTSTForClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the output attention of all layers`,name:"output_attentions"},{anchor:"transformers.PatchTSTForClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <code>ModelOutput</code> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.39.1/src/transformers/models/patchtst/modeling_patchtst.py#L1462",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PatchTSTForClassificationOutput</code> or tuple of <code>torch.Tensor</code> (if <code>return_dict</code>=False or
<code>config.return_dict</code>=False)</p>
`}}),z=new Ne({props:{anchor:"transformers.PatchTSTForClassification.forward.example",$$slots:{default:[pa]},$$scope:{ctx:w}}}),_e=new G({props:{title:"PatchTSTForPretraining",local:"transformers.PatchTSTForPretraining",headingTag:"h2"}}),be=new Z({props:{name:"class transformers.PatchTSTForPretraining",anchor:"transformers.PatchTSTForPretraining",parameters:[{name:"config",val:": PatchTSTConfig"}],parametersDescription:[{anchor:"transformers.PatchTSTForPretraining.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.39.1/en/model_doc/patchtst#transformers.PatchTSTConfig">PatchTSTConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/v4.39.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.39.1/src/transformers/models/patchtst/modeling_patchtst.py#L1291"}}),Me=new Z({props:{name:"forward",anchor:"transformers.PatchTSTForPretraining.forward",parameters:[{name:"past_values",val:": Tensor"},{name:"past_observed_mask",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.PatchTSTForPretraining.forward.past_values",description:`<strong>past_values</strong> (<code>torch.Tensor</code> of shape <code>(bs, sequence_length, num_input_channels)</code>, <em>required</em>) &#x2014;
Input sequence to the model`,name:"past_values"},{anchor:"transformers.PatchTSTForPretraining.forward.past_observed_mask",description:`<strong>past_observed_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, sequence_length, num_input_channels)</code>, <em>optional</em>) &#x2014;
Boolean mask to indicate which <code>past_values</code> were observed and which were missing. Mask values selected
in <code>[0, 1]</code>:</p>
<ul>
<li>1 for values that are <strong>observed</strong>,</li>
<li>0 for values that are <strong>missing</strong> (i.e. NaNs that were replaced by zeros).</li>
</ul>`,name:"past_observed_mask"},{anchor:"transformers.PatchTSTForPretraining.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers`,name:"output_hidden_states"},{anchor:"transformers.PatchTSTForPretraining.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the output attention of all layers`,name:"output_attentions"},{anchor:"transformers.PatchTSTForPretraining.forward.return_dict",description:"<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014; Whether or not to return a <code>ModelOutput</code> instead of a plain tuple.",name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.39.1/src/transformers/models/patchtst/modeling_patchtst.py#L1306",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PatchTSTForPretrainingOutput</code> or tuple of <code>torch.Tensor</code> (if <code>return_dict</code>=False or
<code>config.return_dict</code>=False)</p>
`}}),E=new Ne({props:{anchor:"transformers.PatchTSTForPretraining.forward.example",$$slots:{default:[ha]},$$scope:{ctx:w}}}),ve=new G({props:{title:"PatchTSTForRegression",local:"transformers.PatchTSTForRegression",headingTag:"h2"}}),ye=new Z({props:{name:"class transformers.PatchTSTForRegression",anchor:"transformers.PatchTSTForRegression",parameters:[{name:"config",val:": PatchTSTConfig"}],parametersDescription:[{anchor:"transformers.PatchTSTForRegression.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.39.1/en/model_doc/patchtst#transformers.PatchTSTConfig">PatchTSTConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/v4.39.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.39.1/src/transformers/models/patchtst/modeling_patchtst.py#L1884"}}),we=new Z({props:{name:"forward",anchor:"transformers.PatchTSTForRegression.forward",parameters:[{name:"past_values",val:": Tensor"},{name:"target_values",val:": Tensor = None"},{name:"past_observed_mask",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.PatchTSTForRegression.forward.past_values",description:`<strong>past_values</strong> (<code>torch.Tensor</code> of shape <code>(bs, sequence_length, num_input_channels)</code>, <em>required</em>) &#x2014;
Input sequence to the model`,name:"past_values"},{anchor:"transformers.PatchTSTForRegression.forward.target_values",description:`<strong>target_values</strong> (<code>torch.Tensor</code> of shape <code>(bs, num_input_channels)</code>) &#x2014;
Target values associates with the <code>past_values</code>`,name:"target_values"},{anchor:"transformers.PatchTSTForRegression.forward.past_observed_mask",description:`<strong>past_observed_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, sequence_length, num_input_channels)</code>, <em>optional</em>) &#x2014;
Boolean mask to indicate which <code>past_values</code> were observed and which were missing. Mask values selected
in <code>[0, 1]</code>:</p>
<ul>
<li>1 for values that are <strong>observed</strong>,</li>
<li>0 for values that are <strong>missing</strong> (i.e. NaNs that were replaced by zeros).</li>
</ul>`,name:"past_observed_mask"},{anchor:"transformers.PatchTSTForRegression.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers`,name:"output_hidden_states"},{anchor:"transformers.PatchTSTForRegression.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the output attention of all layers`,name:"output_attentions"},{anchor:"transformers.PatchTSTForRegression.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <code>ModelOutput</code> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.39.1/src/transformers/models/patchtst/modeling_patchtst.py#L1915",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PatchTSTForRegressionOutput</code> or tuple of <code>torch.Tensor</code> (if <code>return_dict</code>=False or
<code>config.return_dict</code>=False)</p>
`}}),Q=new Ne({props:{anchor:"transformers.PatchTSTForRegression.forward.example",$$slots:{default:[ua]},$$scope:{ctx:w}}}),{c(){s=m("meta"),y=o(),d=m("p"),i=o(),h(b.$$.fragment),t=o(),h(M.$$.fragment),He=o(),A=m("p"),A.innerHTML=Nt,Ye=o(),O=m("p"),O.textContent=Rt,ze=o(),K=m("p"),K.innerHTML=It,Xe=o(),ee=m("p"),ee.textContent=Vt,Ee=o(),te=m("p"),te.innerHTML=Ht,qe=o(),ae=m("p"),ae.innerHTML=Yt,Qe=o(),h(ne.$$.fragment),De=o(),se=m("p"),se.innerHTML=zt,Le=o(),h(oe.$$.fragment),Ae=o(),re=m("ul"),re.innerHTML=Xt,Oe=o(),h(le.$$.fragment),Ke=o(),j=m("div"),h(ie.$$.fragment),ft=o(),Je=m("p"),Je.innerHTML=Et,gt=o(),Ue=m("p"),Ue.innerHTML=qt,Tt=o(),h(N.$$.fragment),et=o(),h(ce.$$.fragment),tt=o(),$=m("div"),h(de.$$.fragment),_t=o(),Pe=m("p"),Pe.innerHTML=Qt,bt=o(),Ce=m("p"),Ce.innerHTML=Dt,Mt=o(),R=m("div"),h(me.$$.fragment),vt=o(),h(I.$$.fragment),at=o(),h(pe.$$.fragment),nt=o(),J=m("div"),h(he.$$.fragment),yt=o(),Se=m("p"),Se.innerHTML=Lt,wt=o(),ke=m("p"),ke.innerHTML=At,jt=o(),V=m("div"),h(ue.$$.fragment),$t=o(),h(H.$$.fragment),st=o(),h(fe.$$.fragment),ot=o(),U=m("div"),h(ge.$$.fragment),Jt=o(),xe=m("p"),xe.innerHTML=Ot,Ut=o(),Fe=m("p"),Fe.innerHTML=Kt,Pt=o(),Y=m("div"),h(Te.$$.fragment),Ct=o(),h(z.$$.fragment),rt=o(),h(_e.$$.fragment),lt=o(),P=m("div"),h(be.$$.fragment),St=o(),Be=m("p"),Be.innerHTML=ea,kt=o(),We=m("p"),We.innerHTML=ta,xt=o(),X=m("div"),h(Me.$$.fragment),Ft=o(),h(E.$$.fragment),it=o(),h(ve.$$.fragment),ct=o(),C=m("div"),h(ye.$$.fragment),Bt=o(),Ze=m("p"),Ze.innerHTML=aa,Wt=o(),Ge=m("p"),Ge.innerHTML=na,Zt=o(),q=m("div"),h(we.$$.fragment),Gt=o(),h(Q.$$.fragment),dt=o(),Ve=m("p"),this.h()},l(e){const a=ia("svelte-u9bgzb",document.head);s=p(a,"META",{name:!0,content:!0}),a.forEach(n),y=r(e),d=p(e,"P",{}),S(d).forEach(n),i=r(e),u(b.$$.fragment,e),t=r(e),u(M.$$.fragment,e),He=r(e),A=p(e,"P",{"data-svelte-h":!0}),v(A)!=="svelte-a4z81d"&&(A.innerHTML=Nt),Ye=r(e),O=p(e,"P",{"data-svelte-h":!0}),v(O)!=="svelte-11qe7tl"&&(O.textContent=Rt),ze=r(e),K=p(e,"P",{"data-svelte-h":!0}),v(K)!=="svelte-cqhrix"&&(K.innerHTML=It),Xe=r(e),ee=p(e,"P",{"data-svelte-h":!0}),v(ee)!=="svelte-vfdo9a"&&(ee.textContent=Vt),Ee=r(e),te=p(e,"P",{"data-svelte-h":!0}),v(te)!=="svelte-1lan0k1"&&(te.innerHTML=Ht),qe=r(e),ae=p(e,"P",{"data-svelte-h":!0}),v(ae)!=="svelte-kbmat5"&&(ae.innerHTML=Yt),Qe=r(e),u(ne.$$.fragment,e),De=r(e),se=p(e,"P",{"data-svelte-h":!0}),v(se)!=="svelte-11vcgl9"&&(se.innerHTML=zt),Le=r(e),u(oe.$$.fragment,e),Ae=r(e),re=p(e,"UL",{"data-svelte-h":!0}),v(re)!=="svelte-tg1cax"&&(re.innerHTML=Xt),Oe=r(e),u(le.$$.fragment,e),Ke=r(e),j=p(e,"DIV",{class:!0});var x=S(j);u(ie.$$.fragment,x),ft=r(x),Je=p(x,"P",{"data-svelte-h":!0}),v(Je)!=="svelte-1y8uvzr"&&(Je.innerHTML=Et),gt=r(x),Ue=p(x,"P",{"data-svelte-h":!0}),v(Ue)!=="svelte-uhdjio"&&(Ue.innerHTML=qt),Tt=r(x),u(N.$$.fragment,x),x.forEach(n),et=r(e),u(ce.$$.fragment,e),tt=r(e),$=p(e,"DIV",{class:!0});var F=S($);u(de.$$.fragment,F),_t=r(F),Pe=p(F,"P",{"data-svelte-h":!0}),v(Pe)!=="svelte-1aepnut"&&(Pe.innerHTML=Qt),bt=r(F),Ce=p(F,"P",{"data-svelte-h":!0}),v(Ce)!=="svelte-hswkmf"&&(Ce.innerHTML=Dt),Mt=r(F),R=p(F,"DIV",{class:!0});var je=S(R);u(me.$$.fragment,je),vt=r(je),u(I.$$.fragment,je),je.forEach(n),F.forEach(n),at=r(e),u(pe.$$.fragment,e),nt=r(e),J=p(e,"DIV",{class:!0});var B=S(J);u(he.$$.fragment,B),yt=r(B),Se=p(B,"P",{"data-svelte-h":!0}),v(Se)!=="svelte-73ikvp"&&(Se.innerHTML=Lt),wt=r(B),ke=p(B,"P",{"data-svelte-h":!0}),v(ke)!=="svelte-hswkmf"&&(ke.innerHTML=At),jt=r(B),V=p(B,"DIV",{class:!0});var $e=S(V);u(ue.$$.fragment,$e),$t=r($e),u(H.$$.fragment,$e),$e.forEach(n),B.forEach(n),st=r(e),u(fe.$$.fragment,e),ot=r(e),U=p(e,"DIV",{class:!0});var W=S(U);u(ge.$$.fragment,W),Jt=r(W),xe=p(W,"P",{"data-svelte-h":!0}),v(xe)!=="svelte-xj4l3k"&&(xe.innerHTML=Ot),Ut=r(W),Fe=p(W,"P",{"data-svelte-h":!0}),v(Fe)!=="svelte-hswkmf"&&(Fe.innerHTML=Kt),Pt=r(W),Y=p(W,"DIV",{class:!0});var pt=S(Y);u(Te.$$.fragment,pt),Ct=r(pt),u(z.$$.fragment,pt),pt.forEach(n),W.forEach(n),rt=r(e),u(_e.$$.fragment,e),lt=r(e),P=p(e,"DIV",{class:!0});var D=S(P);u(be.$$.fragment,D),St=r(D),Be=p(D,"P",{"data-svelte-h":!0}),v(Be)!=="svelte-18vp0fh"&&(Be.innerHTML=ea),kt=r(D),We=p(D,"P",{"data-svelte-h":!0}),v(We)!=="svelte-hswkmf"&&(We.innerHTML=ta),xt=r(D),X=p(D,"DIV",{class:!0});var ht=S(X);u(Me.$$.fragment,ht),Ft=r(ht),u(E.$$.fragment,ht),ht.forEach(n),D.forEach(n),it=r(e),u(ve.$$.fragment,e),ct=r(e),C=p(e,"DIV",{class:!0});var L=S(C);u(ye.$$.fragment,L),Bt=r(L),Ze=p(L,"P",{"data-svelte-h":!0}),v(Ze)!=="svelte-1ljxilh"&&(Ze.innerHTML=aa),Wt=r(L),Ge=p(L,"P",{"data-svelte-h":!0}),v(Ge)!=="svelte-hswkmf"&&(Ge.innerHTML=na),Zt=r(L),q=p(L,"DIV",{class:!0});var ut=S(q);u(we.$$.fragment,ut),Gt=r(ut),u(Q.$$.fragment,ut),ut.forEach(n),L.forEach(n),dt=r(e),Ve=p(e,"P",{}),S(Ve).forEach(n),this.h()},h(){k(s,"name","hf:doc:metadata"),k(s,"content",ga),k(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,a){c(document.head,s),l(e,y,a),l(e,d,a),l(e,i,a),f(b,e,a),l(e,t,a),f(M,e,a),l(e,He,a),l(e,A,a),l(e,Ye,a),l(e,O,a),l(e,ze,a),l(e,K,a),l(e,Xe,a),l(e,ee,a),l(e,Ee,a),l(e,te,a),l(e,qe,a),l(e,ae,a),l(e,Qe,a),f(ne,e,a),l(e,De,a),l(e,se,a),l(e,Le,a),f(oe,e,a),l(e,Ae,a),l(e,re,a),l(e,Oe,a),f(le,e,a),l(e,Ke,a),l(e,j,a),f(ie,j,null),c(j,ft),c(j,Je),c(j,gt),c(j,Ue),c(j,Tt),f(N,j,null),l(e,et,a),f(ce,e,a),l(e,tt,a),l(e,$,a),f(de,$,null),c($,_t),c($,Pe),c($,bt),c($,Ce),c($,Mt),c($,R),f(me,R,null),c(R,vt),f(I,R,null),l(e,at,a),f(pe,e,a),l(e,nt,a),l(e,J,a),f(he,J,null),c(J,yt),c(J,Se),c(J,wt),c(J,ke),c(J,jt),c(J,V),f(ue,V,null),c(V,$t),f(H,V,null),l(e,st,a),f(fe,e,a),l(e,ot,a),l(e,U,a),f(ge,U,null),c(U,Jt),c(U,xe),c(U,Ut),c(U,Fe),c(U,Pt),c(U,Y),f(Te,Y,null),c(Y,Ct),f(z,Y,null),l(e,rt,a),f(_e,e,a),l(e,lt,a),l(e,P,a),f(be,P,null),c(P,St),c(P,Be),c(P,kt),c(P,We),c(P,xt),c(P,X),f(Me,X,null),c(X,Ft),f(E,X,null),l(e,it,a),f(ve,e,a),l(e,ct,a),l(e,C,a),f(ye,C,null),c(C,Bt),c(C,Ze),c(C,Wt),c(C,Ge),c(C,Zt),c(C,q),f(we,q,null),c(q,Gt),f(Q,q,null),l(e,dt,a),l(e,Ve,a),mt=!0},p(e,[a]){const x={};a&2&&(x.$$scope={dirty:a,ctx:e}),N.$set(x);const F={};a&2&&(F.$$scope={dirty:a,ctx:e}),I.$set(F);const je={};a&2&&(je.$$scope={dirty:a,ctx:e}),H.$set(je);const B={};a&2&&(B.$$scope={dirty:a,ctx:e}),z.$set(B);const $e={};a&2&&($e.$$scope={dirty:a,ctx:e}),E.$set($e);const W={};a&2&&(W.$$scope={dirty:a,ctx:e}),Q.$set(W)},i(e){mt||(g(b.$$.fragment,e),g(M.$$.fragment,e),g(ne.$$.fragment,e),g(oe.$$.fragment,e),g(le.$$.fragment,e),g(ie.$$.fragment,e),g(N.$$.fragment,e),g(ce.$$.fragment,e),g(de.$$.fragment,e),g(me.$$.fragment,e),g(I.$$.fragment,e),g(pe.$$.fragment,e),g(he.$$.fragment,e),g(ue.$$.fragment,e),g(H.$$.fragment,e),g(fe.$$.fragment,e),g(ge.$$.fragment,e),g(Te.$$.fragment,e),g(z.$$.fragment,e),g(_e.$$.fragment,e),g(be.$$.fragment,e),g(Me.$$.fragment,e),g(E.$$.fragment,e),g(ve.$$.fragment,e),g(ye.$$.fragment,e),g(we.$$.fragment,e),g(Q.$$.fragment,e),mt=!0)},o(e){T(b.$$.fragment,e),T(M.$$.fragment,e),T(ne.$$.fragment,e),T(oe.$$.fragment,e),T(le.$$.fragment,e),T(ie.$$.fragment,e),T(N.$$.fragment,e),T(ce.$$.fragment,e),T(de.$$.fragment,e),T(me.$$.fragment,e),T(I.$$.fragment,e),T(pe.$$.fragment,e),T(he.$$.fragment,e),T(ue.$$.fragment,e),T(H.$$.fragment,e),T(fe.$$.fragment,e),T(ge.$$.fragment,e),T(Te.$$.fragment,e),T(z.$$.fragment,e),T(_e.$$.fragment,e),T(be.$$.fragment,e),T(Me.$$.fragment,e),T(E.$$.fragment,e),T(ve.$$.fragment,e),T(ye.$$.fragment,e),T(we.$$.fragment,e),T(Q.$$.fragment,e),mt=!1},d(e){e&&(n(y),n(d),n(i),n(t),n(He),n(A),n(Ye),n(O),n(ze),n(K),n(Xe),n(ee),n(Ee),n(te),n(qe),n(ae),n(Qe),n(De),n(se),n(Le),n(Ae),n(re),n(Oe),n(Ke),n(j),n(et),n(tt),n($),n(at),n(nt),n(J),n(st),n(ot),n(U),n(rt),n(lt),n(P),n(it),n(ct),n(C),n(dt),n(Ve)),n(s),_(b,e),_(M,e),_(ne,e),_(oe,e),_(le,e),_(ie),_(N),_(ce,e),_(de),_(me),_(I),_(pe,e),_(he),_(ue),_(H),_(fe,e),_(ge),_(Te),_(z),_(_e,e),_(be),_(Me),_(E),_(ve,e),_(ye),_(we),_(Q)}}}const ga='{"title":"PatchTST","local":"patchtst","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"PatchTSTConfig","local":"transformers.PatchTSTConfig","sections":[],"depth":2},{"title":"PatchTSTModel","local":"transformers.PatchTSTModel","sections":[],"depth":2},{"title":"PatchTSTForPrediction","local":"transformers.PatchTSTForPrediction","sections":[],"depth":2},{"title":"PatchTSTForClassification","local":"transformers.PatchTSTForClassification","sections":[],"depth":2},{"title":"PatchTSTForPretraining","local":"transformers.PatchTSTForPretraining","sections":[],"depth":2},{"title":"PatchTSTForRegression","local":"transformers.PatchTSTForRegression","sections":[],"depth":2}],"depth":1}';function Ta(w){return oa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ja extends ra{constructor(s){super(),la(this,s,Ta,fa,sa,{})}}export{ja as component};
