import{s as xe,n as Ce,o as Me}from"../chunks/scheduler.182ea377.js";import{S as ye,i as Le,g as a,s as r,r as g,A as Se,h as d,f as n,c as i,j as F,u as _,x as I,k as N,y as t,a as l,v as b,d as v,t as x,w as C}from"../chunks/index.abf12888.js";import{D as W}from"../chunks/Docstring.93f6f462.js";import{H as pe}from"../chunks/Heading.16916d63.js";function $e(ue){let p,R,V,U,M,j,y,G,L,fe=`Multistep and onestep scheduler (Algorithm 3) introduced alongside latent consistency models in the paper <a href="https://arxiv.org/abs/2310.04378" rel="nofollow">Latent Consistency Models: Synthesizing High-Resolution Images with Few-Step Inference</a> by Simian Luo, Yiqin Tan, Longbo Huang, Jian Li, and Hang Zhao.
This scheduler should be able to generate good samples from <a href="/docs/diffusers/v0.27.2/en/api/pipelines/latent_consistency_models#diffusers.LatentConsistencyModelPipeline">LatentConsistencyModelPipeline</a> in 1-8 steps.`,J,S,Y,s,$,te,E,me=`<code>LCMScheduler</code> extends the denoising procedure introduced in denoising diffusion probabilistic models (DDPMs) with
non-Markovian guidance.`,ne,q,he=`This model inherits from <a href="/docs/diffusers/v0.27.2/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a> and <a href="/docs/diffusers/v0.27.2/en/api/configuration#diffusers.ConfigMixin">ConfigMixin</a>. <a href="/docs/diffusers/v0.27.2/en/api/configuration#diffusers.ConfigMixin">~ConfigMixin</a> takes care of storing all config
attributes that are passed in the scheduler’s <code>__init__</code> function, such as <code>num_train_timesteps</code>. They can be
accessed via <code>scheduler.config.num_train_timesteps</code>. <a href="/docs/diffusers/v0.27.2/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a> provides general loading and saving
functionality via the <a href="/docs/diffusers/v0.27.2/en/api/schedulers/overview#diffusers.SchedulerMixin.save_pretrained">SchedulerMixin.save_pretrained()</a> and <a href="/docs/diffusers/v0.27.2/en/api/schedulers/overview#diffusers.SchedulerMixin.from_pretrained">from_pretrained()</a> functions.`,se,u,w,oe,H,ge=`Ensures interchangeability with schedulers that need to scale the denoising model input depending on the
current timestep.`,re,f,T,ie,k,_e="Sets the begin index for the scheduler. This function should be run from pipeline before the inference.",ae,m,D,de,O,be="Sets the discrete timesteps used for the diffusion chain (to be run before inference).",ce,h,P,le,z,ve=`Predict the sample from the previous timestep by reversing the SDE. This function propagates the diffusion
process from the learned model outputs (most often the predicted noise).`,Z,A,B;return M=new pe({props:{title:"Latent Consistency Model Multistep Scheduler",local:"latent-consistency-model-multistep-scheduler",headingTag:"h1"}}),y=new pe({props:{title:"Overview",local:"overview",headingTag:"h2"}}),S=new pe({props:{title:"LCMScheduler",local:"diffusers.LCMScheduler",headingTag:"h2"}}),$=new W({props:{name:"class diffusers.LCMScheduler",anchor:"diffusers.LCMScheduler",parameters:[{name:"num_train_timesteps",val:": int = 1000"},{name:"beta_start",val:": float = 0.00085"},{name:"beta_end",val:": float = 0.012"},{name:"beta_schedule",val:": str = 'scaled_linear'"},{name:"trained_betas",val:": Union = None"},{name:"original_inference_steps",val:": int = 50"},{name:"clip_sample",val:": bool = False"},{name:"clip_sample_range",val:": float = 1.0"},{name:"set_alpha_to_one",val:": bool = True"},{name:"steps_offset",val:": int = 0"},{name:"prediction_type",val:": str = 'epsilon'"},{name:"thresholding",val:": bool = False"},{name:"dynamic_thresholding_ratio",val:": float = 0.995"},{name:"sample_max_value",val:": float = 1.0"},{name:"timestep_spacing",val:": str = 'leading'"},{name:"timestep_scaling",val:": float = 10.0"},{name:"rescale_betas_zero_snr",val:": bool = False"}],parametersDescription:[{anchor:"diffusers.LCMScheduler.num_train_timesteps",description:`<strong>num_train_timesteps</strong> (<code>int</code>, defaults to 1000) &#x2014;
The number of diffusion steps to train the model.`,name:"num_train_timesteps"},{anchor:"diffusers.LCMScheduler.beta_start",description:`<strong>beta_start</strong> (<code>float</code>, defaults to 0.0001) &#x2014;
The starting <code>beta</code> value of inference.`,name:"beta_start"},{anchor:"diffusers.LCMScheduler.beta_end",description:`<strong>beta_end</strong> (<code>float</code>, defaults to 0.02) &#x2014;
The final <code>beta</code> value.`,name:"beta_end"},{anchor:"diffusers.LCMScheduler.beta_schedule",description:`<strong>beta_schedule</strong> (<code>str</code>, defaults to <code>&quot;linear&quot;</code>) &#x2014;
The beta schedule, a mapping from a beta range to a sequence of betas for stepping the model. Choose from
<code>linear</code>, <code>scaled_linear</code>, or <code>squaredcos_cap_v2</code>.`,name:"beta_schedule"},{anchor:"diffusers.LCMScheduler.trained_betas",description:`<strong>trained_betas</strong> (<code>np.ndarray</code>, <em>optional</em>) &#x2014;
Pass an array of betas directly to the constructor to bypass <code>beta_start</code> and <code>beta_end</code>.`,name:"trained_betas"},{anchor:"diffusers.LCMScheduler.original_inference_steps",description:`<strong>original_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The default number of inference steps used to generate a linearly-spaced timestep schedule, from which we
will ultimately take <code>num_inference_steps</code> evenly spaced timesteps to form the final timestep schedule.`,name:"original_inference_steps"},{anchor:"diffusers.LCMScheduler.clip_sample",description:`<strong>clip_sample</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Clip the predicted sample for numerical stability.`,name:"clip_sample"},{anchor:"diffusers.LCMScheduler.clip_sample_range",description:`<strong>clip_sample_range</strong> (<code>float</code>, defaults to 1.0) &#x2014;
The maximum magnitude for sample clipping. Valid only when <code>clip_sample=True</code>.`,name:"clip_sample_range"},{anchor:"diffusers.LCMScheduler.set_alpha_to_one",description:`<strong>set_alpha_to_one</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Each diffusion step uses the alphas product value at that step and at the previous one. For the final step
there is no previous alpha. When this option is <code>True</code> the previous alpha product is fixed to <code>1</code>,
otherwise it uses the alpha value at step 0.`,name:"set_alpha_to_one"},{anchor:"diffusers.LCMScheduler.steps_offset",description:`<strong>steps_offset</strong> (<code>int</code>, defaults to 0) &#x2014;
An offset added to the inference steps, as required by some model families.`,name:"steps_offset"},{anchor:"diffusers.LCMScheduler.prediction_type",description:`<strong>prediction_type</strong> (<code>str</code>, defaults to <code>epsilon</code>, <em>optional</em>) &#x2014;
Prediction type of the scheduler function; can be <code>epsilon</code> (predicts the noise of the diffusion process),
<code>sample</code> (directly predicts the noisy sample<code>) or </code>v_prediction\` (see section 2.4 of <a href="https://imagen.research.google/video/paper.pdf" rel="nofollow">Imagen
Video</a> paper).`,name:"prediction_type"},{anchor:"diffusers.LCMScheduler.thresholding",description:`<strong>thresholding</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to use the &#x201C;dynamic thresholding&#x201D; method. This is unsuitable for latent-space diffusion models such
as Stable Diffusion.`,name:"thresholding"},{anchor:"diffusers.LCMScheduler.dynamic_thresholding_ratio",description:`<strong>dynamic_thresholding_ratio</strong> (<code>float</code>, defaults to 0.995) &#x2014;
The ratio for the dynamic thresholding method. Valid only when <code>thresholding=True</code>.`,name:"dynamic_thresholding_ratio"},{anchor:"diffusers.LCMScheduler.sample_max_value",description:`<strong>sample_max_value</strong> (<code>float</code>, defaults to 1.0) &#x2014;
The threshold value for dynamic thresholding. Valid only when <code>thresholding=True</code>.`,name:"sample_max_value"},{anchor:"diffusers.LCMScheduler.timestep_spacing",description:`<strong>timestep_spacing</strong> (<code>str</code>, defaults to <code>&quot;leading&quot;</code>) &#x2014;
The way the timesteps should be scaled. Refer to Table 2 of the <a href="https://huggingface.co/papers/2305.08891" rel="nofollow">Common Diffusion Noise Schedules and
Sample Steps are Flawed</a> for more information.`,name:"timestep_spacing"},{anchor:"diffusers.LCMScheduler.timestep_scaling",description:`<strong>timestep_scaling</strong> (<code>float</code>, defaults to 10.0) &#x2014;
The factor the timesteps will be multiplied by when calculating the consistency model boundary conditions
<code>c_skip</code> and <code>c_out</code>. Increasing this will decrease the approximation error (although the approximation
error at the default of <code>10.0</code> is already pretty small).`,name:"timestep_scaling"},{anchor:"diffusers.LCMScheduler.rescale_betas_zero_snr",description:`<strong>rescale_betas_zero_snr</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to rescale the betas to have zero terminal SNR. This enables the model to generate very bright and
dark samples instead of limiting it to samples with medium brightness. Loosely related to
<a href="https://github.com/huggingface/diffusers/blob/74fd735eb073eb1d774b1ab4154a0876eb82f055/examples/dreambooth/train_dreambooth.py#L506" rel="nofollow"><code>--offset_noise</code></a>.`,name:"rescale_betas_zero_snr"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/schedulers/scheduling_lcm.py#L134"}}),w=new W({props:{name:"scale_model_input",anchor:"diffusers.LCMScheduler.scale_model_input",parameters:[{name:"sample",val:": FloatTensor"},{name:"timestep",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.LCMScheduler.scale_model_input.sample",description:`<strong>sample</strong> (<code>torch.FloatTensor</code>) &#x2014;
The input sample.`,name:"sample"},{anchor:"diffusers.LCMScheduler.scale_model_input.timestep",description:`<strong>timestep</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The current timestep in the diffusion chain.`,name:"timestep"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/schedulers/scheduling_lcm.py#L299",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A scaled input sample.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code></p>
`}}),T=new W({props:{name:"set_begin_index",anchor:"diffusers.LCMScheduler.set_begin_index",parameters:[{name:"begin_index",val:": int = 0"}],parametersDescription:[{anchor:"diffusers.LCMScheduler.set_begin_index.begin_index",description:`<strong>begin_index</strong> (<code>int</code>) &#x2014;
The begin index for the scheduler.`,name:"begin_index"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/schedulers/scheduling_lcm.py#L289"}}),D=new W({props:{name:"set_timesteps",anchor:"diffusers.LCMScheduler.set_timesteps",parameters:[{name:"num_inference_steps",val:": Optional = None"},{name:"device",val:": Union = None"},{name:"original_inference_steps",val:": Optional = None"},{name:"timesteps",val:": Optional = None"},{name:"strength",val:": int = 1.0"}],parametersDescription:[{anchor:"diffusers.LCMScheduler.set_timesteps.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of diffusion steps used when generating samples with a pre-trained model. If used,
<code>timesteps</code> must be <code>None</code>.`,name:"num_inference_steps"},{anchor:"diffusers.LCMScheduler.set_timesteps.device",description:`<strong>device</strong> (<code>str</code> or <code>torch.device</code>, <em>optional</em>) &#x2014;
The device to which the timesteps should be moved to. If <code>None</code>, the timesteps are not moved.`,name:"device"},{anchor:"diffusers.LCMScheduler.set_timesteps.original_inference_steps",description:`<strong>original_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The original number of inference steps, which will be used to generate a linearly-spaced timestep
schedule (which is different from the standard <code>diffusers</code> implementation). We will then take
<code>num_inference_steps</code> timesteps from this schedule, evenly spaced in terms of indices, and use that as
our final timestep schedule. If not set, this will default to the <code>original_inference_steps</code> attribute.`,name:"original_inference_steps"},{anchor:"diffusers.LCMScheduler.set_timesteps.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps used to support arbitrary spacing between timesteps. If <code>None</code>, then the default
timestep spacing strategy of equal spacing between timesteps on the training/distillation timestep
schedule is used. If <code>timesteps</code> is passed, <code>num_inference_steps</code> must be <code>None</code>.`,name:"timesteps"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/schedulers/scheduling_lcm.py#L349"}}),P=new W({props:{name:"step",anchor:"diffusers.LCMScheduler.step",parameters:[{name:"model_output",val:": FloatTensor"},{name:"timestep",val:": int"},{name:"sample",val:": FloatTensor"},{name:"generator",val:": Optional = None"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.LCMScheduler.step.model_output",description:`<strong>model_output</strong> (<code>torch.FloatTensor</code>) &#x2014;
The direct output from learned diffusion model.`,name:"model_output"},{anchor:"diffusers.LCMScheduler.step.timestep",description:`<strong>timestep</strong> (<code>float</code>) &#x2014;
The current discrete timestep in the diffusion chain.`,name:"timestep"},{anchor:"diffusers.LCMScheduler.step.sample",description:`<strong>sample</strong> (<code>torch.FloatTensor</code>) &#x2014;
A current instance of a sample created by the diffusion process.`,name:"sample"},{anchor:"diffusers.LCMScheduler.step.generator",description:`<strong>generator</strong> (<code>torch.Generator</code>, <em>optional</em>) &#x2014;
A random number generator.`,name:"generator"},{anchor:"diffusers.LCMScheduler.step.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>LCMSchedulerOutput</code> or <code>tuple</code>.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/schedulers/scheduling_lcm.py#L498",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If return_dict is <code>True</code>, <code>LCMSchedulerOutput</code> is returned, otherwise a
tuple is returned where the first element is the sample tensor.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~schedulers.scheduling_utils.LCMSchedulerOutput</code> or <code>tuple</code></p>
`}}),{c(){p=a("meta"),R=r(),V=a("p"),U=r(),g(M.$$.fragment),j=r(),g(y.$$.fragment),G=r(),L=a("p"),L.innerHTML=fe,J=r(),g(S.$$.fragment),Y=r(),s=a("div"),g($.$$.fragment),te=r(),E=a("p"),E.innerHTML=me,ne=r(),q=a("p"),q.innerHTML=he,se=r(),u=a("div"),g(w.$$.fragment),oe=r(),H=a("p"),H.textContent=ge,re=r(),f=a("div"),g(T.$$.fragment),ie=r(),k=a("p"),k.textContent=_e,ae=r(),m=a("div"),g(D.$$.fragment),de=r(),O=a("p"),O.textContent=be,ce=r(),h=a("div"),g(P.$$.fragment),le=r(),z=a("p"),z.textContent=ve,Z=r(),A=a("p"),this.h()},l(e){const o=Se("svelte-u9bgzb",document.head);p=d(o,"META",{name:!0,content:!0}),o.forEach(n),R=i(e),V=d(e,"P",{}),F(V).forEach(n),U=i(e),_(M.$$.fragment,e),j=i(e),_(y.$$.fragment,e),G=i(e),L=d(e,"P",{"data-svelte-h":!0}),I(L)!=="svelte-6l7z2w"&&(L.innerHTML=fe),J=i(e),_(S.$$.fragment,e),Y=i(e),s=d(e,"DIV",{class:!0});var c=F(s);_($.$$.fragment,c),te=i(c),E=d(c,"P",{"data-svelte-h":!0}),I(E)!=="svelte-1cn3gww"&&(E.innerHTML=me),ne=i(c),q=d(c,"P",{"data-svelte-h":!0}),I(q)!=="svelte-75p182"&&(q.innerHTML=he),se=i(c),u=d(c,"DIV",{class:!0});var K=F(u);_(w.$$.fragment,K),oe=i(K),H=d(K,"P",{"data-svelte-h":!0}),I(H)!=="svelte-1rkfgpx"&&(H.textContent=ge),K.forEach(n),re=i(c),f=d(c,"DIV",{class:!0});var Q=F(f);_(T.$$.fragment,Q),ie=i(Q),k=d(Q,"P",{"data-svelte-h":!0}),I(k)!=="svelte-1k141rk"&&(k.textContent=_e),Q.forEach(n),ae=i(c),m=d(c,"DIV",{class:!0});var X=F(m);_(D.$$.fragment,X),de=i(X),O=d(X,"P",{"data-svelte-h":!0}),I(O)!=="svelte-1vzm9q"&&(O.textContent=be),X.forEach(n),ce=i(c),h=d(c,"DIV",{class:!0});var ee=F(h);_(P.$$.fragment,ee),le=i(ee),z=d(ee,"P",{"data-svelte-h":!0}),I(z)!=="svelte-hi84tp"&&(z.textContent=ve),ee.forEach(n),c.forEach(n),Z=i(e),A=d(e,"P",{}),F(A).forEach(n),this.h()},h(){N(p,"name","hf:doc:metadata"),N(p,"content",we),N(u,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),N(f,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),N(m,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),N(h,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),N(s,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){t(document.head,p),l(e,R,o),l(e,V,o),l(e,U,o),b(M,e,o),l(e,j,o),b(y,e,o),l(e,G,o),l(e,L,o),l(e,J,o),b(S,e,o),l(e,Y,o),l(e,s,o),b($,s,null),t(s,te),t(s,E),t(s,ne),t(s,q),t(s,se),t(s,u),b(w,u,null),t(u,oe),t(u,H),t(s,re),t(s,f),b(T,f,null),t(f,ie),t(f,k),t(s,ae),t(s,m),b(D,m,null),t(m,de),t(m,O),t(s,ce),t(s,h),b(P,h,null),t(h,le),t(h,z),l(e,Z,o),l(e,A,o),B=!0},p:Ce,i(e){B||(v(M.$$.fragment,e),v(y.$$.fragment,e),v(S.$$.fragment,e),v($.$$.fragment,e),v(w.$$.fragment,e),v(T.$$.fragment,e),v(D.$$.fragment,e),v(P.$$.fragment,e),B=!0)},o(e){x(M.$$.fragment,e),x(y.$$.fragment,e),x(S.$$.fragment,e),x($.$$.fragment,e),x(w.$$.fragment,e),x(T.$$.fragment,e),x(D.$$.fragment,e),x(P.$$.fragment,e),B=!1},d(e){e&&(n(R),n(V),n(U),n(j),n(G),n(L),n(J),n(Y),n(s),n(Z),n(A)),n(p),C(M,e),C(y,e),C(S,e),C($),C(w),C(T),C(D),C(P)}}}const we='{"title":"Latent Consistency Model Multistep Scheduler","local":"latent-consistency-model-multistep-scheduler","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"LCMScheduler","local":"diffusers.LCMScheduler","sections":[],"depth":2}],"depth":1}';function Te(ue){return Me(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ne extends ye{constructor(p){super(),Le(this,p,Te,$e,xe,{})}}export{Ne as component};
