import{s as Oo,o as Ko,n as R}from"../chunks/scheduler.182ea377.js";import{S as es,i as ts,g as m,s as n,r as u,m as Lo,H as os,A as ss,h as c,f as i,c as r,j,u as h,n as Po,B as as,x as w,k,y as s,a as _,v as g,d as M,t as b,w as y}from"../chunks/index.abf12888.js";import{T as qo}from"../chunks/Tip.230e2334.js";import{D as G}from"../chunks/Docstring.81ce6c10.js";import{C as D}from"../chunks/CodeBlock.57fe6e13.js";import{E}from"../chunks/ExampleCodeBlock.6db7157e.js";import{H as Tt,E as ns}from"../chunks/EditOnGithub.9b8e78e4.js";function rs($){let o,v=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){o=m("p"),o.textContent=v},l(l){o=c(l,"P",{"data-svelte-h":!0}),w(o)!=="svelte-17p1lpg"&&(o.textContent=v)},m(l,a){_(l,o,a)},p:R,d(l){l&&i(o)}}}function ls($){let o,v="Examples:",l,a,d;return a=new D({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwVU5ldDJEQ29uZGl0aW9uTW9kZWwlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQW1vZGVsJTIwJTNEJTIwVU5ldDJEQ29uZGl0aW9uTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi0yLTElMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJ1bmV0JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQW1vZGVsJTIwJTNEJTIwbW9kZWwudG8oJTIyY3VkYSUyMiklMEFtb2RlbC5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oYXR0ZW50aW9uX29wJTNETWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DConditionModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>model = UNet2DConditionModel.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, subfolder=<span class="hljs-string">&quot;unet&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = model.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)`,wrap:!1}}),{c(){o=m("p"),o.textContent=v,l=n(),u(a.$$.fragment)},l(e){o=c(e,"P",{"data-svelte-h":!0}),w(o)!=="svelte-kvfsh7"&&(o.textContent=v),l=r(e),h(a.$$.fragment,e)},m(e,f){_(e,o,f),_(e,l,f),g(a,e,f),d=!0},p:R,i(e){d||(M(a.$$.fragment,e),d=!0)},o(e){b(a.$$.fragment,e),d=!1},d(e){e&&(i(o),i(l)),y(a,e)}}}function is($){let o,v=`To use private or <a href="https://huggingface.co/docs/hub/models-gated#gated-models" rel="nofollow">gated models</a>, log-in with
<code>huggingface-cli login</code>. You can also activate the special
<a href="https://huggingface.co/diffusers/installation.html#offline-mode" rel="nofollow">“offline-mode”</a> to use this method in a
firewalled environment.`;return{c(){o=m("p"),o.innerHTML=v},l(l){o=c(l,"P",{"data-svelte-h":!0}),w(o)!=="svelte-19a77yg"&&(o.innerHTML=v)},m(l,a){_(l,o,a)},p:R,d(l){l&&i(o)}}}function ds($){let o,v="Example:",l,a,d;return a=new D({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTBBJTBBdW5ldCUyMCUzRCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnVuZXQlMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DConditionModel

unet = UNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, subfolder=<span class="hljs-string">&quot;unet&quot;</span>)`,wrap:!1}}),{c(){o=m("p"),o.textContent=v,l=n(),u(a.$$.fragment)},l(e){o=c(e,"P",{"data-svelte-h":!0}),w(o)!=="svelte-11lpom8"&&(o.textContent=v),l=r(e),h(a.$$.fragment,e)},m(e,f){_(e,o,f),_(e,l,f),g(a,e,f),d=!0},p:R,i(e){d||(M(a.$$.fragment,e),d=!0)},o(e){b(a.$$.fragment,e),d=!1},d(e){e&&(i(o),i(l)),y(a,e)}}}function ms($){let o,v="If you get the error message below, you need to finetune the weights for your downstream task:",l,a,d;return a=new D({props:{code:"U29tZSUyMHdlaWdodHMlMjBvZiUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTIwd2VyZSUyMG5vdCUyMGluaXRpYWxpemVkJTIwZnJvbSUyMHRoZSUyMG1vZGVsJTIwY2hlY2twb2ludCUyMGF0JTIwcnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjBhbmQlMjBhcmUlMjBuZXdseSUyMGluaXRpYWxpemVkJTIwYmVjYXVzZSUyMHRoZSUyMHNoYXBlcyUyMGRpZCUyMG5vdCUyMG1hdGNoJTNBJTBBLSUyMGNvbnZfaW4ud2VpZ2h0JTNBJTIwZm91bmQlMjBzaGFwZSUyMHRvcmNoLlNpemUoJTVCMzIwJTJDJTIwNCUyQyUyMDMlMkMlMjAzJTVEKSUyMGluJTIwdGhlJTIwY2hlY2twb2ludCUyMGFuZCUyMHRvcmNoLlNpemUoJTVCMzIwJTJDJTIwOSUyQyUyMDMlMkMlMjAzJTVEKSUyMGluJTIwdGhlJTIwbW9kZWwlMjBpbnN0YW50aWF0ZWQlMEFZb3UlMjBzaG91bGQlMjBwcm9iYWJseSUyMFRSQUlOJTIwdGhpcyUyMG1vZGVsJTIwb24lMjBhJTIwZG93bi1zdHJlYW0lMjB0YXNrJTIwdG8lMjBiZSUyMGFibGUlMjB0byUyMHVzZSUyMGl0JTIwZm9yJTIwcHJlZGljdGlvbnMlMjBhbmQlMjBpbmZlcmVuY2Uu",highlighted:`Some weights of UNet2DConditionModel were not initialized from the model checkpoint at runwayml/stable-diffusion-v1-5 and are newly initialized because the shapes did not match:
- conv_in.weight: found shape torch.Size([320, 4, 3, 3]) <span class="hljs-keyword">in</span> the checkpoint and torch.Size([320, 9, 3, 3]) <span class="hljs-keyword">in</span> the model instantiated
You should probably TRAIN this model on a down-stream task to be able to use it <span class="hljs-keyword">for</span> predictions and inference.`,wrap:!1}}),{c(){o=m("p"),o.textContent=v,l=n(),u(a.$$.fragment)},l(e){o=c(e,"P",{"data-svelte-h":!0}),w(o)!=="svelte-xueb0m"&&(o.textContent=v),l=r(e),h(a.$$.fragment,e)},m(e,f){_(e,o,f),_(e,l,f),g(a,e,f),d=!0},p:R,i(e){d||(M(a.$$.fragment,e),d=!0)},o(e){b(a.$$.fragment,e),d=!1},d(e){e&&(i(o),i(l)),y(a,e)}}}function cs($){let o,v="Example:",l,a,d;return a=new D({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXVuZXQlMjAlM0QlMjBVTmV0MkRDb25kaXRpb25Nb2RlbC5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBzdWJmb2xkZXIlM0QlMjJ1bmV0JTIyKSUwQXVuZXQubnVtX3BhcmFtZXRlcnMob25seV90cmFpbmFibGUlM0RUcnVlKSUwQTg1OTUyMDk2NA==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DConditionModel

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
unet = UNet2DConditionModel.from_pretrained(model_id, subfolder=<span class="hljs-string">&quot;unet&quot;</span>)
unet.num_parameters(only_trainable=<span class="hljs-literal">True</span>)
<span class="hljs-number">859520964</span>`,wrap:!1}}),{c(){o=m("p"),o.textContent=v,l=n(),u(a.$$.fragment)},l(e){o=c(e,"P",{"data-svelte-h":!0}),w(o)!=="svelte-11lpom8"&&(o.textContent=v),l=r(e),h(a.$$.fragment,e)},m(e,f){_(e,o,f),_(e,l,f),g(a,e,f),d=!0},p:R,i(e){d||(M(a.$$.fragment,e),d=!0)},o(e){b(a.$$.fragment,e),d=!1},d(e){e&&(i(o),i(l)),y(a,e)}}}function ps($){let o,v="Examples:",l,a,d;return a=new D({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsYXhVTmV0MkRDb25kaXRpb25Nb2RlbCUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMkMlMjBwYXJhbXMlMjAlM0QlMjBGbGF4VU5ldDJEQ29uZGl0aW9uTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyKSUwQSUyMyUyME1vZGVsJTIwd2FzJTIwc2F2ZWQlMjB1c2luZyUyMCpzYXZlX3ByZXRyYWluZWQoJy4lMkZ0ZXN0JTJGc2F2ZWRfbW9kZWwlMkYnKSolMjAoZm9yJTIwZXhhbXBsZSUyMHB1cnBvc2VzJTJDJTIwbm90JTIwcnVubmFibGUpLiUwQW1vZGVsJTJDJTIwcGFyYW1zJTIwJTNEJTIwRmxheFVOZXQyRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMjIuJTJGdGVzdCUyRnNhdmVkX21vZGVsJTJGJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxUNet2DConditionModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model, params = FlaxUNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Model was saved using *save_pretrained(&#x27;./test/saved_model/&#x27;)* (for example purposes, not runnable).</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model, params = FlaxUNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;./test/saved_model/&quot;</span>)`,wrap:!1}}),{c(){o=m("p"),o.textContent=v,l=n(),u(a.$$.fragment)},l(e){o=c(e,"P",{"data-svelte-h":!0}),w(o)!=="svelte-kvfsh7"&&(o.textContent=v),l=r(e),h(a.$$.fragment,e)},m(e,f){_(e,o,f),_(e,l,f),g(a,e,f),d=!0},p:R,i(e){d||(M(a.$$.fragment,e),d=!0)},o(e){b(a.$$.fragment,e),d=!1},d(e){e&&(i(o),i(l)),y(a,e)}}}function fs($){let o,v="If you get the error message below, you need to finetune the weights for your downstream task:",l,a,d;return a=new D({props:{code:"U29tZSUyMHdlaWdodHMlMjBvZiUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTIwd2VyZSUyMG5vdCUyMGluaXRpYWxpemVkJTIwZnJvbSUyMHRoZSUyMG1vZGVsJTIwY2hlY2twb2ludCUyMGF0JTIwcnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjBhbmQlMjBhcmUlMjBuZXdseSUyMGluaXRpYWxpemVkJTIwYmVjYXVzZSUyMHRoZSUyMHNoYXBlcyUyMGRpZCUyMG5vdCUyMG1hdGNoJTNBJTBBLSUyMGNvbnZfaW4ud2VpZ2h0JTNBJTIwZm91bmQlMjBzaGFwZSUyMHRvcmNoLlNpemUoJTVCMzIwJTJDJTIwNCUyQyUyMDMlMkMlMjAzJTVEKSUyMGluJTIwdGhlJTIwY2hlY2twb2ludCUyMGFuZCUyMHRvcmNoLlNpemUoJTVCMzIwJTJDJTIwOSUyQyUyMDMlMkMlMjAzJTVEKSUyMGluJTIwdGhlJTIwbW9kZWwlMjBpbnN0YW50aWF0ZWQlMEFZb3UlMjBzaG91bGQlMjBwcm9iYWJseSUyMFRSQUlOJTIwdGhpcyUyMG1vZGVsJTIwb24lMjBhJTIwZG93bi1zdHJlYW0lMjB0YXNrJTIwdG8lMjBiZSUyMGFibGUlMjB0byUyMHVzZSUyMGl0JTIwZm9yJTIwcHJlZGljdGlvbnMlMjBhbmQlMjBpbmZlcmVuY2Uu",highlighted:`Some weights of UNet2DConditionModel were not initialized from the model checkpoint at runwayml/stable-diffusion-v1-5 and are newly initialized because the shapes did not match:
- conv_in.weight: found shape torch.Size([320, 4, 3, 3]) <span class="hljs-keyword">in</span> the checkpoint and torch.Size([320, 9, 3, 3]) <span class="hljs-keyword">in</span> the model instantiated
You should probably TRAIN this model on a down-stream task to be able to use it <span class="hljs-keyword">for</span> predictions and inference.`,wrap:!1}}),{c(){o=m("p"),o.textContent=v,l=n(),u(a.$$.fragment)},l(e){o=c(e,"P",{"data-svelte-h":!0}),w(o)!=="svelte-xueb0m"&&(o.textContent=v),l=r(e),h(a.$$.fragment,e)},m(e,f){_(e,o,f),_(e,l,f),g(a,e,f),d=!0},p:R,i(e){d||(M(a.$$.fragment,e),d=!0)},o(e){b(a.$$.fragment,e),d=!1},d(e){e&&(i(o),i(l)),y(a,e)}}}function us($){let o,v="Examples:",l,a,d;return a=new D({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsYXhVTmV0MkRDb25kaXRpb25Nb2RlbCUwQSUwQSUyMyUyMGxvYWQlMjBtb2RlbCUwQW1vZGVsJTJDJTIwcGFyYW1zJTIwJTNEJTIwRmxheFVOZXQyRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiklMEElMjMlMjBCeSUyMGRlZmF1bHQlMkMlMjB0aGUlMjBtb2RlbCUyMHBhcmFtZXRlcnMlMjB3aWxsJTIwYmUlMjBpbiUyMGZwMzIlMjBwcmVjaXNpb24lMkMlMjB0byUyMGNhc3QlMjB0aGVzZSUyMHRvJTIwYmZsb2F0MTYlMjBwcmVjaXNpb24lMEFwYXJhbXMlMjAlM0QlMjBtb2RlbC50b19iZjE2KHBhcmFtcyklMEElMjMlMjBJZiUyMHlvdSUyMGRvbid0JTIwd2FudCUyMHRvJTIwY2FzdCUyMGNlcnRhaW4lMjBwYXJhbWV0ZXJzJTIwKGZvciUyMGV4YW1wbGUlMjBsYXllciUyMG5vcm0lMjBiaWFzJTIwYW5kJTIwc2NhbGUpJTBBJTIzJTIwdGhlbiUyMHBhc3MlMjB0aGUlMjBtYXNrJTIwYXMlMjBmb2xsb3dzJTBBZnJvbSUyMGZsYXglMjBpbXBvcnQlMjB0cmF2ZXJzZV91dGlsJTBBJTBBbW9kZWwlMkMlMjBwYXJhbXMlMjAlM0QlMjBGbGF4VU5ldDJEQ29uZGl0aW9uTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyKSUwQWZsYXRfcGFyYW1zJTIwJTNEJTIwdHJhdmVyc2VfdXRpbC5mbGF0dGVuX2RpY3QocGFyYW1zKSUwQW1hc2slMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjBwYXRoJTNBJTIwKHBhdGglNUItMiU1RCUyMCElM0QlMjAoJTIyTGF5ZXJOb3JtJTIyJTJDJTIwJTIyYmlhcyUyMiklMjBhbmQlMjBwYXRoJTVCLTIlM0ElNUQlMjAhJTNEJTIwKCUyMkxheWVyTm9ybSUyMiUyQyUyMCUyMnNjYWxlJTIyKSklMEElMjAlMjAlMjAlMjBmb3IlMjBwYXRoJTIwaW4lMjBmbGF0X3BhcmFtcyUwQSU3RCUwQW1hc2slMjAlM0QlMjB0cmF2ZXJzZV91dGlsLnVuZmxhdHRlbl9kaWN0KG1hc2spJTBBcGFyYW1zJTIwJTNEJTIwbW9kZWwudG9fYmYxNihwYXJhbXMlMkMlMjBtYXNrKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxUNet2DConditionModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model, params = FlaxUNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, the model parameters will be in fp32 precision, to cast these to bfloat16 precision</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>params = model.to_bf16(params)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If you don&#x27;t want to cast certain parameters (for example layer norm bias and scale)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># then pass the mask as follows</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> flax <span class="hljs-keyword">import</span> traverse_util

<span class="hljs-meta">&gt;&gt;&gt; </span>model, params = FlaxUNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>flat_params = traverse_util.flatten_dict(params)
<span class="hljs-meta">&gt;&gt;&gt; </span>mask = {
<span class="hljs-meta">... </span>    path: (path[-<span class="hljs-number">2</span>] != (<span class="hljs-string">&quot;LayerNorm&quot;</span>, <span class="hljs-string">&quot;bias&quot;</span>) <span class="hljs-keyword">and</span> path[-<span class="hljs-number">2</span>:] != (<span class="hljs-string">&quot;LayerNorm&quot;</span>, <span class="hljs-string">&quot;scale&quot;</span>))
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> path <span class="hljs-keyword">in</span> flat_params
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>mask = traverse_util.unflatten_dict(mask)
<span class="hljs-meta">&gt;&gt;&gt; </span>params = model.to_bf16(params, mask)`,wrap:!1}}),{c(){o=m("p"),o.textContent=v,l=n(),u(a.$$.fragment)},l(e){o=c(e,"P",{"data-svelte-h":!0}),w(o)!=="svelte-kvfsh7"&&(o.textContent=v),l=r(e),h(a.$$.fragment,e)},m(e,f){_(e,o,f),_(e,l,f),g(a,e,f),d=!0},p:R,i(e){d||(M(a.$$.fragment,e),d=!0)},o(e){b(a.$$.fragment,e),d=!1},d(e){e&&(i(o),i(l)),y(a,e)}}}function hs($){let o,v="Examples:",l,a,d;return a=new D({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsYXhVTmV0MkRDb25kaXRpb25Nb2RlbCUwQSUwQSUyMyUyMGxvYWQlMjBtb2RlbCUwQW1vZGVsJTJDJTIwcGFyYW1zJTIwJTNEJTIwRmxheFVOZXQyRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiklMEElMjMlMjBCeSUyMGRlZmF1bHQlMkMlMjB0aGUlMjBtb2RlbCUyMHBhcmFtcyUyMHdpbGwlMjBiZSUyMGluJTIwZnAzMiUyQyUyMHRvJTIwY2FzdCUyMHRoZXNlJTIwdG8lMjBmbG9hdDE2JTBBcGFyYW1zJTIwJTNEJTIwbW9kZWwudG9fZnAxNihwYXJhbXMpJTBBJTIzJTIwSWYlMjB5b3UlMjB3YW50JTIwZG9uJ3QlMjB3YW50JTIwdG8lMjBjYXN0JTIwY2VydGFpbiUyMHBhcmFtZXRlcnMlMjAoZm9yJTIwZXhhbXBsZSUyMGxheWVyJTIwbm9ybSUyMGJpYXMlMjBhbmQlMjBzY2FsZSklMEElMjMlMjB0aGVuJTIwcGFzcyUyMHRoZSUyMG1hc2slMjBhcyUyMGZvbGxvd3MlMEFmcm9tJTIwZmxheCUyMGltcG9ydCUyMHRyYXZlcnNlX3V0aWwlMEElMEFtb2RlbCUyQyUyMHBhcmFtcyUyMCUzRCUyMEZsYXhVTmV0MkRDb25kaXRpb25Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIpJTBBZmxhdF9wYXJhbXMlMjAlM0QlMjB0cmF2ZXJzZV91dGlsLmZsYXR0ZW5fZGljdChwYXJhbXMpJTBBbWFzayUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMHBhdGglM0ElMjAocGF0aCU1Qi0yJTVEJTIwISUzRCUyMCglMjJMYXllck5vcm0lMjIlMkMlMjAlMjJiaWFzJTIyKSUyMGFuZCUyMHBhdGglNUItMiUzQSU1RCUyMCElM0QlMjAoJTIyTGF5ZXJOb3JtJTIyJTJDJTIwJTIyc2NhbGUlMjIpKSUwQSUyMCUyMCUyMCUyMGZvciUyMHBhdGglMjBpbiUyMGZsYXRfcGFyYW1zJTBBJTdEJTBBbWFzayUyMCUzRCUyMHRyYXZlcnNlX3V0aWwudW5mbGF0dGVuX2RpY3QobWFzayklMEFwYXJhbXMlMjAlM0QlMjBtb2RlbC50b19mcDE2KHBhcmFtcyUyQyUyMG1hc2sp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxUNet2DConditionModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model, params = FlaxUNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, the model params will be in fp32, to cast these to float16</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>params = model.to_fp16(params)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If you want don&#x27;t want to cast certain parameters (for example layer norm bias and scale)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># then pass the mask as follows</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> flax <span class="hljs-keyword">import</span> traverse_util

<span class="hljs-meta">&gt;&gt;&gt; </span>model, params = FlaxUNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>flat_params = traverse_util.flatten_dict(params)
<span class="hljs-meta">&gt;&gt;&gt; </span>mask = {
<span class="hljs-meta">... </span>    path: (path[-<span class="hljs-number">2</span>] != (<span class="hljs-string">&quot;LayerNorm&quot;</span>, <span class="hljs-string">&quot;bias&quot;</span>) <span class="hljs-keyword">and</span> path[-<span class="hljs-number">2</span>:] != (<span class="hljs-string">&quot;LayerNorm&quot;</span>, <span class="hljs-string">&quot;scale&quot;</span>))
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> path <span class="hljs-keyword">in</span> flat_params
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>mask = traverse_util.unflatten_dict(mask)
<span class="hljs-meta">&gt;&gt;&gt; </span>params = model.to_fp16(params, mask)`,wrap:!1}}),{c(){o=m("p"),o.textContent=v,l=n(),u(a.$$.fragment)},l(e){o=c(e,"P",{"data-svelte-h":!0}),w(o)!=="svelte-kvfsh7"&&(o.textContent=v),l=r(e),h(a.$$.fragment,e)},m(e,f){_(e,o,f),_(e,l,f),g(a,e,f),d=!0},p:R,i(e){d||(M(a.$$.fragment,e),d=!0)},o(e){b(a.$$.fragment,e),d=!1},d(e){e&&(i(o),i(l)),y(a,e)}}}function gs($){let o,v="Examples:",l,a,d;return a=new D({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsYXhVTmV0MkRDb25kaXRpb25Nb2RlbCUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTBBbW9kZWwlMkMlMjBwYXJhbXMlMjAlM0QlMjBGbGF4VU5ldDJEQ29uZGl0aW9uTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyKSUwQSUyMyUyMEJ5JTIwZGVmYXVsdCUyQyUyMHRoZSUyMG1vZGVsJTIwcGFyYW1zJTIwd2lsbCUyMGJlJTIwaW4lMjBmcDMyJTJDJTIwdG8lMjBpbGx1c3RyYXRlJTIwdGhlJTIwdXNlJTIwb2YlMjB0aGlzJTIwbWV0aG9kJTJDJTBBJTIzJTIwd2UnbGwlMjBmaXJzdCUyMGNhc3QlMjB0byUyMGZwMTYlMjBhbmQlMjBiYWNrJTIwdG8lMjBmcDMyJTBBcGFyYW1zJTIwJTNEJTIwbW9kZWwudG9fZjE2KHBhcmFtcyklMEElMjMlMjBub3clMjBjYXN0JTIwYmFjayUyMHRvJTIwZnAzMiUwQXBhcmFtcyUyMCUzRCUyMG1vZGVsLnRvX2ZwMzIocGFyYW1zKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxUNet2DConditionModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model, params = FlaxUNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, the model params will be in fp32, to illustrate the use of this method,</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># we&#x27;ll first cast to fp16 and back to fp32</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>params = model.to_f16(params)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># now cast back to fp32</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>params = model.to_fp32(params)`,wrap:!1}}),{c(){o=m("p"),o.textContent=v,l=n(),u(a.$$.fragment)},l(e){o=c(e,"P",{"data-svelte-h":!0}),w(o)!=="svelte-kvfsh7"&&(o.textContent=v),l=r(e),h(a.$$.fragment,e)},m(e,f){_(e,o,f),_(e,l,f),g(a,e,f),d=!0},p:R,i(e){d||(M(a.$$.fragment,e),d=!0)},o(e){b(a.$$.fragment,e),d=!1},d(e){e&&(i(o),i(l)),y(a,e)}}}function Ms($){let o,v="Examples:",l,a,d;return a=new D({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTBBJTBBdW5ldCUyMCUzRCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMiUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnVuZXQlMjIpJTBBJTBBJTIzJTIwUHVzaCUyMHRoZSUyMCU2MHVuZXQlNjAlMjB0byUyMHlvdXIlMjBuYW1lc3BhY2UlMjB3aXRoJTIwdGhlJTIwbmFtZSUyMCUyMm15LWZpbmV0dW5lZC11bmV0JTIyLiUwQXVuZXQucHVzaF90b19odWIoJTIybXktZmluZXR1bmVkLXVuZXQlMjIpJTBBJTBBJTIzJTIwUHVzaCUyMHRoZSUyMCU2MHVuZXQlNjAlMjB0byUyMGFuJTIwb3JnYW5pemF0aW9uJTIwd2l0aCUyMHRoZSUyMG5hbWUlMjAlMjJteS1maW5ldHVuZWQtdW5ldCUyMi4lMEF1bmV0LnB1c2hfdG9faHViKCUyMnlvdXItb3JnJTJGbXktZmluZXR1bmVkLXVuZXQlMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DConditionModel

unet = UNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2&quot;</span>, subfolder=<span class="hljs-string">&quot;unet&quot;</span>)

<span class="hljs-comment"># Push the \`unet\` to your namespace with the name &quot;my-finetuned-unet&quot;.</span>
unet.push_to_hub(<span class="hljs-string">&quot;my-finetuned-unet&quot;</span>)

<span class="hljs-comment"># Push the \`unet\` to an organization with the name &quot;my-finetuned-unet&quot;.</span>
unet.push_to_hub(<span class="hljs-string">&quot;your-org/my-finetuned-unet&quot;</span>)`,wrap:!1}}),{c(){o=m("p"),o.textContent=v,l=n(),u(a.$$.fragment)},l(e){o=c(e,"P",{"data-svelte-h":!0}),w(o)!=="svelte-kvfsh7"&&(o.textContent=v),l=r(e),h(a.$$.fragment,e)},m(e,f){_(e,o,f),_(e,l,f),g(a,e,f),d=!0},p:R,i(e){d||(M(a.$$.fragment,e),d=!0)},o(e){b(a.$$.fragment,e),d=!1},d(e){e&&(i(o),i(l)),y(a,e)}}}function bs($){let o,v,l,a,d,e,f,Ut,ft,Ao='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>p</mi><mi>θ</mi></msub><mo stretchy="false">(</mo><msub><mi>x</mi><mrow><mi>t</mi><mo>−</mo><mn>1</mn></mrow></msub><mi mathvariant="normal">∣</mi><msub><mi>x</mi><mi>t</mi></msub><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">p_{\\theta}(x_{t-1}|x_{t})</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord"><span class="mord mathnormal">p</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.02778em;">θ</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">t</span><span class="mbin mtight">−</span><span class="mord mtight">1</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2083em;"><span></span></span></span></span></span></span><span class="mord">∣</span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.2806em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">t</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mclose">)</span></span></span></span>',ut,ht,pe,xo='All models are built from the base <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin">ModelMixin</a> class which is a <a href="https://pytorch.org/docs/stable/generated/torch.nn.Module.html" rel="nofollow"><code>torch.nn.Module</code></a> providing basic functionality for saving and loading models, locally and from the Hugging Face Hub.',gt,fe,Mt,x,ue,Jt,Xe,$o="Base class for all models.",jt,He,To=`<a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin">ModelMixin</a> takes care of storing the model configuration and provides methods for loading, downloading and
saving models.`,kt,Ne,Uo='<li><strong>config_name</strong> (<code>str</code>) — Filename to save a model to when calling <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.save_pretrained">save_pretrained()</a>.</li>',Zt,S,he,Gt,Ye,Jo=`Deactivates gradient checkpointing for the current model (may be referred to as <em>activation checkpointing</em> or
<em>checkpoint activations</em> in other frameworks).`,Ct,L,ge,It,ze,jo='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',Wt,P,Me,Ft,Ee,ko=`Activates gradient checkpointing for the current model (may be referred to as <em>activation checkpointing</em> or
<em>checkpoint activations</em> in other frameworks).`,Bt,I,be,Vt,De,Zo='Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',Rt,Qe,Go=`When this option is enabled, you should observe lower GPU memory usage and a potential speed up during
inference. Speed up during training is not guaranteed.`,Xt,q,Ht,A,Nt,Z,ye,Yt,Se,Co="Instantiate a pretrained PyTorch model from a pretrained model configuration.",zt,Le,Io=`The model is set in evaluation mode - <code>model.eval()</code> - by default, and dropout modules are deactivated. To
train the model, set it back in training mode with <code>model.train()</code>.`,Et,O,Dt,K,Qt,ee,St,N,_e,Lt,Pe,Wo="Get number of (trainable or non-embedding) parameters in the module.",Pt,te,qt,oe,ve,At,qe,Fo=`Save a model and its configuration file to a directory so that it can be reloaded using the
<a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.from_pretrained">from_pretrained()</a> class method.`,bt,we,yt,U,xe,Ot,Ae,Bo="Base class for all Flax models.",Kt,Oe,Vo=`<a href="/docs/diffusers/main/en/api/models/overview#diffusers.FlaxModelMixin">FlaxModelMixin</a> takes care of storing the model configuration and provides methods for loading, downloading and
saving models.`,eo,Ke,Ro='<li><strong>config_name</strong> (<code>str</code>) — Filename to save a model to when calling <a href="/docs/diffusers/main/en/api/models/overview#diffusers.FlaxModelMixin.save_pretrained">save_pretrained()</a>.</li>',to,F,$e,oo,et,Xo="Instantiate a pretrained Flax model from a pretrained model configuration.",so,se,ao,ae,no,ne,Te,ro,tt,Ho=`Save a model and its configuration file to a directory so that it can be reloaded using the
<a href="/docs/diffusers/main/en/api/models/overview#diffusers.FlaxModelMixin.from_pretrained">from_pretrained()</a> class method.`,lo,B,Ue,io,ot,No=`Cast the floating-point <code>params</code> to <code>jax.numpy.bfloat16</code>. This returns a new <code>params</code> tree and does not cast
the <code>params</code> in place.`,mo,st,Yo=`This method can be used on a TPU to explicitly convert the model parameters to bfloat16 precision to do full
half-precision training or to save weights in bfloat16 for inference in order to save memory and improve speed.`,co,re,po,V,Je,fo,at,zo=`Cast the floating-point <code>params</code> to <code>jax.numpy.float16</code>. This returns a new <code>params</code> tree and does not cast the
<code>params</code> in place.`,uo,nt,Eo=`This method can be used on a GPU to explicitly convert the model parameters to float16 precision to do full
half-precision training or to save weights in float16 for inference in order to save memory and improve speed.`,ho,le,go,Y,je,Mo,rt,Do=`Cast the floating-point <code>params</code> to <code>jax.numpy.float32</code>. This method can be used to explicitly convert the
model parameters to fp32 precision. This returns a new <code>params</code> tree and does not cast the <code>params</code> in place.`,bo,ie,_t,ke,vt,X,Ze,yo,lt,Qo="A Mixin to push a model, scheduler, or pipeline to the Hugging Face Hub.",_o,z,Ge,vo,it,So="Upload model, scheduler, or pipeline files to the 🤗 Hugging Face Hub.",wo,de,wt,Ce,xt,pt,$t;return d=new Tt({props:{title:"Models",local:"models",headingTag:"h1"}}),fe=new Tt({props:{title:"ModelMixin",local:"diffusers.ModelMixin",headingTag:"h2"}}),ue=new G({props:{name:"class diffusers.ModelMixin",anchor:"diffusers.ModelMixin",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_utils.py#L214"}}),he=new G({props:{name:"disable_gradient_checkpointing",anchor:"diffusers.ModelMixin.disable_gradient_checkpointing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_utils.py#L267"}}),ge=new G({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.ModelMixin.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_utils.py#L328"}}),Me=new G({props:{name:"enable_gradient_checkpointing",anchor:"diffusers.ModelMixin.enable_gradient_checkpointing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_utils.py#L258"}}),be=new G({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.ModelMixin.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.ModelMixin.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_utils.py#L292"}}),q=new qo({props:{warning:!0,$$slots:{default:[rs]},$$scope:{ctx:$}}}),A=new E({props:{anchor:"diffusers.ModelMixin.enable_xformers_memory_efficient_attention.example",$$slots:{default:[ls]},$$scope:{ctx:$}}}),ye=new G({props:{name:"from_pretrained",anchor:"diffusers.ModelMixin.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.ModelMixin.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> (for example <code>google/ddpm-celebahq-256</code>) of a pretrained model hosted on
the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_model_directory</code>) containing the model weights saved
with <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.save_pretrained">save_pretrained()</a>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.ModelMixin.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.ModelMixin.from_pretrained.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Override the default <code>torch.dtype</code> and load the model with another dtype. If <code>&quot;auto&quot;</code> is passed, the
dtype is automatically derived from the model&#x2019;s weights.`,name:"torch_dtype"},{anchor:"diffusers.ModelMixin.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.
resume_download &#x2014;
Deprecated and ignored. All downloads are now resumed by default when possible. Will be removed in v1
of Diffusers.`,name:"force_download"},{anchor:"diffusers.ModelMixin.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.ModelMixin.from_pretrained.output_loading_info",description:`<strong>output_loading_info</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info"},{anchor:"diffusers.ModelMixin.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only(bool,"},{anchor:"diffusers.ModelMixin.from_pretrained.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.ModelMixin.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.ModelMixin.from_pretrained.from_flax",description:`<strong>from_flax</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a Flax checkpoint save file.`,name:"from_flax"},{anchor:"diffusers.ModelMixin.from_pretrained.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
The subfolder location of a model file within a larger model repository on the Hub or locally.`,name:"subfolder"},{anchor:"diffusers.ModelMixin.from_pretrained.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"},{anchor:"diffusers.ModelMixin.from_pretrained.device_map",description:`<strong>device_map</strong> (<code>str</code> or <code>Dict[str, Union[int, str, torch.device]]</code>, <em>optional</em>) &#x2014;
A map that specifies where each submodule should go. It doesn&#x2019;t need to be defined for each
parameter/buffer name; once a given module name is inside, every submodule of it will be sent to the
same device.</p>
<p>Set <code>device_map=&quot;auto&quot;</code> to have &#x1F917; Accelerate automatically compute the most optimized <code>device_map</code>. For
more information about each option see <a href="https://hf.co/docs/accelerate/main/en/usage_guides/big_modeling#designing-a-device-map" rel="nofollow">designing a device
map</a>.`,name:"device_map"},{anchor:"diffusers.ModelMixin.from_pretrained.max_memory",description:`<strong>max_memory</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
A dictionary device identifier for the maximum memory. Will default to the maximum memory available for
each GPU and the available CPU RAM if unset.`,name:"max_memory"},{anchor:"diffusers.ModelMixin.from_pretrained.offload_folder",description:`<strong>offload_folder</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
The path to offload weights if <code>device_map</code> contains the value <code>&quot;disk&quot;</code>.`,name:"offload_folder"},{anchor:"diffusers.ModelMixin.from_pretrained.offload_state_dict",description:`<strong>offload_state_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, temporarily offloads the CPU state dict to the hard drive to avoid running out of CPU RAM if
the weight of the CPU state dict + the biggest shard of the checkpoint does not fit. Defaults to <code>True</code>
when there is some disk offload.`,name:"offload_state_dict"},{anchor:"diffusers.ModelMixin.from_pretrained.low_cpu_mem_usage",description:`<strong>low_cpu_mem_usage</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code> if torch version &gt;= 1.9.0 else <code>False</code>) &#x2014;
Speed up model loading only loading the pretrained weights and not initializing the weights. This also
tries to not use more than 1x model size in CPU memory (including peak memory) while loading the model.
Only supported for PyTorch &gt;= 1.9.0. If you are using an older version of PyTorch, setting this
argument to <code>True</code> will raise an error.`,name:"low_cpu_mem_usage"},{anchor:"diffusers.ModelMixin.from_pretrained.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Load weights from a specified <code>variant</code> filename such as <code>&quot;fp16&quot;</code> or <code>&quot;ema&quot;</code>. This is ignored when
loading <code>from_flax</code>.`,name:"variant"},{anchor:"diffusers.ModelMixin.from_pretrained.use_safetensors",description:`<strong>use_safetensors</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>None</code>, the <code>safetensors</code> weights are downloaded if they&#x2019;re available <strong>and</strong> if the
<code>safetensors</code> library is installed. If set to <code>True</code>, the model is forcibly loaded from <code>safetensors</code>
weights. If set to <code>False</code>, <code>safetensors</code> weights are not loaded.`,name:"use_safetensors"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_utils.py#L422"}}),O=new qo({props:{$$slots:{default:[is]},$$scope:{ctx:$}}}),K=new E({props:{anchor:"diffusers.ModelMixin.from_pretrained.example",$$slots:{default:[ds]},$$scope:{ctx:$}}}),ee=new E({props:{anchor:"diffusers.ModelMixin.from_pretrained.example-2",$$slots:{default:[ms]},$$scope:{ctx:$}}}),_e=new G({props:{name:"num_parameters",anchor:"diffusers.ModelMixin.num_parameters",parameters:[{name:"only_trainable",val:": bool = False"},{name:"exclude_embeddings",val:": bool = False"}],parametersDescription:[{anchor:"diffusers.ModelMixin.num_parameters.only_trainable",description:`<strong>only_trainable</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return only the number of trainable parameters.`,name:"only_trainable"},{anchor:"diffusers.ModelMixin.num_parameters.exclude_embeddings",description:`<strong>exclude_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return only the number of non-embedding parameters.`,name:"exclude_embeddings"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_utils.py#L981",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The number of parameters.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>int</code></p>
`}}),te=new E({props:{anchor:"diffusers.ModelMixin.num_parameters.example",$$slots:{default:[cs]},$$scope:{ctx:$}}}),ve=new G({props:{name:"save_pretrained",anchor:"diffusers.ModelMixin.save_pretrained",parameters:[{name:"save_directory",val:": Union"},{name:"is_main_process",val:": bool = True"},{name:"save_function",val:": Optional = None"},{name:"safe_serialization",val:": bool = True"},{name:"variant",val:": Optional = None"},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.ModelMixin.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to save a model and its configuration file to. Will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"diffusers.ModelMixin.save_pretrained.is_main_process",description:`<strong>is_main_process</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the process calling this is the main process or not. Useful during distributed training and you
need to call this function on all processes. In this case, set <code>is_main_process=True</code> only on the main
process to avoid race conditions.`,name:"is_main_process"},{anchor:"diffusers.ModelMixin.save_pretrained.save_function",description:`<strong>save_function</strong> (<code>Callable</code>) &#x2014;
The function to use to save the state dictionary. Useful during distributed training when you need to
replace <code>torch.save</code> with another method. Can be configured with the environment variable
<code>DIFFUSERS_SAVE_MODE</code>.`,name:"save_function"},{anchor:"diffusers.ModelMixin.save_pretrained.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to save the model using <code>safetensors</code> or the traditional PyTorch way with <code>pickle</code>.`,name:"safe_serialization"},{anchor:"diffusers.ModelMixin.save_pretrained.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
If specified, weights are saved in the format <code>pytorch_model.&lt;variant&gt;.bin</code>.`,name:"variant"},{anchor:"diffusers.ModelMixin.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face Hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"diffusers.ModelMixin.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional keyword arguments passed along to the <a href="/docs/diffusers/main/en/api/models/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_utils.py#L334"}}),we=new Tt({props:{title:"FlaxModelMixin",local:"diffusers.FlaxModelMixin",headingTag:"h2"}}),xe=new G({props:{name:"class diffusers.FlaxModelMixin",anchor:"diffusers.FlaxModelMixin",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_flax_utils.py#L50"}}),$e=new G({props:{name:"from_pretrained",anchor:"diffusers.FlaxModelMixin.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"},{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.FlaxModelMixin.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> (for example <code>runwayml/stable-diffusion-v1-5</code>) of a pretrained model
hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_model_directory</code>) containing the model weights saved
using <a href="/docs/diffusers/main/en/api/models/overview#diffusers.FlaxModelMixin.save_pretrained">save_pretrained()</a>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.FlaxModelMixin.from_pretrained.dtype",description:`<strong>dtype</strong> (<code>jax.numpy.dtype</code>, <em>optional</em>, defaults to <code>jax.numpy.float32</code>) &#x2014;
The data type of the computation. Can be one of <code>jax.numpy.float32</code>, <code>jax.numpy.float16</code> (on GPUs) and
<code>jax.numpy.bfloat16</code> (on TPUs).</p>
<p>This can be used to enable mixed-precision training or half-precision inference on GPUs or TPUs. If
specified, all the computation will be performed with the given <code>dtype</code>.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>This only specifies the dtype of the <em>computation</em> and does not influence the dtype of model
parameters.</p>
<p>If you wish to change the dtype of the model parameters, see <a href="/docs/diffusers/main/en/api/models/overview#diffusers.FlaxModelMixin.to_fp16">to_fp16()</a> and
<a href="/docs/diffusers/main/en/api/models/overview#diffusers.FlaxModelMixin.to_bf16">to_bf16()</a>.</p>

					</div>`,name:"dtype"},{anchor:"diffusers.FlaxModelMixin.from_pretrained.model_args",description:`<strong>model_args</strong> (sequence of positional arguments, <em>optional</em>) &#x2014;
All remaining positional arguments are passed to the underlying model&#x2019;s <code>__init__</code> method.`,name:"model_args"},{anchor:"diffusers.FlaxModelMixin.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.FlaxModelMixin.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.
resume_download &#x2014;
Deprecated and ignored. All downloads are now resumed by default when possible. Will be removed in v1
of Diffusers.`,name:"force_download"},{anchor:"diffusers.FlaxModelMixin.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.FlaxModelMixin.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only(bool,"},{anchor:"diffusers.FlaxModelMixin.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.FlaxModelMixin.from_pretrained.from_pt",description:`<strong>from_pt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a PyTorch checkpoint save file.`,name:"from_pt"},{anchor:"diffusers.FlaxModelMixin.from_pretrained.kwargs",description:`<strong>kwargs</strong> (remaining dictionary of keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it is loaded) and initiate the model (for
example, <code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>kwargs</code> are directly passed to the underlying
model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have already been
done).</li>
<li>If a configuration is not provided, <code>kwargs</code> are first passed to the configuration class
initialization function <a href="/docs/diffusers/main/en/api/configuration#diffusers.ConfigMixin.from_config">from_config()</a>. Each key of the <code>kwargs</code> that corresponds
to a configuration attribute is used to override said attribute with the supplied <code>kwargs</code> value.
Remaining keys that do not correspond to any configuration attribute are passed to the underlying
model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_flax_utils.py#L203"}}),se=new E({props:{anchor:"diffusers.FlaxModelMixin.from_pretrained.example",$$slots:{default:[ps]},$$scope:{ctx:$}}}),ae=new E({props:{anchor:"diffusers.FlaxModelMixin.from_pretrained.example-2",$$slots:{default:[fs]},$$scope:{ctx:$}}}),Te=new G({props:{name:"save_pretrained",anchor:"diffusers.FlaxModelMixin.save_pretrained",parameters:[{name:"save_directory",val:": Union"},{name:"params",val:": Union"},{name:"is_main_process",val:": bool = True"},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.FlaxModelMixin.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to save a model and its configuration file to. Will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"diffusers.FlaxModelMixin.save_pretrained.params",description:`<strong>params</strong> (<code>Union[Dict, FrozenDict]</code>) &#x2014;
A <code>PyTree</code> of model parameters.`,name:"params"},{anchor:"diffusers.FlaxModelMixin.save_pretrained.is_main_process",description:`<strong>is_main_process</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the process calling this is the main process or not. Useful during distributed training and you
need to call this function on all processes. In this case, set <code>is_main_process=True</code> only on the main
process to avoid race conditions.`,name:"is_main_process"},{anchor:"diffusers.FlaxModelMixin.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"diffusers.FlaxModelMixin.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional key word arguments passed along to the <a href="/docs/diffusers/main/en/api/models/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_flax_utils.py#L502"}}),Ue=new G({props:{name:"to_bf16",anchor:"diffusers.FlaxModelMixin.to_bf16",parameters:[{name:"params",val:": Union"},{name:"mask",val:": Any = None"}],parametersDescription:[{anchor:"diffusers.FlaxModelMixin.to_bf16.params",description:`<strong>params</strong> (<code>Union[Dict, FrozenDict]</code>) &#x2014;
A <code>PyTree</code> of model parameters.`,name:"params"},{anchor:"diffusers.FlaxModelMixin.to_bf16.mask",description:`<strong>mask</strong> (<code>Union[Dict, FrozenDict]</code>) &#x2014;
A <code>PyTree</code> with same structure as the <code>params</code> tree. The leaves should be booleans. It should be <code>True</code>
for params you want to cast, and <code>False</code> for those you want to skip.`,name:"mask"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_flax_utils.py#L95"}}),re=new E({props:{anchor:"diffusers.FlaxModelMixin.to_bf16.example",$$slots:{default:[us]},$$scope:{ctx:$}}}),Je=new G({props:{name:"to_fp16",anchor:"diffusers.FlaxModelMixin.to_fp16",parameters:[{name:"params",val:": Union"},{name:"mask",val:": Any = None"}],parametersDescription:[{anchor:"diffusers.FlaxModelMixin.to_fp16.params",description:`<strong>params</strong> (<code>Union[Dict, FrozenDict]</code>) &#x2014;
A <code>PyTree</code> of model parameters.`,name:"params"},{anchor:"diffusers.FlaxModelMixin.to_fp16.mask",description:`<strong>mask</strong> (<code>Union[Dict, FrozenDict]</code>) &#x2014;
A <code>PyTree</code> with same structure as the <code>params</code> tree. The leaves should be booleans. It should be <code>True</code>
for params you want to cast, and <code>False</code> for those you want to skip.`,name:"mask"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_flax_utils.py#L161"}}),le=new E({props:{anchor:"diffusers.FlaxModelMixin.to_fp16.example",$$slots:{default:[hs]},$$scope:{ctx:$}}}),je=new G({props:{name:"to_fp32",anchor:"diffusers.FlaxModelMixin.to_fp32",parameters:[{name:"params",val:": Union"},{name:"mask",val:": Any = None"}],parametersDescription:[{anchor:"diffusers.FlaxModelMixin.to_fp32.params",description:`<strong>params</strong> (<code>Union[Dict, FrozenDict]</code>) &#x2014;
A <code>PyTree</code> of model parameters.`,name:"params"},{anchor:"diffusers.FlaxModelMixin.to_fp32.mask",description:`<strong>mask</strong> (<code>Union[Dict, FrozenDict]</code>) &#x2014;
A <code>PyTree</code> with same structure as the <code>params</code> tree. The leaves should be booleans. It should be <code>True</code>
for params you want to cast, and <code>False</code> for those you want to skip.`,name:"mask"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_flax_utils.py#L134"}}),ie=new E({props:{anchor:"diffusers.FlaxModelMixin.to_fp32.example",$$slots:{default:[gs]},$$scope:{ctx:$}}}),ke=new Tt({props:{title:"PushToHubMixin",local:"diffusers.utils.PushToHubMixin",headingTag:"h2"}}),Ze=new G({props:{name:"class diffusers.utils.PushToHubMixin",anchor:"diffusers.utils.PushToHubMixin",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/utils/hub_utils.py#L396"}}),Ge=new G({props:{name:"push_to_hub",anchor:"diffusers.utils.PushToHubMixin.push_to_hub",parameters:[{name:"repo_id",val:": str"},{name:"commit_message",val:": Optional = None"},{name:"private",val:": Optional = None"},{name:"token",val:": Optional = None"},{name:"create_pr",val:": bool = False"},{name:"safe_serialization",val:": bool = True"},{name:"variant",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The name of the repository you want to push your model, scheduler, or pipeline files to. It should
contain your organization name when pushing to an organization. <code>repo_id</code> can also be a path to a local
directory.`,name:"repo_id"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Message to commit while pushing. Default to <code>&quot;Upload {object}&quot;</code>.`,name:"commit_message"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not the repository created should be private.`,name:"private"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. The token generated when running
<code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.create_pr",description:`<strong>create_pr</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to create a PR with the uploaded files or directly commit.`,name:"create_pr"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to convert the model weights to the <code>safetensors</code> format.`,name:"safe_serialization"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
If specified, weights are saved in the format <code>pytorch_model.&lt;variant&gt;.bin</code>.`,name:"variant"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/utils/hub_utils.py#L425"}}),de=new E({props:{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.example",$$slots:{default:[Ms]},$$scope:{ctx:$}}}),Ce=new ns({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/models/overview.md"}}),{c(){o=m("meta"),v=n(),l=m("p"),a=n(),u(d.$$.fragment),e=n(),f=m("p"),Ut=Lo("🤗 Diffusers provides pretrained models for popular algorithms and modules to create custom diffusion systems. The primary function of models is to denoise an input sample as modeled by the distribution "),ft=new os(!1),ut=Lo("."),ht=n(),pe=m("p"),pe.innerHTML=xo,gt=n(),u(fe.$$.fragment),Mt=n(),x=m("div"),u(ue.$$.fragment),Jt=n(),Xe=m("p"),Xe.textContent=$o,jt=n(),He=m("p"),He.innerHTML=To,kt=n(),Ne=m("ul"),Ne.innerHTML=Uo,Zt=n(),S=m("div"),u(he.$$.fragment),Gt=n(),Ye=m("p"),Ye.innerHTML=Jo,Ct=n(),L=m("div"),u(ge.$$.fragment),It=n(),ze=m("p"),ze.innerHTML=jo,Wt=n(),P=m("div"),u(Me.$$.fragment),Ft=n(),Ee=m("p"),Ee.innerHTML=ko,Bt=n(),I=m("div"),u(be.$$.fragment),Vt=n(),De=m("p"),De.innerHTML=Zo,Rt=n(),Qe=m("p"),Qe.textContent=Go,Xt=n(),u(q.$$.fragment),Ht=n(),u(A.$$.fragment),Nt=n(),Z=m("div"),u(ye.$$.fragment),Yt=n(),Se=m("p"),Se.textContent=Co,zt=n(),Le=m("p"),Le.innerHTML=Io,Et=n(),u(O.$$.fragment),Dt=n(),u(K.$$.fragment),Qt=n(),u(ee.$$.fragment),St=n(),N=m("div"),u(_e.$$.fragment),Lt=n(),Pe=m("p"),Pe.textContent=Wo,Pt=n(),u(te.$$.fragment),qt=n(),oe=m("div"),u(ve.$$.fragment),At=n(),qe=m("p"),qe.innerHTML=Fo,bt=n(),u(we.$$.fragment),yt=n(),U=m("div"),u(xe.$$.fragment),Ot=n(),Ae=m("p"),Ae.textContent=Bo,Kt=n(),Oe=m("p"),Oe.innerHTML=Vo,eo=n(),Ke=m("ul"),Ke.innerHTML=Ro,to=n(),F=m("div"),u($e.$$.fragment),oo=n(),et=m("p"),et.textContent=Xo,so=n(),u(se.$$.fragment),ao=n(),u(ae.$$.fragment),no=n(),ne=m("div"),u(Te.$$.fragment),ro=n(),tt=m("p"),tt.innerHTML=Ho,lo=n(),B=m("div"),u(Ue.$$.fragment),io=n(),ot=m("p"),ot.innerHTML=No,mo=n(),st=m("p"),st.textContent=Yo,co=n(),u(re.$$.fragment),po=n(),V=m("div"),u(Je.$$.fragment),fo=n(),at=m("p"),at.innerHTML=zo,uo=n(),nt=m("p"),nt.textContent=Eo,ho=n(),u(le.$$.fragment),go=n(),Y=m("div"),u(je.$$.fragment),Mo=n(),rt=m("p"),rt.innerHTML=Do,bo=n(),u(ie.$$.fragment),_t=n(),u(ke.$$.fragment),vt=n(),X=m("div"),u(Ze.$$.fragment),yo=n(),lt=m("p"),lt.textContent=Qo,_o=n(),z=m("div"),u(Ge.$$.fragment),vo=n(),it=m("p"),it.textContent=So,wo=n(),u(de.$$.fragment),wt=n(),u(Ce.$$.fragment),xt=n(),pt=m("p"),this.h()},l(t){const p=ss("svelte-u9bgzb",document.head);o=c(p,"META",{name:!0,content:!0}),p.forEach(i),v=r(t),l=c(t,"P",{}),j(l).forEach(i),a=r(t),h(d.$$.fragment,t),e=r(t),f=c(t,"P",{});var Ie=j(f);Ut=Po(Ie,"🤗 Diffusers provides pretrained models for popular algorithms and modules to create custom diffusion systems. The primary function of models is to denoise an input sample as modeled by the distribution "),ft=as(Ie,!1),ut=Po(Ie,"."),Ie.forEach(i),ht=r(t),pe=c(t,"P",{"data-svelte-h":!0}),w(pe)!=="svelte-1elbdrk"&&(pe.innerHTML=xo),gt=r(t),h(fe.$$.fragment,t),Mt=r(t),x=c(t,"DIV",{class:!0});var T=j(x);h(ue.$$.fragment,T),Jt=r(T),Xe=c(T,"P",{"data-svelte-h":!0}),w(Xe)!=="svelte-12nk4t7"&&(Xe.textContent=$o),jt=r(T),He=c(T,"P",{"data-svelte-h":!0}),w(He)!=="svelte-ku6myw"&&(He.innerHTML=To),kt=r(T),Ne=c(T,"UL",{"data-svelte-h":!0}),w(Ne)!=="svelte-kvpw1l"&&(Ne.innerHTML=Uo),Zt=r(T),S=c(T,"DIV",{class:!0});var We=j(S);h(he.$$.fragment,We),Gt=r(We),Ye=c(We,"P",{"data-svelte-h":!0}),w(Ye)!=="svelte-jedy0o"&&(Ye.innerHTML=Jo),We.forEach(i),Ct=r(T),L=c(T,"DIV",{class:!0});var Fe=j(L);h(ge.$$.fragment,Fe),It=r(Fe),ze=c(Fe,"P",{"data-svelte-h":!0}),w(ze)!=="svelte-1vfte1e"&&(ze.innerHTML=jo),Fe.forEach(i),Wt=r(T),P=c(T,"DIV",{class:!0});var Be=j(P);h(Me.$$.fragment,Be),Ft=r(Be),Ee=c(Be,"P",{"data-svelte-h":!0}),w(Ee)!=="svelte-1rv66k9"&&(Ee.innerHTML=ko),Be.forEach(i),Bt=r(T),I=c(T,"DIV",{class:!0});var W=j(I);h(be.$$.fragment,W),Vt=r(W),De=c(W,"P",{"data-svelte-h":!0}),w(De)!=="svelte-yfpdyb"&&(De.innerHTML=Zo),Rt=r(W),Qe=c(W,"P",{"data-svelte-h":!0}),w(Qe)!=="svelte-z1uct7"&&(Qe.textContent=Go),Xt=r(W),h(q.$$.fragment,W),Ht=r(W),h(A.$$.fragment,W),W.forEach(i),Nt=r(T),Z=c(T,"DIV",{class:!0});var C=j(Z);h(ye.$$.fragment,C),Yt=r(C),Se=c(C,"P",{"data-svelte-h":!0}),w(Se)!=="svelte-1lisopl"&&(Se.textContent=Co),zt=r(C),Le=c(C,"P",{"data-svelte-h":!0}),w(Le)!=="svelte-1fnd9e6"&&(Le.innerHTML=Io),Et=r(C),h(O.$$.fragment,C),Dt=r(C),h(K.$$.fragment,C),Qt=r(C),h(ee.$$.fragment,C),C.forEach(i),St=r(T),N=c(T,"DIV",{class:!0});var Q=j(N);h(_e.$$.fragment,Q),Lt=r(Q),Pe=c(Q,"P",{"data-svelte-h":!0}),w(Pe)!=="svelte-1jxmzhx"&&(Pe.textContent=Wo),Pt=r(Q),h(te.$$.fragment,Q),Q.forEach(i),qt=r(T),oe=c(T,"DIV",{class:!0});var Ve=j(oe);h(ve.$$.fragment,Ve),At=r(Ve),qe=c(Ve,"P",{"data-svelte-h":!0}),w(qe)!=="svelte-1y16a8m"&&(qe.innerHTML=Fo),Ve.forEach(i),T.forEach(i),bt=r(t),h(we.$$.fragment,t),yt=r(t),U=c(t,"DIV",{class:!0});var J=j(U);h(xe.$$.fragment,J),Ot=r(J),Ae=c(J,"P",{"data-svelte-h":!0}),w(Ae)!=="svelte-1kw8rks"&&(Ae.textContent=Bo),Kt=r(J),Oe=c(J,"P",{"data-svelte-h":!0}),w(Oe)!=="svelte-ltxz86"&&(Oe.innerHTML=Vo),eo=r(J),Ke=c(J,"UL",{"data-svelte-h":!0}),w(Ke)!=="svelte-5tww1s"&&(Ke.innerHTML=Ro),to=r(J),F=c(J,"DIV",{class:!0});var H=j(F);h($e.$$.fragment,H),oo=r(H),et=c(H,"P",{"data-svelte-h":!0}),w(et)!=="svelte-72pb05"&&(et.textContent=Xo),so=r(H),h(se.$$.fragment,H),ao=r(H),h(ae.$$.fragment,H),H.forEach(i),no=r(J),ne=c(J,"DIV",{class:!0});var Re=j(ne);h(Te.$$.fragment,Re),ro=r(Re),tt=c(Re,"P",{"data-svelte-h":!0}),w(tt)!=="svelte-9z80ed"&&(tt.innerHTML=Ho),Re.forEach(i),lo=r(J),B=c(J,"DIV",{class:!0});var me=j(B);h(Ue.$$.fragment,me),io=r(me),ot=c(me,"P",{"data-svelte-h":!0}),w(ot)!=="svelte-16uni9u"&&(ot.innerHTML=No),mo=r(me),st=c(me,"P",{"data-svelte-h":!0}),w(st)!=="svelte-1y9zqww"&&(st.textContent=Yo),co=r(me),h(re.$$.fragment,me),me.forEach(i),po=r(J),V=c(J,"DIV",{class:!0});var ce=j(V);h(Je.$$.fragment,ce),fo=r(ce),at=c(ce,"P",{"data-svelte-h":!0}),w(at)!=="svelte-ifz6ak"&&(at.innerHTML=zo),uo=r(ce),nt=c(ce,"P",{"data-svelte-h":!0}),w(nt)!=="svelte-yfkr09"&&(nt.textContent=Eo),ho=r(ce),h(le.$$.fragment,ce),ce.forEach(i),go=r(J),Y=c(J,"DIV",{class:!0});var dt=j(Y);h(je.$$.fragment,dt),Mo=r(dt),rt=c(dt,"P",{"data-svelte-h":!0}),w(rt)!=="svelte-j66hh4"&&(rt.innerHTML=Do),bo=r(dt),h(ie.$$.fragment,dt),dt.forEach(i),J.forEach(i),_t=r(t),h(ke.$$.fragment,t),vt=r(t),X=c(t,"DIV",{class:!0});var mt=j(X);h(Ze.$$.fragment,mt),yo=r(mt),lt=c(mt,"P",{"data-svelte-h":!0}),w(lt)!=="svelte-7y8zei"&&(lt.textContent=Qo),_o=r(mt),z=c(mt,"DIV",{class:!0});var ct=j(z);h(Ge.$$.fragment,ct),vo=r(ct),it=c(ct,"P",{"data-svelte-h":!0}),w(it)!=="svelte-5nfhmh"&&(it.textContent=So),wo=r(ct),h(de.$$.fragment,ct),ct.forEach(i),mt.forEach(i),wt=r(t),h(Ce.$$.fragment,t),xt=r(t),pt=c(t,"P",{}),j(pt).forEach(i),this.h()},h(){k(o,"name","hf:doc:metadata"),k(o,"content",ys),ft.a=ut,k(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,p){s(document.head,o),_(t,v,p),_(t,l,p),_(t,a,p),g(d,t,p),_(t,e,p),_(t,f,p),s(f,Ut),ft.m(Ao,f),s(f,ut),_(t,ht,p),_(t,pe,p),_(t,gt,p),g(fe,t,p),_(t,Mt,p),_(t,x,p),g(ue,x,null),s(x,Jt),s(x,Xe),s(x,jt),s(x,He),s(x,kt),s(x,Ne),s(x,Zt),s(x,S),g(he,S,null),s(S,Gt),s(S,Ye),s(x,Ct),s(x,L),g(ge,L,null),s(L,It),s(L,ze),s(x,Wt),s(x,P),g(Me,P,null),s(P,Ft),s(P,Ee),s(x,Bt),s(x,I),g(be,I,null),s(I,Vt),s(I,De),s(I,Rt),s(I,Qe),s(I,Xt),g(q,I,null),s(I,Ht),g(A,I,null),s(x,Nt),s(x,Z),g(ye,Z,null),s(Z,Yt),s(Z,Se),s(Z,zt),s(Z,Le),s(Z,Et),g(O,Z,null),s(Z,Dt),g(K,Z,null),s(Z,Qt),g(ee,Z,null),s(x,St),s(x,N),g(_e,N,null),s(N,Lt),s(N,Pe),s(N,Pt),g(te,N,null),s(x,qt),s(x,oe),g(ve,oe,null),s(oe,At),s(oe,qe),_(t,bt,p),g(we,t,p),_(t,yt,p),_(t,U,p),g(xe,U,null),s(U,Ot),s(U,Ae),s(U,Kt),s(U,Oe),s(U,eo),s(U,Ke),s(U,to),s(U,F),g($e,F,null),s(F,oo),s(F,et),s(F,so),g(se,F,null),s(F,ao),g(ae,F,null),s(U,no),s(U,ne),g(Te,ne,null),s(ne,ro),s(ne,tt),s(U,lo),s(U,B),g(Ue,B,null),s(B,io),s(B,ot),s(B,mo),s(B,st),s(B,co),g(re,B,null),s(U,po),s(U,V),g(Je,V,null),s(V,fo),s(V,at),s(V,uo),s(V,nt),s(V,ho),g(le,V,null),s(U,go),s(U,Y),g(je,Y,null),s(Y,Mo),s(Y,rt),s(Y,bo),g(ie,Y,null),_(t,_t,p),g(ke,t,p),_(t,vt,p),_(t,X,p),g(Ze,X,null),s(X,yo),s(X,lt),s(X,_o),s(X,z),g(Ge,z,null),s(z,vo),s(z,it),s(z,wo),g(de,z,null),_(t,wt,p),g(Ce,t,p),_(t,xt,p),_(t,pt,p),$t=!0},p(t,[p]){const Ie={};p&2&&(Ie.$$scope={dirty:p,ctx:t}),q.$set(Ie);const T={};p&2&&(T.$$scope={dirty:p,ctx:t}),A.$set(T);const We={};p&2&&(We.$$scope={dirty:p,ctx:t}),O.$set(We);const Fe={};p&2&&(Fe.$$scope={dirty:p,ctx:t}),K.$set(Fe);const Be={};p&2&&(Be.$$scope={dirty:p,ctx:t}),ee.$set(Be);const W={};p&2&&(W.$$scope={dirty:p,ctx:t}),te.$set(W);const C={};p&2&&(C.$$scope={dirty:p,ctx:t}),se.$set(C);const Q={};p&2&&(Q.$$scope={dirty:p,ctx:t}),ae.$set(Q);const Ve={};p&2&&(Ve.$$scope={dirty:p,ctx:t}),re.$set(Ve);const J={};p&2&&(J.$$scope={dirty:p,ctx:t}),le.$set(J);const H={};p&2&&(H.$$scope={dirty:p,ctx:t}),ie.$set(H);const Re={};p&2&&(Re.$$scope={dirty:p,ctx:t}),de.$set(Re)},i(t){$t||(M(d.$$.fragment,t),M(fe.$$.fragment,t),M(ue.$$.fragment,t),M(he.$$.fragment,t),M(ge.$$.fragment,t),M(Me.$$.fragment,t),M(be.$$.fragment,t),M(q.$$.fragment,t),M(A.$$.fragment,t),M(ye.$$.fragment,t),M(O.$$.fragment,t),M(K.$$.fragment,t),M(ee.$$.fragment,t),M(_e.$$.fragment,t),M(te.$$.fragment,t),M(ve.$$.fragment,t),M(we.$$.fragment,t),M(xe.$$.fragment,t),M($e.$$.fragment,t),M(se.$$.fragment,t),M(ae.$$.fragment,t),M(Te.$$.fragment,t),M(Ue.$$.fragment,t),M(re.$$.fragment,t),M(Je.$$.fragment,t),M(le.$$.fragment,t),M(je.$$.fragment,t),M(ie.$$.fragment,t),M(ke.$$.fragment,t),M(Ze.$$.fragment,t),M(Ge.$$.fragment,t),M(de.$$.fragment,t),M(Ce.$$.fragment,t),$t=!0)},o(t){b(d.$$.fragment,t),b(fe.$$.fragment,t),b(ue.$$.fragment,t),b(he.$$.fragment,t),b(ge.$$.fragment,t),b(Me.$$.fragment,t),b(be.$$.fragment,t),b(q.$$.fragment,t),b(A.$$.fragment,t),b(ye.$$.fragment,t),b(O.$$.fragment,t),b(K.$$.fragment,t),b(ee.$$.fragment,t),b(_e.$$.fragment,t),b(te.$$.fragment,t),b(ve.$$.fragment,t),b(we.$$.fragment,t),b(xe.$$.fragment,t),b($e.$$.fragment,t),b(se.$$.fragment,t),b(ae.$$.fragment,t),b(Te.$$.fragment,t),b(Ue.$$.fragment,t),b(re.$$.fragment,t),b(Je.$$.fragment,t),b(le.$$.fragment,t),b(je.$$.fragment,t),b(ie.$$.fragment,t),b(ke.$$.fragment,t),b(Ze.$$.fragment,t),b(Ge.$$.fragment,t),b(de.$$.fragment,t),b(Ce.$$.fragment,t),$t=!1},d(t){t&&(i(v),i(l),i(a),i(e),i(f),i(ht),i(pe),i(gt),i(Mt),i(x),i(bt),i(yt),i(U),i(_t),i(vt),i(X),i(wt),i(xt),i(pt)),i(o),y(d,t),y(fe,t),y(ue),y(he),y(ge),y(Me),y(be),y(q),y(A),y(ye),y(O),y(K),y(ee),y(_e),y(te),y(ve),y(we,t),y(xe),y($e),y(se),y(ae),y(Te),y(Ue),y(re),y(Je),y(le),y(je),y(ie),y(ke,t),y(Ze),y(Ge),y(de),y(Ce,t)}}}const ys='{"title":"Models","local":"models","sections":[{"title":"ModelMixin","local":"diffusers.ModelMixin","sections":[],"depth":2},{"title":"FlaxModelMixin","local":"diffusers.FlaxModelMixin","sections":[],"depth":2},{"title":"PushToHubMixin","local":"diffusers.utils.PushToHubMixin","sections":[],"depth":2}],"depth":1}';function _s($){return Ko(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class js extends es{constructor(o){super(),ts(this,o,_s,bs,Oo,{})}}export{js as component};
