import{s as rl,n as ml,o as wl}from"../chunks/scheduler.9680c161.js";import{S as jl,i as hl,g as M,s as a,r as y,A as Il,h as o,f as t,c as n,j as cl,u as i,x as T,k as Tl,y as dl,a as e,v as p,d as U,t as J,w as u}from"../chunks/index.38d74ee1.js";import{C as al}from"../chunks/CodeBlock.1371964c.js";import{H as W}from"../chunks/Heading.74c51a96.js";function gl(nl){let c,N,E,$,r,x,m,Ml="<em>Messages API is compatible to OpenAI Chat Completion API</em>",Y,w,ol="Text Generation Inference (TGI) now supports the Message API which is fully compatible with the OpenAI Chat Completion API. This means you can use OpenAI’s client libraries to interact with TGI’s Messages API. Below are some examples of how to utilize this compatibility.",k,j,v,h,yl="You can make a request to TGI’s Messages API using <code>curl</code>. Here’s an example:",R,I,_,d,X,g,il="You can also use OpenAI’s Python client library to make a streaming request. Here’s how:",z,C,F,b,H,G,pl="If you prefer to make a synchronous request, you can do so like this:",P,B,D,Q,L,Z,Ul="TGI can be deployed on various cloud providers for scalable and robust text generation. One such provider is Amazon SageMaker, which has recently added support for TGI. Here’s how you can deploy TGI on Amazon SageMaker:",O,f,K,S,Jl="To enable the Messages API in Amazon SageMaker you need to set the environment variable <code>MESSAGES_API_ENABLED=true</code>.",ll,q,ul="This will modify the <code>/invocations</code> route to accept Messages dictonaries consisting out of role and content. See the example below on how to deploy Llama with the new Messages API.",sl,A,tl,V,el;return r=new W({props:{title:"Messages API",local:"messages-api",headingTag:"h1"}}),j=new W({props:{title:"Making a Request",local:"making-a-request",headingTag:"h2"}}),I=new al({props:{code:"Y3VybCUyMGxvY2FsaG9zdCUzQTMwMDAlMkZ2MSUyRmNoYXQlMkZjb21wbGV0aW9ucyUyMCU1QyUwQSUyMCUyMCUyMCUyMC1YJTIwUE9TVCUyMCU1QyUwQSUyMCUyMCUyMCUyMC1kJTIwJyU3QiUwQSUyMCUyMCUyMm1vZGVsJTIyJTNBJTIwJTIydGdpJTIyJTJDJTBBJTIwJTIwJTIybWVzc2FnZXMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGElMjBoZWxwZnVsJTIwYXNzaXN0YW50LiUyMiUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoYXQlMjBpcyUyMGRlZXAlMjBsZWFybmluZyUzRiUyMiUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMnN0cmVhbSUyMiUzQSUyMHRydWUlMkMlMEElMjAlMjAlMjJtYXhfdG9rZW5zJTIyJTNBJTIwMjAlMEElN0QnJTIwJTVDJTBBJTIwJTIwJTIwJTIwLUglMjAnQ29udGVudC1UeXBlJTNBJTIwYXBwbGljYXRpb24lMkZqc29uJw==",highlighted:`curl localhost:3000/v1/chat/completions \\
    -X POST \\
    -d <span class="hljs-string">&#x27;{
  &quot;model&quot;: &quot;tgi&quot;,
  &quot;messages&quot;: [
    {
      &quot;role&quot;: &quot;system&quot;,
      &quot;content&quot;: &quot;You are a helpful assistant.&quot;
    },
    {
      &quot;role&quot;: &quot;user&quot;,
      &quot;content&quot;: &quot;What is deep learning?&quot;
    }
  ],
  &quot;stream&quot;: true,
  &quot;max_tokens&quot;: 20
}&#x27;</span> \\
    -H <span class="hljs-string">&#x27;Content-Type: application/json&#x27;</span>`,wrap:!1}}),d=new W({props:{title:"Streaming",local:"streaming",headingTag:"h2"}}),C=new al({props:{code:"ZnJvbSUyMG9wZW5haSUyMGltcG9ydCUyME9wZW5BSSUwQSUwQSUyMyUyMGluaXQlMjB0aGUlMjBjbGllbnQlMjBidXQlMjBwb2ludCUyMGl0JTIwdG8lMjBUR0klMEFjbGllbnQlMjAlM0QlMjBPcGVuQUkoJTBBJTIwJTIwJTIwJTIwYmFzZV91cmwlM0QlMjJodHRwJTNBJTJGJTJGbG9jYWxob3N0JTNBMzAwMCUyRnYxJTIyJTJDJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMi0lMjIlMEEpJTBBJTBBY2hhdF9jb21wbGV0aW9uJTIwJTNEJTIwY2xpZW50LmNoYXQuY29tcGxldGlvbnMuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIydGdpJTIyJTJDJTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGElMjBoZWxwZnVsJTIwYXNzaXN0YW50LiUyMiUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoYXQlMjBpcyUyMGRlZXAlMjBsZWFybmluZyUzRiUyMiU3RCUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMHN0cmVhbSUzRFRydWUlMEEpJTBBJTBBJTIzJTIwaXRlcmF0ZSUyMGFuZCUyMHByaW50JTIwc3RyZWFtJTBBZm9yJTIwbWVzc2FnZSUyMGluJTIwY2hhdF9jb21wbGV0aW9uJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQobWVzc2FnZSk=",highlighted:`<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

<span class="hljs-comment"># init the client but point it to TGI</span>
client = OpenAI(
    base_url=<span class="hljs-string">&quot;http://localhost:3000/v1&quot;</span>,
    api_key=<span class="hljs-string">&quot;-&quot;</span>
)

chat_completion = client.chat.completions.create(
    model=<span class="hljs-string">&quot;tgi&quot;</span>,
    messages=[
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span> },
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is deep learning?&quot;</span>}
    ],
    stream=<span class="hljs-literal">True</span>
)

<span class="hljs-comment"># iterate and print stream</span>
<span class="hljs-keyword">for</span> message <span class="hljs-keyword">in</span> chat_completion:
    <span class="hljs-built_in">print</span>(message)`,wrap:!1}}),b=new W({props:{title:"Synchronous",local:"synchronous",headingTag:"h2"}}),B=new al({props:{code:"ZnJvbSUyMG9wZW5haSUyMGltcG9ydCUyME9wZW5BSSUwQSUwQSUyMyUyMGluaXQlMjB0aGUlMjBjbGllbnQlMjBidXQlMjBwb2ludCUyMGl0JTIwdG8lMjBUR0klMEFjbGllbnQlMjAlM0QlMjBPcGVuQUkoJTBBJTIwJTIwJTIwJTIwYmFzZV91cmwlM0QlMjJodHRwJTNBJTJGJTJGbG9jYWxob3N0JTNBMzAwMCUyRnYxJTIyJTJDJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMi0lMjIlMEEpJTBBJTBBY2hhdF9jb21wbGV0aW9uJTIwJTNEJTIwY2xpZW50LmNoYXQuY29tcGxldGlvbnMuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIydGdpJTIyJTJDJTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGElMjBoZWxwZnVsJTIwYXNzaXN0YW50LiUyMiUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoYXQlMjBpcyUyMGRlZXAlMjBsZWFybmluZyUzRiUyMiU3RCUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMHN0cmVhbSUzREZhbHNlJTBBKSUwQSUwQXByaW50KGNoYXRfY29tcGxldGlvbik=",highlighted:`<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

<span class="hljs-comment"># init the client but point it to TGI</span>
client = OpenAI(
    base_url=<span class="hljs-string">&quot;http://localhost:3000/v1&quot;</span>,
    api_key=<span class="hljs-string">&quot;-&quot;</span>
)

chat_completion = client.chat.completions.create(
    model=<span class="hljs-string">&quot;tgi&quot;</span>,
    messages=[
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span> },
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is deep learning?&quot;</span>}
    ],
    stream=<span class="hljs-literal">False</span>
)

<span class="hljs-built_in">print</span>(chat_completion)`,wrap:!1}}),Q=new W({props:{title:"Cloud Providers",local:"cloud-providers",headingTag:"h2"}}),f=new W({props:{title:"Amazon SageMaker",local:"amazon-sagemaker",headingTag:"h2"}}),A=new al({props:{code:"aW1wb3J0JTIwanNvbiUwQWltcG9ydCUyMHNhZ2VtYWtlciUwQWltcG9ydCUyMGJvdG8zJTBBZnJvbSUyMHNhZ2VtYWtlci5odWdnaW5nZmFjZSUyMGltcG9ydCUyMEh1Z2dpbmdGYWNlTW9kZWwlMkMlMjBnZXRfaHVnZ2luZ2ZhY2VfbGxtX2ltYWdlX3VyaSUwQSUwQXRyeSUzQSUwQSUwOXJvbGUlMjAlM0QlMjBzYWdlbWFrZXIuZ2V0X2V4ZWN1dGlvbl9yb2xlKCklMEFleGNlcHQlMjBWYWx1ZUVycm9yJTNBJTBBJTA5aWFtJTIwJTNEJTIwYm90bzMuY2xpZW50KCdpYW0nKSUwQSUwOXJvbGUlMjAlM0QlMjBpYW0uZ2V0X3JvbGUoUm9sZU5hbWUlM0Qnc2FnZW1ha2VyX2V4ZWN1dGlvbl9yb2xlJyklNUInUm9sZSclNUQlNUInQXJuJyU1RCUwQSUwQSUyMyUyMEh1YiUyME1vZGVsJTIwY29uZmlndXJhdGlvbi4lMjBodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGbW9kZWxzJTBBaHViJTIwJTNEJTIwJTdCJTBBJTA5J0hGX01PREVMX0lEJyUzQSdIdWdnaW5nRmFjZUg0JTJGemVwaHlyLTdiLWJldGEnJTJDJTBBJTA5J1NNX05VTV9HUFVTJyUzQSUyMGpzb24uZHVtcHMoMSklMkMlMEElMjAlMjAlMjAlMjAnTUVTU0FHRVNfQVBJX0VOQUJMRUQnJTNBJTIwVHJ1ZSUwQSU3RCUwQSUwQSUyMyUyMGNyZWF0ZSUyMEh1Z2dpbmclMjBGYWNlJTIwTW9kZWwlMjBDbGFzcyUwQWh1Z2dpbmdmYWNlX21vZGVsJTIwJTNEJTIwSHVnZ2luZ0ZhY2VNb2RlbCglMEElMDlpbWFnZV91cmklM0RnZXRfaHVnZ2luZ2ZhY2VfbGxtX2ltYWdlX3VyaSglMjJodWdnaW5nZmFjZSUyMiUyQ3ZlcnNpb24lM0QlMjIxLjQuMCUyMiklMkMlMEElMDllbnYlM0RodWIlMkMlMEElMDlyb2xlJTNEcm9sZSUyQyUyMCUwQSklMEElMEElMjMlMjBkZXBsb3klMjBtb2RlbCUyMHRvJTIwU2FnZU1ha2VyJTIwSW5mZXJlbmNlJTBBcHJlZGljdG9yJTIwJTNEJTIwaHVnZ2luZ2ZhY2VfbW9kZWwuZGVwbG95KCUwQSUwOWluaXRpYWxfaW5zdGFuY2VfY291bnQlM0QxJTJDJTBBJTA5aW5zdGFuY2VfdHlwZSUzRCUyMm1sLmc1LjJ4bGFyZ2UlMjIlMkMlMEElMDljb250YWluZXJfc3RhcnR1cF9oZWFsdGhfY2hlY2tfdGltZW91dCUzRDMwMCUyQyUwQSUyMCUyMCklMEElMjAlMjAlMEElMjMlMjBzZW5kJTIwcmVxdWVzdCUwQXByZWRpY3Rvci5wcmVkaWN0KCU3QiUwQSUyMm1lc3NhZ2VzJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGFzc2lzdGFudC4lMjIlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwaXMlMjBkZWVwJTIwbGVhcm5pbmclM0YlMjIlN0QlMEElMjAlMjAlMjAlMjAlNUQlMEElN0Qp",highlighted:`<span class="hljs-keyword">import</span> json
<span class="hljs-keyword">import</span> sagemaker
<span class="hljs-keyword">import</span> boto3
<span class="hljs-keyword">from</span> sagemaker.huggingface <span class="hljs-keyword">import</span> HuggingFaceModel, get_huggingface_llm_image_uri

<span class="hljs-keyword">try</span>:
	role = sagemaker.get_execution_role()
<span class="hljs-keyword">except</span> ValueError:
	iam = boto3.client(<span class="hljs-string">&#x27;iam&#x27;</span>)
	role = iam.get_role(RoleName=<span class="hljs-string">&#x27;sagemaker_execution_role&#x27;</span>)[<span class="hljs-string">&#x27;Role&#x27;</span>][<span class="hljs-string">&#x27;Arn&#x27;</span>]

<span class="hljs-comment"># Hub Model configuration. https://huggingface.co/models</span>
hub = {
	<span class="hljs-string">&#x27;HF_MODEL_ID&#x27;</span>:<span class="hljs-string">&#x27;HuggingFaceH4/zephyr-7b-beta&#x27;</span>,
	<span class="hljs-string">&#x27;SM_NUM_GPUS&#x27;</span>: json.dumps(<span class="hljs-number">1</span>),
    <span class="hljs-string">&#x27;MESSAGES_API_ENABLED&#x27;</span>: <span class="hljs-literal">True</span>
}

<span class="hljs-comment"># create Hugging Face Model Class</span>
huggingface_model = HuggingFaceModel(
	image_uri=get_huggingface_llm_image_uri(<span class="hljs-string">&quot;huggingface&quot;</span>,version=<span class="hljs-string">&quot;1.4.0&quot;</span>),
	env=hub,
	role=role, 
)

<span class="hljs-comment"># deploy model to SageMaker Inference</span>
predictor = huggingface_model.deploy(
	initial_instance_count=<span class="hljs-number">1</span>,
	instance_type=<span class="hljs-string">&quot;ml.g5.2xlarge&quot;</span>,
	container_startup_health_check_timeout=<span class="hljs-number">300</span>,
  )
  
<span class="hljs-comment"># send request</span>
predictor.predict({
<span class="hljs-string">&quot;messages&quot;</span>: [
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span> },
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is deep learning?&quot;</span>}
    ]
})`,wrap:!1}}),{c(){c=M("meta"),N=a(),E=M("p"),$=a(),y(r.$$.fragment),x=a(),m=M("p"),m.innerHTML=Ml,Y=a(),w=M("p"),w.textContent=ol,k=a(),y(j.$$.fragment),v=a(),h=M("p"),h.innerHTML=yl,R=a(),y(I.$$.fragment),_=a(),y(d.$$.fragment),X=a(),g=M("p"),g.textContent=il,z=a(),y(C.$$.fragment),F=a(),y(b.$$.fragment),H=a(),G=M("p"),G.textContent=pl,P=a(),y(B.$$.fragment),D=a(),y(Q.$$.fragment),L=a(),Z=M("p"),Z.textContent=Ul,O=a(),y(f.$$.fragment),K=a(),S=M("p"),S.innerHTML=Jl,ll=a(),q=M("p"),q.innerHTML=ul,sl=a(),y(A.$$.fragment),tl=a(),V=M("p"),this.h()},l(l){const s=Il("svelte-u9bgzb",document.head);c=o(s,"META",{name:!0,content:!0}),s.forEach(t),N=n(l),E=o(l,"P",{}),cl(E).forEach(t),$=n(l),i(r.$$.fragment,l),x=n(l),m=o(l,"P",{"data-svelte-h":!0}),T(m)!=="svelte-1cus5dm"&&(m.innerHTML=Ml),Y=n(l),w=o(l,"P",{"data-svelte-h":!0}),T(w)!=="svelte-482jbe"&&(w.textContent=ol),k=n(l),i(j.$$.fragment,l),v=n(l),h=o(l,"P",{"data-svelte-h":!0}),T(h)!=="svelte-1w70cim"&&(h.innerHTML=yl),R=n(l),i(I.$$.fragment,l),_=n(l),i(d.$$.fragment,l),X=n(l),g=o(l,"P",{"data-svelte-h":!0}),T(g)!=="svelte-1g3ypvi"&&(g.textContent=il),z=n(l),i(C.$$.fragment,l),F=n(l),i(b.$$.fragment,l),H=n(l),G=o(l,"P",{"data-svelte-h":!0}),T(G)!=="svelte-1xyk36t"&&(G.textContent=pl),P=n(l),i(B.$$.fragment,l),D=n(l),i(Q.$$.fragment,l),L=n(l),Z=o(l,"P",{"data-svelte-h":!0}),T(Z)!=="svelte-10f0asl"&&(Z.textContent=Ul),O=n(l),i(f.$$.fragment,l),K=n(l),S=o(l,"P",{"data-svelte-h":!0}),T(S)!=="svelte-ccajsj"&&(S.innerHTML=Jl),ll=n(l),q=o(l,"P",{"data-svelte-h":!0}),T(q)!=="svelte-7x0wid"&&(q.innerHTML=ul),sl=n(l),i(A.$$.fragment,l),tl=n(l),V=o(l,"P",{}),cl(V).forEach(t),this.h()},h(){Tl(c,"name","hf:doc:metadata"),Tl(c,"content",Cl)},m(l,s){dl(document.head,c),e(l,N,s),e(l,E,s),e(l,$,s),p(r,l,s),e(l,x,s),e(l,m,s),e(l,Y,s),e(l,w,s),e(l,k,s),p(j,l,s),e(l,v,s),e(l,h,s),e(l,R,s),p(I,l,s),e(l,_,s),p(d,l,s),e(l,X,s),e(l,g,s),e(l,z,s),p(C,l,s),e(l,F,s),p(b,l,s),e(l,H,s),e(l,G,s),e(l,P,s),p(B,l,s),e(l,D,s),p(Q,l,s),e(l,L,s),e(l,Z,s),e(l,O,s),p(f,l,s),e(l,K,s),e(l,S,s),e(l,ll,s),e(l,q,s),e(l,sl,s),p(A,l,s),e(l,tl,s),e(l,V,s),el=!0},p:ml,i(l){el||(U(r.$$.fragment,l),U(j.$$.fragment,l),U(I.$$.fragment,l),U(d.$$.fragment,l),U(C.$$.fragment,l),U(b.$$.fragment,l),U(B.$$.fragment,l),U(Q.$$.fragment,l),U(f.$$.fragment,l),U(A.$$.fragment,l),el=!0)},o(l){J(r.$$.fragment,l),J(j.$$.fragment,l),J(I.$$.fragment,l),J(d.$$.fragment,l),J(C.$$.fragment,l),J(b.$$.fragment,l),J(B.$$.fragment,l),J(Q.$$.fragment,l),J(f.$$.fragment,l),J(A.$$.fragment,l),el=!1},d(l){l&&(t(N),t(E),t($),t(x),t(m),t(Y),t(w),t(k),t(v),t(h),t(R),t(_),t(X),t(g),t(z),t(F),t(H),t(G),t(P),t(D),t(L),t(Z),t(O),t(K),t(S),t(ll),t(q),t(sl),t(tl),t(V)),t(c),u(r,l),u(j,l),u(I,l),u(d,l),u(C,l),u(b,l),u(B,l),u(Q,l),u(f,l),u(A,l)}}}const Cl='{"title":"Messages API","local":"messages-api","sections":[{"title":"Making a Request","local":"making-a-request","sections":[],"depth":2},{"title":"Streaming","local":"streaming","sections":[],"depth":2},{"title":"Synchronous","local":"synchronous","sections":[],"depth":2},{"title":"Cloud Providers","local":"cloud-providers","sections":[],"depth":2},{"title":"Amazon SageMaker","local":"amazon-sagemaker","sections":[],"depth":2}],"depth":1}';function bl(nl){return wl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class fl extends jl{constructor(c){super(),hl(this,c,bl,gl,rl,{})}}export{fl as component};
