import{s as _l,f as el,n as ql,o as Hl}from"../chunks/scheduler.37c15a92.js";import{S as El,i as Wl,g as i,s as a,r as y,A as Rl,h as p,f as t,c as n,j as oe,u as m,x as o,k as r,y as Ll,a as s,v as d,d as w,t as T,w as j}from"../chunks/index.2bf4358c.js";import{C as ll}from"../chunks/CodeBlock.4f5fc1ad.js";import{D as Ql}from"../chunks/DocNotebookDropdown.46ab6a61.js";import{H as ne}from"../chunks/Heading.8ada512a.js";function Sl(tl){let J,re,ie,Me,h,ue,f,ce,U,sl="在本節中，我們將仔細研究 <code>Interface</code> 類，並瞭解用於創建其的主要參數。",ye,b,me,I,al="您會注意到 <code>Interface</code> 類有 3 個必需參數：",de,C,nl="<code>Interface(fn, inputs, outputs, ...)</code>",we,v,il="這些參數是：",Te,k,pl="<li><code>fn</code>: 由 Gradio 接口包裝的預測函數。 該函數可以接受一個或多個參數並返回一個或多個值</li> <li><code>inputs</code>: 輸入組件類型。 Gradio 提供了許多預構建的組件，例如<code>&quot;image&quot;</code> 或<code>&quot;mic&quot;</code>。</li> <li><code>outputs</code>: 輸出組件類型。 同樣，Gradio 提供了許多預構建的組件，例如 <code>“圖像”</code>或“標籤”`。</li>",je,g,ol='有關組件的完整列表，<a href="https://gradio.app/docs" rel="nofollow">請參閱 Gradio 文檔</a>。 每個預構建的組件都可以通過實例化該組件對應的類來定製。',Je,A,rl=`例如，正如我們在 <a href="/course/chapter9/2">上一節</a> 中看到的，您可以傳入一個 <code>Textbox(lines=7, label=&quot;Prompt&quot;)</code> 組件來創建一個包含 7 行和一個標籤的文本框，而不是將 <code>&quot;textbox&quot;</code> 傳遞給 <code>inputs</code> 參數。
讓我們看另一個例子，這次是一個 <code>Audio</code> 組件。`,he,x,fe,G,Ml=`如前所述，Gradio 提供了許多不同的輸入和輸出。
因此，讓我們構建一個適用於音頻的“接口”。`,Ue,B,ul="在這個例子中，我們將構建一個音頻到音頻的函數，它需要一個音頻文件並簡單地反轉它。",be,$,cl="我們將使用 <code>Audio</code> 組件作為輸入。 使用 <code>Audio</code> 組件時，您可以指定希望音頻的 <code>source</code> 是用戶上傳的文件還是用戶錄製聲音的麥克風。 在這種情況下，讓我們將其設置為“麥克風”。 只是為了好玩，我們會在我們的“音頻”中添加一個標籤，上面寫著“在這裡說話……”。",Ie,Z,yl="此外，我們希望將音頻作為 numpy 數組接收，以便我們可以輕鬆地“反轉”它。 所以我們將 <code>&quot;type&quot;</code> 設置為 <code>&quot;numpy&quot;</code>，它會傳遞輸入data 作為 (<code>sample_rate</code>, <code>data</code>) 的元組進入我們的函數。",Ce,_,ml="我們還將使用 <code>Audio</code> 輸出組件，它可以自動將具有采樣率和 numpy 數據數組的元組渲染為可播放的音頻文件。 在這種情況下，我們不需要進行任何自定義，因此我們將使用字符串快捷方式“audio”。",ve,q,ke,H,dl=`上面的代碼會產生一個類似下面的界面（如果你的瀏覽器沒有
詢問您的麥克風權限， <a href="https://huggingface.co/spaces/course-demos/audio-reverse" target="_blank">open the demo in  a separate tab</a>.)`,ge,M,wl,Ae,E,Tl="您現在應該能夠錄製自己的聲音並聽到自己在反向說話 - 聽起來好怪👻!",xe,W,Ge,R,jl="假設我們有一個更復雜的函數，有多個輸入和輸出。在下面的示例中，我們有一個接受下拉索引、滑塊值和數字的函數，並返回一個音調的音頻樣本。",Be,L,Jl="看看我們如何傳遞輸入和輸出組件列表，看看你能不能跟上正在發生的事情。",$e,Q,hl="這裡的關鍵是當你通過時：",Ze,S,fl="<li>輸入組件列表，每個組件依次對應一個參數。</li> <li>輸出組件列表，每個組件對應一個返回值。</li>",_e,V,Ul="下面的代碼片段顯示了三個輸入組件如何與 <code>generate_tone()</code> 函數的三個參數對齊：",qe,N,He,u,bl,Ee,X,We,Y,Il=`到目前為止，我們已經使用了<code>launch()</code>方法來啟動界面，但是我們
還沒有真正討論過它的作用。`,Re,P,Cl="默認情況下，<code>launch()</code> 方法將在 Web 服務器中啟動演示正在本地運行。 如果您在 Jupyter 或 Colab 筆記本中運行代碼，那麼Gradio 會將演示 GUI 嵌入到筆記本中，以便您輕鬆使用它。",Le,z,vl="您可以通過不同的參數自定義 <code>launch()</code> 的行為：",Qe,F,kl="<li><code>inline</code> - whether to display the interface inline on Python notebooks.</li> <li><code>inbrowser</code> - whether to automatically launch the interface in a new tab on the default browser.</li> <li><code>share</code> - whether to create a publicly shareable link from your computer for the interface. Kind of like a Google Drive link!</li>",Se,D,gl="我們將在下一節中更詳細地介紹 <code>share</code> 參數！",Ve,K,Ne,O,Al=`讓我們構建一個界面，讓您演示 <strong>speech-recognition</strong> 模型。
為了讓它變得有趣，我們將接受 <em>or</em> 麥克風輸入或上傳的文件。`,Xe,ee,xl='像往常一樣，我們將使用 🤗 Transformers 中的 <code>pipeline()</code> 函數加載我們的語音識別模型。如果您需要快速複習，您可以返回 <a href="/course/chapter1/3">第 1 章中的那個部分</a>。 接下來，我們將實現一個 <code>transcribe_audio()</code> 函數來處理音頻並返回轉錄。 最後，我們將把這個函數包裝在一個 <code>Interface</code> 中，其中 <code>Audio</code> 組件用於輸入，只有文本用於輸出。 總而言之，此應用程序的代碼如下：',Ye,le,Pe,te,Gl='如果您的瀏覽器沒有要求您提供麥克風權限，<a href="https://huggingface.co/spaces/course-demos/audio-reverse" target="_blank">open the demo in a separate tab</a>.',ze,c,Bl,Fe,se,$l=`就是這樣！ 您現在可以使用此界面來轉錄音頻。 注意這裡
通過將 <code>optional</code> 參數作為 <code>True</code> 傳遞，我們允許用戶
提供麥克風或音頻文件（或兩者都不提供，但這會返回錯誤消息）。`,De,ae,Zl="繼續看看如何與他人分享您的界面！",Ke,pe,Oe;return h=new ne({props:{title:"瞭解接口類",local:"瞭解接口類",headingTag:"h1"}}),f=new Ql({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/chapter9/section3.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/chapter9/section3.ipynb"}]}}),b=new ne({props:{title:"如何創建接口",local:"如何創建接口",headingTag:"h2"}}),x=new ne({props:{title:"一個帶音頻的簡單示例",local:"一個帶音頻的簡單示例",headingTag:"h2"}}),q=new ll({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQSUwQWRlZiUyMHJldmVyc2VfYXVkaW8oYXVkaW8pJTNBJTBBJTIwJTIwJTIwJTIwc3IlMkMlMjBkYXRhJTIwJTNEJTIwYXVkaW8lMEElMjAlMjAlMjAlMjByZXZlcnNlZF9hdWRpbyUyMCUzRCUyMChzciUyQyUyMG5wLmZsaXB1ZChkYXRhKSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjByZXZlcnNlZF9hdWRpbyUwQSUwQSUwQW1pYyUyMCUzRCUyMGdyLkF1ZGlvKHNvdXJjZSUzRCUyMm1pY3JvcGhvbmUlMjIlMkMlMjB0eXBlJTNEJTIybnVtcHklMjIlMkMlMjBsYWJlbCUzRCUyMlNwZWFrJTIwaGVyZS4uLiUyMiklMEFnci5JbnRlcmZhY2UocmV2ZXJzZV9hdWRpbyUyQyUyMG1pYyUyQyUyMCUyMmF1ZGlvJTIyKS5sYXVuY2goKQ==",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr


<span class="hljs-keyword">def</span> <span class="hljs-title function_">reverse_audio</span>(<span class="hljs-params">audio</span>):
    sr, data = audio
    reversed_audio = (sr, np.flipud(data))
    <span class="hljs-keyword">return</span> reversed_audio


mic = gr.Audio(source=<span class="hljs-string">&quot;microphone&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;numpy&quot;</span>, label=<span class="hljs-string">&quot;Speak here...&quot;</span>)
gr.Interface(reverse_audio, mic, <span class="hljs-string">&quot;audio&quot;</span>).launch()`,wrap:!1}}),W=new ne({props:{title:"處理多個輸入和輸出",local:"處理多個輸入和輸出",headingTag:"h2"}}),N=new ll({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQW5vdGVzJTIwJTNEJTIwJTVCJTIyQyUyMiUyQyUyMCUyMkMlMjMlMjIlMkMlMjAlMjJEJTIyJTJDJTIwJTIyRCUyMyUyMiUyQyUyMCUyMkUlMjIlMkMlMjAlMjJGJTIyJTJDJTIwJTIyRiUyMyUyMiUyQyUyMCUyMkclMjIlMkMlMjAlMjJHJTIzJTIyJTJDJTIwJTIyQSUyMiUyQyUyMCUyMkElMjMlMjIlMkMlMjAlMjJCJTIyJTVEJTBBJTBBJTBBZGVmJTIwZ2VuZXJhdGVfdG9uZShub3RlJTJDJTIwb2N0YXZlJTJDJTIwZHVyYXRpb24pJTNBJTBBJTIwJTIwJTIwJTIwc3IlMjAlM0QlMjA0ODAwMCUwQSUyMCUyMCUyMCUyMGE0X2ZyZXElMkMlMjB0b25lc19mcm9tX2E0JTIwJTNEJTIwNDQwJTJDJTIwMTIlMjAqJTIwKG9jdGF2ZSUyMC0lMjA0KSUyMCUyQiUyMChub3RlJTIwLSUyMDkpJTBBJTIwJTIwJTIwJTIwZnJlcXVlbmN5JTIwJTNEJTIwYTRfZnJlcSUyMColMjAyJTIwKiolMjAodG9uZXNfZnJvbV9hNCUyMCUyRiUyMDEyKSUwQSUyMCUyMCUyMCUyMGR1cmF0aW9uJTIwJTNEJTIwaW50KGR1cmF0aW9uKSUwQSUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwbnAubGluc3BhY2UoMCUyQyUyMGR1cmF0aW9uJTJDJTIwZHVyYXRpb24lMjAqJTIwc3IpJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjAoMjAwMDAlMjAqJTIwbnAuc2luKGF1ZGlvJTIwKiUyMCgyJTIwKiUyMG5wLnBpJTIwKiUyMGZyZXF1ZW5jeSkpKS5hc3R5cGUobnAuaW50MTYpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwKHNyJTJDJTIwYXVkaW8pJTBBJTBBJTBBZ3IuSW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMGdlbmVyYXRlX3RvbmUlMkMlMEElMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5Ecm9wZG93bihub3RlcyUyQyUyMHR5cGUlM0QlMjJpbmRleCUyMiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5TbGlkZXIobWluaW11bSUzRDQlMkMlMjBtYXhpbXVtJTNENiUyQyUyMHN0ZXAlM0QxKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdyLlRleHRib3godHlwZSUzRCUyMm51bWJlciUyMiUyQyUyMHZhbHVlJTNEMSUyQyUyMGxhYmVsJTNEJTIyRHVyYXRpb24lMjBpbiUyMHNlY29uZHMlMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyYXVkaW8lMjIlMkMlMEEpLmxhdW5jaCgp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

notes = [<span class="hljs-string">&quot;C&quot;</span>, <span class="hljs-string">&quot;C#&quot;</span>, <span class="hljs-string">&quot;D&quot;</span>, <span class="hljs-string">&quot;D#&quot;</span>, <span class="hljs-string">&quot;E&quot;</span>, <span class="hljs-string">&quot;F&quot;</span>, <span class="hljs-string">&quot;F#&quot;</span>, <span class="hljs-string">&quot;G&quot;</span>, <span class="hljs-string">&quot;G#&quot;</span>, <span class="hljs-string">&quot;A&quot;</span>, <span class="hljs-string">&quot;A#&quot;</span>, <span class="hljs-string">&quot;B&quot;</span>]


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_tone</span>(<span class="hljs-params">note, octave, duration</span>):
    sr = <span class="hljs-number">48000</span>
    a4_freq, tones_from_a4 = <span class="hljs-number">440</span>, <span class="hljs-number">12</span> * (octave - <span class="hljs-number">4</span>) + (note - <span class="hljs-number">9</span>)
    frequency = a4_freq * <span class="hljs-number">2</span> ** (tones_from_a4 / <span class="hljs-number">12</span>)
    duration = <span class="hljs-built_in">int</span>(duration)
    audio = np.linspace(<span class="hljs-number">0</span>, duration, duration * sr)
    audio = (<span class="hljs-number">20000</span> * np.sin(audio * (<span class="hljs-number">2</span> * np.pi * frequency))).astype(np.int16)
    <span class="hljs-keyword">return</span> (sr, audio)


gr.Interface(
    generate_tone,
    [
        gr.Dropdown(notes, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;index&quot;</span>),
        gr.Slider(minimum=<span class="hljs-number">4</span>, maximum=<span class="hljs-number">6</span>, step=<span class="hljs-number">1</span>),
        gr.Textbox(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;number&quot;</span>, value=<span class="hljs-number">1</span>, label=<span class="hljs-string">&quot;Duration in seconds&quot;</span>),
    ],
    <span class="hljs-string">&quot;audio&quot;</span>,
).launch()`,wrap:!1}}),X=new ne({props:{title:"launch() 方法",local:"launch-方法",headingTag:"h3"}}),K=new ne({props:{title:"✏️ 讓我們應用它！",local:"-讓我們應用它",headingTag:"h2"}}),le=new ll({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQW1vZGVsJTIwJTNEJTIwcGlwZWxpbmUoJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMiklMEElMEElMEFkZWYlMjB0cmFuc2NyaWJlX2F1ZGlvKG1pYyUzRE5vbmUlMkMlMjBmaWxlJTNETm9uZSklM0ElMEElMjAlMjAlMjAlMjBpZiUyMG1pYyUyMGlzJTIwbm90JTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwbWljJTBBJTIwJTIwJTIwJTIwZWxpZiUyMGZpbGUlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhdWRpbyUyMCUzRCUyMGZpbGUlMEElMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIyWW91JTIwbXVzdCUyMGVpdGhlciUyMHByb3ZpZGUlMjBhJTIwbWljJTIwcmVjb3JkaW5nJTIwb3IlMjBhJTIwZmlsZSUyMiUwQSUyMCUyMCUyMCUyMHRyYW5zY3JpcHRpb24lMjAlM0QlMjBtb2RlbChhdWRpbyklNUIlMjJ0ZXh0JTIyJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdHJhbnNjcmlwdGlvbiUwQSUwQSUwQWdyLkludGVyZmFjZSglMEElMjAlMjAlMjAlMjBmbiUzRHRyYW5zY3JpYmVfYXVkaW8lMkMlMEElMjAlMjAlMjAlMjBpbnB1dHMlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5BdWRpbyhzb3VyY2UlM0QlMjJtaWNyb3Bob25lJTIyJTJDJTIwdHlwZSUzRCUyMmZpbGVwYXRoJTIyJTJDJTIwb3B0aW9uYWwlM0RUcnVlKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdyLkF1ZGlvKHNvdXJjZSUzRCUyMnVwbG9hZCUyMiUyQyUyMHR5cGUlM0QlMjJmaWxlcGF0aCUyMiUyQyUyMG9wdGlvbmFsJTNEVHJ1ZSklMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRzJTNEJTIydGV4dCUyMiUyQyUwQSkubGF1bmNoKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

model = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">transcribe_audio</span>(<span class="hljs-params">mic=<span class="hljs-literal">None</span>, file=<span class="hljs-literal">None</span></span>):
    <span class="hljs-keyword">if</span> mic <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
        audio = mic
    <span class="hljs-keyword">elif</span> file <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
        audio = file
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;You must either provide a mic recording or a file&quot;</span>
    transcription = model(audio)[<span class="hljs-string">&quot;text&quot;</span>]
    <span class="hljs-keyword">return</span> transcription


gr.Interface(
    fn=transcribe_audio,
    inputs=[
        gr.Audio(source=<span class="hljs-string">&quot;microphone&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>, optional=<span class="hljs-literal">True</span>),
        gr.Audio(source=<span class="hljs-string">&quot;upload&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>, optional=<span class="hljs-literal">True</span>),
    ],
    outputs=<span class="hljs-string">&quot;text&quot;</span>,
).launch()`,wrap:!1}}),{c(){J=i("meta"),re=a(),ie=i("p"),Me=a(),y(h.$$.fragment),ue=a(),y(f.$$.fragment),ce=a(),U=i("p"),U.innerHTML=sl,ye=a(),y(b.$$.fragment),me=a(),I=i("p"),I.innerHTML=al,de=a(),C=i("p"),C.innerHTML=nl,we=a(),v=i("p"),v.textContent=il,Te=a(),k=i("ul"),k.innerHTML=pl,je=a(),g=i("p"),g.innerHTML=ol,Je=a(),A=i("p"),A.innerHTML=rl,he=a(),y(x.$$.fragment),fe=a(),G=i("p"),G.textContent=Ml,Ue=a(),B=i("p"),B.textContent=ul,be=a(),$=i("p"),$.innerHTML=cl,Ie=a(),Z=i("p"),Z.innerHTML=yl,Ce=a(),_=i("p"),_.innerHTML=ml,ve=a(),y(q.$$.fragment),ke=a(),H=i("p"),H.innerHTML=dl,ge=a(),M=i("iframe"),Ae=a(),E=i("p"),E.textContent=Tl,xe=a(),y(W.$$.fragment),Ge=a(),R=i("p"),R.textContent=jl,Be=a(),L=i("p"),L.textContent=Jl,$e=a(),Q=i("p"),Q.textContent=hl,Ze=a(),S=i("ul"),S.innerHTML=fl,_e=a(),V=i("p"),V.innerHTML=Ul,qe=a(),y(N.$$.fragment),He=a(),u=i("iframe"),Ee=a(),y(X.$$.fragment),We=a(),Y=i("p"),Y.innerHTML=Il,Re=a(),P=i("p"),P.innerHTML=Cl,Le=a(),z=i("p"),z.innerHTML=vl,Qe=a(),F=i("ul"),F.innerHTML=kl,Se=a(),D=i("p"),D.innerHTML=gl,Ve=a(),y(K.$$.fragment),Ne=a(),O=i("p"),O.innerHTML=Al,Xe=a(),ee=i("p"),ee.innerHTML=xl,Ye=a(),y(le.$$.fragment),Pe=a(),te=i("p"),te.innerHTML=Gl,ze=a(),c=i("iframe"),Fe=a(),se=i("p"),se.innerHTML=$l,De=a(),ae=i("p"),ae.textContent=Zl,Ke=a(),pe=i("p"),this.h()},l(e){const l=Rl("svelte-u9bgzb",document.head);J=p(l,"META",{name:!0,content:!0}),l.forEach(t),re=n(e),ie=p(e,"P",{}),oe(ie).forEach(t),Me=n(e),m(h.$$.fragment,e),ue=n(e),m(f.$$.fragment,e),ce=n(e),U=p(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-1n241ec"&&(U.innerHTML=sl),ye=n(e),m(b.$$.fragment,e),me=n(e),I=p(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-cpncav"&&(I.innerHTML=al),de=n(e),C=p(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-5xxju6"&&(C.innerHTML=nl),we=n(e),v=p(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-136xoue"&&(v.textContent=il),Te=n(e),k=p(e,"UL",{"data-svelte-h":!0}),o(k)!=="svelte-bfg8z6"&&(k.innerHTML=pl),je=n(e),g=p(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-1gdrfcj"&&(g.innerHTML=ol),Je=n(e),A=p(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-wuhuoj"&&(A.innerHTML=rl),he=n(e),m(x.$$.fragment,e),fe=n(e),G=p(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1ylue7a"&&(G.textContent=Ml),Ue=n(e),B=p(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-1qsoflg"&&(B.textContent=ul),be=n(e),$=p(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-1j2c7ez"&&($.innerHTML=cl),Ie=n(e),Z=p(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-35cafe"&&(Z.innerHTML=yl),Ce=n(e),_=p(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-1498ymc"&&(_.innerHTML=ml),ve=n(e),m(q.$$.fragment,e),ke=n(e),H=p(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-1509wnm"&&(H.innerHTML=dl),ge=n(e),M=p(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),oe(M).forEach(t),Ae=n(e),E=p(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-2k33o5"&&(E.textContent=Tl),xe=n(e),m(W.$$.fragment,e),Ge=n(e),R=p(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1h3i1tv"&&(R.textContent=jl),Be=n(e),L=p(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-1dx3yg8"&&(L.textContent=Jl),$e=n(e),Q=p(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-1dstpsk"&&(Q.textContent=hl),Ze=n(e),S=p(e,"UL",{"data-svelte-h":!0}),o(S)!=="svelte-1xcyqhu"&&(S.innerHTML=fl),_e=n(e),V=p(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-cp5tej"&&(V.innerHTML=Ul),qe=n(e),m(N.$$.fragment,e),He=n(e),u=p(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),oe(u).forEach(t),Ee=n(e),m(X.$$.fragment,e),We=n(e),Y=p(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1lc29tb"&&(Y.innerHTML=Il),Re=n(e),P=p(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-1yn25id"&&(P.innerHTML=Cl),Le=n(e),z=p(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1wluu8a"&&(z.innerHTML=vl),Qe=n(e),F=p(e,"UL",{"data-svelte-h":!0}),o(F)!=="svelte-f1qyss"&&(F.innerHTML=kl),Se=n(e),D=p(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1g3b2nk"&&(D.innerHTML=gl),Ve=n(e),m(K.$$.fragment,e),Ne=n(e),O=p(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1bjo3cs"&&(O.innerHTML=Al),Xe=n(e),ee=p(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-1uahifx"&&(ee.innerHTML=xl),Ye=n(e),m(le.$$.fragment,e),Pe=n(e),te=p(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-1e8u067"&&(te.innerHTML=Gl),ze=n(e),c=p(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),oe(c).forEach(t),Fe=n(e),se=p(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-bcbhfh"&&(se.innerHTML=$l),De=n(e),ae=p(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-erzn5k"&&(ae.textContent=Zl),Ke=n(e),pe=p(e,"P",{}),oe(pe).forEach(t),this.h()},h(){r(J,"name","hf:doc:metadata"),r(J,"content",Vl),el(M.src,wl="https://course-demos-audio-reverse.hf.space")||r(M,"src",wl),r(M,"frameborder","0"),r(M,"height","250"),r(M,"title","Gradio app"),r(M,"class","container p-0 flex-grow space-iframe"),r(M,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),r(M,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),el(u.src,bl="https://course-demos-generate-tone.hf.space")||r(u,"src",bl),r(u,"frameborder","0"),r(u,"height","450"),r(u,"title","Gradio app"),r(u,"class","container p-0 flex-grow space-iframe"),r(u,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),r(u,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),el(c.src,Bl="https://course-demos-asr.hf.space")||r(c,"src",Bl),r(c,"frameborder","0"),r(c,"height","550"),r(c,"title","Gradio app"),r(c,"class","container p-0 flex-grow space-iframe"),r(c,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),r(c,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads")},m(e,l){Ll(document.head,J),s(e,re,l),s(e,ie,l),s(e,Me,l),d(h,e,l),s(e,ue,l),d(f,e,l),s(e,ce,l),s(e,U,l),s(e,ye,l),d(b,e,l),s(e,me,l),s(e,I,l),s(e,de,l),s(e,C,l),s(e,we,l),s(e,v,l),s(e,Te,l),s(e,k,l),s(e,je,l),s(e,g,l),s(e,Je,l),s(e,A,l),s(e,he,l),d(x,e,l),s(e,fe,l),s(e,G,l),s(e,Ue,l),s(e,B,l),s(e,be,l),s(e,$,l),s(e,Ie,l),s(e,Z,l),s(e,Ce,l),s(e,_,l),s(e,ve,l),d(q,e,l),s(e,ke,l),s(e,H,l),s(e,ge,l),s(e,M,l),s(e,Ae,l),s(e,E,l),s(e,xe,l),d(W,e,l),s(e,Ge,l),s(e,R,l),s(e,Be,l),s(e,L,l),s(e,$e,l),s(e,Q,l),s(e,Ze,l),s(e,S,l),s(e,_e,l),s(e,V,l),s(e,qe,l),d(N,e,l),s(e,He,l),s(e,u,l),s(e,Ee,l),d(X,e,l),s(e,We,l),s(e,Y,l),s(e,Re,l),s(e,P,l),s(e,Le,l),s(e,z,l),s(e,Qe,l),s(e,F,l),s(e,Se,l),s(e,D,l),s(e,Ve,l),d(K,e,l),s(e,Ne,l),s(e,O,l),s(e,Xe,l),s(e,ee,l),s(e,Ye,l),d(le,e,l),s(e,Pe,l),s(e,te,l),s(e,ze,l),s(e,c,l),s(e,Fe,l),s(e,se,l),s(e,De,l),s(e,ae,l),s(e,Ke,l),s(e,pe,l),Oe=!0},p:ql,i(e){Oe||(w(h.$$.fragment,e),w(f.$$.fragment,e),w(b.$$.fragment,e),w(x.$$.fragment,e),w(q.$$.fragment,e),w(W.$$.fragment,e),w(N.$$.fragment,e),w(X.$$.fragment,e),w(K.$$.fragment,e),w(le.$$.fragment,e),Oe=!0)},o(e){T(h.$$.fragment,e),T(f.$$.fragment,e),T(b.$$.fragment,e),T(x.$$.fragment,e),T(q.$$.fragment,e),T(W.$$.fragment,e),T(N.$$.fragment,e),T(X.$$.fragment,e),T(K.$$.fragment,e),T(le.$$.fragment,e),Oe=!1},d(e){e&&(t(re),t(ie),t(Me),t(ue),t(ce),t(U),t(ye),t(me),t(I),t(de),t(C),t(we),t(v),t(Te),t(k),t(je),t(g),t(Je),t(A),t(he),t(fe),t(G),t(Ue),t(B),t(be),t($),t(Ie),t(Z),t(Ce),t(_),t(ve),t(ke),t(H),t(ge),t(M),t(Ae),t(E),t(xe),t(Ge),t(R),t(Be),t(L),t($e),t(Q),t(Ze),t(S),t(_e),t(V),t(qe),t(He),t(u),t(Ee),t(We),t(Y),t(Re),t(P),t(Le),t(z),t(Qe),t(F),t(Se),t(D),t(Ve),t(Ne),t(O),t(Xe),t(ee),t(Ye),t(Pe),t(te),t(ze),t(c),t(Fe),t(se),t(De),t(ae),t(Ke),t(pe)),t(J),j(h,e),j(f,e),j(b,e),j(x,e),j(q,e),j(W,e),j(N,e),j(X,e),j(K,e),j(le,e)}}}const Vl='{"title":"瞭解接口類","local":"瞭解接口類","sections":[{"title":"如何創建接口","local":"如何創建接口","sections":[],"depth":2},{"title":"一個帶音頻的簡單示例","local":"一個帶音頻的簡單示例","sections":[],"depth":2},{"title":"處理多個輸入和輸出","local":"處理多個輸入和輸出","sections":[{"title":"launch() 方法","local":"launch-方法","sections":[],"depth":3}],"depth":2},{"title":"✏️ 讓我們應用它！","local":"-讓我們應用它","sections":[],"depth":2}],"depth":1}';function Nl(tl){return Hl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Dl extends El{constructor(J){super(),Wl(this,J,Nl,Sl,_l,{})}}export{Dl as component};
