import{s as Zl,o as Bl,n as ke}from"../chunks/scheduler.37c15a92.js";import{S as Gl,i as $l,g as c,s as t,r as p,A as Vl,h as J,f as l,c as a,j as Il,u as r,x as y,k as xl,y as vl,a as n,v as o,d,t as u,w as m}from"../chunks/index.2bf4358c.js";import{T as We}from"../chunks/Tip.363c041f.js";import{Y as Wl}from"../chunks/Youtube.1e50a667.js";import{C as T}from"../chunks/CodeBlock.4f5fc1ad.js";import{C as kl}from"../chunks/CourseFloatingBanner.5dff5e20.js";import{H as As}from"../chunks/Heading.8ada512a.js";function zl(b){let i,h='✎ Par défaut, 🤗 <em>Datasets</em> décompresse les fichiers nécessaires pour charger un jeu de données. Si vous souhaitez conserver de l’espace sur le disque dur, vous pouvez passer <code>DownloadConfig(delete_extracted=True)</code> à l’argument <code>download_config</code> de <code>load_dataset()</code>. Voir la <a href="https://huggingface.co/docs/datasets/package_reference/builder_classes#datasets.DownloadConfig" rel="nofollow">documentation</a> pour plus de détails.';return{c(){i=c("p"),i.innerHTML=h},l(M){i=J(M,"P",{"data-svelte-h":!0}),y(i)!=="svelte-1v02m"&&(i.innerHTML=h)},m(M,j){n(M,i,j)},p:ke,d(M){M&&l(i)}}}function Xl(b){let i,h='✏️ <strong>Essayez !</strong> Choisissez l’un des <a href="https://the-eye.eu/public/AI/pile_preliminary_components/" rel="nofollow">sous-ensembles</a> de <em>The Pile</em> qui est plus grand que la RAM de votre ordinateur portable ou de bureau. Chargez-le avec 🤗 <em>Datasets</em> et mesurez la quantité de RAM utilisée. Notez que pour obtenir une mesure précise, vous devrez le faire dans un nouveau processus. Vous pouvez trouver les tailles décompressées de chaque sous-ensemble dans le tableau 1 du papier de <a href="https://arxiv.org/abs/2101.00027" rel="nofollow"><em>The Pile</em></a>.';return{c(){i=c("p"),i.innerHTML=h},l(M){i=J(M,"P",{"data-svelte-h":!0}),y(i)!=="svelte-1osdilj"&&(i.innerHTML=h)},m(M,j){n(M,i,j)},p:ke,d(M){M&&l(i)}}}function Rl(b){let i,h='💡 Dans les <em>notebooks</em> Jupyter, vous pouvez également chronométrer les cellules à l’aide de la fonction magique <a href="https://ipython.readthedocs.io/en/stable/interactive/magics.html#magic-timeit" rel="nofollow"><code>%%timeit</code></a>.';return{c(){i=c("p"),i.innerHTML=h},l(M){i=J(M,"P",{"data-svelte-h":!0}),y(i)!=="svelte-38kpfm"&&(i.innerHTML=h)},m(M,j){n(M,i,j)},p:ke,d(M){M&&l(i)}}}function Cl(b){let i,h="💡 Pour accélérer la tokenisation avec le streaming, vous pouvez passer <code>batched=True</code>, comme nous l’avons vu dans la dernière section. Il traitera les exemples batch par batch. La taille de batch par défaut est de 1 000 et peut être spécifiée avec l’argument <code>batch_size</code>.";return{c(){i=c("p"),i.innerHTML=h},l(M){i=J(M,"P",{"data-svelte-h":!0}),y(i)!=="svelte-1ej2rqj"&&(i.innerHTML=h)},m(M,j){n(M,i,j)},p:ke,d(M){M&&l(i)}}}function Ql(b){let i,h='✏️ <strong>Essayez !</strong> Utilisez l’un des grands corpus Common Crawl comme <a href="https://huggingface.co/datasets/mc4" rel="nofollow"><code>mc4</code></a> ou <a href="https://huggingface.co/datasets/oscar" rel="nofollow"><code>oscar</code></a> pour créer en streaming un jeu de données multilingue représentant les proportions de langues parlées dans un pays de votre choix. Par exemple, les quatre langues nationales en Suisse sont l’allemand, le français, l’italien et le romanche. Vous pouvez donc essayer de créer un corpus suisse en échantillonnant les sous-ensembles Oscar en fonction de leur proportion parlée.';return{c(){i=c("p"),i.innerHTML=h},l(M){i=J(M,"P",{"data-svelte-h":!0}),y(i)!=="svelte-of2k18"&&(i.innerHTML=h)},m(M,j){n(M,i,j)},p:ke,d(M){M&&l(i)}}}function Nl(b){let i,h,M,j,x,ze,Z,Xe,B,Ds="De nos jours, il n’est pas rare de travailler avec des jeux de données de plusieurs gigaoctets surtout si vous envisagez de pré-entraîner un <em>transformer</em> comme BERT ou GPT-2 à partir de zéro. Dans ces cas, même <em>charger</em> les données peut être un défi. Par exemple, le corpus WebText utilisé pour pré-entraîner GPT-2 se compose de plus de 8 millions de documents et de 40 Go de texte. Le charger dans la RAM de votre ordinateur portable est susceptible de lui donner une crise cardiaque !",Re,G,Ls="Heureusement, 🤗 <em>Datasets</em> a été conçu pour surmonter ces limitations. Il vous libère des problèmes de gestion de la mémoire en traitant les jeux de données comme des fichiers <em>mappés en mémoire</em>, ainsi que des limites du disque dur en faisant du <em>streaming</em> sur les entrées dans un corpus.",Ce,$,Qe,V,qs='Dans cette section, nous allons explorer ces fonctionnalités de 🤗 <em>Datasets</em> avec un énorme corpus de 825 Go connu sous le nom de <a href="https://pile.eleuther.ai" rel="nofollow"><em>The Pile</em></a>. Commençons !',Ne,v,Ee,W,Ps='<em>The Pile</em> est un corpus de texte en anglais créé par <a href="https://www.eleuther.ai" rel="nofollow">EleutherAI</a> pour entraîner des modèles de langage à grande échelle. Il comprend une gamme variée de jeux de données, couvrant des articles scientifiques, des référentiels de code GitHub et du texte Web filtré. Le corpus d’entraînement est disponible en <a href="https://the-eye.eu/public/AI/pile/" rel="nofollow">morceaux de 14 Go</a> et vous pouvez aussi télécharger plusieurs des <a href="https://the-eye.eu/public/AI/pile_preliminary_components/" rel="nofollow">composants individuels</a>. Commençons par jeter un coup d’œil au jeu de données <em>PubMed Abstracts</em>, qui est un corpus de résumés de 15 millions de publications biomédicales sur <a href="https://pubmed.ncbi.nlm.nih.gov/" rel="nofollow">PubMed</a>. Le jeu de données est au <a href="https://jsonlines.org" rel="nofollow">format JSON Lines</a> et est compressé à l’aide de la bibliothèque <code>zstandard</code>. Nous devons donc d’abord installer cette bibliothèque :',Ye,k,He,z,Os='Ensuite, nous pouvons charger le jeu de données en utilisant la méthode pour les fichiers distants que nous avons apprise dans <a href="/course/fr/chapter5/2">section 2</a> :',_e,X,Se,R,Fe,C,Ks="Nous pouvons voir qu’il y a 15 518 009 lignes et 2 colonnes dans notre jeu de données. C’est beaucoup !",Ae,U,De,Q,el="Inspectons le contenu du premier exemple :",Le,N,qe,E,Pe,Y,sl="Cela ressemble au résumé d’un article médical. Voyons maintenant combien de RAM nous avons utilisé pour charger le jeu de données !",Oe,H,Ke,_,ll='Un moyen simple de mesurer l’utilisation de la mémoire dans Python consiste à utiliser la bibliothèque <a href="https://psutil.readthedocs.io/en/latest/" rel="nofollow"><code>psutil</code></a> qui peut être installée avec <code>pip</code> comme suit :',es,S,ss,F,nl="Elle fournit une classe <code>Process</code> qui permet de vérifier l’utilisation de la mémoire du processus en cours :",ls,A,ns,D,ts,L,tl="Ici, l’attribut <code>rss</code> fait référence à la <em>taille de l’ensemble résident</em>, qui est la fraction de mémoire qu’un processus occupe dans la RAM. Cette mesure inclut également la mémoire utilisée par l’interpréteur Python et les bibliothèques que nous avons chargées, de sorte que la quantité réelle de mémoire utilisée pour charger le jeu de données est un peu plus petite. À titre de comparaison, voyons la taille du jeu de données sur le disque en utilisant l’attribut <code>dataset_size</code>. Comme le résultat est exprimé en octets comme précédemment, nous devons le convertir manuellement en gigaoctets :",as,q,is,P,ps,O,al="Malgré sa taille de près de 20 Go, nous pouvons charger et accéder au jeu de données avec beaucoup moins de RAM !",rs,w,os,K,il='Si vous êtes familier avec Pandas, ce résultat pourrait surprendre en raison de la célèbre <a href="https://wesmckinney.com/blog/apache-arrow-pandas-internals/" rel="nofollow">règle d’or</a> de Wes Kinney selon laquelle vous avez généralement besoin de 5 à 10 fois plus de RAM que la taille de votre jeu de données. Alors, comment 🤗 <em>Datasets</em> résout-il ce problème de gestion de la mémoire ? 🤗 <em>Datasets</em> traite chaque jeu de données comme un <a href="https://en.wikipedia.org/wiki/Memory-mapped_file" rel="nofollow">fichier mappé en mémoire</a>. Cela fournit un mappage entre la RAM et le stockage du système de fichiers permettant à la bibliothèque d’accéder et d’opérer sur des éléments du jeu de données sans avoir besoin de le charger entièrement en mémoire.',ds,ee,pl='Les fichiers mappés en mémoire peuvent également être partagés entre plusieurs processus ce qui permet de paralléliser des méthodes telles que <code>Dataset.map()</code> sans avoir à déplacer ou copier le jeu de données. Sous le capot, ces capacités sont toutes réalisées par le format de mémoire <a href="https://arrow.apache.org" rel="nofollow">Apache Arrow</a> et <a href="https://arrow.apache.org/docs/python/index.html" rel="nofollow"><code>pyarrow</code></a>, qui accélèrent le chargement et le traitement des données. (Pour plus de détails sur Apache Arrow et les comparaisons avec Pandas, consultez <a href="https://towardsdatascience.com/apache-arrow-read-dataframe-with-zero-memory-69634092b1a" rel="nofollow">l’article de blog de Dejan Simic</a>). Pour voir ceci en action, effectuons un petit test de vitesse en itérant sur tous les éléments du jeu de données <em>PubMed Abstracts</em> :',us,se,ms,le,Ms,ne,rl="Ici, nous avons utilisé le module <code>timeit</code> de Python pour mesurer le temps d’exécution pris par <code>code_snippet</code>. Vous pourrez généralement itérer sur un jeu de données à une vitesse de quelques dixièmes de Go/s à plusieurs Go/s. Cela fonctionne très bien pour la grande majorité des applications, mais vous devrez parfois travailler avec un jeu de données trop volumineux pour être même stocké sur le disque dur de votre ordinateur portable. Par exemple, si nous essayions de télécharger <em>The Pile</em> dans son intégralité, nous aurions besoin de 825 Go d’espace disque libre ! Pour gérer ces cas, 🤗 <em>Datasets</em> fournit une fonctionnalité de streaming qui nous permet de télécharger et d’accéder aux éléments à la volée, sans avoir besoin de télécharger l’intégralité du jeu de données. Voyons comment cela fonctionne.",cs,f,Js,te,ys,ae,ol="Pour activer le streaming du jeu de données, il vous suffit de passer l’argument <code>streaming=True</code> à la fonction <code>load_dataset()</code>. Par exemple, chargeons à nouveau le jeu de données <em>PubMed Abstracts</em> mais en mode streaming :",Ts,ie,hs,pe,dl="Au lieu du familier <code>Dataset</code> que nous avons rencontré ailleurs dans ce chapitre, l’objet retourné avec <code>streaming=True</code> est un <code>IterableDataset</code>. Comme son nom l’indique, pour accéder aux éléments d’un <code>IterableDataset</code>, nous devons parcourir celui-ci. Nous pouvons accéder au premier élément de notre jeu de données diffusé comme suit :",js,re,bs,oe,Us,de,ul='Les éléments d’un jeu de données diffusé en continu peuvent être traités à la volée à l’aide de <code>IterableDataset.map()</code>, ce qui est utile pendant l’entraînement si vous avez besoin de tokeniser les entrées. Le processus est exactement le même que celui que nous avons utilisé pour tokeniser notre jeu de données dans le <a href="/course/fr/chapter3">chapitre 3</a>, à la seule différence que les sorties sont renvoyées une par une :',ws,ue,fs,me,gs,g,Is,Me,ml="Vous pouvez également mélanger un jeu de données diffusé en continu à l’aide de <code>IterableDataset.shuffle()</code>, mais contrairement à <code>Dataset.shuffle()</code>, cela ne mélange que les éléments dans un <code>buffer_size</code> prédéfini :",xs,ce,Zs,Je,Bs,ye,Ml="Dans cet exemple, nous avons sélectionné un exemple aléatoire parmi les 10 000 premiers exemples du tampon. Une fois qu’un exemple est accédé, sa place dans le tampon est remplie avec l’exemple suivant dans le corpus (c’est-à-dire le 10 001e exemple dans le cas ci-dessus). Vous pouvez également sélectionner des éléments d’un jeu de données diffusé en continu à l’aide des fonctions <code>IterableDataset.take()</code> et <code>IterableDataset.skip()</code>, qui agissent de la même manière que <code>Dataset.select()</code>. Par exemple, pour sélectionner les 5 premiers exemples dans le jeu de données <em>PubMed Abstracts</em>, nous pouvons procéder comme suit :",Gs,Te,$s,he,Vs,je,cl="De même, vous pouvez utiliser la fonction <code>IterableDataset.skip()</code> pour créer des fractionnements d’entraînement et de validation à partir d’un jeu de données mélangé comme suit :",vs,be,Ws,Ue,Jl="Terminons notre exploration du streaming des jeux de données avec une application commune : combiner plusieurs jeux de données pour créer un seul corpus. 🤗 <em>Datasets</em> fournit une fonction <code>interleave_datasets()</code> qui convertit une liste d’objets <code>IterableDataset</code> en un seul <code>IterableDataset</code>, où les éléments du nouveau jeu de données sont obtenus en alternant entre les exemples source. Cette fonction est particulièrement utile lorsque vous essayez de combiner de grands jeux de données. Par exemple, streamons FreeLaw, un sous-ensemble de <em>The Pile</em> et qui est un jeu de données de 51 Go d’avis juridiques de tribunaux américains :",ks,we,zs,fe,Xs,ge,yl="Ce jeu de données est suffisamment volumineux pour solliciter la RAM de la plupart des ordinateurs portables, mais nous avons pu le charger et y accéder sans transpirer ! Combinons maintenant les jeux de données FreeLaw et <em>PubMed Abstracts</em> avec la fonction <code>interleave_datasets()</code> :",Rs,Ie,Cs,xe,Qs,Ze,Tl="Ici, nous avons utilisé la fonction <code>islice()</code> du module <code>itertools</code> de Python pour sélectionner les deux premiers exemples du jeu de données combiné. Nous pouvons voir qu’ils correspondent aux premiers exemples de chacun des deux jeux de données source.",Ns,Be,hl="Enfin, si vous souhaitez streamer <em>The Pile</em> dans son intégralité de 825 Go, vous pouvez récupérer tous les fichiers préparés comme suit :",Es,Ge,Ys,$e,Hs,I,_s,Ve,jl="Vous disposez maintenant de tous les outils dont vous avez besoin pour charger et traiter des jeux de données de toutes formes et tailles. Cependant à moins que vous ne soyez exceptionnellement chanceux, il arrivera un moment dans votre cheminement en traitement du langage naturel où vous devrez réellement créer un jeu de données pour résoudre un problème donné. C’est le sujet de la section suivante !",Ss,ve,Fs;return x=new As({props:{title:"Données massives ? 🤗 <i> Datasets </i> à la rescousse !",local:"données-massives---i-datasets-i-à-la-rescousse-",headingTag:"h1"}}),Z=new kl({props:{chapter:5,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"English",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter5/section4.ipynb"},{label:"Français",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/fr/chapter5/section4.ipynb"},{label:"English",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter5/section4.ipynb"},{label:"Français",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/fr/chapter5/section4.ipynb"}]}}),$=new Wl({props:{id:"JwISwTCPPWo"}}),v=new As({props:{title:"Qu’est-ce que <i> The Pile </i> ?",local:"quest-ce-que-i-the-pile-i-",headingTag:"h2"}}),k=new T({props:{code:"IXBpcCUyMGluc3RhbGwlMjB6c3RhbmRhcmQ=",highlighted:"!pip install zstandard",wrap:!1}}),X=new T({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBJTIzJTIwQ2VsYSUyMHByZW5kJTIwcXVlbHF1ZXMlMjBtaW51dGVzJTIwJUMzJUEwJTIwZXglQzMlQTljdXRlciUyQyUyMGFsb3JzJTIwYWxsZXolMjBwcmVuZHJlJTIwdW4lMjB0aCVDMyVBOSUyMG91JTIwdW4lMjBjYWYlQzMlQTklMjBlbiUyMGF0dGVuZGFudCUyMCUzQSklMEFkYXRhX2ZpbGVzJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZ0aGUtZXllLmV1JTJGcHVibGljJTJGQUklMkZwaWxlX3ByZWxpbWluYXJ5X2NvbXBvbmVudHMlMkZQVUJNRURfdGl0bGVfYWJzdHJhY3RzXzIwMTlfYmFzZWxpbmUuanNvbmwuenN0JTIyJTBBcHVibWVkX2RhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyanNvbiUyMiUyQyUyMGRhdGFfZmlsZXMlM0RkYXRhX2ZpbGVzJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEFwdWJtZWRfZGF0YXNldA==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># Cela prend quelques minutes à exécuter, alors allez prendre un thé ou un café en attendant :)</span>
data_files = <span class="hljs-string">&quot;https://the-eye.eu/public/AI/pile_preliminary_components/PUBMED_title_abstracts_2019_baseline.jsonl.zst&quot;</span>
pubmed_dataset = load_dataset(<span class="hljs-string">&quot;json&quot;</span>, data_files=data_files, split=<span class="hljs-string">&quot;train&quot;</span>)
pubmed_dataset`,wrap:!1}}),R=new T({props:{code:"RGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QidtZXRhJyUyQyUyMCd0ZXh0JyU1RCUyQyUwQSUyMCUyMCUyMCUyMG51bV9yb3dzJTNBJTIwMTU1MTgwMDklMEElN0Qp",highlighted:`Dataset({
    features: [<span class="hljs-string">&#x27;meta&#x27;</span>, <span class="hljs-string">&#x27;text&#x27;</span>],
    num_rows: <span class="hljs-number">15518009</span>
})`,wrap:!1}}),U=new We({props:{$$slots:{default:[zl]},$$scope:{ctx:b}}}),N=new T({props:{code:"cHVibWVkX2RhdGFzZXQlNUIwJTVE",highlighted:'pubmed_dataset[<span class="hljs-number">0</span>]',wrap:!1}}),E=new T({props:{code:"JTdCJ21ldGEnJTNBJTIwJTdCJ3BtaWQnJTNBJTIwMTE0MDk1NzQlMkMlMjAnbGFuZ3VhZ2UnJTNBJTIwJ2VuZyclN0QlMkMlMEElMjAndGV4dCclM0ElMjAnRXBpZGVtaW9sb2d5JTIwb2YlMjBoeXBveGFlbWlhJTIwaW4lMjBjaGlsZHJlbiUyMHdpdGglMjBhY3V0ZSUyMGxvd2VyJTIwcmVzcGlyYXRvcnklMjBpbmZlY3Rpb24uJTVDblRvJTIwZGV0ZXJtaW5lJTIwdGhlJTIwcHJldmFsZW5jZSUyMG9mJTIwaHlwb3hhZW1pYSUyMGluJTIwY2hpbGRyZW4lMjBhZ2VkJTIwdW5kZXIlMjA1JTIweWVhcnMlMjBzdWZmZXJpbmclMjBhY3V0ZSUyMGxvd2VyJTIwcmVzcGlyYXRvcnklMjBpbmZlY3Rpb25zJTIwKEFMUkkpJTJDJTIwdGhlJTIwcmlzayUyMGZhY3RvcnMlMjBmb3IlMjBoeXBveGFlbWlhJTIwaW4lMjBjaGlsZHJlbiUyMHVuZGVyJTIwNSUyMHllYXJzJTIwb2YlMjBhZ2UlMjB3aXRoJTIwQUxSSSUyQyUyMGFuZCUyMHRoZSUyMGFzc29jaWF0aW9uJTIwb2YlMjBoeXBveGFlbWlhJTIwd2l0aCUyMGFuJTIwaW5jcmVhc2VkJTIwcmlzayUyMG9mJTIwZHlpbmclMjBpbiUyMGNoaWxkcmVuJTIwb2YlMjB0aGUlMjBzYW1lJTIwYWdlJTIwLi4uJyUwQSUyMyUyMCVDMyU4OXBpZCVDMyVBOW1pb2xvZ2llJTIwZGUlMjBsJ2h5cG94JUMzJUE5bWllJTIwY2hleiUyMGxlcyUyMGVuZmFudHMlMjBzb3VmZnJhbnQlMjBkJ3VuZSUyMGluZmVjdGlvbiUyMGFpZ3UlQzMlQUIlMjBkZXMlMjB2b2llcyUyMHJlc3BpcmF0b2lyZXMlMjBpbmYlQzMlQTlyaWV1cmVzLiUyMEQlQzMlQTl0ZXJtaW5lciUyMGxhJTIwcHIlQzMlQTl2YWxlbmNlJTIwZGUlMjBsJ2h5cG94JUMzJUE5bWllJTIwY2hleiUyMGxlcyUyMGVuZmFudHMlMjBkZSUyMG1vaW5zJTIwZGUlMjA1JTIwYW5zJTIwc291ZmZyYW50JTIwZCd1bmUlMjBpbmZlY3Rpb24lMjBhaWd1JUMzJUFCJTIwZGVzJTIwdm9pZXMlMjByZXNwaXJhdG9pcmVzJTIwaW5mJUMzJUE5cmlldXJlcyUyMChJQVZJKSUyQyUyMGxlcyUyMGZhY3RldXJzJTIwZGUlMjByaXNxdWUlMjBkZSUyMGwnaHlwb3glQzMlQTltaWUlMjBjaGV6JTIwbGVzJTIwZW5mYW50cyUyMGRlJTIwbW9pbnMlMjBkZSUyMDUlMjBhbnMlMjBzb3VmZnJhbnQlMjBkJ3VuZSUyMElBVkklMkMlMjBldCUyMGwnYXNzb2NpYXRpb24lMjBkZSUyMGwnaHlwb3glQzMlQTltaWUlMjAlQzMlQTAlMjB1biUyMHJpc3F1ZSUyMGFjY3J1JTIwZGUlMjBkJUMzJUE5YyVDMyVBOHMlMjBjaGV6JTIwbGVzJTIwZW5mYW50cyUyMGR1JTIwbSVDMyVBQW1lJTIwJUMzJUEyZ2UlMjAuLi4lMEElN0Q=",highlighted:`{<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11409574</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
 <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Epidemiology of hypoxaemia in children with acute lower respiratory infection.\\nTo determine the prevalence of hypoxaemia in children aged under 5 years suffering acute lower respiratory infections (ALRI), the risk factors for hypoxaemia in children under 5 years of age with ALRI, and the association of hypoxaemia with an increased risk of dying in children of the same age ...&#x27;</span>
<span class="hljs-comment"># Épidémiologie de l&#x27;hypoxémie chez les enfants souffrant d&#x27;une infection aiguë des voies respiratoires inférieures. Déterminer la prévalence de l&#x27;hypoxémie chez les enfants de moins de 5 ans souffrant d&#x27;une infection aiguë des voies respiratoires inférieures (IAVI), les facteurs de risque de l&#x27;hypoxémie chez les enfants de moins de 5 ans souffrant d&#x27;une IAVI, et l&#x27;association de l&#x27;hypoxémie à un risque accru de décès chez les enfants du même âge ...</span>
}`,wrap:!1}}),H=new As({props:{title:"La magie du <i> memory mapping </i>",local:"la-magie-du-i-memory-mapping-i",headingTag:"h2"}}),S=new T({props:{code:"IXBpcCUyMGluc3RhbGwlMjBwc3V0aWw=",highlighted:"!pip install psutil",wrap:!1}}),A=new T({props:{code:"aW1wb3J0JTIwcHN1dGlsJTBBJTBBJTIzJTIwUHJvY2Vzcy5tZW1vcnlfaW5mbyUyMGVzdCUyMGV4cHJpbSVDMyVBOSUyMGVuJTIwb2N0ZXRzJTJDJTIwZG9uYyUyMGNvbnZlcnRpciUyMGVuJTIwbSVDMyVBOWdhb2N0ZXRzJTBBcHJpbnQoZiUyMlJBTSUyMHVzZWQlM0ElMjAlN0Jwc3V0aWwuUHJvY2VzcygpLm1lbW9yeV9pbmZvKCkucnNzJTIwJTJGJTIwKDEwMjQlMjAqJTIwMTAyNCklM0EuMmYlN0QlMjBNQiUyMik=",highlighted:`<span class="hljs-keyword">import</span> psutil

<span class="hljs-comment"># Process.memory_info est exprimé en octets, donc convertir en mégaoctets</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;RAM used: <span class="hljs-subst">{psutil.Process().memory_info().rss / (<span class="hljs-number">1024</span> * <span class="hljs-number">1024</span>):<span class="hljs-number">.2</span>f}</span> MB&quot;</span>)`,wrap:!1}}),D=new T({props:{code:"UkFNJTIwdXNlZCUzQSUyMDU2NzguMzMlMjBNQg==",highlighted:'RAM used: <span class="hljs-number">5678.33</span> MB',wrap:!1}}),q=new T({props:{code:"cHJpbnQoZiUyMk51bWJlciUyMG9mJTIwZmlsZXMlMjBpbiUyMGRhdGFzZXQlMjAlM0ElMjAlN0JwdWJtZWRfZGF0YXNldC5kYXRhc2V0X3NpemUlN0QlMjIpJTBBc2l6ZV9nYiUyMCUzRCUyMHB1Ym1lZF9kYXRhc2V0LmRhdGFzZXRfc2l6ZSUyMCUyRiUyMCgxMDI0KiozKSUwQXByaW50KGYlMjJEYXRhc2V0JTIwc2l6ZSUyMChjYWNoZSUyMGZpbGUpJTIwJTNBJTIwJTdCc2l6ZV9nYiUzQS4yZiU3RCUyMEdCJTIyKQ==",highlighted:`<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Number of files in dataset : <span class="hljs-subst">{pubmed_dataset.dataset_size}</span>&quot;</span>)
size_gb = pubmed_dataset.dataset_size / (<span class="hljs-number">1024</span>**<span class="hljs-number">3</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Dataset size (cache file) : <span class="hljs-subst">{size_gb:<span class="hljs-number">.2</span>f}</span> GB&quot;</span>)`,wrap:!1}}),P=new T({props:{code:"TnVtYmVyJTIwb2YlMjBmaWxlcyUyMGluJTIwZGF0YXNldCUyMCUzQSUyMDIwOTc5NDM3MDUxJTBBRGF0YXNldCUyMHNpemUlMjAoY2FjaGUlMjBmaWxlKSUyMCUzQSUyMDE5LjU0JTIwR0I=",highlighted:`Number of files <span class="hljs-keyword">in</span> dataset : <span class="hljs-number">20979437051</span>
Dataset size (cache file) : <span class="hljs-number">19.54</span> GB`,wrap:!1}}),w=new We({props:{$$slots:{default:[Xl]},$$scope:{ctx:b}}}),se=new T({props:{code:"aW1wb3J0JTIwdGltZWl0JTBBJTBBY29kZV9zbmlwcGV0JTIwJTNEJTIwJTIyJTIyJTIyYmF0Y2hfc2l6ZSUyMCUzRCUyMDEwMDAlMEElMEFmb3IlMjBpZHglMjBpbiUyMHJhbmdlKDAlMkMlMjBsZW4ocHVibWVkX2RhdGFzZXQpJTJDJTIwYmF0Y2hfc2l6ZSklM0ElMEElMjAlMjAlMjAlMjBfJTIwJTNEJTIwcHVibWVkX2RhdGFzZXQlNUJpZHglM0FpZHglMjAlMkIlMjBiYXRjaF9zaXplJTVEJTBBJTIyJTIyJTIyJTBBJTBBdGltZSUyMCUzRCUyMHRpbWVpdC50aW1laXQoc3RtdCUzRGNvZGVfc25pcHBldCUyQyUyMG51bWJlciUzRDElMkMlMjBnbG9iYWxzJTNEZ2xvYmFscygpKSUwQXByaW50KCUwQSUyMCUyMCUyMCUyMGYlMjJJdGVyYXRlZCUyMG92ZXIlMjAlN0JsZW4ocHVibWVkX2RhdGFzZXQpJTdEJTIwZXhhbXBsZXMlMjAoYWJvdXQlMjAlN0JzaXplX2diJTNBLjFmJTdEJTIwR0IpJTIwaW4lMjAlMjIlMEElMjAlMjAlMjAlMjBmJTIyJTdCdGltZSUzQS4xZiU3RHMlMkMlMjBpLmUuJTIwJTdCc2l6ZV9nYiUyRnRpbWUlM0EuM2YlN0QlMjBHQiUyRnMlMjIlMEEp",highlighted:`<span class="hljs-keyword">import</span> timeit

code_snippet = <span class="hljs-string">&quot;&quot;&quot;batch_size = 1000

for idx in range(0, len(pubmed_dataset), batch_size):
    _ = pubmed_dataset[idx:idx + batch_size]
&quot;&quot;&quot;</span>

time = timeit.timeit(stmt=code_snippet, number=<span class="hljs-number">1</span>, <span class="hljs-built_in">globals</span>=<span class="hljs-built_in">globals</span>())
<span class="hljs-built_in">print</span>(
    <span class="hljs-string">f&quot;Iterated over <span class="hljs-subst">{<span class="hljs-built_in">len</span>(pubmed_dataset)}</span> examples (about <span class="hljs-subst">{size_gb:<span class="hljs-number">.1</span>f}</span> GB) in &quot;</span>
    <span class="hljs-string">f&quot;<span class="hljs-subst">{time:<span class="hljs-number">.1</span>f}</span>s, i.e. <span class="hljs-subst">{size_gb/time:<span class="hljs-number">.3</span>f}</span> GB/s&quot;</span>
)`,wrap:!1}}),le=new T({props:{code:"J0l0ZXJhdGVkJTIwb3ZlciUyMDE1NTE4MDA5JTIwZXhhbXBsZXMlMjAoYWJvdXQlMjAxOS41JTIwR0IpJTIwaW4lMjA2NC4ycyUyQyUyMGkuZS4lMjAwLjMwNCUyMEdCJTJGcyc=",highlighted:'<span class="hljs-string">&#x27;Iterated over 15518009 examples (about 19.5 GB) in 64.2s, i.e. 0.304 GB/s&#x27;</span>',wrap:!1}}),f=new We({props:{$$slots:{default:[Rl]},$$scope:{ctx:b}}}),te=new As({props:{title:"Jeux de données en continu",local:"jeux-de-données-en-continu",headingTag:"h2"}}),ie=new T({props:{code:"cHVibWVkX2RhdGFzZXRfc3RyZWFtZWQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTBBJTIwJTIwJTIwJTIwJTIyanNvbiUyMiUyQyUyMGRhdGFfZmlsZXMlM0RkYXRhX2ZpbGVzJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiUyQyUyMHN0cmVhbWluZyUzRFRydWUlMEEp",highlighted:`pubmed_dataset_streamed = load_dataset(
    <span class="hljs-string">&quot;json&quot;</span>, data_files=data_files, split=<span class="hljs-string">&quot;train&quot;</span>, streaming=<span class="hljs-literal">True</span>
)`,wrap:!1}}),re=new T({props:{code:"bmV4dChpdGVyKHB1Ym1lZF9kYXRhc2V0X3N0cmVhbWVkKSk=",highlighted:'<span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(pubmed_dataset_streamed))',wrap:!1}}),oe=new T({props:{code:"JTdCJ21ldGEnJTNBJTIwJTdCJ3BtaWQnJTNBJTIwMTE0MDk1NzQlMkMlMjAnbGFuZ3VhZ2UnJTNBJTIwJ2VuZyclN0QlMkMlMEElMjAndGV4dCclM0ElMjAnRXBpZGVtaW9sb2d5JTIwb2YlMjBoeXBveGFlbWlhJTIwaW4lMjBjaGlsZHJlbiUyMHdpdGglMjBhY3V0ZSUyMGxvd2VyJTIwcmVzcGlyYXRvcnklMjBpbmZlY3Rpb24uJTVDblRvJTIwZGV0ZXJtaW5lJTIwdGhlJTIwcHJldmFsZW5jZSUyMG9mJTIwaHlwb3hhZW1pYSUyMGluJTIwY2hpbGRyZW4lMjBhZ2VkJTIwdW5kZXIlMjA1JTIweWVhcnMlMjBzdWZmZXJpbmclMjBhY3V0ZSUyMGxvd2VyJTIwcmVzcGlyYXRvcnklMjBpbmZlY3Rpb25zJTIwKEFMUkkpJTJDJTIwdGhlJTIwcmlzayUyMGZhY3RvcnMlMjBmb3IlMjBoeXBveGFlbWlhJTIwaW4lMjBjaGlsZHJlbiUyMHVuZGVyJTIwNSUyMHllYXJzJTIwb2YlMjBhZ2UlMjB3aXRoJTIwQUxSSSUyQyUyMGFuZCUyMHRoZSUyMGFzc29jaWF0aW9uJTIwb2YlMjBoeXBveGFlbWlhJTIwd2l0aCUyMGFuJTIwaW5jcmVhc2VkJTIwcmlzayUyMG9mJTIwZHlpbmclMjBpbiUyMGNoaWxkcmVuJTIwb2YlMjB0aGUlMjBzYW1lJTIwYWdlJTIwLi4uJyU3RA==",highlighted:`{<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11409574</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
 <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Epidemiology of hypoxaemia in children with acute lower respiratory infection.\\nTo determine the prevalence of hypoxaemia in children aged under 5 years suffering acute lower respiratory infections (ALRI), the risk factors for hypoxaemia in children under 5 years of age with ALRI, and the association of hypoxaemia with an increased risk of dying in children of the same age ...&#x27;</span>}`,wrap:!1}}),ue=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZCUyMiklMEF0b2tlbml6ZWRfZGF0YXNldCUyMCUzRCUyMHB1Ym1lZF9kYXRhc2V0X3N0cmVhbWVkLm1hcChsYW1iZGElMjB4JTNBJTIwdG9rZW5pemVyKHglNUIlMjJ0ZXh0JTIyJTVEKSklMEFuZXh0KGl0ZXIodG9rZW5pemVkX2RhdGFzZXQpKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>)
tokenized_dataset = pubmed_dataset_streamed.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> x: tokenizer(x[<span class="hljs-string">&quot;text&quot;</span>]))
<span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(tokenized_dataset))`,wrap:!1}}),me=new T({props:{code:"JTdCJ2lucHV0X2lkcyclM0ElMjAlNUIxMDElMkMlMjA0OTU4JTJDJTIwNTE3OCUyQyUyMDQzMjglMkMlMjA2Nzc5JTJDJTIwLi4uJTVEJTJDJTIwJ2F0dGVudGlvbl9tYXNrJyUzQSUyMCU1QjElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwLi4uJTVEJTdE",highlighted:'{<span class="hljs-string">&#x27;input_ids&#x27;</span>: [<span class="hljs-number">101</span>, <span class="hljs-number">4958</span>, <span class="hljs-number">5178</span>, <span class="hljs-number">4328</span>, <span class="hljs-number">6779</span>, ...], <span class="hljs-string">&#x27;attention_mask&#x27;</span>: [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, ...]}',wrap:!1}}),g=new We({props:{$$slots:{default:[Cl]},$$scope:{ctx:b}}}),ce=new T({props:{code:"c2h1ZmZsZWRfZGF0YXNldCUyMCUzRCUyMHB1Ym1lZF9kYXRhc2V0X3N0cmVhbWVkLnNodWZmbGUoYnVmZmVyX3NpemUlM0QxMF8wMDAlMkMlMjBzZWVkJTNENDIpJTBBbmV4dChpdGVyKHNodWZmbGVkX2RhdGFzZXQpKQ==",highlighted:`shuffled_dataset = pubmed_dataset_streamed.shuffle(buffer_size=<span class="hljs-number">10_000</span>, seed=<span class="hljs-number">42</span>)
<span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(shuffled_dataset))`,wrap:!1}}),Je=new T({props:{code:"JTdCJ21ldGEnJTNBJTIwJTdCJ3BtaWQnJTNBJTIwMTE0MTA3OTklMkMlMjAnbGFuZ3VhZ2UnJTNBJTIwJ2VuZyclN0QlMkMlMEElMjAndGV4dCclM0ElMjAnUmFuZG9taXplZCUyMHN0dWR5JTIwb2YlMjBkb3NlJTIwb3IlMjBzY2hlZHVsZSUyMG1vZGlmaWNhdGlvbiUyMG9mJTIwZ3JhbnVsb2N5dGUlMjBjb2xvbnktc3RpbXVsYXRpbmclMjBmYWN0b3IlMjBpbiUyMHBsYXRpbnVtLWJhc2VkJTIwY2hlbW90aGVyYXB5JTIwZm9yJTIwZWxkZXJseSUyMHBhdGllbnRzJTIwd2l0aCUyMGx1bmclMjBjYW5jZXIlMjAuLi4nJTBBJTIzJTIwJUMzJTg5dHVkZSUyMHJhbmRvbWlzJUMzJUE5ZSUyMHN1ciUyMGxhJTIwbW9kaWZpY2F0aW9uJTIwZGUlMjBsYSUyMGRvc2UlMjBvdSUyMGR1JTIwY2FsZW5kcmllciUyMGQnYWRtaW5pc3RyYXRpb24lMjBkdSUyMGZhY3RldXIlMjBkZSUyMHN0aW11bGF0aW9uJTIwZGVzJTIwY29sb25pZXMlMjBkZSUyMGdyYW51bG9jeXRlcyUyMGRhbnMlMjBsZSUyMGNhZHJlJTIwZCd1bmUlMjBjaGltaW90aCVDMyVBOXJhcGllJTIwJUMzJUEwJTIwYmFzZSUyMGRlJTIwcGxhdGluZSUyMGNoZXolMjBsZXMlMjBwYXRpZW50cyUyMCVDMyVBMmclQzMlQTlzJTIwYXR0ZWludHMlMjBkZSUyMGNhbmNlciUyMGR1JTIwcG91bW9uJTIwLi4uJTBBJTdE",highlighted:`{<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11410799</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
 <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Randomized study of dose or schedule modification of granulocyte colony-stimulating factor in platinum-based chemotherapy for elderly patients with lung cancer ...&#x27;</span>
<span class="hljs-comment"># Étude randomisée sur la modification de la dose ou du calendrier d&#x27;administration du facteur de stimulation des colonies de granulocytes dans le cadre d&#x27;une chimiothérapie à base de platine chez les patients âgés atteints de cancer du poumon ...</span>
}`,wrap:!1}}),Te=new T({props:{code:"ZGF0YXNldF9oZWFkJTIwJTNEJTIwcHVibWVkX2RhdGFzZXRfc3RyZWFtZWQudGFrZSg1KSUwQWxpc3QoZGF0YXNldF9oZWFkKQ==",highlighted:`dataset_head = pubmed_dataset_streamed.take(<span class="hljs-number">5</span>)
<span class="hljs-built_in">list</span>(dataset_head)`,wrap:!1}}),he=new T({props:{code:"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",highlighted:`[{<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11409574</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
  <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Epidemiology of hypoxaemia in children with acute lower respiratory infection ...&#x27;</span>
<span class="hljs-comment"># Épidémiologie de l&#x27;hypoxémie chez les enfants atteints d&#x27;une infection aiguë des voies respiratoires inférieures ...},</span>
 {<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11409575</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
  <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Clinical signs of hypoxaemia in children with acute lower respiratory infection: indicators of oxygen therapy ...&#x27;</span>
<span class="hljs-comment"># Signes cliniques d&#x27;hypoxémie chez les enfants atteints d&#x27;une infection aiguë des voies respiratoires inférieures : indicateurs de l&#x27;oxygénothérapie ...},</span>
 {<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11409576</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
  <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&quot;Hypoxaemia in children with severe pneumonia in Papua New Guinea ...&quot;</span>
<span class="hljs-comment"># Hypoxémie chez les enfants atteints de pneumonie grave en Papouasie-Nouvelle-Guinée ...},</span>
 {<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11409577</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
  <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Oxygen concentrators and cylinders ...&#x27;</span>
<span class="hljs-comment"># Concentrateurs et bouteilles d&#x27;oxygène...},</span>
 {<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11409578</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
  <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Oxygen supply in rural africa: a personal experience ...&#x27;</span>
<span class="hljs-comment"># L&#x27;approvisionnement en oxygène dans les zones rurales africaines : une expérience personnelle ...}]</span>`,wrap:!1}}),be=new T({props:{code:"JTIzJTIwSWdub3JlciUyMGxlcyUyMDElMjAwMDAlMjBwcmVtaWVycyUyMGV4ZW1wbGVzJTIwZXQlMjBpbmNsdXJlJTIwbGUlMjByZXN0ZSUyMGRhbnMlMjBsJ2Vuc2VtYmxlJTIwZCdhcHByZW50aXNzYWdlLiUwQXRyYWluX2RhdGFzZXQlMjAlM0QlMjBzaHVmZmxlZF9kYXRhc2V0LnNraXAoMTAwMCklMEElMjMlMjBQcmVuZHJlJTIwbGVzJTIwMSUyMDAwMCUyMHByZW1pZXJzJTIwZXhlbXBsZXMlMjBwb3VyJTIwbCdlbnNlbWJsZSUyMGRlJTIwdmFsaWRhdGlvbi4lMEF2YWxpZGF0aW9uX2RhdGFzZXQlMjAlM0QlMjBzaHVmZmxlZF9kYXRhc2V0LnRha2UoMTAwMCk=",highlighted:`<span class="hljs-comment"># Ignorer les 1 000 premiers exemples et inclure le reste dans l&#x27;ensemble d&#x27;apprentissage.</span>
train_dataset = shuffled_dataset.skip(<span class="hljs-number">1000</span>)
<span class="hljs-comment"># Prendre les 1 000 premiers exemples pour l&#x27;ensemble de validation.</span>
validation_dataset = shuffled_dataset.take(<span class="hljs-number">1000</span>)`,wrap:!1}}),we=new T({props:{code:"bGF3X2RhdGFzZXRfc3RyZWFtZWQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTBBJTIwJTIwJTIwJTIwJTIyanNvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfZmlsZXMlM0QlMjJodHRwcyUzQSUyRiUyRnRoZS1leWUuZXUlMkZwdWJsaWMlMkZBSSUyRnBpbGVfcHJlbGltaW5hcnlfY29tcG9uZW50cyUyRkZyZWVMYXdfT3BpbmlvbnMuanNvbmwuenN0JTIyJTJDJTBBJTIwJTIwJTIwJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiUyQyUwQSUyMCUyMCUyMCUyMHN0cmVhbWluZyUzRFRydWUlMkMlMEEpJTBBbmV4dChpdGVyKGxhd19kYXRhc2V0X3N0cmVhbWVkKSk=",highlighted:`law_dataset_streamed = load_dataset(
    <span class="hljs-string">&quot;json&quot;</span>,
    data_files=<span class="hljs-string">&quot;https://the-eye.eu/public/AI/pile_preliminary_components/FreeLaw_Opinions.jsonl.zst&quot;</span>,
    split=<span class="hljs-string">&quot;train&quot;</span>,
    streaming=<span class="hljs-literal">True</span>,
)
<span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(law_dataset_streamed))`,wrap:!1}}),fe=new T({props:{code:"JTdCJ21ldGEnJTNBJTIwJTdCJ2Nhc2VfSUQnJTNBJTIwJzExMDkyMS5qc29uJyUyQyUwQSUyMCUyMCdjYXNlX2p1cmlzZGljdGlvbiclM0ElMjAnc2NvdHVzLnRhci5neiclMkMlMEElMjAlMjAnZGF0ZV9jcmVhdGVkJyUzQSUyMCcyMDEwLTA0LTI4VDE3JTNBMTIlM0E0OVonJTdEJTJDJTBBJTIwJ3RleHQnJTNBJTIwJyU1Q240NjElMjBVLlMuJTIwMjM4JTIwKDE5ODMpJTVDbk9MSU0lMjBFVCUyMEFMLiU1Q252LiU1Q25XQUtJTkVLT05BJTVDbk5vLiUyMDgxLTE1ODEuJTVDblN1cHJlbWUlMjBDb3VydCUyMG9mJTIwVW5pdGVkJTIwU3RhdGVzLiU1Q25Bcmd1ZWQlMjBKYW51YXJ5JTIwMTklMkMlMjAxOTgzLiU1Q25EZWNpZGVkJTIwQXByaWwlMjAyNiUyQyUyMDE5ODMuJTVDbkNFUlRJT1JBUkklMjBUTyUyMFRIRSUyMFVOSVRFRCUyMFNUQVRFUyUyMENPVVJUJTIwT0YlMjBBUFBFQUxTJTIwRk9SJTIwVEhFJTIwTklOVEglMjBDSVJDVUlUJTVDbioyMzklMjBNaWNoYWVsJTIwQS4lMjBMaWxseSUyQyUyMEZpcnN0JTIwRGVwdXR5JTIwQXR0b3JuZXklMjBHZW5lcmFsJTIwb2YlMjBIYXdhaWklMkMlMjBhcmd1ZWQlMjB0aGUlMjBjYXVzZSUyMGZvciUyMHBldGl0aW9uZXJzLiUyMFdpdGglMjBoaW0lMjBvbiUyMHRoZSUyMGJyaWVmJTIwd2FzJTIwSmFtZXMlMjBILiUyMERhbm5lbmJlcmclMkMlMjBEZXB1dHklMjBBdHRvcm5leSUyMEdlbmVyYWwuLi4nJTdE",highlighted:`{<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;case_ID&#x27;</span>: <span class="hljs-string">&#x27;110921.json&#x27;</span>,
  <span class="hljs-string">&#x27;case_jurisdiction&#x27;</span>: <span class="hljs-string">&#x27;scotus.tar.gz&#x27;</span>,
  <span class="hljs-string">&#x27;date_created&#x27;</span>: <span class="hljs-string">&#x27;2010-04-28T17:12:49Z&#x27;</span>},
 <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;\\n461 U.S. 238 (1983)\\nOLIM ET AL.\\nv.\\nWAKINEKONA\\nNo. 81-1581.\\nSupreme Court of United States.\\nArgued January 19, 1983.\\nDecided April 26, 1983.\\nCERTIORARI TO THE UNITED STATES COURT OF APPEALS FOR THE NINTH CIRCUIT\\n*239 Michael A. Lilly, First Deputy Attorney General of Hawaii, argued the cause for petitioners. With him on the brief was James H. Dannenberg, Deputy Attorney General...&#x27;</span>}`,wrap:!1}}),Ie=new T({props:{code:"ZnJvbSUyMGl0ZXJ0b29scyUyMGltcG9ydCUyMGlzbGljZSUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGludGVybGVhdmVfZGF0YXNldHMlMEElMEFjb21iaW5lZF9kYXRhc2V0JTIwJTNEJTIwaW50ZXJsZWF2ZV9kYXRhc2V0cyglNUJwdWJtZWRfZGF0YXNldF9zdHJlYW1lZCUyQyUyMGxhd19kYXRhc2V0X3N0cmVhbWVkJTVEKSUwQWxpc3QoaXNsaWNlKGNvbWJpbmVkX2RhdGFzZXQlMkMlMjAyKSk=",highlighted:`<span class="hljs-keyword">from</span> itertools <span class="hljs-keyword">import</span> islice
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> interleave_datasets

combined_dataset = interleave_datasets([pubmed_dataset_streamed, law_dataset_streamed])
<span class="hljs-built_in">list</span>(islice(combined_dataset, <span class="hljs-number">2</span>))`,wrap:!1}}),xe=new T({props:{code:"JTVCJTdCJ21ldGEnJTNBJTIwJTdCJ3BtaWQnJTNBJTIwMTE0MDk1NzQlMkMlMjAnbGFuZ3VhZ2UnJTNBJTIwJ2VuZyclN0QlMkMlMEElMjAlMjAndGV4dCclM0ElMjAnRXBpZGVtaW9sb2d5JTIwb2YlMjBoeXBveGFlbWlhJTIwaW4lMjBjaGlsZHJlbiUyMHdpdGglMjBhY3V0ZSUyMGxvd2VyJTIwcmVzcGlyYXRvcnklMjBpbmZlY3Rpb24lMjAuLi4nJTdEJTJDJTBBJTIwJTdCJ21ldGEnJTNBJTIwJTdCJ2Nhc2VfSUQnJTNBJTIwJzExMDkyMS5qc29uJyUyQyUwQSUyMCUyMCUyMCdjYXNlX2p1cmlzZGljdGlvbiclM0ElMjAnc2NvdHVzLnRhci5neiclMkMlMEElMjAlMjAlMjAnZGF0ZV9jcmVhdGVkJyUzQSUyMCcyMDEwLTA0LTI4VDE3JTNBMTIlM0E0OVonJTdEJTJDJTBBJTIwJTIwJ3RleHQnJTNBJTIwJyU1Q240NjElMjBVLlMuJTIwMjM4JTIwKDE5ODMpJTVDbk9MSU0lMjBFVCUyMEFMLiU1Q252LiU1Q25XQUtJTkVLT05BJTVDbk5vLiUyMDgxLTE1ODEuJTVDblN1cHJlbWUlMjBDb3VydCUyMG9mJTIwVW5pdGVkJTIwU3RhdGVzLiU1Q25Bcmd1ZWQlMjBKYW51YXJ5JTIwMTklMkMlMjAxOTgzLiU1Q25EZWNpZGVkJTIwQXByaWwlMjAyNiUyQyUyMDE5ODMuJTVDbkNFUlRJT1JBUkklMjBUTyUyMFRIRSUyMFVOSVRFRCUyMFNUQVRFUyUyMENPVVJUJTIwT0YlMjBBUFBFQUxTJTIwRk9SJTIwVEhFJTIwTklOVEglMjBDSVJDVUlUJTVDbioyMzklMjBNaWNoYWVsJTIwQS4lMjBMaWxseSUyQyUyMEZpcnN0JTIwRGVwdXR5JTIwQXR0b3JuZXklMjBHZW5lcmFsJTIwb2YlMjBIYXdhaWklMkMlMjBhcmd1ZWQlMjB0aGUlMjBjYXVzZSUyMGZvciUyMHBldGl0aW9uZXJzLiUyMFdpdGglMjBoaW0lMjBvbiUyMHRoZSUyMGJyaWVmJTIwd2FzJTIwSmFtZXMlMjBILiUyMERhbm5lbmJlcmclMkMlMjBEZXB1dHklMjBBdHRvcm5leSUyMEdlbmVyYWwuLi4nJTdEJTVE",highlighted:`[{<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11409574</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
  <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Epidemiology of hypoxaemia in children with acute lower respiratory infection ...&#x27;</span>},
 {<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;case_ID&#x27;</span>: <span class="hljs-string">&#x27;110921.json&#x27;</span>,
   <span class="hljs-string">&#x27;case_jurisdiction&#x27;</span>: <span class="hljs-string">&#x27;scotus.tar.gz&#x27;</span>,
   <span class="hljs-string">&#x27;date_created&#x27;</span>: <span class="hljs-string">&#x27;2010-04-28T17:12:49Z&#x27;</span>},
  <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;\\n461 U.S. 238 (1983)\\nOLIM ET AL.\\nv.\\nWAKINEKONA\\nNo. 81-1581.\\nSupreme Court of United States.\\nArgued January 19, 1983.\\nDecided April 26, 1983.\\nCERTIORARI TO THE UNITED STATES COURT OF APPEALS FOR THE NINTH CIRCUIT\\n*239 Michael A. Lilly, First Deputy Attorney General of Hawaii, argued the cause for petitioners. With him on the brief was James H. Dannenberg, Deputy Attorney General...&#x27;</span>}]`,wrap:!1}}),Ge=new T({props:{code:"YmFzZV91cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnRoZS1leWUuZXUlMkZwdWJsaWMlMkZBSSUyRnBpbGUlMkYlMjIlMEFkYXRhX2ZpbGVzJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIydHJhaW4lMjIlM0ElMjAlNUJiYXNlX3VybCUyMCUyQiUyMCUyMnRyYWluJTJGJTIyJTIwJTJCJTIwZiUyMiU3QmlkeCUzQTAyZCU3RC5qc29ubC56c3QlMjIlMjBmb3IlMjBpZHglMjBpbiUyMHJhbmdlKDMwKSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnZhbGlkYXRpb24lMjIlM0ElMjBiYXNlX3VybCUyMCUyQiUyMCUyMnZhbC5qc29ubC56c3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJ0ZXN0JTIyJTNBJTIwYmFzZV91cmwlMjAlMkIlMjAlMjJ0ZXN0Lmpzb25sLnpzdCUyMiUyQyUwQSU3RCUwQXBpbGVfZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJqc29uJTIyJTJDJTIwZGF0YV9maWxlcyUzRGRhdGFfZmlsZXMlMkMlMjBzdHJlYW1pbmclM0RUcnVlKSUwQW5leHQoaXRlcihwaWxlX2RhdGFzZXQlNUIlMjJ0cmFpbiUyMiU1RCkp",highlighted:`base_url = <span class="hljs-string">&quot;https://the-eye.eu/public/AI/pile/&quot;</span>
data_files = {
    <span class="hljs-string">&quot;train&quot;</span>: [base_url + <span class="hljs-string">&quot;train/&quot;</span> + <span class="hljs-string">f&quot;<span class="hljs-subst">{idx:02d}</span>.jsonl.zst&quot;</span> <span class="hljs-keyword">for</span> idx <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">30</span>)],
    <span class="hljs-string">&quot;validation&quot;</span>: base_url + <span class="hljs-string">&quot;val.jsonl.zst&quot;</span>,
    <span class="hljs-string">&quot;test&quot;</span>: base_url + <span class="hljs-string">&quot;test.jsonl.zst&quot;</span>,
}
pile_dataset = load_dataset(<span class="hljs-string">&quot;json&quot;</span>, data_files=data_files, streaming=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(pile_dataset[<span class="hljs-string">&quot;train&quot;</span>]))`,wrap:!1}}),$e=new T({props:{code:"JTdCJ21ldGEnJTNBJTIwJTdCJ3BpbGVfc2V0X25hbWUnJTNBJTIwJ1BpbGUtQ0MnJTdEJTJDJTBBJTIwJ3RleHQnJTNBJTIwJ0l0JTIwaXMlMjBkb25lJTJDJTIwYW5kJTIwc3VibWl0dGVkLiUyMFlvdSUyMGNhbiUyMHBsYXklMjAlRTIlODAlOUNTdXJ2aXZhbCUyMG9mJTIwdGhlJTIwVGFzdGllc3QlRTIlODAlOUQlMjBvbiUyMEFuZHJvaWQlMkMlMjBhbmQlMjBvbiUyMHRoZSUyMHdlYi4uLiclN0Q=",highlighted:`{<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pile_set_name&#x27;</span>: <span class="hljs-string">&#x27;Pile-CC&#x27;</span>},
 <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;It is done, and submitted. You can play “Survival of the Tastiest” on Android, and on the web...&#x27;</span>}`,wrap:!1}}),I=new We({props:{$$slots:{default:[Ql]},$$scope:{ctx:b}}}),{c(){i=c("meta"),h=t(),M=c("p"),j=t(),p(x.$$.fragment),ze=t(),p(Z.$$.fragment),Xe=t(),B=c("p"),B.innerHTML=Ds,Re=t(),G=c("p"),G.innerHTML=Ls,Ce=t(),p($.$$.fragment),Qe=t(),V=c("p"),V.innerHTML=qs,Ne=t(),p(v.$$.fragment),Ee=t(),W=c("p"),W.innerHTML=Ps,Ye=t(),p(k.$$.fragment),He=t(),z=c("p"),z.innerHTML=Os,_e=t(),p(X.$$.fragment),Se=t(),p(R.$$.fragment),Fe=t(),C=c("p"),C.textContent=Ks,Ae=t(),p(U.$$.fragment),De=t(),Q=c("p"),Q.textContent=el,Le=t(),p(N.$$.fragment),qe=t(),p(E.$$.fragment),Pe=t(),Y=c("p"),Y.textContent=sl,Oe=t(),p(H.$$.fragment),Ke=t(),_=c("p"),_.innerHTML=ll,es=t(),p(S.$$.fragment),ss=t(),F=c("p"),F.innerHTML=nl,ls=t(),p(A.$$.fragment),ns=t(),p(D.$$.fragment),ts=t(),L=c("p"),L.innerHTML=tl,as=t(),p(q.$$.fragment),is=t(),p(P.$$.fragment),ps=t(),O=c("p"),O.textContent=al,rs=t(),p(w.$$.fragment),os=t(),K=c("p"),K.innerHTML=il,ds=t(),ee=c("p"),ee.innerHTML=pl,us=t(),p(se.$$.fragment),ms=t(),p(le.$$.fragment),Ms=t(),ne=c("p"),ne.innerHTML=rl,cs=t(),p(f.$$.fragment),Js=t(),p(te.$$.fragment),ys=t(),ae=c("p"),ae.innerHTML=ol,Ts=t(),p(ie.$$.fragment),hs=t(),pe=c("p"),pe.innerHTML=dl,js=t(),p(re.$$.fragment),bs=t(),p(oe.$$.fragment),Us=t(),de=c("p"),de.innerHTML=ul,ws=t(),p(ue.$$.fragment),fs=t(),p(me.$$.fragment),gs=t(),p(g.$$.fragment),Is=t(),Me=c("p"),Me.innerHTML=ml,xs=t(),p(ce.$$.fragment),Zs=t(),p(Je.$$.fragment),Bs=t(),ye=c("p"),ye.innerHTML=Ml,Gs=t(),p(Te.$$.fragment),$s=t(),p(he.$$.fragment),Vs=t(),je=c("p"),je.innerHTML=cl,vs=t(),p(be.$$.fragment),Ws=t(),Ue=c("p"),Ue.innerHTML=Jl,ks=t(),p(we.$$.fragment),zs=t(),p(fe.$$.fragment),Xs=t(),ge=c("p"),ge.innerHTML=yl,Rs=t(),p(Ie.$$.fragment),Cs=t(),p(xe.$$.fragment),Qs=t(),Ze=c("p"),Ze.innerHTML=Tl,Ns=t(),Be=c("p"),Be.innerHTML=hl,Es=t(),p(Ge.$$.fragment),Ys=t(),p($e.$$.fragment),Hs=t(),p(I.$$.fragment),_s=t(),Ve=c("p"),Ve.textContent=jl,Ss=t(),ve=c("p"),this.h()},l(e){const s=Vl("svelte-u9bgzb",document.head);i=J(s,"META",{name:!0,content:!0}),s.forEach(l),h=a(e),M=J(e,"P",{}),Il(M).forEach(l),j=a(e),r(x.$$.fragment,e),ze=a(e),r(Z.$$.fragment,e),Xe=a(e),B=J(e,"P",{"data-svelte-h":!0}),y(B)!=="svelte-1n0aq50"&&(B.innerHTML=Ds),Re=a(e),G=J(e,"P",{"data-svelte-h":!0}),y(G)!=="svelte-z4dff3"&&(G.innerHTML=Ls),Ce=a(e),r($.$$.fragment,e),Qe=a(e),V=J(e,"P",{"data-svelte-h":!0}),y(V)!=="svelte-1ey6jlq"&&(V.innerHTML=qs),Ne=a(e),r(v.$$.fragment,e),Ee=a(e),W=J(e,"P",{"data-svelte-h":!0}),y(W)!=="svelte-xwkwxb"&&(W.innerHTML=Ps),Ye=a(e),r(k.$$.fragment,e),He=a(e),z=J(e,"P",{"data-svelte-h":!0}),y(z)!=="svelte-1djvo8q"&&(z.innerHTML=Os),_e=a(e),r(X.$$.fragment,e),Se=a(e),r(R.$$.fragment,e),Fe=a(e),C=J(e,"P",{"data-svelte-h":!0}),y(C)!=="svelte-jgiig2"&&(C.textContent=Ks),Ae=a(e),r(U.$$.fragment,e),De=a(e),Q=J(e,"P",{"data-svelte-h":!0}),y(Q)!=="svelte-1jodsbq"&&(Q.textContent=el),Le=a(e),r(N.$$.fragment,e),qe=a(e),r(E.$$.fragment,e),Pe=a(e),Y=J(e,"P",{"data-svelte-h":!0}),y(Y)!=="svelte-qvjcta"&&(Y.textContent=sl),Oe=a(e),r(H.$$.fragment,e),Ke=a(e),_=J(e,"P",{"data-svelte-h":!0}),y(_)!=="svelte-1e4dhll"&&(_.innerHTML=ll),es=a(e),r(S.$$.fragment,e),ss=a(e),F=J(e,"P",{"data-svelte-h":!0}),y(F)!=="svelte-e6epbe"&&(F.innerHTML=nl),ls=a(e),r(A.$$.fragment,e),ns=a(e),r(D.$$.fragment,e),ts=a(e),L=J(e,"P",{"data-svelte-h":!0}),y(L)!=="svelte-13cvybs"&&(L.innerHTML=tl),as=a(e),r(q.$$.fragment,e),is=a(e),r(P.$$.fragment,e),ps=a(e),O=J(e,"P",{"data-svelte-h":!0}),y(O)!=="svelte-1807tcn"&&(O.textContent=al),rs=a(e),r(w.$$.fragment,e),os=a(e),K=J(e,"P",{"data-svelte-h":!0}),y(K)!=="svelte-17s56pe"&&(K.innerHTML=il),ds=a(e),ee=J(e,"P",{"data-svelte-h":!0}),y(ee)!=="svelte-q5ckcr"&&(ee.innerHTML=pl),us=a(e),r(se.$$.fragment,e),ms=a(e),r(le.$$.fragment,e),Ms=a(e),ne=J(e,"P",{"data-svelte-h":!0}),y(ne)!=="svelte-1qf5v39"&&(ne.innerHTML=rl),cs=a(e),r(f.$$.fragment,e),Js=a(e),r(te.$$.fragment,e),ys=a(e),ae=J(e,"P",{"data-svelte-h":!0}),y(ae)!=="svelte-qgureo"&&(ae.innerHTML=ol),Ts=a(e),r(ie.$$.fragment,e),hs=a(e),pe=J(e,"P",{"data-svelte-h":!0}),y(pe)!=="svelte-ooenp6"&&(pe.innerHTML=dl),js=a(e),r(re.$$.fragment,e),bs=a(e),r(oe.$$.fragment,e),Us=a(e),de=J(e,"P",{"data-svelte-h":!0}),y(de)!=="svelte-1aulibg"&&(de.innerHTML=ul),ws=a(e),r(ue.$$.fragment,e),fs=a(e),r(me.$$.fragment,e),gs=a(e),r(g.$$.fragment,e),Is=a(e),Me=J(e,"P",{"data-svelte-h":!0}),y(Me)!=="svelte-1936jdb"&&(Me.innerHTML=ml),xs=a(e),r(ce.$$.fragment,e),Zs=a(e),r(Je.$$.fragment,e),Bs=a(e),ye=J(e,"P",{"data-svelte-h":!0}),y(ye)!=="svelte-13iarxl"&&(ye.innerHTML=Ml),Gs=a(e),r(Te.$$.fragment,e),$s=a(e),r(he.$$.fragment,e),Vs=a(e),je=J(e,"P",{"data-svelte-h":!0}),y(je)!=="svelte-1axizdx"&&(je.innerHTML=cl),vs=a(e),r(be.$$.fragment,e),Ws=a(e),Ue=J(e,"P",{"data-svelte-h":!0}),y(Ue)!=="svelte-1303a2x"&&(Ue.innerHTML=Jl),ks=a(e),r(we.$$.fragment,e),zs=a(e),r(fe.$$.fragment,e),Xs=a(e),ge=J(e,"P",{"data-svelte-h":!0}),y(ge)!=="svelte-o783i4"&&(ge.innerHTML=yl),Rs=a(e),r(Ie.$$.fragment,e),Cs=a(e),r(xe.$$.fragment,e),Qs=a(e),Ze=J(e,"P",{"data-svelte-h":!0}),y(Ze)!=="svelte-tlls1x"&&(Ze.innerHTML=Tl),Ns=a(e),Be=J(e,"P",{"data-svelte-h":!0}),y(Be)!=="svelte-1lk2l6b"&&(Be.innerHTML=hl),Es=a(e),r(Ge.$$.fragment,e),Ys=a(e),r($e.$$.fragment,e),Hs=a(e),r(I.$$.fragment,e),_s=a(e),Ve=J(e,"P",{"data-svelte-h":!0}),y(Ve)!=="svelte-9kylg4"&&(Ve.textContent=jl),Ss=a(e),ve=J(e,"P",{}),Il(ve).forEach(l),this.h()},h(){xl(i,"name","hf:doc:metadata"),xl(i,"content",El)},m(e,s){vl(document.head,i),n(e,h,s),n(e,M,s),n(e,j,s),o(x,e,s),n(e,ze,s),o(Z,e,s),n(e,Xe,s),n(e,B,s),n(e,Re,s),n(e,G,s),n(e,Ce,s),o($,e,s),n(e,Qe,s),n(e,V,s),n(e,Ne,s),o(v,e,s),n(e,Ee,s),n(e,W,s),n(e,Ye,s),o(k,e,s),n(e,He,s),n(e,z,s),n(e,_e,s),o(X,e,s),n(e,Se,s),o(R,e,s),n(e,Fe,s),n(e,C,s),n(e,Ae,s),o(U,e,s),n(e,De,s),n(e,Q,s),n(e,Le,s),o(N,e,s),n(e,qe,s),o(E,e,s),n(e,Pe,s),n(e,Y,s),n(e,Oe,s),o(H,e,s),n(e,Ke,s),n(e,_,s),n(e,es,s),o(S,e,s),n(e,ss,s),n(e,F,s),n(e,ls,s),o(A,e,s),n(e,ns,s),o(D,e,s),n(e,ts,s),n(e,L,s),n(e,as,s),o(q,e,s),n(e,is,s),o(P,e,s),n(e,ps,s),n(e,O,s),n(e,rs,s),o(w,e,s),n(e,os,s),n(e,K,s),n(e,ds,s),n(e,ee,s),n(e,us,s),o(se,e,s),n(e,ms,s),o(le,e,s),n(e,Ms,s),n(e,ne,s),n(e,cs,s),o(f,e,s),n(e,Js,s),o(te,e,s),n(e,ys,s),n(e,ae,s),n(e,Ts,s),o(ie,e,s),n(e,hs,s),n(e,pe,s),n(e,js,s),o(re,e,s),n(e,bs,s),o(oe,e,s),n(e,Us,s),n(e,de,s),n(e,ws,s),o(ue,e,s),n(e,fs,s),o(me,e,s),n(e,gs,s),o(g,e,s),n(e,Is,s),n(e,Me,s),n(e,xs,s),o(ce,e,s),n(e,Zs,s),o(Je,e,s),n(e,Bs,s),n(e,ye,s),n(e,Gs,s),o(Te,e,s),n(e,$s,s),o(he,e,s),n(e,Vs,s),n(e,je,s),n(e,vs,s),o(be,e,s),n(e,Ws,s),n(e,Ue,s),n(e,ks,s),o(we,e,s),n(e,zs,s),o(fe,e,s),n(e,Xs,s),n(e,ge,s),n(e,Rs,s),o(Ie,e,s),n(e,Cs,s),o(xe,e,s),n(e,Qs,s),n(e,Ze,s),n(e,Ns,s),n(e,Be,s),n(e,Es,s),o(Ge,e,s),n(e,Ys,s),o($e,e,s),n(e,Hs,s),o(I,e,s),n(e,_s,s),n(e,Ve,s),n(e,Ss,s),n(e,ve,s),Fs=!0},p(e,[s]){const bl={};s&2&&(bl.$$scope={dirty:s,ctx:e}),U.$set(bl);const Ul={};s&2&&(Ul.$$scope={dirty:s,ctx:e}),w.$set(Ul);const wl={};s&2&&(wl.$$scope={dirty:s,ctx:e}),f.$set(wl);const fl={};s&2&&(fl.$$scope={dirty:s,ctx:e}),g.$set(fl);const gl={};s&2&&(gl.$$scope={dirty:s,ctx:e}),I.$set(gl)},i(e){Fs||(d(x.$$.fragment,e),d(Z.$$.fragment,e),d($.$$.fragment,e),d(v.$$.fragment,e),d(k.$$.fragment,e),d(X.$$.fragment,e),d(R.$$.fragment,e),d(U.$$.fragment,e),d(N.$$.fragment,e),d(E.$$.fragment,e),d(H.$$.fragment,e),d(S.$$.fragment,e),d(A.$$.fragment,e),d(D.$$.fragment,e),d(q.$$.fragment,e),d(P.$$.fragment,e),d(w.$$.fragment,e),d(se.$$.fragment,e),d(le.$$.fragment,e),d(f.$$.fragment,e),d(te.$$.fragment,e),d(ie.$$.fragment,e),d(re.$$.fragment,e),d(oe.$$.fragment,e),d(ue.$$.fragment,e),d(me.$$.fragment,e),d(g.$$.fragment,e),d(ce.$$.fragment,e),d(Je.$$.fragment,e),d(Te.$$.fragment,e),d(he.$$.fragment,e),d(be.$$.fragment,e),d(we.$$.fragment,e),d(fe.$$.fragment,e),d(Ie.$$.fragment,e),d(xe.$$.fragment,e),d(Ge.$$.fragment,e),d($e.$$.fragment,e),d(I.$$.fragment,e),Fs=!0)},o(e){u(x.$$.fragment,e),u(Z.$$.fragment,e),u($.$$.fragment,e),u(v.$$.fragment,e),u(k.$$.fragment,e),u(X.$$.fragment,e),u(R.$$.fragment,e),u(U.$$.fragment,e),u(N.$$.fragment,e),u(E.$$.fragment,e),u(H.$$.fragment,e),u(S.$$.fragment,e),u(A.$$.fragment,e),u(D.$$.fragment,e),u(q.$$.fragment,e),u(P.$$.fragment,e),u(w.$$.fragment,e),u(se.$$.fragment,e),u(le.$$.fragment,e),u(f.$$.fragment,e),u(te.$$.fragment,e),u(ie.$$.fragment,e),u(re.$$.fragment,e),u(oe.$$.fragment,e),u(ue.$$.fragment,e),u(me.$$.fragment,e),u(g.$$.fragment,e),u(ce.$$.fragment,e),u(Je.$$.fragment,e),u(Te.$$.fragment,e),u(he.$$.fragment,e),u(be.$$.fragment,e),u(we.$$.fragment,e),u(fe.$$.fragment,e),u(Ie.$$.fragment,e),u(xe.$$.fragment,e),u(Ge.$$.fragment,e),u($e.$$.fragment,e),u(I.$$.fragment,e),Fs=!1},d(e){e&&(l(h),l(M),l(j),l(ze),l(Xe),l(B),l(Re),l(G),l(Ce),l(Qe),l(V),l(Ne),l(Ee),l(W),l(Ye),l(He),l(z),l(_e),l(Se),l(Fe),l(C),l(Ae),l(De),l(Q),l(Le),l(qe),l(Pe),l(Y),l(Oe),l(Ke),l(_),l(es),l(ss),l(F),l(ls),l(ns),l(ts),l(L),l(as),l(is),l(ps),l(O),l(rs),l(os),l(K),l(ds),l(ee),l(us),l(ms),l(Ms),l(ne),l(cs),l(Js),l(ys),l(ae),l(Ts),l(hs),l(pe),l(js),l(bs),l(Us),l(de),l(ws),l(fs),l(gs),l(Is),l(Me),l(xs),l(Zs),l(Bs),l(ye),l(Gs),l($s),l(Vs),l(je),l(vs),l(Ws),l(Ue),l(ks),l(zs),l(Xs),l(ge),l(Rs),l(Cs),l(Qs),l(Ze),l(Ns),l(Be),l(Es),l(Ys),l(Hs),l(_s),l(Ve),l(Ss),l(ve)),l(i),m(x,e),m(Z,e),m($,e),m(v,e),m(k,e),m(X,e),m(R,e),m(U,e),m(N,e),m(E,e),m(H,e),m(S,e),m(A,e),m(D,e),m(q,e),m(P,e),m(w,e),m(se,e),m(le,e),m(f,e),m(te,e),m(ie,e),m(re,e),m(oe,e),m(ue,e),m(me,e),m(g,e),m(ce,e),m(Je,e),m(Te,e),m(he,e),m(be,e),m(we,e),m(fe,e),m(Ie,e),m(xe,e),m(Ge,e),m($e,e),m(I,e)}}}const El='{"title":"Données massives ? 🤗 <i> Datasets </i> à la rescousse !","local":"données-massives---i-datasets-i-à-la-rescousse-","sections":[{"title":"Qu’est-ce que <i> The Pile </i> ?","local":"quest-ce-que-i-the-pile-i-","sections":[],"depth":2},{"title":"La magie du <i> memory mapping </i>","local":"la-magie-du-i-memory-mapping-i","sections":[],"depth":2},{"title":"Jeux de données en continu","local":"jeux-de-données-en-continu","sections":[],"depth":2}],"depth":1}';function Yl(b){return Bl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ql extends Gl{constructor(i){super(),$l(this,i,Yl,Nl,Zl,{})}}export{ql as component};
