import{s as Ze,n as He,o as _e}from"../chunks/scheduler.f7e1785c.js";import{S as qe,i as Qe,g as i,s,r as u,A as ze,h as o,f as l,c as a,j as We,u as r,x as p,k as Ie,y as Re,a as n,v as m,d,t as c,w as y}from"../chunks/index.9f8f0838.js";import{C as f}from"../chunks/CodeBlock.b3510e34.js";import{H as we}from"../chunks/Heading.6643a2f7.js";function Xe(ge){let h,S,X,N,M,Y,w,Ue=`Audio generation encompasses a versatile set of tasks that involve producing an audio output. The tasks
that we will look into here are speech generation (aka “text-to-speech”) and music generation. In text-to-speech, a
model transforms a piece of text into lifelike spoken language sound, opening the door to applications such as virtual assistants,
accessibility tools for the visually impaired, and personalized audiobooks.
On the other hand, music generation can enable creative expression, and finds its use mostly in entertainment and game
development industries.`,P,g,Je=`In 🤗 Transformers, you’ll find a pipeline that covers both of these tasks. This pipeline is called <code>&quot;text-to-audio&quot;</code>,
but for convenience, it also has a <code>&quot;text-to-speech&quot;</code> alias. Here we’ll use both, and you are free to pick whichever
seems more applicable for your task.`,A,U,$e="Let’s explore how you can use this pipeline to start generating audio narration for texts, and music with just a few lines of code.",E,J,be="This pipeline is new to 🤗 Transformers and comes part of the version 4.32 release. Thus you’ll need to upgrade the library to the latest version to get the feature:",L,$,D,b,K,C,Ce=`Let’s begin by exploring text-to-speech generation. First, just as it was the case with audio classification and automatic
speech recognition, we’ll need to define the pipeline. We’ll define a text-to-speech pipeline since it best describes our task, and use the <a href="https://huggingface.co/suno/bark-small" rel="nofollow"><code>suno/bark-small</code></a> checkpoint:`,O,T,ee,x,Te="The next step is as simple as passing some text through the pipeline. All the preprocessing will be done for us under the hood:",te,k,le,j,xe="In a notebook, we can use the following code snippet to listen to the result:",ne,G,se,v,ke=`The model that we’re using with the pipeline, Bark, is actually multilingual, so we can easily substitute the initial
text with a text in, say, French, and use the pipeline in the exact same way. It will pick up on the language all by itself:`,ae,B,ie,V,je=`Not only is this model multilingual, it can also generate audio with non-verbal communications and singing. Here’s how
you can make it sing:`,oe,W,pe,I,Ge=`We’ll dive deeper into Bark specifics in the later unit dedicated to Text-to-speech, and will also show how you can use
other models for this task. Now, let’s generate some music!`,ue,Z,re,H,ve='Just as before, we’ll begin by instantiating a pipeline. For music generation, we’ll define a text-to-audio pipeline, and initialise it with the pretrained checkpoint <a href="https://huggingface.co/facebook/musicgen-small" rel="nofollow"><code>facebook/musicgen-small</code></a>',me,_,de,q,Be="Let’s create a text description of the music we’d like to generate:",ce,Q,ye,z,Ve="We can control the length of the generated output by passing an additional <code>max_new_tokens</code> parameter to the model.",he,R,fe,F,Me;return M=new we({props:{title:"Audio generation with a pipeline",local:"audio-generation-with-a-pipeline",headingTag:"h1"}}),$=new f({props:{code:"cGlwJTIwaW5zdGFsbCUyMC0tdXBncmFkZSUyMHRyYW5zZm9ybWVycw==",highlighted:"pip install --upgrade transformers",wrap:!1}}),b=new we({props:{title:"Generating speech",local:"generating-speech",headingTag:"h2"}}),T=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnRleHQtdG8tc3BlZWNoJTIyJTJDJTIwbW9kZWwlM0QlMjJzdW5vJTJGYmFyay1zbWFsbCUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(<span class="hljs-string">&quot;text-to-speech&quot;</span>, model=<span class="hljs-string">&quot;suno/bark-small&quot;</span>)`,wrap:!1}}),k=new f({props:{code:"dGV4dCUyMCUzRCUyMCUyMkxhZHlidWdzJTIwaGF2ZSUyMGhhZCUyMGltcG9ydGFudCUyMHJvbGVzJTIwaW4lMjBjdWx0dXJlJTIwYW5kJTIwcmVsaWdpb24lMkMlMjBiZWluZyUyMGFzc29jaWF0ZWQlMjB3aXRoJTIwbHVjayUyQyUyMGxvdmUlMkMlMjBmZXJ0aWxpdHklMjBhbmQlMjBwcm9waGVjeS4lMjAlMjIlMEFvdXRwdXQlMjAlM0QlMjBwaXBlKHRleHQp",highlighted:`text = <span class="hljs-string">&quot;Ladybugs have had important roles in culture and religion, being associated with luck, love, fertility and prophecy. &quot;</span>
output = pipe(text)`,wrap:!1}}),G=new f({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBQXVkaW8ob3V0cHV0JTVCJTIyYXVkaW8lMjIlNUQlMkMlMjByYXRlJTNEb3V0cHV0JTVCJTIyc2FtcGxpbmdfcmF0ZSUyMiU1RCk=",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio

Audio(output[<span class="hljs-string">&quot;audio&quot;</span>], rate=output[<span class="hljs-string">&quot;sampling_rate&quot;</span>])`,wrap:!1}}),B=new f({props:{code:"ZnJfdGV4dCUyMCUzRCUyMCUyMkNvbnRyYWlyZW1lbnQlMjAlQzMlQTAlMjB1bmUlMjBpZCVDMyVBOWUlMjByJUMzJUE5cGFuZHVlJTJDJTIwbGUlMjBub21icmUlMjBkZSUyMHBvaW50cyUyMHN1ciUyMGxlcyUyMCVDMyVBOWx5dHJlcyUyMGQndW5lJTIwY29jY2luZWxsZSUyMG5lJTIwY29ycmVzcG9uZCUyMHBhcyUyMCVDMyVBMCUyMHNvbiUyMCVDMyVBMmdlJTJDJTIwbmklMjBlbiUyMG5vbWJyZSUyMGQnYW5uJUMzJUE5ZXMlMkMlMjBuaSUyMGVuJTIwbm9tYnJlJTIwZGUlMjBtb2lzLiUyMCUyMiUwQW91dHB1dCUyMCUzRCUyMHBpcGUoZnJfdGV4dCklMEFBdWRpbyhvdXRwdXQlNUIlMjJhdWRpbyUyMiU1RCUyQyUyMHJhdGUlM0RvdXRwdXQlNUIlMjJzYW1wbGluZ19yYXRlJTIyJTVEKQ==",highlighted:`fr_text = <span class="hljs-string">&quot;Contrairement à une idée répandue, le nombre de points sur les élytres d&#x27;une coccinelle ne correspond pas à son âge, ni en nombre d&#x27;années, ni en nombre de mois. &quot;</span>
output = pipe(fr_text)
Audio(output[<span class="hljs-string">&quot;audio&quot;</span>], rate=output[<span class="hljs-string">&quot;sampling_rate&quot;</span>])`,wrap:!1}}),W=new f({props:{code:"c29uZyUyMCUzRCUyMCUyMiVFMiU5OSVBQSUyMEluJTIwdGhlJTIwanVuZ2xlJTJDJTIwdGhlJTIwbWlnaHR5JTIwanVuZ2xlJTJDJTIwdGhlJTIwbGFkeWJ1ZyUyMHdhcyUyMHNlZW4uJTIwJUUyJTk5JUFBJTIwJTIyJTBBb3V0cHV0JTIwJTNEJTIwcGlwZShzb25nKSUwQUF1ZGlvKG91dHB1dCU1QiUyMmF1ZGlvJTIyJTVEJTJDJTIwcmF0ZSUzRG91dHB1dCU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQp",highlighted:`song = <span class="hljs-string">&quot;♪ In the jungle, the mighty jungle, the ladybug was seen. ♪ &quot;</span>
output = pipe(song)
Audio(output[<span class="hljs-string">&quot;audio&quot;</span>], rate=output[<span class="hljs-string">&quot;sampling_rate&quot;</span>])`,wrap:!1}}),Z=new we({props:{title:"Generating music",local:"generating-music",headingTag:"h2"}}),_=new f({props:{code:"bXVzaWNfcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnRleHQtdG8tYXVkaW8lMjIlMkMlMjBtb2RlbCUzRCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tc21hbGwlMjIp",highlighted:'music_pipe = pipeline(<span class="hljs-string">&quot;text-to-audio&quot;</span>, model=<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)',wrap:!1}}),Q=new f({props:{code:"dGV4dCUyMCUzRCUyMCUyMjkwcyUyMHJvY2slMjBzb25nJTIwd2l0aCUyMGVsZWN0cmljJTIwZ3VpdGFyJTIwYW5kJTIwaGVhdnklMjBkcnVtcyUyMg==",highlighted:'text = <span class="hljs-string">&quot;90s rock song with electric guitar and heavy drums&quot;</span>',wrap:!1}}),R=new f({props:{code:"Zm9yd2FyZF9wYXJhbXMlMjAlM0QlMjAlN0IlMjJtYXhfbmV3X3Rva2VucyUyMiUzQSUyMDUxMiU3RCUwQSUwQW91dHB1dCUyMCUzRCUyMG11c2ljX3BpcGUodGV4dCUyQyUyMGZvcndhcmRfcGFyYW1zJTNEZm9yd2FyZF9wYXJhbXMpJTBBQXVkaW8ob3V0cHV0JTVCJTIyYXVkaW8lMjIlNUQlNUIwJTVEJTJDJTIwcmF0ZSUzRG91dHB1dCU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQp",highlighted:`forward_params = {<span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">512</span>}

output = music_pipe(text, forward_params=forward_params)
Audio(output[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-number">0</span>], rate=output[<span class="hljs-string">&quot;sampling_rate&quot;</span>])`,wrap:!1}}),{c(){h=i("meta"),S=s(),X=i("p"),N=s(),u(M.$$.fragment),Y=s(),w=i("p"),w.textContent=Ue,P=s(),g=i("p"),g.innerHTML=Je,A=s(),U=i("p"),U.textContent=$e,E=s(),J=i("p"),J.textContent=be,L=s(),u($.$$.fragment),D=s(),u(b.$$.fragment),K=s(),C=i("p"),C.innerHTML=Ce,O=s(),u(T.$$.fragment),ee=s(),x=i("p"),x.textContent=Te,te=s(),u(k.$$.fragment),le=s(),j=i("p"),j.textContent=xe,ne=s(),u(G.$$.fragment),se=s(),v=i("p"),v.textContent=ke,ae=s(),u(B.$$.fragment),ie=s(),V=i("p"),V.textContent=je,oe=s(),u(W.$$.fragment),pe=s(),I=i("p"),I.textContent=Ge,ue=s(),u(Z.$$.fragment),re=s(),H=i("p"),H.innerHTML=ve,me=s(),u(_.$$.fragment),de=s(),q=i("p"),q.textContent=Be,ce=s(),u(Q.$$.fragment),ye=s(),z=i("p"),z.innerHTML=Ve,he=s(),u(R.$$.fragment),fe=s(),F=i("p"),this.h()},l(e){const t=ze("svelte-u9bgzb",document.head);h=o(t,"META",{name:!0,content:!0}),t.forEach(l),S=a(e),X=o(e,"P",{}),We(X).forEach(l),N=a(e),r(M.$$.fragment,e),Y=a(e),w=o(e,"P",{"data-svelte-h":!0}),p(w)!=="svelte-1dtkcul"&&(w.textContent=Ue),P=a(e),g=o(e,"P",{"data-svelte-h":!0}),p(g)!=="svelte-f44taj"&&(g.innerHTML=Je),A=a(e),U=o(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-1x3quri"&&(U.textContent=$e),E=a(e),J=o(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-1iuie69"&&(J.textContent=be),L=a(e),r($.$$.fragment,e),D=a(e),r(b.$$.fragment,e),K=a(e),C=o(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-anq3st"&&(C.innerHTML=Ce),O=a(e),r(T.$$.fragment,e),ee=a(e),x=o(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-6b8wyl"&&(x.textContent=Te),te=a(e),r(k.$$.fragment,e),le=a(e),j=o(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-1w6x0gz"&&(j.textContent=xe),ne=a(e),r(G.$$.fragment,e),se=a(e),v=o(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-16u7g8g"&&(v.textContent=ke),ae=a(e),r(B.$$.fragment,e),ie=a(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-ags8tg"&&(V.textContent=je),oe=a(e),r(W.$$.fragment,e),pe=a(e),I=o(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-b3wsq0"&&(I.textContent=Ge),ue=a(e),r(Z.$$.fragment,e),re=a(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-kuejmv"&&(H.innerHTML=ve),me=a(e),r(_.$$.fragment,e),de=a(e),q=o(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-1xd5ix4"&&(q.textContent=Be),ce=a(e),r(Q.$$.fragment,e),ye=a(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-le5gn"&&(z.innerHTML=Ve),he=a(e),r(R.$$.fragment,e),fe=a(e),F=o(e,"P",{}),We(F).forEach(l),this.h()},h(){Ie(h,"name","hf:doc:metadata"),Ie(h,"content",Fe)},m(e,t){Re(document.head,h),n(e,S,t),n(e,X,t),n(e,N,t),m(M,e,t),n(e,Y,t),n(e,w,t),n(e,P,t),n(e,g,t),n(e,A,t),n(e,U,t),n(e,E,t),n(e,J,t),n(e,L,t),m($,e,t),n(e,D,t),m(b,e,t),n(e,K,t),n(e,C,t),n(e,O,t),m(T,e,t),n(e,ee,t),n(e,x,t),n(e,te,t),m(k,e,t),n(e,le,t),n(e,j,t),n(e,ne,t),m(G,e,t),n(e,se,t),n(e,v,t),n(e,ae,t),m(B,e,t),n(e,ie,t),n(e,V,t),n(e,oe,t),m(W,e,t),n(e,pe,t),n(e,I,t),n(e,ue,t),m(Z,e,t),n(e,re,t),n(e,H,t),n(e,me,t),m(_,e,t),n(e,de,t),n(e,q,t),n(e,ce,t),m(Q,e,t),n(e,ye,t),n(e,z,t),n(e,he,t),m(R,e,t),n(e,fe,t),n(e,F,t),Me=!0},p:He,i(e){Me||(d(M.$$.fragment,e),d($.$$.fragment,e),d(b.$$.fragment,e),d(T.$$.fragment,e),d(k.$$.fragment,e),d(G.$$.fragment,e),d(B.$$.fragment,e),d(W.$$.fragment,e),d(Z.$$.fragment,e),d(_.$$.fragment,e),d(Q.$$.fragment,e),d(R.$$.fragment,e),Me=!0)},o(e){c(M.$$.fragment,e),c($.$$.fragment,e),c(b.$$.fragment,e),c(T.$$.fragment,e),c(k.$$.fragment,e),c(G.$$.fragment,e),c(B.$$.fragment,e),c(W.$$.fragment,e),c(Z.$$.fragment,e),c(_.$$.fragment,e),c(Q.$$.fragment,e),c(R.$$.fragment,e),Me=!1},d(e){e&&(l(S),l(X),l(N),l(Y),l(w),l(P),l(g),l(A),l(U),l(E),l(J),l(L),l(D),l(K),l(C),l(O),l(ee),l(x),l(te),l(le),l(j),l(ne),l(se),l(v),l(ae),l(ie),l(V),l(oe),l(pe),l(I),l(ue),l(re),l(H),l(me),l(de),l(q),l(ce),l(ye),l(z),l(he),l(fe),l(F)),l(h),y(M,e),y($,e),y(b,e),y(T,e),y(k,e),y(G,e),y(B,e),y(W,e),y(Z,e),y(_,e),y(Q,e),y(R,e)}}}const Fe='{"title":"Audio generation with a pipeline","local":"audio-generation-with-a-pipeline","sections":[{"title":"Generating speech","local":"generating-speech","sections":[],"depth":2},{"title":"Generating music","local":"generating-music","sections":[],"depth":2}],"depth":1}';function Se(ge){return _e(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ee extends qe{constructor(h){super(),Qe(this,h,Se,Xe,Ze,{})}}export{Ee as component};
