import{s as ft,n as ht,o as gt}from"../chunks/scheduler.182ea377.js";import{S as _t,i as vt,g as i,s as o,r as p,A as St,h as a,f as t,c as n,j as v,u as m,x as u,k as S,y as s,a as d,v as f,d as h,t as g,w as _}from"../chunks/index.abf12888.js";import{D}from"../chunks/Docstring.93f6f462.js";import{H as Le}from"../chunks/Heading.16916d63.js";function bt(Qe){let b,de,ie,le,C,ce,F,Ze='Diffusion Exponential Integrator Sampler (DEIS) is proposed in <a href="https://huggingface.co/papers/2204.13902" rel="nofollow">Fast Sampling of Diffusion Models with Exponential Integrator</a> by Qinsheng Zhang and Yongxin Chen. <code>DEISMultistepScheduler</code> is a fast high order solver for diffusion ordinary differential equations (ODEs).',ue,L,Je="This implementation modifies the polynomial fitting formula in log-rho space instead of the original linear <code>t</code> space in the DEIS paper. The modification enjoys closed-form coefficients for exponential multistep update instead of replying on the numerical solver.",pe,P,Xe="The abstract from the paper is:",me,O,et='<em>The past few years have witnessed the great success of Diffusion models~(DMs) in generating high-fidelity samples in generative modeling tasks. A major limitation of the DM is its notoriously slow sampling procedure which normally requires hundreds to thousands of time discretization steps of the learned diffusion process to reach the desired accuracy. Our goal is to develop a fast sampling method for DMs with a much less number of steps while retaining high sample quality. To this end, we systematically analyze the sampling procedure in DMs and identify key factors that affect the sample quality, among which the method of discretization is most crucial. By carefully examining the learned diffusion process, we propose Diffusion Exponential Integrator Sampler~(DEIS). It is based on the Exponential Integrator designed for discretizing ordinary differential equations (ODEs) and leverages a semilinear structure of the learned diffusion process to reduce the discretization error. The proposed method can be applied to any DMs and can generate high-fidelity samples in as few as 10 steps. In our experiments, it takes about 3 minutes on one A6000 GPU to generate 50k images from CIFAR10. Moreover, by directly using pre-trained DMs, we achieve the state-of-art sampling performance when the number of score function evaluation~(NFE) is limited, e.g., 4.17 FID with 10 NFEs, 3.37 FID, and 9.74 IS with only 15 NFEs on CIFAR10. Code is available at <a href="https://github.com/qsh-zh/deis" rel="nofollow">this https URL</a>.</em>',fe,q,tt='The original codebase can be found at <a href="https://github.com/qsh-zh/deis" rel="nofollow">qsh-zh/deis</a>.',he,k,ge,H,st='It is recommended to set <code>solver_order</code> to 2 or 3, while <code>solver_order=1</code> is equivalent to <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>.',_e,z,rt=`Dynamic thresholding from <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen</a> is supported, and for pixel-space
diffusion models, you can set <code>thresholding=True</code> to use the dynamic thresholding.`,ve,A,Se,l,V,Pe,Q,ot="<code>DEISMultistepScheduler</code> is a fast high order solver for diffusion ordinary differential equations (ODEs).",Oe,Z,nt=`This model inherits from <a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a> and <a href="/docs/diffusers/main/en/api/configuration#diffusers.ConfigMixin">ConfigMixin</a>. Check the superclass documentation for the generic
methods the library implements for all schedulers such as loading and saving.`,qe,$,N,ke,J,it="Convert the model output to the corresponding type the DEIS algorithm needs.",He,T,j,ze,X,at="One step for the first-order DEIS (equivalent to DDIM).",Ae,y,R,Ve,ee,dt="One step for the second-order multistep DEIS.",Ne,I,U,je,te,lt="One step for the third-order multistep DEIS.",Re,M,W,Ue,se,ct=`Ensures interchangeability with schedulers that need to scale the denoising model input depending on the
current timestep.`,We,E,B,Be,re,ut="Sets the discrete timesteps used for the diffusion chain (to be run before inference).",Ye,w,Y,Ge,oe,pt=`Predict the sample from the previous timestep by reversing the SDE. This function propagates the sample with
the multistep DEIS.`,be,G,xe,x,K,Ke,ne,mt="Base class for the output of a scheduler’s <code>step</code> function.",De,ae,$e;return C=new Le({props:{title:"DEISMultistepScheduler",local:"deismultistepscheduler",headingTag:"h1"}}),k=new Le({props:{title:"Tips",local:"tips",headingTag:"h2"}}),A=new Le({props:{title:"DEISMultistepScheduler",local:"diffusers.DEISMultistepScheduler",headingTag:"h2"}}),V=new D({props:{name:"class diffusers.DEISMultistepScheduler",anchor:"diffusers.DEISMultistepScheduler",parameters:[{name:"num_train_timesteps",val:": int = 1000"},{name:"beta_start",val:": float = 0.0001"},{name:"beta_end",val:": float = 0.02"},{name:"beta_schedule",val:": str = 'linear'"},{name:"trained_betas",val:": typing.Optional[numpy.ndarray] = None"},{name:"solver_order",val:": int = 2"},{name:"prediction_type",val:": str = 'epsilon'"},{name:"thresholding",val:": bool = False"},{name:"dynamic_thresholding_ratio",val:": float = 0.995"},{name:"sample_max_value",val:": float = 1.0"},{name:"algorithm_type",val:": str = 'deis'"},{name:"solver_type",val:": str = 'logrho'"},{name:"lower_order_final",val:": bool = True"},{name:"use_karras_sigmas",val:": typing.Optional[bool] = False"},{name:"timestep_spacing",val:": str = 'linspace'"},{name:"steps_offset",val:": int = 0"}],parametersDescription:[{anchor:"diffusers.DEISMultistepScheduler.num_train_timesteps",description:`<strong>num_train_timesteps</strong> (<code>int</code>, defaults to 1000) &#x2014;
The number of diffusion steps to train the model.`,name:"num_train_timesteps"},{anchor:"diffusers.DEISMultistepScheduler.beta_start",description:`<strong>beta_start</strong> (<code>float</code>, defaults to 0.0001) &#x2014;
The starting <code>beta</code> value of inference.`,name:"beta_start"},{anchor:"diffusers.DEISMultistepScheduler.beta_end",description:`<strong>beta_end</strong> (<code>float</code>, defaults to 0.02) &#x2014;
The final <code>beta</code> value.`,name:"beta_end"},{anchor:"diffusers.DEISMultistepScheduler.beta_schedule",description:`<strong>beta_schedule</strong> (<code>str</code>, defaults to <code>&quot;linear&quot;</code>) &#x2014;
The beta schedule, a mapping from a beta range to a sequence of betas for stepping the model. Choose from
<code>linear</code>, <code>scaled_linear</code>, or <code>squaredcos_cap_v2</code>.`,name:"beta_schedule"},{anchor:"diffusers.DEISMultistepScheduler.trained_betas",description:`<strong>trained_betas</strong> (<code>np.ndarray</code>, <em>optional</em>) &#x2014;
Pass an array of betas directly to the constructor to bypass <code>beta_start</code> and <code>beta_end</code>.`,name:"trained_betas"},{anchor:"diffusers.DEISMultistepScheduler.solver_order",description:`<strong>solver_order</strong> (<code>int</code>, defaults to 2) &#x2014;
The DEIS order which can be <code>1</code> or <code>2</code> or <code>3</code>. It is recommended to use <code>solver_order=2</code> for guided
sampling, and <code>solver_order=3</code> for unconditional sampling.`,name:"solver_order"},{anchor:"diffusers.DEISMultistepScheduler.prediction_type",description:`<strong>prediction_type</strong> (<code>str</code>, defaults to <code>epsilon</code>) &#x2014;
Prediction type of the scheduler function; can be <code>epsilon</code> (predicts the noise of the diffusion process),
<code>sample</code> (directly predicts the noisy sample<code>) or </code>v_prediction\` (see section 2.4 of <a href="https://imagen.research.google/video/paper.pdf" rel="nofollow">Imagen
Video</a> paper).`,name:"prediction_type"},{anchor:"diffusers.DEISMultistepScheduler.thresholding",description:`<strong>thresholding</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to use the &#x201C;dynamic thresholding&#x201D; method. This is unsuitable for latent-space diffusion models such
as Stable Diffusion.`,name:"thresholding"},{anchor:"diffusers.DEISMultistepScheduler.dynamic_thresholding_ratio",description:`<strong>dynamic_thresholding_ratio</strong> (<code>float</code>, defaults to 0.995) &#x2014;
The ratio for the dynamic thresholding method. Valid only when <code>thresholding=True</code>.`,name:"dynamic_thresholding_ratio"},{anchor:"diffusers.DEISMultistepScheduler.sample_max_value",description:`<strong>sample_max_value</strong> (<code>float</code>, defaults to 1.0) &#x2014;
The threshold value for dynamic thresholding. Valid only when <code>thresholding=True</code>.`,name:"sample_max_value"},{anchor:"diffusers.DEISMultistepScheduler.algorithm_type",description:`<strong>algorithm_type</strong> (<code>str</code>, defaults to <code>deis</code>) &#x2014;
The algorithm type for the solver.`,name:"algorithm_type"},{anchor:"diffusers.DEISMultistepScheduler.lower_order_final",description:`<strong>lower_order_final</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to use lower-order solvers in the final steps. Only valid for &lt; 15 inference steps.`,name:"lower_order_final"},{anchor:"diffusers.DEISMultistepScheduler.use_karras_sigmas",description:`<strong>use_karras_sigmas</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use Karras sigmas for step sizes in the noise schedule during the sampling process. If <code>True</code>,
the sigmas are determined according to a sequence of noise levels {&#x3C3;i}.`,name:"use_karras_sigmas"},{anchor:"diffusers.DEISMultistepScheduler.timestep_spacing",description:`<strong>timestep_spacing</strong> (<code>str</code>, defaults to <code>&quot;linspace&quot;</code>) &#x2014;
The way the timesteps should be scaled. Refer to Table 2 of the <a href="https://huggingface.co/papers/2305.08891" rel="nofollow">Common Diffusion Noise Schedules and
Sample Steps are Flawed</a> for more information.`,name:"timestep_spacing"},{anchor:"diffusers.DEISMultistepScheduler.steps_offset",description:`<strong>steps_offset</strong> (<code>int</code>, defaults to 0) &#x2014;
An offset added to the inference steps. You can use a combination of <code>offset=1</code> and
<code>set_alpha_to_one=False</code> to make the last step use step 0 for the previous alpha product like in Stable
Diffusion.`,name:"steps_offset"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_deis_multistep.py#L74"}}),N=new D({props:{name:"convert_model_output",anchor:"diffusers.DEISMultistepScheduler.convert_model_output",parameters:[{name:"model_output",val:": FloatTensor"},{name:"*args",val:""},{name:"sample",val:": FloatTensor = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DEISMultistepScheduler.convert_model_output.model_output",description:`<strong>model_output</strong> (<code>torch.FloatTensor</code>) &#x2014;
The direct output from the learned diffusion model.`,name:"model_output"},{anchor:"diffusers.DEISMultistepScheduler.convert_model_output.timestep",description:`<strong>timestep</strong> (<code>int</code>) &#x2014;
The current discrete timestep in the diffusion chain.`,name:"timestep"},{anchor:"diffusers.DEISMultistepScheduler.convert_model_output.sample",description:`<strong>sample</strong> (<code>torch.FloatTensor</code>) &#x2014;
A current instance of a sample created by the diffusion process.`,name:"sample"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_deis_multistep.py#L338",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The converted model output.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code></p>
`}}),j=new D({props:{name:"deis_first_order_update",anchor:"diffusers.DEISMultistepScheduler.deis_first_order_update",parameters:[{name:"model_output",val:": FloatTensor"},{name:"*args",val:""},{name:"sample",val:": FloatTensor = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DEISMultistepScheduler.deis_first_order_update.model_output",description:`<strong>model_output</strong> (<code>torch.FloatTensor</code>) &#x2014;
The direct output from the learned diffusion model.`,name:"model_output"},{anchor:"diffusers.DEISMultistepScheduler.deis_first_order_update.timestep",description:`<strong>timestep</strong> (<code>int</code>) &#x2014;
The current discrete timestep in the diffusion chain.`,name:"timestep"},{anchor:"diffusers.DEISMultistepScheduler.deis_first_order_update.prev_timestep",description:`<strong>prev_timestep</strong> (<code>int</code>) &#x2014;
The previous discrete timestep in the diffusion chain.`,name:"prev_timestep"},{anchor:"diffusers.DEISMultistepScheduler.deis_first_order_update.sample",description:`<strong>sample</strong> (<code>torch.FloatTensor</code>) &#x2014;
A current instance of a sample created by the diffusion process.`,name:"sample"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_deis_multistep.py#L395",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The sample tensor at the previous timestep.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code></p>
`}}),R=new D({props:{name:"multistep_deis_second_order_update",anchor:"diffusers.DEISMultistepScheduler.multistep_deis_second_order_update",parameters:[{name:"model_output_list",val:": typing.List[torch.FloatTensor]"},{name:"*args",val:""},{name:"sample",val:": FloatTensor = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DEISMultistepScheduler.multistep_deis_second_order_update.model_output_list",description:`<strong>model_output_list</strong> (<code>List[torch.FloatTensor]</code>) &#x2014;
The direct outputs from learned diffusion model at current and latter timesteps.`,name:"model_output_list"},{anchor:"diffusers.DEISMultistepScheduler.multistep_deis_second_order_update.sample",description:`<strong>sample</strong> (<code>torch.FloatTensor</code>) &#x2014;
A current instance of a sample created by the diffusion process.`,name:"sample"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_deis_multistep.py#L453",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The sample tensor at the previous timestep.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code></p>
`}}),U=new D({props:{name:"multistep_deis_third_order_update",anchor:"diffusers.DEISMultistepScheduler.multistep_deis_third_order_update",parameters:[{name:"model_output_list",val:": typing.List[torch.FloatTensor]"},{name:"*args",val:""},{name:"sample",val:": FloatTensor = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DEISMultistepScheduler.multistep_deis_third_order_update.model_output_list",description:`<strong>model_output_list</strong> (<code>List[torch.FloatTensor]</code>) &#x2014;
The direct outputs from learned diffusion model at current and latter timesteps.`,name:"model_output_list"},{anchor:"diffusers.DEISMultistepScheduler.multistep_deis_third_order_update.sample",description:`<strong>sample</strong> (<code>torch.FloatTensor</code>) &#x2014;
A current instance of a sample created by diffusion process.`,name:"sample"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_deis_multistep.py#L522",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The sample tensor at the previous timestep.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code></p>
`}}),W=new D({props:{name:"scale_model_input",anchor:"diffusers.DEISMultistepScheduler.scale_model_input",parameters:[{name:"sample",val:": FloatTensor"},{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DEISMultistepScheduler.scale_model_input.sample",description:`<strong>sample</strong> (<code>torch.FloatTensor</code>) &#x2014;
The input sample.`,name:"sample"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_deis_multistep.py#L694",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A scaled input sample.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code></p>
`}}),B=new D({props:{name:"set_timesteps",anchor:"diffusers.DEISMultistepScheduler.set_timesteps",parameters:[{name:"num_inference_steps",val:": int"},{name:"device",val:": typing.Union[str, torch.device] = None"}],parametersDescription:[{anchor:"diffusers.DEISMultistepScheduler.set_timesteps.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>) &#x2014;
The number of diffusion steps used when generating samples with a pre-trained model.`,name:"num_inference_steps"},{anchor:"diffusers.DEISMultistepScheduler.set_timesteps.device",description:`<strong>device</strong> (<code>str</code> or <code>torch.device</code>, <em>optional</em>) &#x2014;
The device to which the timesteps should be moved to. If <code>None</code>, the timesteps are not moved.`,name:"device"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_deis_multistep.py#L199"}}),Y=new D({props:{name:"step",anchor:"diffusers.DEISMultistepScheduler.step",parameters:[{name:"model_output",val:": FloatTensor"},{name:"timestep",val:": int"},{name:"sample",val:": FloatTensor"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.DEISMultistepScheduler.step.model_output",description:`<strong>model_output</strong> (<code>torch.FloatTensor</code>) &#x2014;
The direct output from learned diffusion model.`,name:"model_output"},{anchor:"diffusers.DEISMultistepScheduler.step.timestep",description:`<strong>timestep</strong> (<code>float</code>) &#x2014;
The current discrete timestep in the diffusion chain.`,name:"timestep"},{anchor:"diffusers.DEISMultistepScheduler.step.sample",description:`<strong>sample</strong> (<code>torch.FloatTensor</code>) &#x2014;
A current instance of a sample created by the diffusion process.`,name:"sample"},{anchor:"diffusers.DEISMultistepScheduler.step.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/schedulers/dpm_discrete#diffusers.schedulers.scheduling_utils.SchedulerOutput">SchedulerOutput</a> or <code>tuple</code>.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_deis_multistep.py#L629",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If return_dict is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/schedulers/dpm_discrete#diffusers.schedulers.scheduling_utils.SchedulerOutput"
>SchedulerOutput</a> is returned, otherwise a
tuple is returned where the first element is the sample tensor.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/schedulers/dpm_discrete#diffusers.schedulers.scheduling_utils.SchedulerOutput"
>SchedulerOutput</a> or <code>tuple</code></p>
`}}),G=new Le({props:{title:"SchedulerOutput",local:"diffusers.schedulers.scheduling_utils.SchedulerOutput",headingTag:"h2"}}),K=new D({props:{name:"class diffusers.schedulers.scheduling_utils.SchedulerOutput",anchor:"diffusers.schedulers.scheduling_utils.SchedulerOutput",parameters:[{name:"prev_sample",val:": FloatTensor"}],parametersDescription:[{anchor:"diffusers.schedulers.scheduling_utils.SchedulerOutput.prev_sample",description:`<strong>prev_sample</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code> for images) &#x2014;
Computed sample <code>(x_{t-1})</code> of previous timestep. <code>prev_sample</code> should be used as next model input in the
denoising loop.`,name:"prev_sample"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_utils.py#L50"}}),{c(){b=i("meta"),de=o(),ie=i("p"),le=o(),p(C.$$.fragment),ce=o(),F=i("p"),F.innerHTML=Ze,ue=o(),L=i("p"),L.innerHTML=Je,pe=o(),P=i("p"),P.textContent=Xe,me=o(),O=i("p"),O.innerHTML=et,fe=o(),q=i("p"),q.innerHTML=tt,he=o(),p(k.$$.fragment),ge=o(),H=i("p"),H.innerHTML=st,_e=o(),z=i("p"),z.innerHTML=rt,ve=o(),p(A.$$.fragment),Se=o(),l=i("div"),p(V.$$.fragment),Pe=o(),Q=i("p"),Q.innerHTML=ot,Oe=o(),Z=i("p"),Z.innerHTML=nt,qe=o(),$=i("div"),p(N.$$.fragment),ke=o(),J=i("p"),J.textContent=it,He=o(),T=i("div"),p(j.$$.fragment),ze=o(),X=i("p"),X.textContent=at,Ae=o(),y=i("div"),p(R.$$.fragment),Ve=o(),ee=i("p"),ee.textContent=dt,Ne=o(),I=i("div"),p(U.$$.fragment),je=o(),te=i("p"),te.textContent=lt,Re=o(),M=i("div"),p(W.$$.fragment),Ue=o(),se=i("p"),se.textContent=ct,We=o(),E=i("div"),p(B.$$.fragment),Be=o(),re=i("p"),re.textContent=ut,Ye=o(),w=i("div"),p(Y.$$.fragment),Ge=o(),oe=i("p"),oe.textContent=pt,be=o(),p(G.$$.fragment),xe=o(),x=i("div"),p(K.$$.fragment),Ke=o(),ne=i("p"),ne.innerHTML=mt,De=o(),ae=i("p"),this.h()},l(e){const r=St("svelte-u9bgzb",document.head);b=a(r,"META",{name:!0,content:!0}),r.forEach(t),de=n(e),ie=a(e,"P",{}),v(ie).forEach(t),le=n(e),m(C.$$.fragment,e),ce=n(e),F=a(e,"P",{"data-svelte-h":!0}),u(F)!=="svelte-hu1v06"&&(F.innerHTML=Ze),ue=n(e),L=a(e,"P",{"data-svelte-h":!0}),u(L)!=="svelte-2kur53"&&(L.innerHTML=Je),pe=n(e),P=a(e,"P",{"data-svelte-h":!0}),u(P)!=="svelte-1cwsb16"&&(P.textContent=Xe),me=n(e),O=a(e,"P",{"data-svelte-h":!0}),u(O)!=="svelte-1qgxh8f"&&(O.innerHTML=et),fe=n(e),q=a(e,"P",{"data-svelte-h":!0}),u(q)!=="svelte-7biw7t"&&(q.innerHTML=tt),he=n(e),m(k.$$.fragment,e),ge=n(e),H=a(e,"P",{"data-svelte-h":!0}),u(H)!=="svelte-1wcaqyo"&&(H.innerHTML=st),_e=n(e),z=a(e,"P",{"data-svelte-h":!0}),u(z)!=="svelte-jfe2b1"&&(z.innerHTML=rt),ve=n(e),m(A.$$.fragment,e),Se=n(e),l=a(e,"DIV",{class:!0});var c=v(l);m(V.$$.fragment,c),Pe=n(c),Q=a(c,"P",{"data-svelte-h":!0}),u(Q)!=="svelte-1maiz98"&&(Q.innerHTML=ot),Oe=n(c),Z=a(c,"P",{"data-svelte-h":!0}),u(Z)!=="svelte-linuuh"&&(Z.innerHTML=nt),qe=n(c),$=a(c,"DIV",{class:!0});var Te=v($);m(N.$$.fragment,Te),ke=n(Te),J=a(Te,"P",{"data-svelte-h":!0}),u(J)!=="svelte-10z04zf"&&(J.textContent=it),Te.forEach(t),He=n(c),T=a(c,"DIV",{class:!0});var ye=v(T);m(j.$$.fragment,ye),ze=n(ye),X=a(ye,"P",{"data-svelte-h":!0}),u(X)!=="svelte-9410ii"&&(X.textContent=at),ye.forEach(t),Ae=n(c),y=a(c,"DIV",{class:!0});var Ie=v(y);m(R.$$.fragment,Ie),Ve=n(Ie),ee=a(Ie,"P",{"data-svelte-h":!0}),u(ee)!=="svelte-4wni6b"&&(ee.textContent=dt),Ie.forEach(t),Ne=n(c),I=a(c,"DIV",{class:!0});var Me=v(I);m(U.$$.fragment,Me),je=n(Me),te=a(Me,"P",{"data-svelte-h":!0}),u(te)!=="svelte-cktso6"&&(te.textContent=lt),Me.forEach(t),Re=n(c),M=a(c,"DIV",{class:!0});var Ee=v(M);m(W.$$.fragment,Ee),Ue=n(Ee),se=a(Ee,"P",{"data-svelte-h":!0}),u(se)!=="svelte-1rkfgpx"&&(se.textContent=ct),Ee.forEach(t),We=n(c),E=a(c,"DIV",{class:!0});var we=v(E);m(B.$$.fragment,we),Be=n(we),re=a(we,"P",{"data-svelte-h":!0}),u(re)!=="svelte-1vzm9q"&&(re.textContent=ut),we.forEach(t),Ye=n(c),w=a(c,"DIV",{class:!0});var Ce=v(w);m(Y.$$.fragment,Ce),Ge=n(Ce),oe=a(Ce,"P",{"data-svelte-h":!0}),u(oe)!=="svelte-vbpl4u"&&(oe.textContent=pt),Ce.forEach(t),c.forEach(t),be=n(e),m(G.$$.fragment,e),xe=n(e),x=a(e,"DIV",{class:!0});var Fe=v(x);m(K.$$.fragment,Fe),Ke=n(Fe),ne=a(Fe,"P",{"data-svelte-h":!0}),u(ne)!=="svelte-6ojmkw"&&(ne.innerHTML=mt),Fe.forEach(t),De=n(e),ae=a(e,"P",{}),v(ae).forEach(t),this.h()},h(){S(b,"name","hf:doc:metadata"),S(b,"content",xt),S($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(l,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,r){s(document.head,b),d(e,de,r),d(e,ie,r),d(e,le,r),f(C,e,r),d(e,ce,r),d(e,F,r),d(e,ue,r),d(e,L,r),d(e,pe,r),d(e,P,r),d(e,me,r),d(e,O,r),d(e,fe,r),d(e,q,r),d(e,he,r),f(k,e,r),d(e,ge,r),d(e,H,r),d(e,_e,r),d(e,z,r),d(e,ve,r),f(A,e,r),d(e,Se,r),d(e,l,r),f(V,l,null),s(l,Pe),s(l,Q),s(l,Oe),s(l,Z),s(l,qe),s(l,$),f(N,$,null),s($,ke),s($,J),s(l,He),s(l,T),f(j,T,null),s(T,ze),s(T,X),s(l,Ae),s(l,y),f(R,y,null),s(y,Ve),s(y,ee),s(l,Ne),s(l,I),f(U,I,null),s(I,je),s(I,te),s(l,Re),s(l,M),f(W,M,null),s(M,Ue),s(M,se),s(l,We),s(l,E),f(B,E,null),s(E,Be),s(E,re),s(l,Ye),s(l,w),f(Y,w,null),s(w,Ge),s(w,oe),d(e,be,r),f(G,e,r),d(e,xe,r),d(e,x,r),f(K,x,null),s(x,Ke),s(x,ne),d(e,De,r),d(e,ae,r),$e=!0},p:ht,i(e){$e||(h(C.$$.fragment,e),h(k.$$.fragment,e),h(A.$$.fragment,e),h(V.$$.fragment,e),h(N.$$.fragment,e),h(j.$$.fragment,e),h(R.$$.fragment,e),h(U.$$.fragment,e),h(W.$$.fragment,e),h(B.$$.fragment,e),h(Y.$$.fragment,e),h(G.$$.fragment,e),h(K.$$.fragment,e),$e=!0)},o(e){g(C.$$.fragment,e),g(k.$$.fragment,e),g(A.$$.fragment,e),g(V.$$.fragment,e),g(N.$$.fragment,e),g(j.$$.fragment,e),g(R.$$.fragment,e),g(U.$$.fragment,e),g(W.$$.fragment,e),g(B.$$.fragment,e),g(Y.$$.fragment,e),g(G.$$.fragment,e),g(K.$$.fragment,e),$e=!1},d(e){e&&(t(de),t(ie),t(le),t(ce),t(F),t(ue),t(L),t(pe),t(P),t(me),t(O),t(fe),t(q),t(he),t(ge),t(H),t(_e),t(z),t(ve),t(Se),t(l),t(be),t(xe),t(x),t(De),t(ae)),t(b),_(C,e),_(k,e),_(A,e),_(V),_(N),_(j),_(R),_(U),_(W),_(B),_(Y),_(G,e),_(K)}}}const xt='{"title":"DEISMultistepScheduler","local":"deismultistepscheduler","sections":[{"title":"Tips","local":"tips","sections":[],"depth":2},{"title":"DEISMultistepScheduler","local":"diffusers.DEISMultistepScheduler","sections":[],"depth":2},{"title":"SchedulerOutput","local":"diffusers.schedulers.scheduling_utils.SchedulerOutput","sections":[],"depth":2}],"depth":1}';function Dt(Qe){return gt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Mt extends _t{constructor(b){super(),vt(this,b,Dt,bt,ft,{})}}export{Mt as component};
