import{s as xt,o as Tt,n as we}from"../chunks/scheduler.182ea377.js";import{S as Mt,i as Ut,g as c,s as o,r as b,A as It,h as d,f as l,c as i,j as S,u as y,x as T,k as D,y as s,a as g,v,d as w,t as $,w as x}from"../chunks/index.abf12888.js";import{T as ot}from"../chunks/Tip.230e2334.js";import{D as C}from"../chunks/Docstring.93f6f462.js";import{C as rt}from"../chunks/CodeBlock.57fe6e13.js";import{E as it}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as lt}from"../chunks/Heading.16916d63.js";function Pt(M){let n,_='Make sure to check out the Stable Diffusion <a href="overview#tips">Tips</a> section to learn how to explore the tradeoff between scheduler speed and quality, and how to reuse pipeline components efficiently!',r,a,m='If you’re interested in using one of the official checkpoints for a task, explore the <a href="https://huggingface.co/CompVis" rel="nofollow">CompVis</a>, <a href="https://huggingface.co/runwayml" rel="nofollow">Runway</a>, and <a href="https://huggingface.co/stabilityai" rel="nofollow">Stability AI</a> Hub organizations!';return{c(){n=c("p"),n.innerHTML=_,r=o(),a=c("p"),a.innerHTML=m},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1ue9xpl"&&(n.innerHTML=_),r=i(t),a=d(t,"P",{"data-svelte-h":!0}),T(a)!=="svelte-z4pn9c"&&(a.innerHTML=m)},m(t,h){g(t,n,h),g(t,r,h),g(t,a,h)},p:we,d(t){t&&(l(n),l(r),l(a))}}}function St(M){let n,_="Examples:",r,a,m;return a=new rt({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwaW8lMjBpbXBvcnQlMjBCeXRlc0lPJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblVwc2NhbGVQaXBlbGluZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBJTIzJTIwbG9hZCUyMG1vZGVsJTIwYW5kJTIwc2NoZWR1bGVyJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teDQtdXBzY2FsZXIlMjIlMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblVwc2NhbGVQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMjByZXZpc2lvbiUzRCUyMmZwMTYlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBcGlwZWxpbmUlMjAlM0QlMjBwaXBlbGluZS50byglMjJjdWRhJTIyKSUwQSUwQSUyMyUyMGxldCdzJTIwZG93bmxvYWQlMjBhbiUyMCUyMGltYWdlJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnNkMi11cHNjYWxlJTJGbG93X3Jlc19jYXQucG5nJTIyJTBBcmVzcG9uc2UlMjAlM0QlMjByZXF1ZXN0cy5nZXQodXJsKSUwQWxvd19yZXNfaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihCeXRlc0lPKHJlc3BvbnNlLmNvbnRlbnQpKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFsb3dfcmVzX2ltZyUyMCUzRCUyMGxvd19yZXNfaW1nLnJlc2l6ZSgoMTI4JTJDJTIwMTI4KSklMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwd2hpdGUlMjBjYXQlMjIlMEElMEF1cHNjYWxlZF9pbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEbG93X3Jlc19pbWcpLmltYWdlcyU1QjAlNUQlMEF1cHNjYWxlZF9pbWFnZS5zYXZlKCUyMnVwc2FtcGxlZF9jYXQucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionUpscalePipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load model and scheduler</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-x4-upscaler&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionUpscalePipeline.from_pretrained(
<span class="hljs-meta">... </span>    model_id, revision=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># let&#x27;s download an  image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/sd2-upscale/low_res_cat.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>response = requests.get(url)
<span class="hljs-meta">&gt;&gt;&gt; </span>low_res_img = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>low_res_img = low_res_img.resize((<span class="hljs-number">128</span>, <span class="hljs-number">128</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a white cat&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>upscaled_image = pipeline(prompt=prompt, image=low_res_img).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>upscaled_image.save(<span class="hljs-string">&quot;upsampled_cat.png&quot;</span>)`,wrap:!1}}),{c(){n=c("p"),n.textContent=_,r=o(),b(a.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-kvfsh7"&&(n.textContent=_),r=i(t),y(a.$$.fragment,t)},m(t,h){g(t,n,h),g(t,r,h),v(a,t,h),m=!0},p:we,i(t){m||(w(a.$$.fragment,t),m=!0)},o(t){$(a.$$.fragment,t),m=!1},d(t){t&&(l(n),l(r)),x(a,t)}}}function Dt(M){let n,_=`⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA) from PyTorch
2.0 or xFormers. These attention computations are already very memory efficient so you won’t need to enable
this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious slow downs!`;return{c(){n=c("p"),n.innerHTML=_},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-ackzsn"&&(n.innerHTML=_)},m(r,a){g(r,n,a)},p:we,d(r){r&&l(n)}}}function Jt(M){let n,_="Examples:",r,a,m;return a=new rt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfYXR0ZW50aW9uX3NsaWNpbmcoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){n=c("p"),n.textContent=_,r=o(),b(a.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-kvfsh7"&&(n.textContent=_),r=i(t),y(a.$$.fragment,t)},m(t,h){g(t,n,h),g(t,r,h),v(a,t,h),m=!0},p:we,i(t){m||(w(a.$$.fragment,t),m=!0)},o(t){$(a.$$.fragment,t),m=!1},d(t){t&&(l(n),l(r)),x(a,t)}}}function jt(M){let n,_=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){n=c("p"),n.textContent=_},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-17p1lpg"&&(n.textContent=_)},m(r,a){g(r,n,a)},p:we,d(r){r&&l(n)}}}function kt(M){let n,_="Examples:",r,a,m;return a=new rt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`,wrap:!1}}),{c(){n=c("p"),n.textContent=_,r=o(),b(a.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-kvfsh7"&&(n.textContent=_),r=i(t),y(a.$$.fragment,t)},m(t,h){g(t,n,h),g(t,r,h),v(a,t,h),m=!0},p:we,i(t){m||(w(a.$$.fragment,t),m=!0)},o(t){$(a.$$.fragment,t),m=!1},d(t){t&&(l(n),l(r)),x(a,t)}}}function Ct(M){let n,_,r,a,m,t,h,pt='The Stable Diffusion upscaler diffusion model was created by the researchers and engineers from <a href="https://github.com/CompVis" rel="nofollow">CompVis</a>, <a href="https://stability.ai/" rel="nofollow">Stability AI</a>, and <a href="https://laion.ai/" rel="nofollow">LAION</a>. It is used to enhance the resolution of input images by a factor of 4.',xe,G,Te,Q,Me,f,H,ke,re,ct="Pipeline for text-guided image super-resolution using Stable Diffusion 2.",Ce,pe,dt=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Ze,k,Y,We,ce,ft="The call function to the pipeline for generation.",Ge,L,Le,U,q,Ne,de,mt=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,Fe,N,Be,F,Xe,B,O,Ee,fe,ut=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,Ve,I,K,ze,me,gt=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,Re,X,Ae,E,Qe,V,ee,He,ue,ht='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',Ye,z,te,qe,ge,_t="Disables the FreeU mechanism if enabled.",Oe,P,ne,Ke,he,bt='Enables the FreeU mechanism as in <a href="https://arxiv.org/abs/2309.11497" rel="nofollow">https://arxiv.org/abs/2309.11497</a>.',et,_e,yt="The suffixes after the scaling factors represent the stages where they are being applied.",tt,be,vt=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,nt,R,se,st,ye,wt="Encodes the prompt into text encoder hidden states.",Ue,ae,Ie,Z,oe,at,ve,$t="Output class for Stable Diffusion pipelines.",Pe,$e,Se;return m=new lt({props:{title:"Super-resolution",local:"super-resolution",headingTag:"h1"}}),G=new ot({props:{$$slots:{default:[Pt]},$$scope:{ctx:M}}}),Q=new lt({props:{title:"StableDiffusionUpscalePipeline",local:"diffusers.StableDiffusionUpscalePipeline",headingTag:"h2"}}),H=new C({props:{name:"class diffusers.StableDiffusionUpscalePipeline",anchor:"diffusers.StableDiffusionUpscalePipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"low_res_scheduler",val:": DDPMScheduler"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"safety_checker",val:": typing.Optional[typing.Any] = None"},{name:"feature_extractor",val:": typing.Optional[transformers.models.clip.image_processing_clip.CLIPImageProcessor] = None"},{name:"watermarker",val:": typing.Optional[typing.Any] = None"},{name:"max_noise_level",val:": int = 350"}],parametersDescription:[{anchor:"diffusers.StableDiffusionUpscalePipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionUpscalePipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionUpscalePipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionUpscalePipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionUpscalePipeline.low_res_scheduler",description:`<strong>low_res_scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler used to add initial noise to the low resolution conditioning image. It must be an instance of
<a href="/docs/diffusers/main/en/api/schedulers/ddpm#diffusers.DDPMScheduler">DDPMScheduler</a>.`,name:"low_res_scheduler"},{anchor:"diffusers.StableDiffusionUpscalePipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_upscale.py#L70"}}),Y=new C({props:{name:"__call__",anchor:"diffusers.StableDiffusionUpscalePipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.FloatTensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.FloatTensor]] = None"},{name:"num_inference_steps",val:": int = 75"},{name:"guidance_scale",val:": float = 9.0"},{name:"noise_level",val:": int = 20"},{name:"negative_prompt",val:": typing.Union[typing.List[str], str, NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, torch.FloatTensor], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"clip_skip",val:": int = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code> or tensor representing an image batch to be upscaled.`,name:"image"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/image_variation#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_upscale.py#L554",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/image_variation#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/image_variation#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),L=new it({props:{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.example",$$slots:{default:[St]},$$scope:{ctx:M}}}),q=new C({props:{name:"enable_attention_slicing",anchor:"diffusers.StableDiffusionUpscalePipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": typing.Union[str, int, NoneType] = 'auto'"}],parametersDescription:[{anchor:"diffusers.StableDiffusionUpscalePipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2027"}}),N=new ot({props:{warning:!0,$$slots:{default:[Dt]},$$scope:{ctx:M}}}),F=new it({props:{anchor:"diffusers.StableDiffusionUpscalePipeline.enable_attention_slicing.example",$$slots:{default:[Jt]},$$scope:{ctx:M}}}),O=new C({props:{name:"disable_attention_slicing",anchor:"diffusers.StableDiffusionUpscalePipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2067"}}),K=new C({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionUpscalePipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": typing.Optional[typing.Callable] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionUpscalePipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1966"}}),X=new ot({props:{warning:!0,$$slots:{default:[jt]},$$scope:{ctx:M}}}),E=new it({props:{anchor:"diffusers.StableDiffusionUpscalePipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[kt]},$$scope:{ctx:M}}}),ee=new C({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionUpscalePipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2001"}}),te=new C({props:{name:"disable_freeu",anchor:"diffusers.StableDiffusionUpscalePipeline.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_upscale.py#L550"}}),ne=new C({props:{name:"enable_freeu",anchor:"diffusers.StableDiffusionUpscalePipeline.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.StableDiffusionUpscalePipeline.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.StableDiffusionUpscalePipeline.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.StableDiffusionUpscalePipeline.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.StableDiffusionUpscalePipeline.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_upscale.py#L527"}}),se=new C({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionUpscalePipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"lora_scale",val:": typing.Optional[float] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionUpscalePipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.StableDiffusionUpscalePipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionUpscalePipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionUpscalePipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionUpscalePipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionUpscalePipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionUpscalePipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionUpscalePipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_upscale.py#L198"}}),ae=new lt({props:{title:"StableDiffusionPipelineOutput",local:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",headingTag:"h2"}}),oe=new C({props:{name:"class diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",parameters:[{name:"images",val:": typing.Union[typing.List[PIL.Image.Image], numpy.ndarray]"},{name:"nsfw_content_detected",val:": typing.Optional[typing.List[bool]]"}],parametersDescription:[{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content or
<code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_output.py#L11"}}),{c(){n=c("meta"),_=o(),r=c("p"),a=o(),b(m.$$.fragment),t=o(),h=c("p"),h.innerHTML=pt,xe=o(),b(G.$$.fragment),Te=o(),b(Q.$$.fragment),Me=o(),f=c("div"),b(H.$$.fragment),ke=o(),re=c("p"),re.textContent=ct,Ce=o(),pe=c("p"),pe.innerHTML=dt,Ze=o(),k=c("div"),b(Y.$$.fragment),We=o(),ce=c("p"),ce.textContent=ft,Ge=o(),b(L.$$.fragment),Le=o(),U=c("div"),b(q.$$.fragment),Ne=o(),de=c("p"),de.textContent=mt,Fe=o(),b(N.$$.fragment),Be=o(),b(F.$$.fragment),Xe=o(),B=c("div"),b(O.$$.fragment),Ee=o(),fe=c("p"),fe.innerHTML=ut,Ve=o(),I=c("div"),b(K.$$.fragment),ze=o(),me=c("p"),me.innerHTML=gt,Re=o(),b(X.$$.fragment),Ae=o(),b(E.$$.fragment),Qe=o(),V=c("div"),b(ee.$$.fragment),He=o(),ue=c("p"),ue.innerHTML=ht,Ye=o(),z=c("div"),b(te.$$.fragment),qe=o(),ge=c("p"),ge.textContent=_t,Oe=o(),P=c("div"),b(ne.$$.fragment),Ke=o(),he=c("p"),he.innerHTML=bt,et=o(),_e=c("p"),_e.textContent=yt,tt=o(),be=c("p"),be.innerHTML=vt,nt=o(),R=c("div"),b(se.$$.fragment),st=o(),ye=c("p"),ye.textContent=wt,Ue=o(),b(ae.$$.fragment),Ie=o(),Z=c("div"),b(oe.$$.fragment),at=o(),ve=c("p"),ve.textContent=$t,Pe=o(),$e=c("p"),this.h()},l(e){const p=It("svelte-u9bgzb",document.head);n=d(p,"META",{name:!0,content:!0}),p.forEach(l),_=i(e),r=d(e,"P",{}),S(r).forEach(l),a=i(e),y(m.$$.fragment,e),t=i(e),h=d(e,"P",{"data-svelte-h":!0}),T(h)!=="svelte-1rmru20"&&(h.innerHTML=pt),xe=i(e),y(G.$$.fragment,e),Te=i(e),y(Q.$$.fragment,e),Me=i(e),f=d(e,"DIV",{class:!0});var u=S(f);y(H.$$.fragment,u),ke=i(u),re=d(u,"P",{"data-svelte-h":!0}),T(re)!=="svelte-gmgvzq"&&(re.textContent=ct),Ce=i(u),pe=d(u,"P",{"data-svelte-h":!0}),T(pe)!=="svelte-496sm0"&&(pe.innerHTML=dt),Ze=i(u),k=d(u,"DIV",{class:!0});var W=S(k);y(Y.$$.fragment,W),We=i(W),ce=d(W,"P",{"data-svelte-h":!0}),T(ce)!=="svelte-50j04k"&&(ce.textContent=ft),Ge=i(W),y(L.$$.fragment,W),W.forEach(l),Le=i(u),U=d(u,"DIV",{class:!0});var J=S(U);y(q.$$.fragment,J),Ne=i(J),de=d(J,"P",{"data-svelte-h":!0}),T(de)!=="svelte-10jaql7"&&(de.textContent=mt),Fe=i(J),y(N.$$.fragment,J),Be=i(J),y(F.$$.fragment,J),J.forEach(l),Xe=i(u),B=d(u,"DIV",{class:!0});var ie=S(B);y(O.$$.fragment,ie),Ee=i(ie),fe=d(ie,"P",{"data-svelte-h":!0}),T(fe)!=="svelte-1lh0nh5"&&(fe.innerHTML=ut),ie.forEach(l),Ve=i(u),I=d(u,"DIV",{class:!0});var j=S(I);y(K.$$.fragment,j),ze=i(j),me=d(j,"P",{"data-svelte-h":!0}),T(me)!=="svelte-e03q3e"&&(me.innerHTML=gt),Re=i(j),y(X.$$.fragment,j),Ae=i(j),y(E.$$.fragment,j),j.forEach(l),Qe=i(u),V=d(u,"DIV",{class:!0});var le=S(V);y(ee.$$.fragment,le),He=i(le),ue=d(le,"P",{"data-svelte-h":!0}),T(ue)!=="svelte-1vfte1e"&&(ue.innerHTML=ht),le.forEach(l),Ye=i(u),z=d(u,"DIV",{class:!0});var De=S(z);y(te.$$.fragment,De),qe=i(De),ge=d(De,"P",{"data-svelte-h":!0}),T(ge)!=="svelte-psupw6"&&(ge.textContent=_t),De.forEach(l),Oe=i(u),P=d(u,"DIV",{class:!0});var A=S(P);y(ne.$$.fragment,A),Ke=i(A),he=d(A,"P",{"data-svelte-h":!0}),T(he)!=="svelte-1f3tmq1"&&(he.innerHTML=bt),et=i(A),_e=d(A,"P",{"data-svelte-h":!0}),T(_e)!=="svelte-xjijlp"&&(_e.textContent=yt),tt=i(A),be=d(A,"P",{"data-svelte-h":!0}),T(be)!=="svelte-hy0nzs"&&(be.innerHTML=vt),A.forEach(l),nt=i(u),R=d(u,"DIV",{class:!0});var Je=S(R);y(se.$$.fragment,Je),st=i(Je),ye=d(Je,"P",{"data-svelte-h":!0}),T(ye)!=="svelte-16q0ax1"&&(ye.textContent=wt),Je.forEach(l),u.forEach(l),Ue=i(e),y(ae.$$.fragment,e),Ie=i(e),Z=d(e,"DIV",{class:!0});var je=S(Z);y(oe.$$.fragment,je),at=i(je),ve=d(je,"P",{"data-svelte-h":!0}),T(ve)!=="svelte-1qpjiuf"&&(ve.textContent=$t),je.forEach(l),Pe=i(e),$e=d(e,"P",{}),S($e).forEach(l),this.h()},h(){D(n,"name","hf:doc:metadata"),D(n,"content",Zt),D(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(f,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,p){s(document.head,n),g(e,_,p),g(e,r,p),g(e,a,p),v(m,e,p),g(e,t,p),g(e,h,p),g(e,xe,p),v(G,e,p),g(e,Te,p),v(Q,e,p),g(e,Me,p),g(e,f,p),v(H,f,null),s(f,ke),s(f,re),s(f,Ce),s(f,pe),s(f,Ze),s(f,k),v(Y,k,null),s(k,We),s(k,ce),s(k,Ge),v(L,k,null),s(f,Le),s(f,U),v(q,U,null),s(U,Ne),s(U,de),s(U,Fe),v(N,U,null),s(U,Be),v(F,U,null),s(f,Xe),s(f,B),v(O,B,null),s(B,Ee),s(B,fe),s(f,Ve),s(f,I),v(K,I,null),s(I,ze),s(I,me),s(I,Re),v(X,I,null),s(I,Ae),v(E,I,null),s(f,Qe),s(f,V),v(ee,V,null),s(V,He),s(V,ue),s(f,Ye),s(f,z),v(te,z,null),s(z,qe),s(z,ge),s(f,Oe),s(f,P),v(ne,P,null),s(P,Ke),s(P,he),s(P,et),s(P,_e),s(P,tt),s(P,be),s(f,nt),s(f,R),v(se,R,null),s(R,st),s(R,ye),g(e,Ue,p),v(ae,e,p),g(e,Ie,p),g(e,Z,p),v(oe,Z,null),s(Z,at),s(Z,ve),g(e,Pe,p),g(e,$e,p),Se=!0},p(e,[p]){const u={};p&2&&(u.$$scope={dirty:p,ctx:e}),G.$set(u);const W={};p&2&&(W.$$scope={dirty:p,ctx:e}),L.$set(W);const J={};p&2&&(J.$$scope={dirty:p,ctx:e}),N.$set(J);const ie={};p&2&&(ie.$$scope={dirty:p,ctx:e}),F.$set(ie);const j={};p&2&&(j.$$scope={dirty:p,ctx:e}),X.$set(j);const le={};p&2&&(le.$$scope={dirty:p,ctx:e}),E.$set(le)},i(e){Se||(w(m.$$.fragment,e),w(G.$$.fragment,e),w(Q.$$.fragment,e),w(H.$$.fragment,e),w(Y.$$.fragment,e),w(L.$$.fragment,e),w(q.$$.fragment,e),w(N.$$.fragment,e),w(F.$$.fragment,e),w(O.$$.fragment,e),w(K.$$.fragment,e),w(X.$$.fragment,e),w(E.$$.fragment,e),w(ee.$$.fragment,e),w(te.$$.fragment,e),w(ne.$$.fragment,e),w(se.$$.fragment,e),w(ae.$$.fragment,e),w(oe.$$.fragment,e),Se=!0)},o(e){$(m.$$.fragment,e),$(G.$$.fragment,e),$(Q.$$.fragment,e),$(H.$$.fragment,e),$(Y.$$.fragment,e),$(L.$$.fragment,e),$(q.$$.fragment,e),$(N.$$.fragment,e),$(F.$$.fragment,e),$(O.$$.fragment,e),$(K.$$.fragment,e),$(X.$$.fragment,e),$(E.$$.fragment,e),$(ee.$$.fragment,e),$(te.$$.fragment,e),$(ne.$$.fragment,e),$(se.$$.fragment,e),$(ae.$$.fragment,e),$(oe.$$.fragment,e),Se=!1},d(e){e&&(l(_),l(r),l(a),l(t),l(h),l(xe),l(Te),l(Me),l(f),l(Ue),l(Ie),l(Z),l(Pe),l($e)),l(n),x(m,e),x(G,e),x(Q,e),x(H),x(Y),x(L),x(q),x(N),x(F),x(O),x(K),x(X),x(E),x(ee),x(te),x(ne),x(se),x(ae,e),x(oe)}}}const Zt='{"title":"Super-resolution","local":"super-resolution","sections":[{"title":"StableDiffusionUpscalePipeline","local":"diffusers.StableDiffusionUpscalePipeline","sections":[],"depth":2},{"title":"StableDiffusionPipelineOutput","local":"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput","sections":[],"depth":2}],"depth":1}';function Wt(M){return Tt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Vt extends Mt{constructor(n){super(),Ut(this,n,Wt,Ct,xt,{})}}export{Vt as component};
