import{s as Lt,z as qt,o as At,n as Et}from"../chunks/scheduler.182ea377.js";import{S as Dt,i as Pt,g as i,s as n,r as o,A as Kt,h as p,f as l,c as s,j as Ll,u as r,x as m,k as J,y as Ot,a as t,v as c,d,t as g,w as u}from"../chunks/index.abf12888.js";import{T as zt}from"../chunks/Tip.230e2334.js";import{C as h}from"../chunks/CodeBlock.57fe6e13.js";import{D as en}from"../chunks/DocNotebookDropdown.d9060979.js";import{H as y}from"../chunks/Heading.16916d63.js";function an(ia){let M,f='You’ll notice throughout the guide, we use <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/gligen#diffusers.StableDiffusionGLIGENTextImagePipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> and <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/image_variation#diffusers.StableDiffusionImageVariationPipeline.enable_xformers_memory_efficient_attention">enable_xformers_memory_efficient_attention()</a>, to save memory and increase inference speed. If you’re using PyTorch 2.0, it’s not necessary to call <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/image_variation#diffusers.StableDiffusionImageVariationPipeline.enable_xformers_memory_efficient_attention">enable_xformers_memory_efficient_attention()</a> on your pipeline because it’ll already be using PyTorch 2.0’s native <a href="../optimization/torch2.0#scaled-dot-product-attention">scaled-dot product attention</a>.';return{c(){M=i("p"),M.innerHTML=f},l(b){M=p(b,"P",{"data-svelte-h":!0}),m(M)!=="svelte-1a3m199"&&(M.innerHTML=f)},m(b,W){t(b,M,W)},p:Et,d(b){b&&l(M)}}}function ln(ia){let M,f='It is important to specify <code>output_type=&quot;latent&quot;</code> in the pipeline to keep all the outputs in latent space to avoid an unnecessary decode-encode step. This only works if the chained pipelines are using the same VAE. For example, in the <a href="#text-to-image-to-inpaint">Text-to-image-to-inpaint</a> section, Kandinsky 2.2 uses a different VAE class than the Stable Diffusion model so it won’t work. But if you use Stable Diffusion v1.5 for both pipelines, then you can keep everything in latent space because they both use <a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>.';return{c(){M=i("p"),M.innerHTML=f},l(b){M=p(b,"P",{"data-svelte-h":!0}),m(M)!=="svelte-15caib6"&&(M.innerHTML=f)},m(b,W){t(b,M,W)},p:Et,d(b){b&&l(M)}}}function tn(ia){let M,f,b,W,Y,ma,V,oa,R,ql="Inpainting replaces or edits specific areas of an image. This makes it a useful tool for image restoration like removing defects and artifacts, or even replacing an image area with something entirely new. Inpainting relies on a mask to determine which regions of an image to fill in; the area to inpaint is represented by white pixels and the area to keep is represented by black pixels. The white pixels are filled in by the prompt.",ra,x,Al="With 🤗 Diffusers, here is how you can do inpainting:",ca,C,Dl='<li>Load an inpainting checkpoint with the <a href="/docs/diffusers/main/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForInpainting">AutoPipelineForInpainting</a> class. This’ll automatically detect the appropriate pipeline class to load based on the checkpoint:</li>',da,N,ga,T,ua,w,Pl="<li>Load the base and mask images:</li>",Ma,Q,ha,U,Kl="<li>Create a prompt to inpaint the image with and pass it to the pipeline with the base and mask images:</li>",ya,$,ba,j,Ol='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">base image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint_mask.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">mask image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint-cat.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',Ja,S,fa,H,et="Throughout this guide, the mask image is provided in all of the code examples for convenience. You can inpaint on your own images, but you’ll need to create a mask image for it. Use the Space below to easily create a mask image.",Za,z,at="Upload a base image to inpaint on and use the sketch tool to draw a mask. Once you’re done, click <strong>Run</strong> to generate and download the mask image.",Wa,Z,lt,Ta,E,wa,L,tt='<a href="https://huggingface.co/runwayml/stable-diffusion-inpainting" rel="nofollow">Stable Diffusion Inpainting</a>, <a href="https://huggingface.co/diffusers/stable-diffusion-xl-1.0-inpainting-0.1" rel="nofollow">Stable Diffusion XL (SDXL) Inpainting</a>, and <a href="https://huggingface.co/kandinsky-community/kandinsky-2-2-decoder-inpaint" rel="nofollow">Kandinsky 2.2 Inpainting</a> are among the most popular models for inpainting. SDXL typically produces higher resolution images than Stable Diffusion v1.5, and Kandinsky 2.2 is also capable of generating high-quality images.',Ua,q,ja,A,nt="Stable Diffusion Inpainting is a latent diffusion model finetuned on 512x512 images on inpainting. It is a good starting point because it is relatively fast and generates good quality images. To use this model for inpainting, you’ll need to pass a prompt, base and mask image to the pipeline:",Ga,D,ka,P,Ba,K,st='SDXL is a larger and more powerful version of Stable Diffusion v1.5. This model can follow a two-stage model process (though each model can also be used alone); the base model generates an image, and a refiner model takes that image and further enhances its details and quality. Take a look at the <a href="sdxl">SDXL</a> guide for a more comprehensive guide on how to use SDXL and configure it’s parameters.',Ia,O,va,ee,Xa,ae,it='The Kandinsky model family is similar to SDXL because it uses two models as well; the image prior model creates image embeddings, and the diffusion model generates images from them. You can load the image prior and diffusion model separately, but the easiest way to use Kandinsky 2.2 is to load it into the <a href="/docs/diffusers/main/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForInpainting">AutoPipelineForInpainting</a> class which uses the <a href="/docs/diffusers/main/en/api/pipelines/kandinsky_v22#diffusers.KandinskyV22InpaintCombinedPipeline">KandinskyV22InpaintCombinedPipeline</a> under the hood.',_a,le,Fa,G,pt='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">base image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint-sdv1.5.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">Stable Diffusion Inpainting</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint-sdxl.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">Stable Diffusion XL Inpainting</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint-kandinsky.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">Kandinsky 2.2 Inpainting</figcaption></div>',Ya,te,Va,ne,mt="Image features - like quality and “creativity” - are dependent on pipeline parameters. Knowing what these parameters do is important for getting the results you want. Let’s take a look at the most important parameters and see how changing them affects the output.",Ra,se,xa,ie,ot="<code>strength</code> is a measure of how much noise is added to the base image, which influences how similar the output is to the base image.",Ca,pe,rt="<li>📈 a high <code>strength</code> value means more noise is added to an image and the denoising process takes longer, but you’ll get higher quality images that are more different from the base image</li> <li>📉 a low <code>strength</code> value means less noise is added to an image and the denoising process is faster, but the image quality may not be as great and the generated image resembles the base image more</li>",Na,me,Qa,k,ct='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint-strength-0.6.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">strength = 0.6</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint-strength-0.8.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">strength = 0.8</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint-strength-1.0.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">strength = 1.0</figcaption></div>',$a,oe,Sa,re,dt="<code>guidance_scale</code> affects how aligned the text prompt and generated image are.",Ha,ce,gt="<li>📈 a high <code>guidance_scale</code> value means the prompt and generated image are closely aligned, so the output is a stricter interpretation of the prompt</li> <li>📉 a low <code>guidance_scale</code> value means the prompt and generated image are more loosely aligned, so the output may be more varied from the prompt</li>",za,de,ut="You can use <code>strength</code> and <code>guidance_scale</code> together for more control over how expressive the model is. For example, a combination high <code>strength</code> and <code>guidance_scale</code> values gives the model the most creative freedom.",Ea,ge,La,B,Mt='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint-guidance-2.5.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">guidance_scale = 2.5</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint-guidance-7.5.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">guidance_scale = 7.5</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint-guidance-12.5.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">guidance_scale = 12.5</figcaption></div>',qa,ue,Aa,Me,ht="A negative prompt assumes the opposite role of a prompt; it guides the model away from generating certain things in an image. This is useful for quickly improving image quality and preventing the model from generating things you don’t want.",Da,he,Pa,I,yt='<figure><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint-negative.png"/> <figcaption class="text-center">negative_prompt = &quot;bad architecture, unstable, poor details, blurry&quot;</figcaption></figure>',Ka,ye,Oa,be,bt='The <a href="/docs/diffusers/main/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForInpainting">AutoPipelineForInpainting</a> (and other inpainting pipelines) generally changes the unmasked parts of an image to create a more natural transition between the masked and unmasked region. If this behavior is undesirable, you can force the unmasked area to remain the same. However, forcing the unmasked portion of the image to remain the same may result in some unusual transitions between the unmasked and masked areas.',el,Je,al,fe,ll,Ze,Jt='<a href="/docs/diffusers/main/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForInpainting">AutoPipelineForInpainting</a> can be chained with other 🤗 Diffusers pipelines to edit their outputs. This is often useful for improving the output quality from your other diffusion pipelines, and if you’re using multiple pipelines, it can be more memory-efficient to chain them together to keep the outputs in latent space and reuse the same pipeline components.',tl,We,nl,Te,ft="Chaining a text-to-image and inpainting pipeline allows you to inpaint the generated image, and you don’t have to provide a base image to begin with. This makes it convenient to edit your favorite text-to-image outputs without having to generate an entirely new image.",sl,we,Zt="Start with the text-to-image pipeline to create a castle:",il,Ue,pl,je,Wt="Load the mask image of the output from above:",ml,Ge,ol,ke,Tt="And let’s inpaint the masked area with a waterfall:",rl,Be,cl,v,wt='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint-text-chain.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">text-to-image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint-text-chain-out.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">inpaint</figcaption></div>',dl,Ie,gl,ve,Ut="You can also chain an inpainting pipeline before another pipeline like image-to-image or an upscaler to improve the quality.",ul,Xe,jt="Begin by inpainting an image:",Ml,_e,hl,Fe,Gt="Now let’s pass the image to another inpainting pipeline with SDXL’s refiner model to enhance the image details and quality:",yl,Ye,bl,X,Jl,Ve,kt='Finally, you can pass this image to an image-to-image pipeline to put the finishing touches on it. It is more efficient to use the <a href="/docs/diffusers/main/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForImage2Image.from_pipe">from_pipe()</a> method to reuse the existing pipeline components, and avoid unnecessarily loading all the pipeline components into memory again.',fl,Re,Zl,_,Bt='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">initial image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint-to-image-chain.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">inpaint</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint-to-image-final.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">image-to-image</figcaption></div>',Wl,xe,It="Image-to-image and inpainting are actually very similar tasks. Image-to-image generates a new image that resembles the existing provided image. Inpainting does the same thing, but it only transforms the image area defined by the mask and the rest of the image is unchanged. You can think of inpainting as a more precise tool for making specific changes and image-to-image has a broader scope for making more sweeping changes.",Tl,Ce,wl,Ne,vt="Getting an image to look exactly the way you want is challenging because the denoising process is random. While you can control certain aspects of generation by configuring parameters like <code>negative_prompt</code>, there are better and more efficient methods for controlling image generation.",Ul,Qe,jl,$e,Xt='Prompt weighting provides a quantifiable way to scale the representation of concepts in a prompt. You can use it to increase or decrease the magnitude of the text embedding vector for each concept in the prompt, which subsequently determines how much of each concept is generated. The <a href="https://github.com/damian0815/compel" rel="nofollow">Compel</a> library offers an intuitive syntax for scaling the prompt weights and generating the embeddings. Learn how to create the embeddings in the <a href="../using-diffusers/weighted_prompts">Prompt weighting</a> guide.',Gl,Se,_t='Once you’ve generated the embeddings, pass them to the <code>prompt_embeds</code> (and <code>negative_prompt_embeds</code> if you’re using a negative prompt) parameter in the <a href="/docs/diffusers/main/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForInpainting">AutoPipelineForInpainting</a>. The embeddings replace the <code>prompt</code> parameter:',kl,He,Bl,ze,Il,Ee,Ft="ControlNet models are used with other diffusion models like Stable Diffusion, and they provide an even more flexible and accurate way to control how an image is generated. A ControlNet accepts an additional conditioning image input that guides the diffusion model to preserve the features in it.",vl,Le,Yt="For example, let’s condition an image with a ControlNet pretrained on inpaint images:",Xl,qe,_l,Ae,Vt="Now generate an image from the base, mask and control images. You’ll notice features of the base image are strongly preserved in the generated image.",Fl,De,Yl,Pe,Rt='You can take this a step further and chain it with an image-to-image pipeline to apply a new <a href="https://huggingface.co/nitrosocke/elden-ring-diffusion" rel="nofollow">style</a>:',Vl,Ke,Rl,F,xt='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">initial image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint-controlnet.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">ControlNet inpaint</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint-img2img.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">image-to-image</figcaption></div>',xl,Oe,Cl,ea,Ct='It can be difficult and slow to run diffusion models if you’re resource constrained, but it doesn’t have to be with a few optimization tricks. One of the biggest (and easiest) optimizations you can enable is switching to memory-efficient attention. If you’re using PyTorch 2.0, <a href="../optimization/torch2.0#scaled-dot-product-attention">scaled-dot product attention</a> is automatically enabled and you don’t need to do anything else. For non-PyTorch 2.0 users, you can install and use <a href="../optimization/xformers">xFormers</a>’s implementation of memory-efficient attention. Both options reduce memory usage and accelerate inference.',Nl,aa,Nt="You can also offload the model to the CPU to save even more memory:",Ql,la,$l,ta,Qt='To speed-up your inference code even more, use <a href="../optimization/torch2.0#torchcompile"><code>torch_compile</code></a>. You should wrap <code>torch.compile</code> around the most intensive component in the pipeline which is typically the UNet:',Sl,na,Hl,sa,$t='Learn more in the <a href="../optimization/memory">Reduce memory usage</a> and <a href="../optimization/torch2.0">Torch 2.0</a> guides.',zl,pa,El;return Y=new y({props:{title:"Inpainting",local:"inpainting",headingTag:"h1"}}),V=new en({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/inpaint.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/inpaint.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/inpaint.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/inpaint.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/inpaint.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/inpaint.ipynb"}]}}),N=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW5wYWludGluZyUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTJDJTIwbWFrZV9pbWFnZV9ncmlkJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbnBhaW50aW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJrYW5kaW5za3ktY29tbXVuaXR5JTJGa2FuZGluc2t5LTItMi1kZWNvZGVyLWlucGFpbnQlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZWxpbmUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMjMlMjByZW1vdmUlMjBmb2xsb3dpbmclMjBsaW5lJTIwaWYlMjB4Rm9ybWVycyUyMGlzJTIwbm90JTIwaW5zdGFsbGVkJTIwb3IlMjB5b3UlMjBoYXZlJTIwUHlUb3JjaCUyMDIuMCUyMG9yJTIwaGlnaGVyJTIwaW5zdGFsbGVkJTBBcGlwZWxpbmUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKCk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder-inpaint&quot;</span>, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()`,wrap:!1}}),T=new zt({props:{$$slots:{default:[an]},$$scope:{ctx:ia}}}),Q=new h({props:{code:"aW5pdF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaW5wYWludC5wbmclMjIpJTBBbWFza19pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaW5wYWludF9tYXNrLnBuZyUyMik=",highlighted:`init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint.png&quot;</span>)
mask_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint_mask.png&quot;</span>)`,wrap:!1}}),$=new h({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyYSUyMGJsYWNrJTIwY2F0JTIwd2l0aCUyMGdsb3dpbmclMjBleWVzJTJDJTIwY3V0ZSUyQyUyMGFkb3JhYmxlJTJDJTIwZGlzbmV5JTJDJTIwcGl4YXIlMkMlMjBoaWdobHklMjBkZXRhaWxlZCUyQyUyMDhrJTIyJTBBbmVnYXRpdmVfcHJvbXB0JTIwJTNEJTIwJTIyYmFkJTIwYW5hdG9teSUyQyUyMGRlZm9ybWVkJTJDJTIwdWdseSUyQyUyMGRpc2ZpZ3VyZWQlMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUzRHByb21wdCUyQyUyMG5lZ2F0aXZlX3Byb21wdCUzRG5lZ2F0aXZlX3Byb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMG1hc2tfaW1hZ2UlM0RtYXNrX2ltYWdlKS5pbWFnZXMlNUIwJTVEJTBBbWFrZV9pbWFnZV9ncmlkKCU1QmluaXRfaW1hZ2UlMkMlMjBtYXNrX2ltYWdlJTJDJTIwaW1hZ2UlNUQlMkMlMjByb3dzJTNEMSUyQyUyMGNvbHMlM0QzKQ==",highlighted:`prompt = <span class="hljs-string">&quot;a black cat with glowing eyes, cute, adorable, disney, pixar, highly detailed, 8k&quot;</span>
negative_prompt = <span class="hljs-string">&quot;bad anatomy, deformed, ugly, disfigured&quot;</span>
image = pipeline(prompt=prompt, negative_prompt=negative_prompt, image=init_image, mask_image=mask_image).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, mask_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`,wrap:!1}}),S=new y({props:{title:"Create a mask image",local:"create-a-mask-image",headingTag:"h2"}}),E=new y({props:{title:"Popular models",local:"popular-models",headingTag:"h2"}}),q=new y({props:{title:"Stable Diffusion Inpainting",local:"stable-diffusion-inpainting",headingTag:"h3"}}),D=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW5wYWludGluZyUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTJDJTIwbWFrZV9pbWFnZV9ncmlkJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbnBhaW50aW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24taW5wYWludGluZyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTBBKS50byglMjJjdWRhJTIyKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTIzJTIwcmVtb3ZlJTIwZm9sbG93aW5nJTIwbGluZSUyMGlmJTIweEZvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZCUyMG9yJTIweW91JTIwaGF2ZSUyMFB5VG9yY2glMjAyLjAlMjBvciUyMGhpZ2hlciUyMGluc3RhbGxlZCUwQXBpcGVsaW5lLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBJTIzJTIwbG9hZCUyMGJhc2UlMjBhbmQlMjBtYXNrJTIwaW1hZ2UlMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpbnBhaW50LnBuZyUyMiklMEFtYXNrX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpbnBhaW50X21hc2sucG5nJTIyKSUwQSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvciglMjJjdWRhJTIyKS5tYW51YWxfc2VlZCg5MiklMEFwcm9tcHQlMjAlM0QlMjAlMjJjb25jZXB0JTIwYXJ0JTIwZGlnaXRhbCUyMHBhaW50aW5nJTIwb2YlMjBhbiUyMGVsdmVuJTIwY2FzdGxlJTJDJTIwaW5zcGlyZWQlMjBieSUyMGxvcmQlMjBvZiUyMHRoZSUyMHJpbmdzJTJDJTIwaGlnaGx5JTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTNEcHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTIwbWFza19pbWFnZSUzRG1hc2tfaW1hZ2UlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IpLmltYWdlcyU1QjAlNUQlMEFtYWtlX2ltYWdlX2dyaWQoJTVCaW5pdF9pbWFnZSUyQyUyMG1hc2tfaW1hZ2UlMkMlMjBpbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDMp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># load base and mask image</span>
init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint.png&quot;</span>)
mask_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint_mask.png&quot;</span>)

generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">92</span>)
prompt = <span class="hljs-string">&quot;concept art digital painting of an elven castle, inspired by lord of the rings, highly detailed, 8k&quot;</span>
image = pipeline(prompt=prompt, image=init_image, mask_image=mask_image, generator=generator).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, mask_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`,wrap:!1}}),P=new y({props:{title:"Stable Diffusion XL (SDXL) Inpainting",local:"stable-diffusion-xl-sdxl-inpainting",headingTag:"h3"}}),O=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW5wYWludGluZyUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTJDJTIwbWFrZV9pbWFnZV9ncmlkJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbnBhaW50aW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJkaWZmdXNlcnMlMkZzdGFibGUtZGlmZnVzaW9uLXhsLTEuMC1pbnBhaW50aW5nLTAuMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTBBKS50byglMjJjdWRhJTIyKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTIzJTIwcmVtb3ZlJTIwZm9sbG93aW5nJTIwbGluZSUyMGlmJTIweEZvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZCUyMG9yJTIweW91JTIwaGF2ZSUyMFB5VG9yY2glMjAyLjAlMjBvciUyMGhpZ2hlciUyMGluc3RhbGxlZCUwQXBpcGVsaW5lLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBJTIzJTIwbG9hZCUyMGJhc2UlMjBhbmQlMjBtYXNrJTIwaW1hZ2UlMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpbnBhaW50LnBuZyUyMiklMEFtYXNrX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpbnBhaW50X21hc2sucG5nJTIyKSUwQSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvciglMjJjdWRhJTIyKS5tYW51YWxfc2VlZCg5MiklMEFwcm9tcHQlMjAlM0QlMjAlMjJjb25jZXB0JTIwYXJ0JTIwZGlnaXRhbCUyMHBhaW50aW5nJTIwb2YlMjBhbiUyMGVsdmVuJTIwY2FzdGxlJTJDJTIwaW5zcGlyZWQlMjBieSUyMGxvcmQlMjBvZiUyMHRoZSUyMHJpbmdzJTJDJTIwaGlnaGx5JTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTNEcHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTIwbWFza19pbWFnZSUzRG1hc2tfaW1hZ2UlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IpLmltYWdlcyU1QjAlNUQlMEFtYWtlX2ltYWdlX2dyaWQoJTVCaW5pdF9pbWFnZSUyQyUyMG1hc2tfaW1hZ2UlMkMlMjBpbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDMp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;diffusers/stable-diffusion-xl-1.0-inpainting-0.1&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># load base and mask image</span>
init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint.png&quot;</span>)
mask_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint_mask.png&quot;</span>)

generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">92</span>)
prompt = <span class="hljs-string">&quot;concept art digital painting of an elven castle, inspired by lord of the rings, highly detailed, 8k&quot;</span>
image = pipeline(prompt=prompt, image=init_image, mask_image=mask_image, generator=generator).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, mask_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`,wrap:!1}}),ee=new y({props:{title:"Kandinsky 2.2 Inpainting",local:"kandinsky-22-inpainting",headingTag:"h3"}}),le=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW5wYWludGluZyUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTJDJTIwbWFrZV9pbWFnZV9ncmlkJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbnBhaW50aW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJrYW5kaW5za3ktY29tbXVuaXR5JTJGa2FuZGluc2t5LTItMi1kZWNvZGVyLWlucGFpbnQlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZWxpbmUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMjMlMjByZW1vdmUlMjBmb2xsb3dpbmclMjBsaW5lJTIwaWYlMjB4Rm9ybWVycyUyMGlzJTIwbm90JTIwaW5zdGFsbGVkJTIwb3IlMjB5b3UlMjBoYXZlJTIwUHlUb3JjaCUyMDIuMCUyMG9yJTIwaGlnaGVyJTIwaW5zdGFsbGVkJTBBcGlwZWxpbmUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKCklMEElMEElMjMlMjBsb2FkJTIwYmFzZSUyMGFuZCUyMG1hc2slMjBpbWFnZSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmlucGFpbnQucG5nJTIyKSUwQW1hc2tfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmlucGFpbnRfbWFzay5wbmclMjIpJTBBJTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKCUyMmN1ZGElMjIpLm1hbnVhbF9zZWVkKDkyKSUwQXByb21wdCUyMCUzRCUyMCUyMmNvbmNlcHQlMjBhcnQlMjBkaWdpdGFsJTIwcGFpbnRpbmclMjBvZiUyMGFuJTIwZWx2ZW4lMjBjYXN0bGUlMkMlMjBpbnNwaXJlZCUyMGJ5JTIwbG9yZCUyMG9mJTIwdGhlJTIwcmluZ3MlMkMlMjBoaWdobHklMjBkZXRhaWxlZCUyQyUyMDhrJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UlMkMlMjBtYXNrX2ltYWdlJTNEbWFza19pbWFnZSUyQyUyMGdlbmVyYXRvciUzRGdlbmVyYXRvcikuaW1hZ2VzJTVCMCU1RCUwQW1ha2VfaW1hZ2VfZ3JpZCglNUJpbml0X2ltYWdlJTJDJTIwbWFza19pbWFnZSUyQyUyMGltYWdlJTVEJTJDJTIwcm93cyUzRDElMkMlMjBjb2xzJTNEMyk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder-inpaint&quot;</span>, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># load base and mask image</span>
init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint.png&quot;</span>)
mask_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint_mask.png&quot;</span>)

generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">92</span>)
prompt = <span class="hljs-string">&quot;concept art digital painting of an elven castle, inspired by lord of the rings, highly detailed, 8k&quot;</span>
image = pipeline(prompt=prompt, image=init_image, mask_image=mask_image, generator=generator).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, mask_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`,wrap:!1}}),te=new y({props:{title:"Configure pipeline parameters",local:"configure-pipeline-parameters",headingTag:"h2"}}),se=new y({props:{title:"Strength",local:"strength",headingTag:"h3"}}),me=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW5wYWludGluZyUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTJDJTIwbWFrZV9pbWFnZV9ncmlkJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbnBhaW50aW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24taW5wYWludGluZyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTBBKS50byglMjJjdWRhJTIyKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTIzJTIwcmVtb3ZlJTIwZm9sbG93aW5nJTIwbGluZSUyMGlmJTIweEZvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZCUyMG9yJTIweW91JTIwaGF2ZSUyMFB5VG9yY2glMjAyLjAlMjBvciUyMGhpZ2hlciUyMGluc3RhbGxlZCUwQXBpcGVsaW5lLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBJTIzJTIwbG9hZCUyMGJhc2UlMjBhbmQlMjBtYXNrJTIwaW1hZ2UlMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpbnBhaW50LnBuZyUyMiklMEFtYXNrX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpbnBhaW50X21hc2sucG5nJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmNvbmNlcHQlMjBhcnQlMjBkaWdpdGFsJTIwcGFpbnRpbmclMjBvZiUyMGFuJTIwZWx2ZW4lMjBjYXN0bGUlMkMlMjBpbnNwaXJlZCUyMGJ5JTIwbG9yZCUyMG9mJTIwdGhlJTIwcmluZ3MlMkMlMjBoaWdobHklMjBkZXRhaWxlZCUyQyUyMDhrJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UlMkMlMjBtYXNrX2ltYWdlJTNEbWFza19pbWFnZSUyQyUyMHN0cmVuZ3RoJTNEMC42KS5pbWFnZXMlNUIwJTVEJTBBbWFrZV9pbWFnZV9ncmlkKCU1QmluaXRfaW1hZ2UlMkMlMjBtYXNrX2ltYWdlJTJDJTIwaW1hZ2UlNUQlMkMlMjByb3dzJTNEMSUyQyUyMGNvbHMlM0QzKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># load base and mask image</span>
init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint.png&quot;</span>)
mask_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint_mask.png&quot;</span>)

prompt = <span class="hljs-string">&quot;concept art digital painting of an elven castle, inspired by lord of the rings, highly detailed, 8k&quot;</span>
image = pipeline(prompt=prompt, image=init_image, mask_image=mask_image, strength=<span class="hljs-number">0.6</span>).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, mask_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`,wrap:!1}}),oe=new y({props:{title:"Guidance scale",local:"guidance-scale",headingTag:"h3"}}),ge=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW5wYWludGluZyUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTJDJTIwbWFrZV9pbWFnZV9ncmlkJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbnBhaW50aW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24taW5wYWludGluZyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTBBKS50byglMjJjdWRhJTIyKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTIzJTIwcmVtb3ZlJTIwZm9sbG93aW5nJTIwbGluZSUyMGlmJTIweEZvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZCUyMG9yJTIweW91JTIwaGF2ZSUyMFB5VG9yY2glMjAyLjAlMjBvciUyMGhpZ2hlciUyMGluc3RhbGxlZCUwQXBpcGVsaW5lLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBJTIzJTIwbG9hZCUyMGJhc2UlMjBhbmQlMjBtYXNrJTIwaW1hZ2UlMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpbnBhaW50LnBuZyUyMiklMEFtYXNrX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpbnBhaW50X21hc2sucG5nJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmNvbmNlcHQlMjBhcnQlMjBkaWdpdGFsJTIwcGFpbnRpbmclMjBvZiUyMGFuJTIwZWx2ZW4lMjBjYXN0bGUlMkMlMjBpbnNwaXJlZCUyMGJ5JTIwbG9yZCUyMG9mJTIwdGhlJTIwcmluZ3MlMkMlMjBoaWdobHklMjBkZXRhaWxlZCUyQyUyMDhrJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UlMkMlMjBtYXNrX2ltYWdlJTNEbWFza19pbWFnZSUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEMi41KS5pbWFnZXMlNUIwJTVEJTBBbWFrZV9pbWFnZV9ncmlkKCU1QmluaXRfaW1hZ2UlMkMlMjBtYXNrX2ltYWdlJTJDJTIwaW1hZ2UlNUQlMkMlMjByb3dzJTNEMSUyQyUyMGNvbHMlM0QzKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># load base and mask image</span>
init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint.png&quot;</span>)
mask_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint_mask.png&quot;</span>)

prompt = <span class="hljs-string">&quot;concept art digital painting of an elven castle, inspired by lord of the rings, highly detailed, 8k&quot;</span>
image = pipeline(prompt=prompt, image=init_image, mask_image=mask_image, guidance_scale=<span class="hljs-number">2.5</span>).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, mask_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`,wrap:!1}}),ue=new y({props:{title:"Negative prompt",local:"negative-prompt",headingTag:"h3"}}),he=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW5wYWludGluZyUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTJDJTIwbWFrZV9pbWFnZV9ncmlkJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbnBhaW50aW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24taW5wYWludGluZyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTBBKS50byglMjJjdWRhJTIyKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTIzJTIwcmVtb3ZlJTIwZm9sbG93aW5nJTIwbGluZSUyMGlmJTIweEZvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZCUyMG9yJTIweW91JTIwaGF2ZSUyMFB5VG9yY2glMjAyLjAlMjBvciUyMGhpZ2hlciUyMGluc3RhbGxlZCUwQXBpcGVsaW5lLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBJTIzJTIwbG9hZCUyMGJhc2UlMjBhbmQlMjBtYXNrJTIwaW1hZ2UlMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpbnBhaW50LnBuZyUyMiklMEFtYXNrX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpbnBhaW50X21hc2sucG5nJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmNvbmNlcHQlMjBhcnQlMjBkaWdpdGFsJTIwcGFpbnRpbmclMjBvZiUyMGFuJTIwZWx2ZW4lMjBjYXN0bGUlMkMlMjBpbnNwaXJlZCUyMGJ5JTIwbG9yZCUyMG9mJTIwdGhlJTIwcmluZ3MlMkMlMjBoaWdobHklMjBkZXRhaWxlZCUyQyUyMDhrJTIyJTBBbmVnYXRpdmVfcHJvbXB0JTIwJTNEJTIwJTIyYmFkJTIwYXJjaGl0ZWN0dXJlJTJDJTIwdW5zdGFibGUlMkMlMjBwb29yJTIwZGV0YWlscyUyQyUyMGJsdXJyeSUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTNEcHJvbXB0JTJDJTIwbmVnYXRpdmVfcHJvbXB0JTNEbmVnYXRpdmVfcHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTIwbWFza19pbWFnZSUzRG1hc2tfaW1hZ2UpLmltYWdlcyU1QjAlNUQlMEFtYWtlX2ltYWdlX2dyaWQoJTVCaW5pdF9pbWFnZSUyQyUyMG1hc2tfaW1hZ2UlMkMlMjBpbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDMp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># load base and mask image</span>
init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint.png&quot;</span>)
mask_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint_mask.png&quot;</span>)

prompt = <span class="hljs-string">&quot;concept art digital painting of an elven castle, inspired by lord of the rings, highly detailed, 8k&quot;</span>
negative_prompt = <span class="hljs-string">&quot;bad architecture, unstable, poor details, blurry&quot;</span>
image = pipeline(prompt=prompt, negative_prompt=negative_prompt, image=init_image, mask_image=mask_image).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, mask_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`,wrap:!1}}),ye=new y({props:{title:"Preserve unmasked areas",local:"preserve-unmasked-areas",headingTag:"h2"}}),Je=new h({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> PIL
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

device = <span class="hljs-string">&quot;cuda&quot;</span>
pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>,
    torch_dtype=torch.float16,
)
pipeline = pipeline.to(device)

img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>

init_image = load_image(img_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))
mask_image = load_image(mask_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

prompt = <span class="hljs-string">&quot;Face of a yellow cat, high resolution, sitting on a park bench&quot;</span>
repainted_image = pipeline(prompt=prompt, image=init_image, mask_image=mask_image).images[<span class="hljs-number">0</span>]
repainted_image.save(<span class="hljs-string">&quot;repainted_image.png&quot;</span>)

<span class="hljs-comment"># Convert mask to grayscale NumPy array</span>
mask_image_arr = np.array(mask_image.convert(<span class="hljs-string">&quot;L&quot;</span>))
<span class="hljs-comment"># Add a channel dimension to the end of the grayscale mask</span>
mask_image_arr = mask_image_arr[:, :, <span class="hljs-literal">None</span>]
<span class="hljs-comment"># Binarize the mask: 1s correspond to the pixels which are repainted</span>
mask_image_arr = mask_image_arr.astype(np.float32) / <span class="hljs-number">255.0</span>
mask_image_arr[mask_image_arr &lt; <span class="hljs-number">0.5</span>] = <span class="hljs-number">0</span>
mask_image_arr[mask_image_arr &gt;= <span class="hljs-number">0.5</span>] = <span class="hljs-number">1</span>

<span class="hljs-comment"># Take the masked pixels from the repainted image and the unmasked pixels from the initial image</span>
unmasked_unchanged_image_arr = (<span class="hljs-number">1</span> - mask_image_arr) * init_image + mask_image_arr * repainted_image
unmasked_unchanged_image = PIL.Image.fromarray(unmasked_unchanged_image_arr.<span class="hljs-built_in">round</span>().astype(<span class="hljs-string">&quot;uint8&quot;</span>))
unmasked_unchanged_image.save(<span class="hljs-string">&quot;force_unmasked_unchanged.png&quot;</span>)
make_image_grid([init_image, mask_image, repainted_image, unmasked_unchanged_image], rows=<span class="hljs-number">2</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),fe=new y({props:{title:"Chained inpainting pipelines",local:"chained-inpainting-pipelines",headingTag:"h2"}}),We=new y({props:{title:"Text-to-image-to-inpaint",local:"text-to-image-to-inpaint",headingTag:"h3"}}),Ue=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZSUyQyUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmclMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUyQyUyMG1ha2VfaW1hZ2VfZ3JpZCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZWxpbmUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMjMlMjByZW1vdmUlMjBmb2xsb3dpbmclMjBsaW5lJTIwaWYlMjB4Rm9ybWVycyUyMGlzJTIwbm90JTIwaW5zdGFsbGVkJTIwb3IlMjB5b3UlMjBoYXZlJTIwUHlUb3JjaCUyMDIuMCUyMG9yJTIwaGlnaGVyJTIwaW5zdGFsbGVkJTBBcGlwZWxpbmUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKCklMEElMEF0ZXh0MmltYWdlJTIwJTNEJTIwcGlwZWxpbmUoJTIyY29uY2VwdCUyMGFydCUyMGRpZ2l0YWwlMjBwYWludGluZyUyMG9mJTIwYW4lMjBlbHZlbiUyMGNhc3RsZSUyQyUyMGluc3BpcmVkJTIwYnklMjBsb3JkJTIwb2YlMjB0aGUlMjByaW5ncyUyQyUyMGhpZ2hseSUyMGRldGFpbGVkJTJDJTIwOGslMjIpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image, AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

pipeline = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

text2image = pipeline(<span class="hljs-string">&quot;concept art digital painting of an elven castle, inspired by lord of the rings, highly detailed, 8k&quot;</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Ge=new h({props:{code:"bWFza19pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaW5wYWludF90ZXh0LWNoYWluLW1hc2sucG5nJTIyKQ==",highlighted:'mask_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint_text-chain-mask.png&quot;</span>)',wrap:!1}}),Be=new h({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbnBhaW50aW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJrYW5kaW5za3ktY29tbXVuaXR5JTJGa2FuZGluc2t5LTItMi1kZWNvZGVyLWlucGFpbnQlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZWxpbmUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMjMlMjByZW1vdmUlMjBmb2xsb3dpbmclMjBsaW5lJTIwaWYlMjB4Rm9ybWVycyUyMGlzJTIwbm90JTIwaW5zdGFsbGVkJTIwb3IlMjB5b3UlMjBoYXZlJTIwUHlUb3JjaCUyMDIuMCUyMG9yJTIwaGlnaGVyJTIwaW5zdGFsbGVkJTBBcGlwZWxpbmUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJkaWdpdGFsJTIwcGFpbnRpbmclMjBvZiUyMGElMjBmYW50YXN5JTIwd2F0ZXJmYWxsJTJDJTIwY2xvdWR5JTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRHRleHQyaW1hZ2UlMkMlMjBtYXNrX2ltYWdlJTNEbWFza19pbWFnZSkuaW1hZ2VzJTVCMCU1RCUwQW1ha2VfaW1hZ2VfZ3JpZCglNUJ0ZXh0MmltYWdlJTJDJTIwbWFza19pbWFnZSUyQyUyMGltYWdlJTVEJTJDJTIwcm93cyUzRDElMkMlMjBjb2xzJTNEMyk=",highlighted:`pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder-inpaint&quot;</span>, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

prompt = <span class="hljs-string">&quot;digital painting of a fantasy waterfall, cloudy&quot;</span>
image = pipeline(prompt=prompt, image=text2image, mask_image=mask_image).images[<span class="hljs-number">0</span>]
make_image_grid([text2image, mask_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`,wrap:!1}}),Ie=new y({props:{title:"Inpaint-to-image-to-image",local:"inpaint-to-image-to-image",headingTag:"h3"}}),_e=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW5wYWludGluZyUyQyUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMkMlMjBtYWtlX2ltYWdlX2dyaWQlMEElMEFwaXBlbGluZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmcuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi1pbnBhaW50aW5nJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMEEpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZWxpbmUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMjMlMjByZW1vdmUlMjBmb2xsb3dpbmclMjBsaW5lJTIwaWYlMjB4Rm9ybWVycyUyMGlzJTIwbm90JTIwaW5zdGFsbGVkJTIwb3IlMjB5b3UlMjBoYXZlJTIwUHlUb3JjaCUyMDIuMCUyMG9yJTIwaGlnaGVyJTIwaW5zdGFsbGVkJTBBcGlwZWxpbmUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKCklMEElMEElMjMlMjBsb2FkJTIwYmFzZSUyMGFuZCUyMG1hc2slMjBpbWFnZSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmlucGFpbnQucG5nJTIyKSUwQW1hc2tfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmlucGFpbnRfbWFzay5wbmclMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyY29uY2VwdCUyMGFydCUyMGRpZ2l0YWwlMjBwYWludGluZyUyMG9mJTIwYW4lMjBlbHZlbiUyMGNhc3RsZSUyQyUyMGluc3BpcmVkJTIwYnklMjBsb3JkJTIwb2YlMjB0aGUlMjByaW5ncyUyQyUyMGhpZ2hseSUyMGRldGFpbGVkJTJDJTIwOGslMjIlMEFpbWFnZV9pbnBhaW50aW5nJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTNEcHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTIwbWFza19pbWFnZSUzRG1hc2tfaW1hZ2UpLmltYWdlcyU1QjAlNUQlMEElMEElMjMlMjByZXNpemUlMjBpbWFnZSUyMHRvJTIwMTAyNHgxMDI0JTIwZm9yJTIwU0RYTCUwQWltYWdlX2lucGFpbnRpbmclMjAlM0QlMjBpbWFnZV9pbnBhaW50aW5nLnJlc2l6ZSgoMTAyNCUyQyUyMDEwMjQpKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting, AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># load base and mask image</span>
init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint.png&quot;</span>)
mask_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint_mask.png&quot;</span>)

prompt = <span class="hljs-string">&quot;concept art digital painting of an elven castle, inspired by lord of the rings, highly detailed, 8k&quot;</span>
image_inpainting = pipeline(prompt=prompt, image=init_image, mask_image=mask_image).images[<span class="hljs-number">0</span>]

<span class="hljs-comment"># resize image to 1024x1024 for SDXL</span>
image_inpainting = image_inpainting.resize((<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>))`,wrap:!1}}),Ye=new h({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbnBhaW50aW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtcmVmaW5lci0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUwQSkudG8oJTIyY3VkYSUyMiklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUyMyUyMHJlbW92ZSUyMGZvbGxvd2luZyUyMGxpbmUlMjBpZiUyMHhGb3JtZXJzJTIwaXMlMjBub3QlMjBpbnN0YWxsZWQlMjBvciUyMHlvdSUyMGhhdmUlMjBQeVRvcmNoJTIwMi4wJTIwb3IlMjBoaWdoZXIlMjBpbnN0YWxsZWQlMEFwaXBlbGluZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTNEcHJvbXB0JTJDJTIwaW1hZ2UlM0RpbWFnZV9pbnBhaW50aW5nJTJDJTIwbWFza19pbWFnZSUzRG1hc2tfaW1hZ2UlMkMlMjBvdXRwdXRfdHlwZSUzRCUyMmxhdGVudCUyMikuaW1hZ2VzJTVCMCU1RA==",highlighted:`pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-refiner-1.0&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

image = pipeline(prompt=prompt, image=image_inpainting, mask_image=mask_image, output_type=<span class="hljs-string">&quot;latent&quot;</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),X=new zt({props:{$$slots:{default:[ln]},$$scope:{ctx:ia}}}),Re=new h({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZS5mcm9tX3BpcGUocGlwZWxpbmUpJTBBJTIzJTIwcmVtb3ZlJTIwZm9sbG93aW5nJTIwbGluZSUyMGlmJTIweEZvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZCUyMG9yJTIweW91JTIwaGF2ZSUyMFB5VG9yY2glMjAyLjAlMjBvciUyMGhpZ2hlciUyMGluc3RhbGxlZCUwQXBpcGVsaW5lLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGltYWdlKS5pbWFnZXMlNUIwJTVEJTBBbWFrZV9pbWFnZV9ncmlkKCU1QmluaXRfaW1hZ2UlMkMlMjBtYXNrX2ltYWdlJTJDJTIwaW1hZ2VfaW5wYWludGluZyUyQyUyMGltYWdlJTVEJTJDJTIwcm93cyUzRDIlMkMlMjBjb2xzJTNEMik=",highlighted:`pipeline = AutoPipelineForImage2Image.from_pipe(pipeline)
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

image = pipeline(prompt=prompt, image=image).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, mask_image, image_inpainting, image], rows=<span class="hljs-number">2</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),Ce=new y({props:{title:"Control image generation",local:"control-image-generation",headingTag:"h2"}}),Qe=new y({props:{title:"Prompt weighting",local:"prompt-weighting",headingTag:"h3"}}),He=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW5wYWludGluZyUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBtYWtlX2ltYWdlX2dyaWQlMEElMEFwaXBlbGluZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmcuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi1pbnBhaW50aW5nJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKS50byglMjJjdWRhJTIyKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTIzJTIwcmVtb3ZlJTIwZm9sbG93aW5nJTIwbGluZSUyMGlmJTIweEZvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZCUyMG9yJTIweW91JTIwaGF2ZSUyMFB5VG9yY2glMjAyLjAlMjBvciUyMGhpZ2hlciUyMGluc3RhbGxlZCUwQXBpcGVsaW5lLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHRfZW1iZWRzJTNEcHJvbXB0X2VtYmVkcyUyQyUyMCUyMyUyMGdlbmVyYXRlZCUyMGZyb20lMjBDb21wZWwlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHRfZW1iZWRzJTNEbmVnYXRpdmVfcHJvbXB0X2VtYmVkcyUyQyUyMCUyMyUyMGdlbmVyYXRlZCUyMGZyb20lMjBDb21wZWwlMEElMjAlMjAlMjAlMjBpbWFnZSUzRGluaXRfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBtYXNrX2ltYWdlJTNEbWFza19pbWFnZSUwQSkuaW1hZ2VzJTVCMCU1RCUwQW1ha2VfaW1hZ2VfZ3JpZCglNUJpbml0X2ltYWdlJTJDJTIwbWFza19pbWFnZSUyQyUyMGltYWdlJTVEJTJDJTIwcm93cyUzRDElMkMlMjBjb2xzJTNEMyk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid

pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>, torch_dtype=torch.float16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

image = pipeline(prompt_embeds=prompt_embeds, <span class="hljs-comment"># generated from Compel</span>
    negative_prompt_embeds=negative_prompt_embeds, <span class="hljs-comment"># generated from Compel</span>
    image=init_image,
    mask_image=mask_image
).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, mask_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`,wrap:!1}}),ze=new y({props:{title:"ControlNet",local:"controlnet",headingTag:"h3"}}),qe=new h({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> ControlNetModel, StableDiffusionControlNetInpaintPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

<span class="hljs-comment"># load ControlNet</span>
controlnet = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;lllyasviel/control_v11p_sd15_inpaint&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)

<span class="hljs-comment"># pass ControlNet to the pipeline</span>
pipeline = StableDiffusionControlNetInpaintPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>, controlnet=controlnet, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># load base and mask image</span>
init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint.png&quot;</span>)
mask_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint_mask.png&quot;</span>)

<span class="hljs-comment"># prepare control image</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">make_inpaint_condition</span>(<span class="hljs-params">init_image, mask_image</span>):
    init_image = np.array(init_image.convert(<span class="hljs-string">&quot;RGB&quot;</span>)).astype(np.float32) / <span class="hljs-number">255.0</span>
    mask_image = np.array(mask_image.convert(<span class="hljs-string">&quot;L&quot;</span>)).astype(np.float32) / <span class="hljs-number">255.0</span>

    <span class="hljs-keyword">assert</span> init_image.shape[<span class="hljs-number">0</span>:<span class="hljs-number">1</span>] == mask_image.shape[<span class="hljs-number">0</span>:<span class="hljs-number">1</span>], <span class="hljs-string">&quot;image and image_mask must have the same image size&quot;</span>
    init_image[mask_image &gt; <span class="hljs-number">0.5</span>] = -<span class="hljs-number">1.0</span>  <span class="hljs-comment"># set as masked pixel</span>
    init_image = np.expand_dims(init_image, <span class="hljs-number">0</span>).transpose(<span class="hljs-number">0</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>)
    init_image = torch.from_numpy(init_image)
    <span class="hljs-keyword">return</span> init_image

control_image = make_inpaint_condition(init_image, mask_image)`,wrap:!1}}),De=new h({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyY29uY2VwdCUyMGFydCUyMGRpZ2l0YWwlMjBwYWludGluZyUyMG9mJTIwYW4lMjBlbHZlbiUyMGNhc3RsZSUyQyUyMGluc3BpcmVkJTIwYnklMjBsb3JkJTIwb2YlMjB0aGUlMjByaW5ncyUyQyUyMGhpZ2hseSUyMGRldGFpbGVkJTJDJTIwOGslMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMG1hc2tfaW1hZ2UlM0RtYXNrX2ltYWdlJTJDJTIwY29udHJvbF9pbWFnZSUzRGNvbnRyb2xfaW1hZ2UpLmltYWdlcyU1QjAlNUQlMEFtYWtlX2ltYWdlX2dyaWQoJTVCaW5pdF9pbWFnZSUyQyUyMG1hc2tfaW1hZ2UlMkMlMjBQSUwuSW1hZ2UuZnJvbWFycmF5KG5wLnVpbnQ4KGNvbnRyb2xfaW1hZ2UlNUIwJTVEJTVCMCU1RCkpLmNvbnZlcnQoJ1JHQicpJTJDJTIwaW1hZ2UlNUQlMkMlMjByb3dzJTNEMiUyQyUyMGNvbHMlM0QyKQ==",highlighted:`prompt = <span class="hljs-string">&quot;concept art digital painting of an elven castle, inspired by lord of the rings, highly detailed, 8k&quot;</span>
image = pipeline(prompt=prompt, image=init_image, mask_image=mask_image, control_image=control_image).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, mask_image, PIL.Image.fromarray(np.uint8(control_image[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>])).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>), image], rows=<span class="hljs-number">2</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),Ke=new h({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybml0cm9zb2NrZSUyRmVsZGVuLXJpbmctZGlmZnVzaW9uJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKS50byglMjJjdWRhJTIyKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTIzJTIwcmVtb3ZlJTIwZm9sbG93aW5nJTIwbGluZSUyMGlmJTIweEZvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZCUyMG9yJTIweW91JTIwaGF2ZSUyMFB5VG9yY2glMjAyLjAlMjBvciUyMGhpZ2hlciUyMGluc3RhbGxlZCUwQXBpcGVsaW5lLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyZWxkZW4lMjByaW5nJTIwc3R5bGUlMjBjYXN0bGUlMjIlMjAlMjMlMjBpbmNsdWRlJTIwdGhlJTIwdG9rZW4lMjAlMjJlbGRlbiUyMHJpbmclMjBzdHlsZSUyMiUyMGluJTIwdGhlJTIwcHJvbXB0JTBBbmVnYXRpdmVfcHJvbXB0JTIwJTNEJTIwJTIyYmFkJTIwYXJjaGl0ZWN0dXJlJTJDJTIwZGVmb3JtZWQlMkMlMjBkaXNmaWd1cmVkJTJDJTIwcG9vciUyMGRldGFpbHMlMjIlMEElMEFpbWFnZV9lbGRlbl9yaW5nJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwbmVnYXRpdmVfcHJvbXB0JTNEbmVnYXRpdmVfcHJvbXB0JTJDJTIwaW1hZ2UlM0RpbWFnZSkuaW1hZ2VzJTVCMCU1RCUwQW1ha2VfaW1hZ2VfZ3JpZCglNUJpbml0X2ltYWdlJTJDJTIwbWFza19pbWFnZSUyQyUyMGltYWdlJTJDJTIwaW1hZ2VfZWxkZW5fcmluZyU1RCUyQyUyMHJvd3MlM0QyJTJDJTIwY29scyUzRDIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;nitrosocke/elden-ring-diffusion&quot;</span>, torch_dtype=torch.float16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

prompt = <span class="hljs-string">&quot;elden ring style castle&quot;</span> <span class="hljs-comment"># include the token &quot;elden ring style&quot; in the prompt</span>
negative_prompt = <span class="hljs-string">&quot;bad architecture, deformed, disfigured, poor details&quot;</span>

image_elden_ring = pipeline(prompt, negative_prompt=negative_prompt, image=image).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, mask_image, image, image_elden_ring], rows=<span class="hljs-number">2</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),Oe=new y({props:{title:"Optimize",local:"optimize",headingTag:"h2"}}),la=new h({props:{code:"JTJCJTIwcGlwZWxpbmUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKCklMEElMkIlMjBwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKQ==",highlighted:`<span class="hljs-addition">+ pipeline.enable_xformers_memory_efficient_attention()</span>
<span class="hljs-addition">+ pipeline.enable_model_cpu_offload()</span>`,wrap:!1}}),na=new h({props:{code:"cGlwZWxpbmUudW5ldCUyMCUzRCUyMHRvcmNoLmNvbXBpbGUocGlwZWxpbmUudW5ldCUyQyUyMG1vZGUlM0QlMjJyZWR1Y2Utb3ZlcmhlYWQlMjIlMkMlMjBmdWxsZ3JhcGglM0RUcnVlKQ==",highlighted:'pipeline.unet = torch.<span class="hljs-built_in">compile</span>(pipeline.unet, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)',wrap:!1}}),{c(){M=i("meta"),f=n(),b=i("p"),W=n(),o(Y.$$.fragment),ma=n(),o(V.$$.fragment),oa=n(),R=i("p"),R.textContent=ql,ra=n(),x=i("p"),x.textContent=Al,ca=n(),C=i("ol"),C.innerHTML=Dl,da=n(),o(N.$$.fragment),ga=n(),o(T.$$.fragment),ua=n(),w=i("ol"),w.innerHTML=Pl,Ma=n(),o(Q.$$.fragment),ha=n(),U=i("ol"),U.innerHTML=Kl,ya=n(),o($.$$.fragment),ba=n(),j=i("div"),j.innerHTML=Ol,Ja=n(),o(S.$$.fragment),fa=n(),H=i("p"),H.textContent=et,Za=n(),z=i("p"),z.innerHTML=at,Wa=n(),Z=i("iframe"),Ta=n(),o(E.$$.fragment),wa=n(),L=i("p"),L.innerHTML=tt,Ua=n(),o(q.$$.fragment),ja=n(),A=i("p"),A.textContent=nt,Ga=n(),o(D.$$.fragment),ka=n(),o(P.$$.fragment),Ba=n(),K=i("p"),K.innerHTML=st,Ia=n(),o(O.$$.fragment),va=n(),o(ee.$$.fragment),Xa=n(),ae=i("p"),ae.innerHTML=it,_a=n(),o(le.$$.fragment),Fa=n(),G=i("div"),G.innerHTML=pt,Ya=n(),o(te.$$.fragment),Va=n(),ne=i("p"),ne.textContent=mt,Ra=n(),o(se.$$.fragment),xa=n(),ie=i("p"),ie.innerHTML=ot,Ca=n(),pe=i("ul"),pe.innerHTML=rt,Na=n(),o(me.$$.fragment),Qa=n(),k=i("div"),k.innerHTML=ct,$a=n(),o(oe.$$.fragment),Sa=n(),re=i("p"),re.innerHTML=dt,Ha=n(),ce=i("ul"),ce.innerHTML=gt,za=n(),de=i("p"),de.innerHTML=ut,Ea=n(),o(ge.$$.fragment),La=n(),B=i("div"),B.innerHTML=Mt,qa=n(),o(ue.$$.fragment),Aa=n(),Me=i("p"),Me.textContent=ht,Da=n(),o(he.$$.fragment),Pa=n(),I=i("div"),I.innerHTML=yt,Ka=n(),o(ye.$$.fragment),Oa=n(),be=i("p"),be.innerHTML=bt,el=n(),o(Je.$$.fragment),al=n(),o(fe.$$.fragment),ll=n(),Ze=i("p"),Ze.innerHTML=Jt,tl=n(),o(We.$$.fragment),nl=n(),Te=i("p"),Te.textContent=ft,sl=n(),we=i("p"),we.textContent=Zt,il=n(),o(Ue.$$.fragment),pl=n(),je=i("p"),je.textContent=Wt,ml=n(),o(Ge.$$.fragment),ol=n(),ke=i("p"),ke.textContent=Tt,rl=n(),o(Be.$$.fragment),cl=n(),v=i("div"),v.innerHTML=wt,dl=n(),o(Ie.$$.fragment),gl=n(),ve=i("p"),ve.textContent=Ut,ul=n(),Xe=i("p"),Xe.textContent=jt,Ml=n(),o(_e.$$.fragment),hl=n(),Fe=i("p"),Fe.textContent=Gt,yl=n(),o(Ye.$$.fragment),bl=n(),o(X.$$.fragment),Jl=n(),Ve=i("p"),Ve.innerHTML=kt,fl=n(),o(Re.$$.fragment),Zl=n(),_=i("div"),_.innerHTML=Bt,Wl=n(),xe=i("p"),xe.textContent=It,Tl=n(),o(Ce.$$.fragment),wl=n(),Ne=i("p"),Ne.innerHTML=vt,Ul=n(),o(Qe.$$.fragment),jl=n(),$e=i("p"),$e.innerHTML=Xt,Gl=n(),Se=i("p"),Se.innerHTML=_t,kl=n(),o(He.$$.fragment),Bl=n(),o(ze.$$.fragment),Il=n(),Ee=i("p"),Ee.textContent=Ft,vl=n(),Le=i("p"),Le.textContent=Yt,Xl=n(),o(qe.$$.fragment),_l=n(),Ae=i("p"),Ae.textContent=Vt,Fl=n(),o(De.$$.fragment),Yl=n(),Pe=i("p"),Pe.innerHTML=Rt,Vl=n(),o(Ke.$$.fragment),Rl=n(),F=i("div"),F.innerHTML=xt,xl=n(),o(Oe.$$.fragment),Cl=n(),ea=i("p"),ea.innerHTML=Ct,Nl=n(),aa=i("p"),aa.textContent=Nt,Ql=n(),o(la.$$.fragment),$l=n(),ta=i("p"),ta.innerHTML=Qt,Sl=n(),o(na.$$.fragment),Hl=n(),sa=i("p"),sa.innerHTML=$t,zl=n(),pa=i("p"),this.h()},l(e){const a=Kt("svelte-u9bgzb",document.head);M=p(a,"META",{name:!0,content:!0}),a.forEach(l),f=s(e),b=p(e,"P",{}),Ll(b).forEach(l),W=s(e),r(Y.$$.fragment,e),ma=s(e),r(V.$$.fragment,e),oa=s(e),R=p(e,"P",{"data-svelte-h":!0}),m(R)!=="svelte-1vjeoqc"&&(R.textContent=ql),ra=s(e),x=p(e,"P",{"data-svelte-h":!0}),m(x)!=="svelte-1t7j32f"&&(x.textContent=Al),ca=s(e),C=p(e,"OL",{"data-svelte-h":!0}),m(C)!=="svelte-1fn07c4"&&(C.innerHTML=Dl),da=s(e),r(N.$$.fragment,e),ga=s(e),r(T.$$.fragment,e),ua=s(e),w=p(e,"OL",{start:!0,"data-svelte-h":!0}),m(w)!=="svelte-1jtpcib"&&(w.innerHTML=Pl),Ma=s(e),r(Q.$$.fragment,e),ha=s(e),U=p(e,"OL",{start:!0,"data-svelte-h":!0}),m(U)!=="svelte-1przvba"&&(U.innerHTML=Kl),ya=s(e),r($.$$.fragment,e),ba=s(e),j=p(e,"DIV",{class:!0,"data-svelte-h":!0}),m(j)!=="svelte-72kdzo"&&(j.innerHTML=Ol),Ja=s(e),r(S.$$.fragment,e),fa=s(e),H=p(e,"P",{"data-svelte-h":!0}),m(H)!=="svelte-ic55ez"&&(H.textContent=et),Za=s(e),z=p(e,"P",{"data-svelte-h":!0}),m(z)!=="svelte-87gmw5"&&(z.innerHTML=at),Wa=s(e),Z=p(e,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),Ll(Z).forEach(l),Ta=s(e),r(E.$$.fragment,e),wa=s(e),L=p(e,"P",{"data-svelte-h":!0}),m(L)!=="svelte-5vkfn3"&&(L.innerHTML=tt),Ua=s(e),r(q.$$.fragment,e),ja=s(e),A=p(e,"P",{"data-svelte-h":!0}),m(A)!=="svelte-siyv04"&&(A.textContent=nt),Ga=s(e),r(D.$$.fragment,e),ka=s(e),r(P.$$.fragment,e),Ba=s(e),K=p(e,"P",{"data-svelte-h":!0}),m(K)!=="svelte-1grw9dr"&&(K.innerHTML=st),Ia=s(e),r(O.$$.fragment,e),va=s(e),r(ee.$$.fragment,e),Xa=s(e),ae=p(e,"P",{"data-svelte-h":!0}),m(ae)!=="svelte-19inqtq"&&(ae.innerHTML=it),_a=s(e),r(le.$$.fragment,e),Fa=s(e),G=p(e,"DIV",{class:!0,"data-svelte-h":!0}),m(G)!=="svelte-xc2o0t"&&(G.innerHTML=pt),Ya=s(e),r(te.$$.fragment,e),Va=s(e),ne=p(e,"P",{"data-svelte-h":!0}),m(ne)!=="svelte-13ocbdc"&&(ne.textContent=mt),Ra=s(e),r(se.$$.fragment,e),xa=s(e),ie=p(e,"P",{"data-svelte-h":!0}),m(ie)!=="svelte-qcb5md"&&(ie.innerHTML=ot),Ca=s(e),pe=p(e,"UL",{"data-svelte-h":!0}),m(pe)!=="svelte-vvcg88"&&(pe.innerHTML=rt),Na=s(e),r(me.$$.fragment,e),Qa=s(e),k=p(e,"DIV",{class:!0,"data-svelte-h":!0}),m(k)!=="svelte-1vmqp5s"&&(k.innerHTML=ct),$a=s(e),r(oe.$$.fragment,e),Sa=s(e),re=p(e,"P",{"data-svelte-h":!0}),m(re)!=="svelte-zcb81p"&&(re.innerHTML=dt),Ha=s(e),ce=p(e,"UL",{"data-svelte-h":!0}),m(ce)!=="svelte-cnggx4"&&(ce.innerHTML=gt),za=s(e),de=p(e,"P",{"data-svelte-h":!0}),m(de)!=="svelte-196id8d"&&(de.innerHTML=ut),Ea=s(e),r(ge.$$.fragment,e),La=s(e),B=p(e,"DIV",{class:!0,"data-svelte-h":!0}),m(B)!=="svelte-1cwhpu7"&&(B.innerHTML=Mt),qa=s(e),r(ue.$$.fragment,e),Aa=s(e),Me=p(e,"P",{"data-svelte-h":!0}),m(Me)!=="svelte-1ru9kar"&&(Me.textContent=ht),Da=s(e),r(he.$$.fragment,e),Pa=s(e),I=p(e,"DIV",{class:!0,"data-svelte-h":!0}),m(I)!=="svelte-15bd4ta"&&(I.innerHTML=yt),Ka=s(e),r(ye.$$.fragment,e),Oa=s(e),be=p(e,"P",{"data-svelte-h":!0}),m(be)!=="svelte-38j9px"&&(be.innerHTML=bt),el=s(e),r(Je.$$.fragment,e),al=s(e),r(fe.$$.fragment,e),ll=s(e),Ze=p(e,"P",{"data-svelte-h":!0}),m(Ze)!=="svelte-r6qkkm"&&(Ze.innerHTML=Jt),tl=s(e),r(We.$$.fragment,e),nl=s(e),Te=p(e,"P",{"data-svelte-h":!0}),m(Te)!=="svelte-1uqw6jr"&&(Te.textContent=ft),sl=s(e),we=p(e,"P",{"data-svelte-h":!0}),m(we)!=="svelte-1kzp8f0"&&(we.textContent=Zt),il=s(e),r(Ue.$$.fragment,e),pl=s(e),je=p(e,"P",{"data-svelte-h":!0}),m(je)!=="svelte-yqefj6"&&(je.textContent=Wt),ml=s(e),r(Ge.$$.fragment,e),ol=s(e),ke=p(e,"P",{"data-svelte-h":!0}),m(ke)!=="svelte-ua49j1"&&(ke.textContent=Tt),rl=s(e),r(Be.$$.fragment,e),cl=s(e),v=p(e,"DIV",{class:!0,"data-svelte-h":!0}),m(v)!=="svelte-15ens2s"&&(v.innerHTML=wt),dl=s(e),r(Ie.$$.fragment,e),gl=s(e),ve=p(e,"P",{"data-svelte-h":!0}),m(ve)!=="svelte-16qmg1v"&&(ve.textContent=Ut),ul=s(e),Xe=p(e,"P",{"data-svelte-h":!0}),m(Xe)!=="svelte-1du3njh"&&(Xe.textContent=jt),Ml=s(e),r(_e.$$.fragment,e),hl=s(e),Fe=p(e,"P",{"data-svelte-h":!0}),m(Fe)!=="svelte-j4alid"&&(Fe.textContent=Gt),yl=s(e),r(Ye.$$.fragment,e),bl=s(e),r(X.$$.fragment,e),Jl=s(e),Ve=p(e,"P",{"data-svelte-h":!0}),m(Ve)!=="svelte-2t52xe"&&(Ve.innerHTML=kt),fl=s(e),r(Re.$$.fragment,e),Zl=s(e),_=p(e,"DIV",{class:!0,"data-svelte-h":!0}),m(_)!=="svelte-1lbnv8n"&&(_.innerHTML=Bt),Wl=s(e),xe=p(e,"P",{"data-svelte-h":!0}),m(xe)!=="svelte-1fd5b22"&&(xe.textContent=It),Tl=s(e),r(Ce.$$.fragment,e),wl=s(e),Ne=p(e,"P",{"data-svelte-h":!0}),m(Ne)!=="svelte-1gc804h"&&(Ne.innerHTML=vt),Ul=s(e),r(Qe.$$.fragment,e),jl=s(e),$e=p(e,"P",{"data-svelte-h":!0}),m($e)!=="svelte-6zcpc0"&&($e.innerHTML=Xt),Gl=s(e),Se=p(e,"P",{"data-svelte-h":!0}),m(Se)!=="svelte-1ar98vz"&&(Se.innerHTML=_t),kl=s(e),r(He.$$.fragment,e),Bl=s(e),r(ze.$$.fragment,e),Il=s(e),Ee=p(e,"P",{"data-svelte-h":!0}),m(Ee)!=="svelte-3rypf9"&&(Ee.textContent=Ft),vl=s(e),Le=p(e,"P",{"data-svelte-h":!0}),m(Le)!=="svelte-1x7ee8u"&&(Le.textContent=Yt),Xl=s(e),r(qe.$$.fragment,e),_l=s(e),Ae=p(e,"P",{"data-svelte-h":!0}),m(Ae)!=="svelte-db3ja"&&(Ae.textContent=Vt),Fl=s(e),r(De.$$.fragment,e),Yl=s(e),Pe=p(e,"P",{"data-svelte-h":!0}),m(Pe)!=="svelte-iaoixt"&&(Pe.innerHTML=Rt),Vl=s(e),r(Ke.$$.fragment,e),Rl=s(e),F=p(e,"DIV",{class:!0,"data-svelte-h":!0}),m(F)!=="svelte-9rfwwm"&&(F.innerHTML=xt),xl=s(e),r(Oe.$$.fragment,e),Cl=s(e),ea=p(e,"P",{"data-svelte-h":!0}),m(ea)!=="svelte-1f04pnr"&&(ea.innerHTML=Ct),Nl=s(e),aa=p(e,"P",{"data-svelte-h":!0}),m(aa)!=="svelte-1eqbc05"&&(aa.textContent=Nt),Ql=s(e),r(la.$$.fragment,e),$l=s(e),ta=p(e,"P",{"data-svelte-h":!0}),m(ta)!=="svelte-c3yozi"&&(ta.innerHTML=Qt),Sl=s(e),r(na.$$.fragment,e),Hl=s(e),sa=p(e,"P",{"data-svelte-h":!0}),m(sa)!=="svelte-ve8eie"&&(sa.innerHTML=$t),zl=s(e),pa=p(e,"P",{}),Ll(pa).forEach(l),this.h()},h(){J(M,"name","hf:doc:metadata"),J(M,"content",nn),J(w,"start","2"),J(U,"start","3"),J(j,"class","flex gap-4"),qt(Z.src,lt="https://stevhliu-inpaint-mask-maker.hf.space")||J(Z,"src",lt),J(Z,"frameborder","0"),J(Z,"width","850"),J(Z,"height","450"),J(G,"class","flex flex-row gap-4"),J(k,"class","flex flex-row gap-4"),J(B,"class","flex flex-row gap-4"),J(I,"class","flex justify-center"),J(v,"class","flex flex-row gap-4"),J(_,"class","flex flex-row gap-4"),J(F,"class","flex flex-row gap-4")},m(e,a){Ot(document.head,M),t(e,f,a),t(e,b,a),t(e,W,a),c(Y,e,a),t(e,ma,a),c(V,e,a),t(e,oa,a),t(e,R,a),t(e,ra,a),t(e,x,a),t(e,ca,a),t(e,C,a),t(e,da,a),c(N,e,a),t(e,ga,a),c(T,e,a),t(e,ua,a),t(e,w,a),t(e,Ma,a),c(Q,e,a),t(e,ha,a),t(e,U,a),t(e,ya,a),c($,e,a),t(e,ba,a),t(e,j,a),t(e,Ja,a),c(S,e,a),t(e,fa,a),t(e,H,a),t(e,Za,a),t(e,z,a),t(e,Wa,a),t(e,Z,a),t(e,Ta,a),c(E,e,a),t(e,wa,a),t(e,L,a),t(e,Ua,a),c(q,e,a),t(e,ja,a),t(e,A,a),t(e,Ga,a),c(D,e,a),t(e,ka,a),c(P,e,a),t(e,Ba,a),t(e,K,a),t(e,Ia,a),c(O,e,a),t(e,va,a),c(ee,e,a),t(e,Xa,a),t(e,ae,a),t(e,_a,a),c(le,e,a),t(e,Fa,a),t(e,G,a),t(e,Ya,a),c(te,e,a),t(e,Va,a),t(e,ne,a),t(e,Ra,a),c(se,e,a),t(e,xa,a),t(e,ie,a),t(e,Ca,a),t(e,pe,a),t(e,Na,a),c(me,e,a),t(e,Qa,a),t(e,k,a),t(e,$a,a),c(oe,e,a),t(e,Sa,a),t(e,re,a),t(e,Ha,a),t(e,ce,a),t(e,za,a),t(e,de,a),t(e,Ea,a),c(ge,e,a),t(e,La,a),t(e,B,a),t(e,qa,a),c(ue,e,a),t(e,Aa,a),t(e,Me,a),t(e,Da,a),c(he,e,a),t(e,Pa,a),t(e,I,a),t(e,Ka,a),c(ye,e,a),t(e,Oa,a),t(e,be,a),t(e,el,a),c(Je,e,a),t(e,al,a),c(fe,e,a),t(e,ll,a),t(e,Ze,a),t(e,tl,a),c(We,e,a),t(e,nl,a),t(e,Te,a),t(e,sl,a),t(e,we,a),t(e,il,a),c(Ue,e,a),t(e,pl,a),t(e,je,a),t(e,ml,a),c(Ge,e,a),t(e,ol,a),t(e,ke,a),t(e,rl,a),c(Be,e,a),t(e,cl,a),t(e,v,a),t(e,dl,a),c(Ie,e,a),t(e,gl,a),t(e,ve,a),t(e,ul,a),t(e,Xe,a),t(e,Ml,a),c(_e,e,a),t(e,hl,a),t(e,Fe,a),t(e,yl,a),c(Ye,e,a),t(e,bl,a),c(X,e,a),t(e,Jl,a),t(e,Ve,a),t(e,fl,a),c(Re,e,a),t(e,Zl,a),t(e,_,a),t(e,Wl,a),t(e,xe,a),t(e,Tl,a),c(Ce,e,a),t(e,wl,a),t(e,Ne,a),t(e,Ul,a),c(Qe,e,a),t(e,jl,a),t(e,$e,a),t(e,Gl,a),t(e,Se,a),t(e,kl,a),c(He,e,a),t(e,Bl,a),c(ze,e,a),t(e,Il,a),t(e,Ee,a),t(e,vl,a),t(e,Le,a),t(e,Xl,a),c(qe,e,a),t(e,_l,a),t(e,Ae,a),t(e,Fl,a),c(De,e,a),t(e,Yl,a),t(e,Pe,a),t(e,Vl,a),c(Ke,e,a),t(e,Rl,a),t(e,F,a),t(e,xl,a),c(Oe,e,a),t(e,Cl,a),t(e,ea,a),t(e,Nl,a),t(e,aa,a),t(e,Ql,a),c(la,e,a),t(e,$l,a),t(e,ta,a),t(e,Sl,a),c(na,e,a),t(e,Hl,a),t(e,sa,a),t(e,zl,a),t(e,pa,a),El=!0},p(e,[a]){const St={};a&2&&(St.$$scope={dirty:a,ctx:e}),T.$set(St);const Ht={};a&2&&(Ht.$$scope={dirty:a,ctx:e}),X.$set(Ht)},i(e){El||(d(Y.$$.fragment,e),d(V.$$.fragment,e),d(N.$$.fragment,e),d(T.$$.fragment,e),d(Q.$$.fragment,e),d($.$$.fragment,e),d(S.$$.fragment,e),d(E.$$.fragment,e),d(q.$$.fragment,e),d(D.$$.fragment,e),d(P.$$.fragment,e),d(O.$$.fragment,e),d(ee.$$.fragment,e),d(le.$$.fragment,e),d(te.$$.fragment,e),d(se.$$.fragment,e),d(me.$$.fragment,e),d(oe.$$.fragment,e),d(ge.$$.fragment,e),d(ue.$$.fragment,e),d(he.$$.fragment,e),d(ye.$$.fragment,e),d(Je.$$.fragment,e),d(fe.$$.fragment,e),d(We.$$.fragment,e),d(Ue.$$.fragment,e),d(Ge.$$.fragment,e),d(Be.$$.fragment,e),d(Ie.$$.fragment,e),d(_e.$$.fragment,e),d(Ye.$$.fragment,e),d(X.$$.fragment,e),d(Re.$$.fragment,e),d(Ce.$$.fragment,e),d(Qe.$$.fragment,e),d(He.$$.fragment,e),d(ze.$$.fragment,e),d(qe.$$.fragment,e),d(De.$$.fragment,e),d(Ke.$$.fragment,e),d(Oe.$$.fragment,e),d(la.$$.fragment,e),d(na.$$.fragment,e),El=!0)},o(e){g(Y.$$.fragment,e),g(V.$$.fragment,e),g(N.$$.fragment,e),g(T.$$.fragment,e),g(Q.$$.fragment,e),g($.$$.fragment,e),g(S.$$.fragment,e),g(E.$$.fragment,e),g(q.$$.fragment,e),g(D.$$.fragment,e),g(P.$$.fragment,e),g(O.$$.fragment,e),g(ee.$$.fragment,e),g(le.$$.fragment,e),g(te.$$.fragment,e),g(se.$$.fragment,e),g(me.$$.fragment,e),g(oe.$$.fragment,e),g(ge.$$.fragment,e),g(ue.$$.fragment,e),g(he.$$.fragment,e),g(ye.$$.fragment,e),g(Je.$$.fragment,e),g(fe.$$.fragment,e),g(We.$$.fragment,e),g(Ue.$$.fragment,e),g(Ge.$$.fragment,e),g(Be.$$.fragment,e),g(Ie.$$.fragment,e),g(_e.$$.fragment,e),g(Ye.$$.fragment,e),g(X.$$.fragment,e),g(Re.$$.fragment,e),g(Ce.$$.fragment,e),g(Qe.$$.fragment,e),g(He.$$.fragment,e),g(ze.$$.fragment,e),g(qe.$$.fragment,e),g(De.$$.fragment,e),g(Ke.$$.fragment,e),g(Oe.$$.fragment,e),g(la.$$.fragment,e),g(na.$$.fragment,e),El=!1},d(e){e&&(l(f),l(b),l(W),l(ma),l(oa),l(R),l(ra),l(x),l(ca),l(C),l(da),l(ga),l(ua),l(w),l(Ma),l(ha),l(U),l(ya),l(ba),l(j),l(Ja),l(fa),l(H),l(Za),l(z),l(Wa),l(Z),l(Ta),l(wa),l(L),l(Ua),l(ja),l(A),l(Ga),l(ka),l(Ba),l(K),l(Ia),l(va),l(Xa),l(ae),l(_a),l(Fa),l(G),l(Ya),l(Va),l(ne),l(Ra),l(xa),l(ie),l(Ca),l(pe),l(Na),l(Qa),l(k),l($a),l(Sa),l(re),l(Ha),l(ce),l(za),l(de),l(Ea),l(La),l(B),l(qa),l(Aa),l(Me),l(Da),l(Pa),l(I),l(Ka),l(Oa),l(be),l(el),l(al),l(ll),l(Ze),l(tl),l(nl),l(Te),l(sl),l(we),l(il),l(pl),l(je),l(ml),l(ol),l(ke),l(rl),l(cl),l(v),l(dl),l(gl),l(ve),l(ul),l(Xe),l(Ml),l(hl),l(Fe),l(yl),l(bl),l(Jl),l(Ve),l(fl),l(Zl),l(_),l(Wl),l(xe),l(Tl),l(wl),l(Ne),l(Ul),l(jl),l($e),l(Gl),l(Se),l(kl),l(Bl),l(Il),l(Ee),l(vl),l(Le),l(Xl),l(_l),l(Ae),l(Fl),l(Yl),l(Pe),l(Vl),l(Rl),l(F),l(xl),l(Cl),l(ea),l(Nl),l(aa),l(Ql),l($l),l(ta),l(Sl),l(Hl),l(sa),l(zl),l(pa)),l(M),u(Y,e),u(V,e),u(N,e),u(T,e),u(Q,e),u($,e),u(S,e),u(E,e),u(q,e),u(D,e),u(P,e),u(O,e),u(ee,e),u(le,e),u(te,e),u(se,e),u(me,e),u(oe,e),u(ge,e),u(ue,e),u(he,e),u(ye,e),u(Je,e),u(fe,e),u(We,e),u(Ue,e),u(Ge,e),u(Be,e),u(Ie,e),u(_e,e),u(Ye,e),u(X,e),u(Re,e),u(Ce,e),u(Qe,e),u(He,e),u(ze,e),u(qe,e),u(De,e),u(Ke,e),u(Oe,e),u(la,e),u(na,e)}}}const nn='{"title":"Inpainting","local":"inpainting","sections":[{"title":"Create a mask image","local":"create-a-mask-image","sections":[],"depth":2},{"title":"Popular models","local":"popular-models","sections":[{"title":"Stable Diffusion Inpainting","local":"stable-diffusion-inpainting","sections":[],"depth":3},{"title":"Stable Diffusion XL (SDXL) Inpainting","local":"stable-diffusion-xl-sdxl-inpainting","sections":[],"depth":3},{"title":"Kandinsky 2.2 Inpainting","local":"kandinsky-22-inpainting","sections":[],"depth":3}],"depth":2},{"title":"Configure pipeline parameters","local":"configure-pipeline-parameters","sections":[{"title":"Strength","local":"strength","sections":[],"depth":3},{"title":"Guidance scale","local":"guidance-scale","sections":[],"depth":3},{"title":"Negative prompt","local":"negative-prompt","sections":[],"depth":3}],"depth":2},{"title":"Preserve unmasked areas","local":"preserve-unmasked-areas","sections":[],"depth":2},{"title":"Chained inpainting pipelines","local":"chained-inpainting-pipelines","sections":[{"title":"Text-to-image-to-inpaint","local":"text-to-image-to-inpaint","sections":[],"depth":3},{"title":"Inpaint-to-image-to-image","local":"inpaint-to-image-to-image","sections":[],"depth":3}],"depth":2},{"title":"Control image generation","local":"control-image-generation","sections":[{"title":"Prompt weighting","local":"prompt-weighting","sections":[],"depth":3},{"title":"ControlNet","local":"controlnet","sections":[],"depth":3}],"depth":2},{"title":"Optimize","local":"optimize","sections":[],"depth":2}],"depth":1}';function sn(ia){return At(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class gn extends Dt{constructor(M){super(),Pt(this,M,sn,tn,Lt,{})}}export{gn as component};
