import{S as Tc,i as Uc,s as _c,e as r,k as d,w as M,t as a,M as hc,c as n,d as s,m as p,a as i,x as y,h as o,b as m,G as l,g as c,y as b,q as J,o as w,B as j,v as vc}from"../chunks/vendor-hf-doc-builder.js";import{T as Rn}from"../chunks/Tip-hf-doc-builder.js";import{I as _l}from"../chunks/IconCopyLink-hf-doc-builder.js";import{C as v}from"../chunks/CodeBlock-hf-doc-builder.js";function Cc(ae){let u,C;return{c(){u=r("p"),C=a("Si tu modelo es muy similar a un modelo dentro de la biblioteca, puedes reutilizar la misma configuraci\xF3n de ese modelo.")},l(f){u=n(f,"P",{});var T=i(u);C=o(T,"Si tu modelo es muy similar a un modelo dentro de la biblioteca, puedes reutilizar la misma configuraci\xF3n de ese modelo."),T.forEach(s)},m(f,T){c(f,u,T),l(u,C)},d(f){f&&s(u)}}}function Ec(ae){let u,C,f,T,A;return{c(){u=r("p"),C=a("Esta "),f=r("em"),T=a("API"),A=a(" es experimental y puede tener algunos cambios leves en las pr\xF3ximas versiones.")},l(_){u=n(_,"P",{});var h=i(u);C=o(h,"Esta "),f=n(h,"EM",{});var q=i(f);T=o(q,"API"),q.forEach(s),A=o(h," es experimental y puede tener algunos cambios leves en las pr\xF3ximas versiones."),h.forEach(s)},m(_,h){c(_,u,h),l(u,C),l(u,f),l(f,T),l(u,A)},d(_){_&&s(u)}}}function gc(ae){let u,C,f,T,A;return{c(){u=r("p"),C=a(`Si copias archivos del modelo desde la biblioteca, deber\xE1s reemplazar todas las importaciones relativas en la parte superior
del archivo para importarlos desde el paquete `),f=r("code"),T=a("transformers"),A=a(".")},l(_){u=n(_,"P",{});var h=i(u);C=o(h,`Si copias archivos del modelo desde la biblioteca, deber\xE1s reemplazar todas las importaciones relativas en la parte superior
del archivo para importarlos desde el paquete `),f=n(h,"CODE",{});var q=i(f);T=o(q,"transformers"),q.forEach(s),A=o(h,"."),h.forEach(s)},m(_,h){c(_,u,h),l(u,C),l(u,f),l(f,T),l(u,A)},d(_){_&&s(u)}}}function Ic(ae){let u,C,f,T,A,_,h,q,fo,Vs,Ke,Mo,Ys,el,yo,Qs,W,bo,Ce,Jo,wo,hl,jo,To,Fs,O,oe,vl,Ee,Uo,Cl,_o,Ps,te,ho,El,vo,Co,Ds,ll,Eo,Hs,ge,Ss,sl,go,xs,X,Ie,Io,gl,Zo,Ao,$o,z,ko,Il,No,Ro,Zl,Bo,qo,Al,zo,Wo,Xo,L,Go,$l,Vo,Yo,kl,Qo,Fo,Os,g,Po,Nl,Do,Ho,Rl,So,xo,Bl,Oo,Lo,ql,Ko,et,Ls,G,lt,zl,st,at,Wl,ot,tt,Ks,al,rt,ea,Ze,la,$,nt,Xl,it,ct,Gl,dt,pt,Vl,ut,mt,sa,Ae,aa,V,ft,Yl,Mt,yt,Ql,bt,Jt,oa,K,re,Fl,$e,wt,Pl,jt,ta,Y,Tt,Dl,Ut,_t,Hl,ht,vt,ra,Q,Ct,Sl,Et,gt,xl,It,Zt,na,ke,ia,ne,At,Ol,$t,kt,ca,Ne,da,I,Nt,Ll,Rt,Bt,Kl,qt,zt,es,Wt,Xt,ls,Gt,Vt,pa,ie,ua,k,Yt,ss,Qt,Ft,as,Pt,Dt,os,Ht,St,ma,ol,xt,fa,Re,Ma,N,Ot,ts,Lt,Kt,rs,er,lr,ns,sr,ar,ya,tl,or,ba,Be,Ja,F,tr,is,rr,nr,cs,ir,cr,wa,ee,ce,ds,qe,dr,ps,pr,ja,de,Ta,U,ur,us,mr,fr,ms,Mr,yr,fs,br,Jr,Ms,wr,jr,ys,Tr,Ur,bs,_r,hr,Js,vr,Cr,Ua,ze,_a,P,Er,ws,gr,Ir,js,Zr,Ar,ha,pe,va,rl,$r,Ca,nl,kr,Ea,We,ga,ue,Nr,Ts,Rr,Br,Ia,Xe,Za,me,qr,Us,zr,Wr,Aa,il,Xr,$a,Ge,ka,cl,Gr,Na,Ve,Ra,fe,Vr,_s,Yr,Qr,Ba,Ye,qa,dl,Fr,za,Qe,Wa,R,Pr,hs,Dr,Hr,vs,Sr,xr,Fe,Or,Lr,Xa,Me,Kr,pl,en,ln,Ga,le,ye,Cs,Pe,sn,Es,an,Va,Z,on,gs,tn,rn,Is,nn,cn,De,dn,pn,Zs,un,mn,Ya,He,Qa,be,fn,As,Mn,yn,Fa,Se,Pa,Je,bn,$s,Jn,wn,Da,se,we,ks,xe,jn,Ns,Tn,Ha,ul,Un,Sa,D,_n,Rs,hn,vn,Bs,Cn,En,xa,Oe,Oa,B,gn,qs,In,Zn,zs,An,$n,Ws,kn,Nn,La;return _=new _l({}),Ee=new _l({}),ge=new v({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PretrainedConfig
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetConfig</span>(<span class="hljs-title class_ inherited__">PretrainedConfig</span>):
    model_type = <span class="hljs-string">&quot;resnet&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">
        self,
        block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>,
        layers: <span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>] = [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">6</span>, <span class="hljs-number">3</span>],
        num_classes: <span class="hljs-built_in">int</span> = <span class="hljs-number">1000</span>,
        input_channels: <span class="hljs-built_in">int</span> = <span class="hljs-number">3</span>,
        cardinality: <span class="hljs-built_in">int</span> = <span class="hljs-number">1</span>,
        base_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_type: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;&quot;</span>,
        avg_down: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>,
        **kwargs,
    </span>):
        <span class="hljs-keyword">if</span> block_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;basic&quot;</span>, <span class="hljs-string">&quot;bottleneck&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`block_type\` must be &#x27;basic&#x27; or bottleneck&#x27;, got <span class="hljs-subst">{block_type}</span>.&quot;</span>)
        <span class="hljs-keyword">if</span> stem_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;&quot;</span>, <span class="hljs-string">&quot;deep&quot;</span>, <span class="hljs-string">&quot;deep-tiered&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`stem_type\` must be &#x27;&#x27;, &#x27;deep&#x27; or &#x27;deep-tiered&#x27;, got <span class="hljs-subst">{stem_type}</span>.&quot;</span>)

        self.block_type = block_type
        self.layers = layers
        self.num_classes = num_classes
        self.input_channels = input_channels
        self.cardinality = cardinality
        self.base_width = base_width
        self.stem_width = stem_width
        self.stem_type = stem_type
        self.avg_down = avg_down
        <span class="hljs-built_in">super</span>().__init__(**kwargs)`}}),Ze=new v({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkX2NvbmZpZy5zYXZlX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d_config.save_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)`}}),Ae=new v({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:'resnet50d_config = ResnetConfig.from_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)'}}),$e=new _l({}),ke=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRNb2RlbCUwQWZyb20lMjB0aW1tLm1vZGVscy5yZXNuZXQlMjBpbXBvcnQlMjBCYXNpY0Jsb2NrJTJDJTIwQm90dGxlbmVjayUyQyUyMFJlc05ldCUwQWZyb20lMjAuY29uZmlndXJhdGlvbl9yZXNuZXQlMjBpbXBvcnQlMjBSZXNuZXRDb25maWclMEElMEElMEFCTE9DS19NQVBQSU5HJTIwJTNEJTIwJTdCJTIyYmFzaWMlMjIlM0ElMjBCYXNpY0Jsb2NrJTJDJTIwJTIyYm90dGxlbmVjayUyMiUzQSUyMEJvdHRsZW5lY2slN0QlMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsKFByZVRyYWluZWRNb2RlbCklM0ElMEElMjAlMjAlMjAlMjBjb25maWdfY2xhc3MlMjAlM0QlMjBSZXNuZXRDb25maWclMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwY29uZmlnKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oY29uZmlnKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJsb2NrX2xheWVyJTIwJTNEJTIwQkxPQ0tfTUFQUElORyU1QmNvbmZpZy5ibG9ja190eXBlJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5tb2RlbCUyMCUzRCUyMFJlc05ldCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbmZpZy5sYXllcnMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fY2xhc3NlcyUzRGNvbmZpZy5udW1fY2xhc3NlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluX2NoYW5zJTNEY29uZmlnLmlucHV0X2NoYW5uZWxzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2FyZGluYWxpdHklM0Rjb25maWcuY2FyZGluYWxpdHklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXNlX3dpZHRoJTNEY29uZmlnLmJhc2Vfd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3dpZHRoJTNEY29uZmlnLnN0ZW1fd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3R5cGUlM0Rjb25maWcuc3RlbV90eXBlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXZnX2Rvd24lM0Rjb25maWcuYXZnX2Rvd24lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwdGVuc29yKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHNlbGYubW9kZWwuZm9yd2FyZF9mZWF0dXJlcyh0ZW5zb3Ip",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedModel
<span class="hljs-keyword">from</span> timm.models.resnet <span class="hljs-keyword">import</span> BasicBlock, Bottleneck, ResNet
<span class="hljs-keyword">from</span> .configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig


BLOCK_MAPPING = {<span class="hljs-string">&quot;basic&quot;</span>: BasicBlock, <span class="hljs-string">&quot;bottleneck&quot;</span>: Bottleneck}


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModel</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor</span>):
        <span class="hljs-keyword">return</span> self.model.forward_features(tensor)`}}),Ne=new v({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbihQcmVUcmFpbmVkTW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwY29uZmlnX2NsYXNzJTIwJTNEJTIwUmVzbmV0Q29uZmlnJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGNvbmZpZyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKGNvbmZpZyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyMCUzRCUyMEJMT0NLX01BUFBJTkclNUJjb25maWcuYmxvY2tfdHlwZSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubW9kZWwlMjAlM0QlMjBSZXNOZXQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmxvY2tfbGF5ZXIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb25maWcubGF5ZXJzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2NsYXNzZXMlM0Rjb25maWcubnVtX2NsYXNzZXMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbl9jaGFucyUzRGNvbmZpZy5pbnB1dF9jaGFubmVscyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhcmRpbmFsaXR5JTNEY29uZmlnLmNhcmRpbmFsaXR5JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmFzZV93aWR0aCUzRGNvbmZpZy5iYXNlX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV93aWR0aCUzRGNvbmZpZy5zdGVtX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV90eXBlJTNEY29uZmlnLnN0ZW1fdHlwZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF2Z19kb3duJTNEY29uZmlnLmF2Z19kb3duJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHRlbnNvciUyQyUyMGxhYmVscyUzRE5vbmUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwc2VsZi5tb2RlbCh0ZW5zb3IpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsYWJlbHMlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwdG9yY2gubm4uY3Jvc3NfZW50cm9weShsb2dpdHMlMkMlMjBsYWJlbHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIybG9zcyUyMiUzQSUyMGxvc3MlMkMlMjAlMjJsb2dpdHMlMjIlM0ElMjBsb2dpdHMlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJsb2dpdHMlMjIlM0ElMjBsb2dpdHMlN0Q=",highlighted:`<span class="hljs-keyword">import</span> torch


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModelForImageClassification</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor, labels=<span class="hljs-literal">None</span></span>):
        logits = self.model(tensor)
        <span class="hljs-keyword">if</span> labels <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            loss = torch.nn.cross_entropy(logits, labels)
            <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;loss&quot;</span>: loss, <span class="hljs-string">&quot;logits&quot;</span>: logits}
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;logits&quot;</span>: logits}`}}),ie=new Rn({props:{$$slots:{default:[Cc]},$$scope:{ctx:ae}}}),Re=new v({props:{code:"cmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcp",highlighted:"resnet50d = ResnetModelForImageClassification(resnet50d_config)"}}),Be=new v({props:{code:"aW1wb3J0JTIwdGltbSUwQSUwQXByZXRyYWluZWRfbW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCglMjJyZXNuZXQ1MGQlMjIlMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFyZXNuZXQ1MGQubW9kZWwubG9hZF9zdGF0ZV9kaWN0KHByZXRyYWluZWRfbW9kZWwuc3RhdGVfZGljdCgpKQ==",highlighted:`<span class="hljs-keyword">import</span> timm

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`}}),qe=new _l({}),de=new Rn({props:{warning:!0,$$slots:{default:[Ec]},$$scope:{ctx:ae}}}),ze=new v({props:{code:"LiUwQSVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMHJlc25ldF9tb2RlbCUwQSUyMCUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMF9faW5pdF9fLnB5JTBBJTIwJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwY29uZmlndXJhdGlvbl9yZXNuZXQucHklMEElMjAlMjAlMjAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjBtb2RlbGluZ19yZXNuZXQucHk=",highlighted:`.
\u2514\u2500\u2500 resnet_model
    \u251C\u2500\u2500 __init__.<span class="hljs-keyword">py</span>
    \u251C\u2500\u2500 configuration_resnet.<span class="hljs-keyword">py</span>
    \u2514\u2500\u2500 modeling_resnet.<span class="hljs-keyword">py</span>`}}),pe=new Rn({props:{warning:!0,$$slots:{default:[gc]},$$scope:{ctx:ae}}}),We=new v({props:{code:"ZnJvbSUyMHJlc25ldF9tb2RlbC5jb25maWd1cmF0aW9uX3Jlc25ldCUyMGltcG9ydCUyMFJlc25ldENvbmZpZyUwQWZyb20lMjByZXNuZXRfbW9kZWwubW9kZWxpbmdfcmVzbmV0JTIwaW1wb3J0JTIwUmVzbmV0TW9kZWwlMkMlMjBSZXNuZXRNb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24=",highlighted:`<span class="hljs-keyword">from</span> resnet_model.configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig
<span class="hljs-keyword">from</span> resnet_model.modeling_resnet <span class="hljs-keyword">import</span> ResnetModel, ResnetModelForImageClassification`}}),Xe=new v({props:{code:"UmVzbmV0Q29uZmlnLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCklMEFSZXNuZXRNb2RlbC5yZWdpc3Rlcl9mb3JfYXV0b19jbGFzcyglMjJBdXRvTW9kZWwlMjIpJTBBUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCUyMkF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMjIp",highlighted:`ResnetConfig.register_for_auto_class()
ResnetModel.register_for_auto_class(<span class="hljs-string">&quot;AutoModel&quot;</span>)
ResnetModelForImageClassification.register_for_auto_class(<span class="hljs-string">&quot;AutoModelForImageClassification&quot;</span>)`}}),Ge=new v({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcpJTBBJTBBcHJldHJhaW5lZF9tb2RlbCUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCUyMnJlc25ldDUwZCUyMiUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQXJlc25ldDUwZC5tb2RlbC5sb2FkX3N0YXRlX2RpY3QocHJldHJhaW5lZF9tb2RlbC5zdGF0ZV9kaWN0KCkp",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d = ResnetModelForImageClassification(resnet50d_config)

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`}}),Ve=new v({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login"}}),Ye=new v({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`}}),Qe=new v({props:{code:"cmVzbmV0NTBkLnB1c2hfdG9faHViKCUyMmN1c3RvbS1yZXNuZXQ1MGQlMjIp",highlighted:'resnet50d.push_to_hub(<span class="hljs-string">&quot;custom-resnet50d&quot;</span>)'}}),Pe=new _l({}),He=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMnNndWdnZXIlMkZjdXN0b20tcmVzbmV0NTBkJTIyJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageClassification

model = AutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)`}}),Se=new v({props:{code:"Y29tbWl0X2hhc2glMjAlM0QlMjAlMjJlZDk0YTdjNjI0N2Q4YWVkY2U0NjQ3ZjAwZjIwZGU2ODc1YjViMjkyJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzZ3VnZ2VyJTJGY3VzdG9tLXJlc25ldDUwZCUyMiUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSUyQyUyMHJldmlzaW9uJTNEY29tbWl0X2hhc2glMEEp",highlighted:`commit_hash = <span class="hljs-string">&quot;ed94a7c6247d8aedce4647f00f20de6875b5b292&quot;</span>
model = AutoModelForImageClassification.from_pretrained(
    <span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>, revision=commit_hash
)`}}),xe=new _l({}),Oe=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWwlMkMlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBJTBBQXV0b0NvbmZpZy5yZWdpc3RlciglMjJyZXNuZXQlMjIlMkMlMjBSZXNuZXRDb25maWcpJTBBQXV0b01vZGVsLnJlZ2lzdGVyKFJlc25ldENvbmZpZyUyQyUyMFJlc25ldE1vZGVsKSUwQUF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24ucmVnaXN0ZXIoUmVzbmV0Q29uZmlnJTJDJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModel, AutoModelForImageClassification

AutoConfig.register(<span class="hljs-string">&quot;resnet&quot;</span>, ResnetConfig)
AutoModel.register(ResnetConfig, ResnetModel)
AutoModelForImageClassification.register(ResnetConfig, ResnetModelForImageClassification)`}}),{c(){u=r("meta"),C=d(),f=r("h1"),T=r("a"),A=r("span"),M(_.$$.fragment),h=d(),q=r("span"),fo=a("Compartir modelos personalizados"),Vs=d(),Ke=r("p"),Mo=a(`La biblioteca \u{1F917} Transformers est\xE1 dise\xF1ada para ser f\xE1cilmente ampliable. Cada modelo est\xE1 completamente codificado
sin abstracci\xF3n en una subcarpeta determinada del repositorio, por lo que puedes copiar f\xE1cilmente un archivo del modelo
y ajustarlo seg\xFAn tus necesidades.`),Ys=d(),el=r("p"),yo=a(`Si est\xE1s escribiendo un modelo completamente nuevo, podr\xEDa ser m\xE1s f\xE1cil comenzar desde cero. En este tutorial, te mostraremos
c\xF3mo escribir un modelo personalizado y su configuraci\xF3n para que pueda usarse dentro de Transformers, y c\xF3mo puedes compartirlo
con la comunidad (con el c\xF3digo en el que se basa) para que cualquiera pueda usarlo, incluso si no est\xE1 presente en la biblioteca
\u{1F917} Transformers.`),Qs=d(),W=r("p"),bo=a("Ilustraremos todo esto con un modelo ResNet, envolviendo la clase ResNet de la "),Ce=r("a"),Jo=a("biblioteca timm"),wo=a(" en un "),hl=r("code"),jo=a("PreTrainedModel"),To=a("."),Fs=d(),O=r("h2"),oe=r("a"),vl=r("span"),M(Ee.$$.fragment),Uo=d(),Cl=r("span"),_o=a("Escribir una configuraci\xF3n personalizada"),Ps=d(),te=r("p"),ho=a(`Antes de adentrarnos en el modelo, primero escribamos su configuraci\xF3n. La configuraci\xF3n de un modelo es un objeto que
contendr\xE1 toda la informaci\xF3n necesaria para construir el modelo. Como veremos en la siguiente secci\xF3n, el modelo solo puede
tomar un `),El=r("code"),vo=a("config"),Co=a(" para ser inicializado, por lo que realmente necesitamos que ese objeto est\xE9 lo m\xE1s completo posible."),Ds=d(),ll=r("p"),Eo=a(`En nuestro ejemplo, tomaremos un par de argumentos de la clase ResNet que tal vez queramos modificar. Las diferentes
configuraciones nos dar\xE1n los diferentes tipos de ResNet que son posibles. Luego simplemente almacenamos esos argumentos
despu\xE9s de verificar la validez de algunos de ellos.`),Hs=d(),M(ge.$$.fragment),Ss=d(),sl=r("p"),go=a("Las tres cosas importantes que debes recordar al escribir tu propia configuraci\xF3n son las siguientes:"),xs=d(),X=r("ul"),Ie=r("li"),Io=a("tienes que heredar de "),gl=r("code"),Zo=a("PretrainedConfig"),Ao=a(","),$o=d(),z=r("li"),ko=a("el "),Il=r("code"),No=a("__init__"),Ro=a(" de tu "),Zl=r("code"),Bo=a("PretrainedConfig"),qo=a(" debe aceptar cualquier "),Al=r("code"),zo=a("kwargs"),Wo=a(","),Xo=d(),L=r("li"),Go=a("esos "),$l=r("code"),Vo=a("kwargs"),Yo=a(" deben pasarse a la superclase "),kl=r("code"),Qo=a("__init__"),Fo=a("."),Os=d(),g=r("p"),Po=a(`La herencia es para asegurarte de obtener toda la funcionalidad de la biblioteca \u{1F917} Transformers, mientras que las otras dos
restricciones provienen del hecho de que una `),Nl=r("code"),Do=a("PretrainedConfig"),Ho=a(` tiene m\xE1s campos que los que est\xE1s configurando. Al recargar una
`),Rl=r("code"),So=a("config"),xo=a(" con el m\xE9todo "),Bl=r("code"),Oo=a("from_pretrained"),Lo=a(", esos campos deben ser aceptados por tu "),ql=r("code"),Ko=a("config"),et=a(" y luego enviados a la superclase."),Ls=d(),G=r("p"),lt=a("Definir un "),zl=r("code"),st=a("model_type"),at=a(" para tu configuraci\xF3n (en este caso "),Wl=r("code"),ot=a('model_type="resnet"'),tt=a(`) no es obligatorio, a menos que quieras
registrar tu modelo con las clases autom\xE1ticas (ver la \xFAltima secci\xF3n).`),Ks=d(),al=r("p"),rt=a(`Una vez hecho esto, puedes crear y guardar f\xE1cilmente tu configuraci\xF3n como lo har\xEDas con cualquier otra configuraci\xF3n de un
modelo de la biblioteca. As\xED es como podemos crear una configuraci\xF3n resnet50d y guardarla:`),ea=d(),M(Ze.$$.fragment),la=d(),$=r("p"),nt=a("Esto guardar\xE1 un archivo llamado "),Xl=r("code"),it=a("config.json"),ct=a(" dentro de la carpeta "),Gl=r("code"),dt=a("custom-resnet"),pt=a(`. Luego puedes volver a cargar tu configuraci\xF3n
con el m\xE9todo `),Vl=r("code"),ut=a("from_pretrained"),mt=a(":"),sa=d(),M(Ae.$$.fragment),aa=d(),V=r("p"),ft=a("Tambi\xE9n puedes usar cualquier otro m\xE9todo de la clase "),Yl=r("code"),Mt=a("PretrainedConfig"),yt=a(", como "),Ql=r("code"),bt=a("push_to_hub()"),Jt=a(`, para cargar
directamente tu configuraci\xF3n en el Hub.`),oa=d(),K=r("h2"),re=r("a"),Fl=r("span"),M($e.$$.fragment),wt=d(),Pl=r("span"),jt=a("Escribir un modelo personalizado"),ta=d(),Y=r("p"),Tt=a(`Ahora que tenemos nuestra configuraci\xF3n de ResNet, podemos seguir escribiendo el modelo. En realidad escribiremos dos: una que
extrae las caracter\xEDsticas ocultas de un grupo de im\xE1genes (como `),Dl=r("code"),Ut=a("BertModel"),_t=a(`) y una que es adecuada para clasificaci\xF3n de
imagenes (como `),Hl=r("code"),ht=a("BertForSequenceClassification"),vt=a(")."),ra=d(),Q=r("p"),Ct=a("Como mencionamos antes, solo escribiremos un envoltura ("),Sl=r("em"),Et=a("wrapper"),gt=a(`) libre del modelo para simplificar este ejemplo. Lo \xFAnico que debemos
hacer antes de escribir esta clase es un mapeo entre los tipos de bloques y las clases de bloques reales. Luego se define el
modelo desde la configuraci\xF3n pasando todo a la clase `),xl=r("code"),It=a("ResNet"),Zt=a(":"),na=d(),M(ke.$$.fragment),ia=d(),ne=r("p"),At=a("Para el modelo que clasificar\xE1 las im\xE1genes, solo cambiamos el m\xE9todo de avance (es decir, el m\xE9todo "),Ol=r("code"),$t=a("forward"),kt=a("):"),ca=d(),M(Ne.$$.fragment),da=d(),I=r("p"),Nt=a("En ambos casos, observa c\xF3mo heredamos de "),Ll=r("code"),Rt=a("PreTrainedModel"),Bt=a(" y llamamos a la inicializaci\xF3n de la superclase con "),Kl=r("code"),qt=a("config"),zt=a(`
(un poco como cuando escribes `),es=r("code"),Wt=a("torch.nn.Module"),Xt=a("). La l\xEDnea que establece "),ls=r("code"),Gt=a("config_class"),Vt=a(` no es obligatoria, a menos
que quieras registrar tu modelo con las clases autom\xE1ticas (consulta la \xFAltima secci\xF3n).`),pa=d(),M(ie.$$.fragment),ua=d(),k=r("p"),Yt=a(`Puedes hacer que tu modelo devuelva lo que quieras, pero devolver un diccionario como lo hicimos para
`),ss=r("code"),Qt=a("ResnetModelForImageClassification"),Ft=a(", con el "),as=r("code"),Pt=a("loss"),Dt=a(` incluido cuando se pasan las etiquetas, har\xE1 que tu modelo se pueda
usar directamente dentro de la clase `),os=r("code"),Ht=a("Trainer"),St=a(`. Usar otro formato de salida est\xE1 bien, siempre y cuando est\xE9s planeando usar
tu propio bucle de entrenamiento u otra biblioteca para el entrenamiento.`),ma=d(),ol=r("p"),xt=a("Ahora que tenemos nuestra clase, vamos a crear un modelo:"),fa=d(),M(Re.$$.fragment),Ma=d(),N=r("p"),Ot=a("Nuevamente, puedes usar cualquiera de los m\xE9todos de "),ts=r("code"),Lt=a("PreTrainedModel"),Kt=a(", como "),rs=r("code"),er=a("save_pretrained()"),lr=a(` o
`),ns=r("code"),sr=a("push_to_hub()"),ar=a(`. Usaremos el segundo en la siguiente secci\xF3n y veremos c\xF3mo pasar los pesos del modelo
con el c\xF3digo de nuestro modelo. Pero primero, carguemos algunos pesos previamente entrenados dentro de nuestro modelo.`),ya=d(),tl=r("p"),or=a(`En tu caso de uso, probablemente estar\xE1s entrenando tu modelo personalizado con tus propios datos. Para ir r\xE1pido en este
tutorial, usaremos la versi\xF3n preentrenada de resnet50d. Dado que nuestro modelo es solo un envoltorio alrededor del resnet50d
original, ser\xE1 f\xE1cil transferir esos pesos:`),ba=d(),M(Be.$$.fragment),Ja=d(),F=r("p"),tr=a("Ahora veamos c\xF3mo asegurarnos de que cuando hacemos "),is=r("code"),rr=a("save_pretrained()"),nr=a(" o "),cs=r("code"),ir=a("push_to_hub()"),cr=a(`,
se guarda el c\xF3digo del modelo.`),wa=d(),ee=r("h2"),ce=r("a"),ds=r("span"),M(qe.$$.fragment),dr=d(),ps=r("span"),pr=a("Enviar el c\xF3digo al _Hub_"),ja=d(),M(de.$$.fragment),Ta=d(),U=r("p"),ur=a("Primero, aseg\xFArate de que tu modelo est\xE9 completamente definido en un archivo "),us=r("code"),mr=a(".py"),fr=a(`. Puedes basarte en importaciones
relativas a otros archivos, siempre que todos los archivos est\xE9n en el mismo directorio (a\xFAn no admitimos subm\xF3dulos
para esta caracter\xEDstica). Para nuestro ejemplo, definiremos un archivo `),ms=r("code"),Mr=a("modeling_resnet.py"),yr=a(` y un archivo
`),fs=r("code"),br=a("configuration_resnet.py"),Jr=a(" en una carpeta del directorio de trabajo actual llamado "),Ms=r("code"),wr=a("resnet_model"),jr=a(`. El archivo de configuraci\xF3n
contiene el c\xF3digo de `),ys=r("code"),Tr=a("ResnetConfig"),Ur=a(" y el archivo del modelo contiene el c\xF3digo de "),bs=r("code"),_r=a("ResnetModel"),hr=a(` y
`),Js=r("code"),vr=a("ResnetModelForImageClassification"),Cr=a("."),Ua=d(),M(ze.$$.fragment),_a=d(),P=r("p"),Er=a("El "),ws=r("code"),gr=a("__init__.py"),Ir=a("  puede estar vac\xEDo, solo est\xE1 ah\xED para que Python detecte que "),js=r("code"),Zr=a("resnet_model"),Ar=a(" se puede usar como un m\xF3dulo."),ha=d(),M(pe.$$.fragment),va=d(),rl=r("p"),$r=a("Ten en cuenta que puedes reutilizar (o subclasificar) una configuraci\xF3n o modelo existente."),Ca=d(),nl=r("p"),kr=a(`Para compartir tu modelo con la comunidad, sigue estos pasos: primero importa el modelo y la configuraci\xF3n de ResNet desde
los archivos reci\xE9n creados:`),Ea=d(),M(We.$$.fragment),ga=d(),ue=r("p"),Nr=a("Luego, debes decirle a la biblioteca que deseas copiar el c\xF3digo de esos objetos cuando usas el m\xE9todo "),Ts=r("code"),Rr=a("save_pretrained"),Br=a(`
y registrarlos correctamente con una determinada clase autom\xE1tica (especialmente para modelos), simplemente ejecuta:`),Ia=d(),M(Xe.$$.fragment),Za=d(),me=r("p"),qr=a(`Ten en cuenta que no es necesario especificar una clase autom\xE1tica para la configuraci\xF3n (solo hay una clase autom\xE1tica
para ellos, `),Us=r("code"),zr=a("AutoConfig"),Wr=a(`), pero es diferente para los modelos. Tu modelo personalizado podr\xEDa ser adecuado para muchas
tareas diferentes, por lo que debes especificar cu\xE1l de las clases autom\xE1ticas es la correcta para tu modelo.`),Aa=d(),il=r("p"),Xr=a("A continuaci\xF3n, vamos a crear la configuraci\xF3n y los modelos como lo hicimos antes:"),$a=d(),M(Ge.$$.fragment),ka=d(),cl=r("p"),Gr=a("Ahora, para enviar el modelo al Hub, aseg\xFArate de haber iniciado sesi\xF3n. Ejecuta en tu terminal:"),Na=d(),M(Ve.$$.fragment),Ra=d(),fe=r("p"),Vr=a("o desde un "),_s=r("em"),Yr=a("notebook"),Qr=a(":"),Ba=d(),M(Ye.$$.fragment),qa=d(),dl=r("p"),Fr=a("Luego puedes ingresar a tu propio espacio (o una organizaci\xF3n de la que seas miembro) de esta manera:"),za=d(),M(Qe.$$.fragment),Wa=d(),R=r("p"),Pr=a("Adem\xE1s de los pesos del modelo y la configuraci\xF3n en formato json, esto tambi\xE9n copi\xF3 los archivos "),hs=r("code"),Dr=a(".py"),Hr=a(` del modelo y la
configuraci\xF3n en la carpeta `),vs=r("code"),Sr=a("custom-resnet50d"),xr=a(` y subi\xF3 el resultado al Hub. Puedes verificar el resultado en este
`),Fe=r("a"),Or=a("repositorio de modelos"),Lr=a("."),Xa=d(),Me=r("p"),Kr=a("Consulta el tutorial sobre c\xF3mo "),pl=r("a"),en=a("compartir modelos"),ln=a(" para obtener m\xE1s informaci\xF3n sobre el m\xE9todo para subir modelos al Hub."),Ga=d(),le=r("h2"),ye=r("a"),Cs=r("span"),M(Pe.$$.fragment),sn=d(),Es=r("span"),an=a("Usar un modelo con c\xF3digo personalizado"),Va=d(),Z=r("p"),on=a("Puedes usar cualquier configuraci\xF3n, modelo o "),gs=r("em"),tn=a("tokenizador"),rn=a(` con archivos de c\xF3digo personalizado en tu repositorio con las
clases autom\xE1ticas y el m\xE9todo `),Is=r("code"),nn=a("from_pretrained"),cn=a(`. Todos los archivos y c\xF3digos cargados en el Hub se analizan en busca de
malware (consulta la documentaci\xF3n de `),De=r("a"),dn=a("seguridad del Hub"),pn=a(` para
obtener m\xE1s informaci\xF3n), pero a\xFAn debes revisar el c\xF3digo del modelo y el autor para evitar la ejecuci\xF3n de c\xF3digo malicioso
en tu computadora. Configura `),Zs=r("code"),un=a("trust_remote_code=True"),mn=a(" para usar un modelo con c\xF3digo personalizado:"),Ya=d(),M(He.$$.fragment),Qa=d(),be=r("p"),fn=a("Tambi\xE9n se recomienda encarecidamente pasar un "),As=r("em"),Mn=a("hash"),yn=a(` de confirmaci\xF3n como una \u201Crevisi\xF3n\u201D para asegurarte de que el autor
de los modelos no actualiz\xF3 el c\xF3digo con algunas l\xEDneas nuevas maliciosas (a menos que conf\xEDes plenamente en los autores
de los modelos).`),Fa=d(),M(Se.$$.fragment),Pa=d(),Je=r("p"),bn=a(`Ten en cuenta que al navegar por el historial de confirmaciones del repositorio del modelo en Hub, hay un bot\xF3n para copiar
f\xE1cilmente el hash de confirmaci\xF3n de cualquier `),$s=r("em"),Jn=a("commit"),wn=a("."),Da=d(),se=r("h2"),we=r("a"),ks=r("span"),M(xe.$$.fragment),jn=d(),Ns=r("span"),Tn=a("Registrar un model con c\xF3digo personalizado a las clases autom\xE1ticas"),Ha=d(),ul=r("p"),Un=a(`Si est\xE1s escribiendo una biblioteca que ampl\xEDa \u{1F917} Transformers, es posible que quieras ampliar las clases autom\xE1ticas para
incluir tu propio modelo. Esto es diferente de enviar el c\xF3digo al Hub en el sentido de que los usuarios necesitar\xE1n importar
tu biblioteca para obtener los modelos personalizados (al contrario de descargar autom\xE1ticamente el c\xF3digo del modelo desde Hub).`),Sa=d(),D=r("p"),_n=a("Siempre que tu configuraci\xF3n tenga un atributo "),Rs=r("code"),hn=a("model_type"),vn=a(` que sea diferente de los tipos de modelos existentes, y que tus
clases modelo tengan los atributos `),Bs=r("code"),Cn=a("config_class"),En=a(" correctos, puedes agregarlos a las clases autom\xE1ticas de la siguiente manera:"),xa=d(),M(Oe.$$.fragment),Oa=d(),B=r("p"),gn=a("Ten en cuenta que el primer argumento utilizado al registrar tu configuraci\xF3n personalizada en "),qs=r("code"),In=a("AutoConfig"),Zn=a(` debe coincidir
con el `),zs=r("code"),An=a("model_type"),$n=a(` de tu configuraci\xF3n personalizada, y el primer argumento utilizado al registrar tus modelos personalizados
en cualquier clase del modelo autom\xE1tico debe coincidir con el `),Ws=r("code"),kn=a("config_class"),Nn=a(" de esos modelos."),this.h()},l(e){const t=hc('[data-svelte="svelte-1phssyn"]',document.head);u=n(t,"META",{name:!0,content:!0}),t.forEach(s),C=p(e),f=n(e,"H1",{class:!0});var Le=i(f);T=n(Le,"A",{id:!0,class:!0,href:!0});var Xs=i(T);A=n(Xs,"SPAN",{});var Gs=i(A);y(_.$$.fragment,Gs),Gs.forEach(s),Xs.forEach(s),h=p(Le),q=n(Le,"SPAN",{});var Bn=i(q);fo=o(Bn,"Compartir modelos personalizados"),Bn.forEach(s),Le.forEach(s),Vs=p(e),Ke=n(e,"P",{});var qn=i(Ke);Mo=o(qn,`La biblioteca \u{1F917} Transformers est\xE1 dise\xF1ada para ser f\xE1cilmente ampliable. Cada modelo est\xE1 completamente codificado
sin abstracci\xF3n en una subcarpeta determinada del repositorio, por lo que puedes copiar f\xE1cilmente un archivo del modelo
y ajustarlo seg\xFAn tus necesidades.`),qn.forEach(s),Ys=p(e),el=n(e,"P",{});var zn=i(el);yo=o(zn,`Si est\xE1s escribiendo un modelo completamente nuevo, podr\xEDa ser m\xE1s f\xE1cil comenzar desde cero. En este tutorial, te mostraremos
c\xF3mo escribir un modelo personalizado y su configuraci\xF3n para que pueda usarse dentro de Transformers, y c\xF3mo puedes compartirlo
con la comunidad (con el c\xF3digo en el que se basa) para que cualquiera pueda usarlo, incluso si no est\xE1 presente en la biblioteca
\u{1F917} Transformers.`),zn.forEach(s),Qs=p(e),W=n(e,"P",{});var ml=i(W);bo=o(ml,"Ilustraremos todo esto con un modelo ResNet, envolviendo la clase ResNet de la "),Ce=n(ml,"A",{href:!0,rel:!0});var Wn=i(Ce);Jo=o(Wn,"biblioteca timm"),Wn.forEach(s),wo=o(ml," en un "),hl=n(ml,"CODE",{});var Xn=i(hl);jo=o(Xn,"PreTrainedModel"),Xn.forEach(s),To=o(ml,"."),ml.forEach(s),Fs=p(e),O=n(e,"H2",{class:!0});var Ka=i(O);oe=n(Ka,"A",{id:!0,class:!0,href:!0});var Gn=i(oe);vl=n(Gn,"SPAN",{});var Vn=i(vl);y(Ee.$$.fragment,Vn),Vn.forEach(s),Gn.forEach(s),Uo=p(Ka),Cl=n(Ka,"SPAN",{});var Yn=i(Cl);_o=o(Yn,"Escribir una configuraci\xF3n personalizada"),Yn.forEach(s),Ka.forEach(s),Ps=p(e),te=n(e,"P",{});var eo=i(te);ho=o(eo,`Antes de adentrarnos en el modelo, primero escribamos su configuraci\xF3n. La configuraci\xF3n de un modelo es un objeto que
contendr\xE1 toda la informaci\xF3n necesaria para construir el modelo. Como veremos en la siguiente secci\xF3n, el modelo solo puede
tomar un `),El=n(eo,"CODE",{});var Qn=i(El);vo=o(Qn,"config"),Qn.forEach(s),Co=o(eo," para ser inicializado, por lo que realmente necesitamos que ese objeto est\xE9 lo m\xE1s completo posible."),eo.forEach(s),Ds=p(e),ll=n(e,"P",{});var Fn=i(ll);Eo=o(Fn,`En nuestro ejemplo, tomaremos un par de argumentos de la clase ResNet que tal vez queramos modificar. Las diferentes
configuraciones nos dar\xE1n los diferentes tipos de ResNet que son posibles. Luego simplemente almacenamos esos argumentos
despu\xE9s de verificar la validez de algunos de ellos.`),Fn.forEach(s),Hs=p(e),y(ge.$$.fragment,e),Ss=p(e),sl=n(e,"P",{});var Pn=i(sl);go=o(Pn,"Las tres cosas importantes que debes recordar al escribir tu propia configuraci\xF3n son las siguientes:"),Pn.forEach(s),xs=p(e),X=n(e,"UL",{});var fl=i(X);Ie=n(fl,"LI",{});var lo=i(Ie);Io=o(lo,"tienes que heredar de "),gl=n(lo,"CODE",{});var Dn=i(gl);Zo=o(Dn,"PretrainedConfig"),Dn.forEach(s),Ao=o(lo,","),lo.forEach(s),$o=p(fl),z=n(fl,"LI",{});var je=i(z);ko=o(je,"el "),Il=n(je,"CODE",{});var Hn=i(Il);No=o(Hn,"__init__"),Hn.forEach(s),Ro=o(je," de tu "),Zl=n(je,"CODE",{});var Sn=i(Zl);Bo=o(Sn,"PretrainedConfig"),Sn.forEach(s),qo=o(je," debe aceptar cualquier "),Al=n(je,"CODE",{});var xn=i(Al);zo=o(xn,"kwargs"),xn.forEach(s),Wo=o(je,","),je.forEach(s),Xo=p(fl),L=n(fl,"LI",{});var Ml=i(L);Go=o(Ml,"esos "),$l=n(Ml,"CODE",{});var On=i($l);Vo=o(On,"kwargs"),On.forEach(s),Yo=o(Ml," deben pasarse a la superclase "),kl=n(Ml,"CODE",{});var Ln=i(kl);Qo=o(Ln,"__init__"),Ln.forEach(s),Fo=o(Ml,"."),Ml.forEach(s),fl.forEach(s),Os=p(e),g=n(e,"P",{});var H=i(g);Po=o(H,`La herencia es para asegurarte de obtener toda la funcionalidad de la biblioteca \u{1F917} Transformers, mientras que las otras dos
restricciones provienen del hecho de que una `),Nl=n(H,"CODE",{});var Kn=i(Nl);Do=o(Kn,"PretrainedConfig"),Kn.forEach(s),Ho=o(H,` tiene m\xE1s campos que los que est\xE1s configurando. Al recargar una
`),Rl=n(H,"CODE",{});var ei=i(Rl);So=o(ei,"config"),ei.forEach(s),xo=o(H," con el m\xE9todo "),Bl=n(H,"CODE",{});var li=i(Bl);Oo=o(li,"from_pretrained"),li.forEach(s),Lo=o(H,", esos campos deben ser aceptados por tu "),ql=n(H,"CODE",{});var si=i(ql);Ko=o(si,"config"),si.forEach(s),et=o(H," y luego enviados a la superclase."),H.forEach(s),Ls=p(e),G=n(e,"P",{});var yl=i(G);lt=o(yl,"Definir un "),zl=n(yl,"CODE",{});var ai=i(zl);st=o(ai,"model_type"),ai.forEach(s),at=o(yl," para tu configuraci\xF3n (en este caso "),Wl=n(yl,"CODE",{});var oi=i(Wl);ot=o(oi,'model_type="resnet"'),oi.forEach(s),tt=o(yl,`) no es obligatorio, a menos que quieras
registrar tu modelo con las clases autom\xE1ticas (ver la \xFAltima secci\xF3n).`),yl.forEach(s),Ks=p(e),al=n(e,"P",{});var ti=i(al);rt=o(ti,`Una vez hecho esto, puedes crear y guardar f\xE1cilmente tu configuraci\xF3n como lo har\xEDas con cualquier otra configuraci\xF3n de un
modelo de la biblioteca. As\xED es como podemos crear una configuraci\xF3n resnet50d y guardarla:`),ti.forEach(s),ea=p(e),y(Ze.$$.fragment,e),la=p(e),$=n(e,"P",{});var Te=i($);nt=o(Te,"Esto guardar\xE1 un archivo llamado "),Xl=n(Te,"CODE",{});var ri=i(Xl);it=o(ri,"config.json"),ri.forEach(s),ct=o(Te," dentro de la carpeta "),Gl=n(Te,"CODE",{});var ni=i(Gl);dt=o(ni,"custom-resnet"),ni.forEach(s),pt=o(Te,`. Luego puedes volver a cargar tu configuraci\xF3n
con el m\xE9todo `),Vl=n(Te,"CODE",{});var ii=i(Vl);ut=o(ii,"from_pretrained"),ii.forEach(s),mt=o(Te,":"),Te.forEach(s),sa=p(e),y(Ae.$$.fragment,e),aa=p(e),V=n(e,"P",{});var bl=i(V);ft=o(bl,"Tambi\xE9n puedes usar cualquier otro m\xE9todo de la clase "),Yl=n(bl,"CODE",{});var ci=i(Yl);Mt=o(ci,"PretrainedConfig"),ci.forEach(s),yt=o(bl,", como "),Ql=n(bl,"CODE",{});var di=i(Ql);bt=o(di,"push_to_hub()"),di.forEach(s),Jt=o(bl,`, para cargar
directamente tu configuraci\xF3n en el Hub.`),bl.forEach(s),oa=p(e),K=n(e,"H2",{class:!0});var so=i(K);re=n(so,"A",{id:!0,class:!0,href:!0});var pi=i(re);Fl=n(pi,"SPAN",{});var ui=i(Fl);y($e.$$.fragment,ui),ui.forEach(s),pi.forEach(s),wt=p(so),Pl=n(so,"SPAN",{});var mi=i(Pl);jt=o(mi,"Escribir un modelo personalizado"),mi.forEach(s),so.forEach(s),ta=p(e),Y=n(e,"P",{});var Jl=i(Y);Tt=o(Jl,`Ahora que tenemos nuestra configuraci\xF3n de ResNet, podemos seguir escribiendo el modelo. En realidad escribiremos dos: una que
extrae las caracter\xEDsticas ocultas de un grupo de im\xE1genes (como `),Dl=n(Jl,"CODE",{});var fi=i(Dl);Ut=o(fi,"BertModel"),fi.forEach(s),_t=o(Jl,`) y una que es adecuada para clasificaci\xF3n de
imagenes (como `),Hl=n(Jl,"CODE",{});var Mi=i(Hl);ht=o(Mi,"BertForSequenceClassification"),Mi.forEach(s),vt=o(Jl,")."),Jl.forEach(s),ra=p(e),Q=n(e,"P",{});var wl=i(Q);Ct=o(wl,"Como mencionamos antes, solo escribiremos un envoltura ("),Sl=n(wl,"EM",{});var yi=i(Sl);Et=o(yi,"wrapper"),yi.forEach(s),gt=o(wl,`) libre del modelo para simplificar este ejemplo. Lo \xFAnico que debemos
hacer antes de escribir esta clase es un mapeo entre los tipos de bloques y las clases de bloques reales. Luego se define el
modelo desde la configuraci\xF3n pasando todo a la clase `),xl=n(wl,"CODE",{});var bi=i(xl);It=o(bi,"ResNet"),bi.forEach(s),Zt=o(wl,":"),wl.forEach(s),na=p(e),y(ke.$$.fragment,e),ia=p(e),ne=n(e,"P",{});var ao=i(ne);At=o(ao,"Para el modelo que clasificar\xE1 las im\xE1genes, solo cambiamos el m\xE9todo de avance (es decir, el m\xE9todo "),Ol=n(ao,"CODE",{});var Ji=i(Ol);$t=o(Ji,"forward"),Ji.forEach(s),kt=o(ao,"):"),ao.forEach(s),ca=p(e),y(Ne.$$.fragment,e),da=p(e),I=n(e,"P",{});var S=i(I);Nt=o(S,"En ambos casos, observa c\xF3mo heredamos de "),Ll=n(S,"CODE",{});var wi=i(Ll);Rt=o(wi,"PreTrainedModel"),wi.forEach(s),Bt=o(S," y llamamos a la inicializaci\xF3n de la superclase con "),Kl=n(S,"CODE",{});var ji=i(Kl);qt=o(ji,"config"),ji.forEach(s),zt=o(S,`
(un poco como cuando escribes `),es=n(S,"CODE",{});var Ti=i(es);Wt=o(Ti,"torch.nn.Module"),Ti.forEach(s),Xt=o(S,"). La l\xEDnea que establece "),ls=n(S,"CODE",{});var Ui=i(ls);Gt=o(Ui,"config_class"),Ui.forEach(s),Vt=o(S,` no es obligatoria, a menos
que quieras registrar tu modelo con las clases autom\xE1ticas (consulta la \xFAltima secci\xF3n).`),S.forEach(s),pa=p(e),y(ie.$$.fragment,e),ua=p(e),k=n(e,"P",{});var Ue=i(k);Yt=o(Ue,`Puedes hacer que tu modelo devuelva lo que quieras, pero devolver un diccionario como lo hicimos para
`),ss=n(Ue,"CODE",{});var _i=i(ss);Qt=o(_i,"ResnetModelForImageClassification"),_i.forEach(s),Ft=o(Ue,", con el "),as=n(Ue,"CODE",{});var hi=i(as);Pt=o(hi,"loss"),hi.forEach(s),Dt=o(Ue,` incluido cuando se pasan las etiquetas, har\xE1 que tu modelo se pueda
usar directamente dentro de la clase `),os=n(Ue,"CODE",{});var vi=i(os);Ht=o(vi,"Trainer"),vi.forEach(s),St=o(Ue,`. Usar otro formato de salida est\xE1 bien, siempre y cuando est\xE9s planeando usar
tu propio bucle de entrenamiento u otra biblioteca para el entrenamiento.`),Ue.forEach(s),ma=p(e),ol=n(e,"P",{});var Ci=i(ol);xt=o(Ci,"Ahora que tenemos nuestra clase, vamos a crear un modelo:"),Ci.forEach(s),fa=p(e),y(Re.$$.fragment,e),Ma=p(e),N=n(e,"P",{});var _e=i(N);Ot=o(_e,"Nuevamente, puedes usar cualquiera de los m\xE9todos de "),ts=n(_e,"CODE",{});var Ei=i(ts);Lt=o(Ei,"PreTrainedModel"),Ei.forEach(s),Kt=o(_e,", como "),rs=n(_e,"CODE",{});var gi=i(rs);er=o(gi,"save_pretrained()"),gi.forEach(s),lr=o(_e,` o
`),ns=n(_e,"CODE",{});var Ii=i(ns);sr=o(Ii,"push_to_hub()"),Ii.forEach(s),ar=o(_e,`. Usaremos el segundo en la siguiente secci\xF3n y veremos c\xF3mo pasar los pesos del modelo
con el c\xF3digo de nuestro modelo. Pero primero, carguemos algunos pesos previamente entrenados dentro de nuestro modelo.`),_e.forEach(s),ya=p(e),tl=n(e,"P",{});var Zi=i(tl);or=o(Zi,`En tu caso de uso, probablemente estar\xE1s entrenando tu modelo personalizado con tus propios datos. Para ir r\xE1pido en este
tutorial, usaremos la versi\xF3n preentrenada de resnet50d. Dado que nuestro modelo es solo un envoltorio alrededor del resnet50d
original, ser\xE1 f\xE1cil transferir esos pesos:`),Zi.forEach(s),ba=p(e),y(Be.$$.fragment,e),Ja=p(e),F=n(e,"P",{});var jl=i(F);tr=o(jl,"Ahora veamos c\xF3mo asegurarnos de que cuando hacemos "),is=n(jl,"CODE",{});var Ai=i(is);rr=o(Ai,"save_pretrained()"),Ai.forEach(s),nr=o(jl," o "),cs=n(jl,"CODE",{});var $i=i(cs);ir=o($i,"push_to_hub()"),$i.forEach(s),cr=o(jl,`,
se guarda el c\xF3digo del modelo.`),jl.forEach(s),wa=p(e),ee=n(e,"H2",{class:!0});var oo=i(ee);ce=n(oo,"A",{id:!0,class:!0,href:!0});var ki=i(ce);ds=n(ki,"SPAN",{});var Ni=i(ds);y(qe.$$.fragment,Ni),Ni.forEach(s),ki.forEach(s),dr=p(oo),ps=n(oo,"SPAN",{});var Ri=i(ps);pr=o(Ri,"Enviar el c\xF3digo al _Hub_"),Ri.forEach(s),oo.forEach(s),ja=p(e),y(de.$$.fragment,e),Ta=p(e),U=n(e,"P",{});var E=i(U);ur=o(E,"Primero, aseg\xFArate de que tu modelo est\xE9 completamente definido en un archivo "),us=n(E,"CODE",{});var Bi=i(us);mr=o(Bi,".py"),Bi.forEach(s),fr=o(E,`. Puedes basarte en importaciones
relativas a otros archivos, siempre que todos los archivos est\xE9n en el mismo directorio (a\xFAn no admitimos subm\xF3dulos
para esta caracter\xEDstica). Para nuestro ejemplo, definiremos un archivo `),ms=n(E,"CODE",{});var qi=i(ms);Mr=o(qi,"modeling_resnet.py"),qi.forEach(s),yr=o(E,` y un archivo
`),fs=n(E,"CODE",{});var zi=i(fs);br=o(zi,"configuration_resnet.py"),zi.forEach(s),Jr=o(E," en una carpeta del directorio de trabajo actual llamado "),Ms=n(E,"CODE",{});var Wi=i(Ms);wr=o(Wi,"resnet_model"),Wi.forEach(s),jr=o(E,`. El archivo de configuraci\xF3n
contiene el c\xF3digo de `),ys=n(E,"CODE",{});var Xi=i(ys);Tr=o(Xi,"ResnetConfig"),Xi.forEach(s),Ur=o(E," y el archivo del modelo contiene el c\xF3digo de "),bs=n(E,"CODE",{});var Gi=i(bs);_r=o(Gi,"ResnetModel"),Gi.forEach(s),hr=o(E,` y
`),Js=n(E,"CODE",{});var Vi=i(Js);vr=o(Vi,"ResnetModelForImageClassification"),Vi.forEach(s),Cr=o(E,"."),E.forEach(s),Ua=p(e),y(ze.$$.fragment,e),_a=p(e),P=n(e,"P",{});var Tl=i(P);Er=o(Tl,"El "),ws=n(Tl,"CODE",{});var Yi=i(ws);gr=o(Yi,"__init__.py"),Yi.forEach(s),Ir=o(Tl,"  puede estar vac\xEDo, solo est\xE1 ah\xED para que Python detecte que "),js=n(Tl,"CODE",{});var Qi=i(js);Zr=o(Qi,"resnet_model"),Qi.forEach(s),Ar=o(Tl," se puede usar como un m\xF3dulo."),Tl.forEach(s),ha=p(e),y(pe.$$.fragment,e),va=p(e),rl=n(e,"P",{});var Fi=i(rl);$r=o(Fi,"Ten en cuenta que puedes reutilizar (o subclasificar) una configuraci\xF3n o modelo existente."),Fi.forEach(s),Ca=p(e),nl=n(e,"P",{});var Pi=i(nl);kr=o(Pi,`Para compartir tu modelo con la comunidad, sigue estos pasos: primero importa el modelo y la configuraci\xF3n de ResNet desde
los archivos reci\xE9n creados:`),Pi.forEach(s),Ea=p(e),y(We.$$.fragment,e),ga=p(e),ue=n(e,"P",{});var to=i(ue);Nr=o(to,"Luego, debes decirle a la biblioteca que deseas copiar el c\xF3digo de esos objetos cuando usas el m\xE9todo "),Ts=n(to,"CODE",{});var Di=i(Ts);Rr=o(Di,"save_pretrained"),Di.forEach(s),Br=o(to,`
y registrarlos correctamente con una determinada clase autom\xE1tica (especialmente para modelos), simplemente ejecuta:`),to.forEach(s),Ia=p(e),y(Xe.$$.fragment,e),Za=p(e),me=n(e,"P",{});var ro=i(me);qr=o(ro,`Ten en cuenta que no es necesario especificar una clase autom\xE1tica para la configuraci\xF3n (solo hay una clase autom\xE1tica
para ellos, `),Us=n(ro,"CODE",{});var Hi=i(Us);zr=o(Hi,"AutoConfig"),Hi.forEach(s),Wr=o(ro,`), pero es diferente para los modelos. Tu modelo personalizado podr\xEDa ser adecuado para muchas
tareas diferentes, por lo que debes especificar cu\xE1l de las clases autom\xE1ticas es la correcta para tu modelo.`),ro.forEach(s),Aa=p(e),il=n(e,"P",{});var Si=i(il);Xr=o(Si,"A continuaci\xF3n, vamos a crear la configuraci\xF3n y los modelos como lo hicimos antes:"),Si.forEach(s),$a=p(e),y(Ge.$$.fragment,e),ka=p(e),cl=n(e,"P",{});var xi=i(cl);Gr=o(xi,"Ahora, para enviar el modelo al Hub, aseg\xFArate de haber iniciado sesi\xF3n. Ejecuta en tu terminal:"),xi.forEach(s),Na=p(e),y(Ve.$$.fragment,e),Ra=p(e),fe=n(e,"P",{});var no=i(fe);Vr=o(no,"o desde un "),_s=n(no,"EM",{});var Oi=i(_s);Yr=o(Oi,"notebook"),Oi.forEach(s),Qr=o(no,":"),no.forEach(s),Ba=p(e),y(Ye.$$.fragment,e),qa=p(e),dl=n(e,"P",{});var Li=i(dl);Fr=o(Li,"Luego puedes ingresar a tu propio espacio (o una organizaci\xF3n de la que seas miembro) de esta manera:"),Li.forEach(s),za=p(e),y(Qe.$$.fragment,e),Wa=p(e),R=n(e,"P",{});var he=i(R);Pr=o(he,"Adem\xE1s de los pesos del modelo y la configuraci\xF3n en formato json, esto tambi\xE9n copi\xF3 los archivos "),hs=n(he,"CODE",{});var Ki=i(hs);Dr=o(Ki,".py"),Ki.forEach(s),Hr=o(he,` del modelo y la
configuraci\xF3n en la carpeta `),vs=n(he,"CODE",{});var ec=i(vs);Sr=o(ec,"custom-resnet50d"),ec.forEach(s),xr=o(he,` y subi\xF3 el resultado al Hub. Puedes verificar el resultado en este
`),Fe=n(he,"A",{href:!0,rel:!0});var lc=i(Fe);Or=o(lc,"repositorio de modelos"),lc.forEach(s),Lr=o(he,"."),he.forEach(s),Xa=p(e),Me=n(e,"P",{});var io=i(Me);Kr=o(io,"Consulta el tutorial sobre c\xF3mo "),pl=n(io,"A",{href:!0});var sc=i(pl);en=o(sc,"compartir modelos"),sc.forEach(s),ln=o(io," para obtener m\xE1s informaci\xF3n sobre el m\xE9todo para subir modelos al Hub."),io.forEach(s),Ga=p(e),le=n(e,"H2",{class:!0});var co=i(le);ye=n(co,"A",{id:!0,class:!0,href:!0});var ac=i(ye);Cs=n(ac,"SPAN",{});var oc=i(Cs);y(Pe.$$.fragment,oc),oc.forEach(s),ac.forEach(s),sn=p(co),Es=n(co,"SPAN",{});var tc=i(Es);an=o(tc,"Usar un modelo con c\xF3digo personalizado"),tc.forEach(s),co.forEach(s),Va=p(e),Z=n(e,"P",{});var x=i(Z);on=o(x,"Puedes usar cualquier configuraci\xF3n, modelo o "),gs=n(x,"EM",{});var rc=i(gs);tn=o(rc,"tokenizador"),rc.forEach(s),rn=o(x,` con archivos de c\xF3digo personalizado en tu repositorio con las
clases autom\xE1ticas y el m\xE9todo `),Is=n(x,"CODE",{});var nc=i(Is);nn=o(nc,"from_pretrained"),nc.forEach(s),cn=o(x,`. Todos los archivos y c\xF3digos cargados en el Hub se analizan en busca de
malware (consulta la documentaci\xF3n de `),De=n(x,"A",{href:!0,rel:!0});var ic=i(De);dn=o(ic,"seguridad del Hub"),ic.forEach(s),pn=o(x,` para
obtener m\xE1s informaci\xF3n), pero a\xFAn debes revisar el c\xF3digo del modelo y el autor para evitar la ejecuci\xF3n de c\xF3digo malicioso
en tu computadora. Configura `),Zs=n(x,"CODE",{});var cc=i(Zs);un=o(cc,"trust_remote_code=True"),cc.forEach(s),mn=o(x," para usar un modelo con c\xF3digo personalizado:"),x.forEach(s),Ya=p(e),y(He.$$.fragment,e),Qa=p(e),be=n(e,"P",{});var po=i(be);fn=o(po,"Tambi\xE9n se recomienda encarecidamente pasar un "),As=n(po,"EM",{});var dc=i(As);Mn=o(dc,"hash"),dc.forEach(s),yn=o(po,` de confirmaci\xF3n como una \u201Crevisi\xF3n\u201D para asegurarte de que el autor
de los modelos no actualiz\xF3 el c\xF3digo con algunas l\xEDneas nuevas maliciosas (a menos que conf\xEDes plenamente en los autores
de los modelos).`),po.forEach(s),Fa=p(e),y(Se.$$.fragment,e),Pa=p(e),Je=n(e,"P",{});var uo=i(Je);bn=o(uo,`Ten en cuenta que al navegar por el historial de confirmaciones del repositorio del modelo en Hub, hay un bot\xF3n para copiar
f\xE1cilmente el hash de confirmaci\xF3n de cualquier `),$s=n(uo,"EM",{});var pc=i($s);Jn=o(pc,"commit"),pc.forEach(s),wn=o(uo,"."),uo.forEach(s),Da=p(e),se=n(e,"H2",{class:!0});var mo=i(se);we=n(mo,"A",{id:!0,class:!0,href:!0});var uc=i(we);ks=n(uc,"SPAN",{});var mc=i(ks);y(xe.$$.fragment,mc),mc.forEach(s),uc.forEach(s),jn=p(mo),Ns=n(mo,"SPAN",{});var fc=i(Ns);Tn=o(fc,"Registrar un model con c\xF3digo personalizado a las clases autom\xE1ticas"),fc.forEach(s),mo.forEach(s),Ha=p(e),ul=n(e,"P",{});var Mc=i(ul);Un=o(Mc,`Si est\xE1s escribiendo una biblioteca que ampl\xEDa \u{1F917} Transformers, es posible que quieras ampliar las clases autom\xE1ticas para
incluir tu propio modelo. Esto es diferente de enviar el c\xF3digo al Hub en el sentido de que los usuarios necesitar\xE1n importar
tu biblioteca para obtener los modelos personalizados (al contrario de descargar autom\xE1ticamente el c\xF3digo del modelo desde Hub).`),Mc.forEach(s),Sa=p(e),D=n(e,"P",{});var Ul=i(D);_n=o(Ul,"Siempre que tu configuraci\xF3n tenga un atributo "),Rs=n(Ul,"CODE",{});var yc=i(Rs);hn=o(yc,"model_type"),yc.forEach(s),vn=o(Ul,` que sea diferente de los tipos de modelos existentes, y que tus
clases modelo tengan los atributos `),Bs=n(Ul,"CODE",{});var bc=i(Bs);Cn=o(bc,"config_class"),bc.forEach(s),En=o(Ul," correctos, puedes agregarlos a las clases autom\xE1ticas de la siguiente manera:"),Ul.forEach(s),xa=p(e),y(Oe.$$.fragment,e),Oa=p(e),B=n(e,"P",{});var ve=i(B);gn=o(ve,"Ten en cuenta que el primer argumento utilizado al registrar tu configuraci\xF3n personalizada en "),qs=n(ve,"CODE",{});var Jc=i(qs);In=o(Jc,"AutoConfig"),Jc.forEach(s),Zn=o(ve,` debe coincidir
con el `),zs=n(ve,"CODE",{});var wc=i(zs);An=o(wc,"model_type"),wc.forEach(s),$n=o(ve,` de tu configuraci\xF3n personalizada, y el primer argumento utilizado al registrar tus modelos personalizados
en cualquier clase del modelo autom\xE1tico debe coincidir con el `),Ws=n(ve,"CODE",{});var jc=i(Ws);kn=o(jc,"config_class"),jc.forEach(s),Nn=o(ve," de esos modelos."),ve.forEach(s),this.h()},h(){m(u,"name","hf:doc:metadata"),m(u,"content",JSON.stringify(Zc)),m(T,"id","compartir-modelos-personalizados"),m(T,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(T,"href","#compartir-modelos-personalizados"),m(f,"class","relative group"),m(Ce,"href","https://github.com/rwightman/pytorch-image-models"),m(Ce,"rel","nofollow"),m(oe,"id","escribir-una-configuracin-personalizada"),m(oe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(oe,"href","#escribir-una-configuracin-personalizada"),m(O,"class","relative group"),m(re,"id","escribir-un-modelo-personalizado"),m(re,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(re,"href","#escribir-un-modelo-personalizado"),m(K,"class","relative group"),m(ce,"id","enviar-el-cdigo-al-hub"),m(ce,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(ce,"href","#enviar-el-cdigo-al-hub"),m(ee,"class","relative group"),m(Fe,"href","https://huggingface.co/sgugger/custom-resnet50d"),m(Fe,"rel","nofollow"),m(pl,"href","model_sharing"),m(ye,"id","usar-un-modelo-con-cdigo-personalizado"),m(ye,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(ye,"href","#usar-un-modelo-con-cdigo-personalizado"),m(le,"class","relative group"),m(De,"href","https://huggingface.co/docs/hub/security#malware-scanning"),m(De,"rel","nofollow"),m(we,"id","registrar-un-model-con-cdigo-personalizado-a-las-clases-automticas"),m(we,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(we,"href","#registrar-un-model-con-cdigo-personalizado-a-las-clases-automticas"),m(se,"class","relative group")},m(e,t){l(document.head,u),c(e,C,t),c(e,f,t),l(f,T),l(T,A),b(_,A,null),l(f,h),l(f,q),l(q,fo),c(e,Vs,t),c(e,Ke,t),l(Ke,Mo),c(e,Ys,t),c(e,el,t),l(el,yo),c(e,Qs,t),c(e,W,t),l(W,bo),l(W,Ce),l(Ce,Jo),l(W,wo),l(W,hl),l(hl,jo),l(W,To),c(e,Fs,t),c(e,O,t),l(O,oe),l(oe,vl),b(Ee,vl,null),l(O,Uo),l(O,Cl),l(Cl,_o),c(e,Ps,t),c(e,te,t),l(te,ho),l(te,El),l(El,vo),l(te,Co),c(e,Ds,t),c(e,ll,t),l(ll,Eo),c(e,Hs,t),b(ge,e,t),c(e,Ss,t),c(e,sl,t),l(sl,go),c(e,xs,t),c(e,X,t),l(X,Ie),l(Ie,Io),l(Ie,gl),l(gl,Zo),l(Ie,Ao),l(X,$o),l(X,z),l(z,ko),l(z,Il),l(Il,No),l(z,Ro),l(z,Zl),l(Zl,Bo),l(z,qo),l(z,Al),l(Al,zo),l(z,Wo),l(X,Xo),l(X,L),l(L,Go),l(L,$l),l($l,Vo),l(L,Yo),l(L,kl),l(kl,Qo),l(L,Fo),c(e,Os,t),c(e,g,t),l(g,Po),l(g,Nl),l(Nl,Do),l(g,Ho),l(g,Rl),l(Rl,So),l(g,xo),l(g,Bl),l(Bl,Oo),l(g,Lo),l(g,ql),l(ql,Ko),l(g,et),c(e,Ls,t),c(e,G,t),l(G,lt),l(G,zl),l(zl,st),l(G,at),l(G,Wl),l(Wl,ot),l(G,tt),c(e,Ks,t),c(e,al,t),l(al,rt),c(e,ea,t),b(Ze,e,t),c(e,la,t),c(e,$,t),l($,nt),l($,Xl),l(Xl,it),l($,ct),l($,Gl),l(Gl,dt),l($,pt),l($,Vl),l(Vl,ut),l($,mt),c(e,sa,t),b(Ae,e,t),c(e,aa,t),c(e,V,t),l(V,ft),l(V,Yl),l(Yl,Mt),l(V,yt),l(V,Ql),l(Ql,bt),l(V,Jt),c(e,oa,t),c(e,K,t),l(K,re),l(re,Fl),b($e,Fl,null),l(K,wt),l(K,Pl),l(Pl,jt),c(e,ta,t),c(e,Y,t),l(Y,Tt),l(Y,Dl),l(Dl,Ut),l(Y,_t),l(Y,Hl),l(Hl,ht),l(Y,vt),c(e,ra,t),c(e,Q,t),l(Q,Ct),l(Q,Sl),l(Sl,Et),l(Q,gt),l(Q,xl),l(xl,It),l(Q,Zt),c(e,na,t),b(ke,e,t),c(e,ia,t),c(e,ne,t),l(ne,At),l(ne,Ol),l(Ol,$t),l(ne,kt),c(e,ca,t),b(Ne,e,t),c(e,da,t),c(e,I,t),l(I,Nt),l(I,Ll),l(Ll,Rt),l(I,Bt),l(I,Kl),l(Kl,qt),l(I,zt),l(I,es),l(es,Wt),l(I,Xt),l(I,ls),l(ls,Gt),l(I,Vt),c(e,pa,t),b(ie,e,t),c(e,ua,t),c(e,k,t),l(k,Yt),l(k,ss),l(ss,Qt),l(k,Ft),l(k,as),l(as,Pt),l(k,Dt),l(k,os),l(os,Ht),l(k,St),c(e,ma,t),c(e,ol,t),l(ol,xt),c(e,fa,t),b(Re,e,t),c(e,Ma,t),c(e,N,t),l(N,Ot),l(N,ts),l(ts,Lt),l(N,Kt),l(N,rs),l(rs,er),l(N,lr),l(N,ns),l(ns,sr),l(N,ar),c(e,ya,t),c(e,tl,t),l(tl,or),c(e,ba,t),b(Be,e,t),c(e,Ja,t),c(e,F,t),l(F,tr),l(F,is),l(is,rr),l(F,nr),l(F,cs),l(cs,ir),l(F,cr),c(e,wa,t),c(e,ee,t),l(ee,ce),l(ce,ds),b(qe,ds,null),l(ee,dr),l(ee,ps),l(ps,pr),c(e,ja,t),b(de,e,t),c(e,Ta,t),c(e,U,t),l(U,ur),l(U,us),l(us,mr),l(U,fr),l(U,ms),l(ms,Mr),l(U,yr),l(U,fs),l(fs,br),l(U,Jr),l(U,Ms),l(Ms,wr),l(U,jr),l(U,ys),l(ys,Tr),l(U,Ur),l(U,bs),l(bs,_r),l(U,hr),l(U,Js),l(Js,vr),l(U,Cr),c(e,Ua,t),b(ze,e,t),c(e,_a,t),c(e,P,t),l(P,Er),l(P,ws),l(ws,gr),l(P,Ir),l(P,js),l(js,Zr),l(P,Ar),c(e,ha,t),b(pe,e,t),c(e,va,t),c(e,rl,t),l(rl,$r),c(e,Ca,t),c(e,nl,t),l(nl,kr),c(e,Ea,t),b(We,e,t),c(e,ga,t),c(e,ue,t),l(ue,Nr),l(ue,Ts),l(Ts,Rr),l(ue,Br),c(e,Ia,t),b(Xe,e,t),c(e,Za,t),c(e,me,t),l(me,qr),l(me,Us),l(Us,zr),l(me,Wr),c(e,Aa,t),c(e,il,t),l(il,Xr),c(e,$a,t),b(Ge,e,t),c(e,ka,t),c(e,cl,t),l(cl,Gr),c(e,Na,t),b(Ve,e,t),c(e,Ra,t),c(e,fe,t),l(fe,Vr),l(fe,_s),l(_s,Yr),l(fe,Qr),c(e,Ba,t),b(Ye,e,t),c(e,qa,t),c(e,dl,t),l(dl,Fr),c(e,za,t),b(Qe,e,t),c(e,Wa,t),c(e,R,t),l(R,Pr),l(R,hs),l(hs,Dr),l(R,Hr),l(R,vs),l(vs,Sr),l(R,xr),l(R,Fe),l(Fe,Or),l(R,Lr),c(e,Xa,t),c(e,Me,t),l(Me,Kr),l(Me,pl),l(pl,en),l(Me,ln),c(e,Ga,t),c(e,le,t),l(le,ye),l(ye,Cs),b(Pe,Cs,null),l(le,sn),l(le,Es),l(Es,an),c(e,Va,t),c(e,Z,t),l(Z,on),l(Z,gs),l(gs,tn),l(Z,rn),l(Z,Is),l(Is,nn),l(Z,cn),l(Z,De),l(De,dn),l(Z,pn),l(Z,Zs),l(Zs,un),l(Z,mn),c(e,Ya,t),b(He,e,t),c(e,Qa,t),c(e,be,t),l(be,fn),l(be,As),l(As,Mn),l(be,yn),c(e,Fa,t),b(Se,e,t),c(e,Pa,t),c(e,Je,t),l(Je,bn),l(Je,$s),l($s,Jn),l(Je,wn),c(e,Da,t),c(e,se,t),l(se,we),l(we,ks),b(xe,ks,null),l(se,jn),l(se,Ns),l(Ns,Tn),c(e,Ha,t),c(e,ul,t),l(ul,Un),c(e,Sa,t),c(e,D,t),l(D,_n),l(D,Rs),l(Rs,hn),l(D,vn),l(D,Bs),l(Bs,Cn),l(D,En),c(e,xa,t),b(Oe,e,t),c(e,Oa,t),c(e,B,t),l(B,gn),l(B,qs),l(qs,In),l(B,Zn),l(B,zs),l(zs,An),l(B,$n),l(B,Ws),l(Ws,kn),l(B,Nn),La=!0},p(e,[t]){const Le={};t&2&&(Le.$$scope={dirty:t,ctx:e}),ie.$set(Le);const Xs={};t&2&&(Xs.$$scope={dirty:t,ctx:e}),de.$set(Xs);const Gs={};t&2&&(Gs.$$scope={dirty:t,ctx:e}),pe.$set(Gs)},i(e){La||(J(_.$$.fragment,e),J(Ee.$$.fragment,e),J(ge.$$.fragment,e),J(Ze.$$.fragment,e),J(Ae.$$.fragment,e),J($e.$$.fragment,e),J(ke.$$.fragment,e),J(Ne.$$.fragment,e),J(ie.$$.fragment,e),J(Re.$$.fragment,e),J(Be.$$.fragment,e),J(qe.$$.fragment,e),J(de.$$.fragment,e),J(ze.$$.fragment,e),J(pe.$$.fragment,e),J(We.$$.fragment,e),J(Xe.$$.fragment,e),J(Ge.$$.fragment,e),J(Ve.$$.fragment,e),J(Ye.$$.fragment,e),J(Qe.$$.fragment,e),J(Pe.$$.fragment,e),J(He.$$.fragment,e),J(Se.$$.fragment,e),J(xe.$$.fragment,e),J(Oe.$$.fragment,e),La=!0)},o(e){w(_.$$.fragment,e),w(Ee.$$.fragment,e),w(ge.$$.fragment,e),w(Ze.$$.fragment,e),w(Ae.$$.fragment,e),w($e.$$.fragment,e),w(ke.$$.fragment,e),w(Ne.$$.fragment,e),w(ie.$$.fragment,e),w(Re.$$.fragment,e),w(Be.$$.fragment,e),w(qe.$$.fragment,e),w(de.$$.fragment,e),w(ze.$$.fragment,e),w(pe.$$.fragment,e),w(We.$$.fragment,e),w(Xe.$$.fragment,e),w(Ge.$$.fragment,e),w(Ve.$$.fragment,e),w(Ye.$$.fragment,e),w(Qe.$$.fragment,e),w(Pe.$$.fragment,e),w(He.$$.fragment,e),w(Se.$$.fragment,e),w(xe.$$.fragment,e),w(Oe.$$.fragment,e),La=!1},d(e){s(u),e&&s(C),e&&s(f),j(_),e&&s(Vs),e&&s(Ke),e&&s(Ys),e&&s(el),e&&s(Qs),e&&s(W),e&&s(Fs),e&&s(O),j(Ee),e&&s(Ps),e&&s(te),e&&s(Ds),e&&s(ll),e&&s(Hs),j(ge,e),e&&s(Ss),e&&s(sl),e&&s(xs),e&&s(X),e&&s(Os),e&&s(g),e&&s(Ls),e&&s(G),e&&s(Ks),e&&s(al),e&&s(ea),j(Ze,e),e&&s(la),e&&s($),e&&s(sa),j(Ae,e),e&&s(aa),e&&s(V),e&&s(oa),e&&s(K),j($e),e&&s(ta),e&&s(Y),e&&s(ra),e&&s(Q),e&&s(na),j(ke,e),e&&s(ia),e&&s(ne),e&&s(ca),j(Ne,e),e&&s(da),e&&s(I),e&&s(pa),j(ie,e),e&&s(ua),e&&s(k),e&&s(ma),e&&s(ol),e&&s(fa),j(Re,e),e&&s(Ma),e&&s(N),e&&s(ya),e&&s(tl),e&&s(ba),j(Be,e),e&&s(Ja),e&&s(F),e&&s(wa),e&&s(ee),j(qe),e&&s(ja),j(de,e),e&&s(Ta),e&&s(U),e&&s(Ua),j(ze,e),e&&s(_a),e&&s(P),e&&s(ha),j(pe,e),e&&s(va),e&&s(rl),e&&s(Ca),e&&s(nl),e&&s(Ea),j(We,e),e&&s(ga),e&&s(ue),e&&s(Ia),j(Xe,e),e&&s(Za),e&&s(me),e&&s(Aa),e&&s(il),e&&s($a),j(Ge,e),e&&s(ka),e&&s(cl),e&&s(Na),j(Ve,e),e&&s(Ra),e&&s(fe),e&&s(Ba),j(Ye,e),e&&s(qa),e&&s(dl),e&&s(za),j(Qe,e),e&&s(Wa),e&&s(R),e&&s(Xa),e&&s(Me),e&&s(Ga),e&&s(le),j(Pe),e&&s(Va),e&&s(Z),e&&s(Ya),j(He,e),e&&s(Qa),e&&s(be),e&&s(Fa),j(Se,e),e&&s(Pa),e&&s(Je),e&&s(Da),e&&s(se),j(xe),e&&s(Ha),e&&s(ul),e&&s(Sa),e&&s(D),e&&s(xa),j(Oe,e),e&&s(Oa),e&&s(B)}}}const Zc={local:"compartir-modelos-personalizados",sections:[{local:"escribir-una-configuracin-personalizada",title:"Escribir una configuraci\xF3n personalizada"},{local:"escribir-un-modelo-personalizado",title:"Escribir un modelo personalizado"},{local:"enviar-el-cdigo-al-hub",title:"Enviar el c\xF3digo al _Hub_"},{local:"usar-un-modelo-con-cdigo-personalizado",title:"Usar un modelo con c\xF3digo personalizado"},{local:"registrar-un-model-con-cdigo-personalizado-a-las-clases-automticas",title:"Registrar un model con c\xF3digo personalizado a las clases autom\xE1ticas"}],title:"Compartir modelos personalizados"};function Ac(ae){return vc(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Bc extends Tc{constructor(u){super();Uc(this,u,Ac,Ic,_c,{})}}export{Bc as default,Zc as metadata};
