import{s as fe,n as ye,o as je}from"../chunks/scheduler.85c25b89.js";import{S as Te,i as be,g as l,s as i,u as c,A as ve,h as n,f as e,c as p,j as h,v as d,y as m,k as o,o as r,a,w,d as J,t as g,x as u}from"../chunks/index.9633332f.js";import{I as ht}from"../chunks/IconCopyLink.a4acffac.js";import{C as st}from"../chunks/CodeBlock.00597c71.js";function Ie(Ft){let M,mt,at,ct,f,v,lt,k,Xt,D,zt="AdvProp (EfficientNet)",dt,$,Pt="<strong>AdvProp</strong> is an adversarial training scheme which treats adversarial examples as additional examples, to prevent overfitting. Key to the method is the usage of a separate auxiliary batch norm for adversarial examples, as they have different underlying distributions to normal examples.",wt,Z,Lt='The weights from this model were ported from <a href="https://github.com/tensorflow/tpu" rel="nofollow">Tensorflow/TPU</a>.',Jt,y,I,nt,W,Vt,K,qt="How do I use this model on an image?",gt,_,Dt="To load a pretrained model:",ut,B,Mt,E,Kt="To load and preprocess the image:",ft,N,yt,G,Ot="To get the model predictions:",jt,Q,Tt,A,te="To get the top-5 predictions class names:",bt,Y,vt,X,ee="Replace the model name with the variant you want to use, e.g. <code>tf_efficientnet_b0_ap</code>. You can find the IDs in the model summaries at the top of this page.",It,V,se='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',Ut,j,U,it,R,Rt,O,ae="How do I finetune this model?",xt,S,le="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",Ct,H,kt,F,ne=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,$t,T,x,pt,z,St,tt,ie="How do I train this model?",Zt,P,pe='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',Wt,b,C,ot,L,Ht,et,oe="Citation",_t,q,Bt,rt,Et;return k=new ht({}),W=new ht({}),B=new st({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3RmX2VmZmljaWVudG5ldF9iMF9hcCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;tf_efficientnet_b0_ap&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`}}),N=new st({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`}}),Q=new st({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`}}),Y=new st({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`}}),R=new ht({}),H=new st({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgndGZfZWZmaWNpZW50bmV0X2IwX2FwJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;tf_efficientnet_b0_ap&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)'}}),z=new ht({}),L=new ht({}),q=new st({props:{code:"JTQwbWlzYyU3QnhpZTIwMjBhZHZlcnNhcmlhbCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHRpdGxlJTNEJTdCQWR2ZXJzYXJpYWwlMjBFeGFtcGxlcyUyMEltcHJvdmUlMjBJbWFnZSUyMFJlY29nbml0aW9uJTdEJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXV0aG9yJTNEJTdCQ2loYW5nJTIwWGllJTIwYW5kJTIwTWluZ3hpbmclMjBUYW4lMjBhbmQlMjBCb3FpbmclMjBHb25nJTIwYW5kJTIwSmlhbmclMjBXYW5nJTIwYW5kJTIwQWxhbiUyMFl1aWxsZSUyMGFuZCUyMFF1b2MlMjBWLiUyMExlJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IxOTExLjA5NjY1JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuQ1YlN0QlMEElN0Q=",highlighted:`@misc{xie2020adversarial,
      title={Adversarial Examples Improve Image Recognition}, 
      author={Cihang Xie <span class="hljs-keyword">and </span>Mingxing Tan <span class="hljs-keyword">and </span><span class="hljs-keyword">Boqing </span>Gong <span class="hljs-keyword">and </span><span class="hljs-keyword">Jiang </span>Wang <span class="hljs-keyword">and </span>Alan Yuille <span class="hljs-keyword">and </span>Quoc V. Le},
      year={<span class="hljs-number">2020</span>},
      eprint={<span class="hljs-number">1911</span>.<span class="hljs-number">09665</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`}}),{c(){M=l("meta"),mt=i(),at=l("p"),ct=i(),f=l("h1"),v=l("a"),lt=l("span"),c(k.$$.fragment),Xt=i(),D=l("span"),D.textContent=zt,dt=i(),$=l("p"),$.innerHTML=Pt,wt=i(),Z=l("p"),Z.innerHTML=Lt,Jt=i(),y=l("h2"),I=l("a"),nt=l("span"),c(W.$$.fragment),Vt=i(),K=l("span"),K.textContent=qt,gt=i(),_=l("p"),_.textContent=Dt,ut=i(),c(B.$$.fragment),Mt=i(),E=l("p"),E.textContent=Kt,ft=i(),c(N.$$.fragment),yt=i(),G=l("p"),G.textContent=Ot,jt=i(),c(Q.$$.fragment),Tt=i(),A=l("p"),A.textContent=te,bt=i(),c(Y.$$.fragment),vt=i(),X=l("p"),X.innerHTML=ee,It=i(),V=l("p"),V.innerHTML=se,Ut=i(),j=l("h2"),U=l("a"),it=l("span"),c(R.$$.fragment),Rt=i(),O=l("span"),O.textContent=ae,xt=i(),S=l("p"),S.textContent=le,Ct=i(),c(H.$$.fragment),kt=i(),F=l("p"),F.innerHTML=ne,$t=i(),T=l("h2"),x=l("a"),pt=l("span"),c(z.$$.fragment),St=i(),tt=l("span"),tt.textContent=ie,Zt=i(),P=l("p"),P.innerHTML=pe,Wt=i(),b=l("h2"),C=l("a"),ot=l("span"),c(L.$$.fragment),Ht=i(),et=l("span"),et.textContent=oe,_t=i(),c(q.$$.fragment),Bt=i(),rt=l("p"),this.h()},l(t){const s=ve("svelte-1phssyn",document.head);M=n(s,"META",{name:!0,content:!0}),s.forEach(e),mt=p(t),at=n(t,"P",{}),h(at).forEach(e),ct=p(t),f=n(t,"H1",{class:!0});var Nt=h(f);v=n(Nt,"A",{id:!0,class:!0,href:!0});var re=h(v);lt=n(re,"SPAN",{});var he=h(lt);d(k.$$.fragment,he),he.forEach(e),re.forEach(e),Xt=p(Nt),D=n(Nt,"SPAN",{"data-svelte-h":!0}),m(D)!=="svelte-ehv7d2"&&(D.textContent=zt),Nt.forEach(e),dt=p(t),$=n(t,"P",{"data-svelte-h":!0}),m($)!=="svelte-1x6a5c1"&&($.innerHTML=Pt),wt=p(t),Z=n(t,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-k8hpf1"&&(Z.innerHTML=Lt),Jt=p(t),y=n(t,"H2",{class:!0});var Gt=h(y);I=n(Gt,"A",{id:!0,class:!0,href:!0});var me=h(I);nt=n(me,"SPAN",{});var ce=h(nt);d(W.$$.fragment,ce),ce.forEach(e),me.forEach(e),Vt=p(Gt),K=n(Gt,"SPAN",{"data-svelte-h":!0}),m(K)!=="svelte-1c1hspn"&&(K.textContent=qt),Gt.forEach(e),gt=p(t),_=n(t,"P",{"data-svelte-h":!0}),m(_)!=="svelte-18ywhxh"&&(_.textContent=Dt),ut=p(t),d(B.$$.fragment,t),Mt=p(t),E=n(t,"P",{"data-svelte-h":!0}),m(E)!=="svelte-1c2ipa8"&&(E.textContent=Kt),ft=p(t),d(N.$$.fragment,t),yt=p(t),G=n(t,"P",{"data-svelte-h":!0}),m(G)!=="svelte-1n9qsq1"&&(G.textContent=Ot),jt=p(t),d(Q.$$.fragment,t),Tt=p(t),A=n(t,"P",{"data-svelte-h":!0}),m(A)!=="svelte-19cnvx1"&&(A.textContent=te),bt=p(t),d(Y.$$.fragment,t),vt=p(t),X=n(t,"P",{"data-svelte-h":!0}),m(X)!=="svelte-m13wpe"&&(X.innerHTML=ee),It=p(t),V=n(t,"P",{"data-svelte-h":!0}),m(V)!=="svelte-1wmi3ea"&&(V.innerHTML=se),Ut=p(t),j=n(t,"H2",{class:!0});var Qt=h(j);U=n(Qt,"A",{id:!0,class:!0,href:!0});var de=h(U);it=n(de,"SPAN",{});var we=h(it);d(R.$$.fragment,we),we.forEach(e),de.forEach(e),Rt=p(Qt),O=n(Qt,"SPAN",{"data-svelte-h":!0}),m(O)!=="svelte-1viv4qv"&&(O.textContent=ae),Qt.forEach(e),xt=p(t),S=n(t,"P",{"data-svelte-h":!0}),m(S)!=="svelte-9sr7nh"&&(S.textContent=le),Ct=p(t),d(H.$$.fragment,t),kt=p(t),F=n(t,"P",{"data-svelte-h":!0}),m(F)!=="svelte-1kguc51"&&(F.innerHTML=ne),$t=p(t),T=n(t,"H2",{class:!0});var At=h(T);x=n(At,"A",{id:!0,class:!0,href:!0});var Je=h(x);pt=n(Je,"SPAN",{});var ge=h(pt);d(z.$$.fragment,ge),ge.forEach(e),Je.forEach(e),St=p(At),tt=n(At,"SPAN",{"data-svelte-h":!0}),m(tt)!=="svelte-1ce591d"&&(tt.textContent=ie),At.forEach(e),Zt=p(t),P=n(t,"P",{"data-svelte-h":!0}),m(P)!=="svelte-1n0coha"&&(P.innerHTML=pe),Wt=p(t),b=n(t,"H2",{class:!0});var Yt=h(b);C=n(Yt,"A",{id:!0,class:!0,href:!0});var ue=h(C);ot=n(ue,"SPAN",{});var Me=h(ot);d(L.$$.fragment,Me),Me.forEach(e),ue.forEach(e),Ht=p(Yt),et=n(Yt,"SPAN",{"data-svelte-h":!0}),m(et)!=="svelte-15mb3gy"&&(et.textContent=oe),Yt.forEach(e),_t=p(t),d(q.$$.fragment,t),Bt=p(t),rt=n(t,"P",{}),h(rt).forEach(e),this.h()},h(){o(M,"name","hf:doc:metadata"),o(M,"content",JSON.stringify(Ue)),o(v,"id","advprop-efficientnet"),o(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(v,"href","#advprop-efficientnet"),o(f,"class","relative group"),o(I,"id","how-do-i-use-this-model-on-an-image"),o(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(I,"href","#how-do-i-use-this-model-on-an-image"),o(y,"class","relative group"),o(U,"id","how-do-i-finetune-this-model"),o(U,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(U,"href","#how-do-i-finetune-this-model"),o(j,"class","relative group"),o(x,"id","how-do-i-train-this-model"),o(x,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(x,"href","#how-do-i-train-this-model"),o(T,"class","relative group"),o(C,"id","citation"),o(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(C,"href","#citation"),o(b,"class","relative group")},m(t,s){r(document.head,M),a(t,mt,s),a(t,at,s),a(t,ct,s),a(t,f,s),r(f,v),r(v,lt),w(k,lt,null),r(f,Xt),r(f,D),a(t,dt,s),a(t,$,s),a(t,wt,s),a(t,Z,s),a(t,Jt,s),a(t,y,s),r(y,I),r(I,nt),w(W,nt,null),r(y,Vt),r(y,K),a(t,gt,s),a(t,_,s),a(t,ut,s),w(B,t,s),a(t,Mt,s),a(t,E,s),a(t,ft,s),w(N,t,s),a(t,yt,s),a(t,G,s),a(t,jt,s),w(Q,t,s),a(t,Tt,s),a(t,A,s),a(t,bt,s),w(Y,t,s),a(t,vt,s),a(t,X,s),a(t,It,s),a(t,V,s),a(t,Ut,s),a(t,j,s),r(j,U),r(U,it),w(R,it,null),r(j,Rt),r(j,O),a(t,xt,s),a(t,S,s),a(t,Ct,s),w(H,t,s),a(t,kt,s),a(t,F,s),a(t,$t,s),a(t,T,s),r(T,x),r(x,pt),w(z,pt,null),r(T,St),r(T,tt),a(t,Zt,s),a(t,P,s),a(t,Wt,s),a(t,b,s),r(b,C),r(C,ot),w(L,ot,null),r(b,Ht),r(b,et),a(t,_t,s),w(q,t,s),a(t,Bt,s),a(t,rt,s),Et=!0},p:ye,i(t){Et||(J(k.$$.fragment,t),J(W.$$.fragment,t),J(B.$$.fragment,t),J(N.$$.fragment,t),J(Q.$$.fragment,t),J(Y.$$.fragment,t),J(R.$$.fragment,t),J(H.$$.fragment,t),J(z.$$.fragment,t),J(L.$$.fragment,t),J(q.$$.fragment,t),Et=!0)},o(t){g(k.$$.fragment,t),g(W.$$.fragment,t),g(B.$$.fragment,t),g(N.$$.fragment,t),g(Q.$$.fragment,t),g(Y.$$.fragment,t),g(R.$$.fragment,t),g(H.$$.fragment,t),g(z.$$.fragment,t),g(L.$$.fragment,t),g(q.$$.fragment,t),Et=!1},d(t){t&&(e(mt),e(at),e(ct),e(f),e(dt),e($),e(wt),e(Z),e(Jt),e(y),e(gt),e(_),e(ut),e(Mt),e(E),e(ft),e(yt),e(G),e(jt),e(Tt),e(A),e(bt),e(vt),e(X),e(It),e(V),e(Ut),e(j),e(xt),e(S),e(Ct),e(kt),e(F),e($t),e(T),e(Zt),e(P),e(Wt),e(b),e(_t),e(Bt),e(rt)),e(M),u(k),u(W),u(B,t),u(N,t),u(Q,t),u(Y,t),u(R),u(H,t),u(z),u(L),u(q,t)}}}const Ue={local:"advprop-efficientnet",sections:[{local:"how-do-i-use-this-model-on-an-image",title:"How do I use this model on an image?"},{local:"how-do-i-finetune-this-model",title:"How do I finetune this model?"},{local:"how-do-i-train-this-model",title:"How do I train this model?"},{local:"citation",title:"Citation"}],title:"AdvProp (EfficientNet)"};function xe(Ft){return je(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class We extends Te{constructor(M){super(),be(this,M,xe,Ie,fe,{})}}export{We as component};
