import{s as Me,n as ye,o as we}from"../chunks/scheduler.85c25b89.js";import{S as Je,i as je,g as l,s as i,u as c,A as fe,h as n,f as e,c as p,j as h,v as d,y as m,k as o,o as r,a,w as u,d as g,t as M,x as y}from"../chunks/index.9633332f.js";import{I as rt}from"../chunks/IconCopyLink.a4acffac.js";import{C as et}from"../chunks/CodeBlock.00597c71.js";function Te(Yt){let w,ht,st,mt,J,v,at,x,Vt,D,Ht="Inception ResNet v2",ct,$,zt='<strong>Inception-ResNet-v2</strong> is a convolutional neural architecture that builds on the Inception family of architectures but incorporates <a href="https://paperswithcode.com/method/residual-connection" rel="nofollow">residual connections</a> (replacing the filter concatenation stage of the Inception architecture).',dt,j,U,lt,k,Xt,q,Ft="How do I use this model on an image?",ut,N,Pt="To load a pretrained model:",gt,B,Mt,_,Lt="To load and preprocess the image:",yt,W,wt,E,Dt="To get the model predictions:",Jt,G,jt,Q,qt="To get the top-5 predictions class names:",ft,V,Tt,X,Kt="Replace the model name with the variant you want to use, e.g. <code>inception_resnet_v2</code>. You can find the IDs in the model summaries at the top of this page.",bt,S,Ot='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',vt,f,C,nt,R,St,K,te="How do I finetune this model?",Ut,A,ee="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",Ct,Y,It,H,se=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,Zt,T,I,it,z,Rt,O,ae="How do I train this model?",xt,F,le='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',$t,b,Z,pt,P,At,tt,ne="Citation",kt,L,Nt,ot,Bt;return x=new rt({}),k=new rt({}),B=new et({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2luY2VwdGlvbl9yZXNuZXRfdjInJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;inception_resnet_v2&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`}}),W=new et({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`}}),G=new et({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`}}),V=new et({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`}}),R=new rt({}),Y=new et({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnaW5jZXB0aW9uX3Jlc25ldF92MiclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;inception_resnet_v2&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)'}}),z=new rt({}),P=new rt({}),L=new et({props:{code:"JTQwbWlzYyU3QnN6ZWdlZHkyMDE2aW5jZXB0aW9udjQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB0aXRsZSUzRCU3QkluY2VwdGlvbi12NCUyQyUyMEluY2VwdGlvbi1SZXNOZXQlMjBhbmQlMjB0aGUlMjBJbXBhY3QlMjBvZiUyMFJlc2lkdWFsJTIwQ29ubmVjdGlvbnMlMjBvbiUyMExlYXJuaW5nJTdEJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXV0aG9yJTNEJTdCQ2hyaXN0aWFuJTIwU3plZ2VkeSUyMGFuZCUyMFNlcmdleSUyMElvZmZlJTIwYW5kJTIwVmluY2VudCUyMFZhbmhvdWNrZSUyMGFuZCUyMEFsZXglMjBBbGVtaSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHllYXIlM0QlN0IyMDE2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwZXByaW50JTNEJTdCMTYwMi4wNzI2MSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGFyY2hpdmVQcmVmaXglM0QlN0JhclhpdiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHByaW1hcnlDbGFzcyUzRCU3QmNzLkNWJTdEJTBBJTdE",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{szegedy2016inceptionv4,
      title={Inception-v4, Inception-ResNet and the Impact of Residual Connections on Learning}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{Christian Szegedy and Sergey Ioffe and Vincent Vanhoucke and Alex Alemi}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2016}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{1602.07261}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.CV}</span><span class="language-xml">
}</span>`}}),{c(){w=l("meta"),ht=i(),st=l("p"),mt=i(),J=l("h1"),v=l("a"),at=l("span"),c(x.$$.fragment),Vt=i(),D=l("span"),D.textContent=Ht,ct=i(),$=l("p"),$.innerHTML=zt,dt=i(),j=l("h2"),U=l("a"),lt=l("span"),c(k.$$.fragment),Xt=i(),q=l("span"),q.textContent=Ft,ut=i(),N=l("p"),N.textContent=Pt,gt=i(),c(B.$$.fragment),Mt=i(),_=l("p"),_.textContent=Lt,yt=i(),c(W.$$.fragment),wt=i(),E=l("p"),E.textContent=Dt,Jt=i(),c(G.$$.fragment),jt=i(),Q=l("p"),Q.textContent=qt,ft=i(),c(V.$$.fragment),Tt=i(),X=l("p"),X.innerHTML=Kt,bt=i(),S=l("p"),S.innerHTML=Ot,vt=i(),f=l("h2"),C=l("a"),nt=l("span"),c(R.$$.fragment),St=i(),K=l("span"),K.textContent=te,Ut=i(),A=l("p"),A.textContent=ee,Ct=i(),c(Y.$$.fragment),It=i(),H=l("p"),H.innerHTML=se,Zt=i(),T=l("h2"),I=l("a"),it=l("span"),c(z.$$.fragment),Rt=i(),O=l("span"),O.textContent=ae,xt=i(),F=l("p"),F.innerHTML=le,$t=i(),b=l("h2"),Z=l("a"),pt=l("span"),c(P.$$.fragment),At=i(),tt=l("span"),tt.textContent=ne,kt=i(),c(L.$$.fragment),Nt=i(),ot=l("p"),this.h()},l(t){const s=fe("svelte-1phssyn",document.head);w=n(s,"META",{name:!0,content:!0}),s.forEach(e),ht=p(t),st=n(t,"P",{}),h(st).forEach(e),mt=p(t),J=n(t,"H1",{class:!0});var _t=h(J);v=n(_t,"A",{id:!0,class:!0,href:!0});var ie=h(v);at=n(ie,"SPAN",{});var pe=h(at);d(x.$$.fragment,pe),pe.forEach(e),ie.forEach(e),Vt=p(_t),D=n(_t,"SPAN",{"data-svelte-h":!0}),m(D)!=="svelte-eofr33"&&(D.textContent=Ht),_t.forEach(e),ct=p(t),$=n(t,"P",{"data-svelte-h":!0}),m($)!=="svelte-gd1at0"&&($.innerHTML=zt),dt=p(t),j=n(t,"H2",{class:!0});var Wt=h(j);U=n(Wt,"A",{id:!0,class:!0,href:!0});var oe=h(U);lt=n(oe,"SPAN",{});var re=h(lt);d(k.$$.fragment,re),re.forEach(e),oe.forEach(e),Xt=p(Wt),q=n(Wt,"SPAN",{"data-svelte-h":!0}),m(q)!=="svelte-1c1hspn"&&(q.textContent=Ft),Wt.forEach(e),ut=p(t),N=n(t,"P",{"data-svelte-h":!0}),m(N)!=="svelte-18ywhxh"&&(N.textContent=Pt),gt=p(t),d(B.$$.fragment,t),Mt=p(t),_=n(t,"P",{"data-svelte-h":!0}),m(_)!=="svelte-1c2ipa8"&&(_.textContent=Lt),yt=p(t),d(W.$$.fragment,t),wt=p(t),E=n(t,"P",{"data-svelte-h":!0}),m(E)!=="svelte-1n9qsq1"&&(E.textContent=Dt),Jt=p(t),d(G.$$.fragment,t),jt=p(t),Q=n(t,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-19cnvx1"&&(Q.textContent=qt),ft=p(t),d(V.$$.fragment,t),Tt=p(t),X=n(t,"P",{"data-svelte-h":!0}),m(X)!=="svelte-17lzl0w"&&(X.innerHTML=Kt),bt=p(t),S=n(t,"P",{"data-svelte-h":!0}),m(S)!=="svelte-1wmi3ea"&&(S.innerHTML=Ot),vt=p(t),f=n(t,"H2",{class:!0});var Et=h(f);C=n(Et,"A",{id:!0,class:!0,href:!0});var he=h(C);nt=n(he,"SPAN",{});var me=h(nt);d(R.$$.fragment,me),me.forEach(e),he.forEach(e),St=p(Et),K=n(Et,"SPAN",{"data-svelte-h":!0}),m(K)!=="svelte-1viv4qv"&&(K.textContent=te),Et.forEach(e),Ut=p(t),A=n(t,"P",{"data-svelte-h":!0}),m(A)!=="svelte-9sr7nh"&&(A.textContent=ee),Ct=p(t),d(Y.$$.fragment,t),It=p(t),H=n(t,"P",{"data-svelte-h":!0}),m(H)!=="svelte-1kguc51"&&(H.innerHTML=se),Zt=p(t),T=n(t,"H2",{class:!0});var Gt=h(T);I=n(Gt,"A",{id:!0,class:!0,href:!0});var ce=h(I);it=n(ce,"SPAN",{});var de=h(it);d(z.$$.fragment,de),de.forEach(e),ce.forEach(e),Rt=p(Gt),O=n(Gt,"SPAN",{"data-svelte-h":!0}),m(O)!=="svelte-1ce591d"&&(O.textContent=ae),Gt.forEach(e),xt=p(t),F=n(t,"P",{"data-svelte-h":!0}),m(F)!=="svelte-1n0coha"&&(F.innerHTML=le),$t=p(t),b=n(t,"H2",{class:!0});var Qt=h(b);Z=n(Qt,"A",{id:!0,class:!0,href:!0});var ue=h(Z);pt=n(ue,"SPAN",{});var ge=h(pt);d(P.$$.fragment,ge),ge.forEach(e),ue.forEach(e),At=p(Qt),tt=n(Qt,"SPAN",{"data-svelte-h":!0}),m(tt)!=="svelte-15mb3gy"&&(tt.textContent=ne),Qt.forEach(e),kt=p(t),d(L.$$.fragment,t),Nt=p(t),ot=n(t,"P",{}),h(ot).forEach(e),this.h()},h(){o(w,"name","hf:doc:metadata"),o(w,"content",JSON.stringify(be)),o(v,"id","inception-resnet-v2"),o(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(v,"href","#inception-resnet-v2"),o(J,"class","relative group"),o(U,"id","how-do-i-use-this-model-on-an-image"),o(U,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(U,"href","#how-do-i-use-this-model-on-an-image"),o(j,"class","relative group"),o(C,"id","how-do-i-finetune-this-model"),o(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(C,"href","#how-do-i-finetune-this-model"),o(f,"class","relative group"),o(I,"id","how-do-i-train-this-model"),o(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(I,"href","#how-do-i-train-this-model"),o(T,"class","relative group"),o(Z,"id","citation"),o(Z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(Z,"href","#citation"),o(b,"class","relative group")},m(t,s){r(document.head,w),a(t,ht,s),a(t,st,s),a(t,mt,s),a(t,J,s),r(J,v),r(v,at),u(x,at,null),r(J,Vt),r(J,D),a(t,ct,s),a(t,$,s),a(t,dt,s),a(t,j,s),r(j,U),r(U,lt),u(k,lt,null),r(j,Xt),r(j,q),a(t,ut,s),a(t,N,s),a(t,gt,s),u(B,t,s),a(t,Mt,s),a(t,_,s),a(t,yt,s),u(W,t,s),a(t,wt,s),a(t,E,s),a(t,Jt,s),u(G,t,s),a(t,jt,s),a(t,Q,s),a(t,ft,s),u(V,t,s),a(t,Tt,s),a(t,X,s),a(t,bt,s),a(t,S,s),a(t,vt,s),a(t,f,s),r(f,C),r(C,nt),u(R,nt,null),r(f,St),r(f,K),a(t,Ut,s),a(t,A,s),a(t,Ct,s),u(Y,t,s),a(t,It,s),a(t,H,s),a(t,Zt,s),a(t,T,s),r(T,I),r(I,it),u(z,it,null),r(T,Rt),r(T,O),a(t,xt,s),a(t,F,s),a(t,$t,s),a(t,b,s),r(b,Z),r(Z,pt),u(P,pt,null),r(b,At),r(b,tt),a(t,kt,s),u(L,t,s),a(t,Nt,s),a(t,ot,s),Bt=!0},p:ye,i(t){Bt||(g(x.$$.fragment,t),g(k.$$.fragment,t),g(B.$$.fragment,t),g(W.$$.fragment,t),g(G.$$.fragment,t),g(V.$$.fragment,t),g(R.$$.fragment,t),g(Y.$$.fragment,t),g(z.$$.fragment,t),g(P.$$.fragment,t),g(L.$$.fragment,t),Bt=!0)},o(t){M(x.$$.fragment,t),M(k.$$.fragment,t),M(B.$$.fragment,t),M(W.$$.fragment,t),M(G.$$.fragment,t),M(V.$$.fragment,t),M(R.$$.fragment,t),M(Y.$$.fragment,t),M(z.$$.fragment,t),M(P.$$.fragment,t),M(L.$$.fragment,t),Bt=!1},d(t){t&&(e(ht),e(st),e(mt),e(J),e(ct),e($),e(dt),e(j),e(ut),e(N),e(gt),e(Mt),e(_),e(yt),e(wt),e(E),e(Jt),e(jt),e(Q),e(ft),e(Tt),e(X),e(bt),e(S),e(vt),e(f),e(Ut),e(A),e(Ct),e(It),e(H),e(Zt),e(T),e(xt),e(F),e($t),e(b),e(kt),e(Nt),e(ot)),e(w),y(x),y(k),y(B,t),y(W,t),y(G,t),y(V,t),y(R),y(Y,t),y(z),y(P),y(L,t)}}}const be={local:"inception-resnet-v2",sections:[{local:"how-do-i-use-this-model-on-an-image",title:"How do I use this model on an image?"},{local:"how-do-i-finetune-this-model",title:"How do I finetune this model?"},{local:"how-do-i-train-this-model",title:"How do I train this model?"},{local:"citation",title:"Citation"}],title:"Inception ResNet v2"};function ve(Yt){return we(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class xe extends Je{constructor(w){super(),je(this,w,ve,Te,Me,{})}}export{xe as component};
