import{s as Ut,n as It,o as Zt}from"../chunks/scheduler.85c25b89.js";import{S as $t,i as Ct,g as p,s as l,r as m,A as kt,h as i,f as e,c as n,j as ft,u as o,x as d,k as bt,y as Bt,a,v as c,d as r,t as h,w as M}from"../chunks/index.c9837788.js";import{C as v}from"../chunks/CodeBlock.52fa569e.js";import{H as _}from"../chunks/Heading.3097d2ed.js";function Nt(rt){let J,X,V,Y,w,z,g,ht='A <strong>TResNet</strong> is a variant on a <a href="https://paperswithcode.com/method/resnet" rel="nofollow">ResNet</a> that aim to boost accuracy while maintaining GPU training and inference efficiency.  They contain several design tricks including a SpaceToDepth stem, <a href="https://paperswithcode.com/method/anti-alias-downsampling" rel="nofollow">Anti-Alias downsampling</a>, In-Place Activated BatchNorm, Blocks selection and <a href="https://paperswithcode.com/method/squeeze-and-excitation-block" rel="nofollow">squeeze-and-excitation layers</a>.',H,y,A,j,Mt="To load a pretrained model:",F,T,S,u,dt="To load and preprocess the image:",L,f,D,b,Jt="To get the model predictions:",P,U,q,I,wt="To get the top-5 predictions class names:",K,Z,O,$,gt="Replace the model name with the variant you want to use, e.g. <code>tresnet_l</code>. You can find the IDs in the model summaries at the top of this page.",tt,C,yt='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',st,k,et,B,jt="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",at,N,lt,G,Tt=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,nt,W,pt,x,ut='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',it,E,mt,R,ot,Q,ct;return w=new _({props:{title:"TResNet",local:"tresnet",headingTag:"h1"}}),y=new _({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),T=new v({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3RyZXNuZXRfbCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;tresnet_l&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),f=new v({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),U=new v({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),Z=new v({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),k=new _({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),N=new v({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgndHJlc25ldF9sJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;tresnet_l&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),W=new _({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),E=new _({props:{title:"Citation",local:"citation",headingTag:"h2"}}),R=new v({props:{code:"JTQwbWlzYyU3QnJpZG5pazIwMjB0cmVzbmV0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdGl0bGUlM0QlN0JUUmVzTmV0JTNBJTIwSGlnaCUyMFBlcmZvcm1hbmNlJTIwR1BVLURlZGljYXRlZCUyMEFyY2hpdGVjdHVyZSU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMGF1dGhvciUzRCU3QlRhbCUyMFJpZG5payUyMGFuZCUyMEh1c3NhbSUyMExhd2VuJTIwYW5kJTIwQXNhZiUyME5veSUyMGFuZCUyMEVtYW51ZWwlMjBCZW4lMjBCYXJ1Y2glMjBhbmQlMjBHaWxhZCUyMFNoYXJpciUyMGFuZCUyMEl0YW1hciUyMEZyaWVkbWFuJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IyMDAzLjEzNjMwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuQ1YlN0QlMEElN0Q=",highlighted:`@misc{ridnik2020tresnet,
      title={TResNet: High Performance GPU-Dedicated Architecture}, 
      author={Tal Ridnik <span class="hljs-keyword">and </span>Hussam Lawen <span class="hljs-keyword">and </span>Asaf Noy <span class="hljs-keyword">and </span>Emanuel <span class="hljs-keyword">Ben </span><span class="hljs-keyword">Baruch </span><span class="hljs-keyword">and </span>Gilad <span class="hljs-keyword">Sharir </span><span class="hljs-keyword">and </span>Itamar Friedman},
      year={<span class="hljs-number">2020</span>},
      eprint={<span class="hljs-number">2003</span>.<span class="hljs-number">13630</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`,wrap:!1}}),{c(){J=p("meta"),X=l(),V=p("p"),Y=l(),m(w.$$.fragment),z=l(),g=p("p"),g.innerHTML=ht,H=l(),m(y.$$.fragment),A=l(),j=p("p"),j.textContent=Mt,F=l(),m(T.$$.fragment),S=l(),u=p("p"),u.textContent=dt,L=l(),m(f.$$.fragment),D=l(),b=p("p"),b.textContent=Jt,P=l(),m(U.$$.fragment),q=l(),I=p("p"),I.textContent=wt,K=l(),m(Z.$$.fragment),O=l(),$=p("p"),$.innerHTML=gt,tt=l(),C=p("p"),C.innerHTML=yt,st=l(),m(k.$$.fragment),et=l(),B=p("p"),B.textContent=jt,at=l(),m(N.$$.fragment),lt=l(),G=p("p"),G.innerHTML=Tt,nt=l(),m(W.$$.fragment),pt=l(),x=p("p"),x.innerHTML=ut,it=l(),m(E.$$.fragment),mt=l(),m(R.$$.fragment),ot=l(),Q=p("p"),this.h()},l(t){const s=kt("svelte-u9bgzb",document.head);J=i(s,"META",{name:!0,content:!0}),s.forEach(e),X=n(t),V=i(t,"P",{}),ft(V).forEach(e),Y=n(t),o(w.$$.fragment,t),z=n(t),g=i(t,"P",{"data-svelte-h":!0}),d(g)!=="svelte-15ptpxo"&&(g.innerHTML=ht),H=n(t),o(y.$$.fragment,t),A=n(t),j=i(t,"P",{"data-svelte-h":!0}),d(j)!=="svelte-18ywhxh"&&(j.textContent=Mt),F=n(t),o(T.$$.fragment,t),S=n(t),u=i(t,"P",{"data-svelte-h":!0}),d(u)!=="svelte-1c2ipa8"&&(u.textContent=dt),L=n(t),o(f.$$.fragment,t),D=n(t),b=i(t,"P",{"data-svelte-h":!0}),d(b)!=="svelte-1n9qsq1"&&(b.textContent=Jt),P=n(t),o(U.$$.fragment,t),q=n(t),I=i(t,"P",{"data-svelte-h":!0}),d(I)!=="svelte-19cnvx1"&&(I.textContent=wt),K=n(t),o(Z.$$.fragment,t),O=n(t),$=i(t,"P",{"data-svelte-h":!0}),d($)!=="svelte-rdmov8"&&($.innerHTML=gt),tt=n(t),C=i(t,"P",{"data-svelte-h":!0}),d(C)!=="svelte-1wmi3ea"&&(C.innerHTML=yt),st=n(t),o(k.$$.fragment,t),et=n(t),B=i(t,"P",{"data-svelte-h":!0}),d(B)!=="svelte-9sr7nh"&&(B.textContent=jt),at=n(t),o(N.$$.fragment,t),lt=n(t),G=i(t,"P",{"data-svelte-h":!0}),d(G)!=="svelte-1kguc51"&&(G.innerHTML=Tt),nt=n(t),o(W.$$.fragment,t),pt=n(t),x=i(t,"P",{"data-svelte-h":!0}),d(x)!=="svelte-1n0coha"&&(x.innerHTML=ut),it=n(t),o(E.$$.fragment,t),mt=n(t),o(R.$$.fragment,t),ot=n(t),Q=i(t,"P",{}),ft(Q).forEach(e),this.h()},h(){bt(J,"name","hf:doc:metadata"),bt(J,"content",Gt)},m(t,s){Bt(document.head,J),a(t,X,s),a(t,V,s),a(t,Y,s),c(w,t,s),a(t,z,s),a(t,g,s),a(t,H,s),c(y,t,s),a(t,A,s),a(t,j,s),a(t,F,s),c(T,t,s),a(t,S,s),a(t,u,s),a(t,L,s),c(f,t,s),a(t,D,s),a(t,b,s),a(t,P,s),c(U,t,s),a(t,q,s),a(t,I,s),a(t,K,s),c(Z,t,s),a(t,O,s),a(t,$,s),a(t,tt,s),a(t,C,s),a(t,st,s),c(k,t,s),a(t,et,s),a(t,B,s),a(t,at,s),c(N,t,s),a(t,lt,s),a(t,G,s),a(t,nt,s),c(W,t,s),a(t,pt,s),a(t,x,s),a(t,it,s),c(E,t,s),a(t,mt,s),c(R,t,s),a(t,ot,s),a(t,Q,s),ct=!0},p:It,i(t){ct||(r(w.$$.fragment,t),r(y.$$.fragment,t),r(T.$$.fragment,t),r(f.$$.fragment,t),r(U.$$.fragment,t),r(Z.$$.fragment,t),r(k.$$.fragment,t),r(N.$$.fragment,t),r(W.$$.fragment,t),r(E.$$.fragment,t),r(R.$$.fragment,t),ct=!0)},o(t){h(w.$$.fragment,t),h(y.$$.fragment,t),h(T.$$.fragment,t),h(f.$$.fragment,t),h(U.$$.fragment,t),h(Z.$$.fragment,t),h(k.$$.fragment,t),h(N.$$.fragment,t),h(W.$$.fragment,t),h(E.$$.fragment,t),h(R.$$.fragment,t),ct=!1},d(t){t&&(e(X),e(V),e(Y),e(z),e(g),e(H),e(A),e(j),e(F),e(S),e(u),e(L),e(D),e(b),e(P),e(q),e(I),e(K),e(O),e($),e(tt),e(C),e(st),e(et),e(B),e(at),e(lt),e(G),e(nt),e(pt),e(x),e(it),e(mt),e(ot),e(Q)),e(J),M(w,t),M(y,t),M(T,t),M(f,t),M(U,t),M(Z,t),M(k,t),M(N,t),M(W,t),M(E,t),M(R,t)}}}const Gt='{"title":"TResNet","local":"tresnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Wt(rt){return Zt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Vt extends $t{constructor(J){super(),Ct(this,J,Wt,Nt,Ut,{})}}export{Vt as component};
