import{s as ss,n as ls,o as ps}from"../chunks/scheduler.85c25b89.js";import{S as ds,i as cs,g as a,s as n,r as d,A as gs,h as o,f as i,c as r,j as l,u as c,x as m,k as v,y as t,a as p,v as g,d as u,t as f,w as h}from"../chunks/index.c9837788.js";import{D as b}from"../chunks/Docstring.5c1d567f.js";import{H as K,E as us}from"../chunks/EditOnGithub.b65eee75.js";function fs(bi){let Z,bo,oo,_o,ve,xo,be,_i="This page contains the API reference documentation for learning rate optimizers included in <code>timm</code>.",$o,_e,yo,xe,wo,_,$e,yn,At,xi="Create an optimizer instance via timm registry.",wn,Tt,$i=`Creates and configures an optimizer with appropriate parameter groups and settings.
Supports automatic parameter group creation for weight decay and layer-wise learning
rates, as well as custom parameter grouping.`,Cn,Dt,yi="Examples:",Ln,no,ro,ye,we,An,zt,wi="optimizer = create_optimizer_v2(model, ‘adamw’, lr=1e-3)",Tn,io,mo,Ce,Le,Dn,Mt,Ci=`optimizer = create_optimizer_v2(
…     model, ‘sgd’, lr=0.1, momentum=0.9, weight_decay=1e-4
… )`,zn,so,lo,Ae,Te,Mn,Pt,Li=`optimizer = create_optimizer_v2(
…     model, ‘adam’, lr=1e-3, layer_decay=0.7
… )`,Pn,po,co,De,ze,qn,qt,Ai=`def group_fn(model):
…     return [
…         {‘params’: model.backbone.parameters(), ‘lr’: 1e-4},
…         {‘params’: model.head.parameters(), ‘lr’: 1e-3}
…     ]
optimizer = create_optimizer_v2(
…     model, ‘sgd’, param_group_fn=group_fn
… )`,kn,kt,Ti=`Note:
Parameter group handling precedence:`,En,Et,Di="<li>If param_group_fn is provided, it will be used exclusively</li> <li>If layer_decay is provided, layer-wise groups will be created</li> <li>If weight_decay &gt; 0 and filter_bias_and_bn is True, weight decay groups will be created</li> <li>Otherwise, all parameters will be in a single group</li>",Co,x,Me,Nn,Nt,zi="List available optimizer names, optionally filtered.",On,Ot,Mi=`List all registered optimizers, with optional filtering using wildcard patterns.
Optimizers can be filtered using include and exclude patterns, and can optionally
return descriptions with each optimizer name.`,In,It,Pi="Examples:",Fn,Ft,qi=`<blockquote><blockquote><p>list_optimizers()
[‘adam’, ‘adamw’, ‘sgd’, …]</p></blockquote></blockquote>`,Hn,Ht,ki=`<blockquote><blockquote><p>list_optimizers([‘la<em>’, ‘nla</em>’])  # List lamb &amp; lars
[‘lamb’, ‘lambc’, ‘larc’, ‘lars’, ‘nlarc’, ‘nlars’]</p></blockquote></blockquote>`,Bn,Bt,Ei=`<blockquote><blockquote><p>list_optimizers(’<em>adam</em>’, exclude_filters=[‘bnb<em>’, ‘fused</em>’])  # Exclude bnb &amp; apex adam optimizers
[‘adam’, ‘adamax’, ‘adamp’, ‘adamw’, ‘nadam’, ‘nadamw’, ‘radam’]</p></blockquote></blockquote>`,Rn,Rt,Ni=`<blockquote><blockquote><p>list_optimizers(with_description=True)  # Get descriptions
[(‘adabelief’, ‘Adapts learning rate based on gradient prediction error’),
(‘adadelta’, ‘torch.optim Adadelta, Adapts learning rates based on running windows of gradients’),
(‘adafactor’, ‘Memory-efficient implementation of Adam with factored gradients’),
…]</p></blockquote></blockquote>`,Lo,C,Pe,Gn,Gt,Oi="Get optimizer class by name with option to bind default arguments.",Sn,St,Ii=`Retrieves the optimizer class or a partial function with default arguments bound.
This allows direct instantiation of optimizers with their default configurations
without going through the full factory.`,Vn,Vt,Fi="Examples:",Wn,go,uo,qe,ke,Un,Wt,Hi=`SGD = get_optimizer_class(‘sgd’)  # nesterov=True bound
opt = SGD(model.parameters(), lr=0.1, momentum=0.9)`,Qn,fo,ho,Ee,Ne,jn,Ut,Bi=`SGD = get_optimizer_class(‘sgd’)
opt = SGD(model.parameters(), lr=1e-3, momentum=0.9)`,Ao,Oe,To,L,Ie,Kn,Qt,Ri="Implements AdaBelief algorithm. Modified from Adam in PyTorch",Zn,jt,Gi="reference: AdaBelief Optimizer, adapting stepsizes by the belief in observed gradients, NeurIPS 2020",Xn,Kt,Si=`For a complete table of recommended hyperparameters, see <a href="https://github.com/juntang-zhuang/Adabelief-Optimizer&#39;" rel="nofollow">https://github.com/juntang-zhuang/Adabelief-Optimizer’</a>
For example train/args for EfficientNet see these gists`,Jn,Zt,Vi='<li>link to train_scipt: <a href="https://gist.github.com/juntang-zhuang/0a501dd51c02278d952cf159bc233037" rel="nofollow">https://gist.github.com/juntang-zhuang/0a501dd51c02278d952cf159bc233037</a></li> <li>link to args.yaml: <a href="https://gist.github.com/juntang-zhuang/517ce3c27022b908bb93f78e4f786dc3" rel="nofollow">https://gist.github.com/juntang-zhuang/517ce3c27022b908bb93f78e4f786dc3</a></li>',Yn,J,Fe,er,Xt,Wi="Performs a single optimization step.",Do,A,He,tr,Jt,Ui="Implements Adafactor algorithm.",ar,Yt,Qi=`This implementation is based on: <code>Adafactor: Adaptive Learning Rates with Sublinear Memory Cost</code>
(see <a href="https://arxiv.org/abs/1804.04235" rel="nofollow">https://arxiv.org/abs/1804.04235</a>)`,or,ea,ji=`Note that this optimizer internally adjusts the learning rate depending on the
<em>scale_parameter</em>, <em>relative_step</em> and <em>warmup_init</em> options.`,nr,ta,Ki=`To use a manual (external) learning rate schedule you should set <code>scale_parameter=False</code> and
<code>relative_step=False</code>.`,rr,Y,Be,ir,aa,Zi="Performs a single optimization step.",zo,R,Re,mr,oa,Xi="PyTorch implementation of BigVision’s Adafactor variant with both single and multi tensor implementations.",sr,na,Ji='Adapted from <a href="https://github.com/google-research/big_vision" rel="nofollow">https://github.com/google-research/big_vision</a> by Ross Wightman',Mo,T,Ge,lr,ra,Yi="Implements the AdaHessian algorithm from “ADAHESSIAN: An Adaptive Second OrderOptimizer for Machine Learning”",pr,ee,Se,dr,ia,em="Gets all parameters in all param_groups with gradients",cr,te,Ve,gr,ma,tm="Computes the Hutchinson approximation of the hessian trace and accumulates it for each trainable parameter.",ur,ae,We,fr,sa,am="Performs a single optimization step.",hr,oe,Ue,vr,la,om="Zeros out the accumalated hessian traces.",Po,Qe,je,qo,P,Ke,br,pa,nm="Implements AdamW algorithm.",_r,da,rm=`The original Adam algorithm was proposed in <code>Adam: A Method for Stochastic Optimization</code><em>.
The AdamW variant was proposed in <code>Decoupled Weight Decay Regularization</code></em>.`,xr,ca,im=`.. _Adam\\: A Method for Stochastic Optimization:
<a href="https://arxiv.org/abs/1412.6980" rel="nofollow">https://arxiv.org/abs/1412.6980</a>
.. _Decoupled Weight Decay Regularization:
<a href="https://arxiv.org/abs/1711.05101" rel="nofollow">https://arxiv.org/abs/1711.05101</a>
.. _On the Convergence of Adam and Beyond:
<a href="https://openreview.net/forum?id=ryQu7f-RZ" rel="nofollow">https://openreview.net/forum?id=ryQu7f-RZ</a>`,$r,ne,Ze,yr,ga,mm="Performs a single optimization step.",ko,G,Xe,wr,ua,sm=`Implements a pytorch variant of Adan
Adan was proposed in
Adan: Adaptive Nesterov Momentum Algorithm for Faster Optimizing Deep Models[J]. arXiv preprint arXiv:2208.06677, 2022.
<a href="https://arxiv.org/abs/2208.06677" rel="nofollow">https://arxiv.org/abs/2208.06677</a>`,Cr,re,Je,Lr,fa,lm="Performs a single optimization step.",Eo,S,Ye,Ar,ha,pm='ADOPT: Modified Adam Can Converge with Any β2 with the Optimal Rate: <a href="https://arxiv.org/abs/2411.02853" rel="nofollow">https://arxiv.org/abs/2411.02853</a>',Tr,ie,et,Dr,va,dm="Perform a single optimization step.",No,q,tt,zr,ba,cm=`Implements a pure pytorch variant of FuseLAMB (NvLamb variant) optimizer from apex.optimizers.FusedLAMB
reference: <a href="https://github.com/NVIDIA/DeepLearningExamples/blob/master/PyTorch/LanguageModeling/Transformer-XL/pytorch/lamb.py" rel="nofollow">https://github.com/NVIDIA/DeepLearningExamples/blob/master/PyTorch/LanguageModeling/Transformer-XL/pytorch/lamb.py</a>`,Mr,_a,gm="LAMB was proposed in <code>Large Batch Optimization for Deep Learning: Training BERT in 76 minutes</code>_.",Pr,xa,um=`.. _Large Batch Optimization for Deep Learning - Training BERT in 76 minutes:
<a href="https://arxiv.org/abs/1904.00962" rel="nofollow">https://arxiv.org/abs/1904.00962</a>
.. _On the Convergence of Adam and Beyond:
<a href="https://openreview.net/forum?id=ryQu7f-RZ" rel="nofollow">https://openreview.net/forum?id=ryQu7f-RZ</a>`,qr,me,at,kr,$a,fm="Performs a single optimization step.",Oo,N,ot,Er,ya,hm="LARS for PyTorch",Nr,wa,vm='Paper: <code>Large batch training of Convolutional Networks</code> - <a href="https://arxiv.org/pdf/1708.03888.pdf" rel="nofollow">https://arxiv.org/pdf/1708.03888.pdf</a>',Or,se,nt,Ir,Ca,bm="Performs a single optimization step.",Io,V,rt,Fr,La,_m="Implements Lion algorithm.",Hr,le,it,Br,Aa,xm="Performs a single optimization step.",Fo,mt,st,Ho,w,lt,Rr,Ta,$m=`MADGRAD_: A Momentumized, Adaptive, Dual Averaged Gradient Method for Stochastic
Optimization.`,Gr,Da,ym='.. _MADGRAD: <a href="https://arxiv.org/abs/2101.11075" rel="nofollow">https://arxiv.org/abs/2101.11075</a>',Sr,za,wm=`MADGRAD is a general purpose optimizer that can be used in place of SGD or
Adam may converge faster and generalize better. Currently GPU-only.
Typically, the same learning rate schedule that is used for SGD or Adam may
be used. The overall learning rate is not comparable to either method and
should be determined by a hyper-parameter sweep.`,Vr,Ma,Cm=`MADGRAD requires less weight decay than other methods, often as little as
zero. Momentum values used for SGD or Adam’s beta1 should work here also.`,Wr,Pa,Lm="On sparse problems both weight_decay and momentum should be set to 0.",Ur,pe,pt,Qr,qa,Am="Performs a single optimization step.",Bo,D,dt,jr,ka,Tm="Implements Nadam algorithm (a variant of Adam based on Nesterov momentum).",Kr,Ea,Dm="It has been proposed in <code>Incorporating Nesterov Momentum into Adam</code>__.",Zr,Na,zm='<strong><a href="http://cs229.stanford.edu/proj2015/054_report.pdf" rel="nofollow">http://cs229.stanford.edu/proj2015/054_report.pdf</a></strong> <a href="http://www.cs.toronto.edu/~fritz/absps/momentum.pdf" rel="nofollow">http://www.cs.toronto.edu/~fritz/absps/momentum.pdf</a>',Xr,Oa,Mm=`Originally taken from: <a href="https://github.com/pytorch/pytorch/pull/1408" rel="nofollow">https://github.com/pytorch/pytorch/pull/1408</a>
NOTE: Has potential issues but does work well on some problems.`,Jr,de,ct,Yr,Ia,Pm="Performs a single optimization step.",Ro,k,gt,ei,Fa,qm="Implements NAdamW algorithm.",ti,Ha,km=`See Table 1 in <a href="https://arxiv.org/abs/1910.05446" rel="nofollow">https://arxiv.org/abs/1910.05446</a> for the implementation of
the NAdam algorithm (there is also a comment in the code which highlights
the only difference of NAdamW and AdamW).
For further details regarding the algorithm we refer to
<code>Decoupled Weight Decay Regularization</code>_.`,ai,Ba,Em=`.. _Decoupled Weight Decay Regularization:
<a href="https://arxiv.org/abs/1711.05101" rel="nofollow">https://arxiv.org/abs/1711.05101</a>
.. _On the Convergence of Adam and Beyond:
<a href="https://openreview.net/forum?id=ryQu7f-RZ" rel="nofollow">https://openreview.net/forum?id=ryQu7f-RZ</a>`,oi,ce,ut,ni,Ra,Nm="Performs a single optimization step.",Go,W,ft,ri,Ga,Om="Implements Novograd algorithm.",ii,ge,ht,mi,Sa,Im="Performs a single optimization step.",So,vt,bt,Vo,$,_t,si,Va,Fm="Implements RMSprop algorithm (TensorFlow style epsilon)",li,Wa,Hm=`NOTE: This is a direct cut-and-paste of PyTorch RMSprop with eps applied before sqrt
and a few other modifications to closer match Tensorflow for matching hyper-params.`,pi,Ua,Bm="Noteworthy changes include:",di,Qa,Rm="<li>Epsilon applied inside square-root</li> <li>square_avg initialized to ones</li> <li>LR scaling of update accumulated in momentum buffer</li>",ci,ja,Gm=`Proposed by G. Hinton in his
<a href="http://www.cs.toronto.edu/~tijmen/csc321/slides/lecture_slides_lec6.pdf" rel="nofollow">course</a>.`,gi,Ka,Sm=`The centered version first appears in <a href="https://arxiv.org/pdf/1308.0850v5.pdf" rel="nofollow">Generating Sequences
With Recurrent Neural Networks</a>.`,ui,ue,xt,fi,Za,Vm="Performs a single optimization step.",Wo,$t,yt,Uo,X,wt,hi,fe,Ct,vi,Xa,Wm="Performs a single optimization step.",Qo,Lt,jo,vo,Ko;return ve=new K({props:{title:"Optimization",local:"optimization",headingTag:"h1"}}),_e=new K({props:{title:"Optimizers",local:"optimizers",headingTag:"h2"}}),xe=new K({props:{title:"Factory functions",local:"timm.optim.create_optimizer_v2",headingTag:"h3"}}),$e=new b({props:{name:"timm.optim.create_optimizer_v2",anchor:"timm.optim.create_optimizer_v2",parameters:[{name:"model_or_params",val:": Union"},{name:"opt",val:": str = 'sgd'"},{name:"lr",val:": Optional = None"},{name:"weight_decay",val:": float = 0.0"},{name:"momentum",val:": float = 0.9"},{name:"foreach",val:": Optional = None"},{name:"filter_bias_and_bn",val:": bool = True"},{name:"layer_decay",val:": Optional = None"},{name:"param_group_fn",val:": Optional = None"},{name:"**kwargs",val:": Any"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/_optim_factory.py#L836",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Configured optimizer instance.</p>
`}}),we=new K({props:{title:"Basic usage with a model",local:"basic-usage-with-a-model",headingTag:"h1"}}),Le=new K({props:{title:"SGD with momentum and weight decay",local:"sgd-with-momentum-and-weight-decay",headingTag:"h1"}}),Te=new K({props:{title:"Adam with layer-wise learning rate decay",local:"adam-with-layer-wise-learning-rate-decay",headingTag:"h1"}}),ze=new K({props:{title:"Custom parameter groups",local:"custom-parameter-groups",headingTag:"h1"}}),Me=new b({props:{name:"timm.optim.list_optimizers",anchor:"timm.optim.list_optimizers",parameters:[{name:"filter",val:": Union = ''"},{name:"exclude_filters",val:": Optional = None"},{name:"with_description",val:": bool = False"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/_optim_factory.py#L739",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of optimizer names as strings (e.g., [‘adam’, ‘adamw’, …])
If with_description is True:
List of tuples of (name, description) (e.g., [(‘adam’, ‘Adaptive Moment…’), …])</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If with_description is False</p>
`}}),Pe=new b({props:{name:"timm.optim.get_optimizer_class",anchor:"timm.optim.get_optimizer_class",parameters:[{name:"name",val:": str"},{name:"bind_defaults",val:": bool = True"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/_optim_factory.py#L799",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The optimizer class (e.g., torch.optim.Adam)
If bind_defaults is True:
A partial function with default arguments bound</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If bind_defaults is False</p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValueError</code> — If optimizer name is not found in registry</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),ke=new K({props:{title:"Get SGD with nesterov momentum default",local:"get-sgd-with-nesterov-momentum-default",headingTag:"h1"}}),Ne=new K({props:{title:"Get raw optimizer class",local:"get-raw-optimizer-class",headingTag:"h1"}}),Oe=new K({props:{title:"Optimizer Classes",local:"timm.optim.AdaBelief",headingTag:"h3"}}),Ie=new b({props:{name:"class timm.optim.AdaBelief",anchor:"timm.optim.AdaBelief",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-16"},{name:"weight_decay",val:" = 0"},{name:"amsgrad",val:" = False"},{name:"decoupled_decay",val:" = True"},{name:"fixed_decay",val:" = False"},{name:"rectify",val:" = True"},{name:"degenerated_to_sgd",val:" = True"}],parametersDescription:[{anchor:"timm.optim.AdaBelief.params",description:`<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining
parameter groups`,name:"params"},{anchor:"timm.optim.AdaBelief.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1e-3)",name:"lr"},{anchor:"timm.optim.AdaBelief.betas",description:`<strong>betas</strong> (Tuple[float, float], optional) &#x2014; coefficients used for computing
running averages of gradient and its square (default: (0.9, 0.999))`,name:"betas"},{anchor:"timm.optim.AdaBelief.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability (default: 1e-16)`,name:"eps"},{anchor:"timm.optim.AdaBelief.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.AdaBelief.amsgrad",description:`<strong>amsgrad</strong> (boolean, optional) &#x2014; whether to use the AMSGrad variant of this
algorithm from the paper <code>On the Convergence of Adam and Beyond</code>_
(default: False)`,name:"amsgrad"},{anchor:"timm.optim.AdaBelief.decoupled_decay",description:`<strong>decoupled_decay</strong> (boolean, optional) &#x2014; (default: True) If set as True, then
the optimizer uses decoupled weight decay as in AdamW`,name:"decoupled_decay"},{anchor:"timm.optim.AdaBelief.fixed_decay",description:`<strong>fixed_decay</strong> (boolean, optional) &#x2014; (default: False) This is used when weight<em>decouple
is set as True.
When fixed_decay == True, the weight decay is performed as
$W</em>{new} = W<em>{old} - W</em>{old} \\times decay$.
When fixed<em>decay == False, the weight decay is performed as
$W</em>{new} = W<em>{old} - W</em>{old} \\times decay \\times lr$. Note that in this case, the
weight decay ratio decreases with learning rate (lr).`,name:"fixed_decay"},{anchor:"timm.optim.AdaBelief.rectify",description:`<strong>rectify</strong> (boolean, optional) &#x2014; (default: True) If set as True, then perform the rectified
update similar to RAdam`,name:"rectify"},{anchor:"timm.optim.AdaBelief.degenerated_to_sgd",description:`<strong>degenerated_to_sgd</strong> (boolean, optional) (default &#x2014;True) If set as True, then perform SGD update
when variance of gradient is high`,name:"degenerated_to_sgd"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adabelief.py#L6"}}),Fe=new b({props:{name:"step",anchor:"timm.optim.AdaBelief.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.AdaBelief.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adabelief.py#L106"}}),He=new b({props:{name:"class timm.optim.Adafactor",anchor:"timm.optim.Adafactor",parameters:[{name:"params",val:""},{name:"lr",val:" = None"},{name:"eps",val:" = 1e-30"},{name:"eps_scale",val:" = 0.001"},{name:"clip_threshold",val:" = 1.0"},{name:"decay_rate",val:" = -0.8"},{name:"betas",val:" = None"},{name:"weight_decay",val:" = 0.0"},{name:"scale_parameter",val:" = True"},{name:"warmup_init",val:" = False"},{name:"min_dim_size_to_factor",val:" = 32"}],parametersDescription:[{anchor:"timm.optim.Adafactor.params",description:"<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining parameter groups",name:"params"},{anchor:"timm.optim.Adafactor.lr",description:"<strong>lr</strong> (float, optional) &#x2014; external learning rate (default: None)",name:"lr"},{anchor:"timm.optim.Adafactor.eps",description:`<strong>eps</strong> (tuple[float, float]) &#x2014; regularization constants for square gradient
and parameter scale respectively (default: (1e-30, 1e-3))`,name:"eps"},{anchor:"timm.optim.Adafactor.clip_threshold",description:"<strong>clip_threshold</strong> (float) &#x2014; threshold of root mean square of final gradient update (default: 1.0)",name:"clip_threshold"},{anchor:"timm.optim.Adafactor.decay_rate",description:"<strong>decay_rate</strong> (float) &#x2014; coefficient used to compute running averages of square gradient (default: -0.8)",name:"decay_rate"},{anchor:"timm.optim.Adafactor.beta1",description:"<strong>beta1</strong> (float) &#x2014; coefficient used for computing running averages of gradient (default: None)",name:"beta1"},{anchor:"timm.optim.Adafactor.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.Adafactor.scale_parameter",description:"<strong>scale_parameter</strong> (bool) &#x2014; if True, learning rate is scaled by root mean square of parameter (default: True)",name:"scale_parameter"},{anchor:"timm.optim.Adafactor.warmup_init",description:`<strong>warmup_init</strong> (bool) &#x2014; time-dependent learning rate computation depends on
whether warm-up initialization is being used (default: False)`,name:"warmup_init"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adafactor.py#L17"}}),Be=new b({props:{name:"step",anchor:"timm.optim.Adafactor.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Adafactor.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model and returns the loss.",name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adafactor.py#L117"}}),Re=new b({props:{name:"class timm.optim.AdafactorBigVision",anchor:"timm.optim.AdafactorBigVision",parameters:[{name:"params",val:""},{name:"lr",val:": float = 1.0"},{name:"min_dim_size_to_factor",val:": int = 32"},{name:"decay_rate",val:": float = 0.8"},{name:"decay_offset",val:": int = 0"},{name:"beta2_cap",val:": float = 0.999"},{name:"momentum",val:": Optional = 0.9"},{name:"momentum_dtype",val:": Union = torch.bfloat16"},{name:"eps",val:": Optional = None"},{name:"weight_decay",val:": float = 0.0"},{name:"clipping_threshold",val:": Optional = None"},{name:"unscaled_wd",val:": bool = False"},{name:"foreach",val:": Optional = False"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adafactor_bv.py#L48"}}),Ge=new b({props:{name:"class timm.optim.Adahessian",anchor:"timm.optim.Adahessian",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.1"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0.0"},{name:"hessian_power",val:" = 1.0"},{name:"update_each",val:" = 1"},{name:"n_samples",val:" = 1"},{name:"avg_conv_kernel",val:" = False"}],parametersDescription:[{anchor:"timm.optim.Adahessian.params",description:"<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining parameter groups",name:"params"},{anchor:"timm.optim.Adahessian.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 0.1)",name:"lr"},{anchor:"timm.optim.Adahessian.betas",description:`<strong>betas</strong> ((float, float), optional) &#x2014; coefficients used for computing running averages of gradient and the
squared hessian trace (default: (0.9, 0.999))`,name:"betas"},{anchor:"timm.optim.Adahessian.eps",description:"<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve numerical stability (default: 1e-8)",name:"eps"},{anchor:"timm.optim.Adahessian.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0.0)",name:"weight_decay"},{anchor:"timm.optim.Adahessian.hessian_power",description:"<strong>hessian_power</strong> (float, optional) &#x2014; exponent of the hessian trace (default: 1.0)",name:"hessian_power"},{anchor:"timm.optim.Adahessian.update_each",description:`<strong>update_each</strong> (int, optional) &#x2014; compute the hessian trace approximation only after <em>this</em> number of steps
(to save time) (default: 1)`,name:"update_each"},{anchor:"timm.optim.Adahessian.n_samples",description:"<strong>n_samples</strong> (int, optional) &#x2014; how many times to sample <code>z</code> for the approximation of the hessian trace (default: 1)",name:"n_samples"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adahessian.py#L9"}}),Se=new b({props:{name:"get_params",anchor:"timm.optim.Adahessian.get_params",parameters:[],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adahessian.py#L74"}}),Ve=new b({props:{name:"set_hessian",anchor:"timm.optim.Adahessian.set_hessian",parameters:[],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adahessian.py#L90"}}),We=new b({props:{name:"step",anchor:"timm.optim.Adahessian.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Adahessian.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; a closure that reevaluates the model and returns the loss (default &#x2014; None)",name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adahessian.py#L118"}}),Ue=new b({props:{name:"zero_hessian",anchor:"timm.optim.Adahessian.zero_hessian",parameters:[],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adahessian.py#L81"}}),je=new b({props:{name:"class timm.optim.AdamP",anchor:"timm.optim.AdamP",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0"},{name:"delta",val:" = 0.1"},{name:"wd_ratio",val:" = 0.1"},{name:"nesterov",val:" = False"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adamp.py#L43"}}),Ke=new b({props:{name:"class timm.optim.AdamW",anchor:"timm.optim.AdamW",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0.01"},{name:"amsgrad",val:" = False"}],parametersDescription:[{anchor:"timm.optim.AdamW.params",description:`<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining
parameter groups`,name:"params"},{anchor:"timm.optim.AdamW.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1e-3)",name:"lr"},{anchor:"timm.optim.AdamW.betas",description:`<strong>betas</strong> (Tuple[float, float], optional) &#x2014; coefficients used for computing
running averages of gradient and its square (default: (0.9, 0.999))`,name:"betas"},{anchor:"timm.optim.AdamW.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability (default: 1e-8)`,name:"eps"},{anchor:"timm.optim.AdamW.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay coefficient (default: 1e-2)",name:"weight_decay"},{anchor:"timm.optim.AdamW.amsgrad",description:`<strong>amsgrad</strong> (boolean, optional) &#x2014; whether to use the AMSGrad variant of this
algorithm from the paper <code>On the Convergence of Adam and Beyond</code>_
(default: False)`,name:"amsgrad"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adamw.py#L12"}}),Ze=new b({props:{name:"step",anchor:"timm.optim.AdamW.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.AdamW.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adamw.py#L71"}}),Xe=new b({props:{name:"class timm.optim.Adan",anchor:"timm.optim.Adan",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.98, 0.92, 0.99)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0.0"},{name:"no_prox",val:" = False"}],parametersDescription:[{anchor:"timm.optim.Adan.params",description:"<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining parameter groups.",name:"params"},{anchor:"timm.optim.Adan.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate. (default: 1e-3)",name:"lr"},{anchor:"timm.optim.Adan.betas",description:`<strong>betas</strong> (Tuple[float, float, flot], optional) &#x2014; coefficients used for computing
running averages of gradient and its norm. (default: (0.98, 0.92, 0.99))`,name:"betas"},{anchor:"timm.optim.Adan.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability. (default: 1e-8)`,name:"eps"},{anchor:"timm.optim.Adan.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; decoupled weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.Adan.no_prox",description:"<strong>no_prox</strong> (bool) &#x2014; how to perform the decoupled weight decay (default: False)",name:"no_prox"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adan.py#L16"}}),Je=new b({props:{name:"step",anchor:"timm.optim.Adan.step",parameters:[{name:"closure",val:" = None"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adan.py#L71"}}),Ye=new b({props:{name:"class timm.optim.Adopt",anchor:"timm.optim.Adopt",parameters:[{name:"params",val:""},{name:"lr",val:": Union = 0.001"},{name:"betas",val:": Tuple = (0.9, 0.9999)"},{name:"eps",val:": float = 1e-06"},{name:"weight_decay",val:": float = 0.0"},{name:"decoupled",val:": bool = False"},{name:"foreach",val:": Optional = None"},{name:"maximize",val:": bool = False"},{name:"capturable",val:": bool = False"},{name:"differentiable",val:": bool = False"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adopt.py#L56"}}),et=new b({props:{name:"step",anchor:"timm.optim.Adopt.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Adopt.step.closure",description:`<strong>closure</strong> (Callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adopt.py#L191"}}),tt=new b({props:{name:"class timm.optim.Lamb",anchor:"timm.optim.Lamb",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"bias_correction",val:" = True"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-06"},{name:"weight_decay",val:" = 0.01"},{name:"grad_averaging",val:" = True"},{name:"max_grad_norm",val:" = 1.0"},{name:"trust_clip",val:" = False"},{name:"always_adapt",val:" = False"}],parametersDescription:[{anchor:"timm.optim.Lamb.params",description:"<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining parameter groups.",name:"params"},{anchor:"timm.optim.Lamb.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate. (default: 1e-3)",name:"lr"},{anchor:"timm.optim.Lamb.betas",description:`<strong>betas</strong> (Tuple[float, float], optional) &#x2014; coefficients used for computing
running averages of gradient and its norm. (default: (0.9, 0.999))`,name:"betas"},{anchor:"timm.optim.Lamb.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability. (default: 1e-8)`,name:"eps"},{anchor:"timm.optim.Lamb.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.Lamb.grad_averaging",description:`<strong>grad_averaging</strong> (bool, optional) &#x2014; whether apply (1-beta2) to grad when
calculating running averages of gradient. (default: True)`,name:"grad_averaging"},{anchor:"timm.optim.Lamb.max_grad_norm",description:"<strong>max_grad_norm</strong> (float, optional) &#x2014; value used to clip global grad norm (default: 1.0)",name:"max_grad_norm"},{anchor:"timm.optim.Lamb.trust_clip",description:"<strong>trust_clip</strong> (bool) &#x2014; enable LAMBC trust ratio clipping (default: False)",name:"trust_clip"},{anchor:"timm.optim.Lamb.always_adapt",description:`<strong>always_adapt</strong> (boolean, optional) &#x2014; Apply adaptive learning rate to 0.0
weight decay parameter (default: False)`,name:"always_adapt"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/lamb.py#L60"}}),at=new b({props:{name:"step",anchor:"timm.optim.Lamb.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Lamb.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/lamb.py#L131"}}),ot=new b({props:{name:"class timm.optim.Lars",anchor:"timm.optim.Lars",parameters:[{name:"params",val:""},{name:"lr",val:" = 1.0"},{name:"momentum",val:" = 0"},{name:"dampening",val:" = 0"},{name:"weight_decay",val:" = 0"},{name:"nesterov",val:" = False"},{name:"trust_coeff",val:" = 0.001"},{name:"eps",val:" = 1e-08"},{name:"trust_clip",val:" = False"},{name:"always_adapt",val:" = False"}],parametersDescription:[{anchor:"timm.optim.Lars.params",description:"<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining parameter groups.",name:"params"},{anchor:"timm.optim.Lars.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1.0).",name:"lr"},{anchor:"timm.optim.Lars.momentum",description:"<strong>momentum</strong> (float, optional) &#x2014; momentum factor (default: 0)",name:"momentum"},{anchor:"timm.optim.Lars.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.Lars.dampening",description:"<strong>dampening</strong> (float, optional) &#x2014; dampening for momentum (default: 0)",name:"dampening"},{anchor:"timm.optim.Lars.nesterov",description:"<strong>nesterov</strong> (bool, optional) &#x2014; enables Nesterov momentum (default: False)",name:"nesterov"},{anchor:"timm.optim.Lars.trust_coeff",description:"<strong>trust_coeff</strong> (float) &#x2014; trust coefficient for computing adaptive lr / trust_ratio (default: 0.001)",name:"trust_coeff"},{anchor:"timm.optim.Lars.eps",description:"<strong>eps</strong> (float) &#x2014; eps for division denominator (default: 1e-8)",name:"eps"},{anchor:"timm.optim.Lars.trust_clip",description:"<strong>trust_clip</strong> (bool) &#x2014; enable LARC trust ratio clipping (default: False)",name:"trust_clip"},{anchor:"timm.optim.Lars.always_adapt",description:"<strong>always_adapt</strong> (bool) &#x2014; always apply LARS LR adapt, otherwise only when group weight_decay != 0 (default: False)",name:"always_adapt"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/lars.py#L17"}}),nt=new b({props:{name:"step",anchor:"timm.optim.Lars.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Lars.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model and returns the loss.",name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/lars.py#L75"}}),rt=new b({props:{name:"class timm.optim.Lion",anchor:"timm.optim.Lion",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.0001"},{name:"betas",val:" = (0.9, 0.99)"},{name:"weight_decay",val:" = 0.0"},{name:"maximize",val:" = False"},{name:"foreach",val:" = None"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/lion.py#L25"}}),it=new b({props:{name:"step",anchor:"timm.optim.Lion.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Lion.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/lion.py#L69",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the loss.</p>
`}}),st=new b({props:{name:"class timm.optim.Lookahead",anchor:"timm.optim.Lookahead",parameters:[{name:"base_optimizer",val:""},{name:"alpha",val:" = 0.5"},{name:"k",val:" = 6"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/lookahead.py#L15"}}),lt=new b({props:{name:"class timm.optim.MADGRAD",anchor:"timm.optim.MADGRAD",parameters:[{name:"params",val:": Any"},{name:"lr",val:": float = 0.01"},{name:"momentum",val:": float = 0.9"},{name:"weight_decay",val:": float = 0"},{name:"eps",val:": float = 1e-06"},{name:"decoupled_decay",val:": bool = False"}],parametersDescription:[{anchor:"timm.optim.MADGRAD.params",description:`<strong>params</strong> (iterable) &#x2014;
Iterable of parameters to optimize or dicts defining parameter groups.`,name:"params"},{anchor:"timm.optim.MADGRAD.lr",description:`<strong>lr</strong> (float) &#x2014;
Learning rate (default: 1e-2).`,name:"lr"},{anchor:"timm.optim.MADGRAD.momentum",description:`<strong>momentum</strong> (float) &#x2014;
Momentum value in  the range [0,1) (default: 0.9).`,name:"momentum"},{anchor:"timm.optim.MADGRAD.weight_decay",description:`<strong>weight_decay</strong> (float) &#x2014;
Weight decay, i.e. a L2 penalty (default: 0).`,name:"weight_decay"},{anchor:"timm.optim.MADGRAD.eps",description:`<strong>eps</strong> (float) &#x2014;
Term added to the denominator outside of the root operation to improve numerical stability. (default: 1e-6).`,name:"eps"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/madgrad.py#L24"}}),pt=new b({props:{name:"step",anchor:"timm.optim.MADGRAD.step",parameters:[{name:"closure",val:": Optional = None"}],parametersDescription:[{anchor:"timm.optim.MADGRAD.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model and returns the loss.",name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/madgrad.py#L90"}}),dt=new b({props:{name:"class timm.optim.Nadam",anchor:"timm.optim.Nadam",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.002"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0"},{name:"schedule_decay",val:" = 0.004"}],parametersDescription:[{anchor:"timm.optim.Nadam.params",description:`<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining
parameter groups`,name:"params"},{anchor:"timm.optim.Nadam.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 2e-3)",name:"lr"},{anchor:"timm.optim.Nadam.betas",description:`<strong>betas</strong> (Tuple[float, float], optional) &#x2014; coefficients used for computing
running averages of gradient and its square`,name:"betas"},{anchor:"timm.optim.Nadam.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability (default: 1e-8)`,name:"eps"},{anchor:"timm.optim.Nadam.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.Nadam.schedule_decay",description:"<strong>schedule_decay</strong> (float, optional) &#x2014; momentum schedule decay (default: 4e-3)",name:"schedule_decay"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/nadam.py#L7"}}),ct=new b({props:{name:"step",anchor:"timm.optim.Nadam.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Nadam.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/nadam.py#L50"}}),gt=new b({props:{name:"class timm.optim.NAdamW",anchor:"timm.optim.NAdamW",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0.01"},{name:"maximize",val:": bool = False"},{name:"foreach",val:": Optional = None"},{name:"capturable",val:": bool = False"}],parametersDescription:[{anchor:"timm.optim.NAdamW.params",description:`<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining
parameter groups`,name:"params"},{anchor:"timm.optim.NAdamW.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1e-3)",name:"lr"},{anchor:"timm.optim.NAdamW.betas",description:`<strong>betas</strong> (Tuple[float, float], optional) &#x2014; coefficients used for computing
running averages of gradient and its square (default: (0.9, 0.999))`,name:"betas"},{anchor:"timm.optim.NAdamW.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability (default: 1e-8)`,name:"eps"},{anchor:"timm.optim.NAdamW.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay coefficient (default: 1e-2)",name:"weight_decay"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/nadamw.py#L15"}}),ut=new b({props:{name:"step",anchor:"timm.optim.NAdamW.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.NAdamW.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/nadamw.py#L80"}}),ft=new b({props:{name:"class timm.optim.NvNovoGrad",anchor:"timm.optim.NvNovoGrad",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.95, 0.98)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0"},{name:"grad_averaging",val:" = False"},{name:"amsgrad",val:" = False"}],parametersDescription:[{anchor:"timm.optim.NvNovoGrad.params",description:`<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining
parameter groups`,name:"params"},{anchor:"timm.optim.NvNovoGrad.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1e-3)",name:"lr"},{anchor:"timm.optim.NvNovoGrad.betas",description:`<strong>betas</strong> (Tuple[float, float], optional) &#x2014; coefficients used for computing
running averages of gradient and its square (default: (0.95, 0.98))`,name:"betas"},{anchor:"timm.optim.NvNovoGrad.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability (default: 1e-8)`,name:"eps"},{anchor:"timm.optim.NvNovoGrad.weight_decay",description:`<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)
grad_averaging &#x2014; gradient averaging`,name:"weight_decay"},{anchor:"timm.optim.NvNovoGrad.amsgrad",description:`<strong>amsgrad</strong> (boolean, optional) &#x2014; whether to use the AMSGrad variant of this
algorithm from the paper <code>On the Convergence of Adam and Beyond</code>_
(default: False)`,name:"amsgrad"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/nvnovograd.py#L13"}}),ht=new b({props:{name:"step",anchor:"timm.optim.NvNovoGrad.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.NvNovoGrad.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model",name:"closure"},{anchor:"timm.optim.NvNovoGrad.step.and",description:"<strong>and</strong> returns the loss. &#x2014;",name:"and"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/nvnovograd.py#L66"}}),bt=new b({props:{name:"class timm.optim.RAdam",anchor:"timm.optim.RAdam",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/radam.py#L10"}}),_t=new b({props:{name:"class timm.optim.RMSpropTF",anchor:"timm.optim.RMSpropTF",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.01"},{name:"alpha",val:" = 0.9"},{name:"eps",val:" = 1e-10"},{name:"weight_decay",val:" = 0"},{name:"momentum",val:" = 0.0"},{name:"centered",val:" = False"},{name:"decoupled_decay",val:" = False"},{name:"lr_in_momentum",val:" = True"}],parametersDescription:[{anchor:"timm.optim.RMSpropTF.params",description:`<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining
parameter groups`,name:"params"},{anchor:"timm.optim.RMSpropTF.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1e-2)",name:"lr"},{anchor:"timm.optim.RMSpropTF.momentum",description:"<strong>momentum</strong> (float, optional) &#x2014; momentum factor (default: 0)",name:"momentum"},{anchor:"timm.optim.RMSpropTF.alpha",description:"<strong>alpha</strong> (float, optional) &#x2014; smoothing (decay) constant (default: 0.9)",name:"alpha"},{anchor:"timm.optim.RMSpropTF.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability (default: 1e-10)`,name:"eps"},{anchor:"timm.optim.RMSpropTF.centered",description:`<strong>centered</strong> (bool, optional)  &#x2014; if <code>True</code>, compute the centered RMSProp,
the gradient is normalized by an estimation of its variance`,name:"centered"},{anchor:"timm.optim.RMSpropTF.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.RMSpropTF.decoupled_decay",description:'<strong>decoupled_decay</strong> (bool, optional) &#x2014; decoupled weight decay as per <a href="https://arxiv.org/abs/1711.05101" rel="nofollow">https://arxiv.org/abs/1711.05101</a>',name:"decoupled_decay"},{anchor:"timm.optim.RMSpropTF.lr_in_momentum",description:`<strong>lr_in_momentum</strong> (bool, optional) &#x2014; learning rate scaling is included in the momentum buffer
update as per defaults in Tensorflow`,name:"lr_in_momentum"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/rmsprop_tf.py#L14"}}),xt=new b({props:{name:"step",anchor:"timm.optim.RMSpropTF.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.RMSpropTF.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/rmsprop_tf.py#L89"}}),yt=new b({props:{name:"class timm.optim.SGDP",anchor:"timm.optim.SGDP",parameters:[{name:"params",val:""},{name:"lr",val:" = <required parameter>"},{name:"momentum",val:" = 0"},{name:"dampening",val:" = 0"},{name:"weight_decay",val:" = 0"},{name:"nesterov",val:" = False"},{name:"eps",val:" = 1e-08"},{name:"delta",val:" = 0.1"},{name:"wd_ratio",val:" = 0.1"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/sgdp.py#L19"}}),wt=new b({props:{name:"class timm.optim.SGDW",anchor:"timm.optim.SGDW",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"momentum",val:" = 0"},{name:"dampening",val:" = 0"},{name:"weight_decay",val:" = 0"},{name:"nesterov",val:" = False"},{name:"maximize",val:": bool = False"},{name:"foreach",val:": Optional = None"},{name:"differentiable",val:": bool = False"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/sgdw.py#L16"}}),Ct=new b({props:{name:"step",anchor:"timm.optim.SGDW.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.SGDW.step.closure",description:`<strong>closure</strong> (Callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/sgdw.py#L79"}}),Lt=new us({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/reference/optimizers.mdx"}}),{c(){Z=a("meta"),bo=n(),oo=a("p"),_o=n(),d(ve.$$.fragment),xo=n(),be=a("p"),be.innerHTML=_i,$o=n(),d(_e.$$.fragment),yo=n(),d(xe.$$.fragment),wo=n(),_=a("div"),d($e.$$.fragment),yn=n(),At=a("p"),At.textContent=xi,wn=n(),Tt=a("p"),Tt.textContent=$i,Cn=n(),Dt=a("p"),Dt.textContent=yi,Ln=n(),no=a("blockquote"),ro=a("blockquote"),ye=a("blockquote"),d(we.$$.fragment),An=n(),zt=a("p"),zt.textContent=wi,Tn=n(),io=a("blockquote"),mo=a("blockquote"),Ce=a("blockquote"),d(Le.$$.fragment),Dn=n(),Mt=a("p"),Mt.textContent=Ci,zn=n(),so=a("blockquote"),lo=a("blockquote"),Ae=a("blockquote"),d(Te.$$.fragment),Mn=n(),Pt=a("p"),Pt.textContent=Li,Pn=n(),po=a("blockquote"),co=a("blockquote"),De=a("blockquote"),d(ze.$$.fragment),qn=n(),qt=a("p"),qt.textContent=Ai,kn=n(),kt=a("p"),kt.textContent=Ti,En=n(),Et=a("ol"),Et.innerHTML=Di,Co=n(),x=a("div"),d(Me.$$.fragment),Nn=n(),Nt=a("p"),Nt.textContent=zi,On=n(),Ot=a("p"),Ot.textContent=Mi,In=n(),It=a("p"),It.textContent=Pi,Fn=n(),Ft=a("blockquote"),Ft.innerHTML=qi,Hn=n(),Ht=a("blockquote"),Ht.innerHTML=ki,Bn=n(),Bt=a("blockquote"),Bt.innerHTML=Ei,Rn=n(),Rt=a("blockquote"),Rt.innerHTML=Ni,Lo=n(),C=a("div"),d(Pe.$$.fragment),Gn=n(),Gt=a("p"),Gt.textContent=Oi,Sn=n(),St=a("p"),St.textContent=Ii,Vn=n(),Vt=a("p"),Vt.textContent=Fi,Wn=n(),go=a("blockquote"),uo=a("blockquote"),qe=a("blockquote"),d(ke.$$.fragment),Un=n(),Wt=a("p"),Wt.textContent=Hi,Qn=n(),fo=a("blockquote"),ho=a("blockquote"),Ee=a("blockquote"),d(Ne.$$.fragment),jn=n(),Ut=a("p"),Ut.textContent=Bi,Ao=n(),d(Oe.$$.fragment),To=n(),L=a("div"),d(Ie.$$.fragment),Kn=n(),Qt=a("p"),Qt.textContent=Ri,Zn=n(),jt=a("p"),jt.textContent=Gi,Xn=n(),Kt=a("p"),Kt.innerHTML=Si,Jn=n(),Zt=a("ul"),Zt.innerHTML=Vi,Yn=n(),J=a("div"),d(Fe.$$.fragment),er=n(),Xt=a("p"),Xt.textContent=Wi,Do=n(),A=a("div"),d(He.$$.fragment),tr=n(),Jt=a("p"),Jt.textContent=Ui,ar=n(),Yt=a("p"),Yt.innerHTML=Qi,or=n(),ea=a("p"),ea.innerHTML=ji,nr=n(),ta=a("p"),ta.innerHTML=Ki,rr=n(),Y=a("div"),d(Be.$$.fragment),ir=n(),aa=a("p"),aa.textContent=Zi,zo=n(),R=a("div"),d(Re.$$.fragment),mr=n(),oa=a("p"),oa.textContent=Xi,sr=n(),na=a("p"),na.innerHTML=Ji,Mo=n(),T=a("div"),d(Ge.$$.fragment),lr=n(),ra=a("p"),ra.textContent=Yi,pr=n(),ee=a("div"),d(Se.$$.fragment),dr=n(),ia=a("p"),ia.textContent=em,cr=n(),te=a("div"),d(Ve.$$.fragment),gr=n(),ma=a("p"),ma.textContent=tm,ur=n(),ae=a("div"),d(We.$$.fragment),fr=n(),sa=a("p"),sa.textContent=am,hr=n(),oe=a("div"),d(Ue.$$.fragment),vr=n(),la=a("p"),la.textContent=om,Po=n(),Qe=a("div"),d(je.$$.fragment),qo=n(),P=a("div"),d(Ke.$$.fragment),br=n(),pa=a("p"),pa.textContent=nm,_r=n(),da=a("p"),da.innerHTML=rm,xr=n(),ca=a("p"),ca.innerHTML=im,$r=n(),ne=a("div"),d(Ze.$$.fragment),yr=n(),ga=a("p"),ga.textContent=mm,ko=n(),G=a("div"),d(Xe.$$.fragment),wr=n(),ua=a("p"),ua.innerHTML=sm,Cr=n(),re=a("div"),d(Je.$$.fragment),Lr=n(),fa=a("p"),fa.textContent=lm,Eo=n(),S=a("div"),d(Ye.$$.fragment),Ar=n(),ha=a("p"),ha.innerHTML=pm,Tr=n(),ie=a("div"),d(et.$$.fragment),Dr=n(),va=a("p"),va.textContent=dm,No=n(),q=a("div"),d(tt.$$.fragment),zr=n(),ba=a("p"),ba.innerHTML=cm,Mr=n(),_a=a("p"),_a.innerHTML=gm,Pr=n(),xa=a("p"),xa.innerHTML=um,qr=n(),me=a("div"),d(at.$$.fragment),kr=n(),$a=a("p"),$a.textContent=fm,Oo=n(),N=a("div"),d(ot.$$.fragment),Er=n(),ya=a("p"),ya.textContent=hm,Nr=n(),wa=a("p"),wa.innerHTML=vm,Or=n(),se=a("div"),d(nt.$$.fragment),Ir=n(),Ca=a("p"),Ca.textContent=bm,Io=n(),V=a("div"),d(rt.$$.fragment),Fr=n(),La=a("p"),La.textContent=_m,Hr=n(),le=a("div"),d(it.$$.fragment),Br=n(),Aa=a("p"),Aa.textContent=xm,Fo=n(),mt=a("div"),d(st.$$.fragment),Ho=n(),w=a("div"),d(lt.$$.fragment),Rr=n(),Ta=a("p"),Ta.textContent=$m,Gr=n(),Da=a("p"),Da.innerHTML=ym,Sr=n(),za=a("p"),za.textContent=wm,Vr=n(),Ma=a("p"),Ma.textContent=Cm,Wr=n(),Pa=a("p"),Pa.textContent=Lm,Ur=n(),pe=a("div"),d(pt.$$.fragment),Qr=n(),qa=a("p"),qa.textContent=Am,Bo=n(),D=a("div"),d(dt.$$.fragment),jr=n(),ka=a("p"),ka.textContent=Tm,Kr=n(),Ea=a("p"),Ea.innerHTML=Dm,Zr=n(),Na=a("p"),Na.innerHTML=zm,Xr=n(),Oa=a("p"),Oa.innerHTML=Mm,Jr=n(),de=a("div"),d(ct.$$.fragment),Yr=n(),Ia=a("p"),Ia.textContent=Pm,Ro=n(),k=a("div"),d(gt.$$.fragment),ei=n(),Fa=a("p"),Fa.textContent=qm,ti=n(),Ha=a("p"),Ha.innerHTML=km,ai=n(),Ba=a("p"),Ba.innerHTML=Em,oi=n(),ce=a("div"),d(ut.$$.fragment),ni=n(),Ra=a("p"),Ra.textContent=Nm,Go=n(),W=a("div"),d(ft.$$.fragment),ri=n(),Ga=a("p"),Ga.textContent=Om,ii=n(),ge=a("div"),d(ht.$$.fragment),mi=n(),Sa=a("p"),Sa.textContent=Im,So=n(),vt=a("div"),d(bt.$$.fragment),Vo=n(),$=a("div"),d(_t.$$.fragment),si=n(),Va=a("p"),Va.textContent=Fm,li=n(),Wa=a("p"),Wa.textContent=Hm,pi=n(),Ua=a("p"),Ua.textContent=Bm,di=n(),Qa=a("ol"),Qa.innerHTML=Rm,ci=n(),ja=a("p"),ja.innerHTML=Gm,gi=n(),Ka=a("p"),Ka.innerHTML=Sm,ui=n(),ue=a("div"),d(xt.$$.fragment),fi=n(),Za=a("p"),Za.textContent=Vm,Wo=n(),$t=a("div"),d(yt.$$.fragment),Uo=n(),X=a("div"),d(wt.$$.fragment),hi=n(),fe=a("div"),d(Ct.$$.fragment),vi=n(),Xa=a("p"),Xa.textContent=Wm,Qo=n(),d(Lt.$$.fragment),jo=n(),vo=a("p"),this.h()},l(e){const s=gs("svelte-u9bgzb",document.head);Z=o(s,"META",{name:!0,content:!0}),s.forEach(i),bo=r(e),oo=o(e,"P",{}),l(oo).forEach(i),_o=r(e),c(ve.$$.fragment,e),xo=r(e),be=o(e,"P",{"data-svelte-h":!0}),m(be)!=="svelte-1c6qm22"&&(be.innerHTML=_i),$o=r(e),c(_e.$$.fragment,e),yo=r(e),c(xe.$$.fragment,e),wo=r(e),_=o(e,"DIV",{class:!0});var y=l(_);c($e.$$.fragment,y),yn=r(y),At=o(y,"P",{"data-svelte-h":!0}),m(At)!=="svelte-1330e7"&&(At.textContent=xi),wn=r(y),Tt=o(y,"P",{"data-svelte-h":!0}),m(Tt)!=="svelte-9cjiwr"&&(Tt.textContent=$i),Cn=r(y),Dt=o(y,"P",{"data-svelte-h":!0}),m(Dt)!=="svelte-kvfsh7"&&(Dt.textContent=yi),Ln=r(y),no=o(y,"BLOCKQUOTE",{});var Um=l(no);ro=o(Um,"BLOCKQUOTE",{});var Qm=l(ro);ye=o(Qm,"BLOCKQUOTE",{});var Zo=l(ye);c(we.$$.fragment,Zo),An=r(Zo),zt=o(Zo,"P",{"data-svelte-h":!0}),m(zt)!=="svelte-180ncmf"&&(zt.textContent=wi),Zo.forEach(i),Qm.forEach(i),Um.forEach(i),Tn=r(y),io=o(y,"BLOCKQUOTE",{});var jm=l(io);mo=o(jm,"BLOCKQUOTE",{});var Km=l(mo);Ce=o(Km,"BLOCKQUOTE",{});var Xo=l(Ce);c(Le.$$.fragment,Xo),Dn=r(Xo),Mt=o(Xo,"P",{"data-svelte-h":!0}),m(Mt)!=="svelte-6yrpk7"&&(Mt.textContent=Ci),Xo.forEach(i),Km.forEach(i),jm.forEach(i),zn=r(y),so=o(y,"BLOCKQUOTE",{});var Zm=l(so);lo=o(Zm,"BLOCKQUOTE",{});var Xm=l(lo);Ae=o(Xm,"BLOCKQUOTE",{});var Jo=l(Ae);c(Te.$$.fragment,Jo),Mn=r(Jo),Pt=o(Jo,"P",{"data-svelte-h":!0}),m(Pt)!=="svelte-1vmtu70"&&(Pt.textContent=Li),Jo.forEach(i),Xm.forEach(i),Zm.forEach(i),Pn=r(y),po=o(y,"BLOCKQUOTE",{});var Jm=l(po);co=o(Jm,"BLOCKQUOTE",{});var Ym=l(co);De=o(Ym,"BLOCKQUOTE",{});var Yo=l(De);c(ze.$$.fragment,Yo),qn=r(Yo),qt=o(Yo,"P",{"data-svelte-h":!0}),m(qt)!=="svelte-15ovmpe"&&(qt.textContent=Ai),Yo.forEach(i),Ym.forEach(i),Jm.forEach(i),kn=r(y),kt=o(y,"P",{"data-svelte-h":!0}),m(kt)!=="svelte-sgpn75"&&(kt.textContent=Ti),En=r(y),Et=o(y,"OL",{"data-svelte-h":!0}),m(Et)!=="svelte-psaz57"&&(Et.innerHTML=Di),y.forEach(i),Co=r(e),x=o(e,"DIV",{class:!0});var z=l(x);c(Me.$$.fragment,z),Nn=r(z),Nt=o(z,"P",{"data-svelte-h":!0}),m(Nt)!=="svelte-1h2sspw"&&(Nt.textContent=zi),On=r(z),Ot=o(z,"P",{"data-svelte-h":!0}),m(Ot)!=="svelte-1tapwxe"&&(Ot.textContent=Mi),In=r(z),It=o(z,"P",{"data-svelte-h":!0}),m(It)!=="svelte-kvfsh7"&&(It.textContent=Pi),Fn=r(z),Ft=o(z,"BLOCKQUOTE",{"data-svelte-h":!0}),m(Ft)!=="svelte-m875zf"&&(Ft.innerHTML=qi),Hn=r(z),Ht=o(z,"BLOCKQUOTE",{"data-svelte-h":!0}),m(Ht)!=="svelte-1mioyvo"&&(Ht.innerHTML=ki),Bn=r(z),Bt=o(z,"BLOCKQUOTE",{"data-svelte-h":!0}),m(Bt)!=="svelte-ji9gfr"&&(Bt.innerHTML=Ei),Rn=r(z),Rt=o(z,"BLOCKQUOTE",{"data-svelte-h":!0}),m(Rt)!=="svelte-tvmm3x"&&(Rt.innerHTML=Ni),z.forEach(i),Lo=r(e),C=o(e,"DIV",{class:!0});var O=l(C);c(Pe.$$.fragment,O),Gn=r(O),Gt=o(O,"P",{"data-svelte-h":!0}),m(Gt)!=="svelte-1rcjgrx"&&(Gt.textContent=Oi),Sn=r(O),St=o(O,"P",{"data-svelte-h":!0}),m(St)!=="svelte-13jhmtj"&&(St.textContent=Ii),Vn=r(O),Vt=o(O,"P",{"data-svelte-h":!0}),m(Vt)!=="svelte-kvfsh7"&&(Vt.textContent=Fi),Wn=r(O),go=o(O,"BLOCKQUOTE",{});var es=l(go);uo=o(es,"BLOCKQUOTE",{});var ts=l(uo);qe=o(ts,"BLOCKQUOTE",{});var en=l(qe);c(ke.$$.fragment,en),Un=r(en),Wt=o(en,"P",{"data-svelte-h":!0}),m(Wt)!=="svelte-1en25gb"&&(Wt.textContent=Hi),en.forEach(i),ts.forEach(i),es.forEach(i),Qn=r(O),fo=o(O,"BLOCKQUOTE",{});var as=l(fo);ho=o(as,"BLOCKQUOTE",{});var os=l(ho);Ee=o(os,"BLOCKQUOTE",{});var tn=l(Ee);c(Ne.$$.fragment,tn),jn=r(tn),Ut=o(tn,"P",{"data-svelte-h":!0}),m(Ut)!=="svelte-gfx8y2"&&(Ut.textContent=Bi),tn.forEach(i),os.forEach(i),as.forEach(i),O.forEach(i),Ao=r(e),c(Oe.$$.fragment,e),To=r(e),L=o(e,"DIV",{class:!0});var I=l(L);c(Ie.$$.fragment,I),Kn=r(I),Qt=o(I,"P",{"data-svelte-h":!0}),m(Qt)!=="svelte-1hnunr4"&&(Qt.textContent=Ri),Zn=r(I),jt=o(I,"P",{"data-svelte-h":!0}),m(jt)!=="svelte-1cjb7xo"&&(jt.textContent=Gi),Xn=r(I),Kt=o(I,"P",{"data-svelte-h":!0}),m(Kt)!=="svelte-1347q2l"&&(Kt.innerHTML=Si),Jn=r(I),Zt=o(I,"UL",{"data-svelte-h":!0}),m(Zt)!=="svelte-12x3l9q"&&(Zt.innerHTML=Vi),Yn=r(I),J=o(I,"DIV",{class:!0});var an=l(J);c(Fe.$$.fragment,an),er=r(an),Xt=o(an,"P",{"data-svelte-h":!0}),m(Xt)!=="svelte-1gr03w4"&&(Xt.textContent=Wi),an.forEach(i),I.forEach(i),Do=r(e),A=o(e,"DIV",{class:!0});var F=l(A);c(He.$$.fragment,F),tr=r(F),Jt=o(F,"P",{"data-svelte-h":!0}),m(Jt)!=="svelte-1j9mkxe"&&(Jt.textContent=Ui),ar=r(F),Yt=o(F,"P",{"data-svelte-h":!0}),m(Yt)!=="svelte-1xvyiun"&&(Yt.innerHTML=Qi),or=r(F),ea=o(F,"P",{"data-svelte-h":!0}),m(ea)!=="svelte-1i7ubkr"&&(ea.innerHTML=ji),nr=r(F),ta=o(F,"P",{"data-svelte-h":!0}),m(ta)!=="svelte-96f97i"&&(ta.innerHTML=Ki),rr=r(F),Y=o(F,"DIV",{class:!0});var on=l(Y);c(Be.$$.fragment,on),ir=r(on),aa=o(on,"P",{"data-svelte-h":!0}),m(aa)!=="svelte-1gr03w4"&&(aa.textContent=Zi),on.forEach(i),F.forEach(i),zo=r(e),R=o(e,"DIV",{class:!0});var Ja=l(R);c(Re.$$.fragment,Ja),mr=r(Ja),oa=o(Ja,"P",{"data-svelte-h":!0}),m(oa)!=="svelte-19t8yzj"&&(oa.textContent=Xi),sr=r(Ja),na=o(Ja,"P",{"data-svelte-h":!0}),m(na)!=="svelte-aajaln"&&(na.innerHTML=Ji),Ja.forEach(i),Mo=r(e),T=o(e,"DIV",{class:!0});var H=l(T);c(Ge.$$.fragment,H),lr=r(H),ra=o(H,"P",{"data-svelte-h":!0}),m(ra)!=="svelte-1cuo0rh"&&(ra.textContent=Yi),pr=r(H),ee=o(H,"DIV",{class:!0});var nn=l(ee);c(Se.$$.fragment,nn),dr=r(nn),ia=o(nn,"P",{"data-svelte-h":!0}),m(ia)!=="svelte-1jz1hl7"&&(ia.textContent=em),nn.forEach(i),cr=r(H),te=o(H,"DIV",{class:!0});var rn=l(te);c(Ve.$$.fragment,rn),gr=r(rn),ma=o(rn,"P",{"data-svelte-h":!0}),m(ma)!=="svelte-1y1oyzd"&&(ma.textContent=tm),rn.forEach(i),ur=r(H),ae=o(H,"DIV",{class:!0});var mn=l(ae);c(We.$$.fragment,mn),fr=r(mn),sa=o(mn,"P",{"data-svelte-h":!0}),m(sa)!=="svelte-1gr03w4"&&(sa.textContent=am),mn.forEach(i),hr=r(H),oe=o(H,"DIV",{class:!0});var sn=l(oe);c(Ue.$$.fragment,sn),vr=r(sn),la=o(sn,"P",{"data-svelte-h":!0}),m(la)!=="svelte-4lvf5h"&&(la.textContent=om),sn.forEach(i),H.forEach(i),Po=r(e),Qe=o(e,"DIV",{class:!0});var ns=l(Qe);c(je.$$.fragment,ns),ns.forEach(i),qo=r(e),P=o(e,"DIV",{class:!0});var U=l(P);c(Ke.$$.fragment,U),br=r(U),pa=o(U,"P",{"data-svelte-h":!0}),m(pa)!=="svelte-c51pd7"&&(pa.textContent=nm),_r=r(U),da=o(U,"P",{"data-svelte-h":!0}),m(da)!=="svelte-1cgyzi6"&&(da.innerHTML=rm),xr=r(U),ca=o(U,"P",{"data-svelte-h":!0}),m(ca)!=="svelte-1pe3ewc"&&(ca.innerHTML=im),$r=r(U),ne=o(U,"DIV",{class:!0});var ln=l(ne);c(Ze.$$.fragment,ln),yr=r(ln),ga=o(ln,"P",{"data-svelte-h":!0}),m(ga)!=="svelte-1gr03w4"&&(ga.textContent=mm),ln.forEach(i),U.forEach(i),ko=r(e),G=o(e,"DIV",{class:!0});var Ya=l(G);c(Xe.$$.fragment,Ya),wr=r(Ya),ua=o(Ya,"P",{"data-svelte-h":!0}),m(ua)!=="svelte-acz7r2"&&(ua.innerHTML=sm),Cr=r(Ya),re=o(Ya,"DIV",{class:!0});var pn=l(re);c(Je.$$.fragment,pn),Lr=r(pn),fa=o(pn,"P",{"data-svelte-h":!0}),m(fa)!=="svelte-1gr03w4"&&(fa.textContent=lm),pn.forEach(i),Ya.forEach(i),Eo=r(e),S=o(e,"DIV",{class:!0});var eo=l(S);c(Ye.$$.fragment,eo),Ar=r(eo),ha=o(eo,"P",{"data-svelte-h":!0}),m(ha)!=="svelte-bxurot"&&(ha.innerHTML=pm),Tr=r(eo),ie=o(eo,"DIV",{class:!0});var dn=l(ie);c(et.$$.fragment,dn),Dr=r(dn),va=o(dn,"P",{"data-svelte-h":!0}),m(va)!=="svelte-1siu6mf"&&(va.textContent=dm),dn.forEach(i),eo.forEach(i),No=r(e),q=o(e,"DIV",{class:!0});var Q=l(q);c(tt.$$.fragment,Q),zr=r(Q),ba=o(Q,"P",{"data-svelte-h":!0}),m(ba)!=="svelte-d5zqgn"&&(ba.innerHTML=cm),Mr=r(Q),_a=o(Q,"P",{"data-svelte-h":!0}),m(_a)!=="svelte-1wamkfv"&&(_a.innerHTML=gm),Pr=r(Q),xa=o(Q,"P",{"data-svelte-h":!0}),m(xa)!=="svelte-dty621"&&(xa.innerHTML=um),qr=r(Q),me=o(Q,"DIV",{class:!0});var cn=l(me);c(at.$$.fragment,cn),kr=r(cn),$a=o(cn,"P",{"data-svelte-h":!0}),m($a)!=="svelte-1gr03w4"&&($a.textContent=fm),cn.forEach(i),Q.forEach(i),Oo=r(e),N=o(e,"DIV",{class:!0});var he=l(N);c(ot.$$.fragment,he),Er=r(he),ya=o(he,"P",{"data-svelte-h":!0}),m(ya)!=="svelte-vzcsb8"&&(ya.textContent=hm),Nr=r(he),wa=o(he,"P",{"data-svelte-h":!0}),m(wa)!=="svelte-euart9"&&(wa.innerHTML=vm),Or=r(he),se=o(he,"DIV",{class:!0});var gn=l(se);c(nt.$$.fragment,gn),Ir=r(gn),Ca=o(gn,"P",{"data-svelte-h":!0}),m(Ca)!=="svelte-1gr03w4"&&(Ca.textContent=bm),gn.forEach(i),he.forEach(i),Io=r(e),V=o(e,"DIV",{class:!0});var to=l(V);c(rt.$$.fragment,to),Fr=r(to),La=o(to,"P",{"data-svelte-h":!0}),m(La)!=="svelte-pwyp7b"&&(La.textContent=_m),Hr=r(to),le=o(to,"DIV",{class:!0});var un=l(le);c(it.$$.fragment,un),Br=r(un),Aa=o(un,"P",{"data-svelte-h":!0}),m(Aa)!=="svelte-1gr03w4"&&(Aa.textContent=xm),un.forEach(i),to.forEach(i),Fo=r(e),mt=o(e,"DIV",{class:!0});var rs=l(mt);c(st.$$.fragment,rs),rs.forEach(i),Ho=r(e),w=o(e,"DIV",{class:!0});var E=l(w);c(lt.$$.fragment,E),Rr=r(E),Ta=o(E,"P",{"data-svelte-h":!0}),m(Ta)!=="svelte-wmmdpx"&&(Ta.textContent=$m),Gr=r(E),Da=o(E,"P",{"data-svelte-h":!0}),m(Da)!=="svelte-12dyngi"&&(Da.innerHTML=ym),Sr=r(E),za=o(E,"P",{"data-svelte-h":!0}),m(za)!=="svelte-qjjdis"&&(za.textContent=wm),Vr=r(E),Ma=o(E,"P",{"data-svelte-h":!0}),m(Ma)!=="svelte-rosfou"&&(Ma.textContent=Cm),Wr=r(E),Pa=o(E,"P",{"data-svelte-h":!0}),m(Pa)!=="svelte-hlwvkn"&&(Pa.textContent=Lm),Ur=r(E),pe=o(E,"DIV",{class:!0});var fn=l(pe);c(pt.$$.fragment,fn),Qr=r(fn),qa=o(fn,"P",{"data-svelte-h":!0}),m(qa)!=="svelte-1gr03w4"&&(qa.textContent=Am),fn.forEach(i),E.forEach(i),Bo=r(e),D=o(e,"DIV",{class:!0});var B=l(D);c(dt.$$.fragment,B),jr=r(B),ka=o(B,"P",{"data-svelte-h":!0}),m(ka)!=="svelte-1ss2c23"&&(ka.textContent=Tm),Kr=r(B),Ea=o(B,"P",{"data-svelte-h":!0}),m(Ea)!=="svelte-ewqetr"&&(Ea.innerHTML=Dm),Zr=r(B),Na=o(B,"P",{"data-svelte-h":!0}),m(Na)!=="svelte-1q705lb"&&(Na.innerHTML=zm),Xr=r(B),Oa=o(B,"P",{"data-svelte-h":!0}),m(Oa)!=="svelte-14ul3re"&&(Oa.innerHTML=Mm),Jr=r(B),de=o(B,"DIV",{class:!0});var hn=l(de);c(ct.$$.fragment,hn),Yr=r(hn),Ia=o(hn,"P",{"data-svelte-h":!0}),m(Ia)!=="svelte-1gr03w4"&&(Ia.textContent=Pm),hn.forEach(i),B.forEach(i),Ro=r(e),k=o(e,"DIV",{class:!0});var j=l(k);c(gt.$$.fragment,j),ei=r(j),Fa=o(j,"P",{"data-svelte-h":!0}),m(Fa)!=="svelte-3mtxcr"&&(Fa.textContent=qm),ti=r(j),Ha=o(j,"P",{"data-svelte-h":!0}),m(Ha)!=="svelte-797qvx"&&(Ha.innerHTML=km),ai=r(j),Ba=o(j,"P",{"data-svelte-h":!0}),m(Ba)!=="svelte-1qa39gq"&&(Ba.innerHTML=Em),oi=r(j),ce=o(j,"DIV",{class:!0});var vn=l(ce);c(ut.$$.fragment,vn),ni=r(vn),Ra=o(vn,"P",{"data-svelte-h":!0}),m(Ra)!=="svelte-1gr03w4"&&(Ra.textContent=Nm),vn.forEach(i),j.forEach(i),Go=r(e),W=o(e,"DIV",{class:!0});var ao=l(W);c(ft.$$.fragment,ao),ri=r(ao),Ga=o(ao,"P",{"data-svelte-h":!0}),m(Ga)!=="svelte-5vv99d"&&(Ga.textContent=Om),ii=r(ao),ge=o(ao,"DIV",{class:!0});var bn=l(ge);c(ht.$$.fragment,bn),mi=r(bn),Sa=o(bn,"P",{"data-svelte-h":!0}),m(Sa)!=="svelte-1gr03w4"&&(Sa.textContent=Im),bn.forEach(i),ao.forEach(i),So=r(e),vt=o(e,"DIV",{class:!0});var is=l(vt);c(bt.$$.fragment,is),is.forEach(i),Vo=r(e),$=o(e,"DIV",{class:!0});var M=l($);c(_t.$$.fragment,M),si=r(M),Va=o(M,"P",{"data-svelte-h":!0}),m(Va)!=="svelte-1tqv0s5"&&(Va.textContent=Fm),li=r(M),Wa=o(M,"P",{"data-svelte-h":!0}),m(Wa)!=="svelte-g10xv4"&&(Wa.textContent=Hm),pi=r(M),Ua=o(M,"P",{"data-svelte-h":!0}),m(Ua)!=="svelte-1acg3vg"&&(Ua.textContent=Bm),di=r(M),Qa=o(M,"OL",{"data-svelte-h":!0}),m(Qa)!=="svelte-15y6o6y"&&(Qa.innerHTML=Rm),ci=r(M),ja=o(M,"P",{"data-svelte-h":!0}),m(ja)!=="svelte-1yvkj2h"&&(ja.innerHTML=Gm),gi=r(M),Ka=o(M,"P",{"data-svelte-h":!0}),m(Ka)!=="svelte-53x1ow"&&(Ka.innerHTML=Sm),ui=r(M),ue=o(M,"DIV",{class:!0});var _n=l(ue);c(xt.$$.fragment,_n),fi=r(_n),Za=o(_n,"P",{"data-svelte-h":!0}),m(Za)!=="svelte-1gr03w4"&&(Za.textContent=Vm),_n.forEach(i),M.forEach(i),Wo=r(e),$t=o(e,"DIV",{class:!0});var ms=l($t);c(yt.$$.fragment,ms),ms.forEach(i),Uo=r(e),X=o(e,"DIV",{class:!0});var xn=l(X);c(wt.$$.fragment,xn),hi=r(xn),fe=o(xn,"DIV",{class:!0});var $n=l(fe);c(Ct.$$.fragment,$n),vi=r($n),Xa=o($n,"P",{"data-svelte-h":!0}),m(Xa)!=="svelte-1gr03w4"&&(Xa.textContent=Wm),$n.forEach(i),xn.forEach(i),Qo=r(e),c(Lt.$$.fragment,e),jo=r(e),vo=o(e,"P",{}),l(vo).forEach(i),this.h()},h(){v(Z,"name","hf:doc:metadata"),v(Z,"content",hs),v(_,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(mt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(vt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v($t,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,s){t(document.head,Z),p(e,bo,s),p(e,oo,s),p(e,_o,s),g(ve,e,s),p(e,xo,s),p(e,be,s),p(e,$o,s),g(_e,e,s),p(e,yo,s),g(xe,e,s),p(e,wo,s),p(e,_,s),g($e,_,null),t(_,yn),t(_,At),t(_,wn),t(_,Tt),t(_,Cn),t(_,Dt),t(_,Ln),t(_,no),t(no,ro),t(ro,ye),g(we,ye,null),t(ye,An),t(ye,zt),t(_,Tn),t(_,io),t(io,mo),t(mo,Ce),g(Le,Ce,null),t(Ce,Dn),t(Ce,Mt),t(_,zn),t(_,so),t(so,lo),t(lo,Ae),g(Te,Ae,null),t(Ae,Mn),t(Ae,Pt),t(_,Pn),t(_,po),t(po,co),t(co,De),g(ze,De,null),t(De,qn),t(De,qt),t(_,kn),t(_,kt),t(_,En),t(_,Et),p(e,Co,s),p(e,x,s),g(Me,x,null),t(x,Nn),t(x,Nt),t(x,On),t(x,Ot),t(x,In),t(x,It),t(x,Fn),t(x,Ft),t(x,Hn),t(x,Ht),t(x,Bn),t(x,Bt),t(x,Rn),t(x,Rt),p(e,Lo,s),p(e,C,s),g(Pe,C,null),t(C,Gn),t(C,Gt),t(C,Sn),t(C,St),t(C,Vn),t(C,Vt),t(C,Wn),t(C,go),t(go,uo),t(uo,qe),g(ke,qe,null),t(qe,Un),t(qe,Wt),t(C,Qn),t(C,fo),t(fo,ho),t(ho,Ee),g(Ne,Ee,null),t(Ee,jn),t(Ee,Ut),p(e,Ao,s),g(Oe,e,s),p(e,To,s),p(e,L,s),g(Ie,L,null),t(L,Kn),t(L,Qt),t(L,Zn),t(L,jt),t(L,Xn),t(L,Kt),t(L,Jn),t(L,Zt),t(L,Yn),t(L,J),g(Fe,J,null),t(J,er),t(J,Xt),p(e,Do,s),p(e,A,s),g(He,A,null),t(A,tr),t(A,Jt),t(A,ar),t(A,Yt),t(A,or),t(A,ea),t(A,nr),t(A,ta),t(A,rr),t(A,Y),g(Be,Y,null),t(Y,ir),t(Y,aa),p(e,zo,s),p(e,R,s),g(Re,R,null),t(R,mr),t(R,oa),t(R,sr),t(R,na),p(e,Mo,s),p(e,T,s),g(Ge,T,null),t(T,lr),t(T,ra),t(T,pr),t(T,ee),g(Se,ee,null),t(ee,dr),t(ee,ia),t(T,cr),t(T,te),g(Ve,te,null),t(te,gr),t(te,ma),t(T,ur),t(T,ae),g(We,ae,null),t(ae,fr),t(ae,sa),t(T,hr),t(T,oe),g(Ue,oe,null),t(oe,vr),t(oe,la),p(e,Po,s),p(e,Qe,s),g(je,Qe,null),p(e,qo,s),p(e,P,s),g(Ke,P,null),t(P,br),t(P,pa),t(P,_r),t(P,da),t(P,xr),t(P,ca),t(P,$r),t(P,ne),g(Ze,ne,null),t(ne,yr),t(ne,ga),p(e,ko,s),p(e,G,s),g(Xe,G,null),t(G,wr),t(G,ua),t(G,Cr),t(G,re),g(Je,re,null),t(re,Lr),t(re,fa),p(e,Eo,s),p(e,S,s),g(Ye,S,null),t(S,Ar),t(S,ha),t(S,Tr),t(S,ie),g(et,ie,null),t(ie,Dr),t(ie,va),p(e,No,s),p(e,q,s),g(tt,q,null),t(q,zr),t(q,ba),t(q,Mr),t(q,_a),t(q,Pr),t(q,xa),t(q,qr),t(q,me),g(at,me,null),t(me,kr),t(me,$a),p(e,Oo,s),p(e,N,s),g(ot,N,null),t(N,Er),t(N,ya),t(N,Nr),t(N,wa),t(N,Or),t(N,se),g(nt,se,null),t(se,Ir),t(se,Ca),p(e,Io,s),p(e,V,s),g(rt,V,null),t(V,Fr),t(V,La),t(V,Hr),t(V,le),g(it,le,null),t(le,Br),t(le,Aa),p(e,Fo,s),p(e,mt,s),g(st,mt,null),p(e,Ho,s),p(e,w,s),g(lt,w,null),t(w,Rr),t(w,Ta),t(w,Gr),t(w,Da),t(w,Sr),t(w,za),t(w,Vr),t(w,Ma),t(w,Wr),t(w,Pa),t(w,Ur),t(w,pe),g(pt,pe,null),t(pe,Qr),t(pe,qa),p(e,Bo,s),p(e,D,s),g(dt,D,null),t(D,jr),t(D,ka),t(D,Kr),t(D,Ea),t(D,Zr),t(D,Na),t(D,Xr),t(D,Oa),t(D,Jr),t(D,de),g(ct,de,null),t(de,Yr),t(de,Ia),p(e,Ro,s),p(e,k,s),g(gt,k,null),t(k,ei),t(k,Fa),t(k,ti),t(k,Ha),t(k,ai),t(k,Ba),t(k,oi),t(k,ce),g(ut,ce,null),t(ce,ni),t(ce,Ra),p(e,Go,s),p(e,W,s),g(ft,W,null),t(W,ri),t(W,Ga),t(W,ii),t(W,ge),g(ht,ge,null),t(ge,mi),t(ge,Sa),p(e,So,s),p(e,vt,s),g(bt,vt,null),p(e,Vo,s),p(e,$,s),g(_t,$,null),t($,si),t($,Va),t($,li),t($,Wa),t($,pi),t($,Ua),t($,di),t($,Qa),t($,ci),t($,ja),t($,gi),t($,Ka),t($,ui),t($,ue),g(xt,ue,null),t(ue,fi),t(ue,Za),p(e,Wo,s),p(e,$t,s),g(yt,$t,null),p(e,Uo,s),p(e,X,s),g(wt,X,null),t(X,hi),t(X,fe),g(Ct,fe,null),t(fe,vi),t(fe,Xa),p(e,Qo,s),g(Lt,e,s),p(e,jo,s),p(e,vo,s),Ko=!0},p:ls,i(e){Ko||(u(ve.$$.fragment,e),u(_e.$$.fragment,e),u(xe.$$.fragment,e),u($e.$$.fragment,e),u(we.$$.fragment,e),u(Le.$$.fragment,e),u(Te.$$.fragment,e),u(ze.$$.fragment,e),u(Me.$$.fragment,e),u(Pe.$$.fragment,e),u(ke.$$.fragment,e),u(Ne.$$.fragment,e),u(Oe.$$.fragment,e),u(Ie.$$.fragment,e),u(Fe.$$.fragment,e),u(He.$$.fragment,e),u(Be.$$.fragment,e),u(Re.$$.fragment,e),u(Ge.$$.fragment,e),u(Se.$$.fragment,e),u(Ve.$$.fragment,e),u(We.$$.fragment,e),u(Ue.$$.fragment,e),u(je.$$.fragment,e),u(Ke.$$.fragment,e),u(Ze.$$.fragment,e),u(Xe.$$.fragment,e),u(Je.$$.fragment,e),u(Ye.$$.fragment,e),u(et.$$.fragment,e),u(tt.$$.fragment,e),u(at.$$.fragment,e),u(ot.$$.fragment,e),u(nt.$$.fragment,e),u(rt.$$.fragment,e),u(it.$$.fragment,e),u(st.$$.fragment,e),u(lt.$$.fragment,e),u(pt.$$.fragment,e),u(dt.$$.fragment,e),u(ct.$$.fragment,e),u(gt.$$.fragment,e),u(ut.$$.fragment,e),u(ft.$$.fragment,e),u(ht.$$.fragment,e),u(bt.$$.fragment,e),u(_t.$$.fragment,e),u(xt.$$.fragment,e),u(yt.$$.fragment,e),u(wt.$$.fragment,e),u(Ct.$$.fragment,e),u(Lt.$$.fragment,e),Ko=!0)},o(e){f(ve.$$.fragment,e),f(_e.$$.fragment,e),f(xe.$$.fragment,e),f($e.$$.fragment,e),f(we.$$.fragment,e),f(Le.$$.fragment,e),f(Te.$$.fragment,e),f(ze.$$.fragment,e),f(Me.$$.fragment,e),f(Pe.$$.fragment,e),f(ke.$$.fragment,e),f(Ne.$$.fragment,e),f(Oe.$$.fragment,e),f(Ie.$$.fragment,e),f(Fe.$$.fragment,e),f(He.$$.fragment,e),f(Be.$$.fragment,e),f(Re.$$.fragment,e),f(Ge.$$.fragment,e),f(Se.$$.fragment,e),f(Ve.$$.fragment,e),f(We.$$.fragment,e),f(Ue.$$.fragment,e),f(je.$$.fragment,e),f(Ke.$$.fragment,e),f(Ze.$$.fragment,e),f(Xe.$$.fragment,e),f(Je.$$.fragment,e),f(Ye.$$.fragment,e),f(et.$$.fragment,e),f(tt.$$.fragment,e),f(at.$$.fragment,e),f(ot.$$.fragment,e),f(nt.$$.fragment,e),f(rt.$$.fragment,e),f(it.$$.fragment,e),f(st.$$.fragment,e),f(lt.$$.fragment,e),f(pt.$$.fragment,e),f(dt.$$.fragment,e),f(ct.$$.fragment,e),f(gt.$$.fragment,e),f(ut.$$.fragment,e),f(ft.$$.fragment,e),f(ht.$$.fragment,e),f(bt.$$.fragment,e),f(_t.$$.fragment,e),f(xt.$$.fragment,e),f(yt.$$.fragment,e),f(wt.$$.fragment,e),f(Ct.$$.fragment,e),f(Lt.$$.fragment,e),Ko=!1},d(e){e&&(i(bo),i(oo),i(_o),i(xo),i(be),i($o),i(yo),i(wo),i(_),i(Co),i(x),i(Lo),i(C),i(Ao),i(To),i(L),i(Do),i(A),i(zo),i(R),i(Mo),i(T),i(Po),i(Qe),i(qo),i(P),i(ko),i(G),i(Eo),i(S),i(No),i(q),i(Oo),i(N),i(Io),i(V),i(Fo),i(mt),i(Ho),i(w),i(Bo),i(D),i(Ro),i(k),i(Go),i(W),i(So),i(vt),i(Vo),i($),i(Wo),i($t),i(Uo),i(X),i(Qo),i(jo),i(vo)),i(Z),h(ve,e),h(_e,e),h(xe,e),h($e),h(we),h(Le),h(Te),h(ze),h(Me),h(Pe),h(ke),h(Ne),h(Oe,e),h(Ie),h(Fe),h(He),h(Be),h(Re),h(Ge),h(Se),h(Ve),h(We),h(Ue),h(je),h(Ke),h(Ze),h(Xe),h(Je),h(Ye),h(et),h(tt),h(at),h(ot),h(nt),h(rt),h(it),h(st),h(lt),h(pt),h(dt),h(ct),h(gt),h(ut),h(ft),h(ht),h(bt),h(_t),h(xt),h(yt),h(wt),h(Ct),h(Lt,e)}}}const hs='{"title":"Optimization","local":"optimization","sections":[{"title":"Optimizers","local":"optimizers","sections":[{"title":"Factory functions","local":"timm.optim.create_optimizer_v2","sections":[],"depth":3}],"depth":2}],"depth":1}';function vs(bi){return ps(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ys extends ds{constructor(Z){super(),cs(this,Z,vs,fs,ss,{})}}export{ys as component};
