import{s as ct,n as ut,o as ht}from"../chunks/scheduler.9039eef2.js";import{S as wt,i as bt,g as s,s as i,r as p,A as Mt,h as o,f as l,c as n,j as dt,u as r,x as m,k as ft,l as yt,y as gt,a,v as d,d as f,t as c,w as u}from"../chunks/index.ded8f90d.js";import{C as h}from"../chunks/CodeBlock.8580f3e8.js";import{H as b}from"../chunks/Heading.f027f30d.js";function $t(Xe){let w,ie,le,ne,y,se,g,Qe=`The notebooks and scripts in this examples show how to use Low Rank Adaptation (LoRA) to fine-tune models in a memory efficient manner. Most of PEFT methods supported in peft library but note that some PEFT methods such as Prompt tuning are not supported.
For more information on LoRA, see the <a href="https://arxiv.org/abs/2106.09685" rel="nofollow">original paper</a>.`,oe,$,Se='Here’s an overview of the <code>peft</code>-enabled notebooks and scripts in the <a href="https://github.com/huggingface/trl/tree/main/examples" rel="nofollow">trl repository</a>:',pe,T,Ye='<thead><tr><th>File</th> <th>Task</th> <th>Description</th></tr></thead> <tbody><tr><td><a href="https://github.com/huggingface/trl/blob/main/examples/research_projects/stack_llama/scripts/rl_training.py" rel="nofollow"><code>stack_llama/rl_training.py</code></a></td> <td>RLHF</td> <td>Distributed fine-tuning of the 7b parameter LLaMA models with a learned reward model and <code>peft</code>.</td></tr> <tr><td><a href="https://github.com/huggingface/trl/blob/main/examples/research_projects/stack_llama/scripts/reward_modeling.py" rel="nofollow"><code>stack_llama/reward_modeling.py</code></a></td> <td>Reward Modeling</td> <td>Distributed training of the 7b parameter LLaMA reward model with <code>peft</code>.</td></tr> <tr><td><a href="https://github.com/huggingface/trl/blob/main/examples/research_projects/stack_llama/scripts/supervised_finetuning.py" rel="nofollow"><code>stack_llama/supervised_finetuning.py</code></a></td> <td>SFT</td> <td>Distributed instruction/supervised fine-tuning of the 7b parameter LLaMA model with <code>peft</code>.</td></tr></tbody>',re,_,me,Z,ze=`Note: peft is in active development, so we install directly from their Github page.
Peft also relies on the latest version of transformers.`,de,U,fe,J,De='Note: if you don’t want to log with <code>wandb</code> remove <code>log_with=&quot;wandb&quot;</code> in the scripts/notebooks. You can also replace it with your favourite experiment tracker that’s <a href="https://huggingface.co/docs/accelerate/usage_guides/tracking" rel="nofollow">supported by <code>accelerate</code></a>.',ce,v,ue,C,qe="Simply declare a <code>PeftConfig</code> object in your script and pass it through <code>.from_pretrained</code> to load the TRL+PEFT model.",he,j,we,x,Ke="And if you want to load your model in 8bit precision:",be,L,Me,H,Oe="… or in 4bit precision:",ye,k,ge,G,$e,W,et="The <code>trl</code> library is powered by <code>accelerate</code>. As such it is best to configure and launch trainings with the following commands:",Te,B,_e,F,Ze,R,tt="You can scale up to as many GPUs as you want, as long as you are able to fit the training process in a single device. The only tweak you need to apply is to load the model as follows:",Ue,I,Je,N,lt="And if you want to load your model in 8bit precision:",ve,A,Ce,P,at="… or in 4bit precision:",je,V,xe,E,it="Finally, make sure that the rewards are computed on correct device as well, for that you can use <code>ppo_trainer.model.current_device</code>.",Le,X,He,Q,nt=`The <code>trl</code> library also supports naive pipeline parallelism (NPP) for large models (&gt;60B models). This is a simple way to parallelize the model across multiple GPUs.
This paradigm, termed as “Naive Pipeline Parallelism” (NPP) is a simple way to parallelize the model across multiple GPUs. We load the model and the adapters across multiple GPUs and the activations and gradients will be naively communicated across the GPUs. This supports <code>int8</code> models as well as other <code>dtype</code> models.`,ke,M,st='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/trl-npp.png"/>',Ge,S,We,Y,ot='Simply load your model with a custom <code>device_map</code> argument on the <code>from_pretrained</code> to split your model across multiple devices. Check out this <a href="https://github.com/huggingface/blog/blob/main/accelerate-large-models.md" rel="nofollow">nice tutorial</a> on how to properly create a <code>device_map</code> for your model.',Be,z,pt="Also make sure to have the <code>lm_head</code> module on the first GPU device as it may throw an error if it is not on the first device. As this time of writing, you need to install the <code>main</code> branch of <code>accelerate</code>: <code>pip install git+https://github.com/huggingface/accelerate.git@main</code> and <code>peft</code>: <code>pip install git+https://github.com/huggingface/peft.git@main</code>.",Fe,D,Re,q,rt="Although <code>trl</code> library is powered by <code>accelerate</code>, you should run your training script in a single process. Note that we do not support Data Parallelism together with NPP yet.",Ie,K,Ne,O,Ae,ee,mt="You can easily fine-tune Llama2 model using <code>SFTTrainer</code> and the official script! For example to fine-tune llama2-7b on the Guanaco dataset, run (tested on a single NVIDIA T4-16GB):",Pe,te,Ve,ae,Ee;return y=new b({props:{title:"Examples of using peft with trl to finetune 8-bit models with Low Rank Adaption (LoRA)",local:"examples-of-using-peft-with-trl-to-finetune-8-bit-models-with-low-rank-adaption-lora",headingTag:"h1"}}),_=new b({props:{title:"Installation",local:"installation",headingTag:"h2"}}),U=new h({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRybCU1QnBlZnQlNUQlMEFwaXAlMjBpbnN0YWxsJTIwYml0c2FuZGJ5dGVzJTIwbG9yYWxpYiUwQXBpcCUyMGluc3RhbGwlMjBnaXQlMkJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRnRyYW5zZm9ybWVycy5naXQlNDBtYWluJTBBJTIzb3B0aW9uYWwlM0ElMjB3YW5kYiUwQXBpcCUyMGluc3RhbGwlMjB3YW5kYg==",highlighted:`pip install trl[peft]
pip install bitsandbytes loralib
pip install git+https://github.com/huggingface/transformers.git@main
<span class="hljs-comment">#optional: wandb</span>
pip install wandb`,wrap:!1}}),v=new b({props:{title:"How to use it?",local:"how-to-use-it",headingTag:"h2"}}),j=new h({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNV2l0aFZhbHVlSGVhZCUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyZWRiZWVjaGluZyUyRmdwdC1uZW8tMTI1TS1pbWRiJTIyJTBBbG9yYV9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0QzMiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfZHJvcG91dCUzRDAuMDUlMkMlMEElMjAlMjAlMjAlMjBiaWFzJTNEJTIybm9uZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRhc2tfdHlwZSUzRCUyMkNBVVNBTF9MTSUyMiUyQyUwQSklMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNV2l0aFZhbHVlSGVhZC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMjAlMEElMjAlMjAlMjAlMjBwZWZ0X2NvbmZpZyUzRGxvcmFfY29uZmlnJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> AutoModelForCausalLMWithValueHead

model_id = <span class="hljs-string">&quot;edbeeching/gpt-neo-125M-imdb&quot;</span>
lora_config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

model = AutoModelForCausalLMWithValueHead.from_pretrained(
    model_id, 
    peft_config=lora_config,
)`,wrap:!1}}),L=new h({props:{code:"cHJldHJhaW5lZF9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNV2l0aFZhbHVlSGVhZC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwY29uZmlnLm1vZGVsX25hbWUlMkMlMjAlMEElMjAlMjAlMjAlMjBsb2FkX2luXzhiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcGVmdF9jb25maWclM0Rsb3JhX2NvbmZpZyUyQyUwQSk=",highlighted:`pretrained_model = AutoModelForCausalLMWithValueHead.from_pretrained(
    config.model_name, 
    load_in_8bit=<span class="hljs-literal">True</span>,
    peft_config=lora_config,
)`,wrap:!1}}),k=new h({props:{code:"cHJldHJhaW5lZF9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNV2l0aFZhbHVlSGVhZC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwY29uZmlnLm1vZGVsX25hbWUlMkMlMjAlMEElMjAlMjAlMjAlMjBwZWZ0X2NvbmZpZyUzRGxvcmFfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUwQSk=",highlighted:`pretrained_model = AutoModelForCausalLMWithValueHead.from_pretrained(
    config.model_name, 
    peft_config=lora_config,
    load_in_4bit=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),G=new b({props:{title:"Launch scripts",local:"launch-scripts",headingTag:"h2"}}),B=new h({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZyUyMCUyMyUyMHdpbGwlMjBwcm9tcHQlMjB5b3UlMjB0byUyMGRlZmluZSUyMHRoZSUyMHRyYWluaW5nJTIwY29uZmlndXJhdGlvbiUwQWFjY2VsZXJhdGUlMjBsYXVuY2glMjBleGFtcGxlcyUyRnNjcmlwdHMlMkZwcG8ucHklMjAtLXVzZV9wZWZ0JTIwJTIzJTIwbGF1bmNoJTYwZXMlMjB0cmFpbmluZw==",highlighted:'accelerate config <span class="hljs-comment"># will prompt you to define the training configuration</span>\naccelerate launch examples/scripts/ppo.py --use_peft <span class="hljs-comment"># launch`es training</span>',wrap:!1}}),F=new b({props:{title:"Using trl + peft and Data Parallelism",local:"using-trl--peft-and-data-parallelism",headingTag:"h2"}}),I=new h({props:{code:"JTBB",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig
...

lora_config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

pretrained_model = AutoModelForCausalLMWithValueHead.from_pretrained(
    config.model_name, 
    peft_config=lora_config,
)`,wrap:!1}}),A=new h({props:{code:"cHJldHJhaW5lZF9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNV2l0aFZhbHVlSGVhZC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwY29uZmlnLm1vZGVsX25hbWUlMkMlMjAlMEElMjAlMjAlMjAlMjBwZWZ0X2NvbmZpZyUzRGxvcmFfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl84Yml0JTNEVHJ1ZSUyQyUwQSk=",highlighted:`pretrained_model = AutoModelForCausalLMWithValueHead.from_pretrained(
    config.model_name, 
    peft_config=lora_config,
    load_in_8bit=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),V=new h({props:{code:"cHJldHJhaW5lZF9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNV2l0aFZhbHVlSGVhZC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwY29uZmlnLm1vZGVsX25hbWUlMkMlMjAlMEElMjAlMjAlMjAlMjBwZWZ0X2NvbmZpZyUzRGxvcmFfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUwQSk=",highlighted:`pretrained_model = AutoModelForCausalLMWithValueHead.from_pretrained(
    config.model_name, 
    peft_config=lora_config,
    load_in_4bit=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),X=new b({props:{title:"Naive pipeline parallelism (NPP) for large models (>60B models)",local:"naive-pipeline-parallelism-npp-for-large-models-60b-models",headingTag:"h2"}}),S=new b({props:{title:"How to use NPP?",local:"how-to-use-npp",headingTag:"h3"}}),D=new b({props:{title:"Launch scripts",local:"launch-scripts",headingTag:"h3"}}),K=new h({props:{code:"cHl0aG9uJTIwUEFUSF9UT19TQ1JJUFQ=",highlighted:"python PATH_TO_SCRIPT",wrap:!1}}),O=new b({props:{title:"Fine-tuning Llama-2 model",local:"fine-tuning-llama-2-model",headingTag:"h2"}}),te=new h({props:{code:"cHl0aG9uJTIwZXhhbXBsZXMlMkZzY3JpcHRzJTJGc2Z0LnB5JTIwLS1vdXRwdXRfZGlyJTIwc2Z0X29wZW5hc3Npc3RhbnQtZ3VhbmFjbyUyMCUyMC0tbW9kZWxfbmFtZSUyMG1ldGEtbGxhbWElMkZMbGFtYS0yLTdiLWhmJTIwLS1kYXRhc2V0X25hbWUlMjB0aW1kZXR0bWVycyUyRm9wZW5hc3Npc3RhbnQtZ3VhbmFjbyUyMC0tbG9hZF9pbl80Yml0JTIwLS11c2VfcGVmdCUyMC0tcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTIwNCUyMC0tZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTIwMg==",highlighted:"python examples/scripts/sft.py --output_dir sft_openassistant-guanaco  --model_name meta-llama/Llama-2-7b-hf --dataset_name timdettmers/openassistant-guanaco --load_in_4bit --use_peft --per_device_train_batch_size 4 --gradient_accumulation_steps 2",wrap:!1}}),{c(){w=s("meta"),ie=i(),le=s("p"),ne=i(),p(y.$$.fragment),se=i(),g=s("p"),g.innerHTML=Qe,oe=i(),$=s("p"),$.innerHTML=Se,pe=i(),T=s("table"),T.innerHTML=Ye,re=i(),p(_.$$.fragment),me=i(),Z=s("p"),Z.textContent=ze,de=i(),p(U.$$.fragment),fe=i(),J=s("p"),J.innerHTML=De,ce=i(),p(v.$$.fragment),ue=i(),C=s("p"),C.innerHTML=qe,he=i(),p(j.$$.fragment),we=i(),x=s("p"),x.textContent=Ke,be=i(),p(L.$$.fragment),Me=i(),H=s("p"),H.textContent=Oe,ye=i(),p(k.$$.fragment),ge=i(),p(G.$$.fragment),$e=i(),W=s("p"),W.innerHTML=et,Te=i(),p(B.$$.fragment),_e=i(),p(F.$$.fragment),Ze=i(),R=s("p"),R.textContent=tt,Ue=i(),p(I.$$.fragment),Je=i(),N=s("p"),N.textContent=lt,ve=i(),p(A.$$.fragment),Ce=i(),P=s("p"),P.textContent=at,je=i(),p(V.$$.fragment),xe=i(),E=s("p"),E.innerHTML=it,Le=i(),p(X.$$.fragment),He=i(),Q=s("p"),Q.innerHTML=nt,ke=i(),M=s("div"),M.innerHTML=st,Ge=i(),p(S.$$.fragment),We=i(),Y=s("p"),Y.innerHTML=ot,Be=i(),z=s("p"),z.innerHTML=pt,Fe=i(),p(D.$$.fragment),Re=i(),q=s("p"),q.innerHTML=rt,Ie=i(),p(K.$$.fragment),Ne=i(),p(O.$$.fragment),Ae=i(),ee=s("p"),ee.innerHTML=mt,Pe=i(),p(te.$$.fragment),Ve=i(),ae=s("p"),this.h()},l(e){const t=Mt("svelte-u9bgzb",document.head);w=o(t,"META",{name:!0,content:!0}),t.forEach(l),ie=n(e),le=o(e,"P",{}),dt(le).forEach(l),ne=n(e),r(y.$$.fragment,e),se=n(e),g=o(e,"P",{"data-svelte-h":!0}),m(g)!=="svelte-1z0xkop"&&(g.innerHTML=Qe),oe=n(e),$=o(e,"P",{"data-svelte-h":!0}),m($)!=="svelte-1mehpt8"&&($.innerHTML=Se),pe=n(e),T=o(e,"TABLE",{"data-svelte-h":!0}),m(T)!=="svelte-5tx68h"&&(T.innerHTML=Ye),re=n(e),r(_.$$.fragment,e),me=n(e),Z=o(e,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-1xrpojm"&&(Z.textContent=ze),de=n(e),r(U.$$.fragment,e),fe=n(e),J=o(e,"P",{"data-svelte-h":!0}),m(J)!=="svelte-vkwr34"&&(J.innerHTML=De),ce=n(e),r(v.$$.fragment,e),ue=n(e),C=o(e,"P",{"data-svelte-h":!0}),m(C)!=="svelte-hndmna"&&(C.innerHTML=qe),he=n(e),r(j.$$.fragment,e),we=n(e),x=o(e,"P",{"data-svelte-h":!0}),m(x)!=="svelte-lllysa"&&(x.textContent=Ke),be=n(e),r(L.$$.fragment,e),Me=n(e),H=o(e,"P",{"data-svelte-h":!0}),m(H)!=="svelte-fsazu1"&&(H.textContent=Oe),ye=n(e),r(k.$$.fragment,e),ge=n(e),r(G.$$.fragment,e),$e=n(e),W=o(e,"P",{"data-svelte-h":!0}),m(W)!=="svelte-1dq9zm0"&&(W.innerHTML=et),Te=n(e),r(B.$$.fragment,e),_e=n(e),r(F.$$.fragment,e),Ze=n(e),R=o(e,"P",{"data-svelte-h":!0}),m(R)!=="svelte-5gjozh"&&(R.textContent=tt),Ue=n(e),r(I.$$.fragment,e),Je=n(e),N=o(e,"P",{"data-svelte-h":!0}),m(N)!=="svelte-lllysa"&&(N.textContent=lt),ve=n(e),r(A.$$.fragment,e),Ce=n(e),P=o(e,"P",{"data-svelte-h":!0}),m(P)!=="svelte-fsazu1"&&(P.textContent=at),je=n(e),r(V.$$.fragment,e),xe=n(e),E=o(e,"P",{"data-svelte-h":!0}),m(E)!=="svelte-bxfofv"&&(E.innerHTML=it),Le=n(e),r(X.$$.fragment,e),He=n(e),Q=o(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-1wvtyh7"&&(Q.innerHTML=nt),ke=n(e),M=o(e,"DIV",{style:!0,"data-svelte-h":!0}),m(M)!=="svelte-axlm0o"&&(M.innerHTML=st),Ge=n(e),r(S.$$.fragment,e),We=n(e),Y=o(e,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-baerbw"&&(Y.innerHTML=ot),Be=n(e),z=o(e,"P",{"data-svelte-h":!0}),m(z)!=="svelte-pr8lox"&&(z.innerHTML=pt),Fe=n(e),r(D.$$.fragment,e),Re=n(e),q=o(e,"P",{"data-svelte-h":!0}),m(q)!=="svelte-qlesp3"&&(q.innerHTML=rt),Ie=n(e),r(K.$$.fragment,e),Ne=n(e),r(O.$$.fragment,e),Ae=n(e),ee=o(e,"P",{"data-svelte-h":!0}),m(ee)!=="svelte-98ab3u"&&(ee.innerHTML=mt),Pe=n(e),r(te.$$.fragment,e),Ve=n(e),ae=o(e,"P",{}),dt(ae).forEach(l),this.h()},h(){ft(w,"name","hf:doc:metadata"),ft(w,"content",Tt),yt(M,"text-align","center")},m(e,t){gt(document.head,w),a(e,ie,t),a(e,le,t),a(e,ne,t),d(y,e,t),a(e,se,t),a(e,g,t),a(e,oe,t),a(e,$,t),a(e,pe,t),a(e,T,t),a(e,re,t),d(_,e,t),a(e,me,t),a(e,Z,t),a(e,de,t),d(U,e,t),a(e,fe,t),a(e,J,t),a(e,ce,t),d(v,e,t),a(e,ue,t),a(e,C,t),a(e,he,t),d(j,e,t),a(e,we,t),a(e,x,t),a(e,be,t),d(L,e,t),a(e,Me,t),a(e,H,t),a(e,ye,t),d(k,e,t),a(e,ge,t),d(G,e,t),a(e,$e,t),a(e,W,t),a(e,Te,t),d(B,e,t),a(e,_e,t),d(F,e,t),a(e,Ze,t),a(e,R,t),a(e,Ue,t),d(I,e,t),a(e,Je,t),a(e,N,t),a(e,ve,t),d(A,e,t),a(e,Ce,t),a(e,P,t),a(e,je,t),d(V,e,t),a(e,xe,t),a(e,E,t),a(e,Le,t),d(X,e,t),a(e,He,t),a(e,Q,t),a(e,ke,t),a(e,M,t),a(e,Ge,t),d(S,e,t),a(e,We,t),a(e,Y,t),a(e,Be,t),a(e,z,t),a(e,Fe,t),d(D,e,t),a(e,Re,t),a(e,q,t),a(e,Ie,t),d(K,e,t),a(e,Ne,t),d(O,e,t),a(e,Ae,t),a(e,ee,t),a(e,Pe,t),d(te,e,t),a(e,Ve,t),a(e,ae,t),Ee=!0},p:ut,i(e){Ee||(f(y.$$.fragment,e),f(_.$$.fragment,e),f(U.$$.fragment,e),f(v.$$.fragment,e),f(j.$$.fragment,e),f(L.$$.fragment,e),f(k.$$.fragment,e),f(G.$$.fragment,e),f(B.$$.fragment,e),f(F.$$.fragment,e),f(I.$$.fragment,e),f(A.$$.fragment,e),f(V.$$.fragment,e),f(X.$$.fragment,e),f(S.$$.fragment,e),f(D.$$.fragment,e),f(K.$$.fragment,e),f(O.$$.fragment,e),f(te.$$.fragment,e),Ee=!0)},o(e){c(y.$$.fragment,e),c(_.$$.fragment,e),c(U.$$.fragment,e),c(v.$$.fragment,e),c(j.$$.fragment,e),c(L.$$.fragment,e),c(k.$$.fragment,e),c(G.$$.fragment,e),c(B.$$.fragment,e),c(F.$$.fragment,e),c(I.$$.fragment,e),c(A.$$.fragment,e),c(V.$$.fragment,e),c(X.$$.fragment,e),c(S.$$.fragment,e),c(D.$$.fragment,e),c(K.$$.fragment,e),c(O.$$.fragment,e),c(te.$$.fragment,e),Ee=!1},d(e){e&&(l(ie),l(le),l(ne),l(se),l(g),l(oe),l($),l(pe),l(T),l(re),l(me),l(Z),l(de),l(fe),l(J),l(ce),l(ue),l(C),l(he),l(we),l(x),l(be),l(Me),l(H),l(ye),l(ge),l($e),l(W),l(Te),l(_e),l(Ze),l(R),l(Ue),l(Je),l(N),l(ve),l(Ce),l(P),l(je),l(xe),l(E),l(Le),l(He),l(Q),l(ke),l(M),l(Ge),l(We),l(Y),l(Be),l(z),l(Fe),l(Re),l(q),l(Ie),l(Ne),l(Ae),l(ee),l(Pe),l(Ve),l(ae)),l(w),u(y,e),u(_,e),u(U,e),u(v,e),u(j,e),u(L,e),u(k,e),u(G,e),u(B,e),u(F,e),u(I,e),u(A,e),u(V,e),u(X,e),u(S,e),u(D,e),u(K,e),u(O,e),u(te,e)}}}const Tt='{"title":"Examples of using peft with trl to finetune 8-bit models with Low Rank Adaption (LoRA)","local":"examples-of-using-peft-with-trl-to-finetune-8-bit-models-with-low-rank-adaption-lora","sections":[{"title":"Installation","local":"installation","sections":[],"depth":2},{"title":"How to use it?","local":"how-to-use-it","sections":[],"depth":2},{"title":"Launch scripts","local":"launch-scripts","sections":[],"depth":2},{"title":"Using trl + peft and Data Parallelism","local":"using-trl--peft-and-data-parallelism","sections":[],"depth":2},{"title":"Naive pipeline parallelism (NPP) for large models (>60B models)","local":"naive-pipeline-parallelism-npp-for-large-models-60b-models","sections":[{"title":"How to use NPP?","local":"how-to-use-npp","sections":[],"depth":3},{"title":"Launch scripts","local":"launch-scripts","sections":[],"depth":3}],"depth":2},{"title":"Fine-tuning Llama-2 model","local":"fine-tuning-llama-2-model","sections":[],"depth":2}],"depth":1}';function _t(Xe){return ht(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ct extends wt{constructor(w){super(),bt(this,w,_t,$t,ct,{})}}export{Ct as component};
