import{s as il,o as rl,n as nl}from"../chunks/scheduler.9039eef2.js";import{S as ol,i as pl,g as i,s as a,r as c,A as cl,h as r,f as l,c as n,j as Ie,u as h,x as o,k as sl,y,a as s,v as M,d as w,t as m,w as d}from"../chunks/index.ded8f90d.js";import{T as al}from"../chunks/Tip.b8d86162.js";import{C as j}from"../chunks/CodeBlock.8580f3e8.js";import{H as I}from"../chunks/Heading.f027f30d.js";function hl(Te){let p,b='Note that the scripts above rely heavily on the <code>TextEnvironment</code> API which is still under active development. The API may change in the future. Please see <a href="text_environment"><code>TextEnvironment</code></a> for the related docs.';return{c(){p=i("p"),p.innerHTML=b},l(u){p=r(u,"P",{"data-svelte-h":!0}),o(p)!=="svelte-95mlun"&&(p.innerHTML=b)},m(u,f){s(u,p,f)},p:nl,d(u){u&&l(p)}}}function Ml(Te){let p,b="<strong>Note that many settings are different so the results are not directly comparable.</strong>";return{c(){p=i("p"),p.innerHTML=b},l(u){p=r(u,"P",{"data-svelte-h":!0}),o(p)!=="svelte-1quoiyn"&&(p.innerHTML=b)},m(u,f){s(u,p,f)},p:nl,d(u){u&&l(p)}}}function wl(Te){let p,b,u,f,B,ve,v,Bt='Using Large Language Models (LLMs) with tools has been a popular topic recently with awesome works such as <a href="https://arxiv.org/abs/2302.04761" rel="nofollow">ToolFormer</a> and <a href="https://arxiv.org/pdf/2305.16504.pdf" rel="nofollow">ToolBench</a>. In TRL, we provide a simple example of how to teach LLM to use tools with reinforcement learning.',We,W,vt='Here’s an overview of the scripts in the <a href="https://github.com/lvwerra/trl/tree/main/examples/research_projects/tools" rel="nofollow">trl repository</a>:',Ge,G,Wt='<thead><tr><th>File</th> <th>Description</th></tr></thead> <tbody><tr><td><a href="https://github.com/lvwerra/trl/blob/main/examples/research_projects/tools/calculator.py" rel="nofollow"><code>calculator.py</code></a></td> <td>Script to train LLM to use a calculator with reinforcement learning.</td></tr> <tr><td><a href="https://github.com/lvwerra/trl/blob/main/examples/research_projects/tools/triviaqa.py" rel="nofollow"><code>triviaqa.py</code></a></td> <td>Script to train LLM to use a wiki tool to answer questions.</td></tr> <tr><td><a href="https://github.com/lvwerra/trl/blob/main/examples/research_projects/tools/python_interpreter.py" rel="nofollow"><code>python_interpreter.py</code></a></td> <td>Script to train LLM to use python interpreter to solve math puzzles.</td></tr></tbody>',ke,U,Ce,k,Ze,C,Gt="The rough idea is as follows:",xe,T,Z,Je,kt='Load a tool such as <a href="https://huggingface.co/spaces/ybelkada/simple-calculator" rel="nofollow">ybelkada/simple-calculator</a> that parse a text calculation like <code>&quot;14 + 34&quot;</code> and return the calulated number:',Tt,x,Jt,be,Ct="<p>Define a reward function that returns a positive reward if the tool returns the correct answer. In the script we create a dummy reward function like <code>reward_fn = lambda x: 1</code>, but we override the rewards directly later.</p>",bt,N,je,Zt="Create a prompt on how to use the tools",jt,Y,ft,X,fe,xt="Create a <code>trl.TextEnvironment</code> with the model",Ut,$,gt,Ue,Nt=`<p>Then generate some data such as <code>tasks = [&quot;\\n\\nWhat is 13.1-3?&quot;, &quot;\\n\\nWhat is 4*3?&quot;]</code> and run the environment with <code>queries, responses, masks, rewards, histories = env.run(tasks)</code>. The environment will look for the <code>&lt;call&gt;</code> token in the prompt and append the tool output to the response; it will also return the mask associated with the response. You can further use the <code>histories</code> to visualize the interaction between the model and the tool; <code>histories[0].show_text()</code> will show the text with color-coded tool output and <code>histories[0].show_tokens(tokenizer)</code> will show visualize the tokens.
<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/learning_tools.png"/></p>`,It,ge,Yt="<p>Finally, we can train the model with <code>train_stats = ppo_trainer.step(queries, responses, rewards, masks)</code>. The trainer will use the mask to ignore the tool output when computing the loss, make sure to pass that argument to <code>step</code>.</p>",Ne,H,Ye,V,Xt="We trained a model with the above script for 10 random seeds. You can reproduce the run with the following command. Feel free to remove the <code>--slurm-*</code> arguments if you don’t have access to a slurm cluster.",Xe,F,$e,z,$t='We can then use <a href="https://github.com/openrlbenchmark/openrlbenchmark" rel="nofollow"><code>openrlbenchmark</code></a> which generates the following plot.',He,R,Ve,E,Ht='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/learning_tools_chart.png"/>',Fe,_,Vt="As we can see, while 1-2 experiments crashed for some reason, most of the runs obtained near perfect proficiency in the calculator task.",ze,S,Re,L,Ft='In the <a href="https://arxiv.org/abs/2302.04761" rel="nofollow">ToolFormer</a> paper, it shows an interesting use case that utilizes a Wikipedia Search tool to help answer questions. In this section, we attempt to perform similar experiments but uses RL instead to teach the model to use a wiki tool on the <a href="https://nlp.cs.washington.edu/triviaqa/" rel="nofollow">TriviaQA</a> dataset.',Ee,g,_e,Q,Se,A,zt='Since <a href="https://arxiv.org/abs/2302.04761" rel="nofollow">ToolFormer</a> did not open source, we needed to first replicate the search index. It is mentioned in their paper that the authors built the search index using a BM25 retriever that indexes the Wikipedia dump from <a href="https://github.com/facebookresearch/KILT" rel="nofollow">KILT</a>',Le,q,Rt='Fortunately, <a href="https://github.com/castorini/pyserini" rel="nofollow"><code>pyserini</code></a> already implements the BM25 retriever and provides a prebuilt index for the KILT Wikipedia dump. We can use the following code to search the index.',Qe,D,Ae,P,qe,K,Et='We then basically deployed this snippet as a Hugging Face space <a href="https://huggingface.co/spaces/vwxyzjn/pyserini-wikipedia-kilt-doc" rel="nofollow">here</a>, so that we can use the space as a <code>transformers.Tool</code> later.',De,O,_t='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/pyserini.png"/>',Pe,ee,Ke,te,St="We use the following settings:",Oe,le,Lt='<li>use the <code>bigcode/starcoderbase</code> model as the base model</li> <li>use the <code>pyserini-wikipedia-kilt-doc</code> space as the wiki tool and only uses the first paragrahs of the search result, allowing the <code>TextEnvironment</code> to obtain at most <code>max_tool_reponse=400</code> response tokens from the tool.</li> <li>test if the response contain the answer string, if so, give a reward of 1, otherwise, give a reward of 0.<ul><li>notice this is a simplified evaluation criteria. In <a href="https://arxiv.org/abs/2302.04761" rel="nofollow">ToolFormer</a>, the authors checks if the first 20 words of the response contain the correct answer.</li></ul></li> <li>used the following prompt that demonstrates the usage of the wiki tool.</li>',et,se,tt,ae,lt,ne,Qt="Our experiments show that the agent can learn to use the wiki tool to answer questions. The learning curves would go up mostly, but one of the experiment did crash.",st,ie,At='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/triviaqa_learning_curves.png"/>',at,re,qt='Wandb report is <a href="https://wandb.ai/costa-huang/cleanRL/reports/TriviaQA-Final-Experiments--Vmlldzo1MjY0ODk5" rel="nofollow">here</a> for further inspection.',nt,oe,Dt="Note that the correct rate of the trained model is on the low end, which could be due to the following reasons:",it,pe,Pt="<li><strong>incorrect searches:</strong> When given the question <code>&quot;What is Bruce Willis&#39; real first name?&quot;</code> if the model searches for <code>Bruce Willis</code>, our wiki tool returns “Patrick Poivey (born 18 February 1948) is a French actor. He is especially known for his voice: he is the French dub voice of Bruce Willis since 1988.<code>But a correct search should be</code>Walter Bruce Willis (born March 19, 1955) is an American former actor. He achieved fame with a leading role on the comedy-drama series Moonlighting (1985–1989) and appeared in over a hundred films, gaining recognition as an action hero after his portrayal of John McClane in the Die Hard franchise (1988–2013) and other roles.[1][2]”</li>",rt,ce,Kt='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/real_first_name.png"/>',ot,he,Ot='<li><p><strong>unnecessarily long response</strong>: The wiki tool by default sometimes output very long sequences. E.g., when the wiki tool searches for “Brown Act”</p> <ul><li><p>Our wiki tool returns “The Ralph M. Brown Act, located at California Government Code 54950 “et seq.”, is an act of the California State Legislature, authored by Assemblymember Ralph M. Brown and passed in 1953, that guarantees the public’s right to attend and participate in meetings of local legislative bodies.”</p></li> <li><p><a href="https://arxiv.org/abs/2302.04761" rel="nofollow">ToolFormer</a>’s wiki tool returns “The Ralph M. Brown Act is an act of the California State Legislature that guarantees the public’s right to attend and participate in meetings of local legislative bodies.” which is more succinct.</p> <p><img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/brown_act.png"/></p></li></ul></li>',pt,Me,ct,we,el="In this section, we attempt to teach the model to use a python interpreter to solve math puzzles. The rough idea is to give the agent a prompt like the following:",ht,me,Mt,de,tl='Training experiment can be found at <a href="https://wandb.ai/lvwerra/trl-gsm8k/runs/a5odv01y" rel="nofollow">https://wandb.ai/lvwerra/trl-gsm8k/runs/a5odv01y</a>',wt,ye,ll='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/gms8k_learning_curve.png"/>',mt,Be,dt;return B=new I({props:{title:"Learning Tools (Experimental 🧪)",local:"learning-tools-experimental-",headingTag:"h1"}}),U=new al({props:{warning:!0,$$slots:{default:[hl]},$$scope:{ctx:Te}}}),k=new I({props:{title:"Learning to Use a Calculator",local:"learning-to-use-a-calculator",headingTag:"h2"}}),x=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBsb2FkX3Rvb2wlMEF0b29sJTIwJTNEJTIwbG9hZF90b29sKCUyMnliZWxrYWRhJTJGc2ltcGxlLWNhbGN1bGF0b3IlMjIpJTBBdG9vbF9mbiUyMCUzRCUyMGxhbWJkYSUyMHRleHQlM0ElMjBzdHIocm91bmQoZmxvYXQodG9vbCh0ZXh0KSklMkMlMjAyKSklMjAlMjAlMjMlMjByb3VuZGluZyUyMHRvJTIwMiUyMGRlY2ltYWwlMjBwbGFjZXM=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, load_tool
tool = load_tool(<span class="hljs-string">&quot;ybelkada/simple-calculator&quot;</span>)
tool_fn = <span class="hljs-keyword">lambda</span> text: <span class="hljs-built_in">str</span>(<span class="hljs-built_in">round</span>(<span class="hljs-built_in">float</span>(tool(text)), <span class="hljs-number">2</span>))  <span class="hljs-comment"># rounding to 2 decimal places</span>`,wrap:!1}}),Y=new j({props:{code:"JTIzJTIwc3lzdGVtJTIwcHJvbXB0JTBBcHJvbXB0JTIwJTNEJTIwJTIyJTIyJTIyJTVDJTBBV2hhdCUyMGlzJTIwMTMuMS0zJTNGJTBBJTBBJTNDcmVxdWVzdCUzRSUzQ1NpbXBsZUNhbGN1bGF0b3JUb29sJTNFMTMuMS0zJTNDY2FsbCUzRTEwLjElM0NyZXNwb25zZSUzRSUwQSUwQVJlc3VsdCUzRDEwLjElM0NzdWJtaXQlM0UlMEElMEFXaGF0JTIwaXMlMjA0KjMlM0YlMEElMEElM0NyZXF1ZXN0JTNFJTNDU2ltcGxlQ2FsY3VsYXRvclRvb2wlM0U0KjMlM0NjYWxsJTNFMTIlM0NyZXNwb25zZSUzRSUwQSUwQVJlc3VsdCUzRDEyJTNDc3VibWl0JTNFJTBBJTBBV2hhdCUyMGlzJTIwMTIuMSUyQjElM0YlMEElMEElM0NyZXF1ZXN0JTNFJTNDU2ltcGxlQ2FsY3VsYXRvclRvb2wlM0UxMi4xJTJCMSUzQ2NhbGwlM0UxMy4xJTNDcmVzcG9uc2UlM0UlMEElMEFSZXN1bHQlM0QxMy4xJTNDc3VibWl0JTNFJTBBJTBBV2hhdCUyMGlzJTIwMTIuMS0yMCUzRiUwQSUwQSUzQ3JlcXVlc3QlM0UlM0NTaW1wbGVDYWxjdWxhdG9yVG9vbCUzRTEyLjEtMjAlM0NjYWxsJTNFLTcuOSUzQ3Jlc3BvbnNlJTNFJTBBJTBBUmVzdWx0JTNELTcuOSUzQ3N1Ym1pdCUzRSUyMiUyMiUyMg==",highlighted:`<span class="hljs-comment"># system prompt</span>
prompt = <span class="hljs-string">&quot;&quot;&quot;\\
What is 13.1-3?

&lt;request&gt;&lt;SimpleCalculatorTool&gt;13.1-3&lt;call&gt;10.1&lt;response&gt;

Result=10.1&lt;submit&gt;

What is 4*3?

&lt;request&gt;&lt;SimpleCalculatorTool&gt;4*3&lt;call&gt;12&lt;response&gt;

Result=12&lt;submit&gt;

What is 12.1+1?

&lt;request&gt;&lt;SimpleCalculatorTool&gt;12.1+1&lt;call&gt;13.1&lt;response&gt;

Result=13.1&lt;submit&gt;

What is 12.1-20?

&lt;request&gt;&lt;SimpleCalculatorTool&gt;12.1-20&lt;call&gt;-7.9&lt;response&gt;

Result=-7.9&lt;submit&gt;&quot;&quot;&quot;</span>`,wrap:!1}}),$=new j({props:{code:"ZW52JTIwJTNEJTIwVGV4dEVudmlyb25tZW50KCUwQSUyMCUyMCUyMCUyMG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIyU2ltcGxlQ2FsY3VsYXRvclRvb2wlMjIlM0ElMjB0b29sX2ZuJTdEJTJDJTBBJTIwJTIwJTIwJTIwcmV3YXJkX2ZuJTJDJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGlvbl9rd2FyZ3MlM0RnZW5lcmF0aW9uX2t3YXJncyUyQyUwQSk=",highlighted:`env = TextEnvironment(
    model,
    tokenizer,
    {<span class="hljs-string">&quot;SimpleCalculatorTool&quot;</span>: tool_fn},
    reward_fn,
    prompt,
    generation_kwargs=generation_kwargs,
)`,wrap:!1}}),H=new I({props:{title:"Experiment results",local:"experiment-results",headingTag:"h2"}}),F=new j({props:{code:"V0FOREJfVEFHUyUzRCUyMmNhbGN1bGF0b3JfZmluYWwlMjIlMjBweXRob24lMjBiZW5jaG1hcmslMkZiZW5jaG1hcmsucHklMjAlNUMlMEElMjAlMjAlMjAlMjAtLWNvbW1hbmQlMjAlMjJweXRob24lMjBleGFtcGxlcyUyRnJlc2VhcmNoX3Byb2plY3RzJTJGdG9vbHMlMkZjYWxjdWxhdG9yLnB5JTIyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1udW0tc2VlZHMlMjAxMCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tc3RhcnQtc2VlZCUyMDElMjAlNUMlMEElMjAlMjAlMjAlMjAtLXdvcmtlcnMlMjAxMCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tc2x1cm0tZ3B1cy1wZXItdGFzayUyMDElMjAlNUMlMEElMjAlMjAlMjAlMjAtLXNsdXJtLW50YXNrcyUyMDElMjAlNUMlMEElMjAlMjAlMjAlMjAtLXNsdXJtLXRvdGFsLWNwdXMlMjA4JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1zbHVybS10ZW1wbGF0ZS1wYXRoJTIwYmVuY2htYXJrJTJGdHJsLnNsdXJtX3RlbXBsYXRl",highlighted:`WANDB_TAGS=<span class="hljs-string">&quot;calculator_final&quot;</span> python benchmark/benchmark<span class="hljs-selector-class">.py</span> \\
    <span class="hljs-attr">--command</span> <span class="hljs-string">&quot;python examples/research_projects/tools/calculator.py&quot;</span> \\
    <span class="hljs-attr">--num-seeds</span> <span class="hljs-number">10</span> \\
    <span class="hljs-attr">--start-seed</span> <span class="hljs-number">1</span> \\
    <span class="hljs-attr">--workers</span> <span class="hljs-number">10</span> \\
    <span class="hljs-attr">--slurm-gpus-per-task</span> <span class="hljs-number">1</span> \\
    <span class="hljs-attr">--slurm-ntasks</span> <span class="hljs-number">1</span> \\
    <span class="hljs-attr">--slurm-total-cpus</span> <span class="hljs-number">8</span> \\
    <span class="hljs-attr">--slurm-template-path</span> benchmark/trl.slurm_template`,wrap:!1}}),R=new j({props:{code:"cHl0aG9uJTIwLW0lMjBvcGVucmxiZW5jaG1hcmsucmxvcHNfbXVsdGlfbWV0cmljcyUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZmlsdGVycyUyMCclM0Z3ZSUzRG9wZW5ybGJlbmNobWFyayUyNndwbiUzRHRybCUyNnhheGlzJTNEX3N0ZXAlMjZjZWlrJTNEdHJsX3Bwb190cmFpbmVyX2NvbmZpZy52YWx1ZS50cmFja2VyX3Byb2plY3RfbmFtZSUyNmNlbiUzRHRybF9wcG9fdHJhaW5lcl9jb25maWcudmFsdWUubG9nX3dpdGglMjZtZXRyaWNzJTNEZW52JTJGcmV3YXJkX21lYW4lMjZtZXRyaWNzJTNEb2JqZWN0aXZlJTJGa2wnJTIwJTVDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJ3dhbmRiJTNGdGFnJTNEY2FsY3VsYXRvcl9maW5hbCUyNmNsJTNEY2FsY3VsYXRvcl9tYXNrJyUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZW52LWlkcyUyMHRybCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tY2hlY2stZW1wdHktcnVucyUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcGMubmNvbHMlMjAyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1wYy5uY29scy1sZWdlbmQlMjAxJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1vdXRwdXQtZmlsZW5hbWUlMjBzdGF0aWMlMkYwY29tcGFyZSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tc2Nhbi1oaXN0b3J5",highlighted:`python -m openrlbenchmark<span class="hljs-selector-class">.rlops_multi_metrics</span> \\
    <span class="hljs-attr">--filters</span> <span class="hljs-string">&#x27;?we=openrlbenchmark&amp;wpn=trl&amp;xaxis=_step&amp;ceik=trl_ppo_trainer_config.value.tracker_project_name&amp;cen=trl_ppo_trainer_config.value.log_with&amp;metrics=env/reward_mean&amp;metrics=objective/kl&#x27;</span> \\
        <span class="hljs-string">&#x27;wandb?tag=calculator_final&amp;cl=calculator_mask&#x27;</span> \\
    <span class="hljs-attr">--env-ids</span> trl \\
    <span class="hljs-attr">--check-empty-runs</span> \\
    <span class="hljs-attr">--pc</span><span class="hljs-selector-class">.ncols</span> <span class="hljs-number">2</span> \\
    <span class="hljs-attr">--pc</span><span class="hljs-selector-class">.ncols-legend</span> <span class="hljs-number">1</span> \\
    <span class="hljs-attr">--output-filename</span> static/<span class="hljs-number">0</span>compare \\
    <span class="hljs-attr">--scan-history</span>`,wrap:!1}}),S=new I({props:{title:"(Early Experiments 🧪): learning to use a wiki tool for question answering",local:"early-experiments--learning-to-use-a-wiki-tool-for-question-answering",headingTag:"h2"}}),g=new al({props:{warning:!0,$$slots:{default:[Ml]},$$scope:{ctx:Te}}}),Q=new I({props:{title:"Building a search index",local:"building-a-search-index",headingTag:"h3"}}),D=new j({props:{code:"ZnJvbSUyMHB5c2VyaW5pLnNlYXJjaC5sdWNlbmUlMjBpbXBvcnQlMjBMdWNlbmVTZWFyY2hlciUwQWltcG9ydCUyMGpzb24lMEFzZWFyY2hlciUyMCUzRCUyMEx1Y2VuZVNlYXJjaGVyLmZyb21fcHJlYnVpbHRfaW5kZXgoJ3dpa2lwZWRpYS1raWx0LWRvYycpJTBBZGVmJTIwc2VhcmNoKHF1ZXJ5KSUzQSUwQSUyMCUyMCUyMCUyMGhpdHMlMjAlM0QlMjBzZWFyY2hlci5zZWFyY2gocXVlcnklMkMlMjBrJTNEMSklMEElMjAlMjAlMjAlMjBoaXQlMjAlM0QlMjBoaXRzJTVCMCU1RCUwQSUyMCUyMCUyMCUyMGNvbnRlbnRzJTIwJTNEJTIwanNvbi5sb2FkcyhoaXQucmF3KSU1Qidjb250ZW50cyclNUQlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBjb250ZW50cyUwQXByaW50KHNlYXJjaCglMjJ0ZW5uaXMlMjByYWNrZXQlMjIpKQ==",highlighted:`<span class="hljs-keyword">from</span> pyserini.search.lucene <span class="hljs-keyword">import</span> LuceneSearcher
<span class="hljs-keyword">import</span> json
searcher = LuceneSearcher.from_prebuilt_index(<span class="hljs-string">&#x27;wikipedia-kilt-doc&#x27;</span>)
<span class="hljs-keyword">def</span> <span class="hljs-title function_">search</span>(<span class="hljs-params">query</span>):
    hits = searcher.search(query, k=<span class="hljs-number">1</span>)
    hit = hits[<span class="hljs-number">0</span>]
    contents = json.loads(hit.raw)[<span class="hljs-string">&#x27;contents&#x27;</span>]
    <span class="hljs-keyword">return</span> contents
<span class="hljs-built_in">print</span>(search(<span class="hljs-string">&quot;tennis racket&quot;</span>))`,wrap:!1}}),P=new j({props:{code:"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",highlighted:`Racket (sports equipment)
A racket <span class="hljs-keyword">or</span> racquet is <span class="hljs-keyword">a</span> sports implement consisting <span class="hljs-keyword">of</span> <span class="hljs-keyword">a</span> handled frame <span class="hljs-keyword">with</span> <span class="hljs-keyword">an</span> <span class="hljs-built_in">open</span> hoop across which <span class="hljs-keyword">a</span> network <span class="hljs-keyword">of</span> strings <span class="hljs-keyword">or</span> catgut is stretched tightly. It is used <span class="hljs-keyword">for</span> striking <span class="hljs-keyword">a</span> ball <span class="hljs-keyword">or</span> shuttlecock <span class="hljs-keyword">in</span> games such <span class="hljs-keyword">as</span> squash, tennis, racquetball, <span class="hljs-keyword">and</span> badminton. Collectively, these games are known <span class="hljs-keyword">as</span> racket sports. Racket design <span class="hljs-keyword">and</span> manufacturing has changed considerably over <span class="hljs-keyword">the</span> centuries.

The frame <span class="hljs-keyword">of</span> rackets <span class="hljs-keyword">for</span> all sports was traditionally made <span class="hljs-keyword">of</span> solid wood (later laminated wood) <span class="hljs-keyword">and</span> <span class="hljs-keyword">the</span> strings <span class="hljs-keyword">of</span> animal intestine known <span class="hljs-keyword">as</span> catgut. The traditional racket size was limited <span class="hljs-keyword">by</span> <span class="hljs-keyword">the</span> strength <span class="hljs-keyword">and</span> weight <span class="hljs-keyword">of</span> <span class="hljs-keyword">the</span> wooden frame which had <span class="hljs-built_in">to</span> be strong enough <span class="hljs-built_in">to</span> hold <span class="hljs-keyword">the</span> strings <span class="hljs-keyword">and</span> stiff enough <span class="hljs-built_in">to</span> hit <span class="hljs-keyword">the</span> ball <span class="hljs-keyword">or</span> shuttle. Manufacturers started adding non-wood laminates <span class="hljs-built_in">to</span> wood rackets <span class="hljs-built_in">to</span> improve stiffness. Non-wood rackets were made <span class="hljs-keyword">first</span> <span class="hljs-keyword">of</span> steel, <span class="hljs-keyword">then</span> <span class="hljs-keyword">of</span> aluminum, <span class="hljs-keyword">and</span> <span class="hljs-keyword">then</span> carbon fiber composites. Wood is still used <span class="hljs-keyword">for</span> real tennis, rackets, <span class="hljs-keyword">and</span> xare. Most rackets are now made <span class="hljs-keyword">of</span> composite materials including carbon fiber <span class="hljs-keyword">or</span> fiberglass, metals such <span class="hljs-keyword">as</span> titanium alloys, <span class="hljs-keyword">or</span> ceramics.
...`,wrap:!1}}),ee=new I({props:{title:"Experiment settings",local:"experiment-settings",headingTag:"h3"}}),se=new j({props:{code:"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",highlighted:`prompt = <span class="hljs-string">&quot;&quot;&quot;\\
Answer the following question:

Q: In which branch of the arts is Patricia Neary famous?
A: Ballets
A2: &lt;request&gt;&lt;Wiki&gt;Patricia Neary&lt;call&gt;Patricia Neary (born October 27, 1942) is an American ballerina, choreographer and ballet director, who has been particularly active in Switzerland. She has also been a highly successful ambassador for the Balanchine Trust, bringing George Balanchine&#x27;s ballets to 60 cities around the globe.&lt;response&gt;
Result=Ballets&lt;submit&gt;

Q: Who won Super Bowl XX?
A: Chicago Bears
A2: &lt;request&gt;&lt;Wiki&gt;Super Bowl XX&lt;call&gt;Super Bowl XX was an American football game between the National Football Conference (NFC) champion Chicago Bears and the American Football Conference (AFC) champion New England Patriots to decide the National Football League (NFL) champion for the 1985 season. The Bears defeated the Patriots by the score of 46–10, capturing their first NFL championship (and Chicago&#x27;s first overall sports victory) since 1963, three years prior to the birth of the Super Bowl. Super Bowl XX was played on January 26, 1986 at the Louisiana Superdome in New Orleans.&lt;response&gt;
Result=Chicago Bears&lt;submit&gt;

Q: &quot;&quot;&quot;</span>`,wrap:!1}}),ae=new I({props:{title:"Result and Discussion",local:"result-and-discussion",headingTag:"h3"}}),Me=new I({props:{title:"(Early Experiments 🧪): solving math puzzles with python interpreter",local:"early-experiments--solving-math-puzzles-with-python-interpreter",headingTag:"h2"}}),me=new j({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyJTIyJTIyJTVDJTBBRXhhbXBsZSUyMG9mJTIwdXNpbmclMjBhJTIwUHl0aG9uJTIwQVBJJTIwdG8lMjBzb2x2ZSUyMG1hdGglMjBxdWVzdGlvbnMuJTBBJTBBUSUzQSUyME9saXZpYSUyMGhhcyUyMCUyNDIzLiUyMFNoZSUyMGJvdWdodCUyMGZpdmUlMjBiYWdlbHMlMjBmb3IlMjAlMjQzJTIwZWFjaC4lMjBIb3clMjBtdWNoJTIwbW9uZXklMjBkb2VzJTIwc2hlJTIwaGF2ZSUyMGxlZnQlM0YlMEElMEElM0NyZXF1ZXN0JTNFJTNDUHl0aG9uSW50ZXJwcmV0ZXIlM0UlMEFkZWYlMjBzb2x1dGlvbigpJTNBJTBBJTIwJTIwJTIwJTIwbW9uZXlfaW5pdGlhbCUyMCUzRCUyMDIzJTBBJTIwJTIwJTIwJTIwYmFnZWxzJTIwJTNEJTIwNSUwQSUyMCUyMCUyMCUyMGJhZ2VsX2Nvc3QlMjAlM0QlMjAzJTBBJTIwJTIwJTIwJTIwbW9uZXlfc3BlbnQlMjAlM0QlMjBiYWdlbHMlMjAqJTIwYmFnZWxfY29zdCUwQSUyMCUyMCUyMCUyMG1vbmV5X2xlZnQlMjAlM0QlMjBtb25leV9pbml0aWFsJTIwLSUyMG1vbmV5X3NwZW50JTBBJTIwJTIwJTIwJTIwcmVzdWx0JTIwJTNEJTIwbW9uZXlfbGVmdCUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHJlc3VsdCUwQXByaW50KHNvbHV0aW9uKCkpJTBBJTNDY2FsbCUzRTcyJTNDcmVzcG9uc2UlM0UlMEElMEFSZXN1bHQlMjAlM0QlMjA3MiUyMCUzQ3N1Ym1pdCUzRSUwQSUwQVElM0ElMjAlMjIlMjIlMjI=",highlighted:`prompt = <span class="hljs-string">&quot;&quot;&quot;\\
Example of using a Python API to solve math questions.

Q: Olivia has $23. She bought five bagels for $3 each. How much money does she have left?

&lt;request&gt;&lt;PythonInterpreter&gt;
def solution():
    money_initial = 23
    bagels = 5
    bagel_cost = 3
    money_spent = bagels * bagel_cost
    money_left = money_initial - money_spent
    result = money_left
    return result
print(solution())
&lt;call&gt;72&lt;response&gt;

Result = 72 &lt;submit&gt;

Q: &quot;&quot;&quot;</span>`,wrap:!1}}),{c(){p=i("meta"),b=a(),u=i("p"),f=a(),c(B.$$.fragment),ve=a(),v=i("p"),v.innerHTML=Bt,We=a(),W=i("p"),W.innerHTML=vt,Ge=a(),G=i("table"),G.innerHTML=Wt,ke=a(),c(U.$$.fragment),Ce=a(),c(k.$$.fragment),Ze=a(),C=i("p"),C.textContent=Gt,xe=a(),T=i("ol"),Z=i("li"),Je=i("p"),Je.innerHTML=kt,Tt=a(),c(x.$$.fragment),Jt=a(),be=i("li"),be.innerHTML=Ct,bt=a(),N=i("li"),je=i("p"),je.textContent=Zt,jt=a(),c(Y.$$.fragment),ft=a(),X=i("li"),fe=i("p"),fe.innerHTML=xt,Ut=a(),c($.$$.fragment),gt=a(),Ue=i("li"),Ue.innerHTML=Nt,It=a(),ge=i("li"),ge.innerHTML=Yt,Ne=a(),c(H.$$.fragment),Ye=a(),V=i("p"),V.innerHTML=Xt,Xe=a(),c(F.$$.fragment),$e=a(),z=i("p"),z.innerHTML=$t,He=a(),c(R.$$.fragment),Ve=a(),E=i("p"),E.innerHTML=Ht,Fe=a(),_=i("p"),_.textContent=Vt,ze=a(),c(S.$$.fragment),Re=a(),L=i("p"),L.innerHTML=Ft,Ee=a(),c(g.$$.fragment),_e=a(),c(Q.$$.fragment),Se=a(),A=i("p"),A.innerHTML=zt,Le=a(),q=i("p"),q.innerHTML=Rt,Qe=a(),c(D.$$.fragment),Ae=a(),c(P.$$.fragment),qe=a(),K=i("p"),K.innerHTML=Et,De=a(),O=i("p"),O.innerHTML=_t,Pe=a(),c(ee.$$.fragment),Ke=a(),te=i("p"),te.textContent=St,Oe=a(),le=i("ul"),le.innerHTML=Lt,et=a(),c(se.$$.fragment),tt=a(),c(ae.$$.fragment),lt=a(),ne=i("p"),ne.textContent=Qt,st=a(),ie=i("p"),ie.innerHTML=At,at=a(),re=i("p"),re.innerHTML=qt,nt=a(),oe=i("p"),oe.textContent=Dt,it=a(),pe=i("ul"),pe.innerHTML=Pt,rt=a(),ce=i("p"),ce.innerHTML=Kt,ot=a(),he=i("ul"),he.innerHTML=Ot,pt=a(),c(Me.$$.fragment),ct=a(),we=i("p"),we.textContent=el,ht=a(),c(me.$$.fragment),Mt=a(),de=i("p"),de.innerHTML=tl,wt=a(),ye=i("p"),ye.innerHTML=ll,mt=a(),Be=i("p"),this.h()},l(e){const t=cl("svelte-u9bgzb",document.head);p=r(t,"META",{name:!0,content:!0}),t.forEach(l),b=n(e),u=r(e,"P",{}),Ie(u).forEach(l),f=n(e),h(B.$$.fragment,e),ve=n(e),v=r(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-178bzj4"&&(v.innerHTML=Bt),We=n(e),W=r(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-11mt98v"&&(W.innerHTML=vt),Ge=n(e),G=r(e,"TABLE",{"data-svelte-h":!0}),o(G)!=="svelte-v8ueqj"&&(G.innerHTML=Wt),ke=n(e),h(U.$$.fragment,e),Ce=n(e),h(k.$$.fragment,e),Ze=n(e),C=r(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-dlnuxr"&&(C.textContent=Gt),xe=n(e),T=r(e,"OL",{});var J=Ie(T);Z=r(J,"LI",{});var ue=Ie(Z);Je=r(ue,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-1cfjd6x"&&(Je.innerHTML=kt),Tt=n(ue),h(x.$$.fragment,ue),ue.forEach(l),Jt=n(J),be=r(J,"LI",{"data-svelte-h":!0}),o(be)!=="svelte-ssyycj"&&(be.innerHTML=Ct),bt=n(J),N=r(J,"LI",{});var yt=Ie(N);je=r(yt,"P",{"data-svelte-h":!0}),o(je)!=="svelte-em0npc"&&(je.textContent=Zt),jt=n(yt),h(Y.$$.fragment,yt),yt.forEach(l),ft=n(J),X=r(J,"LI",{});var ut=Ie(X);fe=r(ut,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-idnct8"&&(fe.innerHTML=xt),Ut=n(ut),h($.$$.fragment,ut),ut.forEach(l),gt=n(J),Ue=r(J,"LI",{"data-svelte-h":!0}),o(Ue)!=="svelte-jdeihy"&&(Ue.innerHTML=Nt),It=n(J),ge=r(J,"LI",{"data-svelte-h":!0}),o(ge)!=="svelte-3ih7t1"&&(ge.innerHTML=Yt),J.forEach(l),Ne=n(e),h(H.$$.fragment,e),Ye=n(e),V=r(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-tbi3iu"&&(V.innerHTML=Xt),Xe=n(e),h(F.$$.fragment,e),$e=n(e),z=r(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1xurwqg"&&(z.innerHTML=$t),He=n(e),h(R.$$.fragment,e),Ve=n(e),E=r(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1g846fo"&&(E.innerHTML=Ht),Fe=n(e),_=r(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-vgz8f5"&&(_.textContent=Vt),ze=n(e),h(S.$$.fragment,e),Re=n(e),L=r(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-1k4cy06"&&(L.innerHTML=Ft),Ee=n(e),h(g.$$.fragment,e),_e=n(e),h(Q.$$.fragment,e),Se=n(e),A=r(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-4e7gc4"&&(A.innerHTML=zt),Le=n(e),q=r(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-1ea9kw5"&&(q.innerHTML=Rt),Qe=n(e),h(D.$$.fragment,e),Ae=n(e),h(P.$$.fragment,e),qe=n(e),K=r(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-1oofcgb"&&(K.innerHTML=Et),De=n(e),O=r(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-682f8q"&&(O.innerHTML=_t),Pe=n(e),h(ee.$$.fragment,e),Ke=n(e),te=r(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-1nttfiy"&&(te.textContent=St),Oe=n(e),le=r(e,"UL",{"data-svelte-h":!0}),o(le)!=="svelte-x7upql"&&(le.innerHTML=Lt),et=n(e),h(se.$$.fragment,e),tt=n(e),h(ae.$$.fragment,e),lt=n(e),ne=r(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-1uznutc"&&(ne.textContent=Qt),st=n(e),ie=r(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-xtcpx0"&&(ie.innerHTML=At),at=n(e),re=r(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-1kk3wng"&&(re.innerHTML=qt),nt=n(e),oe=r(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-1gz9d0a"&&(oe.textContent=Dt),it=n(e),pe=r(e,"UL",{"data-svelte-h":!0}),o(pe)!=="svelte-16k5ke5"&&(pe.innerHTML=Pt),rt=n(e),ce=r(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-7ohcuc"&&(ce.innerHTML=Kt),ot=n(e),he=r(e,"UL",{"data-svelte-h":!0}),o(he)!=="svelte-f4p0va"&&(he.innerHTML=Ot),pt=n(e),h(Me.$$.fragment,e),ct=n(e),we=r(e,"P",{"data-svelte-h":!0}),o(we)!=="svelte-9l5kiy"&&(we.textContent=el),ht=n(e),h(me.$$.fragment,e),Mt=n(e),de=r(e,"P",{"data-svelte-h":!0}),o(de)!=="svelte-1dnddfe"&&(de.innerHTML=tl),wt=n(e),ye=r(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-1cvjnh6"&&(ye.innerHTML=ll),mt=n(e),Be=r(e,"P",{}),Ie(Be).forEach(l),this.h()},h(){sl(p,"name","hf:doc:metadata"),sl(p,"content",ml)},m(e,t){y(document.head,p),s(e,b,t),s(e,u,t),s(e,f,t),M(B,e,t),s(e,ve,t),s(e,v,t),s(e,We,t),s(e,W,t),s(e,Ge,t),s(e,G,t),s(e,ke,t),M(U,e,t),s(e,Ce,t),M(k,e,t),s(e,Ze,t),s(e,C,t),s(e,xe,t),s(e,T,t),y(T,Z),y(Z,Je),y(Z,Tt),M(x,Z,null),y(T,Jt),y(T,be),y(T,bt),y(T,N),y(N,je),y(N,jt),M(Y,N,null),y(T,ft),y(T,X),y(X,fe),y(X,Ut),M($,X,null),y(T,gt),y(T,Ue),y(T,It),y(T,ge),s(e,Ne,t),M(H,e,t),s(e,Ye,t),s(e,V,t),s(e,Xe,t),M(F,e,t),s(e,$e,t),s(e,z,t),s(e,He,t),M(R,e,t),s(e,Ve,t),s(e,E,t),s(e,Fe,t),s(e,_,t),s(e,ze,t),M(S,e,t),s(e,Re,t),s(e,L,t),s(e,Ee,t),M(g,e,t),s(e,_e,t),M(Q,e,t),s(e,Se,t),s(e,A,t),s(e,Le,t),s(e,q,t),s(e,Qe,t),M(D,e,t),s(e,Ae,t),M(P,e,t),s(e,qe,t),s(e,K,t),s(e,De,t),s(e,O,t),s(e,Pe,t),M(ee,e,t),s(e,Ke,t),s(e,te,t),s(e,Oe,t),s(e,le,t),s(e,et,t),M(se,e,t),s(e,tt,t),M(ae,e,t),s(e,lt,t),s(e,ne,t),s(e,st,t),s(e,ie,t),s(e,at,t),s(e,re,t),s(e,nt,t),s(e,oe,t),s(e,it,t),s(e,pe,t),s(e,rt,t),s(e,ce,t),s(e,ot,t),s(e,he,t),s(e,pt,t),M(Me,e,t),s(e,ct,t),s(e,we,t),s(e,ht,t),M(me,e,t),s(e,Mt,t),s(e,de,t),s(e,wt,t),s(e,ye,t),s(e,mt,t),s(e,Be,t),dt=!0},p(e,[t]){const J={};t&2&&(J.$$scope={dirty:t,ctx:e}),U.$set(J);const ue={};t&2&&(ue.$$scope={dirty:t,ctx:e}),g.$set(ue)},i(e){dt||(w(B.$$.fragment,e),w(U.$$.fragment,e),w(k.$$.fragment,e),w(x.$$.fragment,e),w(Y.$$.fragment,e),w($.$$.fragment,e),w(H.$$.fragment,e),w(F.$$.fragment,e),w(R.$$.fragment,e),w(S.$$.fragment,e),w(g.$$.fragment,e),w(Q.$$.fragment,e),w(D.$$.fragment,e),w(P.$$.fragment,e),w(ee.$$.fragment,e),w(se.$$.fragment,e),w(ae.$$.fragment,e),w(Me.$$.fragment,e),w(me.$$.fragment,e),dt=!0)},o(e){m(B.$$.fragment,e),m(U.$$.fragment,e),m(k.$$.fragment,e),m(x.$$.fragment,e),m(Y.$$.fragment,e),m($.$$.fragment,e),m(H.$$.fragment,e),m(F.$$.fragment,e),m(R.$$.fragment,e),m(S.$$.fragment,e),m(g.$$.fragment,e),m(Q.$$.fragment,e),m(D.$$.fragment,e),m(P.$$.fragment,e),m(ee.$$.fragment,e),m(se.$$.fragment,e),m(ae.$$.fragment,e),m(Me.$$.fragment,e),m(me.$$.fragment,e),dt=!1},d(e){e&&(l(b),l(u),l(f),l(ve),l(v),l(We),l(W),l(Ge),l(G),l(ke),l(Ce),l(Ze),l(C),l(xe),l(T),l(Ne),l(Ye),l(V),l(Xe),l($e),l(z),l(He),l(Ve),l(E),l(Fe),l(_),l(ze),l(Re),l(L),l(Ee),l(_e),l(Se),l(A),l(Le),l(q),l(Qe),l(Ae),l(qe),l(K),l(De),l(O),l(Pe),l(Ke),l(te),l(Oe),l(le),l(et),l(tt),l(lt),l(ne),l(st),l(ie),l(at),l(re),l(nt),l(oe),l(it),l(pe),l(rt),l(ce),l(ot),l(he),l(pt),l(ct),l(we),l(ht),l(Mt),l(de),l(wt),l(ye),l(mt),l(Be)),l(p),d(B,e),d(U,e),d(k,e),d(x),d(Y),d($),d(H,e),d(F,e),d(R,e),d(S,e),d(g,e),d(Q,e),d(D,e),d(P,e),d(ee,e),d(se,e),d(ae,e),d(Me,e),d(me,e)}}}const ml='{"title":"Learning Tools (Experimental 🧪)","local":"learning-tools-experimental-","sections":[{"title":"Learning to Use a Calculator","local":"learning-to-use-a-calculator","sections":[],"depth":2},{"title":"Experiment results","local":"experiment-results","sections":[],"depth":2},{"title":"(Early Experiments 🧪): learning to use a wiki tool for question answering","local":"early-experiments--learning-to-use-a-wiki-tool-for-question-answering","sections":[{"title":"Building a search index","local":"building-a-search-index","sections":[],"depth":3},{"title":"Experiment settings","local":"experiment-settings","sections":[],"depth":3},{"title":"Result and Discussion","local":"result-and-discussion","sections":[],"depth":3}],"depth":2},{"title":"(Early Experiments 🧪): solving math puzzles with python interpreter","local":"early-experiments--solving-math-puzzles-with-python-interpreter","sections":[],"depth":2}],"depth":1}';function dl(Te){return rl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class jl extends ol{constructor(p){super(),pl(this,p,dl,wl,il,{})}}export{jl as component};
