import{s as Ti,f as wi,o as _i,n as Ji}from"../chunks/scheduler.85c25b89.js";import{S as bi,i as Ui,g as o,s as l,r as p,A as ji,h as i,f as a,c as s,j as x,u as d,x as r,k as T,l as gi,y as g,a as n,v as c,d as m,t as u,w as h}from"../chunks/index.c9837788.js";import{T as vi}from"../chunks/Tip.6bd863a0.js";import{D as xa}from"../chunks/Docstring.5c1d567f.js";import{C as M}from"../chunks/CodeBlock.52fa569e.js";import{H as y,E as Ci}from"../chunks/EditOnGithub.b65eee75.js";function Ii(Ga){let f,G="If the chat template contains special tokens like <code>&lt;|im_start|&gt;</code> (ChatML) or <code>&lt;|eot_id|&gt;</code> (Llama), the embedding layer and LM head must be included in the trainable parameters via the <code>modules_to_save</code> argument. Without this, the fine-tuned model will produce unbounded or nonsense generations. If the chat template doesn’t contain special tokens (e.g. Alpaca), then the <code>modules_to_save</code> argument can be ignored or set to <code>None</code>.";return{c(){f=o("p"),f.innerHTML=G},l(w){f=i(w,"P",{"data-svelte-h":!0}),r(f)!=="svelte-10b052h"&&(f.innerHTML=G)},m(w,_a){n(w,f,_a)},p:Ji,d(w){w&&a(f)}}}function ki(Ga){let f,G,w,_a,Z,Za,B,qs='<a href="https://huggingface.co/models?other=sft,trl" rel="nofollow"><img src="https://img.shields.io/badge/All_models-SFT-blue"/></a> <a href="https://github.com/huggingface/smol-course/tree/main/1_instruction_tuning" rel="nofollow"><img src="https://img.shields.io/badge/smol_course-Chapter_1-yellow"/></a>',Ba,N,Rs="Supervised fine-tuning (or SFT for short) is a crucial step in RLHF. In TRL we provide an easy-to-use API to create your SFT models and train them with few lines of code on your dataset.",Na,q,As=`Check out a complete flexible example at <a href="https://github.com/huggingface/trl/tree/main/trl/scripts/sft.py" rel="nofollow"><code>trl/scripts/sft.py</code></a>.
Experimental support for Vision Language Models is also included in the example <a href="https://github.com/huggingface/trl/tree/main/examples/scripts/sft_vlm.py" rel="nofollow"><code>examples/scripts/sft_vlm.py</code></a>.`,qa,R,Ra,A,Xs=`If you have a dataset hosted on the 🤗 Hub, you can easily fine-tune your SFT model using <a href="/docs/trl/v0.13.0/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> from TRL. Let us assume your dataset is <code>imdb</code>, the text you want to predict is inside the <code>text</code> field of the dataset, and you want to fine-tune the <code>facebook/opt-350m</code> model.
The following code-snippet takes care of all the data pre-processing and training for you:`,Aa,X,Xa,E,Es="Make sure to pass the correct value for <code>max_seq_length</code> as the default value will be set to <code>min(tokenizer.model_max_length, 1024)</code>.",Ea,W,Ws="You can also construct a model outside of the trainer and pass it as follows:",Wa,S,Sa,z,Ss='The above snippets will use the default training arguments from the <a href="/docs/trl/v0.13.0/en/sft_trainer#trl.SFTConfig">SFTConfig</a> class. If you want to modify the defaults pass in your modification to the <code>SFTConfig</code> constructor and pass them to the trainer via the <code>args</code> argument.',za,Q,Qa,V,Va,H,zs=`You can use the <code>DataCollatorForCompletionOnlyLM</code> to train your model on the generated prompts only. Note that this works only in the case when <code>packing=False</code>.
To instantiate that collator for instruction data, pass a response template and the tokenizer. Here is an example of how it would work to fine-tune <code>opt-350m</code> on completions only on the CodeAlpaca dataset:`,Ha,L,La,Y,Qs="To instantiate that collator for assistant style conversation data, pass a response template, an instruction template and the tokenizer. Here is an example of how it would work to fine-tune <code>opt-350m</code> on assistant completions only on the Open Assistant Guanaco dataset:",Ya,D,Da,P,Vs="Make sure to have a <code>pad_token_id</code> which is different from <code>eos_token_id</code> which can result in the model not properly predicting EOS (End of Sentence) tokens during generation.",Pa,O,Oa,K,Hs="Some tokenizers like Llama 2 (<code>meta-llama/Llama-2-XXb-hf</code>) tokenize sequences differently depending on whether they have context or not. For example:",Ka,tt,tn,et,Ls="In this case, and due to lack of context in <code>response_template</code>, the same string (”### Assistant:”) is tokenized differently:",en,at,Ys="<li>Text (with context): <code>[2277, 29937, 4007, 22137, 29901]</code></li> <li><code>response_template</code> (without context): <code>[835, 4007, 22137, 29901]</code></li>",an,nt,Ds="This will lead to an error when the <code>DataCollatorForCompletionOnlyLM</code> does not find the <code>response_template</code> in the dataset example text:",nn,lt,ln,st,Ps="To solve this, you can tokenize the <code>response_template</code> with the same context as in the dataset, truncate it as needed and pass the <code>token_ids</code> directly to the <code>response_template</code> argument of the <code>DataCollatorForCompletionOnlyLM</code> class. For example:",sn,ot,on,it,rn,rt,Os=`Adding special tokens to a language model is crucial for training chat models. These tokens are added between the different roles in a conversation, such as the user, assistant, and system and help the model recognize the structure and flow of a conversation. This setup is essential for enabling the model to generate coherent and contextually appropriate responses in a chat environment.
The <code>setup_chat_format()</code> function in <code>trl</code> easily sets up a model and tokenizer for conversational AI tasks. This function:`,pn,pt,Ks='<li>Adds special tokens to the tokenizer, e.g. <code>&lt;|im_start|&gt;</code> and <code>&lt;|im_end|&gt;</code>, to indicate the start and end of a conversation.</li> <li>Resizes the model’s embedding layer to accommodate the new tokens.</li> <li>Sets the <code>chat_template</code> of the tokenizer, which is used to format the input data into a chat-like format. The default is <code>chatml</code> from OpenAI.</li> <li><em>optionally</em> you can pass <code>resize_to_multiple_of</code> to resize the embedding layer to a multiple of the <code>resize_to_multiple_of</code> argument, e.g. 64. If you want to see more formats being supported in the future, please open a GitHub issue on <a href="https://github.com/huggingface/trl" rel="nofollow">trl</a></li>',dn,dt,cn,ct,to="With our model and tokenizer set up, we can now fine-tune our model on a conversational dataset. Below is an example of how a dataset can be formatted for fine-tuning.",mn,mt,un,ut,eo='The <a href="/docs/trl/v0.13.0/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> supports popular dataset formats. This allows you to pass the dataset to the trainer without any pre-processing directly. The following formats are supported:',hn,ht,ao="<li>conversational format</li>",Mn,Mt,yn,yt,no="<li>instruction format</li>",fn,ft,gn,gt,lo='If your dataset uses one of the above formats, you can directly pass it to the trainer without pre-processing. The <a href="/docs/trl/v0.13.0/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> will then format the dataset for you using the defined format from the model’s tokenizer with the <a href="https://huggingface.co/docs/transformers/main/en/chat_templating#templates-for-chat-models" rel="nofollow">apply_chat_template</a> method.',Tn,Tt,wn,wt,so="If the dataset is not in one of those format you can either preprocess the dataset to match the formatting or pass a formatting function to the SFTTrainer to do it for you. Let’s have a look.",_n,_t,Jn,Jt,oo=`For instruction fine-tuning, it is quite common to have two columns inside the dataset: one for the prompt &amp; the other for the response.
This allows people to format examples like <a href="https://github.com/tatsu-lab/stanford_alpaca" rel="nofollow">Stanford-Alpaca</a> did as follows:`,bn,bt,Un,Ut,io="Let us assume your dataset has two fields, <code>question</code> and <code>answer</code>. Therefore you can just run:",jn,jt,vn,vt,ro='To properly format your input make sure to process all the examples by looping over them and returning a list of processed text. Check out a full example of how to use SFTTrainer on alpaca dataset <a href="https://github.com/huggingface/trl/pull/444#issue-1760952763" rel="nofollow">here</a>',Cn,Ct,In,It,po='<a href="/docs/trl/v0.13.0/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> supports <em>example packing</em>, where multiple short examples are packed in the same input sequence to increase training efficiency. This is done with the <code>ConstantLengthDataset</code> utility class that returns constant length chunks of tokens from a stream of examples. To enable the usage of this dataset class, simply pass <code>packing=True</code> to the <a href="/docs/trl/v0.13.0/en/sft_trainer#trl.SFTConfig">SFTConfig</a> constructor.',kn,kt,Fn,Ft,co=`Note that if you use a packed dataset and if you pass <code>max_steps</code> in the training arguments you will probably train your models for more than few epochs, depending on the way you have configured the packed dataset and the training protocol. Double check that you know and understand what you are doing.
If you don’t want to pack your <code>eval_dataset</code>, you can pass <code>eval_packing=False</code> to the <code>SFTConfig</code> init method.`,$n,$t,xn,xt,mo="If your dataset has several fields that you want to combine, for example if the dataset has <code>question</code> and <code>answer</code> fields and you want to combine them, you can pass a formatting function to the trainer that will take care of that. For example:",Gn,Gt,Zn,Zt,uo='You can also customize the <code>ConstantLengthDataset</code> much more by directly passing the arguments to the <a href="/docs/trl/v0.13.0/en/sft_trainer#trl.SFTConfig">SFTConfig</a> constructor. Please refer to that class’ signature for more information.',Bn,Bt,Nn,Nt,ho='You can directly pass the kwargs of the <code>from_pretrained()</code> method to the <a href="/docs/trl/v0.13.0/en/sft_trainer#trl.SFTConfig">SFTConfig</a>. For example, if you want to load a model in a different precision, analogous to',qn,qt,Rn,Rt,Mo="Note that all keyword arguments of <code>from_pretrained()</code> are supported.",An,At,Xn,Xt,yo="We also support tight integration with 🤗 PEFT library so that any user can conveniently train adapters and share them on the Hub instead of training the entire model.",En,Et,Wn,C,Sn,Wt,fo="You can also continue training your <code>PeftModel</code>. For that, first load a <code>PeftModel</code> outside <code>SFTTrainer</code> and pass it directly to the trainer without the <code>peft_config</code> argument being passed.",zn,St,Qn,zt,go="For that, you need to first load your 8 bit model outside the Trainer and pass a <code>PeftConfig</code> to the trainer. For example:",Vn,Qt,Hn,Vt,Ln,Ht,To=`You can benefit from Flash Attention 1 & 2 using SFTTrainer out of the box with minimal changes of code.
First, to make sure you have all the latest features from transformers, install transformers from source`,Yn,Lt,Dn,Yt,wo=`Note that Flash Attention only works on GPU now and under half-precision regime (when using adapters, base model loaded in half-precision)
Note also both features are perfectly compatible with other tools such as quantization.`,Pn,Dt,On,Pt,_o="For Flash Attention 1 you can use the <code>BetterTransformer</code> API and force-dispatch the API to use Flash Attention kernel. First, install the latest optimum package:",Kn,Ot,tl,Kt,Jo="Once you have loaded your model, wrap the <code>trainer.train()</code> call under the <code>with torch.backends.cuda.sdp_kernel(enable_flash=True, enable_math=False, enable_mem_efficient=False):</code> context manager:",el,te,al,ee,bo="Note that you cannot train your model using Flash Attention 1 on an arbitrary dataset as <code>torch.scaled_dot_product_attention</code> does not support training with padding tokens if you use Flash Attention kernels. Therefore you can only use that feature with <code>packing=True</code>. If your dataset contains padding tokens, consider switching to Flash Attention 2 integration.",nl,ae,Uo="Below are some numbers you can get in terms of speedup and memory efficiency, using Flash Attention 1, on a single NVIDIA-T4 16GB.",ll,ne,jo="<thead><tr><th>use_flash_attn_1</th> <th>model_name</th> <th>max_seq_len</th> <th>batch_size</th> <th>time per training step</th></tr></thead> <tbody><tr><td>x</td> <td>facebook/opt-350m</td> <td>2048</td> <td>8</td> <td>~59.1s</td></tr> <tr><td></td> <td>facebook/opt-350m</td> <td>2048</td> <td>8</td> <td><strong>OOM</strong></td></tr> <tr><td>x</td> <td>facebook/opt-350m</td> <td>2048</td> <td>4</td> <td>~30.3s</td></tr> <tr><td></td> <td>facebook/opt-350m</td> <td>2048</td> <td>4</td> <td>~148.9s</td></tr></tbody>",sl,le,ol,se,vo="To use Flash Attention 2, first install the latest <code>flash-attn</code> package:",il,oe,rl,ie,Co="And add <code>attn_implementation=&quot;flash_attention_2&quot;</code> when calling <code>from_pretrained</code>:",pl,re,dl,pe,Io=`If you don’t use quantization, make sure your model is loaded in half-precision and dispatch your model on a supported GPU device.
After loading your model, you can either train it as it is, or attach adapters and train adapters on it in case your model is quantized.`,cl,de,ko="In contrast to Flash Attention 1, the integration makes it possible to train your model on an arbitrary dataset that also includes padding tokens.",ml,ce,ul,me,Fo="We included a utility function to create your model.",hl,_,ue,ks,Ja,$o="Configuration class for the models.",Fs,ba,xo=`Using <a href="https://huggingface.co/docs/transformers/v4.47.0/en/internal/trainer_utils#transformers.HfArgumentParser" rel="nofollow">HfArgumentParser</a> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,Ml,he,yl,Me,fl,ye,Go='NEFTune is a technique to boost the performance of chat models and was introduced by the paper <a href="https://huggingface.co/papers/2310.05914" rel="nofollow">“NEFTune: Noisy Embeddings Improve Instruction Finetuning”</a> from Jain et al. it consists of adding noise to the embedding vectors during training. According to the abstract of the paper:',gl,fe,Zo="<p>Standard finetuning of LLaMA-2-7B using Alpaca achieves 29.79% on AlpacaEval, which rises to 64.69% using noisy embeddings. NEFTune also improves over strong baselines on modern instruction datasets. Models trained with Evol-Instruct see a 10% improvement, with ShareGPT an 8% improvement, and with OpenPlatypus an 8% improvement. Even powerful models further refined with RLHF such as LLaMA-2-Chat benefit from additional training with NEFTune.</p>",Tl,I,Bo='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/neft-screenshot.png"/>',wl,ge,No="To use it in <code>SFTTrainer</code> simply pass <code>neftune_noise_alpha</code> when creating your <code>SFTConfig</code> instance. Note that to avoid any surprising behaviour, NEFTune is disabled after training to retrieve back the original behaviour of the embedding layer.",_l,Te,Jl,we,qo='We have tested NEFTune by training <code>mistralai/Mistral-7B-v0.1</code> on the <a href="https://huggingface.co/datasets/timdettmers/openassistant-guanaco" rel="nofollow">OpenAssistant dataset</a> and validated that using NEFTune led to a performance boost of ~25% on MT Bench.',bl,k,Ro='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/trl-neftune-mistral-7b.png"/>',Ul,_e,Ao='Note however, that the amount of performance gain is <em>dataset dependent</em> and in particular, applying NEFTune on synthetic datasets like <a href="https://huggingface.co/datasets/stingning/ultrachat" rel="nofollow">UltraChat</a> typically produces smaller gains.',jl,Je,vl,be,Xo='You can further accelerate QLoRA / LoRA (2x faster, 60% less memory) using the <a href="https://github.com/unslothai/unsloth" rel="nofollow"><code>unsloth</code></a> library that is fully compatible with <code>SFTTrainer</code>. Currently <code>unsloth</code> supports only Llama (Yi, TinyLlama, Qwen, Deepseek etc) and Mistral architectures. Some benchmarks on 1x A100 listed below:',Cl,Ue,Eo="<thead><tr><th>1 A100 40GB</th> <th>Dataset</th> <th>🤗</th> <th>🤗 + Flash Attention 2</th> <th>🦥 Unsloth</th> <th>🦥 VRAM saved</th></tr></thead> <tbody><tr><td>Code Llama 34b</td> <td>Slim Orca</td> <td>1x</td> <td>1.01x</td> <td><strong>1.94x</strong></td> <td>-22.7%</td></tr> <tr><td>Llama-2 7b</td> <td>Slim Orca</td> <td>1x</td> <td>0.96x</td> <td><strong>1.87x</strong></td> <td>-39.3%</td></tr> <tr><td>Mistral 7b</td> <td>Slim Orca</td> <td>1x</td> <td>1.17x</td> <td><strong>1.88x</strong></td> <td>-65.9%</td></tr> <tr><td>Tiny Llama 1.1b</td> <td>Alpaca</td> <td>1x</td> <td>1.55x</td> <td><strong>2.74x</strong></td> <td>-57.8%</td></tr></tbody>",Il,je,Wo='First install <code>unsloth</code> according to the <a href="https://github.com/unslothai/unsloth" rel="nofollow">official documentation</a>. Once installed, you can incorporate unsloth into your workflow in a very simple manner; instead of loading <code>AutoModelForCausalLM</code>, you just need to load a <code>FastLanguageModel</code> as follows:',kl,ve,Fl,Ce,So='The saved model is fully compatible with Hugging Face’s transformers library. Learn more about unsloth in their <a href="https://github.com/unslothai/unsloth" rel="nofollow">official repository</a>.',$l,Ie,xl,ke,zo='<a href="https://github.com/linkedin/Liger-Kernel" rel="nofollow">Liger Kernel</a> is a collection of Triton kernels designed specifically for LLM training. It can effectively increase multi-GPU training throughput by 20% and reduces memory usage by 60%. That way, we can <strong>4x</strong> our context length, as described in the benchmark below. They have implemented Hugging Face Compatible <code>RMSNorm</code>, <code>RoPE</code>, <code>SwiGLU</code>, <code>CrossEntropy</code>, <code>FusedLinearCrossEntropy</code>, and more to come. The kernel works out of the box with <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">Flash Attention</a>, <a href="https://pytorch.org/tutorials/intermediate/FSDP_tutorial.html" rel="nofollow">PyTorch FSDP</a>, and <a href="https://github.com/microsoft/DeepSpeed" rel="nofollow">Microsoft DeepSpeed</a>.',Gl,Fe,Qo="With great memory reduction, you can potentially turn off cpu_offloading or gradient checkpointing to further boost the performance.",Zl,$e,Vo='<thead><tr><th>Speed Up</th> <th>Memory Reduction</th></tr></thead> <tbody><tr><td><img src="https://raw.githubusercontent.com/linkedin/Liger-Kernel/main/docs/images/e2e-tps.png" alt="Speed up"/></td> <td><img src="https://raw.githubusercontent.com/linkedin/Liger-Kernel/main/docs/images/e2e-memory.png" alt="Memory"/></td></tr></tbody>',Bl,xe,Ho="<li>To use Liger-Kernel in <code>SFTTrainer</code>, first install by</li>",Nl,Ge,ql,F,Lo='<li>Once installed, set <code>use_liger</code> in <a href="/docs/trl/v0.13.0/en/sft_trainer#trl.SFTConfig">SFTConfig</a>. No other changes are needed!</li>',Rl,Ze,Al,Be,Yo='To learn more about Liger-Kernel, visit their <a href="https://github.com/linkedin/Liger-Kernel/" rel="nofollow">official repository</a>.',Xl,Ne,El,qe,Do="Pay attention to the following best practices when training a model with that trainer:",Wl,Re,Po='<li><a href="/docs/trl/v0.13.0/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> always pads by default the sequences to the <code>max_seq_length</code> argument of the <a href="/docs/trl/v0.13.0/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a>. If none is passed, the trainer will retrieve that value from the tokenizer. Some tokenizers do not provide a default value, so there is a check to retrieve the minimum between 2048 and that value. Make sure to check it before training.</li> <li>For training adapters in 8bit, you might need to tweak the arguments of the <code>prepare_model_for_kbit_training</code> method from PEFT, hence we advise users to use <code>prepare_in_int8_kwargs</code> field, or create the <code>PeftModel</code> outside the <a href="/docs/trl/v0.13.0/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> and pass it.</li> <li>For a more memory-efficient training using adapters, you can load the base model in 8bit, for that simply add <code>load_in_8bit</code> argument when creating the <a href="/docs/trl/v0.13.0/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a>, or create a base model in 8bit outside the trainer and pass it.</li> <li>If you create a model outside the trainer, make sure to not pass to the trainer any additional keyword arguments that are relative to <code>from_pretrained()</code> method.</li>',Sl,Ae,zl,Xe,Oo='Trainer (and thus SFTTrainer) supports multi-GPU training. If you run your script with <code>python script.py</code> it will default to using DP as the strategy, which may be <a href="https://github.com/huggingface/trl/issues/1303" rel="nofollow">slower than expected</a>. To use DDP (which is generally recommended, see <a href="https://huggingface.co/docs/transformers/en/perf_train_gpu_many?select-gpu=Accelerate#data-parallelism" rel="nofollow">here</a> for more info) you must launch the script with <code>python -m torch.distributed.launch script.py</code> or <code>accelerate launch script.py</code>. For DDP to work you must also check the following:',Ql,Ee,Ko='<li>If you’re using gradient_checkpointing, add the following to the TrainingArguments: <code>gradient_checkpointing_kwargs={&#39;use_reentrant&#39;:False}</code> (more info <a href="https://github.com/huggingface/transformers/issues/26969" rel="nofollow">here</a></li> <li>Ensure that the model is placed on the correct device:</li>',Vl,We,Hl,Se,Ll,ze,ti="You may experience some issues with GPTQ Quantization after completing training. Lowering <code>gradient_accumulation_steps</code> to <code>4</code> will resolve most issues during the quantization process to GPTQ format.",Yl,Qe,Dl,Ve,ei='<code>SFTTrainer</code> does not inherently support vision-language data. However, we provide a guide on how to tweak the trainer to support vision-language data. Specifically, you need to use a custom data collator that is compatible with vision-language data. This guide outlines the steps to make these adjustments. For a concrete example, refer to the script <a href="https://github.com/huggingface/trl/blob/main/examples/scripts/sft_vlm.py" rel="nofollow"><code>examples/scripts/sft_vlm.py</code></a> which demonstrates how to fine-tune the LLaVA 1.5 model on the <a href="https://huggingface.co/datasets/HuggingFaceH4/llava-instruct-mix-vsft" rel="nofollow">HuggingFaceH4/llava-instruct-mix-vsft</a> dataset.',Pl,He,Ol,Le,ai="The data format is flexible, provided it is compatible with the custom collator that we will define later. A common approach is to use conversational data. Given that the data includes both text and images, the format needs to be adjusted accordingly. Below is an example of a conversational data format involving both text and images:",Kl,Ye,ts,De,ni="To illustrate how this data format will be processed using the LLaVA model, you can use the following code:",es,Pe,as,Oe,li="The output will be formatted as follows:",ns,Ke,ls,U,si,ss,ta,os,ea,oi="Unlike the default behavior of <code>SFTTrainer</code>, processing multi-modal data is done on the fly during the data collation process. To do this, you need to define a custom collator that processes both the text and images. This collator must take a list of examples as input (see the previous section for an example of the data format) and return a batch of processed data. Below is an example of such a collator:",is,aa,rs,na,ii="We can verify that the collator works as expected by running the following code:",ps,la,ds,sa,cs,oa,ri="Now that we have prepared the data and defined the collator, we can proceed with training the model. To ensure that the data is not processed as text-only, we need to set a couple of arguments in the <code>SFTConfig</code>, specifically <code>remove_unused_columns</code> and <code>skip_prepare_dataset</code> to <code>True</code> to avoid the default processing of the dataset. Below is an example of how to set up the <code>SFTTrainer</code>.",ms,ia,us,ra,pi='A full example of training LLaVa 1.5 on the <a href="https://huggingface.co/datasets/HuggingFaceH4/llava-instruct-mix-vsft" rel="nofollow">HuggingFaceH4/llava-instruct-mix-vsft</a> dataset can be found in the script <a href="https://github.com/huggingface/trl/blob/main/examples/scripts/sft_vlm.py" rel="nofollow"><code>examples/scripts/sft_vlm.py</code></a>.',hs,pa,di='<li><a href="https://wandb.ai/huggingface/trl/runs/2b2c5l7s" rel="nofollow">Experiment tracking</a></li> <li><a href="https://huggingface.co/HuggingFaceH4/sft-llava-1.5-7b-hf" rel="nofollow">Trained model</a></li>',Ms,da,ys,J,ca,$s,Ua,ci=`Class definition of the Supervised Finetuning Trainer (SFT Trainer).
This class is a wrapper around the <code>transformers.Trainer</code> class and inherits all of its attributes and methods.
The trainer takes care of properly initializing the PeftModel in case a user passes a <code>PeftConfig</code> object.`,xs,$,ma,Gs,ja,mi="Creates a draft of a model card using the information available to the <code>Trainer</code>.",fs,ua,gs,b,ha,Zs,va,ui='Configuration class for the <a href="/docs/trl/v0.13.0/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a>.',Bs,Ca,hi=`Using <a href="https://huggingface.co/docs/transformers/v4.47.0/en/internal/trainer_utils#transformers.HfArgumentParser" rel="nofollow">HfArgumentParser</a> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,Ts,Ma,ws,ya,Mi="In the SFTTrainer we smartly support <code>datasets.IterableDataset</code> in addition to other style datasets. This is useful if you are using large corpora that you do not want to save all to disk. The data will be tokenized and processed on the fly, even when packing is enabled.",_s,fa,yi="Additionally, in the SFTTrainer, we support pre-tokenized datasets if they are <code>datasets.Dataset</code> or <code>datasets.IterableDataset</code>. In other words, if such a dataset has a column of <code>input_ids</code>, no further processing (tokenization or packing) will be done, and the dataset will be used as-is. This can be useful if you have pretokenized your dataset outside of this script and want to re-use it directly.",Js,ga,bs,j,Ta,Ns,Ia,fi=`Iterable dataset that returns constant length chunks of tokens from stream of text files.
The dataset also formats the text before tokenization with a specific format that is provided
by the user.`,Us,wa,js,$a,vs;return Z=new y({props:{title:"Supervised Fine-tuning Trainer",local:"supervised-fine-tuning-trainer",headingTag:"h1"}}),R=new y({props:{title:"Quickstart",local:"quickstart",headingTag:"h2"}}),X=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVENvbmZpZyUyQyUyMFNGVFRyYWluZXIlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMnN0YW5mb3JkbmxwJTJGaW1kYiUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMFNGVENvbmZpZyglMEElMjAlMjAlMjAlMjBtYXhfc2VxX2xlbmd0aCUzRDUxMiUyQyUwQSUyMCUyMCUyMCUyMG91dHB1dF9kaXIlM0QlMjIlMkZ0bXAlMjIlMkMlMEEpJTBBdHJhaW5lciUyMCUzRCUyMFNGVFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEEpJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig, SFTTrainer

dataset = load_dataset(<span class="hljs-string">&quot;stanfordnlp/imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

training_args = SFTConfig(
    max_seq_length=<span class="hljs-number">512</span>,
    output_dir=<span class="hljs-string">&quot;/tmp&quot;</span>,
)
trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    args=training_args,
)
trainer.train()`,wrap:!1}}),S=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVENvbmZpZyUyQyUyMFNGVFRyYWluZXIlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMnN0YW5mb3JkbmxwJTJGaW1kYiUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEElMEF0cmFpbmluZ19hcmdzJTIwJTNEJTIwU0ZUQ29uZmlnKG91dHB1dF9kaXIlM0QlMjIlMkZ0bXAlMjIpJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNGVFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBKSUwQSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig, SFTTrainer

dataset = load_dataset(<span class="hljs-string">&quot;stanfordnlp/imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

training_args = SFTConfig(output_dir=<span class="hljs-string">&quot;/tmp&quot;</span>)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    args=training_args,
)

trainer.train()`,wrap:!1}}),Q=new y({props:{title:"Advanced usage",local:"advanced-usage",headingTag:"h2"}}),V=new y({props:{title:"Train on completions only",local:"train-on-completions-only",headingTag:"h3"}}),L=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBTRlRDb25maWclMkMlMjBTRlRUcmFpbmVyJTJDJTIwRGF0YUNvbGxhdG9yRm9yQ29tcGxldGlvbk9ubHlMTSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIybHVjYXNtY2NhYmUtbG1pJTJGQ29kZUFscGFjYS0yMGslMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEElMEFkZWYlMjBmb3JtYXR0aW5nX3Byb21wdHNfZnVuYyhleGFtcGxlKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dF90ZXh0cyUyMCUzRCUyMCU1QiU1RCUwQSUyMCUyMCUyMCUyMGZvciUyMGklMjBpbiUyMHJhbmdlKGxlbihleGFtcGxlJTVCJ2luc3RydWN0aW9uJyU1RCkpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGV4dCUyMCUzRCUyMGYlMjIlMjMlMjMlMjMlMjBRdWVzdGlvbiUzQSUyMCU3QmV4YW1wbGUlNUInaW5zdHJ1Y3Rpb24nJTVEJTVCaSU1RCU3RCU1Q24lMjAlMjMlMjMlMjMlMjBBbnN3ZXIlM0ElMjAlN0JleGFtcGxlJTVCJ291dHB1dCclNUQlNUJpJTVEJTdEJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0X3RleHRzLmFwcGVuZCh0ZXh0KSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG91dHB1dF90ZXh0cyUwQSUwQXJlc3BvbnNlX3RlbXBsYXRlJTIwJTNEJTIwJTIyJTIwJTIzJTIzJTIzJTIwQW5zd2VyJTNBJTIyJTBBY29sbGF0b3IlMjAlM0QlMjBEYXRhQ29sbGF0b3JGb3JDb21wbGV0aW9uT25seUxNKHJlc3BvbnNlX3RlbXBsYXRlJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBTRlRUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGRhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEU0ZUQ29uZmlnKG91dHB1dF9kaXIlM0QlMjIlMkZ0bXAlMjIpJTJDJTBBJTIwJTIwJTIwJTIwZm9ybWF0dGluZ19mdW5jJTNEZm9ybWF0dGluZ19wcm9tcHRzX2Z1bmMlMkMlMEElMjAlMjAlMjAlMjBkYXRhX2NvbGxhdG9yJTNEY29sbGF0b3IlMkMlMEEpJTBBJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig, SFTTrainer, DataCollatorForCompletionOnlyLM

dataset = load_dataset(<span class="hljs-string">&quot;lucasmccabe-lmi/CodeAlpaca-20k&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">formatting_prompts_func</span>(<span class="hljs-params">example</span>):
    output_texts = []
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(example[<span class="hljs-string">&#x27;instruction&#x27;</span>])):
        text = <span class="hljs-string">f&quot;### Question: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;instruction&#x27;</span>][i]}</span>\\n ### Answer: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;output&#x27;</span>][i]}</span>&quot;</span>
        output_texts.append(text)
    <span class="hljs-keyword">return</span> output_texts

response_template = <span class="hljs-string">&quot; ### Answer:&quot;</span>
collator = DataCollatorForCompletionOnlyLM(response_template, tokenizer=tokenizer)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    args=SFTConfig(output_dir=<span class="hljs-string">&quot;/tmp&quot;</span>),
    formatting_func=formatting_prompts_func,
    data_collator=collator,
)

trainer.train()`,wrap:!1}}),D=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBTRlRDb25maWclMkMlMjBTRlRUcmFpbmVyJTJDJTIwRGF0YUNvbGxhdG9yRm9yQ29tcGxldGlvbk9ubHlMTSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIydGltZGV0dG1lcnMlMkZvcGVuYXNzaXN0YW50LWd1YW5hY28lMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEElMEFpbnN0cnVjdGlvbl90ZW1wbGF0ZSUyMCUzRCUyMCUyMiUyMyUyMyUyMyUyMEh1bWFuJTNBJTIyJTBBcmVzcG9uc2VfdGVtcGxhdGUlMjAlM0QlMjAlMjIlMjMlMjMlMjMlMjBBc3Npc3RhbnQlM0ElMjIlMEFjb2xsYXRvciUyMCUzRCUyMERhdGFDb2xsYXRvckZvckNvbXBsZXRpb25Pbmx5TE0oaW5zdHJ1Y3Rpb25fdGVtcGxhdGUlM0RpbnN0cnVjdGlvbl90ZW1wbGF0ZSUyQyUyMHJlc3BvbnNlX3RlbXBsYXRlJTNEcmVzcG9uc2VfdGVtcGxhdGUlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMjBtbG0lM0RGYWxzZSklMEElMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0RTRlRDb25maWcob3V0cHV0X2RpciUzRCUyMiUyRnRtcCUyMiklMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0Rjb2xsYXRvciUyQyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig, SFTTrainer, DataCollatorForCompletionOnlyLM

dataset = load_dataset(<span class="hljs-string">&quot;timdettmers/openassistant-guanaco&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

instruction_template = <span class="hljs-string">&quot;### Human:&quot;</span>
response_template = <span class="hljs-string">&quot;### Assistant:&quot;</span>
collator = DataCollatorForCompletionOnlyLM(instruction_template=instruction_template, response_template=response_template, tokenizer=tokenizer, mlm=<span class="hljs-literal">False</span>)

trainer = SFTTrainer(
    model,
    args=SFTConfig(output_dir=<span class="hljs-string">&quot;/tmp&quot;</span>),
    train_dataset=dataset,
    data_collator=collator,
)

trainer.train()`,wrap:!1}}),O=new y({props:{title:"Using token_ids directly for response_template",local:"using-tokenids-directly-for-responsetemplate",headingTag:"h4"}}),tt=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03Yi1oZiUyMiklMEElMEFkZWYlMjBwcmludF90b2tlbnNfd2l0aF9pZHModHh0KSUzQSUwQSUyMCUyMCUyMCUyMHRva2VucyUyMCUzRCUyMHRva2VuaXplci50b2tlbml6ZSh0eHQlMkMlMjBhZGRfc3BlY2lhbF90b2tlbnMlM0RGYWxzZSklMEElMjAlMjAlMjAlMjB0b2tlbl9pZHMlMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKHR4dCUyQyUyMGFkZF9zcGVjaWFsX3Rva2VucyUzREZhbHNlKSUwQSUyMCUyMCUyMCUyMHByaW50KGxpc3QoemlwKHRva2VucyUyQyUyMHRva2VuX2lkcykpKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMiUyMiUyMiUyMyUyMyUyMyUyMFVzZXIlM0ElMjBIZWxsbyU1Q24lNUNuJTIzJTIzJTIzJTIwQXNzaXN0YW50JTNBJTIwSGklMkMlMjBob3clMjBjYW4lMjBJJTIwaGVscCUyMHlvdSUzRiUyMiUyMiUyMiUwQXByaW50X3Rva2Vuc193aXRoX2lkcyhwcm9tcHQpJTIwJTIwJTIzJTIwJTVCLi4uJTJDJTIwKCclRTIlOTYlODFIZWxsbyclMkMlMjAxNTA0MyklMkMlMjAoJyUzQzB4MEElM0UnJTJDJTIwMTMpJTJDJTIwKCclM0MweDBBJTNFJyUyQyUyMDEzKSUyQyUyMCgnJTIzJTIzJyUyQyUyMDIyNzcpJTJDJTIwKCclMjMnJTJDJTIwMjk5MzcpJTJDJTIwKCclRTIlOTYlODFBc3MnJTJDJTIwNDAwNyklMkMlMjAoJ2lzdGFudCclMkMlMjAyMjEzNyklMkMlMjAoJyUzQSclMkMlMjAyOTkwMSklMkMlMjAuLi4lNUQlMEElMEFyZXNwb25zZV90ZW1wbGF0ZSUyMCUzRCUyMCUyMiUyMyUyMyUyMyUyMEFzc2lzdGFudCUzQSUyMiUwQXByaW50X3Rva2Vuc193aXRoX2lkcyhyZXNwb25zZV90ZW1wbGF0ZSklMjAlMjAlMjMlMjAlNUIoJyVFMiU5NiU4MSUyMyUyMyUyMyclMkMlMjA4MzUpJTJDJTIwKCclRTIlOTYlODFBc3MnJTJDJTIwNDAwNyklMkMlMjAoJ2lzdGFudCclMkMlMjAyMjEzNyklMkMlMjAoJyUzQSclMkMlMjAyOTkwMSklNUQ=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-hf&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">print_tokens_with_ids</span>(<span class="hljs-params">txt</span>):
    tokens = tokenizer.tokenize(txt, add_special_tokens=<span class="hljs-literal">False</span>)
    token_ids = tokenizer.encode(txt, add_special_tokens=<span class="hljs-literal">False</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-built_in">list</span>(<span class="hljs-built_in">zip</span>(tokens, token_ids)))

prompt = <span class="hljs-string">&quot;&quot;&quot;### User: Hello\\n\\n### Assistant: Hi, how can I help you?&quot;&quot;&quot;</span>
print_tokens_with_ids(prompt)  <span class="hljs-comment"># [..., (&#x27;▁Hello&#x27;, 15043), (&#x27;&lt;0x0A&gt;&#x27;, 13), (&#x27;&lt;0x0A&gt;&#x27;, 13), (&#x27;##&#x27;, 2277), (&#x27;#&#x27;, 29937), (&#x27;▁Ass&#x27;, 4007), (&#x27;istant&#x27;, 22137), (&#x27;:&#x27;, 29901), ...]</span>

response_template = <span class="hljs-string">&quot;### Assistant:&quot;</span>
print_tokens_with_ids(response_template)  <span class="hljs-comment"># [(&#x27;▁###&#x27;, 835), (&#x27;▁Ass&#x27;, 4007), (&#x27;istant&#x27;, 22137), (&#x27;:&#x27;, 29901)]</span>`,wrap:!1}}),lt=new M({props:{code:"UnVudGltZUVycm9yJTNBJTIwQ291bGQlMjBub3QlMjBmaW5kJTIwcmVzcG9uc2UlMjBrZXklMjAlNUI4MzUlMkMlMjA0MDA3JTJDJTIwMjIxMzclMkMlMjAyOTkwMSU1RCUyMGluJTIwdG9rZW4lMjBJRHMlMjB0ZW5zb3IoJTVCJTIwJTIwJTIwJTIwMSUyQyUyMCUyMCUyMDgzNSUyQyUyMCUyMC4uLiU1RCk=",highlighted:'RuntimeError: Could not find response key <span class="hljs-selector-attr">[835, 4007, 22137, 29901]</span> <span class="hljs-keyword">in</span> token IDs <span class="hljs-built_in">tensor</span>(<span class="hljs-selector-attr">[    1,   835,  ...]</span>)',wrap:!1}}),ot=new M({props:{code:"cmVzcG9uc2VfdGVtcGxhdGVfd2l0aF9jb250ZXh0JTIwJTNEJTIwJTIyJTVDbiUyMyUyMyUyMyUyMEFzc2lzdGFudCUzQSUyMiUyMCUyMCUyMyUyMFdlJTIwYWRkZWQlMjBjb250ZXh0JTIwaGVyZSUzQSUyMCUyMiU1Q24lMjIuJTIwVGhpcyUyMGlzJTIwZW5vdWdoJTIwZm9yJTIwdGhpcyUyMHRva2VuaXplciUwQXJlc3BvbnNlX3RlbXBsYXRlX2lkcyUyMCUzRCUyMHRva2VuaXplci5lbmNvZGUocmVzcG9uc2VfdGVtcGxhdGVfd2l0aF9jb250ZXh0JTJDJTIwYWRkX3NwZWNpYWxfdG9rZW5zJTNERmFsc2UpJTVCMiUzQSU1RCUyMCUyMCUyMyUyME5vdyUyMHdlJTIwaGF2ZSUyMGl0JTIwbGlrZSUyMGluJTIwdGhlJTIwZGF0YXNldCUyMHRleHRzJTNBJTIwJTYwJTVCMjI3NyUyQyUyMDI5OTM3JTJDJTIwNDAwNyUyQyUyMDIyMTM3JTJDJTIwMjk5MDElNUQlNjAlMEElMEFkYXRhX2NvbGxhdG9yJTIwJTNEJTIwRGF0YUNvbGxhdG9yRm9yQ29tcGxldGlvbk9ubHlMTShyZXNwb25zZV90ZW1wbGF0ZV9pZHMlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`response_template_with_context = <span class="hljs-string">&quot;\\n### Assistant:&quot;</span>  <span class="hljs-comment"># We added context here: &quot;\\n&quot;. This is enough for this tokenizer</span>
response_template_ids = tokenizer.encode(response_template_with_context, add_special_tokens=<span class="hljs-literal">False</span>)[<span class="hljs-number">2</span>:]  <span class="hljs-comment"># Now we have it like in the dataset texts: \`[2277, 29937, 4007, 22137, 29901]\`</span>

data_collator = DataCollatorForCompletionOnlyLM(response_template_ids, tokenizer=tokenizer)`,wrap:!1}}),it=new y({props:{title:"Add Special Tokens for Chat Format",local:"add-special-tokens-for-chat-format",headingTag:"h3"}}),dt=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBzZXR1cF9jaGF0X2Zvcm1hdCUwQSUwQSUyMyUyMExvYWQlMjBtb2RlbCUyMGFuZCUyMHRva2VuaXplciUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEElMEElMjMlMjBTZXQlMjB1cCUyMHRoZSUyMGNoYXQlMjBmb3JtYXQlMjB3aXRoJTIwZGVmYXVsdCUyMCdjaGF0bWwnJTIwZm9ybWF0JTBBbW9kZWwlMkMlMjB0b2tlbml6ZXIlMjAlM0QlMjBzZXR1cF9jaGF0X2Zvcm1hdChtb2RlbCUyQyUyMHRva2VuaXplciklMEE=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> setup_chat_format

<span class="hljs-comment"># Load model and tokenizer</span>
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

<span class="hljs-comment"># Set up the chat format with default &#x27;chatml&#x27; format</span>
model, tokenizer = setup_chat_format(model, tokenizer)
`,wrap:!1}}),mt=new y({props:{title:"Dataset format support",local:"dataset-format-support",headingTag:"h3"}}),Mt=new M({props:{code:"JTdCJTIybWVzc2FnZXMlMjIlM0ElMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGhlbHBmdWwlMjIlN0QlMkMlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0J3MlMjB0aGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlM0YlMjIlN0QlMkMlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMi4uLiUyMiU3RCU1RCU3RCUwQSU3QiUyMm1lc3NhZ2VzJTIyJTNBJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBoZWxwZnVsJTIyJTdEJTJDJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hvJTIwd3JvdGUlMjAnUm9tZW8lMjBhbmQlMjBKdWxpZXQnJTNGJTIyJTdEJTJDJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjIuLi4lMjIlN0QlNUQlN0QlMEElN0IlMjJtZXNzYWdlcyUyMiUzQSUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwaGVscGZ1bCUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhvdyUyMGZhciUyMGlzJTIwdGhlJTIwTW9vbiUyMGZyb20lMjBFYXJ0aCUzRiUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyLi4uJTIyJTdEJTVEJTdE",highlighted:`<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;messages&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;system&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;You are helpful&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;user&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;What&#x27;s the capital of France?&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;assistant&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;...&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;messages&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;system&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;You are helpful&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;user&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Who wrote &#x27;Romeo and Juliet&#x27;?&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;assistant&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;...&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;messages&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;system&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;You are helpful&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;user&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;How far is the Moon from Earth?&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;assistant&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;...&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">}</span>`,wrap:!1}}),ft=new M({props:{code:"JTdCJTIycHJvbXB0JTIyJTNBJTIwJTIyJTNDcHJvbXB0JTIwdGV4dCUzRSUyMiUyQyUyMCUyMmNvbXBsZXRpb24lMjIlM0ElMjAlMjIlM0NpZGVhbCUyMGdlbmVyYXRlZCUyMHRleHQlM0UlMjIlN0QlMEElN0IlMjJwcm9tcHQlMjIlM0ElMjAlMjIlM0Nwcm9tcHQlMjB0ZXh0JTNFJTIyJTJDJTIwJTIyY29tcGxldGlvbiUyMiUzQSUyMCUyMiUzQ2lkZWFsJTIwZ2VuZXJhdGVkJTIwdGV4dCUzRSUyMiU3RCUwQSU3QiUyMnByb21wdCUyMiUzQSUyMCUyMiUzQ3Byb21wdCUyMHRleHQlM0UlMjIlMkMlMjAlMjJjb21wbGV0aW9uJTIyJTNBJTIwJTIyJTNDaWRlYWwlMjBnZW5lcmF0ZWQlMjB0ZXh0JTNFJTIyJTdE",highlighted:`<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;prompt&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;prompt text&gt;&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;completion&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;ideal generated text&gt;&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;prompt&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;prompt text&gt;&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;completion&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;ideal generated text&gt;&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;prompt&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;prompt text&gt;&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;completion&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;ideal generated text&gt;&quot;</span><span class="hljs-punctuation">}</span>`,wrap:!1}}),Tt=new M({props:{code:"JTBBJTBBJTBB",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig, SFTTrainer

...

<span class="hljs-comment"># load jsonl dataset</span>
dataset = load_dataset(<span class="hljs-string">&quot;json&quot;</span>, data_files=<span class="hljs-string">&quot;path/to/dataset.jsonl&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-comment"># load dataset from the HuggingFace Hub</span>
dataset = load_dataset(<span class="hljs-string">&quot;philschmid/dolly-15k-oai-style&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

...

training_args = SFTConfig(packing=<span class="hljs-literal">True</span>)
trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    args=training_args,
    train_dataset=dataset,
)`,wrap:!1}}),_t=new y({props:{title:"Format your input prompts",local:"format-your-input-prompts",headingTag:"h3"}}),bt=new M({props:{code:"QmVsb3clMjBpcyUyMGFuJTIwaW5zdHJ1Y3Rpb24lMjAuLi4lMEElMEElMjMlMjMlMjMlMjBJbnN0cnVjdGlvbiUwQSU3QnByb21wdCU3RCUwQSUwQSUyMyUyMyUyMyUyMFJlc3BvbnNlJTNBJTBBJTdCY29tcGxldGlvbiU3RA==",highlighted:`Below is an instruction ...

<span class="hljs-comment">### Instruction</span>
{prompt}

<span class="hljs-comment">### Response:</span>
{completion}`,wrap:!1}}),jt=new M({props:{code:"JTBB",highlighted:`...
<span class="hljs-keyword">def</span> <span class="hljs-title function_">formatting_prompts_func</span>(<span class="hljs-params">example</span>):
    output_texts = []
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(example[<span class="hljs-string">&#x27;question&#x27;</span>])):
        text = <span class="hljs-string">f&quot;### Question: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;question&#x27;</span>][i]}</span>\\n ### Answer: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;answer&#x27;</span>][i]}</span>&quot;</span>
        output_texts.append(text)
    <span class="hljs-keyword">return</span> output_texts

trainer = SFTTrainer(
    model,
    args=training_args,
    train_dataset=dataset,
    formatting_func=formatting_prompts_func,
)

trainer.train()`,wrap:!1}}),Ct=new y({props:{title:"Packing dataset ( ConstantLengthDataset )",local:"packing-dataset--constantlengthdataset-",headingTag:"h3"}}),kt=new M({props:{code:"JTBB",highlighted:`...
training_args = SFTConfig(packing=<span class="hljs-literal">True</span>)

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    args=training_args
)

trainer.train()`,wrap:!1}}),$t=new y({props:{title:"Customize your prompts using packed dataset",local:"customize-your-prompts-using-packed-dataset",headingTag:"h4"}}),Gt=new M({props:{code:"ZGVmJTIwZm9ybWF0dGluZ19mdW5jKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwdGV4dCUyMCUzRCUyMGYlMjIlMjMlMjMlMjMlMjBRdWVzdGlvbiUzQSUyMCU3QmV4YW1wbGUlNUIncXVlc3Rpb24nJTVEJTdEJTVDbiUyMCUyMyUyMyUyMyUyMEFuc3dlciUzQSUyMCU3QmV4YW1wbGUlNUInYW5zd2VyJyU1RCU3RCUyMiUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRleHQlMEElMEF0cmFpbmluZ19hcmdzJTIwJTNEJTIwU0ZUQ29uZmlnKHBhY2tpbmclM0RUcnVlKSUwQXRyYWluZXIlMjAlM0QlMjBTRlRUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwZm9ybWF0dGluZ19mdW5jJTNEZm9ybWF0dGluZ19mdW5jJTBBKSUwQSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">formatting_func</span>(<span class="hljs-params">example</span>):
    text = <span class="hljs-string">f&quot;### Question: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;question&#x27;</span>]}</span>\\n ### Answer: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;answer&#x27;</span>]}</span>&quot;</span>
    <span class="hljs-keyword">return</span> text

training_args = SFTConfig(packing=<span class="hljs-literal">True</span>)
trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    args=training_args,
    formatting_func=formatting_func
)

trainer.train()`,wrap:!1}}),Bt=new y({props:{title:"Control over the pretrained model",local:"control-over-the-pretrained-model",headingTag:"h3"}}),qt=new M({props:{code:"JTBBJTBB",highlighted:`model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>, torch_dtype=torch.bfloat16)

...

training_args = SFTConfig(
    model_init_kwargs={
        <span class="hljs-string">&quot;torch_dtype&quot;</span>: <span class="hljs-string">&quot;bfloat16&quot;</span>,
    },
    output_dir=<span class="hljs-string">&quot;/tmp&quot;</span>,
)
trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    args=training_args,
)

trainer.train()`,wrap:!1}}),At=new y({props:{title:"Training adapters",local:"training-adapters",headingTag:"h3"}}),Et=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVENvbmZpZyUyQyUyMFNGVFRyYWluZXIlMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMExvcmFDb25maWclMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMnRybC1saWIlMkZDYXB5YmFyYSUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0QzMiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfZHJvcG91dCUzRDAuMDUlMkMlMEElMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCUyMmFsbC1saW5lYXIlMjIlMkMlMEElMjAlMjAlMjAlMjBtb2R1bGVzX3RvX3NhdmUlM0QlNUIlMjJsbV9oZWFkJTIyJTJDJTIwJTIyZW1iZWRfdG9rZW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjB0YXNrX3R5cGUlM0QlMjJDQVVTQUxfTE0lMjIlMkMlMEEpJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNGVFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwJTIyUXdlbiUyRlF3ZW4yLjUtMC41QiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRFNGVENvbmZpZyhvdXRwdXRfZGlyJTNEJTIyUXdlbjIuNS0wLjVCLVNGVCUyMiklMkMlMEElMjAlMjAlMjAlMjBwZWZ0X2NvbmZpZyUzRHBlZnRfY29uZmlnJTBBKSUwQSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig, SFTTrainer
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

dataset = load_dataset(<span class="hljs-string">&quot;trl-lib/Capybara&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

peft_config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    target_modules=<span class="hljs-string">&quot;all-linear&quot;</span>,
    modules_to_save=[<span class="hljs-string">&quot;lm_head&quot;</span>, <span class="hljs-string">&quot;embed_token&quot;</span>],
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

trainer = SFTTrainer(
    <span class="hljs-string">&quot;Qwen/Qwen2.5-0.5B&quot;</span>,
    train_dataset=dataset,
    args=SFTConfig(output_dir=<span class="hljs-string">&quot;Qwen2.5-0.5B-SFT&quot;</span>),
    peft_config=peft_config
)

trainer.train()`,wrap:!1}}),C=new vi({props:{warning:!0,$$slots:{default:[Ii]},$$scope:{ctx:Ga}}}),St=new y({props:{title:"Training adapters with base 8 bit models",local:"training-adapters-with-base-8-bit-models",headingTag:"h3"}}),Qt=new M({props:{code:"JTBBJTBBJTBB",highlighted:`...

peft_config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;EleutherAI/gpt-neo-125m&quot;</span>,
    load_in_8bit=<span class="hljs-literal">True</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    args=SFTConfig(),
    peft_config=peft_config,
)

trainer.train()`,wrap:!1}}),Vt=new y({props:{title:"Using Flash Attention and Flash Attention 2",local:"using-flash-attention-and-flash-attention-2",headingTag:"h2"}}),Lt=new M({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZ2l0JTJCaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZ0cmFuc2Zvcm1lcnMuZ2l0",highlighted:"pip install -U git+https://github.com/huggingface/transformers.git",wrap:!1}}),Dt=new y({props:{title:"Using Flash-Attention 1",local:"using-flash-attention-1",headingTag:"h3"}}),Ot=new M({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwb3B0aW11bQ==",highlighted:"pip install -U optimum",wrap:!1}}),te=new M({props:{code:"",highlighted:`...

<span class="hljs-addition">+ with torch.backends.cuda.sdp_kernel(enable_flash=True, enable_math=False, enable_mem_efficient=False):</span>
    trainer.train()`,wrap:!1}}),le=new y({props:{title:"Using Flash Attention-2",local:"using-flash-attention-2",headingTag:"h3"}}),oe=new M({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZmxhc2gtYXR0bg==",highlighted:"pip install -U flash-attn",wrap:!1}}),re=new M({props:{code:"bW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRCUyMmZsYXNoX2F0dGVudGlvbl8yJTIyJTBBKQ==",highlighted:`model = AutoModelForCausalLM.from_pretrained(
    model_id,
    load_in_4bit=<span class="hljs-literal">True</span>,
    attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>
)`,wrap:!1}}),ce=new y({props:{title:"Using model creation utility",local:"trl.ModelConfig",headingTag:"h3"}}),ue=new xa({props:{name:"class trl.ModelConfig",anchor:"trl.ModelConfig",parameters:[{name:"model_name_or_path",val:": typing.Optional[str] = None"},{name:"model_revision",val:": str = 'main'"},{name:"torch_dtype",val:": typing.Optional[typing.Literal['auto', 'bfloat16', 'float16', 'float32']] = None"},{name:"trust_remote_code",val:": bool = False"},{name:"attn_implementation",val:": typing.Optional[str] = None"},{name:"use_peft",val:": bool = False"},{name:"lora_r",val:": int = 16"},{name:"lora_alpha",val:": int = 32"},{name:"lora_dropout",val:": float = 0.05"},{name:"lora_target_modules",val:": typing.Optional[list[str]] = None"},{name:"lora_modules_to_save",val:": typing.Optional[list[str]] = None"},{name:"lora_task_type",val:": str = 'CAUSAL_LM'"},{name:"use_rslora",val:": bool = False"},{name:"load_in_8bit",val:": bool = False"},{name:"load_in_4bit",val:": bool = False"},{name:"bnb_4bit_quant_type",val:": typing.Literal['fp4', 'nf4'] = 'nf4'"},{name:"use_bnb_nested_quant",val:": bool = False"}],parametersDescription:[{anchor:"trl.ModelConfig.model_name_or_path",description:`<strong>model_name_or_path</strong> (<code>Optional[str]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Model checkpoint for weights initialization.`,name:"model_name_or_path"},{anchor:"trl.ModelConfig.model_revision",description:`<strong>model_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
Specific model version to use. It can be a branch name, a tag name, or a commit id.`,name:"model_revision"},{anchor:"trl.ModelConfig.torch_dtype",description:`<strong>torch_dtype</strong> (<code>Optional[Literal[&quot;auto&quot;, &quot;bfloat16&quot;, &quot;float16&quot;, &quot;float32&quot;]]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Override the default <code>torch.dtype</code> and load the model under this dtype. Possible values are</p>
<ul>
<li><code>&quot;bfloat16&quot;</code>: <code>torch.bfloat16</code></li>
<li><code>&quot;float16&quot;</code>: <code>torch.float16</code></li>
<li><code>&quot;float32&quot;</code>: <code>torch.float32</code></li>
<li><code>&quot;auto&quot;</code>: Automatically derive the dtype from the model&#x2019;s weights.</li>
</ul>`,name:"torch_dtype"},{anchor:"trl.ModelConfig.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to allow for custom models defined on the Hub in their own modeling files. This option should only
be set to <code>True</code> for repositories you trust and in which you have read the code, as it will execute code
present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"trl.ModelConfig.attn_implementation",description:`<strong>attn_implementation</strong> (<code>Optional[str]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Which attention implementation to use. You can run <code>--attn_implementation=flash_attention_2</code>, in which case
you must install this manually by running <code>pip install flash-attn --no-build-isolation</code>.`,name:"attn_implementation"},{anchor:"trl.ModelConfig.use_peft",description:`<strong>use_peft</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use PEFT for training.`,name:"use_peft"},{anchor:"trl.ModelConfig.lora_r",description:`<strong>lora_r</strong> (<code>int</code>, <em>optional</em>, defaults to <code>16</code>) &#x2014;
LoRA R value.`,name:"lora_r"},{anchor:"trl.ModelConfig.lora_alpha",description:`<strong>lora_alpha</strong> (<code>int</code>, <em>optional</em>, defaults to <code>32</code>) &#x2014;
LoRA alpha.`,name:"lora_alpha"},{anchor:"trl.ModelConfig.lora_dropout",description:`<strong>lora_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.05</code>) &#x2014;
LoRA dropout.`,name:"lora_dropout"},{anchor:"trl.ModelConfig.lora_target_modules",description:`<strong>lora_target_modules</strong> (<code>Optional[Union[str, list[str]]]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
LoRA target modules.`,name:"lora_target_modules"},{anchor:"trl.ModelConfig.lora_modules_to_save",description:`<strong>lora_modules_to_save</strong> (<code>Optional[list[str]]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Model layers to unfreeze &amp; train.`,name:"lora_modules_to_save"},{anchor:"trl.ModelConfig.lora_task_type",description:`<strong>lora_task_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;CAUSAL_LM&quot;</code>) &#x2014;
Task type to pass for LoRA (use <code>&quot;SEQ_CLS&quot;</code> for reward modeling).`,name:"lora_task_type"},{anchor:"trl.ModelConfig.use_rslora",description:`<strong>use_rslora</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use Rank-Stabilized LoRA, which sets the adapter scaling factor to <code>lora_alpha/&#x221A;r</code>, instead of
the original default value of <code>lora_alpha/r</code>.`,name:"use_rslora"},{anchor:"trl.ModelConfig.load_in_8bit",description:`<strong>load_in_8bit</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use 8 bit precision for the base model. Works only with LoRA.`,name:"load_in_8bit"},{anchor:"trl.ModelConfig.load_in_4bit",description:`<strong>load_in_4bit</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use 4 bit precision for the base model. Works only with LoRA.`,name:"load_in_4bit"},{anchor:"trl.ModelConfig.bnb_4bit_quant_type",description:`<strong>bnb_4bit_quant_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;nf4&quot;</code>) &#x2014;
Quantization type (<code>&quot;fp4&quot;</code> or <code>&quot;nf4&quot;</code>).`,name:"bnb_4bit_quant_type"},{anchor:"trl.ModelConfig.use_bnb_nested_quant",description:`<strong>use_bnb_nested_quant</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use nested quantization.`,name:"use_bnb_nested_quant"}],source:"https://github.com/huggingface/trl/blob/v0.13.0/trl/trainer/model_config.py#L19"}}),he=new M({props:{code:"ZnJvbSUyMHRybCUyMGltcG9ydCUyME1vZGVsQ29uZmlnJTJDJTIwU0ZUVHJhaW5lciUyQyUyMGdldF9rYml0X2RldmljZV9tYXAlMkMlMjBnZXRfcGVmdF9jb25maWclMkMlMjBnZXRfcXVhbnRpemF0aW9uX2NvbmZpZyUwQW1vZGVsX2FyZ3MlMjAlM0QlMjBNb2RlbENvbmZpZyglMEElMjAlMjAlMjAlMjBtb2RlbF9uYW1lX29yX3BhdGglM0QlMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyJTBBJTIwJTIwJTIwJTIwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRE5vbmUlMkMlMjAlMjMlMjBvciUyMCUyMmZsYXNoX2F0dGVudGlvbl8yJTIyJTBBKSUwQXRvcmNoX2R0eXBlJTIwJTNEJTIwKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2FyZ3MudG9yY2hfZHR5cGUlMEElMjAlMjAlMjAlMjBpZiUyMG1vZGVsX2FyZ3MudG9yY2hfZHR5cGUlMjBpbiUyMCU1QiUyMmF1dG8lMjIlMkMlMjBOb25lJTVEJTBBJTIwJTIwJTIwJTIwZWxzZSUyMGdldGF0dHIodG9yY2glMkMlMjBtb2RlbF9hcmdzLnRvcmNoX2R0eXBlKSUwQSklMEFxdWFudGl6YXRpb25fY29uZmlnJTIwJTNEJTIwZ2V0X3F1YW50aXphdGlvbl9jb25maWcobW9kZWxfYXJncyklMEFtb2RlbF9rd2FyZ3MlMjAlM0QlMjBkaWN0KCUwQSUyMCUyMCUyMCUyMHJldmlzaW9uJTNEbW9kZWxfYXJncy5tb2RlbF9yZXZpc2lvbiUyQyUwQSUyMCUyMCUyMCUyMHRydXN0X3JlbW90ZV9jb2RlJTNEbW9kZWxfYXJncy50cnVzdF9yZW1vdGVfY29kZSUyQyUwQSUyMCUyMCUyMCUyMGF0dG5faW1wbGVtZW50YXRpb24lM0Rtb2RlbF9hcmdzLmF0dG5faW1wbGVtZW50YXRpb24lMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoX2R0eXBlJTJDJTBBJTIwJTIwJTIwJTIwdXNlX2NhY2hlJTNERmFsc2UlMjBpZiUyMHRyYWluaW5nX2FyZ3MuZ3JhZGllbnRfY2hlY2twb2ludGluZyUyMGVsc2UlMjBUcnVlJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRGdldF9rYml0X2RldmljZV9tYXAoKSUyMGlmJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUyMGlzJTIwbm90JTIwTm9uZSUyMGVsc2UlMjBOb25lJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50aXphdGlvbl9jb25maWclMkMlMEEpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfYXJncy5tb2RlbF9uYW1lX29yX3BhdGglMkMlMjAqKm1vZGVsX2t3YXJncyklMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjAuLi4lMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsX2FyZ3MubW9kZWxfbmFtZV9vcl9wYXRoJTJDJTBBJTIwJTIwJTIwJTIwcGVmdF9jb25maWclM0RnZXRfcGVmdF9jb25maWcobW9kZWxfYXJncyklMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> ModelConfig, SFTTrainer, get_kbit_device_map, get_peft_config, get_quantization_config
model_args = ModelConfig(
    model_name_or_path=<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>
    attn_implementation=<span class="hljs-literal">None</span>, <span class="hljs-comment"># or &quot;flash_attention_2&quot;</span>
)
torch_dtype = (
    model_args.torch_dtype
    <span class="hljs-keyword">if</span> model_args.torch_dtype <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;auto&quot;</span>, <span class="hljs-literal">None</span>]
    <span class="hljs-keyword">else</span> <span class="hljs-built_in">getattr</span>(torch, model_args.torch_dtype)
)
quantization_config = get_quantization_config(model_args)
model_kwargs = <span class="hljs-built_in">dict</span>(
    revision=model_args.model_revision,
    trust_remote_code=model_args.trust_remote_code,
    attn_implementation=model_args.attn_implementation,
    torch_dtype=torch_dtype,
    use_cache=<span class="hljs-literal">False</span> <span class="hljs-keyword">if</span> training_args.gradient_checkpointing <span class="hljs-keyword">else</span> <span class="hljs-literal">True</span>,
    device_map=get_kbit_device_map() <span class="hljs-keyword">if</span> quantization_config <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>,
    quantization_config=quantization_config,
)
model = AutoModelForCausalLM.from_pretrained(model_args.model_name_or_path, **model_kwargs)
trainer = SFTTrainer(
    ...,
    model=model_args.model_name_or_path,
    peft_config=get_peft_config(model_args),
)`,wrap:!1}}),Me=new y({props:{title:"Enhance the model’s performances using NEFTune",local:"enhance-the-models-performances-using-neftune",headingTag:"h3"}}),Te=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVENvbmZpZyUyQyUyMFNGVFRyYWluZXIlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMnN0YW5mb3JkbmxwJTJGaW1kYiUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMFNGVENvbmZpZyglMEElMjAlMjAlMjAlMjBuZWZ0dW5lX25vaXNlX2FscGhhJTNENSUyQyUwQSklMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjAlMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGRhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyUyQyUwQSklMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig, SFTTrainer

dataset = load_dataset(<span class="hljs-string">&quot;stanfordnlp/imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

training_args = SFTConfig(
    neftune_noise_alpha=<span class="hljs-number">5</span>,
)
trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    args=training_args,
)
trainer.train()`,wrap:!1}}),Je=new y({props:{title:"Accelerate fine-tuning 2x using unsloth",local:"accelerate-fine-tuning-2x-using-unsloth",headingTag:"h3"}}),ve=new M({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig, SFTTrainer
<span class="hljs-keyword">from</span> unsloth <span class="hljs-keyword">import</span> FastLanguageModel

max_seq_length = <span class="hljs-number">2048</span> <span class="hljs-comment"># Supports automatic RoPE Scaling, so choose any number</span>

<span class="hljs-comment"># Load model</span>
model, tokenizer = FastLanguageModel.from_pretrained(
    model_name=<span class="hljs-string">&quot;unsloth/mistral-7b&quot;</span>,
    max_seq_length=max_seq_length,
    dtype=<span class="hljs-literal">None</span>,  <span class="hljs-comment"># None for auto detection. Float16 for Tesla T4, V100, Bfloat16 for Ampere+</span>
    load_in_4bit=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Use 4bit quantization to reduce memory usage. Can be False</span>
    <span class="hljs-comment"># token = &quot;hf_...&quot;, # use one if using gated models like meta-llama/Llama-2-7b-hf</span>
)

<span class="hljs-comment"># Do model patching and add fast LoRA weights</span>
model = FastLanguageModel.get_peft_model(
    model,
    r=<span class="hljs-number">16</span>,
    target_modules=[
        <span class="hljs-string">&quot;q_proj&quot;</span>,
        <span class="hljs-string">&quot;k_proj&quot;</span>,
        <span class="hljs-string">&quot;v_proj&quot;</span>,
        <span class="hljs-string">&quot;o_proj&quot;</span>,
        <span class="hljs-string">&quot;gate_proj&quot;</span>,
        <span class="hljs-string">&quot;up_proj&quot;</span>,
        <span class="hljs-string">&quot;down_proj&quot;</span>,
    ],
    lora_alpha=<span class="hljs-number">16</span>,
    lora_dropout=<span class="hljs-number">0</span>,  <span class="hljs-comment"># Dropout = 0 is currently optimized</span>
    bias=<span class="hljs-string">&quot;none&quot;</span>,  <span class="hljs-comment"># Bias = &quot;none&quot; is currently optimized</span>
    use_gradient_checkpointing=<span class="hljs-literal">True</span>,
    random_state=<span class="hljs-number">3407</span>,
)

training_args = SFTConfig(output_dir=<span class="hljs-string">&quot;./output&quot;</span>, max_seq_length=max_seq_length)

trainer = SFTTrainer(
    model=model,
    args=training_args,
    train_dataset=dataset,
)
trainer.train()`,wrap:!1}}),Ie=new y({props:{title:"Liger-Kernel: Increase 20% throughput and reduces 60% memory for multi-GPU training",local:"liger-kernel-increase-20-throughput-and-reduces-60-memory-for-multi-gpu-training",headingTag:"h2"}}),Ge=new M({props:{code:"cGlwJTIwaW5zdGFsbCUyMGxpZ2VyLWtlcm5lbA==",highlighted:"pip install liger-kernel",wrap:!1}}),Ze=new M({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFNGVENvbmZpZyglMEElMjAlMjB1c2VfbGlnZXIlM0RUcnVlJTBBKQ==",highlighted:`training_args = SFTConfig(
  use_liger=<span class="hljs-literal">True</span>
)`,wrap:!1}}),Ne=new y({props:{title:"Best practices",local:"best-practices",headingTag:"h2"}}),Ae=new y({props:{title:"Multi-GPU Training",local:"multi-gpu-training",headingTag:"h2"}}),We=new M({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBQYXJ0aWFsU3RhdGUlMEFkZXZpY2Vfc3RyaW5nJTIwJTNEJTIwUGFydGlhbFN0YXRlKCkucHJvY2Vzc19pbmRleCUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlN0InJyUzQWRldmljZV9zdHJpbmclN0QlMEEp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> PartialState
device_string = PartialState().process_index
model = AutoModelForCausalLM.from_pretrained(
     ...
    device_map={<span class="hljs-string">&#x27;&#x27;</span>:device_string}
)`,wrap:!1}}),Se=new y({props:{title:"GPTQ Conversion",local:"gptq-conversion",headingTag:"h2"}}),Qe=new y({props:{title:"Extending SFTTrainer for Vision Language Models",local:"extending-sfttrainer-for-vision-language-models",headingTag:"h2"}}),He=new y({props:{title:"Preparing the Data",local:"preparing-the-data",headingTag:"h3"}}),Ye=new M({props:{code:"aW1hZ2VzJTIwJTNEJTIwJTVCJTIyb2JhbWEucG5nJTIyJTVEJTBBbWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIydGV4dCUyMiUyQyUyMCUyMnRleHQlMjIlM0ElMjAlMjJXaG8lMjBpcyUyMHRoaXMlM0YlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIyaW1hZ2UlMjIlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJ0ZXh0JTIyJTJDJTIwJTIydGV4dCUyMiUzQSUyMCUyMkJhcmFjayUyME9iYW1hJTIyJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIydHlwZSUyMiUzQSUyMCUyMnRleHQlMjIlMkMlMjAlMjJ0ZXh0JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwaGUlMjBmYW1vdXMlMjBmb3IlM0YlMjIlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJ0ZXh0JTIyJTJDJTIwJTIydGV4dCUyMiUzQSUyMCUyMkhlJTIwaXMlMjB0aGUlMjA0NHRoJTIwUHJlc2lkZW50JTIwb2YlMjB0aGUlMjBVbml0ZWQlMjBTdGF0ZXMuJTIyJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTVE",highlighted:`images = [<span class="hljs-string">&quot;obama.png&quot;</span>]
messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Who is this?&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>}
        ]
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Barack Obama&quot;</span>}
        ]
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What is he famous for?&quot;</span>}
        ]
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;He is the 44th President of the United States.&quot;</span>}
        ]
    }
]`,wrap:!1}}),Pe=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJsbGF2YS1oZiUyRmxsYXZhLTEuNS03Yi1oZiUyMiklMEFwcmludChwcm9jZXNzb3IuYXBwbHlfY2hhdF90ZW1wbGF0ZShtZXNzYWdlcyUyQyUyMHRva2VuaXplJTNERmFsc2UpKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-1.5-7b-hf&quot;</span>)
<span class="hljs-built_in">print</span>(processor.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>))`,wrap:!1}}),Ke=new M({props:{code:"V2hvJTIwaXMlMjB0aGlzJTNGJTIwQVNTSVNUQU5UJTNBJTIwQmFyYWNrJTIwT2JhbWElMjBVU0VSJTNBJTIwV2hhdCUyMGlzJTIwaGUlMjBmYW1vdXMlMjBmb3IlM0YlMjBBU1NJU1RBTlQlM0ElMjBIZSUyMGlzJTIwdGhlJTIwNDR0aCUyMFByZXNpZGVudCUyMG9mJTIwdGhlJTIwVW5pdGVkJTIwU3RhdGVzLiUyMA==",highlighted:"Who is this? ASSISTANT: Barack Obama USER: What is he famous for? ASSISTANT: He is the 44th President of the United States. ",wrap:!1}}),ta=new y({props:{title:"A custom collator for processing multi-modal data",local:"a-custom-collator-for-processing-multi-modal-data",headingTag:"h3"}}),aa=new M({props:{code:"ZGVmJTIwY29sbGF0ZV9mbihleGFtcGxlcyklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBHZXQlMjB0aGUlMjB0ZXh0cyUyMGFuZCUyMGltYWdlcyUyQyUyMGFuZCUyMGFwcGx5JTIwdGhlJTIwY2hhdCUyMHRlbXBsYXRlJTBBJTIwJTIwJTIwJTIwdGV4dHMlMjAlM0QlMjAlNUJwcm9jZXNzb3IuYXBwbHlfY2hhdF90ZW1wbGF0ZShleGFtcGxlJTVCJTIybWVzc2FnZXMlMjIlNUQlMkMlMjB0b2tlbml6ZSUzREZhbHNlKSUyMGZvciUyMGV4YW1wbGUlMjBpbiUyMGV4YW1wbGVzJTVEJTBBJTIwJTIwJTIwJTIwaW1hZ2VzJTIwJTNEJTIwJTVCZXhhbXBsZSU1QiUyMmltYWdlcyUyMiU1RCU1QjAlNUQlMjBmb3IlMjBleGFtcGxlJTIwaW4lMjBleGFtcGxlcyU1RCUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFRva2VuaXplJTIwdGhlJTIwdGV4dHMlMjBhbmQlMjBwcm9jZXNzJTIwdGhlJTIwaW1hZ2VzJTBBJTIwJTIwJTIwJTIwYmF0Y2glMjAlM0QlMjBwcm9jZXNzb3IodGV4dHMlMkMlMjBpbWFnZXMlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwcGFkZGluZyUzRFRydWUpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwVGhlJTIwbGFiZWxzJTIwYXJlJTIwdGhlJTIwaW5wdXRfaWRzJTJDJTIwYW5kJTIwd2UlMjBtYXNrJTIwdGhlJTIwcGFkZGluZyUyMHRva2VucyUyMGluJTIwdGhlJTIwbG9zcyUyMGNvbXB1dGF0aW9uJTBBJTIwJTIwJTIwJTIwbGFiZWxzJTIwJTNEJTIwYmF0Y2glNUIlMjJpbnB1dF9pZHMlMjIlNUQuY2xvbmUoKSUwQSUyMCUyMCUyMCUyMGxhYmVscyU1QmxhYmVscyUyMCUzRCUzRCUyMHByb2Nlc3Nvci50b2tlbml6ZXIucGFkX3Rva2VuX2lkJTVEJTIwJTNEJTIwLTEwMCUwQSUyMCUyMCUyMCUyMGJhdGNoJTVCJTIybGFiZWxzJTIyJTVEJTIwJTNEJTIwbGFiZWxzJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYmF0Y2g=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">collate_fn</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-comment"># Get the texts and images, and apply the chat template</span>
    texts = [processor.apply_chat_template(example[<span class="hljs-string">&quot;messages&quot;</span>], tokenize=<span class="hljs-literal">False</span>) <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> examples]
    images = [example[<span class="hljs-string">&quot;images&quot;</span>][<span class="hljs-number">0</span>] <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> examples]

    <span class="hljs-comment"># Tokenize the texts and process the images</span>
    batch = processor(texts, images, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>)

    <span class="hljs-comment"># The labels are the input_ids, and we mask the padding tokens in the loss computation</span>
    labels = batch[<span class="hljs-string">&quot;input_ids&quot;</span>].clone()
    labels[labels == processor.tokenizer.pad_token_id] = -<span class="hljs-number">100</span>
    batch[<span class="hljs-string">&quot;labels&quot;</span>] = labels

    <span class="hljs-keyword">return</span> batch`,wrap:!1}}),la=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJIdWdnaW5nRmFjZUg0JTJGbGxhdmEtaW5zdHJ1Y3QtbWl4LXZzZnQlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQWV4YW1wbGVzJTIwJTNEJTIwJTVCZGF0YXNldCU1QjAlNUQlMkMlMjBkYXRhc2V0JTVCMSU1RCU1RCUyMCUyMCUyMyUyMEp1c3QlMjB0d28lMjBleGFtcGxlcyUyMGZvciUyMHRoZSUyMHNha2UlMjBvZiUyMHRoZSUyMGV4YW1wbGUlMEFjb2xsYXRlZF9kYXRhJTIwJTNEJTIwY29sbGF0ZV9mbihleGFtcGxlcyklMEFwcmludChjb2xsYXRlZF9kYXRhLmtleXMoKSklMjAlMjAlMjMlMjBkaWN0X2tleXMoJTVCJ2lucHV0X2lkcyclMkMlMjAnYXR0ZW50aW9uX21hc2snJTJDJTIwJ3BpeGVsX3ZhbHVlcyclMkMlMjAnbGFiZWxzJyU1RCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(<span class="hljs-string">&quot;HuggingFaceH4/llava-instruct-mix-vsft&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
examples = [dataset[<span class="hljs-number">0</span>], dataset[<span class="hljs-number">1</span>]]  <span class="hljs-comment"># Just two examples for the sake of the example</span>
collated_data = collate_fn(examples)
<span class="hljs-built_in">print</span>(collated_data.keys())  <span class="hljs-comment"># dict_keys([&#x27;input_ids&#x27;, &#x27;attention_mask&#x27;, &#x27;pixel_values&#x27;, &#x27;labels&#x27;])</span>`,wrap:!1}}),sa=new y({props:{title:"Training the vision-language model",local:"training-the-vision-language-model",headingTag:"h3"}}),ia=new M({props:{code:"dHJhaW5pbmdfYXJncy5yZW1vdmVfdW51c2VkX2NvbHVtbnMlMjAlM0QlMjBGYWxzZSUwQXRyYWluaW5nX2FyZ3MuZGF0YXNldF9rd2FyZ3MlMjAlM0QlMjAlN0IlMjJza2lwX3ByZXBhcmVfZGF0YXNldCUyMiUzQSUyMFRydWUlN0QlMEElMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjBkYXRhX2NvbGxhdG9yJTNEY29sbGF0ZV9mbiUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0R0cmFpbl9kYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwcHJvY2Vzc2luZ19jbGFzcyUzRHByb2Nlc3Nvci50b2tlbml6ZXIlMkMlMEEp",highlighted:`training_args.remove_unused_columns = <span class="hljs-literal">False</span>
training_args.dataset_kwargs = {<span class="hljs-string">&quot;skip_prepare_dataset&quot;</span>: <span class="hljs-literal">True</span>}

trainer = SFTTrainer(
    model=model,
    args=training_args,
    data_collator=collate_fn,
    train_dataset=train_dataset,
    processing_class=processor.tokenizer,
)`,wrap:!1}}),da=new y({props:{title:"SFTTrainer",local:"trl.SFTTrainer",headingTag:"h2"}}),ca=new xa({props:{name:"class trl.SFTTrainer",anchor:"trl.SFTTrainer",parameters:[{name:"model",val:": typing.Union[transformers.modeling_utils.PreTrainedModel, torch.nn.modules.module.Module, str, NoneType] = None"},{name:"args",val:": typing.Optional[trl.trainer.sft_config.SFTConfig] = None"},{name:"data_collator",val:": typing.Optional[transformers.data.data_collator.DataCollator] = None"},{name:"train_dataset",val:": typing.Optional[datasets.arrow_dataset.Dataset] = None"},{name:"eval_dataset",val:": typing.Union[datasets.arrow_dataset.Dataset, dict[str, datasets.arrow_dataset.Dataset], NoneType] = None"},{name:"processing_class",val:": typing.Union[transformers.tokenization_utils_base.PreTrainedTokenizerBase, transformers.image_processing_utils.BaseImageProcessor, transformers.feature_extraction_utils.FeatureExtractionMixin, transformers.processing_utils.ProcessorMixin, NoneType] = None"},{name:"model_init",val:": typing.Optional[typing.Callable[[], transformers.modeling_utils.PreTrainedModel]] = None"},{name:"compute_metrics",val:": typing.Optional[typing.Callable[[transformers.trainer_utils.EvalPrediction], dict]] = None"},{name:"callbacks",val:": typing.Optional[list[transformers.trainer_callback.TrainerCallback]] = None"},{name:"optimizers",val:": tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": typing.Optional[typing.Callable[[torch.Tensor, torch.Tensor], torch.Tensor]] = None"},{name:"peft_config",val:": typing.Optional[ForwardRef('PeftConfig')] = None"},{name:"formatting_func",val:": typing.Optional[typing.Callable] = None"}],parametersDescription:[{anchor:"trl.SFTTrainer.model",description:`<strong>model</strong> (Union[<code>transformers.PreTrainedModel</code>, <code>nn.Module</code>, <code>str</code>]) &#x2014;
The model to train, can be a <code>PreTrainedModel</code>, a <code>torch.nn.Module</code> or a string with the model name to
load from cache or download. The model can be also converted to a <code>PeftModel</code> if a <code>PeftConfig</code> object is
passed to the <code>peft_config</code> argument.`,name:"model"},{anchor:"trl.SFTTrainer.args",description:`<strong>args</strong> (<code>Optional[SFTConfig]</code>) &#x2014;
The arguments to tweak for training. Will default to a basic instance of <a href="/docs/trl/v0.13.0/en/sft_trainer#trl.SFTConfig">SFTConfig</a> with the <code>output_dir</code>
set to a directory named <em>tmp_trainer</em> in the current directory if not provided.`,name:"args"},{anchor:"trl.SFTTrainer.data_collator",description:`<strong>data_collator</strong> (<code>Optional[transformers.DataCollator]</code>) &#x2014;
The data collator to use for training.`,name:"data_collator"},{anchor:"trl.SFTTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>Optional[datasets.Dataset]</code>) &#x2014;
The dataset to use for training. We recommend users to use <code>trl.trainer.ConstantLengthDataset</code> to create their dataset.`,name:"train_dataset"},{anchor:"trl.SFTTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (Optional[Union[<code>datasets.Dataset</code>, dict[<code>str</code>, <code>datasets.Dataset</code>]]]) &#x2014;
The dataset to use for evaluation. We recommend users to use <code>trl.trainer.ConstantLengthDataset</code> to create their dataset.`,name:"eval_dataset"},{anchor:"trl.SFTTrainer.processing_class",description:`<strong>processing_class</strong> (<code>PreTrainedTokenizerBase</code> or <code>BaseImageProcessor</code> or <code>FeatureExtractionMixin</code> or <code>ProcessorMixin</code>, <em>optional</em>) &#x2014;
Processing class used to process the data. If provided, will be used to automatically process the inputs
for the model, and it will be saved along the model to make it easier to rerun an interrupted training or
reuse the fine-tuned model.
This supercedes the <code>tokenizer</code> argument, which is now deprecated.`,name:"processing_class"},{anchor:"trl.SFTTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.SFTTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[transformers.EvalPrediction], dict]</code>, <em>optional</em> defaults to None) &#x2014;
The function used to compute metrics during evaluation. It should return a dictionary mapping metric names to metric values.
If not specified, only the loss will be computed during evaluation.`,name:"compute_metrics"},{anchor:"trl.SFTTrainer.callbacks",description:`<strong>callbacks</strong> (<code>list[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.SFTTrainer.optimizers",description:`<strong>optimizers</strong> (<code>tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.SFTTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.SFTTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Optional[PeftConfig]</code>) &#x2014;
The PeftConfig object to use to initialize the PeftModel.`,name:"peft_config"},{anchor:"trl.SFTTrainer.formatting_func",description:`<strong>formatting_func</strong> (<code>Optional[Callable]</code>) &#x2014;
The formatting function to be used for creating the <code>ConstantLengthDataset</code>.`,name:"formatting_func"}],source:"https://github.com/huggingface/trl/blob/v0.13.0/trl/trainer/sft_trainer.py#L67"}}),ma=new xa({props:{name:"create_model_card",anchor:"trl.SFTTrainer.create_model_card",parameters:[{name:"model_name",val:": typing.Optional[str] = None"},{name:"dataset_name",val:": typing.Optional[str] = None"},{name:"tags",val:": typing.Union[str, list[str], NoneType] = None"}],parametersDescription:[{anchor:"trl.SFTTrainer.create_model_card.model_name",description:`<strong>model_name</strong> (<code>str</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The name of the model.`,name:"model_name"},{anchor:"trl.SFTTrainer.create_model_card.dataset_name",description:`<strong>dataset_name</strong> (<code>str</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The name of the dataset used for training.`,name:"dataset_name"},{anchor:"trl.SFTTrainer.create_model_card.tags",description:`<strong>tags</strong> (<code>str</code>, <code>list[str]</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Tags to be associated with the model card.`,name:"tags"}],source:"https://github.com/huggingface/trl/blob/v0.13.0/trl/trainer/sft_trainer.py#L505"}}),ua=new y({props:{title:"SFTConfig",local:"trl.SFTConfig",headingTag:"h2"}}),ha=new xa({props:{name:"class trl.SFTConfig",anchor:"trl.SFTConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"eval_strategy",val:": typing.Union[transformers.trainer_utils.IntervalStrategy, str] = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": typing.Optional[int] = None"},{name:"per_gpu_eval_batch_size",val:": typing.Optional[int] = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": typing.Optional[int] = None"},{name:"eval_delay",val:": typing.Optional[float] = 0"},{name:"torch_empty_cache_steps",val:": typing.Optional[int] = None"},{name:"learning_rate",val:": float = 2e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": typing.Union[transformers.trainer_utils.SchedulerType, str] = 'linear'"},{name:"lr_scheduler_kwargs",val:": typing.Union[dict, str, NoneType] = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": typing.Optional[str] = 'passive'"},{name:"log_level_replica",val:": typing.Optional[str] = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": typing.Optional[str] = None"},{name:"logging_strategy",val:": typing.Union[transformers.trainer_utils.IntervalStrategy, str] = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": typing.Union[transformers.trainer_utils.SaveStrategy, str] = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": typing.Optional[int] = None"},{name:"save_safetensors",val:": typing.Optional[bool] = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"restore_callback_states_from_checkpoint",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": typing.Optional[int] = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": typing.Optional[bool] = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": typing.Optional[str] = None"},{name:"tpu_num_cores",val:": typing.Optional[int] = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": typing.Union[str, typing.List[transformers.debug_utils.DebugOption]] = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": typing.Optional[float] = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": typing.Optional[int] = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": typing.Optional[str] = None"},{name:"disable_tqdm",val:": typing.Optional[bool] = None"},{name:"remove_unused_columns",val:": typing.Optional[bool] = True"},{name:"label_names",val:": typing.Optional[typing.List[str]] = None"},{name:"load_best_model_at_end",val:": typing.Optional[bool] = False"},{name:"metric_for_best_model",val:": typing.Optional[str] = None"},{name:"greater_is_better",val:": typing.Optional[bool] = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": typing.Union[typing.List[transformers.trainer_utils.FSDPOption], str, NoneType] = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": typing.Union[dict, str, NoneType] = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": typing.Optional[str] = None"},{name:"accelerator_config",val:": typing.Union[dict, str, NoneType] = None"},{name:"deepspeed",val:": typing.Union[dict, str, NoneType] = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": typing.Union[transformers.training_args.OptimizerNames, str] = 'adamw_torch'"},{name:"optim_args",val:": typing.Optional[str] = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": typing.Optional[str] = 'length'"},{name:"report_to",val:": typing.Union[NoneType, str, typing.List[str]] = None"},{name:"ddp_find_unused_parameters",val:": typing.Optional[bool] = None"},{name:"ddp_bucket_cap_mb",val:": typing.Optional[int] = None"},{name:"ddp_broadcast_buffers",val:": typing.Optional[bool] = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": typing.Optional[str] = None"},{name:"hub_model_id",val:": typing.Optional[str] = None"},{name:"hub_strategy",val:": typing.Union[transformers.trainer_utils.HubStrategy, str] = 'every_save'"},{name:"hub_token",val:": typing.Optional[str] = None"},{name:"hub_private_repo",val:": typing.Optional[bool] = None"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": typing.Union[dict, str, NoneType] = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"include_for_metrics",val:": typing.List[str] = <factory>"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"evaluation_strategy",val:": typing.Union[transformers.trainer_utils.IntervalStrategy, str] = None"},{name:"push_to_hub_model_id",val:": typing.Optional[str] = None"},{name:"push_to_hub_organization",val:": typing.Optional[str] = None"},{name:"push_to_hub_token",val:": typing.Optional[str] = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": typing.Optional[str] = None"},{name:"ray_scope",val:": typing.Optional[str] = 'last'"},{name:"ddp_timeout",val:": typing.Optional[int] = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": typing.Optional[str] = None"},{name:"torch_compile_mode",val:": typing.Optional[str] = None"},{name:"dispatch_batches",val:": typing.Optional[bool] = None"},{name:"split_batches",val:": typing.Optional[bool] = None"},{name:"include_tokens_per_second",val:": typing.Optional[bool] = False"},{name:"include_num_input_tokens_seen",val:": typing.Optional[bool] = False"},{name:"neftune_noise_alpha",val:": typing.Optional[float] = None"},{name:"optim_target_modules",val:": typing.Union[NoneType, str, typing.List[str]] = None"},{name:"batch_eval_metrics",val:": bool = False"},{name:"eval_on_start",val:": bool = False"},{name:"use_liger_kernel",val:": typing.Optional[bool] = False"},{name:"eval_use_gather_object",val:": typing.Optional[bool] = False"},{name:"average_tokens_across_devices",val:": typing.Optional[bool] = False"},{name:"dataset_text_field",val:": str = 'text'"},{name:"packing",val:": bool = False"},{name:"max_seq_length",val:": typing.Optional[int] = None"},{name:"dataset_num_proc",val:": typing.Optional[int] = None"},{name:"dataset_batch_size",val:": int = 1000"},{name:"model_init_kwargs",val:": typing.Optional[dict[str, typing.Any]] = None"},{name:"dataset_kwargs",val:": typing.Optional[dict[str, typing.Any]] = None"},{name:"eval_packing",val:": typing.Optional[bool] = None"},{name:"num_of_sequences",val:": int = 1024"},{name:"chars_per_token",val:": float = 3.6"},{name:"use_liger",val:": bool = False"}],parametersDescription:[{anchor:"trl.SFTConfig.dataset_text_field",description:`<strong>dataset_text_field</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;text&quot;</code>) &#x2014;
Name of the text field of the dataset. If provided, the trainer will automatically create a
<code>ConstantLengthDataset</code> based on <code>dataset_text_field</code>.`,name:"dataset_text_field"},{anchor:"trl.SFTConfig.packing",description:`<strong>packing</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Controls whether the <code>ConstantLengthDataset</code> packs the sequences of the dataset.`,name:"packing"},{anchor:"trl.SFTConfig.learning_rate",description:`<strong>learning_rate</strong> (<code>float</code>, <em>optional</em>, defaults to <code>2e-5</code>) &#x2014;
Initial learning rate for <code>AdamW</code> optimizer. The default value replaces that of <a href="https://huggingface.co/docs/transformers/v4.47.0/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">TrainingArguments</a>.`,name:"learning_rate"},{anchor:"trl.SFTConfig.max_seq_length",description:`<strong>max_seq_length</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Maximum sequence length for the <code>ConstantLengthDataset</code> and for automatically creating the dataset. If
<code>None</code>, it uses the smaller value between <code>tokenizer.model_max_length</code> and <code>1024</code>.`,name:"max_seq_length"},{anchor:"trl.SFTConfig.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Number of processes to use for processing the dataset. Only used when <code>packing=False</code>.`,name:"dataset_num_proc"},{anchor:"trl.SFTConfig.dataset_batch_size",description:`<strong>dataset_batch_size</strong> (<code>Union[int, None]</code>, <em>optional</em>, defaults to <code>1000</code>) &#x2014;
Number of examples to tokenize per batch. If <code>dataset_batch_size &lt;= 0</code> or <code>dataset_batch_size is None</code>,
tokenizes the full dataset as a single batch.`,name:"dataset_batch_size"},{anchor:"trl.SFTConfig.model_init_kwargs",description:`<strong>model_init_kwargs</strong> (<code>Optional[dict[str, Any]]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Keyword arguments to pass to <code>AutoModelForCausalLM.from_pretrained</code> when instantiating the model from a
string.`,name:"model_init_kwargs"},{anchor:"trl.SFTConfig.dataset_kwargs",description:`<strong>dataset_kwargs</strong> (<code>Optional[dict[str, Any]]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Dictionary of optional keyword arguments to pass when creating packed or non-packed datasets.`,name:"dataset_kwargs"},{anchor:"trl.SFTConfig.eval_packing",description:`<strong>eval_packing</strong> (<code>Optional[bool]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Whether to pack the eval dataset. If <code>None</code>, uses the same value as <code>packing</code>.`,name:"eval_packing"},{anchor:"trl.SFTConfig.num_of_sequences",description:`<strong>num_of_sequences</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1024</code>) &#x2014;
Number of sequences to use for the <code>ConstantLengthDataset</code>.`,name:"num_of_sequences"},{anchor:"trl.SFTConfig.chars_per_token",description:`<strong>chars_per_token</strong> (<code>float</code>, <em>optional</em>, defaults to <code>3.6</code>) &#x2014;
Number of characters per token to use for the <code>ConstantLengthDataset</code>. See
<a href="https://github.com/huggingface/trl/blob/08f550674c553c36c51d1027613c29f14f3676a5/examples/stack_llama/scripts/supervised_finetuning.py#L53" rel="nofollow">chars_token_ratio</a> for more details.`,name:"chars_per_token"},{anchor:"trl.SFTConfig.use_liger",description:`<strong>use_liger</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Monkey patch the model with Liger kernels to increase throughput and reduce memory usage.`,name:"use_liger"}],source:"https://github.com/huggingface/trl/blob/v0.13.0/trl/trainer/sft_config.py#L21"}}),Ma=new y({props:{title:"Datasets",local:"datasets",headingTag:"h2"}}),ga=new y({props:{title:"ConstantLengthDataset",local:"trl.trainer.ConstantLengthDataset",headingTag:"h3"}}),Ta=new xa({props:{name:"class trl.trainer.ConstantLengthDataset",anchor:"trl.trainer.ConstantLengthDataset",parameters:[{name:"tokenizer",val:""},{name:"dataset",val:""},{name:"dataset_text_field",val:" = None"},{name:"formatting_func",val:" = None"},{name:"infinite",val:" = False"},{name:"seq_length",val:" = 1024"},{name:"num_of_sequences",val:" = 1024"},{name:"chars_per_token",val:" = 3.6"},{name:"eos_token_id",val:" = 0"},{name:"shuffle",val:" = True"},{name:"append_concat_token",val:" = True"},{name:"add_special_tokens",val:" = True"}],parametersDescription:[{anchor:"trl.trainer.ConstantLengthDataset.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizer</code>) &#x2014;
The processor used for processing the data.`,name:"tokenizer"},{anchor:"trl.trainer.ConstantLengthDataset.dataset",description:`<strong>dataset</strong> (<code>dataset.Dataset</code>) &#x2014;
Dataset with text files.`,name:"dataset"},{anchor:"trl.trainer.ConstantLengthDataset.dataset_text_field",description:`<strong>dataset_text_field</strong> (<code>Optional[str]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Name of the field in the dataset that contains the text. Only one of <code>dataset_text_field</code> and
<code>formatting_func</code> should be provided.`,name:"dataset_text_field"},{anchor:"trl.trainer.ConstantLengthDataset.formatting_func",description:`<strong>formatting_func</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Function that formats the text before tokenization. Usually it is recommended to have follows a certain
pattern such as <code>&quot;### Question: {question} ### Answer: {answer}&quot;</code>. Only one of <code>dataset_text_field</code> and
<code>formatting_func</code> should be provided.`,name:"formatting_func"},{anchor:"trl.trainer.ConstantLengthDataset.infinite",description:`<strong>infinite</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If True the iterator is reset after dataset reaches end else stops.`,name:"infinite"},{anchor:"trl.trainer.ConstantLengthDataset.seq_length",description:`<strong>seq_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1024</code>) &#x2014;
Length of token sequences to return.`,name:"seq_length"},{anchor:"trl.trainer.ConstantLengthDataset.num_of_sequences",description:`<strong>num_of_sequences</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1024</code>) &#x2014;
Number of token sequences to keep in buffer.`,name:"num_of_sequences"},{anchor:"trl.trainer.ConstantLengthDataset.chars_per_token",description:`<strong>chars_per_token</strong> (<code>int</code>, <em>optional</em>, defaults to <code>3.6</code>) &#x2014;
Number of characters per token used to estimate number of tokens in text buffer.`,name:"chars_per_token"},{anchor:"trl.trainer.ConstantLengthDataset.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to <code>0</code>) &#x2014;
Id of the end of sequence token if the passed tokenizer does not have an EOS token.`,name:"eos_token_id"},{anchor:"trl.trainer.ConstantLengthDataset.shuffle",description:`<strong>shuffle</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Shuffle the examples before they are returned`,name:"shuffle"},{anchor:"trl.trainer.ConstantLengthDataset.append_concat_token",description:`<strong>append_concat_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
If true, appends <code>eos_token_id</code> at the end of each sample being packed.`,name:"append_concat_token"},{anchor:"trl.trainer.ConstantLengthDataset.add_special_tokens",description:`<strong>add_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
If true, tokenizers adds special tokens to each sample being packed.`,name:"add_special_tokens"}],source:"https://github.com/huggingface/trl/blob/v0.13.0/trl/trainer/utils.py#L551"}}),wa=new Ci({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/sft_trainer.mdx"}}),{c(){f=o("meta"),G=l(),w=o("p"),_a=l(),p(Z.$$.fragment),Za=l(),B=o("p"),B.innerHTML=qs,Ba=l(),N=o("p"),N.textContent=Rs,Na=l(),q=o("p"),q.innerHTML=As,qa=l(),p(R.$$.fragment),Ra=l(),A=o("p"),A.innerHTML=Xs,Aa=l(),p(X.$$.fragment),Xa=l(),E=o("p"),E.innerHTML=Es,Ea=l(),W=o("p"),W.textContent=Ws,Wa=l(),p(S.$$.fragment),Sa=l(),z=o("p"),z.innerHTML=Ss,za=l(),p(Q.$$.fragment),Qa=l(),p(V.$$.fragment),Va=l(),H=o("p"),H.innerHTML=zs,Ha=l(),p(L.$$.fragment),La=l(),Y=o("p"),Y.innerHTML=Qs,Ya=l(),p(D.$$.fragment),Da=l(),P=o("p"),P.innerHTML=Vs,Pa=l(),p(O.$$.fragment),Oa=l(),K=o("p"),K.innerHTML=Hs,Ka=l(),p(tt.$$.fragment),tn=l(),et=o("p"),et.innerHTML=Ls,en=l(),at=o("ul"),at.innerHTML=Ys,an=l(),nt=o("p"),nt.innerHTML=Ds,nn=l(),p(lt.$$.fragment),ln=l(),st=o("p"),st.innerHTML=Ps,sn=l(),p(ot.$$.fragment),on=l(),p(it.$$.fragment),rn=l(),rt=o("p"),rt.innerHTML=Os,pn=l(),pt=o("ul"),pt.innerHTML=Ks,dn=l(),p(dt.$$.fragment),cn=l(),ct=o("p"),ct.textContent=to,mn=l(),p(mt.$$.fragment),un=l(),ut=o("p"),ut.innerHTML=eo,hn=l(),ht=o("ul"),ht.innerHTML=ao,Mn=l(),p(Mt.$$.fragment),yn=l(),yt=o("ul"),yt.innerHTML=no,fn=l(),p(ft.$$.fragment),gn=l(),gt=o("p"),gt.innerHTML=lo,Tn=l(),p(Tt.$$.fragment),wn=l(),wt=o("p"),wt.textContent=so,_n=l(),p(_t.$$.fragment),Jn=l(),Jt=o("p"),Jt.innerHTML=oo,bn=l(),p(bt.$$.fragment),Un=l(),Ut=o("p"),Ut.innerHTML=io,jn=l(),p(jt.$$.fragment),vn=l(),vt=o("p"),vt.innerHTML=ro,Cn=l(),p(Ct.$$.fragment),In=l(),It=o("p"),It.innerHTML=po,kn=l(),p(kt.$$.fragment),Fn=l(),Ft=o("p"),Ft.innerHTML=co,$n=l(),p($t.$$.fragment),xn=l(),xt=o("p"),xt.innerHTML=mo,Gn=l(),p(Gt.$$.fragment),Zn=l(),Zt=o("p"),Zt.innerHTML=uo,Bn=l(),p(Bt.$$.fragment),Nn=l(),Nt=o("p"),Nt.innerHTML=ho,qn=l(),p(qt.$$.fragment),Rn=l(),Rt=o("p"),Rt.innerHTML=Mo,An=l(),p(At.$$.fragment),Xn=l(),Xt=o("p"),Xt.textContent=yo,En=l(),p(Et.$$.fragment),Wn=l(),p(C.$$.fragment),Sn=l(),Wt=o("p"),Wt.innerHTML=fo,zn=l(),p(St.$$.fragment),Qn=l(),zt=o("p"),zt.innerHTML=go,Vn=l(),p(Qt.$$.fragment),Hn=l(),p(Vt.$$.fragment),Ln=l(),Ht=o("p"),Ht.textContent=To,Yn=l(),p(Lt.$$.fragment),Dn=l(),Yt=o("p"),Yt.textContent=wo,Pn=l(),p(Dt.$$.fragment),On=l(),Pt=o("p"),Pt.innerHTML=_o,Kn=l(),p(Ot.$$.fragment),tl=l(),Kt=o("p"),Kt.innerHTML=Jo,el=l(),p(te.$$.fragment),al=l(),ee=o("p"),ee.innerHTML=bo,nl=l(),ae=o("p"),ae.textContent=Uo,ll=l(),ne=o("table"),ne.innerHTML=jo,sl=l(),p(le.$$.fragment),ol=l(),se=o("p"),se.innerHTML=vo,il=l(),p(oe.$$.fragment),rl=l(),ie=o("p"),ie.innerHTML=Co,pl=l(),p(re.$$.fragment),dl=l(),pe=o("p"),pe.textContent=Io,cl=l(),de=o("p"),de.textContent=ko,ml=l(),p(ce.$$.fragment),ul=l(),me=o("p"),me.textContent=Fo,hl=l(),_=o("div"),p(ue.$$.fragment),ks=l(),Ja=o("p"),Ja.textContent=$o,Fs=l(),ba=o("p"),ba.innerHTML=xo,Ml=l(),p(he.$$.fragment),yl=l(),p(Me.$$.fragment),fl=l(),ye=o("p"),ye.innerHTML=Go,gl=l(),fe=o("blockquote"),fe.innerHTML=Zo,Tl=l(),I=o("div"),I.innerHTML=Bo,wl=l(),ge=o("p"),ge.innerHTML=No,_l=l(),p(Te.$$.fragment),Jl=l(),we=o("p"),we.innerHTML=qo,bl=l(),k=o("div"),k.innerHTML=Ro,Ul=l(),_e=o("p"),_e.innerHTML=Ao,jl=l(),p(Je.$$.fragment),vl=l(),be=o("p"),be.innerHTML=Xo,Cl=l(),Ue=o("table"),Ue.innerHTML=Eo,Il=l(),je=o("p"),je.innerHTML=Wo,kl=l(),p(ve.$$.fragment),Fl=l(),Ce=o("p"),Ce.innerHTML=So,$l=l(),p(Ie.$$.fragment),xl=l(),ke=o("p"),ke.innerHTML=zo,Gl=l(),Fe=o("p"),Fe.textContent=Qo,Zl=l(),$e=o("table"),$e.innerHTML=Vo,Bl=l(),xe=o("ol"),xe.innerHTML=Ho,Nl=l(),p(Ge.$$.fragment),ql=l(),F=o("ol"),F.innerHTML=Lo,Rl=l(),p(Ze.$$.fragment),Al=l(),Be=o("p"),Be.innerHTML=Yo,Xl=l(),p(Ne.$$.fragment),El=l(),qe=o("p"),qe.textContent=Do,Wl=l(),Re=o("ul"),Re.innerHTML=Po,Sl=l(),p(Ae.$$.fragment),zl=l(),Xe=o("p"),Xe.innerHTML=Oo,Ql=l(),Ee=o("ul"),Ee.innerHTML=Ko,Vl=l(),p(We.$$.fragment),Hl=l(),p(Se.$$.fragment),Ll=l(),ze=o("p"),ze.innerHTML=ti,Yl=l(),p(Qe.$$.fragment),Dl=l(),Ve=o("p"),Ve.innerHTML=ei,Pl=l(),p(He.$$.fragment),Ol=l(),Le=o("p"),Le.textContent=ai,Kl=l(),p(Ye.$$.fragment),ts=l(),De=o("p"),De.textContent=ni,es=l(),p(Pe.$$.fragment),as=l(),Oe=o("p"),Oe.textContent=li,ns=l(),p(Ke.$$.fragment),ls=l(),U=o("iframe"),ss=l(),p(ta.$$.fragment),os=l(),ea=o("p"),ea.innerHTML=oi,is=l(),p(aa.$$.fragment),rs=l(),na=o("p"),na.textContent=ii,ps=l(),p(la.$$.fragment),ds=l(),p(sa.$$.fragment),cs=l(),oa=o("p"),oa.innerHTML=ri,ms=l(),p(ia.$$.fragment),us=l(),ra=o("p"),ra.innerHTML=pi,hs=l(),pa=o("ul"),pa.innerHTML=di,Ms=l(),p(da.$$.fragment),ys=l(),J=o("div"),p(ca.$$.fragment),$s=l(),Ua=o("p"),Ua.innerHTML=ci,xs=l(),$=o("div"),p(ma.$$.fragment),Gs=l(),ja=o("p"),ja.innerHTML=mi,fs=l(),p(ua.$$.fragment),gs=l(),b=o("div"),p(ha.$$.fragment),Zs=l(),va=o("p"),va.innerHTML=ui,Bs=l(),Ca=o("p"),Ca.innerHTML=hi,Ts=l(),p(Ma.$$.fragment),ws=l(),ya=o("p"),ya.innerHTML=Mi,_s=l(),fa=o("p"),fa.innerHTML=yi,Js=l(),p(ga.$$.fragment),bs=l(),j=o("div"),p(Ta.$$.fragment),Ns=l(),Ia=o("p"),Ia.textContent=fi,Us=l(),p(wa.$$.fragment),js=l(),$a=o("p"),this.h()},l(t){const e=ji("svelte-u9bgzb",document.head);f=i(e,"META",{name:!0,content:!0}),e.forEach(a),G=s(t),w=i(t,"P",{}),x(w).forEach(a),_a=s(t),d(Z.$$.fragment,t),Za=s(t),B=i(t,"P",{"data-svelte-h":!0}),r(B)!=="svelte-3qdiva"&&(B.innerHTML=qs),Ba=s(t),N=i(t,"P",{"data-svelte-h":!0}),r(N)!=="svelte-o839x3"&&(N.textContent=Rs),Na=s(t),q=i(t,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1s4xj87"&&(q.innerHTML=As),qa=s(t),d(R.$$.fragment,t),Ra=s(t),A=i(t,"P",{"data-svelte-h":!0}),r(A)!=="svelte-mfqz7r"&&(A.innerHTML=Xs),Aa=s(t),d(X.$$.fragment,t),Xa=s(t),E=i(t,"P",{"data-svelte-h":!0}),r(E)!=="svelte-4l7u4"&&(E.innerHTML=Es),Ea=s(t),W=i(t,"P",{"data-svelte-h":!0}),r(W)!=="svelte-ulikv8"&&(W.textContent=Ws),Wa=s(t),d(S.$$.fragment,t),Sa=s(t),z=i(t,"P",{"data-svelte-h":!0}),r(z)!=="svelte-jb3jkc"&&(z.innerHTML=Ss),za=s(t),d(Q.$$.fragment,t),Qa=s(t),d(V.$$.fragment,t),Va=s(t),H=i(t,"P",{"data-svelte-h":!0}),r(H)!=="svelte-13sbeoj"&&(H.innerHTML=zs),Ha=s(t),d(L.$$.fragment,t),La=s(t),Y=i(t,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1a743rp"&&(Y.innerHTML=Qs),Ya=s(t),d(D.$$.fragment,t),Da=s(t),P=i(t,"P",{"data-svelte-h":!0}),r(P)!=="svelte-rjhq4r"&&(P.innerHTML=Vs),Pa=s(t),d(O.$$.fragment,t),Oa=s(t),K=i(t,"P",{"data-svelte-h":!0}),r(K)!=="svelte-12zdtxn"&&(K.innerHTML=Hs),Ka=s(t),d(tt.$$.fragment,t),tn=s(t),et=i(t,"P",{"data-svelte-h":!0}),r(et)!=="svelte-xlwe87"&&(et.innerHTML=Ls),en=s(t),at=i(t,"UL",{"data-svelte-h":!0}),r(at)!=="svelte-1enki0k"&&(at.innerHTML=Ys),an=s(t),nt=i(t,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-14yxh0m"&&(nt.innerHTML=Ds),nn=s(t),d(lt.$$.fragment,t),ln=s(t),st=i(t,"P",{"data-svelte-h":!0}),r(st)!=="svelte-hvnyie"&&(st.innerHTML=Ps),sn=s(t),d(ot.$$.fragment,t),on=s(t),d(it.$$.fragment,t),rn=s(t),rt=i(t,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-1ccg0zx"&&(rt.innerHTML=Os),pn=s(t),pt=i(t,"UL",{"data-svelte-h":!0}),r(pt)!=="svelte-ebt5re"&&(pt.innerHTML=Ks),dn=s(t),d(dt.$$.fragment,t),cn=s(t),ct=i(t,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-1hmfl2q"&&(ct.textContent=to),mn=s(t),d(mt.$$.fragment,t),un=s(t),ut=i(t,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-dqneti"&&(ut.innerHTML=eo),hn=s(t),ht=i(t,"UL",{"data-svelte-h":!0}),r(ht)!=="svelte-5iwuvk"&&(ht.innerHTML=ao),Mn=s(t),d(Mt.$$.fragment,t),yn=s(t),yt=i(t,"UL",{"data-svelte-h":!0}),r(yt)!=="svelte-23l1e6"&&(yt.innerHTML=no),fn=s(t),d(ft.$$.fragment,t),gn=s(t),gt=i(t,"P",{"data-svelte-h":!0}),r(gt)!=="svelte-1fi1i82"&&(gt.innerHTML=lo),Tn=s(t),d(Tt.$$.fragment,t),wn=s(t),wt=i(t,"P",{"data-svelte-h":!0}),r(wt)!=="svelte-145h0zs"&&(wt.textContent=so),_n=s(t),d(_t.$$.fragment,t),Jn=s(t),Jt=i(t,"P",{"data-svelte-h":!0}),r(Jt)!=="svelte-cqsf2h"&&(Jt.innerHTML=oo),bn=s(t),d(bt.$$.fragment,t),Un=s(t),Ut=i(t,"P",{"data-svelte-h":!0}),r(Ut)!=="svelte-l25vq0"&&(Ut.innerHTML=io),jn=s(t),d(jt.$$.fragment,t),vn=s(t),vt=i(t,"P",{"data-svelte-h":!0}),r(vt)!=="svelte-j2xlt3"&&(vt.innerHTML=ro),Cn=s(t),d(Ct.$$.fragment,t),In=s(t),It=i(t,"P",{"data-svelte-h":!0}),r(It)!=="svelte-1mwt0fi"&&(It.innerHTML=po),kn=s(t),d(kt.$$.fragment,t),Fn=s(t),Ft=i(t,"P",{"data-svelte-h":!0}),r(Ft)!=="svelte-t5o0mn"&&(Ft.innerHTML=co),$n=s(t),d($t.$$.fragment,t),xn=s(t),xt=i(t,"P",{"data-svelte-h":!0}),r(xt)!=="svelte-iejqw3"&&(xt.innerHTML=mo),Gn=s(t),d(Gt.$$.fragment,t),Zn=s(t),Zt=i(t,"P",{"data-svelte-h":!0}),r(Zt)!=="svelte-1kjbfcb"&&(Zt.innerHTML=uo),Bn=s(t),d(Bt.$$.fragment,t),Nn=s(t),Nt=i(t,"P",{"data-svelte-h":!0}),r(Nt)!=="svelte-1o8f8wj"&&(Nt.innerHTML=ho),qn=s(t),d(qt.$$.fragment,t),Rn=s(t),Rt=i(t,"P",{"data-svelte-h":!0}),r(Rt)!=="svelte-1su7aih"&&(Rt.innerHTML=Mo),An=s(t),d(At.$$.fragment,t),Xn=s(t),Xt=i(t,"P",{"data-svelte-h":!0}),r(Xt)!=="svelte-1x3lqim"&&(Xt.textContent=yo),En=s(t),d(Et.$$.fragment,t),Wn=s(t),d(C.$$.fragment,t),Sn=s(t),Wt=i(t,"P",{"data-svelte-h":!0}),r(Wt)!=="svelte-pwdaav"&&(Wt.innerHTML=fo),zn=s(t),d(St.$$.fragment,t),Qn=s(t),zt=i(t,"P",{"data-svelte-h":!0}),r(zt)!=="svelte-11pydf"&&(zt.innerHTML=go),Vn=s(t),d(Qt.$$.fragment,t),Hn=s(t),d(Vt.$$.fragment,t),Ln=s(t),Ht=i(t,"P",{"data-svelte-h":!0}),r(Ht)!=="svelte-fyvvsj"&&(Ht.textContent=To),Yn=s(t),d(Lt.$$.fragment,t),Dn=s(t),Yt=i(t,"P",{"data-svelte-h":!0}),r(Yt)!=="svelte-yypgof"&&(Yt.textContent=wo),Pn=s(t),d(Dt.$$.fragment,t),On=s(t),Pt=i(t,"P",{"data-svelte-h":!0}),r(Pt)!=="svelte-yugu96"&&(Pt.innerHTML=_o),Kn=s(t),d(Ot.$$.fragment,t),tl=s(t),Kt=i(t,"P",{"data-svelte-h":!0}),r(Kt)!=="svelte-1qms4cl"&&(Kt.innerHTML=Jo),el=s(t),d(te.$$.fragment,t),al=s(t),ee=i(t,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-qe5zfz"&&(ee.innerHTML=bo),nl=s(t),ae=i(t,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-69u1rz"&&(ae.textContent=Uo),ll=s(t),ne=i(t,"TABLE",{"data-svelte-h":!0}),r(ne)!=="svelte-8fq96j"&&(ne.innerHTML=jo),sl=s(t),d(le.$$.fragment,t),ol=s(t),se=i(t,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1rqlm78"&&(se.innerHTML=vo),il=s(t),d(oe.$$.fragment,t),rl=s(t),ie=i(t,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-14s96xo"&&(ie.innerHTML=Co),pl=s(t),d(re.$$.fragment,t),dl=s(t),pe=i(t,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-vfpk19"&&(pe.textContent=Io),cl=s(t),de=i(t,"P",{"data-svelte-h":!0}),r(de)!=="svelte-162zeem"&&(de.textContent=ko),ml=s(t),d(ce.$$.fragment,t),ul=s(t),me=i(t,"P",{"data-svelte-h":!0}),r(me)!=="svelte-u9yx96"&&(me.textContent=Fo),hl=s(t),_=i(t,"DIV",{class:!0});var v=x(_);d(ue.$$.fragment,v),ks=s(v),Ja=i(v,"P",{"data-svelte-h":!0}),r(Ja)!=="svelte-21rjm6"&&(Ja.textContent=$o),Fs=s(v),ba=i(v,"P",{"data-svelte-h":!0}),r(ba)!=="svelte-k1oonp"&&(ba.innerHTML=xo),v.forEach(a),Ml=s(t),d(he.$$.fragment,t),yl=s(t),d(Me.$$.fragment,t),fl=s(t),ye=i(t,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-8q8jbt"&&(ye.innerHTML=Go),gl=s(t),fe=i(t,"BLOCKQUOTE",{"data-svelte-h":!0}),r(fe)!=="svelte-1ejl1pl"&&(fe.innerHTML=Zo),Tl=s(t),I=i(t,"DIV",{style:!0,"data-svelte-h":!0}),r(I)!=="svelte-1wkjgyb"&&(I.innerHTML=Bo),wl=s(t),ge=i(t,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-15c39pv"&&(ge.innerHTML=No),_l=s(t),d(Te.$$.fragment,t),Jl=s(t),we=i(t,"P",{"data-svelte-h":!0}),r(we)!=="svelte-sqj12"&&(we.innerHTML=qo),bl=s(t),k=i(t,"DIV",{style:!0,"data-svelte-h":!0}),r(k)!=="svelte-a1m5gi"&&(k.innerHTML=Ro),Ul=s(t),_e=i(t,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-rwofnh"&&(_e.innerHTML=Ao),jl=s(t),d(Je.$$.fragment,t),vl=s(t),be=i(t,"P",{"data-svelte-h":!0}),r(be)!=="svelte-1q1m1nw"&&(be.innerHTML=Xo),Cl=s(t),Ue=i(t,"TABLE",{"data-svelte-h":!0}),r(Ue)!=="svelte-lj2wpp"&&(Ue.innerHTML=Eo),Il=s(t),je=i(t,"P",{"data-svelte-h":!0}),r(je)!=="svelte-1p74c9x"&&(je.innerHTML=Wo),kl=s(t),d(ve.$$.fragment,t),Fl=s(t),Ce=i(t,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-1o18rwj"&&(Ce.innerHTML=So),$l=s(t),d(Ie.$$.fragment,t),xl=s(t),ke=i(t,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-1tpy3c1"&&(ke.innerHTML=zo),Gl=s(t),Fe=i(t,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-wsouej"&&(Fe.textContent=Qo),Zl=s(t),$e=i(t,"TABLE",{"data-svelte-h":!0}),r($e)!=="svelte-1jpb79"&&($e.innerHTML=Vo),Bl=s(t),xe=i(t,"OL",{"data-svelte-h":!0}),r(xe)!=="svelte-10hwsos"&&(xe.innerHTML=Ho),Nl=s(t),d(Ge.$$.fragment,t),ql=s(t),F=i(t,"OL",{start:!0,"data-svelte-h":!0}),r(F)!=="svelte-1u03gu4"&&(F.innerHTML=Lo),Rl=s(t),d(Ze.$$.fragment,t),Al=s(t),Be=i(t,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-1h5mxii"&&(Be.innerHTML=Yo),Xl=s(t),d(Ne.$$.fragment,t),El=s(t),qe=i(t,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-g801h1"&&(qe.textContent=Do),Wl=s(t),Re=i(t,"UL",{"data-svelte-h":!0}),r(Re)!=="svelte-9ejmv1"&&(Re.innerHTML=Po),Sl=s(t),d(Ae.$$.fragment,t),zl=s(t),Xe=i(t,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-s3xf41"&&(Xe.innerHTML=Oo),Ql=s(t),Ee=i(t,"UL",{"data-svelte-h":!0}),r(Ee)!=="svelte-19jsxq"&&(Ee.innerHTML=Ko),Vl=s(t),d(We.$$.fragment,t),Hl=s(t),d(Se.$$.fragment,t),Ll=s(t),ze=i(t,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-xofzi2"&&(ze.innerHTML=ti),Yl=s(t),d(Qe.$$.fragment,t),Dl=s(t),Ve=i(t,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-gz974t"&&(Ve.innerHTML=ei),Pl=s(t),d(He.$$.fragment,t),Ol=s(t),Le=i(t,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-58v4pe"&&(Le.textContent=ai),Kl=s(t),d(Ye.$$.fragment,t),ts=s(t),De=i(t,"P",{"data-svelte-h":!0}),r(De)!=="svelte-1i9g14v"&&(De.textContent=ni),es=s(t),d(Pe.$$.fragment,t),as=s(t),Oe=i(t,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-aegjvb"&&(Oe.textContent=li),ns=s(t),d(Ke.$$.fragment,t),ls=s(t),U=i(t,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),x(U).forEach(a),ss=s(t),d(ta.$$.fragment,t),os=s(t),ea=i(t,"P",{"data-svelte-h":!0}),r(ea)!=="svelte-1y2dzof"&&(ea.innerHTML=oi),is=s(t),d(aa.$$.fragment,t),rs=s(t),na=i(t,"P",{"data-svelte-h":!0}),r(na)!=="svelte-ezw63w"&&(na.textContent=ii),ps=s(t),d(la.$$.fragment,t),ds=s(t),d(sa.$$.fragment,t),cs=s(t),oa=i(t,"P",{"data-svelte-h":!0}),r(oa)!=="svelte-yvalkp"&&(oa.innerHTML=ri),ms=s(t),d(ia.$$.fragment,t),us=s(t),ra=i(t,"P",{"data-svelte-h":!0}),r(ra)!=="svelte-bk6pmc"&&(ra.innerHTML=pi),hs=s(t),pa=i(t,"UL",{"data-svelte-h":!0}),r(pa)!=="svelte-ata0nu"&&(pa.innerHTML=di),Ms=s(t),d(da.$$.fragment,t),ys=s(t),J=i(t,"DIV",{class:!0});var ka=x(J);d(ca.$$.fragment,ka),$s=s(ka),Ua=i(ka,"P",{"data-svelte-h":!0}),r(Ua)!=="svelte-14oyph8"&&(Ua.innerHTML=ci),xs=s(ka),$=i(ka,"DIV",{class:!0});var Cs=x($);d(ma.$$.fragment,Cs),Gs=s(Cs),ja=i(Cs,"P",{"data-svelte-h":!0}),r(ja)!=="svelte-1mh859w"&&(ja.innerHTML=mi),Cs.forEach(a),ka.forEach(a),fs=s(t),d(ua.$$.fragment,t),gs=s(t),b=i(t,"DIV",{class:!0});var Fa=x(b);d(ha.$$.fragment,Fa),Zs=s(Fa),va=i(Fa,"P",{"data-svelte-h":!0}),r(va)!=="svelte-1x2bn6g"&&(va.innerHTML=ui),Bs=s(Fa),Ca=i(Fa,"P",{"data-svelte-h":!0}),r(Ca)!=="svelte-k1oonp"&&(Ca.innerHTML=hi),Fa.forEach(a),Ts=s(t),d(Ma.$$.fragment,t),ws=s(t),ya=i(t,"P",{"data-svelte-h":!0}),r(ya)!=="svelte-16l6c3u"&&(ya.innerHTML=Mi),_s=s(t),fa=i(t,"P",{"data-svelte-h":!0}),r(fa)!=="svelte-k5kqyl"&&(fa.innerHTML=yi),Js=s(t),d(ga.$$.fragment,t),bs=s(t),j=i(t,"DIV",{class:!0});var Is=x(j);d(Ta.$$.fragment,Is),Ns=s(Is),Ia=i(Is,"P",{"data-svelte-h":!0}),r(Ia)!=="svelte-1dlriq1"&&(Ia.textContent=fi),Is.forEach(a),Us=s(t),d(wa.$$.fragment,t),js=s(t),$a=i(t,"P",{}),x($a).forEach(a),this.h()},h(){T(f,"name","hf:doc:metadata"),T(f,"content",Fi),T(_,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),gi(I,"text-align","center"),gi(k,"text-align","center"),T(F,"start","2"),wi(U.src,si="https://huggingface.co/datasets/HuggingFaceH4/llava-instruct-mix-vsft/embed/viewer/default/train")||T(U,"src",si),T(U,"frameborder","0"),T(U,"width","100%"),T(U,"height","560px"),T($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(b,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,e){g(document.head,f),n(t,G,e),n(t,w,e),n(t,_a,e),c(Z,t,e),n(t,Za,e),n(t,B,e),n(t,Ba,e),n(t,N,e),n(t,Na,e),n(t,q,e),n(t,qa,e),c(R,t,e),n(t,Ra,e),n(t,A,e),n(t,Aa,e),c(X,t,e),n(t,Xa,e),n(t,E,e),n(t,Ea,e),n(t,W,e),n(t,Wa,e),c(S,t,e),n(t,Sa,e),n(t,z,e),n(t,za,e),c(Q,t,e),n(t,Qa,e),c(V,t,e),n(t,Va,e),n(t,H,e),n(t,Ha,e),c(L,t,e),n(t,La,e),n(t,Y,e),n(t,Ya,e),c(D,t,e),n(t,Da,e),n(t,P,e),n(t,Pa,e),c(O,t,e),n(t,Oa,e),n(t,K,e),n(t,Ka,e),c(tt,t,e),n(t,tn,e),n(t,et,e),n(t,en,e),n(t,at,e),n(t,an,e),n(t,nt,e),n(t,nn,e),c(lt,t,e),n(t,ln,e),n(t,st,e),n(t,sn,e),c(ot,t,e),n(t,on,e),c(it,t,e),n(t,rn,e),n(t,rt,e),n(t,pn,e),n(t,pt,e),n(t,dn,e),c(dt,t,e),n(t,cn,e),n(t,ct,e),n(t,mn,e),c(mt,t,e),n(t,un,e),n(t,ut,e),n(t,hn,e),n(t,ht,e),n(t,Mn,e),c(Mt,t,e),n(t,yn,e),n(t,yt,e),n(t,fn,e),c(ft,t,e),n(t,gn,e),n(t,gt,e),n(t,Tn,e),c(Tt,t,e),n(t,wn,e),n(t,wt,e),n(t,_n,e),c(_t,t,e),n(t,Jn,e),n(t,Jt,e),n(t,bn,e),c(bt,t,e),n(t,Un,e),n(t,Ut,e),n(t,jn,e),c(jt,t,e),n(t,vn,e),n(t,vt,e),n(t,Cn,e),c(Ct,t,e),n(t,In,e),n(t,It,e),n(t,kn,e),c(kt,t,e),n(t,Fn,e),n(t,Ft,e),n(t,$n,e),c($t,t,e),n(t,xn,e),n(t,xt,e),n(t,Gn,e),c(Gt,t,e),n(t,Zn,e),n(t,Zt,e),n(t,Bn,e),c(Bt,t,e),n(t,Nn,e),n(t,Nt,e),n(t,qn,e),c(qt,t,e),n(t,Rn,e),n(t,Rt,e),n(t,An,e),c(At,t,e),n(t,Xn,e),n(t,Xt,e),n(t,En,e),c(Et,t,e),n(t,Wn,e),c(C,t,e),n(t,Sn,e),n(t,Wt,e),n(t,zn,e),c(St,t,e),n(t,Qn,e),n(t,zt,e),n(t,Vn,e),c(Qt,t,e),n(t,Hn,e),c(Vt,t,e),n(t,Ln,e),n(t,Ht,e),n(t,Yn,e),c(Lt,t,e),n(t,Dn,e),n(t,Yt,e),n(t,Pn,e),c(Dt,t,e),n(t,On,e),n(t,Pt,e),n(t,Kn,e),c(Ot,t,e),n(t,tl,e),n(t,Kt,e),n(t,el,e),c(te,t,e),n(t,al,e),n(t,ee,e),n(t,nl,e),n(t,ae,e),n(t,ll,e),n(t,ne,e),n(t,sl,e),c(le,t,e),n(t,ol,e),n(t,se,e),n(t,il,e),c(oe,t,e),n(t,rl,e),n(t,ie,e),n(t,pl,e),c(re,t,e),n(t,dl,e),n(t,pe,e),n(t,cl,e),n(t,de,e),n(t,ml,e),c(ce,t,e),n(t,ul,e),n(t,me,e),n(t,hl,e),n(t,_,e),c(ue,_,null),g(_,ks),g(_,Ja),g(_,Fs),g(_,ba),n(t,Ml,e),c(he,t,e),n(t,yl,e),c(Me,t,e),n(t,fl,e),n(t,ye,e),n(t,gl,e),n(t,fe,e),n(t,Tl,e),n(t,I,e),n(t,wl,e),n(t,ge,e),n(t,_l,e),c(Te,t,e),n(t,Jl,e),n(t,we,e),n(t,bl,e),n(t,k,e),n(t,Ul,e),n(t,_e,e),n(t,jl,e),c(Je,t,e),n(t,vl,e),n(t,be,e),n(t,Cl,e),n(t,Ue,e),n(t,Il,e),n(t,je,e),n(t,kl,e),c(ve,t,e),n(t,Fl,e),n(t,Ce,e),n(t,$l,e),c(Ie,t,e),n(t,xl,e),n(t,ke,e),n(t,Gl,e),n(t,Fe,e),n(t,Zl,e),n(t,$e,e),n(t,Bl,e),n(t,xe,e),n(t,Nl,e),c(Ge,t,e),n(t,ql,e),n(t,F,e),n(t,Rl,e),c(Ze,t,e),n(t,Al,e),n(t,Be,e),n(t,Xl,e),c(Ne,t,e),n(t,El,e),n(t,qe,e),n(t,Wl,e),n(t,Re,e),n(t,Sl,e),c(Ae,t,e),n(t,zl,e),n(t,Xe,e),n(t,Ql,e),n(t,Ee,e),n(t,Vl,e),c(We,t,e),n(t,Hl,e),c(Se,t,e),n(t,Ll,e),n(t,ze,e),n(t,Yl,e),c(Qe,t,e),n(t,Dl,e),n(t,Ve,e),n(t,Pl,e),c(He,t,e),n(t,Ol,e),n(t,Le,e),n(t,Kl,e),c(Ye,t,e),n(t,ts,e),n(t,De,e),n(t,es,e),c(Pe,t,e),n(t,as,e),n(t,Oe,e),n(t,ns,e),c(Ke,t,e),n(t,ls,e),n(t,U,e),n(t,ss,e),c(ta,t,e),n(t,os,e),n(t,ea,e),n(t,is,e),c(aa,t,e),n(t,rs,e),n(t,na,e),n(t,ps,e),c(la,t,e),n(t,ds,e),c(sa,t,e),n(t,cs,e),n(t,oa,e),n(t,ms,e),c(ia,t,e),n(t,us,e),n(t,ra,e),n(t,hs,e),n(t,pa,e),n(t,Ms,e),c(da,t,e),n(t,ys,e),n(t,J,e),c(ca,J,null),g(J,$s),g(J,Ua),g(J,xs),g(J,$),c(ma,$,null),g($,Gs),g($,ja),n(t,fs,e),c(ua,t,e),n(t,gs,e),n(t,b,e),c(ha,b,null),g(b,Zs),g(b,va),g(b,Bs),g(b,Ca),n(t,Ts,e),c(Ma,t,e),n(t,ws,e),n(t,ya,e),n(t,_s,e),n(t,fa,e),n(t,Js,e),c(ga,t,e),n(t,bs,e),n(t,j,e),c(Ta,j,null),g(j,Ns),g(j,Ia),n(t,Us,e),c(wa,t,e),n(t,js,e),n(t,$a,e),vs=!0},p(t,[e]){const v={};e&2&&(v.$$scope={dirty:e,ctx:t}),C.$set(v)},i(t){vs||(m(Z.$$.fragment,t),m(R.$$.fragment,t),m(X.$$.fragment,t),m(S.$$.fragment,t),m(Q.$$.fragment,t),m(V.$$.fragment,t),m(L.$$.fragment,t),m(D.$$.fragment,t),m(O.$$.fragment,t),m(tt.$$.fragment,t),m(lt.$$.fragment,t),m(ot.$$.fragment,t),m(it.$$.fragment,t),m(dt.$$.fragment,t),m(mt.$$.fragment,t),m(Mt.$$.fragment,t),m(ft.$$.fragment,t),m(Tt.$$.fragment,t),m(_t.$$.fragment,t),m(bt.$$.fragment,t),m(jt.$$.fragment,t),m(Ct.$$.fragment,t),m(kt.$$.fragment,t),m($t.$$.fragment,t),m(Gt.$$.fragment,t),m(Bt.$$.fragment,t),m(qt.$$.fragment,t),m(At.$$.fragment,t),m(Et.$$.fragment,t),m(C.$$.fragment,t),m(St.$$.fragment,t),m(Qt.$$.fragment,t),m(Vt.$$.fragment,t),m(Lt.$$.fragment,t),m(Dt.$$.fragment,t),m(Ot.$$.fragment,t),m(te.$$.fragment,t),m(le.$$.fragment,t),m(oe.$$.fragment,t),m(re.$$.fragment,t),m(ce.$$.fragment,t),m(ue.$$.fragment,t),m(he.$$.fragment,t),m(Me.$$.fragment,t),m(Te.$$.fragment,t),m(Je.$$.fragment,t),m(ve.$$.fragment,t),m(Ie.$$.fragment,t),m(Ge.$$.fragment,t),m(Ze.$$.fragment,t),m(Ne.$$.fragment,t),m(Ae.$$.fragment,t),m(We.$$.fragment,t),m(Se.$$.fragment,t),m(Qe.$$.fragment,t),m(He.$$.fragment,t),m(Ye.$$.fragment,t),m(Pe.$$.fragment,t),m(Ke.$$.fragment,t),m(ta.$$.fragment,t),m(aa.$$.fragment,t),m(la.$$.fragment,t),m(sa.$$.fragment,t),m(ia.$$.fragment,t),m(da.$$.fragment,t),m(ca.$$.fragment,t),m(ma.$$.fragment,t),m(ua.$$.fragment,t),m(ha.$$.fragment,t),m(Ma.$$.fragment,t),m(ga.$$.fragment,t),m(Ta.$$.fragment,t),m(wa.$$.fragment,t),vs=!0)},o(t){u(Z.$$.fragment,t),u(R.$$.fragment,t),u(X.$$.fragment,t),u(S.$$.fragment,t),u(Q.$$.fragment,t),u(V.$$.fragment,t),u(L.$$.fragment,t),u(D.$$.fragment,t),u(O.$$.fragment,t),u(tt.$$.fragment,t),u(lt.$$.fragment,t),u(ot.$$.fragment,t),u(it.$$.fragment,t),u(dt.$$.fragment,t),u(mt.$$.fragment,t),u(Mt.$$.fragment,t),u(ft.$$.fragment,t),u(Tt.$$.fragment,t),u(_t.$$.fragment,t),u(bt.$$.fragment,t),u(jt.$$.fragment,t),u(Ct.$$.fragment,t),u(kt.$$.fragment,t),u($t.$$.fragment,t),u(Gt.$$.fragment,t),u(Bt.$$.fragment,t),u(qt.$$.fragment,t),u(At.$$.fragment,t),u(Et.$$.fragment,t),u(C.$$.fragment,t),u(St.$$.fragment,t),u(Qt.$$.fragment,t),u(Vt.$$.fragment,t),u(Lt.$$.fragment,t),u(Dt.$$.fragment,t),u(Ot.$$.fragment,t),u(te.$$.fragment,t),u(le.$$.fragment,t),u(oe.$$.fragment,t),u(re.$$.fragment,t),u(ce.$$.fragment,t),u(ue.$$.fragment,t),u(he.$$.fragment,t),u(Me.$$.fragment,t),u(Te.$$.fragment,t),u(Je.$$.fragment,t),u(ve.$$.fragment,t),u(Ie.$$.fragment,t),u(Ge.$$.fragment,t),u(Ze.$$.fragment,t),u(Ne.$$.fragment,t),u(Ae.$$.fragment,t),u(We.$$.fragment,t),u(Se.$$.fragment,t),u(Qe.$$.fragment,t),u(He.$$.fragment,t),u(Ye.$$.fragment,t),u(Pe.$$.fragment,t),u(Ke.$$.fragment,t),u(ta.$$.fragment,t),u(aa.$$.fragment,t),u(la.$$.fragment,t),u(sa.$$.fragment,t),u(ia.$$.fragment,t),u(da.$$.fragment,t),u(ca.$$.fragment,t),u(ma.$$.fragment,t),u(ua.$$.fragment,t),u(ha.$$.fragment,t),u(Ma.$$.fragment,t),u(ga.$$.fragment,t),u(Ta.$$.fragment,t),u(wa.$$.fragment,t),vs=!1},d(t){t&&(a(G),a(w),a(_a),a(Za),a(B),a(Ba),a(N),a(Na),a(q),a(qa),a(Ra),a(A),a(Aa),a(Xa),a(E),a(Ea),a(W),a(Wa),a(Sa),a(z),a(za),a(Qa),a(Va),a(H),a(Ha),a(La),a(Y),a(Ya),a(Da),a(P),a(Pa),a(Oa),a(K),a(Ka),a(tn),a(et),a(en),a(at),a(an),a(nt),a(nn),a(ln),a(st),a(sn),a(on),a(rn),a(rt),a(pn),a(pt),a(dn),a(cn),a(ct),a(mn),a(un),a(ut),a(hn),a(ht),a(Mn),a(yn),a(yt),a(fn),a(gn),a(gt),a(Tn),a(wn),a(wt),a(_n),a(Jn),a(Jt),a(bn),a(Un),a(Ut),a(jn),a(vn),a(vt),a(Cn),a(In),a(It),a(kn),a(Fn),a(Ft),a($n),a(xn),a(xt),a(Gn),a(Zn),a(Zt),a(Bn),a(Nn),a(Nt),a(qn),a(Rn),a(Rt),a(An),a(Xn),a(Xt),a(En),a(Wn),a(Sn),a(Wt),a(zn),a(Qn),a(zt),a(Vn),a(Hn),a(Ln),a(Ht),a(Yn),a(Dn),a(Yt),a(Pn),a(On),a(Pt),a(Kn),a(tl),a(Kt),a(el),a(al),a(ee),a(nl),a(ae),a(ll),a(ne),a(sl),a(ol),a(se),a(il),a(rl),a(ie),a(pl),a(dl),a(pe),a(cl),a(de),a(ml),a(ul),a(me),a(hl),a(_),a(Ml),a(yl),a(fl),a(ye),a(gl),a(fe),a(Tl),a(I),a(wl),a(ge),a(_l),a(Jl),a(we),a(bl),a(k),a(Ul),a(_e),a(jl),a(vl),a(be),a(Cl),a(Ue),a(Il),a(je),a(kl),a(Fl),a(Ce),a($l),a(xl),a(ke),a(Gl),a(Fe),a(Zl),a($e),a(Bl),a(xe),a(Nl),a(ql),a(F),a(Rl),a(Al),a(Be),a(Xl),a(El),a(qe),a(Wl),a(Re),a(Sl),a(zl),a(Xe),a(Ql),a(Ee),a(Vl),a(Hl),a(Ll),a(ze),a(Yl),a(Dl),a(Ve),a(Pl),a(Ol),a(Le),a(Kl),a(ts),a(De),a(es),a(as),a(Oe),a(ns),a(ls),a(U),a(ss),a(os),a(ea),a(is),a(rs),a(na),a(ps),a(ds),a(cs),a(oa),a(ms),a(us),a(ra),a(hs),a(pa),a(Ms),a(ys),a(J),a(fs),a(gs),a(b),a(Ts),a(ws),a(ya),a(_s),a(fa),a(Js),a(bs),a(j),a(Us),a(js),a($a)),a(f),h(Z,t),h(R,t),h(X,t),h(S,t),h(Q,t),h(V,t),h(L,t),h(D,t),h(O,t),h(tt,t),h(lt,t),h(ot,t),h(it,t),h(dt,t),h(mt,t),h(Mt,t),h(ft,t),h(Tt,t),h(_t,t),h(bt,t),h(jt,t),h(Ct,t),h(kt,t),h($t,t),h(Gt,t),h(Bt,t),h(qt,t),h(At,t),h(Et,t),h(C,t),h(St,t),h(Qt,t),h(Vt,t),h(Lt,t),h(Dt,t),h(Ot,t),h(te,t),h(le,t),h(oe,t),h(re,t),h(ce,t),h(ue),h(he,t),h(Me,t),h(Te,t),h(Je,t),h(ve,t),h(Ie,t),h(Ge,t),h(Ze,t),h(Ne,t),h(Ae,t),h(We,t),h(Se,t),h(Qe,t),h(He,t),h(Ye,t),h(Pe,t),h(Ke,t),h(ta,t),h(aa,t),h(la,t),h(sa,t),h(ia,t),h(da,t),h(ca),h(ma),h(ua,t),h(ha),h(Ma,t),h(ga,t),h(Ta),h(wa,t)}}}const Fi='{"title":"Supervised Fine-tuning Trainer","local":"supervised-fine-tuning-trainer","sections":[{"title":"Quickstart","local":"quickstart","sections":[],"depth":2},{"title":"Advanced usage","local":"advanced-usage","sections":[{"title":"Train on completions only","local":"train-on-completions-only","sections":[{"title":"Using token_ids directly for response_template","local":"using-tokenids-directly-for-responsetemplate","sections":[],"depth":4}],"depth":3},{"title":"Add Special Tokens for Chat Format","local":"add-special-tokens-for-chat-format","sections":[],"depth":3},{"title":"Dataset format support","local":"dataset-format-support","sections":[],"depth":3},{"title":"Format your input prompts","local":"format-your-input-prompts","sections":[],"depth":3},{"title":"Packing dataset ( ConstantLengthDataset )","local":"packing-dataset--constantlengthdataset-","sections":[{"title":"Customize your prompts using packed dataset","local":"customize-your-prompts-using-packed-dataset","sections":[],"depth":4}],"depth":3},{"title":"Control over the pretrained model","local":"control-over-the-pretrained-model","sections":[],"depth":3},{"title":"Training adapters","local":"training-adapters","sections":[],"depth":3},{"title":"Training adapters with base 8 bit models","local":"training-adapters-with-base-8-bit-models","sections":[],"depth":3}],"depth":2},{"title":"Using Flash Attention and Flash Attention 2","local":"using-flash-attention-and-flash-attention-2","sections":[{"title":"Using Flash-Attention 1","local":"using-flash-attention-1","sections":[],"depth":3},{"title":"Using Flash Attention-2","local":"using-flash-attention-2","sections":[],"depth":3},{"title":"Using model creation utility","local":"trl.ModelConfig","sections":[],"depth":3},{"title":"Enhance the model’s performances using NEFTune","local":"enhance-the-models-performances-using-neftune","sections":[],"depth":3},{"title":"Accelerate fine-tuning 2x using unsloth","local":"accelerate-fine-tuning-2x-using-unsloth","sections":[],"depth":3}],"depth":2},{"title":"Liger-Kernel: Increase 20% throughput and reduces 60% memory for multi-GPU training","local":"liger-kernel-increase-20-throughput-and-reduces-60-memory-for-multi-gpu-training","sections":[],"depth":2},{"title":"Best practices","local":"best-practices","sections":[],"depth":2},{"title":"Multi-GPU Training","local":"multi-gpu-training","sections":[],"depth":2},{"title":"GPTQ Conversion","local":"gptq-conversion","sections":[],"depth":2},{"title":"Extending SFTTrainer for Vision Language Models","local":"extending-sfttrainer-for-vision-language-models","sections":[{"title":"Preparing the Data","local":"preparing-the-data","sections":[],"depth":3},{"title":"A custom collator for processing multi-modal data","local":"a-custom-collator-for-processing-multi-modal-data","sections":[],"depth":3},{"title":"Training the vision-language model","local":"training-the-vision-language-model","sections":[],"depth":3}],"depth":2},{"title":"SFTTrainer","local":"trl.SFTTrainer","sections":[],"depth":2},{"title":"SFTConfig","local":"trl.SFTConfig","sections":[],"depth":2},{"title":"Datasets","local":"datasets","sections":[{"title":"ConstantLengthDataset","local":"trl.trainer.ConstantLengthDataset","sections":[],"depth":3}],"depth":2}],"depth":1}';function $i(Ga){return _i(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ri extends bi{constructor(f){super(),Ui(this,f,$i,ki,Ti,{})}}export{Ri as component};
