import{s as es,o as ts,n as ss}from"../chunks/scheduler.9bc65507.js";import{S as ls,i as as,g as i,s as a,r as o,m as ns,A as is,h as p,f as s,c as n,j as Ot,u as m,x as r,n as ps,k as jt,y as rs,a as l,v as M,d as c,t as y,w as d}from"../chunks/index.707bf1b6.js";import{T as os}from"../chunks/Tip.c2ecdbf4.js";import{C as h}from"../chunks/CodeBlock.54a9f38d.js";import{D as ms}from"../chunks/DocNotebookDropdown.41f65cb5.js";import{H as Je}from"../chunks/Heading.342b1fa6.js";function Ms(Te){let u,b="Many image captioning datasets contain multiple captions per image. In those cases, a common strategy is to randomly sample a caption amongst the available ones during training.";return{c(){u=i("p"),u.textContent=b},l(f){u=p(f,"P",{"data-svelte-h":!0}),r(u)!=="svelte-n6sigx"&&(u.textContent=b)},m(f,ge){l(f,u,ge)},p:ss,d(f){f&&s(u)}}}function cs(Te){let u,b,f,ge,T,Ue,U,je,j,$t=`Image captioning is the task of predicting a caption for a given image. Common real world applications of it include
aiding visually impaired people that can help them navigate through different situations. Therefore, image captioning
helps to improve content accessibility for people by describing images to them.`,$e,$,Ct="This guide will show you how to:",Ce,C,_t="<li>Fine-tune an image captioning model.</li> <li>Use the fine-tuned model for inference.</li>",_e,_,kt="Before you begin, make sure you have all the necessary libraries installed:",ke,k,Ie,I,It="We encourage you to log in to your Hugging Face account so you can upload and share your model with the community. When prompted, enter your token to log in:",ve,v,Be,B,We,W,vt=`Use the 🤗 Dataset library to load a dataset that consists of {image-caption} pairs. To create your own image captioning dataset
in PyTorch, you can follow <a href="https://github.com/NielsRogge/Transformers-Tutorials/blob/master/GIT/Fine_tune_GIT_on_an_image_captioning_dataset.ipynb" rel="nofollow">this notebook</a>.`,Ze,Z,Ge,G,Re,R,Bt="The dataset has two features, <code>image</code> and <code>text</code>.",xe,w,He,x,Wt='Split the dataset’s train split into a train and test set with the <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.train_test_split" rel="nofollow">train_test_split</a> method:',Xe,H,Ve,X,Zt="Let’s visualize a couple of samples from the training set.",Ye,V,Ee,J,Gt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/sample_training_images_image_cap.png" alt="Sample training images"/>',ze,Y,Qe,E,Rt="Since the dataset has two modalities (image and text), the pre-processing pipeline will preprocess images and the captions.",Fe,z,xt="To do so, load the processor class associated with the model you are about to fine-tune.",Ne,Q,Ae,F,Ht="The processor will internally pre-process the image (which includes resizing, and pixel scaling) and tokenize the caption.",Se,N,Le,A,Xt="With the dataset ready, you can now set up the model for fine-tuning.",qe,S,Pe,L,Vt='Load the <a href="https://huggingface.co/microsoft/git-base" rel="nofollow">“microsoft/git-base”</a> into a <a href="https://huggingface.co/docs/transformers/model_doc/auto#transformers.AutoModelForCausalLM" rel="nofollow"><code>AutoModelForCausalLM</code></a> object.',Ke,q,De,P,Oe,K,Yt='Image captioning models are typically evaluated with the <a href="https://huggingface.co/spaces/evaluate-metric/rouge" rel="nofollow">Rouge Score</a> or <a href="https://huggingface.co/spaces/evaluate-metric/wer" rel="nofollow">Word Error Rate</a>. For this guide, you will use the Word Error Rate (WER).',et,D,Et='We use the 🤗 Evaluate library to do so. For potential limitations and other gotchas of the WER, refer to <a href="https://huggingface.co/spaces/evaluate-metric/wer" rel="nofollow">this guide</a>.',tt,O,st,ee,lt,te,zt='Now, you are ready to start fine-tuning the model. You will use the 🤗 <a href="/docs/transformers/main/en/main_classes/trainer#transformers.Trainer">Trainer</a> for this.',at,se,Qt='First, define the training arguments using <a href="/docs/transformers/main/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a>.',nt,le,it,ae,Ft="Then pass them along with the datasets and the model to 🤗 Trainer.",pt,ne,rt,ie,Nt='To start training, simply call <a href="/docs/transformers/main/en/main_classes/trainer#transformers.Trainer.train">train()</a> on the <a href="/docs/transformers/main/en/main_classes/trainer#transformers.Trainer">Trainer</a> object.',ot,pe,mt,re,At="You should see the training loss drop smoothly as training progresses.",Mt,oe,St='Once training is completed, share your model to the Hub with the <a href="/docs/transformers/main/en/main_classes/trainer#transformers.Trainer.push_to_hub">push_to_hub()</a> method so everyone can use your model:',ct,me,yt,Me,dt,ce,Lt="Take a sample image from <code>test_ds</code> to test the model.",ht,ye,ut,g,qt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/test_image_image_cap.png" alt="Test image"/>',ft,de,wt,he,Pt="Call <code>generate</code> and decode the predictions.",Jt,ue,gt,fe,bt,we,Kt="Looks like the fine-tuned model generated a pretty good caption!",Tt,be,Ut;return T=new Je({props:{title:"Image captioning",local:"image-captioning",headingTag:"h1"}}),U=new ms({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/image_captioning.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/image_captioning.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/image_captioning.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/image_captioning.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/image_captioning.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/image_captioning.ipynb"}]}}),k=new h({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGRhdGFzZXRzJTIwZXZhbHVhdGUlMjAtcSUwQXBpcCUyMGluc3RhbGwlMjBqaXdlciUyMC1x",highlighted:`pip install transformers datasets evaluate -q
pip install jiwer -q`,wrap:!1}}),v=new h({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),B=new Je({props:{title:"Load the Pokémon BLIP captions dataset",local:"load-the-pokémon-blip-captions-dataset",headingTag:"h2"}}),Z=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIybGFtYmRhbGFicyUyRnBva2Vtb24tYmxpcC1jYXB0aW9ucyUyMiklMEFkcw==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

ds = load_dataset(<span class="hljs-string">&quot;lambdalabs/pokemon-blip-captions&quot;</span>)
ds`,wrap:!1}}),G=new h({props:{code:"RGF0YXNldERpY3QoJTdCJTBBJTIwJTIwJTIwJTIwdHJhaW4lM0ElMjBEYXRhc2V0KCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZlYXR1cmVzJTNBJTIwJTVCJ2ltYWdlJyUyQyUyMCd0ZXh0JyU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9yb3dzJTNBJTIwODMzJTBBJTIwJTIwJTIwJTIwJTdEKSUwQSU3RCk=",highlighted:`DatasetDict({
    train: Dataset({
        features: [<span class="hljs-string">&#x27;image&#x27;</span>, <span class="hljs-string">&#x27;text&#x27;</span>],
        num_rows: 833
    })
})`,wrap:!1}}),w=new os({props:{$$slots:{default:[Ms]},$$scope:{ctx:Te}}}),H=new h({props:{code:"ZHMlMjAlM0QlMjBkcyU1QiUyMnRyYWluJTIyJTVELnRyYWluX3Rlc3Rfc3BsaXQodGVzdF9zaXplJTNEMC4xKSUwQXRyYWluX2RzJTIwJTNEJTIwZHMlNUIlMjJ0cmFpbiUyMiU1RCUwQXRlc3RfZHMlMjAlM0QlMjBkcyU1QiUyMnRlc3QlMjIlNUQ=",highlighted:`ds = ds[<span class="hljs-string">&quot;train&quot;</span>].train_test_split(test_size=<span class="hljs-number">0.1</span>)
train_ds = ds[<span class="hljs-string">&quot;train&quot;</span>]
test_ds = ds[<span class="hljs-string">&quot;test&quot;</span>]`,wrap:!1}}),V=new h({props:{code:"ZnJvbSUyMHRleHR3cmFwJTIwaW1wb3J0JTIwd3JhcCUwQWltcG9ydCUyMG1hdHBsb3RsaWIucHlwbG90JTIwYXMlMjBwbHQlMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEElMEElMEFkZWYlMjBwbG90X2ltYWdlcyhpbWFnZXMlMkMlMjBjYXB0aW9ucyklM0ElMEElMjAlMjAlMjAlMjBwbHQuZmlndXJlKGZpZ3NpemUlM0QoMjAlMkMlMjAyMCkpJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UobGVuKGltYWdlcykpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXglMjAlM0QlMjBwbHQuc3VicGxvdCgxJTJDJTIwbGVuKGltYWdlcyklMkMlMjBpJTIwJTJCJTIwMSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjYXB0aW9uJTIwJTNEJTIwY2FwdGlvbnMlNUJpJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2FwdGlvbiUyMCUzRCUyMCUyMiU1Q24lMjIuam9pbih3cmFwKGNhcHRpb24lMkMlMjAxMikpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGx0LnRpdGxlKGNhcHRpb24pJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGx0Lmltc2hvdyhpbWFnZXMlNUJpJTVEKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBsdC5heGlzKCUyMm9mZiUyMiklMEElMEElMEFzYW1wbGVfaW1hZ2VzX3RvX3Zpc3VhbGl6ZSUyMCUzRCUyMCU1Qm5wLmFycmF5KHRyYWluX2RzJTVCaSU1RCU1QiUyMmltYWdlJTIyJTVEKSUyMGZvciUyMGklMjBpbiUyMHJhbmdlKDUpJTVEJTBBc2FtcGxlX2NhcHRpb25zJTIwJTNEJTIwJTVCdHJhaW5fZHMlNUJpJTVEJTVCJTIydGV4dCUyMiU1RCUyMGZvciUyMGklMjBpbiUyMHJhbmdlKDUpJTVEJTBBcGxvdF9pbWFnZXMoc2FtcGxlX2ltYWdlc190b192aXN1YWxpemUlMkMlMjBzYW1wbGVfY2FwdGlvbnMp",highlighted:`<span class="hljs-keyword">from</span> textwrap <span class="hljs-keyword">import</span> wrap
<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np


<span class="hljs-keyword">def</span> <span class="hljs-title function_">plot_images</span>(<span class="hljs-params">images, captions</span>):
    plt.figure(figsize=(<span class="hljs-number">20</span>, <span class="hljs-number">20</span>))
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(images)):
        ax = plt.subplot(<span class="hljs-number">1</span>, <span class="hljs-built_in">len</span>(images), i + <span class="hljs-number">1</span>)
        caption = captions[i]
        caption = <span class="hljs-string">&quot;\\n&quot;</span>.join(wrap(caption, <span class="hljs-number">12</span>))
        plt.title(caption)
        plt.imshow(images[i])
        plt.axis(<span class="hljs-string">&quot;off&quot;</span>)


sample_images_to_visualize = [np.array(train_ds[i][<span class="hljs-string">&quot;image&quot;</span>]) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">5</span>)]
sample_captions = [train_ds[i][<span class="hljs-string">&quot;text&quot;</span>] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">5</span>)]
plot_images(sample_images_to_visualize, sample_captions)`,wrap:!1}}),Y=new Je({props:{title:"Preprocess the dataset",local:"preprocess-the-dataset",headingTag:"h2"}}),Q=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEFjaGVja3BvaW50JTIwJTNEJTIwJTIybWljcm9zb2Z0JTJGZ2l0LWJhc2UlMjIlMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

checkpoint = <span class="hljs-string">&quot;microsoft/git-base&quot;</span>
processor = AutoProcessor.from_pretrained(checkpoint)`,wrap:!1}}),N=new h({props:{code:"ZGVmJTIwdHJhbnNmb3JtcyhleGFtcGxlX2JhdGNoKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlcyUyMCUzRCUyMCU1QnglMjBmb3IlMjB4JTIwaW4lMjBleGFtcGxlX2JhdGNoJTVCJTIyaW1hZ2UlMjIlNUQlNUQlMEElMjAlMjAlMjAlMjBjYXB0aW9ucyUyMCUzRCUyMCU1QnglMjBmb3IlMjB4JTIwaW4lMjBleGFtcGxlX2JhdGNoJTVCJTIydGV4dCUyMiU1RCU1RCUwQSUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMHByb2Nlc3NvcihpbWFnZXMlM0RpbWFnZXMlMkMlMjB0ZXh0JTNEY2FwdGlvbnMlMkMlMjBwYWRkaW5nJTNEJTIybWF4X2xlbmd0aCUyMiklMEElMjAlMjAlMjAlMjBpbnB1dHMudXBkYXRlKCU3QiUyMmxhYmVscyUyMiUzQSUyMGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCU3RCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbnB1dHMlMEElMEElMEF0cmFpbl9kcy5zZXRfdHJhbnNmb3JtKHRyYW5zZm9ybXMpJTBBdGVzdF9kcy5zZXRfdHJhbnNmb3JtKHRyYW5zZm9ybXMp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">transforms</span>(<span class="hljs-params">example_batch</span>):
    images = [x <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;image&quot;</span>]]
    captions = [x <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;text&quot;</span>]]
    inputs = processor(images=images, text=captions, padding=<span class="hljs-string">&quot;max_length&quot;</span>)
    inputs.update({<span class="hljs-string">&quot;labels&quot;</span>: inputs[<span class="hljs-string">&quot;input_ids&quot;</span>]})
    <span class="hljs-keyword">return</span> inputs


train_ds.set_transform(transforms)
test_ds.set_transform(transforms)`,wrap:!1}}),S=new Je({props:{title:"Load a base model",local:"load-a-base-model",headingTag:"h2"}}),q=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(checkpoint)`,wrap:!1}}),P=new Je({props:{title:"Evaluate",local:"evaluate",headingTag:"h2"}}),O=new h({props:{code:"ZnJvbSUyMGV2YWx1YXRlJTIwaW1wb3J0JTIwbG9hZCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBd2VyJTIwJTNEJTIwbG9hZCglMjJ3ZXIlMjIpJTBBJTBBJTBBZGVmJTIwY29tcHV0ZV9tZXRyaWNzKGV2YWxfcHJlZCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMkMlMjBsYWJlbHMlMjAlM0QlMjBldmFsX3ByZWQlMEElMjAlMjAlMjAlMjBwcmVkaWN0ZWQlMjAlM0QlMjBsb2dpdHMuYXJnbWF4KC0xKSUwQSUyMCUyMCUyMCUyMGRlY29kZWRfbGFiZWxzJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShsYWJlbHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklMEElMjAlMjAlMjAlMjBkZWNvZGVkX3ByZWRpY3Rpb25zJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShwcmVkaWN0ZWQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklMEElMjAlMjAlMjAlMjB3ZXJfc2NvcmUlMjAlM0QlMjB3ZXIuY29tcHV0ZShwcmVkaWN0aW9ucyUzRGRlY29kZWRfcHJlZGljdGlvbnMlMkMlMjByZWZlcmVuY2VzJTNEZGVjb2RlZF9sYWJlbHMpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIyd2VyX3Njb3JlJTIyJTNBJTIwd2VyX3Njb3JlJTdE",highlighted:`<span class="hljs-keyword">from</span> evaluate <span class="hljs-keyword">import</span> load
<span class="hljs-keyword">import</span> torch

wer = load(<span class="hljs-string">&quot;wer&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    logits, labels = eval_pred
    predicted = logits.argmax(-<span class="hljs-number">1</span>)
    decoded_labels = processor.batch_decode(labels, skip_special_tokens=<span class="hljs-literal">True</span>)
    decoded_predictions = processor.batch_decode(predicted, skip_special_tokens=<span class="hljs-literal">True</span>)
    wer_score = wer.compute(predictions=decoded_predictions, references=decoded_labels)
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;wer_score&quot;</span>: wer_score}`,wrap:!1}}),ee=new Je({props:{title:"Train!",local:"train",headingTag:"h2"}}),le=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTJDJTIwVHJhaW5lciUwQSUwQW1vZGVsX25hbWUlMjAlM0QlMjBjaGVja3BvaW50LnNwbGl0KCUyMiUyRiUyMiklNUIxJTVEJTBBJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMG91dHB1dF9kaXIlM0RmJTIyJTdCbW9kZWxfbmFtZSU3RC1wb2tlbW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwbGVhcm5pbmdfcmF0ZSUzRDVlLTUlMkMlMEElMjAlMjAlMjAlMjBudW1fdHJhaW5fZXBvY2hzJTNENTAlMkMlMEElMjAlMjAlMjAlMjBmcDE2JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDMyJTJDJTBBJTIwJTIwJTIwJTIwcGVyX2RldmljZV9ldmFsX2JhdGNoX3NpemUlM0QzMiUyQyUwQSUyMCUyMCUyMCUyMGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzRDIlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3RvdGFsX2xpbWl0JTNEMyUyQyUwQSUyMCUyMCUyMCUyMGV2YWx1YXRpb25fc3RyYXRlZ3klM0QlMjJzdGVwcyUyMiUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfc3RlcHMlM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfc3RyYXRlZ3klM0QlMjJzdGVwcyUyMiUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfc3RlcHMlM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMGxvZ2dpbmdfc3RlcHMlM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMHJlbW92ZV91bnVzZWRfY29sdW1ucyUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwcHVzaF90b19odWIlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwbGFiZWxfbmFtZXMlM0QlNUIlMjJsYWJlbHMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBsb2FkX2Jlc3RfbW9kZWxfYXRfZW5kJTNEVHJ1ZSUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments, Trainer

model_name = checkpoint.split(<span class="hljs-string">&quot;/&quot;</span>)[<span class="hljs-number">1</span>]

training_args = TrainingArguments(
    output_dir=<span class="hljs-string">f&quot;<span class="hljs-subst">{model_name}</span>-pokemon&quot;</span>,
    learning_rate=<span class="hljs-number">5e-5</span>,
    num_train_epochs=<span class="hljs-number">50</span>,
    fp16=<span class="hljs-literal">True</span>,
    per_device_train_batch_size=<span class="hljs-number">32</span>,
    per_device_eval_batch_size=<span class="hljs-number">32</span>,
    gradient_accumulation_steps=<span class="hljs-number">2</span>,
    save_total_limit=<span class="hljs-number">3</span>,
    evaluation_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
    eval_steps=<span class="hljs-number">50</span>,
    save_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
    save_steps=<span class="hljs-number">50</span>,
    logging_steps=<span class="hljs-number">50</span>,
    remove_unused_columns=<span class="hljs-literal">False</span>,
    push_to_hub=<span class="hljs-literal">True</span>,
    label_names=[<span class="hljs-string">&quot;labels&quot;</span>],
    load_best_model_at_end=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),ne=new h({props:{code:"dHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RzJTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9kYXRhc2V0JTNEdGVzdF9kcyUyQyUwQSUyMCUyMCUyMCUyMGNvbXB1dGVfbWV0cmljcyUzRGNvbXB1dGVfbWV0cmljcyUyQyUwQSk=",highlighted:`trainer = Trainer(
    model=model,
    args=training_args,
    train_dataset=train_ds,
    eval_dataset=test_ds,
    compute_metrics=compute_metrics,
)`,wrap:!1}}),pe=new h({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()",wrap:!1}}),me=new h({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1Yigp",highlighted:"trainer.push_to_hub()",wrap:!1}}),Me=new Je({props:{title:"Inference",local:"inference",headingTag:"h2"}}),ye=new h({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZzYXlha3BhdWwlMkZzYW1wbGUtZGF0YXNldHMlMkZyZXNvbHZlJTJGbWFpbiUyRnBva2Vtb24ucG5nJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBaW1hZ2U=",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

url = <span class="hljs-string">&quot;https://huggingface.co/datasets/sayakpaul/sample-datasets/resolve/main/pokemon.png&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
image`,wrap:!1}}),de=new h({props:{code:"ZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byhkZXZpY2UpJTBBcGl4ZWxfdmFsdWVzJTIwJTNEJTIwaW5wdXRzLnBpeGVsX3ZhbHVlcw==",highlighted:`device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>

inputs = processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)
pixel_values = inputs.pixel_values`,wrap:!1}}),ue=new h({props:{code:"Z2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKHBpeGVsX3ZhbHVlcyUzRHBpeGVsX3ZhbHVlcyUyQyUyMG1heF9sZW5ndGglM0Q1MCklMEFnZW5lcmF0ZWRfY2FwdGlvbiUyMCUzRCUyMHByb2Nlc3Nvci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQlMEFwcmludChnZW5lcmF0ZWRfY2FwdGlvbik=",highlighted:`generated_ids = model.generate(pixel_values=pixel_values, max_length=<span class="hljs-number">50</span>)
generated_caption = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(generated_caption)`,wrap:!1}}),fe=new h({props:{code:"YSUyMGRyYXdpbmclMjBvZiUyMGElMjBwaW5rJTIwYW5kJTIwYmx1ZSUyMHBva2Vtb24=",highlighted:"a drawing of a pink and blue pokemon",wrap:!1}}),{c(){u=i("meta"),b=a(),f=i("p"),ge=a(),o(T.$$.fragment),Ue=a(),o(U.$$.fragment),je=a(),j=i("p"),j.textContent=$t,$e=a(),$=i("p"),$.textContent=Ct,Ce=a(),C=i("ul"),C.innerHTML=_t,_e=a(),_=i("p"),_.textContent=kt,ke=a(),o(k.$$.fragment),Ie=a(),I=i("p"),I.textContent=It,ve=a(),o(v.$$.fragment),Be=a(),o(B.$$.fragment),We=a(),W=i("p"),W.innerHTML=vt,Ze=a(),o(Z.$$.fragment),Ge=a(),o(G.$$.fragment),Re=a(),R=i("p"),R.innerHTML=Bt,xe=a(),o(w.$$.fragment),He=a(),x=i("p"),x.innerHTML=Wt,Xe=a(),o(H.$$.fragment),Ve=a(),X=i("p"),X.textContent=Zt,Ye=a(),o(V.$$.fragment),Ee=a(),J=i("div"),J.innerHTML=Gt,ze=a(),o(Y.$$.fragment),Qe=a(),E=i("p"),E.textContent=Rt,Fe=a(),z=i("p"),z.textContent=xt,Ne=a(),o(Q.$$.fragment),Ae=a(),F=i("p"),F.textContent=Ht,Se=a(),o(N.$$.fragment),Le=a(),A=i("p"),A.textContent=Xt,qe=a(),o(S.$$.fragment),Pe=a(),L=i("p"),L.innerHTML=Vt,Ke=a(),o(q.$$.fragment),De=a(),o(P.$$.fragment),Oe=a(),K=i("p"),K.innerHTML=Yt,et=a(),D=i("p"),D.innerHTML=Et,tt=a(),o(O.$$.fragment),st=a(),o(ee.$$.fragment),lt=a(),te=i("p"),te.innerHTML=zt,at=a(),se=i("p"),se.innerHTML=Qt,nt=a(),o(le.$$.fragment),it=a(),ae=i("p"),ae.textContent=Ft,pt=a(),o(ne.$$.fragment),rt=a(),ie=i("p"),ie.innerHTML=Nt,ot=a(),o(pe.$$.fragment),mt=a(),re=i("p"),re.textContent=At,Mt=a(),oe=i("p"),oe.innerHTML=St,ct=a(),o(me.$$.fragment),yt=a(),o(Me.$$.fragment),dt=a(),ce=i("p"),ce.innerHTML=Lt,ht=a(),o(ye.$$.fragment),ut=a(),g=i("div"),g.innerHTML=qt,ft=ns(`
    
Prepare image for the model.

	`),o(de.$$.fragment),wt=a(),he=i("p"),he.innerHTML=Pt,Jt=a(),o(ue.$$.fragment),gt=a(),o(fe.$$.fragment),bt=a(),we=i("p"),we.textContent=Kt,Tt=a(),be=i("p"),this.h()},l(e){const t=is("svelte-u9bgzb",document.head);u=p(t,"META",{name:!0,content:!0}),t.forEach(s),b=n(e),f=p(e,"P",{}),Ot(f).forEach(s),ge=n(e),m(T.$$.fragment,e),Ue=n(e),m(U.$$.fragment,e),je=n(e),j=p(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-ws486a"&&(j.textContent=$t),$e=n(e),$=p(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1aff4p7"&&($.textContent=Ct),Ce=n(e),C=p(e,"UL",{"data-svelte-h":!0}),r(C)!=="svelte-l0kgiy"&&(C.innerHTML=_t),_e=n(e),_=p(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1c9nexd"&&(_.textContent=kt),ke=n(e),m(k.$$.fragment,e),Ie=n(e),I=p(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-27hn0u"&&(I.textContent=It),ve=n(e),m(v.$$.fragment,e),Be=n(e),m(B.$$.fragment,e),We=n(e),W=p(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1ijrbcw"&&(W.innerHTML=vt),Ze=n(e),m(Z.$$.fragment,e),Ge=n(e),m(G.$$.fragment,e),Re=n(e),R=p(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-14ukxt"&&(R.innerHTML=Bt),xe=n(e),m(w.$$.fragment,e),He=n(e),x=p(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-mi4jsl"&&(x.innerHTML=Wt),Xe=n(e),m(H.$$.fragment,e),Ve=n(e),X=p(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1fsrtvj"&&(X.textContent=Zt),Ye=n(e),m(V.$$.fragment,e),Ee=n(e),J=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(J)!=="svelte-1qemygy"&&(J.innerHTML=Gt),ze=n(e),m(Y.$$.fragment,e),Qe=n(e),E=p(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1ogvs11"&&(E.textContent=Rt),Fe=n(e),z=p(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1shh6cf"&&(z.textContent=xt),Ne=n(e),m(Q.$$.fragment,e),Ae=n(e),F=p(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-l3qjuh"&&(F.textContent=Ht),Se=n(e),m(N.$$.fragment,e),Le=n(e),A=p(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1bhogex"&&(A.textContent=Xt),qe=n(e),m(S.$$.fragment,e),Pe=n(e),L=p(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-n2g9rz"&&(L.innerHTML=Vt),Ke=n(e),m(q.$$.fragment,e),De=n(e),m(P.$$.fragment,e),Oe=n(e),K=p(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1tzk2iw"&&(K.innerHTML=Yt),et=n(e),D=p(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-e8lgr2"&&(D.innerHTML=Et),tt=n(e),m(O.$$.fragment,e),st=n(e),m(ee.$$.fragment,e),lt=n(e),te=p(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1c4yipi"&&(te.innerHTML=zt),at=n(e),se=p(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-phbw8m"&&(se.innerHTML=Qt),nt=n(e),m(le.$$.fragment,e),it=n(e),ae=p(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-y5ywt5"&&(ae.textContent=Ft),pt=n(e),m(ne.$$.fragment,e),rt=n(e),ie=p(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-15tefr6"&&(ie.innerHTML=Nt),ot=n(e),m(pe.$$.fragment,e),mt=n(e),re=p(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-acs4yg"&&(re.textContent=At),Mt=n(e),oe=p(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1v13hlo"&&(oe.innerHTML=St),ct=n(e),m(me.$$.fragment,e),yt=n(e),m(Me.$$.fragment,e),dt=n(e),ce=p(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-16tgs9z"&&(ce.innerHTML=Lt),ht=n(e),m(ye.$$.fragment,e),ut=n(e),g=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(g)!=="svelte-yvzmn4"&&(g.innerHTML=qt),ft=ps(e,`
    
Prepare image for the model.

	`),m(de.$$.fragment,e),wt=n(e),he=p(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-1rbuk2y"&&(he.innerHTML=Pt),Jt=n(e),m(ue.$$.fragment,e),gt=n(e),m(fe.$$.fragment,e),bt=n(e),we=p(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-vibkpa"&&(we.textContent=Kt),Tt=n(e),be=p(e,"P",{}),Ot(be).forEach(s),this.h()},h(){jt(u,"name","hf:doc:metadata"),jt(u,"content",ys),jt(J,"class","flex justify-center"),jt(g,"class","flex justify-center")},m(e,t){rs(document.head,u),l(e,b,t),l(e,f,t),l(e,ge,t),M(T,e,t),l(e,Ue,t),M(U,e,t),l(e,je,t),l(e,j,t),l(e,$e,t),l(e,$,t),l(e,Ce,t),l(e,C,t),l(e,_e,t),l(e,_,t),l(e,ke,t),M(k,e,t),l(e,Ie,t),l(e,I,t),l(e,ve,t),M(v,e,t),l(e,Be,t),M(B,e,t),l(e,We,t),l(e,W,t),l(e,Ze,t),M(Z,e,t),l(e,Ge,t),M(G,e,t),l(e,Re,t),l(e,R,t),l(e,xe,t),M(w,e,t),l(e,He,t),l(e,x,t),l(e,Xe,t),M(H,e,t),l(e,Ve,t),l(e,X,t),l(e,Ye,t),M(V,e,t),l(e,Ee,t),l(e,J,t),l(e,ze,t),M(Y,e,t),l(e,Qe,t),l(e,E,t),l(e,Fe,t),l(e,z,t),l(e,Ne,t),M(Q,e,t),l(e,Ae,t),l(e,F,t),l(e,Se,t),M(N,e,t),l(e,Le,t),l(e,A,t),l(e,qe,t),M(S,e,t),l(e,Pe,t),l(e,L,t),l(e,Ke,t),M(q,e,t),l(e,De,t),M(P,e,t),l(e,Oe,t),l(e,K,t),l(e,et,t),l(e,D,t),l(e,tt,t),M(O,e,t),l(e,st,t),M(ee,e,t),l(e,lt,t),l(e,te,t),l(e,at,t),l(e,se,t),l(e,nt,t),M(le,e,t),l(e,it,t),l(e,ae,t),l(e,pt,t),M(ne,e,t),l(e,rt,t),l(e,ie,t),l(e,ot,t),M(pe,e,t),l(e,mt,t),l(e,re,t),l(e,Mt,t),l(e,oe,t),l(e,ct,t),M(me,e,t),l(e,yt,t),M(Me,e,t),l(e,dt,t),l(e,ce,t),l(e,ht,t),M(ye,e,t),l(e,ut,t),l(e,g,t),l(e,ft,t),M(de,e,t),l(e,wt,t),l(e,he,t),l(e,Jt,t),M(ue,e,t),l(e,gt,t),M(fe,e,t),l(e,bt,t),l(e,we,t),l(e,Tt,t),l(e,be,t),Ut=!0},p(e,[t]){const Dt={};t&2&&(Dt.$$scope={dirty:t,ctx:e}),w.$set(Dt)},i(e){Ut||(c(T.$$.fragment,e),c(U.$$.fragment,e),c(k.$$.fragment,e),c(v.$$.fragment,e),c(B.$$.fragment,e),c(Z.$$.fragment,e),c(G.$$.fragment,e),c(w.$$.fragment,e),c(H.$$.fragment,e),c(V.$$.fragment,e),c(Y.$$.fragment,e),c(Q.$$.fragment,e),c(N.$$.fragment,e),c(S.$$.fragment,e),c(q.$$.fragment,e),c(P.$$.fragment,e),c(O.$$.fragment,e),c(ee.$$.fragment,e),c(le.$$.fragment,e),c(ne.$$.fragment,e),c(pe.$$.fragment,e),c(me.$$.fragment,e),c(Me.$$.fragment,e),c(ye.$$.fragment,e),c(de.$$.fragment,e),c(ue.$$.fragment,e),c(fe.$$.fragment,e),Ut=!0)},o(e){y(T.$$.fragment,e),y(U.$$.fragment,e),y(k.$$.fragment,e),y(v.$$.fragment,e),y(B.$$.fragment,e),y(Z.$$.fragment,e),y(G.$$.fragment,e),y(w.$$.fragment,e),y(H.$$.fragment,e),y(V.$$.fragment,e),y(Y.$$.fragment,e),y(Q.$$.fragment,e),y(N.$$.fragment,e),y(S.$$.fragment,e),y(q.$$.fragment,e),y(P.$$.fragment,e),y(O.$$.fragment,e),y(ee.$$.fragment,e),y(le.$$.fragment,e),y(ne.$$.fragment,e),y(pe.$$.fragment,e),y(me.$$.fragment,e),y(Me.$$.fragment,e),y(ye.$$.fragment,e),y(de.$$.fragment,e),y(ue.$$.fragment,e),y(fe.$$.fragment,e),Ut=!1},d(e){e&&(s(b),s(f),s(ge),s(Ue),s(je),s(j),s($e),s($),s(Ce),s(C),s(_e),s(_),s(ke),s(Ie),s(I),s(ve),s(Be),s(We),s(W),s(Ze),s(Ge),s(Re),s(R),s(xe),s(He),s(x),s(Xe),s(Ve),s(X),s(Ye),s(Ee),s(J),s(ze),s(Qe),s(E),s(Fe),s(z),s(Ne),s(Ae),s(F),s(Se),s(Le),s(A),s(qe),s(Pe),s(L),s(Ke),s(De),s(Oe),s(K),s(et),s(D),s(tt),s(st),s(lt),s(te),s(at),s(se),s(nt),s(it),s(ae),s(pt),s(rt),s(ie),s(ot),s(mt),s(re),s(Mt),s(oe),s(ct),s(yt),s(dt),s(ce),s(ht),s(ut),s(g),s(ft),s(wt),s(he),s(Jt),s(gt),s(bt),s(we),s(Tt),s(be)),s(u),d(T,e),d(U,e),d(k,e),d(v,e),d(B,e),d(Z,e),d(G,e),d(w,e),d(H,e),d(V,e),d(Y,e),d(Q,e),d(N,e),d(S,e),d(q,e),d(P,e),d(O,e),d(ee,e),d(le,e),d(ne,e),d(pe,e),d(me,e),d(Me,e),d(ye,e),d(de,e),d(ue,e),d(fe,e)}}}const ys='{"title":"Image captioning","local":"image-captioning","sections":[{"title":"Load the Pokémon BLIP captions dataset","local":"load-the-pokémon-blip-captions-dataset","sections":[],"depth":2},{"title":"Preprocess the dataset","local":"preprocess-the-dataset","sections":[],"depth":2},{"title":"Load a base model","local":"load-a-base-model","sections":[],"depth":2},{"title":"Evaluate","local":"evaluate","sections":[],"depth":2},{"title":"Train!","local":"train","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2}],"depth":1}';function ds(Te){return ts(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bs extends ls{constructor(u){super(),as(this,u,ds,cs,es,{})}}export{bs as component};
