import{s as Zt,o as It,n as rt}from"../chunks/scheduler.22bf70d2.js";import{S as At,i as Wt,g as f,s as c,r as h,A as Xt,h as u,f as a,c as n,j as kt,u as y,x as T,k as Ct,y as Rt,a as l,v as M,d as w,t as $,w as g}from"../chunks/index.59178e06.js";import{T as ct}from"../chunks/Tip.75d940ba.js";import{C as k}from"../chunks/CodeBlock.f7047b13.js";import{H as C}from"../chunks/Heading.f8746c79.js";import{H as Yt,a as Gt}from"../chunks/HfOption.04cc3620.js";function Ht(j){let r,b="Accelerate only prepares objects that inherit from their respective PyTorch classes such as <code>torch.optim.Optimizer</code>.";return{c(){r=f("p"),r.innerHTML=b},l(i){r=u(i,"P",{"data-svelte-h":!0}),T(r)!=="svelte-1oh2ah6"&&(r.innerHTML=b)},m(i,m){l(i,r,m)},p:rt,d(i){i&&a(r)}}}function Vt(j){let r,b='Accelerate enables automatic mixed precision, so <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.autocast">autocast()</a> is only needed if there are other mixed precision operations besides those performed on loss by <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.backward">backward()</a> which already handles the scaling.';return{c(){r=f("p"),r.innerHTML=b},l(i){r=u(i,"P",{"data-svelte-h":!0}),T(r)!=="svelte-17p4of7"&&(r.innerHTML=b)},m(i,m){l(i,r,m)},p:rt,d(i){i&&a(r)}}}function Bt(j){let r,b='For models from the <a href="https://hf.co/docs/transformers/index" rel="nofollow">Transformers</a> library, save the model with the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.save_pretrained" rel="nofollow">save_pretrained</a> method so that it can be reloaded with the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained" rel="nofollow">from_pretrained</a> method.',i,m,o;return m=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQSUwQXVud3JhcHBlZF9tb2RlbCUyMCUzRCUyMGFjY2VsZXJhdG9yLnVud3JhcF9tb2RlbChtb2RlbCklMEF1bndyYXBwZWRfbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnBhdGglMkZ0byUyRm15X21vZGVsX2RpcmVjdG9yeSUyMiUyQyUwQSUyMCUyMCUyMCUyMGlzX21haW5fcHJvY2VzcyUzRGFjY2VsZXJhdG9yLmlzX21haW5fcHJvY2VzcyUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfZnVuY3Rpb24lM0RhY2NlbGVyYXRvci5zYXZlJTJDJTBBKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJwYXRoJTJGdG8lMkZteV9tb2RlbF9kaXJlY3RvcnklMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel

unwrapped_model = accelerator.unwrap_model(model)
unwrapped_model.save_pretrained(
    <span class="hljs-string">&quot;path/to/my_model_directory&quot;</span>,
    is_main_process=accelerator.is_main_process,
    save_function=accelerator.save,
)

model = AutoModel.from_pretrained(<span class="hljs-string">&quot;path/to/my_model_directory&quot;</span>)`,wrap:!1}}),{c(){r=f("p"),r.innerHTML=b,i=c(),h(m.$$.fragment)},l(d){r=u(d,"P",{"data-svelte-h":!0}),T(r)!=="svelte-y3y63b"&&(r.innerHTML=b),i=n(d),y(m.$$.fragment,d)},m(d,U){l(d,r,U),l(d,i,U),M(m,d,U),o=!0},p:rt,i(d){o||(w(m.$$.fragment,d),o=!0)},o(d){$(m.$$.fragment,d),o=!1},d(d){d&&(a(r),a(i)),g(m,d)}}}function zt(j){let r,b,i,m,o,d='To load your weights, use the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.unwrap_model">unwrap_model()</a> method to unwrap the model first before loading the weights. All model parameters are references to tensors, so this loads your weights inside <code>model</code>.',U,J,_;return r=new k({props:{code:"YWNjZWxlcmF0b3Iud2FpdF9mb3JfZXZlcnlvbmUoKSUwQWFjY2VsZXJhdG9yLnNhdmVfbW9kZWwobW9kZWwlMkMlMjBzYXZlX2RpcmVjdG9yeSk=",highlighted:`accelerator.wait_for_everyone()
accelerator.save_model(model, save_directory)`,wrap:!1}}),i=new ct({props:{$$slots:{default:[Bt]},$$scope:{ctx:j}}}),J=new k({props:{code:"dW53cmFwcGVkX21vZGVsJTIwJTNEJTIwYWNjZWxlcmF0b3IudW53cmFwX21vZGVsKG1vZGVsKSUwQXBhdGhfdG9fY2hlY2twb2ludCUyMCUzRCUyMG9zLnBhdGguam9pbihzYXZlX2RpcmVjdG9yeSUyQyUyMnB5dG9yY2hfbW9kZWwuYmluJTIyKSUwQXVud3JhcHBlZF9tb2RlbC5sb2FkX3N0YXRlX2RpY3QodG9yY2gubG9hZChwYXRoX3RvX2NoZWNrcG9pbnQpKQ==",highlighted:`unwrapped_model = accelerator.unwrap_model(model)
path_to_checkpoint = os.path.join(save_directory,<span class="hljs-string">&quot;pytorch_model.bin&quot;</span>)
unwrapped_model.load_state_dict(torch.load(path_to_checkpoint))`,wrap:!1}}),{c(){h(r.$$.fragment),b=c(),h(i.$$.fragment),m=c(),o=f("p"),o.innerHTML=d,U=c(),h(J.$$.fragment)},l(s){y(r.$$.fragment,s),b=n(s),y(i.$$.fragment,s),m=n(s),o=u(s,"P",{"data-svelte-h":!0}),T(o)!=="svelte-js2qkb"&&(o.innerHTML=d),U=n(s),y(J.$$.fragment,s)},m(s,p){M(r,s,p),l(s,b,p),M(i,s,p),l(s,m,p),l(s,o,p),l(s,U,p),M(J,s,p),_=!0},p(s,p){const v={};p&2&&(v.$$scope={dirty:p,ctx:s}),i.$set(v)},i(s){_||(w(r.$$.fragment,s),w(i.$$.fragment,s),w(J.$$.fragment,s),_=!0)},o(s){$(r.$$.fragment,s),$(i.$$.fragment,s),$(J.$$.fragment,s),_=!1},d(s){s&&(a(b),a(m),a(o),a(U)),g(r,s),g(i,s),g(J,s)}}}function xt(j){let r,b="Set <code>safe_serialization=True</code> to save the model in the safetensor format.",i,m,o,d,U='To load a sharded checkpoint or a safetensor formatted checkpoint, use the <a href="/docs/accelerate/main/en/package_reference/big_modeling#accelerate.load_checkpoint_in_model">load_checkpoint_in_model()</a> method. This method allows you to load a checkpoint onto a specific device.',J,_,s;return m=new k({props:{code:"YWNjZWxlcmF0b3Iud2FpdF9mb3JfZXZlcnlvbmUoKSUwQWFjY2VsZXJhdG9yLnNhdmVfbW9kZWwobW9kZWwlMkMlMjBzYXZlX2RpcmVjdG9yeSUyQyUyMG1heF9zaGFyZF9zaXplJTNEJTIyMUdCJTIyJTJDJTIwc2FmZV9zZXJpYWxpemF0aW9uJTNEVHJ1ZSk=",highlighted:`accelerator.wait_for_everyone()
accelerator.save_model(model, save_directory, max_shard_size=<span class="hljs-string">&quot;1GB&quot;</span>, safe_serialization=<span class="hljs-literal">True</span>)`,wrap:!1}}),_=new k({props:{code:"bG9hZF9jaGVja3BvaW50X2luX21vZGVsKHVud3JhcHBlZF9tb2RlbCUyQyUyMHNhdmVfZGlyZWN0b3J5JTJDJTIwZGV2aWNlX21hcCUzRCU3QiUyMiUyMiUzQWRldmljZSU3RCk=",highlighted:'load_checkpoint_in_model(unwrapped_model, save_directory, device_map={<span class="hljs-string">&quot;&quot;</span>:device})',wrap:!1}}),{c(){r=f("p"),r.innerHTML=b,i=c(),h(m.$$.fragment),o=c(),d=f("p"),d.innerHTML=U,J=c(),h(_.$$.fragment)},l(p){r=u(p,"P",{"data-svelte-h":!0}),T(r)!=="svelte-jahj75"&&(r.innerHTML=b),i=n(p),y(m.$$.fragment,p),o=n(p),d=u(p,"P",{"data-svelte-h":!0}),T(d)!=="svelte-70qodr"&&(d.innerHTML=U),J=n(p),y(_.$$.fragment,p)},m(p,v){l(p,r,v),l(p,i,v),M(m,p,v),l(p,o,v),l(p,d,v),l(p,J,v),M(_,p,v),s=!0},p:rt,i(p){s||(w(m.$$.fragment,p),w(_.$$.fragment,p),s=!0)},o(p){$(m.$$.fragment,p),$(_.$$.fragment,p),s=!1},d(p){p&&(a(r),a(i),a(o),a(d),a(J)),g(m,p),g(_,p)}}}function Ft(j){let r,b,i,m;return r=new Gt({props:{id:"save",option:"single checkpoint",$$slots:{default:[zt]},$$scope:{ctx:j}}}),i=new Gt({props:{id:"save",option:"sharded checkpoint",$$slots:{default:[xt]},$$scope:{ctx:j}}}),{c(){h(r.$$.fragment),b=c(),h(i.$$.fragment)},l(o){y(r.$$.fragment,o),b=n(o),y(i.$$.fragment,o)},m(o,d){M(r,o,d),l(o,b,d),M(i,o,d),m=!0},p(o,d){const U={};d&2&&(U.$$scope={dirty:d,ctx:o}),r.$set(U);const J={};d&2&&(J.$$scope={dirty:d,ctx:o}),i.$set(J)},i(o){m||(w(r.$$.fragment,o),w(i.$$.fragment,o),m=!0)},o(o){$(r.$$.fragment,o),$(i.$$.fragment,o),m=!1},d(o){o&&a(b),g(r,o),g(i,o)}}}function Qt(j){let r,b,i,m,o,d,U,J="Each distributed training framework has their own way of doing things which can require writing a lot of custom code to adapt it to your PyTorch training code and training environment. Accelerate offers a friendly way to interface with these distributed training frameworks without having to learn the specific details of each one. Accelerate takes care of those details for you, so you can focus on the training code and scale it to any distributed training environment.",_,s,p="In this tutorial, you’ll learn how to adapt your existing PyTorch code with Accelerate and get you on your way toward training on distributed systems with ease! You’ll start with a basic PyTorch training loop (it assumes all the training objects like <code>model</code> and <code>optimizer</code> have been setup already) and progressively integrate Accelerate into it.",v,A,Me,W,we,X,nt='The <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> is the main class for adapting your code to work with Accelerate. It knows about the distributed setup you’re using such as the number of different processes and your hardware type. This class also provides access to many of the necessary methods for enabling your PyTorch code to work in any distributed training environment and for managing and executing processes across devices.',$e,R,ot='That’s why you should always start by importing and creating an <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> instance in your script.',ge,Y,Te,H,it='The <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> also knows which device to move your PyTorch objects to, so it is recommended to let Accelerate handle this for you.',be,V,Ue,B,Je,z,st='Next, you need to prepare your PyTorch objects (model, optimizer, scheduler, etc.) for distributed training. The <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.prepare">prepare()</a> method takes care of placing your model in the appropriate container (like single GPU or multi-GPU) for your training setup, adapting the optimizer and scheduler to use Accelerate’s <a href="/docs/accelerate/main/en/package_reference/torch_wrappers#accelerate.optimizer.AcceleratedOptimizer">AcceleratedOptimizer</a> and <a href="/docs/accelerate/main/en/package_reference/torch_wrappers#accelerate.scheduler.AcceleratedScheduler">AcceleratedScheduler</a>, and creating a new dataloader that can be sharded across processes.',_e,G,ve,x,dt="The PyTorch objects are returned in the same order they’re sent.",je,F,ke,Q,Ce,S,pt='Finally, remove the <code>to(device)</code> calls to the inputs and targets in the training loop because Accelerate’s DataLoader classes automatically places them on the right device. You should also replace the usual <code>backward()</code> pass with Accelerate’s <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.backward">backward()</a> method which scales the gradients for you and uses the appropriate <code>backward()</code> method depending on your distributed setup (for example, DeepSpeed or Megatron).',Ge,N,Ze,L,mt="Put everything together and your new Accelerate training loop should now look like this!",Ie,P,Ae,E,We,K,ft="Accelerate offers additional features - like gradient accumulation, gradient clipping, mixed precision training and more - you can add to your script to improve your training run. Let’s explore these three features.",Xe,q,Re,D,ut='Gradient accumulation enables you to train on larger batch sizes by accumulating the gradients over multiple batches before updating the weights. This can be useful for getting around memory limitations. To enable this feature in Accelerate, specify the <code>gradient_accumulation_steps</code> parameter in the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> class and add the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.accumulate">accumulate()</a> context manager to your script.',Ye,O,He,ee,Ve,te,ht="Gradient clipping is a technique to prevent “exploding gradients”, and Accelerate offers:",Be,ae,yt='<li><a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.clip_grad_value_">clip<em>grad_value</em>()</a> to clip gradients to a minimum and maximum value</li> <li><a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.clip_grad_norm_">clip<em>grad_norm</em>()</a> for normalizing gradients to a certain value</li>',ze,le,xe,re,Mt="Mixed precision accelerates training by using a lower precision data type like fp16 (half-precision) to calculate the gradients. For the best performance with Accelerate, the loss should be computed inside your model (like in Transformers models) because computations outside of the model are computed in full precision.",Fe,ce,wt='Set the mixed precision type to use in the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a>, and then use the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.autocast">autocast()</a> context manager to automatically cast the values to the specified data type.',Qe,Z,Se,ne,Ne,oe,Le,ie,$t="Accelerate can also save and load a <em>model</em> once training is complete or you can also save the model and optimizer <em>state</em> which could be useful for resuming training.",Pe,se,Ee,de,gt='Once all processes are complete, unwrap the model with the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.unwrap_model">unwrap_model()</a> method before saving it because the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.prepare">prepare()</a> method wrapped your model into the proper interface for distributed training. If you don’t unwrap the model, saving the model state dictionary also saves any potential extra layers from the larger model and you won’t be able to load the weights back into your base model.',Ke,pe,Tt='You should use the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.save_model">save_model()</a> method to unwrap and save the model state dictionary. This method can also save a model into sharded checkpoints or into the <a href="https://hf.co/docs/safetensors/index" rel="nofollow">safetensors</a> format.',qe,I,De,me,Oe,fe,bt='During training, you may want to save the current state of the model, optimizer, random generators, and potentially learning rate schedulers so they can be restored in the <em>same script</em>. You should add the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.save_state">save_state()</a> and <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.load_state">load_state()</a> methods to your script to save and load states.',et,ue,Ut='To further customize where and how states are saved through <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.save_state">save_state()</a>, use the <a href="/docs/accelerate/main/en/package_reference/utilities#accelerate.utils.ProjectConfiguration">ProjectConfiguration</a> class. For example, if <code>automatic_checkpoint_naming</code> is enabled, each saved checkpoint is stored at <code>Accelerator.project_dir/checkpoints/checkpoint_{checkpoint_number}</code>.',tt,he,Jt='Any other stateful items to be stored should be registered with the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.register_for_checkpointing">register_for_checkpointing()</a> method so they can be saved and loaded. Every object passed to this method to be stored must have a <code>load_state_dict</code> and <code>state_dict</code> function.',at,ye,lt;return o=new C({props:{title:"Add Accelerate to your code",local:"add-accelerate-to-your-code",headingTag:"h1"}}),A=new k({props:{code:"ZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUwQW1vZGVsLnRvKGRldmljZSklMEElMEFmb3IlMjBiYXRjaCUyMGluJTIwdHJhaW5pbmdfZGF0YWxvYWRlciUzQSUwQSUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKSUwQSUyMCUyMCUyMCUyMGlucHV0cyUyQyUyMHRhcmdldHMlMjAlM0QlMjBiYXRjaCUwQSUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMGlucHV0cy50byhkZXZpY2UpJTBBJTIwJTIwJTIwJTIwdGFyZ2V0cyUyMCUzRCUyMHRhcmdldHMudG8oZGV2aWNlKSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbChpbnB1dHMpJTBBJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMGxvc3NfZnVuY3Rpb24ob3V0cHV0cyUyQyUyMHRhcmdldHMpJTBBJTIwJTIwJTIwJTIwbG9zcy5iYWNrd2FyZCgpJTBBJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMHNjaGVkdWxlci5zdGVwKCk=",highlighted:`device = <span class="hljs-string">&quot;cuda&quot;</span>
model.to(device)

<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> training_dataloader:
    optimizer.zero_grad()
    inputs, targets = batch
    inputs = inputs.to(device)
    targets = targets.to(device)
    outputs = model(inputs)
    loss = loss_function(outputs, targets)
    loss.backward()
    optimizer.step()
    scheduler.step()`,wrap:!1}}),W=new C({props:{title:"Accelerator",local:"accelerator",headingTag:"h2"}}),Y=new k({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

accelerator = Accelerator()`,wrap:!1}}),V=new k({props:{code:"LSUyMGRldmljZSUyMCUzRCUyMCUyMmN1ZGElMjIlMEElMkIlMjBkZXZpY2UlMjAlM0QlMjBhY2NlbGVyYXRvci5kZXZpY2UlMEElMjAlMjBtb2RlbC50byhkZXZpY2Up",highlighted:`<span class="hljs-deletion">- device = &quot;cuda&quot;</span>
<span class="hljs-addition">+ device = accelerator.device</span>
  model.to(device)`,wrap:!1}}),B=new C({props:{title:"Prepare PyTorch objects",local:"prepare-pytorch-objects",headingTag:"h2"}}),G=new ct({props:{warning:!1,$$slots:{default:[Ht]},$$scope:{ctx:j}}}),F=new k({props:{code:"bW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjB0cmFpbmluZ19kYXRhbG9hZGVyJTJDJTIwc2NoZWR1bGVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZSglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUyMG9wdGltaXplciUyQyUyMHRyYWluaW5nX2RhdGFsb2FkZXIlMkMlMjBzY2hlZHVsZXIlMEEp",highlighted:`model, optimizer, training_dataloader, scheduler = accelerator.prepare(
    model, optimizer, training_dataloader, scheduler
)`,wrap:!1}}),Q=new C({props:{title:"Training loop",local:"training-loop",headingTag:"h2"}}),N=new k({props:{code:"LSUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMGlucHV0cy50byhkZXZpY2UpJTBBLSUyMCUyMCUyMHRhcmdldHMlMjAlM0QlMjB0YXJnZXRzLnRvKGRldmljZSklMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoaW5wdXRzKSUwQSUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBsb3NzX2Z1bmN0aW9uKG91dHB1dHMlMkMlMjB0YXJnZXRzKSUwQS0lMjAlMjAlMjBsb3NzLmJhY2t3YXJkKCklMEElMkIlMjAlMjAlMjBhY2NlbGVyYXRvci5iYWNrd2FyZChsb3NzKQ==",highlighted:`<span class="hljs-deletion">-   inputs = inputs.to(device)</span>
<span class="hljs-deletion">-   targets = targets.to(device)</span>
    outputs = model(inputs)
    loss = loss_function(outputs, targets)
<span class="hljs-deletion">-   loss.backward()</span>
<span class="hljs-addition">+   accelerator.backward(loss)</span>`,wrap:!1}}),P=new k({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQSUwQWRldmljZSUyMCUzRCUyMGFjY2VsZXJhdG9yLmRldmljZSUwQW1vZGVsJTJDJTIwb3B0aW1pemVyJTJDJTIwdHJhaW5pbmdfZGF0YWxvYWRlciUyQyUyMHNjaGVkdWxlciUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjB0cmFpbmluZ19kYXRhbG9hZGVyJTJDJTIwc2NoZWR1bGVyJTBBKSUwQSUwQWZvciUyMGJhdGNoJTIwaW4lMjB0cmFpbmluZ19kYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwb3B0aW1pemVyLnplcm9fZ3JhZCgpJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTJDJTIwdGFyZ2V0cyUyMCUzRCUyMGJhdGNoJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0cyklMEElMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwbG9zc19mdW5jdGlvbihvdXRwdXRzJTJDJTIwdGFyZ2V0cyklMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvci5iYWNrd2FyZChsb3NzKSUwQSUyMCUyMCUyMCUyMG9wdGltaXplci5zdGVwKCklMEElMjAlMjAlMjAlMjBzY2hlZHVsZXIuc3RlcCgp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
accelerator = Accelerator()

device = accelerator.device
model, optimizer, training_dataloader, scheduler = accelerator.prepare(
    model, optimizer, training_dataloader, scheduler
)

<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> training_dataloader:
    optimizer.zero_grad()
    inputs, targets = batch
    outputs = model(inputs)
    loss = loss_function(outputs, targets)
    accelerator.backward(loss)
    optimizer.step()
    scheduler.step()`,wrap:!1}}),E=new C({props:{title:"Training features",local:"training-features",headingTag:"h2"}}),q=new C({props:{title:"Gradient accumulation",local:"gradient-accumulation",headingTag:"h3"}}),O=new k({props:{code:"JTJCJTIwYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcihncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0QyKSUwQSUyMCUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTJDJTIwdHJhaW5pbmdfZGF0YWxvYWRlciUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUobW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjB0cmFpbmluZ19kYXRhbG9hZGVyKSUwQSUwQSUyMCUyMGZvciUyMGlucHV0JTJDJTIwbGFiZWwlMjBpbiUyMHRyYWluaW5nX2RhdGFsb2FkZXIlM0ElMEElMkIlMjAlMjAlMjAlMjAlMjB3aXRoJTIwYWNjZWxlcmF0b3IuYWNjdW11bGF0ZShtb2RlbCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmVkaWN0aW9ucyUyMCUzRCUyMG1vZGVsKGlucHV0KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBsb3NzX2Z1bmN0aW9uKHByZWRpY3Rpb25zJTJDJTIwbGFiZWwpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3IuYmFja3dhcmQobG9zcyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2NoZWR1bGVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKQ==",highlighted:`<span class="hljs-addition">+ accelerator = Accelerator(gradient_accumulation_steps=2)</span>
  model, optimizer, training_dataloader = accelerator.prepare(model, optimizer, training_dataloader)

  for input, label in training_dataloader:
<span class="hljs-addition">+     with accelerator.accumulate(model):</span>
          predictions = model(input)
          loss = loss_function(predictions, label)
          accelerator.backward(loss)
          optimizer.step()
          scheduler.step()
          optimizer.zero_grad()`,wrap:!1}}),ee=new C({props:{title:"Gradient clipping",local:"gradient-clipping",headingTag:"h3"}}),le=new C({props:{title:"Mixed precision",local:"mixed-precision",headingTag:"h3"}}),Z=new ct({props:{warning:!0,$$slots:{default:[Vt]},$$scope:{ctx:j}}}),ne=new k({props:{code:"JTJCJTIwYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcihtaXhlZF9wcmVjaXNpb24lM0QlMjJmcDE2JTIyKSUwQSUyQiUyMHdpdGglMjBhY2NlbGVyYXRvci5hdXRvY2FzdCgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMGNvbXBsZXhfbG9zc19mdW5jdGlvbihvdXRwdXRzJTJDJTIwdGFyZ2V0KSUzQQ==",highlighted:`<span class="hljs-addition">+ accelerator = Accelerator(mixed_precision=&quot;fp16&quot;)</span>
<span class="hljs-addition">+ with accelerator.autocast():</span>
      loss = complex_loss_function(outputs, target):`,wrap:!1}}),oe=new C({props:{title:"Save and load",local:"save-and-load",headingTag:"h2"}}),se=new C({props:{title:"Model",local:"model",headingTag:"h3"}}),I=new Yt({props:{id:"save",options:["single checkpoint","sharded checkpoint"],$$slots:{default:[Ft]},$$scope:{ctx:j}}}),me=new C({props:{title:"State",local:"state",headingTag:"h3"}}),{c(){r=f("meta"),b=c(),i=f("p"),m=c(),h(o.$$.fragment),d=c(),U=f("p"),U.textContent=J,_=c(),s=f("p"),s.innerHTML=p,v=c(),h(A.$$.fragment),Me=c(),h(W.$$.fragment),we=c(),X=f("p"),X.innerHTML=nt,$e=c(),R=f("p"),R.innerHTML=ot,ge=c(),h(Y.$$.fragment),Te=c(),H=f("p"),H.innerHTML=it,be=c(),h(V.$$.fragment),Ue=c(),h(B.$$.fragment),Je=c(),z=f("p"),z.innerHTML=st,_e=c(),h(G.$$.fragment),ve=c(),x=f("p"),x.textContent=dt,je=c(),h(F.$$.fragment),ke=c(),h(Q.$$.fragment),Ce=c(),S=f("p"),S.innerHTML=pt,Ge=c(),h(N.$$.fragment),Ze=c(),L=f("p"),L.textContent=mt,Ie=c(),h(P.$$.fragment),Ae=c(),h(E.$$.fragment),We=c(),K=f("p"),K.textContent=ft,Xe=c(),h(q.$$.fragment),Re=c(),D=f("p"),D.innerHTML=ut,Ye=c(),h(O.$$.fragment),He=c(),h(ee.$$.fragment),Ve=c(),te=f("p"),te.textContent=ht,Be=c(),ae=f("ul"),ae.innerHTML=yt,ze=c(),h(le.$$.fragment),xe=c(),re=f("p"),re.textContent=Mt,Fe=c(),ce=f("p"),ce.innerHTML=wt,Qe=c(),h(Z.$$.fragment),Se=c(),h(ne.$$.fragment),Ne=c(),h(oe.$$.fragment),Le=c(),ie=f("p"),ie.innerHTML=$t,Pe=c(),h(se.$$.fragment),Ee=c(),de=f("p"),de.innerHTML=gt,Ke=c(),pe=f("p"),pe.innerHTML=Tt,qe=c(),h(I.$$.fragment),De=c(),h(me.$$.fragment),Oe=c(),fe=f("p"),fe.innerHTML=bt,et=c(),ue=f("p"),ue.innerHTML=Ut,tt=c(),he=f("p"),he.innerHTML=Jt,at=c(),ye=f("p"),this.h()},l(e){const t=Xt("svelte-u9bgzb",document.head);r=u(t,"META",{name:!0,content:!0}),t.forEach(a),b=n(e),i=u(e,"P",{}),kt(i).forEach(a),m=n(e),y(o.$$.fragment,e),d=n(e),U=u(e,"P",{"data-svelte-h":!0}),T(U)!=="svelte-19zbp5z"&&(U.textContent=J),_=n(e),s=u(e,"P",{"data-svelte-h":!0}),T(s)!=="svelte-1lmjen8"&&(s.innerHTML=p),v=n(e),y(A.$$.fragment,e),Me=n(e),y(W.$$.fragment,e),we=n(e),X=u(e,"P",{"data-svelte-h":!0}),T(X)!=="svelte-1dn1lk2"&&(X.innerHTML=nt),$e=n(e),R=u(e,"P",{"data-svelte-h":!0}),T(R)!=="svelte-zcqlut"&&(R.innerHTML=ot),ge=n(e),y(Y.$$.fragment,e),Te=n(e),H=u(e,"P",{"data-svelte-h":!0}),T(H)!=="svelte-1csx4md"&&(H.innerHTML=it),be=n(e),y(V.$$.fragment,e),Ue=n(e),y(B.$$.fragment,e),Je=n(e),z=u(e,"P",{"data-svelte-h":!0}),T(z)!=="svelte-wqk9uz"&&(z.innerHTML=st),_e=n(e),y(G.$$.fragment,e),ve=n(e),x=u(e,"P",{"data-svelte-h":!0}),T(x)!=="svelte-l5v2wx"&&(x.textContent=dt),je=n(e),y(F.$$.fragment,e),ke=n(e),y(Q.$$.fragment,e),Ce=n(e),S=u(e,"P",{"data-svelte-h":!0}),T(S)!=="svelte-i5xqdp"&&(S.innerHTML=pt),Ge=n(e),y(N.$$.fragment,e),Ze=n(e),L=u(e,"P",{"data-svelte-h":!0}),T(L)!=="svelte-1b6tm11"&&(L.textContent=mt),Ie=n(e),y(P.$$.fragment,e),Ae=n(e),y(E.$$.fragment,e),We=n(e),K=u(e,"P",{"data-svelte-h":!0}),T(K)!=="svelte-1ef6475"&&(K.textContent=ft),Xe=n(e),y(q.$$.fragment,e),Re=n(e),D=u(e,"P",{"data-svelte-h":!0}),T(D)!=="svelte-1nruvdz"&&(D.innerHTML=ut),Ye=n(e),y(O.$$.fragment,e),He=n(e),y(ee.$$.fragment,e),Ve=n(e),te=u(e,"P",{"data-svelte-h":!0}),T(te)!=="svelte-bg95gl"&&(te.textContent=ht),Be=n(e),ae=u(e,"UL",{"data-svelte-h":!0}),T(ae)!=="svelte-3kii7l"&&(ae.innerHTML=yt),ze=n(e),y(le.$$.fragment,e),xe=n(e),re=u(e,"P",{"data-svelte-h":!0}),T(re)!=="svelte-81s14c"&&(re.textContent=Mt),Fe=n(e),ce=u(e,"P",{"data-svelte-h":!0}),T(ce)!=="svelte-mmotdg"&&(ce.innerHTML=wt),Qe=n(e),y(Z.$$.fragment,e),Se=n(e),y(ne.$$.fragment,e),Ne=n(e),y(oe.$$.fragment,e),Le=n(e),ie=u(e,"P",{"data-svelte-h":!0}),T(ie)!=="svelte-dqdivd"&&(ie.innerHTML=$t),Pe=n(e),y(se.$$.fragment,e),Ee=n(e),de=u(e,"P",{"data-svelte-h":!0}),T(de)!=="svelte-nvfiz9"&&(de.innerHTML=gt),Ke=n(e),pe=u(e,"P",{"data-svelte-h":!0}),T(pe)!=="svelte-56aoja"&&(pe.innerHTML=Tt),qe=n(e),y(I.$$.fragment,e),De=n(e),y(me.$$.fragment,e),Oe=n(e),fe=u(e,"P",{"data-svelte-h":!0}),T(fe)!=="svelte-qzsquh"&&(fe.innerHTML=bt),et=n(e),ue=u(e,"P",{"data-svelte-h":!0}),T(ue)!=="svelte-cf1uwy"&&(ue.innerHTML=Ut),tt=n(e),he=u(e,"P",{"data-svelte-h":!0}),T(he)!=="svelte-uuw2iq"&&(he.innerHTML=Jt),at=n(e),ye=u(e,"P",{}),kt(ye).forEach(a),this.h()},h(){Ct(r,"name","hf:doc:metadata"),Ct(r,"content",St)},m(e,t){Rt(document.head,r),l(e,b,t),l(e,i,t),l(e,m,t),M(o,e,t),l(e,d,t),l(e,U,t),l(e,_,t),l(e,s,t),l(e,v,t),M(A,e,t),l(e,Me,t),M(W,e,t),l(e,we,t),l(e,X,t),l(e,$e,t),l(e,R,t),l(e,ge,t),M(Y,e,t),l(e,Te,t),l(e,H,t),l(e,be,t),M(V,e,t),l(e,Ue,t),M(B,e,t),l(e,Je,t),l(e,z,t),l(e,_e,t),M(G,e,t),l(e,ve,t),l(e,x,t),l(e,je,t),M(F,e,t),l(e,ke,t),M(Q,e,t),l(e,Ce,t),l(e,S,t),l(e,Ge,t),M(N,e,t),l(e,Ze,t),l(e,L,t),l(e,Ie,t),M(P,e,t),l(e,Ae,t),M(E,e,t),l(e,We,t),l(e,K,t),l(e,Xe,t),M(q,e,t),l(e,Re,t),l(e,D,t),l(e,Ye,t),M(O,e,t),l(e,He,t),M(ee,e,t),l(e,Ve,t),l(e,te,t),l(e,Be,t),l(e,ae,t),l(e,ze,t),M(le,e,t),l(e,xe,t),l(e,re,t),l(e,Fe,t),l(e,ce,t),l(e,Qe,t),M(Z,e,t),l(e,Se,t),M(ne,e,t),l(e,Ne,t),M(oe,e,t),l(e,Le,t),l(e,ie,t),l(e,Pe,t),M(se,e,t),l(e,Ee,t),l(e,de,t),l(e,Ke,t),l(e,pe,t),l(e,qe,t),M(I,e,t),l(e,De,t),M(me,e,t),l(e,Oe,t),l(e,fe,t),l(e,et,t),l(e,ue,t),l(e,tt,t),l(e,he,t),l(e,at,t),l(e,ye,t),lt=!0},p(e,[t]){const _t={};t&2&&(_t.$$scope={dirty:t,ctx:e}),G.$set(_t);const vt={};t&2&&(vt.$$scope={dirty:t,ctx:e}),Z.$set(vt);const jt={};t&2&&(jt.$$scope={dirty:t,ctx:e}),I.$set(jt)},i(e){lt||(w(o.$$.fragment,e),w(A.$$.fragment,e),w(W.$$.fragment,e),w(Y.$$.fragment,e),w(V.$$.fragment,e),w(B.$$.fragment,e),w(G.$$.fragment,e),w(F.$$.fragment,e),w(Q.$$.fragment,e),w(N.$$.fragment,e),w(P.$$.fragment,e),w(E.$$.fragment,e),w(q.$$.fragment,e),w(O.$$.fragment,e),w(ee.$$.fragment,e),w(le.$$.fragment,e),w(Z.$$.fragment,e),w(ne.$$.fragment,e),w(oe.$$.fragment,e),w(se.$$.fragment,e),w(I.$$.fragment,e),w(me.$$.fragment,e),lt=!0)},o(e){$(o.$$.fragment,e),$(A.$$.fragment,e),$(W.$$.fragment,e),$(Y.$$.fragment,e),$(V.$$.fragment,e),$(B.$$.fragment,e),$(G.$$.fragment,e),$(F.$$.fragment,e),$(Q.$$.fragment,e),$(N.$$.fragment,e),$(P.$$.fragment,e),$(E.$$.fragment,e),$(q.$$.fragment,e),$(O.$$.fragment,e),$(ee.$$.fragment,e),$(le.$$.fragment,e),$(Z.$$.fragment,e),$(ne.$$.fragment,e),$(oe.$$.fragment,e),$(se.$$.fragment,e),$(I.$$.fragment,e),$(me.$$.fragment,e),lt=!1},d(e){e&&(a(b),a(i),a(m),a(d),a(U),a(_),a(s),a(v),a(Me),a(we),a(X),a($e),a(R),a(ge),a(Te),a(H),a(be),a(Ue),a(Je),a(z),a(_e),a(ve),a(x),a(je),a(ke),a(Ce),a(S),a(Ge),a(Ze),a(L),a(Ie),a(Ae),a(We),a(K),a(Xe),a(Re),a(D),a(Ye),a(He),a(Ve),a(te),a(Be),a(ae),a(ze),a(xe),a(re),a(Fe),a(ce),a(Qe),a(Se),a(Ne),a(Le),a(ie),a(Pe),a(Ee),a(de),a(Ke),a(pe),a(qe),a(De),a(Oe),a(fe),a(et),a(ue),a(tt),a(he),a(at),a(ye)),a(r),g(o,e),g(A,e),g(W,e),g(Y,e),g(V,e),g(B,e),g(G,e),g(F,e),g(Q,e),g(N,e),g(P,e),g(E,e),g(q,e),g(O,e),g(ee,e),g(le,e),g(Z,e),g(ne,e),g(oe,e),g(se,e),g(I,e),g(me,e)}}}const St='{"title":"Add Accelerate to your code","local":"add-accelerate-to-your-code","sections":[{"title":"Accelerator","local":"accelerator","sections":[],"depth":2},{"title":"Prepare PyTorch objects","local":"prepare-pytorch-objects","sections":[],"depth":2},{"title":"Training loop","local":"training-loop","sections":[],"depth":2},{"title":"Training features","local":"training-features","sections":[{"title":"Gradient accumulation","local":"gradient-accumulation","sections":[],"depth":3},{"title":"Gradient clipping","local":"gradient-clipping","sections":[],"depth":3},{"title":"Mixed precision","local":"mixed-precision","sections":[],"depth":3}],"depth":2},{"title":"Save and load","local":"save-and-load","sections":[{"title":"Model","local":"model","sections":[],"depth":3},{"title":"State","local":"state","sections":[],"depth":3}],"depth":2}],"depth":1}';function Nt(j){return It(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ot extends At{constructor(r){super(),Wt(this,r,Nt,Qt,Zt,{})}}export{Ot as component};
