import{s as Qt,o as St,n as yt}from"../chunks/scheduler.22bf70d2.js";import{S as Et,i as Dt,g as s,s as i,r as p,A as qt,h as c,f as a,c as n,j as Vt,u as m,x as d,k as Te,y as Kt,a as l,v as f,d as h,t as u,w as y}from"../chunks/index.59178e06.js";import{T as ut}from"../chunks/Tip.75d940ba.js";import{C as g}from"../chunks/CodeBlock.f7047b13.js";import{H as I}from"../chunks/Heading.f8746c79.js";function Ot($){let r,w="Add <code>--config_file</code> to the <code>accelerate test</code> or <code>accelerate launch</code> command to specify the location of the configuration file if it is saved in a non-default location like the cache.";return{c(){r=s("p"),r.innerHTML=w},l(o){r=c(o,"P",{"data-svelte-h":!0}),d(r)!=="svelte-owtvtx"&&(r.innerHTML=w)},m(o,T){l(o,r,T)},p:yt,d(o){o&&a(r)}}}function ea($){let r,w='This step is <em>optional</em> but it is considered best practice to allow Accelerate to handle device placement. You could also deactivate automatic device placement by passing <code>device_placement=False</code> when initializing the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a>. If you want to explicitly place objects on a device with <code>.to(device)</code>, make sure you use <code>accelerator.device</code> instead. For example, if you create an optimizer before placing a model on <code>accelerator.device</code>, training fails on a TPU.';return{c(){r=s("p"),r.innerHTML=w},l(o){r=c(o,"P",{"data-svelte-h":!0}),d(r)!=="svelte-1d9et17"&&(r.innerHTML=w)},m(o,T){l(o,r,T)},p:yt,d(o){o&&a(r)}}}function ta($){let r,w='Data at the end of a dataset may be duplicated so the batch can be equally divided among all workers. The <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.gather_for_metrics">gather_for_metrics()</a> method automatically removes the duplicated data to calculate a more accurate metric.';return{c(){r=s("p"),r.innerHTML=w},l(o){r=c(o,"P",{"data-svelte-h":!0}),d(r)!=="svelte-1dd63cl"&&(r.innerHTML=w)},m(o,T){l(o,r,T)},p:yt,d(o){o&&a(r)}}}function aa($){let r,w='Take a look at the <a href="concept_guides/big_model_inference">Handling big models for inference</a> guide for a better understanding of how Big Model Inference works under the hood.';return{c(){r=s("p"),r.innerHTML=w},l(o){r=c(o,"P",{"data-svelte-h":!0}),d(r)!=="svelte-1s8g9lk"&&(r.innerHTML=w)},m(o,T){l(o,r,T)},p:yt,d(o){o&&a(r)}}}function la($){let r,w,o,T,j,ge,G,wt='There are many ways to launch and run your code depending on your training environment (<a href="https://pytorch.org/docs/stable/elastic/run.html" rel="nofollow">torchrun</a>, <a href="https://www.deepspeed.ai/" rel="nofollow">DeepSpeed</a>, etc.) and available hardware. Accelerate offers a unified interface for launching and training on different distributed setups, allowing you to focus on your PyTorch training code instead of the intricacies of adapting your code to these different setups. This allows you to easily scale your PyTorch code for training and inference on distributed setups with hardware like GPUs and TPUs. Accelerate also provides Big Model Inference to make loading and running inference with really large models that usually don’t fit in memory more accessible.',$e,C,Tt="This quicktour introduces the three main features of Accelerate:",Me,B,gt="<li>a unified command line launching interface for distributed training scripts</li> <li>a training library for adapting PyTorch training code to run on different distributed setups</li> <li>Big Model Inference</li>",Je,Z,be,x,$t='Accelerate automatically selects the appropriate configuration values for any given distributed training framework (DeepSpeed, FSDP, etc.) through a unified configuration file generated from the <a href="package_reference/cli#accelerate-config"><code>accelerate config</code></a> command. You could also pass the configuration values explicitly to the command line which is helpful in certain situations like if you’re using SLURM.',_e,H,Mt='But in most cases, you should always run <a href="package_reference/cli#accelerate-config"><code>accelerate config</code></a> first to help Accelerate learn about your training setup.',ve,W,Ue,L,Jt='The <a href="package_reference/cli#accelerate-config"><code>accelerate config</code></a> command creates and saves a default_config.yaml file in Accelerates cache folder. This file stores the configuration for your training environment, which helps Accelerate correctly launch your training script based on your machine.',ke,X,bt='After you’ve configured your environment, you can test your setup with <a href="package_reference/cli#accelerate-test"><code>accelerate test</code></a>, which launches a short script to test the distributed environment.',Ie,R,je,M,Ge,Y,_t='Once your environment is setup, launch your training script with <a href="package_reference/cli#accelerate-launch"><code>accelerate launch</code></a>!',Ce,A,Be,N,vt='To learn more, check out the <a href="basic_tutorials/launch">Launch distributed code</a> tutorial for more information about launching your scripts.',Ze,z,xe,P,Ut='The next main feature of Accelerate is the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> class which adapts your PyTorch code to run on different distributed setups.',He,F,kt="You only need to add a few lines of code to your training script to enable it to run on multiple GPUs or TPUs.",We,V,Le,Q,It='<li>Import and instantiate the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> class at the beginning of your training script. The <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> class initializes everything necessary for distributed training, and it automatically detects your training environment (a single machine with a GPU, a machine with several GPUs, several machines with multiple GPUs or a TPU, etc.) based on how the code was launched.</li>',Xe,S,Re,J,jt='<li>Remove calls like <code>.cuda()</code> on your model and input data. The <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> class automatically places these objects on the appropriate device for you.</li>',Ye,b,Ae,E,Ne,_,Gt='<li>Pass all relevant PyTorch objects for training (optimizer, model, dataloader(s), learning rate scheduler) to the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.prepare">prepare()</a> method as soon as they’re created. This method wraps the model in a container optimized for your distributed setup, uses Accelerates version of the optimizer and scheduler, and creates a sharded version of your dataloader for distribution across GPUs or TPUs.</li>',ze,D,Pe,v,Ct='<li>Replace <code>loss.backward()</code> with <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.backward">backward()</a> to use the correct <code>backward()</code> method for your training setup.</li>',Fe,q,Ve,K,Bt='Read <a href="concept_guides/internal_mechanism">Accelerate’s internal mechanisms</a> guide to learn more details about how Accelerate adapts your code.',Qe,O,Se,ee,Zt='To perform distributed evaluation, pass your validation dataloader to the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.prepare">prepare()</a> method:',Ee,te,De,ae,xt='Each device in your distributed setup only receives a part of the evaluation data, which means you should group your predictions together with the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.gather_for_metrics">gather_for_metrics()</a> method. This method requires all tensors to be the same size on each process, so if your tensors have different sizes on each process (for instance when dynamically padding to the maximum length in a batch), you should use the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.pad_across_processes">pad_across_processes()</a> method to pad you tensor to the largest size across processes.',qe,le,Ke,U,Oe,ie,et,ne,Ht='Accelerate’s Big Model Inference has two main features, <a href="/docs/accelerate/main/en/package_reference/big_modeling#accelerate.init_empty_weights">init_empty_weights()</a> and <a href="/docs/accelerate/main/en/package_reference/big_modeling#accelerate.load_checkpoint_and_dispatch">load_checkpoint_and_dispatch()</a>, to load large models for inference that typically don’t fit into memory.',tt,k,at,re,lt,se,Wt='The <a href="/docs/accelerate/main/en/package_reference/big_modeling#accelerate.init_empty_weights">init_empty_weights()</a> context manager initializes models of any size by creating a <em>model skeleton</em> and moving and placing parameters each time they’re created to PyTorch’s <a href="https://pytorch.org/docs/main/meta.html" rel="nofollow"><strong>meta</strong></a> device. This way, not all weights are immediately loaded and only a small part of the model is loaded into memory at a time.',it,ce,Lt='For example, loading an empty <a href="https://huggingface.co/mistralai/Mixtral-8x7B-Instruct-v0.1" rel="nofollow">Mixtral-8x7B</a> model takes significantly less memory than fully loading the models and weights on the CPU.',nt,oe,rt,de,st,pe,Xt='The <a href="/docs/accelerate/main/en/package_reference/big_modeling#accelerate.load_checkpoint_and_dispatch">load_checkpoint_and_dispatch()</a> function loads full or sharded checkpoints into the empty model, and automatically distribute weights across all available devices.',ct,me,Rt="The <code>device_map</code> parameter determines where to place each model layer, and specifiying <code>&quot;auto&quot;</code> places them on the GPU first, then the CPU, and finally the hard drive as memory-mapped tensors if there’s still not enough memory. Use the <code>no_split_module_classes</code> parameter to indicate which modules shouldn’t be split across devices (typically those with a residual connection).",ot,fe,dt,he,pt,ue,Yt="Now that you’ve been introduced to the main Accelerate features, your next steps could include:",mt,ye,At='<li>Check out the <a href="basic_tutorials/overview">tutorials</a> for a gentle walkthrough of Accelerate. This is especially useful if you’re new to distributed training and the library.</li> <li>Dive into the <a href="usage_guides/explore">guides</a> to see how to use Accelerate for specific use-cases.</li> <li>Deepen your conceptual understanding of how Accelerate works internally by reading the <a href="concept_guides/internal_mechanism">concept guides</a>.</li> <li>Look up classes and commands in the <a href="package_reference/accelerator">API reference</a> to see what parameters and options are available.</li>',ft,we,ht;return j=new I({props:{title:"Quicktour",local:"quicktour",headingTag:"h1"}}),Z=new I({props:{title:"Unified launch interface",local:"unified-launch-interface",headingTag:"h2"}}),W=new g({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),R=new g({props:{code:"YWNjZWxlcmF0ZSUyMHRlc3Q=",highlighted:'accelerate <span class="hljs-built_in">test</span>',wrap:!1}}),M=new ut({props:{warning:!1,$$slots:{default:[Ot]},$$scope:{ctx:$}}}),A=new g({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHBhdGhfdG9fc2NyaXB0LnB5JTIwLS1hcmdzX2Zvcl90aGVfc2NyaXB0",highlighted:"accelerate launch path_to_script.py --args_for_the_script",wrap:!1}}),z=new I({props:{title:"Adapt training code",local:"adapt-training-code",headingTag:"h2"}}),V=new g({props:{code:"JTJCJTIwZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUyQiUyMGFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQSUwQSUyQiUyMGRldmljZSUyMCUzRCUyMGFjY2VsZXJhdG9yLmRldmljZSUwQSUyQiUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTJDJTIwdHJhaW5pbmdfZGF0YWxvYWRlciUyQyUyMHNjaGVkdWxlciUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUoJTBBJTJCJTIwJTIwJTIwJTIwJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjB0cmFpbmluZ19kYXRhbG9hZGVyJTJDJTIwc2NoZWR1bGVyJTBBJTJCJTIwKSUwQSUwQSUyMCUyMGZvciUyMGJhdGNoJTIwaW4lMjB0cmFpbmluZ19kYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnplcm9fZ3JhZCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwaW5wdXRzJTJDJTIwdGFyZ2V0cyUyMCUzRCUyMGJhdGNoJTBBLSUyMCUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMGlucHV0cy50byhkZXZpY2UpJTBBLSUyMCUyMCUyMCUyMCUyMHRhcmdldHMlMjAlM0QlMjB0YXJnZXRzLnRvKGRldmljZSklMEElMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoaW5wdXRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBsb3NzX2Z1bmN0aW9uKG91dHB1dHMlMkMlMjB0YXJnZXRzKSUwQSUyQiUyMCUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLmJhY2t3YXJkKGxvc3MpJTBBJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMHNjaGVkdWxlci5zdGVwKCk=",highlighted:`<span class="hljs-addition">+ from accelerate import Accelerator</span>
<span class="hljs-addition">+ accelerator = Accelerator()</span>

<span class="hljs-addition">+ device = accelerator.device</span>
<span class="hljs-addition">+ model, optimizer, training_dataloader, scheduler = accelerator.prepare(</span>
<span class="hljs-addition">+     model, optimizer, training_dataloader, scheduler</span>
<span class="hljs-addition">+ )</span>

  for batch in training_dataloader:
      optimizer.zero_grad()
      inputs, targets = batch
<span class="hljs-deletion">-     inputs = inputs.to(device)</span>
<span class="hljs-deletion">-     targets = targets.to(device)</span>
      outputs = model(inputs)
      loss = loss_function(outputs, targets)
<span class="hljs-addition">+     accelerator.backward(loss)</span>
      optimizer.step()
      scheduler.step()`,wrap:!1}}),S=new g({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

accelerator = Accelerator()`,wrap:!1}}),b=new ut({props:{warning:!0,$$slots:{default:[ea]},$$scope:{ctx:$}}}),E=new g({props:{code:"ZGV2aWNlJTIwJTNEJTIwYWNjZWxlcmF0b3IuZGV2aWNl",highlighted:"device = accelerator.device",wrap:!1}}),D=new g({props:{code:"bW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjB0cmFpbl9kYXRhbG9hZGVyJTJDJTIwbHJfc2NoZWR1bGVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZSglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUyMG9wdGltaXplciUyQyUyMHRyYWluX2RhdGFsb2FkZXIlMkMlMjBscl9zY2hlZHVsZXIlMEEp",highlighted:`model, optimizer, train_dataloader, lr_scheduler = accelerator.prepare(
    model, optimizer, train_dataloader, lr_scheduler
)`,wrap:!1}}),q=new g({props:{code:"YWNjZWxlcmF0b3IuYmFja3dhcmQobG9zcyk=",highlighted:"accelerator.backward(loss)",wrap:!1}}),O=new I({props:{title:"Distributed evaluation",local:"distributed-evaluation",headingTag:"h3"}}),te=new g({props:{code:"dmFsaWRhdGlvbl9kYXRhbG9hZGVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZSh2YWxpZGF0aW9uX2RhdGFsb2FkZXIp",highlighted:"validation_dataloader = accelerator.prepare(validation_dataloader)",wrap:!1}}),le=new g({props:{code:"Zm9yJTIwaW5wdXRzJTJDJTIwdGFyZ2V0cyUyMGluJTIwdmFsaWRhdGlvbl9kYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwcHJlZGljdGlvbnMlMjAlM0QlMjBtb2RlbChpbnB1dHMpJTBBJTIwJTIwJTIwJTIwJTIzJTIwR2F0aGVyJTIwYWxsJTIwcHJlZGljdGlvbnMlMjBhbmQlMjB0YXJnZXRzJTBBJTIwJTIwJTIwJTIwYWxsX3ByZWRpY3Rpb25zJTJDJTIwYWxsX3RhcmdldHMlMjAlM0QlMjBhY2NlbGVyYXRvci5nYXRoZXJfZm9yX21ldHJpY3MoKHByZWRpY3Rpb25zJTJDJTIwdGFyZ2V0cykpJTBBJTIwJTIwJTIwJTIwJTIzJTIwRXhhbXBsZSUyMG9mJTIwdXNlJTIwd2l0aCUyMGElMjAqRGF0YXNldHMuTWV0cmljKiUwQSUyMCUyMCUyMCUyMG1ldHJpYy5hZGRfYmF0Y2goYWxsX3ByZWRpY3Rpb25zJTJDJTIwYWxsX3RhcmdldHMp",highlighted:`<span class="hljs-keyword">for</span> inputs, targets <span class="hljs-keyword">in</span> validation_dataloader:
    predictions = model(inputs)
    <span class="hljs-comment"># Gather all predictions and targets</span>
    all_predictions, all_targets = accelerator.gather_for_metrics((predictions, targets))
    <span class="hljs-comment"># Example of use with a *Datasets.Metric*</span>
    metric.add_batch(all_predictions, all_targets)`,wrap:!1}}),U=new ut({props:{warning:!1,$$slots:{default:[ta]},$$scope:{ctx:$}}}),ie=new I({props:{title:"Big Model Inference",local:"big-model-inference",headingTag:"h2"}}),k=new ut({props:{warning:!1,$$slots:{default:[aa]},$$scope:{ctx:$}}}),re=new I({props:{title:"Empty weights initialization",local:"empty-weights-initialization",headingTag:"h3"}}),oe=new g({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBpbml0X2VtcHR5X3dlaWdodHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b0NvbmZpZyUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWl4dHJhbC04eDdCLUluc3RydWN0LXYwLjElMjIpJTBBd2l0aCUyMGluaXRfZW1wdHlfd2VpZ2h0cygpJTNBJTBBJTIwJTIwJTIwJTIwbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> init_empty_weights
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForCausalLM

config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;mistralai/Mixtral-8x7B-Instruct-v0.1&quot;</span>)
<span class="hljs-keyword">with</span> init_empty_weights():
    model = AutoModelForCausalLM.from_config(config)`,wrap:!1}}),de=new I({props:{title:"Load and dispatch weights",local:"load-and-dispatch-weights",headingTag:"h3"}}),fe=new g({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBsb2FkX2NoZWNrcG9pbnRfYW5kX2Rpc3BhdGNoJTBBJTBBbW9kZWwlMjAlM0QlMjBsb2FkX2NoZWNrcG9pbnRfYW5kX2Rpc3BhdGNoKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTJDJTIwY2hlY2twb2ludCUzRCUyMm1pc3RyYWxhaSUyRk1peHRyYWwtOHg3Qi1JbnN0cnVjdC12MC4xJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBub19zcGxpdF9tb2R1bGVfY2xhc3NlcyUzRCU1QidCbG9jayclNUQlMEEp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> load_checkpoint_and_dispatch

model = load_checkpoint_and_dispatch(
    model, checkpoint=<span class="hljs-string">&quot;mistralai/Mixtral-8x7B-Instruct-v0.1&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, no_split_module_classes=[<span class="hljs-string">&#x27;Block&#x27;</span>]
)`,wrap:!1}}),he=new I({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),{c(){r=s("meta"),w=i(),o=s("p"),T=i(),p(j.$$.fragment),ge=i(),G=s("p"),G.innerHTML=wt,$e=i(),C=s("p"),C.textContent=Tt,Me=i(),B=s("ul"),B.innerHTML=gt,Je=i(),p(Z.$$.fragment),be=i(),x=s("p"),x.innerHTML=$t,_e=i(),H=s("p"),H.innerHTML=Mt,ve=i(),p(W.$$.fragment),Ue=i(),L=s("p"),L.innerHTML=Jt,ke=i(),X=s("p"),X.innerHTML=bt,Ie=i(),p(R.$$.fragment),je=i(),p(M.$$.fragment),Ge=i(),Y=s("p"),Y.innerHTML=_t,Ce=i(),p(A.$$.fragment),Be=i(),N=s("p"),N.innerHTML=vt,Ze=i(),p(z.$$.fragment),xe=i(),P=s("p"),P.innerHTML=Ut,He=i(),F=s("p"),F.textContent=kt,We=i(),p(V.$$.fragment),Le=i(),Q=s("ol"),Q.innerHTML=It,Xe=i(),p(S.$$.fragment),Re=i(),J=s("ol"),J.innerHTML=jt,Ye=i(),p(b.$$.fragment),Ae=i(),p(E.$$.fragment),Ne=i(),_=s("ol"),_.innerHTML=Gt,ze=i(),p(D.$$.fragment),Pe=i(),v=s("ol"),v.innerHTML=Ct,Fe=i(),p(q.$$.fragment),Ve=i(),K=s("p"),K.innerHTML=Bt,Qe=i(),p(O.$$.fragment),Se=i(),ee=s("p"),ee.innerHTML=Zt,Ee=i(),p(te.$$.fragment),De=i(),ae=s("p"),ae.innerHTML=xt,qe=i(),p(le.$$.fragment),Ke=i(),p(U.$$.fragment),Oe=i(),p(ie.$$.fragment),et=i(),ne=s("p"),ne.innerHTML=Ht,tt=i(),p(k.$$.fragment),at=i(),p(re.$$.fragment),lt=i(),se=s("p"),se.innerHTML=Wt,it=i(),ce=s("p"),ce.innerHTML=Lt,nt=i(),p(oe.$$.fragment),rt=i(),p(de.$$.fragment),st=i(),pe=s("p"),pe.innerHTML=Xt,ct=i(),me=s("p"),me.innerHTML=Rt,ot=i(),p(fe.$$.fragment),dt=i(),p(he.$$.fragment),pt=i(),ue=s("p"),ue.textContent=Yt,mt=i(),ye=s("ul"),ye.innerHTML=At,ft=i(),we=s("p"),this.h()},l(e){const t=qt("svelte-u9bgzb",document.head);r=c(t,"META",{name:!0,content:!0}),t.forEach(a),w=n(e),o=c(e,"P",{}),Vt(o).forEach(a),T=n(e),m(j.$$.fragment,e),ge=n(e),G=c(e,"P",{"data-svelte-h":!0}),d(G)!=="svelte-zyosvv"&&(G.innerHTML=wt),$e=n(e),C=c(e,"P",{"data-svelte-h":!0}),d(C)!=="svelte-1o5ahli"&&(C.textContent=Tt),Me=n(e),B=c(e,"UL",{"data-svelte-h":!0}),d(B)!=="svelte-d1sk9"&&(B.innerHTML=gt),Je=n(e),m(Z.$$.fragment,e),be=n(e),x=c(e,"P",{"data-svelte-h":!0}),d(x)!=="svelte-aki53"&&(x.innerHTML=$t),_e=n(e),H=c(e,"P",{"data-svelte-h":!0}),d(H)!=="svelte-2e4yon"&&(H.innerHTML=Mt),ve=n(e),m(W.$$.fragment,e),Ue=n(e),L=c(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-47dzsm"&&(L.innerHTML=Jt),ke=n(e),X=c(e,"P",{"data-svelte-h":!0}),d(X)!=="svelte-vfcxnx"&&(X.innerHTML=bt),Ie=n(e),m(R.$$.fragment,e),je=n(e),m(M.$$.fragment,e),Ge=n(e),Y=c(e,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-jk8hrr"&&(Y.innerHTML=_t),Ce=n(e),m(A.$$.fragment,e),Be=n(e),N=c(e,"P",{"data-svelte-h":!0}),d(N)!=="svelte-ehdvry"&&(N.innerHTML=vt),Ze=n(e),m(z.$$.fragment,e),xe=n(e),P=c(e,"P",{"data-svelte-h":!0}),d(P)!=="svelte-p6um74"&&(P.innerHTML=Ut),He=n(e),F=c(e,"P",{"data-svelte-h":!0}),d(F)!=="svelte-1x7bxhi"&&(F.textContent=kt),We=n(e),m(V.$$.fragment,e),Le=n(e),Q=c(e,"OL",{"data-svelte-h":!0}),d(Q)!=="svelte-11drxr9"&&(Q.innerHTML=It),Xe=n(e),m(S.$$.fragment,e),Re=n(e),J=c(e,"OL",{start:!0,"data-svelte-h":!0}),d(J)!=="svelte-1twlm3"&&(J.innerHTML=jt),Ye=n(e),m(b.$$.fragment,e),Ae=n(e),m(E.$$.fragment,e),Ne=n(e),_=c(e,"OL",{start:!0,"data-svelte-h":!0}),d(_)!=="svelte-5855kf"&&(_.innerHTML=Gt),ze=n(e),m(D.$$.fragment,e),Pe=n(e),v=c(e,"OL",{start:!0,"data-svelte-h":!0}),d(v)!=="svelte-i7dd5a"&&(v.innerHTML=Ct),Fe=n(e),m(q.$$.fragment,e),Ve=n(e),K=c(e,"P",{"data-svelte-h":!0}),d(K)!=="svelte-l0bxbi"&&(K.innerHTML=Bt),Qe=n(e),m(O.$$.fragment,e),Se=n(e),ee=c(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-z7h89a"&&(ee.innerHTML=Zt),Ee=n(e),m(te.$$.fragment,e),De=n(e),ae=c(e,"P",{"data-svelte-h":!0}),d(ae)!=="svelte-8edius"&&(ae.innerHTML=xt),qe=n(e),m(le.$$.fragment,e),Ke=n(e),m(U.$$.fragment,e),Oe=n(e),m(ie.$$.fragment,e),et=n(e),ne=c(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-124mhu8"&&(ne.innerHTML=Ht),tt=n(e),m(k.$$.fragment,e),at=n(e),m(re.$$.fragment,e),lt=n(e),se=c(e,"P",{"data-svelte-h":!0}),d(se)!=="svelte-o30c3t"&&(se.innerHTML=Wt),it=n(e),ce=c(e,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-1oh4egp"&&(ce.innerHTML=Lt),nt=n(e),m(oe.$$.fragment,e),rt=n(e),m(de.$$.fragment,e),st=n(e),pe=c(e,"P",{"data-svelte-h":!0}),d(pe)!=="svelte-277jb5"&&(pe.innerHTML=Xt),ct=n(e),me=c(e,"P",{"data-svelte-h":!0}),d(me)!=="svelte-h9i8yj"&&(me.innerHTML=Rt),ot=n(e),m(fe.$$.fragment,e),dt=n(e),m(he.$$.fragment,e),pt=n(e),ue=c(e,"P",{"data-svelte-h":!0}),d(ue)!=="svelte-51r5yq"&&(ue.textContent=Yt),mt=n(e),ye=c(e,"UL",{"data-svelte-h":!0}),d(ye)!=="svelte-1xs3v0c"&&(ye.innerHTML=At),ft=n(e),we=c(e,"P",{}),Vt(we).forEach(a),this.h()},h(){Te(r,"name","hf:doc:metadata"),Te(r,"content",ia),Te(J,"start","2"),Te(_,"start","3"),Te(v,"start","4")},m(e,t){Kt(document.head,r),l(e,w,t),l(e,o,t),l(e,T,t),f(j,e,t),l(e,ge,t),l(e,G,t),l(e,$e,t),l(e,C,t),l(e,Me,t),l(e,B,t),l(e,Je,t),f(Z,e,t),l(e,be,t),l(e,x,t),l(e,_e,t),l(e,H,t),l(e,ve,t),f(W,e,t),l(e,Ue,t),l(e,L,t),l(e,ke,t),l(e,X,t),l(e,Ie,t),f(R,e,t),l(e,je,t),f(M,e,t),l(e,Ge,t),l(e,Y,t),l(e,Ce,t),f(A,e,t),l(e,Be,t),l(e,N,t),l(e,Ze,t),f(z,e,t),l(e,xe,t),l(e,P,t),l(e,He,t),l(e,F,t),l(e,We,t),f(V,e,t),l(e,Le,t),l(e,Q,t),l(e,Xe,t),f(S,e,t),l(e,Re,t),l(e,J,t),l(e,Ye,t),f(b,e,t),l(e,Ae,t),f(E,e,t),l(e,Ne,t),l(e,_,t),l(e,ze,t),f(D,e,t),l(e,Pe,t),l(e,v,t),l(e,Fe,t),f(q,e,t),l(e,Ve,t),l(e,K,t),l(e,Qe,t),f(O,e,t),l(e,Se,t),l(e,ee,t),l(e,Ee,t),f(te,e,t),l(e,De,t),l(e,ae,t),l(e,qe,t),f(le,e,t),l(e,Ke,t),f(U,e,t),l(e,Oe,t),f(ie,e,t),l(e,et,t),l(e,ne,t),l(e,tt,t),f(k,e,t),l(e,at,t),f(re,e,t),l(e,lt,t),l(e,se,t),l(e,it,t),l(e,ce,t),l(e,nt,t),f(oe,e,t),l(e,rt,t),f(de,e,t),l(e,st,t),l(e,pe,t),l(e,ct,t),l(e,me,t),l(e,ot,t),f(fe,e,t),l(e,dt,t),f(he,e,t),l(e,pt,t),l(e,ue,t),l(e,mt,t),l(e,ye,t),l(e,ft,t),l(e,we,t),ht=!0},p(e,[t]){const Nt={};t&2&&(Nt.$$scope={dirty:t,ctx:e}),M.$set(Nt);const zt={};t&2&&(zt.$$scope={dirty:t,ctx:e}),b.$set(zt);const Pt={};t&2&&(Pt.$$scope={dirty:t,ctx:e}),U.$set(Pt);const Ft={};t&2&&(Ft.$$scope={dirty:t,ctx:e}),k.$set(Ft)},i(e){ht||(h(j.$$.fragment,e),h(Z.$$.fragment,e),h(W.$$.fragment,e),h(R.$$.fragment,e),h(M.$$.fragment,e),h(A.$$.fragment,e),h(z.$$.fragment,e),h(V.$$.fragment,e),h(S.$$.fragment,e),h(b.$$.fragment,e),h(E.$$.fragment,e),h(D.$$.fragment,e),h(q.$$.fragment,e),h(O.$$.fragment,e),h(te.$$.fragment,e),h(le.$$.fragment,e),h(U.$$.fragment,e),h(ie.$$.fragment,e),h(k.$$.fragment,e),h(re.$$.fragment,e),h(oe.$$.fragment,e),h(de.$$.fragment,e),h(fe.$$.fragment,e),h(he.$$.fragment,e),ht=!0)},o(e){u(j.$$.fragment,e),u(Z.$$.fragment,e),u(W.$$.fragment,e),u(R.$$.fragment,e),u(M.$$.fragment,e),u(A.$$.fragment,e),u(z.$$.fragment,e),u(V.$$.fragment,e),u(S.$$.fragment,e),u(b.$$.fragment,e),u(E.$$.fragment,e),u(D.$$.fragment,e),u(q.$$.fragment,e),u(O.$$.fragment,e),u(te.$$.fragment,e),u(le.$$.fragment,e),u(U.$$.fragment,e),u(ie.$$.fragment,e),u(k.$$.fragment,e),u(re.$$.fragment,e),u(oe.$$.fragment,e),u(de.$$.fragment,e),u(fe.$$.fragment,e),u(he.$$.fragment,e),ht=!1},d(e){e&&(a(w),a(o),a(T),a(ge),a(G),a($e),a(C),a(Me),a(B),a(Je),a(be),a(x),a(_e),a(H),a(ve),a(Ue),a(L),a(ke),a(X),a(Ie),a(je),a(Ge),a(Y),a(Ce),a(Be),a(N),a(Ze),a(xe),a(P),a(He),a(F),a(We),a(Le),a(Q),a(Xe),a(Re),a(J),a(Ye),a(Ae),a(Ne),a(_),a(ze),a(Pe),a(v),a(Fe),a(Ve),a(K),a(Qe),a(Se),a(ee),a(Ee),a(De),a(ae),a(qe),a(Ke),a(Oe),a(et),a(ne),a(tt),a(at),a(lt),a(se),a(it),a(ce),a(nt),a(rt),a(st),a(pe),a(ct),a(me),a(ot),a(dt),a(pt),a(ue),a(mt),a(ye),a(ft),a(we)),a(r),y(j,e),y(Z,e),y(W,e),y(R,e),y(M,e),y(A,e),y(z,e),y(V,e),y(S,e),y(b,e),y(E,e),y(D,e),y(q,e),y(O,e),y(te,e),y(le,e),y(U,e),y(ie,e),y(k,e),y(re,e),y(oe,e),y(de,e),y(fe,e),y(he,e)}}}const ia='{"title":"Quicktour","local":"quicktour","sections":[{"title":"Unified launch interface","local":"unified-launch-interface","sections":[],"depth":2},{"title":"Adapt training code","local":"adapt-training-code","sections":[{"title":"Distributed evaluation","local":"distributed-evaluation","sections":[],"depth":3}],"depth":2},{"title":"Big Model Inference","local":"big-model-inference","sections":[{"title":"Empty weights initialization","local":"empty-weights-initialization","sections":[],"depth":3},{"title":"Load and dispatch weights","local":"load-and-dispatch-weights","sections":[],"depth":3}],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function na($){return St(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class pa extends Et{constructor(r){super(),Dt(this,r,na,la,Qt,{})}}export{pa as component};
