import{s as Vt,o as $t,n as jt}from"../chunks/scheduler.8c3d61f6.js";import{S as It,i as Zt,g as a,s as i,r as u,A as Xt,h as l,f as n,c as s,j as X,u as f,x as p,k as G,y as d,a as o,v as g,d as h,t as _,w as b}from"../chunks/index.da70eac4.js";import{T as Gt}from"../chunks/Tip.1d9b8c37.js";import{D as he}from"../chunks/Docstring.ee4b6913.js";import{C as ve}from"../chunks/CodeBlock.00a903b3.js";import{E as kt}from"../chunks/ExampleCodeBlock.f7bd2c1f.js";import{H as be,E as Bt}from"../chunks/EditOnGithub.1e64e623.js";function Wt(re){let r,J='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers.md">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading.md#reuse-a-pipeline">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){r=a("p"),r.innerHTML=J},l(w){r=l(w,"P",{"data-svelte-h":!0}),p(r)!=="svelte-w7r39y"&&(r.innerHTML=J)},m(w,y){o(w,r,y)},p:jt,d(w){w&&n(r)}}}function Pt(re){let r,J="Examples:",w,y,M;return y=new ve({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQ29nVmlkZW9YUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBJTIzJTIwTW9kZWxzJTNBJTIwJTIyVEhVRE0lMkZDb2dWaWRlb1gtMmIlMjIlMjBvciUyMCUyMlRIVURNJTJGQ29nVmlkZW9YLTViJTIyJTBBcGlwZSUyMCUzRCUyMENvZ1ZpZGVvWFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJUSFVETSUyRkNvZ1ZpZGVvWC0yYiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEFwcm9tcHQlMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwJTIyQSUyMHBhbmRhJTJDJTIwZHJlc3NlZCUyMGluJTIwYSUyMHNtYWxsJTJDJTIwcmVkJTIwamFja2V0JTIwYW5kJTIwYSUyMHRpbnklMjBoYXQlMkMlMjBzaXRzJTIwb24lMjBhJTIwd29vZGVuJTIwc3Rvb2wlMjBpbiUyMGElMjBzZXJlbmUlMjBiYW1ib28lMjBmb3Jlc3QuJTIwJTIyJTBBJTIwJTIwJTIwJTIwJTIyVGhlJTIwcGFuZGEncyUyMGZsdWZmeSUyMHBhd3MlMjBzdHJ1bSUyMGElMjBtaW5pYXR1cmUlMjBhY291c3RpYyUyMGd1aXRhciUyQyUyMHByb2R1Y2luZyUyMHNvZnQlMkMlMjBtZWxvZGljJTIwdHVuZXMuJTIwTmVhcmJ5JTJDJTIwYSUyMGZldyUyMG90aGVyJTIwJTIyJTBBJTIwJTIwJTIwJTIwJTIycGFuZGFzJTIwZ2F0aGVyJTJDJTIwd2F0Y2hpbmclMjBjdXJpb3VzbHklMjBhbmQlMjBzb21lJTIwY2xhcHBpbmclMjBpbiUyMHJoeXRobS4lMjBTdW5saWdodCUyMGZpbHRlcnMlMjB0aHJvdWdoJTIwdGhlJTIwdGFsbCUyMGJhbWJvbyUyQyUyMCUyMiUwQSUyMCUyMCUyMCUyMCUyMmNhc3RpbmclMjBhJTIwZ2VudGxlJTIwZ2xvdyUyMG9uJTIwdGhlJTIwc2NlbmUuJTIwVGhlJTIwcGFuZGEncyUyMGZhY2UlMjBpcyUyMGV4cHJlc3NpdmUlMkMlMjBzaG93aW5nJTIwY29uY2VudHJhdGlvbiUyMGFuZCUyMGpveSUyMGFzJTIwaXQlMjBwbGF5cy4lMjAlMjIlMEElMjAlMjAlMjAlMjAlMjJUaGUlMjBiYWNrZ3JvdW5kJTIwaW5jbHVkZXMlMjBhJTIwc21hbGwlMkMlMjBmbG93aW5nJTIwc3RyZWFtJTIwYW5kJTIwdmlicmFudCUyMGdyZWVuJTIwZm9saWFnZSUyQyUyMGVuaGFuY2luZyUyMHRoZSUyMHBlYWNlZnVsJTIwYW5kJTIwbWFnaWNhbCUyMCUyMiUwQSUyMCUyMCUyMCUyMCUyMmF0bW9zcGhlcmUlMjBvZiUyMHRoaXMlMjB1bmlxdWUlMjBtdXNpY2FsJTIwcGVyZm9ybWFuY2UuJTIyJTBBKSUwQXZpZGVvJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDYlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmZyYW1lcyU1QjAlNUQlMEFleHBvcnRfdG9fdmlkZW8odmlkZW8lMkMlMjAlMjJvdXRwdXQubXA0JTIyJTJDJTIwZnBzJTNEOCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> CogVideoXPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Models: &quot;THUDM/CogVideoX-2b&quot; or &quot;THUDM/CogVideoX-5b&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = CogVideoXPipeline.from_pretrained(<span class="hljs-string">&quot;THUDM/CogVideoX-2b&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A panda, dressed in a small, red jacket and a tiny hat, sits on a wooden stool in a serene bamboo forest. &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;The panda&#x27;s fluffy paws strum a miniature acoustic guitar, producing soft, melodic tunes. Nearby, a few other &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;pandas gather, watching curiously and some clapping in rhythm. Sunlight filters through the tall bamboo, &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;casting a gentle glow on the scene. The panda&#x27;s face is expressive, showing concentration and joy as it plays. &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;The background includes a small, flowing stream and vibrant green foliage, enhancing the peaceful and magical &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;atmosphere of this unique musical performance.&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>video = pipe(prompt=prompt, guidance_scale=<span class="hljs-number">6</span>, num_inference_steps=<span class="hljs-number">50</span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(video, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">8</span>)`,wrap:!1}}),{c(){r=a("p"),r.textContent=J,w=i(),u(y.$$.fragment)},l(c){r=l(c,"P",{"data-svelte-h":!0}),p(r)!=="svelte-kvfsh7"&&(r.textContent=J),w=s(c),f(y.$$.fragment,c)},m(c,T){o(c,r,T),o(c,w,T),g(y,c,T),M=!0},p:jt,i(c){M||(h(y.$$.fragment,c),M=!0)},o(c){_(y.$$.fragment,c),M=!1},d(c){c&&(n(r),n(w)),b(y,c)}}}function Ht(re){let r,J,w,y,M,c,T,rt='<a href="https://arxiv.org/abs/2408.06072" rel="nofollow">CogVideoX: Text-to-Video Diffusion Models with An Expert Transformer</a> from Tsinghua University &amp; ZhipuAI, by Zhuoyi Yang, Jiayan Teng, Wendi Zheng, Ming Ding, Shiyu Huang, Jiazheng Xu, Yuanming Yang, Wenyi Hong, Xiaohan Zhang, Guanyu Feng, Da Yin, Xiaotao Gu, Yuxuan Zhang, Weihan Wang, Yean Cheng, Ting Liu, Bin Xu, Yuxiao Dong, Jie Tang.',we,k,dt="The abstract from the paper is:",ye,B,pt='<em>We introduce CogVideoX, a large-scale diffusion transformer model designed for generating videos based on text prompts. To efficently model video data, we propose to levearge a 3D Variational Autoencoder (VAE) to compresses videos along both spatial and temporal dimensions. To improve the text-video alignment, we propose an expert transformer with the expert adaptive LayerNorm to facilitate the deep fusion between the two modalities. By employing a progressive training technique, CogVideoX is adept at producing coherent, long-duration videos characterized by significant motion. In addition, we develop an effectively text-video data processing pipeline that includes various data preprocessing strategies and a video captioning method. It significantly helps enhance the performance of CogVideoX, improving both generation quality and semantic alignment. Results show that CogVideoX demonstrates state-of-the-art performance across both multiple machine metrics and human evaluations. The model weight of CogVideoX-2B is publicly available at <a href="https://github.com/THUDM/CogVideo" rel="nofollow">https://github.com/THUDM/CogVideo</a>.</em>',Me,j,Te,W,ct='This pipeline was contributed by <a href="https://github.com/zRzRzRzRzRzRzR" rel="nofollow">zRzRzRzRzRzRzR</a>. The original codebase can be found <a href="https://huggingface.co/THUDM" rel="nofollow">here</a>. The original weights can be found under <a href="https://huggingface.co/THUDM" rel="nofollow">hf.co/THUDM</a>.',Je,P,mt="There are two models available that can be used with the CogVideoX pipeline:",xe,H,ut='<li><a href="https://huggingface.co/THUDM/CogVideoX-2b" rel="nofollow"><code>THUDM/CogVideoX-2b</code></a></li> <li><a href="https://huggingface.co/THUDM/CogVideoX-5b" rel="nofollow"><code>THUDM/CogVideoX-5b</code></a></li>',Ce,z,Ue,Y,ft='Use <a href="https://huggingface.co/docs/diffusers/main/en/tutorials/fast_diffusion#torchcompile" rel="nofollow"><code>torch.compile</code></a> to reduce the inference latency.',je,N,gt="First, load the pipeline:",Ve,R,$e,L,ht="Then change the memory layout of the pipelines <code>transformer</code> component to <code>torch.channels_last</code>:",Ie,E,Ze,F,_t="Finally, compile the components and run inference:",Xe,q,Ge,D,bt='The <a href="https://gist.github.com/a-r-r-o-w/5183d75e452a368fd17448fcc810bd3f" rel="nofollow">benchmark</a> results on an 80GB A100 machine are:',ke,S,Be,Q,We,A,vt='CogVideoX-2b requires about 19 GB of GPU memory to decode 49 frames (6 seconds of video at 8 FPS) with output resolution 720x480 (W x H), which makes it not possible to run on consumer GPUs or free-tier T4 Colab. The following memory optimizations could be used to reduce the memory footprint. For replication, you can refer to <a href="https://gist.github.com/a-r-r-o-w/3959a03f15be5c9bd1fe545b09dfcc93" rel="nofollow">this</a> script.',Pe,O,wt="<li><code>pipe.enable_model_cpu_offload()</code>:<ul><li>Without enabling cpu offloading, memory usage is <code>33 GB</code></li> <li>With enabling cpu offloading, memory usage is <code>19 GB</code></li></ul></li> <li><code>pipe.vae.enable_tiling()</code>:<ul><li>With enabling cpu offloading and tiling, memory usage is <code>11 GB</code></li></ul></li> <li><code>pipe.vae.enable_slicing()</code></li>",He,K,ze,m,ee,Qe,de,yt="Pipeline for text-to-video generation using CogVideoX.",Ae,pe,Mt=`This model inherits from <a href="/docs/diffusers/v0.30.2/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Oe,x,te,Ke,ce,Tt="Function invoked when calling the pipeline for generation.",et,V,tt,$,ne,nt,me,Jt="Encodes the prompt into text encoder hidden states.",ot,I,oe,it,ue,xt="Enables fused QKV projections.",st,Z,ie,at,fe,Ct="Disable QKV projection fusion if enabled.",Ye,se,Ne,C,ae,lt,ge,Ut="Output class for CogVideo pipelines.",Re,le,Le,_e,Ee;return M=new be({props:{title:"CogVideoX",local:"cogvideox",headingTag:"h1"}}),j=new Gt({props:{$$slots:{default:[Wt]},$$scope:{ctx:re}}}),z=new be({props:{title:"Inference",local:"inference",headingTag:"h2"}}),R=new ve({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQ29nVmlkZW9YUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBcGlwZSUyMCUzRCUyMENvZ1ZpZGVvWFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJUSFVETSUyRkNvZ1ZpZGVvWC0yYiUyMikudG8oJTIyY3VkYSUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> CogVideoXPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

pipe = CogVideoXPipeline.from_pretrained(<span class="hljs-string">&quot;THUDM/CogVideoX-2b&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),E=new ve({props:{code:"cGlwZS50cmFuc2Zvcm1lci50byhtZW1vcnlfZm9ybWF0JTNEdG9yY2guY2hhbm5lbHNfbGFzdCk=",highlighted:"pipe.transformer.to(memory_format=torch.channels_last)",wrap:!1}}),q=new ve({props:{code:"cGlwZS50cmFuc2Zvcm1lciUyMCUzRCUyMHRvcmNoLmNvbXBpbGUocGlwZWxpbmUudHJhbnNmb3JtZXIlMkMlMjBtb2RlJTNEJTIybWF4LWF1dG90dW5lJTIyJTJDJTIwZnVsbGdyYXBoJTNEVHJ1ZSklMEElMEElMjMlMjBDb2dWaWRlb1glMjB3b3JrcyUyMHdlbGwlMjB3aXRoJTIwbG9uZyUyMGFuZCUyMHdlbGwtZGVzY3JpYmVkJTIwcHJvbXB0cyUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBwYW5kYSUyQyUyMGRyZXNzZWQlMjBpbiUyMGElMjBzbWFsbCUyQyUyMHJlZCUyMGphY2tldCUyMGFuZCUyMGElMjB0aW55JTIwaGF0JTJDJTIwc2l0cyUyMG9uJTIwYSUyMHdvb2RlbiUyMHN0b29sJTIwaW4lMjBhJTIwc2VyZW5lJTIwYmFtYm9vJTIwZm9yZXN0LiUyMFRoZSUyMHBhbmRhJ3MlMjBmbHVmZnklMjBwYXdzJTIwc3RydW0lMjBhJTIwbWluaWF0dXJlJTIwYWNvdXN0aWMlMjBndWl0YXIlMkMlMjBwcm9kdWNpbmclMjBzb2Z0JTJDJTIwbWVsb2RpYyUyMHR1bmVzLiUyME5lYXJieSUyQyUyMGElMjBmZXclMjBvdGhlciUyMHBhbmRhcyUyMGdhdGhlciUyQyUyMHdhdGNoaW5nJTIwY3VyaW91c2x5JTIwYW5kJTIwc29tZSUyMGNsYXBwaW5nJTIwaW4lMjByaHl0aG0uJTIwU3VubGlnaHQlMjBmaWx0ZXJzJTIwdGhyb3VnaCUyMHRoZSUyMHRhbGwlMjBiYW1ib28lMkMlMjBjYXN0aW5nJTIwYSUyMGdlbnRsZSUyMGdsb3clMjBvbiUyMHRoZSUyMHNjZW5lLiUyMFRoZSUyMHBhbmRhJ3MlMjBmYWNlJTIwaXMlMjBleHByZXNzaXZlJTJDJTIwc2hvd2luZyUyMGNvbmNlbnRyYXRpb24lMjBhbmQlMjBqb3klMjBhcyUyMGl0JTIwcGxheXMuJTIwVGhlJTIwYmFja2dyb3VuZCUyMGluY2x1ZGVzJTIwYSUyMHNtYWxsJTJDJTIwZmxvd2luZyUyMHN0cmVhbSUyMGFuZCUyMHZpYnJhbnQlMjBncmVlbiUyMGZvbGlhZ2UlMkMlMjBlbmhhbmNpbmclMjB0aGUlMjBwZWFjZWZ1bCUyMGFuZCUyMG1hZ2ljYWwlMjBhdG1vc3BoZXJlJTIwb2YlMjB0aGlzJTIwdW5pcXVlJTIwbXVzaWNhbCUyMHBlcmZvcm1hbmNlLiUyMiUwQXZpZGVvJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDYlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmZyYW1lcyU1QjAlNUQ=",highlighted:`pipe.transformer = torch.<span class="hljs-built_in">compile</span>(pipeline.transformer, mode=<span class="hljs-string">&quot;max-autotune&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># CogVideoX works well with long and well-described prompts</span>
prompt = <span class="hljs-string">&quot;A panda, dressed in a small, red jacket and a tiny hat, sits on a wooden stool in a serene bamboo forest. The panda&#x27;s fluffy paws strum a miniature acoustic guitar, producing soft, melodic tunes. Nearby, a few other pandas gather, watching curiously and some clapping in rhythm. Sunlight filters through the tall bamboo, casting a gentle glow on the scene. The panda&#x27;s face is expressive, showing concentration and joy as it plays. The background includes a small, flowing stream and vibrant green foliage, enhancing the peaceful and magical atmosphere of this unique musical performance.&quot;</span>
video = pipe(prompt=prompt, guidance_scale=<span class="hljs-number">6</span>, num_inference_steps=<span class="hljs-number">50</span>).frames[<span class="hljs-number">0</span>]`,wrap:!1}}),S=new ve({props:{code:"V2l0aG91dCUyMHRvcmNoLmNvbXBpbGUoKSUzQSUyMEF2ZXJhZ2UlMjBpbmZlcmVuY2UlMjB0aW1lJTNBJTIwOTYuODklMjBzZWNvbmRzLiUwQVdpdGglMjB0b3JjaC5jb21waWxlKCklM0ElMjBBdmVyYWdlJTIwaW5mZXJlbmNlJTIwdGltZSUzQSUyMDc2LjI3JTIwc2Vjb25kcy4=",highlighted:`<span class="hljs-attribute">Without</span> torch.compile(): Average inference time: <span class="hljs-number">96</span>.<span class="hljs-number">89</span> seconds.
<span class="hljs-attribute">With</span> torch.compile(): Average inference time: <span class="hljs-number">76</span>.<span class="hljs-number">27</span> seconds.`,wrap:!1}}),Q=new be({props:{title:"Memory optimization",local:"memory-optimization",headingTag:"h3"}}),K=new be({props:{title:"CogVideoXPipeline",local:"diffusers.CogVideoXPipeline",headingTag:"h2"}}),ee=new he({props:{name:"class diffusers.CogVideoXPipeline",anchor:"diffusers.CogVideoXPipeline",parameters:[{name:"tokenizer",val:": T5Tokenizer"},{name:"text_encoder",val:": T5EncoderModel"},{name:"vae",val:": AutoencoderKLCogVideoX"},{name:"transformer",val:": CogVideoXTransformer3DModel"},{name:"scheduler",val:": Union"}],parametersDescription:[{anchor:"diffusers.CogVideoXPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/v0.30.2/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"},{anchor:"diffusers.CogVideoXPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
Frozen text-encoder. CogVideoX uses
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>; specifically the
<a href="https://huggingface.co/PixArt-alpha/PixArt-alpha/tree/main/t5-v1_1-xxl" rel="nofollow">t5-v1_1-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.CogVideoXPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5Tokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5Tokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.CogVideoXPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/v0.30.2/en/api/models/cogvideox_transformer3d#diffusers.CogVideoXTransformer3DModel">CogVideoXTransformer3DModel</a>) &#x2014;
A text conditioned <code>CogVideoXTransformer3DModel</code> to denoise the encoded video latents.`,name:"transformer"},{anchor:"diffusers.CogVideoXPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/v0.30.2/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded video latents.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/v0.30.2/src/diffusers/pipelines/cogvideo/pipeline_cogvideox.py#L154"}}),te=new he({props:{name:"__call__",anchor:"diffusers.CogVideoXPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"negative_prompt",val:": Union = None"},{name:"height",val:": int = 480"},{name:"width",val:": int = 720"},{name:"num_frames",val:": int = 49"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": Optional = None"},{name:"guidance_scale",val:": float = 6"},{name:"use_dynamic_cfg",val:": bool = False"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"output_type",val:": str = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback_on_step_end",val:": Union = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"max_sequence_length",val:": int = 226"}],parametersDescription:[{anchor:"diffusers.CogVideoXPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.CogVideoXPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.CogVideoXPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"diffusers.CogVideoXPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"diffusers.CogVideoXPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, defaults to <code>48</code>) &#x2014;
Number of frames to generate. Must be divisible by self.vae_scale_factor_temporal. Generated video will
contain 1 extra frame because CogVideoX is conditioned with (num_seconds * fps + 1) frames where
num_seconds is 6 and fps is 4. However, since videos can be saved at any fps, the only condition that
needs to be satisfied is that of divisibility mentioned above.`,name:"num_frames"},{anchor:"diffusers.CogVideoXPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.CogVideoXPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.CogVideoXPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.CogVideoXPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of videos to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.CogVideoXPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.CogVideoXPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.CogVideoXPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.CogVideoXPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.CogVideoXPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.CogVideoXPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.CogVideoXPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.CogVideoXPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.CogVideoXPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code>, defaults to <code>226</code>) &#x2014;
Maximum sequence length in encoded prompt. Must be consistent with
<code>self.transformer.config.max_text_seq_length</code> otherwise may lead to poor results.`,name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/v0.30.2/src/diffusers/pipelines/cogvideo/pipeline_cogvideox.py#L485",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/v0.30.2/en/api/pipelines/cogvideox#diffusers.pipelines.cogvideo.pipeline_cogvideox.CogVideoXPipelineOutput"
>CogVideoXPipelineOutput</a> if <code>return_dict</code> is True, otherwise a
<code>tuple</code>. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/v0.30.2/en/api/pipelines/cogvideox#diffusers.pipelines.cogvideo.pipeline_cogvideox.CogVideoXPipelineOutput"
>CogVideoXPipelineOutput</a> or <code>tuple</code></p>
`}}),V=new kt({props:{anchor:"diffusers.CogVideoXPipeline.__call__.example",$$slots:{default:[Pt]},$$scope:{ctx:re}}}),ne=new he({props:{name:"encode_prompt",anchor:"diffusers.CogVideoXPipeline.encode_prompt",parameters:[{name:"prompt",val:": Union"},{name:"negative_prompt",val:": Union = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"max_sequence_length",val:": int = 226"},{name:"device",val:": Optional = None"},{name:"dtype",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.CogVideoXPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.CogVideoXPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.CogVideoXPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.CogVideoXPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.CogVideoXPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.CogVideoXPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.
device &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device
dtype &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"negative_prompt_embeds"}],source:"https://github.com/huggingface/diffusers/blob/v0.30.2/src/diffusers/pipelines/cogvideo/pipeline_cogvideox.py#L250"}}),oe=new he({props:{name:"fuse_qkv_projections",anchor:"diffusers.CogVideoXPipeline.fuse_qkv_projections",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.30.2/src/diffusers/pipelines/cogvideo/pipeline_cogvideox.py#L433"}}),ie=new he({props:{name:"unfuse_qkv_projections",anchor:"diffusers.CogVideoXPipeline.unfuse_qkv_projections",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.30.2/src/diffusers/pipelines/cogvideo/pipeline_cogvideox.py#L438"}}),se=new be({props:{title:"CogVideoXPipelineOutput",local:"diffusers.pipelines.cogvideo.pipeline_cogvideox.CogVideoXPipelineOutput",headingTag:"h2"}}),ae=new he({props:{name:"class diffusers.pipelines.cogvideo.pipeline_cogvideox.CogVideoXPipelineOutput",anchor:"diffusers.pipelines.cogvideo.pipeline_cogvideox.CogVideoXPipelineOutput",parameters:[{name:"frames",val:": Tensor"}],parametersDescription:[{anchor:"diffusers.pipelines.cogvideo.pipeline_cogvideox.CogVideoXPipelineOutput.frames",description:`<strong>frames</strong> (<code>torch.Tensor</code>, <code>np.ndarray</code>, or List[List[PIL.Image.Image]]) &#x2014;
List of video outputs - It can be a nested list of length <code>batch_size,</code> with each sub-list containing
denoised PIL image sequences of length <code>num_frames.</code> It can also be a NumPy array or Torch tensor of shape
<code>(batch_size, num_frames, channels, height, width)</code>.`,name:"frames"}],source:"https://github.com/huggingface/diffusers/blob/v0.30.2/src/diffusers/pipelines/cogvideo/pipeline_cogvideox.py#L139"}}),le=new Bt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/cogvideox.md"}}),{c(){r=a("meta"),J=i(),w=a("p"),y=i(),u(M.$$.fragment),c=i(),T=a("p"),T.innerHTML=rt,we=i(),k=a("p"),k.textContent=dt,ye=i(),B=a("p"),B.innerHTML=pt,Me=i(),u(j.$$.fragment),Te=i(),W=a("p"),W.innerHTML=ct,Je=i(),P=a("p"),P.textContent=mt,xe=i(),H=a("ul"),H.innerHTML=ut,Ce=i(),u(z.$$.fragment),Ue=i(),Y=a("p"),Y.innerHTML=ft,je=i(),N=a("p"),N.textContent=gt,Ve=i(),u(R.$$.fragment),$e=i(),L=a("p"),L.innerHTML=ht,Ie=i(),u(E.$$.fragment),Ze=i(),F=a("p"),F.textContent=_t,Xe=i(),u(q.$$.fragment),Ge=i(),D=a("p"),D.innerHTML=bt,ke=i(),u(S.$$.fragment),Be=i(),u(Q.$$.fragment),We=i(),A=a("p"),A.innerHTML=vt,Pe=i(),O=a("ul"),O.innerHTML=wt,He=i(),u(K.$$.fragment),ze=i(),m=a("div"),u(ee.$$.fragment),Qe=i(),de=a("p"),de.textContent=yt,Ae=i(),pe=a("p"),pe.innerHTML=Mt,Oe=i(),x=a("div"),u(te.$$.fragment),Ke=i(),ce=a("p"),ce.textContent=Tt,et=i(),u(V.$$.fragment),tt=i(),$=a("div"),u(ne.$$.fragment),nt=i(),me=a("p"),me.textContent=Jt,ot=i(),I=a("div"),u(oe.$$.fragment),it=i(),ue=a("p"),ue.textContent=xt,st=i(),Z=a("div"),u(ie.$$.fragment),at=i(),fe=a("p"),fe.textContent=Ct,Ye=i(),u(se.$$.fragment),Ne=i(),C=a("div"),u(ae.$$.fragment),lt=i(),ge=a("p"),ge.textContent=Ut,Re=i(),u(le.$$.fragment),Le=i(),_e=a("p"),this.h()},l(e){const t=Xt("svelte-u9bgzb",document.head);r=l(t,"META",{name:!0,content:!0}),t.forEach(n),J=s(e),w=l(e,"P",{}),X(w).forEach(n),y=s(e),f(M.$$.fragment,e),c=s(e),T=l(e,"P",{"data-svelte-h":!0}),p(T)!=="svelte-1jx3rme"&&(T.innerHTML=rt),we=s(e),k=l(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-1cwsb16"&&(k.textContent=dt),ye=s(e),B=l(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-19oae4l"&&(B.innerHTML=pt),Me=s(e),f(j.$$.fragment,e),Te=s(e),W=l(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-14a2tju"&&(W.innerHTML=ct),Je=s(e),P=l(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-n3pqk3"&&(P.textContent=mt),xe=s(e),H=l(e,"UL",{"data-svelte-h":!0}),p(H)!=="svelte-1sqd7ay"&&(H.innerHTML=ut),Ce=s(e),f(z.$$.fragment,e),Ue=s(e),Y=l(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-iekg51"&&(Y.innerHTML=ft),je=s(e),N=l(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-jub7f1"&&(N.textContent=gt),Ve=s(e),f(R.$$.fragment,e),$e=s(e),L=l(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-1p91erm"&&(L.innerHTML=ht),Ie=s(e),f(E.$$.fragment,e),Ze=s(e),F=l(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-9i4prs"&&(F.textContent=_t),Xe=s(e),f(q.$$.fragment,e),Ge=s(e),D=l(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1brnakn"&&(D.innerHTML=bt),ke=s(e),f(S.$$.fragment,e),Be=s(e),f(Q.$$.fragment,e),We=s(e),A=l(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1wycjro"&&(A.innerHTML=vt),Pe=s(e),O=l(e,"UL",{"data-svelte-h":!0}),p(O)!=="svelte-v5wcbj"&&(O.innerHTML=wt),He=s(e),f(K.$$.fragment,e),ze=s(e),m=l(e,"DIV",{class:!0});var v=X(m);f(ee.$$.fragment,v),Qe=s(v),de=l(v,"P",{"data-svelte-h":!0}),p(de)!=="svelte-gmblkq"&&(de.textContent=yt),Ae=s(v),pe=l(v,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-4jgft3"&&(pe.innerHTML=Mt),Oe=s(v),x=l(v,"DIV",{class:!0});var U=X(x);f(te.$$.fragment,U),Ke=s(U),ce=l(U,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-v78lg8"&&(ce.textContent=Tt),et=s(U),f(V.$$.fragment,U),U.forEach(n),tt=s(v),$=l(v,"DIV",{class:!0});var Fe=X($);f(ne.$$.fragment,Fe),nt=s(Fe),me=l(Fe,"P",{"data-svelte-h":!0}),p(me)!=="svelte-16q0ax1"&&(me.textContent=Jt),Fe.forEach(n),ot=s(v),I=l(v,"DIV",{class:!0});var qe=X(I);f(oe.$$.fragment,qe),it=s(qe),ue=l(qe,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-1vadzv1"&&(ue.textContent=xt),qe.forEach(n),st=s(v),Z=l(v,"DIV",{class:!0});var De=X(Z);f(ie.$$.fragment,De),at=s(De),fe=l(De,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-fohozp"&&(fe.textContent=Ct),De.forEach(n),v.forEach(n),Ye=s(e),f(se.$$.fragment,e),Ne=s(e),C=l(e,"DIV",{class:!0});var Se=X(C);f(ae.$$.fragment,Se),lt=s(Se),ge=l(Se,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-1qnvsrt"&&(ge.textContent=Ut),Se.forEach(n),Re=s(e),f(le.$$.fragment,e),Le=s(e),_e=l(e,"P",{}),X(_e).forEach(n),this.h()},h(){G(r,"name","hf:doc:metadata"),G(r,"content",zt),G(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),G($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),G(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),G(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),G(m,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),G(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){d(document.head,r),o(e,J,t),o(e,w,t),o(e,y,t),g(M,e,t),o(e,c,t),o(e,T,t),o(e,we,t),o(e,k,t),o(e,ye,t),o(e,B,t),o(e,Me,t),g(j,e,t),o(e,Te,t),o(e,W,t),o(e,Je,t),o(e,P,t),o(e,xe,t),o(e,H,t),o(e,Ce,t),g(z,e,t),o(e,Ue,t),o(e,Y,t),o(e,je,t),o(e,N,t),o(e,Ve,t),g(R,e,t),o(e,$e,t),o(e,L,t),o(e,Ie,t),g(E,e,t),o(e,Ze,t),o(e,F,t),o(e,Xe,t),g(q,e,t),o(e,Ge,t),o(e,D,t),o(e,ke,t),g(S,e,t),o(e,Be,t),g(Q,e,t),o(e,We,t),o(e,A,t),o(e,Pe,t),o(e,O,t),o(e,He,t),g(K,e,t),o(e,ze,t),o(e,m,t),g(ee,m,null),d(m,Qe),d(m,de),d(m,Ae),d(m,pe),d(m,Oe),d(m,x),g(te,x,null),d(x,Ke),d(x,ce),d(x,et),g(V,x,null),d(m,tt),d(m,$),g(ne,$,null),d($,nt),d($,me),d(m,ot),d(m,I),g(oe,I,null),d(I,it),d(I,ue),d(m,st),d(m,Z),g(ie,Z,null),d(Z,at),d(Z,fe),o(e,Ye,t),g(se,e,t),o(e,Ne,t),o(e,C,t),g(ae,C,null),d(C,lt),d(C,ge),o(e,Re,t),g(le,e,t),o(e,Le,t),o(e,_e,t),Ee=!0},p(e,[t]){const v={};t&2&&(v.$$scope={dirty:t,ctx:e}),j.$set(v);const U={};t&2&&(U.$$scope={dirty:t,ctx:e}),V.$set(U)},i(e){Ee||(h(M.$$.fragment,e),h(j.$$.fragment,e),h(z.$$.fragment,e),h(R.$$.fragment,e),h(E.$$.fragment,e),h(q.$$.fragment,e),h(S.$$.fragment,e),h(Q.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),h(te.$$.fragment,e),h(V.$$.fragment,e),h(ne.$$.fragment,e),h(oe.$$.fragment,e),h(ie.$$.fragment,e),h(se.$$.fragment,e),h(ae.$$.fragment,e),h(le.$$.fragment,e),Ee=!0)},o(e){_(M.$$.fragment,e),_(j.$$.fragment,e),_(z.$$.fragment,e),_(R.$$.fragment,e),_(E.$$.fragment,e),_(q.$$.fragment,e),_(S.$$.fragment,e),_(Q.$$.fragment,e),_(K.$$.fragment,e),_(ee.$$.fragment,e),_(te.$$.fragment,e),_(V.$$.fragment,e),_(ne.$$.fragment,e),_(oe.$$.fragment,e),_(ie.$$.fragment,e),_(se.$$.fragment,e),_(ae.$$.fragment,e),_(le.$$.fragment,e),Ee=!1},d(e){e&&(n(J),n(w),n(y),n(c),n(T),n(we),n(k),n(ye),n(B),n(Me),n(Te),n(W),n(Je),n(P),n(xe),n(H),n(Ce),n(Ue),n(Y),n(je),n(N),n(Ve),n($e),n(L),n(Ie),n(Ze),n(F),n(Xe),n(Ge),n(D),n(ke),n(Be),n(We),n(A),n(Pe),n(O),n(He),n(ze),n(m),n(Ye),n(Ne),n(C),n(Re),n(Le),n(_e)),n(r),b(M,e),b(j,e),b(z,e),b(R,e),b(E,e),b(q,e),b(S,e),b(Q,e),b(K,e),b(ee),b(te),b(V),b(ne),b(oe),b(ie),b(se,e),b(ae),b(le,e)}}}const zt='{"title":"CogVideoX","local":"cogvideox","sections":[{"title":"Inference","local":"inference","sections":[{"title":"Memory optimization","local":"memory-optimization","sections":[],"depth":3}],"depth":2},{"title":"CogVideoXPipeline","local":"diffusers.CogVideoXPipeline","sections":[],"depth":2},{"title":"CogVideoXPipelineOutput","local":"diffusers.pipelines.cogvideo.pipeline_cogvideox.CogVideoXPipelineOutput","sections":[],"depth":2}],"depth":1}';function Yt(re){return $t(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class St extends It{constructor(r){super(),Zt(this,r,Yt,Ht,Vt,{})}}export{St as component};
