import{s as Zo,o as Jo,n as Mt}from"../chunks/scheduler.182ea377.js";import{S as Vo,i as jo,g as a,s,r as f,A as ko,h as l,f as o,c as i,j as D,u,x as d,k as U,y as p,a as n,v as h,d as g,t as _,w as v}from"../chunks/index.abf12888.js";import{T as yo}from"../chunks/Tip.230e2334.js";import{D as ye}from"../chunks/Docstring.93f6f462.js";import{C as Me}from"../chunks/CodeBlock.57fe6e13.js";import{E as Mo}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as B}from"../chunks/Heading.16916d63.js";function $o(j){let r,Z="🧪 This pipeline is for research purposes only.";return{c(){r=a("p"),r.textContent=Z},l(m){r=l(m,"P",{"data-svelte-h":!0}),d(r)!=="svelte-1oxhjjd"&&(r.textContent=Z)},m(m,b){n(m,r,b)},p:Mt,d(m){m&&o(r)}}}function So(j){let r,Z='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){r=a("p"),r.innerHTML=Z},l(m){r=l(m,"P",{"data-svelte-h":!0}),d(r)!=="svelte-1wmc0l4"&&(r.innerHTML=Z)},m(m,b){n(m,r,b)},p:Mt,d(m){m&&o(r)}}}function Do(j){let r,Z="Examples:",m,b,x;return b=new Me({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwVGV4dFRvVmlkZW9TRFBpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGV4cG9ydF90b192aWRlbyUwQSUwQXBpcGUlMjAlM0QlMjBUZXh0VG9WaWRlb1NEUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmRhbW8tdmlsYWIlMkZ0ZXh0LXRvLXZpZGVvLW1zLTEuN2IlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUwQSklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyU3BpZGVybWFuJTIwaXMlMjBzdXJmaW5nJTIyJTBBdmlkZW9fZnJhbWVzJTIwJTNEJTIwcGlwZShwcm9tcHQpLmZyYW1lcyU1QjAlNUQlMEF2aWRlb19wYXRoJTIwJTNEJTIwZXhwb3J0X3RvX3ZpZGVvKHZpZGVvX2ZyYW1lcyklMEF2aWRlb19wYXRo",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> TextToVideoSDPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = TextToVideoSDPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;damo-vilab/text-to-video-ms-1.7b&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_model_cpu_offload()

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Spiderman is surfing&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>video_frames = pipe(prompt).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>video_path = export_to_video(video_frames)
<span class="hljs-meta">&gt;&gt;&gt; </span>video_path`,wrap:!1}}),{c(){r=a("p"),r.textContent=Z,m=s(),f(b.$$.fragment)},l(c){r=l(c,"P",{"data-svelte-h":!0}),d(r)!=="svelte-kvfsh7"&&(r.textContent=Z),m=i(c),u(b.$$.fragment,c)},m(c,J){n(c,r,J),n(c,m,J),h(b,c,J),x=!0},p:Mt,i(c){x||(g(b.$$.fragment,c),x=!0)},o(c){_(b.$$.fragment,c),x=!1},d(c){c&&(o(r),o(m)),v(b,c)}}}function Uo(j){let r,Z="Examples:",m,b,x;return b=new Me({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, DPMSolverMultistepScheduler
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;cerspense/zeroscope_v2_576w&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = DPMSolverMultistepScheduler.from_config(pipe.scheduler.config)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;spiderman running in the desert&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>video_frames = pipe(prompt, num_inference_steps=<span class="hljs-number">40</span>, height=<span class="hljs-number">320</span>, width=<span class="hljs-number">576</span>, num_frames=<span class="hljs-number">24</span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># safe low-res video</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>video_path = export_to_video(video_frames, output_video_path=<span class="hljs-string">&quot;./video_576_spiderman.mp4&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># let&#x27;s offload the text-to-image model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cpu&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># and load the image-to-image model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;cerspense/zeroscope_v2_XL&quot;</span>, torch_dtype=torch.float16, revision=<span class="hljs-string">&quot;refs/pr/15&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = DPMSolverMultistepScheduler.from_config(pipe.scheduler.config)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_model_cpu_offload()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># The VAE consumes A LOT of memory, let&#x27;s make sure we run it in sliced mode</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_slicing()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># now let&#x27;s upscale it</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>video = [Image.fromarray(frame).resize((<span class="hljs-number">1024</span>, <span class="hljs-number">576</span>)) <span class="hljs-keyword">for</span> frame <span class="hljs-keyword">in</span> video_frames]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># and denoise it</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>video_frames = pipe(prompt, video=video, strength=<span class="hljs-number">0.6</span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>video_path = export_to_video(video_frames, output_video_path=<span class="hljs-string">&quot;./video_1024_spiderman.mp4&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>video_path`,wrap:!1}}),{c(){r=a("p"),r.textContent=Z,m=s(),f(b.$$.fragment)},l(c){r=l(c,"P",{"data-svelte-h":!0}),d(r)!=="svelte-kvfsh7"&&(r.textContent=Z),m=i(c),u(b.$$.fragment,c)},m(c,J){n(c,r,J),n(c,m,J),h(b,c,J),x=!0},p:Mt,i(c){x||(g(b.$$.fragment,c),x=!0)},o(c){_(b.$$.fragment,c),x=!1},d(c){c&&(o(r),o(m)),v(b,c)}}}function Co(j){let r,Z,m,b,x,c,J,ze,X,Et='<a href="https://arxiv.org/abs/2308.06571" rel="nofollow">ModelScope Text-to-Video Technical Report</a> is by Jiuniu Wang, Hangjie Yuan, Dayou Chen, Yingya Zhang, Xiang Wang, Shiwei Zhang.',Re,L,Ht="The abstract from the paper is:",Ne,z,Ft='<em>This paper introduces ModelScopeT2V, a text-to-video synthesis model that evolves from a text-to-image synthesis model (i.e., Stable Diffusion). ModelScopeT2V incorporates spatio-temporal blocks to ensure consistent frame generation and smooth movement transitions. The model could adapt to varying frame numbers during training and inference, rendering it suitable for both image-text and video-text datasets. ModelScopeT2V brings together three components (i.e., VQGAN, a text encoder, and a denoising UNet), totally comprising 1.7 billion parameters, in which 0.5 billion parameters are dedicated to temporal capabilities. The model demonstrates superior performance over state-of-the-art methods across three evaluation metrics. The code and an online demo are available at <a href="https://modelscope.cn/models/damo/text-to-video-synthesis/summary" rel="nofollow">https://modelscope.cn/models/damo/text-to-video-synthesis/summary</a>.</em>',Ee,R,Yt='You can find additional information about Text-to-Video on the <a href="https://modelscope.cn/models/damo/text-to-video-synthesis/summary" rel="nofollow">project page</a>, <a href="https://github.com/modelscope/modelscope/" rel="nofollow">original codebase</a>, and try it out in a <a href="https://huggingface.co/spaces/damo-vilab/modelscope-text-to-video-synthesis" rel="nofollow">demo</a>. Official checkpoints can be found at <a href="https://huggingface.co/damo-vilab" rel="nofollow">damo-vilab</a> and <a href="https://huggingface.co/cerspense" rel="nofollow">cerspense</a>.',He,N,Fe,E,Ye,H,Qt="Let’s start by generating a short video with the default length of 16 frames (2s at 8 fps):",Qe,F,Ae,Y,At=`Diffusers supports different optimization techniques to improve the latency
and memory footprint of a pipeline. Since videos are often more memory-heavy than images,
we can enable CPU offloading and VAE slicing to keep the memory footprint at bay.`,qe,Q,qt="Let’s generate a video of 8 seconds (64 frames) on the same GPU using CPU offloading and VAE slicing:",Oe,A,Ke,q,Ot="It just takes <strong>7 GBs of GPU memory</strong> to generate the 64 video frames using PyTorch 2.0, “fp16” precision and the techniques mentioned above.",et,O,Kt="We can also use a different scheduler easily, using the same method we’d use for Stable Diffusion:",tt,K,ot,ee,eo="Here are some sample outputs:",nt,te,to=`<tbody><tr><td><center>An astronaut riding a horse.
        <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/astr.gif" alt="An astronaut riding a horse." style="width: 300px;"/></center></td> <td><center>Darth vader surfing in waves.
        <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/vader.gif" alt="Darth vader surfing in waves." style="width: 300px;"/></center></td></tr></tbody>`,st,oe,it,ne,oo=`Zeroscope are watermark-free model and have been trained on specific sizes such as <code>576x320</code> and <code>1024x576</code>.
One should first generate a video using the lower resolution checkpoint <a href="https://huggingface.co/cerspense/zeroscope_v2_576w" rel="nofollow"><code>cerspense/zeroscope_v2_576w</code></a> with <a href="/docs/diffusers/v0.27.2/en/api/pipelines/text_to_video#diffusers.TextToVideoSDPipeline">TextToVideoSDPipeline</a>,
which can then be upscaled using <a href="/docs/diffusers/v0.27.2/en/api/pipelines/text_to_video#diffusers.VideoToVideoSDPipeline">VideoToVideoSDPipeline</a> and <a href="https://huggingface.co/cerspense/zeroscope_v2_XL" rel="nofollow"><code>cerspense/zeroscope_v2_XL</code></a>.`,at,se,lt,ie,no="Now the video can be upscaled:",rt,ae,pt,le,so="Here are some sample outputs:",dt,re,io=`<tbody><tr><td><center>Darth vader surfing in waves.
        <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/darthvader_cerpense.gif" alt="Darth vader surfing in waves." style="width: 576px;"/></center></td></tr></tbody>`,ct,pe,mt,de,ao="Video generation is memory-intensive and one way to reduce your memory usage is to set <code>enable_forward_chunking</code> on the pipeline’s UNet so you don’t run the entire feedforward layer at once. Breaking it up into chunks in a loop is more efficient.",ft,ce,lo='Check out the <a href="text-img2vid">Text or image-to-video</a> guide for more details about how certain parameters can affect video generation and how to optimize inference by reducing memory usage.',ut,C,ht,me,gt,T,fe,Zt,Ze,ro="Pipeline for text-to-video generation.",Jt,Je,po=`This model inherits from <a href="/docs/diffusers/v0.27.2/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Vt,Ve,co="The pipeline also inherits the following loading methods:",jt,je,mo='<li><a href="/docs/diffusers/v0.27.2/en/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/v0.27.2/en/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/v0.27.2/en/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li>',kt,k,ue,$t,ke,fo="The call function to the pipeline for generation.",St,I,Dt,P,he,Ut,$e,uo="Encodes the prompt into text encoder hidden states.",_t,ge,vt,w,_e,Ct,Se,ho="Pipeline for text-guided video-to-video generation.",It,De,go=`This model inherits from <a href="/docs/diffusers/v0.27.2/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Pt,Ue,_o="The pipeline also inherits the following loading methods:",Gt,Ce,vo='<li><a href="/docs/diffusers/v0.27.2/en/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/v0.27.2/en/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/v0.27.2/en/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li>',Wt,$,ve,Bt,Ie,bo="The call function to the pipeline for generation.",Xt,G,Lt,W,be,zt,Pe,To="Encodes the prompt into text encoder hidden states.",bt,Te,Tt,V,we,Rt,Ge,wo="Output class for text-to-video pipelines.",Nt,We,xo=`PIL image sequences of length <code>num_frames.</code> It can also be a NumPy array or Torch tensor of shape
<code>(batch_size, num_frames, channels, height, width)</code>`,wt,Le,xt;return x=new yo({props:{warning:!0,$$slots:{default:[$o]},$$scope:{ctx:j}}}),J=new B({props:{title:"Text-to-video",local:"text-to-video",headingTag:"h1"}}),N=new B({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),E=new B({props:{title:"text-to-video-ms-1.7b",local:"text-to-video-ms-17b",headingTag:"h3"}}),F=new Me({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBcGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJkYW1vLXZpbGFiJTJGdGV4dC10by12aWRlby1tcy0xLjdiJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJTcGlkZXJtYW4lMjBpcyUyMHN1cmZpbmclMjIlMEF2aWRlb19mcmFtZXMlMjAlM0QlMjBwaXBlKHByb21wdCkuZnJhbWVzJTVCMCU1RCUwQXZpZGVvX3BhdGglMjAlM0QlMjBleHBvcnRfdG9fdmlkZW8odmlkZW9fZnJhbWVzKSUwQXZpZGVvX3BhdGg=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;damo-vilab/text-to-video-ms-1.7b&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;Spiderman is surfing&quot;</span>
video_frames = pipe(prompt).frames[<span class="hljs-number">0</span>]
video_path = export_to_video(video_frames)
video_path`,wrap:!1}}),A=new Me({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBcGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJkYW1vLXZpbGFiJTJGdGV4dC10by12aWRlby1tcy0xLjdiJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIpJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUwQSUyMyUyMG1lbW9yeSUyMG9wdGltaXphdGlvbiUwQXBpcGUuZW5hYmxlX3ZhZV9zbGljaW5nKCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJEYXJ0aCUyMFZhZGVyJTIwc3VyZmluZyUyMGElMjB3YXZlJTIyJTBBdmlkZW9fZnJhbWVzJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1fZnJhbWVzJTNENjQpLmZyYW1lcyU1QjAlNUQlMEF2aWRlb19wYXRoJTIwJTNEJTIwZXhwb3J0X3RvX3ZpZGVvKHZpZGVvX2ZyYW1lcyklMEF2aWRlb19wYXRo",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;damo-vilab/text-to-video-ms-1.7b&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)
pipe.enable_model_cpu_offload()

<span class="hljs-comment"># memory optimization</span>
pipe.enable_vae_slicing()

prompt = <span class="hljs-string">&quot;Darth Vader surfing a wave&quot;</span>
video_frames = pipe(prompt, num_frames=<span class="hljs-number">64</span>).frames[<span class="hljs-number">0</span>]
video_path = export_to_video(video_frames)
video_path`,wrap:!1}}),K=new Me({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBEUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBcGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJkYW1vLXZpbGFiJTJGdGV4dC10by12aWRlby1tcy0xLjdiJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIpJTBBcGlwZS5zY2hlZHVsZXIlMjAlM0QlMjBEUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIuZnJvbV9jb25maWcocGlwZS5zY2hlZHVsZXIuY29uZmlnKSUwQXBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJTcGlkZXJtYW4lMjBpcyUyMHN1cmZpbmclMjIlMEF2aWRlb19mcmFtZXMlMjAlM0QlMjBwaXBlKHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyNSkuZnJhbWVzJTVCMCU1RCUwQXZpZGVvX3BhdGglMjAlM0QlMjBleHBvcnRfdG9fdmlkZW8odmlkZW9fZnJhbWVzKSUwQXZpZGVvX3BhdGg=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, DPMSolverMultistepScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;damo-vilab/text-to-video-ms-1.7b&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)
pipe.scheduler = DPMSolverMultistepScheduler.from_config(pipe.scheduler.config)
pipe.enable_model_cpu_offload()

prompt = <span class="hljs-string">&quot;Spiderman is surfing&quot;</span>
video_frames = pipe(prompt, num_inference_steps=<span class="hljs-number">25</span>).frames[<span class="hljs-number">0</span>]
video_path = export_to_video(video_frames)
video_path`,wrap:!1}}),oe=new B({props:{title:"cerspense/zeroscope_v2_576w & cerspense/zeroscope_v2_XL",local:"cerspensezeroscopev2576w--cerspensezeroscopev2xl",headingTag:"h3"}}),se=new Me({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBEUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBJTBBcGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJjZXJzcGVuc2UlMkZ6ZXJvc2NvcGVfdjJfNTc2dyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBJTIzJTIwbWVtb3J5JTIwb3B0aW1pemF0aW9uJTBBcGlwZS51bmV0LmVuYWJsZV9mb3J3YXJkX2NodW5raW5nKGNodW5rX3NpemUlM0QxJTJDJTIwZGltJTNEMSklMEFwaXBlLmVuYWJsZV92YWVfc2xpY2luZygpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyRGFydGglMjBWYWRlciUyMHN1cmZpbmclMjBhJTIwd2F2ZSUyMiUwQXZpZGVvX2ZyYW1lcyUyMCUzRCUyMHBpcGUocHJvbXB0JTJDJTIwbnVtX2ZyYW1lcyUzRDI0KS5mcmFtZXMlNUIwJTVEJTBBdmlkZW9fcGF0aCUyMCUzRCUyMGV4cG9ydF90b192aWRlbyh2aWRlb19mcmFtZXMpJTBBdmlkZW9fcGF0aA==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, DPMSolverMultistepScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;cerspense/zeroscope_v2_576w&quot;</span>, torch_dtype=torch.float16)
pipe.enable_model_cpu_offload()

<span class="hljs-comment"># memory optimization</span>
pipe.unet.enable_forward_chunking(chunk_size=<span class="hljs-number">1</span>, dim=<span class="hljs-number">1</span>)
pipe.enable_vae_slicing()

prompt = <span class="hljs-string">&quot;Darth Vader surfing a wave&quot;</span>
video_frames = pipe(prompt, num_frames=<span class="hljs-number">24</span>).frames[<span class="hljs-number">0</span>]
video_path = export_to_video(video_frames)
video_path`,wrap:!1}}),ae=new Me({props:{code:"cGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJjZXJzcGVuc2UlMkZ6ZXJvc2NvcGVfdjJfWEwlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBcGlwZS5zY2hlZHVsZXIlMjAlM0QlMjBEUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIuZnJvbV9jb25maWcocGlwZS5zY2hlZHVsZXIuY29uZmlnKSUwQXBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMEElMjMlMjBtZW1vcnklMjBvcHRpbWl6YXRpb24lMEFwaXBlLnVuZXQuZW5hYmxlX2ZvcndhcmRfY2h1bmtpbmcoY2h1bmtfc2l6ZSUzRDElMkMlMjBkaW0lM0QxKSUwQXBpcGUuZW5hYmxlX3ZhZV9zbGljaW5nKCklMEElMEF2aWRlbyUyMCUzRCUyMCU1QkltYWdlLmZyb21hcnJheShmcmFtZSkucmVzaXplKCgxMDI0JTJDJTIwNTc2KSklMjBmb3IlMjBmcmFtZSUyMGluJTIwdmlkZW9fZnJhbWVzJTVEJTBBJTBBdmlkZW9fZnJhbWVzJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjB2aWRlbyUzRHZpZGVvJTJDJTIwc3RyZW5ndGglM0QwLjYpLmZyYW1lcyU1QjAlNUQlMEF2aWRlb19wYXRoJTIwJTNEJTIwZXhwb3J0X3RvX3ZpZGVvKHZpZGVvX2ZyYW1lcyklMEF2aWRlb19wYXRo",highlighted:`pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;cerspense/zeroscope_v2_XL&quot;</span>, torch_dtype=torch.float16)
pipe.scheduler = DPMSolverMultistepScheduler.from_config(pipe.scheduler.config)
pipe.enable_model_cpu_offload()

<span class="hljs-comment"># memory optimization</span>
pipe.unet.enable_forward_chunking(chunk_size=<span class="hljs-number">1</span>, dim=<span class="hljs-number">1</span>)
pipe.enable_vae_slicing()

video = [Image.fromarray(frame).resize((<span class="hljs-number">1024</span>, <span class="hljs-number">576</span>)) <span class="hljs-keyword">for</span> frame <span class="hljs-keyword">in</span> video_frames]

video_frames = pipe(prompt, video=video, strength=<span class="hljs-number">0.6</span>).frames[<span class="hljs-number">0</span>]
video_path = export_to_video(video_frames)
video_path`,wrap:!1}}),pe=new B({props:{title:"Tips",local:"tips",headingTag:"h2"}}),C=new yo({props:{$$slots:{default:[So]},$$scope:{ctx:j}}}),me=new B({props:{title:"TextToVideoSDPipeline",local:"diffusers.TextToVideoSDPipeline",headingTag:"h2"}}),fe=new ye({props:{name:"class diffusers.TextToVideoSDPipeline",anchor:"diffusers.TextToVideoSDPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet3DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"}],parametersDescription:[{anchor:"diffusers.TextToVideoSDPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/v0.27.2/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.TextToVideoSDPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.TextToVideoSDPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
A <a href="https://huggingface.co/docs/transformers/v4.39.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.TextToVideoSDPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/v0.27.2/en/api/models/unet3d-cond#diffusers.UNet3DConditionModel">UNet3DConditionModel</a>) &#x2014;
A <a href="/docs/diffusers/v0.27.2/en/api/models/unet3d-cond#diffusers.UNet3DConditionModel">UNet3DConditionModel</a> to denoise the encoded video latents.`,name:"unet"},{anchor:"diffusers.TextToVideoSDPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/v0.27.2/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/v0.27.2/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/v0.27.2/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/v0.27.2/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth.py#L84"}}),ue=new ye({props:{name:"__call__",anchor:"diffusers.TextToVideoSDPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_frames",val:": int = 16"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 9.0"},{name:"negative_prompt",val:": Union = None"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'np'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.TextToVideoSDPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated video.`,name:"height"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated video.`,name:"width"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The number of video frames that are generated. Defaults to 16 frames which at 8 frames per seconds
amounts to 2 seconds of video.`,name:"num_frames"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality videos at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/v0.27.2/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for video
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>. Latents should be of shape
<code>(batch_size, num_channel, num_frames, height, width)</code>.`,name:"latents"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;np&quot;</code>) &#x2014;
The output format of the generated video. Choose between <code>torch.FloatTensor</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.27.2/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput">TextToVideoSDPipelineOutput</a> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth.py#L455",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/v0.27.2/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput"
>TextToVideoSDPipelineOutput</a> is
returned, otherwise a <code>tuple</code> is returned where the first element is a list with the generated frames.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/v0.27.2/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput"
>TextToVideoSDPipelineOutput</a> or <code>tuple</code></p>
`}}),I=new Mo({props:{anchor:"diffusers.TextToVideoSDPipeline.__call__.example",$$slots:{default:[Do]},$$scope:{ctx:j}}}),he=new ye({props:{name:"encode_prompt",anchor:"diffusers.TextToVideoSDPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.TextToVideoSDPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.TextToVideoSDPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.TextToVideoSDPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.TextToVideoSDPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.TextToVideoSDPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.TextToVideoSDPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.TextToVideoSDPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.TextToVideoSDPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth.py#L166"}}),ge=new B({props:{title:"VideoToVideoSDPipeline",local:"diffusers.VideoToVideoSDPipeline",headingTag:"h2"}}),_e=new ye({props:{name:"class diffusers.VideoToVideoSDPipeline",anchor:"diffusers.VideoToVideoSDPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet3DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"}],parametersDescription:[{anchor:"diffusers.VideoToVideoSDPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/v0.27.2/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"},{anchor:"diffusers.VideoToVideoSDPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.VideoToVideoSDPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
A <a href="https://huggingface.co/docs/transformers/v4.39.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.VideoToVideoSDPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/v0.27.2/en/api/models/unet3d-cond#diffusers.UNet3DConditionModel">UNet3DConditionModel</a>) &#x2014;
A <a href="/docs/diffusers/v0.27.2/en/api/models/unet3d-cond#diffusers.UNet3DConditionModel">UNet3DConditionModel</a> to denoise the encoded video latents.`,name:"unet"},{anchor:"diffusers.VideoToVideoSDPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/v0.27.2/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/v0.27.2/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/v0.27.2/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/v0.27.2/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth_img2img.py#L160"}}),ve=new ye({props:{name:"__call__",anchor:"diffusers.VideoToVideoSDPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"video",val:": Union = None"},{name:"strength",val:": float = 0.6"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 15.0"},{name:"negative_prompt",val:": Union = None"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'np'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.VideoToVideoSDPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.video",description:`<strong>video</strong> (<code>List[np.ndarray]</code> or <code>torch.FloatTensor</code>) &#x2014;
<code>video</code> frames or tensor representing a video batch to be used as the starting point for the process.
Can also accept video latents as <code>image</code>, if passing latents directly, it will not be encoded again.`,name:"video"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
Indicates extent to transform the reference <code>video</code>. Must be between 0 and 1. <code>video</code> is used as a
starting point, adding more noise to it the larger the <code>strength</code>. The number of denoising steps
depends on the amount of noise initially added. When <code>strength</code> is 1, added noise is maximum and the
denoising process runs for the full number of iterations specified in <code>num_inference_steps</code>. A value of
1 essentially ignores <code>video</code>.`,name:"strength"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality videos at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in video generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/v0.27.2/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for video
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>. Latents should be of shape
<code>(batch_size, num_channel, num_frames, height, width)</code>.`,name:"latents"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;np&quot;</code>) &#x2014;
The output format of the generated video. Choose between <code>torch.FloatTensor</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.27.2/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput">TextToVideoSDPipelineOutput</a> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth_img2img.py#L561",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/v0.27.2/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput"
>TextToVideoSDPipelineOutput</a> is
returned, otherwise a <code>tuple</code> is returned where the first element is a list with the generated frames.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/v0.27.2/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput"
>TextToVideoSDPipelineOutput</a> or <code>tuple</code></p>
`}}),G=new Mo({props:{anchor:"diffusers.VideoToVideoSDPipeline.__call__.example",$$slots:{default:[Uo]},$$scope:{ctx:j}}}),be=new ye({props:{name:"encode_prompt",anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth_img2img.py#L242"}}),Te=new B({props:{title:"TextToVideoSDPipelineOutput",local:"diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput",headingTag:"h2"}}),we=new ye({props:{name:"class diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput",anchor:"diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput",parameters:[{name:"frames",val:": Union"}],parametersDescription:[{anchor:"diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput.frames",description:`<strong>frames</strong> (<code>torch.Tensor</code>, <code>np.ndarray</code>, or List[List[PIL.Image.Image]]) &#x2014;
List of video outputs - It can be a nested list of length <code>batch_size,</code> with each sub-list containing denoised`,name:"frames"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/pipelines/text_to_video_synthesis/pipeline_output.py#L13"}}),{c(){r=a("meta"),Z=s(),m=a("p"),b=s(),f(x.$$.fragment),c=s(),f(J.$$.fragment),ze=s(),X=a("p"),X.innerHTML=Et,Re=s(),L=a("p"),L.textContent=Ht,Ne=s(),z=a("p"),z.innerHTML=Ft,Ee=s(),R=a("p"),R.innerHTML=Yt,He=s(),f(N.$$.fragment),Fe=s(),f(E.$$.fragment),Ye=s(),H=a("p"),H.textContent=Qt,Qe=s(),f(F.$$.fragment),Ae=s(),Y=a("p"),Y.textContent=At,qe=s(),Q=a("p"),Q.textContent=qt,Oe=s(),f(A.$$.fragment),Ke=s(),q=a("p"),q.innerHTML=Ot,et=s(),O=a("p"),O.textContent=Kt,tt=s(),f(K.$$.fragment),ot=s(),ee=a("p"),ee.textContent=eo,nt=s(),te=a("table"),te.innerHTML=to,st=s(),f(oe.$$.fragment),it=s(),ne=a("p"),ne.innerHTML=oo,at=s(),f(se.$$.fragment),lt=s(),ie=a("p"),ie.textContent=no,rt=s(),f(ae.$$.fragment),pt=s(),le=a("p"),le.textContent=so,dt=s(),re=a("table"),re.innerHTML=io,ct=s(),f(pe.$$.fragment),mt=s(),de=a("p"),de.innerHTML=ao,ft=s(),ce=a("p"),ce.innerHTML=lo,ut=s(),f(C.$$.fragment),ht=s(),f(me.$$.fragment),gt=s(),T=a("div"),f(fe.$$.fragment),Zt=s(),Ze=a("p"),Ze.textContent=ro,Jt=s(),Je=a("p"),Je.innerHTML=po,Vt=s(),Ve=a("p"),Ve.textContent=co,jt=s(),je=a("ul"),je.innerHTML=mo,kt=s(),k=a("div"),f(ue.$$.fragment),$t=s(),ke=a("p"),ke.textContent=fo,St=s(),f(I.$$.fragment),Dt=s(),P=a("div"),f(he.$$.fragment),Ut=s(),$e=a("p"),$e.textContent=uo,_t=s(),f(ge.$$.fragment),vt=s(),w=a("div"),f(_e.$$.fragment),Ct=s(),Se=a("p"),Se.textContent=ho,It=s(),De=a("p"),De.innerHTML=go,Pt=s(),Ue=a("p"),Ue.textContent=_o,Gt=s(),Ce=a("ul"),Ce.innerHTML=vo,Wt=s(),$=a("div"),f(ve.$$.fragment),Bt=s(),Ie=a("p"),Ie.textContent=bo,Xt=s(),f(G.$$.fragment),Lt=s(),W=a("div"),f(be.$$.fragment),zt=s(),Pe=a("p"),Pe.textContent=To,bt=s(),f(Te.$$.fragment),Tt=s(),V=a("div"),f(we.$$.fragment),Rt=s(),Ge=a("p"),Ge.textContent=wo,Nt=s(),We=a("p"),We.innerHTML=xo,wt=s(),Le=a("p"),this.h()},l(e){const t=ko("svelte-u9bgzb",document.head);r=l(t,"META",{name:!0,content:!0}),t.forEach(o),Z=i(e),m=l(e,"P",{}),D(m).forEach(o),b=i(e),u(x.$$.fragment,e),c=i(e),u(J.$$.fragment,e),ze=i(e),X=l(e,"P",{"data-svelte-h":!0}),d(X)!=="svelte-17trsey"&&(X.innerHTML=Et),Re=i(e),L=l(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-1cwsb16"&&(L.textContent=Ht),Ne=i(e),z=l(e,"P",{"data-svelte-h":!0}),d(z)!=="svelte-1ovx0um"&&(z.innerHTML=Ft),Ee=i(e),R=l(e,"P",{"data-svelte-h":!0}),d(R)!=="svelte-9292p9"&&(R.innerHTML=Yt),He=i(e),u(N.$$.fragment,e),Fe=i(e),u(E.$$.fragment,e),Ye=i(e),H=l(e,"P",{"data-svelte-h":!0}),d(H)!=="svelte-a4ktac"&&(H.textContent=Qt),Qe=i(e),u(F.$$.fragment,e),Ae=i(e),Y=l(e,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-1gwbshq"&&(Y.textContent=At),qe=i(e),Q=l(e,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-yoc5w4"&&(Q.textContent=qt),Oe=i(e),u(A.$$.fragment,e),Ke=i(e),q=l(e,"P",{"data-svelte-h":!0}),d(q)!=="svelte-m9rmsr"&&(q.innerHTML=Ot),et=i(e),O=l(e,"P",{"data-svelte-h":!0}),d(O)!=="svelte-1yxs7ur"&&(O.textContent=Kt),tt=i(e),u(K.$$.fragment,e),ot=i(e),ee=l(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-1pxzje"&&(ee.textContent=eo),nt=i(e),te=l(e,"TABLE",{"data-svelte-h":!0}),d(te)!=="svelte-5s26g4"&&(te.innerHTML=to),st=i(e),u(oe.$$.fragment,e),it=i(e),ne=l(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-13piesq"&&(ne.innerHTML=oo),at=i(e),u(se.$$.fragment,e),lt=i(e),ie=l(e,"P",{"data-svelte-h":!0}),d(ie)!=="svelte-4ywac8"&&(ie.textContent=no),rt=i(e),u(ae.$$.fragment,e),pt=i(e),le=l(e,"P",{"data-svelte-h":!0}),d(le)!=="svelte-1pxzje"&&(le.textContent=so),dt=i(e),re=l(e,"TABLE",{"data-svelte-h":!0}),d(re)!=="svelte-9iw63g"&&(re.innerHTML=io),ct=i(e),u(pe.$$.fragment,e),mt=i(e),de=l(e,"P",{"data-svelte-h":!0}),d(de)!=="svelte-op8wgu"&&(de.innerHTML=ao),ft=i(e),ce=l(e,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-1lb9rti"&&(ce.innerHTML=lo),ut=i(e),u(C.$$.fragment,e),ht=i(e),u(me.$$.fragment,e),gt=i(e),T=l(e,"DIV",{class:!0});var y=D(T);u(fe.$$.fragment,y),Zt=i(y),Ze=l(y,"P",{"data-svelte-h":!0}),d(Ze)!=="svelte-19ipoo4"&&(Ze.textContent=ro),Jt=i(y),Je=l(y,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-inq4do"&&(Je.innerHTML=po),Vt=i(y),Ve=l(y,"P",{"data-svelte-h":!0}),d(Ve)!=="svelte-14s6m4u"&&(Ve.textContent=co),jt=i(y),je=l(y,"UL",{"data-svelte-h":!0}),d(je)!=="svelte-1rxpzv2"&&(je.innerHTML=mo),kt=i(y),k=l(y,"DIV",{class:!0});var S=D(k);u(ue.$$.fragment,S),$t=i(S),ke=l(S,"P",{"data-svelte-h":!0}),d(ke)!=="svelte-50j04k"&&(ke.textContent=fo),St=i(S),u(I.$$.fragment,S),S.forEach(o),Dt=i(y),P=l(y,"DIV",{class:!0});var xe=D(P);u(he.$$.fragment,xe),Ut=i(xe),$e=l(xe,"P",{"data-svelte-h":!0}),d($e)!=="svelte-16q0ax1"&&($e.textContent=uo),xe.forEach(o),y.forEach(o),_t=i(e),u(ge.$$.fragment,e),vt=i(e),w=l(e,"DIV",{class:!0});var M=D(w);u(_e.$$.fragment,M),Ct=i(M),Se=l(M,"P",{"data-svelte-h":!0}),d(Se)!=="svelte-1oyadpc"&&(Se.textContent=ho),It=i(M),De=l(M,"P",{"data-svelte-h":!0}),d(De)!=="svelte-inq4do"&&(De.innerHTML=go),Pt=i(M),Ue=l(M,"P",{"data-svelte-h":!0}),d(Ue)!=="svelte-14s6m4u"&&(Ue.textContent=_o),Gt=i(M),Ce=l(M,"UL",{"data-svelte-h":!0}),d(Ce)!=="svelte-1rxpzv2"&&(Ce.innerHTML=vo),Wt=i(M),$=l(M,"DIV",{class:!0});var Be=D($);u(ve.$$.fragment,Be),Bt=i(Be),Ie=l(Be,"P",{"data-svelte-h":!0}),d(Ie)!=="svelte-50j04k"&&(Ie.textContent=bo),Xt=i(Be),u(G.$$.fragment,Be),Be.forEach(o),Lt=i(M),W=l(M,"DIV",{class:!0});var yt=D(W);u(be.$$.fragment,yt),zt=i(yt),Pe=l(yt,"P",{"data-svelte-h":!0}),d(Pe)!=="svelte-16q0ax1"&&(Pe.textContent=To),yt.forEach(o),M.forEach(o),bt=i(e),u(Te.$$.fragment,e),Tt=i(e),V=l(e,"DIV",{class:!0});var Xe=D(V);u(we.$$.fragment,Xe),Rt=i(Xe),Ge=l(Xe,"P",{"data-svelte-h":!0}),d(Ge)!=="svelte-1uuckb2"&&(Ge.textContent=wo),Nt=i(Xe),We=l(Xe,"P",{"data-svelte-h":!0}),d(We)!=="svelte-gk6g69"&&(We.innerHTML=xo),Xe.forEach(o),wt=i(e),Le=l(e,"P",{}),D(Le).forEach(o),this.h()},h(){U(r,"name","hf:doc:metadata"),U(r,"content",Io),U(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){p(document.head,r),n(e,Z,t),n(e,m,t),n(e,b,t),h(x,e,t),n(e,c,t),h(J,e,t),n(e,ze,t),n(e,X,t),n(e,Re,t),n(e,L,t),n(e,Ne,t),n(e,z,t),n(e,Ee,t),n(e,R,t),n(e,He,t),h(N,e,t),n(e,Fe,t),h(E,e,t),n(e,Ye,t),n(e,H,t),n(e,Qe,t),h(F,e,t),n(e,Ae,t),n(e,Y,t),n(e,qe,t),n(e,Q,t),n(e,Oe,t),h(A,e,t),n(e,Ke,t),n(e,q,t),n(e,et,t),n(e,O,t),n(e,tt,t),h(K,e,t),n(e,ot,t),n(e,ee,t),n(e,nt,t),n(e,te,t),n(e,st,t),h(oe,e,t),n(e,it,t),n(e,ne,t),n(e,at,t),h(se,e,t),n(e,lt,t),n(e,ie,t),n(e,rt,t),h(ae,e,t),n(e,pt,t),n(e,le,t),n(e,dt,t),n(e,re,t),n(e,ct,t),h(pe,e,t),n(e,mt,t),n(e,de,t),n(e,ft,t),n(e,ce,t),n(e,ut,t),h(C,e,t),n(e,ht,t),h(me,e,t),n(e,gt,t),n(e,T,t),h(fe,T,null),p(T,Zt),p(T,Ze),p(T,Jt),p(T,Je),p(T,Vt),p(T,Ve),p(T,jt),p(T,je),p(T,kt),p(T,k),h(ue,k,null),p(k,$t),p(k,ke),p(k,St),h(I,k,null),p(T,Dt),p(T,P),h(he,P,null),p(P,Ut),p(P,$e),n(e,_t,t),h(ge,e,t),n(e,vt,t),n(e,w,t),h(_e,w,null),p(w,Ct),p(w,Se),p(w,It),p(w,De),p(w,Pt),p(w,Ue),p(w,Gt),p(w,Ce),p(w,Wt),p(w,$),h(ve,$,null),p($,Bt),p($,Ie),p($,Xt),h(G,$,null),p(w,Lt),p(w,W),h(be,W,null),p(W,zt),p(W,Pe),n(e,bt,t),h(Te,e,t),n(e,Tt,t),n(e,V,t),h(we,V,null),p(V,Rt),p(V,Ge),p(V,Nt),p(V,We),n(e,wt,t),n(e,Le,t),xt=!0},p(e,[t]){const y={};t&2&&(y.$$scope={dirty:t,ctx:e}),x.$set(y);const S={};t&2&&(S.$$scope={dirty:t,ctx:e}),C.$set(S);const xe={};t&2&&(xe.$$scope={dirty:t,ctx:e}),I.$set(xe);const M={};t&2&&(M.$$scope={dirty:t,ctx:e}),G.$set(M)},i(e){xt||(g(x.$$.fragment,e),g(J.$$.fragment,e),g(N.$$.fragment,e),g(E.$$.fragment,e),g(F.$$.fragment,e),g(A.$$.fragment,e),g(K.$$.fragment,e),g(oe.$$.fragment,e),g(se.$$.fragment,e),g(ae.$$.fragment,e),g(pe.$$.fragment,e),g(C.$$.fragment,e),g(me.$$.fragment,e),g(fe.$$.fragment,e),g(ue.$$.fragment,e),g(I.$$.fragment,e),g(he.$$.fragment,e),g(ge.$$.fragment,e),g(_e.$$.fragment,e),g(ve.$$.fragment,e),g(G.$$.fragment,e),g(be.$$.fragment,e),g(Te.$$.fragment,e),g(we.$$.fragment,e),xt=!0)},o(e){_(x.$$.fragment,e),_(J.$$.fragment,e),_(N.$$.fragment,e),_(E.$$.fragment,e),_(F.$$.fragment,e),_(A.$$.fragment,e),_(K.$$.fragment,e),_(oe.$$.fragment,e),_(se.$$.fragment,e),_(ae.$$.fragment,e),_(pe.$$.fragment,e),_(C.$$.fragment,e),_(me.$$.fragment,e),_(fe.$$.fragment,e),_(ue.$$.fragment,e),_(I.$$.fragment,e),_(he.$$.fragment,e),_(ge.$$.fragment,e),_(_e.$$.fragment,e),_(ve.$$.fragment,e),_(G.$$.fragment,e),_(be.$$.fragment,e),_(Te.$$.fragment,e),_(we.$$.fragment,e),xt=!1},d(e){e&&(o(Z),o(m),o(b),o(c),o(ze),o(X),o(Re),o(L),o(Ne),o(z),o(Ee),o(R),o(He),o(Fe),o(Ye),o(H),o(Qe),o(Ae),o(Y),o(qe),o(Q),o(Oe),o(Ke),o(q),o(et),o(O),o(tt),o(ot),o(ee),o(nt),o(te),o(st),o(it),o(ne),o(at),o(lt),o(ie),o(rt),o(pt),o(le),o(dt),o(re),o(ct),o(mt),o(de),o(ft),o(ce),o(ut),o(ht),o(gt),o(T),o(_t),o(vt),o(w),o(bt),o(Tt),o(V),o(wt),o(Le)),o(r),v(x,e),v(J,e),v(N,e),v(E,e),v(F,e),v(A,e),v(K,e),v(oe,e),v(se,e),v(ae,e),v(pe,e),v(C,e),v(me,e),v(fe),v(ue),v(I),v(he),v(ge,e),v(_e),v(ve),v(G),v(be),v(Te,e),v(we)}}}const Io='{"title":"Text-to-video","local":"text-to-video","sections":[{"title":"Usage example","local":"usage-example","sections":[{"title":"text-to-video-ms-1.7b","local":"text-to-video-ms-17b","sections":[],"depth":3},{"title":"cerspense/zeroscope_v2_576w & cerspense/zeroscope_v2_XL","local":"cerspensezeroscopev2576w--cerspensezeroscopev2xl","sections":[],"depth":3}],"depth":2},{"title":"Tips","local":"tips","sections":[],"depth":2},{"title":"TextToVideoSDPipeline","local":"diffusers.TextToVideoSDPipeline","sections":[],"depth":2},{"title":"VideoToVideoSDPipeline","local":"diffusers.VideoToVideoSDPipeline","sections":[],"depth":2},{"title":"TextToVideoSDPipelineOutput","local":"diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput","sections":[],"depth":2}],"depth":1}';function Po(j){return Jo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class No extends Vo{constructor(r){super(),jo(this,r,Po,Co,Zo,{})}}export{No as component};
