import{s as ti,o as li,n as _s}from"../chunks/scheduler.182ea377.js";import{S as si,i as ai,g as n,s as a,r as m,A as ii,h as p,f as l,c as i,j as ei,u as c,x as o,k as Zt,y as ni,a as s,v as M,d,t as u,w as h}from"../chunks/index.abf12888.js";import{T as vs}from"../chunks/Tip.230e2334.js";import{C as w}from"../chunks/CodeBlock.57fe6e13.js";import{H as gt}from"../chunks/Heading.16916d63.js";function pi(I){let r,j=`It is useful to look at some inference samples while a model is training to measure the
training progress. In our <a href="https://github.com/huggingface/diffusers/tree/main/examples/" rel="nofollow">training scripts</a>, we support this utility with additional support for
logging to TensorBoard and Weights &amp; Biases.`;return{c(){r=n("p"),r.innerHTML=j},l(J){r=p(J,"P",{"data-svelte-h":!0}),o(r)!=="svelte-1yulmeg"&&(r.innerHTML=j)},m(J,y){s(J,r,y)},p:_s,d(J){J&&l(r)}}}function oi(I){let r,j=`By construction, there are some limitations in this score. The captions in the training dataset
were crawled from the web and extracted from <code>alt</code> and similar tags associated an image on the internet.
They are not necessarily representative of what a human being would use to describe an image. Hence we
had to “engineer” some prompts here.`;return{c(){r=n("p"),r.innerHTML=j},l(J){r=p(J,"P",{"data-svelte-h":!0}),o(r)!=="svelte-17jek1b"&&(r.innerHTML=j)},m(J,y){s(J,r,y)},p:_s,d(J){J&&l(r)}}}function ri(I){let r,j="Both CLIP score and CLIP direction similarity rely on the CLIP model, which can make the evaluations biased.";return{c(){r=n("p"),r.textContent=j},l(J){r=p(J,"P",{"data-svelte-h":!0}),o(r)!=="svelte-1jj27lk"&&(r.textContent=j)},m(J,y){s(J,r,y)},p:_s,d(J){J&&l(r)}}}function mi(I){let r,j="FID results tend to be fragile as they depend on a lot of factors:",J,y,g="<li>The specific Inception model used during computation.</li> <li>The implementation accuracy of the computation.</li> <li>The image format (not the same if we start from PNGs vs JPGs).</li>",Z,T,Ct=`Keeping that in mind, FID is often most useful when comparing similar runs, but it is
hard to reproduce paper results unless the authors carefully disclose the FID
measurement code.`,C,U,Bt="These points apply to other related metrics too, such as KID and IS.";return{c(){r=n("p"),r.textContent=j,J=a(),y=n("ul"),y.innerHTML=g,Z=a(),T=n("p"),T.textContent=Ct,C=a(),U=n("p"),U.textContent=Bt},l(f){r=p(f,"P",{"data-svelte-h":!0}),o(r)!=="svelte-nu8das"&&(r.textContent=j),J=i(f),y=p(f,"UL",{"data-svelte-h":!0}),o(y)!=="svelte-1u7ggn4"&&(y.innerHTML=g),Z=i(f),T=p(f,"P",{"data-svelte-h":!0}),o(T)!=="svelte-tbdsq8"&&(T.textContent=Ct),C=i(f),U=p(f,"P",{"data-svelte-h":!0}),o(U)!=="svelte-11vfq1v"&&(U.textContent=Bt)},m(f,b){s(f,r,b),s(f,J,b),s(f,y,b),s(f,Z,b),s(f,T,b),s(f,C,b),s(f,U,b)},p:_s,d(f){f&&(l(r),l(J),l(y),l(Z),l(T),l(C),l(U))}}}function ci(I){let r,j,J,y,g,Z,T,Ct='<img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"/>',C,U,Bt='Evaluation of generative models like <a href="https://huggingface.co/docs/diffusers/stable_diffusion" rel="nofollow">Stable Diffusion</a> is subjective in nature. But as practitioners and researchers, we often have to make careful choices amongst many different possibilities. So, when working with different generative models (like GANs, Diffusion, etc.), how do we choose one over the other?',f,b,Ws=`Qualitative evaluation of such models can be error-prone and might incorrectly influence a decision.
However, quantitative metrics don’t necessarily correspond to image quality. So, usually, a combination
of both qualitative and quantitative evaluations provides a stronger signal when choosing one model
over the other.`,_t,X,Gs="In this document, we provide a non-exhaustive overview of qualitative and quantitative methods to evaluate Diffusion models. For quantitative methods, we specifically focus on how to implement them alongside <code>diffusers</code>.",Wt,k,xs='The methods shown in this document can also be used to evaluate different <a href="https://huggingface.co/docs/diffusers/main/en/api/schedulers/overview" rel="nofollow">noise schedulers</a> keeping the underlying generation model fixed.',Gt,V,xt,R,Xs="We cover Diffusion models with the following pipelines:",Xt,H,ks='<li>Text-guided image generation (such as the <a href="https://huggingface.co/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img" rel="nofollow"><code>StableDiffusionPipeline</code></a>).</li> <li>Text-guided image generation, additionally conditioned on an input image (such as the <a href="https://huggingface.co/docs/diffusers/main/en/api/pipelines/stable_diffusion/img2img" rel="nofollow"><code>StableDiffusionImg2ImgPipeline</code></a> and <a href="https://huggingface.co/docs/diffusers/main/en/api/pipelines/pix2pix" rel="nofollow"><code>StableDiffusionInstructPix2PixPipeline</code></a>).</li> <li>Class-conditioned image generation models (such as the <a href="https://huggingface.co/docs/diffusers/main/en/api/pipelines/dit" rel="nofollow"><code>DiTPipeline</code></a>).</li>',kt,N,Vt,F,Vs=`Qualitative evaluation typically involves human assessment of generated images. Quality is measured across aspects such as compositionality, image-text alignment, and spatial relations. Common prompts provide a degree of uniformity for subjective metrics.
DrawBench and PartiPrompts are prompt datasets used for qualitative benchmarking. DrawBench and PartiPrompts were introduced by <a href="https://imagen.research.google/" rel="nofollow">Imagen</a> and <a href="https://parti.research.google/" rel="nofollow">Parti</a> respectively.`,Rt,$,Rs='From the <a href="https://parti.research.google/" rel="nofollow">official Parti website</a>:',Ht,Y,Hs="<p>PartiPrompts (P2) is a rich set of over 1600 prompts in English that we release as part of this work. P2 can be used to measure model capabilities across various categories and challenge aspects.</p>",Nt,E,Ns='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/evaluation_diffusion_models/parti-prompts.png" alt="parti-prompts"/>',Ft,A,Fs="PartiPrompts has the following columns:",$t,Q,$s="<li>Prompt</li> <li>Category of the prompt (such as “Abstract”, “World Knowledge”, etc.)</li> <li>Challenge reflecting the difficulty (such as “Basic”, “Complex”, “Writing &amp; Symbols”, etc.)</li>",Yt,S,Ys="These benchmarks allow for side-by-side human evaluation of different image generation models.",Et,z,Es="For this, the 🧨 Diffusers team has built <strong>Open Parti Prompts</strong>, which is a community-driven qualitative benchmark based on Parti Prompts to compare state-of-the-art open-source diffusion models:",At,L,As='<li><a href="https://huggingface.co/spaces/OpenGenAI/open-parti-prompts" rel="nofollow">Open Parti Prompts Game</a>: For 10 parti prompts, 4 generated images are shown and the user selects the image that suits the prompt best.</li> <li><a href="https://huggingface.co/spaces/OpenGenAI/parti-prompts-leaderboard" rel="nofollow">Open Parti Prompts Leaderboard</a>: The leaderboard comparing the currently best open-sourced diffusion models to each other.</li>',Qt,P,Qs="To manually compare images, let’s see how we can use <code>diffusers</code> on a couple of PartiPrompts.",St,q,Ss='Below we show some prompts sampled across different challenges: Basic, Complex, Linguistic Structures, Imagination, and Writing &amp; Symbols. Here we are using PartiPrompts as a <a href="https://huggingface.co/datasets/nateraw/parti-prompts" rel="nofollow">dataset</a>.',zt,D,Lt,K,zs='Now we can use these prompts to generate some images using Stable Diffusion (<a href="https://huggingface.co/CompVis/stable-diffusion-v1-4" rel="nofollow">v1-4 checkpoint</a>):',Pt,O,qt,ee,Ls='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/evaluation_diffusion_models/parti-prompts-14.png" alt="parti-prompts-14"/>',Dt,te,Ps='We can also set <code>num_images_per_prompt</code> accordingly to compare different images for the same prompt. Running the same pipeline but with a different checkpoint (<a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">v1-5</a>), yields:',Kt,le,qs='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/evaluation_diffusion_models/parti-prompts-15.png" alt="parti-prompts-15"/>',Ot,se,Ds=`Once several images are generated from all the prompts using multiple models (under evaluation), these results are presented to human evaluators for scoring. For
more details on the DrawBench and PartiPrompts benchmarks, refer to their respective papers.`,el,B,tl,ae,ll,ie,Ks="In this section, we will walk you through how to evaluate three different diffusion pipelines using:",sl,ne,Os="<li>CLIP score</li> <li>CLIP directional similarity</li> <li>FID</li>",al,pe,il,oe,ea='<a href="https://arxiv.org/abs/2104.08718" rel="nofollow">CLIP score</a> measures the compatibility of image-caption pairs. Higher CLIP scores imply higher compatibility 🔼. The CLIP score is a quantitative measurement of the qualitative concept “compatibility”. Image-caption pair compatibility can also be thought of as the semantic similarity between the image and the caption. CLIP score was found to have high correlation with human judgement.',nl,re,ta='Let’s first load a <a href="/docs/diffusers/v0.27.2/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a>:',pl,me,ol,ce,la="Generate some images with multiple prompts:",rl,Me,ml,de,sa="And then, we calculate the CLIP score.",cl,ue,Ml,he,aa="In the above example, we generated one image per prompt. If we generated multiple images per prompt, we would have to take the average score from the generated images per prompt.",dl,Je,ia=`Now, if we wanted to compare two checkpoints compatible with the <a href="/docs/diffusers/v0.27.2/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> we should pass a generator while calling the pipeline. First, we generate images with a
fixed seed with the <a href="https://huggingface.co/CompVis/stable-diffusion-v1-4" rel="nofollow">v1-4 Stable Diffusion checkpoint</a>:`,ul,we,hl,fe,na='Then we load the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">v1-5 checkpoint</a> to generate images:',Jl,ye,wl,Te,pa="And finally, we compare their CLIP scores:",fl,je,yl,Ue,oa='It seems like the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">v1-5</a> checkpoint performs better than its predecessor. Note, however, that the number of prompts we used to compute the CLIP scores is quite low. For a more practical evaluation, this number should be way higher, and the prompts should be diverse.',Tl,v,jl,be,Ul,Ie,ra='In this case, we condition the generation pipeline with an input image as well as a text prompt. Let’s take the <a href="/docs/diffusers/v0.27.2/en/api/pipelines/pix2pix#diffusers.StableDiffusionInstructPix2PixPipeline">StableDiffusionInstructPix2PixPipeline</a>, as an example. It takes an edit instruction as an input prompt and an input image to be edited.',bl,ge,ma="Here is one example:",Il,Ze,ca='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/evaluation_diffusion_models/edit-instruction.png" alt="edit-instruction"/>',gl,Ce,Ma='One strategy to evaluate such a model is to measure the consistency of the change between the two images (in <a href="https://huggingface.co/docs/transformers/model_doc/clip" rel="nofollow">CLIP</a> space) with the change between the two image captions (as shown in <a href="https://arxiv.org/abs/2108.00946" rel="nofollow">CLIP-Guided Domain Adaptation of Image Generators</a>). This is referred to as the ”<strong>CLIP directional similarity</strong>“.',Zl,Be,da="<li>Caption 1 corresponds to the input image (image 1) that is to be edited.</li> <li>Caption 2 corresponds to the edited image (image 2). It should reflect the edit instruction.</li>",Cl,ve,ua="Following is a pictorial overview:",Bl,_e,ha='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/evaluation_diffusion_models/edit-consistency.png" alt="edit-consistency"/>',vl,We,Ja="We have prepared a mini dataset to implement this metric. Let’s first load the dataset.",_l,Ge,Wl,xe,Gl,Xe,wa="Here we have:",xl,ke,fa="<li><code>input</code> is a caption corresponding to the <code>image</code>.</li> <li><code>edit</code> denotes the edit instruction.</li> <li><code>output</code> denotes the modified caption reflecting the <code>edit</code> instruction.</li>",Xl,Ve,ya="Let’s take a look at a sample.",kl,Re,Vl,He,Rl,Ne,Ta="And here is the image:",Hl,Fe,Nl,$e,ja='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/evaluation_diffusion_models/edit-dataset.png" alt="edit-dataset"/>',Fl,Ye,Ua="We will first edit the images of our dataset with the edit instruction and compute the directional similarity.",$l,Ee,ba='Let’s first load the <a href="/docs/diffusers/v0.27.2/en/api/pipelines/pix2pix#diffusers.StableDiffusionInstructPix2PixPipeline">StableDiffusionInstructPix2PixPipeline</a>:',Yl,Ae,El,Qe,Ia="Now, we perform the edits:",Al,Se,Ql,ze,ga="To measure the directional similarity, we first load CLIP’s image and text encoders:",Sl,Le,zl,Pe,Za='Notice that we are using a particular CLIP checkpoint, i.e., <code>openai/clip-vit-large-patch14</code>. This is because the Stable Diffusion pre-training was performed with this CLIP variant. For more details, refer to the <a href="https://huggingface.co/docs/transformers/model_doc/clip" rel="nofollow">documentation</a>.',Ll,qe,Ca="Next, we prepare a PyTorch <code>nn.Module</code> to compute directional similarity:",Pl,De,ql,Ke,Ba="Let’s put <code>DirectionalSimilarity</code> to use now.",Dl,Oe,Kl,et,va="Like the CLIP Score, the higher the CLIP directional similarity, the better it is.",Ol,tt,_a="It should be noted that the <code>StableDiffusionInstructPix2PixPipeline</code> exposes two arguments, namely, <code>image_guidance_scale</code> and <code>guidance_scale</code> that let you control the quality of the final edited image. We encourage you to experiment with these two arguments and see the impact of that on the directional similarity.",es,lt,Wa="We can extend the idea of this metric to measure how similar the original image and edited version are. To do that, we can just do <code>F.cosine_similarity(img_feat_two, img_feat_one)</code>. For these kinds of edits, we would still want the primary semantics of the images to be preserved as much as possible, i.e., a high similarity score.",ts,st,Ga='We can use these metrics for similar pipelines such as the <a href="https://huggingface.co/docs/diffusers/main/en/api/pipelines/pix2pix_zero#diffusers.StableDiffusionPix2PixZeroPipeline" rel="nofollow"><code>StableDiffusionPix2PixZeroPipeline</code></a>.',ls,_,ss,at,xa='<strong><em>Extending metrics like IS, FID (discussed later), or KID can be difficult</em></strong> when the model under evaluation was pre-trained on a large image-captioning dataset (such as the <a href="https://laion.ai/blog/laion-5b/" rel="nofollow">LAION-5B dataset</a>). This is because underlying these metrics is an InceptionNet (pre-trained on the ImageNet-1k dataset) used for extracting intermediate image features. The pre-training dataset of Stable Diffusion may have limited overlap with the pre-training dataset of InceptionNet, so it is not a good candidate here for feature extraction.',as,it,Xa='<strong><em>Using the above metrics helps evaluate models that are class-conditioned. For example, <a href="https://huggingface.co/docs/diffusers/main/en/api/pipelines/dit" rel="nofollow">DiT</a>. It was pre-trained being conditioned on the ImageNet-1k classes.</em></strong>',is,nt,ns,pt,ka='Class-conditioned generative models are usually pre-trained on a class-labeled dataset such as <a href="https://huggingface.co/datasets/imagenet-1k" rel="nofollow">ImageNet-1k</a>. Popular metrics for evaluating these models include Fréchet Inception Distance (FID), Kernel Inception Distance (KID), and Inception Score (IS). In this document, we focus on FID (<a href="https://arxiv.org/abs/1706.08500" rel="nofollow">Heusel et al.</a>). We show how to compute it with the <a href="https://huggingface.co/docs/diffusers/api/pipelines/dit" rel="nofollow"><code>DiTPipeline</code></a>, which uses the <a href="https://arxiv.org/abs/2212.09748" rel="nofollow">DiT model</a> under the hood.',ps,ot,Va='FID aims to measure how similar are two datasets of images. As per <a href="https://mmgeneration.readthedocs.io/en/latest/quick_run.html#fid" rel="nofollow">this resource</a>:',os,rt,Ra="<p>Fréchet Inception Distance is a measure of similarity between two datasets of images. It was shown to correlate well with the human judgment of visual quality and is most often used to evaluate the quality of samples of Generative Adversarial Networks. FID is calculated by computing the Fréchet distance between two Gaussians fitted to feature representations of the Inception network.</p>",rs,mt,Ha="These two datasets are essentially the dataset of real images and the dataset of fake images (generated images in our case). FID is usually calculated with two large datasets. However, for this document, we will work with two mini datasets.",ms,ct,Na="Let’s first download a few images from the ImageNet-1k training set:",cs,Mt,Ms,dt,ds,ut,Fa="These are 10 images from the following ImageNet-1k classes: “cassette_player”, “chain_saw” (x2), “church”, “gas_pump” (x3), “parachute” (x2), and “tench”.",us,W,$a='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/evaluation_diffusion_models/real-images.png" alt="real-images"/><br/> <em>Real images.</em>',hs,ht,Ya="Now that the images are loaded, let’s apply some lightweight pre-processing on them to use them for FID calculation.",Js,Jt,ws,wt,Ea='We now load the <a href="https://huggingface.co/docs/diffusers/api/pipelines/dit" rel="nofollow"><code>DiTPipeline</code></a> to generate images conditioned on the above-mentioned classes.',fs,ft,ys,yt,Aa='Now, we can compute the FID using <a href="https://torchmetrics.readthedocs.io/" rel="nofollow"><code>torchmetrics</code></a>.',Ts,Tt,js,jt,Qa="The lower the FID, the better it is. Several things can influence FID here:",Us,Ut,Sa="<li>Number of images (both real and fake)</li> <li>Randomness induced in the diffusion process</li> <li>Number of inference steps in the diffusion process</li> <li>The scheduler being used in the diffusion process</li>",bs,bt,za="For the last two points, it is, therefore, a good practice to run the evaluation across different seeds and inference steps, and then report an average result.",Is,G,gs,It,La="As a final step, let’s visually inspect the <code>fake_images</code>.",Zs,x,Pa='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/evaluation_diffusion_models/fake-images.png" alt="fake-images"/><br/> <em>Fake images.</em>',Cs,vt,Bs;return g=new gt({props:{title:"Evaluating Diffusion Models",local:"evaluating-diffusion-models",headingTag:"h1"}}),V=new gt({props:{title:"Scenarios",local:"scenarios",headingTag:"h2"}}),N=new gt({props:{title:"Qualitative Evaluation",local:"qualitative-evaluation",headingTag:"h2"}}),D=new w({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBJTIzJTIwcHJvbXB0cyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJuYXRlcmF3JTJGcGFydGktcHJvbXB0cyUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBJTIzJTIwcHJvbXB0cyUyMCUzRCUyMHByb21wdHMuc2h1ZmZsZSgpJTBBJTIzJTIwc2FtcGxlX3Byb21wdHMlMjAlM0QlMjAlNUJwcm9tcHRzJTVCaSU1RCU1QiUyMlByb21wdCUyMiU1RCUyMGZvciUyMGklMjBpbiUyMHJhbmdlKDUpJTVEJTBBJTBBJTIzJTIwRml4aW5nJTIwdGhlc2UlMjBzYW1wbGUlMjBwcm9tcHRzJTIwaW4lMjB0aGUlMjBpbnRlcmVzdCUyMG9mJTIwcmVwcm9kdWNpYmlsaXR5LiUwQXNhbXBsZV9wcm9tcHRzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyYSUyMGNvcmdpJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyYSUyMGhvdCUyMGFpciUyMGJhbGxvb24lMjB3aXRoJTIwYSUyMHlpbi15YW5nJTIwc3ltYm9sJTJDJTIwd2l0aCUyMHRoZSUyMG1vb24lMjB2aXNpYmxlJTIwaW4lMjB0aGUlMjBkYXl0aW1lJTIwc2t5JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyYSUyMGNhciUyMHdpdGglMjBubyUyMHdpbmRvd3MlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhJTIwY3ViZSUyMG1hZGUlMjBvZiUyMHBvcmN1cGluZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCdUaGUlMjBzYXlpbmclMjAlMjJCRSUyMEVYQ0VMTEVOVCUyMFRPJTIwRUFDSCUyME9USEVSJTIyJTIwd3JpdHRlbiUyMG9uJTIwYSUyMHJlZCUyMGJyaWNrJTIwd2FsbCUyMHdpdGglMjBhJTIwZ3JhZmZpdGklMjBpbWFnZSUyMG9mJTIwYSUyMGdyZWVuJTIwYWxpZW4lMjB3ZWFyaW5nJTIwYSUyMHR1eGVkby4lMjBBJTIweWVsbG93JTIwZmlyZSUyMGh5ZHJhbnQlMjBpcyUyMG9uJTIwYSUyMHNpZGV3YWxrJTIwaW4lMjB0aGUlMjBmb3JlZ3JvdW5kLiclMkMlMEElNUQ=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># prompts = load_dataset(&quot;nateraw/parti-prompts&quot;, split=&quot;train&quot;)</span>
<span class="hljs-comment"># prompts = prompts.shuffle()</span>
<span class="hljs-comment"># sample_prompts = [prompts[i][&quot;Prompt&quot;] for i in range(5)]</span>

<span class="hljs-comment"># Fixing these sample prompts in the interest of reproducibility.</span>
sample_prompts = [
    <span class="hljs-string">&quot;a corgi&quot;</span>,
    <span class="hljs-string">&quot;a hot air balloon with a yin-yang symbol, with the moon visible in the daytime sky&quot;</span>,
    <span class="hljs-string">&quot;a car with no windows&quot;</span>,
    <span class="hljs-string">&quot;a cube made of porcupine&quot;</span>,
    <span class="hljs-string">&#x27;The saying &quot;BE EXCELLENT TO EACH OTHER&quot; written on a red brick wall with a graffiti image of a green alien wearing a tuxedo. A yellow fire hydrant is on a sidewalk in the foreground.&#x27;</span>,
]`,wrap:!1}}),O=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFzZWVkJTIwJTNEJTIwMCUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLm1hbnVhbF9zZWVkKHNlZWQpJTBBJTBBaW1hZ2VzJTIwJTNEJTIwc2RfcGlwZWxpbmUoc2FtcGxlX3Byb21wdHMlMkMlMjBudW1faW1hZ2VzX3Blcl9wcm9tcHQlM0QxJTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yKS5pbWFnZXM=",highlighted:`<span class="hljs-keyword">import</span> torch

seed = <span class="hljs-number">0</span>
generator = torch.manual_seed(seed)

images = sd_pipeline(sample_prompts, num_images_per_prompt=<span class="hljs-number">1</span>, generator=generator).images`,wrap:!1}}),B=new vs({props:{$$slots:{default:[pi]},$$scope:{ctx:I}}}),ae=new gt({props:{title:"Quantitative Evaluation",local:"quantitative-evaluation",headingTag:"h2"}}),pe=new gt({props:{title:"Text-guided image generation",local:"text-guided-image-generation",headingTag:"h3"}}),me=new w({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9ja3B0JTIwJTNEJTIwJTIyQ29tcFZpcyUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNCUyMiUwQXNkX3BpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2NrcHQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnRvKCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_ckpt = <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>
sd_pipeline = StableDiffusionPipeline.from_pretrained(model_ckpt, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),Me=new w({props:{code:"cHJvbXB0cyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMmElMjBwaG90byUyMG9mJTIwYW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyMG1hcnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJBJTIwaGlnaCUyMHRlY2glMjBzb2xhcnB1bmslMjB1dG9waWElMjBpbiUyMHRoZSUyMEFtYXpvbiUyMHJhaW5mb3Jlc3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJBJTIwcGlrYWNodSUyMGZpbmUlMjBkaW5pbmclMjB3aXRoJTIwYSUyMHZpZXclMjB0byUyMHRoZSUyMEVpZmZlbCUyMFRvd2VyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyQSUyMG1lY2hhJTIwcm9ib3QlMjBpbiUyMGElMjBmYXZlbGElMjBpbiUyMGV4cHJlc3Npb25pc3QlMjBzdHlsZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmFuJTIwaW5zZWN0JTIwcm9ib3QlMjBwcmVwYXJpbmclMjBhJTIwZGVsaWNpb3VzJTIwbWVhbCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMkElMjBzbWFsbCUyMGNhYmluJTIwb24lMjB0b3AlMjBvZiUyMGElMjBzbm93eSUyMG1vdW50YWluJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwRGlzbmV5JTJDJTIwYXJ0c3RhdGlvbiUyMiUyQyUwQSU1RCUwQSUwQWltYWdlcyUyMCUzRCUyMHNkX3BpcGVsaW5lKHByb21wdHMlMkMlMjBudW1faW1hZ2VzX3Blcl9wcm9tcHQlM0QxJTJDJTIwb3V0cHV0X3R5cGUlM0QlMjJucCUyMikuaW1hZ2VzJTBBJTBBcHJpbnQoaW1hZ2VzLnNoYXBlKSUwQSUyMyUyMCg2JTJDJTIwNTEyJTJDJTIwNTEyJTJDJTIwMyk=",highlighted:`prompts = [
    <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>,
    <span class="hljs-string">&quot;A high tech solarpunk utopia in the Amazon rainforest&quot;</span>,
    <span class="hljs-string">&quot;A pikachu fine dining with a view to the Eiffel Tower&quot;</span>,
    <span class="hljs-string">&quot;A mecha robot in a favela in expressionist style&quot;</span>,
    <span class="hljs-string">&quot;an insect robot preparing a delicious meal&quot;</span>,
    <span class="hljs-string">&quot;A small cabin on top of a snowy mountain in the style of Disney, artstation&quot;</span>,
]

images = sd_pipeline(prompts, num_images_per_prompt=<span class="hljs-number">1</span>, output_type=<span class="hljs-string">&quot;np&quot;</span>).images

<span class="hljs-built_in">print</span>(images.shape)
<span class="hljs-comment"># (6, 512, 512, 3)</span>`,wrap:!1}}),ue=new w({props:{code:"ZnJvbSUyMHRvcmNobWV0cmljcy5mdW5jdGlvbmFsLm11bHRpbW9kYWwlMjBpbXBvcnQlMjBjbGlwX3Njb3JlJTBBZnJvbSUyMGZ1bmN0b29scyUyMGltcG9ydCUyMHBhcnRpYWwlMEElMEFjbGlwX3Njb3JlX2ZuJTIwJTNEJTIwcGFydGlhbChjbGlwX3Njb3JlJTJDJTIwbW9kZWxfbmFtZV9vcl9wYXRoJTNEJTIyb3BlbmFpJTJGY2xpcC12aXQtYmFzZS1wYXRjaDE2JTIyKSUwQSUwQWRlZiUyMGNhbGN1bGF0ZV9jbGlwX3Njb3JlKGltYWdlcyUyQyUyMHByb21wdHMpJTNBJTBBJTIwJTIwJTIwJTIwaW1hZ2VzX2ludCUyMCUzRCUyMChpbWFnZXMlMjAqJTIwMjU1KS5hc3R5cGUoJTIydWludDglMjIpJTBBJTIwJTIwJTIwJTIwY2xpcF9zY29yZSUyMCUzRCUyMGNsaXBfc2NvcmVfZm4odG9yY2guZnJvbV9udW1weShpbWFnZXNfaW50KS5wZXJtdXRlKDAlMkMlMjAzJTJDJTIwMSUyQyUyMDIpJTJDJTIwcHJvbXB0cykuZGV0YWNoKCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjByb3VuZChmbG9hdChjbGlwX3Njb3JlKSUyQyUyMDQpJTBBJTBBc2RfY2xpcF9zY29yZSUyMCUzRCUyMGNhbGN1bGF0ZV9jbGlwX3Njb3JlKGltYWdlcyUyQyUyMHByb21wdHMpJTBBcHJpbnQoZiUyMkNMSVAlMjBzY29yZSUzQSUyMCU3QnNkX2NsaXBfc2NvcmUlN0QlMjIpJTBBJTIzJTIwQ0xJUCUyMHNjb3JlJTNBJTIwMzUuNzAzOA==",highlighted:`<span class="hljs-keyword">from</span> torchmetrics.functional.multimodal <span class="hljs-keyword">import</span> clip_score
<span class="hljs-keyword">from</span> functools <span class="hljs-keyword">import</span> partial

clip_score_fn = partial(clip_score, model_name_or_path=<span class="hljs-string">&quot;openai/clip-vit-base-patch16&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculate_clip_score</span>(<span class="hljs-params">images, prompts</span>):
    images_int = (images * <span class="hljs-number">255</span>).astype(<span class="hljs-string">&quot;uint8&quot;</span>)
    clip_score = clip_score_fn(torch.from_numpy(images_int).permute(<span class="hljs-number">0</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>), prompts).detach()
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">round</span>(<span class="hljs-built_in">float</span>(clip_score), <span class="hljs-number">4</span>)

sd_clip_score = calculate_clip_score(images, prompts)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;CLIP score: <span class="hljs-subst">{sd_clip_score}</span>&quot;</span>)
<span class="hljs-comment"># CLIP score: 35.7038</span>`,wrap:!1}}),we=new w({props:{code:"c2VlZCUyMCUzRCUyMDAlMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5tYW51YWxfc2VlZChzZWVkKSUwQSUwQWltYWdlcyUyMCUzRCUyMHNkX3BpcGVsaW5lKHByb21wdHMlMkMlMjBudW1faW1hZ2VzX3Blcl9wcm9tcHQlM0QxJTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTIwb3V0cHV0X3R5cGUlM0QlMjJucCUyMikuaW1hZ2Vz",highlighted:`seed = <span class="hljs-number">0</span>
generator = torch.manual_seed(seed)

images = sd_pipeline(prompts, num_images_per_prompt=<span class="hljs-number">1</span>, generator=generator, output_type=<span class="hljs-string">&quot;np&quot;</span>).images`,wrap:!1}}),ye=new w({props:{code:"bW9kZWxfY2twdF8xXzUlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXNkX3BpcGVsaW5lXzFfNSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9ja3B0XzFfNSUyQyUyMHRvcmNoX2R0eXBlJTNEd2VpZ2h0X2R0eXBlKS50byhkZXZpY2UpJTBBJTBBaW1hZ2VzXzFfNSUyMCUzRCUyMHNkX3BpcGVsaW5lXzFfNShwcm9tcHRzJTJDJTIwbnVtX2ltYWdlc19wZXJfcHJvbXB0JTNEMSUyQyUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUyMG91dHB1dF90eXBlJTNEJTIybnAlMjIpLmltYWdlcw==",highlighted:`model_ckpt_1_5 = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
sd_pipeline_1_5 = StableDiffusionPipeline.from_pretrained(model_ckpt_1_5, torch_dtype=weight_dtype).to(device)

images_1_5 = sd_pipeline_1_5(prompts, num_images_per_prompt=<span class="hljs-number">1</span>, generator=generator, output_type=<span class="hljs-string">&quot;np&quot;</span>).images`,wrap:!1}}),je=new w({props:{code:"c2RfY2xpcF9zY29yZV8xXzQlMjAlM0QlMjBjYWxjdWxhdGVfY2xpcF9zY29yZShpbWFnZXMlMkMlMjBwcm9tcHRzKSUwQXByaW50KGYlMjJDTElQJTIwU2NvcmUlMjB3aXRoJTIwdi0xLTQlM0ElMjAlN0JzZF9jbGlwX3Njb3JlXzFfNCU3RCUyMiklMEElMjMlMjBDTElQJTIwU2NvcmUlMjB3aXRoJTIwdi0xLTQlM0ElMjAzNC45MTAyJTBBJTBBc2RfY2xpcF9zY29yZV8xXzUlMjAlM0QlMjBjYWxjdWxhdGVfY2xpcF9zY29yZShpbWFnZXNfMV81JTJDJTIwcHJvbXB0cyklMEFwcmludChmJTIyQ0xJUCUyMFNjb3JlJTIwd2l0aCUyMHYtMS01JTNBJTIwJTdCc2RfY2xpcF9zY29yZV8xXzUlN0QlMjIpJTBBJTIzJTIwQ0xJUCUyMFNjb3JlJTIwd2l0aCUyMHYtMS01JTNBJTIwMzYuMjEzNw==",highlighted:`sd_clip_score_1_4 = calculate_clip_score(images, prompts)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;CLIP Score with v-1-4: <span class="hljs-subst">{sd_clip_score_1_4}</span>&quot;</span>)
<span class="hljs-comment"># CLIP Score with v-1-4: 34.9102</span>

sd_clip_score_1_5 = calculate_clip_score(images_1_5, prompts)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;CLIP Score with v-1-5: <span class="hljs-subst">{sd_clip_score_1_5}</span>&quot;</span>)
<span class="hljs-comment"># CLIP Score with v-1-5: 36.2137</span>`,wrap:!1}}),v=new vs({props:{warning:!0,$$slots:{default:[oi]},$$scope:{ctx:I}}}),be=new gt({props:{title:"Image-conditioned text-to-image generation",local:"image-conditioned-text-to-image-generation",headingTag:"h3"}}),Ge=new w({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJzYXlha3BhdWwlMkZpbnN0cnVjdHBpeDJwaXgtZGVtbyUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBZGF0YXNldC5mZWF0dXJlcw==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(<span class="hljs-string">&quot;sayakpaul/instructpix2pix-demo&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
dataset.features`,wrap:!1}}),xe=new w({props:{code:"JTdCJ2lucHV0JyUzQSUyMFZhbHVlKGR0eXBlJTNEJ3N0cmluZyclMkMlMjBpZCUzRE5vbmUpJTJDJTBBJTIwJ2VkaXQnJTNBJTIwVmFsdWUoZHR5cGUlM0Qnc3RyaW5nJyUyQyUyMGlkJTNETm9uZSklMkMlMEElMjAnb3V0cHV0JyUzQSUyMFZhbHVlKGR0eXBlJTNEJ3N0cmluZyclMkMlMjBpZCUzRE5vbmUpJTJDJTBBJTIwJ2ltYWdlJyUzQSUyMEltYWdlKGRlY29kZSUzRFRydWUlMkMlMjBpZCUzRE5vbmUpJTdE",highlighted:`{<span class="hljs-string">&#x27;input&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=None),
 <span class="hljs-string">&#x27;edit&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=None),
 <span class="hljs-string">&#x27;output&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=None),
 <span class="hljs-string">&#x27;image&#x27;</span>: Image(decode=True, <span class="hljs-built_in">id</span>=None)}`,wrap:!1}}),Re=new w({props:{code:"aWR4JTIwJTNEJTIwMCUwQXByaW50KGYlMjJPcmlnaW5hbCUyMGNhcHRpb24lM0ElMjAlN0JkYXRhc2V0JTVCaWR4JTVEJTVCJ2lucHV0JyU1RCU3RCUyMiklMEFwcmludChmJTIyRWRpdCUyMGluc3RydWN0aW9uJTNBJTIwJTdCZGF0YXNldCU1QmlkeCU1RCU1QidlZGl0JyU1RCU3RCUyMiklMEFwcmludChmJTIyTW9kaWZpZWQlMjBjYXB0aW9uJTNBJTIwJTdCZGF0YXNldCU1QmlkeCU1RCU1QidvdXRwdXQnJTVEJTdEJTIyKQ==",highlighted:`idx = <span class="hljs-number">0</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Original caption: <span class="hljs-subst">{dataset[idx][<span class="hljs-string">&#x27;input&#x27;</span>]}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Edit instruction: <span class="hljs-subst">{dataset[idx][<span class="hljs-string">&#x27;edit&#x27;</span>]}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Modified caption: <span class="hljs-subst">{dataset[idx][<span class="hljs-string">&#x27;output&#x27;</span>]}</span>&quot;</span>)`,wrap:!1}}),He=new w({props:{code:"T3JpZ2luYWwlMjBjYXB0aW9uJTNBJTIwMi4lMjBGQVJPRSUyMElTTEFORFMlM0ElMjBBbiUyMGFyY2hpcGVsYWdvJTIwb2YlMjAxOCUyMG1vdW50YWlub3VzJTIwaXNsZXMlMjBpbiUyMHRoZSUyME5vcnRoJTIwQXRsYW50aWMlMjBPY2VhbiUyMGJldHdlZW4lMjBOb3J3YXklMjBhbmQlMjBJY2VsYW5kJTJDJTIwdGhlJTIwRmFyb2UlMjBJc2xhbmRzJTIwaGFzJTIwJ2V2ZXJ5dGhpbmclMjB5b3UlMjBjb3VsZCUyMGhvcGUlMjBmb3InJTJDJTIwYWNjb3JkaW5nJTIwdG8lMjBCaWclMjA3JTIwVHJhdmVsLiUyMEl0JTIwYm9hc3RzJTIwJ2NyeXN0YWwlMjBjbGVhciUyMHdhdGVyZmFsbHMlMkMlMjByb2NreSUyMGNsaWZmcyUyMHRoYXQlMjBzZWVtJTIwdG8lMjBqdXQlMjBvdXQlMjBvZiUyMG5vd2hlcmUlMjBhbmQlMjB2ZWx2ZXR5JTIwZ3JlZW4lMjBoaWxscyclMEFFZGl0JTIwaW5zdHJ1Y3Rpb24lM0ElMjBtYWtlJTIwdGhlJTIwaXNsZXMlMjBhbGwlMjB3aGl0ZSUyMG1hcmJsZSUwQU1vZGlmaWVkJTIwY2FwdGlvbiUzQSUyMDIuJTIwV0hJVEUlMjBNQVJCTEUlMjBJU0xBTkRTJTNBJTIwQW4lMjBhcmNoaXBlbGFnbyUyMG9mJTIwMTglMjBtb3VudGFpbm91cyUyMHdoaXRlJTIwbWFyYmxlJTIwaXNsZXMlMjBpbiUyMHRoZSUyME5vcnRoJTIwQXRsYW50aWMlMjBPY2VhbiUyMGJldHdlZW4lMjBOb3J3YXklMjBhbmQlMjBJY2VsYW5kJTJDJTIwdGhlJTIwV2hpdGUlMjBNYXJibGUlMjBJc2xhbmRzJTIwaGFzJTIwJ2V2ZXJ5dGhpbmclMjB5b3UlMjBjb3VsZCUyMGhvcGUlMjBmb3InJTJDJTIwYWNjb3JkaW5nJTIwdG8lMjBCaWclMjA3JTIwVHJhdmVsLiUyMEl0JTIwYm9hc3RzJTIwJ2NyeXN0YWwlMjBjbGVhciUyMHdhdGVyZmFsbHMlMkMlMjByb2NreSUyMGNsaWZmcyUyMHRoYXQlMjBzZWVtJTIwdG8lMjBqdXQlMjBvdXQlMjBvZiUyMG5vd2hlcmUlMjBhbmQlMjB2ZWx2ZXR5JTIwZ3JlZW4lMjBoaWxscyc=",highlighted:`Original caption: 2. FAROE ISLANDS: An archipelago of 18 mountainous isles <span class="hljs-keyword">in</span> the North Atlantic Ocean between Norway and Iceland, the Faroe Islands has <span class="hljs-string">&#x27;everything you could hope for&#x27;</span>, according to Big 7 Travel. It boasts <span class="hljs-string">&#x27;crystal clear waterfalls, rocky cliffs that seem to jut out of nowhere and velvety green hills&#x27;</span>
Edit instruction: make the isles all white marble
Modified caption: 2. WHITE MARBLE ISLANDS: An archipelago of 18 mountainous white marble isles <span class="hljs-keyword">in</span> the North Atlantic Ocean between Norway and Iceland, the White Marble Islands has <span class="hljs-string">&#x27;everything you could hope for&#x27;</span>, according to Big 7 Travel. It boasts <span class="hljs-string">&#x27;crystal clear waterfalls, rocky cliffs that seem to jut out of nowhere and velvety green hills&#x27;</span>`,wrap:!1}}),Fe=new w({props:{code:"ZGF0YXNldCU1QmlkeCU1RCU1QiUyMmltYWdlJTIyJTVE",highlighted:'dataset[idx][<span class="hljs-string">&quot;image&quot;</span>]',wrap:!1}}),Ae=new w({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkluc3RydWN0UGl4MlBpeFBpcGVsaW5lJTBBJTBBaW5zdHJ1Y3RfcGl4MnBpeF9waXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbkluc3RydWN0UGl4MlBpeFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJ0aW1icm9va3MlMkZpbnN0cnVjdC1waXgycGl4JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKS50byhkZXZpY2Up",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionInstructPix2PixPipeline

instruct_pix2pix_pipeline = StableDiffusionInstructPix2PixPipeline.from_pretrained(
    <span class="hljs-string">&quot;timbrooks/instruct-pix2pix&quot;</span>, torch_dtype=torch.float16
).to(device)`,wrap:!1}}),Se=new w({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBJTBBZGVmJTIwZWRpdF9pbWFnZShpbnB1dF9pbWFnZSUyQyUyMGluc3RydWN0aW9uKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwaW5zdHJ1Y3RfcGl4MnBpeF9waXBlbGluZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnN0cnVjdGlvbiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGltYWdlJTNEaW5wdXRfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRfdHlwZSUzRCUyMm5wJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBJTIwJTIwJTIwJTIwKS5pbWFnZXMlNUIwJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwaW1hZ2UlMEElMEFpbnB1dF9pbWFnZXMlMjAlM0QlMjAlNUIlNUQlMEFvcmlnaW5hbF9jYXB0aW9ucyUyMCUzRCUyMCU1QiU1RCUwQW1vZGlmaWVkX2NhcHRpb25zJTIwJTNEJTIwJTVCJTVEJTBBZWRpdGVkX2ltYWdlcyUyMCUzRCUyMCU1QiU1RCUwQSUwQWZvciUyMGlkeCUyMGluJTIwcmFuZ2UobGVuKGRhdGFzZXQpKSUzQSUwQSUyMCUyMCUyMCUyMGlucHV0X2ltYWdlJTIwJTNEJTIwZGF0YXNldCU1QmlkeCU1RCU1QiUyMmltYWdlJTIyJTVEJTBBJTIwJTIwJTIwJTIwZWRpdF9pbnN0cnVjdGlvbiUyMCUzRCUyMGRhdGFzZXQlNUJpZHglNUQlNUIlMjJlZGl0JTIyJTVEJTBBJTIwJTIwJTIwJTIwZWRpdGVkX2ltYWdlJTIwJTNEJTIwZWRpdF9pbWFnZShpbnB1dF9pbWFnZSUyQyUyMGVkaXRfaW5zdHJ1Y3Rpb24pJTBBJTBBJTIwJTIwJTIwJTIwaW5wdXRfaW1hZ2VzLmFwcGVuZChucC5hcnJheShpbnB1dF9pbWFnZSkpJTBBJTIwJTIwJTIwJTIwb3JpZ2luYWxfY2FwdGlvbnMuYXBwZW5kKGRhdGFzZXQlNUJpZHglNUQlNUIlMjJpbnB1dCUyMiU1RCklMEElMjAlMjAlMjAlMjBtb2RpZmllZF9jYXB0aW9ucy5hcHBlbmQoZGF0YXNldCU1QmlkeCU1RCU1QiUyMm91dHB1dCUyMiU1RCklMEElMjAlMjAlMjAlMjBlZGl0ZWRfaW1hZ2VzLmFwcGVuZChlZGl0ZWRfaW1hZ2Up",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np


<span class="hljs-keyword">def</span> <span class="hljs-title function_">edit_image</span>(<span class="hljs-params">input_image, instruction</span>):
    image = instruct_pix2pix_pipeline(
        instruction,
        image=input_image,
        output_type=<span class="hljs-string">&quot;np&quot;</span>,
        generator=generator,
    ).images[<span class="hljs-number">0</span>]
    <span class="hljs-keyword">return</span> image

input_images = []
original_captions = []
modified_captions = []
edited_images = []

<span class="hljs-keyword">for</span> idx <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(dataset)):
    input_image = dataset[idx][<span class="hljs-string">&quot;image&quot;</span>]
    edit_instruction = dataset[idx][<span class="hljs-string">&quot;edit&quot;</span>]
    edited_image = edit_image(input_image, edit_instruction)

    input_images.append(np.array(input_image))
    original_captions.append(dataset[idx][<span class="hljs-string">&quot;input&quot;</span>])
    modified_captions.append(dataset[idx][<span class="hljs-string">&quot;output&quot;</span>])
    edited_images.append(edited_image)`,wrap:!1}}),Le=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBDTElQVG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwQ0xJUFRleHRNb2RlbFdpdGhQcm9qZWN0aW9uJTJDJTBBJTIwJTIwJTIwJTIwQ0xJUFZpc2lvbk1vZGVsV2l0aFByb2plY3Rpb24lMkMlMEElMjAlMjAlMjAlMjBDTElQSW1hZ2VQcm9jZXNzb3IlMkMlMEEpJTBBJTBBY2xpcF9pZCUyMCUzRCUyMCUyMm9wZW5haSUyRmNsaXAtdml0LWxhcmdlLXBhdGNoMTQlMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBDTElQVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjbGlwX2lkKSUwQXRleHRfZW5jb2RlciUyMCUzRCUyMENMSVBUZXh0TW9kZWxXaXRoUHJvamVjdGlvbi5mcm9tX3ByZXRyYWluZWQoY2xpcF9pZCkudG8oZGV2aWNlKSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMENMSVBJbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoY2xpcF9pZCklMEFpbWFnZV9lbmNvZGVyJTIwJTNEJTIwQ0xJUFZpc2lvbk1vZGVsV2l0aFByb2plY3Rpb24uZnJvbV9wcmV0cmFpbmVkKGNsaXBfaWQpLnRvKGRldmljZSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    CLIPTokenizer,
    CLIPTextModelWithProjection,
    CLIPVisionModelWithProjection,
    CLIPImageProcessor,
)

clip_id = <span class="hljs-string">&quot;openai/clip-vit-large-patch14&quot;</span>
tokenizer = CLIPTokenizer.from_pretrained(clip_id)
text_encoder = CLIPTextModelWithProjection.from_pretrained(clip_id).to(device)
image_processor = CLIPImageProcessor.from_pretrained(clip_id)
image_encoder = CLIPVisionModelWithProjection.from_pretrained(clip_id).to(device)`,wrap:!1}}),De=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-keyword">import</span> torch.nn.functional <span class="hljs-keyword">as</span> F


<span class="hljs-keyword">class</span> <span class="hljs-title class_">DirectionalSimilarity</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, tokenizer, text_encoder, image_processor, image_encoder</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.tokenizer = tokenizer
        self.text_encoder = text_encoder
        self.image_processor = image_processor
        self.image_encoder = image_encoder

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_image</span>(<span class="hljs-params">self, image</span>):
        image = self.image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)[<span class="hljs-string">&quot;pixel_values&quot;</span>]
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;pixel_values&quot;</span>: image.to(device)}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize_text</span>(<span class="hljs-params">self, text</span>):
        inputs = self.tokenizer(
            text,
            max_length=self.tokenizer.model_max_length,
            padding=<span class="hljs-string">&quot;max_length&quot;</span>,
            truncation=<span class="hljs-literal">True</span>,
            return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
        )
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;input_ids&quot;</span>: inputs.input_ids.to(device)}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">encode_image</span>(<span class="hljs-params">self, image</span>):
        preprocessed_image = self.preprocess_image(image)
        image_features = self.image_encoder(**preprocessed_image).image_embeds
        image_features = image_features / image_features.norm(dim=<span class="hljs-number">1</span>, keepdim=<span class="hljs-literal">True</span>)
        <span class="hljs-keyword">return</span> image_features

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">encode_text</span>(<span class="hljs-params">self, text</span>):
        tokenized_text = self.tokenize_text(text)
        text_features = self.text_encoder(**tokenized_text).text_embeds
        text_features = text_features / text_features.norm(dim=<span class="hljs-number">1</span>, keepdim=<span class="hljs-literal">True</span>)
        <span class="hljs-keyword">return</span> text_features

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_directional_similarity</span>(<span class="hljs-params">self, img_feat_one, img_feat_two, text_feat_one, text_feat_two</span>):
        sim_direction = F.cosine_similarity(img_feat_two - img_feat_one, text_feat_two - text_feat_one)
        <span class="hljs-keyword">return</span> sim_direction

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, image_one, image_two, caption_one, caption_two</span>):
        img_feat_one = self.encode_image(image_one)
        img_feat_two = self.encode_image(image_two)
        text_feat_one = self.encode_text(caption_one)
        text_feat_two = self.encode_text(caption_two)
        directional_similarity = self.compute_directional_similarity(
            img_feat_one, img_feat_two, text_feat_one, text_feat_two
        )
        <span class="hljs-keyword">return</span> directional_similarity`,wrap:!1}}),Oe=new w({props:{code:"ZGlyX3NpbWlsYXJpdHklMjAlM0QlMjBEaXJlY3Rpb25hbFNpbWlsYXJpdHkodG9rZW5pemVyJTJDJTIwdGV4dF9lbmNvZGVyJTJDJTIwaW1hZ2VfcHJvY2Vzc29yJTJDJTIwaW1hZ2VfZW5jb2RlciklMEFzY29yZXMlMjAlM0QlMjAlNUIlNUQlMEElMEFmb3IlMjBpJTIwaW4lMjByYW5nZShsZW4oaW5wdXRfaW1hZ2VzKSklM0ElMEElMjAlMjAlMjAlMjBvcmlnaW5hbF9pbWFnZSUyMCUzRCUyMGlucHV0X2ltYWdlcyU1QmklNUQlMEElMjAlMjAlMjAlMjBvcmlnaW5hbF9jYXB0aW9uJTIwJTNEJTIwb3JpZ2luYWxfY2FwdGlvbnMlNUJpJTVEJTBBJTIwJTIwJTIwJTIwZWRpdGVkX2ltYWdlJTIwJTNEJTIwZWRpdGVkX2ltYWdlcyU1QmklNUQlMEElMjAlMjAlMjAlMjBtb2RpZmllZF9jYXB0aW9uJTIwJTNEJTIwbW9kaWZpZWRfY2FwdGlvbnMlNUJpJTVEJTBBJTBBJTIwJTIwJTIwJTIwc2ltaWxhcml0eV9zY29yZSUyMCUzRCUyMGRpcl9zaW1pbGFyaXR5KG9yaWdpbmFsX2ltYWdlJTJDJTIwZWRpdGVkX2ltYWdlJTJDJTIwb3JpZ2luYWxfY2FwdGlvbiUyQyUyMG1vZGlmaWVkX2NhcHRpb24pJTBBJTIwJTIwJTIwJTIwc2NvcmVzLmFwcGVuZChmbG9hdChzaW1pbGFyaXR5X3Njb3JlLmRldGFjaCgpLmNwdSgpKSklMEElMEFwcmludChmJTIyQ0xJUCUyMGRpcmVjdGlvbmFsJTIwc2ltaWxhcml0eSUzQSUyMCU3Qm5wLm1lYW4oc2NvcmVzKSU3RCUyMiklMEElMjMlMjBDTElQJTIwZGlyZWN0aW9uYWwlMjBzaW1pbGFyaXR5JTNBJTIwMC4wNzk3OTc2NTUzNDQwMDk0",highlighted:`dir_similarity = DirectionalSimilarity(tokenizer, text_encoder, image_processor, image_encoder)
scores = []

<span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(input_images)):
    original_image = input_images[i]
    original_caption = original_captions[i]
    edited_image = edited_images[i]
    modified_caption = modified_captions[i]

    similarity_score = dir_similarity(original_image, edited_image, original_caption, modified_caption)
    scores.append(<span class="hljs-built_in">float</span>(similarity_score.detach().cpu()))

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;CLIP directional similarity: <span class="hljs-subst">{np.mean(scores)}</span>&quot;</span>)
<span class="hljs-comment"># CLIP directional similarity: 0.0797976553440094</span>`,wrap:!1}}),_=new vs({props:{$$slots:{default:[ri]},$$scope:{ctx:I}}}),nt=new gt({props:{title:"Class-conditioned image generation",local:"class-conditioned-image-generation",headingTag:"h3"}}),Mt=new w({props:{code:"ZnJvbSUyMHppcGZpbGUlMjBpbXBvcnQlMjBaaXBGaWxlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEElMEFkZWYlMjBkb3dubG9hZCh1cmwlMkMlMjBsb2NhbF9maWxlcGF0aCklM0ElMEElMjAlMjAlMjAlMjByJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KHVybCklMEElMjAlMjAlMjAlMjB3aXRoJTIwb3Blbihsb2NhbF9maWxlcGF0aCUyQyUyMCUyMndiJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGYud3JpdGUoci5jb250ZW50KSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGxvY2FsX2ZpbGVwYXRoJTBBJTBBZHVtbXlfZGF0YXNldF91cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmhmLmNvJTJGZGF0YXNldHMlMkZzYXlha3BhdWwlMkZzYW1wbGUtZGF0YXNldHMlMkZyZXNvbHZlJTJGbWFpbiUyRnNhbXBsZS1pbWFnZW5ldC1pbWFnZXMuemlwJTIyJTBBbG9jYWxfZmlsZXBhdGglMjAlM0QlMjBkb3dubG9hZChkdW1teV9kYXRhc2V0X3VybCUyQyUyMGR1bW15X2RhdGFzZXRfdXJsLnNwbGl0KCUyMiUyRiUyMiklNUItMSU1RCklMEElMEF3aXRoJTIwWmlwRmlsZShsb2NhbF9maWxlcGF0aCUyQyUyMCUyMnIlMjIpJTIwYXMlMjB6aXBwZXIlM0ElMEElMjAlMjAlMjAlMjB6aXBwZXIuZXh0cmFjdGFsbCglMjIuJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> zipfile <span class="hljs-keyword">import</span> ZipFile
<span class="hljs-keyword">import</span> requests


<span class="hljs-keyword">def</span> <span class="hljs-title function_">download</span>(<span class="hljs-params">url, local_filepath</span>):
    r = requests.get(url)
    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(local_filepath, <span class="hljs-string">&quot;wb&quot;</span>) <span class="hljs-keyword">as</span> f:
        f.write(r.content)
    <span class="hljs-keyword">return</span> local_filepath

dummy_dataset_url = <span class="hljs-string">&quot;https://hf.co/datasets/sayakpaul/sample-datasets/resolve/main/sample-imagenet-images.zip&quot;</span>
local_filepath = download(dummy_dataset_url, dummy_dataset_url.split(<span class="hljs-string">&quot;/&quot;</span>)[-<span class="hljs-number">1</span>])

<span class="hljs-keyword">with</span> ZipFile(local_filepath, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> zipper:
    zipper.extractall(<span class="hljs-string">&quot;.&quot;</span>)`,wrap:!1}}),dt=new w({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwb3MlMEElMEFkYXRhc2V0X3BhdGglMjAlM0QlMjAlMjJzYW1wbGUtaW1hZ2VuZXQtaW1hZ2VzJTIyJTBBaW1hZ2VfcGF0aHMlMjAlM0QlMjBzb3J0ZWQoJTVCb3MucGF0aC5qb2luKGRhdGFzZXRfcGF0aCUyQyUyMHgpJTIwZm9yJTIweCUyMGluJTIwb3MubGlzdGRpcihkYXRhc2V0X3BhdGgpJTVEKSUwQSUwQXJlYWxfaW1hZ2VzJTIwJTNEJTIwJTVCbnAuYXJyYXkoSW1hZ2Uub3BlbihwYXRoKS5jb252ZXJ0KCUyMlJHQiUyMikpJTIwZm9yJTIwcGF0aCUyMGluJTIwaW1hZ2VfcGF0aHMlNUQ=",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> os

dataset_path = <span class="hljs-string">&quot;sample-imagenet-images&quot;</span>
image_paths = <span class="hljs-built_in">sorted</span>([os.path.join(dataset_path, x) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> os.listdir(dataset_path)])

real_images = [np.array(Image.<span class="hljs-built_in">open</span>(path).convert(<span class="hljs-string">&quot;RGB&quot;</span>)) <span class="hljs-keyword">for</span> path <span class="hljs-keyword">in</span> image_paths]`,wrap:!1}}),Jt=new w({props:{code:"ZnJvbSUyMHRvcmNodmlzaW9uLnRyYW5zZm9ybXMlMjBpbXBvcnQlMjBmdW5jdGlvbmFsJTIwYXMlMjBGJTBBJTBBJTBBZGVmJTIwcHJlcHJvY2Vzc19pbWFnZShpbWFnZSklM0ElMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMHRvcmNoLnRlbnNvcihpbWFnZSkudW5zcXVlZXplKDApJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBpbWFnZS5wZXJtdXRlKDAlMkMlMjAzJTJDJTIwMSUyQyUyMDIpJTIwJTJGJTIwMjU1LjAlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBGLmNlbnRlcl9jcm9wKGltYWdlJTJDJTIwKDI1NiUyQyUyMDI1NikpJTBBJTBBcmVhbF9pbWFnZXMlMjAlM0QlMjB0b3JjaC5jYXQoJTVCcHJlcHJvY2Vzc19pbWFnZShpbWFnZSklMjBmb3IlMjBpbWFnZSUyMGluJTIwcmVhbF9pbWFnZXMlNUQpJTBBcHJpbnQocmVhbF9pbWFnZXMuc2hhcGUpJTBBJTIzJTIwdG9yY2guU2l6ZSglNUIxMCUyQyUyMDMlMkMlMjAyNTYlMkMlMjAyNTYlNUQp",highlighted:`<span class="hljs-keyword">from</span> torchvision.transforms <span class="hljs-keyword">import</span> functional <span class="hljs-keyword">as</span> F


<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_image</span>(<span class="hljs-params">image</span>):
    image = torch.tensor(image).unsqueeze(<span class="hljs-number">0</span>)
    image = image.permute(<span class="hljs-number">0</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>) / <span class="hljs-number">255.0</span>
    <span class="hljs-keyword">return</span> F.center_crop(image, (<span class="hljs-number">256</span>, <span class="hljs-number">256</span>))

real_images = torch.cat([preprocess_image(image) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> real_images])
<span class="hljs-built_in">print</span>(real_images.shape)
<span class="hljs-comment"># torch.Size([10, 3, 256, 256])</span>`,wrap:!1}}),ft=new w({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpVFBpcGVsaW5lJTJDJTIwRFBNU29sdmVyTXVsdGlzdGVwU2NoZWR1bGVyJTBBJTBBZGl0X3BpcGVsaW5lJTIwJTNEJTIwRGlUUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGRGlULVhMLTItMjU2JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQWRpdF9waXBlbGluZS5zY2hlZHVsZXIlMjAlM0QlMjBEUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIuZnJvbV9jb25maWcoZGl0X3BpcGVsaW5lLnNjaGVkdWxlci5jb25maWcpJTBBZGl0X3BpcGVsaW5lJTIwJTNEJTIwZGl0X3BpcGVsaW5lLnRvKCUyMmN1ZGElMjIpJTBBJTBBd29yZHMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJjYXNzZXR0ZSUyMHBsYXllciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmNoYWluc2F3JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyY2hhaW5zYXclMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJjaHVyY2glMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJnYXMlMjBwdW1wJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyZ2FzJTIwcHVtcCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmdhcyUyMHB1bXAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJwYXJhY2h1dGUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJwYXJhY2h1dGUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJ0ZW5jaCUyMiUyQyUwQSU1RCUwQSUwQWNsYXNzX2lkcyUyMCUzRCUyMGRpdF9waXBlbGluZS5nZXRfbGFiZWxfaWRzKHdvcmRzKSUwQW91dHB1dCUyMCUzRCUyMGRpdF9waXBlbGluZShjbGFzc19sYWJlbHMlM0RjbGFzc19pZHMlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMjBvdXRwdXRfdHlwZSUzRCUyMm5wJTIyKSUwQSUwQWZha2VfaW1hZ2VzJTIwJTNEJTIwb3V0cHV0LmltYWdlcyUwQWZha2VfaW1hZ2VzJTIwJTNEJTIwdG9yY2gudGVuc29yKGZha2VfaW1hZ2VzKSUwQWZha2VfaW1hZ2VzJTIwJTNEJTIwZmFrZV9pbWFnZXMucGVybXV0ZSgwJTJDJTIwMyUyQyUyMDElMkMlMjAyKSUwQXByaW50KGZha2VfaW1hZ2VzLnNoYXBlKSUwQSUyMyUyMHRvcmNoLlNpemUoJTVCMTAlMkMlMjAzJTJDJTIwMjU2JTJDJTIwMjU2JTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiTPipeline, DPMSolverMultistepScheduler

dit_pipeline = DiTPipeline.from_pretrained(<span class="hljs-string">&quot;facebook/DiT-XL-2-256&quot;</span>, torch_dtype=torch.float16)
dit_pipeline.scheduler = DPMSolverMultistepScheduler.from_config(dit_pipeline.scheduler.config)
dit_pipeline = dit_pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)

words = [
    <span class="hljs-string">&quot;cassette player&quot;</span>,
    <span class="hljs-string">&quot;chainsaw&quot;</span>,
    <span class="hljs-string">&quot;chainsaw&quot;</span>,
    <span class="hljs-string">&quot;church&quot;</span>,
    <span class="hljs-string">&quot;gas pump&quot;</span>,
    <span class="hljs-string">&quot;gas pump&quot;</span>,
    <span class="hljs-string">&quot;gas pump&quot;</span>,
    <span class="hljs-string">&quot;parachute&quot;</span>,
    <span class="hljs-string">&quot;parachute&quot;</span>,
    <span class="hljs-string">&quot;tench&quot;</span>,
]

class_ids = dit_pipeline.get_label_ids(words)
output = dit_pipeline(class_labels=class_ids, generator=generator, output_type=<span class="hljs-string">&quot;np&quot;</span>)

fake_images = output.images
fake_images = torch.tensor(fake_images)
fake_images = fake_images.permute(<span class="hljs-number">0</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>)
<span class="hljs-built_in">print</span>(fake_images.shape)
<span class="hljs-comment"># torch.Size([10, 3, 256, 256])</span>`,wrap:!1}}),Tt=new w({props:{code:"ZnJvbSUyMHRvcmNobWV0cmljcy5pbWFnZS5maWQlMjBpbXBvcnQlMjBGcmVjaGV0SW5jZXB0aW9uRGlzdGFuY2UlMEElMEFmaWQlMjAlM0QlMjBGcmVjaGV0SW5jZXB0aW9uRGlzdGFuY2Uobm9ybWFsaXplJTNEVHJ1ZSklMEFmaWQudXBkYXRlKHJlYWxfaW1hZ2VzJTJDJTIwcmVhbCUzRFRydWUpJTBBZmlkLnVwZGF0ZShmYWtlX2ltYWdlcyUyQyUyMHJlYWwlM0RGYWxzZSklMEElMEFwcmludChmJTIyRklEJTNBJTIwJTdCZmxvYXQoZmlkLmNvbXB1dGUoKSklN0QlMjIpJTBBJTIzJTIwRklEJTNBJTIwMTc3LjcxNDcyMTY3OTY4NzU=",highlighted:`<span class="hljs-keyword">from</span> torchmetrics.image.fid <span class="hljs-keyword">import</span> FrechetInceptionDistance

fid = FrechetInceptionDistance(normalize=<span class="hljs-literal">True</span>)
fid.update(real_images, real=<span class="hljs-literal">True</span>)
fid.update(fake_images, real=<span class="hljs-literal">False</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;FID: <span class="hljs-subst">{<span class="hljs-built_in">float</span>(fid.compute())}</span>&quot;</span>)
<span class="hljs-comment"># FID: 177.7147216796875</span>`,wrap:!1}}),G=new vs({props:{warning:!0,$$slots:{default:[mi]},$$scope:{ctx:I}}}),{c(){r=n("meta"),j=a(),J=n("p"),y=a(),m(g.$$.fragment),Z=a(),T=n("a"),T.innerHTML=Ct,C=a(),U=n("p"),U.innerHTML=Bt,f=a(),b=n("p"),b.textContent=Ws,_t=a(),X=n("p"),X.innerHTML=Gs,Wt=a(),k=n("p"),k.innerHTML=xs,Gt=a(),m(V.$$.fragment),xt=a(),R=n("p"),R.textContent=Xs,Xt=a(),H=n("ul"),H.innerHTML=ks,kt=a(),m(N.$$.fragment),Vt=a(),F=n("p"),F.innerHTML=Vs,Rt=a(),$=n("p"),$.innerHTML=Rs,Ht=a(),Y=n("blockquote"),Y.innerHTML=Hs,Nt=a(),E=n("p"),E.innerHTML=Ns,Ft=a(),A=n("p"),A.textContent=Fs,$t=a(),Q=n("ul"),Q.innerHTML=$s,Yt=a(),S=n("p"),S.textContent=Ys,Et=a(),z=n("p"),z.innerHTML=Es,At=a(),L=n("ul"),L.innerHTML=As,Qt=a(),P=n("p"),P.innerHTML=Qs,St=a(),q=n("p"),q.innerHTML=Ss,zt=a(),m(D.$$.fragment),Lt=a(),K=n("p"),K.innerHTML=zs,Pt=a(),m(O.$$.fragment),qt=a(),ee=n("p"),ee.innerHTML=Ls,Dt=a(),te=n("p"),te.innerHTML=Ps,Kt=a(),le=n("p"),le.innerHTML=qs,Ot=a(),se=n("p"),se.textContent=Ds,el=a(),m(B.$$.fragment),tl=a(),m(ae.$$.fragment),ll=a(),ie=n("p"),ie.textContent=Ks,sl=a(),ne=n("ul"),ne.innerHTML=Os,al=a(),m(pe.$$.fragment),il=a(),oe=n("p"),oe.innerHTML=ea,nl=a(),re=n("p"),re.innerHTML=ta,pl=a(),m(me.$$.fragment),ol=a(),ce=n("p"),ce.textContent=la,rl=a(),m(Me.$$.fragment),ml=a(),de=n("p"),de.textContent=sa,cl=a(),m(ue.$$.fragment),Ml=a(),he=n("p"),he.textContent=aa,dl=a(),Je=n("p"),Je.innerHTML=ia,ul=a(),m(we.$$.fragment),hl=a(),fe=n("p"),fe.innerHTML=na,Jl=a(),m(ye.$$.fragment),wl=a(),Te=n("p"),Te.textContent=pa,fl=a(),m(je.$$.fragment),yl=a(),Ue=n("p"),Ue.innerHTML=oa,Tl=a(),m(v.$$.fragment),jl=a(),m(be.$$.fragment),Ul=a(),Ie=n("p"),Ie.innerHTML=ra,bl=a(),ge=n("p"),ge.textContent=ma,Il=a(),Ze=n("p"),Ze.innerHTML=ca,gl=a(),Ce=n("p"),Ce.innerHTML=Ma,Zl=a(),Be=n("ul"),Be.innerHTML=da,Cl=a(),ve=n("p"),ve.textContent=ua,Bl=a(),_e=n("p"),_e.innerHTML=ha,vl=a(),We=n("p"),We.textContent=Ja,_l=a(),m(Ge.$$.fragment),Wl=a(),m(xe.$$.fragment),Gl=a(),Xe=n("p"),Xe.textContent=wa,xl=a(),ke=n("ul"),ke.innerHTML=fa,Xl=a(),Ve=n("p"),Ve.textContent=ya,kl=a(),m(Re.$$.fragment),Vl=a(),m(He.$$.fragment),Rl=a(),Ne=n("p"),Ne.textContent=Ta,Hl=a(),m(Fe.$$.fragment),Nl=a(),$e=n("p"),$e.innerHTML=ja,Fl=a(),Ye=n("p"),Ye.textContent=Ua,$l=a(),Ee=n("p"),Ee.innerHTML=ba,Yl=a(),m(Ae.$$.fragment),El=a(),Qe=n("p"),Qe.textContent=Ia,Al=a(),m(Se.$$.fragment),Ql=a(),ze=n("p"),ze.textContent=ga,Sl=a(),m(Le.$$.fragment),zl=a(),Pe=n("p"),Pe.innerHTML=Za,Ll=a(),qe=n("p"),qe.innerHTML=Ca,Pl=a(),m(De.$$.fragment),ql=a(),Ke=n("p"),Ke.innerHTML=Ba,Dl=a(),m(Oe.$$.fragment),Kl=a(),et=n("p"),et.textContent=va,Ol=a(),tt=n("p"),tt.innerHTML=_a,es=a(),lt=n("p"),lt.innerHTML=Wa,ts=a(),st=n("p"),st.innerHTML=Ga,ls=a(),m(_.$$.fragment),ss=a(),at=n("p"),at.innerHTML=xa,as=a(),it=n("p"),it.innerHTML=Xa,is=a(),m(nt.$$.fragment),ns=a(),pt=n("p"),pt.innerHTML=ka,ps=a(),ot=n("p"),ot.innerHTML=Va,os=a(),rt=n("blockquote"),rt.innerHTML=Ra,rs=a(),mt=n("p"),mt.textContent=Ha,ms=a(),ct=n("p"),ct.textContent=Na,cs=a(),m(Mt.$$.fragment),Ms=a(),m(dt.$$.fragment),ds=a(),ut=n("p"),ut.textContent=Fa,us=a(),W=n("p"),W.innerHTML=$a,hs=a(),ht=n("p"),ht.textContent=Ya,Js=a(),m(Jt.$$.fragment),ws=a(),wt=n("p"),wt.innerHTML=Ea,fs=a(),m(ft.$$.fragment),ys=a(),yt=n("p"),yt.innerHTML=Aa,Ts=a(),m(Tt.$$.fragment),js=a(),jt=n("p"),jt.textContent=Qa,Us=a(),Ut=n("ul"),Ut.innerHTML=Sa,bs=a(),bt=n("p"),bt.textContent=za,Is=a(),m(G.$$.fragment),gs=a(),It=n("p"),It.innerHTML=La,Zs=a(),x=n("p"),x.innerHTML=Pa,Cs=a(),vt=n("p"),this.h()},l(e){const t=ii("svelte-u9bgzb",document.head);r=p(t,"META",{name:!0,content:!0}),t.forEach(l),j=i(e),J=p(e,"P",{}),ei(J).forEach(l),y=i(e),c(g.$$.fragment,e),Z=i(e),T=p(e,"A",{target:!0,href:!0,"data-svelte-h":!0}),o(T)!=="svelte-1fn2wis"&&(T.innerHTML=Ct),C=i(e),U=p(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-z81vpv"&&(U.innerHTML=Bt),f=i(e),b=p(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-14o42r"&&(b.textContent=Ws),_t=i(e),X=p(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-tqblgl"&&(X.innerHTML=Gs),Wt=i(e),k=p(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1on511i"&&(k.innerHTML=xs),Gt=i(e),c(V.$$.fragment,e),xt=i(e),R=p(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-cqau2t"&&(R.textContent=Xs),Xt=i(e),H=p(e,"UL",{"data-svelte-h":!0}),o(H)!=="svelte-1izcxm8"&&(H.innerHTML=ks),kt=i(e),c(N.$$.fragment,e),Vt=i(e),F=p(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-cad463"&&(F.innerHTML=Vs),Rt=i(e),$=p(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-15hirvk"&&($.innerHTML=Rs),Ht=i(e),Y=p(e,"BLOCKQUOTE",{"data-svelte-h":!0}),o(Y)!=="svelte-191e550"&&(Y.innerHTML=Hs),Nt=i(e),E=p(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-19xz367"&&(E.innerHTML=Ns),Ft=i(e),A=p(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-76ujpq"&&(A.textContent=Fs),$t=i(e),Q=p(e,"UL",{"data-svelte-h":!0}),o(Q)!=="svelte-umnjz5"&&(Q.innerHTML=$s),Yt=i(e),S=p(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-ybl15o"&&(S.textContent=Ys),Et=i(e),z=p(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-f7spg1"&&(z.innerHTML=Es),At=i(e),L=p(e,"UL",{"data-svelte-h":!0}),o(L)!=="svelte-18glkk1"&&(L.innerHTML=As),Qt=i(e),P=p(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-e5mnz8"&&(P.innerHTML=Qs),St=i(e),q=p(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-304bv6"&&(q.innerHTML=Ss),zt=i(e),c(D.$$.fragment,e),Lt=i(e),K=p(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-tpmlzv"&&(K.innerHTML=zs),Pt=i(e),c(O.$$.fragment,e),qt=i(e),ee=p(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-4i7yd5"&&(ee.innerHTML=Ls),Dt=i(e),te=p(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-1iqix0j"&&(te.innerHTML=Ps),Kt=i(e),le=p(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-gipltn"&&(le.innerHTML=qs),Ot=i(e),se=p(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-1vqr9z3"&&(se.textContent=Ds),el=i(e),c(B.$$.fragment,e),tl=i(e),c(ae.$$.fragment,e),ll=i(e),ie=p(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-6557l0"&&(ie.textContent=Ks),sl=i(e),ne=p(e,"UL",{"data-svelte-h":!0}),o(ne)!=="svelte-dg8xrl"&&(ne.innerHTML=Os),al=i(e),c(pe.$$.fragment,e),il=i(e),oe=p(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-17jh2lx"&&(oe.innerHTML=ea),nl=i(e),re=p(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-l33spf"&&(re.innerHTML=ta),pl=i(e),c(me.$$.fragment,e),ol=i(e),ce=p(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-6rdsa0"&&(ce.textContent=la),rl=i(e),c(Me.$$.fragment,e),ml=i(e),de=p(e,"P",{"data-svelte-h":!0}),o(de)!=="svelte-1iembt3"&&(de.textContent=sa),cl=i(e),c(ue.$$.fragment,e),Ml=i(e),he=p(e,"P",{"data-svelte-h":!0}),o(he)!=="svelte-1a3tn0d"&&(he.textContent=aa),dl=i(e),Je=p(e,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-fx2hva"&&(Je.innerHTML=ia),ul=i(e),c(we.$$.fragment,e),hl=i(e),fe=p(e,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-qym5mj"&&(fe.innerHTML=na),Jl=i(e),c(ye.$$.fragment,e),wl=i(e),Te=p(e,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-ni3sdy"&&(Te.textContent=pa),fl=i(e),c(je.$$.fragment,e),yl=i(e),Ue=p(e,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-1xnoaz5"&&(Ue.innerHTML=oa),Tl=i(e),c(v.$$.fragment,e),jl=i(e),c(be.$$.fragment,e),Ul=i(e),Ie=p(e,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-1jr4341"&&(Ie.innerHTML=ra),bl=i(e),ge=p(e,"P",{"data-svelte-h":!0}),o(ge)!=="svelte-r4qmx2"&&(ge.textContent=ma),Il=i(e),Ze=p(e,"P",{"data-svelte-h":!0}),o(Ze)!=="svelte-tnn31f"&&(Ze.innerHTML=ca),gl=i(e),Ce=p(e,"P",{"data-svelte-h":!0}),o(Ce)!=="svelte-oghx7t"&&(Ce.innerHTML=Ma),Zl=i(e),Be=p(e,"UL",{"data-svelte-h":!0}),o(Be)!=="svelte-yda35x"&&(Be.innerHTML=da),Cl=i(e),ve=p(e,"P",{"data-svelte-h":!0}),o(ve)!=="svelte-1bn7xvw"&&(ve.textContent=ua),Bl=i(e),_e=p(e,"P",{"data-svelte-h":!0}),o(_e)!=="svelte-fs1abj"&&(_e.innerHTML=ha),vl=i(e),We=p(e,"P",{"data-svelte-h":!0}),o(We)!=="svelte-1t03m2p"&&(We.textContent=Ja),_l=i(e),c(Ge.$$.fragment,e),Wl=i(e),c(xe.$$.fragment,e),Gl=i(e),Xe=p(e,"P",{"data-svelte-h":!0}),o(Xe)!=="svelte-1q1xt9i"&&(Xe.textContent=wa),xl=i(e),ke=p(e,"UL",{"data-svelte-h":!0}),o(ke)!=="svelte-mhcjab"&&(ke.innerHTML=fa),Xl=i(e),Ve=p(e,"P",{"data-svelte-h":!0}),o(Ve)!=="svelte-9q1iss"&&(Ve.textContent=ya),kl=i(e),c(Re.$$.fragment,e),Vl=i(e),c(He.$$.fragment,e),Rl=i(e),Ne=p(e,"P",{"data-svelte-h":!0}),o(Ne)!=="svelte-5rwzaj"&&(Ne.textContent=Ta),Hl=i(e),c(Fe.$$.fragment,e),Nl=i(e),$e=p(e,"P",{"data-svelte-h":!0}),o($e)!=="svelte-1r4pb3b"&&($e.innerHTML=ja),Fl=i(e),Ye=p(e,"P",{"data-svelte-h":!0}),o(Ye)!=="svelte-1n3s9hn"&&(Ye.textContent=Ua),$l=i(e),Ee=p(e,"P",{"data-svelte-h":!0}),o(Ee)!=="svelte-1edqxz3"&&(Ee.innerHTML=ba),Yl=i(e),c(Ae.$$.fragment,e),El=i(e),Qe=p(e,"P",{"data-svelte-h":!0}),o(Qe)!=="svelte-pfw8ud"&&(Qe.textContent=Ia),Al=i(e),c(Se.$$.fragment,e),Ql=i(e),ze=p(e,"P",{"data-svelte-h":!0}),o(ze)!=="svelte-1nzzrqn"&&(ze.textContent=ga),Sl=i(e),c(Le.$$.fragment,e),zl=i(e),Pe=p(e,"P",{"data-svelte-h":!0}),o(Pe)!=="svelte-1c659ih"&&(Pe.innerHTML=Za),Ll=i(e),qe=p(e,"P",{"data-svelte-h":!0}),o(qe)!=="svelte-k3cp0u"&&(qe.innerHTML=Ca),Pl=i(e),c(De.$$.fragment,e),ql=i(e),Ke=p(e,"P",{"data-svelte-h":!0}),o(Ke)!=="svelte-1tdcjay"&&(Ke.innerHTML=Ba),Dl=i(e),c(Oe.$$.fragment,e),Kl=i(e),et=p(e,"P",{"data-svelte-h":!0}),o(et)!=="svelte-14mrga2"&&(et.textContent=va),Ol=i(e),tt=p(e,"P",{"data-svelte-h":!0}),o(tt)!=="svelte-vck7qn"&&(tt.innerHTML=_a),es=i(e),lt=p(e,"P",{"data-svelte-h":!0}),o(lt)!=="svelte-nbfdj7"&&(lt.innerHTML=Wa),ts=i(e),st=p(e,"P",{"data-svelte-h":!0}),o(st)!=="svelte-9ga2iu"&&(st.innerHTML=Ga),ls=i(e),c(_.$$.fragment,e),ss=i(e),at=p(e,"P",{"data-svelte-h":!0}),o(at)!=="svelte-7qwtg3"&&(at.innerHTML=xa),as=i(e),it=p(e,"P",{"data-svelte-h":!0}),o(it)!=="svelte-hcc15s"&&(it.innerHTML=Xa),is=i(e),c(nt.$$.fragment,e),ns=i(e),pt=p(e,"P",{"data-svelte-h":!0}),o(pt)!=="svelte-1jmn10t"&&(pt.innerHTML=ka),ps=i(e),ot=p(e,"P",{"data-svelte-h":!0}),o(ot)!=="svelte-1rk18fl"&&(ot.innerHTML=Va),os=i(e),rt=p(e,"BLOCKQUOTE",{"data-svelte-h":!0}),o(rt)!=="svelte-7e4j74"&&(rt.innerHTML=Ra),rs=i(e),mt=p(e,"P",{"data-svelte-h":!0}),o(mt)!=="svelte-simh2d"&&(mt.textContent=Ha),ms=i(e),ct=p(e,"P",{"data-svelte-h":!0}),o(ct)!=="svelte-1h659dy"&&(ct.textContent=Na),cs=i(e),c(Mt.$$.fragment,e),Ms=i(e),c(dt.$$.fragment,e),ds=i(e),ut=p(e,"P",{"data-svelte-h":!0}),o(ut)!=="svelte-1jd4ltz"&&(ut.textContent=Fa),us=i(e),W=p(e,"P",{align:!0,"data-svelte-h":!0}),o(W)!=="svelte-94lw7t"&&(W.innerHTML=$a),hs=i(e),ht=p(e,"P",{"data-svelte-h":!0}),o(ht)!=="svelte-iw90qp"&&(ht.textContent=Ya),Js=i(e),c(Jt.$$.fragment,e),ws=i(e),wt=p(e,"P",{"data-svelte-h":!0}),o(wt)!=="svelte-a40j2v"&&(wt.innerHTML=Ea),fs=i(e),c(ft.$$.fragment,e),ys=i(e),yt=p(e,"P",{"data-svelte-h":!0}),o(yt)!=="svelte-1nlt7gv"&&(yt.innerHTML=Aa),Ts=i(e),c(Tt.$$.fragment,e),js=i(e),jt=p(e,"P",{"data-svelte-h":!0}),o(jt)!=="svelte-17lmdw3"&&(jt.textContent=Qa),Us=i(e),Ut=p(e,"UL",{"data-svelte-h":!0}),o(Ut)!=="svelte-16n90lm"&&(Ut.innerHTML=Sa),bs=i(e),bt=p(e,"P",{"data-svelte-h":!0}),o(bt)!=="svelte-1evgdla"&&(bt.textContent=za),Is=i(e),c(G.$$.fragment,e),gs=i(e),It=p(e,"P",{"data-svelte-h":!0}),o(It)!=="svelte-ptrlon"&&(It.innerHTML=La),Zs=i(e),x=p(e,"P",{align:!0,"data-svelte-h":!0}),o(x)!=="svelte-16e5oh4"&&(x.innerHTML=Pa),Cs=i(e),vt=p(e,"P",{}),ei(vt).forEach(l),this.h()},h(){Zt(r,"name","hf:doc:metadata"),Zt(r,"content",Mi),Zt(T,"target","_blank"),Zt(T,"href","https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers/evaluation.ipynb"),Zt(W,"align","center"),Zt(x,"align","center")},m(e,t){ni(document.head,r),s(e,j,t),s(e,J,t),s(e,y,t),M(g,e,t),s(e,Z,t),s(e,T,t),s(e,C,t),s(e,U,t),s(e,f,t),s(e,b,t),s(e,_t,t),s(e,X,t),s(e,Wt,t),s(e,k,t),s(e,Gt,t),M(V,e,t),s(e,xt,t),s(e,R,t),s(e,Xt,t),s(e,H,t),s(e,kt,t),M(N,e,t),s(e,Vt,t),s(e,F,t),s(e,Rt,t),s(e,$,t),s(e,Ht,t),s(e,Y,t),s(e,Nt,t),s(e,E,t),s(e,Ft,t),s(e,A,t),s(e,$t,t),s(e,Q,t),s(e,Yt,t),s(e,S,t),s(e,Et,t),s(e,z,t),s(e,At,t),s(e,L,t),s(e,Qt,t),s(e,P,t),s(e,St,t),s(e,q,t),s(e,zt,t),M(D,e,t),s(e,Lt,t),s(e,K,t),s(e,Pt,t),M(O,e,t),s(e,qt,t),s(e,ee,t),s(e,Dt,t),s(e,te,t),s(e,Kt,t),s(e,le,t),s(e,Ot,t),s(e,se,t),s(e,el,t),M(B,e,t),s(e,tl,t),M(ae,e,t),s(e,ll,t),s(e,ie,t),s(e,sl,t),s(e,ne,t),s(e,al,t),M(pe,e,t),s(e,il,t),s(e,oe,t),s(e,nl,t),s(e,re,t),s(e,pl,t),M(me,e,t),s(e,ol,t),s(e,ce,t),s(e,rl,t),M(Me,e,t),s(e,ml,t),s(e,de,t),s(e,cl,t),M(ue,e,t),s(e,Ml,t),s(e,he,t),s(e,dl,t),s(e,Je,t),s(e,ul,t),M(we,e,t),s(e,hl,t),s(e,fe,t),s(e,Jl,t),M(ye,e,t),s(e,wl,t),s(e,Te,t),s(e,fl,t),M(je,e,t),s(e,yl,t),s(e,Ue,t),s(e,Tl,t),M(v,e,t),s(e,jl,t),M(be,e,t),s(e,Ul,t),s(e,Ie,t),s(e,bl,t),s(e,ge,t),s(e,Il,t),s(e,Ze,t),s(e,gl,t),s(e,Ce,t),s(e,Zl,t),s(e,Be,t),s(e,Cl,t),s(e,ve,t),s(e,Bl,t),s(e,_e,t),s(e,vl,t),s(e,We,t),s(e,_l,t),M(Ge,e,t),s(e,Wl,t),M(xe,e,t),s(e,Gl,t),s(e,Xe,t),s(e,xl,t),s(e,ke,t),s(e,Xl,t),s(e,Ve,t),s(e,kl,t),M(Re,e,t),s(e,Vl,t),M(He,e,t),s(e,Rl,t),s(e,Ne,t),s(e,Hl,t),M(Fe,e,t),s(e,Nl,t),s(e,$e,t),s(e,Fl,t),s(e,Ye,t),s(e,$l,t),s(e,Ee,t),s(e,Yl,t),M(Ae,e,t),s(e,El,t),s(e,Qe,t),s(e,Al,t),M(Se,e,t),s(e,Ql,t),s(e,ze,t),s(e,Sl,t),M(Le,e,t),s(e,zl,t),s(e,Pe,t),s(e,Ll,t),s(e,qe,t),s(e,Pl,t),M(De,e,t),s(e,ql,t),s(e,Ke,t),s(e,Dl,t),M(Oe,e,t),s(e,Kl,t),s(e,et,t),s(e,Ol,t),s(e,tt,t),s(e,es,t),s(e,lt,t),s(e,ts,t),s(e,st,t),s(e,ls,t),M(_,e,t),s(e,ss,t),s(e,at,t),s(e,as,t),s(e,it,t),s(e,is,t),M(nt,e,t),s(e,ns,t),s(e,pt,t),s(e,ps,t),s(e,ot,t),s(e,os,t),s(e,rt,t),s(e,rs,t),s(e,mt,t),s(e,ms,t),s(e,ct,t),s(e,cs,t),M(Mt,e,t),s(e,Ms,t),M(dt,e,t),s(e,ds,t),s(e,ut,t),s(e,us,t),s(e,W,t),s(e,hs,t),s(e,ht,t),s(e,Js,t),M(Jt,e,t),s(e,ws,t),s(e,wt,t),s(e,fs,t),M(ft,e,t),s(e,ys,t),s(e,yt,t),s(e,Ts,t),M(Tt,e,t),s(e,js,t),s(e,jt,t),s(e,Us,t),s(e,Ut,t),s(e,bs,t),s(e,bt,t),s(e,Is,t),M(G,e,t),s(e,gs,t),s(e,It,t),s(e,Zs,t),s(e,x,t),s(e,Cs,t),s(e,vt,t),Bs=!0},p(e,[t]){const qa={};t&2&&(qa.$$scope={dirty:t,ctx:e}),B.$set(qa);const Da={};t&2&&(Da.$$scope={dirty:t,ctx:e}),v.$set(Da);const Ka={};t&2&&(Ka.$$scope={dirty:t,ctx:e}),_.$set(Ka);const Oa={};t&2&&(Oa.$$scope={dirty:t,ctx:e}),G.$set(Oa)},i(e){Bs||(d(g.$$.fragment,e),d(V.$$.fragment,e),d(N.$$.fragment,e),d(D.$$.fragment,e),d(O.$$.fragment,e),d(B.$$.fragment,e),d(ae.$$.fragment,e),d(pe.$$.fragment,e),d(me.$$.fragment,e),d(Me.$$.fragment,e),d(ue.$$.fragment,e),d(we.$$.fragment,e),d(ye.$$.fragment,e),d(je.$$.fragment,e),d(v.$$.fragment,e),d(be.$$.fragment,e),d(Ge.$$.fragment,e),d(xe.$$.fragment,e),d(Re.$$.fragment,e),d(He.$$.fragment,e),d(Fe.$$.fragment,e),d(Ae.$$.fragment,e),d(Se.$$.fragment,e),d(Le.$$.fragment,e),d(De.$$.fragment,e),d(Oe.$$.fragment,e),d(_.$$.fragment,e),d(nt.$$.fragment,e),d(Mt.$$.fragment,e),d(dt.$$.fragment,e),d(Jt.$$.fragment,e),d(ft.$$.fragment,e),d(Tt.$$.fragment,e),d(G.$$.fragment,e),Bs=!0)},o(e){u(g.$$.fragment,e),u(V.$$.fragment,e),u(N.$$.fragment,e),u(D.$$.fragment,e),u(O.$$.fragment,e),u(B.$$.fragment,e),u(ae.$$.fragment,e),u(pe.$$.fragment,e),u(me.$$.fragment,e),u(Me.$$.fragment,e),u(ue.$$.fragment,e),u(we.$$.fragment,e),u(ye.$$.fragment,e),u(je.$$.fragment,e),u(v.$$.fragment,e),u(be.$$.fragment,e),u(Ge.$$.fragment,e),u(xe.$$.fragment,e),u(Re.$$.fragment,e),u(He.$$.fragment,e),u(Fe.$$.fragment,e),u(Ae.$$.fragment,e),u(Se.$$.fragment,e),u(Le.$$.fragment,e),u(De.$$.fragment,e),u(Oe.$$.fragment,e),u(_.$$.fragment,e),u(nt.$$.fragment,e),u(Mt.$$.fragment,e),u(dt.$$.fragment,e),u(Jt.$$.fragment,e),u(ft.$$.fragment,e),u(Tt.$$.fragment,e),u(G.$$.fragment,e),Bs=!1},d(e){e&&(l(j),l(J),l(y),l(Z),l(T),l(C),l(U),l(f),l(b),l(_t),l(X),l(Wt),l(k),l(Gt),l(xt),l(R),l(Xt),l(H),l(kt),l(Vt),l(F),l(Rt),l($),l(Ht),l(Y),l(Nt),l(E),l(Ft),l(A),l($t),l(Q),l(Yt),l(S),l(Et),l(z),l(At),l(L),l(Qt),l(P),l(St),l(q),l(zt),l(Lt),l(K),l(Pt),l(qt),l(ee),l(Dt),l(te),l(Kt),l(le),l(Ot),l(se),l(el),l(tl),l(ll),l(ie),l(sl),l(ne),l(al),l(il),l(oe),l(nl),l(re),l(pl),l(ol),l(ce),l(rl),l(ml),l(de),l(cl),l(Ml),l(he),l(dl),l(Je),l(ul),l(hl),l(fe),l(Jl),l(wl),l(Te),l(fl),l(yl),l(Ue),l(Tl),l(jl),l(Ul),l(Ie),l(bl),l(ge),l(Il),l(Ze),l(gl),l(Ce),l(Zl),l(Be),l(Cl),l(ve),l(Bl),l(_e),l(vl),l(We),l(_l),l(Wl),l(Gl),l(Xe),l(xl),l(ke),l(Xl),l(Ve),l(kl),l(Vl),l(Rl),l(Ne),l(Hl),l(Nl),l($e),l(Fl),l(Ye),l($l),l(Ee),l(Yl),l(El),l(Qe),l(Al),l(Ql),l(ze),l(Sl),l(zl),l(Pe),l(Ll),l(qe),l(Pl),l(ql),l(Ke),l(Dl),l(Kl),l(et),l(Ol),l(tt),l(es),l(lt),l(ts),l(st),l(ls),l(ss),l(at),l(as),l(it),l(is),l(ns),l(pt),l(ps),l(ot),l(os),l(rt),l(rs),l(mt),l(ms),l(ct),l(cs),l(Ms),l(ds),l(ut),l(us),l(W),l(hs),l(ht),l(Js),l(ws),l(wt),l(fs),l(ys),l(yt),l(Ts),l(js),l(jt),l(Us),l(Ut),l(bs),l(bt),l(Is),l(gs),l(It),l(Zs),l(x),l(Cs),l(vt)),l(r),h(g,e),h(V,e),h(N,e),h(D,e),h(O,e),h(B,e),h(ae,e),h(pe,e),h(me,e),h(Me,e),h(ue,e),h(we,e),h(ye,e),h(je,e),h(v,e),h(be,e),h(Ge,e),h(xe,e),h(Re,e),h(He,e),h(Fe,e),h(Ae,e),h(Se,e),h(Le,e),h(De,e),h(Oe,e),h(_,e),h(nt,e),h(Mt,e),h(dt,e),h(Jt,e),h(ft,e),h(Tt,e),h(G,e)}}}const Mi='{"title":"Evaluating Diffusion Models","local":"evaluating-diffusion-models","sections":[{"title":"Scenarios","local":"scenarios","sections":[],"depth":2},{"title":"Qualitative Evaluation","local":"qualitative-evaluation","sections":[],"depth":2},{"title":"Quantitative Evaluation","local":"quantitative-evaluation","sections":[{"title":"Text-guided image generation","local":"text-guided-image-generation","sections":[],"depth":3},{"title":"Image-conditioned text-to-image generation","local":"image-conditioned-text-to-image-generation","sections":[],"depth":3},{"title":"Class-conditioned image generation","local":"class-conditioned-image-generation","sections":[],"depth":3}],"depth":2}],"depth":1}';function di(I){return li(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class yi extends si{constructor(r){super(),ai(this,r,di,ci,ti,{})}}export{yi as component};
