import{s as Dt,n as Kt,o as Ot}from"../chunks/scheduler.9991993c.js";import{S as el,i as tl,g as i,s as n,r as p,A as ll,h as m,f as l,c as a,j as Pt,u as r,x as o,k as St,y as sl,a as s,v as c,d as J,t as g,w as M}from"../chunks/index.7fc9a5e7.js";import{C as u}from"../chunks/CodeBlock.e11cba92.js";import{D as nl}from"../chunks/DocNotebookDropdown.a0cb4c0f.js";import{H as d}from"../chunks/Heading.e3de321f.js";function al(dt){let b,de,ue,Te,T,fe,f,Ue,U,Tt='🤗 Transformers 中有多种多语言模型，它们的推理用法与单语言模型不同。但是，并非<em>所有</em>的多语言模型用法都不同。一些模型，例如 <a href="https://huggingface.co/google-bert/bert-base-multilingual-uncased" rel="nofollow">google-bert/bert-base-multilingual-uncased</a> 就可以像单语言模型一样使用。本指南将向您展示如何使用不同用途的多语言模型进行推理。',ye,y,he,h,ft="XLM 有十个不同的检查点，其中只有一个是单语言的。剩下的九个检查点可以归为两类：使用语言嵌入的检查点和不使用语言嵌入的检查点。",$e,$,we,w,Ut="以下 XLM 模型使用语言嵌入来指定推理中使用的语言：",ke,k,yt="<li><code>FacebookAI/xlm-mlm-ende-1024</code> （掩码语言建模，英语-德语）</li> <li><code>FacebookAI/xlm-mlm-enfr-1024</code> （掩码语言建模，英语-法语）</li> <li><code>FacebookAI/xlm-mlm-enro-1024</code> （掩码语言建模，英语-罗马尼亚语）</li> <li><code>FacebookAI/xlm-mlm-xnli15-1024</code> （掩码语言建模，XNLI 数据集语言）</li> <li><code>FacebookAI/xlm-mlm-tlm-xnli15-1024</code> （掩码语言建模+翻译，XNLI 数据集语言）</li> <li><code>FacebookAI/xlm-clm-enfr-1024</code> （因果语言建模，英语-法语）</li> <li><code>FacebookAI/xlm-clm-ende-1024</code> （因果语言建模，英语-德语）</li>",xe,x,ht="语言嵌入被表示一个张量，其形状与传递给模型的 <code>input_ids</code> 相同。这些张量中的值取决于所使用的语言，并由分词器的 <code>lang2id</code> 和 <code>id2lang</code>  属性识别。",je,j,$t="在此示例中，加载 <code>FacebookAI/xlm-clm-enfr-1024</code> 检查点（因果语言建模，英语-法语）：",Ce,C,ve,v,wt="分词器的 <code>lang2id</code> 属性显示了该模型的语言及其对应的id：",_e,_,Ze,Z,kt="接下来，创建一个示例输入：",Ie,I,Xe,X,xt="将语言 id 设置为 <code>&quot;en&quot;</code> 并用其定义语言嵌入。语言嵌入是一个用 <code>0</code> 填充的张量，这个张量应该与 <code>input_ids</code> 大小相同。",Ve,V,Re,R,jt="现在，你可以将 <code>input_ids</code> 和语言嵌入传递给模型：",We,W,Ge,G,Ct='<a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/text-generation/run_generation.py" rel="nofollow">run_generation.py</a> 脚本可以使用 <code>xlm-clm</code> 检查点生成带有语言嵌入的文本。',Le,L,Fe,F,vt="以下 XLM 模型在推理时不需要语言嵌入：",ze,z,_t="<li><code>FacebookAI/xlm-mlm-17-1280</code> （掩码语言建模，支持 17 种语言）</li> <li><code>FacebookAI/xlm-mlm-100-1280</code> （掩码语言建模，支持 100 种语言）</li>",Be,B,Zt="与之前的 XLM 检查点不同，这些模型用于通用句子表示。",Ee,E,Qe,Q,It="以下 BERT 模型可用于多语言任务：",He,H,Xt="<li><code>google-bert/bert-base-multilingual-uncased</code> （掩码语言建模 + 下一句预测，支持 102 种语言）</li> <li><code>google-bert/bert-base-multilingual-cased</code> （掩码语言建模 + 下一句预测，支持 104 种语言）</li>",qe,q,Vt="这些模型在推理时不需要语言嵌入。它们应该能够从上下文中识别语言并进行相应的推理。",Ne,N,Ye,Y,Rt="以下 XLM-RoBERTa 模型可用于多语言任务：",Ae,A,Wt="<li><code>FacebookAI/xlm-roberta-base</code> （掩码语言建模，支持 100 种语言）</li> <li><code>FacebookAI/xlm-roberta-large</code> （掩码语言建模，支持 100 种语言）</li>",Pe,P,Gt="XLM-RoBERTa 使用 100 种语言的 2.5TB 新创建和清理的 CommonCrawl 数据进行了训练。与之前发布的 mBERT 或 XLM 等多语言模型相比，它在分类、序列标记和问答等下游任务上提供了更强大的优势。",Se,S,De,D,Lt="以下 M2M100 模型可用于多语言翻译：",Ke,K,Ft="<li><code>facebook/m2m100_418M</code> （翻译）</li> <li><code>facebook/m2m100_1.2B</code> （翻译）</li>",Oe,O,zt="在此示例中，加载 <code>facebook/m2m100_418M</code> 检查点以将中文翻译为英文。你可以在分词器中设置源语言：",et,ee,tt,te,Bt="对文本进行分词：",lt,le,st,se,Et="M2M100 强制将目标语言 id 作为第一个生成的标记，以进行到目标语言的翻译。在 <code>generate</code> 方法中将 <code>forced_bos_token_id</code> 设置为 <code>en</code> 以翻译成英语：",nt,ne,at,ae,it,ie,Qt="以下 MBart 模型可用于多语言翻译：",mt,me,Ht="<li><code>facebook/mbart-large-50-one-to-many-mmt</code> （一对多多语言机器翻译，支持 50 种语言）</li> <li><code>facebook/mbart-large-50-many-to-many-mmt</code> （多对多多语言机器翻译，支持 50 种语言）</li> <li><code>facebook/mbart-large-50-many-to-one-mmt</code> （多对一多语言机器翻译，支持 50 种语言）</li> <li><code>facebook/mbart-large-50</code> （多语言翻译，支持 50 种语言）</li> <li><code>facebook/mbart-large-cc25</code></li>",ot,oe,qt="在此示例中，加载  <code>facebook/mbart-large-50-many-to-many-mmt</code> 检查点以将芬兰语翻译为英语。 你可以在分词器中设置源语言：",pt,pe,rt,re,Nt="对文本进行分词：",ct,ce,Jt,Je,Yt="MBart 强制将目标语言 id 作为第一个生成的标记，以进行到目标语言的翻译。在 <code>generate</code> 方法中将 <code>forced_bos_token_id</code> 设置为 <code>en</code> 以翻译成英语：",gt,ge,Mt,Me,At="如果你使用的是 <code>facebook/mbart-large-50-many-to-one-mmt</code> 检查点，则无需强制目标语言 id 作为第一个生成的令牌，否则用法是相同的。",ut,be,bt;return T=new d({props:{title:"用于推理的多语言模型",local:"用于推理的多语言模型",headingTag:"h1"}}),f=new nl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/zh/multilingual.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/zh/pytorch/multilingual.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/zh/tensorflow/multilingual.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/zh/multilingual.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/zh/pytorch/multilingual.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/zh/tensorflow/multilingual.ipynb"}]}}),y=new d({props:{title:"XLM",local:"xlm",headingTag:"h2"}}),$=new d({props:{title:"带有语言嵌入的 XLM",local:"带有语言嵌入的-xlm",headingTag:"h3"}}),C=new u({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwWExNVG9rZW5pemVyJTJDJTIwWExNV2l0aExNSGVhZE1vZGVsJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwWExNVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJGYWNlYm9va0FJJTJGeGxtLWNsbS1lbmZyLTEwMjQlMjIpJTBBbW9kZWwlMjAlM0QlMjBYTE1XaXRoTE1IZWFkTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMkZhY2Vib29rQUklMkZ4bG0tY2xtLWVuZnItMTAyNCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> XLMTokenizer, XLMWithLMHeadModel

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = XLMTokenizer.from_pretrained(<span class="hljs-string">&quot;FacebookAI/xlm-clm-enfr-1024&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = XLMWithLMHeadModel.from_pretrained(<span class="hljs-string">&quot;FacebookAI/xlm-clm-enfr-1024&quot;</span>)`,wrap:!1}}),_=new u({props:{code:"cHJpbnQodG9rZW5pemVyLmxhbmcyaWQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.lang2id)
{<span class="hljs-string">&#x27;en&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;fr&#x27;</span>: <span class="hljs-number">1</span>}`,wrap:!1}}),I=new u({props:{code:"aW5wdXRfaWRzJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QnRva2VuaXplci5lbmNvZGUoJTIyV2lraXBlZGlhJTIwd2FzJTIwdXNlZCUyMHRvJTIyKSU1RCklMjAlMjAlMjMlMjBiYXRjaCUyMHNpemUlMjAlRTQlQjglQkElMjAx",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = torch.tensor([tokenizer.encode(<span class="hljs-string">&quot;Wikipedia was used to&quot;</span>)])  <span class="hljs-comment"># batch size 为 1</span>',wrap:!1}}),V=new u({props:{code:"bGFuZ3VhZ2VfaWQlMjAlM0QlMjB0b2tlbml6ZXIubGFuZzJpZCU1QiUyMmVuJTIyJTVEJTIwJTIwJTIzJTIwMCUwQWxhbmdzJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1Qmxhbmd1YWdlX2lkJTVEJTIwKiUyMGlucHV0X2lkcy5zaGFwZSU1QjElNUQpJTIwJTIwJTIzJTIwdG9yY2gudGVuc29yKCU1QjAlMkMlMjAwJTJDJTIwMCUyQyUyMC4uLiUyQyUyMDAlNUQpJTBBJTBBJTIzJTIwJUU2JTg4JTkxJUU0JUJCJUFDJUU1JUIwJTg2JUU1JTg1JUI2JTIwcmVzaGFwZSUyMCVFNCVCOCVCQSUyMChiYXRjaF9zaXplJTJDJTIwc2VxdWVuY2VfbGVuZ3RoKSUyMCVFNSVBNCVBNyVFNSVCMCU4RiUwQWxhbmdzJTIwJTNEJTIwbGFuZ3MudmlldygxJTJDJTIwLTEpJTIwJTIwJTIzJTIwJUU3JThFJUIwJUU1JTlDJUE4JUU3JTlBJTg0JUU1JUJEJUEyJUU3JThBJUI2JUU2JTk4JUFGJTIwJTVCMSUyQyUyMHNlcXVlbmNlX2xlbmd0aCU1RCUyMCglRTYlODglOTElRTQlQkIlQUMlRTclOUElODQlMjBiYXRjaCUyMHNpemUlMjAlRTQlQjglQkElMjAxKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>language_id = tokenizer.lang2id[<span class="hljs-string">&quot;en&quot;</span>]  <span class="hljs-comment"># 0</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>langs = torch.tensor([language_id] * input_ids.shape[<span class="hljs-number">1</span>])  <span class="hljs-comment"># torch.tensor([0, 0, 0, ..., 0])</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 我们将其 reshape 为 (batch_size, sequence_length) 大小</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>langs = langs.view(<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>)  <span class="hljs-comment"># 现在的形状是 [1, sequence_length] (我们的 batch size 为 1)</span>`,wrap:!1}}),W=new u({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0X2lkcyUyQyUyMGxhbmdzJTNEbGFuZ3Mp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids, langs=langs)',wrap:!1}}),L=new d({props:{title:"不带语言嵌入的 XLM",local:"不带语言嵌入的-xlm",headingTag:"h3"}}),E=new d({props:{title:"BERT",local:"bert",headingTag:"h2"}}),N=new d({props:{title:"XLM-RoBERTa",local:"xlm-roberta",headingTag:"h2"}}),S=new d({props:{title:"M2M100",local:"m2m100",headingTag:"h2"}}),ee=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME0yTTEwMEZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUyQyUyME0yTTEwMFRva2VuaXplciUwQSUwQWVuX3RleHQlMjAlM0QlMjAlMjJEbyUyMG5vdCUyMG1lZGRsZSUyMGluJTIwdGhlJTIwYWZmYWlycyUyMG9mJTIwd2l6YXJkcyUyQyUyMGZvciUyMHRoZXklMjBhcmUlMjBzdWJ0bGUlMjBhbmQlMjBxdWljayUyMHRvJTIwYW5nZXIuJTIyJTBBY2hpbmVzZV90ZXh0JTIwJTNEJTIwJTIyJUU0JUI4JThEJUU4JUE2JTgxJUU2JThGJTkyJUU2JTg5JThCJUU1JUI3JUFCJUU1JUI4JUFCJUU3JTlBJTg0JUU0JUJBJThCJUU1JThCJTk5JTJDJTIwJUU1JTlCJUEwJUU3JTgyJUJBJUU0JUJCJTk2JUU1JTgwJTkxJUU2JTk4JUFGJUU1JUJFJUFFJUU1JUE2JTk5JUU3JTlBJTg0JTJDJTIwJUU1JUJFJTg4JUU1JUJGJUFCJUU1JUIwJUIxJUU2JTlDJTgzJUU3JTk5JUJDJUU2JTgwJTkyLiUyMiUwQSUwQXRva2VuaXplciUyMCUzRCUyME0yTTEwMFRva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtMm0xMDBfNDE4TSUyMiUyQyUyMHNyY19sYW5nJTNEJTIyemglMjIpJTBBbW9kZWwlMjAlM0QlMjBNMk0xMDBGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbTJtMTAwXzQxOE0lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> M2M100ForConditionalGeneration, M2M100Tokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>en_text = <span class="hljs-string">&quot;Do not meddle in the affairs of wizards, for they are subtle and quick to anger.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>chinese_text = <span class="hljs-string">&quot;不要插手巫師的事務, 因為他們是微妙的, 很快就會發怒.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = M2M100Tokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/m2m100_418M&quot;</span>, src_lang=<span class="hljs-string">&quot;zh&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = M2M100ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/m2m100_418M&quot;</span>)`,wrap:!1}}),le=new u({props:{code:"ZW5jb2RlZF96aCUyMCUzRCUyMHRva2VuaXplcihjaGluZXNlX3RleHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_zh = tokenizer(chinese_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),ne=new u({props:{code:"Z2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqZW5jb2RlZF96aCUyQyUyMGZvcmNlZF9ib3NfdG9rZW5faWQlM0R0b2tlbml6ZXIuZ2V0X2xhbmdfaWQoJTIyZW4lMjIpKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX3Rva2VucyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generated_tokens = model.generate(**encoded_zh, forced_bos_token_id=tokenizer.get_lang_id(<span class="hljs-string">&quot;en&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&#x27;Do not interfere with the matters of the witches, because they are delicate and will soon be angry.&#x27;</span>`,wrap:!1}}),ae=new d({props:{title:"MBart",local:"mbart",headingTag:"h2"}}),pe=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0lMEElMEFlbl90ZXh0JTIwJTNEJTIwJTIyRG8lMjBub3QlMjBtZWRkbGUlMjBpbiUyMHRoZSUyMGFmZmFpcnMlMjBvZiUyMHdpemFyZHMlMkMlMjBmb3IlMjB0aGV5JTIwYXJlJTIwc3VidGxlJTIwYW5kJTIwcXVpY2slMjB0byUyMGFuZ2VyLiUyMiUwQWZpX3RleHQlMjAlM0QlMjAlMjIlQzMlODRsJUMzJUE0JTIwc2VrYWFubnUlMjB2ZWxob2plbiUyMGFzaW9paGluJTJDJTIwc2lsbCVDMyVBNCUyMG5lJTIwb3ZhdCUyMGhpZW5vdmFyYWlzaWElMjBqYSUyMG5vcGVhc3RpJTIwdmloYWlzaWEuJTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JTIyJTJDJTIwc3JjX2xhbmclM0QlMjJmaV9GSSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>en_text = <span class="hljs-string">&quot;Do not meddle in the affairs of wizards, for they are subtle and quick to anger.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fi_text = <span class="hljs-string">&quot;Älä sekaannu velhojen asioihin, sillä ne ovat hienovaraisia ja nopeasti vihaisia.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-many-mmt&quot;</span>, src_lang=<span class="hljs-string">&quot;fi_FI&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-many-mmt&quot;</span>)`,wrap:!1}}),ce=new u({props:{code:"ZW5jb2RlZF9lbiUyMCUzRCUyMHRva2VuaXplcihlbl90ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_en = tokenizer(en_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),ge=new u({props:{code:"Z2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqZW5jb2RlZF9lbiUyQyUyMGZvcmNlZF9ib3NfdG9rZW5faWQlM0R0b2tlbml6ZXIubGFuZ19jb2RlX3RvX2lkJTVCJTIyZW5fWFglMjIlNUQpJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfdG9rZW5zJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generated_tokens = model.generate(**encoded_en, forced_bos_token_id=tokenizer.lang_code_to_id[<span class="hljs-string">&quot;en_XX&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;Don&#x27;t interfere with the wizard&#x27;s affairs, because they are subtle, will soon get angry.&quot;</span>`,wrap:!1}}),{c(){b=i("meta"),de=n(),ue=i("p"),Te=n(),p(T.$$.fragment),fe=n(),p(f.$$.fragment),Ue=n(),U=i("p"),U.innerHTML=Tt,ye=n(),p(y.$$.fragment),he=n(),h=i("p"),h.textContent=ft,$e=n(),p($.$$.fragment),we=n(),w=i("p"),w.textContent=Ut,ke=n(),k=i("ul"),k.innerHTML=yt,xe=n(),x=i("p"),x.innerHTML=ht,je=n(),j=i("p"),j.innerHTML=$t,Ce=n(),p(C.$$.fragment),ve=n(),v=i("p"),v.innerHTML=wt,_e=n(),p(_.$$.fragment),Ze=n(),Z=i("p"),Z.textContent=kt,Ie=n(),p(I.$$.fragment),Xe=n(),X=i("p"),X.innerHTML=xt,Ve=n(),p(V.$$.fragment),Re=n(),R=i("p"),R.innerHTML=jt,We=n(),p(W.$$.fragment),Ge=n(),G=i("p"),G.innerHTML=Ct,Le=n(),p(L.$$.fragment),Fe=n(),F=i("p"),F.textContent=vt,ze=n(),z=i("ul"),z.innerHTML=_t,Be=n(),B=i("p"),B.textContent=Zt,Ee=n(),p(E.$$.fragment),Qe=n(),Q=i("p"),Q.textContent=It,He=n(),H=i("ul"),H.innerHTML=Xt,qe=n(),q=i("p"),q.textContent=Vt,Ne=n(),p(N.$$.fragment),Ye=n(),Y=i("p"),Y.textContent=Rt,Ae=n(),A=i("ul"),A.innerHTML=Wt,Pe=n(),P=i("p"),P.textContent=Gt,Se=n(),p(S.$$.fragment),De=n(),D=i("p"),D.textContent=Lt,Ke=n(),K=i("ul"),K.innerHTML=Ft,Oe=n(),O=i("p"),O.innerHTML=zt,et=n(),p(ee.$$.fragment),tt=n(),te=i("p"),te.textContent=Bt,lt=n(),p(le.$$.fragment),st=n(),se=i("p"),se.innerHTML=Et,nt=n(),p(ne.$$.fragment),at=n(),p(ae.$$.fragment),it=n(),ie=i("p"),ie.textContent=Qt,mt=n(),me=i("ul"),me.innerHTML=Ht,ot=n(),oe=i("p"),oe.innerHTML=qt,pt=n(),p(pe.$$.fragment),rt=n(),re=i("p"),re.textContent=Nt,ct=n(),p(ce.$$.fragment),Jt=n(),Je=i("p"),Je.innerHTML=Yt,gt=n(),p(ge.$$.fragment),Mt=n(),Me=i("p"),Me.innerHTML=At,ut=n(),be=i("p"),this.h()},l(e){const t=ll("svelte-u9bgzb",document.head);b=m(t,"META",{name:!0,content:!0}),t.forEach(l),de=a(e),ue=m(e,"P",{}),Pt(ue).forEach(l),Te=a(e),r(T.$$.fragment,e),fe=a(e),r(f.$$.fragment,e),Ue=a(e),U=m(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-1xhgqc7"&&(U.innerHTML=Tt),ye=a(e),r(y.$$.fragment,e),he=a(e),h=m(e,"P",{"data-svelte-h":!0}),o(h)!=="svelte-1do04ou"&&(h.textContent=ft),$e=a(e),r($.$$.fragment,e),we=a(e),w=m(e,"P",{"data-svelte-h":!0}),o(w)!=="svelte-ae6845"&&(w.textContent=Ut),ke=a(e),k=m(e,"UL",{"data-svelte-h":!0}),o(k)!=="svelte-p9591r"&&(k.innerHTML=yt),xe=a(e),x=m(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-1xxan1y"&&(x.innerHTML=ht),je=a(e),j=m(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-ugc5kb"&&(j.innerHTML=$t),Ce=a(e),r(C.$$.fragment,e),ve=a(e),v=m(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1bg3kzi"&&(v.innerHTML=wt),_e=a(e),r(_.$$.fragment,e),Ze=a(e),Z=m(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-mgsk1x"&&(Z.textContent=kt),Ie=a(e),r(I.$$.fragment,e),Xe=a(e),X=m(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-1wd8oyh"&&(X.innerHTML=xt),Ve=a(e),r(V.$$.fragment,e),Re=a(e),R=m(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-wr7smr"&&(R.innerHTML=jt),We=a(e),r(W.$$.fragment,e),Ge=a(e),G=m(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1y11as"&&(G.innerHTML=Ct),Le=a(e),r(L.$$.fragment,e),Fe=a(e),F=m(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-ug2kdl"&&(F.textContent=vt),ze=a(e),z=m(e,"UL",{"data-svelte-h":!0}),o(z)!=="svelte-1thvgtu"&&(z.innerHTML=_t),Be=a(e),B=m(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-s35cwf"&&(B.textContent=Zt),Ee=a(e),r(E.$$.fragment,e),Qe=a(e),Q=m(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-10z54vn"&&(Q.textContent=It),He=a(e),H=m(e,"UL",{"data-svelte-h":!0}),o(H)!=="svelte-vuevit"&&(H.innerHTML=Xt),qe=a(e),q=m(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-mlr4c8"&&(q.textContent=Vt),Ne=a(e),r(N.$$.fragment,e),Ye=a(e),Y=m(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1e23zdv"&&(Y.textContent=Rt),Ae=a(e),A=m(e,"UL",{"data-svelte-h":!0}),o(A)!=="svelte-18avzy"&&(A.innerHTML=Wt),Pe=a(e),P=m(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-gdaw37"&&(P.textContent=Gt),Se=a(e),r(S.$$.fragment,e),De=a(e),D=m(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1eurwqt"&&(D.textContent=Lt),Ke=a(e),K=m(e,"UL",{"data-svelte-h":!0}),o(K)!=="svelte-11pgdv5"&&(K.innerHTML=Ft),Oe=a(e),O=m(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-7kr2c3"&&(O.innerHTML=zt),et=a(e),r(ee.$$.fragment,e),tt=a(e),te=m(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-1azdq78"&&(te.textContent=Bt),lt=a(e),r(le.$$.fragment,e),st=a(e),se=m(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-7k4v2z"&&(se.innerHTML=Et),nt=a(e),r(ne.$$.fragment,e),at=a(e),r(ae.$$.fragment,e),it=a(e),ie=m(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-1n3gxv8"&&(ie.textContent=Qt),mt=a(e),me=m(e,"UL",{"data-svelte-h":!0}),o(me)!=="svelte-xrptst"&&(me.innerHTML=Ht),ot=a(e),oe=m(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-df2xsd"&&(oe.innerHTML=qt),pt=a(e),r(pe.$$.fragment,e),rt=a(e),re=m(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-1azdq78"&&(re.textContent=Nt),ct=a(e),r(ce.$$.fragment,e),Jt=a(e),Je=m(e,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-z2e3e4"&&(Je.innerHTML=Yt),gt=a(e),r(ge.$$.fragment,e),Mt=a(e),Me=m(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-573keg"&&(Me.innerHTML=At),ut=a(e),be=m(e,"P",{}),Pt(be).forEach(l),this.h()},h(){St(b,"name","hf:doc:metadata"),St(b,"content",il)},m(e,t){sl(document.head,b),s(e,de,t),s(e,ue,t),s(e,Te,t),c(T,e,t),s(e,fe,t),c(f,e,t),s(e,Ue,t),s(e,U,t),s(e,ye,t),c(y,e,t),s(e,he,t),s(e,h,t),s(e,$e,t),c($,e,t),s(e,we,t),s(e,w,t),s(e,ke,t),s(e,k,t),s(e,xe,t),s(e,x,t),s(e,je,t),s(e,j,t),s(e,Ce,t),c(C,e,t),s(e,ve,t),s(e,v,t),s(e,_e,t),c(_,e,t),s(e,Ze,t),s(e,Z,t),s(e,Ie,t),c(I,e,t),s(e,Xe,t),s(e,X,t),s(e,Ve,t),c(V,e,t),s(e,Re,t),s(e,R,t),s(e,We,t),c(W,e,t),s(e,Ge,t),s(e,G,t),s(e,Le,t),c(L,e,t),s(e,Fe,t),s(e,F,t),s(e,ze,t),s(e,z,t),s(e,Be,t),s(e,B,t),s(e,Ee,t),c(E,e,t),s(e,Qe,t),s(e,Q,t),s(e,He,t),s(e,H,t),s(e,qe,t),s(e,q,t),s(e,Ne,t),c(N,e,t),s(e,Ye,t),s(e,Y,t),s(e,Ae,t),s(e,A,t),s(e,Pe,t),s(e,P,t),s(e,Se,t),c(S,e,t),s(e,De,t),s(e,D,t),s(e,Ke,t),s(e,K,t),s(e,Oe,t),s(e,O,t),s(e,et,t),c(ee,e,t),s(e,tt,t),s(e,te,t),s(e,lt,t),c(le,e,t),s(e,st,t),s(e,se,t),s(e,nt,t),c(ne,e,t),s(e,at,t),c(ae,e,t),s(e,it,t),s(e,ie,t),s(e,mt,t),s(e,me,t),s(e,ot,t),s(e,oe,t),s(e,pt,t),c(pe,e,t),s(e,rt,t),s(e,re,t),s(e,ct,t),c(ce,e,t),s(e,Jt,t),s(e,Je,t),s(e,gt,t),c(ge,e,t),s(e,Mt,t),s(e,Me,t),s(e,ut,t),s(e,be,t),bt=!0},p:Kt,i(e){bt||(J(T.$$.fragment,e),J(f.$$.fragment,e),J(y.$$.fragment,e),J($.$$.fragment,e),J(C.$$.fragment,e),J(_.$$.fragment,e),J(I.$$.fragment,e),J(V.$$.fragment,e),J(W.$$.fragment,e),J(L.$$.fragment,e),J(E.$$.fragment,e),J(N.$$.fragment,e),J(S.$$.fragment,e),J(ee.$$.fragment,e),J(le.$$.fragment,e),J(ne.$$.fragment,e),J(ae.$$.fragment,e),J(pe.$$.fragment,e),J(ce.$$.fragment,e),J(ge.$$.fragment,e),bt=!0)},o(e){g(T.$$.fragment,e),g(f.$$.fragment,e),g(y.$$.fragment,e),g($.$$.fragment,e),g(C.$$.fragment,e),g(_.$$.fragment,e),g(I.$$.fragment,e),g(V.$$.fragment,e),g(W.$$.fragment,e),g(L.$$.fragment,e),g(E.$$.fragment,e),g(N.$$.fragment,e),g(S.$$.fragment,e),g(ee.$$.fragment,e),g(le.$$.fragment,e),g(ne.$$.fragment,e),g(ae.$$.fragment,e),g(pe.$$.fragment,e),g(ce.$$.fragment,e),g(ge.$$.fragment,e),bt=!1},d(e){e&&(l(de),l(ue),l(Te),l(fe),l(Ue),l(U),l(ye),l(he),l(h),l($e),l(we),l(w),l(ke),l(k),l(xe),l(x),l(je),l(j),l(Ce),l(ve),l(v),l(_e),l(Ze),l(Z),l(Ie),l(Xe),l(X),l(Ve),l(Re),l(R),l(We),l(Ge),l(G),l(Le),l(Fe),l(F),l(ze),l(z),l(Be),l(B),l(Ee),l(Qe),l(Q),l(He),l(H),l(qe),l(q),l(Ne),l(Ye),l(Y),l(Ae),l(A),l(Pe),l(P),l(Se),l(De),l(D),l(Ke),l(K),l(Oe),l(O),l(et),l(tt),l(te),l(lt),l(st),l(se),l(nt),l(at),l(it),l(ie),l(mt),l(me),l(ot),l(oe),l(pt),l(rt),l(re),l(ct),l(Jt),l(Je),l(gt),l(Mt),l(Me),l(ut),l(be)),l(b),M(T,e),M(f,e),M(y,e),M($,e),M(C,e),M(_,e),M(I,e),M(V,e),M(W,e),M(L,e),M(E,e),M(N,e),M(S,e),M(ee,e),M(le,e),M(ne,e),M(ae,e),M(pe,e),M(ce,e),M(ge,e)}}}const il='{"title":"用于推理的多语言模型","local":"用于推理的多语言模型","sections":[{"title":"XLM","local":"xlm","sections":[{"title":"带有语言嵌入的 XLM","local":"带有语言嵌入的-xlm","sections":[],"depth":3},{"title":"不带语言嵌入的 XLM","local":"不带语言嵌入的-xlm","sections":[],"depth":3}],"depth":2},{"title":"BERT","local":"bert","sections":[],"depth":2},{"title":"XLM-RoBERTa","local":"xlm-roberta","sections":[],"depth":2},{"title":"M2M100","local":"m2m100","sections":[],"depth":2},{"title":"MBart","local":"mbart","sections":[],"depth":2}],"depth":1}';function ml(dt){return Ot(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class gl extends el{constructor(b){super(),tl(this,b,ml,al,Dt,{})}}export{gl as component};
